' c Sim.for             6-25-90   D. Kerr  c 4 c  Primal Simplex Method for solving Linear Programs c D c lexicographical selection of tying candidates for leaving variable c to prevent cycling. < c tableau built out by 1st scanning constraints for possibleC c   basic variables, then adding slack variables for <= constraints F c   then slack and, if needed, artificial variables for >= constraintsA c   and finally, artificial variables as needed for initial basis  c   for = constraints.B c   Artificial variables are all on the right hand side of tableauA c   so that it is easy to drop them from computations in phase 2.  c ! c   Nvar      number of variables # c   M         number of constraints 7 c   A         array (M,NVar) of constraint coefficients ; c   b         array (M) of "Right Hand Side" of constraints E c   rel       array of constraint relationship to Right Hand Side b() % c           -1 if <=, 0 if =, 1 if >= 3 c   nonneg    array of variables' relationship to 0 > c         elements are = 1 if they must be non-negative (>= 0), c   N         number of variables in problem3 c               = NVar + slackcnt + dblcnt + artcnt < c   TablWidth width (# of columns) of tableau = N in Phase 1' c   slackcnt  number of slack variables + c   dblcnt    number of "doubled" variables 2 c         ( if a variable has no >= 0 requirement,. c           it is "doubled" into two that do :/ c           x = u - v where u and v both >= 0 ) , c   artcnt    number of artificial variables9 c   art       array of number-ids of artificial variables ! c   t         array (M,N) tableau 2 c       note:  t(0,*) is used for reduced costs...4 c   k         number-id of variable entering basis  % c        mnemonically "kolumn number" * c   r         index of basic() containing 3 c               number-id of variable leaving basis " c        mnemonically "row number"$ c        pivot is on row r, column k; c   rtie      array of row ids tying for smallest b/y ratio ; c   yytie     array of row ids tying for smallest y/y ratio @ c          see Bazaraa & Jarvis p. 169 for discussion of Beale'sE c          method (lexicographical ordering) for preventing cycling.  4 c   basic     array of number-ids of basic variables0 c   nbasic    array , etc. , non-basic variables< c   backbasic array of back pointer for basic() and nbasic()- c   corg      array of original obj fn coeffs % c   c         array of obj fn coeffs  / c   nbv       number-id of a non-basic variable 0 c   candidate array of non-basic vars that might! c               become basic vars + c   value     array of values corresponding ) c               to entries in candidate()  c = c maxvar = max # of variables;  maxcon = max # of constraints .       parameter ( maxvar = 101, maxcon = 100 )- c lun is "logical unit number" for input data        parameter ( lun = 10 )$ c      dimension A( maxcon, maxvar )$       dimension A( maxcon * maxvar ))      &        , c( maxvar ),  b( maxcon ) *      &        , X( maxvar ), ray( maxvar )/       logical*1 rel( maxvar ), nonneg( maxcon )        integer*2 irtn8       character filenm*16, line*80, ch*1, echo*1, disp*1 c        write( 6, 1 ) A    1  format( ' Simplex Algorithm for solving Linear Programs'/ )    10  continue c  initialize arrays       do 12 i = 1, maxcon          nonneg(i) = 0          b( i ) = 0.0         do 12 j = 1, maxvar            a( i*j ) = 0.0   12  continue       do 14 j = 1, maxvar          X( j ) = 0.0         ray( j ) = 0.0         c( j ) = 0.0         rel( j ) = 0   14  continue c G       write( 6, fmt='(40h Enter file name or just <cr> to quit:  ,$)' )        go to 30   20  continue1       write( 6, fmt='(a)' )  ' File not found...' @       write( 6, fmt='(33h Try again or just <cr> to quit: ,$)' )   30  continue!       read( 5, fmt='(a)' ) filenm %       if (filenm .eq. ' ')  go to 990 8       open( lun, file=filenm, status = 'old', err = 20 ) c 8       write( 6, fmt='(25h echo input? (y,<cr>=n): ,$)' )       read( 5, fmt='(a)' ) echo %       if ( echo .eq. ' ' ) echo = 'n'  c        write( 6, 40 )6   40  format( ' display (i)nitial or (a)ll tableaus? '"      &      , '(i,a,<cr>=n): ',$ )       read( 5, fmt='(a)' ) disp        irtn = 0)       if ( disp(1:1) .eq. 'i' ) irtn = -1 )       if ( disp(1:1) .eq. 'a' ) irtn = -2  c        itemno = 0       iconstr= 0   50  continue,       read( lun, fmt='(a)', end = 991 ) line*       if ( line( 1:1 ) .eq. '*' ) go to 50       itemno = itemno + 1 /       go to ( 110, 120, 130, 140, 150 ), itemno 	 c NVar, M   110  continue/       read( line, *, end=992, err=993 ) NVar, M <       if ( (NVar .gt. maxvar) .or. (NVar .lt. 1) ) go to 9947       if ( (M .gt. maxcon ) .or. (M .lt. 1) ) go to 995        go to 200  c c   120  continue       j = 0        ix = 0  125  continue%       if ( ix .gt. len( line ) ) then #         if ( j .eq. NVar - 1 ) then            j = j + 1            c( j ) = 0.0           go to 127          else           go to 992          end if       end if&       icom = index( line( ix: ), ',' )(       ispace = index( line( ix: ), ' ' )$       if ( ispace .ne. 1 ) go to 126         ix = ix + 1          go to 125   126  continue       j = j + 1        if ( icom .eq. 1 ) then          c( j ) = 0.09       else if (( icom .gt. 1 ) .or. ( j .eq. NVar )) then 2         if ( ichar( line( ix:ix ) ) .lt. 58 ) then0           read( line( ix: ), *, err=993 ) c( j )         else           c( j ) = 0.0         end if
       else2         print *, ' obj function missing coef #', j         go to 993        end if       ix = ix + icom"       if ( j .lt. NVar ) go to 125  127  continue       go to 200  c A, rel, b   130  continue       ix = 1       iconstr = iconstr + 1 $ c   parse line a comma at at time...       j = 0   135  continue(       if ( ix .gt. len(line) ) go to 992&       icom = index( line( ix: ), ',' )(       ispace = index( line( ix: ), ' ' )$       if ( ispace .ne. 1 ) go to 137$ c                 skip over space...         ix = ix + 1          go to 135   137  continue               j = j + 1        if ( icom .eq. 1 ) then #          A( iconstr+M*(j-1) ) = 0.0 7       else if (( icom .gt. 1 ).or.( j .eq. NVar )) then 2         if ( ichar( line( ix:ix ) ) .lt. 58 ) then>           read( line( ix: ), *, err=993 ) A( iconstr+M*(j-1) )         else%            A( iconstr+M*(j-1) ) = 0.0          end if
       elseA         print *, ' constraint ', iconstr, '  missing coefficient'          print *, ' #', j         go to 993        end if       ix = ix + icom  "       if ( j .lt. NVar ) go to 135 c "       irelle = index( line, '<=' )"       irelge = index( line, '>=' )!       ireleq = index( line, '=' )        if (irelle .gt. 0 ) then         irel = irelle + 2          rel( iconstr ) = -1 #       else if (irelge .gt. 0 ) then          irel = irelge + 2          rel( iconstr ) = 1#       else if (ireleq .gt. 0 ) then          irel = ireleq + 1          rel( iconstr ) = 0
       else;         print *, ' no relation sign in constraint ',iconstr          go to 999        end if;       read( line( irel: ), *, end=992, err=993 ) b(iconstr) /       if ( iconstr .lt. M ) itemno = itemno - 1        go to 200  c nonneg  140  continue       ix = 1       do 145 j = 1, NVar - 1&         icom = index( line(ix:), ',' )&         ige = index( line(ix:), '>=' )         if ( icom .gt. 0 ) then :           if (( ige .gt. 0 ) .and. ( ige .lt. icom )) then5 c                               variable must be >= 0              nonneg( j ) = 1            else8 c                               variable is unrestricted             nonneg( j ) = 0            end if
         else  G           print *, ' incomplete info on variable non-negativity at #',j            go to 999          end if         ix = icom + 1   145  continue$       ige = index( line(ix:), '>=' )       if ( ige .gt. 0 ) then         nonneg( j ) = 1 
       else         nonneg( j ) = 0        end if       go to 200   c failsafe - shouldn't get here!  150  continue7       print *, ' program logic error in reading input!'        go to 999   200  continue#       if ( itemno .lt. 4 ) go to 50  c D       if ( echo .eq. 'y' ) call rpt( NVar, M, c, A, rel, b, nonneg )>       Z = smplx( NVar, M, c, A, rel, b, nonneg, X, ray, irtn )0       call rptans( NVar, M, c, X, ray, Z, irtn )@       write( 6, fmt='(/32h run program again? (<cr>=y,n): ,$)' )       read( 5, fmt='(a)' ) ch !       if ( ch .eq. ' ' ) ch = 'y't"       if ( ch .ne. 'y' ) go to 999       close ( lun )t       go to 10 cs ce  990  continueD       write( 6, fmt='(a)' )  ' program terminated per user request.'       goto 999 cf  991  continue=       write( 6, fmt='(a)' )  ' unexpected end to input file.'        goto 999 cb  992  continue!       write( 6, fmt=1992 ) itemnot?  1992 format( ' unexpected end to input file for itemno ', i2 )        goto 999 c   993  continue!       write( 6, fmt=1993 ) itemno ;  1993 format( ' error reading input file for itemno ', i2 )        goto 999 c   994  continue       write( 6, fmt=1994 ) NVar =  1994 format( ' NVar (number of variables) too large or < 1;'n      &, '  NVar = ', i2 )        goto 999 ci  995  continue       write( 6, fmt=1995 ) M8  1995 format( ' M (number of columns) too large or < 1;'      &, ' M = ', i2 )a       goto 999 c   999  continue       call exitb	       endb co'       logical function in( ans, valid )v"       character ans*(*), valid*(*).       in = ( index( ans(1:1), valid ) .ne. 0 )       return	       end 