 /* C interface to screen and file I/O for AnalytiCalc */
#include <curses.h>
WINDOW *winptr,*curscr,*stdwin;
WINDOW *stdscr;
/* long currx,curry; */
long xsize,ysize;
long LINES,COLS;
extern int cbreak();
/* copen - opens window after screen setup; returns "handle" which will
   be used for other accesses. The cclose routine will clear things out. */
WINDOW *copen(fname,fnsz,mode)
char *fname;
long fnsz; /* Sun interface...passes addr and size */
long *mode; /* mode arg for size */
{
  winptr = initscr(); /* init the screen */
  xsize=COLS;
  ysize=LINES;
  cbreak();
  noecho();
/*  nonl(); */
  intrflush(stdscr,FALSE);
  keypad(stdscr,TRUE);
/*  currx=0;
  curry=0; */ /* zero initial cursor loc */
  refresh();
/* use stdwin for our stuff */
  return(winptr); /* return stdscr pointer*/
}
cgetsz(col,row)
long *col,*row;
{  *col = xsize + 1;
  *row = ysize + 1;
  return(0);
}
/* cclose - close scren window */
cclose(fh)
WINDOW *fh;
{
echo();attrset(A_NORMAL);
endwin(); /*just finish all curses stuff*/
return(0);
}
/* cmove - move to char x,y (zero based..offset here for 1-based AnalytiCalc) */
cmove(fh,lasty,lastx)
WINDOW *fh;
  long *lasty,*lastx;
{
  long cx,cy;
  cx = *lastx ;
  cy = *lasty ;
/*  currx=*lastx;
  curry=*lasty;  */
  move(cy,cx);
  refresh(); /* move, and echo the move to screen */
  return(0);
}
cclear(fh)
WINDOW *fh;
{
/* cclear - clear entire screen */
clear();refresh();
return(0);
}
/* ccleareol - clear to end of LINES on current screen */
ccleareol(fh)
WINDOW *fh;
{
clrtoeol();refresh();
return(0);
}
/* crefresh - repaint screen */
crefresh(fh)
WINDOW *fh;
{
clearok(fh,TRUE);
refresh(); /* repaint screen totally */
return(0);
}
/* cattron - set reverse video */
cattron(fh)
WINDOW *fh;
{
attron(A_REVERSE);
refresh();
return(0);
}
/* cattroff - turns off reverse video etc. */
cattroff(fh)
WINDOW *fh;
{
attrset(A_NORMAL);
refresh();
return(0);
}
/* cwrite - write chars to screen */
cwrite(fh,chrs,size,csz)
WINDOW *fh;
long csz;
long *size;
char *chrs;
{
long i;
char *ch;
  (char *)ch = (char *)chrs;
  for (i=0;i < *size;i++){
  if (*ch != '\0') addch(*ch++);
  }
 refresh();
return(0);
}
/* cread - read chars off keyboard, returning flags if esc seqs. */
long cread(fh,buf,size,esccod,iact,bsz)
WINDOW *fh;
char *buf;
long *iact;
long bsz;
long *size;
long *esccod;
{
long kkk;
long i,l;
long *ec;
int j;
char *cp,cwk;
   kkk=0;
   ec = esccod;
   cp = buf;
   for (i=0;i<*size;i++){
   j=getch();
   kkk++;
   cwk=j & 255;
   if ((j < 255) && (cwk == '\r')) j = '\n';
   l=j;
   *ec = l;
/* we read a char at a time for analyticalc, so no end chks much */
   *cp++ = j & 255;
   *iact = kkk;
   if (j == 10) return(i);
   if (j == 13) return(i);
   }
   *iact = kkk;
   return(0);
}

