/*
|-----------------------------------------------------------------------|
|									|
|	F.Blancher				Mar.	1993		|
|	FafaDll 				Version 1.1		|
|									|
|	Dll Controles Windows 						|
|	Test1 - Fichier d'exemple de la librairie			|
|									|
|	Copyright (c)	FB			Paris			|
|									|
|-----------------------------------------------------------------------|
*/

#include		<windows.h>

/*
|-----------------------------------------------------------------------|
| Declarations - proto
|-----------------------------------------------------------------------|
*/

HANDLE		Inst ;
char		AppName[ 12 ] = "Test1" ;

enum	{		/* options du menu */
	M_BUTTON = 100,
	M_STATIC,
	M_CHECK,
	M_CHECK2,
	M_CONT,

	M_QUIT
	} ;

/*
|-----------------------------------------------------------------------|
| proc MainWndProc : boucle principale de reception des evenements	|
|-----------------------------------------------------------------------|
*/

BOOL	WINAPI	LoopTest( HWND w, UINT msg, UINT mw, LONG ml )
{
static	UINT	c ;

	if ( msg == WM_COMMAND )
		if ( ( mw == IDOK || mw == IDCANCEL ) )
			EndDialog( w, 0 ) ;
		else if ( mw == 500 )
			SetDlgItemInt( w, 501, ++ c, 0 ) ;
	return 0 ;
}

LONG FAR PASCAL MainWndProc( HWND w, UINT msg, UINT mw, LONG ml )
{
	switch( msg )
		{
		case WM_CREATE :
			ShowWindow( w, SW_SHOW ) ;
			UpdateWindow( w ) ;
			return 0 ;

		case WM_DESTROY:
			PostQuitMessage( 0 ) ;
			return 0 ;

		case WM_COMMAND :
			if ( mw == M_QUIT )
				PostMessage( w, WM_SYSCOMMAND, SC_CLOSE, 0L ) ;
			else if ( mw >= M_BUTTON && mw <= M_CONT )
				DialogBox( Inst, MAKEINTRESOURCE( mw ), w,
					( FARPROC ) LoopTest );
			return 0 ;

		}
	return DefWindowProc( w, msg, mw, ml ) ;
}

/*
|-----------------------------------------------------------------------|
| proc InitFirstInstance : Premiere instance				|
|-----------------------------------------------------------------------|
*/

static	int	near	InitFirstInstance( void )
{
	WNDCLASS c ;

	c.lpszClassName = AppName ;
	c.hInstance     = Inst ;
	c.lpfnWndProc   = MainWndProc ;
	c.style         = CS_HREDRAW | CS_VREDRAW ;
	c.lpszMenuName  = NULL ;
	c.hCursor       = LoadCursor( ( HINSTANCE ) 0, IDC_ARROW ) ;
	c.hIcon         = 0 ;
	c.hbrBackground = GetStockObject( LTGRAY_BRUSH ) ;
	c.cbClsExtra    = 0 ;
	c.cbWndExtra    = 0 ;

	return RegisterClass( & c )
		&& CreateWindow( AppName, AppName,
			WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
			CW_USEDEFAULT, CW_USEDEFAULT, 0,
			LoadMenu( Inst, MAKEINTRESOURCE( 1 ) ), Inst, 0 ) ;
}

/*
|-----------------------------------------------------------------------|
| proc ActivatePrevious : Active l'instance precedante	 		|
|-----------------------------------------------------------------------|
*/

static	int	near	ActivatePrevious( void )
{
	HWND	w = FindWindow( AppName, AppName ) ;

	if ( w )
		if ( IsIconic( w ) )
			OpenIcon( w ) ;
		else	SetFocus( w ) ;
	return 0 ;
}

/*
|-----------------------------------------------------------------------|
| proc WinMain :							|
|-----------------------------------------------------------------------|
*/

int	PASCAL WinMain( HANDLE Me, HANDLE Prev, LPSTR Cl, int Show )
{
	MSG   		msg ;
extern int InitFafa(HANDLE) ;
	
	Inst = Me ;
	if (InitFafa(Me)==0)
		return(0) ;
	if ( Prev )
		return ActivatePrevious() ;
	else if ( InitFirstInstance() )
		while ( GetMessage( & msg, ( HWND ) 0, 0, 0 ) )
			{
			TranslateMessage( & msg ) ;
			DispatchMessage ( & msg ) ;
			}
	return 0 ;
}

