#ifndef SND_0_H_LOADED
#define SND_0_H_LOADED

#define FILE_BUFFER_SIZE 8192
#define MAX_BUFFER_SIZE 65536
#define MAX_FILE_NAME 128       /* max file name length */
#define MIX_FILE_BUFFER_SIZE 2048

#define SCROLLBAR_MAX 100       /* used by zx, zy but not sx (huge files need special handling) or sy (tiny motions needed here too) */
#define SCROLLBAR_SY_MAX 500
#define SCROLLBAR_MID 50
#define SCROLLBAR_LINEAR_MAX 15
#define SCROLLBAR_LINEAR_MULT 0.011584929

#define AMPLITUDE_ENV 0
#define SPECTRUM_ENV 1
#define SRATE_ENV 2

#define DEFAULT_OUTPUT_TYPE NeXT_sound_file

enum {W_chn_main_window,   /* top window for chan */
      W_chn_edhist,
      W_chn_wf_buttons,
      W_chn_left_scrollers,W_chn_bottom_scrollers,W_chn_graph,    
                           /* direct children of main_window */
      W_chn_sx,W_chn_zx,   /* scroll bars in bottom_scrollers */
      W_chn_gzy,W_chn_gsy, /* scroll bars for combined graphs */
      W_chn_zy,W_chn_sy,   /* scroll bars in left_scrollers */
      W_chn_f,W_chn_w      /* buttons in wf_buttons */
};
#define NUM_CHAN_WIDGETS 14

#define NO_SELECTION -1

enum {W_snd_pane,
      W_snd_name_form,W_snd_amp_form,
      W_snd_amp,W_snd_amp_label,W_snd_amp_number,W_snd_amp_separator,
      W_snd_srate,W_snd_srate_label,W_snd_srate_number,W_snd_srate_arrow,
      W_snd_expand,W_snd_expand_label,W_snd_expand_number,W_snd_expand_button,
      W_snd_contrast,W_snd_contrast_label,W_snd_contrast_number,W_snd_contrast_button,
      W_snd_revscl,W_snd_revscl_label,W_snd_revscl_number,
      W_snd_revlen,W_snd_revlen_label,W_snd_revlen_number,W_snd_reverb_button,
      W_snd_filter_label,W_snd_filter_order,W_snd_filter_env,W_snd_filter,W_snd_filter_button,
      W_snd_record_sep,W_snd_record,W_snd_replay,W_snd_apply,W_snd_set,W_snd_reset,
      W_snd_name,W_snd_name_icon,W_snd_info_label,W_snd_info,
      W_snd_info_sep,
      W_snd_play,W_snd_sync,W_snd_combine,
      W_snd_ctrls
};
/* order matters here -- W_snd_ctrls should be last */

#define NUM_SND_WIDGETS 46

typedef struct {unsigned int s_type;} snd_any;

enum {AXIS_INFO,FILE_INFO,FFT_INFO,CHAN_INFO,SND_INFO,SND_STATE,REGION_INFO,UNKNOWN_TYPE};
enum {GRAPH_LINES,GRAPH_DOTS,GRAPH_FILLED};
enum {NORMAL_FFT,SONOGRAM,SPECTROGRAM};
enum {NOGRAPH,WAVE,FFT,LISP,FFT_MAIN};    /* for marks, regions, mouse click detection */

enum {FOCUS_LEFT,FOCUS_RIGHT,FOCUS_ACTIVE,FOCUS_MIDDLE};
enum {DONT_LOCK_MIXES,LOCK_MIXES};
enum {DONT_DELETE_ME,DELETE_ME};

#ifdef NEXT
  #define S_ISDIR(mode) (((mode) & S_IFMT) == S_IFDIR)
  #define S_ISLNK(mode) (((mode) & S_IFMT) == S_IFLNK)
#endif

#define READ_FORWARD 1
#define READ_BACKWARD -1

enum {X_IN_SECONDS,X_IN_SAMPLES,X_TO_ONE,X_IN_LENGTH};
enum {SPEED_AS_FLOAT,SPEED_AS_RATIO,SPEED_AS_SEMITONE};

enum {MD_CS,MD_TITLE,MD_M};

enum {CURSOR_IN_VIEW,CURSOR_ON_LEFT,CURSOR_ON_RIGHT,CURSOR_IN_MIDDLE,
      CURSOR_UPDATE_DISPLAY,CURSOR_NO_ACTION,CURSOR_CLAIM_SELECTION,KEYBOARD_NO_ACTION};

#define MAX_NUM_PEAKS 100
#define REGIONS 16

enum {GROUP_INITIALIZED,GROUP_ACTIVE,GROUP_CLEARED};
enum {NO_PROBLEM,BLIND_LEAP,GIVE_UP,HUNKER_DOWN};
enum {CHANNELS_SEPARATE,CHANNELS_COMBINED,CHANNELS_SUPERIMPOSED};
enum {FD_INITIALIZED,FD_OPEN,FD_CLOSED};
enum {PRINT_SND,PRINT_ENV};

#define SND_DATA_FILE 0
#define SND_DATA_BUFFER 1

enum {SOUNDS_VERTICAL,SOUNDS_HORIZONTAL};
enum {FOURIER,WAVELET,HANKEL,CHEBYSHEV,LEGENDRE};
enum {AUTOLOAD,REC_IN_AMPS,REC_OUT_AMPS,AUDIO_GAINS,REC_SRATE,IN_FORMAT,OUT_CHANS,OUT_FORMAT};

enum {rectangular,hanning,welch,parzen,bartlett,hamming,blackman2,blackman3,blackman4,
      exponential,riemann,kaiser,cauchy,poisson,gaussian,tukey};

/* ---------------- USER-VISIBLE VARIABLE NAMES ---------------- */
/* 
 * see also snd.c for initializations
 * this code looks crazy now -- originally I moved all these variables into Guile,
 * but that didn't work out as intended, so they are now back in C, but wrapped up
 * in these (now) completely pointless macros.  
 */

#if HAVE_GUILE
  #include <guile/gh.h>
#else
  #define dont_open(a,b) (0)
  #define dont_close(a,b) (0)
  #define after_fft(a,b,c) (0)
  #define dont_graph(a,b) (0)
  #define dont_start(a) (0)
  #define dont_exit(a) (0)
#endif

  #define default_amp(ss) ss->Default_Amp
  #define init_default_amp(ss,a) ss->Default_Amp = a
  #define set_default_amp(ss,a) ss->Default_Amp = a

  #define default_contrast(ss) ss->Default_Contrast
  #define init_default_contrast(ss,a) ss->Default_Contrast = a
  #define set_default_contrast(ss,a) ss->Default_Contrast = a

  #define default_contrast_amp(ss) ss->Default_Contrast_Amp
  #define init_default_contrast_amp(ss,a) ss->Default_Contrast_Amp = a
  #define set_default_contrast_amp(ss,a) ss->Default_Contrast_Amp = a

  #define default_contrasting(ss) ss->Default_Contrasting
  #define init_default_contrasting(ss,a) ss->Default_Contrasting = a
  #define set_default_contrasting(ss,a) ss->Default_Contrasting = a

  #define default_expand(ss) ss->Default_Expand
  #define init_default_expand(ss,a) ss->Default_Expand = a
  #define set_default_expand(ss,a) ss->Default_Expand = a

  #define default_expanding(ss) ss->Default_Expanding
  #define init_default_expanding(ss,a) ss->Default_Expanding = a
  #define set_default_expanding(ss,a) ss->Default_Expanding = a

  #define default_expand_hop(ss) ss->Default_Expand_Hop
  #define init_default_expand_hop(ss,a) ss->Default_Expand_Hop = a
  #define set_default_expand_hop(ss,a) ss->Default_Expand_Hop = a

  #define default_expand_length(ss) ss->Default_Expand_Length
  #define init_default_expand_length(ss,a) ss->Default_Expand_Length = a
  #define set_default_expand_length(ss,a) ss->Default_Expand_Length = a

  #define default_expand_ramp(ss) ss->Default_Expand_Ramp
  #define init_default_expand_ramp(ss,a) ss->Default_Expand_Ramp = a
  #define set_default_expand_ramp(ss,a) ss->Default_Expand_Ramp = a

  #define default_filtering(ss) ss->Default_Filtering
  #define init_default_filtering(ss,a) ss->Default_Filtering = a
  #define set_default_filtering(ss,a) ss->Default_Filtering = a

  #define default_filter_order(ss) ss->Default_Filter_Order
  #define init_default_filter_order(ss,a) ss->Default_Filter_Order = a
  #define set_default_filter_order(ss,a) ss->Default_Filter_Order = a

  #define default_reverbing(ss) ss->Default_Reverbing
  #define init_default_reverbing(ss,a) ss->Default_Reverbing = a
  #define set_default_reverbing(ss,a) ss->Default_Reverbing = a

  #define reverb_decay(ss) ss->Reverb_Decay
  #define init_reverb_decay(ss,a) ss->Reverb_Decay = a
  #define set_reverb_decay(ss,a) ss->Reverb_Decay = a

  #define default_reverb_feedback(ss) ss->Default_Reverb_Feedback
  #define init_default_reverb_feedback(ss,a) ss->Default_Reverb_Feedback = a
  #define set_default_reverb_feedback(ss,a) ss->Default_Reverb_Feedback = a

  #define default_reverb_length(ss) ss->Default_Reverb_Length
  #define init_default_reverb_length(ss,a) ss->Default_Reverb_Length = a
  #define set_default_reverb_length(ss,a) ss->Default_Reverb_Length = a

  #define default_reverb_lowpass(ss) ss->Default_Reverb_Lowpass
  #define init_default_reverb_lowpass(ss,a) ss->Default_Reverb_Lowpass = a
  #define set_default_reverb_lowpass(ss,a) ss->Default_Reverb_Lowpass = a

  #define default_reverb_scale(ss) ss->Default_Reverb_Scale
  #define init_default_reverb_scale(ss,a) ss->Default_Reverb_Scale = a
  #define set_default_reverb_scale(ss,a) ss->Default_Reverb_Scale = a

  #define default_speed(ss) ss->Default_Speed
  #define init_default_speed(ss,a) ss->Default_Speed = a
  #define set_default_speed(ss,a) ss->Default_Speed = a

  #define default_output_type(ss) ss->Default_Output_Type
  #define init_default_output_type(ss,a) ss->Default_Output_Type = a
  #define set_default_output_type(ss,a) ss->Default_Output_Type = a

  #define normalize_on_open(ss) ss->Normalize_On_Open
  #define init_normalize_on_open(ss,a) ss->Normalize_On_Open = a
  #define set_normalize_on_open(ss,a) ss->Normalize_On_Open = a

  #define auto_resize(ss) ss->Auto_Resize
  #define init_auto_resize(ss,a) ss->Auto_Resize = a
  #define set_auto_resize(ss,a) ss->Auto_Resize = a

  #define color_cutoff(ss) ss->Color_Cutoff
  #define init_color_cutoff(ss,a) ss->Color_Cutoff = a
  #define in_set_color_cutoff(ss,a) ss->Color_Cutoff = a

  #define color_inverted(ss) ss->Color_Inverted
  #define init_color_inverted(ss,a) ss->Color_Inverted = a
  #define in_set_color_inverted(ss,a) ss->Color_Inverted = a

  #define color_scale(ss) ss->Color_Scale
  #define init_color_scale(ss,a) ss->Color_Scale = a
  #define in_set_color_scale(ss,a) ss->Color_Scale = a

  #define fft_beta(ss) ss->Fft_Beta
  #define init_fft_beta(ss,a) ss->Fft_Beta = a
  #define in_set_fft_beta(ss,a) ss->Fft_Beta = a

  #define fft_size(ss) ss->Fft_Size
  #define init_fft_size(ss,a) ss->Fft_Size = a
  #define in_set_fft_size(ss,a) ss->Fft_Size = a

  #define fft_style(ss) ss->Fft_Style
  #define init_fft_style(ss,a) ss->Fft_Style = a
  #define in_set_fft_style(ss,a) ss->Fft_Style = a

  #define fft_window(ss) ss->Fft_Window
  #define init_fft_window(ss,a) ss->Fft_Window = a
  #define in_set_fft_window(ss,a) ss->Fft_Window = a

  #define initial_x0(ss) ss->Initial_X0
  #define init_initial_x0(ss,a) ss->Initial_X0 = a
  #define set_initial_x0(ss,a) ss->Initial_X0 = a

  #define initial_x1(ss) ss->Initial_X1
  #define init_initial_x1(ss,a) ss->Initial_X1 = a
  #define set_initial_x1(ss,a) ss->Initial_X1 = a

  #define initial_y0(ss) ss->Initial_Y0
  #define init_initial_y0(ss,a) ss->Initial_Y0 = a
  #define set_initial_y0(ss,a) ss->Initial_Y0 = a

  #define initial_y1(ss) ss->Initial_Y1
  #define init_initial_y1(ss,a) ss->Initial_Y1 = a
  #define set_initial_y1(ss,a) ss->Initial_Y1 = a

  #define line_size(ss) ss->Line_Size
  #define init_line_size(ss,a) ss->Line_Size = a
  #define set_line_size(ss,a) ss->Line_Size = a

  #define dot_size(ss) ss->Dot_Size
  #define init_dot_size(ss,a) ss->Dot_Size = a
  #define in_set_dot_size(ss,a) ss->Dot_Size = a

  #define normalize_fft(ss) ss->Normalize_Fft
  #define init_normalize_fft(ss,a) ss->Normalize_Fft = a
  #define in_set_normalize_fft(ss,a) ss->Normalize_Fft = a

  #define ask_before_overwrite(ss) ss->Ask_Before_Overwrite
  #define init_ask_before_overwrite(ss,a) ss->Ask_Before_Overwrite = a
  #define set_ask_before_overwrite(ss,a) ss->Ask_Before_Overwrite = a

  #define spectro_cutoff(ss) ss->Spectro_Cutoff
  #define init_spectro_cutoff(ss,a) ss->Spectro_Cutoff = a
  #define in_set_spectro_cutoff(ss,a) ss->Spectro_Cutoff = a

  #define spectro_x_angle(ss) ss->Spectro_X_Angle
  #define init_spectro_x_angle(ss,a) ss->Spectro_X_Angle = a
  #define in_set_spectro_x_angle(ss,a) ss->Spectro_X_Angle = a

  #define spectro_y_angle(ss) ss->Spectro_Y_Angle
  #define init_spectro_y_angle(ss,a) ss->Spectro_Y_Angle = a
  #define in_set_spectro_y_angle(ss,a) ss->Spectro_Y_Angle = a

  #define spectro_z_angle(ss) ss->Spectro_Z_Angle
  #define init_spectro_z_angle(ss,a) ss->Spectro_Z_Angle = a
  #define in_set_spectro_z_angle(ss,a) ss->Spectro_Z_Angle = a

  #define spectro_x_scale(ss) ss->Spectro_X_Scale
  #define init_spectro_x_scale(ss,a) ss->Spectro_X_Scale = a
  #define in_set_spectro_x_scale(ss,a) ss->Spectro_X_Scale = a

  #define spectro_y_scale(ss) ss->Spectro_Y_Scale
  #define init_spectro_y_scale(ss,a) ss->Spectro_Y_Scale = a
  #define in_set_spectro_y_scale(ss,a) ss->Spectro_Y_Scale = a

  #define spectro_z_scale(ss) ss->Spectro_Z_Scale
  #define init_spectro_z_scale(ss,a) ss->Spectro_Z_Scale = a
  #define in_set_spectro_z_scale(ss,a) ss->Spectro_Z_Scale = a

  #define spectro_hop(ss) ss->Spectro_Hop
  #define init_spectro_hop(ss,a) ss->Spectro_Hop = a
  #define in_set_spectro_hop(ss,a) ss->Spectro_Hop = a

  #define spectro_color(ss) ss->Spectro_Color
  #define init_spectro_color(ss,a) ss->Spectro_Color = a
  #define in_set_spectro_color(ss,a) ss->Spectro_Color = a

  #define speed_tones(ss) ss->Speed_Tones
  #define init_speed_tones(ss,a) ss->Speed_Tones = a
  #define set_speed_tones(ss,a) ss->Speed_Tones = a

  #define speed_style(ss) ss->Speed_Style
  #define init_speed_style(ss,a) ss->Speed_Style = a
  #define in_set_speed_style(ss,a) ss->Speed_Style = a

  #define graph_style(ss) ss->Graph_Style
  #define init_graph_style(ss,a) ss->Graph_Style = a
  #define in_set_graph_style(ss,a) ss->Graph_Style = a

  #define sinc_width(ss) ss->Sinc_Width
  #define init_sinc_width(ss,a) ss->Sinc_Width = a
  #define set_sinc_width(ss,a) ss->Sinc_Width = a

  #define mixer_groups(ss) ss->Mixer_Groups
  #define init_mixer_groups(ss,a) ss->Mixer_Groups = a
  #define set_mixer_groups(ss,a) ss->Mixer_Groups = a

  #define mixer_group_max_out_chans(ss) ss->Mixer_Group_Max_Out_Chans
  #define init_mixer_group_max_out_chans(ss,a) ss->Mixer_Group_Max_Out_Chans = a
  #define set_mixer_group_max_out_chans(ss,a) ss->Mixer_Group_Max_Out_Chans = a

  #define verbose_cursor(ss) ss->Verbose_Cursor
  #define init_verbose_cursor(ss,a) ss->Verbose_Cursor = a
  #define in_set_verbose_cursor(ss,a) ss->Verbose_Cursor = a

  #define movies(ss) ss->Movies
  #define init_movies(ss,a) ss->Movies = a
  #define set_movies(ss,a) ss->Movies = a

  #define prefix_arg(ss) ss->Prefix_Arg
  #define init_prefix_arg(ss,a) ss->Prefix_Arg = a
  #define set_prefix_arg(ss,a) ss->Prefix_Arg = a

  #define filter_env_order(ss) ss->Filter_Env_Order
  #define init_filter_env_order(ss,a) ss->Filter_Env_Order = a
  #define set_filter_env_order(ss,a) ss->Filter_Env_Order = a

  #define save_state_on_exit(ss) ss->Save_State_On_Exit
  #define init_save_state_on_exit(ss,a) ss->Save_State_On_Exit = a
  #define set_save_state_on_exit(ss,a) ss->Save_State_On_Exit = a

  #define zoom_focus_style(ss) ss->Zoom_Focus_Style
  #define init_zoom_focus_style(ss,a) ss->Zoom_Focus_Style = a
  #define set_zoom_focus_style(ss,a) ss->Zoom_Focus_Style = a

  #define fit_data_on_open(ss) ss->Fit_Data_On_Open
  #define init_fit_data_on_open(ss,a) ss->Fit_Data_On_Open = a
  #define set_fit_data_on_open(ss,a) ss->Fit_Data_On_Open = a

  #define mix_duration_brackets(ss) ss->Mix_Duration_Brackets
  #define init_mix_duration_brackets(ss,a) ss->Mix_Duration_Brackets = a
  #define set_mix_duration_brackets(ss,a) ss->Mix_Duration_Brackets = a

  #define eps_file(ss) ss->Eps_File
  #define init_eps_file(ss,a) ss->Eps_File = a
  #define set_eps_file(ss,a) ss->Eps_File = a

  #define session_file(ss) ss->Session_File
  #define init_session_file(ss,a) ss->Session_File = a
  #define set_session_file(ss,a) ss->Session_File = a

  #define temp_dir(ss) ss->Temp_Dir
  #define init_temp_dir(ss,a) ss->Temp_Dir = a
  #define set_temp_dir(ss,a) ss->Temp_Dir = a

  #define vu_font(ss) ss->Vu_Font
  #define init_vu_font(ss,a) ss->Vu_Font = a
  #define set_vu_font(ss,a) ss->Vu_Font = a

  #define vu_font_size(ss) ss->Vu_Font_Size
  #define init_vu_font_size(ss,a) ss->Vu_Font_Size = a
  #define set_vu_font_size(ss,a) ss->Vu_Font_Size = a

  #define vu_size(ss) ss->Vu_Size
  #define init_vu_size(ss,a) ss->Vu_Size = a
  #define set_vu_size(ss,a) ss->Vu_Size = a

  #define wavelet_type(ss) ss->Wavelet_Type
  #define init_wavelet_type(ss,a) ss->Wavelet_Type = a
  #define in_set_wavelet_type(ss,a) ss->Wavelet_Type = a

  #define transform_type(ss) ss->Transform_Type
  #define init_transform_type(ss,a) ss->Transform_Type = a
  #define in_set_transform_type(ss,a) ss->Transform_Type = a

  #define wavo_hop(ss) ss->Wavo_Hop
  #define init_wavo_hop(ss,a) ss->Wavo_Hop = a
  #define set_wavo_hop(ss,a) ss->Wavo_Hop = a

  #define wavo(ss) ss->Wavo
  #define init_wavo(ss,a) ss->Wavo = a
  #define in_set_wavo(ss,a) ss->Wavo = a

  #define wavo_trace(ss) ss->Wavo_Trace
  #define init_wavo_trace(ss,a) ss->Wavo_Trace = a
  #define set_wavo_trace(ss,a) ss->Wavo_Trace = a

  #define window_height(ss) ss->Window_Height
  #define init_window_height(ss,a) ss->Window_Height = a
  #define set_window_height(ss,a) ss->Window_Height = a

  #define window_width(ss) ss->Window_Width
  #define init_window_width(ss,a) ss->Window_Width = a
  #define set_window_width(ss,a) ss->Window_Width = a

  #define window_y(ss) ss->Window_Y
  #define init_window_y(ss,a) ss->Window_Y = a
  #define in_set_window_y(ss,a) ss->Window_Y = a

  #define window_x(ss) ss->Window_X
  #define init_window_x(ss,a) ss->Window_X = a
  #define in_set_window_x(ss,a) ss->Window_X = a

  #define x_axis_style(ss) ss->X_Axis_Style
  #define init_x_axis_style(ss,a) ss->X_Axis_Style = a
  #define in_set_x_axis_style(ss,a) ss->X_Axis_Style = a

  #define xmax(ss) ss->Xmax
  #define init_xmax(ss,a) ss->Xmax = a
  #define set_xmax(ss,a) ss->Xmax = a

  #define xmin(ss) ss->Xmin
  #define init_xmin(ss,a) ss->Xmin = a
  #define set_xmin(ss,a) ss->Xmin = a

  #define ymax(ss) ss->Ymax
  #define init_ymax(ss,a) ss->Ymax = a
  #define set_ymax(ss,a) ss->Ymax = a

  #define ymin(ss) ss->Ymin
  #define init_ymin(ss,a) ss->Ymin = a
  #define set_ymin(ss,a) ss->Ymin = a

  #define zero_pad(ss) ss->Zero_Pad
  #define init_zero_pad(ss,a) ss->Zero_Pad = a
  #define set_zero_pad(ss,a) ss->Zero_Pad = a

  #define show_fft_peaks(ss) ss->Show_Fft_Peaks
  #define init_show_fft_peaks(ss,a) ss->Show_Fft_Peaks = a
  #define in_set_show_fft_peaks(ss,a) ss->Show_Fft_Peaks = a

  #define show_y_zero(ss) ss->Show_Y_Zero
  #define init_show_y_zero(ss,a) ss->Show_Y_Zero = a
  #define in_set_show_y_zero(ss,a) ss->Show_Y_Zero = a

  #define show_mix_consoles(ss) ss->Show_Mix_Consoles
  #define init_show_mix_consoles(ss,a) ss->Show_Mix_Consoles = a
  #define in_set_show_mix_consoles(ss,a) ss->Show_Mix_Consoles = a

  #define show_marks(ss) ss->Show_Marks
  #define init_show_marks(ss,a) ss->Show_Marks = a
  #define in_set_show_marks(ss,a) ss->Show_Marks = a

  #define show_edit_history(ss) ss->Show_Edit_History
  #define init_show_edit_history(ss,a) ss->Show_Edit_History = a
  #define set_show_edit_history(ss,a) ss->Show_Edit_History = a

  #define subsampling(ss) ss->Subsampling
  #define init_subsampling(ss,a) ss->Subsampling = a
  #define in_set_subsampling(ss,a) ss->Subsampling = a

  #define fft_log_magnitude(ss) ss->Fft_Log_Magnitude
  #define init_fft_log_magnitude(ss,a) ss->Fft_Log_Magnitude = a
  #define in_set_fft_log_magnitude(ss,a) ss->Fft_Log_Magnitude = a

  #define fft_log_frequency(ss) ss->Fft_Log_Frequency
  #define init_fft_log_frequency(ss,a) ss->Fft_Log_Frequency = a
  #define in_set_fft_log_frequency(ss,a) ss->Fft_Log_Frequency = a

  #define channel_style(ss) ss->Channel_Style
  #define init_channel_style(ss,a) ss->Channel_Style = a
  #define in_set_channel_style(ss,a) ss->Channel_Style = a

  #define sound_style(ss) ss->Sound_Style
  #define init_sound_style(ss,a) ss->Sound_Style = a
  #define set_sound_style(ss,a) ss->Sound_Style = a

  #define raw_srate(ss) ss->Raw_Srate
  #define init_raw_srate(ss,a) ss->Raw_Srate = a
  #define set_raw_srate(ss,a) ss->Raw_Srate = a

  #define raw_chans(ss) ss->Raw_Chans
  #define init_raw_chans(ss,a) ss->Raw_Chans = a
  #define set_raw_chans(ss,a) ss->Raw_Chans = a

  #define raw_format(ss) ss->Raw_Format
  #define init_raw_format(ss,a) ss->Raw_Format = a
  #define set_raw_format(ss,a) ss->Raw_Format = a

  #define raw_type(ss) ss->Raw_Type
  #define init_raw_type(ss,a) ss->Raw_Type = a
  #define set_raw_type(ss,a) ss->Raw_Type = a

  #define use_raw_defaults(ss) ss->Use_Raw_Defaults
  #define init_use_raw_defaults(ss,a) ss->Use_Raw_Defaults = a
  #define set_use_raw_defaults(ss,a) ss->Use_Raw_Defaults = a

  #define print_length(ss) ss->Print_Length
  #define init_print_length(ss,a) ss->Print_Length = a
  #define set_print_length(ss,a) ss->Print_Length = a

  #define enved_clipping(ss) ss->Enved_Clipping
  #define init_enved_clipping(ss,a) ss->Enved_Clipping = a
  #define in_set_enved_clipping(ss,a) ss->Enved_Clipping = a

  #define enved_waving(ss) ss->Enved_Waving
  #define init_enved_waving(ss,a) ss->Enved_Waving = a
  #define in_set_enved_waving(ss,a) ss->Enved_Waving = a

  #define enved_target(ss) ss->Enved_Target
  #define init_enved_target(ss,a) ss->Enved_Target = a
  #define in_set_enved_target(ss,a) ss->Enved_Target = a

  #define enved_base(ss) ss->Enved_Base
  #define init_enved_base(ss,a) ss->Enved_Base = a
  #define in_set_enved_base(ss,a) ss->Enved_Base = a

  #define enved_exping(ss) ss->Enved_Exping
  #define init_enved_exping(ss,a) ss->Enved_Exping = a
  #define in_set_enved_exping(ss,a) ss->Enved_Exping = a

  #define recorder_autoload(ss) ss->Recorder_Autoload
  #define init_recorder_autoload(ss,a) ss->Recorder_Autoload = a
  #define in_set_recorder_autoload(ss,a) ss->Recorder_Autoload = a

  #define recorder_file(ss) ss->Recorder_File
  #define init_recorder_file(ss,a) ss->Recorder_File = a
  #define in_set_recorder_file(ss,a) ss->Recorder_File = a

  #define recorder_buffer_size(ss) ss->Recorder_Buffer_Size
  #define init_recorder_buffer_size(ss,a) ss->Recorder_Buffer_Size = a
  #define in_set_recorder_buffer_size(ss,a) ss->Recorder_Buffer_Size = a

  #define recorder_in_format(ss) ss->Recorder_In_Format
  #define init_recorder_in_format(ss,a) ss->Recorder_In_Format = a
  #define in_set_recorder_in_format(ss,a) ss->Recorder_In_Format = a

  #define recorder_srate(ss) ss->Recorder_Srate
  #define init_recorder_srate(ss,a) ss->Recorder_Srate = a
  #define in_set_recorder_srate(ss,a) ss->Recorder_Srate = a

  #define recorder_out_format(ss) ss->Recorder_Out_Format
  #define init_recorder_out_format(ss,a) ss->Recorder_Out_Format = a
  #define in_set_recorder_out_format(ss,a) ss->Recorder_Out_Format = a

  #define recorder_out_chans(ss) ss->Recorder_Out_Chans
  #define init_recorder_out_chans(ss,a) ss->Recorder_Out_Chans = a
  #define in_set_recorder_out_chans(ss,a) ss->Recorder_Out_Chans = a

  #define show_edit_history(ss) ss->Show_Edit_History
  #define init_show_edit_history(ss,a) ss->Show_Edit_History = a
  #define set_show_edit_history(ss,a) ss->Show_Edit_History = a

  #define edit_history_width(ss) ss->Edit_History_Width
  #define init_edit_history_width(ss,a) ss->Edit_History_Width = a
  #define in_set_edit_history_width(ss,a) ss->Edit_History_Width = a

#if HAVE_XmHTML
  #define html_width(ss) ss->HTML_Width
  #define init_html_width(ss,a) ss->HTML_Width = a
  #define set_html_width(ss,a) ss->HTML_Width = a

  #define html_height(ss) ss->HTML_Height
  #define init_html_height(ss,a) ss->HTML_Height = a
  #define set_html_height(ss,a) ss->HTML_Height = a

  #define html_dir(ss) ss->HTML_Dir
  #define init_html_dir(ss,a) ss->HTML_Dir = a
  #define set_html_dir(ss,a) ss->HTML_Dir = a

  #define html_font_size_list(ss) ss->HTML_Font_Size_List
  #define init_html_font_size_list(ss,a) ss->HTML_Font_Size_List = a
  #define set_html_font_size_list(ss,a) ss->HTML_Font_Size_List = a

  #define html_fixed_font_size_list(ss) ss->HTML_Fixed_Font_Size_List
  #define init_html_fixed_font_size_list(ss,a) ss->HTML_Fixed_Font_Size_List = a
  #define set_html_fixed_font_size_list(ss,a) ss->HTML_Fixed_Font_Size_List = a
#endif
#endif
