#if (!(HAVE_XmHTML))

/* some of the longer help texts */

static char file_menu_help[] =
"  Open: open a file.\n\
  Close: close the currently selected file.\n\
  Save: save any edits on the current file.\n\
  Save as: save edits on the current file,\n\
      in some new file.\n\
  Revert: undo any edits on the current file.\n\
  Mix: mix in a file.\n\
  Update: reload current sound from disk.\n\
  New: create an empty sound edit window.\n\
  Record: fire up the recorder\n\
  View: open a file in read-only mode.\n\
  Print: produce graph as Postscript file.\n\
  Exit: leave Snd, without saving any edits.\n\
";

char *get_file_menu_help(void) {return(file_menu_help);}


static char edit_menu_help[] =
"  Undo: undo the last edit in the current file.\n\
  Redo: redo the undone edit.\n\
  Find: a global search -- operates across all\n\
     currently sync'd sounds.\n\
  Cut: store, then delete the selection.\n\
  Paste: insert the selection at the current location\n\
  Mix selection: add the selection at the current location\n\
  Play selection: play the current selection.\n\
  Save selection: save the current selection in a file.\n\
  Edit Envelope: start the envelope editor dialog.\n\
  Edit Header: view or edit file's header.\n\
  Show Edit History: show edits as text.\n\
";

char *get_edit_menu_help(void) {return(edit_menu_help);}

static char view_menu_help[] =
"  Show Controls: display the control pane.\n\
  Normalize: During editing with multiple\n\
     files and channels, some data may be\n\
     obscured or compressed by changed window\n\
     sizes.  Normalize returns Snd to a state\n\
     where everything is equally compressed.\n\
  Channel style: combine all channels into\n\
     one graph.\n\
  Graph style: display data as dots, lines or,\n\
     filled polygons.\n\
  Show Marks: display mark locations using a\n\
     long vertical line.\n\
  Show Y=0: display the y=0 line.\n\
  Verbose cursor: show cursor loc and sample value.\n\
  Regions: fire up the region browser.\n\
  Files: fire up the file browser.\n\
  Color: color browser for sonogram.\n\
  Orientation: sonogram orientation.\n\
  Hide consoles: currently unimplemented.\n\
  X axis units: x axis labels in seconds, samples, ect.\n\
";

char *get_view_menu_help(void) {return(view_menu_help);}


static char options_menu_help[] = 
"   Transform Options: various fft-related settings\n\
   Speed style: control panel speed scrollbar interpretation.\n\
   Zoom focus: where to focus during zooms.\n\
   Subsampling off: When large amounts of data are\n\
      being displayed, Snd may subsample the data to\n\
      speed up the display process.  This can introduce\n\
      artifacts of the sampling interval on rare occasions.\n\
   Save Options: save the current Options and View menu settings.\n\
   Session: load or save session.\n\
\n\
";

char *get_options_menu_help(void) {return(options_menu_help);}

static char help_menu_help[] =   
"  Click for Help: if you choose this, the\n\
      mouse cursor becomes a '?'; position\n\
      the cursor over the portion of the Snd\n\
      window that interests you, and click\n\
      the button.\n\
  About Snd: this text.\n\
  FFT: a discussion of Snd's FFT options.\n\
  Find: how to perform searches.\n\
  Undo/Redo: how to back up while editing.\n\
  Sync: how to perform multichannel operations.\n\
  Speed: how to change sampling rate.\n\
  Expand: how to change tempo.\n\
  Reverb: how to reverberate.\n\
  Contrast: how to add contrast enhancement.\n\
  Envelope: how to apply an envelope.\n\
  Marks: about marks in Snd.\n\
  Mixing: about mixing in Snd.\n\
  Formats: Snd-supported formats and headers.\n\
  Customization: how to customize Snd.\n\
  User functions: how to add your own functions to Snd.\n\
  Recording: how to use the recorder.\n\
";

char *get_help_menu_help(void) {return(help_menu_help);}


static char about_snd_help[] = 
"Snd is a sound editor. See snd.html or snd.txt for\n\
full details.  Please send bug reports or suggestions to\n\
bil@ccrma.stanford.edu.\n\
\n\
To get started, go to the File menu, and\n\
open a sound file.  To hear the sound, click\n\
the 'play' button. To see an fft, click the\n\
'f' button on the left.  The left mouse button\n\
is used for most pointing operations; the\n\
middle button pastes in the current selection;\n\
the right button brings up the Snd popup menu.\n\
\n\
";

char *get_about_snd_help(void) {return(about_snd_help);}


static char graph_help[] =
"  [Down] zoom out, amount depends on state keys\n\
  [Up] zoom in\n\
  [Left] move window left, amount depends on state keys\n\
  [Right] move window right\n\
  <:   move cursor to sample 0\n\
  >:   move cursor to last sample\n\
  c-<: move cursor to sample 0\n\
  c->: move cursor to last sample\n\
  c-a: move cursor to window start\n\
  c-b: move cursor back one sample\n\
  c-d: delete sample at cursor\n\
  c-e: move cursor to window end\n\
  c-f: move cursor ahead one sample\n\
  c-g: abort current command\n\
  c-i: display cursor info\n\
  c-j: goto mark\n\
  c-k: delete one line's worth of samples\n\
  c-l: position window so cursor is in the middle\n\
  c-m: place (or remove) mark at cursor location\n\
  c-n: move cursor ahead one 'line'\n\
  c-o: insert one zero sample at cursor\n\
  c-p: move cursor back one 'line'\n\
  c-q: play current channel starting at cursor\n\
  c-r: repeat last search backwards\n\
  c-s: search according to an expression\n\
       'y' is the current sample value,\n\
       'y(n) is the value of the sample n from the current\n\
       the find expression syntax is C-like and\n\
       supports much of C and its math library.\n\
       c-s y>.1 finds the next sample greater than .1\n\
  c-t: stop playing\n\
  c-u: start count definition.  If followed by a\n\
       float, the actual count is that number multiplied\n\
       by the current sampling rate.  If the optional\n\
       number is followed by c-m, the count returned\n\
       is the distance from the cursor to the n-th\n\
       successive mark.  That is, c-u c-m c-f is the\n\
       same as c-j.\n\
  c-v: move cursor to mid-window\n\
  c-w: delete current region\n\
  c-x: start extended command (see below)\n\
  c-y: paste in last deleted region. Use c-u\n\
       to paste in earlier regions.\n\
  c-z: set sample at cursor to 0.0\n\
  c-_: undo\n\
  c-[Space]: start region definition\n\
       - c-[Space] to remove region\n\
\n\
The extended commands (preceded by c-x) are:\n\
  a: apply envelope to selection\n\
  b: position window so cursor is on left margin\n\
  c: define selection from cursor to nth mark\n\
  d: set temp dir name\n\
  e: execute last keyboard macro\n\
  f: position window so cursor is on right margin\n\
  i: insert region\n\
  j: goto named mark\n\
  k: close file\n\
  l: position selection in mid-view\n\
  n: re-evaluate expression over selection\n\
  o: move to next or previous graph\n\
  p: play selection or region n\n\
  q: mix in region\n\
  r: redo last undone edit\n\
  u: undo last edit\n\
  v: position window over current selection\n\
  w: save selection as file\n\
  x: evaluate expression over selection\n\
  z: smooth selection\n\
  /: place named mark\n\
  (: begin keyboard macro definition\n\
  ): end keyboard macro definition\n\
\n\
  c-a: apply envelope.  If a count is specified,\n\
     the envelope is applied from the cursor for\n\
     that number of samples.  Otherwise, the\n\
     envelope is applied to the entire file, and\n\
     if syncing is on, all sync'd channels.\n\
  c-b: set x window bounds (preceded by 1 arg)\n\
  c-c: hide controls\n\
  c-d: print\n\
  c-e: give last keyboard macro a name\n\
  c-f: open file\n\
  c-g: abort command\n\
  c-i: insert file\n\
  c-m: add named mark\n\
  c-n: re-evaluate expression\n\
  c-o: show controls\n\
  c-p: set window size (preceded by 1 arg)\n\
  c-q: mix in file\n\
  c-r: redo last undone edit\n\
  c-s: save file\n\
  c-u: undo last edit\n\
       Snd supports 'unlimited undo/redo'\n\
  c-v: set window size as percentage of total\n\
  c-w: save current channel in file\n\
  c-x: evaluate expression\n\
  c-z: smooth using cosine\n\
\n\
Unless otherwise noted, case is not significant;\n\
c-a is the same as c-A.\n\
\n\
Most commands can be prefaced by an integer or\n\
a float; the integer causes the command to be repeated\n\
that many times; the float is multiplied by the\n\
sound's sampling rate, then applied that many times.\n\
So, for example, c-u 1.0 c-f causes the cursor to move\n\
ahead one second in the sound.\n\
\n\
The y-axis limit (default = 1.0) can be set\n\
in the minibuffer via the variable 'ymax'.\n\
";

char *get_graph_help(void) {return(graph_help);}

static char fft_keypad_help[] = 
"The keypad keys are mapped to various variables as follows:\n\
\n\
    variable         increase           decrease\n\
  spectro-cutoff    PageUp (9)          PageDown (3)\n\
  spectro-hop       Add (+)             Subtract (-)\n\
  spectro-z-angle   RightArrow (6)      LeftArrow (4)\n\
  spectro-x-angle   Ctrl-UpArrow (8)    Ctrl-DownArrow (2)\n\
  spectro-y-angle   Ctrl-RightArrow (6) Ctrl-LeftArrow (4)\n\
  spectro-z-scale   UpArrow (8)         DownArrow (2)\n\
  fft-size          Multiply (*)        Divide (/)\n\
  dot-size          Delete (.)          Insert (0)\n\
\n\
You can rotate the spectrogram around the various axes\n\
by holding down the keypad and control keys.  You can get\n\
arbitrarily small or large ffts with the Multiply and\n\
Divide keys.  The x and y axis scalers are named\n\
spectro-x-scale and spectro-y-scale; they can be set via\n\
M-X and setf.  The keypad Enter key resets all the\n\
spectrogram variables to their default values.\n\
(In Linux, use the corresponding numbered keys --\n\
add shift to the key sequences given above).\n\
See also the Color and Orientation menu options\n\
in the View menu.\n\
\n\
";

char *get_fft_keypad_help(void) {return(fft_keypad_help);}

static char fft_menu_help[] = 
"The FFT performs a projection of the\n\
time domain into the frequency domain.\n\
Good discussions of the Fourier Transform\n\
and the trick used in the FFT itself\n\
can be found in many DSP books; those\n\
I know of include 'A Digital Signal Processing\n\
Primer', Ken Steiglitz, Addison-Wesley,\n\
1996; or 'Numerical Recipes in C', mentioned\n\
below.\n\
\n\
The FFT size can be any power of 2. The\n\
larger, the longer it takes to compute,\n\
and the larger the amount of the time domain\n\
that gets consumed.  Interpretation of the\n\
FFT results is not straightforward!\n\
\n\
The window choices are taken primarily\n\
from Harris' article.\n\
\n\
  Fredric J. Harris, 'On the Use of Windows\n\
     for Harmonic Analysis with the Discrete\n\
     Fourier Transform', Proceedings of the\n\
     IEEE, Vol. 66, No. 1, January 1978.\n\
\n\
with updates from:\n\
\n\
  Albert H. Nuttall, 'Some Windows with Very\n\
     Good Sidelobe Behaviour', IEEE Transactions\n\
     of Acoustics, Speech, and Signal Processing,\n\
     Vol. ASSP-29, 1, February 1981.\n\
\n\
\n\
Nearly all the transform-related choices are set\n\
by the transform dialog launched from the Options\n\
Menu Transform item. Most of this dialog should be\n\
self-explanatory.  Some of the windows take an\n\
additional parameter sometimes known as alpha or\n\
beta.  This is set in Snd by the scroller in the\n\
transform dialog.\n\
\n\
The FFT display is activated by setting the 'f'\n\
button on the channel's window.  It then updates\n\
itself each time the time domain waveform moves or\n\
changes.  The update function runs in the\n\
background, so in some cases, notably very large\n\
FFTs, you will notice that the FFT updates less\n\
often than the time domain.\n\
\n\
The spectrum data is usually normalized to fit\n\
between 0.0 to 1.0; if you'd rather have un-normalized\n\
data (the y-axis in this case changes to reflect the\n\
data values, to some extent), set the variable\n\
normalize-fft to 0.\n\
\n\
The actual FFT algorithm used here is the\n\
'realft' function from 'Numerical Recipes in C',\n\
by Press et al, Cambridge Univ Press, 1989.\n\
\n\
The harmonic analysis function is normally the\n\
Fourier Transform, but others are available,\n\
including about 20 wavelet choices, the Hankel and\n\
Chebyshev transforms, and perhaps others.\n\
\n\
";

char *get_fft_menu_help(void) {return(fft_menu_help);}

static char find_menu_help[] = 
"Searches in Snd refer to the sound data, and are\n\
in general patterned after Emacs.  When you type\n\
c-s or c-r, the minibuffer below the graph is\n\
activated and you are asked for the search expression.\n\
The expression is a piece of C-like code that describes\n\
which sample satisifies the search.  For example,\n\
to look for the next sample that is greater than\n\
.1, we could type: y>.1.  The cursor then moves\n\
to the next such sample, if any.  Successive c-s\n\
or c-r repeat the search.  c-x c-s can redefine the\n\
search pattern, which is also cleared in other\n\
events, much like Emacs.\n\
\n\
The search (and c-x c-x eval) expression\n\
syntax includes most of C's operators, and the\n\
standard math library, as well as a few variables\n\
internal to Snd.  To get at the current sample's\n\
value, use 'y'.  'y(n)' refers to the sample\n\
n samples from the current one. 'x' is the current\n\
sample number. 'samples' is the total number of\n\
samples.\n\
\n\
Normally, the search applies only to the current channel.\n\
To search all current files at once, use the Edit menu's\n\
find option.\n\
\n\
";

char *get_find_menu_help(void) {return(find_menu_help);}

static char expression_help[] = 
"The C operators implemented are:\n\
\n\
+ - * / > >= < <= == != ( ) { }\n\
=+ *= /= -= = || && ? : !\n\
\n\
The math library functions included are:\n\
\n\
log log10 exp cos sin abs (i.e. fabs)\n\
pow sqrt atan acos asin cosh sinh tanh fmod\n\
ceil floor pi\n\
";

char *get_expression_help(void) {return(expression_help);}


static char undo_menu_help[] = 
"Snd supports unlimited undo in the\n\
sense that you can backup through all\n\
the edits since the last save, and at\n\
any point redo those edits.  Certain\n\
operations require that temporary files\n\
be written, so disk space may eventually\n\
become a problem.  Revert is the same\n\
as backing up to the last save.\n\
\n\
In addition, eight or so of the previous\n\
selections are saved on a stack accessible\n\
via c-y.\n\
\n\
";

char *get_undo_menu_help(void) {return(undo_menu_help);}


static char sync_menu_help[] = 
"The sync button causes certain operations to\n\
apply to all channels simultaneously.  In mono\n\
sounds, the sync button has a similar effect,\n\
but applied across multiple sounds.\n\
\n\
To get multi-channel selections, set the sync\n\
button, then define the selection (by dragging\n\
the mouse) in one channel, and the parallel\n\
portions of the other channels will also be\n\
selected.\n\
\n\
";

char *get_sync_menu_help(void) {return(sync_menu_help);}


static char speed_menu_help[] = 
"'Speed' here refers to the rate at which the\n\
sound data is consumed during playback.\n\
Another term might be 'srate'.  Snd uses\n\
linear interpolation to perform the speed\n\
change.  The arrow button on the right determines\n\
the direction we move through the data.\n\
The scroll bar position is normally interpreted\n\
as a float between .05 and 20.  The Options\n\
Speed Style menu (or the speed-style variable)\n\
can change this to use semitones (actually microtones)\n\
or just-intonation ratios.  The number of equal\n\
divisions to the octave in the semitone case is\n\
set by the variable speed-tones (normally 12).\n\
\n\
";

char *get_speed_menu_help(void) {return(speed_menu_help);}


static char expand_menu_help[] = 
"'Expand' here refers to a kind of granular\n\
synthesis used to change the tempo of events\n\
in the sound without changing pitch.  Successive\n\
short slices of the file are overlapped with\n\
the difference in size between the input and\n\
output hops (between successive slices) giving\n\
the change in tempo.  This doesn't work in all\n\
files -- it sometimes sounds like execrable reverb\n\
or is too buzzy -- but it certainly is more\n\
robust than the phase vocoder approach to the\n\
same problem. \n\
\n\
There are a variety of variables that control\n\
hop sizes, segment lengths, and overall segment\n\
envelopes.  These can be set in the minibuffer\n\
via m-x and setf, or in your Snd init file.\n\
The variables are:\n\
\n\
  default-expand-ramp: the length of the ramp up (.4, 0 to .5)\n\
  default-expand-length: the length of each slice (.15)\n\
  default-expand-hop: the hop size (.05)\n\
\n\
The expander is on only if the expand\n\
button is set.\n\
\n\
";

char *get_expand_menu_help(void) {return(expand_menu_help);}


static char reverb_menu_help[] = 
"The Snd reverberator is a version of Michael\n\
McNabb's Nrev.  In addition to the controls\n\
in the control pane, you can set the reverb\n\
feedback gains and the coefficient of the low\n\
pass filter in the allpass bank. The variables\n\
are 'default-reverb-feedback' and 'default-reverb-lowpass'.\n\
The reverb is on only if the reverb button is set.\n\
";
char *get_reverb_menu_help(void) {return(reverb_menu_help);}


static char contrast_menu_help[] = 
"'Contrast enhancement' is my name for this\n\
somewhat weird waveshaper or compander.  It\n\
phase-modulates a sound, which can in some\n\
cases make it sound sharper or brighter.\n\
For softer sounds, it causes only an amplitude\n\
change.  Contrast is on only if the contrast\n\
button is set.\n\
";
char *get_contrast_menu_help(void) {return(contrast_menu_help);}


static char env_menu_help[] = 
"An envelope in Snd is a list of x y\n\
break-point pairs. The x axis range is\n\
arbitrary. For example, to define a triangle\n\
curve: '(0 0 1 1 2 0). There is no (obvious) limit\n\
on the number of breakpoints.\n\
\n\
To apply an envelope to a sound, use the extended\n\
command C-x C-a. If this command gets a numeric\n\
argument, the envelope is applied from the cursor\n\
for that many samples.\n\
\n\
  C-x a     apply amplitude envelope to selection\n\
  C-x C-a   apply amplitude envelope to channel\n\
\n\
You can also specify a envelope name to the C-x C-a\n\
prompt.\n\
\n\
To scale a file or selection by or to some\n\
amplitude, use the M-x commands:\n\
\n\
  scale-by args\n\
  scale-to args\n\
  scale-selection-by args\n\
  scale-selection-to args\n\
\n\
scale-by scales the current sync'd channels by its\n\
arguments, and scale-to scales them to its\n\
arguments (a normalization). The arguments in\n\
each case are either a list of floats\n\
corresponding to each successsive member of the\n\
current set of sync'd channels, or just one\n\
argument. In the latter case, scale-by uses that\n\
scaler for all its channels, and scale-to\n\
normalizes all the channels together so that the\n\
loudest reaches that amplitude (that is, scale-to\n\
.5) when applied to a stereo file means that both\n\
channels are scaled by the same amount so that the\n\
loudest point in the file becomes .5).\n\
";
char *get_env_menu_help(void) {return(env_menu_help);}


static char format_menu_help[] = 
"Snd can read and write any of the sound\n\
file data and header formats that CLM can\n\
handle:\n\
\n\
Supported read/write:\n\
  NeXT/Sun/DEC/AFsp 8-bit mulaw and alaw, 8, 16, 24, 32-bit linear, 32, 64-bit float\n\
  AIFF 8, 16, 24, 32-bit linear, 8-bit mulaw and alaw (AIFC in these cases)\n\
  RIFF ('wave') 16-bit linear, 8-bit unsigned, 32-bit linear, 8-bit mulaw, 8-bit alaw\n\
  IRCAM (old style) 16-bit linear, 32-bit float, 8-bit mulaw and alaw\n\
  no header, many data formats\n\
\n\
Supported read-only:\n\
  8SVX 8-bit linear, 16-bit linear\n\
  IRCAM 32-bit Vax float\n\
  EBICSF, INRS, ESPS, SPPACK, ADC (OGI) 16-bit linear\n\
  NIST-SPHERE 16-bit linear, 8-bit mulaw and alaw\n\
  AVR 16-bit linear and unsigned, 8-bit linear and unsigned\n\
  VOC 8-bit unsigned, 16-bit linear\n\
  Sound Tools 8-bit unsigned, PSION alaw, MAUD 8/16 bit\n\
  Turtle Beach SMP, SoundFont 2.0 16-bit linear\n\
  Sound Designer I, Tandy DeskMate 8-bit unsigned\n\
  Gravis Ultrasound 16-bit unsigned, Comdisco SPW\n\
  Goldwave sample, Sonic Foundry, DiamondWare,omf, avi\n\
  CSRE adf, SBStudio II, Delusion, Farandole, quicktime\n\
  Ultratracker, Sample Dump, Digiplayer, Yamaha\n\
\n\
Translated automatically:\n\
  IEEE text, Mus10 SAM 16-bit (modes 1 and 4)\n\
  IBM CVSD, HCOM, NIST shortpack, AVI\n\
  MIDI sample dump, Intel and Dialogic ADPCM\n\
  G721, G723, IFF Fibonacci and Exponential\n\
\n\
'Linear' here means 2's complement integer.\n\
The files can have any number of channels.\n\
Data can be either big or little endian.\n\
\n\
When edits are saved, files in the first\n\
group are changed in place; those in the second\n\
group are changed to use one of the first\n\
group's headers (normally Sun); those in\n\
the third group are translated when opened\n\
and an new (perhaps redundant) '.snd' extension\n\
is added to distinguish the original from the\n\
translated form; the latter is then treated\n\
as the original by the editor.\n\
\n\
";

char *get_format_menu_help(void) {return(format_menu_help);}


static char info_help[] = 
"This is the 'minibuffer', to use Emacs\n\
jargon.  Although it looks inert and wasted,\n\
there is in fact a text window lurking beneath\n\
that has access to the Lisp evaluator, not\n\
to mention much of the innards of the Snd program.\n\
";

char *get_info_help(void) {return(info_help);}


static char play_help[] =
"Snd can play any number of sounds at once\n\
or should be able to anyway.  A sort of\n\
clumsy realtime mixer, although it was not\n\
intended to fill that role. \n\
\n\
";

char *get_play_help(void) {return(play_help);}


static char mark_help[] = 
"A mark in Snd is attached to a particular\n\
sample in the sound data.  It moves with that\n\
sample as you edit the data, and if the sample\n\
is deleted, so is its mark.  Marks also follow\n\
the undo/redo edit history -- I'm not sure this\n\
is a good idea, but it seemed more intuitive\n\
than other alternatives.  This means that marks\n\
are 'undone' and 'redone' alongside the edits\n\
that they accompany.\n\
\n\
The mark symbol itself has three or four\n\
parts.  The name, if any, is at the top.\n\
Then a 'tab'.  You can click the name or\n\
tab portion and drag the mark to redefine it.\n\
Then a line to the bottom of the graph, showing\n\
where the mark is. And, below the x axis, an\n\
arrow.  You can click and drag the arrow to\n\
play the data following the mouse -- sort of\n\
like listening to a tape as you rock it back\n\
and forth by hand on the spindles. Or just\n\
click the arrow to play the data starting\n\
at the mark.\n\
\n\
";

char *get_mark_help(void) {return(mark_help);}


static char init_file_help[] =
"Nearly everything in Snd can be set in an initialization file, loaded at any\n\
time from a session file, specified via inter-process communciation from any\n\
other program, invoked via M-x in the minibuffer, imbedded in a keyboard\n\
macro, or dealt with from the lisp listener panel. The syntax used is lisp;\n\
if the Guile library is loaded, the underlying language is actually Scheme,\n\
these entities are fully incorporated into lisp, and all of them can be used\n\
in arbitrarily complicated functions. I've tried to bring out to lisp nearly\n\
every portion of Snd, both the signal-processing functions, and much of the\n\
user interface. You can, for example, add your own menu choices, editing\n\
operations, or graphing alternatives. These extensions can be loaded at any\n\
time.\n\
\n\
Sndlib (selected header and data format types):\n\
  next-sound-file    aiff-sound-file     riff-sound-file  snd-16-linear-little-endian\n\
  snd-16-linear      snd-8-mulaw         snd-8-linear     snd-32-linear-little-endian\n\
  snd-32-linear      snd-8-alaw          snd-8-unsigned   snd-32-float-little-endian\n\
  snd-64-double      snd-24-linear       snd-32-float\n\
\n\
FFT style (the Transform Options Display choice):\n\
  normal-fft         sonogram            spectrogram\n\
\n\
Transform type:\n\
  fourier-tranform   wavelet-tranform    hankel-tranform  chebyshev-tranform   legendre-tranform\n\
\n\
FFT Window type:\n\
  rectangular-window hanning-window     welch-window      parzen-window\n\
  bartlett-window    hamming-window     blackman2-window  blackman3-window\n\
  blackman4-window   exponential-window riemann-window    kaiser-window\n\
  cauchy-window      poisson-window     gaussian-window   tukey-window\n\
\n\
Zoom Focus style:\n\
  focus-left         focus-right        focus-active      focus-middle\n\
\n\
X-axis Label:\n\
  x-in-seconds       x-in-samples       x-to-one\n\
\n\
Speed Control style:\n\
  speed-as-float     speed-as-ratio     speed-as-semitone\n\
\n\
Channel Combination style;\n\
  channels-separate  channels-combined  channels-superimposed\n\
\n\
Envelope Editor target:\n\
  amplitude-env      spectrum-env       srate-env\n\
\n\
Graph Line style:\n\
  graph-lines        graph-dots         graph-filled\n\
\n\
Keyboard action choices:\n\
  cursor-in-view     cursor-on-left     cursor-on-right   cursor-in-middle\n\
  cursor-update-display cursor-no-action cursor-claim-selection keyboard-no-action\n\
\n\
These variables are accessed as though each were a function\n\
of no arguments, and set using a function with \"set-\" prepended\n\
to the variable name.  For example, auto-resize's current\n\
value can be accessed via (auto-resize), and set to a\n\
new value via (set-auto-resize #t). \n\
\n\
  ask-before-overwrite  0\n\
  auto-resize           1\n\
  channel-style         channels-separate\n\
  color-cutoff          0.003\n\
  color-inverted        1\n\
  color-scale           0.5\n\
  default-amp           1.0\n\
  default-contrast      0.0\n\
  default-contrast-amp  1.0\n\
  default-contrasting   0\n\
  default-expand        1.0\n\
  default-expand-hop    0.05\n\
  default-expand-length 0.15\n\
  default-expand-ramp   0.4\n\
  default-expanding     0\n\
  default-filter-order  2\n\
  default-filtering     0\n\
  default-output-type   next-sound-file\n\
  default-reverb-feedback 1.09\n\
  default-reverb-length 1.0\n\
  default-reverb-lowpass 0.7\n\
  default-reverb-scale  0.0\n\
  default-reverbing     0\n\
  default-speed         1.0\n\
  dot-size              1\n\
  edit-history-width    100\n\
  enved-base            1.0\n\
  enved-clipping        0\n\
  enved-exping          0\n\
  enved-target          amplitude-env\n\
  enved-waving          0\n\
  eps-file              nil\n\
  fft-beta              0.0\n\
  fft-log-frequency     0\n\
  fft-log-magnitude     0\n\
  fft-size              256\n\
  fft-style             normal-fft\n\
  fft-window            blackman2-window\n\
  filter-env-order      40\n\
  fit-data-on-open     -1\n\
  graph-style           graph-lines\n\
  initial-x0            0.0\n\
  initial-x1            0.1\n\
  initial-y0           -1.0\n\
  initial-y1            1.0\n\
  line-size             128\n\
  mix-amp-scaler        1.0\n\
  mix-duration-brackets 0\n\
  mix-speed-scaler      1.0\n\
  mix-tempo-scaler      1.0\n\
  mixer-group-max-out-chans 4\n\
  mixer-groups          6\n\
  movies                1\n\
  normalize-fft         1\n\
  normalize-on-open     1\n\
  prefix-arg            nil\n\
  print-length          12\n\
  raw-chans             1\n\
  raw-format            snd-16-linear\n\
  raw-srate             44100\n\
  raw-type              next-sound-file\n\
  recorder-autoload     0\n\
  recorder-buffer-size  4096\n\
  recorder-file         nil\n\
  recorder-in-format    16-bit linear\n\
  recorder-out-chans    2\n\
  recorder-out-format   same as above\n\
  recorder-srate        22050\n\
  reverb-decay          1.0\n\
  save-state-on-exit    0\n\
  session-file          nil\n\
  show-edit-history     0\n\
  show-fft-peaks        0\n\
  show-marks            1\n\
  show-mix-consoles     1\n\
  show-y-zero           0\n\
  sinc-width            10\n\
  spectro-color        -1\n\
  spectro-cutoff        1.0\n\
  spectro-hop           4\n\
  spectro-x-angle       90.0\n\
  spectro-x-scale       1.0\n\
  spectro-y-angle       0.0\n\
  spectro-y-scale       1.0\n\
  spectro-z-angle      -2.0\n\
  spectro-z-scale       0.1\n\
  speed-style           speed-as-float\n\
  speed-tones           12\n\
  subsampling           1\n\
  temp-dir              nil\n\
  transform-type        fourier-transform\n\
  use-raw-defaults      0\n\
  verbose-cursor        0\n\
  vu-font               nil\n\
  vu-font-size          1.0\n\
  vu-size               1.0\n\
  wavelet-type          0\n\
  wavo                  0\n\
  wavo-hop              3\n\
  wavo-trace            64\n\
  window-height         0\n\
  window-width          0\n\
  window-x             -1\n\
  window-y             -1\n\
  x-axis-style          x-in-seconds\n\
  xmax                  0.0\n\
  xmin                  0.0\n\
  ymax                  1.0\n\
  ymin                  1.0\n\
  zero-pad              0\n\
  zoom-focus-style      focus-active\n\
\n\
The hooks provide a way to customize various situations that arise through\n\
user-interface manipulations. Each is a string containing whatever lisp code\n\
should be evaluated. See the Examples section for examples.\n\
\n\
  open-hook\n\
  close-hook\n\
  fft-hook\n\
  graph-hook\n\
  exit-hook\n\
  start-hook\n\
\n\
When these hooks are invoked, the following variables are set:\n\
\n\
  open-hook-filename\n\
  close-hook-sound\n\
  fft-hook-sound\n\
  graph-hook-sound\n\
  fft-hook-channel\n\
  graph-hook-channel\n\
  fft-hook-scaler\n\
\n\
The '' functions give lisp access to most of Snd's data structures and\n\
functions.  In the argument lists below, snd as an\n\
argument refers to the sound's index, and defaults to the currently selected\n\
sound. Similarly, chn is the channel number, starting from 0, and defaults\n\
to the currently selected channel. So if there's only one sound active, and\n\
it has only one channel, (cursor) (cursor 0), and (cursor 0 0)\n\
all refer to the same thing.\n\
\n\
  active-sounds     ()\n\
  add-mark          (sample snd chn)\n\
  add-to-main-menu  (menu-label)\n\
  add-to-menu       (top-menu menu-label callback)\n\
  amp               (snd)\n\
  append-to-minibuffer (msg snd)\n\
  backward-graph    (count)\n\
  backward-mark     (count)\n\
  backward-mix      (count)\n\
  backward-sample   (count)\n\
  change-menu-label (top-menu old-label new-label)\n\
  channels          (snd)\n\
  chans             (snd)\n\
  clear-audio-inputs ()\n\
  clm-dialog        (msg)\n\
  close-sound       (snd)\n\
  color-dialog      ()\n\
  comment           (snd)\n\
  contrast          (snd)\n\
  contrast-amp      (snd)\n\
  contrasting?      (snd)\n\
  control-panel-restore (snd)\n\
  control-panel-save (snd)\n\
  cursor            (snd chn)\n\
  cursor-follows-play (snd)\n\
  cut               ()\n\
  data-format       (snd)\n\
  data-location     (snd)\n\
  delete-mark       (samp snd chn)\n\
  delete-region     (reg)\n\
  delete-sample     (samp snd chn)\n\
  delete-samples    (samp samps snd chn)\n\
  edit-header-dialog()\n\
  edits             (snd chn)\n\
  env               (envelope samp samps env-base snd chn)\n\
  env-selection     (envelope env-base snd chn)\n\
  enved-dialog      ()\n\
  exit              ()\n\
  expand            (snd)\n\
  expand-hop        (snd)\n\
  expand-length     (snd)\n\
  expand-ramp       (snd)\n\
  expanding?        (snd)\n\
  fft               (rl im sgn)\n\
  ffting?           (snd chn)\n\
  file-dialog       ()\n\
  file-name         (snd)\n\
  filter            (env order snd chn)\n\
  filter-env        (snd)\n\
  filter-order      (snd)\n\
  filtering?        (snd)\n\
  find-mark         (samp snd chn)\n\
  find-sound        (filename)\n\
  forward-graph     (count)\n\
  forward-mark      (count)\n\
  forward-mix       (count)\n\
  forward-sample    (count)\n\
  global-set-key    (key state code)\n\
  global-unset-key  (key state)\n\
  graph             (data xlabel x0 x1 snd chn)\n\
  graphing?         (snd chn)\n\
  group-amp         (group chan)\n\
  group-beg         (group)\n\
  group-dialog      ()\n\
  group-end         (group)\n\
  group-ok?         (group)\n\
  group-speed       (group)\n\
  group-tempo       (group)\n\
  groups            ()\n\
  header-type       (snd)\n\
  help-dialog       (subject help)\n\
  hide-listener     ()\n\
  insert-sound      (file in_chan snd chn)\n\
  insert-region     (reg snd chn)\n\
  insert-sample     (samp value snd chn)\n\
  insert-samples    (samp data snd chn)\n\
  key               (key state)\n\
  left-sample       (snd chn)\n\
  sound-length      (snd chn)\n\
  make-region       (beg end snd chn)\n\
  mark-name         (mark snd chn)\n\
  mark-sample       (mark snd chn)\n\
  marks             (snd chn)\n\
  max-sounds        ()\n\
  maxamp            (snd chn)\n\
  mix               (file samp in_chan snd chn)\n\
  mix-amp           (mix chan)\n\
  mix-anchor        (mix)\n\
  mix-groups        (mix)\n\
  mix-length        (mix)\n\
  mix-position      (mix)\n\
  mix-region        (samp scaler reg snd chn)\n\
  mix-speed         (mix)\n\
  mix-state         (mix)\n\
  new-sound         (name)\n\
  normalize-view    ()\n\
  ok?               (snd)\n\
  open-sound        (name)\n\
  open-alternate-sound(name)\n\
  orientation-dialog()\n\
  peaks             (snd chn)\n\
  play              (samp snd chn)\n\
  play-region       (reg)\n\
  preload-directory (dir)\n\
  preload-file      (file)\n\
  print             ()\n\
  protect-region    (reg protect)\n\
  read-only?        (snd)\n\
  record-dialog     ()\n\
  recorder-gain     (gain)\n\
  recorder-in-amp   (in out)\n\
  recorder-out-amp  (out)\n\
  redo              (edits snd chn)\n\
  region-chans      (reg)\n\
  region-dialog     ()\n\
  region-length     (reg)\n\
  region-maxamp     (reg)\n\
  region-sample     (samp reg chn)\n\
  region-samples    (samp samps reg chn)\n\
  region-srate      (reg)\n\
  regions           ()\n\
  report-in-minibuffer (msg snd)\n\
  reverb-feedback   (snd)\n\
  reverb-length     (snd)\n\
  reverb-lowpass    (snd)\n\
  reverb-scale      (snd)\n\
  reverbing?        (snd)\n\
  revert-sound      (snd)\n\
  right-sample      (snd chn)\n\
  sample            (samp snd chn)\n\
  samples           (samp samps snd chn)\n\
  save-edit-history (file snd chn)\n\
  save-sound        (snd)\n\
  save-sound-as     (filename snd)\n\
  save-macros       ()\n\
  save-marks        (snd)\n\
  save-region       (reg filename)\n\
  save-state        ()\n\
  scale-by          (scalers snd chn)\n\
  scale-selection-by(scalers)\n\
  scale-selection-to(scalers)\n\
  scale-to          (scalers snd chn)\n\
  select-channel    (chn)\n\
  select-region     (reg)\n\
  select-sound      (snd)\n\
  selected-channel  (snd)\n\
  selected-sound    ()\n\
  set-amp           (amp snd)\n\
  set-contrast      (contrast snd)\n\
  set-contrast-amp  (contrast-amp snd)\n\
  set-contrasting   (contrasting snd)\n\
  set-cursor        (samp snd chn)\n\
  set-cursor-follows-play (cursor-follows snd)\n\
  set-expand        (expand-amount snd)\n\
  set-expand-hop    (expand-hop snd)\n\
  set-expand-length (expand-length snd)\n\
  set-expand-ramp   (expand-ramp snd)\n\
  set-expanding     (contrasting snd)\n\
  set-ffting        (on snd chn)\n\
  set-filter-order  (filter-order snd)\n\
  set-filter-env    (filter-env snd)\n\
  set-filtering     (filtering snd)\n\
  set-graph-style   (style)\n\
  set-graphing      (on snd chn)\n\
  set-group-amp     (group chan amp)\n\
  set-group-beg     (group beg)\n\
  set-group-end     (group end)\n\
  set-group-speed   (group speed)\n\
  set-group-tempo   (group tempo)\n\
  set-just-sounds   (just-sounds)\n\
  set-left-sample   (samp snd chn)\n\
  set-mark-name     (mark name snd chn)\n\
  set-mark-sample   (mark sample snd chn)\n\
  set-menu-sensitive (top-menu label on)\n\
  set-mix-amp       (mix chan amp)\n\
  set-mix-anchor    (mix anchor)\n\
  set-mix-groups    (mix groups)\n\
  set-mix-length    (mix length)\n\
  set-mix-position  (mix samp)\n\
  set-mix-speed     (mix speed)\n\
  set-mix-state     (mix state)\n\
  set-read-only     (read-only snd)\n\
  set-recorder-gain(gain amp)\n\
  set-recorder-in-amp(in out amp)\n\
  set-recorder-out-amp(out amp)\n\
  set-reverb-decay  (decay snd)\n\
  set-reverb-feedback(feedback snd)\n\
  set-reverb-length(length snd)\n\
  set-reverb-lowpass(lowpass snd)\n\
  set-reverb-scale(scale snd)\n\
  set-reverbing     (on snd)\n\
  set-right-sample  (samp snd chn)\n\
  set-sample        (samp value snd chn)\n\
  set-samples       (samp samps data snd chn)\n\
  set-showing-controls (showing snd)\n\
  set-speed         (speed snd)\n\
  set-syncing       (syncing snd)\n\
  set-uniting       (style snd)\n\
  set-waving        (on snd chn)\n\
  set-x-bounds      (x0 x1 snd chn)\n\
  set-y-bounds      (y0 y1 snd chn)\n\
  short-file-name   (snd)\n\
  showing-controls? (snd)\n\
  show-listener     ()\n\
  speed             (snd)\n\
  srate             (snd)\n\
  src               (num-or-env base)\n\
  stop              (snd)\n\
  syncing?          (snd)\n\
  transform-dialog  ()\n\
  transform-sample  (bin slice snd chn)\n\
  transform-samples (snd chn()\n\
  undo              (edits snd chn)\n\
  uniting?          (snd)\n\
  update-soun       ()\n\
  update-ffts       ()\n\
  update-graphs     ()\n\
  version           ()\n\
  view-sound        (filename)\n\
  waving            (snd chn()\n\
  window-height     ()\n\
  window-width      ()\n\
  x-bounds          (snd chn)\n\
  y-bounds          (snd chn)\n\
  yes-or-no-p       (ques)\n\
\n\
  setq setf defvar\n\
\n\
Some of the underlying sound library (Sndlib functions are available in lisp\n\
(and more could be made available, if they're needed).\n\
\n\
  sound-samples (filename)\n\
  sound-datum-size (filename)\n\
  sound-data-location (filename)\n\
  sound-chans (filename)\n\
  sound-srate (filename)\n\
  sound-header-type (filename)\n\
  sound-data-format(filename)\n\
  sound-length (filename)\n\
  sound-type-specifier (filename)\n\
  sound-type-name (type)\n\
  sound-format-name (format)\n\
  sound-comment (filename)\n\
  bytes-per-sample (format)\n\
  audio-error ()\n\
  audio-error-name(err)\n\
\n\
";


char *get_init_file_help(void) {return(init_file_help);}

static char resource_help[] =
"Snd-specific resources are:\n\
\n\
initFile       \"~/.snd\"\n\
epsFile        \"snd.eps\"\n\
overwriteCheck 0\n\
groups         6\n\
autoResize     1\n\
\n\
buttonFont     -*-times-medium-r-*-*-14-*-*-*-*-*-iso8859-1\n\
boldbuttonFont -*-times-bold-r-*-*-14-*-*-*-*-*-iso8859-1\n\
axisLabelFont  -*-times-medium-r-normal-*-20-*-*-*-*-*-iso8859-1\n\
axisNumbersFont -*-courier-medium-r-normal-*-14-*-*-*-*-*-iso8859-1\n\
helpTextFont    9x15\n\
listenerFont    9x15\n\
\n\
useSchemes      none\n\
lightestcolor   ivory1\n\
basiccolor      ivory2\n\
darkcolor       ivory3\n\
darkestcolor    ivory4\n\
textcolor       lightsteelblue1\n\
cursorcolor     cyan ! (in Linux: red)\n\
selectioncolor  ivory4\n\
mixercolor      lightgreen\n\
groupcolor      red\n\
lightbluecolor  aliceblue\n\
\n\
If you use schemes, the color resources are ignored.\n\
\n";

char *get_resource_help(void) {return(resource_help);}


static char region_browser_help[] =
"This is the 'region browser'.  The scrolled\n\
window contains the list of current regions\n\
with a brief title to indicate the provenance\n\
thereof, and two buttons.  The 'save' button\n\
protects or unprotects the region from deletion.\n\
The 'play' button plays the associated region.\n\
One channel of the currently selected region\n\
is displayed in the graph window.  The up and\n\
down arrows move up or down in the region's\n\
list of channels.  If you click a region's\n\
title, the text is highlighted, and that region\n\
is displayed in the graph area.  You can cause\n\
that region to become the current 'selection'\n\
by clicking the 'Select' button (this merely\n\
moves the region to the top slot in the region\n\
list).  You can delete the selected region by\n\
clicking the 'Delete' button.  To dismiss the\n\
browser, click 'Ok'.\n\
\n";

char *get_region_browser_help(void) {return(region_browser_help);}

static char mixing_help[] =
"Since mixing is the most common and most useful\n\
editing operation performed on sounds, there is\n\
relatively elaborate support for it in Snd. Each\n\
individual mix portion has a mix console, a\n\
small box displayed in above the waveform\n\
containing various controls. These consoles\n\
follow the sync buttons where relevant. More\n\
importantly, consoles can be edited together by\n\
collecting related mix portions into a group,\n\
then firing up the Group Editor (via the View\n\
menu Groups option). In a sense, a group can be\n\
viewed as Snd's way of implementing a more normal\n\
mixer's tracks.\n\
\n\
To mix in a file, use either the File Mix menu\n\
option or the command C-x C-q. Currently the only\n\
difference between these two is that the Mix menu\n\
option tries to take the current sync state into\n\
account, whereas the C-x C-q command does not. To\n\
mix a selection, use C-x q. The mix starts at the\n\
current cursor location.\n\
\n\
When a section or file is mixed into the current\n\
file a mix console is associated with it, each\n\
output channel getting its own console. The\n\
console is displayed at first as a row of widgets\n\
giving the input file name, the begin and end\n\
times of the mixed-in portion (click to change\n\
from seconds to samples), then three icons:\n\
\n\
  a speaker:   while pushed, the input is played\n\
  an 'x':      click to remove the console permanently\n\
  a box:       click to open (or close) the console\n\
\n\
You can drag the widgets to change the position\n\
of the mix. Once opened, each console presents a\n\
pane with an amplitude slider for each input\n\
channel, and a speed control (srate change on the\n\
input). The initial state of the console sets the\n\
speed to 1.0, and all the input amplitudes 0.0\n\
except the channel that matches the current\n\
output channel, which is set to 1.0 (a straight\n\
mix). To return to this state at any time, click\n\
the 'amp:' label. To turn the mix off ('mute' it,\n\
set all amps to 0.0), double click the label; to\n\
return to the last settings you made, click it\n\
with control or meta down. Similarly, click the\n\
'speed:' label to reset it to 1.0, and click it\n\
with control or meta to return to your last\n\
settings. Each time you release the mouse button\n\
(or click the amp label) counts as another 'edit'\n\
of the file, so it is usually better to use\n\
'undo' and 'redo' in this context, rather than\n\
repeated clicks and shift-clicks. The srate scale\n\
is interpreted in the same way as the sound pane\n\
speed control -- as a float normally, but also,\n\
if you like, quantized to semitones or integer\n\
ratios.\n\
\n\
To change the scale interpretation, set the\n\
variables mix-amp-scaler, mix-speed-scaler, and\n\
in the group editor mix-tempo-scaler; all default\n\
to 1.0 which gives a scaling from 0 to around\n\
12. These numbers actually scale an exponent, so\n\
(for example) if mix-amp-scaler is set to 0.5,\n\
the scale goes from 0.0 to around 3.5; similarly\n\
if mix-tempo-scaler is 0.025, its scale goes from\n\
around .95 to 1.05.\n\
\n\
To reduce the mix console to the single letter\n\
'M', double click the file name. Double click the\n\
'M' to return to the original row of icons. Since\n\
screen space is at a premium, this minimal form\n\
of the console can reduce clutter. You can still\n\
drag the 'M' to reposition the mix.\n\
\n\
When any edit is performed that changes the file\n\
within the mixed portion, the affected mix\n\
consoles are removed from the display, and the\n\
only way to return to them is to undo the\n\
offending edit. That is, if you mix a portion,\n\
then cut some part of that portion, the mix will\n\
be locked in place from then on, as if you had\n\
clicked the 'x' button on the mix console.\n\
\n\
To turn off the constant graphics updates (which\n\
can slow down old machines like mine, and which\n\
can also be annoying when you know what you're\n\
doing), set the variable movies to 0 (it is also\n\
accessible in the Group Editor).\n\
\n\
When a sound is mixed into a file that has its\n\
sync button on, the separate channels are tied\n\
together so that as long as the sync button is\n\
on, if you move one mix console the other sync'd\n\
consoles move with it. Similarly, any speed\n\
change is reflected automatically in the other\n\
consoles; amplitude changes however, are not\n\
copied. To make the sync'd consoles independent,\n\
turn off the sync button. Once unsync'd, the\n\
consoles remain independent unless you 'undo'\n\
enough edits to return to the sync'd state.\n\
\n";
char *get_mixing_help(void) {return(mixing_help);}

static char grouping_help[] = 
"To tie together an arbitrary collection of mix\n\
consoles, use the 'group' buttons in the upper\n\
right corner of the mixer. Any mixers that share\n\
a button can be changed in parallel using the\n\
Group Editor (the Groups option under the View\n\
menu). The group editor gives amplitude control\n\
over each output channel that has a mix that is\n\
a member of the group. The speed control affects\n\
the sampling rate, and the tempo control affects\n\
the spacing of the individual members of the\n\
group. The play button plays just the group\n\
members.\n\
\n\
The group editor envelope fields use the same\n\
syntax as other Snd envelopes: '(0 0 1 1) is a\n\
ramp, for example, and '(0 0 1 1 2 0) is a sort\n\
of pyramid. The envelope data in a given field\n\
only takes effect after the field has been\n\
activated (normally by a carriage return). The\n\
tempo envelope is interpreted in terms of the\n\
current group times using the placement of the\n\
given mix within the group to find the parallel\n\
place on the (arbitrary) tempo envelope x axis.\n\
The value of the envelope at that point becomes\n\
another tempo multiplier; that is, these\n\
envelopes are not time maps (perhaps someday!).\n\
Since a tempo value of 2 makes things happen\n\
twice as slowly (it essentially multiplies begin\n\
times), the tempo envelope causes things to go\n\
faster as it gets closer to zero -- weird!\n\
\n\
The underlying mix consoles have independent\n\
envelopes, but my original plan to include\n\
envelope text fields in the consoles made them\n\
too big, cluttered, and unwieldy; an attempt to\n\
make each console a scrollable (or paned) window\n\
failed due to unfortunate limitations in\n\
Motif. These could be overcome, but would\n\
require much more programming than I think the\n\
issue is worth. I'm interested in better ideas,\n\
if anyone has any. One idea I'm goofing around\n\
with makes the mix matrix entries visicalc-like\n\
expressions.\n\
\n\
Since a mix is viewed in Snd as just another\n\
edit which you can undo and redo, and since one\n\
mix console can be participating in any number\n\
of groups, and since any number of files can\n\
have these grouped mixes active at once, and\n\
since you can ungroup a mix, then undo the\n\
related edit, it becomes a bit of a pain to\n\
describe what each sequence of actions will do.\n\
In general, think of a group as simply another\n\
kind of 'sync' button. The Group Editor itself\n\
does not follow the undo/redo chains (edits in\n\
Snd are considered to be local to each channel,\n\
but the group editor affects all mixes together,\n\
possibly across many channels). Each change to a\n\
group control immediately affects all mixes\n\
associated with that group, in each case as a\n\
single edit of each participating channel. Each\n\
change to the mix console takes into account the\n\
state of the groups that it is a member of.\n\
Undo of any edit simply undoes the edit -- the\n\
mix console will back up one state, but if the\n\
group controls have changed in the meantime, the\n\
two are now out of sync. Similarly, if you\n\
remove a mix from a group, the group's effect\n\
upon the mix is removed as well. If it joins a\n\
group with current state, that causes an\n\
immediate change in the mixed portion's\n\
state. The tempo control, however, only affects\n\
mixes that are under its control when it is\n\
changed (does that make sense? -- the idea is\n\
that you might want to leave a group briefly to\n\
fix a local mix position or speed, then rejoin\n\
the group, but in that process you don't want\n\
the tempo control to cause the mix to jump about\n\
randomly in time). Similar complications affect\n\
the group envelopes. You can choose whether the\n\
envelope is applied over the entire output\n\
duration, or just the group duration; in the\n\
latter case, you need to be aware that adding or\n\
removing mixes can change that duration,\n\
changing the effect of the envelope. Group state\n\
changes by themselves are not edits (i.e. if a\n\
group has no members, undo and redo will not\n\
notice that you've been fiddling with its amp\n\
scalers). If a mix is participating in several\n\
groups, all associated groups affect the mix\n\
together (group states are multiplied, and\n\
envelopes are melded into something resembling a\n\
gathering of the various envelopes). If a mix is\n\
synced to others, and joins or leaves a group,\n\
all the synced mixes follow its lead. All of\n\
this can be summarized: groups act like the sync\n\
buttons. And if it's confusing, consider the\n\
alternatives; or better, decide once and for all\n\
which mixes are grouped together, and use only\n\
one group per mix. Then everything should be\n\
intuitive.\n\
\n\
";
char *get_grouping_help(void) {return(grouping_help);}


static char recording_help[] = 
"To make a recording, choose 'Record' from the\n\
File menu. A window opens with the various\n\
recording controls.  The top three panes display\n\
the status of the input and output lines. If a\n\
channel is active, its meter will glow\n\
yellow. If some signal clips during recording,\n\
the meter will flash red. The numbers below the\n\
channel buttons indicate the signal maximum\n\
since it was last reset. The sliders underneath\n\
the meters scale the audio data in various ways\n\
before it is mixed into the output. The vertical\n\
sliders on the right scale the line-in and\n\
microphone signals before the meter, and the\n\
output signal before it gets to the speaker\n\
(these are needed to avoid clipping on input,\n\
and to set the 'monitor' volume of the output\n\
independent of the output file volume).\n\
\n\
The fourth pane has information about the\n\
current output file (its name and so on), and\n\
the layout of the window. The buttons on the\n\
right can be used to open and close panes\n\
painlessly. If the button is not square (a\n\
diamond on the SGI), the underlying audio\n\
hardware can't handle input from that device at\n\
the same time as it reads other 'radio' button\n\
devices. So, in that case, opening the panel via\n\
the button also turns off the other incompatible\n\
device. The fifth pane contains a history of\n\
whatever the recorder thought worth\n\
reporting. The duration field gives the current\n\
output file's duration. The bottom row of\n\
buttons dismiss the window, start recording,\n\
cancel the current take, and provide some\n\
help. There's also a slider on the far right\n\
that controls the speaker output volume\n\
(independent of the output file volume).\n\
\n\
To make a recording, choose the inputs and\n\
outputs you want; for example, to record channel\n\
A from the microphone to channel A of the output\n\
file, click the Microphone panel's A button and\n\
the Output panel's A button. Then when you're\n\
ready to go, click the Record button. Click it\n\
again to finish the recording.\n\
\n\
If the record window's VU meters are too big (or\n\
too small) for your screen, you can fool around\n\
with the variable vu-size which defaults to 1.0.\n\
Similarly the variable vu-font-size tries to\n\
change the size of the numbers on the label, and\n\
vu-font chooses the family name of the font\n\
used.\n\
\n\
Digital input is slightly tricky -- you\n\
need to set the sampling rate before you\n\
click the 'digital input' button; otherwise\n\
you'll get a stuttering effect because the output\n\
(monitor) rate doesn't match the input rate.\n\
";

char *get_recording_help(void) {return(recording_help);}


static char envelope_editor_help[] = 
"The Edit Envelope dialog (under the Edit menu)\n\
fires up a window for viewing and editing\n\
envelopes. The dialog has a display showing either\n\
the envelope currently being edited or a panorama\n\
of all currently loaded envelopes. The current\n\
envelope can be edited with the mouse: click at\n\
some spot in the graph to place a new breakpoint,\n\
drag an existing breakpoint to change its\n\
position, and click an existing breakpoint to\n\
delete it. The Undo and Redo buttons can be used\n\
to move around in the list of envelope edits; the\n\
current state of the envelope can be saved with\n\
the 'save' button, or printed with 'print'.\n\
\n\
Envelopes can be defined using defvar, and loaded\n\
from a separate file of envelope definitions via\n\
the load function or the Session dialog's Load command.\n\
For example, the file:\n\
\n\
  (defvar ramp '(0 0 1 1))\n\
  (defvar pyramid '(0 0 1 1 2 0))\n\
\n\
defines two envelopes that can be used in Snd\n\
wherever an envelope is needed (e.g. C-x C-a). You\n\
can also define a new envelope in the dialog's\n\
text field; '(0 0 1 1) followed by return fires up\n\
a ramp as a new envelope.\n\
\n\
In the overall view of envelopes, click an\n\
envelope, or click its name in the scrolled list\n\
on the left to select it; click the selected\n\
envelope to load it into the editor portion,\n\
clearing out whatever was previously there.  To\n\
load an exisiting envelope into the editor, you\n\
can also type its name in the text field; to give\n\
a name to the envelope as it is currently defined\n\
in the graph viewer, type its name in this field,\n\
then either push return or the 'save' button.\n\
\n\
Once you have an envelope in the editor, it can be\n\
applied to the currently active sounds via the\n\
'Apply' or 'Undo&Apply' buttons; the latter first\n\
tries to undo the previous edit, then applies the\n\
envelope. The envelope can be applied to the\n\
amplitude, the spectrum, or the sampling rate. The\n\
choice is made via the three buttons marked 'amp',\n\
'flt', and 'src'. The filter order is the variable\n\
filter-env-order which defaults to 40. (The\n\
equivalent M-X function is (filter-env order\n\
env)). The sampling rate conversion sinc width is\n\
the variable src-width which defaults to 10 (the\n\
equivalent M-X function is (src env)). To\n\
interrupt the application of the envelope, click\n\
the 'Stop' button.\n\
\n\
The two toggle buttons at the lower right choose\n\
whether to show a light-colored version of the\n\
currently active sound (the 'wave' button), and\n\
whether to clip mouse movement at the current y\n\
axis bounds (the 'clip' button).\n\
";

char *get_envelope_editor_help(void) {return(envelope_editor_help);}


static char edit_history_help[] = 
"The current state of the undo/redo list can be\n\
viewed as a scrolled list of strings by choosing\n\
the Edit menu's Show edit history option. The list\n\
is placed on the left of the associated channel\n\
pane. If there are no current edits, it just lists\n\
the associated file name (i.e. the zero-edits\n\
state).  As you edit the sound, the operations\n\
appear in the edit list window. Click on a member\n\
of the list to move to that point in the edit list\n\
(equivalent to some number of undo's or\n\
redo's). To move to a given edit point and follow\n\
the sync chain (if any), use control-click.\n\
\n\
Use edit-history-width to change the edit list's\n\
width. examp.scm has key bindings that might make\n\
this process simpler. If Guile is loaded, the\n\
function save-edit-history saves the current edit\n\
list as a loadable program.\n\
";

char *get_edit_history_help(void) {return(edit_history_help);}

#endif
