;;; Auto-test sequence for Snd as driven from CLM
;;;
;;; to run snd under dbx while driving it from clm, 
;;;   start clm, :pa clm, (snd-open-fifos)
;;;   dbx -r snd
;;;   (receive-snd), (setf snd-is-connected t), :pa USER, :ld snd-test

(in-package :clm)
(trace send-snd receive-snd)

(defvar test-loops 1) ;number of times to repeat this entire test sequence

(defun srss (n &optional no-wait)
  (if (not no-wait) (sleep 1))
  (send-and-receive-snd n))

(defun con-test (var-name true-val)
  (let ((val (srss (format nil "(let ((val ~A)) val)" var-name) t)))
    (if (/= val true-val) (print (format nil "~S is ~A (not ~A)" var-name val true-val)))))

(defun sndlib-test (var-name true-val &optional other-val)
  (let ((val (srss (format nil "(~A \"oboe.snd\")" var-name) t)))
    (if (and (/= val true-val) (or (not other-val) (/= val other-val))) (print (format nil "~S is ~A (not ~A)" var-name val true-val)))))

(defun var-test (var-name init-val new-val)
  (let ((val (srss (concatenate 'string "(" var-name ")") t)))
    (if (/= val init-val) (print (format nil "~S is ~A (not ~A)" var-name val init-val)))
    (srss (concatenate 'string "(set-" var-name (format nil " ~S" new-val) ")") t)
    (let ((curval (srss (concatenate 'string "(" var-name ")") t)))
      (if (/= curval new-val) (print (format nil "~S set to ~A (not ~A)" var-name curval new-val)))
      (srss (concatenate 'string "(set-" var-name (format nil " ~S" init-val) ")") t))))

(defun in-var-test (var-name new-val &optional arg1 arg2)
  (srss (concatenate 'string "(set-" var-name " " (or arg1 "") " " (or arg2 "") (format nil " ~S)" new-val)) t)
  (let ((val (srss (concatenate 'string "(" var-name " " (or arg1 "") " " (or arg2 "") ")") t)))
    (if (/= val new-val) (print (format nil "~A is ~A (not ~A)" var-name val new-val)))))


(defun decode-state (n) (if (= n 0) "MD_CS" (if (= n 1) "MD_TITLE" "MD_M")))
(defvar z-snd-index 0)
(defvar obtest-index 0)

(defvar hdr-dir-accessible t)		;does ~/hdr have all the CLM test sound files
(setf nap-time 4)
(setf i 0)

(run-in-shell "cp" "oboe.snd obtest.snd") ; used in save/save-as/save-mark tests
(when (probe-file "/tmp/snd_snd_fifo") (delete-file "/tmp/snd_snd_fifo"))

(let ((clm-snd-lisp (concatenate 'string "clm-snd." *clm-lisp-name*))
      (clm-snd-fasl (concatenate 'string "clm-snd." *clm-fasl-name*)))
  (when (or (not (probe-file clm-snd-fasl)) 
	    (> (file-write-date clm-snd-lisp) (file-write-date clm-snd-fasl)))
    (compile-file clm-snd-lisp))
  (load clm-snd-fasl))

(start-snd)
(sleep 2)
(print (format nil "Snd version: ~A" (srss "(version)"))) (force-output)

(defvar ob-snd "ob.snd")
(defvar ob-snd-index 0)
(if (not (probe-file "ob.snd")) (setf ob-snd "oboe.snd"))
(defvar now-snd "now.snd")
(defvar now-snd-index 0)
(if (not (probe-file "now.snd")) (setf now-snd "oboe.snd"))
(defvar four-snd "4.snd")
(defvar four-snd-index 0)
(if (not (probe-file "4.snd"))
    (with-sound (:channels 4 :output "4.snd" :play nil :wait t) (user::fm-violin 0 1 440 .1)))
(defvar two-snd "2.snd")
(defvar two-snd-index 0)
(if (not (probe-file "2.snd"))
    (with-sound (:channels 2 :output "2.snd" :play nil :wait t) (user::fm-violin 0 1 440 .1)))
(defvar four-aiff "4.aiff")
(defvar four-aiff-index 0)
(if (not (probe-file "4.aiff")) (setf four-aiff four-snd))
(defvar two-aiff "2.aiff")
(defvar two-aiff-index 0)
(if (not (probe-file "2.aiff")) (setf two-aiff two-snd))
(if (not (probe-file "z.snd")) (with-sound (:channels 1 :output "z.snd" :play nil :wait t) ))

(defvar have-guile nil)

(let ((guile (srss "(guile)")))
  (setf have-guile (and guile (numberp guile) (= guile 1))))

(loop for i-loops from 0 below test-loops do
      
(setf ob-snd-index (srss (format nil "(open-sound ~S)" ob-snd)))
(print "ob")
(sleep 2)

(srss "(play)")
(if have-guile (srss "(set-graph-style graph-dots)") (srss "(set-graph-style 1)"))
(srss "(set-show-fft-peaks #f)")
(srss "(set-cursor 1200)")
(setf i (srss "(cursor)"))
(if (/= i 1200) (print (format nil "cursor at ~D?" i)))
(srss "(set-ffting #t)")  

(when have-guile
  ;; ---------------- Constants 
  (con-test "next-sound-file" NeXT-sound-file)
  (con-test "aiff-sound-file" AIFF-sound-file)
  (con-test "riff-sound-file" RIFF-sound-file)
  (con-test "snd-16-linear" snd-16-linear)
  (con-test "snd-8-mulaw" snd-8-mulaw)
  (con-test "snd-8-linear" snd-8-linear)
  (con-test "snd-32-float" snd-32-float)
  (con-test "snd-32-linear" snd-32-linear)
  (con-test "snd-8-alaw" snd-8-alaw)
  (con-test "snd-8-unsigned" snd-8-unsigned)
  (con-test "snd-24-linear" snd-24-linear)
  (con-test "snd-64-double" snd-64-double)
  (con-test "snd-16-linear-little-endian" snd-16-linear-little-endian)
  (con-test "snd-32-linear-little-endian" snd-32-linear-little-endian)
  (con-test "snd-32-float-little-endian" snd-32-float-little-endian)
  (con-test "amplitude-env" 0)
  (con-test "spectrum-env" 1)
  (con-test "srate-env" 2)
  (con-test "graph-lines" 0)
  (con-test "graph-dots" 1)
  (con-test "graph-filled" 2)
  (con-test "normal-fft" 0)
  (con-test "sonogram" 1)
  (con-test "spectrogram" 2)
  (con-test "focus-left" 0)
  (con-test "focus-right" 1)
  (con-test "focus-active" 2)
  (con-test "focus-middle" 3)
  (con-test "x-in-seconds" 0)
  (con-test "x-in-samples" 1)
  (con-test "x-to-one" 2)
  (con-test "speed-as-float" 0)
  (con-test "speed-as-ratio" 1)
  (con-test "speed-as-semitone" 2)
  (con-test "channels-separate" 0)
  (con-test "channels-combined" 1)
  (con-test "channels-superimposed" 2)
  (con-test "fourier-transform" 0)
  (con-test "wavelet-transform" 1)
  (con-test "hankel-transform" 2)
  (con-test "chebyshev-transform" 3)
  (con-test "legendre-transform" 4)
  (con-test "rectangular-window" 0)
  (con-test "hanning-window" 1)
  (con-test "welch-window" 2)
  (con-test "parzen-window" 3)
  (con-test "bartlett-window" 4)
  (con-test "hamming-window" 5)
  (con-test "blackman2-window" 6)
  (con-test "blackman3-window" 7)
  (con-test "blackman4-window" 8)
  (con-test "exponential-window" 9)
  (con-test "riemann-window" 10)
  (con-test "kaiser-window" 11)
  (con-test "cauchy-window" 12)
  (con-test "poisson-window" 13)
  (con-test "gaussian-window" 14)
  (con-test "tukey-window" 15)
  )

;;; ---------------- Sndlib
(sndlib-test "sound-samples" 50828)
(sndlib-test "sound-datum-size" 2)
(sndlib-test "sound-data-location" 28)
(sndlib-test "sound-chans" 1)
(sndlib-test "sound-srate" 22050)
(sndlib-test "sound-header-type" 0)
(sndlib-test "sound-data-format" 1)
(sndlib-test "sound-length" 101684)
(sndlib-test "sound-type-specifier" 1684960046 779316836)
(print (format nil "oboe.snd: ~A ~A comment: ~A" (srss "(sound-type-name 0)") (srss "(sound-format-name 1)") (srss "(sound-comment \"oboe.snd\")")))


;;; ---------------- Variables
(var-test "fft-size" 256 512)
(var-test "fft-style" 0 1)
(var-test "sinc-width" 10 20)
(var-test "speed-tones" 12 20)
(let ((val (srss "(default-contrasting)" t))) (if (and val (/= val 0)) (print (format nil "default-contrasting is ~D" val))))
(let ((val (srss "(default-expanding)" t))) (if (and val (/= val 0)) (print (format nil "default-expanding is ~D" val))))
(let ((val (srss "(default-reverbing)" t))) (if (and val (/= val 0)) (print (format nil "default-reverbing is ~D" val))))
(let ((val (srss "(default-filtering)" t))) (if (and val (/= val 0)) (print (format nil "default-filtering is ~D" val))))
(var-test "default-filter-order" 2 20)
(let ((val (srss "(normalize-on-open)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "normalize-on-open is ~D" val))))
(let ((val (srss "(auto-resize)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "auto-resize is ~D" val)))) 
(let ((val (srss "(color-inverted)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "color-inverted is ~D" val))))
(var-test "zero-pad" 0 1)
(var-test "line-size" 128 256)
(let ((val (srss "(ask-before-overwrite)" t))) (if (and val (/= val 0)) (print (format nil "ask-before-overwrite is ~D" val))))
(var-test "x-axis-style" 0 1)
(let ((val (srss "(wavo)" t))) (if (and val (/= val 0)) (print (format nil "wavo is ~D" val))))
(var-test "wavo-hop" 3 20)
(var-test "wavo-trace" 64 20)
(var-test "spectro-hop" 4 20)
(var-test "spectro-color" -1 0)
(var-test "wavelet-type" 0 1)
(var-test "transform-type" 0 1)
(var-test "dot-size" 1 20)
(var-test "speed-style" 0 1)
(let ((val (srss "(movies)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "movies is ~D" val))))
(let ((val (srss "(normalize-fft)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "normalize-fft is ~D" val))))
(let ((val (srss "(mix-duration-brackets)" t))) (if (and val (/= val 0)) (print (format nil "mix-duration-brackets is ~D" val))))
(var-test "fit-data-on-open" -1 0)
(var-test "zoom-focus-style" 2 0)
(let ((val (srss "(save-state-on-exit)" t))) (if (and val (/= val 0)) (print (format nil "save-state-on-exit is ~D" val))))
(var-test "graph-style" 1 0)
(var-test "filter-env-order" 40 20)
(var-test "mixer-groups" 6 8)
(var-test "mixer-group-max-out-chans" 4 8)
(let ((val (srss "(verbose-cursor)" t))) (if (and val (/= val 0)) (print (format nil "verbose-cursor is ~D" val))))
(let ((val (srss "(show-fft-peaks)" t))) (if (and val (/= val 0)) (print (format nil "show-fft-peaks is ~D" val))))
(let ((val (srss "(show-y-zero)" t))) (if (and val (/= val 0)) (print (format nil "show-y-zero is ~D" val))))
(let ((val (srss "(show-marks)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "show-marks is ~D" val))))
(let ((val (srss "(subsampling)" t))) (if (or (not val) (and (numberp val) (/= val 1))) (print (format nil "subsampling is ~D" val))))
(let ((val (srss "(fft-log-magnitude)" t))) (if (and val (/= val 0)) (print (format nil "fft-log-magnitude is ~D" val))))
(let ((val (srss "(fft-log-frequency)" t))) (if (and val (/= val 0)) (print (format nil "fft-log-frequency is ~D" val))))
(var-test "channel-style" 0 1)
(var-test "raw-srate" 44100 22050)
(var-test "raw-chans" 1 2)
(var-test "raw-format" 1 2)
(var-test "raw-type" 0 1)
(let ((val (srss "(use-raw-defaults)" t))) (if (and val (/= val 0)) (print (format nil "use-raw-defaults is ~D" val))))
(var-test "print-length" 12 20)
(var-test "show-mix-consoles" 1 0)
(let ((val (srss "(recorder-autoload)" t))) (if (and val (/= val 0)) (print (format nil "recorder-autoload is ~D" val))))
(var-test "recorder-buffer-size" 4096 1024)
(var-test "recorder-out-chans" 2 1)
(var-test "recorder-srate" 22050 44100)
(let ((val (srss "(enved-waving)" t))) (if (and val (/= val 0)) (print (format nil "enved-waving is ~D" val))))
(let ((val (srss "(enved-clipping)" t))) (if (and val (/= val 0)) (print (format nil "enved-clipping is ~D" val))))
(let ((val (srss "(enved-exping)"))) (if (and val (/= val 0)) (print (format nil "enved-exping is ~D" val))))
(var-test "enved-target" 0 1)
(var-test "default-amp" 1.0 2.0)
(var-test "default-contrast" 0.0 1.0)
(var-test "default-contrast-amp" 1.0 0.0)
(var-test "default-expand-length" .15 .10)
(var-test "default-expand-ramp" .4 .20)
(var-test "default-expand-hop" .05 .025)
(var-test "default-reverb-feedback" 1.09 1.0)
(var-test "default-reverb-lowpass" 0.7 0.8)
(var-test "default-expand" 1.0 2.0)
(var-test "default-speed" 1.0 2.0)
(var-test "default-reverb-scale" 0.0 1.0)
(var-test "default-reverb-length" 1.0 2.0)
(var-test "reverb-decay" 1.0 3.0)
(var-test "initial-x0" 0.0 .10)
(var-test "initial-x1" 0.1 .20)
(var-test "initial-y0" -1.0 -2.0)
(var-test "initial-y1" 1.0 2.0)
(var-test "xmax" 0.0 0.0)
(var-test "xmin" 0.0 0.0)
(var-test "ymax" 1.0 1.0)
(var-test "ymin" -1.0 -1.0)
(var-test "spectro-x-scale" 1.0 2.0)
(var-test "spectro-y-scale" 1.0 2.0)
(var-test "spectro-z-scale" 0.1 2.0)
(var-test "spectro-z-angle" -2.0 2.0)
(var-test "spectro-x-angle" 90.0 2.0)
(var-test "spectro-y-angle" 0.0 2.0)
(var-test "fft-beta" 0.0 1.0)
(var-test "color-cutoff" .003 .10)
(var-test "color-scale" 0.5 .20)
(var-test "spectro-cutoff" 1.0 .50)
(var-test "vu-size" 1.0 2.0)
(var-test "vu-font-size" 1.0 2.0)
(var-test "enved-base" 1.0 2.0)

;;; ---------------- Functions
(setf now-snd-index (srss (format nil "(view-sound ~S)" now-snd)))
(print "ob+now")
(srss (format nil "(close-sound ~D)" ob-snd-index))
(print "now")
(setf z-snd-index (srss "(open-sound \"z.snd\")"))
(print "now+z")
(srss "(set-fft-log-magnitude 0)")
(srss "(set-waving 0)")
(srss (format nil "(close-sound ~D)" z-snd-index))
(print "now")
(srss "(set-show-y-zero)")
(srss "(set-window-width 600)")
(srss "(set-window-height 400)")
(if have-guile (srss "(set-graph-style graph-lines)") (srss "(set-graph-style 0)"))
(srss "(set-show-fft-peaks)")
(srss "(set-fft-log-magnitude)")
(srss "(set-ffting)")
(srss "(set-show-marks)")
(srss "(set-cursor 12000)")
(srss "(add-mark 12000)")
(srss "(set-cursor 6000)")
(srss "(add-mark 6000)")
(srss "(set-cursor 18000)")
(srss "(set-show-y-zero 0)")
(srss "(set-fft-log-magnitude 0)")
(srss "(set-subsampling 0)")
(srss "(find-mark 12000)")
(srss "(set-ffting 0)")
(srss "(set-x-bounds 0.0 1.0)")
(srss "(set-x-bounds 0.1 0.15)")
(srss "(set-waving 0)")
(if have-guile (srss "(set-fft-style sonogram)") (srss "(set-fft-style 1)"))
(srss "(set-ffting 1)")
(srss "(set-spectro-cutoff .5)")
(srss "(set-showing-controls)")
(srss "(set-waving)")
(srss "(set-y-bounds -3.0 3.0)")
(srss "(set-x-bounds 0.0 2.0)")
(srss "(set-subsampling)")
(srss "(set-show-marks 0)")
(if have-guile (srss "(set-transform-type fourier-transform)") (srss "(set-transform-type 0)"))
(srss "(set-show-fft-peaks)")
(srss "(set-fft-log-frequency)")
(srss "(set-fft-log-magnitude 0)")
(srss "(set-showing-controls 0)")
(srss "(set-x-bounds 0.0 0.1)")
(if have-guile (srss "(set-fft-style spectrogram)") (srss "(set-fft-style 2)"))
(srss "(set-fft-log-frequency 0)")
(setf ob-snd-index (srss (format nil "(open-sound ~S)" ob-snd)))
(print "now+ob")
(srss (format nil "(close-sound ~D)" now-snd-index))
(print "ob")
(srss "(delete-samples 0 1200)")
(srss "(undo 1)")
(srss "(redo 1)")
(srss "(undo 1)")
(srss "(env '(0 0 1 1 2 0) 0 22050)")
(srss "(undo 1)")
(srss (format nil "(key ~D ~D)" (char-code #\f) 4))
(srss "(set-syncing)")
(setf now-snd-index (srss (format nil "(open-sound ~S)" now-snd)))
(print "now+ob")
(srss "(set-syncing)")
(srss "(normalize-view)")
(srss (format nil "(key ~D ~D)" (char-code #\e) 4))
(srss (format nil "(key ~D ~D)" (char-code #\f) 4))
(srss "(set-syncing 0)")
;; try various keyboard commands  
(srss "(set-just-sounds)")
(srss (format nil "(select-sound ~D)" ob-snd-index))
(srss (format nil "(key ~D ~D)" (char-code #\>) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\<) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\>) 0))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\<) 0))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\a) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\e) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\b) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\p) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\n) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\l) 4))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\b) 0))
(srss "(set-cursor 1200)")
(srss "(make-region 1000 2000)")
(srss "(cut)")
(srss "(set-cursor 0)")
(srss "(insert-region)")
(srss (format nil "(revert-sound ~S)" ob-snd-index))
(srss (format nil "(key ~D ~D)" (char-code #\m) 4))
(srss (format nil "(key ~D ~D)" (char-code #\v) 4))
(srss (format nil "(key ~D ~D)" (char-code #\d) 4))
(srss (format nil "(key ~D ~D)" (char-code #\z) 4))
(srss (format nil "(key ~D ~D)" (char-code #\o) 4))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\u) 0))
(srss "(undo 2)")
(srss (format nil "(key ~D ~D)" (char-code #\<) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))

(let ((data (make-array 32 :element-type 'integer :initial-element 8192))
      (indata nil))
  (loop for i from 0 to 31 do (setf (aref data i) (* (- 32 i) 256)))
  (srss "(clm-snd-set-samples 632)")
  (clm-data 32 data)
  (srss "(set-cursor 0)")
  (srss "(undo 1)")
  (srss "(undo 1)")
  (srss "(redo 2)")
  (srss "(undo 2)")
  (srss "(make-region 1000 1010)")
  (setf indata (srss "(region-samples 0)"))
  (print indata))
(srss (format nil "(key ~D ~D)" (char-code #\w) 4))
(srss (format nil "(key ~D ~D)" (char-code #\y) 4))
(srss (format nil "(key ~D ~D)" (char-code #\q) 4))
(srss (format nil "(key ~D ~D)" (char-code #\t) 4))
(srss "(set-cursor 8000)")
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\f) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\l) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\u) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\r) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\v) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\o) 4))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\u) 4))
(srss (format nil "(revert-sound ~S)" ob-snd-index))
;; now pound on file open/close for awhile
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\k) 0))
(srss (format nil "(close-sound ~D)" now-snd-index))
(print "ob")
;; should be just menu-bar here
;; most commands work, pound on file open/close (widgets get a work out and sound list gets reallocated)
(when hdr-dir-accessible
  (let ((o2i (srss "(open-sound \"~/hdr/o2.bicsf\") "))
	(r8ui (srss "(open-sound \"~/hdr/riff-8-u.snd\") ")))
    (srss (format nil "(close-sound ~D)" r8ui))
    (let ((wi (srss "(open-sound \"~/hdr/wood.riff\") ")))
      (srss (format nil "(close-sound ~D)" o2i))
      (let ((wmi (srss "(open-sound \"~/hdr/wood.maud\") "))
	    (wsfi (srss "(open-sound \"~/hdr/wood.sf\") ")))
	(srss (format nil "(close-sound ~D)" wmi))
	(srss (format nil "(close-sound ~D)" wi))
	(let ((w12i (srss "(open-sound \"~/hdr/wood12.aiff\")"))
	      (w24i (srss "(open-sound \"~/hdr/wood24.aiff\")")))
	  (srss (format nil "(close-sound ~D)" wsfi))
	  (let ((n24i (srss "(open-sound \"~/hdr/next24.snd\") "))
		(e16i (srss "(open-sound \"~/hdr/esps-16.snd\")")))
	    (srss (format nil "(close-sound ~D)" n24i))
	    (srss (format nil "(close-sound ~D)" e16i)))
	  (srss (format nil "(close-sound ~D)" w12i))
	  (srss (format nil "(close-sound ~D)" w24i)))
	(let ((sd16i (srss "(open-sound \"~/hdr/sd1-16.snd\") "))
	      (in16i (srss "(open-sound \"~/hdr/inrs-16.snd\")"))
	      (s16i (srss "(open-sound \"~/hdr/sun-16-afsp.snd\")"))
	      (n16i (srss "(open-sound \"~/hdr/next-16.snd\") "))
	      (smi (srss "(open-sound \"~/hdr/sun-mulaw.snd\") "))
	      (nmi (srss "(open-sound \"~/hdr/next-mulaw.snd\")")))
	  (srss "(normalize-view)")
	  (let ((n8i (srss "(open-sound \"~/hdr/next-8.snd\") ")))
	    (srss (format nil "(close-sound ~D)" in16i))
	    (srss (format nil "(close-sound ~D)" s16i))
	    (srss (format nil "(close-sound ~D)" n16i))
	    (let ((nist16i (srss "(open-sound \"~/hdr/nist-16.snd\") ")))
	      (srss (format nil "(close-sound ~D)" sd16i))
	      (srss (format nil "(close-sound ~D)" smi))
	      (let ((v8i (srss "(open-sound \"~/hdr/voc-8-u.snd\") "))
		    (r16i (srss "(open-sound \"~/hdr/riff-16.snd\") "))
		    (a8i (srss "(open-sound \"~/hdr/aiff-8.snd\") "))
		    (a16i (srss "(open-sound \"~/hdr/aiff-16.snd\")")))
		(srss "(normalize-view) ")
		(srss (format nil "(close-sound ~D)" nist16i))
		(srss (format nil "(close-sound ~D)" v8i))
		(srss (format nil "(close-sound ~D)" r16i))
		(srss (format nil "(close-sound ~D)" a8i))
		(let ((wbi (srss "(open-sound \"~/hdr/woodblock.aiff\")")))
		  (srss (format nil "(close-sound ~D)" nmi))
		  (srss (format nil "(close-sound ~D)" n8i))
		  (srss (format nil "(close-sound ~D)" a16i))
		  (let ((uli (srss "(open-sound \"~/hdr/ulaw.aifc\") "))
			(ali (srss "(open-sound \"~/hdr/alaw.aifc\") ")))
		    (srss (format nil "(close-sound ~D)" wbi))
		    (srss (format nil "(close-sound ~D)" uli))
		    (srss (format nil "(close-sound ~D)" ali)))))))))))
  (let ((ki (srss "(open-sound \"~/hdr/kirk.wve\")"))
	(ai (srss "(open-sound \"~/hdr/addf8.d\") ")))
    (srss (format nil "(close-sound ~D)" ki))
    (srss (format nil "(close-sound ~D)" ai))))
(srss (format nil "(close-sound ~D)" ob-snd-index))

;; basic stuff is ok -- now pound on regions and the sync button (multi-channel ops)
(setf four-snd-index (srss (format nil "(open-sound ~S)" four-snd)))
(print "four")
(srss "(set-window-width 600)")
(srss "(set-window-height 800)")
(srss "(normalize-view) ")
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\o) 0))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\o) 0))

(let ((data (make-array 32 :element-type 'integer :initial-element 8192))
      (indata nil))
  (loop for k from 0 to 3 do
    (loop for i from 0 to 31 do (setf (aref data i) (* (- 32 i) 256)))
    (srss "(clm-snd-set-samples 632)")
    (clm-data 32 data)
    (loop for j from 0 to 6 do
      (srss (format nil "(key ~D ~D)" (char-code #\m) 4))
      (srss (format nil "(set-cursor ~D)" (* j 1000))))
    (srss "(set-cursor 0)")
    (srss "(undo 1)")
    (srss "(undo 1)")
    (srss "(redo 2)")
    (srss "(undo 2)")
    (srss "(make-region 1000 1010)")
    (srss (format nil "(key ~D ~D)" (char-code #\w) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\y) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\x) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\o) 0))))
(setf two-snd-index (srss (format nil "(open-sound ~S)" two-snd)))
(print "four+two")
(srss "(set-syncing)")
(let ((data (make-array 32 :element-type 'integer :initial-element 8192))
      (indata nil))
  (loop for k from 0 to 1 do
    (loop for j from 0 to 6 do
      (srss (format nil "(key ~D ~D)" (char-code #\m) 4))
      (srss (format nil "(set-cursor ~D)" (* j 1000))))
    (loop for i from 0 to 31 do (setf (aref data i) (* (- 32 i) 256)))
    (srss "(clm-snd-set-samples 632)")
    (clm-data 32 data)
    (srss "(set-cursor 0)")
    (srss "(undo 1)")
    (srss "(undo 1)")
    (srss "(redo 2)")
    (srss "(undo 2)")
    (srss "(make-region 1000 1010)")
    (srss (format nil "(key ~D ~D)" (char-code #\w) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\y) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\x) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\o) 0))))
(setf ob-snd-index (srss (format nil "(open-sound ~S)" ob-snd)))
(print "ob+four+two")
(srss (format nil "(revert-sound ~D)" four-snd-index))
(srss (format nil "(revert-sound ~D)" two-snd-index))
(srss (format nil "(close-sound ~D)" four-snd-index))
(srss (format nil "(close-sound ~D)" two-snd-index))
(print "ob")
(loop for i from 0 to 30 do
  (srss (format nil "(make-region ~D ~D)" (* i 100) (* i 110)))
  (when (> (random 1.0) .5) 
    (srss (format nil "(key ~D ~D)" (char-code #\x) 4))
    (srss (format nil "(key ~D ~D)" (char-code #\p) 0))))
(srss (format nil "(close-sound ~D)" ob-snd-index))
(setf two-snd-index (srss (format nil "(open-sound ~S)" two-snd)))
(setf ob-snd-index (srss (format nil "(open-sound ~S)" ob-snd)))
(setf four-snd-index (srss (format nil "(open-sound ~S)" four-snd)))
(print "ob+two+four")
(srss "(normalize-view)")
(srss (format nil "(close-sound ~D)" four-snd-index))
(srss (format nil "(close-sound ~D)" two-snd-index))
(srss (format nil "(close-sound ~D)" ob-snd-index))
(setf ob-snd-index (srss (format nil "(open-sound ~S)" ob-snd)))
(print "ob")
(srss "(set-syncing)")
(setf four-snd-index (srss (format nil "(open-sound ~S)" four-snd)))
(srss (format nil "(set-syncing ~D)" four-snd-index))
(setf two-snd-index (srss (format nil "(open-sound ~S)" two-snd)))
(print "ob+two+four")
(srss (format nil "(set-syncing ~D)" two-snd-index))
;; now multi-channel ops
(srss (format nil "(key ~D ~D)" (char-code #\>) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\<) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\>) 0))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\<) 0))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\a) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\e) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\b) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\p) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\n) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\l) 4))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\b) 0))
(srss "(set-cursor 1200)")
(srss "(make-region 1000 2000)")
(srss "(cut)")
(srss "(set-cursor 0)")
(srss "(insert-region 0)")
(srss "(undo 2)")
(srss "(redo)")
(srss "(undo)")
(srss "(redo)")
(srss "(undo)")
(srss "(set-syncing 0)")
(srss (format nil "(close-sound ~D)" two-snd-index))
(srss (format nil "(close-sound ~D)" four-snd-index))
(srss (format nil "(close-sound ~D)" ob-snd-index))
(setf four-aiff-index (srss (format nil "(open-sound ~S)" four-aiff)))
(print "4")
(srss "(set-syncing)")
(setf two-aiff-index (srss (format nil "(open-sound ~S)" two-aiff)))
(print "2+4")
(srss "(set-syncing)")
;; now multi-channel ops
(srss (format nil "(key ~D ~D)" (char-code #\>) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\<) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\>) 0))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\<) 0))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\a) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\e) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\b) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\p) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\n) 4))
(srss (format nil "(key ~D ~D)" (char-code #\i) 4))
(srss (format nil "(key ~D ~D)" (char-code #\l) 4))
(srss (format nil "(key ~D ~D)" (char-code #\x) 4))
(srss (format nil "(key ~D ~D)" (char-code #\b) 0))
(srss "(set-cursor 1200)")
(srss "(make-region 1000 2000)")
(srss "(cut)")
(srss "(set-cursor 0)")
(srss "(insert-region 0)")
(srss "(undo 2)")
(srss "(redo)")
(srss "(undo)")
(srss "(redo)")
(srss "(undo)")
(srss "(set-syncing 0)")
(srss (format nil "(close-sound ~D)" four-aiff-index))
(srss (format nil "(close-sound ~D)" two-aiff-index))

(setf two-aiff-index (srss (format nil "(open-sound ~S)" two-aiff)))

(print "2")
(srss "(set-syncing)")
(srss "(mix \"pistol.snd\" 100)")
(let ((val (srss "(mix-position 0)"))) (if (/= val 100) (print (format nil "mix is at ~D, not 100?" val))))
(let ((val (srss "(mix-length 0)"))) (if (/= val 41623) (print (format nil "mix len: ~D, not 41623?" val))))
(let ((val (srss "(mix-anchor 0)"))) (if (/= val 0) (print (format nil "mix anchor is at ~D, not 0?" val))))
(let ((val (srss "(mix-speed 0)"))) (if (/= val 1.0) (print (format nil "mix speed is ~F, not 1.0?" val))))
(let ((val (srss "(mix-amp 0 0)"))) (if (/= val 1.0) (print (format nil "mix amp is ~F, not 1.0?" val))))
(let ((val (srss "(mix-groups 0)"))) (if (/= val 0) (print (format nil "mix groups is ~D, not 0?" val))))
(srss "(set-mix-position 0 200)")
(let ((val (srss "(mix-position 0)"))) (if (/= val 200) (print (format nil "mix is at ~D, not 200?" val))))
(srss "(set-mix-speed 0 2.0)")
(let ((val (srss "(mix-speed 0)"))) (if (/= val 2.0) (print (format nil "mix speed is ~F, not 2.0?" val))))
(srss "(set-mix-amp 0 0 .5)")
(let ((val (srss "(mix-amp 0 0)"))) (if (/= val 0.5) (print (format nil "mix amp is ~F, not 0.5?" val))))

(srss "(add-mark 100)")
(srss "(enved-dialog)")
(srss "(color-dialog)")
(srss "(orientation-dialog)")
(srss "(transform-dialog)")
(srss "(file-dialog)")
(srss "(region-dialog)")
(srss "(edit-header-dialog)")
(srss "(record-dialog)")
(srss "(group-dialog)")
(srss "(help-dialog \"Test\" \"snd-test here\")")

(sleep 2)
(in-var-test "recorder-gain" .5 "0")
(in-var-test "recorder-in-amp" .25 "0" "0")
(in-var-test "recorder-out-amp" .8 "1")

(in-var-test "mix-groups" 1 "0")
(in-var-test "group-tempo" .5 "0")
(in-var-test "group-speed" 1.5 "0")
(in-var-test "group-beg" 0 "0")
(in-var-test "group-end" 1000 "0")
(in-var-test "group-amp" .5 "0" "0")

(in-var-test "sample" .5 "0")
(in-var-test "cursor" 2130)
(in-var-test "left-sample" 1000)
(in-var-test "right-sample" 3000)

(srss "(forward-sample)")
(srss "(backward-sample)")
(srss "(forward-graph)")
(srss "(backward-graph)")
(srss "(forward-mark)")
(srss "(backward-mark)")
(srss "(forward-mix)")
(srss "(backward-mix)")
(srss "(regions)")
(srss "(region-length)")
(srss "(region-srate)")
(srss "(region-chans)")
(srss "(region-maxamp)")
(srss "(select-region 2)")
(srss "(protect-region 2 1)")
(srss "(play-region 2)")
(srss "(mix-region)")
(srss "(region-sample)")
(srss "(update-graphs)")
(srss "(update-ffts)")
(srss "(play)")
(srss "(stop)")
(srss "(groups)")
(srss "(group-ok? 0)")
(srss "(scale-to .1)")
(srss "(scale-by 2.0)")
(srss "(normalize-view)")
(srss "(transform-sample)")
(when (= i-loops 0)
  (srss "(add-to-main-menu \"Test\")")
  (srss "(add-to-menu 5 \"Denoise\" \"(report-in-minibuffer \\\"denoise\\\")\")"))

(srss (format nil "(close-sound ~D)" two-aiff-index))

(when (and have-guile (= 0 i-loops))
  (send-snd "(load \"gh-snd-test.scm\")")
  (receive-snd) 
  (setf ob-snd-index (srss (format nil "(open-sound ~S)" ob-snd)))
  (srss "(set-ffting #t)")  
  (srss "(set-x-bounds .1 .2)")
  (srss (format nil "(close-sound ~D)" ob-snd-index))

  )
)
(print "finished normally!!")
