/* X-specific type/macro declarations */

#ifndef SND_X0_H_LOADED
#define SND_X0_H_LOADED

#if defined(HAVE_CONFIG_H)
  #include "config.h"
  #if (!defined(HAVE_X11_KEYSYM_H))
    #error where are the X11 header files?
  #endif
  #if (!defined(HAVE_XM_XMALL_H)) 
    #error where are the Motif header files?
  #endif
#endif
#include <Xm/XmAll.h>
#include <X11/keysym.h>

#define UNSET_TRANSIENT 1
/* unset transient => make most dialog windows act like they're not 
 * inheriting from transientshell -- that is if the dialog is active,
 * let the window manager obscure it with some other Snd window.
 * All the documentation says this is dangerous, so it's on this switch
 */

#if defined(LINUX) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE)
  #define RESIZE_DIALOG 1
  /* these versions of Motif need to be told to allow a dialog to include resize controls */
#else
  #define RESIZE_DIALOG 0
#endif
 
#if defined(LINUX) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE)
  #define MANAGE_DIALOG 1
  /* these versions of Motif need to "manage" a dialog before dealing with its children */
#else
  #define MANAGE_DIALOG 0
#endif

#if defined(LINUX) && (!(defined(LESSTIF_VERSION))) && (!(defined(MKLINUX)))
  #define OVERRIDE_TOGGLE 1
  /* Metrolink Motif (Linux) defines control-button1 to be "take focus" -- this is not a good idea!! */
  /* there are at least 2 versions of Motif available in mkLinux */
#else
  #define OVERRIDE_TOGGLE 0
#endif

#if defined(LESSTIF_VERSION) && defined(MKLINUX)
  #define PANED_WINDOWS_BUGGY 1
#else
  #define PANED_WINDOWS_BUGGY 0
#endif

#if defined(LINUX) || defined(XPM) || defined(HAVE_X11_XPM_H)
  #define HAVE_XPM 1
#else
  #define HAVE_XPM 0
#endif

#if defined(SGI) || defined (LESSTIF_VERSION) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE) || defined(VMS)
  #define HAVE_SELECTED_POSITION_COUNT 0
#else
  #define HAVE_SELECTED_POSITION_COUNT 1
#endif

#if ((XmVERSION >= 2) && (XmREVISION >= 1))
  #define HAVE_PRINT_SHELL 1
#else
  #define HAVE_PRINT_SHELL 0
#endif

#ifdef SGI
  #define CLOSED_CTRLS_HEIGHT 22
  #define OPEN_CTRLS_HEIGHT 185
#else
  #define CLOSED_CTRLS_HEIGHT 18
  #define OPEN_CTRLS_HEIGHT 170
#endif

#define POINT_BUFFER_SIZE 4096
#define GRAY_SCALES 64
#define CORRUPTION_TIME 60
#define WITH_ARROWS 1
#define WITH_FW_BUTTONS 0

#define ACTIVATABLE 1
#define NOT_ACTIVATABLE 0

#ifndef LESSTIF_VERSION
  #define ZOOM_SCROLL_SIZE 10
#else
  #define ZOOM_SCROLL_SIZE 14
#endif

#ifdef SGI
  #define LINE_MARGIN 10
  #define CONTROLS_MARGIN 0
#endif
#ifdef NEXT
  #define LINE_MARGIN 10
  #define CONTROLS_MARGIN 0
#endif

#if defined(LINUX) || defined(SCO5) || defined(UW2) || defined(SOLARIS) || defined(HPUX) || defined(ALPHA) || defined(WINDOZE) || defined(VMS)
  #define LINE_MARGIN 4
  #define CONTROLS_MARGIN 1
  #ifndef LESSTIF_VERSION
    #define TOGGLE_SIZE 13
    #define TOGGLE_MARGIN 0
    #define NEED_TOGGLE_SIZE 1
  #else
    #define NEED_TOGGLE_SIZE 0
  #endif
#else
  #define NEED_TOGGLE_SIZE 0
#endif

#define CHANNEL_SASH_INDENT -10

enum {fdata_form,fdata_sep1,fdata_hlab,fdata_hlist,fdata_dlab,fdata_dlist,
      fdata_slab,fdata_stext,fdata_clab,fdata_ctext,fdata_sep2,fdata_sep3, 
      fdata_comment_label,fdata_comment_text,fdata_out_form,fdata_sep4,
      fdata_loclab,fdata_loctext};
#define FILE_DATA_WIDGETS 18


typedef struct {
  GC gc;
  Display *dp;
  Drawable wn;
  XFontStruct *label_font,*numbers_font;
} axis_context;

typedef struct {
  GC gc;                   /* channel's graphics context */
  GC cgc;                  /* cursor context (XOR mode, maybe red?) */
  GC selgc;                /* selection context (OR mode) */
  GC igc;                  /* erase context (separate from XOR business) */
  Widget chan_widgets[NUM_CHAN_WIDGETS];
  XtWorkProcId fft_in_progress;
  axis_context *ax;        /* for snd-axis.c graphics */
} chan_context;

typedef struct {
  Pixmap speed_r,speed_l;
  GC speed_gc;
  XtWorkProcId env_in_progress;
  XtWorkProcId apply_in_progress;
  void *env_data;
  Widget snd_widgets[NUM_SND_WIDGETS];
} snd_context;

typedef struct {
  XtAppContext mainapp;     
  Widget mainshell;
  Widget mainpane;
  Widget soundpane;
  Display *mdpy;
  XmFontList button_fontlist;
  XFontStruct *button_fontstruct;
  XmFontList bold_button_fontlist;
  XFontStruct *bold_button_fontstruct; 
  XmFontList listener_fontlist;
  XFontStruct *listener_fontstruct;
  XFontStruct *axis_label_fontstruct;
  XFontStruct *axis_numbers_fontstruct;
  XmFontList help_text_fontlist;
  XFontStruct *help_text_fontstruct;
  Pixel zoom,scale,text,main,high,white,black,cursor,gray,mixpix,red,mixhi,yellow,txt;
  XEvent *text_activate_event;
#if UNSET_TRANSIENT
  Widget *dialogs;
  int dialog_list_size,ndialogs;
#endif
} state_context;

typedef struct {
  Widget graph;
  XPoint *p0,*p1;
  int lastpj;
} mix_context;

typedef struct {
  int inuse,chans_allocated,x,y,moving,active,state;
  void *owner;           /* pointer to current mixdata struct that is using this set of widgets */
  Widget *w;
} mixmark;

typedef struct {
  Pixmap off_label;
  Pixmap on_label;
  Pixmap clip_label;
  XFontStruct *label_font;
  float size;
} vu_label;


/* now pull in the key names (/usr/include/X11/keysymdef.h) */
#define snd_K_Shift_L XK_Shift_L	 
#define snd_K_space XK_space 
#define snd_K_exclam XK_exclam 
#define snd_K_quotedbl XK_quotedbl 
#define snd_K_numbersign XK_numbersign 
#define snd_K_dollar XK_dollar 
#define snd_K_percent XK_percent 
#define snd_K_ampersand XK_ampersand 
#define snd_K_openparen XK_parenleft 
#define snd_K_closeparen XK_parenright 
#define snd_K_asterisk XK_asterisk 
#define snd_K_plus XK_plus 
#define snd_K_comma XK_comma 
#define snd_K_minus XK_minus 
#define snd_K_period XK_period 
#define snd_K_slash XK_slash 
#define snd_K_0 XK_0 
#define snd_K_1 XK_1 
#define snd_K_2 XK_2 
#define snd_K_3 XK_3 
#define snd_K_4 XK_4 
#define snd_K_5 XK_5 
#define snd_K_6 XK_6 
#define snd_K_7 XK_7 
#define snd_K_8 XK_8 
#define snd_K_9 XK_9 
#define snd_K_colon XK_colon 
#define snd_K_semicolon XK_semicolon 
#define snd_K_less XK_less 
#define snd_K_equal XK_equal 
#define snd_K_greater XK_greater 
#define snd_K_question XK_question 
#define snd_K_at XK_at 
#define snd_K_A XK_A 
#define snd_K_B XK_B 
#define snd_K_C XK_C 
#define snd_K_D XK_D 
#define snd_K_E XK_E 
#define snd_K_F XK_F 
#define snd_K_G XK_G 
#define snd_K_H XK_H 
#define snd_K_I XK_I 
#define snd_K_J XK_J 
#define snd_K_K XK_K 
#define snd_K_L XK_L 
#define snd_K_M XK_M 
#define snd_K_N XK_N 
#define snd_K_O XK_O 
#define snd_K_P XK_P 
#define snd_K_Q XK_Q 
#define snd_K_R XK_R 
#define snd_K_S XK_S 
#define snd_K_T XK_T 
#define snd_K_U XK_U 
#define snd_K_V XK_V 
#define snd_K_W XK_W 
#define snd_K_X XK_X 
#define snd_K_Y XK_Y 
#define snd_K_Z XK_Z 
#define snd_K_bracketleft XK_bracketleft 
#define snd_K_backslash XK_backslash 
#define snd_K_bracketright XK_bracketright 
#define snd_K_underscore XK_underscore 
#define snd_K_a XK_a 
#define snd_K_b XK_b 
#define snd_K_c XK_c 
#define snd_K_d XK_d 
#define snd_K_e XK_e 
#define snd_K_f XK_f 
#define snd_K_g XK_g 
#define snd_K_h XK_h 
#define snd_K_i XK_i 
#define snd_K_j XK_j 
#define snd_K_k XK_k 
#define snd_K_l XK_l 
#define snd_K_m XK_m 
#define snd_K_n XK_n 
#define snd_K_o XK_o 
#define snd_K_p XK_p 
#define snd_K_q XK_q 
#define snd_K_r XK_r 
#define snd_K_s XK_s 
#define snd_K_t XK_t 
#define snd_K_u XK_u 
#define snd_K_v XK_v 
#define snd_K_w XK_w 
#define snd_K_x XK_x 
#define snd_K_y XK_y 
#define snd_K_z XK_z 
#define snd_K_braceleft XK_braceleft 
#define snd_K_bar XK_bar 
#define snd_K_braceright XK_braceright 
#define snd_K_asciitilde XK_asciitilde 
#define snd_K_Home XK_Home		 
#define snd_K_Left XK_Left		 
#define snd_K_Up XK_Up		 
#define snd_K_Right XK_Right	 
#define snd_K_Down XK_Down		 

#define snd_keypad_PageUp XK_KP_Page_Up
#define snd_keypad_PageDown XK_KP_Page_Down
#define snd_keypad_End XK_KP_End
#define snd_keypad_Insert XK_KP_Insert
#define snd_keypad_Delete XK_KP_Delete
#if !defined(UW2)
#define snd_keypad_Left XK_KP_Left
#define snd_keypad_Up XK_KP_Up
#define snd_keypad_Right XK_KP_Right
#define snd_keypad_Down XK_KP_Down
#endif
#define snd_keypad_Multiply XK_KP_Multiply
#define snd_keypad_Add XK_KP_Add
#define snd_keypad_Subtract XK_KP_Subtract
#define snd_keypad_Divide XK_KP_Divide
#define snd_keypad_Decimal XK_KP_Decimal
#define snd_keypad_Enter XK_KP_Enter

#define snd_keypad_0 XK_KP_0
#define snd_keypad_1 XK_KP_1
#define snd_keypad_2 XK_KP_2
#define snd_keypad_3 XK_KP_3
#define snd_keypad_4 XK_KP_4
#define snd_keypad_5 XK_KP_5
#define snd_keypad_6 XK_KP_6
#define snd_keypad_7 XK_KP_7
#define snd_keypad_8 XK_KP_8
#define snd_keypad_9 XK_KP_9

#define snd_ShiftMask ShiftMask
#define snd_LockMask LockMask
#define snd_ControlMask ControlMask
#define snd_MetaMask Mod1Mask

#endif
