/* X-specific function declarations */

#ifndef SND_X1_H_LOADED
#define SND_X1_H_LOADED

typedef struct {int slice; snd_state *ss; Widget shell; Display *dpy;} task_manager;

axis_context *free_axis_context(axis_context *ax);
GC copy_GC(chan_info *cp);
GC erase_GC(chan_info *cp);

void draw_line (axis_context *ax,int x0,int y0,int x1,int y1);
void fill_rectangle (axis_context *ax,int x0, int y0, int width, int height);
void fill_rectangles (axis_context *ax, XRectangle *rects, int num);
void fill_polygon(axis_context *ax,int points, ...);
void draw_polygon(axis_context *ax,int points, ...);
void draw_string (axis_context *ax, int x0, int y0, char *str, int len);
void draw_lines (axis_context *ax,XPoint *points,int num);
void draw_point (Display *dp, Drawable wn, GC gc, XPoint point, int size);
void draw_points (axis_context *ax,XPoint *points,int num, int size);
void fill_polygons (axis_context *ax,XPoint *points,int num,axis_info *ap);
void fill_two_sided_polygons(axis_context *ax,XPoint *points,XPoint *points1,int num);
void set_number_font(axis_context *ax);
void set_label_font(axis_context *ax);
int label_width(axis_context *ax, char *txt);
int number_width(axis_context *ax, char *num);
int number_height(axis_context *ax);
int label_height(axis_context *ax);

int map_over_children (Widget w, int (*func)(), void *userptr);
int set_main_color_of_widget (Widget w,void *userptr);
void make_button_label(Widget button,char *str);
void make_bold_button_label(Widget button,char *str);
void make_name_label(Widget label,char *str);

void goto_window(Widget text);
void goto_graph(chan_info *cp);
void goto_minibuffer(snd_info *sp);
void text_set_string(Widget txt, char *str);
char *text_get_string(Widget txt);
int get_window_height(Widget w);
int get_window_width(Widget w);

void set_chan_fft_in_progress(chan_info *cp, XtWorkProcId fp);
Widget add_menu(snd_state *state);
Widget get_menubar(void);

int background_zoom_color(Arg *args, int n, snd_state *ss);
int background_scale_color(Arg *args, int n, snd_state *ss);
int background_main_color(Arg *args, int n, snd_state *ss);
int background_high_color(Arg *args, int n, snd_state *ss);
int background_white_color(Arg *args, int n, snd_state *ss);
int background_mixer_color(Arg *args, int n, snd_state *ss);
int background_text_color(Arg *args, int n, snd_state *ss);
int background_txt_color(Arg *args, int n, snd_state *ss);
void high_color(snd_state *ss, Widget w);
void white_color(snd_state *ss, Widget w);

void set_button_font(axis_context *ax, snd_state *ss);

Widget main_SHELL(void *w);
Widget main_PANE(void *w);
Widget sound_PANE(void *w);
Display *main_DISPLAY(void *w);
int main_SCREEN(void *w);
XtAppContext main_APP(void *w);
XmFontList button_FONT(void *w);
XmFontList bold_button_FONT(void *w);
XmFontList help_text_FONT(void *w);
XFontStruct *peak_numbers_FONTSTRUCT(void *w);
XFontStruct *bold_peak_numbers_FONTSTRUCT(void *w);
XFontStruct *axis_label_FONTSTRUCT(void *w);
XFontStruct *axis_numbers_FONTSTRUCT(void *w);

Boolean CreateOpenDialog(Widget w,XtPointer clientData);

Widget snd_widget(snd_info *sp,int w);
Widget chan_widget(chan_info *cp,int w);
void make_graph_cursor(task_manager *tm);

void intern_atoms (snd_state *ss);
void InitializeDrop(snd_state *ss);

axis_context *copy_context (chan_info *cp);
axis_context *selection_context (chan_info *cp);
axis_context *cursor_context (chan_info *cp);

void make_axes(chan_info *cp, axis_info *ap, int x_style);
void set_scrollbar(Widget w,float position,float range, int scrollbar_max);
float get_scrollbar(Widget w,int val, int scrollbar_max);

XtCallbackList make_callback_list(XtCallbackProc callback, XtPointer closure);

void add_channel_window(snd_info *sound, int channel, snd_state *ss, int chan_y, int insertion, Widget main, int arrows);

void StartMarkWatch(chan_info *cp);
void CancelMarkWatch(void);

void clear_window(axis_context *ax);

void set_color(axis_context *ax, Pixel color);
void reset_color(chan_info *cp);
void StartSelectionWatch(chan_info *cp);
void CancelSelectionWatch(void);

Time main_TIME(snd_state *ss);


/* these are currently implemented in X-specific files */

void snd_printf(void *ss,char *msg);
int chan_fft_in_progress(chan_info *cp);
int calculate_fft(chan_info *cp, void *ptr);
void create_popup_menu(snd_state *ss);
void reflect_file_open_in_menu (void);
void reflect_file_change_in_menu (void);
void reflect_file_lack_in_menu (void);
void reflect_file_revert_in_menu (snd_state *ss);
void reflect_file_save_in_menu (snd_state *ss);
void reflect_edit_with_selection_in_menu (void);
void reflect_edit_without_selection_in_menu (void);
void reflect_undo_in_menu(void);
void reflect_undo_ok_in_menu(void);
void reflect_redo_in_menu(void);
void reflect_no_more_redo_in_menu(void);
void reflect_undo_or_redo_in_menu(chan_info *cp);
void reflect_regions_in_menu(void);
void reflect_no_regions_in_menu(void);
void reflect_raw_open_in_menu(void);
void reflect_raw_pending_in_menu(void);
int mark_name_width(snd_state *ss, char *txt);
int sound_unlock_ctrls(snd_info *sp, void *ptr);
int sound_lock_ctrls(snd_info *sp, void *ptr);
void snd_info_cleanup(snd_info *sp);
void chan_info_cleanup(chan_info *cp);
int channel_unlock_pane(chan_info *cp, void *ptr);
int channel_lock_pane(chan_info *cp, void *ptr);
void add_chan_callbacks(chan_info *cp);
void set_title(snd_state *ss, char *title);
void unlock_ctrls(snd_info *sp);
void snd_doit(snd_state *state,int argc, char **argv);

void set_peak_numbers_font(chan_info *cp);
void set_bold_peak_numbers_font(chan_info *cp);

void set_graph_style(snd_state *ss, int val);
void set_show_marks(snd_state *ss, int val);
void set_show_y_zero(snd_state *ss, int val);
void set_subsampling(snd_state *ss, int val);

void set_show_fft_peaks(snd_state *ss, int val);
void set_fft_log_magnitude(snd_state *ss, int val);
void set_fft_log_frequency(snd_state *ss, int val);
void set_fft_beta(snd_state *ss, float val);
void set_fft_style(snd_state *ss, int val);
void set_fft_size(snd_state *ss, int val);
void set_fft_window(snd_state *ss, int val);
void set_transform_type(snd_state *ss, int val);
void set_normalize_fft(snd_state *ss, int val);
void set_wavelet_type(snd_state *ss, int val);

void set_color_scale(snd_state *ss, float val);
void set_color_inverted(snd_state *ss, int val);
void set_color_cutoff(snd_state *ss, float val);
void set_spectro_color(snd_state *ss, int val);
void set_spectro_hop(snd_state *ss, int val);
void set_spectro_x_angle(snd_state *ss, float val);
void set_spectro_y_angle(snd_state *ss, float val);
void set_spectro_z_angle(snd_state *ss, float val);
void set_spectro_x_scale(snd_state *ss, float val);
void set_spectro_y_scale(snd_state *ss, float val);
void set_spectro_z_scale(snd_state *ss, float val);
void set_spectro_cutoff(snd_state *ss, float val);

void set_channel_style(snd_state *ss, int val);

void fftb(chan_info *cp, int on);
void waveb(chan_info *cp, int on);
void syncb(snd_info *sp, int on);
int CLM_connect(snd_state *ss);
void CLM_disconnect(snd_state *ss);

void erase_graph_border(chan_info *cp);
void display_graph_border(chan_info *cp);

void remove_amp_env(snd_info *sp);
void signal_amp_env_done(snd_info *sp);
void remove_apply(snd_info *sp);

void set_grf_points(int xi, int j, int ymin, int ymax);
void set_grf_point(int xi, int j, int yi);
void allocate_grf_points(void);
void draw_grf_points(snd_state *ss,chan_info *cp, int j, axis_info *ap);
void draw_both_grf_points(snd_state *ss,chan_info *cp, int j);
void draw_both_grfs(axis_context *ax, int j);

void toggle_expand_button(snd_info *sp, int state);
void toggle_contrast_button(snd_info *sp, int state);
void toggle_reverb_button(snd_info *sp, int state);
void toggle_filter_button(snd_info *sp, int state);
void toggle_direction_arrow(snd_info *sp, int state);
void toggle_just_sounds(int n);

int snd_window_width(snd_state *ss);
int snd_window_height(snd_state *ss);
void set_snd_window_width(snd_state *ss,int width);
void set_snd_window_height(snd_state *ss,int height);

void show_controls(snd_state *ss);
void hide_controls(snd_state *ss);
void sound_show_ctrls(snd_info *sp);
void sound_hide_ctrls(snd_info *sp);
void set_view_ctrls_label(char *lab);
void set_view_listener_label(char *lab);
void handle_listener(snd_state *ss);
void reflect_play_region_stop(region_info *r);
int region_browser_is_active(void);
void update_region_browser(int grf_too);
void set_play_button(snd_info *sp, int val);

void allocate_sono_rects(snd_state *ss, int size);
void set_sono_rectangle(int j, int color, int x, int y, int width, int height);
void draw_sono_rectangles(chan_info *cp, int color, int jmax);

void reflect_play_stop (snd_info *sp);
void set_play_in_progress (snd_state *ss, dac_manager *dac_m);

void snd_amp_changed(snd_info *sp, int val);
void snd_srate_changed(snd_info *sp, int val);
void snd_expand_changed(snd_info *sp, int val);
void snd_contrast_changed(snd_info *sp, int val);
void snd_revscl_changed(snd_info *sp, int val);
void snd_revlen_changed(snd_info *sp, int val);

int get_raw_value(Widget w);
int get_raw_size(Widget w);
int set_raw_value(Widget w, int val);
void alert_new_file(void);

void call_replay_amp(snd_state *ss, XtPointer ap,int time);
void call_replay_speed(snd_state *ss, XtPointer ap,int time);
void call_replay_contrast(snd_state *ss, XtPointer ap,int time);
void call_replay_expand(snd_state *ss, XtPointer ap,int time);
void call_replay_reverb(snd_state *ss, XtPointer ap,int time);
void call_replay_direction(snd_state *ss, XtPointer ap,int time);
void start_amp_env(snd_info *sp, int anew);
void set_apply_button(snd_info *sp, int val);

void lock_apply(snd_state *ss, snd_info *sp);
void lock_play_and_record(snd_state *ss, snd_info *sp);
void unlock_apply(snd_state *ss,snd_info *sp);
void unlock_play_and_record(snd_state *ss,snd_info *sp);
void set_verbose_cursor(snd_state *ss,int val);
file_info *get_file_info(char *filename, snd_state *ss);
file_info *get_reasonable_file_info(char *filename, snd_state *ss, file_info *hdr);

int snd_yes_or_no_p(snd_state *ss,char *question);

void normalize_sound(snd_state *ss, snd_info *sp, snd_info *osp, chan_info *ncp);
void set_normalize_option(int on);

void combine_sound(snd_info *sp);
void separate_sound(snd_info *sp);
void superimpose_sound(snd_info *sp);
void combineb(snd_info *sp, int val);

void draw_spectro_line(chan_info *cp, int color, int x0, int y0, int x1, int y1);
void allocate_color_map(snd_state *ss, int colormap);

void reflect_spectro(snd_state *ss);
void remember_me(snd_state *ss, char *shortname, char *fullname);
void greet_me(snd_state *ss, char *shortname);
void make_a_big_star_outa_me(snd_state *ss, char *shortname, int big_star);
void highlight_selected_sound(snd_state *ss);
void set_file_browser_play_button(char *name, int state);
void get_current_color(int colormap, int j, int *r, int *g, int *b);
void add_directory_to_prevlist(snd_state *ss, char *dirname);
void save_prevlist(FILE *fd);
void start_color_dialog(snd_state *ss, int width, int height);
void start_orientation_dialog(snd_state *ss, int width, int height);
void start_file_dialog(snd_state *ss, int width, int height);
void start_clm_dialog(snd_state *ss, char *msg, char *help);
void cleanup_clm_dialog(snd_state *ss);

void set_show_mix_consoles(snd_state *ss,int on);

void textfield_focus_Callback(Widget w,XtPointer clientData,XtPointer callData);
void textfield_unfocus_Callback(Widget w,XtPointer clientData,XtPointer callData);
Widget sndCreateTextFieldWidget(snd_state *ss, char *name, Widget parent, Arg *args, int n, int activatable);
Widget sndCreateTextWidget(snd_state *ss, char *name, Widget parent, Arg *args, int n);

void graph_key_press(Widget w,XtPointer clientData,XEvent *event,Boolean *cont);

void activate_speed_in_menu(snd_state *ss, int newval);
void activate_focus_menu(snd_state *ss, int new_focus);
void release_mixmark_widgets(mixmark *m);
mix_context *set_mixdata_context(chan_info *cp);
void move_mixmark(mixmark *m, int x, int y);
void use_mixmark(mixdata *md, int x, int y);
void initialize_mix(snd_state *ss);

void erase_and_draw_grf_points(snd_state *ss,mix_context *ms,chan_info *cp, int j);
void erase_and_draw_both_grf_points(snd_state *ss,mix_context *ms,chan_info *cp, int j);

int mix_dragging(void);
void fixup_mixmark(mixdata *md);
void fire_up_group_browser(snd_state *ss);
XPoint *points_address(int which);
void mix_save_graph(snd_state *ss, mix_context *ms,int j);

void set_mixer_location(mixmark *m, int nx);
void respeed(mixdata *md, float spd);
void reamp(mixdata *md, int chan, float amp);
void set_mix_title_beg(mixdata *md, mixmark *m);
int channel_open_pane(chan_info *cp, void *ptr);
void toggle_group(mixdata *md, int on, int button);
void raise_dialog(Widget w);
void raise_widget(Widget w);
void move_mix_x(mixmark *m, int xspot);
void stop_group_play(snd_info *sp);
void reflect_mixer_amp(mixdata *md);

void draw_mix_duration_bracket(mixdata *md, int xspot, int yspot);
void erase_mix_duration_bracket(mixdata *md, int xspot, int yspot);
void remake_group_browser_label(void);
int gb_is_active(void);
void set_mix_speed(mixdata *md, console_state *cs);
void remake_group_amp_labels(snd_state *ss);
void reflect_group_size_in_scales(snd_state *ss, grp_info *g);
void update_group_browser(snd_state *ss);
snd_info *snd_new_file(snd_state *ss,char *newname);
void snd_record_file(snd_state *ss);

void reflect_group_amp_row_change(snd_state *ss, grp_info *g, int row);
void reflect_group_speed_change(snd_state *ss, grp_info *g, float speed);
void reflect_group_tempo_change(grp_info *g, float speed);

#ifdef LINUX
  void override_toggle_translation(Widget w);
#endif

int color_sashes(Widget w, void *ptr);
void read_file_data_choices(Widget stext, Widget ctext, Widget hlist, Widget dlist, int *srate, int *chans, int *type, int *format);
void load_header_and_data_lists(Widget hlist, Widget dlist, int type, int format, int *hpos, int *dpos);
Widget *sndCreateFileDataForm(snd_state *ss, Widget parent, char *name, Arg *args, int n, int with_chan, int with_comment, int header_type, int data_format, int with_loc);
float read_record_state(int which, int vali, int valj);
void write_record_state(int which, int vali, int valj, float valf);
void cleanup_recording (void);
Pixmap make_pixmap(snd_state *ss, unsigned char *bits, int width, int height, int depth, GC gc);
void lock_recording_audio(void);
void unlock_recording_audio(void);
void snd_file_lock_icon(snd_info *sp, int on);
void snd_file_bomb_icon(snd_info *sp, int on);
int record_in_progress(void);
#if UNSET_TRANSIENT
  void add_dialog(snd_state *ss, Widget dialog);
#endif

void alert_envelope_editor(snd_state *ss, char *name, env *val);
void new_active_channel_alert(snd_state *ss);
void alert_enved_amp_env(snd_info *sp);
void save_envelope_editor_state(snd_state *ss, FILE *fd);
void enved_print(snd_state *ss, char *name);
void env_redisplay(snd_state *ss);

void File_Print_Callback(Widget w,XtPointer clientData,XtPointer callData);

void reflect_resize(snd_state *ss);
void display_enved_progress(snd_state *ss,char *str);
void check_for_event(snd_state *ss);

void save_window_size(snd_state *ss);
void restore_window_size(snd_state *ss);
void fire_up_transform_dialog(snd_state *ss);
void edit_header(snd_info *sp);

void snd_open_file_dialog(Widget w, snd_state *ss);
void snd_save_as_dialog(Widget w, snd_state *ss);
void snd_edit_save_as_dialog(Widget w, snd_state *ss);

void View_Files_Callback(Widget w,XtPointer clientData,XtPointer callData);
void View_Region_Callback(Widget w,XtPointer clientData,XtPointer callData);
void View_Orientation_Callback(Widget w,XtPointer clientData,XtPointer callData);
void View_Color_Callback(Widget w,XtPointer clientData,XtPointer callData);
void File_Mix_Callback(Widget w,XtPointer clientData,XtPointer callData);
void Edit_Find_Callback(Widget w,XtPointer clientData,XtPointer callData);
void Options_Session_Callback(Widget w,XtPointer clientData,XtPointer callData);
void snd_append_command(snd_state *ss, char *msg);
int control_panel_open(snd_info *sp);
void goto_listener(void);
void snd_append_char(snd_state *ss, char *msg);

#if HAVE_GUILE
void g_initialize_gh(snd_state *ss);
#endif

void set_window_y(snd_state *ss, int y);
void set_window_x(snd_state *ss, int x);
int add_to_main_menu(snd_state *ss, char *label);
void add_to_menu(snd_state *ss, int which_menu, char *label, int callb);
int remove_from_menu(snd_state *ss, int which_menu, char *label);

void set_enved_clipping(snd_state *ss, int val);
void set_enved_exping(snd_state *ss, int val);
void set_enved_base(snd_state *ss,float val);
void set_enved_target(snd_state *ss, int val);
void set_enved_waving(snd_state *ss, int val);
void delete_region_and_update_browser(snd_state *ss, int n);
void select_region_and_update_browser(snd_state *ss, int n);
int lisp_listener_height(void);
void set_region_protect(int reg, int protect);
void filter_order_changed(snd_info *sp, int order);
void filter_env_changed(snd_info *sp, env *e);
void set_listener_width(int width);
void set_autoload(snd_state *ss, int val);
int set_env_base(char *name, float val);

void edit_history(snd_state *ss, int on);
int open_edit_histories(chan_info *cp, void *ptr);
int close_edit_histories(chan_info *cp, void *ptr);
void reflect_edit_history_change(chan_info *cp);
void reflect_edit_counter_change(chan_info *cp);
int set_edit_history_width(snd_state *ss, int width);

int transform_dialog_is_active(void);
int enved_dialog_is_active(void);
int color_dialog_is_active(void);
int orientation_dialog_is_active(void);
int file_dialog_is_active(void);
int region_dialog_is_active(void);
int record_dialog_is_active(void);
int group_dialog_is_active(void);

int change_menu_label(int which_menu,char *old_label, char *new_label);
int set_menu_sensitive(int which_menu,char *old_label, int on);

#endif
