#include "snd.h"

/* X side of file print */

static Widget file_print_dialog = NULL;
static Widget file_print_name = NULL;
static Widget file_print_eps_or_lpr = NULL;
static char print_string[256];

static void file_print_help_callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   "File Print",
"Print causes the currently active display to be\n\
either printed (via the lpr command) or saved as\n\
an eps file.  In the latter case, the file name\n\
is set either by the dialog, or taken from the\n\
resource epsFile (normally snd.eps).\n\
");
}

static void file_print_cancel_callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_state *ss = (snd_state *)clientData;
  ss->print_choice = PRINT_SND;
  XtUnmanageChild(file_print_dialog);
}

static int lpr (char *name)
{
  /* make some desultory effort to print the file */
  sprintf(print_string,"lpr %s",name);
  return(system(print_string));
}

#if 0
/* Xp X extension */
static void ignore_this (Widget print_dialog)
{
  int n;
  Arg args[12];
  if (print_dialog == NULL)
    {
      {
	int event_base,error_base;
	if (!(XpQueryExtension (XtDisplay(draw),&event_base,&error_base))) fprintf(stderr,"no print extension");
      }
      n=0;
      {
	int i,num; 
	char **exts;
	exts=XListExtensions(XtDisplay(toplevel),&num);
	if ((exts) && (num>0))
	  {
	    for (i=0;i<num;i++) fprintf(stderr,"%s\n",exts[i]);
	  }
      }
      print_dialog = XmPrintSetup(toplevel,XtScreen(toplevel),"Print",args,n);
      XpStartJob(XtDisplay(print_dialog),XPSpool);
      XpStartPage(XtDisplay(print_dialog),XtWindow(print_dialog));
      /* XpStartDoc(*dpy,type: XPDocNormal XPDocRaw */
      XmRedisplayWidget(draw);
      /* entire sound pane here? or just drawingarea graphs? */
      XpEndPage(XtDisplay(print_dialog)); /* ?? */
      XpEndJob(XtDisplay(print_dialog));
      /* callback DtPrintSetupCallbackStruct *p
	 can provide printer name
	 XmNstartJobCallback -- when safe to begin rendering (triggered by XpStartJob)
	 XmNendJobCallback -- render done
	 XmNpageSetupCallback -- can be used instead of start callback (it drives the layout)
	 XmMinX|Y XmNmaxX|Y -- specify bounding box in current context
	 XmNdefaultPixmapResolution (100 def) (dpi)
	 XmNpdmNotificationCallback -- status callback from PDM:
	   XmCR_PDM_NONE: no printer
	   XmCR_PDM_START_VXAUTH: video connection not authorized
	   XmCR_PDM_START_PXAUTH: print connection not authorized
	   XmCR_PDM_UP: running
	   XmCR_PDM_OK: all done happily
	   XmCR_PDM_CANCEL: exited with cancel
	   XmCR_PDM_START_ERROR: cannot start (logged by printer daemon)
	   XmCR_PDM_EXIT_ERROR: exited with error callback info
	     XmPrintShellCallbackStruct
	       int reason
	       XEvent *event
	       XPContext print_context
	       Boolean last_page (only for page setup -- set to true to indicate done)
	       XtPointer detail
	       the PDM_Popup shell can be used to handle notification callbacks
      */
    }
}
#endif

static int printing = 0;

static void file_print_ok_callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_state *ss = (snd_state *)clientData;
  int print_it,quit = 0;
  char *name;
  XmString plab,slab;
  snd_info *nsp;
  if (printing) 
    ss->stopped_explicitly = 1;
  else
    {
      if (ss->print_choice == PRINT_SND)
	{
	  plab = XmStringCreateLocalized(snd_string_Stop);
	  nsp = any_selected_sound(ss);
	  sprintf(print_string,snd_string_printing,nsp->shortname);
	  slab = XmStringCreateLocalized(print_string);
	  XtVaSetValues(file_print_dialog,XmNokLabelString,plab,XmNmessageString,slab,NULL);
	  XmStringFree(plab);
	  XmStringFree(slab);
	}
      printing = 1;
      finish_keyboard_selection();
      print_it = XmToggleButtonGetState(file_print_eps_or_lpr);
      quit = (ss->print_choice == PRINT_ENV);
      if (print_it)
	{
	  name = snd_tempnam(temp_dir(ss),"snd_");
	  switch (ss->print_choice)
	    {
	    case PRINT_SND: snd_print(ss,name,1); break;
	    case PRINT_ENV: enved_print(ss,name); break;
	    }
	  lpr(name);
	  remove(name);
	}
      else 
	{
	  switch (ss->print_choice)
	    {
	    case PRINT_SND: snd_print(ss,XmTextGetString(file_print_name),1); break;
	    case PRINT_ENV: enved_print(ss,XmTextGetString(file_print_name)); break;
	    }
	}
    }
  printing = 0;
  if (ss->print_choice == PRINT_SND)
    {
      plab = XmStringCreateLocalized(snd_string_Print);
      sprintf(print_string,snd_string_print_f,nsp->shortname);
      slab = XmStringCreateLocalized(print_string);
      XtVaSetValues(file_print_dialog,XmNokLabelString,plab,XmNmessageString,slab,NULL);
      XmStringFree(plab);
      XmStringFree(slab);
    }
  ss->print_choice = PRINT_SND;
  if (quit) XtUnmanageChild(file_print_dialog);
}

void File_Print_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  Arg args[20];
  int n;
  Widget dl,rc;
  XmString xmstr1,xmstr2,xmstr3,xmstr4,titlestr;
  snd_info *nsp;
  snd_state *ss = (snd_state *)clientData;
  if (ss->print_choice == PRINT_SND)
    {
      nsp = any_selected_sound(ss);
      sprintf(print_string,snd_string_print_f,nsp->shortname);
      xmstr4 = XmStringCreateLocalized(print_string);
    }
  else xmstr4 = XmStringCreateLocalized(snd_string_print_env);

  if (!file_print_dialog)
    {
      n=0;
      if (!(ss->using_schemes)) n = background_main_color(args,n,ss);
      xmstr1=XmStringCreateLocalized(snd_string_Print);  /* "ok" here is confusing -- might mean, ok I'm done */
      xmstr2=XmStringCreateLocalized(snd_string_Help);
      xmstr3=XmStringCreateLocalized(snd_string_Dismiss);
      titlestr = XmStringCreateLocalized(snd_string_Print);

      XtSetArg(args[n],XmNmessageString,xmstr4); n++;
      XtSetArg(args[n],XmNokLabelString,xmstr1); n++;
      XtSetArg(args[n],XmNhelpLabelString,xmstr2); n++;
      XtSetArg(args[n],XmNcancelLabelString,xmstr3); n++;
      XtSetArg(args[n],XmNautoUnmanage,FALSE); n++;
      XtSetArg(args[n],XmNdialogTitle,titlestr); n++;
#if RESIZE_DIALOG
      XtSetArg(args[n],XmNresizePolicy,XmRESIZE_GROW); n++;
      XtSetArg(args[n],XmNnoResize,FALSE); n++;
#endif
      file_print_dialog = XmCreateMessageDialog(w,snd_string_eps_file_p,args,n);
      XmStringFree(xmstr1);
      XmStringFree(xmstr2);
      XmStringFree(xmstr3);
      XmStringFree(xmstr4);
      XmStringFree(titlestr);
      XtUnmanageChild(XmMessageBoxGetChild(file_print_dialog,XmDIALOG_SYMBOL_LABEL));
      XtAddCallback(file_print_dialog,XmNhelpCallback,file_print_help_callback,ss);
      XtAddCallback(file_print_dialog,XmNcancelCallback,file_print_cancel_callback,ss);
      XtAddCallback(file_print_dialog,XmNokCallback,file_print_ok_callback,ss);

      rc = XtCreateManagedWidget("form",xmFormWidgetClass,file_print_dialog,NULL,0);

      n=0;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      dl = XtCreateManagedWidget(snd_string_eps_file_p,xmLabelWidgetClass,rc,args,n);

      n=0;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,dl); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNvalue,eps_file(ss)); n++;
      file_print_name = sndCreateTextFieldWidget(ss,"text",rc,args,n,NOT_ACTIVATABLE);

      n=0;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,file_print_name); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      file_print_eps_or_lpr = XtCreateManagedWidget(snd_string_direct_to_printer,xmToggleButtonWidgetClass,rc,args,n);
#if OVERRIDE_TOGGLE
      override_toggle_translation(file_print_eps_or_lpr);
#endif

#if MANAGE_DIALOG
      XtManageChild(file_print_dialog);
#endif

      if (!(ss->using_schemes))	
	{
	  map_over_children(file_print_dialog,set_main_color_of_widget,(void *)clientData);
	  XtVaSetValues(XmMessageBoxGetChild(file_print_dialog,XmDIALOG_OK_BUTTON),XmNarmColor,(ss->sgx)->text,NULL);
	  XtVaSetValues(XmMessageBoxGetChild(file_print_dialog,XmDIALOG_CANCEL_BUTTON),XmNarmColor,(ss->sgx)->text,NULL);
	  XtVaSetValues(XmMessageBoxGetChild(file_print_dialog,XmDIALOG_HELP_BUTTON),XmNarmColor,(ss->sgx)->text,NULL);
	  XtVaSetValues(file_print_eps_or_lpr,XmNselectColor,(ss->sgx)->text,NULL);
	}
    }
  else
    {
      XtVaSetValues(file_print_dialog,XmNmessageString,xmstr4,NULL);
      XmStringFree(xmstr4);
      raise_dialog(file_print_dialog);
    }
  if (!XtIsManaged(file_print_dialog)) XtManageChild(file_print_dialog);
}
