/* Sound display/edit/etc
 *
 * a re-implementation in summer 1996 of my much-missed dpysnd -- the Foonly/SAIL/E/Mus10/Grnlib sound editor from ca 1983.
 * with much help from Douglas Young's "The X Window System, Programming and Applications with Xt" Prentice-Hall 1994.
 *
 * Snd code is split between the sound editor proper (every file without an 'x' in the name),
 * and anything that is specific to X/Motif.  To port to another window system, it should be 
 * sufficient to reimplement whatever is in snd-x*.h, and approximate the user interface in 
 * snd-x*.c.  Except for tempnam, the DAC stuff in snd-dac, and open/read (I like unbuffered IO), 
 * all the code is (or is thought to be) straight ANSI C.
 */

#include "snd.h"

#ifdef SGI
  #include <sys/fpu.h>
#endif

#if defined(BEOS)
  int snd_main(int argc, char **argv)
#else
  #if HAVE_GUILE
    static void snd_main(int argc, char **argv)
  #else
    int main (int argc, char **argv)
  #endif
#endif
{
  snd_state *state;                      /* global state info, carried around via callData arg in callbacks */
  /* there are also 2 global variables -- 
   *    snd_IO_error which parallels C's errno, 
   *    snd_search_fd which provides global access to the current active data.
   */
#ifdef SGI
  union fpc_csr f; f.fc_word = get_fpc_csr(); f.fc_struct.flush = 1; set_fpc_csr(f.fc_word);
#endif
  initialize_sndlib();
  init_regions();

  state=(snd_state *)calloc(1,sizeof(snd_state));
  state->s_type = make_snd_pointer_type(SND_STATE);
#ifdef _DEBUG_MALLOC_INC
  {unsigned long size; malloc_size(&size); state->orig_size = size;}
#endif

  init_fft_size(state,256);
  init_fft_window(state,default_fft_window(NULL));
  init_fft_beta(state,0.0);
  init_fft_style(state,NORMAL_FFT);
  init_sinc_width(state,10);
  init_speed_tones(state,12);
  init_window_width(state,0);
  init_window_height(state,0);
  init_window_x(state,-1); /* -1 -> let WM choose */
  init_window_y(state,-1);
  init_default_amp(state,1.0);
  init_default_contrast(state,0.0);
  init_default_contrasting(state,0);
  init_default_contrast_amp(state,1.0);
  init_default_expand_length(state,.15);
  init_default_expand_ramp(state,.4);
  init_default_expand_hop(state,.05);
  init_default_reverb_feedback(state,1.09);
  init_default_reverb_lowpass(state,0.7);
  init_default_expand(state,1.0);
  init_default_expanding(state,0);
  init_default_speed(state,1.0);
  init_default_reverbing(state,0);
  init_default_filtering(state,0);
  init_default_reverb_scale(state,0.0);
  init_default_reverb_length(state,1.0);
  init_default_filter_order(state,2);
  init_reverb_decay(state,1.0); 
  init_default_output_type(state,DEFAULT_OUTPUT_TYPE);
  init_initial_x0(state,0.0);
  init_initial_x1(state,0.1);
  init_initial_y0(state,-1.0);
  init_initial_y1(state,1.0);
  init_xmax(state,0.0);
  init_xmin(state,0.0);
  init_ymax(state,1.0);
  init_ymin(state,-1.0);
  init_normalize_on_open(state,1);
  init_auto_resize(state,1); 
  init_color_cutoff(state,.003);
  init_color_scale(state,1.0);
  init_color_inverted(state,1);
  init_zero_pad(state,0);
  init_line_size(state,128);
  init_ask_before_overwrite(state,0);
  init_x_axis_style(state,X_IN_SECONDS);
  init_wavo(state,0);
  init_wavo_hop(state,3);
  init_wavo_trace(state,64);
  init_spectro_hop(state,4);
  init_spectro_x_scale(state,1.0);
  init_spectro_y_scale(state,1.0);
  init_spectro_z_scale(state,0.1);
  init_spectro_z_angle(state,-2.0);
  init_spectro_x_angle(state,90.0);
  init_spectro_y_angle(state,0.0);
  init_spectro_color(state,-1);
  init_spectro_cutoff(state,1.0);
  init_wavelet_type(state,0);
  init_transform_type(state,FOURIER);
  init_dot_size(state,1);
  init_vu_size(state,1.0);
  init_vu_font_size(state,1.0);
  init_vu_font(state,NULL);
  init_speed_style(state,SPEED_AS_FLOAT);
  init_movies(state,1);
  init_normalize_fft(state,1);
  init_mix_duration_brackets(state,0);
  init_fit_data_on_open(state,-1);
  init_zoom_focus_style(state,FOCUS_ACTIVE);
  init_save_state_on_exit(state,0);
  init_graph_style(state,GRAPH_LINES);
  init_filter_env_order(state,40);
  init_mixer_groups(state,6);
  init_mixer_group_max_out_chans(state,4);
  init_verbose_cursor(state,0);
  init_temp_dir(state,NULL);
  init_eps_file(state,NULL);
  init_show_fft_peaks(state,0);
  init_show_y_zero(state,0);
  init_show_marks(state,1);
  init_show_edit_history(state,0);
  init_edit_history_width(state,0);
  init_subsampling(state,1);
  init_fft_log_magnitude(state,0);
  init_fft_log_frequency(state,0);
  init_channel_style(state,CHANNELS_SEPARATE);
  init_sound_style(state,SOUNDS_VERTICAL);
  init_raw_srate(state,44100);
  init_raw_chans(state,1);
  init_raw_format(state,snd_16_linear);
  init_raw_type(state,NeXT_sound_file);
  init_use_raw_defaults(state,0);
  init_print_length(state,12);
  init_show_mix_consoles(state,1);
  init_recorder_autoload(state,0);
  init_recorder_buffer_size(state,4096);
  init_recorder_out_chans(state,2);
  init_recorder_out_format(state,COMPATIBLE_FORMAT);
  init_recorder_in_format(state,COMPATIBLE_FORMAT);
  init_recorder_srate(state,22050);
  init_recorder_file(state,NULL);
  init_session_file(state,NULL);
  init_enved_base(state,1.0);
  init_enved_waving(state,0);
  init_enved_clipping(state,0);
  init_enved_exping(state,0);
  init_enved_target(state,AMPLITUDE_ENV);
  init_prefix_arg(state,0);

  state->viewing = 0;
  state->max_sounds = 4;                 /* expands to accomodate any number of files */
  state->stopped_explicitly = 0;
  state->selected_sound = NO_SELECTION;
  state->from_clm = 0;
  state->to_clm = 0;
  state->mx_sp = NULL;
  state->sounds = (snd_info **)calloc(state->max_sounds,sizeof(snd_info *));
  state->print_choice = PRINT_SND;
  state->pending_open = NULL;
  state->listening = 0;
  state->open_hook_active = 0;
  state->close_hook_active = 0;
  state->fft_hook_active = 0;
  state->graph_hook_active = 0;
  state->exit_hook_active = 0;
  state->start_hook_active = 0;


  snd_IO_error = snd_no_error;

#if HAVE_GUILE
  g_initialize_gh(state);
#endif

  snd_doit(state,argc,argv);

#if (!HAVE_GUILE)
  return(0);
#endif
}

#if HAVE_GUILE     
  int main(int argc, char *argv[])
   {
     gh_enter(argc,argv,snd_main);
     return(0);
   }
#endif

/* snd change log

   23-Sep:   clm/Snd interface changes.
   21-Sep:   asf headers.
   16-Sep:   added set-oss-buffers and various lisp graph mouse/key hooks.
   14-Sep:   added y0 and y1 args to graph (Lisp function).  XmHTML support.
   9-Sept:   mklinux/lesstif kludges (rowcolumn until panedwindow fixed).  control-click 'f' or 'w' buttons affects all chans.
   7-Sept:   save-state implemented. global-unset-key. change-menu-label.  set-menu-sensitive.
   3-Sept:   snd-2-1.rpm. save-edit-history added.
   1-Sept:   global-set-key (re)implemented.  Edit history feature added.
   27-Aug:   removed old clipboard support (never worked right).
   25-Aug:   added remove-from-menu for Buffers in examp.scm, plugged some memory leaks. removed -remote switch (linux bugs).
   24-Aug:   envelope editor minor bugfixes.
   18-Aug:   changed snd/clm fifo names to try to use current home directory.
   17-Aug:   better text handling in lisp listener (action procs), listenerFont, snd-env/clm-env.
   14-Aug:   horizontal-pane normalization, control panel expand typo.
   10-Aug:   snd-2-0.rpm. Guile added (snd-gh.c).  Many non-backwards-compatible changes to snd-clm (M-x) interface.
             Snd compiles in Hummingbird Exceed X/Motif in Windows 95; does not yet load however.
	     .marks and .explode clm/snd files now omit the intermediate extension (due to linux-msdos bug).
	     Lisp listener window added below control panel.
	     removed support for backup file (.snd-backup), all "ufun" stuff, and the escape to CLM (M-X with-sound).
             Added graph-filled options (to View Graph style menu).
   2-July:   c-q multi-channel and edit header bugfixes.
   30-June:  better symlink handling. Transform dialog replaces 5 or 6 menu items (snd-xfft.c).
             fft beta now handled differently. View Info menu moved to Edit: Edit Header.
	     New -h flag to Snd: position sounds horizontally, not vertically (vertical paned window).
   25-June:  DEC Alpha port.
   24-June:  exponential and step envelopes. Sun-related bugfixes and HPUX port thanks to Seppo Ingalsuo.
             control-panel related variables have new (longer) names: explen becomes expand-length
	     and so on -- all panel settings now have parallel defaults settable via .snd or
	     M-X: default-expand-length, etc.
   12-June:  snd-1-4.rpm (for glibc). added recorder-buffer-size variable.  Recorder can read multiple card inputs in Linux.
   8-June:   log freq sonogram drawing bug fixed (low components didn't fill their bin completely).
   2-June:   print interruptible, some recorder bugs fixed. Multi-card support in linux (quad via 2 soundcards).
   27-May:   more elaborate checks for write-permission problems.
   28-Apr:   malloc error checks. group_max_out_chans now a variable (for n-channel mixes).
   13-Apr:   added amps to show-peaks in fft.
   30-Mar:   snd-1-3.rpm
   26-Mar:   sndplay, sndinfo, audinfo, various autoconf configuration files added.
   23-Mar:   sound.c, sndlib.h, sndlib.html added, cmus_prototypes.h, sound_types.h removed.
   20-Mar:   apply in control panel now clears the panel.
   19-Mar:   click or drag fft to get description.
   10-Mar:   8-channel ADAT support; audio.c. Fixed major bug in multi-channel scale-by and several selection-related problems.
   12-Feb:   3 more header formats; Most C-x C-x built-in vars removed; override-data-location and override-sound-format.
   5-Feb:    8 more header formats; show-marks is now the default.
   28-Jan:   Oki adpcm and snd-trans.c little-endian cases.
   23-Jan:   empty (or new file) file bugs fixed.
   21-Jan:   Transform type option menu with wavelet choice window.
   19-Jan:   src in env editor and M-X (src-width, src-style). find and expr interruptible.
   12-Jan:   autoResize resource.  minor file update with fft bug fixed. 
   8-Jan:    snd-1-2.rpm. various env vars to customize envelope editor. Print dialog for enved print button.
   1-Jan-98: save selection output file size calc was off in multi-channel case.
   ---------
   22-Dec:   envelope editor dialog, Sun support except for recorder. filter-env function.
   12-Dec:   defvar, named envelopes.
   8-Dec:    fft freq axis is now dragable.
   3-Dec:    Mix dialog is now a file selection box.  global-explen and friends.
   6-Oct:    ports to UnixWare2 and OpenServer5 courtesy of Larry Plona.
   30-Sep:   snd-1-1.rpm. digital line-in recording fixed on the SGI.  snd.spec added.
   22-Sep:   iconify closes all active dialogs.
   9-Sep:    record window pixmap changes to try to accomodate old (buggy) versions of Xlib.  read-only variable and icon.
   8-Sep:    Lesstif 0.80 port (see README.Snd for caveats).  Raw data handling improved.
   1-Sep:    record window implemented, save-as dialog uses file selection box.
   13-Aug:   [space] to pause/continue playback.
   11-Aug:   an icon and other sound support improvements in Linux.
   20-July:  searching bugs fixed. global-set-key. space cancels selection. Snd to CLM communication improved (m-x lisp expr).
   8-July:   cursor play stuff caused seg fault in region play.  no-rld stuff removed.
   26-June:  y1..8 in parser.
   24-June:  click mix console brings it to top of stack.
   23-June:  C-x C-j: goto mix and other mix-<> functions. cursor follows play upon control-click.
   20-June:  group/mixer support.  File save-as now remains in current file, rather than switching to new.
   10-June:  print dialog. superimposed channel graphs (part 1).
   4-June:   group editor.
   19-May:   click file name for info.  
   16-May:   cursor changes. sync'd mixes. green sashes!
   13-May:   %spectrum works for normal fft.  Sound control labels are clickable.  initial-x0 and friends.
   5-May:    support for explode in CLM with-sound. dB for sonogram etc.
   23-Apr:   normalize-fft, better spectrum rotations.
   14-Apr:   first mix console step. expand clicks fixed. 
   4-Apr:    speed style option menu, associated variables.
   20-Mar:   file update option. Most dialogs now not transient (not auto-raised). -remote switch.
   18-Mar:   x axis units option.
   17-Mar:   session options. selection play fixed.
   14-Mar:   scale-by, scale-to, amp-envelope, with selection cases. More header types.
   1-Mar:    data command for clm through-snd.
   24-Feb:   Next switches, sessions, ufun action lists.
   17-Feb:   file browser (view files).
   12-Feb:   save-as dialog improved
   10-Feb:   view color and orientation menu options, with associated color variables.
   31-Jan:   file-loadable filter/envelopes.
   27-Jan:   1+1 where i+1 intended in spectrum!
   24-Jan:   memory leaks
   20-Jan:   improved spectrogram rotation, keypad keymap, wavogram.
   17-Jan:   dot-size. 'unite' button and Combine channels menu option. zoom focus choices (option menu).
   8-Jan-97: fixed bug in fft peak calculation. Save-As in Edit menu improved.
   ---------
   30-Dec:   clm display hooks.
   23-Dec:   amp env improved.
   18-Dec:   new file option smarter, spectrogram improved.
   16-Dec:   more clm-snd connections, peaks command.
   9-Dec:    Info menu option, save-marks.
   4-Dec:    Linux fixups (XmCreateMessageDialog -> bad drawable)
   20-Nov:   clm marks, fixed several apply and aiff header bugs
   18-Oct:   Linux port. info option, c-X c-V
   30-Sep:   snd-trans.c
   17-Sep:   better support for schemes, cross disk saves
   9-Sep-96: launched!
 */
