/* snd.h */
/* 
 * there are several compile-time options:
 *
 *   HAVE_GUILE    define if the guile library is available 
 *                 (adds lisp extension/customization language)
 *                 http://www.red-bean.com/~pate/guile
 *                 (this is now a standard part of the Gnu distribution)
 *
 *   HAVE_XmHTML    define if the XmHTML widget available
 *                 (used by help functions) 
 *                 http://www.xs4all.nl/~ripley/XmHTML
 *
 *   XPM           define if you have the XPM library (the default in Linux)
 *                 (used to make cute icons in various places)
 *
 *   USR_LIB_OSS    
 *   USR_LOCAL_LIB_OSS 
 *                 define if OSS library/header files are in /usr/lib or /usr/local/lib.
 *                 These are sometimes needed to find the correct version of soundcard.h
 *                 OSS is one of the main sound support providers for Linux.
 *                 http://www.4front-tech.com/ or maybe www.4front.com
 *
 *   HAVE_CONFIG_H define if you're trying to build Snd via autoconf config files
 */

#ifndef SND_H
#define SND_H

#if defined(HAVE_CONFIG_H)
  #include "config.h"
  #if (!defined(HAVE_STRTOK))
    #error Snd code needs strtok which is apparently missing
  #endif
#endif

#include <ctype.h>
#include <stddef.h>
#include <math.h>
#include <stdio.h>
#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_FCNTL_H))
  #include <fcntl.h>
#endif
#include <signal.h>
#if (!defined(HAVE_CONFIG_H)) || (defined(HAVE_LIMITS_H))
  #include <limits.h>
#endif
#include <errno.h>
#include <stdlib.h>

#if (defined(NEXT) || (defined(HAVE_LIBC_H) && (!defined(HAVE_UNISTD_H))))
  #include <libc.h>
#else
  #include <unistd.h>
#ifdef VMS
#if __DECC_VER < 50200000
#include <unixio.h>
#endif
#endif
#endif

#include <string.h>
#include <stdarg.h>
#include <time.h>

#if MACOS
  #include <stat.h>
#else
  #include <sys/types.h>
  #include <sys/stat.h>
#endif

#include "sndlib.h"
#include "cmus.h"
/* cmus.h needed only for the clm-style struct offsets, cl_false, and fifo names */

#if defined(BEOS)
  #define HAVE_MOTIF 0
#else
  #define HAVE_MOTIF 1
#endif

#ifdef WINDOZE
  #define _NO_PROTO
  #define IMPDATA
  #define IMPQUARK
#endif

#include "snd-0.h"

#if HAVE_MOTIF
  #include "snd-x0.h"
#endif

/* #include "/snd/books/dbm/malloc.h" */

#include "snd-1.h"

#if HAVE_MOTIF
  #include "snd-x1.h"
#endif

#ifndef WINDOZE
  #include "snd-strings.h"
#else
  #include "snd-stri.h"
#endif

#define SND_VERSION "27-Sep-98"
#define SND_RPM_VERSION "2.1"

#endif

