G /* Emulation of 4.2 UNIX socket interface routines includes drivers for F    Wollongong, CMU-TEK, UCX tcp/ip interface and also emulates the SUNE    version of X.25 sockets.  The TWG will also work for MultiNet.  */   I /* This is from unixlib, by P.Kay@massey.ac.nz; wonderful implementation. B    You can get the real thing on 130.123.1.4 as unixlib_tar.z.  */   #include <stdio.h> #include <errno.h> #include <ssdef.h> #include <dvidef.h>  #include <signal.h>  #include <sys$library:msgdef.h>  #include <iodef.h> #include <ctype.h> #include <vms.h> #include "[.vms]network.h"  C #define QIO_FAILED (st != SS$_NORMAL || p[s].iosb[0] != SS$_NORMAL) ( #define QIO_ST_FAILED (st != SS$_NORMAL)   /* Socket routine.  */ int " VMSsocket (domain, type, protocol)       int domain, type, protocol; { /   struct descriptor inetdesc, x25desc, mbxdesc;     int i, st, s, p_initialise ();   long ucx_sock_def;   char *getenv ();     if (!tcp_make)     set_tcp_make ();     if (p_initialised == 0)      {        for (i = 0; i < 32; i++) 	p_initialise (i);         p_initialised = 1;     }   K   /* First of all, get a file descriptor and file ptr we can associate with H      the socket, allocate a buffer, and remember the socket details.  */   s = dup (0);
   if (s > 31)      {        errno = EMFILE;        close (s);       return -1;     }      p[s].fptr = fdopen (s, "r");5   p[s].fd_buff = (unsigned char *) malloc (BUF_SIZE);    p[s].domain = domain;    p[s].type = type;    p[s].protocol = protocol;   5   /* Handle the case of INET and X.25 separately.  */    if (domain == AF_INET)     {        if (tcp_make == NONE)  	{F 	  printf ("Trying to obtain a TCP socket when we don't have TCP!\n"); 	  exit (1); 	}       if (tcp_make == CMU) 	{0 	  /* For CMU we need only assign a channel.  */ 	  inetdesc.size = 3;  	  inetdesc.ptr = "IP:";A 	  if (sys$assign (&inetdesc, &p[s].channel, 0, 0) != SS$_NORMAL)  	    return -1;  	}       else if (tcp_make == UCX)  	{@ 	  /* For UCX assign channel and associate a socket with it.  */ 	  inetdesc.size = 3;  	  inetdesc.ptr = "BG:";A 	  if (sys$assign (&inetdesc, &p[s].channel, 0, 0) != SS$_NORMAL)  	    return -1;   ; 	  ucx_sock_def = (domain << 24) + (type << 16) + protocol; @ 	  st = sys$qiow (0, p[s].channel, IO$_SETMODE, p[s].iosb, 0, 0," 			 &ucx_sock_def, 0, 0, 0, 0, 0); 	  if (QIO_FAILED) 	    return -1;  	}
       else 	{G 	  /* For TWG we assign the channel and associate a socket with it.  */  	  inetdesc.size = 7;  	  inetdesc.ptr = "_INET0:";  A 	  if (sys$assign (&inetdesc, &p[s].channel, 0, 0) != SS$_NORMAL)  	    return -1;   ? 	  st = sys$qiow (0, p[s].channel, IO$_SOCKET, p[s].iosb, 0, 0,  			 domain, type, 0, 0, 0, 0); 	  if (QIO_FAILED) 	    return -1;  	}     }    else1     /* We don't handle any other domains yet.  */      return -1;  E   /* For each case if we are successful we return the descriptor.  */    return s;  }    /* Bind routine.  */ VMSbind (s, name, namelen)      int s;       union socket_addr *name;       int namelen;  { !   char infobuff[1024], lhost[32]; 	   int st;      if (!tcp_make)     set_tcp_make ();     if (p[s].domain == AF_INET)      { H       /* One main problem with bind is that if we're given a port numberB 	 of 0, then we're expected to return a unique port number.  Since< 	 we don't KNOW, we return 1050+s and look to Lady Luck.  */       if (tcp_make == CMU) 	{9 	  if (name->in.sin_port == 0 && p[s].type != SOCK_DGRAM) " 	    name->in.sin_port = 1050 + s; 	  p[s].namelen = namelen;' 	  bcopy (name, &(p[s].name), namelen);    	  if (p[s].type == SOCK_DGRAM)  	    {A 	      /* Another problem is that CMU still needs an OPEN request & 		 even if it's a datagram socket.  */; 	      st = sys$qiow (0, p[s].channel, TCP$OPEN, p[s].iosb, 2 			     0, 0, 0, 0, ntohs (p[s].name.in.sin_port), 			     0, 1, 0);  	      if (QIO_ST_FAILED)  		return -1;   	      p[s].cmu_open = 1; 6 	      sys$qiow (0, p[s].channel, TCP$INFO, p[s].iosb,& 			0, 0, &infobuff, 1024, 0, 0, 0, 0);; 	      bcopy (infobuff + 264, &(p[s].name.in.sin_port), 2); = 	      p[s].name.in.sin_port = htons (p[s].name.in.sin_port);   $ 	      /* So get it another way.  */2 	      bcopy (infobuff + 136, lhost, infobuff[1]);! 	      lhost[infobuff[1]] = '\0'; 3 	      sys$qiow (0, p[s].channel, GTHST, p[s].iosb, * 			0, 0, &infobuff, 1024, 1, lhost, 0, 0);9 	      bcopy (infobuff + 4, &(p[s].name.in.sin_addr), 4);   / 	      /* Be prepared to receive a message.  */  	      hang_a_read (s);  	    } 	}       else if (tcp_make == UCX)  	{A 	  /* UCX will select a prot for you.  If the port's number is 0, / 	     translate "name" into an item_2 list.  */  	  struct itemlist lhost;  	  lhost.length = namelen; 	  lhost.code = 0;! 	  lhost.dataptr = (char *) name;   @ 	  st = sys$qiow (0, p[s].channel, IO$_SETMODE, p[s].iosb, 0, 0, 			 0, 0, &lhost, 0, 0, 0);  	  if (QIO_FAILED) 	    return -1;    	  if (p[s].type == SOCK_DGRAM)  	    hang_a_read (s);    	}
       else 	{# 	  /* WG is more straightforward */ 7 	  st = sys$qiow (0, p[s].channel, IO$_BIND, p[s].iosb, % 			 0, 0, name, namelen, 0, 0, 0, 0);  	  if (QIO_FAILED) 	    return -1;   8 	  /* If it's a datagram, get ready for the message.  */ 	  if (p[s].type == SOCK_DGRAM)  	    hang_a_read (s);  	}     }    else0     /* We don't handle any other domain yet.  */     return -1;     return 0;  }    /* Connect routine.  */  VMSconnect (s, name, namelen)       int s;       union socket_addr *name;       int namelen;  {    int pr, fl, st;    char *inet_ntoa ();    static struct    {      int len;     char name[128];    } gethostbuf;    extern int connect_ast ();     if (!tcp_make)     set_tcp_make ();  J   /* For datagrams we need to remember who the name was so we can send allL      messages to that address without having to specify it all the time.  */   if (p[s].connected)      {        if (p[s].connected == 1) 	errno = EISCONN; 
       else 	{ 	  errno = ECONNREFUSED; 	  p[s].connected = 0; 	}       return -1;     }      if (p[s].connect_pending)      {        errno = EALREADY;        return -1;     }      p[s].passive = 0;    p[s].tolen = namelen; $   bcopy (name, &(p[s].to), namelen);     if (p[s].domain == AF_INET)      {        if (tcp_make == CMU) 	{  G 	  /* Get the info about the remote host  and open up a connection.  */ G 	  st = sys$qiow (0, p[s].channel, GTHST, p[s].iosb, 0, 0, &gethostbuf, , 			 132, 2, name->in.sin_addr.s_addr, 0, 0); 	  if (QIO_FAILED) 	    {F 	      strcpy (gethostbuf.name, inet_ntoa (name->in.sin_addr.s_addr));1 	      gethostbuf.len = strlen (gethostbuf.name);  	    }' 	  gethostbuf.name[gethostbuf.len] = 0;    	  /* TCP */
 	  pr = 0; 	  /* Active */ 
 	  fl = 1;  % 	  /* Nothing else for datagrams.  */  	  if (p[s].type == SOCK_DGRAM)  	    return (0);C 	  st = sys$qio (s, p[s].channel, TCP$OPEN, p[s].iosb, connect_ast, 8 			&p[s], &(gethostbuf.name), ntohs (name->in.sin_port),- 			ntohs (p[s].name.in.sin_port), fl, pr, 0);  	  if (QIO_ST_FAILED)  	    return -1;  	}       else if (tcp_make == UCX)  	{8 	  /* Both UDP and TCP can use a connect - IO$_ACCESS */ 	  p[s].rhost.length = namelen;  	  p[s].rhost.code = 0; & 	  p[s].rhost.dataptr = (char *) name;  E 	  st = sys$qio (s, p[s].channel, IO$_ACCESS, p[s].iosb, connect_ast, & 			&p[s], 0, 0, &p[s].rhost, 0, 0, 0); 	  if (QIO_ST_FAILED)  	    return -1;  	}
       else 	{ 	  /* TWG */ 	  if (p[s].type == SOCK_DGRAM)  	    return (0);F 	  st = sys$qio (s, p[s].channel, IO$_CONNECT, p[s].iosb, connect_ast,% 			&p[s], name, namelen, 0, 0, 0, 0);  	  if (QIO_ST_FAILED)  	    return -1;  	}     }    else0     /* We don't handle any other domain yet.  */     return -1;     if (p[s].non_blocking)     {        if (p[s].connected)  	{ 	  if (p[s].connected == 1)  	    return 0; 	  else  	    { 	      p[s].connected = 0; 	      errno = ECONNREFUSED; 	      return -1;  	    } 	}
       else 	{ 	  p[s].connect_pending = 1; 	  errno = EINPROGRESS; 
 	  return -1;  	}     }    else     { ,       /* wait for the connection to occur */       if (p[s].connected)n 	{ 	  if (p[s].connected == 1)o 	    return 0; 	  elsep 	    { 	      p[s].connected = 0; 	      errno = ECONNREFUSED; 	      return -1;w 	    } 	}         /* Timed out? */       if (wait_efn (s) == -1). 	return -1;   '       if (p[s].connected != SS$_NORMAL)h 	{ 	  errno = ECONNREFUSED;
 	  return -1;i 	}         return 0;u     }n }>   /* Listen routine.  */ VMSlisten (s, backlog)      int s;       int backlog;r {:	   int st;      if (!tcp_make)     set_tcp_make ();     p[s].passive = 1;e   p[s].backlog = backlog;n   if (p[s].domain == AF_INET)|     {i       if (tcp_make == CMU) 	{> 	  /* For the CMU sockets we can't do the open call in listen;? 	     we have to do it in hang_an_accept, because when we closeo> 	     off the connection we have to be ready to accept another9 	     one.  accept() also calls hang_an_accept on the old* 	     descriptor.  */p   	  /* Nothing */ 	}       else if (tcp_make == UCX)  	{  B 	  /* Doc Verbage sez backlog is descriptor of byte.  Doc examplesA 	     and common sense say backlog is value.  Value doesn't work,a4 	     so let's try descriptor of byte after all.  */ 	  struct descriptor bl; 	  unsigned char ucx_backlog;   ) 	  ucx_backlog = (unsigned char) backlog;r" 	  bl.size = sizeof (ucx_backlog);" 	  bl.ptr = (char *) &ucx_backlog;  @ 	  st = sys$qiow (0, p[s].channel, IO$_SETMODE, p[s].iosb, 0, 0, 			 0, 0, 0, &bl, 0, 0); 	  if (QIO_FAILED) 	    return -1;] 	}
       else 	{ 	  /* TWG */? 	  st = sys$qiow (0, p[s].channel, IO$_LISTEN, p[s].iosb, 0, 0,F 			 backlog, 0, 0, 0, 0, 0); 	  if (QIO_FAILED) 	    return -1;g 	}     }a   else0     /* We don't handle any other domain yet.  */     return -1;     p[s].status = LISTENING;   hang_an_accept (s);    return 0;  }i   /* Accept routine.  */ int. VMSaccept (s, addr, addrlen)      int s;       union socket_addr *addr;M      int *addrlen; {    int news, st;    struct descriptor inetdesc;o     if (!tcp_make)     set_tcp_make ();  0   if (p[s].non_blocking && !p[s].accept_pending)     {B       errno = EWOULDBLOCK;       return -1;     }   J   /* hang_an_accept set up an incoming connection request so we have first9      to hang around until one appears or we time out.  */I   if (p[s].domain == AF_INET)	     {s       if (tcp_make == CMU) 	{ 	  char infobuff[1024];    	  /* Timed out?  */ 	  if (wait_efn (s) == -1) 	    return -1;o  & 	  /* Ok, get a new descriptor ...  */ 	  news = dup (0); 	  if (news > 31); 	    { 	      errno = EMFILE; 	      close (news); 	      return -1;  	    }  . 	  /* ... and copy all of our data across.  */* 	  bcopy (&p[s], &p[news], sizeof (p[0]));  ' 	  /* But not this field, of course! */r 	  p[news].s = news;  8 	  sys$qiow (0, p[news].channel, TCP$INFO, p[news].iosb,) 		    0, 0, &infobuff, 1024, 0, 0, 0, 0);e  7 	  /* Copy across the connection info if necessary.  */  	  if (addr != 0). 	    {. 	      *addrlen = sizeof (struct sockaddr_in);7 	      bcopy (infobuff + 132, &(addr->in.sin_port), 2);f5 	      addr->in.sin_port = htons (addr->in.sin_port);)% 	      addr->in.sin_family = AF_INET;m7 	      bcopy (infobuff + 272, &(addr->in.sin_addr), 4);b" 	      p[news].fromlen = *addrlen;/ 	      bcopy (addr, &(p[news].from), *addrlen);q 	    }' 	  p[news].status = PASSIVE_CONNECTION;n  , 	  /* Get a new file ptr for the socket.  */% 	  p[news].fptr = fdopen (news, "r");_   	  /* Reset this field.  */D 	  p[news].accept_pending = 0;   	  /* Allocate a buffer.  */9 	  p[news].fd_buff = (unsigned char *) malloc (BUF_SIZE);p 	  p[news].fd_leftover = 0;   " 	  /* Be prepared to get msgs.  */ 	  hang_a_read (news);  < 	  /* Now fix up our previous socket so it's again listening 	     for connections.  */ 	  inetdesc.size = 3;  	  inetdesc.ptr = "IP:";A 	  if (sys$assign (&inetdesc, &p[s].channel, 0, 0) != SS$_NORMAL)  	    return -1;  	  p[s].status = LISTENING;  	  hang_an_accept (s);  + 	  /* Return the new socket descriptor.  */f 	  return news;0 	}       else if (tcp_make == UCX)[ 	{F 	  /* UCX does the actual accept from hang_an_accept.  The accept info? 	    is put into the data structure for the "listening" socket.oC 	    These just need to be copied into a newly allocated socket for 9 	    the connect and the listening socket re-started.  */   ; 	  /* Wait for event flag from accept being received insideo 	     of hang_an_accept().  */   	  if (wait_efn (s) == -1) 	    /* Timed out.  */ 	    return -1;n  & 	  /* Ok, get a new descriptor ...  */ 	  news = dup (0); 	  if (news > 31)s 	    { 	      errno = EMFILE; 	      close (news); 	      return -1;" 	    }. 	  /* ... and copy all of our data across.  */* 	  bcopy (&p[s], &p[news], sizeof (p[0]));- 	  p[news].s = news;	/* but not this field */ * 	  p[news].channel = p[s].ucx_accept_chan;  @ 	  /* Initialize the remote host address item_list_3 struct.  */6 	  p[news].rhost.length = sizeof (struct sockaddr_in); 	  p[news].rhost.code = 0;2 	  p[news].rhost.dataptr = (char *) &p[news].from;0 	  p[news].rhost.retlenptr = &p[news].fromdummy;   	  if (addr != 0)e 	    {5 	      /* Return the caller's info, if requested.  */ $ 	      *addrlen = p[news].fromdummy;6 	      bcopy (&p[news].from, addr, p[news].fromdummy); 	    }  0 	  /* Finish fleshing out the new structure.  */' 	  p[news].status = PASSIVE_CONNECTION;u  0 	  /* Get a new file pointer for the socket.  */% 	  p[news].fptr = fdopen (news, "r");    	  /* Reset this field.  */r 	  p[news].accept_pending = 0;   	  /* Allocate a buffer.  */9 	  p[news].fd_buff = (unsigned char *) malloc (BUF_SIZE);r 	  p[news].fd_leftover = 0;   ! 	  /* Get it started reading.  */f 	  hang_a_read (news);   	  p[s].status = LISTENING;s 	  hang_an_accept (s);   	  return news;  	}
       else 	{ 	  /* TWG */ 	  struct descriptor inetdesc; 	  int size;   	  /* Time out?  */c 	  if (wait_efn (s) == -1) 	    return -1;=  & 	  /* Ok, get a new descriptor ...  */ 	  news = dup (0); 	  if (news > 31)c 	    { 	      errno = EMFILE; 	      close (news); 	      return -1;  	    }   	  /* Assign a new channel.  */n 	  inetdesc.size = 7;p 	  inetdesc.ptr = "_INET0:";7 	  st = sys$assign (&inetdesc, &p[news].channel, 0, 0);[ 	  if (QIO_ST_FAILED)  	    { 	      p[s].accept_pending = 0;  	      sys$clref (s);t 	      return -1;n 	    }  - 	  /* From info needs an int length field! */h! 	  size = sizeof (p[s].from) + 4;hE 	  st = sys$qiow (0, p[news].channel, IO$_ACCEPT, p[news].iosb, 0, 0,E2 			 &p[s].fromdummy, size, p[s].channel, 0, 0, 0);  6 	  if (QIO_ST_FAILED || p[news].iosb[0] != SS$_NORMAL) 	    { 	      p[s].accept_pending = 0;o 	      sys$clref (s);e 	      return -1;C 	    }   	  if (addr != 0)e 	    {4 	      /* Return the caller's info if requested.  */! 	      *addrlen = p[s].fromdummy; * 	      bcopy (&p[s].from, addr, *addrlen); 	    }  ( 	  /* Fix up our new data structure.  */' 	  p[news].status = PASSIVE_CONNECTION;t 	  p[news].domain = AF_INET; 	  p[news].passive = 1;i% 	  p[news].fptr = fdopen (news, "r");} 	  /* Allocate a buffer.  */9 	  p[news].fd_buff = (unsigned char *) malloc (BUF_SIZE);C  % 	  /* Be prepared to accept msgs.  */  	  hang_a_read (news);  5 	  /* Get the old descriptor back onto accepting.  */i 	  hang_an_accept (s); 	  return news;, 	}     }t   else0     /* We don't handle any other domain yet.  */     return -1; }r   /* Recv routine.  */ int  VMSrecv (s, buf, len, flags)      int s;       char *buf;;      int len, flags; {]-   return recvfrom (s, buf, len, flags, 0, 0);  }&   /* Revfrom routine.  */0 int / VMSrecvfrom (s, buf, len, flags, from, fromlen)       int s;       char *buf;a      int len, flags;      union socket_addr *from;f      int *fromlen; { 
   int number;(     if (!tcp_make)     set_tcp_make ();  6   if (p[s].domain != AF_INET && p[s].domain != AF_X25)     return -1;  D   /* If we're not onto datagrams, then it's possible that a previousE      call to recvfrom didn't read all the data, and left some behind.1D      So first of all, look in our data buffer for any leftovers that       will satisfy this read.  */  G   /* We couldn't satisfy the request from previous calls so we must now ,      wait for a message to come through.  */   if (wait_efn (s) == -1)      /* Timed out.  */m     return -1;  !   if (p[s].closed_by_remote == 1)1     { %       /* This could have happened! */        errno = ECONNRESET;;       return -1;     }      if (from != NULL)      {*       if (tcp_make == CMU) 	{ 	  if (p[s].type == SOCK_DGRAM)i 	    {G 	      /* Not documented but we get the from data from the beginning ofp 		 the data buffer.  */l( 	      *fromlen = sizeof (p[s].from.in);% 	      from->in.sin_family = AF_INET;)9 	      bcopy (&p[s].fd_buff[8], &(from->in.sin_port), 2);n5 	      from->in.sin_port = htons (from->in.sin_port);a9 	      bcopy (&p[s].fd_buff[0], &(from->in.sin_addr), 4);r  @ 	      /* Remove the address data from front of data buffer.  */B 	      bcopy (p[s].fd_buff + 12, p[s].fd_buff, p[s].fd_buff_size); 	    } 	  elsek 	    { 	      *fromlen = p[s].fromlen;a. 	      bcopy (&p[s].from, from, p[s].fromlen); 	    } 	}       else if (tcp_make == UCX)u 	{ 	  *fromlen = p[s].fromdummy;y, 	  bcopy (&p[s].from, from, p[s].fromdummy); 	}
       else 	{ 	  *fromlen = p[s].fromlen; * 	  bcopy (&p[s].from, from, p[s].fromlen); 	}     }=  %   /* We may've received too much.  */    number = p[s].fd_buff_size;$   if (number <= len)     {T<       /* If we haven't give back all the data available.  */(       bcopy (p[s].fd_buff, buf, number);       p[s].fd_leftover = 0;$       hang_a_read (s);       return (number);     }	   else     {,7       /* If we have too much data then split it up.  */ &       p[s].fd_leftover = p[s].fd_buff;)       bcopy (p[s].fd_leftover, buf, len);[%       /* And change the pointers.  */t       p[s].fd_leftover += len;       p[s].fd_buff_size -= len;p       return (len);      }t }    /* Send routine.  */ intr VMSsend (s, msg, len, flags)      int s;       char *msg;p      int len, flags; {t+   return sendto (s, msg, len, flags, 0, 0);n }b   /* Sendto routine.  */ int)) VMSsendto (s, msg, len, flags, to, tolen)       int s;       unsigned char *msg;      int len, flags;      union socket_addr *to;f      int tolen;g {o   int i, j, st, size;r&   unsigned char udpbuf[BUF_SIZE + 12];!   char infobuff[1024], lhost[32];a   unsigned short int temp;     if (!tcp_make)     set_tcp_make ();  D   /* First remember who we sent it to and set the value of size.  */   if (to != 0)     {u       p[s].tolen = tolen; $       bcopy (to, &(p[s].to), tolen);       size = tolen;      }    else
     size = 0;.     if (p[s].domain == AF_INET).     { F       /* We might never have started a read for udp (socket/sendto) so 	 put one here.  */w"       if (p[s].type == SOCK_DGRAM) 	hang_a_read (s);F         if (tcp_make == CMU) 	{ 	  if (p[s].type == SOCK_DGRAM)/ 	    {= 	      /* We might never have opened up a udp connection yet,. 		 so check.  */ 	      if (p[s].cmu_open != 1) 		{;> 		  st = sys$qiow (0, p[s].channel, TCP$OPEN, p[s].iosb, 0, 0, 				 0, 0, 0, 0, 1, 0);o 		  if (QIO_ST_FAILED) 		    return -1;   		  p[s].cmu_open = 1;3 		  sys$qiow (0, p[s].channel, TCP$INFO, p[s].iosb,b* 			    0, 0, &infobuff, 1024, 0, 0, 0, 0);8 		  bcopy (infobuff + 264, &(p[s].name.in.sin_port), 2);: 		  p[s].name.in.sin_port = htons (p[s].name.in.sin_port);/ 		  bcopy (infobuff + 136, lhost, infobuff[1]);( 		  lhost[infobuff[1]] = '\0';0 		  sys$qiow (0, p[s].channel, GTHST, p[s].iosb,. 			    0, 0, &infobuff, 1024, 1, lhost, 0, 0);6 		  bcopy (infobuff + 4, &(p[s].name.in.sin_addr), 4); 		}r  B 	      /* This isn't well documented.  To send to a UDP socket, we7 		 need to put the address info at the beginning of thee 		 buffer.  */% 	      bcopy (msg, udpbuf + 12, len); 3 	      bcopy (&p[s].to.in.sin_addr, udpbuf + 4, 4);e* 	      temp = ntohs (p[s].to.in.sin_port);% 	      bcopy (&temp, udpbuf + 10, 2);I1 	      bcopy (&p[s].name.in.sin_addr, udpbuf, 4);w, 	      temp = ntohs (p[s].name.in.sin_port);$ 	      bcopy (&temp, udpbuf + 8, 2); 	      temp = len + 12;aA 	      st = sys$qiow (0, p[s].channel, TCP$SEND, p[s].iosb, 0, 0,e" 			     udpbuf, temp, 0, 0, 0, 0); 	      if (QIO_FAILED) 		return -1; 	    } 	  elsey 	    { 	      /* TCP (! UDP)  */nA 	      st = sys$qiow (0, p[s].channel, TCP$SEND, p[s].iosb, 0, 0,e 			     msg, len, 0, 0, 0, 0); 	      if (QIO_FAILED) 		return -1; 	    } 	  return len; 	}       else if (tcp_make == UCX)  	{ 	  struct itemlist rhost; . 	  rhost.length = sizeof (struct sockaddr_in); 	  rhost.code = 0;% 	  rhost.dataptr = (char *) &p[s].to;o  B 	  st = sys$qiow (0, p[s].channel, IO$_WRITEVBLK, p[s].iosb, 0, 0, 			 msg, len, &rhost, 0, 0, 0);, 	  if (QIO_FAILED) 	    return -1;]   	  return len; 	}
       else 	{ 	  /* TWG */< 	  st = sys$qiow (0, p[s].channel, IO$_WRITEVBLK, p[s].iosb,* 			 0, 0, msg, len, 0, &p[s].to, size, 0); 	  if (QIO_FAILED) 	    return -1;a   	  return len; 	}     }d   else0     /* We don't handle any other domain yet.  */     return -1; }r   /* Getsockname routine.  */  inti! VMSgetsockname (s, name, namelen)e      int s;e      union socket_addr *name;       int *namelen; {.	   int st;      if (!tcp_make)     set_tcp_make ();     if (p[s].domain == AF_INET)i     {h       if (tcp_make == CMU) 	{C 	  /* For CMU we just return values held in our data structure.  */t 	  *namelen = p[s].namelen;n( 	  bcopy (&(p[s].name), name, *namelen); 	  return (0); 	}       else if (tcp_make == UCX); 	{$ 	  /* An item_list_3 descriptor.  */ 	  struct itemlist lhost;    	  lhost.length = *namelen;w 	  lhost.code = 0;! 	  lhost.dataptr = (char *) name;*  4 	  /* Fill in namelen with actual ret len value.  */+ 	  lhost.retlenptr = (short int *) namelen;   B 	  st = sys$qiow (0, p[s].channel, IO$_SENSEMODE, p[s].iosb, 0, 0, 			 0, 0, &lhost, 0, 0, 0);  	  if (QIO_FAILED) 	    return -1;    	  return 0; 	}
       else 	{& 	  /* TWG gives us the information. */> 	  st = sys$qiow (0, p[s].channel, IO$_GETSOCKNAME, p[s].iosb,% 			 0, 0, name, namelen, 0, 0, 0, 0);  	  if (QIO_FAILED) 	    return -1;i   	  return 0; 	}     }d   else0     /* We don't handle any other domain yet.  */     return -1; }[   /* Select routine.  */ int{7 VMSselect (nfds, readfds, writefds, exceptfds, timeout)t      int nfds;,      fd_set *readfds, *writefds, *exceptfds;      struct timeval *timeout;e {('   int timer, fd, alarm_set, total, end;n   long mask, cluster;T   struct descriptor termdesc;s9   static fd_set new_readfds, new_writefds, new_exceptfds;_     FD_ZERO (&new_readfds);S   FD_ZERO (&new_writefds);   FD_ZERO (&new_exceptfds);    total = 0;  9   /* Assign a terminal channel if we haven't already.  */{   if (terminal.chan == -1)     {o       termdesc.size = 10;*"       termdesc.ptr = "SYS$INPUT:";3       sys$assign (&termdesc, &terminal.chan, 0, 0);i     }r   alarm_set = 0;   if (timeout != NULL)     {S6       /* If a timeout is given then set the alarm.  */       end = timeout->tv_sec;       if (timer != 0)) 	{F 	  /* We need to reset the alarm if it didn't fire, but we set it.  */ 	  alarm_set = 1;  	  si_alarm (end); 	}     }s   else     end = 1;     do     {/       if (exceptfds) 	{ 	   /* Nothing */ ;* 	}         if (writefds)  	{  	  for (fd = 0; fd < nfds; fd++)! 	    if (FD_ISSET (fd, writefds))m 	      { 		if (p[fd].connect_pending) 		   /* Nothing */ ;. 		else if ((p[fd].status == ACTIVE_CONNECTION), 			 || (p[fd].status == PASSIVE_CONNECTION)) 		  {c! 		    FD_SET (fd, &new_writefds);  		    total++; 		  }e 	      } 	}         if (readfds) 	{, 	  /* True if data pending or an accept.  */  	  for (fd = 3; fd < nfds; fd++)" 	    if (FD_ISSET (fd, readfds) &&> 		((p[fd].fd_buff_size != -1) || (p[fd].accept_pending == 1))) 	      { 		FD_SET (fd, &new_readfds);
 		total++; 	      } 	}         if (total || (end == 0)) 	break;o  K       /* Otherwise, wait on an event flag.  It's possible that the wait canaB 	 be stopped by a spurious event flag being set -- i.e. one that's? 	 got a status not normal.  So we've got to be prepared to loopr3 	 around the wait until a valid reason happens.  */   "       /* Set up the wait mask.  */       cluster = 0;       mask = 0;/#       for (fd = 3; fd < nfds; fd++)T 	{ 	  sys$clref (fd); 	  if (readfds)[ 	    if FD_ISSET' 	      (fd, readfds) mask |= (1 << fd);e 	  if (writefds) 	    if FD_ISSET( 	      (fd, writefds) mask |= (1 << fd); 	  if (exceptfds)  	    if FD_ISSET) 	      (fd, exceptfds) mask |= (1 << fd);D 	}         mask |= (1 << TIMER_EFN);d  '       /* Clear it off just in case.  */g       sys$clref (TIMER_EFN);         /* Wait around.  */[        sys$wflor (cluster, mask);         mask = 0;        if (read_efn (TIMER_EFN))( 	{ 	  errno = EINTR;n	 	  break;o 	}   } while (1);   /*NOTREACHED*/  &   /* Unset the alarm if we set it.  */   if (alarm_set == 1)r     alarm (0);     if (readfds)     *readfds = new_readfds;.     if (writefds)(     *writefds = new_writefds;,     if (exceptfds)     *exceptfds = new_exceptfds;      return total;o }n   /* Shutdown routine.  */ VMSshutdown (s, how)      int s, how; {l	   int st;m   int ucx_how;     if (!tcp_make)     set_tcp_make ();     if (p[s].domain == AF_INET)y     {        if (tcp_make == CMU) 	{$ 	  /* For CMU we just close off.  */ 	  si_close (s); 	  return 0; 	}       else if (tcp_make == UCX)* 	{@ 	  st = sys$qiow (0, p[s].channel, IO$_DEACCESS | IO$M_SHUTDOWN,) 			 p[s].iosb, 0, 0, 0, 0, 0, how, 0, 0);v 	  if (QIO_FAILED) 	    return -1;f   	  return 0; 	}
       else 	{ 	  /* TWG lets us do it.  */F 	  st = sys$qiow (0, p[s].channel, IO$_SHUTDOWN, p[s].iosb, 0, 0, how, 			 0, 0, 0, 0, 0);s 	  if (QIO_FAILED) 	    return -1;v   	  return 0; 	}     }c"   else				/* it wasn't a socket */     return -1; }    /*  */s  A /* The following routines are used by the above socket calls.  */n  D /* hang_a_read sets up a read to be finished at some later time.  */ hang_a_read (s)       int s;i {s   extern int read_ast ();i   int size, st;t  +   /* Don't bother if we already did it.  */ !   if (p[s].read_outstanding == 1)      return;   !   /* Have a read outstanding.  */t   p[s].read_outstanding = 1;    size = sizeof (p[s].from) + 4;   sys$clref (s);  G   /* Clear off the event flag just in case, and reset the buf size.  */S   p[s].fd_buff_size = -1;[   if (p[s].domain == AF_INET)s     {t       if (tcp_make == CMU) 	{C 	  st = sys$qio (s, p[s].channel, TCP$RECEIVE, p[s].iosb, read_ast, . 			&p[s], p[s].fd_buff, BUF_SIZE, 0, 0, 0, 0); 	  if (QIO_ST_FAILED)  	    return -1;& 	}       else if (tcp_make == UCX)n 	{  3 	  p[s].rhost.length = sizeof (struct sockaddr_in);A 	  p[s].rhost.code = 0;*, 	  p[s].rhost.dataptr = (char *) &p[s].from;* 	  p[s].rhost.retlenptr = &p[s].fromdummy;  D 	  st = sys$qio (s, p[s].channel, IO$_READVBLK, p[s].iosb, read_ast,8 			&p[s], p[s].fd_buff, BUF_SIZE, &p[s].rhost, 0, 0, 0); 	  if (QIO_ST_FAILED)h 	    return -1;d 	}
       else 	{ 	  /* TWG */D 	  st = sys$qio (s, p[s].channel, IO$_READVBLK, p[s].iosb, read_ast,3 			&p[s], p[s].fd_buff, BUF_SIZE, 0, &p[s].fromlen,1 			size, 0); 	  if (QIO_ST_FAILED)  	    return -1;  	}     }e   else0     /* We don't handle any other domain yet.  */     return -1; }n  @ /* hang_an_accept waits for a connection request to come in.  */ hang_an_accept (s)      int s;n {n   extern int accept_ast ();i	   int st;	  +   /* Clear the event flag just in case.  */    sys$clref (s);  #   /* Reset our flag & buf size.  */n   p[s].accept_pending = 0;   p[s].fd_buff_size = -1;,   if (p[s].domain == AF_INET)b     {,       if (tcp_make == CMU) 	{B 	  st = sys$qio (s, p[s].channel, TCP$OPEN, p[s].iosb, accept_ast,8 			&p[s], 0, 0, ntohs (p[s].name.in.sin_port), 0, 0, 0); 	  if (QIO_ST_FAILED)  	    return -1;, 	}       else if (tcp_make == UCX)p 	{ 	  struct descriptor inetdesc;  < 	  /* Assign channel for actual connection off listener.  */ 	  inetdesc.size = 3;  	  inetdesc.ptr = "BG:";7 	  if (sys$assign (&inetdesc, &p[s].ucx_accept_chan, 0,. 			  0) != SS$_NORMAL) 	    return -1;   E 	  /* UCX's accept returns remote host info and the channel for a newT> 	     socket to perform reads/writes on, so a sys$assign isn't 	     really necessary.  */u3 	  p[s].rhost.length = sizeof (struct sockaddr_in);P, 	  p[s].rhost.dataptr = (char *) &p[s].from; 	  p[s].fromdummy = 0;* 	  p[s].rhost.retlenptr = &p[s].fromdummy;  F 	  st = sys$qio (s, p[s].channel, IO$_ACCESS | IO$M_ACCEPT, p[s].iosb,( 			accept_ast, &p[s], 0, 0, &p[s].rhost,  			&p[s].ucx_accept_chan, 0, 0); 	  if (QIO_ST_FAILED)  	    return -1;; 	}
       else 	{= 	  st = sys$qio (s, p[s].channel, IO$_ACCEPT_WAIT, p[s].iosb,W( 			accept_ast, &p[s], 0, 0, 0, 0, 0, 0); 	  if (QIO_ST_FAILED)i 	    return -1;  	}     }1   else0     /* We don't handle any other domain yet.  */     return -1; }p  D /* wait_efn just sets up a wait on either an event or the timer.  */ wait_efn (s)      int s;E {    long mask, cluster;r     cluster = 0;   sys$clref (TIMER_EFN);%   mask = (1 << s) | (1 << TIMER_EFN);    sys$wflor (cluster, mask);     if (read_efn (TIMER_EFN))t     {e       errno = EINTR;       return -1;     }s     return 0;e }   @ /* read_ast is called by the system whenever a read is done.  */ read_ast (p)      struct fd_entry *p; {    int i, j;    unsigned char *v, *w;   $   /* Reset the outstanding flag.  */   p->read_outstanding = 0;   if (p->iosb[0] == SS$_NORMAL)      {(       /* Check no errors.  */ #       p->fd_buff_size = p->iosb[1];p       if (tcp_make == CMU) 	{ 	  /* fiddle for DGRMs */  	  if (p->type == SOCK_DGRAM)l 	    p->fd_buff_size -= 12;l 	}       if (p->sig_req == 1) 	gsignal (SIGIO);      } %   else if (p->iosb[0] == SS$_CLEARED)u     p->closed_by_remote = 1;   else if (tcp_make == UCX)s     {$'       if (p->iosb[0] == SS$_LINKDISCON)] 	p->closed_by_remote = 1;o     }0 })  B /* accept_ast is called whenever an incoming call is detected.  */ accept_ast (p)      struct fd_entry *p; {/   if (p->iosb[0] == SS$_NORMAL)e     p->accept_pending = 1;   else.     /* If it failed set up another listen.  */#     listen (p->s, p[p->s].backlog);  }   ? /* connect_ast is called whenever an async connect is made.  *// connect_ast (p)       struct fd_entry *p; {    p->connect_pending = 0;f0   if ((p->connected = p->iosb[0]) == SS$_NORMAL)     {f$       /* We made the connection.  */$       p->status = ACTIVE_CONNECTION;  )       /* Be prepared to accept a msg.  */o       hang_a_read (p->s);t     }p }    /*  */ ( /* These routines handle stream I/O.  */  = /* si_close -- must close off any connection in progress.  */r si_close (s)      int s;x {t   if (!tcp_make)     set_tcp_make ();     if ((s < 0) || (s > 31))     return -1;     if (p[s].channel != 0)     { *       /* Was it one of our descriptors? */!       if (p[s].domain == AF_INET)( 	{ 	  if (tcp_make == CMU) 5 	    sys$qiow (0, p[s].channel, TCP$CLOSE, p[s].iosb,   		      0, 0, 0, 0, 0, 0, 0, 0);! 	  if (p[s].status != HANDED_OFF)  	    sys$dassgn (p[s].channel);(
 	  close (s);{ 	  free (p[s].fd_buff);t 	  p_initialise (s); 	}       return 0;      }a   else     { 7       /* Re-initialise data structure just in case.  */        p[s].fd_buff_size = -1;)       p[s].accept_pending = 0;        p[s].status = INITIALISED;       return close (s);)     }i }F  ; /* si_alarm -- insert a call to our own alarm function.  */) si_alarm (i)      int i;l {i   extern int pre_alarm ();  ?   /* Make the call to pre_alarm instead of what the user wants;	:      pre_alarm will call his routine when it finishes.  */&   /* VAX needs this call each time! */   signal (SIGALRM, pre_alarm);   alarm (i); }r  9 /* pre_alarm -- gets called first on an alarm signal.  */& pre_alarm () {f<   /* Come here first so we can set our timer event flag.  */   sys$setef (TIMER_EFN);   (*alarm_function) ();  }   0 /* p_initialise - initialise our data array.  */ p_initialise (s)      int s;. {t   int j;   for (j = 0; j < 4; j++)s     p[s].iosb[j] = 0;e   p[s].channel = 0;i   p[s].fd_buff_size = -1;t   p[s].accept_pending = 0;   p[s].connect_pending = 0;r   p[s].connected = 0;a   p[s].fd_buff = NULL;   p[s].fd_leftover = NULL;   p[s].fptr = NULL;s
   p[s].s = s;    p[s].name.in.sin_port = 0;   p[s].masklen = 4;{   for (j = 0; j < 16; j++)     p[s].mask[j] = 0xff;   p[s].need_header = 0;m   p[s].status = INITIALISED;   p[s].read_outstanding = 0;   p[s].cmu_open = 0;   p[s].x25_listener = 0;   p[s].mother = s;   p[s].child = 0;    p[s].no_more_accepts = 0;D   p[s].closed_by_remote = 0;   p[s].non_blocking = 0;   p[s].sig_req = 0;e   sys$clref (s); }e  4 /* read_efn -- see whether an event flag is set.  */ read_efn (i)      int i;  {    int j;   sys$readef (i, &j);I   j &= (1 << i);     return j;n }    static set_tcp_make (); {    struct descriptor inetdesc;e   int channel;   /* first try CMU */e   inetdesc.size = 3;   inetdesc.ptr = "IP:"; ;   if (sys$assign (&inetdesc, &channel, 0, 0) == SS$_NORMAL)      {t       sys$dassgn (channel);        tcp_make = CMU;p
       return;u     }l     /* next try TWG */   inetdesc.size = 7;   inetdesc.ptr = "_INET0:"; ;   if (sys$assign (&inetdesc, &channel, 0, 0) == SS$_NORMAL)c     {(       sys$dassgn (channel);_       tcp_make = WG;
       return;      }{     /* next try UCX */   inetdesc.size = 4;   inetdesc.ptr = "BG0:";;   if (sys$assign (&inetdesc, &channel, 0, 0) == SS$_NORMAL),     {h       sys$dassgn (channel);U       tcp_make = UCX;0
       return;o     })     /* nothing there oh dear!*/r   tcp_make = NONE;	   return;  }l  
 static char *  getdevicename (channel)        unsigned short int channel; {D	   int st;o   struct   {      struct itemlist id;i     int eol;   } itmlst;    static char name[64];    short int lgth;*     name[0] = '\0';/   itmlst.id.code = DVI$_DEVNAM;    itmlst.id.length = 64;   itmlst.id.dataptr = name;t   itmlst.id.retlenptr = &lgth;   itmlst.eol = 0; 7   st = sys$getdvi (0, channel, 0, &itmlst, 0, 0, 0, 0);i   if (QIO_ST_FAILED);     fprintf (stderr, "error getting device name %d\n", st);      return (name); } 