F #define	CONVENIENCE_ROUTINES	0	/* Compile routines = 1, else 0	     */P /*=============================================================================  ! 0 ! Program:	CD_PLAYER.C	(Version 1.0 revision 21) ! D ! Author(s)	Gary Boyles (gpb - DEC, Englewood, CO  USA) ! Motif code@ !		Steve Davis (snd - DEC, Greenbelt, MD  USA) ! device control, !							    ! icons  ! Date:		15-JUN-1992				   !  !  ! Modification History:  !  !	Revision	Reason					  Date9 !	--------	-------------------------------------	-------- - !	V1.0 -17	Initially finished		(gpb)	11/21/91 3 !	     -18	Plugged some memory-leaks	(gpb)	01/03/92 7 !	     -19	Modularized things a bit more	(gpb)	06/05/92 / !	     -20	Added the following:		(gpb)	06/15/92 ' !			a) Descending time-remaining scale. - !			b) track-max label to "Track Now Playing" ( !			c) Total play-time printf statement.' !			d) MSF-related convenience routines ) !			   (present for example -- not used). 4 !	     -21	OpenVMS Alpha Port	        (snd)	04/19/95 !			 - fix minor code & syntax !			 - removed the printf % !			 - changed create-scale widget to ) !			   allow for size on both x & y axes. * !			 - adjusted window and widget geometryM !                          for proper appearance @1280x1024x100dpi.           . !			 - retest on DEC3000-M400 OpenVMS AXP V6.1, !			 - retest on VS4000-M60 OpenVMS VAX V6.1+ !			 - re-kit, add VUE$CD command procedure  !              ! Description: ! G !	This program acts as a control panel for a SCSI audio CD player. The  G !	program uses MOTIF toolkit routines to create and manage the display  F !	and its widgets. It creates a workstation window panel with buttons  !	for:             ! < !		eject	= stop playing/enable-eject/eject-caddy from player5 !		stop	= stop the player from playing & enable-eject ? !	    	play	= start playing CD on current track & disable-eject . !	   	pause	= pause/resume the CD-player      ) !		replay  = replay the current selection # !		shuffle = play random selections ; !		exit	= stop playing/enable eject(but don't)/exit program " !		incr	= increment track playing ! !		decr	= decrement track playing  ! A !	The program also creates the following scales/sliders/displays:  !  !		current-track playing !		track-time display ) !		track-time remaining (seconds) display  !		volume control/display " !		channel-balance control/display" !                                 D !  	Note that the volume thumb-wheel on your CD player should be on E !	full-volume, because the slider will only control volume upto what  H !	the thumb-wheel is set to. Note that the volume control slider is onlyD !	for the headphone jack on the front of the drive. The audio output9 !	RCA phono jacks on tabletop CD drives are fixed output.  !                             F !	NOTE: ALL TESTING WAS PERFORMED ON A DEC RRD42 (Sony CDU-541) drive! ! 5 !	Currently the following improvements are necessary: G !	  1)  Better random # generator for shuffle (currently not so random) ? !	  2)  Some error-trapping code		    (currently quite minimal)  ! E !	In the program listing (frontend) refers for the most part to MOTIF B !	routines, and (backend) refers to CD-control routines.  Routines> !	starting with "handle_" are the button/arrow/slider callback !	routines. % !                                     G !	In regard to routines getting executed... it happens via two methods: E !	  1)  Pushing a button or moving the slider (activating a callback) * !	  2)  Via the timer routine "the_timer". !  !	Build Instructions: : !		A command procedure DECW$CD_PLAYER.BLD is used to buildF !	this product on both VAX and AXP. The com file is included with this !	kit. ! G !	The program interfaces to the CD player through the SCSI disk driver. B !	If you assume that the CD-player is device DKB400 then you wouldC !	have to do the following before running the program (with privs): = !                                                             ! !	$ DEFINE DECW$CD_PLAYER DKB400:  !  !	Note: ; !	To change the icon resources for the CD-player, edit your 9 !	"mwm" file (on VMS this is DECW$MWM.DAT).  For example:  !	( !		Mwm*CD*iconImageForeground:	Firebrick% !		Mwm*CD*iconImageBackground:	Yellow  ! N !===========================================================================*/  4 #include <stdio.h>                                  ; #include <Xm/MainW.h>	    	    	/* MainWindow Class	    	*/ 5 #include <Xm/BulletinB.h>		/* BulletinBoard Class		*/ 1 #include <Xm/Frame.h>			/* Frame widget class		*/ + #include <Xm/Label.h>			/* Label class			*/ 1 #include <Xm/PushB.h> 			/* Push-button Class		*/ 1 #include <Xm/RowColumn.h>		/* RowColumn Class		*/ 4 #include <Xm/Scale.h>	    	  	/* Scale class			*/     N /*===============================(Frontend)===================================/ ! Symbolic Constants                             !====================*/ : #define SHOW_CD_TIME		0	/* 1 = show ttl play time on CD	*/,                                             7 #define ICON_LABEL		"Audio"	/* Cd-player Icon label		*/   > #define TIMER_INTERVAL		1000	/* How often?  1000 = 1/second	*/         : #define CD_TRACK_MIN		0	/* Lower limit for track select	*/> #define CD_TRACK_MAX   		99	/* Upper limit for track select	*/  ; #define BALANCE_SCALE_MAX	10	/* Balance max (min = -max)	*/   3 #define VOLUME_OFF		  0	/* Volume Completely Off	*/ 8 #define VOLUME_DEFAULT		200	/* Initial volume-setting	*/? #define VOLUME_MINIMUM		155 	/* Lower limit for volume level	*/ > #define VOLUME_MAXIMUM		255	/* Upper limit for volume level	*/
           2 #define PUSH_BUTTON		0	/* Used in Create_Button	*/1 #define ARROW_LEFT		1	/* Used in Create_Button	*/ 2 #define ARROW_RIGHT		2	/* Used in Create_Button	*/:                                                            #define SHADOW_THICKNESS	4& #define BOTTOM_SHADOW_COLOR		"DimGrey"! #define TOP_SHADOW_COLOR		"White"                  ' #define DEFAULT_FOREGROUND		"Firebrick" + #define DEFAULT_BACKGROUND		"AntiqueWhite3"   9 #define DEF_PUSHBUTTON_BACKGROUND	"Black"		/* Defaults	*/ ) #define DEF_PUSHBUTTON_FOREGROUND	"White" = #define ALT_PUSHBUTTON_BACKGROUND	"Firebrick"	/* Alternate	*/ ; #define ALT_PUSHBUTTON_FOREGROUND	DEF_PUSHBUTTON_FOREGROUND   : #define TRACK_TIME_BACKGROUND		"NavyBlue"                 8 #define TRACK_TIME_FOREGROUND		DEF_PUSHBUTTON_FOREGROUND   #define BUTTON_HEIGHT	  	40  #define BUTTON_WIDTH		100  #define LABEL_HEIGHT		29  , #define ARROW_FOREGROUND		DEFAULT_BACKGROUND, #define ARROW_BACKGROUND		DEFAULT_FOREGROUND  , #define SCALE_FOREGROUND		DEFAULT_FOREGROUND, #define SCALE_BACKGROUND		DEFAULT_BACKGROUND, #define SCALE_TOP_SHADOW		DEFAULT_FOREGROUND0 #define SCALE_BOTTOM_SHADOW 		DEFAULT_FOREGROUND     #define	FALSE			0  #define TRUE			1 #define NOT_USED		-1 #define	VERTICAL_SCALE		1  #define HORIZONTAL_SCALE	2  M /*=========================================================================== 4 ! Define bitmap for the icon used for the cd-player.N !===========================================================================*/
                #define SMALL_ICON_WIDTH	32  #define SMALL_ICON_HEIGHT	32! static	char small_icon_bits[] = { J    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xf8, 0x00,J    0x00, 0x01, 0x08, 0x01, 0x80, 0x00, 0x08, 0x02, 0x80, 0x00, 0x08, 0x04,J    0x80, 0x00, 0x08, 0x04, 0x80, 0x00, 0x08, 0x04, 0x80, 0x00, 0x08, 0x04,J    0x80, 0x00, 0x08, 0x04, 0x80, 0x00, 0x08, 0x04, 0x80, 0x00, 0x08, 0x04,J    0x80, 0x00, 0x08, 0x04, 0x80, 0x00, 0x08, 0x02, 0x00, 0x01, 0x08, 0x01,J    0x00, 0x7e, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,J    0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x00, 0x00, 0x08, 0x80, 0x00,J    0x00, 0x08, 0x80, 0x00, 0x00, 0x08, 0x87, 0x00, 0x00, 0x88, 0x8f, 0x00,J    0x00, 0xc8, 0x9f, 0x00, 0x00, 0xc8, 0x9f, 0x00, 0x00, 0xc8, 0x9f, 0x00,J    0x00, 0x88, 0x8f, 0x00, 0x00, 0x08, 0x87, 0x00, 0x00, 0x08, 0x80, 0x00,3    0x00, 0xf8, 0xff, 0x00, 0x00, 0xf8, 0xff, 0x00}; 
                #define MEDIUM_ICON_WIDTH	50 #define MEDIUM_ICON_HEIGHT	50 " static	char medium_icon_bits[] = {J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0x0f, 0x7c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0x07,J    0x7c, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x7f, 0x8e, 0xff, 0xff, 0xff,J    0xff, 0xf3, 0x7f, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x7f, 0x9e, 0xff,J    0xff, 0xff, 0xff, 0xf3, 0x7f, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x7f,J    0x9e, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x7f, 0x9e, 0xff, 0xff, 0xff, 0xff,J    0xe3, 0x7f, 0x8e, 0xff, 0xff, 0xff, 0xff, 0x07, 0x7c, 0xc0, 0xff, 0xff,J    0xff, 0xff, 0x0f, 0x7c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0x07, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0xc0,J    0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xfc, 0xff, 0xff,J    0xff, 0xc9, 0xff, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xcc, 0xff, 0x3f, 0xff,J    0xff, 0xff, 0x7f, 0xce, 0xff, 0x9f, 0xff, 0xff, 0xff, 0x3f, 0xcf, 0xff,J    0xcf, 0xff, 0xff, 0xff, 0x9f, 0xcf, 0xff, 0x07, 0x00, 0x00, 0x00, 0xc0,J    0xcf, 0xff, 0x07, 0x00, 0x00, 0x00, 0xe0, 0xcf, 0xff, 0xe7, 0xff, 0xff,J    0xff, 0xe7, 0xcf, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xe7, 0xcf, 0xff, 0xe7,J    0xff, 0xff, 0xff, 0xe7, 0xcf, 0xff, 0x67, 0x00, 0x00, 0x00, 0xe7, 0xcf,J    0xff, 0x67, 0xff, 0xff, 0x7f, 0xe7, 0xcf, 0xff, 0x67, 0xff, 0xff, 0x7f,J    0xe7, 0xcf, 0xff, 0x67, 0x00, 0x00, 0x00, 0xe7, 0xcf, 0xff, 0xe7, 0xff,J    0xff, 0xff, 0xe7, 0xe7, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xe7, 0xf3, 0xff,J    0xe7, 0xf9, 0xff, 0x1f, 0xe7, 0xf9, 0xff, 0xe7, 0xf9, 0xff, 0x1c, 0xe7,J    0xfc, 0xff, 0xe7, 0xff, 0xff, 0xff, 0x67, 0xfe, 0xff, 0xe7, 0xff, 0xff,J    0xff, 0x27, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x07,J    0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,    0xff, 0xff}; 
                #define LARGE_ICON_WIDTH	75  #define LARGE_ICON_HEIGHT	75! static	char large_icon_bits[] = { J    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xaa, 0xaa,J    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfa, 0x55, 0x55, 0x55, 0x55,J    0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,J    0xaa, 0xaa, 0xaa, 0xfa, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,J    0x55, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfa,J    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xaa, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xfa, 0xd5, 0x00, 0x00, 0x00,J    0x00, 0x00, 0x00, 0x00, 0x60, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,J    0xaa, 0xaa, 0xaa, 0xfa, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,J    0x65, 0xfd, 0xaa, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xfa,J    0xd5, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x64, 0xfd, 0xaa, 0x2a,J    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xaa, 0xfa, 0xd5, 0x25, 0x00, 0x00,J    0x00, 0x00, 0x00, 0x80, 0x64, 0xfd, 0xaa, 0xea, 0xff, 0xff, 0xff, 0xff,J    0xff, 0xff, 0xaa, 0xfa, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,J    0x65, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfa,J    0xd5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x65, 0xfd, 0xaa, 0x0a,J    0xaa, 0xaa, 0xaa, 0xaa, 0x02, 0x80, 0xaa, 0xfa, 0xd5, 0x65, 0x05, 0x40,J    0x55, 0x55, 0x05, 0x00, 0x65, 0xfd, 0xaa, 0x6a, 0x0a, 0x80, 0xaa, 0xaa,J    0xaa, 0xaa, 0xaa, 0xfa, 0xd5, 0x05, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,J    0x65, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfa,J    0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfd, 0xaa, 0xff,J    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xfa, 0x55, 0x55, 0x55, 0x55,J    0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,J    0xaa, 0xaa, 0xaa, 0xfa, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,J    0x55, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfa,J    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xfd, 0xaa, 0xaa,J    0xfe, 0xff, 0x01, 0xf0, 0xff, 0xaf, 0xaa, 0xfa, 0x55, 0x55, 0xff, 0xff,J    0xff, 0xff, 0xff, 0x5f, 0x55, 0xfd, 0xaa, 0xaa, 0x9f, 0xaa, 0xaa, 0xaa,J    0xaa, 0xbe, 0xaa, 0xfa, 0x55, 0x55, 0x4f, 0x55, 0x01, 0x50, 0x55, 0x3d,J    0x55, 0xfd, 0xaa, 0xaa, 0xa7, 0x2a, 0xbe, 0x82, 0xaa, 0xba, 0xaa, 0xfa,J    0x55, 0x55, 0x53, 0x85, 0x5f, 0x15, 0x54, 0x35, 0x55, 0xfd, 0xaa, 0xaa,J    0xab, 0xea, 0xbf, 0xaa, 0xaa, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0x57, 0xf1,J    0x5f, 0x55, 0x51, 0x35, 0x55, 0xfd, 0xaa, 0xaa, 0xab, 0xfa, 0xbf, 0xaa,J    0xaa, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0x57, 0xfc, 0x5f, 0x55, 0x45, 0x35,J    0x55, 0xfd, 0xaa, 0xaa, 0x2b, 0xfe, 0xbf, 0xaa, 0xaa, 0xba, 0xaa, 0xfa,J    0x55, 0x55, 0x57, 0xff, 0x5f, 0x55, 0x55, 0x35, 0x55, 0xfd, 0xaa, 0xaa,J    0x2b, 0xff, 0xbf, 0xaa, 0x8a, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0x97, 0xff,J    0x5f, 0x55, 0x15, 0x35, 0x55, 0xfd, 0xaa, 0xaa, 0xab, 0xff, 0x07, 0xa8,J    0x2a, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0x97, 0xff, 0xf3, 0x51, 0x55, 0x35,J    0x55, 0xfd, 0xaa, 0xaa, 0xcb, 0xff, 0xf9, 0xa3, 0x2a, 0xba, 0xaa, 0xfa,J    0x55, 0x54, 0xd7, 0xff, 0xfc, 0x47, 0x55, 0x35, 0x55, 0xfd, 0xaa, 0xaa,J    0xcb, 0xff, 0xfe, 0xaf, 0x2a, 0xba, 0xaa, 0xfa, 0x55, 0x54, 0xd7, 0xff,J    0xfe, 0x4f, 0x55, 0x35, 0x55, 0xfd, 0xaa, 0xa8, 0x8b, 0xaa, 0xfe, 0xaf,J    0x3f, 0xba, 0xaa, 0xfa, 0x55, 0x40, 0x57, 0x55, 0xfe, 0xcf, 0x7f, 0x35,J    0x55, 0xfd, 0xaa, 0xaa, 0x8b, 0xaa, 0xfe, 0xef, 0x7f, 0xba, 0xaa, 0xfa,J    0x55, 0x54, 0x57, 0x55, 0xfc, 0xe7, 0x7f, 0x35, 0x55, 0xfd, 0xaa, 0xaa,J    0x8b, 0xaa, 0xf8, 0xf3, 0x7f, 0xba, 0xaa, 0xfa, 0x55, 0x54, 0x17, 0x55,J    0xf1, 0xf9, 0x7f, 0x35, 0x55, 0xfd, 0xaa, 0xaa, 0xab, 0xaa, 0x02, 0xfc,J    0xbf, 0xba, 0xaa, 0xfa, 0x05, 0x54, 0x17, 0x55, 0x55, 0xff, 0x3f, 0x35,J    0x55, 0xfd, 0x02, 0xaa, 0x2b, 0xaa, 0xaa, 0xff, 0x9f, 0xba, 0xaa, 0xfa,J    0x01, 0x54, 0x57, 0x55, 0x55, 0xff, 0x5f, 0x35, 0x55, 0xfd, 0x02, 0xaa,J    0x2b, 0xaa, 0xaa, 0xff, 0xaf, 0xba, 0xaa, 0xfa, 0x05, 0x55, 0x57, 0x55,J    0x55, 0xff, 0x47, 0x35, 0x55, 0xfd, 0xaa, 0xaa, 0xab, 0xa8, 0xaa, 0xff,J    0xab, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0x57, 0x51, 0x55, 0xff, 0x55, 0x35,J    0x55, 0xfd, 0xaa, 0xaa, 0xab, 0xa2, 0xaa, 0xfe, 0xa8, 0xba, 0xaa, 0xfa,J    0x55, 0x55, 0x57, 0x15, 0x55, 0x3f, 0x55, 0x35, 0x55, 0xfd, 0xaa, 0xaa,J    0xab, 0x2a, 0xa8, 0x82, 0xaa, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0x57, 0x55,J    0x01, 0x50, 0x55, 0x35, 0x55, 0xfd, 0xaa, 0xaa, 0xab, 0xaa, 0xaa, 0xaa,J    0xaa, 0xba, 0xaa, 0xfa, 0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,J    0x55, 0xfd, 0xaa, 0xaa, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xaa, 0xfa,J    0x55, 0x55, 0x01, 0x00, 0x00, 0x00, 0x00, 0x40, 0x55, 0xfd, 0xaa, 0xaa,J    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xfa, 0x55, 0x55, 0x55, 0x55,'    0x55, 0x55, 0x55, 0x55, 0x55, 0xfd};     % Pixmap 					/* The CD-player icon		*/ 	 	cd_icon;   
                globalvalue  	IO$_AVAILABLE, 
 	IO$_PACKACK,  	IO$_DIAGNOSE;    N /*================================(Backend)===================================1 !  SCSI Generic Class Driver #Defines & Variables 2 !===============================================*/  H static char	gk_device [] = {"DECW$CD_PLAYER"};                             short    gk_chan;                & /*------------------------------------0 ! CD-ROM SCSI operation command codes           ( !-------------------------------------*/ #define SCSI_STATUS_MASK	0X3E  #define MEDIA_OPCODE		0x1E   #define MODE_SELECT_OPCODE	0X15  #define PAUSE_OPCODE		0X4B #define RESUME_OPCODE		0X4B  #define STOP_OPCODE		0x1B   #define READ_SUBCHAN_OPCODE	0X42: #define READ_TOC_OPCODE		0X43                              #define PLAY_TRACK_OPCODE	0X48$ #define PLAYBACK_CONTROL_OPCODE 0XC9# #define PLAYBACK_STATUS_OPCODE	0XC4    #define READ 1 #define WRITE 0   M                                                                               ' /*  Varibles for saving CD-player state H !======================================*/                               1                                                  t
 static int 	saved_track_time_sec,4 	track_time_sec,			/* Playing time for this track	*/6 	total_tracks	= 0,		/* Total track read off this CD	*/ 	saved_total_tracks = 0,- 	current_track	= 0,		/* Track now playing		*/A< 	saved_current_track = 0,	/* Track we thought was playing	*/6 	random_track	= 0,		/* Track # generated for SHUFFLE*/6 	old_random_track= 0,		/* Saved (old) random_track	*/ 7 	random_total 	= 0,		/* # of random tracks to SHUFFLE*/-1 	current_volume	= 0,		/* Current volume-level		*/n5 	left_volume	= 0,		/* Current left-channel setting	*/l6 	right_volume	= 0,		/* Current right-channel setting*/6 	play_flag 	= FALSE,	/* Flags set/reset by pressing	*/1 	cd_paused	= FALSE,	/* the various pushbuttons	*/s 	saved_cd_paused	= FALSE,b       	shuffle_flag	= FALSE;                     0 static	unsigned int Track_Address[CD_TRACK_MAX];0 			/* Save the start address of each CD track	*/  C static	int	Track_Seconds [CD_TRACK_MAX];                           n8 		      	/* Track time (seconds) for each track on CD	*/                               O /*============================================================================ y !  (Frontend) Routines   !=====================*/  ( void	init_icon();			/* Setup CD icon		*/J                                                                           8 int	String_To_Pixel(),		/* String to Pixel Conversion	*/2 	get_icon_size();		/* Which icon-size is needed	*/  5 Widget	Create_Button(),		/* Create button or arrow	*/a6     	Create_Scale(),			/* Create a horizontal scale	*/( 	Create_Label();			/* Create a label		*/         M /*===========================================================================n# !  (Frontend to Backend) Routines  	# !================================*/&   void6 	handle_eject_button(),		/* EJECT   button callback	*/5 	handle_stop_button(),		/* STOP    button callback	*/y5 	handle_play_button(),		/* START   button callback	*/	6 	handle_pause_button(),		/* PAUSE   button callback	*/7 	handle_replay_button(),		/* REPLAY  button callback	*/m7 	handle_shuffle_button(),	/* SHUFFLE botton callback	*/ 5 	handle_exit_button(),		/* EXIT    button callback	*/r<    	handle_track_decr(),		/* DECRement CD track callback 	*/8 	handle_track_incr(),		/* INCRement CD track callback	*/9 	handle_track_scale(),		/* Track-input slider callback	*/ 8 	handle_time_scale(),		/* Track-time  slider callback	*/> 	handle_volume_scale(),	   	/* Volume-input slider callback	*/< 	handle_balance_scale();		/* Balance-input slider callback*/  M /*===========================================================================n !  Backend Routinesf !==================*/u          void- 	the_timer(),		  	/* Master program timer		*/ 6 	update_track_time(),		/* Update Track-Time Display	*/< 	update_time_scale_max(),	/* Size time-scale to tracktime	*/=     	update_track_info(),	 	/* Update track scale and data	*/r2 	update_track_max(),		/* Update track-max label	*/5 	init_track_scale(),		/* Init track-scale  display	*/q= 	init_volume_and_balance(),	/* Init volume/balance display	*/f= 	set_volume_and_balance(),	/* Set CD volume/balance levels	*/ 3 	reset_pause_button(),		/* Reset label to PAUSE		*/l7 	toggle_pause_label(),		/* Toggle label PAUSE/RESUME	*/ 2 	do_shuffle();			/* Do the actual track shuffle	*/                               6 int	get_random_track();		/* Random number generator	*/    M /*===========================================================================r( !  (Backend) CD-player specific Routines* !=======================================*/@ unsigned int	read_CD_capacity(),	/* # of blocks on current CD	*/6 		read_toc_track();	/* Returns start-addr for track	*/  7 int	read_toc(),	       		/* Get CD table-of-contents	*/h8 	setup_default_block_size(),	/* Set block size = 512		*/- 	play_track(),			/* Play a track on the CD	*/wA 	play_MSF(),                     /* Mins/sec/frame format play	*/ 6 	play_partial_track(),		/* Plays portion of a track	*/% 	pause_cd(),			/* Suspend playing		*/t& 	resume_cd(),			/* Resume  playing		*/) 	stop_unit(),			/* Stop the CD player		*/ # 	eject_cd(),			/* Eject the CD			*/F3 	enable_eject(),			/* Allow manual removal of CD	*/ 6    	disable_eject();		/* Don't allow manual removal	*/  7 void	get_volume(),			/* Get current volume of player	*/ 3 	set_volume(),			/* Set the volume of the player	*/*0 	get_status(),			/* Read CD table-of-contents	*/7 	save_track_time(),		/* Save track-time of CD tracks	*/	#     	bpt();				/* Null Routine			*/<  M /*===========================================================================	 ! VMS specific routinesu !======================*/*  ? int	execute_command();	       	/* Sends the actual SCSI cmds	*/= 		  			/* to the CD-player		*/< void    exit_handler(),			/* Stop CD/Deassign Channel/etc	*/7 	alloc_cd_channel(),    		/* Assigns a channel to CD	*/f6     	dealloc_cd_channel();		/* Deassign CD channel		*/    M /*===========================================================================y !  List of Widgets (Frontend)I !============================*/                                 f Widget                
 	toplevel,
 	main_window,	 	work_area,D 	rc, 	eject_button,
 	stop_button,t
 	play_button,  	pause_button, 	replay_button,  	shuffle_button,
 	exit_button,d 	decrArrow,O 	incrArrow,l 	volume_scale, 	balance_scale,O
 	track_scale,0 	time_scale,
 	trackMax, 	trackTime,  	trackFrame, 	trackLabel, 	timeLabel,o
 	arrowsLabel;   ,                                             O /*===========================================================================*/dO /*===========================================================================*/i /* Other Declarations        !====================*/ 1 static	Display	*display;		/* Holds display id		*/    XtAppContext ctx;_    Pixel	color;        O
 Arg	args[20];	  + int	n;		       		/* Generic arg counter		*/E  G unsigned long int random_number = 1;	/* Holds random numbers required*/n  					/* for SHUFFLE operation	*/=                                                               O /*===========================================================================*/UO /*===========================================================================*/yO /*===========================================================================*/ O /*===========================================================================*/	O /*                             BEGIN MAIN ROUTINE                            */A                      n main(argc, argv)            int argc;                     J                                                                              char **argv;   {O   K   /*=======================================================================D6   ! Create our application shell, and our main window.L   !=======================================================================*/9   toplevel = XtInitialize(		/* Create ApplicationShell	*/e 	"Audio",			/* Name				*/= 	"CD",				/* Class			*/= 	NULL,			  	/* Options			*/ & 	0,	       			/* Number of options		*/! 	&argc,				/* Address of argc		*/  	argv);				/* Arg value			*/    >   main_window = XmCreateMainWindow (	/* Create main-window		*/!       	toplevel,			/* Parent			*/0 	"Main",	 			/* name				*/% 	args, 0);	  		/* args, # of args		*/,     XtManageChild(main_window);0      display = XtDisplay(toplevel);    K   /*=======================================================================,I   ! Create a bulletin-board as our work-area, and manage via a row-column,L   !=======================================================================*/.   n = 0;				/* Set bulletin-board resources	*/*   XtSetArg( args[n], XmNwidth,  745); ++n;*   XtSetArg( args[n], XmNheight, 160); ++n;<   XtSetArg( args[n], XmNresizePolicy, XmRESIZE_NONE); ++n;    /   color = String_To_Pixel (DEFAULT_BACKGROUND);,0   XtSetArg( args[n], XmNbackground, color); ++n;  A   work_area = XmCreateBulletinBoard (	/* Create bulletin-board	*/I 	main_window,			/* Parent			*/ 	"Work",				/* name				*/a$ 	args, n);			/* args, # of args.		*/     XtManageChild(work_area);,               !   n = 0;				/* Init arg count		*/,J   XtSetArg(args[n], XmNorientation, XmHORIZONTAL); ++n;	/* Lay it flat  */E   XtSetArg(args[n], XmNpacking, XmPACK_TIGHT);	++n;	/* How to pack	*/0J   XtSetArg( args[n], XmNspacing, 5);	++n;        /* button interspacing */I   XtSetArg( args[n], XmNx, 170);	++n;        /* button X placement */    0I   XtSetArg( args[n], XmNy, 105); 	++n;        /* button Y placement */   0  /   color = String_To_Pixel (DEFAULT_BACKGROUND);,0   XtSetArg( args[n], XmNbackground, color); ++n;  0<   rc = XmCreateRowColumn (		/* Create row-col widget inst	*/ 	work_area,	   		/* Parent			*/f 	"RowCol",			/* Name				*/( 	args, n);	  		/* Arglist, Arg count		*/     XtManageChild(rc);                  0                   K   /*=======================================================================,6   ! Now create a EJECT (i.e. EJECT the CD) pushbutton.E   !   Inputs:	parent, name/label, PUSH_BUTTON/ARROW_LEFT/ARROW_RIGHT,,<   !		X, Y, height, width, foreground, background, display-idL   !=======================================================================*/G                                                                        e;   eject_button = Create_Button (rc, " EJECT ", PUSH_BUTTON,,< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			DEF_PUSHBUTTON_FOREGROUND,0' 			DEF_PUSHBUTTON_BACKGROUND, display);03   XtManageChild(eject_button);                     0N   XtAddCallback(eject_button, XmNactivateCallback, handle_eject_button, NULL);     K   /*=======================================================================e4   ! Now create a STOP (i.e. STOP the CD) pushbutton.E   !   Inputs:	parent, name/label, PUSH_BUTTON/ARROW_LEFT/ARROW_RIGHT,0<   !		X, Y, height, width, foreground, background, display-idL   !=======================================================================*/G                                                                        ,9   stop_button = Create_Button (rc, " STOP ", PUSH_BUTTON,,< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			DEF_PUSHBUTTON_FOREGROUND,0, 	     		DEF_PUSHBUTTON_BACKGROUND, display);>   XtManageChild(stop_button);                                 L   XtAddCallback(stop_button, XmNactivateCallback, handle_stop_button, NULL);@                                                                   K   /*=======================================================================,%   ! Now create a PLAY  CD pushbutton.,L   !=======================================================================*/                         ;   play_button = Create_Button (rc, "  PLAY  ", PUSH_BUTTON,0< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			DEF_PUSHBUTTON_FOREGROUND,0' 			DEF_PUSHBUTTON_BACKGROUND, display);f   XtManageChild(play_button);,L   XtAddCallback(play_button, XmNactivateCallback, handle_play_button, NULL);3                                                    5  K   /*=======================================================================0@   ! Now create a PAUSE (i.e. pause/resume selection) pushbutton.L   !=======================================================================*/  ;   pause_button = Create_Button (rc, " PAUSE ", PUSH_BUTTON,,< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			DEF_PUSHBUTTON_FOREGROUND,,' 			DEF_PUSHBUTTON_BACKGROUND, display);0   XtManageChild(pause_button);N   XtAddCallback(pause_button, XmNactivateCallback, handle_pause_button, NULL);    K   /*=======================================================================09   ! Now create a REPLAY (i.e. play last song) pushbutton.6L   !=======================================================================*/  ;   replay_button = Create_Button (rc, "REPLAY", PUSH_BUTTON,,< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			DEF_PUSHBUTTON_FOREGROUND,,' 			DEF_PUSHBUTTON_BACKGROUND, display);0   XtManageChild(replay_button);,P   XtAddCallback(replay_button, XmNactivateCallback, handle_replay_button, NULL);                               K   /*=======================================================================    ! Add in SHUFFLE pushbutton.L   !=======================================================================*/"                                   =   shuffle_button = Create_Button (rc, "SHUFFLE", PUSH_BUTTON,5< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			DEF_PUSHBUTTON_FOREGROUND, ' 			DEF_PUSHBUTTON_BACKGROUND, display);,.   XtManageChild(shuffle_button);              P   XtAddCallback(shuffle_button,XmNactivateCallback,handle_shuffle_button, NULL);                                                            K   /*=======================================================================0   ! Add in EXIT pushbutton.0L   !=======================================================================*/"                                   ;   exit_button = Create_Button (rc, "  EXIT  ", PUSH_BUTTON,0< 		       	NOT_USED, NOT_USED, BUTTON_HEIGHT, BUTTON_WIDTH,   			ALT_PUSHBUTTON_FOREGROUND, + 		    	DEF_PUSHBUTTON_BACKGROUND, display);0   XtManageChild(exit_button);,L   XtAddCallback(exit_button, XmNactivateCallback, handle_exit_button, NULL);                                         fK   /*=======================================================================,%   ! Add decrement-track Arrow button.,L   !=======================================================================*/J                                                                           ;   decrArrow = Create_Button (work_area, "DECR", ARROW_LEFT,,&      		   	170, 15, 40, 60,            			ARROW_FOREGROUND, 			ARROW_BACKGROUND, display);%   XtManageChild(decrArrow);          a                               I   XtAddCallback(decrArrow, XmNactivateCallback, handle_track_decr, NULL);0                                         1K   /*=======================================================================,%   ! Add increment-track Arrow button.,L   !=======================================================================*/   <   incrArrow = Create_Button (work_area, "INCR", ARROW_RIGHT, 		 	240, 15, 40, 60, 			ARROW_FOREGROUND, 		 	ARROW_BACKGROUND, display);,  %   XtManageChild(incrArrow);          ,                               I   XtAddCallback(incrArrow, XmNactivateCallback, handle_track_incr, NULL);f0                                                 !                                  0K   /*=======================================================================3B   ! Add a scale widget to show current volume-level set on the CD.B   !   Inputs:	parent, name/label, X, Y, scale-X-size,scale_y_size /   !		scale-min, scale-max, initial scale value,0(   !		foreground color, background color,+   !		bottom shadow color, top shadow color,5   !	    	display-id0   !                            ,G   ! Note:  Start scale at 0, no matter what the actual volume-level minf   !	   value is.L   !=======================================================================*/                 E   volume_scale = Create_Scale (work_area, "Volume", "  Volume Level",n   		0, 1, 130, 20,$   		VOLUME_MINIMUM - VOLUME_MINIMUM,)        		VOLUME_MAXIMUM - VOLUME_MINIMUM,=% 	   	VOLUME_DEFAULT - VOLUME_MINIMUM,=, 	   	DEFAULT_FOREGROUND, DEFAULT_BACKGROUND,0        		BOTTOM_SHADOW_COLOR,  TOP_SHADOW_COLOR, 		HORIZONTAL_SCALE, display);=                              XtManageChild(volume_scale);                               P   XtAddCallback(volume_scale,XmNvalueChangedCallback,handle_volume_scale, NULL);                 L   balance_scale = Create_Scale (work_area, "Balance", "(L)   Balance   (R)",   		0, 75, 130, 20,        O6  		-BALANCE_SCALE_MAX, BALANCE_SCALE_MAX, 0,          , 	   	DEFAULT_FOREGROUND, DEFAULT_BACKGROUND,1        		BOTTOM_SHADOW_COLOR,  TOP_SHADOW_COLOR,	O 		HORIZONTAL_SCALE, display);C                              XtManageChild(balance_scale);C                               8   XtAddCallback(balance_scale , XmNvalueChangedCallback, 		handle_balance_scale, NULL);  *                                           K   /*======================================================================= @   ! Add a scale widget to show current TRACK-SELECTED on the CD.4   !   Inputs:	parent, name/label, X, Y, scale-size, /   !		scale-min, scale-max, initial scale value,t.   !	      	foreground color, background color,+   !		bottom shadow color, top shadow color,s   !	    	display-id          ! 5   !   Note:	Scale can also be used to change track #.cL   !=======================================================================*/                 6   track_scale = Create_Scale (work_area, "This_Track", 		"  Track Now Playing",/   		320, 1, 180, 20,                           r/     		CD_TRACK_MIN, CD_TRACK_MAX, CD_TRACK_MIN,l2       	   	DEFAULT_FOREGROUND, DEFAULT_BACKGROUND,1        		BOTTOM_SHADOW_COLOR,  TOP_SHADOW_COLOR,	i* 		HORIZONTAL_SCALE, display);             %                                      *<   XtManageChild(track_scale);                                                              N   XtAddCallback(track_scale,XmNvalueChangedCallback,handle_track_scale, NULL);  *                                           K   /*=======================================================================c>   ! Add a scale widget to show track-time remaining in secondsL   !=======================================================================*/  A   time_scale = Create_Scale (work_area, "Time_Scale", " Seconds",o.   		650, 1, 80, 20,                              		0, 999, 0,2       	   	DEFAULT_FOREGROUND, DEFAULT_BACKGROUND,1        		BOTTOM_SHADOW_COLOR,  TOP_SHADOW_COLOR,	o* 		HORIZONTAL_SCALE, display);             %                                      	;   XtManageChild(time_scale);                               a                               4   XtAddCallback(time_scale, XmNvalueChangedCallback, 		handle_time_scale, NULL);                  9   timeLabel = Create_Label (work_area, "TL", "Remaining",	'    			650, 76, LABEL_HEIGHT, 85,         			DEFAULT_FOREGROUND,, 			DEFAULT_BACKGROUND, display);                                                 XtManageChild(timeLabel);       4                                                     K   /*=======================================================================o/   ! Add label widgets to display highest track.FA   !   Inputs:	Parent, Name, Actual Label, x,Y, height, width,    a8   !	    	foreground color, background color, display id.L   !=======================================================================*/   n = 0;1   trackMax = Create_Label (work_area, "TM", "99",l 			500, 25, LABEL_HEIGHT, 30,  			DEFAULT_FOREGROUND,, 			DEFAULT_BACKGROUND, display);            	          /   XtManageChild(trackMax);     l4                                                     K   /*=======================================================================f1   ! Add Frame widget to frame the  TRACK-TIME.   rA   !   Inputs:	Parent, Name, Actual Label, x,Y, height, width,    a8   !	    	foreground color, background color, display id.L   !=======================================================================*/                 !   n = 0;					/* Init arg count	*/-7   XtSetArg( args[n], XmNx, 550);	++n;	/* X Location		*/d8   XtSetArg( args[n], XmNy, 20);	 	++n;	/* Y Location		*/	          y?   XtSetArg( args[n], XmNshadowType,		/* Type of frame effect	*/* 		XmSHADOW_ETCHED_IN);	++n;*               G   color = String_To_Pixel (TOP_SHADOW_COLOR);	/* Frame shadow colors	*/_4   XtSetArg( args[n], XmNtopShadowColor, color);	++n;  0   color = String_To_Pixel (BOTTOM_SHADOW_COLOR);7   XtSetArg( args[n], XmNbottomShadowColor, color); ++n;=-                                              =B   XtSetArg( args[n], XmNshadowThickness, SHADOW_THICKNESS+2); ++n;  =>   trackFrame = XmCreateFrame (		/* Create Frame widget inst	*/ 	work_area,	   		/* Parent			*/c 	"tFrame",			/* Name				*/( 	args, n);	  		/* Arglist, Arg count		*/     XtManageChild(trackFrame);  4                                                     K   /*======================================================================= /   ! Add label widgets to display TRACK-TIME.   _A   !   Inputs:	Parent, Name, Actual Label, x,Y, height, width,     8   !	    	foreground color, background color, display id.L   !=======================================================================*/   n = 0;6   trackTime = Create_Label (trackFrame, "L1", "00:00", 			0, 0, LABEL_HEIGHT, 60, 			TRACK_TIME_FOREGROUND,o# 			TRACK_TIME_BACKGROUND, display);u	          r    XtManageChild(trackTime);          K   /*=======================================================================r8   ! Add label widget to add label to track-time display.L   !=======================================================================*/(                                         ;   trackLabel = Create_Label (work_area, "L2", "Track Time",o'    			535, 55, LABEL_HEIGHT, 90,         			DEFAULT_FOREGROUND,, 			DEFAULT_BACKGROUND, display);                                             !   XtManageChild(trackLabel);     s     K   /*=======================================================================*6   ! Add label widget to add label to Incr/Decr Arrows.L   !=======================================================================*/(                                         >   arrowsLabel = Create_Label (work_area, "L3", "Select Track",% 			165, 55, LABEL_HEIGHT, 140,       t      			DEFAULT_FOREGROUND,o, 			DEFAULT_BACKGROUND, display);                                          r"   XtManageChild(arrowsLabel);                             _K   /*=======================================================================aA   ! Now lets realize everything, allocate the CD, setup our timer=B   ! (typically to run once per second), and go into our event loopL   !=======================================================================*/   A   XtRealizeWidget (toplevel);	/* Lets bring all the widgets up	*/t   0   init_icon();			/* Setup the Cd-player icon		*/   :   alloc_cd_channel();		/* Allocate a channel for the CD	*/      setup_default_block_size();e   2   the_timer ();			/* And start the clock timer		*/  @   update_time_scale_max();	/* Make sure time_scale is correct	*/   ;   enable_eject ();		/* Allow eject until unit is started	*/=                    =E   init_volume_and_balance ();	/* Get current volume-levels from CD	*/=, 				/* And set the balance/volume sliders	*/   @   XtMainLoop ();                                                   }=  N /*                              END MAIN ROUTINE                            */N /*==========================================================================*/N /*==========================================================================*/N /*==========================================================================*/N /*==========================================================================*/               N /*============================================================================ !  init_icon Routine.=K !  Initialize/select the CD-reader icon.  The icons that have been includedIK !  in this program are of equal width and height, and the code assumes this,G !  (i.e. if icon changes are made, then coding changes may also have to  !  be made).O !============================================================================*/n                             F void	init_icon()                                                         {a	   int		i,a 		icon_size;5   Arg	      	ArgL [2];                               00   Window	icon_window_id = XtWindow(main_window);    2   icon_size = get_icon_size();			/* 0=none set		*/     if (icon_size == 0 ||bA       icon_size < MEDIUM_ICON_WIDTH)	    	/* Use smallest icon	*/=     {=,     cd_icon = XCreateBitmapFromData(display,     			icon_window_id,)     			small_icon_bits,                        			SMALL_ICON_WIDTH,     			SMALL_ICON_HEIGHT);     },   else     {)<     if (icon_size < LARGE_ICON_WIDTH)		/* Use medium icon	*/       { .       cd_icon = XCreateBitmapFromData(display,     			icon_window_id,*     			medium_icon_bits,                         			MEDIUM_ICON_WIDTH,e     			MEDIUM_ICON_HEIGHT);_       }	#     else					/* Use largest icon	*/	       {g.       cd_icon = XCreateBitmapFromData(display,     			icon_window_id,-     		    	large_icon_bits,                          			LARGE_ICON_WIDTH,     			LARGE_ICON_HEIGHT);       }l     }      i = 0;C   XtSetArg (ArgL[i], XmNiconPixmap, cd_icon);	i++;	/* Set PIXMAP	*/gC   XtSetArg (ArgL[i], XmNiconName, ICON_LABEL);	i++;	/* And label	*/t"   XtSetValues (toplevel, ArgL, i);       % }                                             XN /*============================================================================ !  get_icon_size Routine. B !  Get the size of the icon in-use.  Return the largest dimension.O !============================================================================*/"   int get_icon_size ()   {g   XIconSize	*size_list;g   int		num_sizes,a	 		status;c4   Window	root_window = XDefaultRootWindow (display);  H   status = XGetIconSizes (display, root_window, &size_list, &num_sizes);  3   if (status == 0)			/* If no icon-size set then	*/n+     {					/* return 0.  Otherwise return	*/E/     return 0;				/* the greater dimension...	*/r)     }					/* icon-width or icon-height	*/=   else     {=5     if (size_list->max_width > size_list->max_height)        { "       return size_list->max_width;"       }                                else       { #       return size_list->max_height;O       }O     }   T }H                            FN /*============================================================================ ! Create_Button Routine.I ! Routine to create the Push or Arrow Buttons on the CD.  The widget-namej? ! is returned.  Note that X & Y locations are only used if > 0.=O !============================================================================*/s   Widget Create_Button (* 	Widget 	theParent,		/* Name of parent		*/+ 	char	theName[],		/* Name of the button		*/u1 	int	button_type,		/* Push or Arrow left/right	*/=/        	int	xLoc,			/* X location in window		*/=( 	int	yLoc,			/* Y location in window		*/5 	int    	height,			/* Height (in pixels) of button	*/a7        	int	width, 			/* Width (in pixels) of button	*/D, 	char	f_color[],  		/* Foreground color 		*/+ 	char	b_color[], 		/* Background color 		*/H& 	Display *dpy)			/* Display id			*/   %                                        {	.   Widget	wgt;			/* Widget instance produced	*/4   Pixel		color;			/* Pixel color fore/back ground	*/*   Arg	   	ArgL[20];		/* Argument list	 	*/	   int		i;   !   i = 0;				/* Init arg count		*/=6                                                          if (xLoc > NOT_USED) {C     XtSetArg( ArgL[i], XmNx, xLoc); ++i;	/* X position for button*/=   }      if (yLoc > NOT_USED) {C     XtSetArg( ArgL[i], XmNy, yLoc); ++i;	/* Y position for button*/O   }D   F   XtSetArg( ArgL[i], XmNheight, height); ++i;	/* Height (in pixels)	*/D   XtSetArg( ArgL[i], XmNwidth, width); ++i;	/* Width  (in pixels)	*/   =   color = String_To_Pixel (f_color);		/* Get (pixel) color	*/uJ   XtSetArg( ArgL[i], XmNforeground,color); ++i;	/* Set foreground color	*/)                                          =>   color = String_To_Pixel (b_color);		/* Get (pixel) color 	*/J   XtSetArg( ArgL[i], XmNbackground,color); ++i;	/* Set background color	*/                        =0   color = String_To_Pixel (BOTTOM_SHADOW_COLOR);7   XtSetArg( ArgL[i], XmNbottomShadowColor, color); ++i;H                        	-   color = String_To_Pixel (TOP_SHADOW_COLOR);_4   XtSetArg( ArgL[i], XmNtopShadowColor, color); ++i;  @   XtSetArg( ArgL[i], XmNshadowThickness, SHADOW_THICKNESS); ++i;   2   XtSetArg( ArgL[i], XmNrecomputeSize, True); ++i;                      ==   if (button_type == PUSH_BUTTON)	/* Standard PushButton?		*/u     {					/*   (Yes)			*/=9       wgt = XmCreatePushButton(			/* Create Pushbutton	*//"       	theParent,				/* Parent		*/       	theName,				/* Name			*/ . 	ArgL, i);		   	     	/* Arglist, Arg count	*/     }    else					/*   (No)			*/U*     {					/*   Must be an Arrow Button.	*/A       if (button_type == ARROW_RIGHT) 		/* set RIGHT direction	*/, 	{( 	  XtSetArg( ArgL[i], XmNarrowDirection,  		XmARROW_RIGHT); ++i;           	}   *       else					/* (or)			*/=& 	{      					/* set LEFT  direction	*/( 	  XtSetArg( ArgL[i], XmNarrowDirection, 		XmARROW_LEFT); ++i;    = 	} = 						/* (Now)		*/;       wgt = XmCreateArrowButton(		/* Create Arrow Button	*/l 	theParent,				/* Parent		*/       	theName,				/* Name			*/ . 	ArgL, i);	   	     		/* Arglist, Arg count	*/     }	  1   return(wgt);				/* Return pushbutton/widget.	*/R }   !                                  _N /*============================================================================ ! Create_Scale Routine. > ! Add a scale widget to show current TRACK-SELECTED on the CD.: !   Inputs:	parent, name, title/label, X, Y, Xsize, Ysize,- !		scale-min, scale-max, initial scale value,  !		bg color, fg color,) !		bottom shadow color, top shadow color,= ! 	     	display-id O !============================================================================*/0                  Widget Create_Scale (   ) 	Widget	theParent,		/* Name of parent		*/R+ 	char	theLabel[],		/* Name of the scale		*/p1 	char	theTitle[],		/* Title/label of the scale	*/b*   	int	xLoc,			/* X location in window		*/( 	int	yLoc,			/* Y location in window		*/7        	int	sXSize,			/* Width of the scale (pixels)	*/=7        	int	sYSize,			/* Heightof the scale (pixels)	*/m' 	int	sMin,			/* Scale minimum value		*/=' 	int	sMax,			/* Scale maximum value		*/=( 	int	sInit,			/* Scale initial value		*/- 	char	sf_color[],  		/* Foreground color 		*/ , 	char	sb_color[], 		/* Background color 		*/. 	char	bs_color[], 		/* Bottom shadow color		*/. 	char	ts_color[], 		/* Top    shadow color		*/1 	int	s_orientation,		/* vertical or horizontal	*/ # 	Display *dpy)			/* Display id			*/     {	.   Widget	wgt;			/* Widget instance produced	*/%   Pixel		color;			/* Pixel color			*/ 4   XmString	Ctitle;			/* Compound-string for title	*/*   Arg	   	ArgL[20];		/* Argument list	 	*/	   int		i;d  !   i = 0;				/* Init arg count		*/=+                                            =A   XtSetArg( ArgL[i], XmNsensitive, True); ++i;	/* Allow input		*/r   B   XtSetArg( ArgL[i], XmNx, xLoc); ++i;	/* X position for scale.	*/B   XtSetArg( ArgL[i], XmNy, yLoc); ++i;	/* Y position for scale.	*/'                                        tC   XtSetArg( ArgL[i], XmNscaleWidth, sXSize); ++i;/* scale Width		*/fD   XtSetArg( ArgL[i], XmNscaleHeight, sYSize); ++i;/* scale Height	*/B   XtSetArg( ArgL[i], XmNshowValue, True); ++i;	/* Do show value	*/                                d=   XtSetArg( ArgL[i], XmNminimum, sMin);	++i;	/* Min scale		*/ =   XtSetArg( ArgL[i], XmNmaximum, sMax); ++i;	/* Max scale		*/ G   XtSetArg( ArgL[i], XmNvalue,  sInit);	++i;	/* Initital scale value	*/,  >   color = String_To_Pixel (sf_color);		/* Get (pixel) color	*/J   XtSetArg( ArgL[i], XmNforeground,color); ++i;	/* Set foreground color	*/  ?   color = String_To_Pixel (sb_color);		/* Get (pixel) color 	*/iJ   XtSetArg( ArgL[i], XmNbackground,color); ++i;	/* Set background color	*/  ?   color = String_To_Pixel (bs_color);		/* Get (pixel) color 	*/V6   XtSetArg( ArgL[i], XmNbottomShadowColor,color); ++i;  M?   color = String_To_Pixel (ts_color);		/* Get (pixel) color 	*/M3   XtSetArg( ArgL[i], XmNtopShadowColor,color);	++i;UA   XtSetArg( ArgL[i], XmNshadowThickness, SHADOW_THICKNESS);  ++i;T                          TD   Ctitle = XmStringCreateSimple (theTitle);	/* Compound-str title	*/I   XtSetArg( ArgL[i], XmNtitleString, Ctitle); ++i;  /* Set Scale title	*/N  :   if (s_orientation == VERTICAL_SCALE)                         { 8     XtSetArg( ArgL[i], XmNorientation, XmVERTICAL);	++i;     }e   else     {,:     XtSetArg( ArgL[i], XmNorientation, XmHORIZONTAL);	++i;     },2                                                   -   wgt = XmCreateScale(			/* Create Scale			*/_(       	theParent,			/* Parent			*/      &       	theLabel,			/* Name				*/      / 	ArgL, i);		   	/* Arglist, Arg count		*/         9   XmStringFree (Ctitle);		/* Free up memory for title 	*/         b,   return(wgt);				/* Return scale/widget		*/) }                                        =        =                         N /*============================================================================ ! Create_Label Routine.t2 ! Add a label widget.  Inputs to this routine are:L !   Parent, Name of widget, Label, X, Y, height, width, colors & display-id.O !============================================================================*/    Widget Create_Label (   +   	Widget	theParent,		/* Name of parent		*/=, 	char  	theName[],		/* Name of the label		*/, 	char	theLabel[],		/* Text for the label		*// 	int	xLoc,	       		/* X location in window		*/a-      	int	yLoc,			/* Y location in window		*/ & 	int	height,			/* height of label.		*/)   	int	width,			/* width of the label		*/F, 	char	f_color[],  		/* Foreground color 		*/+ 	char	b_color[], 		/* Background color 		*/	# 	Display *dpy)			/* Display id			*/  {	.   Widget	wgt;			/* Widget instance produced	*/%   Pixel		color;			/* Pixel color			*/ 0   XmString	Clabel;			/* Compound-string label	*//   Arg	   	ArgL[10];     		/* Argument list	 	*/a	   int		i;s     i = 0;  $   color = String_To_Pixel (f_color);0   XtSetArg( ArgL[i], XmNforeground, color); ++i;%                                       $   color = String_To_Pixel (b_color);0   XtSetArg( ArgL[i], XmNbackground, color); ++i;        =;   XtSetArg( ArgL[i], XmNx, xLoc);  ++i;		/* X position 		*/t;   XtSetArg( ArgL[i], XmNy, yLoc);  ++i;		/* Y position 		*/0E   XtSetArg( ArgL[i], XmNheight, height);++i;	/* Height (in pixels)	*/RD   XtSetArg( ArgL[i], XmNwidth, width);	++i;	/* Width  (in pixels)	*/                        S2   XtSetArg( ArgL[i], XmNlabelType, XmSTRING); ++i;  D   Clabel = XmStringCreateSimple (theLabel);	/* Compound-str label	*/C   XtSetArg( ArgL[i], XmNlabelString, Clabel); ++i;	/* Set string	*/m        n;   wgt = XmCreateLabel(			/* Create Label Widget instance	*/ # 	theParent,	       		/* Parent			*/,'        	theName,		       	/* Name				*/L& 	ArgL, i);			/* Arglist, Arg count		*/  :   XmStringFree (Clabel);		/* Free up memory from string	*/  ,   return(wgt);				/* Return Label widget		*/ }        N /*============================================================================ ! String_To_Pixel Routine.? ! This routine returns a pixel value when passed a named color.t; !   Note:  Variable "display" has been previously declared.,O !============================================================================*/=   String_To_Pixel(char *spec)=   {=   int i;   Colormap cmap;               r    x   XColor color_struct;  ;   cmap = XDefaultColormap(display, DefaultScreen(display));R  9   i    = XParseColor(display, cmap, spec, &color_struct); 3   i    = XAllocColor(display, cmap, &color_struct);                               return(color_struct.pixel);= }=  '                                        =N /*============================================================================= ! handle_eject_button Routine.  Eject the current cd playing.gO !============================================================================*/=*                                           ! void handle_eject_button(        a   	Widget wgt,     	caddr_t client_data,0"   	XmAnyCallbackStruct *call_data) { 9   play_flag 	= FALSE;	/* Set flag to show not started		*/ -   cd_paused	= FALSE;	/* CD is not paused			*/r3   shuffle_flag	= FALSE;	/* Not in shuffle mode			*/ 6   enable_eject();		/* Allow the CD to program-eject	*/4   stop_unit();			/* Spin down the CD (if playing)	*/%   eject_cd();			/* Eject the CD				*/t@   reset_pause_button();		/* Set label to PAUSE & flag = FALSE	*/=   init_track_scale();		/* Init "track now playing" display	*/  }   *                                           N /*============================================================================; ! handle_stop_button Routine.  Stop the current cd playing.eO !============================================================================*/r*                                            void handle_stop_button(   	Widget wgt,     	caddr_t client_data,=E   	XmAnyCallbackStruct *call_data)                                   T {.9   play_flag 	= FALSE;	/* Set flag to show not started		*/,-   cd_paused	= FALSE;	/* CD is not paused			*/o3   shuffle_flag	= FALSE;	/* Not in shuffle mode			*/=4   stop_unit();			/* Spin down the CD (if playing)	*/@   reset_pause_button();		/* Set label to PAUSE & flag = FALSE	*//   enable_eject();		/* Allow  removal of CD			*/  }          _  
           N /*============================================================================3 ! handle_play_button Routine.  Start CD on track 1.=O !============================================================================*/=*                                            void handle_play_button( 	Widget wgt,     	caddr_t client_data,b  	XmAnyCallbackStruct *call_data)9 {                                                         9   play_flag 	= TRUE;		/* Set flag to show now-playing		*/ -   cd_paused	= FALSE;	/* CD is not paused			*/t3   shuffle_flag	= FALSE;	/* Not in shuffle mode			*/=:   reset_pause_button();		/* Make sure CD is not paused		*/8   get_status();			/* Get information about current CD	*/C   XmScaleGetValue (track_scale, &current_track);  /* Get track #	*/=9   play_track(current_track);	/* Start the CD playing			*/aE   set_volume_and_balance();	/* Set volume and balance levels on CD	*/_-   disable_eject();		/* Disable CD eject.			*/DB   update_time_scale_max();	/* Set time-scale to correct setting	*/ }   
           N /*============================================================================ ! handle_pause_button Routine.L ! Pause the current CD, and change the button label from "PAUSE" to "RESUME"G ! (or) if on "RESUME" then start CD and change button label to "PAUSE".nO !============================================================================*/=*                                            void handle_pause_button(* 	Widget wgt,6     	caddr_t client_data,                               	XmAnyCallbackStruct *call_data) {      if (play_flag  == TRUE)a     {                       :     if (cd_paused == FALSE)	/* Were we paused already?		*/       {				/* (No)					*/ *       cd_paused = TRUE;		/* Set Flag				*/:       toggle_pause_label();	/* Change the button label		*/2       pause_cd();		/* Send PAUSE command to CD		*/       } "     else                          0       {				/* (Yes -- we were paused already)	*//       cd_paused = FALSE;	/* Reset the flag			*/ :       toggle_pause_label();	/* Change the button label		*/4       resume_cd();		/* Send RESUME command to CD		*/       }=     }= }   
           N /*============================================================================D ! handle_replay_button Routine.  Replay the current track on the CD.O !============================================================================*/=*                                            void handle_replay_button( 	Widget wgt,     	caddr_t client_data,=  	XmAnyCallbackStruct *call_data)   {                    -  4   shuffle_flag = FALSE;		/* Not in shuffle mode			*/  .   if (play_flag  = TRUE && cd_paused == FALSE)     {aB     play_track(current_track);	/* Play the current track again		*/G     set_volume_and_balance();	/* Set volume and balance levels on CD	*/=2     disable_eject();		/* Disable removal of CD		*/     }  }      
           N /*============================================================================# ! handle_shuffle_button Routine.    K ! Play tracks in a random order.  Keep playing in a random order until somew? ! other button is pushed, or until total_tracks * n are played.fN !===========================================================================*/*                                           C void handle_shuffle_button(                                          	Widget wgt,0     	caddr_t client_data,                         	XmAnyCallbackStruct *call_data)   {     1   if (play_flag  == TRUE && cd_paused == FALSE)        {        shuffle_flag = TRUE;0       do_shuffle();			/* Play a random track		*/     }_ }n                 
           M /*===========================================================================/8 ! handle_exit_button Routine.  Used to exit the program.N !===========================================================================*/*                                            void handle_exit_button( 	Widget wgt,%     	caddr_t client_data,            X  	XmAnyCallbackStruct *call_data)                                , {NE     XtCloseDisplay(XtDisplay(wgt));	/* Get rid of CD panel display	*/A1     enable_eject();			/* Allow the CD to eject	*/ 5     stop_unit();			/* Stop Playing                 */=6     dealloc_cd_channel();		/* Deassign the channel		*/     exit(0);				/* Bye-Bye			*/e }o    N /*============================================================================ ! handle_track_decr Routine.J ! Callback for the << arrow button.  Decrement the track count by one, andI ! update the display.  If track count is less than track-min, then set to  ! track-max.O !============================================================================*/)   void handle_track_decr 	(n 	Widget wgt, 	caddr_t client_data,s"   	XmAnyCallbackStruct *call_data)                             ! {                                t    int	this_track,                	next_track;                        t4   shuffle_flag = FALSE;			/* Not in shuffle-mode		*/                         1   if (play_flag  == TRUE && cd_paused == FALSE)  a     {t1       XmScaleGetValue (track_scale, &this_track); !                                  ="       next_track = --this_track;           if (next_track < 1)o         {           %           next_track = total_tracks;	t         }     ,                                             :       play_track (next_track);		/* Start track playing		*/A       set_volume_and_balance();		/* Set vol & bal levels on CD	*/_     }                  e }	    N /*============================================================================2 ! handle_track_incr Routine.                      J ! Callback for the >> arrow button.  Increment the track count by one, andL ! update the select-track display. If track count is greater than track-max, ! then set to track-min.O !============================================================================*/a                        s void handle_track_incr	(  . 	Widget	wgt,                                   	caddr_t	client_data,W  	XmAnyCallbackStruct	*call_data)                    c! {                                	    int 	this_track,               	next_track;  4   shuffle_flag = FALSE;			/* Hot in shuffle-mode		*/               1   if (play_flag  == TRUE && cd_paused == FALSE)  t     { 1       XmScaleGetValue (track_scale, &this_track);*   "       next_track = this_track + 1;  $       if (next_track > total_tracks)	         {n           next_track = 1;          }       A       play_track (next_track); 		/* Start track playing	      	*/LA       set_volume_and_balance();		/* Set vol & bal levels on CD	*/      }T }i                        i  N /*============================================================================2 ! handle_time_scale Routine.                      ' ! Callback for track-time slider input.*O !============================================================================*/c   void handle_time_scale (  . 	Widget	wgt,                                   	caddr_t	client_data,A  	XmAnyCallbackStruct	*call_data)                       ! {                                T   }                           N /*============================================================================3 ! handle_track_scale Routine.                      gH ! Callback for track-slider input.  Get new slider value, and update theN ! CD playing.  This allows the slider to be used for input, as well as output.O !============================================================================*/	        void handle_track_scale (  /. 	Widget	wgt,                                   	caddr_t	client_data,   	XmAnyCallbackStruct	*call_data)                       ! {                                =   int	this_track;s  4   shuffle_flag = FALSE;			/* Hot in shuffle-mode		*/  1   if (play_flag  == TRUE && cd_paused == FALSE)  *     {             1       XmScaleGetValue (track_scale, &this_track); :       play_track (this_track);		/* Start track playing		*/A       set_volume_and_balance();		/* Set vol & bal levels on CD	*/(     }e }       N /*============================================================================4 ! handle_volume_scale Routine.                      J ! Callback for volume-slider input.  Get the slider-value from the displayH ! panel, and update the actual volume-level in the cd-player.  Note thatL ! the volume-slider starts at 0 (i.e. VOLUME_DEFAULT - VOLUME_MINIMUM) whileC ! the actual volume-level put into the CD starts at VOLUME_MINIMUM.eO !============================================================================*/o                    o void handle_volume_scale (  . 	Widget	wgt,                                   	caddr_t	client_data,="   	XmAnyCallbackStruct	*call_data)  ! {                                l=   set_volume_and_balance();		/* Set vol & bal levels on CD	*/b }     N /*============================================================================5 ! handle_balance_scale Routine.                      /K ! Callback for balance-slider input.  Get the slider-value from the displayl@ ! panel, and set the balance between the left and right channels ! (i.e. channels 0 & 1).O !============================================================================*/i                    a void handle_balance_scale (  c. 	Widget	wgt,                                   	caddr_t	client_data,r"   	XmAnyCallbackStruct	*call_data)
           7 {                                                       =   set_volume_and_balance();		/* Set vol & bal levels on CD	*/  }      N /*============================================================================ ! the_timer Routine.I ! This routine is a timer which runs, gets the track-time status, updatessG ! the track-time, and then registers itself as a timeout callback to be J ! called again.  This routine is executed once every TIMER_INTERVAL, which  ! is typically every one second. ! D ! The routine also handles automatic track SHUFFLE after the initial ! button-press.) ! G ! Note:	The CD-player will automatically go to the next track after the $ !	current track is finished playing.O !============================================================================*/;        void the_timer ()A                            u {                     7   if (shuffle_flag == TRUE)			/* Are we shuffling CD	*/i$     {						/* (yes)... did the CD	*/C       if (current_track != random_track)	/* player shift to next	*/ '         {					/* track? (yes)... get	*/	1         do_shuffle();				/* another random one	*/g?         random_total = random_total + 1;	/* BUT... let's not	*/iA         if (random_total >= total_tracks*4)	/* play on forever	*/            {                       shuffle_flag = FALSE;            random_total = 0;r           stop_unit();           }           	         }t	     }    e  '   get_status();					/* Get CD status	*/ 4   update_track_info();				/* Inc track/time scale	*/3   update_track_time();				/* and track-time clock*/x,   get_volume();					/* Get current volume	*/A   XtAddTimeOut (TIMER_INTERVAL, the_timer);	/* & reset timeout	*/A }       S  N /*============================================================================ ! update_track_time Routine.A ! This is the common routine for updating the track-time display.eG ! It is called by the one second timer routine as well as by the button E ! callback routines. If the player state has changed, then update thel+ ! appropriate button/slider on the display.tO !============================================================================*/              J void update_track_time ()                                                                   , { =   Arg		ArgL[5];                                                  char		track_time_char[6];e   XmString	the_track_time;   int		track_time_min, 		time_remaining,t 		max_time,g   		i = 0;           I   /*======================================================================I   ! 1st lets update the track-time display                               eI   !====================================================================*/a  < 	track_time_min = track_time_sec / 60;	/* Figure out time	*/1 	track_time_char [0] = track_time_min / 10 + '0';=1 	track_time_char [1] = track_time_min % 10 + '0';t 	track_time_char [2] = ':';r8 	track_time_char [3] = (track_time_sec % 60) / 10 + '0';8 	track_time_char [4] = (track_time_sec % 60) % 10 + '0'; 	track_time_char [5] = '\0';$                                     D 	the_track_time = XmStringCreateSimple (track_time_char);            						/* cvt to compound str	*/   9 	XtSetArg( ArgL[i], XmNlabelString, the_track_time); ++i;   						/* Set arg for new time	*/; 	XtSetValues(trackTime, ArgL, i);	/* Update time-display	*/t                          p5 	XmStringFree (the_track_time);		/* Recover memory	*/m  J    /*=====================================================================!    ! And now the track-time scale J    !====================================================================*/  B 	time_remaining = Track_Seconds [current_track] - track_time_sec ;> 	XmScaleGetValue (time_scale, &max_time);  /* Get scale-max	*/  9 	if (time_remaining > max_time)		/* Make sure we don't	*/i 	  {					/* exceed scale		*/	 	  i = 0;i7 	  XtSetArg( ArgL[i], XmNmaximum, time_remaining); i++;r< 	  XtSetValues(time_scale, ArgL, i);	/* Do display update	*/ 	  }  0   	XmScaleSetValue (time_scale, time_remaining);    }                                                         T0                                                 N /*============================================================================1 ! update_time_scale_max Routine.                  3 ! Update/reset the maximum value on the time_scale. O !============================================================================*/A%                                        void update_time_scale_max()  / {                                              *
   int		i = 0;i   Arg	 	ArgL[5];  *   XtSetArg( ArgL[i], XmNminimum, 0);		++i;*   XtSetArg( ArgL[i], XmNvalue,   0);		++i;  <   if (Track_Seconds[current_track] > 0 && current_track > 0)     {aF     XtSetArg( ArgL[i], XmNmaximum, Track_Seconds[current_track]); ++i;     }=   else     {=-     XtSetArg( ArgL[i], XmNmaximum, 999);	++i;=     }=  ;   XtSetValues(time_scale, ArgL, i);	/* Do display update	*/m }c   N /*============================================================================, ! update_track_max Routine.                 @ ! Update the label that shows the max track # on the current CD.O !============================================================================*/r      e void update_track_max()   / {                                              =	   int		i;=   Arg		ArgL[5];=   char		track_max_char[3];   XmString	the_track_max;.  F   track_max_char[0] = (total_tracks/10) + '0';	/* Stuff into string	*/.   track_max_char[1] = total_tracks % 10 + '0';   track_max_char[2] = '\0';   C   the_track_max = XmStringCreateSimple (track_max_char);           t 						/* cvt to compound str	*/t     i = 0;9   XtSetArg( ArgL[i], XmNlabelString, the_track_max); ++i;r  						/* Set arg for new time	*/=   XtSetValues(trackMax, ArgL, i);		/* Update track-max dpy	*/l               6   XmStringFree (the_track_max);			/* Recover memory	*/ }p                N /*============================================================================- ! update_track_info Routine.                 A5 ! This is the common routine that does the following:n% !   1)  Updates display if necessary. F !   2)  Check to see if old CD has been removed (and updates display).F !   3)  If there is a new CD... we save the track time for each track.O !============================================================================*/=      = void update_track_info()  / {                                              b&   Arg	ArgL[5];			/* Argument list	 	*/'   int	i = 0,				/* Argument counter		*/d- 	this_track;			/* Track # from track_scale	*/     =   /* Make sure track_scale reflects the current track playinge?   !==========================================================*/N-   XmScaleGetValue (track_scale, &this_track);p  "   if (this_track != current_track)     {_1     XmScaleSetValue (track_scale, current_track);      }                         E   /* If the old CD is gone then make sure track-scale max is still ok=G   !==================================================================*/n            aD   if (saved_total_tracks != total_tracks)	/* We've removed old CD	*/     {=+       if (total_tracks == 0)			/* No CD		*/    	{ 	  saved_total_tracks = 0;& 	  init_track_scale();                 	  update_track_max(); 	}     u       else					/* New CD		*/ 	{          % 	  saved_total_tracks = total_tracks;f	 	  i = 0;;;       	  XtSetArg( ArgL[i], XmNmaximum, total_tracks); ++i;/= 	  XtSetValues(track_scale, ArgL, i);	/* Do display update	*/f  6 	  save_track_time ();		/* Save track-time for each	*/% 					/* track on CD (Track_Time[])	*/G8 	  update_track_max();		/* Display total-tracks on CD	*/ 	}     }c! }                                    7                                                         N /*============================================================================ ! init_track_scale Routine..A ! Initialize the scale (i.e. set track-slider to initial values).tO !============================================================================*/=   void init_track_scale ()       {e(   Arg		ArgL[5];  		/* Argument list	 	*/$   int		i, 			/* Argument counter		*/* 		track_max;		/* Top-end for the scale.	*/     i = 0;   C   if (total_tracks > CD_TRACK_MIN)	/* If there's a CD mounted...	*/=(     {					/* then use its track-count	*/;       track_max = total_tracks;		/* to define the scale		*/_     }*   else     {        track_max = CD_TRACK_MAX;      }                X                      l   /* Update scale	*/   /*====================*/6     XtSetArg( ArgL[i], XmNminimum, CD_TRACK_MIN);	++i;8     XtSetArg( ArgL[i], XmNvalue,   CD_TRACK_MIN);	++i;  F     XtSetArg( ArgL[i], XmNmaximum, track_max);		++i;                  '     XtSetValues (track_scale, ArgL, i);d!     current_track = CD_TRACK_MIN;/ }                                                    	N /*============================================================================! ! init_volume_and_balance routine)N ! Initialize the balance and volume sliders.  Try and use the current settingsJ ! off of the cd-player itself.  Note:  get_volume() modifies the variables0 ! current_volume, left_volume, and right_volume.O !============================================================================*/=   void init_volume_and_balance ()=   {=   int	L_volume,=
 	R_volume,
 	C_volume, 	balance_setting;   6   get_volume ();  			/* Get values off of cd-player	*/   L_volume = left_volume;a   R_volume = right_volume;   C_volume = current_volume;  A   if (L_volume < VOLUME_MINIMUM)	/* We need default values for	*/=6 	L_volume = VOLUME_DEFAULT;	/* slider calculations		*/      if (R_volume < VOLUME_MINIMUM)!       	R_volume = VOLUME_DEFAULT;l      if (C_volume < VOLUME_MINIMUM)!       	C_volume = VOLUME_DEFAULT;;    7   /*--------------------------------------------------- 5   ! Calculate the correct balance-slider setting from=7   ! the actual volume levels gotten from the cd-player. 9   !----------------------------------------------------*/d   if (L_volume > R_volume)     {n*     balance_setting = -BALANCE_SCALE_MAX +8 			(BALANCE_SCALE_MAX * (R_volume - VOLUME_MINIMUM))/   +     		       	(L_volume  - VOLUME_MINIMUM);      }    else     {      if (L_volume < R_volume)       {               ,       balance_setting = BALANCE_SCALE_MAX - 5 			(BALANCE_SCALE_MAX * (L_volume - VOLUME_MINIMUM))/u% 		     	(R_volume - VOLUME_MINIMUM); a       }     ,     else                                           {U       balance_setting = 0;       }a     }a  7   /*---------------------------------------------------=+   ! Now set the balance and volume sliders.=9   !----------------------------------------------------*/ 3   XmScaleSetValue (balance_scale, balance_setting);=  =   XmScaleSetValue (volume_scale, C_volume - VOLUME_MINIMUM );  }     N /*============================================================================7 ! set_volume_and_balance Routine.                       J ! Get the balance-level, and the volume-level, and set the CD accordingly.H ! Note that the volume is set to (VOLUME_MINIMUM + volume_scale), unless0 ! scale is zero, and then volume is set to zero. ! (i.e. channels 0 & 1).O !============================================================================*/   ' void set_volume_and_balance()          =   {= int	new_balance, 	new_volume,
 	L_volume,
 	R_volume;  A   XmScaleGetValue (volume_scale,  &new_volume);		/* Get volume	*/b  9   if (new_volume == 0)			/* If scale is 0... then turn	*/n&     {					/* volume all the way off	*/      current_volume = VOLUME_OFF;      left_volume    = VOLUME_OFF;      right_volume   = VOLUME_OFF;     }n,   else					/* Else set to minimum + scale	*/     { 1     current_volume = new_volume + VOLUME_MINIMUM;   D     XmScaleGetValue (balance_scale, &new_balance);	/* Get balance	*/  =     if (new_balance <= 0)		/* Convert to volume levels for	*/*)       {					/* left and right channels	*/ 6       L_volume = current_volume;                      !       R_volume = current_volume +t(   	 	(((current_volume - VOLUME_MINIMUM)& 		* new_balance)/ BALANCE_SCALE_MAX );       }       3     else                                                   { !       L_volume = current_volume - '   		(((current_volume - VOLUME_MINIMUM) & 		* new_balance)/ BALANCE_SCALE_MAX );6       R_volume = current_volume;                             }	<     left_volume = L_volume;		/* Save left-channel  volume	*/<     right_volume= R_volume;		/* Save right-channel volume	*/     }=  H   set_volume(left_volume, right_volume);/* Go out and actually change	*/& 					/* the volume on the CD-player	*/   }t      u      nN /*============================================================================ ! reset_pause_button Routine. J ! Reset the PAUSE button (i.e. make sure it says PAUSE, and make sure that ! "cd_paused" is set to FALSE.O !============================================================================*/r    void reset_pause_button ()   {t4   Pixel		color;			/* Needed for changing bg color	*/7   XmString	Cpause;			/* Compound-str for pause label	*/_)   Arg	   	ArgL[5];		/* Argument list	 	*/i"   int		i;     			/* Arg count			*/  (   i = 0;	       			/* Init arg count		*/                   )   cd_paused = FALSE;			/* Reset flag			*/)P   color = String_To_Pixel (DEF_PUSHBUTTON_BACKGROUND); /* Get (pixel) color*/   B   XtSetArg( ArgL[i], XmNbackground,color); ++i;	/* Reset color		*/F   Cpause = XmStringCreateSimple (" PAUSE ");	/* Cvt to compound-str	*/J   XtSetArg( ArgL[i], XmNlabelString, Cpause); ++i;  /* Reset to "PAUSE"	*/A   XtSetValues (pause_button, ArgL, i);		/* Actually do changes	*/=4   XmStringFree (Cpause);			/* Free memory for str	*/ }          N /*============================================================================ ! toggle_pause_label Routine.=C ! Change the pause button from PAUSE to RESUME, or RESUME to PAUSE.,O !============================================================================*/*    void toggle_pause_label ()                              { 4   Pixel		color;			/* Needed for changing bg color	*/4   XmString	Clabel;			/* Compound string for label	*//   Arg	   	ArgL[5];	      	/* Argument list	 	*/ $   int		i;		       	/* Arg count			*/    (   i = 0;	       			/* Init arg count		*/     if (cd_paused == FALSE)s     {                fJ       color = String_To_Pixel (DEF_PUSHBUTTON_BACKGROUND);/* Get color 	*/C       XtSetArg( ArgL[i], XmNbackground,color); ++i;	/* Set color	*/ A       Clabel = XmStringCreateSimple (" PAUSE ");	/* Create str	*/_F       XtSetArg( ArgL[i], XmNlabelString, Clabel); ++i;	/* Set label	*/     }    else     {                sJ       color = String_To_Pixel (ALT_PUSHBUTTON_BACKGROUND);/* Get  color	*/C       XtSetArg( ArgL[i], XmNbackground,color); ++i;	/* Set color	*/ A       Clabel = XmStringCreateSimple ("RESUME");		/* Create str	*/sF       XtSetArg( ArgL[i], XmNlabelString, Clabel); ++i;	/* Set label	*/     }o  A   XtSetValues (pause_button, ArgL, i);		/* Actually do changes	*/=4   XmStringFree (Clabel);			/* Free memory for str	*/ } #                                       N /*============================================================================ ! do_shuffle Routine.dI ! Get a random track between 1 and total_tracks.  Set the current track #eI ! to that track, and then play the current_track.  Only do a shuffle if al ! CD in the player.eO !============================================================================*/=  $ void	do_shuffle ()                     {   /   if (total_tracks > 0)				/* Is CD present?	*/      { =     random_track = get_random_track();		/* Get any track #	*/aE     while (random_track == old_random_track)	/* Make sure it's not	*/e"       {						/* the one we just	*/6       random_track = get_random_track();	/* played		*/       } 5     play_track (random_track);		/* Play the track		*/s?     set_volume_and_balance();		/* Set vol & bal levels on CD	*/e9     old_random_track = random_track;	/* Save track #			*/a<     current_track = random_track;	/* Set current-track #		*/   }n }s                                    N /*============================================================================ ! get_random_track Routine. ; ! Routine which returns a random track number between 1 andnJ ! total_tracks.  Note:  We need a better random # generator (but not now).O !============================================================================*/   I int get_random_track()                                                   =                   0 {                                               J   random_number = (random_number/(current_track+1))                        			* 1103515245 + 12345;D   return (((unsigned int) (random_number/65536) % total_tracks)+1);  }e    N /*============================================================================# ! setup_default_block_size Routine.F> ! This routine changes the default block size of the CD player; ! to 512 bytes and is required for correct callibration of n> ! the track time. The mode select command is tried three times? ! because if the device has just been reset, the first two willt5 ! fail.                                               O !============================================================================*/y   int setup_default_block_size()    {                         J   char	mode_select_command [6]	=  {MODE_SELECT_OPCODE, 0x10, 0, 0, 12, 0},> 	mode_select_data [12]	= {0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 2, 0};   int i, status;=                                                              r   for (i=0; i<3; i++)v"     {                             1   	status = execute_command (mode_select_command,l'     			6, mode_select_data, 12, WRITE);      	if (status) return status;      	bpt ();     }	       return status;     }       N /*============================================================================ ! read_toc Routine.eE ! This routine reads the table of contents on the CD to determine theL ! total number of tracks.mO !============================================================================*/=   int read_toc ()=   {p   int	TTL_tracks = 0,.
   	status;     char	read_toc_command [10] =/ 		{READ_TOC_OPCODE, 0, 0, 0, 0, 0, 0, 0, 4, 0};    char	toc_data[4];a  A   if (!execute_command (read_toc_command, 10, toc_data, 4, READ))s     {d1     TTL_tracks = 0;    				/* No CD is present	*/t     }l   else  /     TTL_tracks = toc_data[3] - toc_data[2] + 1;=     return TTL_tracks;
 }                                        N /*============================================================================ ! read_toc_track Routine. L ! This routine reads the table of contents on the CD for the specified track< ! and returns the block/address for the start of that track.O !============================================================================*/=                       , unsigned int read_toc_track (int track_num)   8 #define READ_THE_TOC  	0X43                                {=-   unsigned char	read_toc_track_command [12] =k1       {READ_THE_TOC, 0, 0, 0, 0, 0, 0, 0, 12, 0};	+                                            0#   unsigned char	toc_track_data[12];k     int track, status;  4   unsigned int addr1, addr2, addr3, addr4, the_addr;E                                                                      %(   read_toc_track_command[6] = track_num;   /   if (!execute_command (read_toc_track_command,k/ 			12, toc_track_data, 12, READ)) return FALSE;   *   addr4 = toc_track_data[8];              M   addr3 = toc_track_data[9];                                                 r   addr2 = toc_track_data[10];k   addr1 = toc_track_data[11];d  ;   addr4 = addr4 << 24;		/* Do all necessary byte-shifts		*/k   addr3 = addr3 << 16;   addr2 = addr2 << 8;=   ?   the_addr = addr4 + addr3 + addr2 + addr1;	/* Final address	*/d  1   return the_addr;		/* And return the block #		*/=
 }            =     N /*============================================================================ ! save_track_time Routine.I ! This routine saves the track-time for each track of the CD in the array  ! Track_Seconds [].sO !============================================================================*/ + void save_track_time ()                    a   {                         +   unsigned int	track_address[CD_TRACK_MAX],l 		end_of_CD,   		track_units;     int	last_track,  	track, 
 	ttl_CD_secs, 	 	CD_secs, 	 	CD_mins,  	x;   =   last_track = read_toc();		/* Get total # of tracks on CD	*/=    7   /* Save track address for each track on current CD	*/t:   /*====================================================*/1     for (track = 1; track <= last_track; track++)=       {=5       track_address [track] = read_toc_track (track);        }     8   /* Now compute track-time (seconds) for each track)	*/:   /*====================================================*/I     for (track = 1; track <= (last_track - 1); track++)	/* Except last	*/e       {LB       track_units = track_address[track+1] - track_address[track];4       Track_Seconds[track] = track_units / (75 * 4);	       }  ,   3   end_of_CD = read_CD_capacity ();			/* Now last	*/      if (SHOW_CD_TIME == 1)     {u'     ttl_CD_secs	= end_of_CD / (75 * 4);i     CD_mins	= ttl_CD_secs / 60; +     CD_secs	= ttl_CD_secs - (CD_mins * 60);=.     printf ("=========================== \n");?     printf ("Total CD Play Time = %d:%d \n", CD_mins, CD_secs);l     }a     Track_Seconds[last_track] =r; 		(end_of_CD - track_address[last_track]) / (75 * 4);      = }     N /*============================================================================ ! read_CD_capacity Routine. O !============================================================================*/.  unsigned int read_CD_capacity ()   #define CD_CAPACITY		0X25o   {nN   unsigned char	CD_capacity  [10] = {CD_CAPACITY,  0, 0, 0, 0, 0, 0, 0, 0, 0};  <   unsigned char	CD_capacity_data[12];                         4   unsigned int addr1, addr2, addr3, addr4, the_addr;     int x;  rE   if (!execute_command (CD_capacity, 10, CD_capacity_data, 12, READ))t     {      return FALSE;M     }L  @   addr4 = CD_capacity_data[0];		/* Extract the necessary data	*/   addr3 = CD_capacity_data[1];   addr2 = CD_capacity_data[2];   addr1 = CD_capacity_data[3];  .   addr4 = addr4 << 24;				/* Do byte-shifts	*/   addr3 = addr3 << 16;   addr2 = addr2 << 8;h  A   the_addr = addr4 + addr3 + addr2 + addr1;	/* Compute address	*/i   .   return the_addr;				/* return the block #	*/ }s           N /*============================================================================! ! play_track Routine.            =K ! This routine plays the specified track on the CD.                        uO !============================================================================*/L  & int play_track (int track_num)        )                                          	 { 
   int	status;a      char	play_track_command [10] =2 		{PLAY_TRACK_OPCODE, 0, 0, 0, 0, 1, 0, 0,  1, 0};6                                                       %   play_track_command [4] = track_num;i(   play_track_command [7] = total_tracks;?   status = execute_command(play_track_command, 10, 0, 0, READ);    disable_eject();   return status;	I }h    N /*============================================================================ ! pause_cd Routine.=6 ! This routine sends a PAUSE command to the CD-player.O !============================================================================*/_   int pause_cd ()oC {                                                                   I   char	pause_command [10] =   {PAUSE_OPCODE , 0, 0, 0, 0, 0, 0, 0, 0, 0};/  9   return execute_command (pause_command, 10, 0, 0, READ);= };    N /*============================================================================ ! resume_cd Routine.7 ! This routine sends a RESUME command to the CD-player.rO !============================================================================*/(   int resume_cd () {aH   char	resume_command [10] = {RESUME_OPCODE, 0, 0, 0, 0, 0, 0, 0, 1, 0};  :   return execute_command (resume_command, 10, 0, 0, READ); }=       N /*============================================================================ ! stop_unit Routine.6 ! This routine sends a stop command the the CD player.O !============================================================================*/o   int stop_unit()    {                         9   char	stop_command [6] = {STOP_OPCODE  , 0, 0, 0, 0, 0};	  7   return execute_command (stop_command, 6, 0, 0, READ);  }     N /*============================================================================ ! eject_cd Routine.    /; ! This routine sends an eject-cd command the the CD player._O !============================================================================*/X   int eject_cd()   {                         <   char	eject_command [6]   = {STOP_OPCODE  , 0, 0, 0, 2, 0};  8   return execute_command (eject_command, 6, 0, 0, READ); }                          A                    uN /*============================================================================ ! enable_eject Routine.     2 ! This routine enables the manual removal of a CD.O !============================================================================*/=   int enable_eject()  - {                                            e;   char	media_enable [6]   = {MEDIA_OPCODE , 0, 0, 0, 0, 0};   7   return execute_command (media_enable, 6, 0, 0, READ);v  }                                   N /*============================================================================ ! disable_eject Routine.    3 ! This routine disables the manual removal of a CD. O !============================================================================*/o   int disable_eject()_   {                        o;   char	media_disable [6]  = {MEDIA_OPCODE , 0, 0, 0, 1, 0};_  8   return execute_command (media_disable, 6, 0, 0, READ); }v  0                                                 N /*============================================================================ ! get_volume Routine.     1 ! This routine gets the volume-level from the cd.-O !============================================================================*/l   void get_volume()                             t {                           int  	audio_stat	= 0,- 	volume_level	= 0, 	volume_ch0	= 0,   	volume_ch1	= 0,) 	status		= 0;                            A     char 	cd_data [14];L     char	playback_status  [10] =9 			{PLAYBACK_STATUS_OPCODE,  0, 0, 0, 0, 0, 0, 0, 14, 0};            K   status = execute_command (playback_status, 10, cd_data, 14, READ);       t  C   audio_stat = cd_data[4]  & 0377;	/* Play/Eject=0, Stop/Pause=1	*/ME   volume_ch0 = cd_data[11] & 0377;	/* Volume ch0 (low-order 8 bits)*/lE   volume_ch1 = cd_data[13] & 0377;	/* Volume ch1 (low-order 8 bits)*/   @   if (volume_ch0 > volume_ch1)		/* Make sure the volume-level	*/*     {					/* returned is the highest of	*/7     volume_level = volume_ch0;		/* the two channels		*/-     }-   else     {m     volume_level = volume_ch1;     }e                           ?   left_volume    = volume_ch0;		/* Save left-channel  volume	*/=?   right_volume   = volume_ch1;		/* Save right-channel volume	*/=@   current_volume = volume_level;	/* And the higher of the two	*/  *   if (volume_level > 0 && audio_stat == 0)*     {					/* Assume we are playing a CD	*/9     play_flag  = TRUE;			/* if status is 0, and volume	*/c*     }					/* is not 0 (if volume was 0,	*/$ 					/* then we could be ejected)	*/ /*6   printf ("L= %d    R= %d     Max = %d    Stat= %d\n",8 	  left_volume, right_volume, volume_level, audio_stat); */    }                                    N /*============================================================================ ! set_volume Routine.     J ! This routine changes the volume of the cd-player in both channels 0 & 1.O !============================================================================*/o*                                           / void set_volume(int volume_ch0, int volume_ch1)n  - {                                            m
   int	status;b     char	playback_control [10] =8 		{PLAYBACK_CONTROL_OPCODE, 0, 0, 0, 0, 0, 0, 0, 14, 0};  4   char	cd_data [14] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0};                  o   cd_data [10] = 1;;   cd_data [11] = volume_ch0;   cd_data [12] = 2;l   cd_data [13] = volume_ch1;  F   status = execute_command (playback_control, 10, cd_data, 14, WRITE);                   }                                              N /*============================================================================ ! get_status Routine.CI ! This routine reads the current status of the CD player to determine the	H ! total number of tracks, whether the player is playing, and, if so, theK ! current track number being played. If any of this information has changedfH ! since the last time the screen was updated, then the screen is updated ! again.O !============================================================================*/=        void get_status()                           {u"   char	read_subchan_command [10] =7 		{READ_SUBCHAN_OPCODE, 0, 0x40, 1, 0, 0, 0, 0, 48, 0};s     char	subchan_data [48];=     int	i, 	track_time_units;'                                         ?   total_tracks = read_toc();		/* Get total tracks on this CD	*/   I   if (total_tracks == 0 || execute_command (read_subchan_command,        l)   	10, subchan_data, 48,  READ) == FALSE)      {      current_track = 0;     track_time_sec = 0; ,     }                                          else     { $     current_track = subchan_data[6]; /*2     if (subchan_data[1] == 0x12) cd_paused = TRUE;!     printf ("Subchannel data: ");iB     for (i=0; i<20; i++) printf (" %02x", subchan_data[i] & 0xff);     printf ("\n"); */=     track_time_units = (subchan_data[13] & 0xff) * 0x10000 + n2     	    		   (subchan_data[14] & 0xff) * 0x100 + (     			   (subchan_data[15] & 0xff);      H     /*===================================================================     ! The following operation converts the units (blocks from=F     ! beginning of track) in the subchan_data [13], subchan_data [14],:     ! and subchan_data [15] fields into units of seconds. I     !==================================================================*/                          1     track_time_sec = track_time_units / (75 * 4);l             3     if ((track_time_sec != saved_track_time_sec) &&o8       	    (track_time_sec != (saved_track_time_sec-1)))       {     ,       saved_track_time_sec = track_time_sec;9       }                                                  e        if (subchan_data[1] == 0x13)       {o       stop_unit ();        }B     }A  +   if (current_track != saved_current_track)L     {N     update_time_scale_max();(     saved_current_track = current_track;     }" }U                               N /*============================================================================ ! bpt Routine.' ! This is a null routine (spin-wheels).AO !============================================================================*/d void bpt ()		          r {  }     N /*============================================================================ ! exit_handler Routine.aF ! Callback routine for exit button. Stop the CD from playing, deassign& ! the channel to the player, and exit.O !============================================================================*/   A void exit_handler ()                                             = {       4   stop_unit ();           	/* spin down the unit		*/4   dealloc_cd_channel();		/* blow away the channel	*/   exit(1);			/* go away			*/ }t                         N /*============================================================================N !=============================================================================N !=============================================================================: ! Below are the only VMS-SPECIFIC routines in the program:O !============================================================================*/h  N /*============================================================================ ! execute_command Routine.D ! This routine sends the specified command to the CD player. It doesB ! so by filling in the generic class driver descriptor and issuing" ! an IO$_DIAGNOSE QIO to GKDRIVER.O !============================================================================*/                       int execute_command (= 		int *command_addr, 		int command_len, 		int data_addr, 		int data_len,t 		int rw_flag)           ' /*=====================================s' !  SCSI Generic Class Driver Constants a( !=====================================*/ #define FLAGS_READ		1= #define FLAGS_DISCONNECT	2  #define FLAGS_DISCONNECT	2       #define GOOD_SCSI_STATUS	0 #define OPCODE			0( #define FLAGS			1                       ! #define COMMAND_ADDRESS		2       a! #define COMMAND_LENGTH		3        n! #define DATA_ADDRESS		4           ! #define DATA_LENGTH		5           (! #define PAD_LENGTH		6            6! #define PHASE_TIMEOUT		7         =  #define DISCONNECT_TIMEOUT	8       {=  7   char	request_sense_command [6] = {3, 0, 0, 0, 18, 0},i   	request_sense_data [18],c
 	scsi_status;u     int	gk_iosb[2],C     	gk_desc[15],b 	i,a 	status;  &   gk_desc[OPCODE]		= 1;               /   gk_desc[FLAGS]		= rw_flag + FLAGS_DISCONNECT;e*   gk_desc[COMMAND_ADDRESS]	= command_addr;(   gk_desc[COMMAND_LENGTH]	= command_len;%   gk_desc[DATA_ADDRESS]		= data_addr; #   gk_desc[DATA_LENGTH]		= data_len;=!   gk_desc[PAD_LENGTH]		= 0;      =    gk_desc[PHASE_TIMEOUT]	= 0;   #   gk_desc[DISCONNECT_TIMEOUT]	= 60;    B   for (i=9; i<15; i++) gk_desc[i] = 0;	/* Clear reserved fields	*/  H /*======================================================================H ! Issue the QIO to send the inquiry command and receive the inquiry dataJ !=======================================================================*/             >   status = sys$qiow (1, gk_chan, IO$_DIAGNOSE, gk_iosb, 0, 0, &   		   &gk_desc[0], 15*4, 0, 0, 0, 0);    , /*==========================================+ !  Check the various returned status values=. !===========================================*/=                                                              h'   if (!(status & 1)) sys$exit (status);   8   if (!(gk_iosb[0] & 1)) sys$exit (gk_iosb[0] & 0xffff);  6   scsi_status = (gk_iosb[1] >> 24) & SCSI_STATUS_MASK;  3   if (scsi_status == GOOD_SCSI_STATUS) return TRUE;o     if (scsi_status == 2)P     {,     bpt ();0     gk_desc[OPCODE]	= 1;3     gk_desc[FLAGS]	= FLAGS_READ + FLAGS_DISCONNECT; 5     gk_desc[COMMAND_ADDRESS]	= request_sense_command;       gk_desc[COMMAND_LENGTH]	= 6;/     gk_desc[DATA_ADDRESS]	= request_sense_data;d      gk_desc[DATA_LENGTH]	= 18;  !     gk_desc[PAD_LENGTH]		= 0;           gk_desc[PHASE_TIMEOUT]	= 0; %     gk_desc[DISCONNECT_TIMEOUT]	= 60;=  D     for (i=9; i<15; i++) gk_desc[i] = 0;	/* Clear reserved fields */  @     status = sys$qiow (1, gk_chan, IO$_DIAGNOSE, gk_iosb, 0, 0, '     	   &gk_desc[0], 15*4, 0, 0, 0, 0);c     }=  H   return FALSE;                                                          }    	   N /*============================================================================/ ! alloc_cd_channel Routine.                    n2 ! This routine assigns a channel to the CD player.O !============================================================================*/    void alloc_cd_channel () 	c {a
   int	status,n 	gk_device_desc[2];   )   gk_device_desc[0] = strlen (gk_device);a$   gk_device_desc[1] = &gk_device[0];;   status = sys$assign (&gk_device_desc[0], &gk_chan, 0, 0);a   if (!(status & 1))     {(=     printf ("Unable to assign channel to %s", &gk_device[0]);t     exit (status);     }        }r    N /*============================================================================ ! dealloc_cd_channel Routine.r4 ! This routine deassigns a channel to the CD player O !============================================================================*/r   void dealloc_cd_channel () 	  {8
   int	status;d      status = sys$dassgn (gk_chan);   if (!(status & 1))     {uA     printf ("Unable to deassign channel from %s", &gk_device[0]);      exit (status);     }= }=  O /*===========================================================================*/rO /*===============================(END PROGRAM)===============================*/dO /*===========================================================================*/=O /*===========================================================================*/ ( /*			     Convenience Routines			     */   #if CONVENIENCE_ROUTINES  N /*============================================================================ ! play_MSF Routine.            ;I ! This routine plays a segment starting at "sm" minutes and "ss" seconds,t, ! and goes to "em" minutes and "es" seconds. !=J ! Note:	The program doesn't use this routine --  It is presented as an FYI= !	in case the user wants to utilize the MSF calls for the CD.kO !============================================================================*//                            int play_MSF (	int sm, int ss, 		int em, int es)1   #define PLAY_MSF_OPCODE		0X47k   {*'   unsigned char	play_MSF_command [10] =n1 			{PLAY_MSF_OPCODE, 0, 0, 0, 0, 0, 0, 0,  0, 0};;
   int status;e6                                                       <   if (sm == 0 && ss < 3) ss = 3;		/* Play starts at 3 sec	*/  2   play_MSF_command [3] = sm;			/* Start minutes	*/2   play_MSF_command [4] = ss;			/* start seconds	*/0   play_MSF_command [5] = 0;			/* start frame		*/6                                                       1   play_MSF_command [6] = em;			/* end minutes		*/ 7   play_MSF_command [7] = es;			/* end seconds		*/      t.   play_MSF_command [8] = 0;			/* end frame		*/  =   status = execute_command(play_MSF_command, 10, 0, 0, READ);=     return status;	    }C           N /*============================================================================) ! play_partial_track Routine.            )J ! This routine starts at "x" minutes into the current track, and plays forG ! "y" minutes.  Note that if you try and play for more minutes than areaD ! remaining on the CD (from your start)... that nothing will happen!& ! (we call that... being feature-rich) !eJ ! Note:	The program doesn't use this routine --  It is presented as an FYI; !	to illustrate the use of the MSF format for playing a CD.tO !============================================================================*/_J                                                                            int play_partial_track ( 		int track_num, 		int start_at_minutes,      r 		int start_at_seconds,+ 		int duration_minutes,s 		int duration_seconds)d   {	   int	track_minutes	= 0, 	track_seconds	= 0,= 	begin_minutes	= 0,= 	begin_seconds	= 0,= 	end_minutes	= 0,= 	end_seconds	= 0;a   unsigned int 	total_seconds	= 0,i 	start_here	= 0, 	stop_here	= 0,  	actual_CD_stop	= 0;  6   total_seconds = read_toc_track (track_num) / (75*4);+ 				/* Calcuate track start (in seconds)	*/a  %   track_minutes = total_seconds / 60; 7   track_seconds = total_seconds - (track_minutes * 60);r  4   begin_minutes = track_minutes + start_at_minutes; 3   begin_seconds = track_seconds + start_at_seconds; , 				/* Now add in start offset - mins/sec	*/  1   end_minutes = begin_minutes + duration_minutes;t1   end_seconds = begin_seconds + duration_seconds;n+ 				/* And compute the end    - mins/sec	*/e  2   start_here = (begin_minutes*60) + begin_seconds;0   stop_here  = (end_minutes*60)   + end_seconds;  /   actual_CD_stop = read_CD_capacity() / (75*4);c  =   if (start_here > actual_CD_stop)		/* If start is greater	*/="     {		 				/* than CD capacity	*/(     return FALSE;				/* exit on error	*/     }   =   if (stop_here > actual_CD_stop)		/* If end is greater...	*/d#     {						/* then set to actual	*/ 1     end_minutes = actual_CD_stop/60;		/* end			*/_4     end_seconds = actual_CD_stop - (end_minutes*60);     }=J                                                                           ?   printf ("play_MSF   min=%d    sec=%d    min=%d    sec=%d \n",= 		begin_minutes, begin_seconds,= 		end_minutes,   end_seconds);  )   play_MSF (begin_minutes, begin_seconds,_< 	    end_minutes,   end_seconds);	/* Now play the segment	*/ }e   #endif  O /*===========================================================================*/=O /*=================================(END ALL)=================================*/sO /*===========================================================================*/=