 /* **++ **  FACILITY:  CMEM  V1.1  ** ** **  MODULE DESCRIPTION:  **H **	This is the main module containing all user callable routines as wellH **	as the replacements for the C RTL dynamic memory management routines. **5 **	The following routines are defined in this module:  ** **	    cmem___putmsg **	    cmem___hash_index **	    cmem___get_block_size# **	    cmem___allocate_info_cluster ! **	    cmem___allocate_info_block   **	    cmem___display_block_info **	    cmem___lookup_address **	    cmem___condition_handler  **	    cmem___vm_allocate  **	    cmem___vm_free  ** **	    cmem_initialize **	    cmem_reset_display_flags  **	    cmem_show_blocks  **	    cmem_check_address  **	    cmem_collect_stack  **	    cmem_collect_time **	    cmem_boundary_check **	    cmem_protect_freed  **7 **	    cmem_malloc			(DECC: DECC$MALLOC;  VAXC: malloc) 7 **	    cmem_calloc			(DECC: DECC$CALLOC;  VAXC: calloc) 3 **	    cmem_free			(DECC: DECC$FREE;    VAXC: free) 8 **	    cmem_realloc		(DECC: DECC$REALLOC; VAXC: realloc) ** ** **  AUTHORS: **2 **      Brett Hunsaker (hunsaker@eisner.decus.org) ** ** **  CREATION DATE:  4 May 1995 ** ** **  DESIGN ISSUES: **C **	We needed some way of tracking who was allocating memory and not  **	releasing it. ** ** **  MODIFICATION HISTORY:  **5 **      4-May-1995	B. Hunsaker	Initial implementation  **. **	Necessity is truly the mother of invention. **7 **	13-Sep-1995	B. Hunsaker	Add support for DEC C on VAX  **B **	Got a mail message suggesting the proper code to use DEC C on a **	VAX.  ** **-- */   /* ** **  ENVIRONMENT SETTINGS ** */   /*C 	For VAX C compatibility, we use the 'globalref' modifier to access D 	message codes.  This will generate a warning message with DEC C, soE 	disable that here.  If this module was only compiled with DEC C, you D 	could get away with using 'extern int <condition_name>' rather than" 	'globalref int <condition_name>'. */  
 #ifdef __DECC $ #pragma message disable( GLOBALEXT ) #endif     /*B 	We will access the frame pointer (R13) on a VAX to walk the stackC 	when we allocate memory.  This is done using the VAX C '_READ_GPR' C 	built-in function which requires the '#pragma builtins' statement.  */   #pragma builtins     /* ** **  GLOBAL CONSTANTS ** */   /*D 	This is where we remap our routine names to thoses used by the RTL. */  
 #ifdef __DECC   ! #define		cmem_malloc		DECC$MALLOC ! #define		cmem_calloc		DECC$CALLOC # #define		cmem_realloc		DECC$REALLOC  #define		cmem_free		DECC$FREE    #else    #define		cmem_malloc		malloc #define		cmem_calloc		calloc #define		cmem_realloc		realloc #define		cmem_free		free   #endif   #define		END_OF_LIST		-1   #define		BYTES_PER_PAGELET	512   #define		FILL_PATTERN		0xAA    #define		MAX_CALL_DEPTH		20  #define		HASH_LIST_HEADERS	8191 ! #define		BLOCK_INFO_ENTRIES	50000      /* ** **  INCLUDE FILES  ** */   #include <stdio.h> #include <stdlib.h>  #include <string.h>    #include starlet #include lib$routines  #include ots$routines  #include prtdef  #include descrip #include ssdef   /*@ 	Some VAX sites might not have re-installed VAX C to pick up theC 	new $GETSYI codes which we use.  We'll define it here just to help E 	those sites, but it will only help if they are running VAX/VMS V5.4?  	or better.  */   #include syidef  #ifndef SYI$_PAGE_SIZEN #define SYI$_PAGE_SIZE 4452             /* Memory page size in bytes        */ #endif   #include varargs   #ifdef __ALPHA #include libicb  #endif     /* ** **  GLOBAL STRUCTURES  ** */  # typedef struct address_range_struct  {    unsigned long start_address;   unsigned long end_address; } address_range_type;      /*B 	We will need some information about each block of memory which is4 	allocated.  This will be kept within a linked list. */   struct block_info_struct {    unsigned int				next_block;    unsigned int				zone_id;   void *				user_address; !   unsigned int				requested_size; /   unsigned int				call_stack[ MAX_CALL_DEPTH ];     unsigned int				vms_time[ 2 ];   struct   { "     unsigned int			stack_good : 1;!     unsigned int			time_good : 1; &     unsigned int			do_not_display : 1;
   } flags; };     /*A 	We will initially allocate one 'conglomerated' structure so that B 	we aren't constandtly fighting the user for dynamic memory.  ThisD 	will be capable of holding a finite amount of information about allD 	the memory blocks which have been allocated.  If the user allocatesD 	more blocks then this structure can hold, we'll create an extensionA 	for this to hold the extra info.  If that one fills too, then we A 	will just keep appending more blocks as needed.  Once allocated, , 	they will never be released -- just reused. */   struct cluster_info_struct { 1   struct cluster_info_struct *		next_cluster_ptr; )   int					list_head[ HASH_LIST_HEADERS ];     int					available_block_count;   int					next_available_block; 6   unsigned char				block_in_use[ BLOCK_INFO_ENTRIES ];=   struct block_info_struct		block_info[ BLOCK_INFO_ENTRIES ];  };     /*A 	Just for the heck of it we will store all our global data in one  	structure.  */   struct global_values_struct  {     unsigned long int			page_size;(   unsigned long int			pagelets_per_page;%   unsigned long int			protected_zone; '   unsigned long int			unprotected_zone; 2   struct cluster_info_struct *		first_cluster_ptr;*   int					(*previous_exception_handler)();   unsigned char				dostack;    unsigned char				dotime;%   unsigned char				protect_allocated; !   unsigned char				protect_freed;    unsigned char				initialized;  };     /* ** **  GLOBAL VARIABLES ** */  1 static struct global_values_struct	cmem___globals  	= {/ 	    0,		/* Page size; set via $GETJPI			    */ = 	    0,		/* Pagelets/page: calculated via init routine	    */ = 	    0,		/* Protected zone id: from LIB$CREATE_VM_ZONE	    */ ? 	    0,		/* Unprotected zone id: from LIB$CREATE_VM_ZONE	    */ > 	    NULL,	/* Cluster info pointer: set in init routine	    */A 	    NULL,	/* Pointer to previous exception handler: not used  */   9 			/* ------------------------------------------------ */ * 			/*	       INITIAL MODE SETTINGS		    */9 			/* ------------------------------------------------ */ 2 	    TRUE,	/* Collect call stack info		    	    */. 	    TRUE,	/* Collect allocation time			    */< 	    FALSE,	/* Allocate with protected boundary pages	    */8 	    FALSE,	/* Set memory to no-access upon free		    */9 			/* ------------------------------------------------ */   A 	    FALSE	/* Global data initialized: set via init routine    */  	  };          /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      cmem___putmsg: **E **	Provides a convience routine for accessing the capabilities of the  **	SYS$PUTMSG system service.  ** ** **  FORMAL PARAMETERS: **F **	The calling parameter list is the same as that used for LIB$SIGNAL. ** **      condition_value:" **	    Type:	Unsigned long integer **	    Access:	Input **	    Mechanism:	By value **> **	    Provides a VMS condition value to be converted to text. **
 **	fao_count:  **	    Type:	Signed integer  **	    Access:	Input **	    Mechanism:	By value **H **	    This is the number of FAO parameters associated with the message.6 **	    If not specified, then no FAO parameters exist. ** **	fao_param1: **	    Type:	Unspecified **	    Access:	Input **	    Mechanism:	By value **' **	    This is the first FAO parameter.  ** **	fao_param2: **	    Type:	Unspecified **	    Access:	Input **	    Mechanism:	By value **( **	    This is the second FAO parameter. ** ** **  RETURN VALUE:  **J **      The status returned by the call to SYS$PUTMSG is propagated to the **	calling routine.  ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **K **      Simply put the parameters into a structure on the heap and call the  **	SYS$PUTMSG system service.  ** ** **  PRECONDITIONS: **     **	None. ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  **7 **	    cmem___putmsg( signaled_condition, 1, "burp!" );  ** ** **  EXCEPTIONS:  **     **  	CMEM__GETVMFAIL:A **    4 **	    We couldn't get the virtual memory we needed. ** ** **-- */  9 /* int cmem___putmsg( int condition_value, ... )			    */h   int cmem___putmsg( va_alist )m  0 va_dcl				/* Note that no ";" is needed.		    */   {i   /* ** **  INCLUDE FILESe ** */     /* **
 **  CONSTANTS  ** */     /* ** **  STRUCTURES AND UNIONSe ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */      globalref int CMEM__GETVMFAIL;     /* ** **  LOCAL VARIABLESa ** */     int	    argument_count;*   int *	    putmsg_array;*   va_list   argument_pointer;e   int	    loop;l   int	    byte_size;   int	    status;e     /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*3 	Get the count of arguments.  This is VMS specific.e */     va_count( argument_count ); J   argument_count &= 0xFF;    /* Deal with a little problem in DEC C	    */  5   byte_size = ( argument_count + 1 ) * sizeof( int );_6   status = lib$get_vm( &byte_size, &putmsg_array, 0 );   if ( ( status & 1 ) != 1 )   {kA     lib$signal( ( int ) &CMEM__GETVMFAIL, 1, "$PUTMSG", status );9   }*   else   {I'     putmsg_array[ 0 ] = argument_count;t  !     va_start( argument_pointer ); 3     for( loop = 1; loop <= argument_count; loop++ )O=       putmsg_array[ loop ] = va_arg( argument_pointer, int );      va_end( argument_pointer );o  1     status = sys$putmsg( putmsg_array, 0, 0, 0 );d0     lib$free_vm( &byte_size, &putmsg_array, 0 );   }u     return( status );e }          /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      cmem___hash_index: **C **	Converts a user address value into an index into the hash table.s ** ** **  FORMAL PARAMETERS: ** **	address:  **	    Type:	    Pointer **	    Access:	    Input **	    Mechanism:	    By value **F **	    The user address which was returned from 'malloc', 'calloc', or **	    'realloc'.n ** ** **  RETURN VALUE:  **> **	Index into hash table; ranges 0 to 'HASH_LIST_HEADERS' - 1. ** ** **  SIDE EFFECTS:  **
 **      None.V ** ** **  DESIGN:  **F **	Basically do a mod function on the value.  We make some adjustmentsD **	assuming that a user will normally be allocating quadword aligned **	data structures.  ** ** **  PRECONDITIONS: **   / **	None. ** ** **  CALLING SEQUENCE:n **) **  	Here is an example calling sequence:f **7 **	    block_index = cmem___hash_index( user_pointer );_ ** ** **  EXCEPTIONS:f **   e **	None. ** ** **-- */   unsigned int cmem___hash_index(s 	void *			address )a {c   /* ** **  INCLUDE FILESc ** */     /* **
 **  CONSTANTSa ** */     /* ** **  STRUCTURES AND UNIONSf ** */     /* ** **  EXTERNAL ROUTINESP ** */     /* ** **  EXTERNAL CONSTANTS ** */     /* ** **  LOCAL VARIABLESH ** */     /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*@ 	This is a simple hash function.  We get rid of the bottom threeB 	bits as good programmers will be allocating quadword aligned dataA 	structures, and thus our hash function would produce very poorly  	distributed indexes.e */  B   return( ( ( unsigned int ) address >> 3 ) % HASH_LIST_HEADERS ); }e         /* **++ **  FUNCTIONAL DESCRIPTION:w ** **      cmem___get_block_size: **B **	Returns the size of a memory segment associated with a specific **	address.Y ** ** **  FORMAL PARAMETERS: ** **	user_address: **	    Type:	    Pointer **	    Access:	    Input **	    Mechanism:	    By value **F **	    The user address which was returned from 'malloc', 'calloc', or **	    'realloc'.n ** ** **  RETURN VALUE:  **F **	The size of the associated memory segment in bytes.  If the address+ **	could not be found, then we return zero.h ** ** **  SIDE EFFECTS:i **
 **      None.  ** ** **  DESIGN:t **E **	The 'realloc' routine needs to know the size of the current block.	/ **	So, we wrote this routine to get that value.d **E **	Scan the appropriate hash linked list within each cluster until we F **	find the specified memory segment.  Return the size of the block or! **	zero if we can't find a match.m ** ** **  PRECONDITIONS: **   _7 **	The 'cmem_initialize' routine must have been called.l ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:t **4 **	    size = cmem___get_block_size( user_pointer ); ** ** **  EXCEPTIONS:  **   r **	None. ** ** **-- */  3 size_t cmem___get_block_size( void * user_address )t {    /* ** **  INCLUDE FILESu ** */     /* **
 **  CONSTANTSi ** */     /* ** **  STRUCTURES AND UNIONSo ** */     /* ** **  EXTERNAL ROUTINESe ** */     /* ** **  EXTERNAL CONSTANTS ** */     /* ** **  LOCAL VARIABLESr ** */     unsigned char			found_it;t+   struct cluster_info_struct *	cluster_ptr;u   int				block_index;i     /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*E 	Scan all the information blocks in all the clusters to see if we cant 	find this address.t */     found_it = FALSE;T1   cluster_ptr = cmem___globals.first_cluster_ptr;i  L   block_index = cluster_ptr->list_head[ cmem___hash_index( user_address ) ];     while ( !found_it )n   {	   /*E 	If we're at the end of a linked list for a particular hash value, we	. 	need to move on to the next cluster (if any). */  %     if ( block_index == END_OF_LIST )i     {sD       if ( ( cluster_ptr = cluster_ptr->next_cluster_ptr ) == NULL ) 	break;k
       else         block_index =n> 		cluster_ptr->list_head[ cmem___hash_index( user_address ) ];     }      /*B 	If the address in the info block matches what the user passed us,C 	we've found the block.  Otherwise, keep on transversing the linked0 	list. */       else     {IP       if ( cluster_ptr->block_info[ block_index ].user_address == user_address ) 	found_it = TRUE;e
       elseA 	block_index = cluster_ptr->block_info[ block_index ].next_block;$     }V   }E     /*C 	If we have no entry for that address, then return zero as the size 9 	of the block.  Otherwise, return what is actually there.* */     return( found_it ?> 		cluster_ptr->block_info[ block_index ].requested_size : 0 ); }T        " void cmem___allocate_info_cluster(- 	struct cluster_info_struct * *	cluster_ptr )c {a  "   globalref int CMEM__INFOEXPFAIL;       int				status;    A   status = lib$get_vm( &( sizeof( struct cluster_info_struct ) ),  		cluster_ptr, 0 );S   if ( ( status & 1 ) != 1 )   { 6     lib$stop( ( int ) &CMEM__INFOEXPFAIL, 0, status );     return;    }L  *   (*cluster_ptr)->next_cluster_ptr = NULL;=   (*cluster_ptr)->available_block_count = BLOCK_INFO_ENTRIES;P+   (*cluster_ptr)->next_available_block = 0;o"   ots$move5( 0, NULL, END_OF_LIST,B 	sizeof( (*cluster_ptr)->list_head ), (*cluster_ptr)->list_head );   ots$move5( 0, NULL, FALSE,H 	sizeof( (*cluster_ptr)->block_in_use ), (*cluster_ptr)->block_in_use );	   return;o }t     u  6 struct block_info_struct * cmem___allocate_info_block( 	void *			user_address ) {e        globalref int CMEM__NOFREEBLK;       int				status;+   struct cluster_info_struct *	cluster_ptr;g   int				blocks_scanned;   int				block_index;i   int				hash_index;   int				next_index;     /*- 	Find a cluster which has an available block.I */  1   cluster_ptr = cmem___globals.first_cluster_ptr;o2   while( cluster_ptr->available_block_count == 0 )   { 0     if ( cluster_ptr->next_cluster_ptr == NULL )E       cmem___allocate_info_cluster( &cluster_ptr->next_cluster_ptr );*  0     cluster_ptr = cluster_ptr->next_cluster_ptr;   }      /*D 	Go find an available block.  Although the cluster header says thereB 	is an avilable block, we will check to make sure we don't go into- 	an infinite loop if there really is not one.  */     blocks_scanned = 0;*2   block_index = cluster_ptr->next_available_block;    4   while ( cluster_ptr->block_in_use[ block_index ] )   {s1     if ( ++blocks_scanned >= BLOCK_INFO_ENTRIES )n     { +       lib$stop( ( int ) &CMEM__NOFREEBLK );a       return( NULL );n     }*  .     if ( ++block_index >= BLOCK_INFO_ENTRIES )       block_index = 0;   }O  '   --cluster_ptr->available_block_count; %   cluster_ptr->next_available_block =mA 	( block_index == BLOCK_INFO_ENTRIES - 1 ? 0 : block_index + 1 );t     /*C 	We've found an open slot.  Now hook us into the appropriate linkedN 	list within this cluster. */  1   hash_index = cmem___hash_index( user_address );*@   if ( ( cluster_ptr->list_head[ hash_index ] ) == END_OF_LIST )   {*7     cluster_ptr->list_head[ hash_index ] = block_index;    }*   else   {N6     next_index = cluster_ptr->list_head[ hash_index ];L     while( cluster_ptr->block_info[ next_index ].next_block != END_OF_LIST )D       next_index = cluster_ptr->block_info[ next_index ].next_block;C     cluster_ptr->block_info[ next_index ].next_block = block_index;N   }I 	I   /*A 	Set the block so that it indicates it is now the end of the listtD 	and return a pointer to the block.  We can't return just the index,B 	as the calling routine would not know what cluster is being used. */  B   cluster_ptr->block_info[ block_index ].next_block = END_OF_LIST;E   cluster_ptr->block_info[ block_index ].user_address = user_address;)  2   cluster_ptr->block_in_use[ block_index ] = TRUE;4   return( &cluster_ptr->block_info[ block_index ] ); }y        F void cmem___display_block_info( struct block_info_struct * block_ptr ) {o   /*? 	We'll display the information to the screen even if the 'don'tg? 	display this' flag is set.  It is up to the calling routine tot 	check that flag.p */     globalref int CMEM__UNEXPERR;v       extern void cmem___symbolize(  	unsigned long int	address,  	char *			output_string,* 	unsigned long int	output_string_length );       int				status;   int				loop;+   unsigned short int		return_string_length;e-   struct dsc$descriptor_s	return_string_desc;e   char				return_string[ 200 ];*     /*C 	The user can turn off our collection of the call stack and time ofd> 	allocation to improve performance.  In this case, we can only? 	display the address and size of the allocated block of memory.e */  #   if ( block_ptr->flags.time_good )    {*5     return_string_desc.dsc$a_pointer = return_string;N3     return_string_desc.dsc$b_dtype = DSC$K_DTYPE_T; 3     return_string_desc.dsc$b_class = DSC$K_CLASS_S;l>     return_string_desc.dsc$w_length = sizeof( return_string );  D     status = sys$asctim( &return_string_length, &return_string_desc,! 		&block_ptr->vms_time[ 0 ], 0 );a     if ( ( status & 1 ) != 1 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1,_) 				"$ASCTIM displaying block", status );.  1     return_string[ return_string_length ] = '\0';s-     printf( "%08X: %d bytes allocated at %s",D5 		block_ptr->user_address, block_ptr->requested_size,  		return_string );   }A   else   {*'     printf( "%08X: %d bytes allocated", 7 		block_ptr->user_address, block_ptr->requested_size );*   }      /*4 	Display the stack if we collected that information. */  $   if ( block_ptr->flags.stack_good )   {       printf( "; call stack:\n" );2     for( loop = 0; loop < MAX_CALL_DEPTH; loop++ )     {m/       if ( block_ptr->call_stack[ loop ] != 0 )r       {a1 	cmem___symbolize( block_ptr->call_stack[ loop ], - 				return_string, sizeof( return_string ) );n* 	printf( "  %2d: PC = %08X%s\n", loop + 1,2 			block_ptr->call_stack[ loop ], return_string );       }      }    }m   printf( "\n" );:  	   return;r }t        1 struct block_info_struct * cmem___lookup_address(d 	void *			user_address ) {R   /*C 	This routine scans all allocated blocks to see if an address might C 	be in one of the protected boundary pages.  We return a pointer toh3 	the info block if we find it, else we return NULL.' */    +   struct cluster_info_struct *	cluster_ptr;z   int				block_index;o$   address_range_type		address_range;     /*> 	Scan all allocated blocks in the protected zone to see if theB 	address provided by the user is in one of the allocated segments. */  6   for( cluster_ptr = cmem___globals.first_cluster_ptr;C 	cluster_ptr != NULL; cluster_ptr = cluster_ptr->next_cluster_ptr )a   {nK     for( block_index = 0; block_index < BLOCK_INFO_ENTRIES; block_index++ )      { 7       if ( ( cluster_ptr->block_in_use[ block_index ] )h8 	    && ( cluster_ptr->block_info[ block_index ].zone_id* 		    == cmem___globals.protected_zone ) )         {L   /*? 	Calculate the address range for this block.  If the address of : 	the access violation is within the allocated space, then $ 	return a pointer to the block info. */  3 	address_range.start_address = ( ( ( unsigned int )d5 		cluster_ptr->block_info[ block_index ].user_address  		/ cmem___globals.page_size ): 		* cmem___globals.page_size ) - cmem___globals.page_size;- 	address_range.end_address = ( unsigned int ) 5 		cluster_ptr->block_info[ block_index ].user_addressB9 		+ cluster_ptr->block_info[ block_index ].requested_sizet! 		- 1 + cmem___globals.page_size;n  F 	if ( ( ( unsigned int ) user_address >= address_range.start_address )H 	    && ( ( unsigned int ) user_address <= address_range.end_address ) )5 	  return( &cluster_ptr->block_info[ block_index ] );/       }n     }F   }T     return( NULL );m }g     f   int cmem___condition_handler(e)         int *           signal_arguments,e-         int *           mechanism_arguments )  {	   /*A 	THIS ROUTINE IS NOT FULLY IMPLEMENTED.  IT DOESN'T WORK WITH THE,C 	DEBUGGER AS IT SHOULD.  THE INITIALIZATION CODE DOES NOT CURRENTLYb% 	DECLARE THIS AS A CONDITION HANDLER.  */  !   globalref int CMEM__BNDRYRDVIO;t"   globalref int CMEM__BNDRYWRTVIO;       int				    status;+   struct block_info_struct *	    block_ptr;s     /*D 	If we got an access violation, check to see if it was in one of ourA 	protected pages.  Display information about the associated blocke 	of memory.n */  ,   if ( signal_arguments[ 1 ] == SS$_ACCVIO )   {      if ( ( block_ptrI 	= cmem___lookup_address( ( void * ) signal_arguments[ 3 ] ) ) != NULL )       {l1       if ( ( signal_arguments[ 2 ] & 0x4 ) == 0 )nM         cmem___putmsg( ( int ) &CMEM__BNDRYRDVIO, 1, signal_arguments[ 3 ] );,
       elseN         cmem___putmsg( ( int ) &CMEM__BNDRYWRTVIO, 1, signal_arguments[ 3 ] );     } +     cmem___display_block_info( block_ptr );[   }k     /*? 	There can only be one routine using the exception vector.  So,l? 	if someone was there before us, we need to invoke them so theyl 	can do whatever they want.; */  :   if ( cmem___globals.previous_exception_handler != NULL )   {u7     status = cmem___globals.previous_exception_handler(aH                                 signal_arguments, mechanism_arguments );     return( status );L   }    else     return( SS$_RESIGNAL );L }      s   int cmem___vm_allocate(o 	int *			number_of_bytes,  	void * *		base_address,  	unsigned int *		user_argument ) {U     globalref int			CMEM__NORMAL;r#   globalref int			CMEM__EXPREGFAIL;i#   globalref int			CMEM__MALLOCFAIL;S$   globalref int			CMEM__PROTCHGFAIL;!   globalref int			CMEM__UNEXPERR;        int				status;   int				user_pages;   int				internal_pagelets;i$   address_range_type		address_range;%   address_range_type		address_range2;;     /*C 	The VMS system service we use requires the size to be specified in	B 	pagelets.  We also need a page at the beginning and at the end ofD 	this space to try and detect reads and writes outside the allocated 	space.  */  B   user_pages = ( *number_of_bytes + cmem___globals.page_size - 1 ) 				/ cmem___globals.page_size; (   internal_pagelets = ( user_pages + 2 )' 				* cmem___globals.pagelets_per_page;t     /*B 	We allocate the number of pagelets.  VMS will round the number of= 	pagelets to properly align with the page size of the system.h */  A   status = sys$expreg( internal_pagelets, &address_range, 0, 0 );t   if ( ( status & 1 ) != 1 )   {n*     lib$signal( ( int ) &CMEM__EXPREGFAIL,7 			    2, number_of_bytes, internal_pagelets, status );n     base_address = NULL;     goto error_return;   }i     /*B 	Protect the starting and ending pages so that the code will incur? 	an access violation when there is any attempt to read or write  	them. */  =   address_range2.start_address = address_range.start_address; ;   address_range2.end_address = address_range.start_address;k  <   status = sys$setprt( &address_range2, 0, 0, PRT$C_NA, 0 );   if ( ( status & 1 ) != 1 )   {o8     lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );     base_address = NULL;     goto error_return;   }   ;   address_range2.start_address = address_range.end_address;)9   address_range2.end_address = address_range.end_address;O  <   status = sys$setprt( &address_range2, 0, 0, PRT$C_NA, 0 );   if ( ( status & 1 ) != 1 )   {e8     lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );     base_address = NULL;     goto error_return;   }E     /*A 	Determine the address to return to the user.  We want to make it_= 	so that the end of the space is next to the protected endingb 	page. */  8   *base_address = ( void * ) ( address_range.end_address7 			- *number_of_bytes - cmem___globals.page_size + 1 );o   /*? 	We want to initialize any memory between the initial protected D 	page and the 'base_address' with a value which will be checked when 	we free the memory. */  #   ots$move5( 0, NULL, FILL_PATTERN,b@ 		( unsigned int ) *base_address - ( address_range.start_address  			+ cmem___globals.page_size ),; 		address_range.start_address + cmem___globals.page_size );    /*E 	That's it.  Re-enable ASTs if that was how it was configured when weo
 	were called.d */  !   status = ( int ) &CMEM__NORMAL;     
 error_return:s     return( status );  }      o   int cmem___vm_free(t 	int *				number_of_bytes,+ 	struct block_info_struct *	block_info_ptr,n! 	unsigned int *			user_argument )  {g     globalref int CMEM__NORMAL;s"   globalref int CMEM__FREEWRTFAIL;"   globalref int CMEM__PROTCHGFAIL;!   globalref int CMEM__DELTVAFAIL;i       int				status;$   address_range_type		address_range;%   address_range_type		address_range2;[   char				single_character;a0   struct dsc$descriptor_s	single_character_desc;,   struct dsc$descriptor_s	check_string_desc;     /*C 	For the 'protected' zone, we expect the calling routine to pass uskA 	the address of the information block, rather than the address of  	allocated memory. */     /*@ 	Begin by calculating the address range of the blocks which were 	allocated.e */     address_range.start_addressC4 	= ( ( ( unsigned int ) block_info_ptr->user_address 		/ cmem___globals.page_size ): 		* cmem___globals.page_size ) - cmem___globals.page_size;   address_range.end_address00 	= ( unsigned int ) block_info_ptr->user_addressE 	    + block_info_ptr->requested_size - 1 + cmem___globals.page_size;s     /*? 	Check the memory preceding us to insure that it is the correct%A 	pattern.  If not, then somebody wrote into that space which is ap 	no-no.s */  "   single_character = FILL_PATTERN;:   single_character_desc.dsc$a_pointer = &single_character;4   single_character_desc.dsc$b_dtype = DSC$K_DTYPE_T;4   single_character_desc.dsc$b_class = DSC$K_CLASS_S;B   single_character_desc.dsc$w_length = sizeof( single_character );  !   check_string_desc.dsc$a_pointeroI 	= ( char * ) ( address_range.start_address + cmem___globals.page_size );s0   check_string_desc.dsc$b_dtype = DSC$K_DTYPE_T;0   check_string_desc.dsc$b_class = DSC$K_CLASS_S;    check_string_desc.dsc$w_length4 	    = ( unsigned int ) block_info_ptr->user_address5 		- ( unsigned int ) check_string_desc.dsc$a_pointer;   D   if ( lib$skpc( &single_character_desc, &check_string_desc ) != 0 )   {u(     status = ( int ) &CMEM__FREEWRTFAIL;     goto error_return;   }      /*A 	For this zone only, the user can tell us to actually release theoF 	memory or else just protect it.  The latter can be used to detect use@ 	of released memory at the cost of continually increasing use of 	virtual memory. */  %   if ( cmem___globals.protect_freed )a   {y     status = sys$setprt( 		&address_range,e 		0, 0, PRT$C_NA, 0 );     if ( ( status & 1 ) != 1 )     { :       lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );*       status = ( int ) &CMEM__PROTCHGFAIL;       goto error_return;     }s   }t   else   {t   /*F 	We change the protection on the pages we accessed back to user-write.: 	Although the $DELTVA system service probably does this... */  ?     address_range2.start_address = address_range.start_address;b=     address_range2.end_address = address_range.start_address;)  >     status = sys$setprt( &address_range2, 0, 0, PRT$C_UW, 0 );     if ( ( status & 1 ) != 1 )     {o:       lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );*       status = ( int ) &CMEM__PROTCHGFAIL;       goto error_return;     }   =     address_range2.start_address = address_range.end_address;_;     address_range2.end_address = address_range.end_address;_  >     status = sys$setprt( &address_range2, 0, 0, PRT$C_UW, 0 );     if ( ( status & 1 ) != 1 )     {x:       lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );*       status = ( int ) &CMEM__PROTCHGFAIL;       goto error_return;     }t     /*@ 	Release the memory.  The $DELTVA system service will work greatA 	unless the user's program allocates static structures after somee6 	dynamic stuff has enlarged the virtual address space. */  0     status = sys$deltva( &address_range, 0, 0 );     if ( ( status & 1 ) != 1 )     { 9       lib$signal( ( int ) &CMEM__DELTVAFAIL, 0, status );u)       status = ( int ) &CMEM__DELTVAFAIL;L       goto error_return;     }W   }H  !   status = ( int ) &CMEM__NORMAL;I    
 error_return:      return( status );E }I     C   void cmem_initialize( void ) {e     struct item_list_structl   {e&     unsigned short int		buffer_length;"     unsigned short int		item_code;     void *			buffer_address;/     unsigned short int *	return_length_address;t   };     struct io_status_block_structs   {i"     unsigned int		condition_value;     unsigned int		reserved;(   };       globalref int CMEM__UNEXPERR;    globalref int CMEM__INIT;e    +   extern int cmem___start_debugger( void );30   int cmem_collect_stack( unsigned char state );/   int cmem_collect_time( unsigned char state );s1   int cmem_boundary_check( unsigned char state );30   int cmem_protect_freed( unsigned char state );       int				status;   int				temp;   int				previous_ast_state;     char *			equivalence_string;  0   struct item_list_struct	getsyi_item_list[ 2 ];%   struct io_status_block_struct	iosb;n    ?   $DESCRIPTOR( protected_zone_desc, "C Debug Protected Heap" );vC   $DESCRIPTOR( unprotected_zone_desc, "C Debug Unprotected Heap" );r     /*D 	Most CMEM routines which call this initialization routine will haveE 	already disabled AST delivery.  But it is possible that the user may ? 	call us directly.  So, we need to make sure ASTs are disabled.L  D 	There is a slight chance that an AST may fire after we were invokedF 	but before we can disable ASTs and that the AST may have invoked thisF 	routine.  To allow for this, we check the status of the 'initialized'& 	flag to see if we really need to run.  A 	Also, a user might call us twice, so it makes sense to see if we  	were initialized before.e */  '   previous_ast_state = sys$setast( 0 );s$   if ( !cmem___globals.initialized )   {g   /*E 	We will have two virtual memory zones defined.  The 'protected' zone @ 	has pages set to no-access both before and after each allocated@ 	chunk of memory.  The other is the standard heap with allocated 	chunks next to each other.d  E 	Why not just use the protected memory scheme all the time?  Well, it_@ 	has a tendancy to eat up a LOT of virtual address space.  On anE 	Alpha with 8KByte pages, allocating 1 byte will require the use of 3  	pages of memory (24 KBytes).l */  %     status = lib$create_user_vm_zone( ! 		&cmem___globals.protected_zone,e 		0, 		cmem___vm_allocate,t 		cmem___vm_free,t 		0, 		0, 		&protected_zone_desc );t     if ( ( status & 1 ) != 1 )(       lib$stop( ( int ) &CMEM__UNEXPERR,. 			    1, "LIB$CREATE_USER_VM_ZONE", status );        status = lib$create_vm_zone(# 		&cmem___globals.unprotected_zone,  		0, 		0, 		0, 		0, 		0, 		0, 		0, 		0, 		0, 		&unprotected_zone_desc,c 		0, 		0 );     if ( ( status & 1 ) != 1 )(       lib$stop( ( int ) &CMEM__UNEXPERR,) 			    1, "LIB$CREATE_VM_ZONE", status );e     /*B 	With the 'protect_allocate' flag set, we will put no-access pages> 	before and after the allocated memory.  For that we need some; 	information about the system's memory management hardware.O */  M     getsyi_item_list[ 0 ].buffer_length = sizeof( cmem___globals.page_size );d5     getsyi_item_list[ 0 ].item_code = SYI$_PAGE_SIZE;)E     getsyi_item_list[ 0 ].buffer_address = &cmem___globals.page_size;s4     getsyi_item_list[ 0 ].return_length_address = 0;,     getsyi_item_list[ 1 ].buffer_length = 0;(     getsyi_item_list[ 1 ].item_code = 0;  D     status = sys$getsyiw( 0, 0, 0, &getsyi_item_list, &iosb, 0, 0 );     if ( ( status & 1 ) != 1 )O       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETSYIW for page size", status );o1     else if ( ( iosb.condition_value & 1 ) != 1 )oL       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETSYIW (IOSB) for page size", 							iosb.condition_value );  $     cmem___globals.pagelets_per_page2 			= cmem___globals.page_size / BYTES_PER_PAGELET;     /*B 	We initially allocate a large chunk of memory to maintain all ourD 	information about the user's allocated memory.  Hopefully this willC 	prevent us from fragmenting memory while the user code is running,.@ 	but if need be, we can add more of these structures in a linked 	list. */  F     cmem___allocate_info_cluster( &cmem___globals.first_cluster_ptr );     /*B 	The format of the debug symbol table is undocumented.  So, ratherC 	than try to figure out the routine name associated with an address = 	on the call stack, we'll let the debugger do it for us in a g 	subprocess. */       cmem___start_debugger();     /*D 	Declare a condition handler to interpret an access violation error.> 	We'll use the primary exception vector.  But, if the user hasC 	already established one, then we'll call him after we've displayedr 	our information.r   	THIS ISN'T WORKING YET. */   /*5     status = sys$setexv( 0, cmem___condition_handler,d2 		0, &cmem___globals.previous_exception_handler );     if ( ( status & 1 ) != 1 )@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$SETEXV", status ); */     /*E 	Our global variables are set.  We'll never need to call this routineoB 	again so set the flag that all other routines check and return to 	the caller. */  &     cmem___globals.initialized = TRUE;)     cmem___putmsg( ( int ) &CMEM__INIT );s     /*A 	Translate some logicals to see if the user wants to override our(A 	defaults for some of the features of this package.  The user can-C 	use the VMS Debugger CALL command to dynamically change a setting.m  @ 	We do this after the global 'we have been initialized' flag hasB 	been set as the routines we call to set the values will call this< 	initialization routine if that flag is not set.  We use the= 	routines rather than setting them directly so that they will$= 	display the fact that a logical is overriding the documented 	 	default._ */  I     if( ( equivalence_string = getenv( "CMEM_COLLECT_STACK" ) ) != NULL )_     {d0       sscanf( equivalence_string, "%i", &temp );!       cmem_collect_stack( temp );_     }s  H     if( ( equivalence_string = getenv( "CMEM_COLLECT_TIME" ) ) != NULL )     { 0       sscanf( equivalence_string, "%i", &temp );        cmem_collect_time( temp );     }>   /*C 	By default, we have both boundary checking and protection of freedf? 	pages disabled.  In order to protect freed memory, you need to @ 	have enabled boundary checks.  So, translate the boundary check? 	logical first to allow the user to enable that before enablinga 	protection of freed memory.  E         If the user fails to enable boundary checks before requestings@ 	protection of freed memory, he will get the 'NOBNDYPRT' warning% 	when we invoke 'cmem_protect_freed'.t */ 	eJ     if( ( equivalence_string = getenv( "CMEM_BOUNDARY_CHECK" ) ) != NULL )     { 0       sscanf( equivalence_string, "%i", &temp );"       cmem_boundary_check( temp );     }   I     if( ( equivalence_string = getenv( "CMEM_PROTECT_FREED" ) ) != NULL )      {t0       sscanf( equivalence_string, "%i", &temp );!       cmem_protect_freed( temp );-     }    }o     /*@ 	Restore the setting of the AST enabled bit and get out of here. */  )   if ( previous_ast_state == SS$_WASSET )b     sys$setast( 1 );  	   return;a }e     e  $ int cmem_reset_display_flags( void ) {(  +   struct cluster_info_struct *	cluster_ptr;(   int				block_index;    int				total_block_count;n    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();     total_block_count = 0;  6   for( cluster_ptr = cmem___globals.first_cluster_ptr;C 	cluster_ptr != NULL; cluster_ptr = cluster_ptr->next_cluster_ptr )e   {dK     for( block_index = 0; block_index < BLOCK_INFO_ENTRIES; block_index++ )      {s5       if ( cluster_ptr->block_in_use[ block_index ] )C       {CD 	cluster_ptr->block_info[ block_index ].flags.do_not_display = TRUE;         total_block_count++;       }R     }t   }m  C   printf( "%d blocks currently in use and will not be displayed\n",o 							total_block_count );r     return( 1 ); }m     f   void cmem_show_blocks( void )  {c  +   struct cluster_info_struct *	cluster_ptr;g   int				block_index;s   int				displayed_block_count;    int				hidden_block_count;    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();     displayed_block_count = 0;   hidden_block_count = 0;M  0   printf( "\nAllocated blocks of memory:\n\n" );6   for( cluster_ptr = cmem___globals.first_cluster_ptr;C 	cluster_ptr != NULL; cluster_ptr = cluster_ptr->next_cluster_ptr );   { K     for( block_index = 0; block_index < BLOCK_INFO_ENTRIES; block_index++ )o     {*5       if ( cluster_ptr->block_in_use[ block_index ] )o       {sC 	if ( cluster_ptr->block_info[ block_index ].flags.do_not_display )d 	  hidden_block_count++; 	elseM 	{H 	  cmem___display_block_info( &cluster_ptr->block_info[ block_index ] ); 	  displayed_block_count++;l 	}       }n     }c   }t  #   if ( displayed_block_count == 0 )eB     printf( "  -- All blocks were successfully released --\n\n" );  	   return;p }e     d   int cmem_check_address(  	void *		address ) {n  +   struct block_info_struct *	    block_ptr;h   /*9 	Check to see if the address is within one of our blocks.e */  B   if ( ( block_ptr = cmem___lookup_address( address ) ) != NULL )    {t/     printf( "Address %08X found:\n", address );S+     cmem___display_block_info( block_ptr );o   }d   elseI     printf( "Address %08X not found in any allocated block\n", address );      return( SS$_NORMAL );  }i     B  - int cmem_collect_stack( unsigned char state )r {l   /*F 	This routine determines whether or not we collect the call stack whenE 	allocating a segment of memory.  You can call this from the debuggerA& 	using the CALL command.  For example:  & 	    DBG> CALL cmem_collect_stack( 1 ) */       globalref int CMEM__STACKENA;o   globalref int CMEM__STACKDIS;        int			    status;u    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();  !   cmem___globals.dostack = state;0   if ( cmem___globals.dostack )i%     status = ( int ) &CMEM__STACKENA;    else%     status = ( int ) &CMEM__STACKDIS;z     cmem___putmsg( status );   return( status );f }      l  , int cmem_collect_time( unsigned char state ) {d   /*C 	This routine determines whether or not we collect the time a block C 	was allocated.  You can call this from the debugger using the CALLe 	command.  For example:d  % 	    DBG> CALL cmem_collect_time( 1 )g */       globalref int CMEM__TIMEENA;   globalref int CMEM__TIMEDIS;       int			    status;s    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();      cmem___globals.dotime = state;   if ( cmem___globals.dotime )$     status = ( int ) &CMEM__TIMEENA;   else$     status = ( int ) &CMEM__TIMEDIS;     cmem___putmsg( status );   return( status );  }      s  . int cmem_boundary_check( unsigned char state ) {_   /*A 	This routine allows the user to decide if memory at both ends oftB 	an allocated block is to be protected.  You can call this routine 	from the debugger as shown:  ' 	    DBG> CALL cmem_boundary_check( 1 )s */    "   globalref int CMEM__BNDRYPRTENA;"   globalref int CMEM__BNDRYPRTDIS;       int				status;    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();  +   cmem___globals.protect_allocated = state;i)   if ( cmem___globals.protect_allocated )m(     status = ( int ) &CMEM__BNDRYPRTENA;   else(     status = ( int ) &CMEM__BNDRYPRTDIS;     cmem___putmsg( status );   return( status );g }i        - int cmem_protect_freed( unsigned char state ); {    /*D 	Memory that was allocated with boundary checking can be set so thatC 	an attempt to access it after it is freed will result in an accesss 	violation.   & 	    DBG> CALL cmem_protect_freed( 1 ) */        globalref int CMEM__RELMEMPRT;"   globalref int CMEM__RELMEMREUSE;    globalref int CMEM__NOBNDYPRT;       int				status;    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();  '   cmem___globals.protect_freed = state;s%   if ( cmem___globals.protect_freed ).   {s+     if ( cmem___globals.protect_allocated )l(       status = ( int ) &CMEM__RELMEMPRT;     else(       status = ( int ) &CMEM__NOBNDYPRT;   }o   else(     status = ( int ) &CMEM__RELMEMREUSE;     cmem___putmsg( status );   return( status );i }e     w  ! void * cmem_malloc( size_t size )  {i   /*D 	We use two ifdefs here instead of a 'ifdef __VAX && __DECC' because2 	you get an error if either symbol is not defined. */   #ifdef __VAX  
 #ifdef __DECCr   /*C 	Lars Forsstrom (larfo@weald.air.saab.se) provided the following as D 	the technique to use to get the frame pointer on the VAX when using 	DEC C.   7 	He said that this solution is found in EXC_HANDLING.H.h */  ,   extern int *	    cma$exc_fetch_fp( void );   #endif   #endif    #   globalref int			CMEM__MALLOCFAIL;a!   globalref int			CMEM__UNEXPERR;c       int				status;   int				previous_ast_state;   void *			base_address;,   struct block_info_struct *	block_info_ptr;   int				stack_index;	   #ifdef __ALPHA  %   struct invo_context_blk	invocation;(   #else      int *				frame_pointer;    #endif     /*E 	This routine is AST reentrant.  We accomplish this by disabling ASTs.@ 	while we are on the call stack.  The VAX C versions of 'malloc'1 	always seem to have some AST related problems...l */  '   previous_ast_state = sys$setast( 0 );U     /*D 	The standard "C" library doesn't provide any initialization routineC 	that the user needs to call.  So we need to make sure that we callh1 	the set-up routine in all user visible routines.e */  $   if ( !cmem___globals.initialized )     cmem_initialize();     /*C 	We can allocate from one of two zones depending upon what the usere 	has selected. */  )   if ( cmem___globals.protect_allocated )o.     status = lib$get_vm( &size, &base_address,& 					&cmem___globals.protected_zone );   else.     status = lib$get_vm( &size, &base_address,( 					&cmem___globals.unprotected_zone );   if ( ( status & 1 ) != 1 )   {g=     lib$signal( ( int ) &CMEM__MALLOCFAIL, 1, size, status );s     base_address = NULL;     goto error_return;   }l     /*% 	Fill the allocated memory with 0xAA.a */  9   ots$move5( 0, NULL, FILL_PATTERN, size, base_address );      /*> 	We need to record information about this block in our tables. */  >   block_info_ptr = cmem___allocate_info_block( base_address );  (   block_info_ptr->requested_size = size;/   block_info_ptr->flags.do_not_display = FALSE;h<   block_info_ptr->flags.stack_good = cmem___globals.dostack;:   block_info_ptr->flags.time_good = cmem___globals.dotime;@   block_info_ptr->zone_id = ( cmem___globals.protect_allocated ?C 	cmem___globals.protected_zone : cmem___globals.unprotected_zone );m     /*2 	Get the current time, if we are collecting stats. */     if ( cmem___globals.dotime )   {i5     status = sys$gettim( &block_info_ptr->vms_time );U     if ( ( status & 1 ) != 1 )@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETTIM", status );   }      /*F 	Record the call stack for later display.  Unused entries in the arrayD 	are filled with zeros so that the display routine will know when to 	stop. */     if ( cmem___globals.dostack )    {o     stack_index = 0;  * #ifdef __ALPHA						/* DEC C on ALPHA   */  -     lib$get_curr_invo_context( &invocation );$;     while ( lib$get_prev_invo_context( &invocation ) == 1 )l     {s1       block_info_ptr->call_stack[ stack_index++ ]t- 		= invocation.libicb$q_program_counter[ 0 ];l*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }   + #elif __DECC					    /* DEC C on VAX	    */;  1     frame_pointer = ( int * ) cma$exc_fetch_fp();_  =     while ( _PROBER( 3, sizeof( int ), frame_pointer ) == 1 )e     {eG       block_info_ptr->call_stack[ stack_index++ ] = frame_pointer[ 4 ];_3       frame_pointer = ( int * ) frame_pointer[ 3 ];u*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }e   #else						    /* VAX C		    */   .     frame_pointer = ( int * ) _READ_GPR( 13 );  =     while ( _PROBER( 3, sizeof( int ), frame_pointer ) == 1 )e     { G       block_info_ptr->call_stack[ stack_index++ ] = frame_pointer[ 4 ];h3       frame_pointer = ( int * ) frame_pointer[ 3 ];t*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }c   #endif  *     while ( stack_index < MAX_CALL_DEPTH )6       block_info_ptr->call_stack[ stack_index++ ] = 0;   }i        /*E 	That's it.  Re-enable ASTs if that was how it was configured when wek
 	were called.n */  
 error_return:p  )   if ( previous_ast_state == SS$_WASSET )t     sys$setast( 1 );  $   return( ( void * ) base_address ); }         . void * cmem_calloc( size_t nobj, size_t size ) {S    #   globalref int			CMEM__MALLOCFAIL;u!   globalref int			CMEM__UNEXPERR;        int				status;   int				previous_ast_state;   unsigned int			byte_size;    void *			base_address;,   struct block_info_struct *	block_info_ptr;   int				stack_index;o   #ifdef __ALPHA  %   struct invo_context_blk	invocation;    #endif   /*E 	This routine is AST reentrant.  We accomplish this by disabling ASTsw@ 	while we are on the call stack.  The VAX C versions of 'calloc'1 	always seem to have some AST related problems...  */  '   previous_ast_state = sys$setast( 0 );      /*D 	The standard "C" library doesn't provide any initialization routineC 	that the user needs to call.  So we need to make sure that we call 1 	the set-up routine in all user visible routines.m */  $   if ( !cmem___globals.initialized )     cmem_initialize();     /*C 	We can allocate from one of two zones depending upon what the user_ 	has selected. */     byte_size = size * nobj;)   if ( cmem___globals.protect_allocated )t3     status = lib$get_vm( &byte_size, &base_address,c& 					&cmem___globals.protected_zone );   else3     status = lib$get_vm( &byte_size, &base_address,n( 					&cmem___globals.unprotected_zone );   if ( ( status & 1 ) != 1 )   {eB     lib$signal( ( int ) &CMEM__MALLOCFAIL, 1, byte_size, status );     base_address = NULL;     goto error_return;   }=     /*& 	Fill the allocated memory with zeros. */  3   ots$move5( 0, NULL, 0, byte_size, base_address );      /*  B 	With the value calculated that we will return to the user, we can+ 	allocate a block in our information table.n */  >   block_info_ptr = cmem___allocate_info_block( base_address );  -   block_info_ptr->requested_size = byte_size; /   block_info_ptr->flags.do_not_display = FALSE; <   block_info_ptr->flags.stack_good = cmem___globals.dostack;:   block_info_ptr->flags.time_good = cmem___globals.dotime;@   block_info_ptr->zone_id = ( cmem___globals.protect_allocated ?C 	cmem___globals.protected_zone : cmem___globals.unprotected_zone );      /* 	Go get the current time.  */     if ( cmem___globals.dotime )   {c5     status = sys$gettim( &block_info_ptr->vms_time );E     if ( ( status & 1 ) != 1 )@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETTIM", status );   }      /*F 	Record the call stack for later display.  Unused entries in the arrayD 	are filled with zeros so that the display routine will know when to 	stop. */     if ( cmem___globals.dostack )s   {i     stack_index = 0;   #ifdef __ALPHA  -     lib$get_curr_invo_context( &invocation );l;     while ( lib$get_prev_invo_context( &invocation ) == 1 )T     { 1       block_info_ptr->call_stack[ stack_index++ ]a- 		= invocation.libicb$q_program_counter[ 0 ];m*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }t   #elsea  ! /*	Follow the frame pointer... */N   #endif  *     while ( stack_index < MAX_CALL_DEPTH )6       block_info_ptr->call_stack[ stack_index++ ] = 0;   }          /*E 	That's it.  Re-enable ASTs if that was how it was configured when wes
 	were called.  */  
 error_return:   )   if ( previous_ast_state == SS$_WASSET )r     sys$setast( 1 );  $   return( ( void * ) base_address ); }      e  % void cmem_free( void * base_address )  {   "   globalref int CMEM__FREEWRTFAIL;!   globalref int CMEM__FREEUNALLO;M   globalref int CMEM__UNEXPERR;;       int				status;%   unsigned char			previous_ast_state;i   unsigned char			found_it;a+   struct cluster_info_struct *	cluster_ptr;b   int				block_index;    int				previous_block_index;     /*E 	Scan all the information blocks in all the clusters to see if we cant 	find this address.O */     found_it = FALSE; 1   cluster_ptr = cmem___globals.first_cluster_ptr;t  %   previous_block_index = END_OF_LIST; L   block_index = cluster_ptr->list_head[ cmem___hash_index( base_address ) ];     while ( !found_it )A   {_   /*E 	If we're at the end of a linked list for a particular hash value, wed. 	need to move on to the next cluster (if any). */  %     if ( block_index == END_OF_LIST )o     { D       if ( ( cluster_ptr = cluster_ptr->next_cluster_ptr ) == NULL ) 	break; 
       else       {s$ 	previous_block_index = END_OF_LIST;         block_index = > 		cluster_ptr->list_head[ cmem___hash_index( base_address ) ];       }M     }L   /*B 	If the address in the info block matches what the user passed us,C 	we've found the block.  Otherwise, keep on transversing the linked_ 	list. */       else     {	P       if ( cluster_ptr->block_info[ block_index ].user_address == base_address ) 	found_it = TRUE;f
       else       {d$ 	previous_block_index = block_index;A 	block_index = cluster_ptr->block_info[ block_index ].next_block;c       }.     }A   }e     /*E 	If we didn't find an entry in the tables, then the user is trying to E 	release memory that was never allocated.  Give him a trace back dumpr 	to work with. */     if ( !found_it )   {t=     lib$signal( ( int ) &CMEM__FREEUNALLO, 1, base_address );l   }t     else   {n   /*@ 	If this block is at the head of the list, we need to change the< 	list head.  Otherwise we need to unlink it from the middle. */  .     if ( previous_block_index == END_OF_LIST )     { A       cluster_ptr->list_head[ cmem___hash_index( base_address ) ]g7 			= cluster_ptr->block_info[ block_index ].next_block;t     }      else     {t@       cluster_ptr->block_info[ previous_block_index ].next_block7 			= cluster_ptr->block_info[ block_index ].next_block;      }n     /*? 	Now let's release the memory.  If we are using the "protected"L@ 	model, we pass the address of the information block rather thanD 	the address of the allocated memory.  This prevents our user 'free'@ 	routine from having to scan through all the clusters and linked 	lists to find the block again.n */  7     if ( cluster_ptr->block_info[ block_index ].zone_id_' 					== cmem___globals.protected_zone )_       status = lib$free_vm(y8 	&cluster_ptr->block_info[ block_index ].requested_size,) 	&cluster_ptr->block_info[ block_index ],e3 	&cluster_ptr->block_info[ block_index ].zone_id );e     else       status = lib$free_vm(d8 	&cluster_ptr->block_info[ block_index ].requested_size,6 	&cluster_ptr->block_info[ block_index ].user_address,3 	&cluster_ptr->block_info[ block_index ].zone_id );e  /     if ( status == ( int ) &CMEM__FREEWRTFAIL )>     {e       lib$signal( status ); K       cmem___display_block_info( &cluster_ptr->block_info[ block_index ] );      }*#     else if ( ( status & 1 ) != 1 )sD       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "LIB$FREE_VM", status );     /*$ 	Mark the block as no longer in use. */  4     if ( cluster_ptr->available_block_count++ == 0 )6       cluster_ptr->next_available_block = block_index;  5     cluster_ptr->block_in_use[ block_index ] = FALSE;    }e    
 error_return:(   /*F 	Restore the AST setting before exiting.  Any path out of this routineD 	had better get to this location or else ASTs might not be restored. */  )   if ( previous_ast_state == SS$_WASSET )      sys$setast( 1 );  	   return;n }X     ;  . void * cmem_realloc( void * ptr, size_t size ) {_       int				temp;   void *			new_pointer;a     /*E 	Go get the new space using our allocation routine.  If we are unable A 	to allocate space, then return a NULL pointer.  The old space iseA 	still valid and is still pointed to by the pointer passed as the;  	first argument to this routine. */  $   new_pointer = cmem_malloc( size );   if ( new_pointer == NULL )     return( NULL );      /*E 	If the first argument is a NULL pointer, then this routine acts just_> 	like 'malloc'.  Return a pointer to the uninitialized memory. */     if ( ptr == NULL )     return( new_pointer );     /*E 	Copy the old memory to the new.  If the new block is larger than theAC 	old, the 'cmem_malloc' routine will have fill the extra space with  	our 0xAA check pattern. */  7   if ( ( temp = cmem___get_block_size( ptr ) ) < size )w(     ots$move3( temp, ptr, new_pointer );   else(     ots$move3( size, ptr, new_pointer );     /*? 	Release the old memory.  This will generate a traceback if thec> 	pointer wasn't to a valid block.  Return a pointer to the new 	space.A */     cmem_free( ptr );	   return( new_pointer ); }	