% 	%title	"Perform string substitution"s 	%ident	"V1-003"  8 	sub str_substitute (string dst_str, string src_str		  &$ 				,string old_chr, string new_chr)   !+ ! Version:	V1-003c !e ! Facility:	Library routines.t ! F ! Abstract:	Scan a character string replacing occurences of one string= !		with another and write the result to a destination string.  !0 ! Environment:	User mode.9 !c
 ! History: !s" !	08-Nov-1988, DBS; Version V1-001 ! 001 -	Original version.e" !	29-Dec-1988, DBS; Version V1-002D ! 002 -	Changed the order of the parameters to reflect the standard." !	18-Dec-1995, DBS; Version V1-003( ! 003 -	Converted from FORTRAN to BASIC. !-   !++s ! Functional Description:tE !	This routine will perform one scan of a source character string and E !	replace all occurences of the "old_chr" with "new_chr".  The resulttE !	will be written to the character string dst_str.  For single chara-fB !	cter substitutions, or substitutions of equal length, the sourceB !	and destination can be the same, but for substitutions where theE !	old and new strings are different sizes it is best to use differents) !	strings for the source and destination._ !. ! Calling Sequence:n ! : !	call str_substitute (dst_str, src_str, old_chr, new_chr) !e ! Formal Argument(s):e' !	dst_str.wt.ds	The destination string.m" !	src_str.rt.ds	The source string.9 !	old_chr.rt.ds	The character(s) that should be replaced. ; !	new_chr.rt.ds	The character(s) to substitute for the old.  !e ! Implicit Inputs: !	None !  ! Implicit Outputs:) !	None !r ! Completion Codes:t !	None !( ! Side Effects:w !	None !  !--g 2    	option	type = explicit,					  &! 		constant type = integer,				  & $ 		size = (integer long, real double)  ! ! Type declarations for variablesi   	declare long	dst_inc( 	declare long	dst_loop 	declare long	new_len  	declare long	old_len  	declare long	src_inc  	declare long	src_len. 	declare long	src_loop   !+
 ! Mainline !-	 mainline:q   	src_len	 = len(src_str) 	old_len	 = len(old_chr) 	new_len	 = len(new_chr)
 	src_loop = 1d
 	dst_loop = 1n   	while (src_loop <= src_len)0 		if (mid(src_str, src_loop, old_len) = old_chr) 			then_, 			mid(dst_str, dst_loop, new_len) = new_chr 			src_inc	= old_len 			dst_inc	= new_len 		else7 		mid(dst_str, dst_loop, 1) = mid(src_str, src_loop, 1) 
 		src_inc	= 1 
 		dst_inc = 1  		end if 		src_loop = src_loop + src_inc  		dst_loop = dst_loop + dst_inc  	next    	end sub