 /* DCMAIN.C */( /* Y.L. Noyelle, Supelec, France 1998 */L /* Manages command line, source files, character input/output, and errors */   #include <ctype.h> #include <setjmp.h>  #include <stdlib.h>  #include <string.h> 
 #ifdef VMS9 #  define _POSIX_C_SOURCE  0  /* for "fileno" function */  #  include <stdio.h> #  include <unistd.h>  #  undef _POSIX_C_SOURCE #elif defined _MSC_VER /*#  include <io.h>  #  define isatty _isatty #  define fileno _fileno*/ #  define _POSIX_  #  include <stdio.h> #  include <unistd.h>  #  undef _POSIX_ #elif defined __hpux #  define _INCLUDE_POSIX_SOURCE  #  include <stdio.h> #  include <unistd.h>  #  undef _INCLUDE_POSIX_SOURCE #else  #  include <stdio.h> #  include <unistd.h>  #endif #include "dcmain.h"  #include "dcmain.ph" #include "dcblk.h" #include "dcblk.ph"  #include "dcdecl.h"  #include "dcdecl.ph" #include "dcdir.h" #include "dcdir.ph"  #include "dcexp.ph"  #include "dcext.h" #include "dcext.ph"  #include "dcinst.ph" #include "dcprag.ph" #include "dcrec.h" #include "dcrec.ph"  #include "dcrecdir.ph"  
 #ifdef VMSc #  pragma noinline (changeStreamTo, copyDirPrefix, dispUsg, errExit, fileErr, fmtdMsg, foundOption) 9 #  pragma noinline (getNxtFName, intrnErr, nxtChunkOfTxt) F #  pragma noinline (mngOptListTok, mngOptMsgLimit, mngOptStopAfterMsg)" #  pragma noinline (mngOptVerbose)A #  pragma noinline (searchNxtNL, storeDMacTxt, waitAndAnalAnswer)  #endif  + #define ComputeFileHCode(x) {						       \ &   ThCode fileHCode = 0;							       \ 									       \ I   {register const char *p = x;; while (*p != '\0') {fileHCode +=	       \ $ 						  (ThCode)RealChar(*p); p++;}} #define CSuffix		".c" ; #define DccOptPref	"+z"  /* could be "-z", just the same */  #define DccSymbol	"__dcc"  #define DefineStr	"define "  #define DfltOptVal	-1 
 #ifdef VMS #define DDOpt		"/def=" #define DIOpt		"/incl="  #define DUOpt		"/undef=" #else  #define DDOpt		"-D"  #define DIOpt		"-I"  #define DUOpt		"-U"  #endif- #define EmptyDirName	((const TdirAtom *)"\0") ' #define FinishSrcFile()	{						       \ P   free(curSourceMngtBlk); /* do not free curFileName, because name may still   \4 				    be used (i.e. in a 'NotUsed' warning). */  \6   lineNb = 0;  /* indicates "no valid source line" */} #define IdentHeaderSpace "  " O /*~ zif LitLen(IdentHeaderSpace) != LgtHdrId "Bad 'IdentHeaderSpace' string" */  #define LgtD(x)		(size_t)*x   #define LimChar		(1<<NbBitsChar)0 #define LS2		(LineSize + 1 + 1)  /* +1 for NL */ #define MinDccOptLgt	4) #define NakedFName(x)	(x+(ubyte)*(x - 1))  #define NbSrcLinesKept	2M #define ResetSpaceAtEndOfLine spaceAtEndOfLine = (wrapFl)? LineSize : INT_MAX 0 #define SearchAdjFiles(fileName, x)					       \*   ComputeFileHCode(fileName)						       \P     for (ptr = adjFilesArr; ptr < adjFilesArr + usedSizAdjArr; ptr++) {	       \M       if (fileHCode==ptr->hCode && (StrEq(fileName, ptr->amendFName) || x)) {  #define SeparPattern	"+"= #define SizeBufDef	(509) + 1  /* cf C standard, plus EndCh */ M #define SizeSourceBuffer (NbSrcLinesKept*(LineSize + TransfSize) + 1 + 1 + 1) : #define TxtOptions	"'" DDOpt "', '" DUOpt "', '" DIOpt "'" #define UndefStr	"undef "    typedef FILE *Stream;  typedef ubyte TdirAtom; ! typedef const TdirAtom *TdirName;    typedef struct {   ThCode hCode;    bool noLoadSysFile;    Tstring amendFName;    Tstring adjFName; 
 } TadjFilesS;    typedef struct {   Stream sourceStream;7   char *ptrS, *oldMaxPtrS, *posEndChP1, *nxtPosEndChP1;    TlineNb lineNb; <   char idPlusSource[LgtHdrId + MaxLgtId + SizeSourceBuffer]; } TsourceMngtBlk;   ( typedef struct _TinclStkElt TinclStkElt; struct _TinclStkElt {     TsourceMngtBlk *sourceMngtBlk;   TmngtPriv *listPriv;   Tstring fileName; 
   struct {     bool _hdrFilPerSe:1;     bool _sysHdrFile:1;      bool _diffLc:1; 0     signed int _indentIncra:INT_BIT - 1 - 1 - 1;
   } inclInfo;    TinclStkElt *prec; };: /*~zif sizeof(((TinclStkElt *)0)->inclInfo) != sizeof(int)- 					       "Bad structure for 'inclInfo'" */ ) #define hdrFilPerSe	inclInfo._hdrFilPerSe % #define sHdrFile	inclInfo._sysHdrFile   #define diffLc		inclInfo._diffLc) #define indentIncra	inclInfo._indentIncra    /* Function profiles */ J static TinclStkElt *allocInclStkElt(void), *freeInclStkElt(TinclStkElt *);E static char *manageEndInclude(void), *searchNxtNL(char *, ptrdiff_t); - /****static char *trigraph(char *, char *);*/ O static void changeStreamTo(Stream), checks(void), dispUsg(void), emitCstWdthCh( J   const char *, const char *), emitC(char), errExit(Terr, const Tstring *)K   /*~NeverReturns*/, fileErr(Tstring) /*~NeverReturns*/, flushAndExit(void) P   /*~NeverReturns*/, fmtdMsg(Terr n, const Tstring *parArr), initAdjFiles(void),J   initAll(void), initEmitC(void), initErr(void), initMain(void), intrnErr(,   Tstring, uint *), openSourceFile(Tstring),C   processCUnit(Tstring, bool), prmtrzMsg(Tstring, const Tstring *), )   resetArgPtr(void), storeDMacTxt(Tchar); P static void mngOptListTok(void), mngOptMsgLimit(void), mngOptStopAfterMsg(void),   mngOptVerbose(void);? static bool foundOption(Tstring, bool *), isDccOption(Tstring), G   isHeaderFile(Tstring), isSrcFName(Tstring), openSourceFile1(Tstring), *   waitAndAnalAnswer(void) /*~PseudoVoid*/;/ static TdirName copyDirPrefix(Tstring, size_t);  static Tstring getNxtArg(void); 
 #ifdef LcEqUc : static bool sameLowerCaseName(const char *, const char *); #endif   /* Global variables */ static TadjFilesS *adjFilesArr; 5 static Tstring adjFilesList, sysInclDir = SysInclDir; $ static const Tstring *argvg, *argv1;J static bool callCompil = True, callCompilSeen = False, callCompilW = True,M   chkIndent = True, emitTrailer = True, errSeen = False, notCompiled = False,    warnSeen = False; B static bool chkPossErr = True;	/* check various possible errors */3 static bool chkRdbl = True;	/* check readability */ * static TstringNC copDfltArgs, dfltArgsPtr; static uint ctrdI;B static uint ctrISE = 0;		/* number of '#include' stack elements */ static uint ctrErr, ctrWarn;F static ulong cumNbLines = 0;	/* cumulated number of lines processed */( static TsourceMngtBlk *curSourceMngtBlk;H static int deltaPtrS = 0;  /* device to limit size of loaded chunk while- 					searching next NL (cf searchNxtNL()). */ P static TdirName *dirArray; /* array of directory prefixes for 'include' files */0 static char *endSBuf;	/* end of source buffer */ static Tstring dfltArgs;! static bool givAlwsFName = False; M static bool hdrFilePerSe = False;  /* True if current file has a '.xhx' name, 4 			and is not included with a ComposingHdr d-pragma.7 			Do not forget that "normal" files included in header 6 			files are considered as header files themselves. */K static int hfpsCtrM1 = -1;  /* count (-1) of real header files in 'include'  								       stack. */0 static uint initMsgLimit = DefaultMessagesLimit;$ static bool initStopAfterMsg = True; static bool interactivOutptDev;   static bool initVerbose = False;$ static Tstring lastTrtdFName = NULL;8 static size_t lgtCmdBuf;  /* length of command buffer */B static size_t lgtLastTokBuf;  /* length of "last tokens" buffer */ static bool moreInfMsg = False;  static bool msgLimitFl = False;  static uint msgLimit;  static char *nxtPosEndChP1; G static char *oldMaxPtrS;  /* end of logical (circular) source buffer */ $ static int optionValue = DfltOptVal; static Stream outputStream;  static bool ovfldTokBuf; static CreateParArr(1); B static char *pLastTokBuf,  /* pointer inside last tokens buffer */ 	    *begLastTokBuf = NULL,  	    *endLastTokBuf;' static Tchar *pStoDMacTxt, *endDMacBuf; ' static TinclStkElt *pTopInclStk = NULL;  static bool screenMsg; static Stream sourceStream; K static int spaceAtEndOfLine;  /* number of remaining character slots at end 4 				      of current line (see 'emitC' function). */ static bool stopAfterMsg; , static size_t usedSizAdjArr, totalSizAdjArr; static bool warnFl = True; static bool wrapFl = True;: static const Ttok zSCol[] = {NoSwallowTok, SCOL, EndSTok};   /* External variables */A char *begSBuf;	/* beginning of source buffer (circular buffer) */  bool fileClosed;B char *nlPosP1;	/* 1 + position of last seen 'newline' character */N char *posEndChP1; /* 1 + position of EndCh character indicating end of current 								  text chunk. */ int tabSpacing = 0;   ' int main(int argc, const Tstring *argv)  { <   Tstring lastFName = NULL, lastCUFName = NULL, starterFile;'   bool argErrFl = False, usgFl = False;       outputStream = SUMMARY_STREAM;   initEmitC();   argvg = argv;    if (argc == 1) dispUsg();    else {=     interactivOutptDev = isatty(fileno(MAIN_OUT_STREAM)) > 0;      {        TstringNC w, w1;       Tstring dccDir = DccDir;  7       if ((w = getenv("DCCFILES"))!=NULL && *w!='\0') { ,         MyAlloc(dccDir = w1, strlen(w) + 1);         strcpy(w1, w);J         if ((w = strchr(w1, ' ')) != NULL) {*w++ = '\0'; sysInclDir = w;}}K       MyAlloc(starterFile = w, strlen(dccDir) + (LitLen(StarterFile) + 1));        strcpy(w, dccDir);       strcat(w, StarterFile); P       MyAlloc(adjFilesList = w, strlen(dccDir) + (LitLen(AdjustFilesList) + 1));       strcpy(w, dccDir);"       strcat(w, AdjustFilesList);}?     if ((dfltArgs = getenv("DCCDFLTS")) == NULL) dfltArgs = ""; /     MyAlloc(copDfltArgs, strlen(dfltArgs) + 1); O     /* Search position of last file name in command line, so that it is proces- M        sed with all indicated options, even ones met after that file name. */      {        Tstring w;         resetArgPtr();J       while ((w = getNxtArg()) != NULL) if (isSrcFName(w)) lastFName = w;}I rescanOptL:  /* back here if more than one compilation unit to process */      initAll();/     getTokLvl = 1;  /* don't keep tokens yet */      mngOptListTok();     mngOptMsgLimit();      mngOptVerbose();>     mngOptStopAfterMsg();  /* to come after mngOptVerbose() */     enterBlock();       openSourceFile(starterFile);     dollAlwdInId = True;     prog();      FinishSrcFile() L     initAdjFiles();  /* here, because uses symbol defined in starter file */M     cUnitFName = curFileName = "";  /* for -D, -U options processing (call to 4 				   'manageDir', which may note these values). */.     getTokLvl = 0;  /* start keeping tokens */     {        Tstring arg;         resetArgPtr();.       ctrdI = 0;  /* number of '-I' options */4       lgtCmdBuf = 0;  /* length of command buffer */+       while ((arg = getNxtArg()) != NULL) {          if (isDccOption(arg)) { $           static bool tabFl = False;             parArr1[1] = arg; 0           if (foundOption("ac", &askConstFl)) {}3           else if (foundOption("ae", &allErrFl)) {} 8           else if (foundOption("afn", &givAlwsFName)) {}2           else if (foundOption("bo", &chkBool)) {}5           else if (foundOption("cc", &callCompil)) {} 6           else if (foundOption("ctn", &chkTypName)) {}6           else if (foundOption("cw", &callCompilW)) {}:           else if (foundOption("epl", &chkEmptParList)) {}8           else if (foundOption("frt", &chkFctRetTyp)) {}6           else if (foundOption("inc", &chkInclPos)) {}5           else if (foundOption("ind", &chkIndent)) {} 1           else if (foundOption("lt", &listTok)) { F             if (optionValue >= MaxLgtId + 1) {lgtLastTokBuf = (size_t)- 					 optionValue; optionValue = DfltOptVal;} J             else lgtLastTokBuf = LineSize - LitLen(Dots) - (strlen(errTxt[; 			      LastToks]) - 1);  /* so that just one line used */              mngOptListTok();} >           else if (foundOption("mcc", &verifAllPtrForConst)) {8             if (verifAllPtrForConst) askConstFl = True;}<           else if (foundOption("mic", &moreIndexTypeChk)) {}5           else if (foundOption("msg", &msgLimitFl)) { #             if (optionValue >= 0) { /               initMsgLimit = (uint)optionValue; (               optionValue = DfltOptVal;}             mngOptMsgLimit();}3           else if (foundOption("nui", &warnNUI)) {} 3           else if (foundOption("nup", &warnNUP)) {} 1           else if (foundOption("nw", &noWarn)) {} 5           else if (foundOption("pe", &chkPossErr)) {} :           else if (foundOption("pnt", &chkNmdTypParFl)) {}4           else if (foundOption("po", &chkPortbl)) {}2           else if (foundOption("rd", &chkRdbl)) {}9           else if (foundOption("sam", &initStopAfterMsg)) !             mngOptStopAfterMsg(); 4           else if (foundOption("sy", &printStat)) {}0           else if (foundOption("tab", &tabFl)) {"             if (optionValue > 0) {'               tabSpacing = optionValue; )               optionValue = DfltOptVal;}} 6           else if (foundOption("tr", &emitTrailer)) {}4           else if (foundOption("uc", &chkNumCst)) {}0           else if (foundOption("usg", &usgFl)) {3             if (usgFl) {dispUsg(); usgFl = False;}} C           else if (foundOption("ve", &moreInfMsg)) mngOptVerbose(); E           else if (foundOption("vve", &initVerbose)) mngOptVerbose(); 1           else if (foundOption("wa", &warnFl)) {} 1           else if (foundOption("wr", &wrapFl)) {}            else {D             if (lastTrtdFName == NULL) fmtdMsg(UnknOption, parArr1);             argErrFl = True;} *           if (optionValue != DfltOptVal) {F             if (lastTrtdFName == NULL) fmtdMsg(IgndCharsOpt, parArr1);%             optionValue = DfltOptVal;              argErrFl = True;} L           /* Take option into account immediatly, because -D, -U, -I options& 						management may create errors. */F           screenMsg = !(allErrFl | chkEmptParList | moreIndexTypeChk |7 		chkNmdTypParFl) & askConstFl & chkBool & callCompil & 2 		chkFctRetTyp & 	chkInclPos & warnNUI & warnNUP &0 		chkPossErr & chkPortbl & chkRdbl & chkNumCst;}         else {           int dOptionSeen;  O           if (strncmp(arg, DIOpt, LitLen(DIOpt)) == 0) ctrdI++; /* count number  							     of '-I' options. */ K           else if ((dOptionSeen = strncmp(arg, DDOpt, LitLen(DDOpt)))==0 || B 		  strncmp(arg, DUOpt, LitLen(DUOpt))==0) {  /* '-D/-U' option */9             for (;;) {  /* only there to avoid 'goto's */ 5               Tchar bufDef[SizeBufDef + LgtHdrId], c; (               register Tstring ptrInArg;  %               if (dOptionSeen == 0) { I                 strncpy(&bufDef[LgtHdrId], DefineStr, LitLen(DefineStr)); C                 pStoDMacTxt = &bufDef[LitLen(DefineStr) + LgtHdrId]  								  /*~LocalAdr*/;2                 ptrInArg = &(arg)[LitLen(DDOpt)];}               else {G                 strncpy(&bufDef[LgtHdrId], UndefStr, LitLen(UndefStr)); B                 pStoDMacTxt = &bufDef[LitLen(UndefStr) + LgtHdrId] 								  /*~LocalAdr*/;2                 ptrInArg = &(arg)[LitLen(DUOpt)];}E               endDMacBuf = &bufDef[0] + sizeof(bufDef) /*~LocalAdr*/; Q               while (c = *ptrInArg++, isAlfa(c)) storeDMacTxt(c);  /* store macro  									name. */ %               if (dOptionSeen == 0) { "                 storeDMacTxt(' ');P                 if (c == '\0') storeDMacTxt('1');/* "1" is default macro text */K                 else if (c != '=') {errWS(BadDOption | Warn2, arg); break;} -                 else {  /* copy macro body */ F                   while ((c = *ptrInArg++) != '\0') storeDMacTxt(c);}}J               else if (c != '\0') {errWS(BadDOption | Warn2, arg); break;}"               storeDMacTxt(EndCh);D               posEndChP1 = NULL;  /* previous EndCh = end of text */O               if (endDMacBuf == NULL /* buffer overflow */) {errWS(BadDOption |  							    Warn2, arg); break;}                dirLineFl = True; 7               srcPtr = &bufDef[LgtHdrId] /*~LocalAdr*/; H               /* Prepare to print pseudo source line in case of error *//               bufDef[LgtHdrId - 1 - 1] = EndCh; *               bufDef[LgtHdrId - 1] = '\n';               nlPosP1 = srcPtr; 1               begSBuf = &bufDef[0] /*~LocalAdr*/; @               oldMaxPtrS = &bufDef[NbElt(bufDef)] /*~LocalAdr*/;               manageDir();               RestoSmshCh;               break;}}P           lgtCmdBuf += strlen(arg) + 1;  /* +1 because of separating space; use-; 			  less for already processed compilation units names. */             if (isSrcFName(arg)) {P             if (arg == lastFName) lastCUFName = lastFName;  /* for last compila-/ 	    				     tion unit, take also into account ( 					     possible following options. */H             else if (lastTrtdFName != NULL) {  /* skip already processed 							   compilation units. */e>               if (arg == lastTrtdFName) lastTrtdFName = NULL;}6             else {  /* process new compilation unit */'               processCUnit(arg, False);e"               lastTrtdFName = arg;J               changeStreamTo(MAIN_OUT_STREAM);  /* separating pattern more 								useful there. */               {X                 int i;  C                 for (i = 0; i < LineSize/LitLen(SeparPattern); i++)f&                   emitS(SeparPattern);                 emitC('\n');} -               changeStreamTo(SUMMARY_STREAM);c2               goto rescanOptL /*~BackBranch*/;}}}}(       processCUnit(lastCUFName, True);}}   changeStreamTo(NULL);e$   if (argErrFl) return EXIT_ERRORS2;   return (errSeen)     ? (callCompilSeen)       ? EXIT_ERRORS2       : EXIT_ERRORS1     : (warnSeen)       ? (notCompiled)c         ? EXIT_WARNINGS2         : EXIT_WARNINGS1       : EXIT_SUCCESS;. }   ; static void processCUnit(Tstring cUFName, bool lastFNameFl)n {tJ   TdirName *ptrDirArray;  /* pointer in array of directories for 'include' 								       files. */   char *cmdBuf, *ptrCmdBuf;    register Tstring arg;O   bool fNameSeen = False;m     /* Get compiler name */    {i     TlitString w; F     static char locBuf[] = IdentHeaderSpace DccSymbol ";";  /* ';' for& 						     getLitString() workings. */  5     getTokLvl = 1;  /* prevent tokens from showing */	     srcPtr = &locBuf[LgtHdrId];hH     if (NxtTok()!=CSTST || (w = getLitString(), srcPtr != &locBuf[NbElt(- 					 locBuf) - 1])) errExit(BadUUdcc, NULL);f"     lgtCmdBuf += initGetStrLit(w);     getTokLvl = 0;     RestoSmshCh;}	@   /* Allocate array of directory prefixes for 'include' files */M   MyAlloc(dirArray, (ctrdI + 1 + 1 + 1)*sizeof(*dirArray));  /* +3 because ofdB 		       compilUnitFile directory, SysInclDir, and ending NULL. */D   /* Allocate compile command buffer (to be passed to system via the 							  'system' function). */    MyAlloc(cmdBuf, lgtCmdBuf);    ptrCmdBuf = cmdBuf;aP   while ((*ptrCmdBuf++ = getNxtStrLitChar()) != '\0') {} /* put compiler name *//   exitBlock();  /* because of getLitString() */l   ptrCmdBuf--;   ptrDirArray = dirArray + 1;i   cUnitFName = NULL;   resetArgPtr();'   while ((arg = getNxtArg()) != NULL) {n  #     if (isDccOption(arg)) continue;	A     if (strncmp(arg, DIOpt, LitLen(DIOpt)) == 0) *ptrDirArray++ = B 		copyDirPrefix(arg + LitLen(DIOpt), strlen(arg + LitLen(DIOpt)));I     else if (strncmp(arg, DDOpt, LitLen(DDOpt))==0 || strncmp(arg, DUOpt,(I 	     LitLen(DUOpt))==0) {}  /* '-D'/'-U' option already taken care of */ &     else {  /* file name by default */       fNameSeen = True;j       if (arg != cUFName) { D         if (isSrcFName(arg)) continue;}  /* ignore already processed& 						       compilation unit name. */       else {         Tstring begOfFName;u         size_t lgtPath;t
 #ifdef VMS         size_t posVersNb;r #endif  #         begOfFName = skipPath(arg);)-         lgtPath = (size_t)(begOfFName - arg);,A         *dirArray = (lgtPath != 0)? copyDirPrefix(arg, lgtPath) :I 							       &EmptyDirName[0];t
 #ifdef VMS	         {rL           /* Add '.c' type suffix if none; remove possible version number in 							     'stripped' name. */nE           size_t suffLgt = (strchr(begOfFName, '.') == NULL)? LitLen(;- 					      CSuffix) /* no type suffix */ : 0;o           Tstring w;           TstringNC wm;u  ?           posVersNb = (((w = strchr(begOfFName, ';')) == NULL)? 4 				 strlen(begOfFName) : (size_t)(w - begOfFName));H           MyAlloc(cUnitFName = wm, strlen(arg) + (LitLen(CSuffix) + 1));0           strncpy(wm, arg, lgtPath + posVersNb);F           if (suffLgt != 0) strcpy(wm + lgtPath + posVersNb, CSuffix);A           strcpy(wm + lgtPath + posVersNb + suffLgt, begOfFName +;- 					   posVersNb);  /* add version number */o           posVersNb += suffLgt;d7           MyAlloc(strpdCUnitFName = wm, posVersNb + 1);n7           strncpy(wm, cUnitFName + lgtPath, posVersNb); $           *(wm + posVersNb) = '\0';} #elsee         cUnitFName = arg;r%         strpdCUnitFName = begOfFName;T #endif       }}/     /* Add argument to compiler command line */ /     *ptrCmdBuf++ = ' ';  /* separating space */(.     while (*arg!= '\0') *ptrCmdBuf++ = *arg++;1     if (cUnitFName!=NULL && !lastFNameFl) break;}r&   *ptrCmdBuf = '\0';  /* ending NUL */M   if (!fNameSeen || cUnitFName==NULL && !callCompil) errExit(NoCUName, NULL);rA   *ptrDirArray++ = copyDirPrefix(sysInclDir, strlen(sysInclDir));u   *ptrDirArray = NULL;O   if (cUnitFName != NULL) {  /* if something to compile, do not skip to link */t8     if (tabSpacing == 0) tabSpacing = DefaultTabSpacing;#     if(! chkIndent) indentIncr = 0;o     dollAlwdInId = False;sJ     mskBool = (chkBool)? (boolTypeElt.typeSort = boolCstTypeElt.typeSort =@ 		Bool, Bool|BoolOpnd) : (boolTypeElt.typeSort = boolCstTypeElt.4 				  typeSort = Int, NumEnumBool|PtrPoss|BoolOpnd);L     cumDeltaLineNb = 0; cumNbSkippedLines = 0;  /* may have been modified by& 						'starter' or 'initAdj' files. */     openSourceFile(cUnitFName);)E     if (isHeaderFile(cUnitFName)) {cumNbLines = 1; errWS(CompHdrFile,P 								   cUnitFName);}
     else {&       changeStreamTo(MAIN_OUT_STREAM);       prog();}     exitBlock();"     checkCondStkAndDeleteMacros();     freeTCB();#     changeStreamTo(SUMMARY_STREAM); 
     checks();g/     if (emitTrailer || (ctrErr | ctrWarn)!=0) {c#       CreateParArr(2) /*~DynInit*/;b         parArr2[1] = cUnitFName;;       parArr2[2] = longToS((long)(cumNbLines + lineNb - 1 +i- 					   cumDeltaLineNb - cumNbSkippedLines));e)       prmtrzMsg(errTxt[EndMsg], parArr2);s$       if ((ctrErr | ctrWarn) != 0) {         TnbBuf buf;o  &         bufLongToS((long)ctrErr, buf);         parArr2[1] = &buf[0]; ,         parArr2[2] = longToS((long)ctrWarn);-         prmtrzMsg(errTxt[ErrWarn], parArr2);}e%       else emitS(errTxt[NoErrWarn]);}t9     FinishSrcFile()  /* lineNb not used any more here */ c
 #ifdef VMS-     free((TstringNC /*~OddCast*/)cUnitFName);i2     free((TstringNC /*~OddCast*/)strpdCUnitFName); #endif   } M   if (ctrWarn != 0) {warnSeen = True; if (! callCompilW) notCompiled = True;}rK   if (ctrErr != 0) {errSeen = True; if (callCompil) callCompilSeen = True;}d7   else if (callCompil && (callCompilW || ctrWarn==0)) {o     changeStreamTo(NULL);t     (void)system(cmdBuf);}   /* Free allocated memory */s   free(cmdBuf); N   if (*dirArray != &EmptyDirName[0]) free((TdirAtom * /*~OddCast*/)*dirArray);   ptrDirArray = dirArray + 1;    do {2     free((TdirAtom * /*~OddCast*/)*ptrDirArray++);!   } while (*ptrDirArray != NULL);1   free(dirArray);l }i  ; static AllocXElt(allocInclStkElt, TinclStkElt *, ctrISE, ;)t  $ static void changeStreamTo(Stream x) {t   static bool errSeen = False;  K   if (spaceAtEndOfLine < 0) {emitC('\n'); ResetSpaceAtEndOfLine;}  /* flushF 								     emitC(). */L   if (!errSeen && fflush(outputStream)!=0) {errSeen = True; sysErr(ExCod2);}"   if (x != NULL) outputStream = x; }t   static void checks(void) {tK   if (nestLvl != -1) {intrnErr("nestLvl", (uint *)&nestLvl); nestLvl = -1;}d5   if (ctrBSE > 1)  intrnErr("ctrBlkStkElt", &ctrBSE);r2   if (ctrCE != 0)  intrnErr("ctrCaseElt", &ctrCE);6   if (ctrCSE != 0) intrnErr("ctrCondStkElt", &ctrCSE);3   if (ctrDE != 0)  intrnErr("ctrDeclElt=", &ctrDE);a6   if (ctrDIE != 0) intrnErr("ctrDescrIdElt", &ctrDIE);6   if (ctrISE != 0) intrnErr("ctrInclStkElt", &ctrISE);4   if (ctrMSB != 0) intrnErr("ctrMacroBlk", &ctrMSB);5   if (ctrMSE != 0) intrnErr("ctrMacStkElt", &ctrMSE);r8   if (ctrNI != 0)  intrnErr("ctrNotInitVarElt", &ctrNI);M   if (ctrNSB > 1+1+1 /* 3 because first name block never freed, and two otherfG 	may be kept not freed (see exitBlock() ) */) intrnErr("ctrNameStoBlk",t 								       &ctrNSB);3   if (ctrSE != 0)  intrnErr("ctrSemanElt", &ctrSE);n6   if (ctrTCB != 0) intrnErr("ctrTypCombElt", &ctrTCB);2   if (ctrTE != 0)  intrnErr("ctrTypeElt", &ctrTE);6   if (ctrTLE != 0) intrnErr("ctrTagListElt", &ctrTLE);)   intrnErr("", NULL);  /* flush buffer */  }w  9 static TdirName copyDirPrefix(Tstring string, size_t lgt)h {a   TdirName res;   P   if (lgt >= UCHAR_MAXC) {parArr1[1] = string; errExit(StringTooLong, parArr1);}J   MyAlloc(res, lgt + 1 + 1);  /* +1 for length field, +1 for ending '/' */4   memcpy((char * /*~OddCast*/)res + 1, string, lgt);
 #ifdef VMS0   *(TdirAtom * /*~OddCast*/)res = (TdirAtom)lgt; #else <   *(TdirAtom * /*~OddCast*/)(res + lgt + 1) = (TdirAtom)'/';6   *(TdirAtom * /*~OddCast*/)res = (TdirAtom)(lgt + 1); #endif
   return res;  }s   static void dispUsg(void)  {f
   TnbBuf buf;D   CreateParArr(4) /*~DynInit*/;   "   bufLongToS((long)LineSize, buf);   parArr4[1] = *argvg;0   parArr4[2] = longToS((long)DefaultTabSpacing);   parArr4[3] = &buf[0];    parArr4[4] = TxtOptions;   fmtdMsg(Use1, parArr4); )   if (isatty(fileno(outputStream)) > 0) {w     fmtdMsg(ProceedMsg, NULL);     waitAndAnalAnswer();}d   fmtdMsg(Use2, parArr4);i }+   #define HyphenDetec	2 K static char bufChar[HyphenDetec + LineSize + 1 + 1] = "  ",  /* initialized(, 					because of hyphen detection; +1 for en-- 					ding '\0', +1 for overflow detection. */t             *ptrBufCh;F static bool partWord = False;  /* flag "previous word not complete" */   static void initEmitC(void)p {nO   bufChar[0] = bufChar[1] = ' ';  /* initialized because of hyphen detection */e#   ptrBufCh = &bufChar[HyphenDetec];r   spaceAtEndOfLine = 0;a   partWord = False;} }e   static void emitC(char x)rP /* Manages line wrap-around (tries to wrap only when a space or hyphen character/    is seen, while avoiding lines too empty). */  { K #define MyFPuts(buf) {if (fputs(buf, outputStream) == EOF) sysErr(ExCod2);}m   bool ovfl = False;     if (x != '\n') {     *ptrBufCh++ = x;H     if (! (x==' ' || x=='-' && isalpha(*(ptrBufCh - HyphenDetec - 1)) &&2 				isalpha(*(ptrBufCh - HyphenDetec)))) { /* dash: 			supposed to be hyphen only if last but one character is8 			letter (not only last because of word "d-pragma"). */0       if (ptrBufCh < AdLastElt(bufChar)) return;       ovfl = True;}}   {e)     char *begBuf = &bufChar[HyphenDetec];      int nbChar;t  G     *((x==' ' && ptrBufCh - begBuf==spaceAtEndOfLine + 1)? --ptrBufCh : 9 			ptrBufCh) = '\0';  /* ending character (remove uselessr& 						       space at end of line). */J     while ((nbChar = (int)(ptrBufCh - begBuf))>spaceAtEndOfLine || ovfl &&? 		nbChar==spaceAtEndOfLine) {  /* in case of overflow, keep one & 						 slot at end of line for '\'. */I       if (spaceAtEndOfLine>TolLostSpace || (partWord /* previous word note; 			 completely written */ || ovfl) && spaceAtEndOfLine>0) {dH         char *nxtBegBuf = begBuf + spaceAtEndOfLine - 1, c = *nxtBegBuf;  +         *nxtBegBuf = '\0';  /* for fputs */w@         if (*begBuf != '\0') {MyFPuts(begBuf)  MyFPuts("\\\n") }*         else if (partWord) MyFPuts("\\\n")P         else MyFPuts("\n")  /* case last character of line is space or hyphen */8         *nxtBegBuf = c;  /* restore smashed character */         begBuf = nxtBegBuf;}       else MyFPuts("\n")       ResetSpaceAtEndOfLine;}xK     if (*begBuf != '\0') MyFPuts(begBuf)  /* write (last part of) buffer */t9     ptrBufCh = &bufChar[HyphenDetec];  /* buffer empty */DM     if (x == '\n') spaceAtEndOfLine = -1;  /* to have NL inserted before nextd 								    emission. */$     else spaceAtEndOfLine -= nbChar;     partWord = ovfl;}r #undef MyFPuts #undef HyphenDetec }t  ' /*~Undef bufChar, ptrBufCh, partWord */l  F static void emitCstWdthCh(register const char *bStr, const char *eStr)I /* Emits all character between 'bStr' (included) and 'eStr' (excluded) as O    constant width characters (tabs and non-printable characters become spaces);l@    otherwise, LineSize would not be identical to line length. */ {u	   char c;I     while (bStr != eStr) {     c = *bStr++;5     emitC((IsVisibleChar(c) || c == '\n')? c : ' ');}o }n   void emitS(Tstring x)  {u4   if (x != NULL) {while (*x != '\0') {emitC(*x++);}} }d  ! void endPrgF(register char *ptrS)  { #   if (! fileClosed) ilgCharF(ptrS);r   else {)     BackUp;  /* do not go beyond EndCh */b<     if (dirLineFl) {dirLineFl = False; curTok.tok = ENDDIR;}
     else {       RestoSmshCh;G       if (pTopInclStk != NULL) {ptrS = manageEndInclude(); curTok.tok =  								    WHITESPACE;}9       else {curTok.tok = ENDPROG; condDirSkip = False;}}}    srcPtr = ptrS; }o   static uint minMsgLvl = 0;   static void initErr(void)  {    minMsgLvl = 0; }"  ( void err(Terr n, const Tstring parArr[]) {d*   Terr errNo = n & (EndErrInfoBits -1 -1);'   bool warn = n&WarnMsk || dpragNst!=0;   -   if (mngConc) {  /* if inside ## operator */ L     if (concatErr == NoConcErr) concatErr = errNo;  /* retain first error */     return;}3   if (peepTok) return;  /* will be seen again... */ (   if (InsideMacro && curTok.tok==SCOL) {U     static const Terr retainedErr[] = {RSBrExptd, RBraOrCommaExptd, RParOrCommaExptd,f 							  RBraExptd, RParExptd};U&     const Terr *ptr = &retainedErr[0];       do {       if (errNo == *ptr++)(         if (checkSColAtEndMac()) return;         else break;g6     } while (ptr < &retainedErr[NbElt(retainedErr)]);}   if (warn && (!warnFlD                || sysHdrFile  /* no warning in system header file */H                || sysMacro && n&CWarn  /* no Cwarning in system macro */*                || n&PossErr && !chkPossErr%                || n&Rdbl && !chkRdbl)        || errNo==NoErrMsg       || n&WarnMsk && noWarn       || ignoreErr) return;P!   if (dpragNst==0 && screenMsg) {d9     uint msgLvl = (warn)? (uint)(n & WarnMsk) : UINT_MAX;;  :     if (msgLvl < minMsgLvl) return;  /* screen messages */     minMsgLvl = msgLvl;}    if ((ctrWarn | ctrErr) == 0) {!     emitS(errTxt[WarnErrInFile]);n     emitS(cUnitFName);     emitS("\" *****\n");M     if (stopAfterMsg) {emitS(errTxt[StopAftMsgBanner]); waitAndAnalAnswer();}{     emitC('\n');}a   else emitS(errTxt[SeparMsg]);c@   if (!stopAfterMsg && msgLimit--==0) errExit(TooManyMsg, NULL);M   if (!(n & NoDispLine) && (lineNb!=0 || dirLineFl)) {  /* not no printing ofp 									line. */,     char *ptrS;n     const char *expl; O     ptrdiff_t distErrBegLine;  /* nb of characters between the beginning of thed4 				      line and the error position (included). */     char savInfoId[LgtHdrId];   N     if (adSmshCh != NULL) {   /* put back in place possible characters smashed- 					  by an identifier length/name space. */d>       savInfoId[0] = *adSmshCh; savInfoId[1]= *(adSmshCh + 1);:       *adSmshCh = smshCh[0]; *(adSmshCh + 1) = smshCh[1];}     ptrS = srcPtr;M     if ((distErrBegLine = ptrS - nlPosP1) < 0) distErrBegLine += oldMaxPtrS -/4 				       begSBuf; /* because of circular buffer */%     if (distErrBegLine <= LineSize) {tO       /* Beginning of line not very far from error position, so (end of) prece-uI          ding line, and (beginning of) current line, can be displayed. */rC       /* Search beginning of preceding line; 'expl' points on it */        uint ctr;h  @       for (expl = nlPosP1 - 1, ctr = LS2 - 1; ctr != 0; ctr--) {/         if (expl == begSBuf) expl = oldMaxPtrS;;P         if (*(--expl) == EndCh) {expl = begSBuf - 1; goto foundNLL;}  /* no line3 				    before (testing lineNb == 1 is not correct,n) 				    because of possible splicing). */r*         if (*expl == '\n') goto foundNLL;}3       /* Beginning of preceding line not visible */        emitS(Dots);       expl += LitLen(Dots); 	 foundNLL:*=       if (++expl >= oldMaxPtrS) expl -= oldMaxPtrS - begSBuf; I       ptrS = searchNxtNL(ptrS, distErrBegLine);}  /* (local copy of) ptrS  							moved to end of line. */ 
     else {I       /* Beginning of line too far from error position; only current lineSO          (broken into two physical lines, the first one being terminated by '\' M          to indicate logical continuation) can be displayed; 'expl' points on /          first char of second physical line. */sO       const char *begErrLine;  /* pointer on 1st char of first physical line */g  M       if (distErrBegLine <= NbSrcLinesKept*LineSize - 1) {  /* - 1 because ofp 								  ending '\'. *//         /* Beginning of current line visible */f'         distErrBegLine -= LineSize - 1;          begErrLine = nlPosP1;k+         expl = begErrLine + (LineSize - 1);nK         ptrS = searchNxtNL(ptrS, distErrBegLine);}  /* (local copy of) ptrS  							moved to end of line. */mF       else {      /* beginning of current line not visible : put error4 				     position at end of second physical line. */         emitS(Dots);"         distErrBegLine = LineSize;N         if ((begErrLine = ptrS - (NbSrcLinesKept*LineSize - (LitLen(Dots)) - 1@ 		    /* - 1 because of ending '\' */)) < begSBuf) begErrLine += 							   oldMaxPtrS - begSBuf; <         expl = begErrLine + (LineSize - (LitLen(Dots)) - 1);> /*        if ((ptrSM1 = ptrS) == begSBuf) ptrSM1 = oldMaxPtrS;F         if (*--ptrSM1=='\n' || ptrSM1==posEndChP1-1) ptrS = ptrSM1;*/}+       /* Print first part of source line */);       if (expl >= oldMaxPtrS) expl -= oldMaxPtrS - begSBuf;EO       if (expl < begErrLine) {emitCstWdthCh(begErrLine, oldMaxPtrS); begErrLine  								     = begSBuf;}&       emitCstWdthCh(begErrLine, expl);       emitS("\\\n");}e,     /* Print (second part of) source line */G     if (ptrS < expl) {emitCstWdthCh(expl, oldMaxPtrS); expl = begSBuf;}l     emitCstWdthCh(expl, ptrS);*     /* Print caret under error position */     emitC('\n');     if (distErrBegLine != 0)1       while (--distErrBegLine != 0) {emitC('_');}I     emitS("^\n");SF     if (adSmshCh != NULL) {   /* put back in place possible identifier 							   length/name space. */rA       *adSmshCh = savInfoId[0]; *(adSmshCh + 1) = savInfoId[1];}}=L   if (warn) ctrWarn++; else {ctrErr++; ignoreErr = !allErrFl && curTok.tok!= 								       ENDPROG;}   {gF     bool savGAFN = givAlwsFName, savMIF = moreInfMsg, explain = False;  	 explainL:r     if (warn) {p       emitS(errTxt[Warning]); <       emitC('0' + ((uint)(n & WarnMsk) >> INT_BIT - 1 - 1));4       /*~ zif (uint)WarnMsk != 3u<<(INT_BIT - 1 - 1)& 						 "Change previous expression "*/       emitC(')');}     else emitS(errTxt[Error]);E     if (!(n & NoDispLine) || givAlwsFName) {  /* print file name/line) 								      number. */       TnbBuf bufLineNo;=         emitS(errTxt[Line]);I       bufLongToS((long)lineNb, bufLineNo); /* so 'longToS' buffer remainsl 							       uncorrupted... */        emitS(bufLineNo);a4       if (curFileName!=cUnitFName || givAlwsFName) {         emitS(errTxt[File]);         emitS(curFileName); %         emitS(errTxt[EndFileName]);}})     emitS(": ");G     prmtrzMsg(errTxt[errNo], parArr);  /* parametrized error message */;V     if (listTok && (!(n & NoDispLine) || explain) && (!stopAfterMsg || moreInfMsg)) { ; 			/* output last tokens taken into account before error */*       emitS(errTxt[LastToks]);P       if (ovfldTokBuf) {emitS(Dots); emitCstWdthCh(pLastTokBuf, endLastTokBuf);}1       emitCstWdthCh(begLastTokBuf, pLastTokBuf);}s     emitC('\n');H     if (stopAfterMsg && (explain = waitAndAnalAnswer())) {givAlwsFName =; 			True; moreInfMsg = True; goto explainL /*~BackBranch*/;}      givAlwsFName = savGAFN;=     moreInfMsg = savMIF;}g }t   /*~Undef minMsgLvl */   D static void errExit(Terr n, const Tstring *parArr) /*~NeverReturns*/ { (   if (n != NoErrMsg) fmtdMsg(n, parArr);   flushAndExit();  }   9 static void fatalErr(Terr n, Tstring x) /*~NeverReturns*/m { !   changeStreamTo(SUMMARY_STREAM);n   mngConc = ignoreErr = False;   errWS(n, x);   flushAndExit();L };  7 static void fileErr(Tstring fileName) /*~NeverReturns*/  {r#   fatalErr(FileOpenFail, fileName);  }   0 static void flushAndExit(void) /*~NeverReturns*/ {)   changeStreamTo(NULL);e   exit(EXIT_FAILURE);N })  2 static void fmtdMsg(Terr n, const Tstring *parArr) {L #ifndef VMS    static bool frstTime = True;  0   if (frstTime) {emitC('\r'); frstTime = False;} #endif   prmtrzMsg(errTxt[n], parArr);;   emitC('\n'); }w  / static bool foundOption(Tstring opt, bool *pFl)	 {    bool flagVal;    size_t lgtOpt = strlen(opt);  J   if (*opt!=parArr1[1][LitLen(DccOptPref)] || strncmp(parArr1[1] + LitLen(4 				   DccOptPref), opt, lgtOpt) != 0) return False;!   flagVal = (*parArr1[1] == '+');b   lgtOpt += LitLen(DccOptPref);F   if (*pFl == flagVal) {K     if (lastTrtdFName == NULL) {  /* to not repeat already given message */  #define MaxSizDccOpt	6"       Tchar buf[MaxSizDccOpt + 1];  7       if (lgtOpt > MaxSizDccOpt) lgtOpt = MaxSizDccOpt;  #undef MaxSizDccOpt&'       strncpy(buf, parArr1[1], lgtOpt);'       buf[lgtOpt] = '\0';f       {e%         CreateParArr(1) /*~DynInit*/;e           parArr1[1] = &buf[0];i)         fmtdMsg(AlrdSeenOpt, parArr1);}}}(   else *pFl = flagVal;#   if (parArr1[1][lgtOpt] != '\0') {U+     const Tchar *ptr = &parArr1[1][lgtOpt];p       optionValue = 0;     do {A       if (! isdigit(*ptr)) {optionValue = DfltOptVal - 1; break;}r8       optionValue = optionValue*Base10 + (*ptr++ - '0');     } while (*ptr != '\0');}   return True; }t  @ static FreeXElt(freeInclStkElt, TinclStkElt *, ctrISE, ; , prec)   static Tstring getNxtArg(void)7 /* Gives back pointer on next argument (NULL at end) */d {e   Tstring begOpt;   Q   while (*dfltArgsPtr == ' ') dfltArgsPtr++;  /* skip possible starting spaces */mO   if (*dfltArgsPtr == '\0' /* environment string exhausted */) return *++argv1;	   begOpt = dfltArgsPtr; A   while (*++dfltArgsPtr != '\0') {  /* search end of parameter */      if (*dfltArgsPtr == ' ') {8       *dfltArgsPtr++ = '\0';  /* put parameter ending */       break;}}   return begOpt; }(    static Tstring getNxtFName(void) {c   Tchar *ptrD, *w;   TlitString ptrO;  3   if ((ptrO = getLitString()) == NULL) ptrD = NULL;n   else {'     MyAlloc(ptrD, initGetStrLit(ptrO));D
     w = ptrD;mI     while ((*w++ = getNxtStrLitChar()) != '\0') {}}  /* save file name inc 							     contiguous area. */ /   exitBlock();  /* because of getLitString() */b   return ptrD; }r   static void initAdjFiles(void) {=   openSourceFile(adjFilesList);    while (NxtTok() != ENDPROG) {2 #define IncrSizeAdjArr 5G     if (usedSizAdjArr == totalSizAdjArr) {  /* array full; extend it */         if (totalSizAdjArr == 0) {(         totalSizAdjArr = IncrSizeAdjArr;C         MyAlloc(adjFilesArr, sizeof(TadjFilesS) * totalSizAdjArr);}        else {)         totalSizAdjArr += IncrSizeAdjArr;TD         if ((adjFilesArr = realloc(adjFilesArr, sizeof(TadjFilesS) *; 			 totalSizAdjArr)) == NULL) sysErr(errTxt[RanOutOfMem]);}a #undef IncrSizeAdjArrt     }N     {        Tstring w;  >       adjFilesArr[usedSizAdjArr].noLoadSysFile = Found(EMARK);6       if ((w = getNxtFName()) == NULL) skipTok(zSCol);       else {2         adjFilesArr[usedSizAdjArr].amendFName = w;-         if (! Found(COMMA)) err0(CommaExptd);          ComputeFileHCode(w);8           adjFilesArr[usedSizAdjArr].hCode = fileHCode;}8         if ((w = getNxtFName()) == NULL) skipTok(zSCol);9         else adjFilesArr[usedSizAdjArr++].adjFName = w;}}p-     if (curTok.tok != SCOL) err0(SColExptd);}n   FinishSrcFile()F }	   static void initAll(void)( {r   initBlk();
   initDecl();=   initExp();   initExt();
   initInst();(
   initMain();u
   initPrag();t   initRec(); }h   static void initMain(void) {- #ifndef VMS"   static bool frstInit = True;     if (frstInit) {tI     if (setvbuf(MAIN_OUT_STREAM, NULL, (int)_IOLBF, BUFSIZ) != 0) sysErr(( 									ExCod1);E     frstInit = False;} #endif   ctrErr = ctrWarn = 0;;   cumNbLines = 0;    initErr(); }l   bool insideInclude(void) {!   return pTopInclStk != NULL;& }D  - static void intrnErr(Tstring wrd, uint *pCtr), {t   static bool errSeen = False;     if (pCtr == NULL) {BD     if (errSeen) {emitC(' '); errSeen = False;}}  /* flush buffer */   else {     emitS("\nINTERNAL PB: ");r     emitS(wrd);B     emitS("= ");      emitS(longToS((long)*pCtr));     *pCtr = 0;     errSeen = True;} }e  $ static bool isDccOption(Tstring arg) {"E   return (*arg=='+' || *arg=='-') && *(arg + 1)=='z' && strlen(arg)>=, 								   MinDccOptLgt; })  * static bool isHeaderFile(Tstring fileName) { "   Tstring p = SearchDot(fileName);       if (p == NULL) return False;*   if (strchr(p, 'h') != NULL) return True;
 #ifdef LcEqUcf   if (strchr(p, 'H') != NULL) {y,     if (chkPortbl) err0(LowerCaseH | Warn1);     return True;}  #endif   return False;a }r  ! static bool isSrcFName(Tstring x)  {A   return !isDccOption(x) &&1
 #ifdef VMS 			    *x!='/';d #elser8 			    *x!='-' && StrEq(x + strlen(x) - LitLen(CSuffix), 								       CSuffix); #endif }*  # static char *manageEndInclude(void)s { (   TinclStkElt *locPTInclS = pTopInclStk;  -   if (! adjustFile) cumNbLines += lineNb - 1;eL   free(curSourceMngtBlk); /* do not free curFileName, because name may stillI 	    be used after exit of include file (i.e. in a 'NotUsed' warning). */(4   /* Search if system header file to be 'amended' */   if (sysHdrFile) {D     TadjFilesS *ptr;C     Tstring nakedFName = NakedFName(curFileName); /* skip prefix */a  I     /* Search if not recursive inclusion (because adjustFiles can only be *        included at end of system file). */     { "       TinclStkElt *w = locPTInclS;  
       do {E         if (StrEq(NakedFName(w->fileName), nakedFName)) goto recursL;	'       } while ((w = w->prec) != NULL);}-     {d
 #ifdef LcEqUcr       bool diffLC = False;  H       SearchAdjFiles(nakedFName, (diffLC = sameLowerCaseName(nakedFName, 							      ptr->amendFName)))n2             if (diffLC) locPTInclS->diffLc = True; #elsei'       SearchAdjFiles(nakedFName, False)  #endif             adjustFile = True;             sysHdrFile = False;d*             openSourceFile(ptr->adjFName);             return srcPtr;}}}}
 recursL:;}   adjustFile = False;y'   /* Go back to previous source file */g/   curSourceMngtBlk = locPTInclS->sourceMngtBlk;{A   begSBuf = &curSourceMngtBlk->idPlusSource[LgtHdrId + MaxLgtId]; '   endSBuf = begSBuf + SizeSourceBuffer;u,   oldMaxPtrS = curSourceMngtBlk->oldMaxPtrS;,   posEndChP1 = curSourceMngtBlk->posEndChP1;2   nxtPosEndChP1 = curSourceMngtBlk->nxtPosEndChP1;I   nlPosP1 = srcPtr = curSourceMngtBlk->ptrS;  /* because of call to err()a& 						      later in this function. */$   lineNb = curSourceMngtBlk->lineNb;0   sourceStream = curSourceMngtBlk->sourceStream;'   indentIncr = locPTInclS->indentIncra;h%   curFileName = locPTInclS->fileName;B(   headListPrivTo = locPTInclS->listPriv;   fileClosed = False;*E   if (hfpsCtrM1 < 0) {headerFile = False; curHdrFName = NonHdrFName;}    else {     TinclStkElt *w;p  /     if (hfpsCtrM1 == 0) insideHdrInHdr = False;b1     /* Search in which header file we are back */k(     for (w = locPTInclS;; w = w->prec) {I       if ((insideHdrInHdr)? w->hdrFilPerSe : isHeaderFile(w->fileName)) {r"         curHdrFName = w->fileName;         break;}}}d4   sysHdrFile = sysAdjHdrFile = locPTInclS->sHdrFile;:   if (hdrFilePerSe = locPTInclS->hdrFilPerSe) hfpsCtrM1--;
 #ifdef LcEqUcs=   if (locPTInclS->diffLc && chkPortbl) err0(ChkUcLc | Warn1);\ #endif+   pTopInclStk = freeInclStkElt(locPTInclS); 3   return srcPtr - 1;  /* -1 to get back to nlF() */i }i  A void manageInclude(TstringNC fileName, bool sysFl, bool cmpsgHdr)r {e   /* Save previous context */f   RestoSmshCh;   {s'     TinclStkElt *w = allocInclStkElt();   #     curSourceMngtBlk->ptrS= srcPtr; .     curSourceMngtBlk->oldMaxPtrS = oldMaxPtrS;.     curSourceMngtBlk->posEndChP1 = posEndChP1;4     curSourceMngtBlk->nxtPosEndChP1 = nxtPosEndChP1;&     curSourceMngtBlk->lineNb = lineNb;2     curSourceMngtBlk->sourceStream = sourceStream;(     w->sourceMngtBlk = curSourceMngtBlk;      w->indentIncra = indentIncr;     w->fileName = curFileName;!     w->listPriv = headListPrivTo;c3     if (w->hdrFilPerSe = hdrFilePerSe) hfpsCtrM1++;a     w->sHdrFile = sysHdrFile;a
 #ifdef LcEqUcu     w->diffLc = False; #endif     w->prec = pTopInclStk;     pTopInclStk = w;}a9   /* Test for errors/warnings while err() stills works */n   {g$     Tstring p = SearchDot(fileName);  N     if (p!=NULL && StrEq(p+1, "c")) errWS(DontInclBodyFile | Warn2, fileName);F     for (p = fileName; *p !='\0'; p++) if (! IsVisibleChar(*p)) errWS(- 					  NotVisiChar | Warn3, charToHexS(*p));}e   {r     bool isBodyHdrF;  0     if (hdrFilePerSe = isHeaderFile(fileName)) {A       /* Search if circular chain of inclusion of header files */s       {.%         TinclStkElt *w = pTopInclStk;S8         Tstring cmpsgHdrFName = NULL, strpdFName = NULL;           do {K           if (!w->hdrFilPerSe && isHeaderFile(w->fileName)) cmpsgHdrFName =i 								    w->fileName;0           if (cmpsgHdrFName!=NULL || cmpsgHdr) {D             if (strpdFName == NULL) strpdFName = skipPath(fileName);;             if (StrEq(skipPath(w->fileName), strpdFName)) {-J               errWSS(CmpsgHdrWithSelf | Warn1, strpdFName, cmpsgHdrFName);               break;}})         } while ((w = w->prec) != NULL);} ,       isBodyHdrF = isBodyHdrFile(fileName);}     if (cmpsgHdr) {rB       if (!headerFile || !hdrFilePerSe) err0(IlgCmpsgHdr | Warn1);A       else if (isBodyHdrF) errWS(IlgCmpsgHdr1 | Warn1, fileName);mO       else if (insideHdrInHdr && isBodyHdrFile(curHdrFName)) err0(IlgCmpsgHdr2|  								    Warn1|Rdbl);       else goto OkL;       cmpsgHdr = False;h OkL:;A     }}F   if (nestLvl != 0) indentIncr = 0;  /* to avoid 'BadIndent' errors in& 						files included inside blocks. *//   if (sysFl) sysHdrFile = sysAdjHdrFile = True;s#   if (hdrFilePerSe && sysHdrFile) {|5     /* Check if adjust file to replace header file *//     TadjFilesS *ptr;  
 #ifdef LcEqUcsJ     SearchAdjFiles(fileName, sameLowerCaseName(fileName, ptr->amendFName)) #elseW#     SearchAdjFiles(fileName, False)  #endif#           if (ptr->noLoadSysFile) {              adjustFile = True;*             openSourceFile(ptr->adjFName);             goto openOK1;}           break;}}}}   /* Open included file */   {a     Tchar *fNameBuf;U     static const TdirName noPrefix[] = {EmptyDirName, EmptyDirName , NULL};  /* 'Emp- ; 			   tyDirName' twice, because of quoted include files. */A#     const TdirName *ptrDirArray = ( 
 #ifdef VMS"     skipPath(fileName) != fileName #elsem     *fileName == '/' #endif8 			  )? &noPrefix[0] : (sysFl)? dirArray + 1 : dirArray;K     size_t lgtFileN = strlen(fileName) + 1 + 1;  /* prefix length, trailingo 									'\0'. */      size_t lgtPrefix;i
 #ifdef VMS     Tchar *pos = NULL;  K     /* Manage 'dir/file' form (=>'dir:file') for system header file name */hL     if (hdrFilePerSe && sysHdrFile && (pos = strchr(fileName, '/'))!=NULL) {+       *pos = ':';  /* replace '/' by ':' */e"       ptrDirArray = &noPrefix[0];} #endif  L     /* Try possible prefixes to open include file (and make a permanent copy        of its name). */[     for (;;) {!       /* Create full file name */ %       lgtPrefix = LgtD(*ptrDirArray);o.       MyAlloc(fNameBuf, lgtPrefix + lgtFileN);#       *fNameBuf = (Tchar)lgtPrefix;g<       memcpy(fNameBuf + 1, (*ptrDirArray++) + 1, lgtPrefix);1       strcpy(fNameBuf + 1 + lgtPrefix, fileName);d*       if (openSourceFile1(fNameBuf + 1)) {H         if (*ptrDirArray == NULL) curFileName = NakedFName(curFileName);2 				/* system directory => conceal its name (would& 						 just puzzle casual user...). */K         *(TstringNC /*~OddCast*/)(curFileName - 1) = '\0';  /* no prefix */-         break;}eM       if (*ptrDirArray==NULL || !sysHdrFile && *(ptrDirArray + 1)==NULL /* do=G 	     not look in system directory for quoted include file */) fileErr(  								      fileName);       free(fNameBuf);}
 #ifdef VMSM     if (pos != NULL) *((TstringNC/*~OddCast*/)curFileName + (pos - fileName))o- 					 = '/';  /* restore '/' replacing ':' */- #endif   }- openOK1:1   if (hdrFilePerSe) {  /* would-be header file */ -     if (! cmpsgHdr) {  /* real header file */f        curHdrFName = curFileName;F       if (headerFile) {  /* header file included inside header file */         insideHdrInHdr = True;}s       else {         headerFile = True;J         (void)addLvl0InclFName(curHdrFName);}}  /* jot down files included 								  at level 0. */$     else {  /* "composing" header */       hdrFilePerSe = False;eO       if (! insideHdrInHdr) {  /* composed header included at level 0 => compo-s; 			       sing header behaves as if included at level 0. */'I         curHdrFName = curFileName;  /* to prevent ExtObjNotDef message */i.         (void)addLvl0InclFName(curHdrFName);}}2     headListPrivTo = NULL;}  /* reset PrivateTo */   free(fileName);cP   lineNb--;  /* because of extra 'newline' put by end of directive processing */ }.   static void mngOptListTok(void)g { I   if (begLastTokBuf != NULL) {free(begLastTokBuf); begLastTokBuf = NULL;}y   if (listTok) {*     MyAlloc(begLastTokBuf, lgtLastTokBuf);2     endLastTokBuf = begLastTokBuf + lgtLastTokBuf;      pLastTokBuf = begLastTokBuf;     ovfldTokBuf = False;}o }n    static void mngOptMsgLimit(void) {    msgLimit = (msgLimitFl)B 	     ? initMsgLimit 	     : (interactivOutptDev)$ 	       ? (uint)DefaultMessagesLimit 	       : UINT_MAX;t }1  $ static void mngOptStopAfterMsg(void) { '   if (stopAfterMsg = initStopAfterMsg) }3     if (! interactivOutptDev) stopAfterMsg = False;      else verbose = HalfVerbo;  }M   static void mngOptVerbose(void)< {g   verbose = (initVerbose)E= 		? (moreInfMsg = True /* 'zvve' implies 'zve' */, FullVerbo)  		: (moreInfMsg) 		  ? HalfVerbo  		  : Terse; }"   TcharStream nxtChFromTxt(void) {o	   char c;/   char *ptrS = srcPtr;     NxtChC   srcPtr = ptrS;   return (TcharStream)c; }t  ( char *nxtChunkOfTxt(register char *ptrS)H /* Loads next chunk of source text, managing the circular source buffer.*    ptrS points just after ending EndCh. */ {I>   int lgt;	/* (max) length of chunk of text to load (including 							     terminating \0). */	=   size_t readLgt;	/* length of chunk of text really loaded */(  8   ptrS--;		/* to eliminate previous terminating EndCh */G   if (ptrS == oldMaxPtrS) {  /* if next text chunk already loaded (by aG- 					preceding searchNxtNL() or splice()). */I     posEndChP1 = nxtPosEndChP1;      return begSBuf;}J   lgt = (int)(ptrS - begSBuf) - deltaPtrS - (LineSize + LS2);  /* preserve; 			   (maximum) number of characters needed before ptrS. */<I   if (nlPosP1 <= ptrS) {  /* normal case (no 'circular buffer' effect) */)0     int minLgt = (int)(nlPosP1 - begSBuf) - LS2;  G     if (lgt < minLgt) lgt = minLgt;}  /* free space before beginning ofb 							      preceding line. */    if (lgt >= 0) {tP     if (endSBuf - ptrS > TransfSize) {  /* if enough space at end of buffer,  */I       lgt = (int)(endSBuf - ptrS);      /*   use it (in order to maximiseu 								 oldMaxPtrS). */O       oldMaxPtrS = endSBuf;}  /* to prevent oldMaxPtrS from indicating 'already  							  loaded' text chunk. */ ,     else {	/* load at beginning of buffer */I       oldMaxPtrS = ptrS;  /* remember (logical) end of circular buffer */iN       if (nlPosP1 > ptrS) nlPosP1 = begSBuf + 1; /* to force subsequent reset,4 				for nlPosP1 becomes meaningless in that case. */       ptrS = begSBuf;}}fE   else {  /* characters to be kept start at end of circular buffer */}     int minLgt;t  $     lgt += (int)(oldMaxPtrS - ptrS);)     minLgt = (int)(nlPosP1 - ptrS) - LS2;a$     if (lgt < minLgt) lgt = minLgt;}G   if ((uint)(adSmshCh - ptrS) < (uint)lgt) adSmshCh = NULL;  /* if lasti- 					      identifier will be overwritten. */;P   if ((uint)(nlPosP1 - 1 - ptrS) < (uint)lgt) nlPosP1 = begSBuf - NbSrcLinesKept@ 		      *LineSize; /* if NL is overwritten, its position becomes; 			  meaningless (see use of 'distErrBegLine' in err()). */t<   readLgt = fread(ptrS, 1, (size_t)(lgt - 1), sourceStream);+   if (readLgt==0 || ferror(sourceStream)) {(M     bool w = ferror(sourceStream);  /* so that ferror called before fclose */r  J     if (w | fclose(sourceStream)!=0 /* '|' so that fclose always called */; 			     ) {srcPtr = ptrS; errWS(InptFileErr, curFileName);}      fileClosed = True;     *ptrS = EndCh;     posEndChP1 = NULL;}n   else {+     register char *endBuf = ptrS + readLgt;T  0     *endBuf++ = EndCh;  /* end of loaded text */     posEndChP1 = endBuf;}r   return ptrS; }   , static void openSourceFile(Tstring fileName) {n5   if (! openSourceFile1(fileName)) fileErr(fileName);p }   - static bool openSourceFile1(Tstring fileName)O {rB   if ((sourceStream = fopen(fileName, "r")) == NULL) return False;   fileClosed = False;    curFileName = fileName; 4   MyAlloc(curSourceMngtBlk, sizeof(TsourceMngtBlk));M   begSBuf = &curSourceMngtBlk->idPlusSource[LgtHdrId + MaxLgtId];  /* reservemE 	an identifier name buffer in front of the source buffer, buffer used G 	in case an identifier straddles both ends of (circular) source buffer,D2 	because nameStrings must always be contiguous. */A   oldMaxPtrS = posEndChP1 = endSBuf = begSBuf + SizeSourceBuffer;nP   *(endSBuf - (1 + 1 + 1)) = EndCh;  /* indicate first line (of current file) */M   *(endSBuf - (1 + 1)) = '\n';	/* simulate initial NL (to manage preprocessora 								 directives). */=   *(endSBuf - (1)) = EndCh;	/* simulate end of loaded text */r=   srcPtr = endSBuf - (1 + 1);	/* initialize source pointer */ 
   lineNb = 0;e   return True; };  7 static void prmtrzMsg(Tstring x, const Tstring *tabPrm)c {e   register char c;   static char lastChar;;	   uint w;    static bool skip;A   static int lvl = -1;     if (x != NULL) {B     if (++lvl == 0) skip = False;  /* start in no-skipping mode */      while ((c = *x++) != '\0') {       if (c=='@' && *x=='0') {'         if (! moreInfMsg) skip = !skip;t
         x++;}*       else if (! skip)B         if (c=='@' && tabPrm!=NULL && (w = (uint)(*x - '1'))<(uintI 	      /*~OddCast*/)*tabPrm) {prmtrzMsg(*(tabPrm + w + 1), tabPrm); x++;}+"         else emitC(lastChar = c);}I     if (--lvl<0 && skip && lastChar!='?') emitC('.');}  /* message ending  								      period. */ }t   static void resetArgPtr(void)L {tJ   dfltArgsPtr = strcpy(copDfltArgs, dfltArgs);  /* copied because modified 							       (' ' => '\0'). */    argv1 = argvg; }C  
 #ifdef LcEqUc}; static bool sameLowerCaseName(const char *x, const char *y)  {tL   while (RealChar(*x) == RealChar(*y)) {if (*x++ == '\0') return True; y++;}   return False;) }= #endif   void saveTokChar(char c) {hM   if (pLastTokBuf == endLastTokBuf) {pLastTokBuf = begLastTokBuf; ovfldTokBuf= 									= True;}    *pLastTokBuf++ = c;t }   < static char *searchNxtNL(register char *ptrS, ptrdiff_t ctr)L /* Search until next NL, or until seen LineSize chars on error line; returns"    a pointer on this character. */ {A-   char c, *savPECP1 = NULL, *oldPECP1 = NULL;r  )   if (ctr == 0) {deltaPtrS = 1; ctr = 1;}    else {N     if (ptrS == begSBuf) {ptrS = oldMaxPtrS; oldPECP1 = posEndChP1; posEndChP1 								    = ptrS + 1;}     BackUp;}   do {O     deltaPtrS++;  /* to limit length of loaded text chunk, so as not to destroyNA 		     last NL. Value = 1 too much, so can also serve as flag (inr 		     nxtChunkOfTxt()). */fK     for (;;) {  /* get next character; may cause (but only once) loading of  							     next text chunk. */=5       if ((c = *ptrS++)==EndCh && ptrS==posEndChP1) {s4         if (oldPECP1 == NULL) savPECP1 = posEndChP1;4         else {savPECP1 = oldPECP1; oldPECP1 = NULL;}#         ptrS = nxtChunkOfTxt(ptrS);	G         if (ptrS != begSBuf) savPECP1 = NULL;  /* no circular effect */x         continue;}3 /*    if (c == '\?') {          *//* trigraph? *//*tM       while ((c = *ptrS++)==EndCh && ptrS==posEndChP1) {ptrS = nxtChunkOfTxt(nP                                                                          ptrS);}L       if (c == '\?') ptrS = trigraph(ptrS, &c);*//* *doIt* c not ds reg *//*       else {BackUp; c = '\?';}       break;}*/ D       if (c!='\\' || !splice(ptrS)) break; ptrS--;}  /* splicing? */I     if (c=='\n' || c==EndCh && fileClosed) break;  /* found NL (or end ofc 								source file). */   } while (ctr++ <= LineSize);	   BackUp;m+   deltaPtrS = 0;  /* back to normal case */    if (savPECP1 != NULL) {IC     nxtPosEndChP1 = posEndChP1;  /* because of possible splice() */o     posEndChP1 = savPECP1;} 3   else if (oldPECP1 != NULL) posEndChP1 = oldPECP1;o   return ptrS; }     bool splice(register char *ptrS)F /* On entry we have just read a backslash, and ptrS points at the next    character. */ {T@   if (*ptrS==EndCh && ptrS+1==posEndChP1) {  /* end of buffer */      char *savPECP1 = posEndChP1;  #     ptrS = nxtChunkOfTxt(ptrS + 1);iN     if (ptrS == begSBuf) {nxtPosEndChP1 = posEndChP1; posEndChP1 = savPECP1;}} 							   /* circular effect */ "   if (*ptrS != '\n') return False;E   /* Line splicing: remove '\\' and '\n' by shifting end of buffer */f   {      char *savPECP1 = NULL;  1     if (ptrS == begSBuf) {  /* circular effect */,       savPECP1 = posEndChP1;!       posEndChP1 = nxtPosEndChP1;n&       nxtPosEndChP1 -= LitLen("\\\n");#       *(oldMaxPtrS - 1) = *++ptrS;}i5     while (! (*ptrS++==EndCh && ptrS== posEndChP1)) {)(       *(ptrS - LitLen("\\\n")) = *ptrS;}G     posEndChP1 = (savPECP1 != NULL)? savPECP1 : ptrS - LitLen("\\\n");}w   lineNb++;    return True; }e  ! static void storeDMacTxt(Tchar c)f {y3   if (pStoDMacTxt >= endDMacBuf) endDMacBuf = NULL;F   *pStoDMacTxt++ = c;l }m  ( void sysErr(Tstring x) /*~NeverReturns*/ {r   fatalErr(SysError, x); }d  ? /****static char *trigraph(register char *ptrS, char *pEquivCh) &   a traiter non dans NxtCh (sauf ??/)  { 
   sysErr(55);    *pEquivCh = *ptrS;   return ptrS; }*/k  3 static bool waitAndAnalAnswer(void) /*~PseudoVoid*/! {U	   char c;    bool resul = False;      (void)fflush(outputStream);e#   while ((c = getchar()) != '\n') {m'     if (c == '#') stopAfterMsg = False;p5     if (tolower(c) == ExplainMsgChar) resul = True;};> #ifdef CrEchoedAsNewLine2   ResetSpaceAtEndOfLine;  /* kill previous '\n' */ #endif   return resul;; }    /* End DCMAIN.C */