 /* DCPRAG.C */( /* Y.L. Noyelle, Supelec, France 1994 */ /* Manages d-pragmas */    #include <stdlib.h>  #include <setjmp.h>  #include <string.h>  #include "dcprag.h"  #include "dcprag.ph" #include "dcblk.h" #include "dcdecl.h"  #include "dcdir.h" #include "dcexp.h" #include "dcext.h" #include "dcmain.h"  #include "dcrec.h" #include "dcrec.ph"  #include "dcrecdir.ph"  
 #ifdef VMS8 #  pragma noinline (checkEndDP, procPrivTo, skipToEndDP) #endif  
 DefIsSameName    struct _TCBlk { %   const TsemanElt *lTypeId, *rTypeId;    TpcTypeElt resulType;    TlineNb defLineNb;   Tstring defFileName;   TCBlk *next; };   struct _TmngtPriv {    TmngtPriv *prec;B   const Tchar fileName[1];  /* stub for name, so must be at end */ };9 /*~zif Offset(TmngtPriv, fileName) != sizeof(TmngtPriv)-1 4 				      "Field 'fileName' not at end of struct" */   /* Function profiles */ 4 static TCBlk *allocTCBlk(void), *freeTCBlk(TCBlk *);1 static bool getTypeIdent(TpcTypeElt *gottenType); * static TtypeSort intPromotion(TpcTypeElt);O static void addTCB(TkOpTC, TpcTypeElt, TpcTypeElt, TpcTypeElt), checkEndDP(void M   ), initWarnMngt(void), manageTC(TkOpTC, TpcTypeElt, TpcTypeElt, TpcTypeElt, N   bool), procPrivTo(void), skipToEndDP(void), verifyTC(TpcTypeElt, TpcTypeElt,   TpcTypeElt);   /* Global variables */I static const Ttok zCommaEndDP[] = {NoSwallowTok, COMMA, ENDDPRAG, ENDDIR,  								       EndSTok};   /* External variables */7 uint ctrTCB = 0;  /* count of TypeCombination blocks */  bool noWarn = False;L TCBlk *(*pHeadTCBLists)[ModAsgn - AddAsgn + 1 /*~IndexType TkOpTC*/] = NULL;   typedef enum {CastTo, DccCompl,  #ifdef TstAdjFiles 				EndAdj, EndSys,  #endif! 						IndexType, Init, NoDefault, "   NoWarn, PopWarn, PrivTo, Public, #ifdef TstAdjFiles 				   SimAdj, SimSys, #endif" 						   TypeCmbn, Undef, UndfTag,   WWarn, Zif} TidDP;J static const struct _descPrag {Tname pragName; ThCode hCode;} tabDPrag[] = 	   /* Token-like */5           {{ConvTname("\xA\0BackBranch"),	0x257CA39}, 8            {ConvTname("\xC\0ComposingHdr"),	0x4718E851},5            {ConvTname("\xA\0DollarSign"),	0x2F2FBD1}, 1            {ConvTname("\x7\0DynInit"),		0x67C28}, 3            {ConvTname("\x8\0ExactCmp"),		0x20F2ED}, 3            {ConvTname("\x8\0FullEnum"),		0x21F8FC}, 1            {ConvTname("\x7\0Generic"),		0x64A30}, 5            {ConvTname("\xA\0LiteralCst"),	0x3C62E49}, 3            {ConvTname("\x8\0LocalAdr"),		0x27351A}, 1            {ConvTname("\x7\0Masking"),		0x795F1}, 3            {ConvTname("\x9\0MayModify"),	0xBDF8C6}, 8            {ConvTname("\xC\0NeverReturns"),	0x621221EB},1            {ConvTname("\x7\0NoBreak"),		0x817AF}, 7            {ConvTname("\xB\0NonConstExp"),	0x1476A396}, 1            {ConvTname("\x7\0NotUsed"),		0x8794B}, 1            {ConvTname("\x7\0OddCast"),		0x7FEC7}, 5            {ConvTname("\xA\0PortableQM"),	0x4618D4B}, 5            {ConvTname("\xA\0PseudoVoid"),	0x46A6080}, 3            {ConvTname("\x9\0ResultPtr"),	0xE0BA94}, 5            {ConvTname("\xA\0ResultType"),	0x463A773}, 3            {ConvTname("\x8\0RootType"),		0x2F194E}, 3            {ConvTname("\x9\0SameValue"),	0xDF8C02}, 8            {ConvTname("\xC\0SideEffectOK"),	0x70AFBE08},8            {ConvTname("\xC\0SizeOfMemBlk"),	0x734A69AC},0            {ConvTname("\x6\0SizeOK"),		0x1E375},1            {ConvTname("\x7\0Utility"),		0xA4E6B}, 7            {ConvTname("\xB\0VoidToOther"),	0x191BE16A}, L            /*~ zif __index != EndDPragTok - BegDPragTok "Bad 'tabDPrag'1" */+ 	   /* Non-token, or token with argument */ 0            {ConvTname("\x6\0CastTo"),		0x10AE0},8            {ConvTname("\xC\0DccCompliant"),	0x40F23DAD}, #ifdef TstAdjFiles5            {ConvTname("\xA\0EndAdjFile"),	0x2F8826E}, 5            {ConvTname("\xA\0EndSysFile"),	0x2FDE362},  #endif3            {ConvTname("\x9\0IndexType"),	0xB18D4D}, ,            {ConvTname("\x4\0Init"),		0xEA6},3            {ConvTname("\x9\0NoDefault"),	0xCA3005}, 0            {ConvTname("\x6\0NoWarn"),		0x1A733},1            {ConvTname("\x7\0PopWarn"),		0x8E91C}, 3            {ConvTname("\x9\0PrivateTo"),	0xE1DE0D}, 0            {ConvTname("\x6\0Public"),		0x1D18F}, #ifdef TstAdjFiles5            {ConvTname("\xA\0SimAdjFile"),	0x486AB24}, 5            {ConvTname("\xA\0SimSysFile"),	0x48C0C18},  #endif;            {ConvTname("\xF\0TypeCombination"),	0xAC6C71FA}, .            {ConvTname("\x5\0Undef"),		0x65EB},3            {ConvTname("\x8\0UndefTag"),		0x31C772}, -            {ConvTname("\x4\0Warn"),		0x145E}, *            {ConvTname("\x3\0zif"),		0x6FA}I            /*~ zif __index != EndDPragTok - BegDPragTok + __extent(TidDP)  							  "Bad 'tabDPrag'2" */};    void dpragMet(void)  { 9   int savOldSpCnt = oldSpaceCount, savSpCnt = spaceCount;    TvalTok resulTok;   
   dpragNst++; K   if (--getTokLvl==0 && listTok) {curTok.tok = DPPREFIX; storeTokSource();}    GetNxtTok();   if (curTok.tok != IDENT) {6     if (curTok.tok != ENDDPRAG) err0(DPragNameExptd);}   else {#     const struct _descPrag *ptrTDP;   J     for (ptrTDP = &tabDPrag[0]; ptrTDP <= AdLastElt(tabDPrag); ptrTDP++) {O       if (isSameName(curTok.hCod, curTok.name, ptrTDP->hCode, ptrTDP->pragName) - 					       ) {  /* found correct d-pragma */ I         if (ptrTDP < &tabDPrag[EndDPragTok - BegDPragTok]) {  /* d-pragma  							      coded as token. */            GetNxtTok();D           resulTok.tok = BegDPragTok + (int)(ptrTDP - &tabDPrag[0]);           goto okL;}J         curTok.val = (uint)(ptrTDP - &tabDPrag[EndDPragTok -BegDPragTok]);!         resulTok = manageDPrag();          goto okL1;}}     err0(UnknDPrag);}    skipToEndDP();   resulTok.tok = WHITESPACE; okL:   checkEndDP();  okL1:    curTok = resulTok;K   oldSpaceCount = savOldSpCnt; spaceCount = savSpCnt; getTokLvl++;  /* back  							   to previous state. */ 	   return;  }   G static bool lastIsPopWarnAtMainLvl = True;  /* True because of possible  							       option '-zwa'. */  static uint warnStk = 0;   static void initWarnMngt(void) {     lastIsPopWarnAtMainLvl = True;   warnStk = 0; }    TvalTok manageDPrag(void)  {    TvalTok resulTok;   ?   if (! macroExpand) {  /* do not heed d-pragma if inside macro I 	     definition, macro arguments collection, or conditional skipping. */      resulTok.tok = DPRAG;   !     resulTok.val = curTok.val;}      else {!     TidDP dp = (TidDP)curTok.val;        resulTok.tok = WHITESPACE;     switch (dp) { "       case CastTo: case IndexType:         GetNxtTok();%         resulTok.dpType = declType(); :         resulTok.tok = (dp == CastTo)? CASTTO : INDEXTYPE;         goto exitL;        case DccCompl:2         if (!sysHdrFile) err0(IlgDccCmpl | Warn1);0         else sysHdrFile = sysAdjHdrFile = False;         break; #ifdef TstAdjFilesI       case EndAdj: adjustFile = False; sysAdjHdrFile = sysHdrFile; break; I       case EndSys: sysHdrFile = False; sysAdjHdrFile = adjustFile; break;  #endif       case Init:         do {           TsemanElt *ptrId;              GetNxtTok();1           if (curTok.tok != IDENT) err0(IdExptd);            else {M             if ((ptrId = curTok.ptrSem) == NULL) errWN(UndefId, curTok.name); P             else if (ptrId->kind!=Obj || ptrId->attribb<Auto && ptrId->attribb!=- 					  StatiL)  errWN(NotVarId, curTok.name); N             else if (ptrId->initBefUsd || ptrId->initlz || ptrId->used) errWN(- 					    UslInitBU|Warn1|Rdbl, ptrId->nameb); 4             else if (adjMacro) ptrId->initlz = True;*             else ptrId->initBefUsd = True;             GetNxtTok();} &         } while (curTok.tok == COMMA);         goto exitL; $    /* case IndexType : see CastTo */4       case NoDefault: resulTok.tok = DEFAULT; break;     /* case NoWarn:  see WWarn */       case PopWarn:          noWarn = warnStk & 1;          warnStk >>= 1;N         if (! (ReallyInsideMacro || insideInclude())) lastIsPopWarnAtMainLvl = 									   True;          break;       case PrivTo:C         if (! headerFile) errWS(DPragNotAlwd | Warn2, "PrivateTo"); N         headListPrivTo = NULL;  /* do not free preceding list, which is proba-4 				   bly refered to by 'listAlwdFiles' members. */         procPrivTo();          goto exitL;        case Public:@         if (! headerFile) errWS(DPragNotAlwd | Warn2, "Public");         headListPrivTo = NULL;         break; #ifdef TstAdjFiles<       case SimAdj: sysAdjHdrFile = adjustFile = True; break;<       case SimSys: sysAdjHdrFile = sysHdrFile = True; break; #endif       case TypeCmbn:,         if (nestLvl != 0) err0(TCNotAtLvl0);         do {             bool commut = True;            TkOpTC oper;(           TpcTypeElt lTyp, rTyp, resTyp; 	     $           if (getTypeIdent(&lTyp)) {$             if (curTok.tok==TILDE) {               commut = False;                GetNxtTok();} (             oper = (curTok.tok == ADDOP)6                    ? AddTC + ((TkAdd)curTok.val - Add))                    : (curTok.tok == STAR)                       ? MulTC,                      : (curTok.tok == MULOP):                        ? MulTC + ((TkMul)curTok.val - Mul)4                        : (err0(IlgTCOptr), IlgTcOp);              if (oper >= AddTC) {2               if (! (oper==AddTC || oper==MulTC)) 3                 if  (! commut) err0(NonCommutOper); $                 else commut = False;(               if (getTypeIdent(&rTyp)) {:                 if (curTok.tok != ARROW) err0(ArrowExptd);                 else {.                   if (getTypeIdent(&resTyp)) {?                     manageTC(oper, lTyp, rTyp, resTyp, commut); E                     if (curTok.tok == COMMA || curTok.tok == ENDDPRAG  								) continue;}}}}}           skipTok(zCommaEndDP); &         } while (curTok.tok == COMMA);         goto exitL;         case Undef : case UndfTag:)         if (nestLvl != 0) err0(IllUndef);          do {           TsemanElt *pId;   "           if (NxtTok() != IDENT) {             err0(IdExptd);"             skipTok(zCommaEndDP);}           else {             if (nestLvl == 0) { "               if (dp == UndfTag) {A                 *(TnameNC /*~OddCast*/)(curTok.name + DispNSId) =  							    (TnameAtom)TagSpace; 1                 pId = searchSymTab(curTok.name);}                else$                 pId = curTok.ptrSem;:               if (pId == NULL) errWN(UnknId, curTok.name);J               else if (pId->undef && dp==UndfTag) errWN(AlrdUndef | Warn2, 								   curTok.name);&               else pId->undef = True;}             GetNxtTok();} &         } while (curTok.tok == COMMA);         goto exitL;        case WWarn: case NoWarn:,         warnStk = warnStk<<1 | (uint)noWarn;          noWarn = (dp == NoWarn);7         if (! (ReallyInsideMacro || insideInclude())) { I           if (!lastIsPopWarnAtMainLvl && !((warnStk & 1) ^ noWarn)) err0( 4 				(noWarn)? WarnAlrdOff|Warn2 : WarnAlrdOn|Warn2);*           lastIsPopWarnAtMainLvl = False;}         break;       case Zif: { 5           TresulExp saveCExp = cExp, saveLExp = lExp; E           bool trueZif, saveZifExp = zifExp, saveIfDirExp = ifDirExp;            TlitString str;              zifExp = True;           ifDirExp = False;            GetNxtTok();J           trueZif = correctExprN(NULL, Bool, True, "zif", False) && !cExp. 							 errEvl && cExp.uVal!=0; 8           if ((str = getLitString())!=NULL && trueZif) {!             Tchar *ptrZifMsg, *w;   7             MyAlloc(w = ptrZifMsg, initGetStrLit(str)); :             while ((*w++ = getNxtStrLitChar()) != '\0') {}.             errWS(ZifWarn | Warn3, ptrZifMsg);             free(ptrZifMsg);} 7           exitBlock();  /* because of getLitString() */            zifExp = saveZifExp;"           ifDirExp = saveIfDirExp;,           cExp = saveCExp; lExp = saveLExp;}         goto exitL;      } 4     GetNxtTok();  /* here for good error position */ exitL:     checkEndDP(); M     resulTok.hCod = 0;}  /* to differentiate d-pragma tokens from keywords */    return resulTok; }   * /*~Undef lastIsPopWarnAtMainLvl,warnStk */  P /******************************************************************************/P /*                                UTILITIES                                   */P /******************************************************************************/  L static void addTCB(TkOpTC op, TpcTypeElt lType, TpcTypeElt rType, TpcTypeElt 									resType)  {    TCBlk *pcTCB, *prec = NULL; 3   register const TsemanElt *lTypId = lType->typeId;      if (pHeadTCBLists == NULL) {J     /* Allocate and initialize table of TypeCombinations for each operator        (Add -> Mod). */      TCBlk **ptr;  3     MyAlloc(pHeadTCBLists, sizeof(*pHeadTCBLists)); J     for (ptr = &(*pHeadTCBLists)[AddTC]; ptr <= &(*pHeadTCBLists)[ModTC];)       *ptr++ = NULL;} J   for (pcTCB = (*pHeadTCBLists)[op]; pcTCB != NULL; pcTCB = pcTCB->next) {B     if (pcTCB->lTypeId==lTypId && pcTCB->rTypeId==rType->typeId) {'       static Tchar tCOperRepre[] = " ";  #include "dctxttok.h"   8       tCOperRepre[0] = txtAsgnTok[AddAsgn + (int)op][0];I       errWFName(TCAlrdDef, pcTCB->defLineNb, pcTCB->defFileName, lTypId-> ; 			     nameb, nameToS(rType->typeId->nameb), tCOperRepre);        longjmp(*curErrRet, 1);}     prec = pcTCB;}   {      TCBlk *w = allocTCBlk();       w->next = NULL;      w->lTypeId = lTypId;     w->rTypeId = rType->typeId;      w->resulType = resType;      w->defLineNb = lineNb;!     w->defFileName = curFileName; /     if (prec == NULL) (*pHeadTCBLists)[op] = w;      else prec->next = w;}  }   0 static AllocXElt(allocTCBlk, TCBlk *, ctrTCB, ;)   static void checkEndDP(void) {    if (curTok.tok != ENDDPRAG) {      err0(EndDPragLineExptd);     skipToEndDP();} I   dpragNst--;  /* reset here only so that ERror->WArning inside d-pragma, I 	    even if look-ahead (e.g. in call to declType() in __sameType() ). */  }    Tstring dpName(Ttok pragNb)  { B   static Tstring listStrings[] = {DPragPrefix, NULL, DPragSuffix};N   Tstring *w, *limW = &listStrings[(pragNb == DPRAG)? NbElt(listStrings) - 1 : 							    NbElt(listStrings)]; )   register Tchar *ptrBuf = &tokTxtBuf[0];   F   listStrings[1] = (Tstring)(tabDPrag[(pragNb == DPRAG)? (curTok.val +H 	(EndDPragTok - BegDPragTok)) : (uint)(pragNb - BegDPragTok)].pragName + 								      LgtHdrId);*   for (w = &listStrings[0]; w != limW; ) {     register Tstring w1 = *w++;   +     while (*w1 != '\0') *ptrBuf++ = *w1++;}    *ptrBuf = '\0';    return &tokTxtBuf[0];  }   5 static FreeXElt(freeTCBlk, TCBlk *, ctrTCB, ; , next)    void freeTCB(void) {    if (pHeadTCBLists != NULL) {     TCBlk **ptrInArr;   L     for (ptrInArr = &(*pHeadTCBLists)[AddTC]; ptrInArr <= &(*pHeadTCBLists)[ 								     ModTC]; ) {"       TCBlk *curTCB = *ptrInArr++;  9       while (curTCB != NULL) curTCB = freeTCBlk(curTCB);}      free(pHeadTCBLists);     pHeadTCBLists = NULL;} }   0 static bool getTypeIdent(TpcTypeElt *gottenType) {    bool resul = False;    TsemanElt *ptrId;       GetNxtTok();   if (curTok.tok == IDENT) {*     if ((ptrId = curTok.ptrSem) == NULL) {1       DefSem1(artifDef, Type, True, True, False);      "       errWN(UndefId, curTok.name);       (void)defineId(artifDef);        *gottenType = NULL;        resul = True;}#     else if (ptrId->kind == Type) { M       *gottenType = (ptrId->namedType!=NULL && (!IsTypeSort(ptrId->namedType, A 		NumEnum) || !ptrId->namedType->paralTyp))? (errWT(TypeNotParal, 4 				    ptrId->namedType), NULL) : ptrId->namedType;       resul = True;}'     else errWN(NotTypeId, curTok.name);      GetNxtTok();}    else err0(IdExptd);    return resul;  }    void initPrag(void)  {    initWarnMngt();  }   + static TtypeSort intPromotion(TpcTypeElt x)  {    TtypeSort ts = x->typeSort;      if (ts == Enum) return Int;    if (ts < Int)  #if USHRT_MAXC == UINT_MAXC B     if (chkPortbl && ts==UShort) errWS(NonPortTC | Warn2, IntStr); #endif     return Int;    return ts; }   < bool isFNameVisible(Tstring fileName, const TsemanElt *pTag) { 4   register const TmngtPriv *w = pTag->listAlwdFiles;      fileName = skipPath(fileName);   do {7     if (strJokerEq(w->fileName, fileName)) return True; "   } while ((w = w->prec) != NULL);   return False;  }   E static void manageTC(TkOpTC oper, TpcTypeElt lType, TpcTypeElt rType, & 						TpcTypeElt resType, bool commut) {P"   jmp_buf localJmpBuf, *savErrRet;  P   if (nestLvl!=0 || lType==NULL || rType==NULL) return; /* ignore combination */   if (resType != NULL) {$     verifyTC(lType, rType, resType);     if (oper == ModTC) {N       if (IsTypeSort(resType, Flt)) errWSTT(IlgTCModOpnd, NULL, lType, rType);D       if (lType != resType) err0(IncorTCModRes | Warn2 | PossErr);}}%   if (lType == rType) commut = False;a   savErrRet = curErrRet;)   curErrRet = &localJmpBuf /*~LocalAdr*/;m    if (setjmp(*curErrRet) == 0) {(     addTCB(oper, lType, rType, resType);4     if (commut) addTCB(oper, rType, lType, resType);     if (resType != NULL)       switch (oper) {          case AddTC:;E           if (resType == lType) addTCB(SubTC, lType, rType, resType);; 							    /* 'generic' type */m           break;         case MulTC:F/           addTCB(DivTC, resType, lType, rType);nI           if (IsTypeSort(resType, WhoEnum)) addTCB(ModTC, resType, lType,t 								       resType);           if (commut) {t1             addTCB(DivTC, resType, rType, lType);iK             if (IsTypeSort(resType, WhoEnum)) addTCB(ModTC, resType, rType,i 								      resType);}           break;         case DivTC:pO           if (IsTypeSort(resType, WhoEnum)) addTCB(ModTC, lType, rType, lType);e           break;         /*~NoDefault*/}}   curErrRet = savErrRet; }n   static void procPrivTo(void) {R   GetNxtTok();   do {     TlitString str;E  5     if ((str = getLitString())!=NULL && headerFile) {o       register Tchar *pc;n       Tstring sp;l       TmngtPriv *w;o  C       MyAlloc(w, initGetStrLit(str) + Offset(TmngtPriv, fileName));t1       pc = (Tchar * /*~OddCast*/)&w->fileName[0];SI       while ((*pc++ = getNxtStrLitChar()) != '\0') {};  /* note indicated, 								   file name. */"       /* Suppress possible path */<       if ((sp = skipPath(w->fileName)) != &w->fileName[0]) {$         size_t lgt = strlen(sp) + 1;   @         memmove((Tchar * /*~OddCast*/)&w->fileName[0], sp, lgt);;         w = realloc(w, lgt + Offset(TmngtPriv, fileName));}m       w->prec = headListPrivTo;1       headListPrivTo = w;}1     exitBlock();  /* because of getLitString() */m   } while (Found(COMMA));} }    static void skipToEndDP(void)C {)L   static const Ttok zEndDPrag[] = {NoSwallowTok, ENDDPRAG, ENDDIR, EndSTok};     skipTok(zEndDPrag);iI   if (curTok.tok == ENDDIR) {dirLineFl = True; backUp();}  /* to get back  							ENDDIR as next token. */r }	    TpcTypeElt searchTC(TkOpTC oper)F /* Returns usually QuasiNULLval(TpcTypeElt) if no combination found */ {F   TpcTypeElt lType, rType;(   register TsemanElt *lTypeId, *rTypeId;,   TCBlk *ptrTCoper = (*pHeadTCBLists)[oper];  I   if (ptrTCoper==NULL || (lType = lExp.type)==NULL || !lType->paralTyp ||nP        cExp.type==NULL || !cExp.type->paralTyp) return QuasiNULLval(TpcTypeElt);O   /* Prepare to row up hierarchy, in order to find possible combination between(      ancestors. */   do {     lTypeId = lType->typeId;     rType = cExp.type;     do {(       register TCBlk *pcTCB = ptrTCoper;         rTypeId = rType->typeId;
       do {F         if (lTypeId==pcTCB->lTypeId && rTypeId==pcTCB->rTypeId) return 							       pcTCB->resulType;f.       } while ((pcTCB = pcTCB->next) != NULL);H     } while (!rType->rootTyp && (rType = rTypeId->type)!=NULL && rType-> 								      paralTyp);P   } while (!lType->rootTyp && (lType = lTypeId->type)!=NULL && lType->paralTyp);+   if (InsideInterval(oper, MulTC, DivTC) &&DN   /* Search whether one operand appears in a type combination involving opera-K      tor '*' ('normal' type combination for non dimensionless type). If so,nB      complain about missing typeCombination (cf Volt*Volt/Ohm). */A 		     ((ptrTCoper = (*pHeadTCBLists)[MulTC])!=NULL || (ptrTCoperm- 					    = (*pHeadTCBLists)[DivTC])!=NULL)) {      lType = lExp.type;     do {'       TsemanElt *typId = lType->typeId;4(       register TCBlk *pcTCB = ptrTCoper;  
       do {3         if (typId==pcTCB->lTypeId) goto noTCFoundL;).       } while ((pcTCB = pcTCB->next) != NULL);N     } while (!lType->rootTyp && (lType = lType->typeId->type)!=NULL && lType-> 								      paralTyp);     rType = cExp.type;5     if (rType != lExp.type) {  /* test to speed up */x
       do {)         TsemanElt *typId = rType->typeId;x*         register TCBlk *pcTCB = ptrTCoper;           do {5           if (typId==pcTCB->rTypeId) goto noTCFoundL;"0         } while ((pcTCB = pcTCB->next) != NULL);H       } while (!rType->rootTyp && (rType = rType->typeId->type)!=NULL && 							     rType->paralTyp);}}}"   return QuasiNULLval(TpcTypeElt); noTCFoundL:D   {o     TnameBuf buf; !     static Tchar operBuf[] = " ";   .     bufNameToS(cExp.type->typeId->nameb, buf);     operBuf[0] = paramTxt[0];uI     errWNSS(NoTCAllows | Warn1, lExp.type->typeId->nameb, operBuf, buf);}o   return NULL; }P  L static void verifyTC(TpcTypeElt lType, TpcTypeElt rType, TpcTypeElt resType) {uI   TtypeSort tsl = intPromotion(lType), tsr = intPromotion(rType), tsRes =e 							  intPromotion(resType);D      #if UINT_MAXC == ULONG_MAXCl:   if (tsl<tsr) {TtypeSort tsaux=tsr;; tsr=tsl; tsl=tsaux;}M   if (chkPortbl && tsl==Long && tsr==UInt) errWS(NonPortTC | Warn2, LongStr);c #elseg   if (tsl<tsr) tsl = tsr;< #endif g5   if (tsRes!=tsl && !(tsl==Double && tsRes==Float)) {       Tchar buf[SizTypTxtBuf + 1];  #     strcpy(buf, typeToS1(resType));B/     errWSTT(IncorTCResTyp, buf, lType, rType);}  }    /* End DCPRAG.C */