
 /* DCREC.C */ ( /* Y.L. Noyelle, Supelec, France 1994 */   #include <ctype.h> #include <string.h>  #include "dcrec.h" #include "dcrec.ph"  #include "dcblk.h" #include "dcblk.ph"  #include "dcdecl.h"  #include "dcdir.ph"  #include "dcexp.h" #include "dcext.h" #include "dcmain.h"  #include "dcmain.ph" #include "dcprag.ph" #include "dcrecdir.ph"  
 #ifdef VMSF #  pragma noinline (putTokChar, semanErrNb, storeTokSource, syntErrNb) #endif   #define Base8		8 #define Base16		16 #define BitsOctDigit	3B #define ComputeHCode(x) hCode = hCode*HCodeCst + (ThCode)(x - Aln) #define DfltOptVal	-1 & #define DoWhatForNb(x) {						       \@   curTok.val = 0;  /* reset flags for analNumCst() */			       \    frstChOfNb = x;							       \   curTok.tok = CSTNU;}E #define HCodeCst	5  /* changing this constant (that must stay odd for B 		      good scrambling) means changing all hardwired Hcodes... *// #define LexErr(x, y)	srcPtr = ptrS, errWS(x, y) = #define LexErrPhase4(x, y) {if (! condDirSkip) LexErr(x, y);}  #define LgtD(x)		(size_t)*x   #define LimChar		(1<<NbBitsChar), #define Lletter		(Uletter + ('z' - 'a' + 1))& #define ManageLitChar(x)						       \P   if (c=='\n' || c==EndCh && fileClosed) {LexErr(x, NULL); BackUp; break;}     \;   if (c == '\\') ptrS = getEscSeqChar(ptrS, &c);			       \ 4   else if (!IsVisibleChar(c) && c!='\t')				       \/     LexErr(NotVisiChar | Warn2, charToHexS(c));  #define MaxNbCharRepr	3 J #define ResetSpaceAtEndOfL spaceAtEndOfLine = (wrapFl)? LineSize : INT_MAX #define SizeBufDef	LineSize M #define SizeSourceBuffer (NbSrcLinesKept*(LineSize + TransfSize) + 1 + 1 + 1)  #define Uletter		(Aln + Base10)    /* Function profiles */ + static char *getEscSeqChar(char *, char *); ' static TcharStream nxtChFromConc(void); # typedef void TspeTokRecFct(char *); M static TspeTokRecFct nlF, ampersF, dollF, dotF, dQuoteF, eMarkF, eqF, greaTF, L   lessTF, minusF, nbSignF, percentF, plusF, quoteF, slashF, starF, upArrowF,   vBarF;O static void initKeyWords(void), initStoreTokTxt(void), putCh(char), putTokChar( J   char), restoNormState(void), semanErrNb(void), syntErrNb(Terr, Tstring);   /* Global variables */ static char *pConcTxt; static void (*pPutCh)(char); static TstringNC pTokTxt;  static Ttok white = WHITESPACE;    /* External variables */  O char *adSmshCh;  /* address of characters currently smashed in source buffer by B 		     an identifier header (couple id. length, id. nameSpace). */ Terr concatErr = NoErrMsg;J bool dirLineFl = False;  /* True if currently processing directive line */ char frstChOfNb = '\0'; E bool mngConc = False;  /* True if currently doing ## concatenation */  TdescrId *pDescCurId; ) void (*pStoreChFct)(char) = &saveTokChar; F char smshCh[LgtHdrId];  /* buffer to save characters smashed in source& 						buffer 	by identifier header. */# char *srcPtr;  /* source pointer */ P TdescrId *symTabHeads[SizeSymTab];  /* symbol table (heads of 'small tables') */8 Tchar tokTxtBuf[MaxLgtId + 1];  /* general use buffer */    % static const Tname tabKeyWords[] = {  2     /* First byte: length; 2nd byte: name space */     NULL,			/* NOATTRIB */     ConvTname("\6\0static"),6     ConvTname("\6\0extern"), ConvTname("\7\0typedef"),N     ConvTname("\4\0auto"), ConvTname("\x8\0register"), ConvTname("\5\0const"),O     ConvTname("\x8\0volatile"), ConvTname("\4\0enum"), ConvTname("\6\0struct"), J     ConvTname("\5\0union"), ConvTname("\4\0void"), ConvTname("\5\0float"),K     ConvTname("\6\0double"), ConvTname("\4\0char"), ConvTname("\5\0short"), L     ConvTname("\3\0int"), ConvTname("\4\0long"), ConvTname("\x8\0unsigned"),K     ConvTname("\6\0signed"), ConvTname("\5\0break"), ConvTname("\4\0case"), N     ConvTname("\x8\0continue"), ConvTname("\7\0default"), ConvTname("\2\0do"),G     ConvTname("\4\0else"), ConvTname("\3\0for"), ConvTname("\4\0goto"), J     ConvTname("\2\0if"), ConvTname("\6\0return"), ConvTname("\6\0sizeof"),6     ConvTname("\6\0switch"), ConvTname("\5\0while"),};N   /*~ zif (ObjectSpace != (TnameSpace)0) "Table 'tabKeyWords': change second "E 	"byte of each keyword to the new value of ObjectSpace" */ /* cf also  							 'lowLimit', 'maxId'. */ 7   /*~ zif NbElt(tabKeyWords) != (EKeyWords - BKeyWords) - 					      "Table 'tabKeyWords': bad size" */   I /* Action to do on characters; Aln must have highest value, cf working of  							     getTokFromTxt(). */ 2 typedef enum {WhiteSpace = (int)ETok1Char, BegFct,O   IlgCharFct = BegFct, EndPrgFct, NlFct, AmpersFct, DollFct, DotFct, DQuoteFct, M   EMarkFct, EqualFct, GTFct, LTFct, MinusFct, NbSignFct, PercentFct, PlusFct, H   QuoteFct, SlashFct, StarFct, UpArrowFct, VBarFct, EndFct, Aln = EndFct } TcodChar; K static const TcodChar charInfo[/*~ IndexType char */] = {   /* ASCII coding 4 				  assumed; otherwise, just shuffle entries... */7 		EndPrgFct	  /* EndCh (to be left there, regardless of  							    character coding. */ 8 		/*~zif __index!=EndCh "Bad position for EndPrgFct" */,
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct,  		WhiteSpace,	  /* HT */ 		NlFct,		  /* NL */ 		WhiteSpace,	  /* VT */ 		WhiteSpace,	  /* FF */ 		IlgCharFct,	  /* CR */
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct, 
 		IlgCharFct,  		WhiteSpace,	  /* space */  		EMarkFct,	  /* ! */	 		DQuoteFct,	  /* " */ 		NbSignFct,	  /* # */ 		DollFct,	  /* $ */ 		PercentFct,	  /* % */  		AmpersFct,	  /* & */ 		QuoteFct,	  /* ' */  		(TcodChar)LPAR,	  /* ( */  		(TcodChar)RPAR,	  /* ) */  		StarFct,	  /* * */ 		PlusFct,	  /* + */ 		(TcodChar)COMMA,  /* , */  		MinusFct,	  /* - */  		DotFct,		  /* . */ 		SlashFct,	  /* / */  		Aln+0,		  /* 0 */  		Aln+1, 		Aln+2, 		Aln+3, 		Aln+4, 		Aln+5, 		Aln+6, 		Aln+7, 		Aln+8, 		Aln+9,		  /* 9 */  		(TcodChar)COLON,  /* : */  		(TcodChar)SCOL,	  /* ; */  		LTFct,		  /* < */  		EqualFct,	  /* = */  		GTFct,		  /* > */  		(TcodChar)QMARK,  /* ? */  		IlgCharFct,	  /* @ */  		Uletter+0,	  /* A */ 		Uletter+1, 		Uletter+2, 		Uletter+3, 		Uletter+4, 		Uletter+5, 		Uletter+6, 		Uletter+7, 		Uletter+8, 		Uletter+9,
 		Uletter+10, 
 		Uletter+11, 
 		Uletter+12, 
 		Uletter+13, 
 		Uletter+14, 
 		Uletter+15, 
 		Uletter+16, 
 		Uletter+17, 
 		Uletter+18, 
 		Uletter+19, 
 		Uletter+20, 
 		Uletter+21, 
 		Uletter+22, 
 		Uletter+23, 
 		Uletter+24,  		Uletter+25,	  /* Z */  		(TcodChar)LSBR,	  /* [ */  		IlgCharFct,	  /* \ */  		(TcodChar)RSBR,	  /* ] */  		UpArrowFct,	  /* ^ */  		Lletter+26,	  /* _ */  		IlgCharFct,	  /* ` */  		Lletter+0,	  /* a */ 		Lletter+1, 		Lletter+2, 		Lletter+3, 		Lletter+4, 		Lletter+5, 		Lletter+6, 		Lletter+7, 		Lletter+8, 		Lletter+9,
 		Lletter+10, 
 		Lletter+11, 
 		Lletter+12, 
 		Lletter+13, 
 		Lletter+14, 
 		Lletter+15, 
 		Lletter+16, 
 		Lletter+17, 
 		Lletter+18, 
 		Lletter+19, 
 		Lletter+20, 
 		Lletter+21, 
 		Lletter+22, 
 		Lletter+23, 
 		Lletter+24,  		Lletter+25,	  /* z */  		(TcodChar)LBRA,	  /* { */  		VBarFct,	  /* | */ 		(TcodChar)RBRA,	  /* } */  		(TcodChar)TILDE,  /* ~ */  		IlgCharFct,};	  /* DEL */ O /*~ zif NbEltGen(charInfo, '\0')!=LimChar "Array 'charInfo': incorrect size" */    void getTokFromTxt(void) /* Gets next token */  { >   register char *ptrS;	/* local fast copy of source pointer */1   register char c;	/* current source character */ 7   register TcodChar cI; /* info on current character */ @   static TspeTokRecFct *const tabTokFct[/*~IndexType int */] = {J     &ilgCharF, &endPrgF, &nlF, &ampersF, &dollF, &dotF, &dQuoteF, &eMarkF,J     &eqF, &greaTF, &lessTF, &minusF, &nbSignF, &percentF, &plusF, &quoteF,(     &slashF, &starF, &upArrowF, &vBarF};N   /*~ zif NbElt(tabTokFct) != EndFct - BegFct "Array 'tabTokFct': bad size" */  J   getTokLvl++;  /* to be able to detect calls at level 0 ('real' calls) */I   spaceCount = SpaceCntNoBegLine;  /* a priori, no line beginning seen */ C   for (;;) {  /* because of WHITESPACE and false #if/#elif/#else */      ptrS = srcPtr;/     /* Put info on next non-blank char in cI */      for (;;) {       NxtCh C       if ((ubyte)c >= LimChar) LexErr(NotASCIIChar, charToHexS(c)); 8       else if ((cI = charInfo[c]) != WhiteSpace) break;}3     if (cI < Aln) {		/* not an alphanumeric char */ ?       if (cI < (TcodChar)ETok1Char) {	/* direct token number */          curTok.tok = (Ttok) cI;          srcPtr = ptrS;         goto exitL;}:       /* Else there is a specific function to be called */%       (*tabTokFct[cI- BegFct])(ptrS); G       if (curTok.tok == WHITESPACE) continue;  /* happens in particular  							after 'newline' seen. */ *       if (curTok.tok == DOLLVAL) goto idL;       goto exitL;}$     if (cI < Uletter) {	/* number */       DoWhatForNb(c)       srcPtr = ptrS;       goto exitL;}!     /* Else identifier/keyword */  idL:     { J       register char *adBegId = ptrS - 1;  /* address of first character of/ 				current identifier; identifiers are managed 1 				so that their name is always in one piece. */ 4       int lgtId;		/* length of current identifier */P       ThCode hCode;  /* h-code for current identifier (in 'Object' nameSpace) */J       register TdescrId *pCurId;  /* position of identifier description in 								symbol table. */       RestoSmshCh;@       hCode = (ThCode)ObjectSpace*HCodeCst + (ThCode)(cI - Aln);*       for (;;) {  /* collect identifier */3         if ((ubyte)(c = *ptrS++) >= LimChar) break; C         if ((cI = charInfo[c])>=Aln || (c=='$' && (sysAdjHdrFile ||  							       dollAlwdInId))) {            ComputeHCode(cI);            continue;}-         /* Next character not alphanumeric */ H         if (c=='\\' && splice(ptrS)) {ptrS--; continue;}  /* splicing */I         if (c!=EndCh || ptrS!=posEndChP1) break;  /* end of identifier */ M         /* End of source buffer hit: load some more text and, if appropriate, L            copy already seen portion of identifier into fore buffer, so that1           identifier string always contiguous. */ P         lgtId = (int)(ptrS - adBegId) - 1;  /* length of already seen portion */M         if ((ptrS = nxtChunkOfTxt(ptrS))==begSBuf) {  /* next chunk of source - 					  text loaded at beginning of buffer. */ J           if (lgtId > MaxLgtId) lgtId = MaxLgtId;  /* *doIt* if (adBegId <I 	    begSBuf) err(TooBigId); err(TrnctdId) detected in case lgtId>SLI? */ G           adBegId = memmove(begSBuf - lgtId, adBegId, (size_t)lgtId);}} 
       BackUp;        srcPtr = ptrS;<       lgtId = (int)(ptrS - adBegId);	/* identifier length */F       smshCh[1] = *--adBegId;	/* save character about to be smashed */N       *adBegId = (char) ObjectSpace;  /* qualify the name by the name space */       smshCh[0] = *--adBegId; A       adSmshCh = adBegId;  /* note that characters are smashed */ J       curTok.name = ConvTname(adBegId);  /* remember address of identifierB 		nameString (used also for directive keywords, such as '#if'). */G       if (lgtId > MaxLgtId) {  /* truncate identifier if exceed storage  								    capacity. */0         *(TnameNC)adBegId = (TnameAtom)MaxLgtId;O         hCode = hCodFct(ConvTname(adBegId));}  /* recompute H-code, taking only & 						 kept character into account. */O       else *(TnameNC)adBegId = (TnameAtom)lgtId;  /* store identifier length in  							   front of its name. */ M       curTok.hCod = hCode;  /* must be defined even for keywords, in order to - 					   differentiate them from d-pragmas. */ <       /* Search identifier in symbol table (Object Space) */1       SearchSym(ConvTname(adBegId), MacroVisible)        curTok.tok = IDENT; @       if ((pDescCurId = pCurId) == NULL) {  /* new identifier */L         if (lgtId>SignifLgtId && chkPortbl) err0(TrnctdId | Warn2);  /* warn 									once. */          curTok.ptrSem = NULL;}>       else if (pCurId->nstLvl < 0) {    /* keyword or macro */5         if (pCurId->nstLvl + 1 == 0) {  /* keyword */ %           curTok.tok = pCurId->noLex;            goto exitL;}P         else if (macroExpand) {expandMac(); if (curTok.tok!= IDENT) goto exitL;}I         else curTok.ptrSem = NULL;}  /* if inside argument collection for 4 				       macros, do as if identifier undefined. */G       else curTok.ptrSem = pCurId->pIdSeman;  /* 'regular' (and already  							existing) identifier. */ M       if (curTok.ptrSem!=NULL && curTok.ptrSem->undef && getTokLvl==1) errWN( - 					     UndfndId|Warn1|Rdbl, curTok.name);}  exitL:     if (! condDirSkip) {M       if (--getTokLvl==0 && listTok) storeTokSource();  /* only keep token in B 		    "last tokens list" if 'real' (level 0) call to GetNxtTok. */       return;}1     if (InsideInterval(curTok.tok, CSTNU, CSTST)) 6       if (curTok.tok - CSTNU == 0) analNumCst(NoConv);4       else analStrCst(NoConv);}  /* end "for(;;)" */ }   ( static void ampersF(register char *ptrS) {    register char c;     NxtCh &   if (c == '&') {curTok.tok = LOGAND;}G   else if (c == '=') {curTok.val = (uint)AndAsgn; curTok.tok = ASGNOP;} %   else {BackUp; curTok.tok = APSAND;}    srcPtr = ptrS; }   & static void dollF(register char *ptrS) { 8   if (! (sysAdjHdrFile || dollAlwdInId)) ilgCharF(ptrS);   else curTok.tok = DOLLVAL; }   % static void dotF(register char *ptrS)  {    register char c;     NxtCh    if (c == '.') { 	     NxtCh %     if (c == '.') curTok.tok = ELLIP; <     else {BackUp; LexErr(IlgSynt, NULL); curTok.tok = DOT;}}   else {     BackUp; M     if (InsideInterval(charInfo[c], Aln, Aln + ('9' - '0'))) DoWhatForNb('.')      else curTok.tok = DOT;}    srcPtr = ptrS; }    static void dQuoteF(char *ptrS)  {    curTok.tok = CSTST;    srcPtr = ptrS; }   ' static void eMarkF(register char *ptrS)  {    register char c;     NxtCh >   if (c == '=') {curTok.val = (uint)NE; curTok.tok = EQUALOP;}$   else {BackUp; curTok.tok = EMARK;}   srcPtr = ptrS; }   $ static void eqF(register char *ptrS) {    register char c;     NxtCh >   if (c == '=') {curTok.val = (uint)EQ; curTok.tok = EQUALOP;}C   else {BackUp; curTok.val = (uint)SimplAsgn; curTok.tok = ASGNOP;}    srcPtr = ptrS; }   ' static void greaTF(register char *ptrS)  {    register char c;     NxtCh >   if (c == '=') {curTok.val = (uint)GE; curTok.tok = ORDEROP;}   else if (c == '>') {	     NxtCh D     if (c == '=') {curTok.val = (uint)RShAsgn; curTok.tok = ASGNOP;}A     else {BackUp; curTok.val = (uint)RSh; curTok.tok = SHIFTOP;}} =   else {BackUp; curTok.val = (uint)GT; curTok.tok = ORDEROP;}    srcPtr = ptrS; }   " void ilgCharF(register char *ptrS) {    static Tchar errCh[] = " ";      srcPtr = ptrS;    errCh[0] = (Tchar)*(ptrS - 1);H   errWSS((errCh[0] == '$')? IlgCharD : IlgChar, errCh, charToHexS((char) 								     errCh[0]));   curTok.tok = WHITESPACE; }   ' static void lessTF(register char *ptrS)  {    register char c;     NxtCh >   if (c == '=') {curTok.val = (uint)LE; curTok.tok = ORDEROP;}   else if (c == '<') {	     NxtCh D     if (c == '=') {curTok.val = (uint)LShAsgn; curTok.tok = ASGNOP;}A     else {BackUp; curTok.val = (uint)LSh; curTok.tok = SHIFTOP;}} =   else {BackUp; curTok.val = (uint)LT; curTok.tok = ORDEROP;}    srcPtr = ptrS; }   ' static void minusF(register char *ptrS)  {    register char c;     NxtCh =   if (c == '-') {curTok.val = (uint)Dec; curTok.tok = INCOP;} G   else if (c == '=') {curTok.val = (uint)SubAsgn; curTok.tok = ASGNOP;} (   else if (c == '>') curTok.tok = ARROW;<   else {BackUp; curTok.val = (uint)Sub; curTok.tok = ADDOP;}   srcPtr = ptrS; }   ( static void nbSignF(register char *ptrS) {    register char c;     NxtCh &   if (c == '#') curTok.tok = CONCATOP;&   else {BackUp; curTok.tok = QUOTEOP;}D   if (! dirLineFl) {LexErrPhase4(LegalOnlyInMac, NULL); curTok.tok = 								    WHITESPACE;}   srcPtr = ptrS; }   $ static void nlF(register char *ptrS) {    register char c;  2   if (dirLineFl) {  /* end of preprocessor line */     dirLineFl = False;     curTok.tok = ENDDIR;@     condDirSkip = False;}  /* will be re-set by 'manageDir()' */   else {P     if (spaceCount != -1) oldSpaceCount = spaceCount; /* ignore comment lines */     for (;;) {       nlPosP1 = ptrS;C       lineNb++;o       spaceCount = 0;1       for (;;) {
         NxtChcE         if ((ubyte)c >= LimChar) LexErr(NotASCIIChar, charToHexS(c));c2         else if (charInfo[c] != WhiteSpace) break;N         else if (c == '\t') spaceCount = (spaceCount + tabSpacing)/tabSpacing* 								     tabSpacing;        	else spaceCount++;}e:       if (c == '#') {	/* beginning of preprocessor line */         dirLineFl = True;e         srcPtr = ptrS;         manageDir();         ptrS = srcPtr;}i       else {         BackUp;oF         curTok.tok = white;  /* WHITESPACE in general; WHITESPACE+1 in/ 				peepNxtNonBlChFromTxt(), to prevent readingk- 				next token after conditional skipping. */	         break;}}}f   srcPtr = ptrS; }\  ) static void percentF(register char *ptrS)  {c   register char c;     NxtChtB   if (c == '=') {curTok.val = (uint)ModAsgn; curTok.tok = ASGNOP;}<   else {BackUp; curTok.val = (uint)Mod; curTok.tok = MULOP;}   srcPtr = ptrS; }s  & static void plusF(register char *ptrS) {    register char c;     NxtChd=   if (c == '+') {curTok.val = (uint)Inc; curTok.tok = INCOP;}'G   else if (c == '=') {curTok.val = (uint)AddAsgn; curTok.tok = ASGNOP;}=<   else {BackUp; curTok.val = (uint)Add; curTok.tok = ADDOP;}   srcPtr = ptrS; }   ' static void quoteF(register char *ptrS)l {i   uint nbChar = 0;	   char c;)     curTok.error = False;t   for (;;) {	     NxtChe     if (c == '\'') break;R      ManageLitChar(UnFnshCharCst)     curTok.val = (uint)c;)     nbChar++;}O   if (nbChar != 1) {LexErrPhase4(LgtCharCstNotOne|Warn3|PossErr, NULL); curTok.e 								  error = True;}.   curTok.tok = (curTok.error)? CSTCH1 : CSTCH;   srcPtr = ptrS; }   ' static void slashF(register char *ptrS)  {t   register char c;     NxtChv,   if (c == '*') {	/* comment, or d-pragma */6     if (dpragNst != 0) LexErrPhase4(UnclosedDP, NULL);	     NxtChFI     if (c=='~' && dpragNst==0 && !condDirSkip) {srcPtr = ptrS; dpragMet()r& 						      ; return;}  /* d-pragma */     for (;;) {       if (c == '/') {p
         NxtChTG         if (c == '*') {LexErr(UnclosedCmt|Warn2|PossErr, NULL); NxtCh}},       while (c == '*') {
         NxtCht5         if (c == '/') goto exitL;}  /* end comment */cK       if (fileClosed && c==EndCh) {LexErr(UnFnshCmt, NULL); BackUp; break;}e0       if (c == '\n') {nlPosP1 = ptrS; lineNb++;}       NxtCh} exitL:F     curTok.tok = (dpragNst!=0 && !condDirSkip)? ENDDPRAG : WHITESPACE;A     if (spaceCount >= 0) spaceCount = -1;}  /* for always correct/; 			indentation check after comment at beginning of line. */OG   else if (c == '=') {curTok.val = (uint)DivAsgn; curTok.tok = ASGNOP;}e<   else {BackUp; curTok.val = (uint)Div; curTok.tok = MULOP;}   srcPtr = ptrS; }r  & static void starF(register char *ptrS) {e   register char c;     NxtChfB   if (c == '=') {curTok.val = (uint)MulAsgn; curTok.tok = ASGNOP;}8   else if (dpragNst!=0 && c=='/') curTok.tok = ENDDPRAG;#   else {BackUp; curTok.tok = STAR;}u   srcPtr = ptrS; }g  ) static void upArrowF(register char *ptrS)t {e   register char c;     NxtChtB   if (c == '=') {curTok.val = (uint)XorAsgn; curTok.tok = ASGNOP;}"   else {BackUp; curTok.tok = XOR;}   srcPtr = ptrS; }n  & static void vBarF(register char *ptrS) {t   register char c;     NxtCh,%   if (c == '|') {curTok.tok = LOGOR;}(G   else if (c == '=') {curTok.val = (uint)IorAsgn; curTok.tok = ASGNOP;}o"   else {BackUp; curTok.tok = IOR;}   srcPtr = ptrS; }5  P /******************************************************************************/ /*				    UTILITIES				      */oP /******************************************************************************/  # void analNumCst(void(*pPutC)(char))eJ /* The analysis of a constant is only done now so that it is not convertedO    each time it is found (for example, during macro body storage or macro para- )    meter passing), but only when used. */e {n4 #define StoreAndGetCh	{putCh(c); c=(char)NxtChar();}   uint curDigVal, base, base1;   TcalcU value;S	   char c;a*   bool eSeen = False;  /* exponent seen */     pPutCh = pPutC;k   curTok.error = False;fL   base1 = base = Base10;  /* 'base1' needed because 0 alone => base 10... */5   if ((c = frstChOfNb) == '.') {curTok.val |= FltSeen"- 					     ; StoreAndGetCh frstChOfNb = '\0';} &   value = (TcalcU)(charInfo[c] - Aln);"   StoreAndGetCh frstChOfNb = '\0';,   if (value==0 && !(curTok.val & FltSeen)) {E     if (c=='x' || c=='X') {base1 = Base16; StoreAndGetCh}  /* *doIt* A& 						   only hex nb if digit after */     else base1 = Base8;}   for (;;) {#     if ((ubyte)c >= LimChar) break; ;     if ((curDigVal = (uint)(charInfo[c] - Aln)) >= base1) { D       if (base1==Base16 && InsideInterval(c, 'a', 'f')) curDigVal -= 							      Lletter - Uletter; G       else if (curDigVal < Base10) syntErrNb(IlgOctDig, charToHexS(c));E       else {M         if (c == '.') {if ((curTok.val & FltSeen) != 0 || base!=Base10) breakn; 			 ; base1 = Base10; curTok.val |= FltSeen; goto noConvL;}a         if (c=='e' || c=='E') {F+           if (eSeen || base!=Base10) break;a 	  eSeen = True;            curTok.val |= FltSeen;           StoreAndGetCht-           if (c=='+' || c=='-') StoreAndGetCh	J           if ((ubyte)c>=LimChar || !InsideInterval(charInfo[c], Aln, Aln +4 				('9' - '0'))) {syntErrNb(WrngNb1, NULL); break;}           base1 = Base10;C           goto noConvL;}         break;}}     base = base1;C     if (pPutC == NULL) {B       if (! (curTok.val & FltSeen)) {  /* compute binary number */9         uint w = base >> 1;  /* for 'base' always even */c%         TcalcU resulMult = 0, value1;	  J         do {  /* multiply bitwise by 'base' to detect possible overflow */           value1 = value << 1;/           if (value1>>1 != value) semanErrNb();r           value = value1;            if (w & 1) {-             TcalcU temp = resulMult + value1;t  /             if (temp < resulMult) semanErrNb();*             resulMult = temp;}!         } while ((w >>= 1) != 0); .         value = resulMult + (TcalcU)curDigVal;-         if (value < resulMult) semanErrNb();};P       else if (curDigVal != 0) value = 1 + 1;} /* to get NumCstShdBeNamed msg */ noConvL:     StoreAndGetCh}!   /* Process possible suffixes */ 6   if (curTok.val & FltSeen) {  /* floating constant */H     uint w = (c=='f' || c=='F')? FSeen : (c=='l' || c=='L')? LDSeen : 0;  E     curTok.numVal = (TcalcS)value;  /* until better processing ... */e1     if (w != 0) {curTok.val |= w; StoreAndGetCh}}7    else {  /* integer constant */     uint w;0  "     curTok.numVal = (TcalcS)value;     for (;;) {       switch(c) {t+       case 'u': case 'U': w = USeen; break;*       case 'l': case 'L':  #ifndef LONGLONGM         if (sysAdjHdrFile)  /* 'LL' always accepted in system header files */	 #endif	         {e.           if (curTok.val & (LSeen | LLSeen)) {             w = LLSeen;	!             curTok.val &= ~LSeen;+             break;}}         w = LSeen; break;	       default:1         if (base != Base10) curTok.val |= OctHex;t:         if ((TcalcS)value < 0) {  /* a-priori, overflow */L           if (curTok.val & OctHex) curTok.val |= USeen;  /* if octal or hex, 							 convert to unsigned. */*J           else if (pPutC==NULL && curTok.val & SignSeen && (!(curTok.val &4 				  NegSeen) || -(TcalcS)value>=0)) semanErrNb();}         goto exitNbL;}2       if (curTok.val & w) syntErrNb(WrngNb, NULL);       curTok.val |= w;       StoreAndGetCh}}v exitNbL:(   if (pNxtCh == &nxtChFromTxt) srcPtr--;   restoNormState();p #undef StoreAndGetCh }   # void analStrCst(void(*pPutC)(char))aO /* The analysis of a string constant is only done now, so that it can be storedTJ    at different places (for example, during macro body storage or for real    use). */s {&   pPutCh = pPutC;t.   if (! MacroTxt) {  /* not macro expansion */!     register char *ptrS = srcPtr;o     char c;a       for (;;) {       NxtCh;       if (c == '\"') break;!!       ManageLitChar(UnFnshStrCst)'       putCh(c);}     srcPtr = ptrS;}    else     for (;;) {       int c;  %       if ((c = NxtChar()) < 0) break;B       putCh((char)c);}0   if (listTok && getTokLvl==0) saveTokChar('"');   restoNormState();l   restoQuoState(); }    void backUp(void)  {*   srcPtr--;n }    static Tstring curTokTxt(void)7 /* Yields the string representation of current token */r {o #include "dctxttok.h"c   switch (curTok.tok) {=*   case IDENT: return nameToS(curTok.name);E   case FORCEMACEXP: case FORCEMACEXP1: case NOMACEXP: return nameToS(r 							    pDescCurId->idName);b   case CSTCH: case CSTCH1: {*       void (*savPSCF)(char) = pStoreChFct;          pStoreChFct = &putTokChar;       tokTxtBuf[0] = '\'';       pTokTxt = &tokTxtBuf[1];@       if (curTok.tok != CSTCH1) {  /* not erroneous character */8         if ((char)curTok.val == '\'') *pTokTxt++ = '\\';+         storeTokTxtRepr((char)curTok.val);}        *pTokTxt++ = '\'';       *pTokTxt = '\0';       pStoreChFct = savPSCF;       return &tokTxtBuf[0];}   case CSTNU:    return "";i   case CSTST:    return "\""; 5   case ADDOP:    return txtAddTok[(TkAdd)curTok.val]; 7   case ASGNOP:   return txtAsgnTok[(TkAsgn)curTok.val];rC   case EQUALOP: case ORDEROP:  return txtCmpTok[(TkCmp)curTok.val]; 5   case INCOP:    return txtIncTok[(TkInc)curTok.val];h5   case MULOP:    return txtMulTok[(TkMul)curTok.val];c5   case SHIFTOP:  return txtShiTok[(TkShi)curTok.val];p   default: {N       static const Tstring tok1ChTxtRepr[/*~IndexType Ttok*/] = {"", ":", ",",; 			"{", "(", "[", "->", ".", "?", "}", ")", "]", ";", "~"}; L       static const Tstring tok2ChTxtRepr[] = {"", "&", "^", "|", "&", "...",I 	"!", "", "", "", "&&", "||", "", "", "", "*", DPragPrefix, DPragSuffix};i  C       if (curTok.tok < ETok1Char) return tok1ChTxtRepr[curTok.tok]; O       if (curTok.tok < EKeyWords) return (curTok.tok==DEFAULT && curTok.val==0)( 		? ""< 		: (Tstring)tabKeyWords[curTok.tok - BKeyWords] + LgtHdrId;P       if (curTok.tok < BSideEffTok) return tok2ChTxtRepr[curTok.tok -EKeyWords];       return "";}} }l  : static char *getEscSeqChar(register char *ptrS, char *pch)? /* Manages escape sequences for string or character constant */  {d   char c, errC;l   uint charVal;*     NxtCh :   if (InsideInterval(c, '0', '9')) {  /* octal constant */
     int i;       charVal = 0;)     for (i = 0; i < MaxNbCharRepr; i++) {        uint curDigVal;   K       if ((curDigVal = (uint)(c - '0')) > (uint)('7' - '0')) {LexErrPhase4( 4 				IlgOctDig, charToHexS(c)); curTok.error = True;}4       charVal = (charVal<<BitsOctDigit) + curDigVal;       NxtCh 0       if (! InsideInterval(c, '0', '9')) break;}     BackUp;}   else {     const char *ptr;O     static const char speChar[] = {'n','t','\'','\"','\\','\?','v','b','r','f',h 								       'a','x'};O     static const char correspChar[/*~IndexType ptrdiff_t */] = {'\n','\t','\'',y4 				  '\"','\\','\?','\v','\b','\r','\f','\a','\0'};D     /*~ zif (NbElt(speChar) != NbElt(correspChar)) "Pb 'speChar'" */  :     for (ptr = &speChar[0]; ptr <= AdLastElt(speChar); ) {       if (c == *ptr++) {         bool digitSeen;i  L         if ((charVal = (uint)correspChar[ptr - &speChar[1]]) != 0) goto okL;"         /* Hexadecimal constant */         digitSeen = False;         for (;;) {           uint curDigVal;              NxtCh()           if ((ubyte)c >= LimChar) break; @           if ((curDigVal = (uint)(charInfo[c] - Aln))>=Base16) {5             if (! InsideInterval(c, 'a', 'f')) break;e,             curDigVal -= Lletter - Uletter;}           digitSeen = True; 8           charVal = (charVal<<BitsHexDigit) + curDigVal;L           if (charVal > UCHAR_MAXC) charVal = UCHAR_MAXC + 1;}  /* to detect 								    overflow. */         BackUp;o          if (digitSeen) goto okL;         errC = '\0';         goto errL;}}
     errC = c;  errL:).     LexErrPhase4(IlgEscSeq, charToHexS(errC));'     if (fileClosed && c==EndCh) BackUp;n5     charVal = 1;  /* to avoid a fake NUL character */      curTok.error = True;}u okL:K   if (charVal > UCHAR_MAXC) {LexErrPhase4(Overflow1 | Warn3, NULL); curTok.{ 								  error = True;}   *pch = (char)charVal;L   return ptrS; }o    ThCode hCodFct(register Tname x)4 /* hash-code (=> curTok.hCod) guaranteed non zero */ {    uint lgt;r   ThCode hCode;;  A   lgt = (uint)*x++;	/*~ zif (DispLgtId != 0) "Pb in hCodFct()" */ D   hCode = (ThCode)*x++;	/*~ zif (DispNSId != 1) "Pb in hCodFct()" */>   do {ComputeHCode(charInfo[(char)*x++]);} while (--lgt != 0);   return hCode;p }e   static void initKeyWords(void) {t   const Tname *pExplTabKW;   TdescrId *ptrDescKW;  J   for (pExplTabKW = &tabKeyWords[0]; pExplTabKW <= AdLastElt(tabKeyWords); 								 pExplTabKW++) {     if (*pExplTabKW != NULL) {D       ptrDescKW = enterSymTabHC1(*pExplTabKW, hCodFct(*pExplTabKW));K       ptrDescKW->noLex = BKeyWords + (int)(pExplTabKW - &tabKeyWords[0]);}}t
   ctrDIE = 0;) }a   void initRec(void) {l   static bool frstInit = True;  3   if (frstInit) {initKeyWords(); frstInit = False;}p   initStoreTokTxt(); }    bool isAlfa(char c)  {'   return ((ubyte)c >= LimChar)          ? False          : (c == '$')s*            ? sysAdjHdrFile || dollAlwdInId            : charInfo[c]>=Aln; }p   void manageConc(void)o< /* BEWARE of recursive case (e.g. a##b##c => ## a ## b c) */ {n@   static char concatBuf[LgtHdrId + MaxLgtId + 1 + MaxConcatLvl],- 					     *pConcatBuf = &concatBuf[LgtHdrId];c1   char *oldPConcBuf = pConcatBuf, *concSavSrcPtr; /   bool errTokTooLong = False, scndTurn = False;{   void (*rmbPGNT)(void) = NULL;r     for (;;) {     Tstring ptrTokTxt;     size_t lgtTokTxt;l       ptrTokTxt = curTokTxt();3     if (InsideInterval(curTok.tok, CSTNU, CSTST)) { *       ptrTokTxt = pTokTxt = &tokTxtBuf[0];;       if (curTok.tok - CSTNU == 0) analNumCst(&putTokChar);        else {,         void (*savPSCF)(char) = pStoreChFct;           *pTokTxt++ = '"';("         pStoreChFct = &putTokChar;%         analStrCst(&storeTokTxtRepr);u         putTokChar('"');<         pStoreChFct = savPSCF;}  /* back to initial value */       *pTokTxt = '\0';}C     RestoSmshCh'M     if (pConcatBuf + (lgtTokTxt = strlen(ptrTokTxt)) > AdLastElt(concatBuf) +( 									    1) {T       errTokTooLong = True;=C       lgtTokTxt = (size_t)(AdLastElt(concatBuf) + 1 - pConcatBuf);}r-     memcpy(pConcatBuf, ptrTokTxt, lgtTokTxt);a     pConcatBuf += lgtTokTxt;     if (scndTurn) break;     GetNxtTok();     scndTurn = True;}o0   if (errTokTooLong) concatErr = CrtdTokTooLong;N   else if (pConcatBuf == oldPConcBuf) concatErr = EmptyTxt;  /* empty token */"   else {  /* no error up to now */=     concatErr = NoConcErr;  /* to intercept possible error */ 7     *pConcatBuf = ' ';  /* end of created token text */p     concSavSrcPtr = srcPtr;t     srcPtr = oldPConcBuf;]     mngConc = True;I     macroExpand = False;     { #       int savSpaceCnt = spaceCount;k  /       getTokFromTxt();  /* get created token */h        spaceCount = savSpaceCnt;}     macroExpand = True;'3     if (InsideInterval(curTok.tok, CSTNU, CSTST)) {        rmbPGNT = pCurGNT;       pNxtCh = &nxtChFromTxt;o6       if (curTok.tok - CSTNU == 0) analNumCst(NoConv);8       else analStrCst(NoConv);  /* end checking phase */       pNxtCh = &nxtChFromMac;}J     if (concatErr==NoConcErr /* no error seen yet */ && srcPtr!=pConcatBuf 							 ) concatErr = EmptyTxt;t     mngConc = False;     srcPtr = concSavSrcPtr;}   if (concatErr != NoConcErr) { 7     *pConcatBuf = '\0';  /* in order to get a string */k@     errWSS(IlgCrtdTok, (Tstring)oldPConcBuf, errTxt[concatErr]);I     curTok.tok = SCOL;}  /* arbitrary; but ## must always return a token, - 					because of a##b##c and error in b##c. */    else if (rmbPGNT != NULL) { O     pConcTxt = (curTok.tok == CSTNU)? (frstChOfNb = *oldPConcBuf, oldPConcBuf +  							       1) : oldPConcBuf;L     pNxtCh = &nxtChFromConc;N     pCurGNT = rmbPGNT;}  /* no lexical error can occur now in number/string */   concatErr = NoErrMsg;t   pConcatBuf = oldPConcBuf;) }   & static TcharStream nxtChFromConc(void) { "   return (TcharStream)*pConcTxt++; }     char peepNxtNonBlChFromTxt(void)* /* See prerequisites in nxtCharOrMacTok().P    Go also through newlines, so to be used with care because of checkIndent() */ {)   for (;;) {     char c;        {e#       register char *ptrS = srcPtr;          for (;;) {
         NxtCh A         if ((ubyte)c>=LimChar || charInfo[c]!=WhiteSpace) break;} 
       BackUp;a       srcPtr = ptrS;     };     if (c == '\n') {/       TdescrId *savPDCI, *savPNxtMac = pNxtMac;b       TvalTok savCurTok;=       int savOldSpCnt = oldSpaceCount, savSpCnt = spaceCount;*       uint savDPNst = dpragNst;/  N       if (curTok.tok == IDENT) curTok.name = ((savPDCI = pDescCurId) == NULL)?B 		       storeName(curTok.name, ObjectSpace) : pDescCurId->idName;       savCurTok = curTok;i       getTokLvl++;=       nlF(srcPtr + 1);  /* may be a directive "white line" */e       getTokLvl--;       if (condDirSkip) {<         white = WHITESPACE+1;  /* anything but WHITESPACE */         GetNxtTok();         white = WHITESPACE;}       pDescCurId = savPDCI;.       curTok = savCurTok;.9       oldSpaceCount = savOldSpCnt; spaceCount = savSpCnt;T       dpragNst = savDPNst;       pNxtMac = savPNxtMac;}     else return c;}) }    static void putCh(char c)C { 4   if ((size_t)pPutCh > (size_t)NoConv) (*pPutCh)(c);F   if (listTok && getTokLvl==0 && frstChOfNb=='\0') storeTokTxtRepr(c); }G   static void putTokChar(char c) {(H   if (pTokTxt < &tokTxtBuf[NbElt(tokTxtBuf) - 1]) *pTokTxt++ = (Tchar)c; }g    static void restoNormState(void) { 7   if (pNxtCh == &nxtChFromConc) pNxtCh = &nxtChFromMac;  }    static void semanErrNb(void) {    if (! curTok.error) {h     err0(Overflow1 | Warn2);     curTok.error = True;}( }h  ( void skipTok(const Ttok stopTokenList[]) {o.   for (; curTok.tok != ENDPROG; GetNxtTok()) {     register const Ttok *ptrT;'     register Ttok currTok = curTok.tok;   K     if (currTok==CASTTO || currTok==INDEXTYPE) FreeExpType1(curTok.dpType); .     if (InsideInterval(currTok, CSTNU, CSTST))3       if (currTok - CSTNU == 0) analNumCst(NoConv);        else analStrCst(NoConv);@     /* Search whether current token inside 'stop tokens' list */     ptrT = &stopTokenList[0];      do {       if (currTok == *ptrT++) { (         if (ptrT == &stopTokenList[1]) {J           if (currTok==LBRA || currTok==RBRA || currTok==SCOL || currTok==& 						       COMMA) ignoreErr = False;3           else if (currTok == ENDDPRAG) dpragNst--;h4           GetNxtTok();}  /* 'swallow' first token */         return;}     } while (*ptrT != EndSTok);C)     if (currTok == ENDDPRAG) dpragNst--;}& }o   void storeTokSource(void)P {;   storeTokTxt(curTokTxt());a }o   static Tchar prevChar = ' ';  ! static void initStoreTokTxt(void)t {    prevChar = ' ';* }    void storeTokTxt(Tstring w)l {($   if (pStoreChFct == &saveTokChar) {9     if (curTok.tok==CSTNU && pStoreChFct==&saveTokChar) {}:       /* Put 1st character of constant in '+zlt' buffer */$       static Tchar skelStr[] = "\0";  %       skelStr[0] = (Tchar)frstChOfNb;u       w = &skelStr[0];}P.     /* Insert separating space if necessary */&     if (isAlfa(prevChar) && isAlfa(*w)7         || (*w==prevChar && strchr("+-<>=&|", *w)!=NULLrO         || *w=='=') && strchr("+-<>=!&|*/%^.", prevChar)!=NULL) (*pStoreChFct)(., 				' ');}  /* so that "==-(3)" outputted as& 						"==-(3)", and "+ =" as "+ =". */P   if (*w != '\0') { /* some token texts may be empty (for example, ? tokens). */     do {       (*pStoreChFct)(*w++);      } while (*w != '\0');      prevChar = *(w - 1);}r }n   /*~Undef prevChar */   void storeTokTxtRepr(char c) {}   if (isprint(c)) {51     if (c=='\"' || c=='\\') (*pStoreChFct)('\\');*     (*pStoreChFct)(c);     return;}'   {  /* Replace invisible characters */*4     static const char tSpeChar[] = "\n\t\v\b\r\f\a";#     const char *ptr = &tSpeChar[0];d       (*pStoreChFct)('\\');y2     /* Search if invisible character has a name */     do {O       if (*ptr++ == c) {(*pStoreChFct)("ntvbrfa"[ptr - &tSpeChar[1]]); return;}      } while (*ptr != '\0');}N   {  /* Else output hex coding (to draw attention on fact that not decimal) */     Tstring w = charToHexS(c);  <     if (((int)c & UCHAR_MAXC) >= Base8) (*pStoreChFct)('x');3     do {(*pStoreChFct)(*w++);} while (*w != '\0');}  }e  ( static void syntErrNb(Terr n, Tstring y) { N   if (!MacroTxt && !condDirSkip) errWS(n, y);  /* msg only at macro collection 									time. */d   curTok.error = True; }    /* End DCREC.C */a