< (* DELIVER.PAS - General MAIL delivery manager for VMS MAIL.   Modification History   ;    Written by Ned Freed, 23-Sep-1985, modified 30-Apr-1986. ?    Mail dispatch interface originally written by Kevin Carosso. 6    Some modifications by Sheldon Smith, December 1986.G    Rewrite by Ned Freed to use new $GETUAI system service, 15-Dec-1986. :    This change requires the use of VMS 4.4 and Pascal 3.4.             @    Modified by Andy Leslie to run under VMS X5.0-3N2 21-Dec-1987@    - Changed destination to 0::_username - _username has the "_">      stripped by VMS otherwise. Also, V5 changes to MAIL meantC      I had to move the "! sent to ..." string to the subject field.      >    Modified by Andy Leslie to run under VMS V5.0-1 20-Jul-1988A    - Re-ordered $SNOJBC item list so that Username is first. This A      is to allow for a feature of the VMS Job Controller in 5.0-1 E      Built and tested on VMS V5.0-1 using a FT version of PASCAL and        PASSTR.  &    Modified by Rich Whalen 11-Feb-1993C    - The lengths of the device string and the device with directory A      string were insufficent, extended to 31 and 79 respectively.    CaveatH    It is believed that it will work on versions of VMS prior to VMS V5, *    but this is untested by me, AJL 23-7-88   What is DELIVER?       C    DELIVER provides a general-purpose MAIL delivery manager similar @    to the MMDF-II MAILDELIVERY system. DELIVER makes it possibleC    for users to set up a file containing screening information that A    automatically deals with each incoming message. Actions may be B    selectively taken by DELIVER based on information in the From:,1    To: and Subject: fields of the message header.    B    DELIVER operates as a foreign mail interface to VMS MAIL and isF    invoked with a call to LIB$FIND_IMAGE_SYMBOL in MAIL. The shareableI    image containing this code should be placed in SYS$LIBRARY as the file     DELIVER_MAILSHR.EXE).   A    Users may activate DELIVER by setting their forwarding address E    to DELIVER%username, where "username" is the user's own user name. D    In order for DELIVER to perform any useful function a file calledG    MAIL.DELIVERY must be present in the user's default login directory.    K    DELIVER's operation is only meaningful in outgoing mode; however, rather F    than waste a possible incoming MAIL interface, DELIVER implements aK    rudimentary mail posting mechanism on the incoming side that can be used -    to send messages contained in data files.    E    If privileges are not granted by you using the DELIVER$STARTUP.COM M    provided, SYSNAM and CMKRNL will be required to run DELIVER in this mode.  @    You may wish to do this  since it is possible to forge From: "    addresses using this mechanism.      Note: A     The foreign protocol interface within MAIL is undocumented at @     this time.  It may change without notice in a future release(     of VMS. Indeed it already has, once.   D     The information necessary to write this code comes from the MAILE     source on the VMS microfiche.  The most useful information is the G     routine NETJOB in module MAIL$MAIL (230-E2), which handles incoming G     foreign mail, and the various routines in module NETSUBS (230-N11), 2     most of which deal with outgoing foreign mail.   Gotchas        File Protections:      5     It seems that SYS$SHARE:PASRTL.EXE must be (W:RE) A                   SYS$SYSTEM:VMSMAIL_PROFILE.DATA must be (W:RW)  7                   SYS$SYSTEM:*MAIL*.EXE must be (W:RE)  2                   SYS$MESSAGE:*.MSG must be (W:RE),     		  SYS$SYSTEM:SEARCH.EXE must be (W:RE)     F     DON'T forget to Edit MAIL.DELIVERY and the DELIVER_REPLY.COM files(     to suit you or it'll all fall apart.   N     Don't forget to create the DELIVER$DIR directory and put DELIVER_REPLY.COML     plus DELIVER_REPLY.TXT there. DELIVER.HISTORY will be created there too.     D     Finally, if all else fails, SET AUDIT/ALARM/ENABLE=ALL and watchG     the messages fly past! Sooner or later you'll see what the problems      are.   *)   : [inherit ('SYS$LIBRARY:STARLET')] module deliver (output);    const    (* Debugging control flags *) N   DEBUG_IN  = FALSE;            (* Debug messages produced by receive code. *)D   DEBUG_OUT = FALSE;		(* Debug messages produced by send code.    *)   2   (* Switch for use of SJC$_USER_IDENTIFICATION *)&   use_sjc_user_identification = false;  K   LNK_C_OUT_CONNECT  = 0;       (* MAIL protocol link actions.           *) K   LNK_C_OUT_SENDER   = 1;       (* These are defined in MAILSHR.MAR      *) K   LNK_C_OUT_CKUSER   = 2;       (* but because we cannot have external   *) K   LNK_C_OUT_TO       = 3;       (* constants in Pascal, they are         *) K   LNK_C_OUT_SUBJ     = 4;       (* redefined here.                       *)    LNK_C_OUT_FILE     = 5;    LNK_C_OUT_CKSEND   = 6;    LNK_C_OUT_DEACCESS = 7;       LNK_C_IN_CONNECT = 8;    LNK_C_IN_SENDER  = 9;    LNK_C_IN_CKUSER  = 10;   LNK_C_IN_TO      = 11;   LNK_C_IN_SUBJ    = 12;   LNK_C_IN_FILE    = 13;      LNK_C_IO_READ  = 14;   LNK_C_IO_WRITE = 15;      LNK_C_IN_CC = 16;    LNK_C_OUT_CC = 17;     LNK_C_IN_ATTRIBS = 18;   LNK_C_OUT_ATTRIBS = 19;   D   parameter_size     = 512;     (* Size of a single parameter in theG                                    MAIL.DELIVERY file. This is also the O                                    maximum size of lines read from any file. *) D   max_parameters     = 7;       (* Maximum number of parameters that<                                    can appear on a line in a8                                    MAIL.DELIVERY file *)D   min_parameters     = 5;       (* Minimum number of parameters that<                                    can appear on a line in a8                                    MAIL.DELIVERY file *)E   from_parameter     = 1;       (* Position of the From: parameter *) C   to_parameter       = 2;       (* Position of the To: parameter *) H   subject_parameter  = 3;       (* Position of the Subject: parameter *)H   decision_parameter = 4;       (* Position of the decision parameter *)F   action_parameter   = 5;       (* Position of the action parameter *)O   argument1_parameter = 6;       (* Position of the first argument parameter *) P   argument2_parameter = 7;       (* Position of the second argument parameter *)   N   stack_size = 10;              (* State mach. stack for messages from MAIL *)     device_string_len = 31;    directory_string_len = 79;   K   DCL_line_size = 256;          (* Maximum possible line allowed by DCL. *)   H   big_size = 1024;              (* Longest text line allowed in mail. *)  C   UAF$S_DEFDEV = 32;            (* Size of fields in SYSUAF.DAT. *)    UAF$S_DEFDIR = 64;   UAF$S_ACCOUNT = 32;    type   $ubyte = [byte] 0..255;    $uword = [word] 0..65535; ,   string = varying [parameter_size] of char;*   big_string = varying [big_size] of char;   J   (* A string descriptor type used to handle the descriptors MAIL hands to      DELIVER. *)<   longest_possible_string = packed array [1..65536] of char;   string_descriptor = record1                         length : [word] 0..65535; 6                         dclass, dtype : [byte] 0..255;;                         address : ^longest_possible_string;                        end;   C   (* Storage for a single line of MAIL.DELIVERY file information *) )   parameter_block_ptr = ^parameter_block;    parameter_block = recordH                       parameters  : array [1..max_parameters] of string;8                       next        : parameter_block_ptr;,                       any_from    : boolean;,                       any_to      : boolean;,                       any_subject : boolean;5                     end; (* parameter_block record *)    9   account_name = packed array [1..UAF$S_ACCOUNT] of char; +   user_name = packed array [1..12] of char;    priorities = [byte] 0..255;    I   (* Storage for information about a single recipient. The uic, username, E      account and priority fields are ordered to match the format of a @      SJC$_USER_IDENTIFICATION buffer and cannot be reordered. *)   user_block_ptr = ^user_block;    user_block = record (                  uic         : unsigned;)                  username    : user_name; ,                  account     : account_name;-                  priority    : [byte] 0..255; /                  user_length : [word] 0..65535; &                  directory   : string;3                  rules_list  : parameter_block_ptr; .                  next        : user_block_ptr;4                  copyname    : varying [29] of char;+                end; (* user_block record *)    :   (* Possible reasons why MAIL_IO_WRITE will be called. *)B   write_states = (bad_msg, user_check, delivery_check, error_msg);   B   (* A stack structure to store information about pending calls to      MAIL_IO_WRITE. *)   write_state_stack = record&                         top : integer;F                         store : array [1..stack_size] of write_states;9                       end; (* write_state_check record *)    "   (* Record for VMS item lists. *)   item = record $            len    : [word] 0..65535;$            code   : [word] 0..65535;#            addr   : [long] integer; #            rlen   : [long] integer;           end; (* item record *)   1   file_attribute_block = array [0..1] of integer;     var B   default_batch_queue : [static, readonly] string := 'MAIL$BATCH';8   system_batch_queue : [readonly] string := 'SYS$BATCH';=   batch_log : [static] string; batch_keep : [static] boolean;    C   (* Storage for message header information on the outgoing side *) B   tostring, fromstring, subjectstring, ccstring : [static] string;  &   folder_invocation : [static] string;  <   (* List of active recipients and associated information *)6   user_list, user_list_last : [static] user_block_ptr;%   user_count : [static] integer := 0;        from_owner : [static] boolean;   ?   (* Storage for accumulated To: line for incoming messages. *)       toline : [static] string;    6   (* The state machine for MAIL status information. *)   )   write_recv_states  : write_state_stack; %   last_error, sticky_error : integer;    6   (* Error message codes defined in DELIVER_ERR.MSG *))   DELIVER__GOTNOSYSPRV, DELIVER__NOTPRIV, @   DELIVER__CANACCUAF, DELIVER__NOSUCHUSER, DELIVER__NAMETOOLONG,G   DELIVER__NODEFAULTDIR, DELIVER__TOOMANYPARAMS, DELIVER__TOOFEWPARAMS, N   DELIVER__NOMDFILE, DELIVER__MDIGNORED, DELIVER__NORULES, DELIVER__MESREAERR,P   DELIVER__GETFILERR, DELIVER__MESWRTERR, DELIVER__INTSTKOVR, DELIVER__STKEMPTY,=   DELIVER__BADSTKELE, DELIVER__MESOPNERR, DELIVER__MSGWRTERR, G   DELIVER__MSGREAERR, DELIVER__USERNOEXIST : [external, value] integer;    0   MAIL$C_PROT_MAJOR : [external, value] integer;  @   arm_write_access : [static, readonly] unsigned := ARM$M_WRITE;  , (* Routine to get job/process information *)   function LIB$GETJPI ( =   item_code : integer; var process_id : unsigned := %immed 0; =   process_name : [readonly] varying [u1] of char := %immed 0; '   var out_value : unsigned := %immed 0; 4   var out_string : varying [u2] of char := %immed 0;9   var out_len : integer := %immed 0) : integer; external;    (* Routine to signal errors *)   D procedure LIB$SIGNAL (%IMMED stat : [list, unsafe] integer); extern;   , (* Routine to read command line arguments *)   6 function CLI$GET_VALUE (name : varying [max1] of char;6   var val : varying [max2] of char) : integer; extern;   " (* Routine to get symbol values *)   7 function LIB$GET_SYMBOL (name : varying [max1] of char; 9   var result : varying [max2] of char) : integer; extern;    " (* Routine to set symbol values *)   7 function LIB$SET_SYMBOL (name : varying [max1] of char; 5   svalue : varying [max2] of char) : integer; extern;    7 function STR$UPCASE (var dststr : varying [l1] of char; 7   var srcstr : varying [l2] of char) : integer; extern;   J (* create_with_SYSPRV is a Pascal user-action routine for OPEN statements.J    It enables SYSPRV while doing certain OPEN's so we can write files into    user directories. *)    0 function create_with_SYSPRV (var fab : FAB$TYPE;0                              var rab : RAB$TYPE;7                              var fil : text) : integer;  type/   protection = packed array [0..15] of boolean;    var    stat, i : integer;0   ppriv, priv : [quad] array [0..1] of unsigned;   xabptr : ^XAB$TYPE;     begin (* create_with_SYSPRV *);   if DEBUG_OUT then writeln ('create_with_SYSPRV called.');   (   priv[0] := PRV$M_SYSPRV; priv[1] := 0;N   stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);   if odd (stat) then begin%     FAB.FAB$V_LNM_MODE := PSL$C_EXEC;      new (xabptr);      xabptr^.XAB$L_ACLBUF := 0;     xabptr^.XAB$W_ACLSIZ := 0;&     xabptr^.XAB$B_BLN := XAB$K_PROLEN;#     xabptr^.XAB$B_COD := XAB$C_PRO; '     xabptr^.XAB$L_NXT := fab.FAB$L_XAB;      (* s:rwed, o:rwed, g, w *)A     FOR i := 0 TO 7 DO xabptr^.XAB$W_PRO::protection[i] := false; A     FOR i := 8 TO 15 DO xabptr^.XAB$W_PRO::protection[i] := true;      xabptr^.XAB$L_UIC := 0;      stat := $CREATE (FAB);.     if odd (stat) then stat := $CONNECT (RAB);'     fab.FAB$L_XAB := xabptr^.XAB$L_NXT;      dispose (xabptr);    end    elseO     if DEBUG_OUT then writeln ('Error setting privs for create_with_SYSPRV');   -   priv[0] := uand (priv[0], unot (ppriv[0])); -   priv[1] := uand (priv[1], unot (ppriv[1])); 5   $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);    create_with_SYSPRV := stat;  end; (* create_with_SYSPRV *)    H (* open_with_SYSPRV is a Pascal user-action routine for OPEN statements.E    It enables SYSPRV while doing certain OPEN's so we can read system     files. *)   . function open_with_SYSPRV (var fab : FAB$TYPE;.                            var rab : RAB$TYPE;5                            var fil : text) : integer;  var @   stat : integer; ppriv, priv : [quad] array [0..1] of unsigned;    begin (* open_with_SYSPRV *)9   if DEBUG_OUT then writeln ('open_with_SYSPRV called.'); (   priv[0] := PRV$M_SYSPRV; priv[1] := 0;N   stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);   if odd (stat) then begin:     FAB.FAB$V_LNM_MODE := PSL$C_EXEC; stat := $OPEN (FAB);.     if odd (stat) then stat := $CONNECT (RAB);   end;-   priv[0] := uand (priv[0], unot (ppriv[0])); -   priv[1] := uand (priv[1], unot (ppriv[1])); 5   $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);    open_with_SYSPRV := stat;  end; (* open_with_SYSPRV *)    F (* find_user_directory locates a user in the system authorization fileC    and returns his or her default login directory (which is where a D    MAIL.DELIVERY file must reside). find_user_directory also returnsC    the user's UIC and account since this information will be needed *    for creating the delivery batch job. *)   > function find_user_directory (username : varying [l1] of char;7   var user_directory : string; var user_uic : unsigned; H   var user_account : account_name; var priority : priorities) : boolean;    var C   device_with_prefix : packed array [1..device_string_len] of char; I   directory_with_prefix : packed array [1..directory_string_len] of char; /   items : array [1..6] of item; stat : integer; 0   ppriv, priv : [quad] array [0..1] of unsigned;    begin (* find_user_directory *) <   if DEBUG_OUT then writeln ('find_user_directory called.');   find_user_directory := false;     if length (username) > 12 then(     LIB$SIGNAL (DELIVER__NAMETOOLONG, 2,:                 username.length, iaddress (username.body))   else begin     with items[1] do begin/       len := size (user_uic); code := UAI$_UIC; -       addr := iaddress (user_uic); rlen := 0;      end; (* with *)      with items[2] do begin1       len := UAF$S_ACCOUNT; code := UAI$_ACCOUNT; 1       addr := iaddress (user_account); rlen := 0;      end; (* with *)      with items[3] do begin4       len := device_string_len; code := UAI$_DEFDEV;7       addr := iaddress (device_with_prefix); rlen := 0;      end; (* with *)      with items[4] do begin/       len := UAF$S_DEFDIR; code := UAI$_DEFDIR; :       addr := iaddress (directory_with_prefix); rlen := 0;     end; (* with *)      with items[5] do begin/       len := size (priority); code := UAI$_PRI; -       addr := iaddress (priority); rlen := 0;g     end; (* with *)o     with items[6] do begin0       len := 0; code := 0; addr := 0; rlen := 0;     end; (* with *)t?     (* Enable SYSPRV to check for valid user recipient-name. *)i*     priv[0] := PRV$M_SYSPRV; priv[1] := 0;H     $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);:     stat := $GETUAI (usrnam := username, itmlst := items);=     if stat = SS$_NOPRIV then LIB$SIGNAL (DELIVER__CANACCUAF)2$     else if stat = SS$_NOSYSPRV then;       LIB$SIGNAL (DELIVER__GOTNOSYSPRV, 2, username.length,S+                   iaddress (username.body))      else if not odd (stat) then.)       LIB$SIGNAL (DELIVER__NOSUCHUSER, 2,M<                   username.length, iaddress (username.body))     else begin6       user_directory := substr (device_with_prefix, 2,>                                 ord (device_with_prefix[1])) +9                         substr (directory_with_prefix, 2,C@                                 ord (directory_with_prefix[1]));:       if DEBUG_OUT then writeln ('  Default directory: "',7                                  user_directory, '".');dE       if DEBUG_OUT then writeln ('  Account: "', user_account, '".');rG       if DEBUG_OUT then writeln ('  UIC: ', hex (user_uic, 8, 8), '.');8*       if length (user_directory) <= 0 then-         LIB$SIGNAL (DELIVER__NODEFAULTDIR, 2,i>                     username.length, iaddress (username.body))'       else find_user_directory := true;o1       (* Disable and reestablish former privs. *)l1       priv[0] := uand (priv[0], unot (ppriv[0])); 1       priv[1] := uand (priv[1], unot (ppriv[1]));i9       $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);      end;   end; end; (* find_user_directory *)  nH (* copy_descr_to_string copies a MAIL string (passed by descriptor) into    a Pascal VARYING string. *)  c  procedure copy_descr_to_string (&   var mail_string : string_descriptor;/   var out_string : string; DEBUG_ON : boolean);E  y vari   index : integer;  r  begin (* copy_descr_to_string *)<   if DEBUG_ON then writeln ('copy_descr_to_string called.');   out_string := '';u/   if mail_string.length > 256 then index := 256s#   else index := mail_string.length;g)   for index := 1 to mail_string.length doi;     out_string := out_string + mail_string.address^[index]; D   if DEBUG_ON then writeln ('  String copied: "', out_string, '".'); end; (* copy_descr_to_string *)n  eI (* copy_string_to_descr copies a Pascal VARYING string into a MAIL stringe    (passed by descriptor). *)t  a  procedure copy_string_to_descr (   var in_string : string;A;   var mail_string : string_descriptor; DEBUG_ON : boolean);   Y4   [asynchronous, unbound, external (LIB$SCOPY_DXDX)]9   function copy_string (var src : varying [max1] of char; 3     var dst : string_descriptor) : integer; extern;u  t  begin (* copy_string_to_descr *)<   if DEBUG_ON then writeln ('copy_string_to_descr called.');'   copy_string (in_string, mail_string);oC   if DEBUG_ON then writeln ('  String copied: "', in_string, '".');  end; (* copy_string_to_descr *)i  rF (* charupper is a simple function to convert characters to upper case.>    The full DEC Multinational Character Set is accomodated. *)  u& function charupper (ch : char) : char;  e begin (* charupper *)n%   if (ch >= 'a') and (ch <= 'z') theno9     charupper := chr (ord (ch) + (ord ('A') - ord ('a')))(6   else if (ord (ch) >= 224) and (ord (ch) <= 253) then-     charupper := chr (ord (ch) + (192 - 224))M   else charupper := ch;) end; (* charupper *)  $> (* dispose_rules_list disposes of heap storage associated with!    a list of parameter blocks. *)t  dD procedure dispose_rules_list (var rules_list : parameter_block_ptr);  l varf"   temp_list : parameter_block_ptr;  a begin (* dispose_rules_list *);   if DEBUG_OUT then writeln ('dispose_rules_list called.');I"   while rules_list <> nil do begin<     temp_list := rules_list; rules_list := rules_list^.next;     dispose (temp_list);$   end; (* while rules_list <> nil *) end; (* dispose_rules_list *)   .= (* dispose_user_list disposes of heap storage associated withu!    a list of user name blocks. *)c  r= procedure dispose_user_list (var user_list : user_block_ptr);   d varb   temp_list : user_block_ptr;   A begin (* dispose_user_list *)d:   if DEBUG_OUT then writeln ('dispose_user_list called.');!   while user_list <> nil do begine9     temp_list := user_list; user_list := user_list^.next;MD     dispose_rules_list (temp_list^.rules_list); dispose (temp_list);#   end; (* while user_list <> nil *)A end; (* dispose_user_list *)  =D (* read_maildelivery_file reads the contents of a MAIL.DELIVERY file?    and creates a rules_list structure. Any errors are signalled     by returning FALSE. *)   *2 function read_maildelivery_file (var dfile : text;2   var rules_list : parameter_block_ptr) : boolean;  _ labelC   99;7    var 8   current, last : parameter_block_ptr; quoted : boolean;:   pindex, lindex, rindex, lcount : integer; line : string;  =   procedure addch (ch : char);      labelO     88;1      var_     cindex : integer;N  _   begin (* addch *)_)     if pindex > max_parameters then begin H       if FROM_OWNER then LIB$SIGNAL (DELIVER__TOOMANYPARAMS, 1, lcount);       goto 99;     end;@     if current = nil then if (ch = '!') or (ch = ';') then begin=       if DEBUG_OUT then writeln ('  Skipping comment line.');r'       lindex := length (line); goto 88;      end else begin       new (current);       with current^ do beginF         for cindex := 1 to max_parameters do parameters[cindex] := '';         next := nil;       end; (* with current^ *)       rindex := rindex + 1;r;       if DEBUG_OUT then writeln (' Rule #', rindex:0, '.');n       if last = nil then begin/         last := current; rules_list := current;r       end else begin/         last^.next := current; last := current;m
       end;     end;D     current^.parameters[pindex] := current^.parameters[pindex] + ch;   88:t   end; (* addch *)  a" begin (* read_maildelivery_file *)?   if DEBUG_OUT then writeln ('read_maildelivery_file called.');r<   read_maildelivery_file := false; last := nil; lcount := 0;   rindex := 0;    while not eof (dfile) do begin/     readln (dfile, line); lcount := lcount + 1;;K     if DEBUG_OUT then writeln ('  Line from MAIL.DELIVERY: "', line, '".');;>     pindex := 1; current := nil; lindex := 1; quoted := false;*     while lindex <= length (line) do beginE       if (not quoted) and (line[lindex] in [' ', chr (9)]) then begini?         if current <> nil then if pindex <= max_parameters thene@           if length (current^.parameters[pindex]) > 0 then beginK             if DEBUG_OUT then writeln ('  Parameter #', pindex:0, ' is: "', J                                        current^.parameters[pindex], '".');!             pindex := pindex + 1;f           end;/       end else if line[lindex] = '"' then beginr&         if length (line) > lindex then,           if line[lindex+1] = '"' then begin1             addch ('"'); lindex := succ (lindex);f'           end else quoted := not quoted "         else quoted := not quoted;C       end else if quoted and (pindex > 5) then addch (line[lindex]) ,       else addch (charupper (line[lindex]));       lindex := lindex + 1;      end; (* while not eoln *)r1     if current <> nil then with current^ do begin &       if pindex <= max_parameters then5         if length (parameters[pindex]) > 0 then begin I           if DEBUG_OUT then writeln ('  Parameter #', pindex:0, ' is: "',e?                                      parameters[pindex], '".');            pindex := pindex + 1;          end;       pindex := pindex - 1; +       if pindex < min_parameters then begin I         if FROM_OWNER then LIB$SIGNAL (DELIVER__TOOFEWPARAMS, 1, lcount);.         goto 99;
       end;=       any_from      := parameters[from_parameter]      = '*'; =       any_to        := parameters[to_parameter]        = '*';i=       any_subject   := parameters[subject_parameter]   = '*';o1       if parameters[subject_parameter] = '"' thenE,         parameters[subject_parameter] := '';     end;   end; (* while not eof *)+   if FROM_OWNER and (rules_list = nil) then !     LIB$SIGNAL (DELIVER__NORULES)u&   else read_maildelivery_file := true;   99:u   close (dfile);! end; (* read_maildelivery_file *):  yJ (* MAIL_OUT_CONNECT is called by VMS MAIL to initiate a send operation. *)   ; [global] function MAIL_OUT_CONNECT (var context : unsigned;t   var link_flag : integer;)   var protocol, node : string_descriptor;    var log_link_error : integer;9#   var file_RAT, file_RFM : integer;e   var MAIL$GL_FLAGS : integer;3   var attached_file : string_descriptor) : integer;   t vart   stat : integer;_   begin (* MAIL_OUT_CONNECT *)9   if DEBUG_OUT then writeln ('MAIL_OUT_CONNECT called.');e3   fromstring := ''; tostring := ''; ccstring := '';_-   subjectstring := ''; user_list_last := nil;n)   stat := $TRNLOG (lognam := 'PMDF_ROOT',a4                    rslbuf := folder_invocation.body,7                    rsllen := folder_invocation.length); 1   if (not odd (stat)) or (stat = SS$_NOTRAN) then #     folder_invocation := '$ FOLDER' ,   else folder_invocation := '$ PMDF FOLDER';!   MAIL_OUT_CONNECT := SS$_NORMAL;  end; (* MAIL_OUT_CONNECT *)   dF (* MAIL_OUT_LINE is called by VMS MAIL whenever a single line of stuff2    must be delivered to the DELIVER mail relay. *)  ]8 [global] function MAIL_OUT_LINE (var context : unsigned;   var link_flag : integer;0   var node, line : string_descriptor) : integer;  o begin (* MAIL_OUT_LINE *)r6   if DEBUG_OUT then writeln ('MAIL_OUT_LINE called.');   case iaddress (link_flag) of*     (* MAIL is delivering a To: address *)     LNK_C_OUT_TO     : beginM                          if DEBUG_OUT then writeln ('  OUT_TO option used.');uJ                          copy_descr_to_string (line, tostring, DEBUG_OUT);.                        end; (* LNK_C_OUT_TO *),     (* MAIL is delivering a From: address *)     LNK_C_OUT_SENDER : begin*                          if DEBUG_OUT thenA                            writeln ('  OUT_SENDER option used.');wL                          copy_descr_to_string (line, fromstring, DEBUG_OUT);2                        end; (* LNK_C_OUT_SENDER *),     (* MAIL is delivering a Subject: line *)     LNK_C_OUT_SUBJ   : beginO                          if DEBUG_OUT then writeln ('  OUT_SUBJ option used.');_C                          copy_descr_to_string (line, subjectstring,U:                                                DEBUG_OUT);0                        end; (* LNK_C_OUT_SUBJ *)       otherwise beginI[                          if DEBUG_OUT then writeln ('  Otherwise option used.', link_flag);  	      end;r   end; (* case *)O   MAIL_OUT_LINE := SS$_NORMAL; end; (* MAIL_OUT_LINE *)  [D (* MAIL_OUT_CHECK is called once with each addressee for the currentB    message and once again after the message body has been sent. *)  v" [global] function MAIL_OUT_CHECK (   var context : unsigned;n   var link_flag : integer;.   var protocol, addressee : string_descriptor;,   procedure MAIL$READ_ERROR_TEXT) : integer;  % var D   usernamebuffer, userdirectory : string; userpriority : priorities;F   maildelivery : text; useruic : unsigned; useraccount : account_name;   currenttime : [quad] record +                          l0, l1 : unsigned;)                        end;(  e begin (* MAIL_OUT_CHECK *)7   if DEBUG_OUT then writeln ('MAIL_OUT_CHECK called.');    case iaddress (link_flag) of      (* Check out an addressee *)4     LNK_C_OUT_CKUSER : if (addressee.length = 1) andF                           (addressee.address^[1] = chr (0)) then beginK                          (* The null byte indicates that all the addresseese5                             have been accomodated. *)cN                          if DEBUG_OUT then writeln ('  Terminate user list.');6                          MAIL_OUT_CHECK := SS$_NORMAL;%                        end else beginNM                          if DEBUG_OUT then writeln ('  CKUSER option used.');iI                          copy_descr_to_string (addressee, usernamebuffer,b:                                                DEBUG_OUT);E                          STR$UPCASE (usernamebuffer, usernamebuffer);r*                          if DEBUG_OUT then<                            writeln ('  Checking out user "',:                                     usernamebuffer, '".');D                          if not find_user_directory (usernamebuffer,C                                                      userdirectory,TJ                                                      useruic, useraccount, 						     userpriority) then_A                            MAIL_OUT_CHECK := DELIVER__USERNOEXISTB#                          else begin K                            if DEBUG_OUT then writeln ('  Trying to open "',OD                              userdirectory + 'MAIL.DELIVERY', '".');?                            open (file_variable := maildelivery,=N                                  file_name := userdirectory + 'MAIL.DELIVERY',<                                  organization := SEQUENTIAL,5                                  sharing := READONLY,_A                                  user_action := open_with_SYSPRV, I                                  error := CONTINUE, history := READONLY);)=                            if status (maildelivery) <= 0 then E                              reset (maildelivery, error := CONTINUE); B                            if status (maildelivery) > 0 then begin>                              LIB$SIGNAL (DELIVER__NOMDFILE, 2,5                                usernamebuffer.length,i?                                iaddress (usernamebuffer.body)); A                              MAIL_OUT_CHECK := DELIVER__NOMDFILE; )                            end else begin .                              if DEBUG_OUT thenN                                writeln ('  Adding this user to active list.');:                              user_count := user_count + 1;?                              if user_list_last = nil then begint4                                new (user_list_last);;                                user_list := user_list_last;_+                              end else begin :                                new (user_list_last^.next);F                                user_list_last := user_list_last^.next;!                              end;L:                              with user_list_last^ do beginI                                FROM_OWNER := fromstring = usernamebuffer;aK                                if not read_maildelivery_file (maildelivery,i8                                   rules_list) then begin@                                  if FROM_OWNER then LIB$SIGNAL (7                                    DELIVER__MDIGNORED);eA                                  dispose_rules_list (rules_list);(#                                end;a0                                next      := nil;J                                username  := pad (usernamebuffer, ' ', 12);:                                directory := userdirectory;4                                uic       := useruic;8                                account   := useraccount;;                                priority    := userpriority;rD                                user_length := usernamebuffer.length;5                                $GETTIM (currenttime); 4                                copyname := 'MAIL_' +G                                            hex (currenttime.l0, 8, 8) +rG                                            hex (currenttime.l1, 8, 8) +oB                                            hex (user_count, 8, 8);0                                if DEBUG_OUT thenE                                  writeln ('  Added user "', username,:>                                           '"; file code is "',:                                           copyname, '".');<                              end; (* with user_list_last^ *):                              MAIL_OUT_CHECK := SS$_NORMAL;                            end;n                          end;d2                        end; (* LNK_C_OUT_CKUSER *).     (* Check out the message send operation *)     LNK_C_OUT_CKSEND : beginM                          if DEBUG_OUT then writeln ('  CKSEND option used.');i6                          MAIL_OUT_CHECK := SS$_NORMAL;2                        end; (* LNK_C_OUT_CKSEND *)     otherwise begin [                          if DEBUG_OUT then writeln ('  Otherwise option used.', link_flag);V 	      end;i   end; (* case *)T end; (* MAIL_OUT_CHECK *)   vF (* MAIL_OUT_FILE is called when the body of the message is ready to beF    sent. The message is available as a file and must be read from thisF    temporary file using RMS. MAIL_OUT_FILE is where most of the actual@    work DELIVER does takes place. The following steps are taken:  (H    (1) The mode of the message file is set to record I/O (MAIL sometimes&        leaves the file in block mode).  rD    (2) The list of users to whom messages are being sent is scanned.!        For each user on the list:x  ,@        (a) A copy of the message is placed in the user's defaultA            directory. The file is created with SYSPRV, so it will !            be owned by that user.o  w@        (b) The user's rules are scanned and checked for matches.  rD        (c) If any of the rules are satisfied, a command file is alsoG            created. This files contains some initial symbol definitions G            and then commands to implement each of the user's rules that G            matched. The command file ends with commands that delete theUC            copy of the message as well as the commmand file itself.o  )I        (d) A batch job is created to run the command file. Note that thish>            means MAIL must be installed with CMKRNL privilege. *)   8 [global] function MAIL_OUT_FILE (var context : unsigned;   var link_flag : integer;#   var protocol : string_descriptor;    var message_RAB : RAB$TYPE;rA   [asynchronous, unbound] procedure UTIL$REPORT_ERROR) : integer;e  i labeln	   44, 99;s   varY"   user_list_scan : user_block_ptr;2   onehasmatched, somehavematched, match : boolean;=   rules_list_scan : parameter_block_ptr; message_file : text;iC   fromupstring, toupstring, subjectupstring, line, try_batch_queue,G#     specified_batch_queue : string;n5   index, lleft, stat, queue_try, last_item : integer;n0   ppriv, priv : [quad] array [0..1] of unsigned;(   iosb : [quad] array [0..1] of integer;    items : array [1..17] of item;,   submit_parameters : array [1..8] of record<                                         specified : boolean;;                                         contents  : string;g*                                       end;   previous_bio : boolean;d(   previous_rbf, previous_ubf : unsigned;&   previous_rsz, previous_usz : $uword;   previous_rac : $ubyte;   big_line : big_string;   <   function STR$MATCH_WILD (candidate : varying [l1] of char;6     pattern : varying [l2] of char) : integer; extern;   9   function STR$UPCASE (var dststr : varying [l1] of char;u9     var srcstr : varying [l2] of char) : integer; extern;w  e   procedure check_status;a     begin (* check_status *)+     if status (message_file) > 0 then begine@       LIB$SIGNAL (DELIVER__MESWRTERR, 1, status (message_file));*       MAIL_OUT_FILE := DELIVER__MESWRTERR;       goto 99;     end; (* if *)p   end; (* check_status *)u  5   (* function to read a line from the message file *)n  a2   function get_line (var line : string) : boolean;      varh     stat : integer;z  t   begin (* get_line *)A     if DEBUG_OUT then writeln ('MAIL_OUT_FILE\get_line called.');4     get_line := false;6     message_RAB.RAB$L_UBF := iaddress (big_line.body);&     message_RAB.RAB$W_USZ := big_size;&     stat := $GET (RAB := message_RAB);     if odd (stat) then begin       line.length := 0;r0       for index := 1 to message_RAB.RAB$W_RSZ do% 	line := line + big_line.body[index];l       get_line := true;a%     end else if stat <> RMS$_EOF thenr/       LIB$SIGNAL (DELIVER__MESREAERR, 1, stat);s   end; (* get_line *)I   '   procedure put_string (line : string);p     begin (* put_string *)&     if lleft >= line.length then begin!       write (message_file, line);i#       lleft := lleft - line.length;i     end; (* if *)o   end; (* put_string *)h  !   procedure put_char (ch : char);s     begin (* put_char *)     if lleft >= 1 then begin       write (message_file, ch);t       lleft := pred (lleft);     end; (* if *)A   end; (* put_char *)_  1   procedure put_symbol (symbol, svalue : string);l     vard     index : integer;     squote_previous : boolean;     begin (* put_symbol *)0     write (message_file, '$ ', symbol, ' == "');/     lleft := DCL_line_size - 8 - symbol.length;      squote_previous := false;;,     for index := 1 to svalue.length do begin3       if svalue[index] = '"' then put_string ('""')        else beginN         if (svalue[index] = '''') and squote_previous then put_string ('"+"');!         put_char (svalue[index]);r       end; (* if *) .       squote_previous := svalue[index] = '''';     end; (* for *)3     writeln (message_file, '"', error := CONTINUE);      check_status;x1     write (message_file, '$ Q', symbol, ' == "'); /     lleft := DCL_line_size - 9 - symbol.length;      squote_previous := false;x.     for index := 1 to length (svalue) do begin5       if svalue[index] = '"' then put_string ('""""') C       else if (not squote_previous) or (svalue[index] <> '''') then !         put_char (svalue[index]); .       squote_previous := svalue[index] = '''';     end; (* for *)3     writeln (message_file, '"', error := CONTINUE);e     check_status;82     write (message_file, '$ QQ', symbol, ' == "');0     lleft := DCL_line_size - 10 - symbol.length;     squote_previous := false;i,     for index := 1 to svalue.length do begin9       if svalue[index] = '"' then put_string ('""""""""')fC       else if (not squote_previous) or (svalue[index] <> '''') then !         put_char (svalue[index]);r.       squote_previous := svalue[index] = '''';     end; (* for *)3     writeln (message_file, '"', error := CONTINUE);;     check_status;m   end; (* put_symbol *).   begin (* MAIL_OUT_FILE *)86   if DEBUG_OUT then writeln ('MAIL_OUT_FILE called.');   D   (* Do some fancy footwork with RMS to insure that the file is openC      for sequential access and not block access. MAIL sometimes hasxB      this file open in block mode. The only way to change modes isI      to disconnect the RAB, diddle the mode bit and then reconnect it. *)L#   $DISCONNECT (RAB := message_RAB);:(   previous_bio := message_RAB.RAB$V_BIO;(   previous_rbf := message_RAB.RAB$L_RBF;(   previous_rsz := message_RAB.RAB$W_RSZ;(   previous_ubf := message_RAB.RAB$L_UBF;(   previous_usz := message_RAB.RAB$W_USZ;(   previous_rac := message_RAB.RAB$B_RAC;B   if DEBUG_OUT then writeln ('  The BIO field of the RAB is set ',2     uand (message_RAB.RAB$L_ROP, RAB$M_BIO) <> 0);J   message_RAB.RAB$L_ROP := uand (message_RAB.RAB$L_ROP, unot (RAB$M_BIO));    $CONNECT (RAB := message_RAB);  1O   if DEBUG_OUT then writeln (' Creating upper case copies of header strings.');l+   STR$UPCASE (fromupstring,    fromstring);[)   STR$UPCASE (toupstring,      tostring);c.   STR$UPCASE (subjectupstring, subjectstring);O   if DEBUG_OUT then writeln ('  From: "', fromupstring, '", To: "', toupstring,iE                              '", Subject: "', subjectupstring, '".');(  r9   if DEBUG_OUT then writeln (' Pruning the rules list.');n   user_list_scan := user_list;&   while user_list_scan <> nil do begin+     if DEBUG_OUT then writeln ('  User: "', O       substr (user_list_scan^.username, 1, user_list_scan^.user_length), '".');eL     if DEBUG_OUT then writeln ('  Create copy of message headers in file "',9                                user_list_scan^.directory,iF                                user_list_scan^.copyname, '.HEADER".');8     open (file_variable := message_file, history := NEW,=           record_length := big_size, record_type := VARIABLE,;2           file_name := user_list_scan^.directory +<                        user_list_scan^.copyname + '.HEADER',?           user_action := create_with_SYSPRV, error := CONTINUE,j&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);     check_status; E     writeln (message_file, 'From:   ',fromstring, error := CONTINUE);      check_status;$D     writeln (message_file, 'To:     ', tostring, error := CONTINUE);     check_status;eD     writeln (message_file, 'Cc:     ', ccstring, error := CONTINUE);     check_status;iI     writeln (message_file, 'Subj:   ', subjectstring, error := CONTINUE);o     check_status; ,     close (message_file, error := CONTINUE);     check_status;tD     if DEBUG_OUT then writeln ('  Create copy of message in file "',9                                user_list_scan^.directory, D                                user_list_scan^.copyname, '.TEXT".');8     open (file_variable := message_file, history := NEW,C           record_length := parameter_size, record_type := VARIABLE,i2           file_name := user_list_scan^.directory +:                        user_list_scan^.copyname + '.TEXT',?           user_action := create_with_SYSPRV, error := CONTINUE,r&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);     check_status;R!     $REWIND (RAB := message_RAB);P"     while get_line (line) do begin&       if DEBUG_OUT then writeln(line);6       writeln (message_file, line, error := CONTINUE);       check_status;f     end; (* while get_line *)E,     close (message_file, error := CONTINUE);     check_status;n  tA     if DEBUG_OUT then writeln ('  Creating command file named "',_9                                user_list_scan^.directory,fC                                user_list_scan^.copyname, '.COM".');l8     open (file_variable := message_file, history := NEW,C           record_length := parameter_size, record_type := VARIABLE,h2           file_name := user_list_scan^.directory +9                        user_list_scan^.copyname + '.COM',T?           user_action := create_with_SYSPRV, error := CONTINUE,s&           organization := SEQUENTIAL);>     if status (message_file) <= 0 then rewrite (message_file);     check_status;   <     writeln (message_file, '$ SET NOON', error := CONTINUE);     check_status;cE     writeln (message_file, '$ DELETE = "DELETE"', error := CONTINUE);      check_status; K     writeln (message_file, '$ MESSAGE_DELETE == "YES"', error := CONTINUE);n     check_status; $     put_symbol ('FROM', fromstring);      put_symbol ('TO', tostring);*     put_symbol ('SUBJECT', subjectstring);      put_symbol ('CC', ccstring);  1     writeln (message_file, '$ MESSAGE_FILE == "', '              user_list_scan^.directory, D              user_list_scan^.copyname, '.TEXT"', error := CONTINUE);     check_status;t3     writeln (message_file, '$ MESSAGE_HEADER == "',e'              user_list_scan^.directory,;F              user_list_scan^.copyname, '.HEADER"', error := CONTINUE);     check_status;e1     writeln (message_file, '$ COMMAND_FILE == "',y'              user_list_scan^.directory, C              user_list_scan^.copyname, '.COM"', error := CONTINUE);e     check_status;   rF     if DEBUG_OUT then writeln ('  Check this user''s delivery list.');J     onehasmatched := false; rules_list_scan := user_list_scan^.rules_list;     somehavematched := false;e     batch_log := '_NLA0:';     batch_keep := false;      specified_batch_queue := '';G     for index := 1 to 8 do submit_parameters[index].specified := false;i2     rules_list_scan := user_list_scan^.rules_list;B     while rules_list_scan <> nil do with rules_list_scan^ do begin;       match := (any_to      or (STR$MATCH_WILD (toupstring,sL                                 parameters[to_parameter]) = STR$_MATCH)) and=                (any_from    or (STR$MATCH_WILD (fromupstring,eN                                 parameters[from_parameter]) = STR$_MATCH)) and@                (any_subject or (STR$MATCH_WILD (subjectupstring,N                                 parameters[subject_parameter]) = STR$_MATCH));/       case parameters[decision_parameter][1] of ,         'A'      : match := true;           "         'X'      : match := false;"         'T', 'Y' : match := match;&         'F', 'N' : match := not match;:         '?', 'O' : match := match and (not onehasmatched);@         'B', 'Q' : match := (not match) and (not onehasmatched);9         'E'      : match := match or (not onehasmatched);w!         otherwise match := false;        end; (* decision case *)       if match then begin E         if DEBUG_OUT then writeln (' Rule matched. From: pattern: "', :           parameters[from_parameter], '", To: pattern: "',=           parameters[to_parameter], '", Subject: pattern: "',uC           parameters[subject_parameter], '", Decision character: ', 2           parameters[decision_parameter][1], '.');          somehavematched := true;O         if parameters[decision_parameter][1] <> 'A' then onehasmatched := true; /         case parameters[action_parameter][1] ofL           (* append *)           'A'  : begin)                    writeln (message_file, E                             '$ APPEND/NEW_VERSION ''MESSAGE_FILE'' ', <                             parameters[argument1_parameter],/                             error := CONTINUE);Y                     check_status;"                  end; (* append *)=           (* deliver *)                                      =           'B', 'D',            'O'  : begin0                    if MAIL$C_PROT_MAJOR > 1 then>                      writeln (message_file, folder_invocation,C                               '/FROM="''''QFROM''"/TO="''''QTO''"', I                               '/CC="''''QCC''"/SUBJECT="''''QSUBJECT''"', 3                               ' ''MESSAGE_FILE'' ', C                               parameters[argument1_parameter], ' ', >                               parameters[argument2_parameter],0                               error := CONTINUE)                    else begin )                      write (message_file,u>                             '$ MAIL/NOSELF/SUBJECT="(From: ');J                      write (message_file, '''''QFROM'') ''''QSUBJECT''"');A                      write (message_file, ' ''MESSAGE_FILE'' "_', @                             substr (user_list_scan^.username, 1,B                                     user_list_scan^.user_length));D                      writeln (message_file, '"', error := CONTINUE);                     end; (* if *)                     check_status;#                  end; (* deliver *)r           (* create, copy *)           'C'  : beginE                    writeln (message_file, '$ COPY ''MESSAGE_FILE'' ', <                             parameters[argument1_parameter],/                             error := CONTINUE);                      check_status;(                  end; (* create, copy *)           (* execute *)V           'E'  : beginD                    if parameters[argument1_parameter][1] <> '$' then.                    write (message_file, '$ ');J                    writeln (message_file, parameters[argument1_parameter],/                             error := CONTINUE);                      check_status;#                  end; (* execute *)            (* forward *)            'F'  : begin0                    if MAIL$C_PROT_MAJOR > 1 then)                      write (message_file, D                             '$ MAIL/NOTRAN/NOSELF/SUBJECT="(From: '),                    else write (message_file,A                                '$ MAIL/NOSELF/SUBJECT="(From: '); H                    write (message_file, '''''QFROM'') ''''QSUBJECT''"');?                    writeln (message_file, ' ''MESSAGE_FILE'' ', P                             parameters[argument1_parameter], error := CONTINUE);                     check_status;#                  end; (* forward *) (           (* append with mail headers *)           'H'  : beginB                    writeln (message_file, '$ APPEND/NEW_VERSION ',N                             '''MESSAGE_HEADER''+SYS$INPUT:+''MESSAGE_FILE'' ',<                             parameters[argument1_parameter],/                             error := CONTINUE);                      check_status;=                    writeln (message_file, error := CONTINUE);e                     check_status;4                  end; (* append with mail headers *)           (* keep-command *)$           'K'  : batch_keep := true;           (* log-keep *)           'L'  : begin?                    if parameters[argument1_parameter] = '' then K                      batch_log := user_list_scan^.directory + 'DELIVER.LOG'i@                    else batch_log := user_list_scan^.directory +E                                      parameters[argument1_parameter];r$                  end; (* log-keep *)           (* message-keep *)           'M'  : beginE                    writeln (message_file, '$ MESSAGE_DELETE == "NO"', /                             error := CONTINUE);                      check_status;(                  end; (* message-keep *)           (* quit *)(           'Q'  : rules_list_scan := nil;"           (* privileged-deliver *)           'V'  : begin0                    if MAIL$C_PROT_MAJOR > 1 then>                      writeln (message_file, folder_invocation,C                               '/FROM="''''QFROM''"/TO="''''QTO''"', I                               '/CC="''''QCC''"/SUBJECT="''''QSUBJECT''"',h3                               ' ''MESSAGE_FILE'' ',sC                               parameters[argument1_parameter], ' ',s>                               parameters[argument2_parameter],0                               error := CONTINUE)                    else beginmD                      writeln (message_file, '$ DELIVER_FROM = FROM',1                               error := CONTINUE); "                      check_status;@                      writeln (message_file, '$ DELIVER_TO = TO',1                               error := CONTINUE);]"                      check_status;@                      writeln (message_file, '$ DELIVER_CC = CC',1                               error := CONTINUE);y"                      check_status;+                      writeln (message_file,9J                               '$ PRIV = F$SETPRV("DETACH,SYSPRV,BYPASS")',1                               error := CONTINUE);e"                      check_status;;                      write (message_file, '$ MAIL/NOSELF');q)                      write (message_file,nM                        '/PROTOCOL=DELIVER_MAILSHR/SUBJECT="''''QSUBJECT''"');]A                      write (message_file, ' ''MESSAGE_FILE'' "_',;@                             substr (user_list_scan^.username, 1,B                                     user_list_scan^.user_length));D                      writeln (message_file, '"', error := CONTINUE);"                      check_status;F                      writeln (message_file, '$ PRIV = F$SETPRV(PRIV)',1                               error := CONTINUE);r"                      check_status;+                      writeln (message_file,nC                               '$ DELETE/SYMBOL/LOCAL DELIVER_FROM', 1                               error := CONTINUE);t"                      check_status;O                      writeln (message_file, '$ DELETE/SYMBOL/LOCAL DELIVER_TO',s1                               error := CONTINUE);s"                      check_status;O                      writeln (message_file, '$ DELETE/SYMBOL/LOCAL DELIVER_CC',D1                               error := CONTINUE);*                     end; (* if *)                     check_status;.                  end; (* privileged-deliver *)"           (* privileged-forward *)           'W'  : beginB                    writeln (message_file, '$ DELIVER_FROM = FROM',/                             error := CONTINUE);a                     check_status;>                    writeln (message_file, '$ DELIVER_TO = TO',/                             error := CONTINUE);f                     check_status;>                    writeln (message_file, '$ DELIVER_CC = CC',/                             error := CONTINUE);e                     check_status;)                    writeln (message_file,EH                             '$ PRIV = F$SETPRV("DETACH,SYSPRV,BYPASS")',/                             error := CONTINUE);                      check_status;0                    if MAIL$C_PROT_MAJOR > 1 thenA                      write (message_file, '$ MAIL/NOTRAN/NOSELF')_>                    else write (message_file, '$ MAIL/NOSELF');'                    write (message_file, P                           '/PROTOCOL=DELIVER_MAILSHR/SUBJECT="''''QSUBJECT''"');?                    writeln (message_file, ' ''MESSAGE_FILE'' ',eP                             parameters[argument1_parameter], error := CONTINUE);                     check_status;C                    writeln (message_file,'$ PRIV = F$SETPRV(PRIV)',8/                             error := CONTINUE);;                     check_status;O                    writeln (message_file, '$ DELETE/SYMBOL/LOCAL DELIVER_FROM',g/                             error := CONTINUE);p                     check_status;M                    writeln (message_file, '$ DELETE/SYMBOL/LOCAL DELIVER_TO', /                             error := CONTINUE);                      check_status;M                    writeln (message_file, '$ DELETE/SYMBOL/LOCAL DELIVER_CC',=/                             error := CONTINUE);e                     check_status;.                  end; (* privileged-forward *)*           (* job-queue or job parameter *)=           'J'  : if parameters[argument2_parameter] = '' theneK                    specified_batch_queue := parameters[argument1_parameter]i                  else begin ?                    STR$UPCASE (parameters[argument1_parameter],I@                                parameters[argument1_parameter]);D                    if parameters[argument1_parameter] = 'QUEUE' thenM                      specified_batch_queue := parameters[argument2_parameter]fL                    else if parameters[argument1_parameter] = 'P1' then begin<                      submit_parameters[1].specified := true;5                      submit_parameters[1].contents :=]7                        parameters[argument2_parameter];'P                    end else if parameters[argument1_parameter] = 'P2' then begin<                      submit_parameters[2].specified := true;5                      submit_parameters[2].contents :=t7                        parameters[argument2_parameter];sP                    end else if parameters[argument1_parameter] = 'P3' then begin<                      submit_parameters[3].specified := true;5                      submit_parameters[3].contents :=C7                        parameters[argument2_parameter];AP                    end else if parameters[argument1_parameter] = 'P4' then begin<                      submit_parameters[4].specified := true;5                      submit_parameters[4].contents :=s7                        parameters[argument2_parameter];IP                    end else if parameters[argument1_parameter] = 'P5' then begin<                      submit_parameters[5].specified := true;5                      submit_parameters[5].contents :=f7                        parameters[argument2_parameter];hP                    end else if parameters[argument1_parameter] = 'P6' then begin<                      submit_parameters[6].specified := true;5                      submit_parameters[6].contents := 7                        parameters[argument2_parameter]; P                    end else if parameters[argument1_parameter] = 'P7' then begin<                      submit_parameters[7].specified := true;5                      submit_parameters[7].contents :=B7                        parameters[argument2_parameter];sP                    end else if parameters[argument1_parameter] = 'P8' then begin<                      submit_parameters[8].specified := true;5                      submit_parameters[8].contents := 7                        parameters[argument2_parameter];H                    end;e                  end; (* if *)           otherwise begin end;         end; (* case *)y=       end; (* add commands to implement this matching rule *)oN       if rules_list_scan <> nil then rules_list_scan := rules_list_scan^.next;     end; (* while *)  S%     if not somehavematched then beginrI       if DEBUG_OUT then writeln ('  No rules matched, just deliver it.');(#       if MAIL$C_PROT_MAJOR > 1 then 1         writeln (message_file, folder_invocation,o6                  '/FROM="''''QFROM''"/TO="''''QTO''"',<                  '/CC="''''QCC''"/SUBJECT="''''QSUBJECT''"',9                  ' ''MESSAGE_FILE'' ', error := CONTINUE)eC       else writeln (message_file, '$ MAIL/NOSELF/SUBJECT="(From: ',uF                     '''''QFROM'') ''''QSUBJECT''" ''MESSAGE_FILE'' _',8                     substr (user_list_scan^.username, 1,M                             user_list_scan^.user_length), error := CONTINUE);        check_status;      end; (* if *)r  H     if DEBUG_OUT then writeln ('  Finishing up delivery command file.');B     writeln (message_file, '$ IF MESSAGE_DELETE .nes. "NO" then ',<              'DELETE ''MESSAGE_FILE'';', error := CONTINUE);     check_status;mB     writeln (message_file, '$ IF MESSAGE_DELETE .nes. "NO" then ',>              'DELETE ''MESSAGE_HEADER'';', error := CONTINUE);     check_status;T8     writeln (message_file, '$ DELETE ''COMMAND_FILE'';',               error := CONTINUE);     check_status; ,     close (message_file, error := CONTINUE);     check_status;   _:     if DEBUG_OUT then writeln ('  Submitting batch job.');d     priv[0] := PRV$M_CMKRNL + PRV$M_SYSPRV + PRV$M_BYPASS + PRV$M_OPER + PRV$M_TMPMBX; priv[1] := 0;P     stat := $SETPRV (ENBFLG := 1, PRVADR := priv, PRMFLG := 0, PRVPRV := ppriv);*     if (not odd (stat)) and DEBUG_OUT then:         writeln ('    Unable to get privs to submit job');1     if (stat = SS$_NOTALLPRIV) and DEBUG_OUT then ) 	writeln ('    Unable to get all privs'); ;     if specified_batch_queue.length > 0 then queue_try := 1      else queue_try := 2;   44:,     case queue_try ofE3       1 : try_batch_queue := specified_batch_queue;+1       2 : try_batch_queue := default_batch_queue; 0       3 : try_batch_queue := system_batch_queue;     end; (* case *)EE     if DEBUG_OUT then writeln ('  Checking validity of batch queue ',)0                                try_batch_queue);     with items[1] do begin:       len := size (arm_write_access); code := CHP$_ACCESS;5       addr := iaddress (arm_write_access); rlen := 0;o     end; (* with items[1] *)     with items[2] do begin0       len := 0; code := 0; addr := 0; rlen := 0;     end; (* with items[2] *)8     stat := $CHECK_ACCESS (objtyp := ACL$C_JOBCTL_QUEUE,5                            objnam := try_batch_queue, I                            usrnam := substr (user_list_scan^.username, 1,IJ                                              user_list_scan^.user_length),,                            itmlst := items);     if odd (stat) then beginL       line := user_list_scan^.directory + user_list_scan^.copyname + '.COM';       if DEBUG_OUT then begint/         writeln ('    Queue ', try_batch_queue, :                                  ' is writable by user.');,         writeln ('  Submitting batch job.'); 	writeln ('       ', line);t+ 	writeln ('       logfile  = ', batch_log);e       end; (* if *)   8       for index := 1 to 17 DO WITH items[index] do BEGIN+ 	len := 0; code := 0; addr := 0; rlen := 0;u 	END;t       with items[2] do begin:         len := try_batch_queue.length; code := SJC$_QUEUE;;         addr := iaddress (try_batch_queue.body); rlen := 0;=       end; (* with items[2] *)       with items[3] do begin<         len := line.length; code := SJC$_FILE_SPECIFICATION;0         addr := iaddress (line.body); rlen := 0;       end; (* with items[3] *)       with items[4] do begin@         len := batch_log.length; code := SJC$_LOG_SPECIFICATION;5         addr := iaddress (batch_log.body); rlen := 0;n       end; (* with items[4] *)       with items[5] do begin,         len := 0; code := SJC$_NO_LOG_SPOOL;         addr := 0; rlen := 0;        end; (* with items[5] *)       with items[6] do begin         len := 0; 6         if batch_keep then code := SJC$_NO_DELETE_FILE&         else code := SJC$_DELETE_FILE;         addr := 0; rlen := 0;        end; (* with items[6] *)/       if use_sjc_user_identification then begin          with items[1] do begin6           len := 25; code := SJC$_USER_IDENTIFICATION;<           addr := iaddress (user_list_scan^.uic); rlen := 0;: 	  if DEBUG_OUT then writeln(' user_identification used');          end; (* with items[1] *)         last_item := 6;        end else begin         with items[1] do beginD           len := user_list_scan^.user_length; code := SJC$_USERNAME;A           addr := iaddress (user_list_scan^.username); rlen := 0; y 	  if DEBUG_OUT then writeln('  using username of ', user_list_scan^.username, 'length = ', user_list_scan^.user_length);c          end; (* with items[1] *)         with items[7] do begin%           len := 4; code := SJC$_UIC;f<           addr := iaddress (user_list_scan^.uic); rlen := 0;          end; (* with items[7] *)         with items[8] do begin.           len := 8; code := SJC$_ACCOUNT_NAME;@           addr := iaddress (user_list_scan^.account); rlen := 0;          end; (* with items[8] *)         last_item := 8;        end; (* if *)sD       if DEBUG_OUT then writeln ('    building submit parameters.');M       for index := 1 to 8 do if submit_parameters[index].specified then begin &         last_item := succ (last_item);9 	IF DEBUG_OUT then writeln('    last_item =', last_item);g&         with items[last_item] do begin:           len := submit_parameters[index].contents.length;/           code := SJC$_PARAMETER_1 + index - 1;/O           addr := iaddress (submit_parameters[index].contents.body); rlen := 0;'(         end; (* with items[last_item] *)       end; (* if, for *)$       last_item := succ (last_item);>       IF DEBUG_OUT then writeln('    last_item =', last_item);$       with items[last_item] do begin2         len := 0; code := 0; addr := 0; rlen := 0;&       end; (* with items[last_item] *)6       if DEBUG_OUT then writeln ('    Queueing job.');P       stat := $SNDJBCW (func := SJC$_ENTER_FILE, itmlst := items, iosb := iosb);)       if odd (stat) then stat := iosb[0];',       if (not odd (stat)) and DEBUG_OUT thene         writeln ('    Error submitting job, status = ', stat:0, ' iosb =', iosb[0]:0,' ', iosb[1]:0);      end else if DEBUG_OUT then-       writeln ('    Queue ', try_batch_queue,i6                ' is not writable, status = ', stat:0);6     if (not odd (stat)) and (queue_try < 3) then begin$       queue_try := succ (queue_try);       goto 44;     end; (* if *) /     priv[0] := uand (priv[0], unot (ppriv[0]));e/     priv[1] := uand (priv[1], unot (ppriv[1])); 7     $SETPRV (ENBFLG := 0, PRVADR := priv, PRMFLG := 0);       if not odd (stat) then begin       LIB$SIGNAL (stat);       MAIL_OUT_FILE := stat;       goto 99;     end; (* if *) #     if not odd (iosb[0]) then begin:       LIB$SIGNAL (iosb[0]);        MAIL_OUT_FILE := iosb[0];]       goto 99;     end; (* if *)i+     user_list_scan := user_list_scan^.next;w   end; (* while *)   MAIL_OUT_FILE := SS$_NORMAL; 99: 6   (* Turn the BIO bit back on if it was set before. *)#   $DISCONNECT (RAB := message_RAB); (   message_RAB.RAB$V_BIO := previous_bio;(   message_RAB.RAB$L_RBF := previous_rbf;(   message_RAB.RAB$W_RSZ := previous_rsz;(   message_RAB.RAB$L_UBF := previous_ubf;(   message_RAB.RAB$W_USZ := previous_usz;(   message_RAB.RAB$B_RAC := previous_rac;    $CONNECT (RAB := message_RAB); end; (* MAIL_OUT_FILE *)   J (* MAIL_OUT_DEACCESS is called to shut down the current send operation. *)  '< [global] function MAIL_OUT_DEACCESS (var context : unsigned;%   var link_flag : integer) : integer;     begin (* MAIL_OUT_DEACCESS *)a:   if DEBUG_OUT then writeln ('MAIL_OUT_DEACCESS called.');    if user_list <> nil then beginM     if DEBUG_OUT then writeln ('  Deleting user list and associated rules.');b"     dispose_user_list (user_list);   end;"   MAIL_OUT_DEACCESS := SS$_NORMAL; end; (* MAIL_OUT_DEACCESS *)  HK (* MAIL_OUT_ATTRIBS delivers the message file's attributes to DELIVER. ThissL    information is currently unused (see comment in MAIL_IN_ATTRIBS below. *)  ; [global] function MAIL_OUT_ATTRIBS (var context : unsigned;g6   var link_flag : integer; var system_flags : integer;.   var idtld : file_attribute_block) : integer;   begin (* MAIL_OUT_ATTRIBS *)9   if DEBUG_OUT then writeln ('MAIL_OUT_ATTRIBS called.'); !   MAIL_OUT_ATTRIBS := SS$_NORMAL;g end; (* MAIL_OUT_ATTRIBS *)a  O (* These routines manipulate a stack in which we maintain state information for_F    information being "written" to us when MAIL calls MAIL_IO_WRITE. *)  _5 procedure init_stack (var stack : write_state_stack);     begin (* init_stack *)2   if DEBUG_IN then writeln ('INIT_STACK called.');   stack.top := 0;k end; (* init_stack *):  gE procedure push (var stack : write_state_stack; state : write_states);'    var    i : integer;    begin (* push *),   if DEBUG_IN then writeln ('PUSH called.');   with stack do begina.     if top < stack_size then top := succ (top))     else LIB$SIGNAL (DELIVER__INTSTKOVR);i     store[top] := state;     if DEBUG_IN then begin        writeln ('  after PUSH:');:       for i := top downto 1 do writeln ('    ', store[i]);     end; (* if *)    end; (* with *)  end; (* push *)'  T. procedure pop (var stack : write_state_stack);  C var'   i : integer;  ' begin (* pop *) +   if DEBUG_IN then writeln ('POP called.');'   with stack do begin      top := pred (top);3     if top < 1 then LIB$SIGNAL (DELIVER__STKEMPTY);    end; (* with *)m   if DEBUG_IN then begin     writeln ('  after POP:');CD     for i := stack.top downto 1 do writeln ('    ', stack.store[i]);   end; end; (* pop *)  FE function top_of_stack (var stack : write_state_stack) : write_states;     begin (* top_of_stack *)4   if DEBUG_IN then writeln ('TOP_OF_STACK called.');   with stack do begin      if top > 0 then beginC!       top_of_stack := store[top];e;       if DEBUG_IN then writeln (' returning ', store[top]);L     end else begin%       LIB$SIGNAL (DELIVER__STKEMPTY);I       top_of_stack := bad_msg;8       if DEBUG_IN then writeln (' returning ', bad_msg);     end; (* if *)      end; (* with *)$ end; (* top_of_stack *)A  )I (* The incoming mail handling routines are activated by a command line of     the form:   M    $ MAIL/PROTOCOL=DELIVER_MAILSHR/SUBJECT="subject" message.txt address-list   iH    Everything is specified on the command line except the From: address,B    which is obtained by translating the logical name DELIVER$FROM.  'J    System privileges are required to use this interface since this routine4    makes it possible to "forge" return addresses. *)  _: [global] function MAIL_IN_CONNECT (var context : unsigned;   var link_flag : integer;%   var input_tran : string_descriptor; #   var file_RAT, file_RFM : integer;_!   var MAIL$GL_SYSFLAGS : integer; *   var MAIL$Q_PROTOCOL : string_descriptor;   var pflags : integer; #   var file_ORG : $ubyte) : integer;w  e vare9   priv : [quad] array [0..1] of unsigned; stat : integer;L   begin (* MAIL_IN_CONNECT *) 7   if DEBUG_IN then writeln ('MAIL_IN_CONNECT called.');     (* Set file structure stuff *)   file_RAT := FAB$M_CR;_   file_RFM := FAB$C_VAR;6   if MAIL$C_PROT_MAJOR > 1 then file_ORG := FAB$C_SEQ;     priv[0] := 0; priv[1] := 0; 6   stat := LIB$GETJPI (JPI$_PROCPRIV, , , priv[0], , );+   if not odd (stat) then LIB$SIGNAL (stat); 0   if uand (priv[0], PRV$M_SYSPRV) = 0 then begin"     LIB$SIGNAL (DELIVER__NOTPRIV);(     MAIL_IN_CONNECT := DELIVER__NOTPRIV;   end else begin     toline := ''; ;     if DEBUG_IN then writeln ('Initializing state stack.'); #     init_stack (write_recv_states); &     push (write_recv_states, bad_msg);     sticky_error := SS$_NORMAL;aG     LIB$SET_SYMBOL ('DELIVER_STATUS', '%X' + hex (sticky_error, 8, 8));i"     MAIL_IN_CONNECT := SS$_NORMAL;   end; (* if *)  end; (* MAIL_IN_CONNECT *)   J (* MAIL calls MAIL_IN_LINE to get single line information from DELIVER. *)   7 [global] function MAIL_IN_LINE (var context : unsigned;    var link_flag : integer;*   var line : string_descriptor) : integer;  E var &   linebuffer : string; stat : integer;  " begin (* MAIL_IN_LINE *)4   if DEBUG_IN then writeln ('MAIL_IN_LINE called.');   case iaddress (link_flag) of*     (* Return From: information to MAIL *)     LNK_C_IN_SENDER : begineL                         if DEBUG_IN then writeln ('IN_SENDER option used.');L                         stat := LIB$GET_SYMBOL ('DELIVER_FROM', linebuffer);O                         if not odd (stat) then linebuffer := '<not specified>'; J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);1                        end; (* LNK_C_IN_SENDER *) (     (* Return To: information to MAIL *)     LNK_C_IN_CKUSER : beginnL                         if DEBUG_IN then writeln ('IN_CKUSER option used.');E                         stat := CLI$GET_VALUE ('TOLIST', linebuffer);iO                         if not odd (stat) then linebuffer := chr (0) else begin M                           if length (toline) > 0 then toline := toline + ','; 8                           toline := toline + linebuffer;?                           push (write_recv_states, user_check);                          end;J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);0                       end; (* LNK_C_IN_CKUSER *)(     (* Return entire To: line to MAIL *)     LNK_C_IN_TO     : beginrH                         if DEBUG_IN then writeln ('IN_TO option used.');J                         stat := LIB$GET_SYMBOL ('DELIVER_TO', linebuffer);+                         if odd (stat) then  K                           copy_string_to_descr (linebuffer, line, DEBUG_IN)_K                         else copy_string_to_descr (toline, line, DEBUG_IN);;-                        end; (* LNK_C_IN_TO *)r-     (* Return entire Subject: line to MAIL *)e     LNK_C_IN_SUBJ   : begineJ                         if DEBUG_IN then writeln ('IN_SUBJ option used.');F                         stat := CLI$GET_VALUE ('SUBJECT', linebuffer);@                         if not odd (stat) then linebuffer := '';J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);/                        end; (* LNK_C_IN_SUBJ *)e(     (* Return entire Cc: line to MAIL *)     LNK_C_IN_CC     : begineH                         if DEBUG_IN then writeln ('IN_CC option used.');J                         stat := LIB$GET_SYMBOL ('DELIVER_CC', linebuffer);@                         if not odd (stat) then linebuffer := '';J                         copy_string_to_descr (linebuffer, line, DEBUG_IN);/                        end; (* LNK_C_IN_SUBJ *)      otherwise beginu[                          if DEBUG_OUT then writeln ('  Otherwise option used.', link_flag);n 	      end;    end; (* case *)i   MAIL_IN_LINE := SS$_NORMAL;u end; (* MAIL_IN_LINE *)s  iG (* MAIL_IN_FILE is called by MAIL to read the body of the message to be_J    delivered. This routine gets the file name from the command line, opens;    the file and copies it into MAIL's intermediate file. *).  c7 [global] function MAIL_IN_FILE (var context : unsigned;.   var link_flag : integer;   var scratch : integer;   var message_RAB : RAB$TYPE; ,   procedure UTIL$REPORT_IO_ERROR) : integer;  =   varh    filename, linebuffer : string;   message_file : text;   stat : integer;    previous_bio : boolean;e(   previous_rbf, previous_ubf : unsigned;&   previous_rsz, previous_usz : $uword;   previous_rac : $ubyte;  p begin (* MAIL_IN_FILE *)4   if DEBUG_IN then writeln ('MAIL_IN_FILE called.');H   (* Get the name of the file containing the message to be delivered. *)+   stat := CLI$GET_VALUE ('FILE', filename);r   if not odd (stat) then begin-     LIB$SIGNAL (DELIVER__GETFILERR, 1, stat);a'     MAIL_IN_FILE := DELIVER__GETFILERR;    end else begin?     open (file_variable := message_file, file_name := filename,e:           organization := SEQUENTIAL, sharing := READONLY,E           default := '.TXT', error := CONTINUE, history := READONLY); &     if status (message_file) <= 0 then.       reset (message_file, error := CONTINUE);+     if status (message_file) > 0 then beginf&       LIB$SIGNAL (DELIVER__MESOPNERR);)       MAIL_IN_FILE := DELIVER__MESOPNERR;      end else beginO       (* MAIL can never get it right... The logic for setting and resetting thetJ          BIO bit is broken up at least as far as VMS 5.4... We'll play ourL          usual game and make sure the damn thing is properly set for what we          want to do. *) '       $DISCONNECT (RAB := message_RAB);Q,       previous_bio := message_RAB.RAB$V_BIO;,       previous_rbf := message_RAB.RAB$L_RBF;,       previous_rsz := message_RAB.RAB$W_RSZ;,       previous_ubf := message_RAB.RAB$L_UBF;,       previous_usz := message_RAB.RAB$W_USZ;,       previous_rac := message_RAB.RAB$B_RAC;%       message_RAB.RAB$V_BIO := false;n$       $CONNECT (RAB := message_RAB);9       message_RAB.RAB$L_RBF := iaddress (linebuffer) + 2;T       stat := SS$_NORMAL; >       while (not eof (message_file)) and (odd (stat)) do begin=         readln (message_file, linebuffer, error := CONTINUE);E/         if status (message_file) > 0 then beginmD           LIB$SIGNAL (DELIVER__MSGREAERR, 1, status (message_file));%           stat := DELIVER__MSGREAERR;;         end else begin7           message_RAB.RAB$W_RSZ := length (linebuffer);',           stat := $PUT (RAB := message_RAB);            if not odd (stat) then5             LIB$SIGNAL (DELIVER__MSGWRTERR, 1, stat);s         end;       end; (* while *).       close (message_file, error := CONTINUE);:       (* Turn the BIO bit back on if it was set before. *)'       $DISCONNECT (RAB := message_RAB);R,       message_RAB.RAB$V_BIO := previous_bio;,       message_RAB.RAB$L_RBF := previous_rbf;,       message_RAB.RAB$W_RSZ := previous_rsz;,       message_RAB.RAB$L_UBF := previous_ubf;,       message_RAB.RAB$W_USZ := previous_usz;,       message_RAB.RAB$B_RAC := previous_rac;$       $CONNECT (RAB := message_RAB);       MAIL_IN_FILE := stat;y     end;   end;+   push (write_recv_states, delivery_check);u end; (* MAIL_IN_FILE *)e   N (* MAIL_IN_ATTRIBS is called to get file attributes for the message file. ThisJ    routine is currently unused. It is not possible to add support for fileI    attributes to DELIVER at this time (VMS 5.0-2) because this routine isbH    *never* called for foreign protocols. See the code in the accept_linkK    routine in MAIL$SERVER_SUBS -- the only way that the SERV_FORRECV bit in=H    MAIL$L_SRVFLAGS can be set is by a MAIL-11 transaction. This bit thenN    determines if LNK_C_IN_ATTRIBS is used and MAIL_IN_ATTRIBS is called by theL    mail_server routine in MAIL$SERVER_MAIN. Until this code is expanded uponM    (or if we are willing to patch the MAIL image) it will not be possible fortK    DELIVER to handle file attributes and the things they apply to like DDIFs    files. *)  : [global] function MAIL_IN_ATTRIBS (var context : unsigned;G   var link_flag : integer; var idtld : file_attribute_block) : integer;c   begin (* MAIL_IN_ATTRIBS *)f7   if DEBUG_IN then writeln ('MAIL_IN_ATTRIBS called.');y    MAIL_IN_ATTRIBS := SS$_NORMAL; end; (* MAIL_IN_ATTRIBS *)  H (* MAIL_IO_WRITE is called by MAIL to tell DELIVER what it thinks of the8    results returned by the various MAIL_IN_ routines. *)   8 [global] function MAIL_IO_WRITE (var context : unsigned;   var link_flag : integer;&   line : string_descriptor) : integer;  D label    99;i   var    error_text : string;  yE   function string_to_integer (var str : string_descriptor) : integer;_  c   var.6     number : packed array [1..4] of char; i : integer;  i   begin (* string_to_integer *) =     if str.length <> 4 then string_to_integer := 0 else begin:6       for i := 1 to 4 do number[i] := str.address^[i];-       string_to_integer := number :: integer;      end;   end; (* string_to_integer *)  P begin (* MAIL_IO_WRITE *):5   if DEBUG_IN then writeln ('MAIL_IO_WRITE called.'); *   case top_of_stack (write_recv_states) of     delivery_check : beginD                        if DEBUG_IN then writeln ('Delivery check.');>                        last_error := string_to_integer (line);O                        if DEBUG_IN then writeln (' got a stat : ', last_error);C/                        pop (write_recv_states); P                        if not odd (last_error) and odd (sticky_error) then begin4                          sticky_error := last_error;:                          LIB$SET_SYMBOL ('DELIVER_STATUS',J                                          '%X' + hex (sticky_error, 8, 8));$                        end; (* if *)7                        if last_error <> SS$_NORMAL theng=                          push (write_recv_states, error_msg);s.                      end; (* delivery_check *)     user_check :     begin@                        if DEBUG_IN then writeln ('User check.');>                        last_error := string_to_integer (line);O                        if DEBUG_IN then writeln (' got a stat : ', last_error);7/                        pop (write_recv_states);fP                        if not odd (last_error) and odd (sticky_error) then begin4                          sticky_error := last_error;:                          LIB$SET_SYMBOL ('DELIVER_STATUS',J                                          '%X' + hex (sticky_error, 8, 8));$                        end; (* if *)7                        if last_error <> SS$_NORMAL thenl=                          push (write_recv_states, error_msg);m*                      end; (* user_check *)     error_msg :      begin@                        if DEBUG_IN then writeln ('Error text.');L                        if (line.length = 1) and (line.address^[1] = chr (0))!                        then begin )                          if DEBUG_IN then P                            writeln (' got a NULL -- popping write_recv_states');%                        end else begin K                          copy_descr_to_string (line, error_text, DEBUG_IN);G)                          if DEBUG_IN thentI                            writeln ('Error message: "', error_text, '"');d5                          if not odd (last_error) then J                            LIB$SET_SYMBOL ('DELIVER_MESSAGE', error_text);                        end;L/                        pop (write_recv_states);(*                      end; (* error_text *)     bad_msg :        beginH                        if DEBUG_IN then writeln ('Unexpected message.');>                        last_error := string_to_integer (line);P                        if not odd (last_error) and odd (sticky_error) then begin4                          sticky_error := last_error;:                          LIB$SET_SYMBOL ('DELIVER_STATUS',J                                          '%X' + hex (sticky_error, 8, 8));$                        end; (* if *)'                        if DEBUG_IN thenBE                          writeln (' UNEXPECTED stat : ', last_error);g;                        push (write_recv_states, error_msg); '                      end; (* bad_msg *)n     otherwise begin &       LIB$SIGNAL (DELIVER__BADSTKELE);*       MAIL_IO_WRITE := DELIVER__BADSTKELE;       goto 99;     end;   end; (* case *)    MAIL_IO_WRITE := SS$_NORMAL; 99:l end; (* MAIL_IO_WRITE *)  N7 [global] function MAIL_IO_READ (var context : unsigned;    var link_flag : integer;3   var returned_line : string_descriptor) : integer;i  _ begin (* MAIL_IO_READ *)4   if DEBUG_IN then writeln ('MAIL_IO_READ called.');   MAIL_IO_READ := SS$_NORMAL;B end; (* MAIL_IO_READ *)s  _ (* End of DELIVER.PAS *) end.message_RAB.RAB$B_RAC := previous_rac;    $CONNECT (RAB := message_RAB); end; (* MAIL_OUT_FILE *)   J (* MAIL_OUT_DEACCESS is called to shut down the current send operation. *)  '< [global] function MAIL_OUT_DEACCESS (var context : unsigned;%   var link_flag : integer) : integer;     begin (* MAIL_OUT_DEACCESS *)a:   if DEBUG_OUT then writeln ('MAIL_OUT_DEACCESS called.');    if user_list <> nil then beginM     if DEBUG_OUT then writeln ('                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  