 #pragma module DQDRIVER "X-1"   J /************************************************************************/
 /*									*/ J /* Copyright  Digital Equipment Corporation, 1994 All Rights Reserved.	*/H /* Unpublished rights reserved under the copyright laws of the United	*/ /* States.								*/
 /*									*/ I /* The software contained on this media is proprietary to and embodies	*/ C /* the confidential technology of Digital Equipment Corporation.	*/ G /* Possession, use, duplication or dissemination of the software and	*/ G /* media is authorized only pursuant to a valid written license from	*/ ( /* Digital Equipment Corporation.					*/
 /*									*/ G /* RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the	*/ A /* U.S. Government is subject to restrictions as set forth in		*/ I /* Subparagraph (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19,	*/  /* as applicable.							*/
 /*									*/ J /************************************************************************/  J /************************************************************************/
 /*									*/  /* Facility:								*/ /*	IDE Disk Driver							*/ 
 /*									*/  /* Abstract:								*/1 /*	This driver controls a standard IDE disk.			*/ 
 /*									*/  /* Author:								*/* /*	Benjamin J. Thomas III / May 1994				*/
 /*									*/  /* Dedication:								*/
 /*									*/ J /* My brother-in-law and nephew were killed in a small plane crash just	*/D /* off Nantucket island, on June 6, 1994, shortly after I started	*/E /* writing this driver.  This effort is dedicated to the memory of	*/ F /* of Reginald Marden and Christopher Marden.  They will be missed.	*/
 /*									*/ 
 /*									*/  /* Revision History:							*/ 
 /*									*/ , /*	X-1		Benjamin J. Thomas III		May, 1994	*/ /*		Initial version.					*/ 
 /*									*/ J /************************************************************************/    /* Miscellaneous tidbits						*/
 /*									*/ B /*	o Always check the BUSY bit.  If set, none of the other bits	*/E /*	  can be fully trusted.  If clear, it's ok to believe the other	*/ ' /*	  bits and to issue commands.					*/ 
 /*									*/ B /*	o Make sure the correct drive is selected before any action.	*/B /*	  This means checking the BUSY bit for clear, then selecting	*/B /*	  the desired driver, then checking BUSY again for clear for	*/E /*	  that drive.  Note that VMS allows a channel concept, and this	*/ E /*	  driver obtains ownership of the channel.  Therefore, we don't	*/ B /*	  have to be quite so paranoid about ownership changes.  Get	*/B /*	  the channel, then get ownership...release the channel when	*/ /*	  all done.							*/ 
 /*									*/ A /*	o It's a good idea to keep sector count under 128.  This is	*/ D /*	  just a caution against drives that may not handle the number	*/ /*	  as unsigned.							*/
 /*									*/ D /*	o Read ALT_STS for the status bits unless the direct intent is	*/' /*	  also to clear the interrupt					*/ 
 /*									*/ A /*	o Read/Write multiple commands don't seem to work very well	*/ D /*	  all the time.  Based on advice, those commands seem aimed at	*/E /*	  treating the disk as if it had a different sector size.  This	*/ B /*	  driver uses the simple read/write commands.  This means an	*/D /*	  interrupt per sector, which can't be avoided.  A DMA version	*/A /*	  could possibly help this (someday).  For now, read/writes	*/ D /*	  will be done with the simple commands, and not exceeding 127	*/1 /*	  blocks at a time (see previous bullet).			*/ 
 /*									*/ 
 /*									*/ # /* Basic transfer algorithm						*/ 
 /*									*/ 0 /*	1) Use ALT_STATUS to check for BUSY = 0				*/) /*			Error -> RESET, then retry once			*/ $ /*	2) Select the proper drive					*/7 /*	3) Check ALT_STATUS again, for BUSY=0, DRDY = 1			*/ * /*			Error -> RESET, retry from step 1		*/ /*	4) Write the CSRs						*/ /*	5) Write the command						*/   /*	6) Wait for interrupt						*/, /*			Timeout -> RESET, retry from step 3		*/0 /*	7) Read STATUS (which clears interrupt)				*/* /*	8) Transfer data is DRQ=1, BUSY=0				*/6 /*			Error ->  DRQ=0 -> goto step 9 (ERR should =1)	*/, /*				  BUSY=1-> RESET, retry from step 3	*/9 /*	9) Check that STATUS (saved from step 7) has ERR=0		*/   /*			Error -> handle error				*/; /*	10) If not done, goto step 6 (multisector transfers)		*/ 7 /*	    If done, goto step 3 (next command/transfer)		*/ 
 /*									*/ # /* A write would modify as:						*/ 
 /*									*/ / /*	5a) Check ALT_STATUS for BUSY=0, DRQ=1				*/ " /*	5b) Send all of the data					*/ /*	Remove step 8							*/ 
 /*									*/  /* Powerup algorithm							*/ 
 /*									*/ @ /*	1) Poll ALT_STATUS for up to 40 seconds for BUSY=0, DRDY=1	*/ /*			Error -> Fatal					*/ /*	2) Select drive 0						*/. /*	3) Read ALT_STATUS for BUSY=0, DRDY=1				*/ /*			Error -> Fatal					*/ /*	4) Drive 0 exists						*/ /*	5) Select drive 1						*/. /*	6) Read ALT_STATUS for BUSY=0, DRDY=1				*/7 /*			Error->BUSY=1 fatal master/slave incompatability*/ # /*			       DRDY=0  no drive 1			*/  /*	7) drive 1 exists						*/   /* Build instructions:							*/  /* ===================							*/ 
 /*									*/ 0 /*	$ CC_OPT = "/DEFINE=(BASEALIGN_SUPPORT)"			*/ /*	$ IF P1 .NES. ""						*/  /*	$ THEN								*/ B /*	$  IF P1 .NES. "DEBUG" THEN EXIT %X14         ! SS$_BADPARAM	*/F /*	$  CC_OPT = "/DEBUG/NOOPTIMIZE/DEFINE=(DEBUG,BASEALIGN_SUPPORT)" */ /*	$ ENDIF								*/ /*	$								*/  /*	$! Compile the driver						*/ /*	$								*/A /*	$ CC/STANDARD=RELAXED_ANSI89/INSTRUCTION=NOFLOATING_POINT -	*/ # /*		/EXTERN=STRICT 'CC_OPT' -				*/ 1 /*		/LIS=DQDRIVER/MACHINE_CODE/OBJ=DQDRIVER -		*/ 2 /*		DQDRIVER+SYS$LIBRARY:SYS$LIB_C.TLB/LIBRARY		*/ /*	$								*/ /*	$! Link the driver						*/  /*	$								*/E /*	$ LINK/ALPHA/USERLIB=PROC/NATIVE_ONLY/BPAGE=14/SECTION/REPLACE-	*/ : /*	        /NODEMAND_ZERO/NOTRACEBACK/SYSEXE/NOSYSSHR-		*/? /*	        /SHARE=SYS$DQDRIVER-               ! Driver image	*/ D /*	        /DSF=SYS$DQDRIVER-                 ! Debug symbol file	*/? /*	        /SYMBOL=SYS$DQDRIVER-              ! Symbol table	*/ > /*	        /MAP=SYS$DQDRIVER/FULL/CROSS -     ! Map listing	*/$ /*	        SYS$INPUT:/OPTIONS					*/ /*	SYMBOL_TABLE=GLOBALS						*/   /*	CLUSTER=VMSDRIVER,,,-						*/! /*	        DQDRIVER.OBJ,-						*/ X /*	        SYS$LIBRARY:VMS$VOLATILE_PRIVATE_INTERFACES/INCLUDE=(BUGCHECK_CODES)/LIB,- */F /*	        SYS$LIBRARY:STARLET/INCLUDE:(SYS$DRIVER_INIT,SYS$DOINIT) */< /*	COLLECT=NONPAGED_EXECUTE_PSECTS/ATTRIBUTES=RESIDENT,-		*/ /*	        $CODE$							*/  /*	PSECT_ATTR=$LINK$,WRT						*/" /*	PSECT_ATTR=$INITIAL$,WRT					*/- /*	PSECT_ATTR=$LITERAL$,NOPIC,NOSHR,WRT				*/ . /*	PSECT_ATTR=$READONLY$,NOPIC,NOSHR,WRT				*/) /*	PSECT_ATTR=$$$105_PROLOGUE,NOPIC				*/ & /*	PSECT_ATTR=$$$110_DATA,NOPIC					*/' /*	PSECT_ATTR=$$$115_LINKAGE,WRT					*/ E /*	COLLECT=NONPAGED_READWRITE_PSECTS/ATTRIBUTES=RESIDENT,$PLIT$, -	*/ H /*              $INITIAL$,$GLOBAL$,$OWN$,$$$105_PROLOGUE,$$$110_DATA,	*/> /*		$$$115_LINKAGE,$BSS$,$DATA$,$LINK$,$LITERAL$,$READONLY$	*/) /*	PSECT_ATTR=EXEC$INIT_CODE,NOSHR					*/ D /*	COLLECT=INITIALIZATION_PSECTS/ATTRIBUTES=INITIALIZATION_CODE,-	*/; /*	        EXEC$INIT_000, EXEC$INIT_001,EXEC$INIT_002,-		*/ = /*		EXEC$INIT_CODE,EXEC$INIT_LINKAGE,EXEC$INIT_SSTBL_000,-	*/ 0 /*		EXEC$INIT_SSTBL_001,EXEC$INIT_SSTBL_002			*/ /*	$QUIT:								*/  /*	$ EXIT $STATUS							*/   /* Usage Instructions:							*/  /* ===================							*/ 
 /*									*/ H /* This driver was written with a $19 ISA IDE controller plugged into	*/F /* an ISA bus.  In addition, on the Digital AlphaStation 400 4/233,	*/H /* there is a built-in (but not supported) IDE controller.  In either	*/= /* case, you need to make sure that everything is set up.		*/ 
 /*									*/ I /* For the Digital AlphaStation 400 4/233, you must run the ENABLE-IDE	*/ F /* progam (from the Freeware CD) to enable the IDE port.  This port	*/E /* will use IRQ 14 and is on the ISA bus.  You may need to run the	*/ G /* console's ISACFG utility to reserve IRQ 14 for the device.  For a	*/ E /* separate ISA board, there is no need to do any special hardware	*/  /* setup.								*/u
 /*									*/1
 /*									*/*/ /* A sample ISACFG line, might look like:				*/*
 /*									*/ U /* >>>isacfg -mk -slot 3 -dev 0 -iobase 1f0 -irq0 14 -etyp 1 -enadev 1	-handle IDE */	
 /*									*/h6 /* To load the driver, use the following command:			*/
 /*									*/. /*	$ MC SYSMAN							*/ E /*	SYSMAN> IO CONNECT DQA0:/DRIVER=SYS$DQDRIVER/Node=n/CSR=%X1F0 -	*/s /*		/Adap=x/Vector=y					*/h
 /*									*/a- /* This command assumes (or requires):					*/e
 /*									*/rB /*	CSR is %X1F0, this is the standard address for a primary IDE	*/6 /*	IRQ is usually, 14, so vector y = 4 * IRQ = 56			*/A /*	Adapter is the ISA adapter, found from the TR number of the	*/S= /*		ISA adapter from SYSMAN IO SHOW BUS.  This is the "TR"	*/o? /*	node is the slot number into which the board was plugged.	*/a r /* Caveats:								*/ 
 /*									*/rI /* This driver was written from the X3T9.2 specs, which may or may not	*/*F /* accurately reflect working drives. The driver has been tested on	*/F /* a few different IDE drives, but the following are known items to	*/ /* watch out for:							*/
 /*									*/*> /*	o Driver has never been tested (nor does it support) DMA	*/> /*	o Driver has been used only with 16 bit data interfaces		*/A /*	o Driver hasn't yet been tested with 2 drives (units 0 & 1)	*/	
 /*									*/	4 /* I'm sure that there are others - good luck.				*/
 /*									*/aJ /* One obvious place for improvement is the copying of data to and from	*/H /* the transfer buffer.  It would be better to move the data directly	*/I /* to/from the user buffer, but there were some reasons that I didn't.	*/iI /* First, it's just plain a pain to get it right.  You have to account	*/*F /* for the alignment issues;  this is no good if you are constantly	*/F /* taking alignment faults or if you are constantly loading/merging	*/F /* data.  Secondly, you need to always empty/fill the disk's buffer	*/H /* and that means handling non-sector-sized counts.  Overall, not too	*/H /* hard, but a pain.  Finally, if you *really* want performance, you 	*/5 /* should just move to DMA, not programmed I/O.				*/n oa /* Registers - Here's my register cheat sheet.  The CSRs are expressed as ISA offset and then		*/cF /* the offsets for two of the ISA machines that I tried it on.						*/ /*													*/r= /* +=====-=====-=====-=====-=====-=====-=====-=====+							*/ = /* |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |							*/*= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/t] /* | BSY | DRDY| DWF | DSC | DRQ |CORR | IDX | ERR |	3F6 (1FB00) [7EC0] R	Alternate Status	*/n= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/	] /* |  x  |   x |  x  |  x  |  1  | SRST| nIEN|  0  |	3F6 (1FB00) [7EC0] W	Device control 		*/ = /* |-----+-----+-----+-----+-----+-----+-----+-----|							*//\ /* | HiZ | nWTG| nHS3| nHS2| nHS1| nHS0| nDS1| nDS0|	3F7 (1FB80) [7EE0] R	Drive address 		*/= /* +===============================================+							*/ 7 /* |						   |	1F0 (F820)  [3E08] RW	Data (16 bits)		*/e= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/tU /* | BBK | UNC | MC  | IDNF| MCR |ABRT |TK0NF|AMNF |	1F1 (F880)  [3E20] R	Error	 		*/s= /* +===============================================+							*/.7 /* |					           |	1F1 (F880)  [3E20] W	Features		*/t= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/s< /* |					           |	1F2 (F900)  [3E40] RW	Sector count		*/= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/mE /* |					           |	1F3 (F980)  [3E60] RW	Sector number (LBA0-7)	*/c= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/TE /* |					           |	1F4 (FA00)  [3E80] RW	Cylinder low (LBA8-15)	*/*= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/S? /* |						   |	1F5 (FA80)  [3EA0] RW	Cylinder high(LBA16-23)	*/o= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/mc /* |  1  |  L  |  1  | DRV | HS3 | HS2 | HS1 | HS0 |	1F6 (FB00)  [3EC0] RW	Drive/head (LBA24-27)	*/e= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/sU /* | BSY | DRDY| DWF | DSC | DRQ |CORR | IDX | ERR |	1F7 (FB80)  [3EE0] R	Status			*/U= /* |-----+-----+-----+-----+-----+-----+-----+-----|							*/v7 /* |					           |	1F7 (FB80)  [3EE0] W	Command			*/r= /* +===============================================+							*/	  6 /* Define system data structure types and constants */  - #include	ccbdef			/* Channel control block */	0 #include	crbdef			/* Controller request block */: #include	cramdef			/* Controller register access method */# #include	dcdef			/* Device codes */	) #include	ddbdef			/* Device data block */	- #include	ddtdef			/* Driver dispatch table */c. #include	devdef			/* Device characteristics */- #include	dptdef			/* Driver prologue table */d4 #include	embdvdef		/* Error log entry for devices *// #include	fdtdef			/* Function decision table */e" #include	fkbdef			/* Fork block */, #include	idbdef			/* Interrupt data block */% #include	iocdef			/* IOC constants */t) #include	iodef			/* I/O function codes */ * #include	irpdef			/* I/O request packet */+ #include	orbdef			/* Object rights block */=A #include	pagedef			/* Get page definitions and disk block size */R- #include	pcbdef			/* Process control block */E4 #include	ptedef			/* Page Table entry definitions */2 #include	ssdef			/* System service status codes */* #include	stddef			/* Common definitions */+ #include	stsdef			/* Status value fields */$* #include	ucbdef			/* Unit control block */2 #include	vadef			/* Virtual address definitions */  4 /* Define function prototypes for system routines */  7 #include	acp_routines		/* ACP$ and ACP_STD$ routines */R7 #include	erl_routines		/* erl$ and erl_std$ routines *//7 #include	exe_routines		/* exe$ and exe_std$ routines */N7 #include	ioc_routines		/* ioc$ and ioc_std$ routines */-7 #include	ldr_routines		/* ldr$ and ldr_std$ routines */H9 /*#include	sch_routines		/* sch$ and sch_std$ routines */v  ) /* Define various device driver macros */   8 #include	vms_drivers		/* Device driver support macros */4 #include	vms_macros		/* Define bug_check and such */  4 /* Define the DEC C functions used by this driver */  , #include	builtins		/* C builtin functions */6 #include	string			/* String rtns from "kernel CRTL" */   /* Define some useful types */  > typedef unsigned short int WORD;	/* Define a WORD (16 bits) */9 typedef unsigned char BYTE;		/* Define a BYTE (8 bits) */C7 typedef unsigned int UINT;		/* Usigned int (32 bits) */_  . /* Define constants specific to this driver */   enum {				/* Timeout times */=:     TIMEOUT_TIME=   10,			/* I/O Timeout time (seconds) */>     DRQ_TIME	= 1000*1000,		/* DRQ wait time (1 millisecond) */3     RESET_TIME	=    2,			/* Reset time (seconds) */O>     READY_TIME	= 1000*100		/* Ready time (100 microseconds) */ };  ( enum {				/* Miscellaneous constants: */6     NUMBER_CRAMS=   18,			/* Number of CRAMs needed */3     MODEL_LENGTH=   40,			/* Model string length */RS     ERR_BYTES	=   EMB$C_DV_LENGTH+12+5+8,	/* Size of error log buffer (in bytes) *//L     RDSTATS_LEN	=   (TIMEOUT_TIME + 9) * 4,	/* Size of RDSTATS_LEN buffer */6     MAX_RETRY	=    8			/* Maximum number of retries */ };  $ enum {				/* Controller constants */+     DEVICE_IPL	=   21			/* IPL of device */T };  / enum {				/* Geometry and transfer constants */B4     MAX_SECTOR	=  256,			/* Max sectors per track */3     MAX_HEAD	=   16,			/* Max heads per cylinder */=7     MAX_CYLINDER= 8192,			/* Max cylinders per drive */w8     MAX_XFER	=  127,			/* Max transfer size (sectors) */G     BLK_SIZE	= IOC$C_DISK_BLKSIZ,	/* Size of a disk block (in bytes) */*C     BLK_MASK	= IOC$M_BLOCK_BYTEMASK,	/* "Byte within block" mask *//=     BLK_SHIFT	=    9			/* Shift factor for blocks to bytes */  };   /* External references */t  7 extern	int	MMG$GL_BWP_MASK;	/* Byte-within-page mask */ 5 extern	int	MMG$GL_PAGE_SIZE;	/* Page size in bytes */.; extern	int	MMG$GL_VPN_TO_VA;	/* Page to byte shift count */u; extern	PTE	*MMG$GL_SPTBASE;	/* Base of system page table */rG extern	int	MMG$GL_PTE_OFFSET_TO_VA;/* Shift for PTE to VA conversion */n+ extern	DDT	driver$ddt;		/* Prototype DDT */	+ extern	DPT	driver$dpt;		/* Prototype DPT */*+ extern	FDT	driver$fdt;		/* Prototype FDT */* #ifdef DEBUG4 extern void ini$brk(void);		/* Breakpoint routine */ #endif  3 /* Shortcuts for some of the external references */d  3 #define	_ddt	driver$ddt		/* Abbreviation for DDT */	3 #define	_dpt	driver$dpt		/* Abbreviation for DPT */ 3 #define	_fdt	driver$fdt		/* Abbreviation for FDT */	  ' /* Define the proper WFIKPCH routine */*   #ifdef DEBUG #define	WFIKPCH	wfikpch_hist #else	 #define	WFIKPCH	ioc$kp_wfikpch #endif r* /* Define the IDE disk controller CSRs.	*/  B /* Here are the customary values for PC AT compatible machines.	*/A /* Note that the CSRs may be anywhere, and are defined here as	*/A@ /* offsets from a base.  That base is the address of the DATA	*/ /* register.							*/  /*				Primary		Secondary	*/	+ /* Data/Control Ports		1F0-1F7h	170-177h	*/s- /* Control/Status Ports		3F7-3F6h	377-376h	*/y  * 	/* Offsets for control block registers */  7 #define REG_ALT_STS	0x206		/* READ: Alternate status */d5 #define REG_DEV_CTL	0x206		/* WRITE:Device control */h5 #define REG_DRV_ADDR	0x207		/* READ: Drive address */e  * 	/* Offsets for command block registers */  $ #define REG_DATA	0		/* R/W:  Data */& #define REG_ERROR	1		/* READ: Error */, #define REG_FEATURES	1		/* WRITE:Features *// #define REG_SEC_CNT	2		/* R/W:  Sector count */h/ #define REG_SECTOR	3		/* R/W:  Sector number */v0 #define REG_CYL_LO	4		/* R/W:  Cylinder (low) */1 #define REG_CYL_HI	5		/* R/W:  Cylinder (high) */e. #define REG_DRV_HD	6		/* R/W:  Drive / Head */( #define REG_STATUS	7		/* READ: Status */' #define REG_CMD		7		/* WRITE:Command */s  " 	/* LBA fields (read and write) */  ' #define REG_LBA_0	3		/* LBA bits 0-7 */s( #define REG_LBA_8	4		/* LBA bits 8-15 */* #define REG_LBA_16	5		/* LBA bits 16-23 */* #define REG_LBA_24	6		/* LBA bits 24-27 */   /* Device Control Register */y   enum ctl_masks {@     CTL_M_nIEN		= 0x01,		/* Interrupt enable bit for the host */6     CTL_M_SRST		= 0x02,		/* Host software reset bit */:     CTL_M_MBO		= 0x04		/* Bit 3 must always be set to 1 */ };   /* Drive/head register */    enum head_masks { 6     DRVHD_M_MBO		= 0xA0,		/* Bits 5 and 7 must be 1 */1     DRVHD_M_LBA		= 0x40		/* LBA addressing bit */  };  , /* Status (and alternate status) register */   enum sts_masks {#     STS_M_ERR	= 0x01,			/* Error */=(     STS_M_IDX	= 0x02,			/* Index mark */-     STS_M_CORR	= 0x04,			/* Corrected data */+*     STS_M_DRQ	= 0x08,			/* Data request */1     STS_M_DSC	= 0x10,			/* Drive seek complete */I/     STS_M_DWF	= 0x20,			/* Drive write fault */**     STS_M_DRDY	= 0x40,			/* Drive ready */!     STS_M_BSY	= 0x80			/* Busy */  };   /* Commands */  2 #define	CMD_READ	0x20		/* Read Sector (w/retry) */9 #define	CMD_READ_VERIFY	0x40		/* Read Verify (w/retry) */|< #define	CMD_INIT_DRV	0x91		/* Initialize drive parameters *// #define	CMD_IDENTIFY	0xec		/* Identify Drive */=) #define	CMD_SEEK	0x70		/* SEEK command */=4 #define	CMD_WRITE	0x30		/* Write Sector (w/retry) */ 1H /* Set up the table for CRAM initialization.  This table contains the	*/G /* CSR offset, the command used in this CRAM and the byte lane shift	*/0A /* value.  The byte lane shift value is computed at run time.		*/=  : typedef struct {			/* The CRAM initialization structure */#     int	cmd;				/* Command index */+(     int	offset;				/* Register offset */-     int	shift;				/* Byte lane shift count */u    } cram_item;+  4 /* Define the indices in this (and the UCB) table */   #define	RD_ALT_STS	0 #define	RD_DRV_ADDR	1r #define	WT_DEV_CTL	2 #define	RD_DATA		3 #define	WT_DATA		4 #define	RD_ERROR	5 #define	RD_SEC_CNT	6 #define	WT_SEC_CNT	7 #define	RD_SECTOR	88 #define	WT_SECTOR	9- #define	RD_CYL_LO	10 #define	WT_CYL_LO	11 #define	RD_CYL_HI	12 #define	WT_CYL_HI	13 #define	RD_DRV_HD	14 #define	WT_DRV_HD	15 #define	RD_STATUS	16 #define	WT_CMD		17  O #define	cram_def(cmd,csr) CRAMCMD$K_##cmd##32, REG_##csr, ((REG_##csr & 3) <<3)D  % cram_item	cram_init[NUMBER_CRAMS] = {+     cram_def(RDBYTE,ALT_STS),-     cram_def(RDBYTE,DRV_ADDR),     cram_def(WTBYTE,DEV_CTL),E     cram_def(RDWORD,DATA),     cram_def(WTWORD,DATA),     cram_def(RDBYTE,ERROR),+     cram_def(RDBYTE,SEC_CNT),      cram_def(WTBYTE,SEC_CNT),m     cram_def(RDBYTE,SECTOR),     cram_def(WTBYTE,SECTOR),     cram_def(RDBYTE,CYL_LO),     cram_def(WTBYTE,CYL_LO),     cram_def(RDBYTE,CYL_HI),     cram_def(WTBYTE,CYL_HI),     cram_def(RDBYTE,DRV_HD),     cram_def(WTBYTE,DRV_HD),     cram_def(RDBYTE,STATUS),     cram_def(WTBYTE,CMD)     }; dN /* Define Device-Dependent Unit Control Block with extensions for DQ device */     typedef struct {*     DT_UCB	ucb$r_dtucb;		/* Generic UCB */     union {c&         UINT	lbn;			/* Block number */         struct {*             BYTE	sec;		/* Sector number */)             BYTE	trk;		/* Track number */n,             WORD	cyl;		/* Cylinder number */
         } pa;e     } ucb$l_media;/     int		ucb$l_bcr;		/* Byte count remaining */t,     UINT	ucb$l_org_media;	/* Original LBN */9     void	*ucb$l_org_svapte;	/* Original SVAPTE address */	3     UINT	ucb$l_org_bcnt;		/* Original byte count */e4     UINT	ucb$l_org_boff;		/* Original byte offset *//     UINT	ucb$l_drv_head;		/* Drive/head info */e3     UINT	ucb$l_read_cmd;		/* Proper read command */d4     UINT	ucb$l_write_cmd;	/* Proper write command */     union {          UINT	lw;			/* Flags */         struct {.             UINT	lba : 1;	/* LBA addressing */+             UINT	dma : 1;	/* DMA capable */e         } bits;*     } ucb$l_flags;(     KPB		*ucb$ps_kpb;		/* KPB pointer */:     CRAM	*ucb$ps_crams[NUMBER_CRAMS];	/* Table of CRAMs */5     UINT	*ucb$ps_xfer;		/* Transfer buffer pointer */e6     PTE		*ucb$ps_s0_svapte;	/* Pointer to base SPTE */5     BYTE	*ucb$ps_s0_va;		/* Pointer to user buffer */c #ifdef DEBUG7     int		ucb$l_total_ints;	/* Total interrupts count */u@     int		ucb$l_unsol_ints;	/* Count of unsolicited interrupts */F     int		ucb$l_timeout[TIMEOUT_TIME+2];	/* Timeout histogram vector */ #endif
     } DQ_UCB;m  C #define ucb$r_dq_ucb ucb$r_dtucb.ucb$r_dpucb.ucb$r_erlucb.ucb$r_ucb 9 #define ucb$r_dq_erl ucb$r_dtucb.ucb$r_dpucb.ucb$r_erlucbu, #define ucb$r_dq_dp  ucb$r_dtucb.ucb$r_dpucb  #define ucb$r_dq_dt  ucb$r_dtucb  ! #define	baseucb	ucb->ucb$r_dq_ucbn s2 /* Define the Identify Drive information buffer */A /*	Use the nomember_alignment to make sure that this structure	*/n% /*	matches what the drive uses					*/*   #pragma	member_alignment	savec #pragma nomember_alignment   typedef struct {2     WORD	config;			/* Configuration information */*     WORD	cyls;			/* Number of cylinders */%     WORD	rsvd2;			/* Reserved word */E'     WORD	heads;			/* Number of heads */)5     WORD	ubytes_track;		/* Unformatted bytes/track */r7     WORD	ubytes_sector;		/* Unformatted bytes/sector */ *     WORD	sectors;		/* Number of sectors */)     WORD	unique7[3];		/* Vendor unique */*5     char	serial_number[20];	/* ASCII serial number */N(     WORD	buffer_type;		/* Buffer type */:     WORD	buffer_size_blocks;	/* Buffer size (in blocks) */5     WORD	ecc_bytes;		/* Number of ECC bytes/sector *//<     char	firmware_revision[8];	/* ASCII firmware revision */<     char	model_number[MODEL_LENGTH]; /* ASCII drive model */8     BYTE	rw_multiple;		/* Number of sectors/interrupt */+     BYTE	unique47;    		/* Vendor unique */ /     WORD	dblword_io;		/* Doubleword I/O flag */d*     WORD	capabilities;		/* Capabilities */!     WORD	rsvd50;			/* Reserved */=5     WORD	pio_cycle;		/* Programmed I/O cycle times */E.     WORD	dma_cycle;		/* DMA I/O cycle times */7     WORD	valid54_58;		/* Valid bit for next 4 fields */t4     WORD	curr_cyls;		/* 1) Current cylinder count */1     WORD	curr_heads;		/* 2) Current head count */a5     WORD	curr_sectors;		/* 3) Current sector count */-5     int		max_sectors;		/* 4) Maximum sector number */aB     WORD	multiple_sectors;	/* Current sectors/interrupt setting */;     int		lba_maxblock;		/* LBA mode maximum block number */ 4     WORD	single_word_dma;	/* Single word DMA info */3     WORD	multi_word_dma;		/* Multi word DMA info */$$     BYTE	rsvd64[64];		/* Reserved */,     BYTE	unique128[32];		/* Vendor unique */%     BYTE	rsvd160[96];		/* Reserved */d     } ID_PAGE;  #pragma	member_alignment	restore   /* Capabilities bits */S   enum cap_bits {f.     CAP_M_LBA	= 0x200,		/* Handles LBA mode */)     CAP_M_DMA	= 0x100			/* Handles DMA */n }; d  1 #define	IS_SET(reg,bits) ( (reg & bits) == bits )d0 #define	IS_CLEAR(reg,bits) ( (reg & bits) == 0 )  5 #define	$SUCCESS(code)	( (code & STS$M_SUCCESS) == 1)	2 #define	$FAIL(code)	( (code & STS$M_SUCCESS) == 0)   #define	TRUE	1 #define	FALSE	0   ; /* Prototypes for driver routines defined in this module */f   int	driver$init_tables();	E void	struc_init(CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb); G void	struc_reinit(CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb);s, int	ctrl_init(IDB *idb, DDB *ddb, CRB *crb);% int	unit_init(IDB *idb, DQ_UCB *ucb);h3 void	regdump(BYTE *buffer, int arg_2, DQ_UCB *ucb); 6 void	unit_init_fork(void *fr3, IDB *idb, DQ_UCB *ucb); void	startio(KPB *kpb);D void	isr(IDB *idb);d7 int	rct_fdt(IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb); ; int	rdstats_fdt(IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb);  int	seek(DQ_UCB *ucb); int	drvclr(DQ_UCB *ucb); int	packack(DQ_UCB *ucb);/" int	fetch_drive_info(DQ_UCB *ucb);$ int	process_drive_info(DQ_UCB *ucb); int	no_drive_info(DQ_UCB *ucb);	 int	check_geom(DQ_UCB *ucb); int	set_geom(DQ_UCB *ucb);A int	read_sector(int sector, int head, int cylinder, DQ_UCB *ucb);  int	read(DQ_UCB *ucb);G int	read_segment(DQ_UCB *ucb,int xfer_req, int *xfer_cnt,BYTE *buffer);a int	datacheck(DQ_UCB *ucb);* int	write(DQ_UCB *ucb); H int	write_segment(DQ_UCB *ucb,int xfer_req,int *xfer_cnt,int *byte_cnt); int	readrct(DQ_UCB *ucb);  int	readstats(DQ_UCB *ucb);_9 BYTE	*map_user_buffer(DQ_UCB *ucb,int offset,int length); 5 void	move_sec_from_drive(DQ_UCB *ucb, BYTE **buffer); @ void	compute_address(DQ_UCB *ucb,int *sec, int *head, int *cyl); int	unload(DQ_UCB *ucb); int	wait_ready(DQ_UCB *ucb); int	wait_busy(DQ_UCB *ucb);s int	wait_drq(DQ_UCB *ucb); int	reset_ctrl(DQ_UCB *ucb); BYTE	inp(int reg,DQ_UCB *ucb); WORD	inpw(int reg,DQ_UCB *ucb);h) void	out(int reg, BYTE data,DQ_UCB *ucb);B* void	outw(int reg, WORD data,DQ_UCB *ucb);  5 /* This should be in MMG_ROUTINES.H, but isn't yet */t    void	mmg$tbi_single(BYTE *addr);   #ifdef DEBUG0 int wfikpch_hist(KPB *kpb, int tmo, int newipl); #endif I0 /* DRIVER$INIT_TABLES - Initialize Driver Tables
 /*									*/ I /* This routine is used to initialize the driver tables.  The DPT, DDT	*/e( /* and FDT structures are set up.					*/
 /*									*/u /* Usage:								*/Y( /*	status = driver$init_tables();					*/
 /*									*/u /* Input:								*/a /*	none								*/M
 /*									*/  /* Output:								*/ /*	none								*/D
 /*									*/* /* Return value:							*/ - /*	SS$_NORMAL	tables successfully set up			*/p   int driver$init_tables()  {I  > /* Finish initialization of the Driver Prologue Table (DPT) */  =     ini_dpt_name        (&_dpt,"DQDRIVER");	/* Driver name */1=     ini_dpt_adapt       (&_dpt,AT$_ISA);	/* ISA bus device */a7     ini_dpt_flags	(&_dpt,DPT$M_SMPMOD);	/* Set flags */a5     ini_dpt_maxunits    (&_dpt,2);		/* 2 units max */i>     ini_dpt_ucbsize     (&_dpt,sizeof(DQ_UCB));	/* UCB size */D     ini_dpt_struc_init  (&_dpt,struc_init);	/* Structure init rtn */H     ini_dpt_struc_reinit(&_dpt,struc_reinit);	/* Structure reinit rtn */G     ini_dpt_ucb_crams   (&_dpt,NUMBER_CRAMS);	/* Allocate some CRAMs */a      ini_dpt_end         (&_dpt);  > /* Finish initialization of the Driver Dispatch Table (DDT) */  D     ini_ddt_ctrlinit    (&_ddt,ctrl_init);	/* Controller init rtn */>     ini_ddt_unitinit    (&_ddt,unit_init);	/* Unit init rtn */N     ini_ddt_start       (&_ddt,exe_std$kp_startio); /* Exec's Start I/O rtn */@     ini_ddt_kp_startio	(&_ddt,startio);	/* KP's Start I/O rtn */H     ini_ddt_kp_stack_size(&_ddt,KPB$K_MIN_IO_STACK); /* KP stack size */K     ini_ddt_kp_reg_mask	(&_ddt,KPREG$K_HLL_REG_MASK);/* KP register mask */ B     ini_ddt_cancel      (&_ddt,ioc_std$cancelio); /* Cancel rtn */?     ini_ddt_regdmp	(&_ddt,regdump);	/* Register dump routine */ >     ini_ddt_erlgbf	(&_ddt,ERR_BYTES);	/* Set error log size */      ini_ddt_end         (&_ddt);  @ /* Finish initialization of the Function Decision Table (FDT) */  >     ini_fdt_act(&_fdt,IO$_READLBLK,  acp_std$readblk,	DIRECT);>     ini_fdt_act(&_fdt,IO$_READPBLK,  acp_std$readblk,	DIRECT);>     ini_fdt_act(&_fdt,IO$_READVBLK,  acp_std$readblk,	DIRECT);>     ini_fdt_act(&_fdt,IO$_WRITECHECK,acp_std$readblk,	DIRECT);  ?     ini_fdt_act(&_fdt,IO$_WRITELBLK, acp_std$writeblk,	DIRECT); >     ini_fdt_act(&_fdt,IO$_WRITEPBLK, acp_std$writeblk,	DIRECT)?     ini_fdt_act(&_fdt,IO$_WRITEVBLK, acp_std$writeblk,	DIRECT);   ?     ini_fdt_act(&_fdt,IO$_ACCESS,    acp_std$access,	BUFFERED); ?     ini_fdt_act(&_fdt,IO$_CREATE,    acp_std$access,	BUFFERED);/  A     ini_fdt_act(&_fdt,IO$_DEACCESS,  acp_std$deaccess,	BUFFERED);b  ?     ini_fdt_act(&_fdt,IO$_ACPCONTROL,acp_std$modify,	BUFFERED);O?     ini_fdt_act(&_fdt,IO$_DELETE,    acp_std$modify,	BUFFERED);d?     ini_fdt_act(&_fdt,IO$_MODIFY,    acp_std$modify,	BUFFERED);   >     ini_fdt_act(&_fdt,IO$_MOUNT,     acp_std$mount,	BUFFERED);  7     ini_fdt_act(&_fdt,IO$_READRCT,   rct_fdt,		DIRECT);;:     ini_fdt_act(&_fdt,IO$_RDSTATS,   rdstats_fdt,	DIRECT);  C     ini_fdt_act(&_fdt,IO$_UNLOAD,    exe_std$lcldskvalid,BUFFERED); C     ini_fdt_act(&_fdt,IO$_AVAILABLE, exe_std$lcldskvalid,BUFFERED); C     ini_fdt_act(&_fdt,IO$_PACKACK,   exe_std$lcldskvalid,BUFFERED);_  @     ini_fdt_act(&_fdt,IO$_NOP,	     exe_std$zeroparm,	BUFFERED);A     ini_fdt_act(&_fdt,IO$_DRVCLR,    exe_std$zeroparm,	BUFFERED);*A     ini_fdt_act(&_fdt,IO$_RELEASE,   exe_std$zeroparm,	BUFFERED);r  @     ini_fdt_act(&_fdt,IO$_SEEK,      exe_std$oneparm,	BUFFERED);@     ini_fdt_act(&_fdt,IO$_FORMAT,    exe_std$oneparm,	BUFFERED);  @     ini_fdt_act(&_fdt,IO$_SETMODE,   exe_std$setchar,	BUFFERED);@     ini_fdt_act(&_fdt,IO$_SETCHAR,   exe_std$setchar,	BUFFERED);  B     ini_fdt_act(&_fdt,IO$_SENSEMODE, exe_std$sensemode,	BUFFERED);B     ini_fdt_act(&_fdt,IO$_SENSECHAR, exe_std$sensemode,	BUFFERED);     ini_fdt_end(&_fdt);e  C /* If we got this far then everything worked, so return success. */d  9     return SS$_NORMAL;			/* Return with success status */D }n h< /* STRUC_INIT - Device Data Structure Initialization Routine
 /*									*/ F /* This routine is used to initialize the data structures at driver	*/ /* loading time.							*/v
 /*									*/e /* Usage:								*/e, /*	struc_init(crb, ddb, idb, orb, ucb)				*/
 /*									*/  /* Input:								*// /*	crb	pointer to CRB						*/O /*	ddb	pointer to DDB						*/E /*	idb	pointer to IDB						*/f /*	orb	pointer to ORB						*/c /*	ucb	pointer to UCB						*/*
 /*									*/y /* Output:								*/ /*	none								*/*
 /*									*/c /* Return value:							*/  /*	none								*/7  F void struc_init(CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb) {  4 /* Initialize the fork lock and device IPL fields */  D     baseucb.ucb$b_flck = SPL$C_IOLOCK8;	/* set up fork lock index */:     baseucb.ucb$b_dipl = DEVICE_IPL;	/*  and device IPL */    /* Initialize some UCB fields */  L     baseucb.ucb$l_devchar = (DEV$M_DIR + DEV$M_FOD + DEV$M_AVL + DEV$M_ELG +L                              DEV$M_IDV + DEV$M_ODV + DEV$M_SHR + DEV$M_RND);G     baseucb.ucb$l_devchar2 = DEV$M_NNM;		/* Use "node$" device names */cE     baseucb.ucb$b_devclass = DC$_DISK; 		/* Device class is a disk */ F     baseucb.ucb$b_devtype  = DT$_GENERIC_DK;	/* Device type for DDR */=     baseucb.ucb$w_devbufsiz= BLK_SIZE;		/* Size of a block */tE     baseucb.ucb$l_devsts   = UCB$M_NOCNVRT;	/* Do NOT convert LBNs */n     return;D }r eA /* STRUC_REINIT - Device Data Structure Re-Initialization Routineu
 /*									*/uH /* This routine is used to reinitialize the data structures at driver	*/ /* reloading time.							*/e
 /*									*/  /* Usage:								*/l, /*	struc_init(crb, ddb, idb, orb, ucb)				*/
 /*									*/s /* Input:								*/n /*	crb	pointer to CRB						*/m /*	ddb	pointer to DDB						*/M /*	idb	pointer to IDB						*/; /*	orb	pointer to ORB						*/u /*	ucb	pointer to UCB						*/ 
 /*									*/0 /* Output:								*/ /*	none								*/p
 /*									*/i /* Return value:							*/l /*	none								*/n  I void struc_reinit (CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb) {	     8     ddb->ddb$ps_ddt = &_ddt;		/* Point ddb to the ddt */6     dpt_store_isr(crb, isr);		/* Set up ISR address */  %     return;				/* Return to caller */c }) (- /*	rct_fdt	- IO$_READRCT FDT Processing				*/e
 /*									*/$E /*	This routine is the FDT processing routine for the RCT function	*/ J /* code.  The LBN and size are checked and, if ok, the buffer is locked	*/5 /* down and the I/O handed off to be processed.				*/b
 /*									*/  /* Input:								*/R /*	irp	pointer to IRP						*/  /*	pcb	pointer to PCB						*/i /*	ucb	pointer to UCB						*/b /*	ccb	pointer to CCB						*/U
 /*									*/d /* Output:								*/
 /*									*/U /* Return value:							*/f> /*	SS$_FDT_COMPL	shows that the routine completed correctly	*/  8 int rct_fdt(IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb) {  , int	status;				/* Returned routine status */  B     irp->irp$l_bcnt = irp->irp$l_qio_p2;	/* Copy the byte count */:     irp->irp$l_media= irp->irp$l_qio_p3;	/* and the LBN */  < /* Check that LBN = 0 and byte count is less than 1 block */  D     if ( (irp->irp$l_bcnt <= BLK_SIZE) && (irp->irp$l_media == 0)) {9         status = exe_std$readlock(irp,pcb,(UCB *)ucb,ccb,i; 	             (void *)irp->irp$l_qio_p1,irp->irp$l_bcnt,0);t@         exe_std$qiodrvpkt(irp,(UCB *)ucb);/* Queue the packet */.         return SS$_FDT_COMPL;		/*  and exit */     } else {>         irp->irp$l_iost1 = SS$_BADPARAM; /* Load error code */5         irp->irp$l_iost2 = 0;		 /* Clear high IOSB */YA         exe_std$finishio(irp,(UCB *) ucb);/* Finish with error */_     }m  %     return SS$_FDT_COMPL;		/* exit */d }m e0 /*	rdstats_fdt	- IO$_RDSTATS FDT Processing			*/
 /*									*/D@ /*	This routine is the FDT processing routine for the RDSTATS	*/H /* function code.  If the DEBUG conditional is on, several statistics	*/E /* are returned to the caller.  Otherwise, the SS$_NODATA error is	*/r /* returned.								*/
 /*									*/( /* Input:								*/_ /*	irp	pointer to IRP						*/  /*	pcb	pointer to PCB						*/t /*	ucb	pointer to UCB						*/E /*	ccb	pointer to CCB						*/f
 /*									*/* /* Output:								*/
 /*									*/I /* Return value:							*/n> /*	SS$_FDT_COMPL	shows that the routine completed correctly	*/  < int rdstats_fdt(IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb) {  , int	status;				/* Returned routine status */) int	*bp;				/* Longword buffer pointer */_ int	i;				/* Loop counter */  8 /* Check that LBN = 0 and byte count is large enough  */   #ifdef DEBUGL     irp->irp$l_iost1 = SS$_BADPARAM;	/* Assume an error - Load error code */  J     if ( (irp->irp$l_qio_p2 >= RDSTATS_LEN) && (irp->irp$l_qio_p3 == 0)) {B         bp = (void *) irp->irp$l_qio_p1;	/* Point to the buffer */F         *bp = ucb->ucb$l_total_ints;	/* Get count of all interrupts */,         bp++;				/* Move to next longword */N         *bp = ucb->ucb$l_unsol_ints;	/* Get count of unsolicited interrupts */,         bp++;				/* Move to next longword */@         *bp = NUMBER_CRAMS;		/* Copy over the number of CRAMS */
         bp++; C         *bp = (int) ucb->ucb$ps_xfer;	/* Transfer buffer address */t
         bp++;iB         *bp = (int) ucb->ucb$ps_s0_svapte; /* Base SPTE address */
         bp++;A@         *bp = (int) ucb->ucb$ps_s0_va;	/* S0 VA (user buffer) */
         bp++;i@         *bp = TIMEOUT_TIME+2;		/* Save size of TIMEOUT vector */,         bp++;				/* Move to next location */  - 	/* Copy over the timeout histogram vector */n  4            for (i=0; i <= (TIMEOUT_TIME + 2); i++) {I            *bp = ucb->ucb$l_timeout[i];	/* Copy over the timeout count */i(            bp++;			/* Advance pointer */            }  <         irp->irp$l_iost1 = (RDSTATS_LEN << 16) + SS$_NORMAL;     }	 #elseK8     irp->irp$l_iost1 = SS$_NODATA;	/* Load error code */ #endif  0     irp->irp$l_iost2 = 0;		/* Clear high IOSB */;     exe_std$finishio(irp,(UCB *) ucb);	/* Finish the I/O */ *     return SS$_FDT_COMPL;		/*  and exit */ }r l5 /* CTRL_INIT - Controller Initialization Routine			*/s
 /*									*/nH /* This routine is used to perform controller specific initialization	*/F /* and is called by 1) system startup, 2) during driver loading and	*/+ /* 3) during power failure recovery.					*/d
 /*									*/  /* Usage:								*/E
 /*									*/d+ /*	status = ctrl_init (idb, ddb, crb)				*/I
 /*									*/n /* Input:								*/R  /*	idb	pointer to the idb					*/  /*	ddb	pointer to the ddb					*/  /*	crb	Pointer to the crb					*/
 /*									*/( /* Output:								*/ /*   None.								*/
 /*									*/_ /* Return value:							*/ C /*   status     SS$_NORMAL - unit was initialized successfully.		*/p  d/ int ctrl_init (IDB *idb, DDB *ddb, CRB *crb)  {_   #ifdef DEBUG.         ini$brk ();			/* Request breakpoint */ #endif  -     return SS$_NORMAL;			/* Return SUCCESS */_ }( d0 /* UNIT_INIT - Unit Initialization Routine				*/
 /*									*/dC /* This routine is used to perform unit specific initialization		*/,F /* and is called by 1) system startup, 2) during driver loading and	*/+ /* 3) during power failure recovery.					*/(
 /*									*/TI /* This routine does very little work.  Its primary job is to start up	*/lH /* the fork process that will do the bulk of the unit initialization.	*/
 /*									*/) /* Usage:								*/_
 /*									*/,' /*	status = unit_init (idb, ucb)					*/ 
 /*									*/d /* Input:								*/t  /*	idb	pointer to the IDB					*/  /*	ucb	pointer to the UCB					*/
 /*									*/E /* Output:								*/ /*   None.								*/
 /*									*/r /* Return value:							*/dC /*   status     SS$_NORMAL - unit was initialized successfully.		*/c  _( int unit_init (IDB *idb, DQ_UCB *ucb)  {  <     if (baseucb.ucb$v_power)		/* Is this power recovery ? */<         return SS$_NORMAL;		/* Power recovery - just exit */  <     baseucb.ucb$v_online = 0;		/* Start with unit offline */7     ucb->ucb$l_flags.lw = 0;		/* Clear all the flags */eK     ucb->ucb$l_read_cmd  = CMD_READ;	/* Default read command is 1 sector */aM     ucb->ucb$l_write_cmd = CMD_WRITE;	/* Default write command is 1 sector */   6 /* Set up drive/head bits for later use in commands */  B     ucb->ucb$l_drv_head = DRVHD_M_MBO + (baseucb.ucb$w_unit << 4);  G /* Set up and queue fork process to complete the unit initialization */m  K     baseucb.ucb$l_fpc = &unit_init_fork;/* Point to fork routine address */,M     exe_std$primitive_fork(0,(int64)idb,(FKB *) ucb);/* Start fork process */	2     return SS$_NORMAL;			/* Return with success */ }t D9 /* UNIT_INIT_FORK - Unit Initialization Fork Routine			*/t
 /*									*/ > /* This is the fork routine that does the bulk of the unit		*/  /* initialization work.							*/
 /*									*/	 /* Usage:								*/i
 /*									*/D) /*	unit_init_fork ( fr3, idb, ucb)					*/ 
 /*									*/  /* Input:								*/i, /*	fr3	Fork routine parameter (unused)				*/  /*	idb	pointer to the IDB					*/  /*	ucb	pointer to the UCB					*/
 /*									*/  /* Output:								*/ /*   None.								*/
 /*									*/  /* Return value:							*/D /*	none								*/D  7 void unit_init_fork(void *fr3, IDB *idb, DQ_UCB *ucb) {V  ) CRAM	*cram_ptr;			/* Pointer to a CRAM */ 3 int	index;				/* Index for walking the CRAM list */$! ADP	*adp;				/* Address of ADP */$? int	isa_base;        	    	/* Slot I/O address if ISA option */c9 int	device_data;  	          	/* Data from or for CRAM *//( int	status;				/* Return status value */1 int	page_cnt;			/* Number of pages to allocate */=- int	offset;				/* PTE offset in page table */ & int	csr_base;			/* Base CSR address */3 IDB	*idb_ptr;			/* CRAM IDB pointer value to use */	  1 /* Set up all of the CRAMs that were allocated */a  4     adp	= baseucb.ucb$ps_adp;		/* Get ADP address */A     cram_ptr = baseucb.ucb$ps_cram;	/* Point to the first CRAM */,  C 	/* Ok, here's a hack.  I'm going to pick up the IDB$Q_CSR value.*/t@ 	/* If it's < 0x8000, then it's treated as an offset from the	*/@ 	/* the base of ISA space.  For example, 0x1F0.  If not, it's	*/C 	/* treated as the actual VA of the base address.  This leads to	*/  	/* two cases:							*/ : 	/*	1 - ISA offset.  Clear the CRAM IDB pointer so that	*/= 	/*	    only the ADP$Q_CSR field is used.  Use the IDB CSR	*/ : 	/*	    value as the offset to the register (csr_base).	*/; 	/*	2 - VA of CSR.  Don't clear the CRAM IDB pointer, so	*/u; 	/*	    the CRAM_CMD code will use IDB$Q_CSR as the base	*/R: 	/*	    address.  Also, set csr_base to 0, as the VA is	*/9 	/*	    assumed to point directly to the base address.	*/d
 	/*								*/ > 	/* All of this allows the SYSMAN IO CONNECT command to use	*/* 	/* either value in the /CSR switch.				*/  C     if (idb->idb$q_csr > 0x8000) {	/* Check if it's in ISA space */ 8         idb_ptr= idb;			/* Use pointer to IDB in CRAM */8         csr_base = 0;			/* No base, assume correct VA */     } else {9         idb_ptr= NULL;			/* Use no IDB pointer in CRAM */C@         csr_base = idb->idb$q_csr;	/* Use the CSR as the base */     }p  M     for (index=0; cram_ptr != 0; cram_ptr = cram_ptr->cram$l_flink,index++) { I         cram_ptr->cram$l_idb = idb_ptr;	/* Set IDB pointer in the CRAM */ C         ucb->ucb$ps_crams[index] = cram_ptr;	/* Set up UCB table */t3         status = ioc$cram_cmd(cram_init[index].cmd, ?                               csr_base+cram_init[index].offset,)0                               adp, cram_ptr, 0);G         cram_ptr->cram$l_idb = idb;	/* Set the IDB pointer correctly */t9         if ($FAIL(status))		/* Check the return status */c+             return;			/* Return if error */d?         cram_ptr->cram$v_der = 1;	/* Disable error reporting *//     }e   /* Allocate transfer buffer */  @     page_cnt = ((MAX_XFER * BLK_SIZE) + (MMG$GL_PAGE_SIZE-1)) >>J                  MMG$GL_VPN_TO_VA;	/* Compute pages for MAX_XFER buffer */D     status = exe_std$alophycntg(page_cnt,(void *)&ucb->ucb$ps_xfer);     if ($FAIL(status))-         return;				/* Just exit on failure */T  O /* Allocate SPTEs for double mapping the user buffer (plus guard + spillage) */*  I     status = ldr_std$alloc_pt(page_cnt+3,(void *)&ucb->ucb$ps_s0_svapte);r     if ($FAIL(status))-         return;				/* Just exit on failure */   K /* Compute S0 address of the double map buffer.  Note that "offset" will */*K /* be the number of PTEs, not the offset from SPTBASE.  So, the shift is */	K /* page number to VA, not PTE offset to VA.  A small factor of PTE size. */p  4     offset = ucb->ucb$ps_s0_svapte - MMG$GL_SPTBASE;M     ucb->ucb$ps_s0_va = (BYTE *)((offset << MMG$GL_VPN_TO_VA) | VA$M_SYSTEM);	      /* Enable interrupts */t  E     status = ioc$node_function(baseucb.ucb$l_crb, IOC$K_ENABLE_INTR);u/     if ($FAIL(status))			/* Check status and */i.         return;				/*  simply exit if error */   #ifdef DEBUG  D /* Clear the histogram buffer counts.  Clear each entry from 0 to */C /* TIMEOUT_TIME and the overflow count at the end of the vector. */f  7     for (index = 0 ; index < TIMEOUT_TIME+2; index++) {f<         ucb->ucb$l_timeout[index] = 0;	/* Clear the count */     }    #endif  C /* Mark the device as "on line" and ready to accept I/O requests */   ;     baseucb.ucb$v_online = 1;		/* Set the unit as ONLINE */A.     return;				/*  and return to the caller */ }p  ) /* REGDUMP - Register Dump Routine					*/T
 /*									*/aJ /* This is the register dump routine.  It is used to dump the registers	*/< /* at the time of an error.  It is called at device IPL.		*/
 /*									*/  /* Input:								*//3 /*	buffer	address of buffer to store registers			*/a2 /*	arg_2	additional argument passed by caller			*/ /*	ucb	pointer to UCB						*/o
 /*									*/e /* Output:								*/ /*	none								*/r  4 void regdump(BYTE *buffer, int arg_2, DQ_UCB *ucb) {  H /* For some reason, the error packet isn't displaying well.  So, hack	*/J /* it.  Fudge the pointer based on empirical results and add "ssss" and	*/' /* "eeee" to bracket the packet.					*/K  (     buffer += 5;			/* Advance pointer */  /     *buffer++ = 's';			/* Bracket the buffer */	     *buffer++ = 's';     *buffer++ = 's';     *buffer++ = 's';  H /* Put all of the registers into the buffer.  Pad to an even longword */  3     *buffer++ = arg_2;			/* Copy over the marker */	H     *buffer++ = inp(RD_ALT_STS,ucb);	/* Get alternate status register */=     *buffer++ = inp(RD_DRV_ADDR,ucb);	/* Get drive address */i2     *buffer++ = inp(RD_ERROR,ucb);	/* Get error */;     *buffer++ = inp(RD_SEC_CNT,ucb);	/* Get sector count */	;     *buffer++ = inp(RD_SECTOR,ucb);	/* Get sector number */	C     *buffer++ = inp(RD_CYL_LO,ucb);	/* Get cylinder number (low) */pD     *buffer++ = inp(RD_CYL_HI,ucb);	/* Get cylinder number (high) */D     *buffer++ = inp(RD_DRV_HD,ucb);	/* Get drive/head information */5     *buffer++ = inp(RD_STATUS,ucb);	/* Get status  */i.     *buffer++ = 0;			/* Round up to an even *//     *buffer++ = 0;			/*  number of longwords */d  < /* Add trailer to help ID this in the unformatted packets */  7     *buffer++ = 'e';			/* Add tail of buffer bracket */      *buffer++ = 'e';     *buffer++ = 'e';     *buffer++ = 'e'; }T  & /* STARTIO - Start I/O Routine						*/
 /*									*/	H /* This is the driver start I/O routine.  This routine processes each	*/  /* of the I/O requests.							*/
 /*									*/  /* Input:								*/i0 /*	irp        Pointer to I/O request packet			*/0 /*	ucb        Pointer to unit control block			*/
 /*									*/t /* Output:								*/ /*	none								*/)   void startio(KPB *kpb) {  % int	iost1, iost2;			/* IOSB fields */c" int	temp;				/* Temporary value */$ DQ_UCB	*ucb;				/* Pointer to UCB */! IRP	*irp;				/* Pointer to IRP */	   /* Set up necessary pointers */	  :     ucb = (DQ_UCB *)kpb->kpb$ps_ucb;	/* Get UCB pointer */1     irp = kpb->kpb$ps_irp;		/* Get IRP pointer */ 6     ucb->ucb$ps_kpb = kpb;		/* Save the KPB address */  A /* Check that either volume is valid or this is a physical I/O */r  6     if ( !irp->irp$v_physio && !baseucb.ucb$v_valid) {@         ioc_std$reqcom(SS$_VOLINV,0,(UCB *)ucb);/* Finish I/O */!         return;				/* And exit */a     }   B /* Get LBN from media field.  Interpret according to PHYSIO bit */  G     ucb->ucb$l_media.lbn = irp->irp$l_media;/* Copy the disk address */EG     ucb->ucb$l_bcr = baseucb.ucb$l_bcnt;/* Copy remaining byte count */o  @     if (irp->irp$v_physio) {		/* Convert from physical format */Q         ucb->ucb$l_media.lbn = ((((ucb->ucb$l_media.pa.cyl*baseucb.ucb$b_tracks)+iS                                    ucb->ucb$l_media.pa.trk)*baseucb.ucb$b_sectors)+i>                                    ucb->ucb$l_media.pa.sec-1);     }   & /* Remember the transfer parameters */  :     ucb->ucb$l_org_media = ucb->ucb$l_media.lbn;	/* LBN */I     ucb->ucb$l_org_svapte= baseucb.ucb$l_svapte;	/* Page table address */ @     ucb->ucb$l_org_bcnt  = baseucb.ucb$l_bcnt;		/* Byte count */A     ucb->ucb$l_org_boff  = baseucb.ucb$l_boff;		/* Byte offset */*  # /* Handle based on function code */   E     iost1 = ioc$kp_reqchan(kpb,KPB$K_LOW); /* Get the data channel */u@     if ($FAIL(iost1)) {			/* Check for failure to get channel */;         ioc_std$reqcom(iost1,0,(UCB *)ucb);/* Finish I/O */.!         return;				/* And exit */r     }:         =     iost1 = SS$_ILLIOFUNC;		/* Assume illegal I/O function */,2     iost2 = 0;				/* Assume no data transferred */       switch (irp->irp$v_fcode) {f         case IO$_NOP:t9             iost1 = SS$_NORMAL;		/* Status is "normal" */ 0             break;			/*  and complete the I/O */           case IO$_AVAILABLE:D         case IO$_UNLOAD:8 	    iost1 = unload(ucb);	/* Call the unload function */0             break;			/*  and complete the I/O */           case IO$_SEEK:<             iost1 = seek(ucb);		/* Call the SEEK function */0             break;			/*  and complete the I/O */           case IO$_DRVCLR:D             iost1 = drvclr(ucb);	/* Call the DRIVE CLEAR function */0             break;			/*  and complete the I/O */           case IO$_PACKACK: 4             iost1 = packack(ucb);	/* Call PACKACK */0             break;			/*  and complete the I/O */           case IO$_WRITECHECK:         case IO$_READLBLK:         case IO$_READPBLK:>             iost1 = read(ucb);		/* Read the required blocks */7             if (IS_SET(irp->irp$l_func,IO$M_DATACHECK))eD                 iost1 = datacheck(ucb);	/*  Yes, do the datacheck */8             temp  = baseucb.ucb$l_bcnt - ucb->ucb$l_bcr;4             iost1 = (iost1 & 0xFFFF) + (temp << 16);0             break;			/*  and complete the I/O */           case IO$_WRITELBLK:C         case IO$_WRITEPBLK:d@             iost1 = write(ucb);		/* Write the required blocks */7             if (IS_SET(irp->irp$l_func,IO$M_DATACHECK)) D                 iost1 = datacheck(ucb);	/*  Yes, do the datacheck */8             temp  = baseucb.ucb$l_bcnt - ucb->ucb$l_bcr;4             iost1 = (iost1 & 0xFFFF) + (temp << 16);0             break;			/*  and complete the I/O */           case IO$_READRCT:	?             iost1 = readrct(ucb);	/* Get back the drive data */=B             iost1 = (iost1 & 0xFFFF) + (baseucb.ucb$l_bcnt << 16);C             break;                      /*  and complete the I/O */            case IO$_FORMAT:K             iost1 = SS$_UNSUPPORTED;	/* Return UNSUPPORTED error for now */S0             break;			/*  and complete the I/O */           default:             break;     }*  G /* I/O is done, release channel and return information about the I/O */   ?     ioc_std$relchan((UCB *)ucb);	/* Release the data channel */ <     ioc_std$reqcom(iost1,iost2,(UCB *)ucb);	/* Finish I/O */       return;I }p t- /* PACKACK - Perform PACKACK operation					*/*
 /*									*/rF /* This routine is used to determine information about the drive so	*// /* that is can be mounted and put to use.				*/*
 /*									*/* /* Input:								*/f /*	ucb	pointer to UCB						*/X
 /*									*/  /* Output:								*/ /*	none								*/ 
 /*									*/O /* Return value:							*/A /*	status value							*/ /*		SS$_NORMAL - success					*/(4 /*		SS$_NODATA - failed to get drive information		*/   int packack(DQ_UCB *ucb) {  * int	status;				/* Routine return status */" int	orig_ipl;			/* Original IPL */! BYTE	err;				/* Error register */r  F /* Get the drive info.  If it fails, do it manually.  Else, process */ /* the data */  B     status = fetch_drive_info(ucb);	/* Get the drive infrmation *//     if ($FAIL(status)) {		/* If it fails ... */*>         status = no_drive_info(ucb);	/* Try it the hard way */9         if ($FAIL(status)) {		/* If that fails, too... */ 1             return status;		/* exit with error */b	         }_     } else {E         status = process_drive_info(ucb);/* Process the drive info */A3         if ($FAIL(status))		/* If that failed... */ 3             return status;		/*   exit with error */$  E 	/* Validate the geometry and if invalid, determine it empirically */   :         status = check_geom(ucb);	/* Check the geometry */3         if ($FAIL(status))		/* Check for success */ M             status = no_drive_info(ucb);/*  Failed - determine it manually */*     }   E /* Done.  Set the drive as valid and return to caller with success */l  6     if ($SUCCESS(status)) 		/* If all is well, then */:         baseucb.ucb$v_valid = 1;	/*   set the VALID bit */  <     return SS$_NORMAL;			/* Return to caller with success */ }  IJ /* fetch_drive_info - This routine is used to read the drive information*/ /* page.								*/
 /*									*/	 /* Input:								*/s  /*	ucb	pointer to the UCB					*/
 /*									*/h /* Output:								*/ /*	none								*/r
 /*									*/  /* Status:								*/ /*	SS$_NORMAL	success						*/** /*	SS$_NODATA	error reading the page				*/$ /*	SS$_TIMEOUT	device timeout					*/  # int fetch_drive_info(DQ_UCB *ucb) {t  * int	status;				/* Routine return status */" int	orig_ipl;			/* Original IPL */  . /* Wait for drive to be ready for a command */  ?     status = wait_ready(ucb);		/* Wait for drive to be ready */,;     if ($FAIL(status))			/* Check the status for failure */s0         return status;			/* Return with error */  6 /* Select the drive, then ask for drive information */  A 	/* Obtain devicelock and write registers and send the command */   9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl);lI     out(WT_DRV_HD,ucb->ucb$l_drv_head,ucb); /* Select drive and head 0 */e:     out(WT_CMD,CMD_IDENTIFY,ucb);	/* Ask for drive info */  8 /* Wait for the interrupt and all that goes with that */  <     status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  > /* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */I /*  else, if other error, then use DEVICE UNLOCK and return with error */,        if (status == SS$_TIMEOUT) {@         erl_std$devictmo(0,(UCB *)ucb);	/* Handle the timeout */:         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);6         return SS$_TIMEOUT;		/* Return with timeout */     } else if ($FAIL(status)) {e?         device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);	1         return status;			/* Return with status */      }    /* Drop back to fork IPL */l  6     status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);   /* Check the error status.  */  0     if ( IS_SET(inp(RD_ALT_STS,ucb),STS_M_ERR) ).         return SS$_NODATA;		/* Return error */  
 /* Success */u  -     return SS$_NORMAL;			/* Return success */e }t  G /* process_drive_info - This routine is used to read and process the	*/	9 /* information returned by the drive in the ID page.			*/o
 /*									*/q /* Input:								*/u  /*	ucb	pointer to the UCB					*/
 /*									*/	 /* Output:								*/ /*	none								*/	
 /*									*/o /* Status:								*/ /*	SS$_NORMAL	success						*/   % int process_drive_info(DQ_UCB *ucb) {u  ' #include	<dtndef>		/* Define the DTN */   7 char	model[DTN$K_NAMELEN_MAX+1];	/* ASCIZ model name */o+ int	mod_len;			/* Length of model string */_/ ID_PAGE	*id_ptr;			/* Pointer to the ID page */_$ DTN	*dtn;				/* Dummy DTN pointer */, int	status;				/* Returned routine status */ int	i;				/* String index */% WORD	datal, datah;			/* Data words */r& BYTE	*xfer;				/* Pointer to buffer */  C /* Read the data from the sector buffer into the transfer buffer */F  H     xfer = (BYTE *) ucb->ucb$ps_xfer;	/* Point to the transfer buffer */8     move_sec_from_drive(ucb,&xfer);	/* Get the sector */  A     id_ptr=(ID_PAGE *)ucb->ucb$ps_xfer;	/* Get ID Page pointer */   C /* Do some simple checks on the geometry to make sure its' valid */o  G     if ( (id_ptr->sectors > MAX_SECTOR) || /* Check too many sectors */ @          (id_ptr->heads > MAX_HEAD) ||	/*  and too many heads */;          (id_ptr->sectors == 0) ||	/* or too few sectors */i7          (id_ptr->heads == 0) ||	/* or too few heads */ :          (id_ptr->cyls == 0) )		/* or too few cylinders */6         return SS$_IVADDR;		/* Sanity failed - exit */  ( /* Copy over the geometry information */  C     baseucb.ucb$b_sectors  = id_ptr->sectors;	/* Set the sectors */ =     baseucb.ucb$b_tracks   = id_ptr->heads;	/*  and tracks */ @     baseucb.ucb$w_cylinders= id_ptr->cyls;	/*   and cylinders */7     ucb->ucb$r_dq_dt.ucb$l_maxblock = id_ptr->sectors *o,                              id_ptr->heads *>                              id_ptr->cyls;	/*    and MAXLBN */  8     set_geom(ucb);			/* Set the geometry in the drive */  8 /* Set up for proper read/write command and I/O sizes */  =     ucb->ucb$l_read_cmd  = CMD_READ;	/*  Single block read */i@     ucb->ucb$l_write_cmd = CMD_WRITE;	/*   and write commands */       * /* Set flags based on capabilities flag */  6     ucb->ucb$l_flags.bits.lba = 0;	/* Assume no LBA */6     ucb->ucb$l_flags.bits.dma = 0;	/* Assume no DMA */  F     if (IS_SET(id_ptr->capabilities,CAP_M_LBA)) { /* If LBA capable */>         ucb->ucb$l_flags.bits.lba = 1;		/* Set the LBA flag */     }m  F     if (IS_SET(id_ptr->capabilities,CAP_M_DMA)) { /* If DMA capable */>         ucb->ucb$l_flags.bits.dma = 1;		/* Set the DMA flag */     }h   /* Add the device type name */  L /* Ok, this is brain damaged, but we have to do it.  Each of the bytes in */; /* the ASCII string is byte swapped.  So, swap them back */$  0     mod_len =(MODEL_LENGTH>DTN$K_NAMELEN_MAX) ? N               DTN$K_NAMELEN_MAX : MODEL_LENGTH; /* Set the length of string */  I     for (i=0; i < (mod_len>>1)<<1; i += 2) { /* Copy the swapped bytes */ -         model[i] = id_ptr->model_number[i+1];b-         model[i+1] = id_ptr->model_number[i];c     }A  C     if ( (mod_len & 1) == 1)		/* Get the odd last byte if needed */a9         model[mod_len-1] = id_ptr->model_number[mod_len];$  7     model[mod_len] = '\0';		/* Make the string ASCIZ */;  ! /* Now, remove trailing spaces */t  !     for (i=1; i < mod_len; i++) {E>         if (model[mod_len - i] != ' ')	/* Is this a space ? */1             break;			/* Non-space - leave loop */ B         model[mod_len - i] = '\0';	/* Terminate string at space */     }h  6     mod_len = strlen(model);		/* Get the new length */  F /* Now, add the device type and name for Dynamic Device Recognition */  @     status = ioc$add_device_type(model,mod_len,(UCB *)ucb,&dtn);E     baseucb.ucb$b_devtype = DT$_GENERIC_DK;	/* Device type for DDR */t  7     return SS$_NORMAL;			/* Return success to caller */F }+ aI /* no_drive_info - This routine is used to determine information about	*/oE /* the drive when the IDENTIFY_DRIVE command isn't supported.  The	*/_6 /* geometry is calculated from a number of reads.			*/
 /*									*/; /* Input:								*/h  /*	ucb	pointer to the UCB					*/
 /*									*/  /* Output:								*/ /*	none								*/ 
 /*									*/r /* Status:								*/ /*	SS$_NORMAL	success						*/*    int no_drive_info(DQ_UCB *ucb) {  / int	status;				/* Return status from routine */F( int	sector;				/* Trial sector number */$ int	head;				/* Trial head number */' int	cyl;				/* Trial cylinder number */u& int	drv_head;			/* Drive/head value */1 int	low,high;			/* Cylinders for binary search */e* BYTE	err;				/* Error register contents */  @     if (!(status = wait_ready(ucb)))	/*  Wait for drive ready */0         return status;			/* Return with error */  $ /* Clear the geometry information */  8     baseucb.ucb$b_sectors  = 0;		/* Clear the sectors */2     baseucb.ucb$b_tracks   = 0;		/*  and tracks */6     baseucb.ucb$w_cylinders= 0;		/*   and cylinders */;     ucb->ucb$r_dq_dt.ucb$l_maxblock = 0;/*    and MAXLBN */e  / /* Determine the number of sectors per track */dB /*	Read each sector on head 0, cylinder 0 until an error occurs */  6     for (sector = 1; sector <= MAX_SECTOR; sector++) {M         status = read_sector(sector,0,0,ucb); /* Try a read of this sector */;.         if ($FAIL(status))		/* Check status */+             break;			/* At failure, exit */          elseB             baseucb.ucb$b_sectors++;	/* Else, bump sector count */     }p  1 /* Determine the number of tracks per cylinder */ C /*	Read each track on sector 1, cylinder 0 until an error occurs */u  -     for (head = 0; head < MAX_HEAD; head++) {a<         status = read_sector(1,head,0,ucb); /* Try a read */2         if ($FAIL(status))		/* Check the status */0             break;			/* If failure, exit loop */         else?             baseucb.ucb$b_tracks++;	/* Else, bump head count */      }y  ' /* Determine the number of cylinders */vB /*	Perform a binary search by reading cylinders with head 0 and	*/? /*	sector 1 until the highest cylinder number is determined.	*/;  C     sector = baseucb.ucb$b_sectors;	/* Get highest sector number */lB     head   = baseucb.ucb$b_tracks-1;	/* Get highest head number */  &     low = 1;				/* Set low boundary */4     high=MAX_CYLINDER;			/* Set the high boundary */0     while (high >= 1) {			/* Loop until found */>         cyl = (low + high) >> 1;	/* Pick the middle to read */K         status = read_sector(sector,head,cyl,ucb);/* Issue the test read */ 5         if ($FAIL(status)) {		/* Check for success */ :             if (high <= low) {		/* Are we down to LOW ? */5                 cyl--;			/* Cylinder is 1 too high */ *                 break;			/*  Yes - exit */ 	    }:             high= cyl - 1;		/*  Failed - lower the high */         } else {7             if (low >= high)		/* Are we at the end ? */ 2                 break;			/*  Yes, just bail out */6             low = cyl + 1;		/* No, raise the bottom */
             } 	         }e  % /* Update the geometry information */e  D     baseucb.ucb$w_cylinders = cyl + 1;	/* Set number of cylinders */=     ucb->ucb$r_dq_dt.ucb$l_maxblock = baseucb.ucb$b_sectors *u<                                       baseucb.ucb$b_tracks *>                                       baseucb.ucb$w_cylinders;  2     return SS$_NORMAL;			/* Return with success */ }I IF /* check_geom - this routine is used to verify that the geometry is	*/G /* correct.  Reads for the last block on the higest cylinder and the	*/tE /* highest+1 cylinders are done.  If the maximum LBN fails, or the	*/ = /* maximum cyl + 1 succeed, then the geometry is suspect.		*/K
 /*									*/  /* Input:								*/T  /*	ucb	pointer to the UCB					*/
 /*									*/L /* Output:								*/ /*	none								*/c
 /*									*/i /* Status:								*/+ /*	SS$_NORMAL	success, geometry is ok				*/s+ /*	SS$_BADPARAM	geometry is incorrect				*/    int check_geom(DQ_UCB *ucb) {c  " int	sector;				/* Sector number */ int	head;				/* Head number */! int	cyl;				/* Cylinder number */)2 int	status;				/* Status returned from routines */  ' /* Attempt to read the maximum block */	  B     sector= baseucb.ucb$b_sectors;	/* Use highest sector number */C     head  = baseucb.ucb$b_tracks - 1;	/* Use highest head number */iI     cyl   = baseucb.ucb$w_cylinders - 1;/* Use highest cylinder number */t  A     status = read_sector(sector,head,cyl,ucb); /* Try the read */	0     if ($FAIL(status))			/* Check for success */C         return SS$_BADPARAM;		/* It failed - return with failure */u  S /* Attempt to read the end of the next cylinder.  Return an error if this works. */I  1     cyl++;				/* Point to nonexistent cylinder */tA     status = read_sector(sector,head,cyl,ucb);	/* Try the read */n2     if ($SUCCESS(status))		/* Check for success */D         return SS$_BADPARAM;		/*  It worked - return with failure */  2     return SS$_NORMAL;			/* Return with success */ }e /H /* set_geom - this routine is used to set the current geometry in the	*/ /* drive.								*/ 
 /*									*/r /* Input:								*/n  /*	ucb	pointer to the UCB					*/
 /*									*/) /* Output:								*/ /*	none								*/P
 /*									*/p /* Status:								*/+ /*	SS$_NORMAL	success, geometry is ok				*/h+ /*	SS$_BADPARAM	geometry is incorrect				*/    int set_geom(DQ_UCB *ucb) {T  " int	sector;				/* Sector number */ int	head;				/* Head number */! int	cyl;				/* Cylinder number */ ( int	drv;				/* Drive/head information */2 int	status;				/* Status returned from routines */" int	orig_ipl;			/* Original IPL */ BYTE	sts;				/* Status CSR */e BYTE	err;				/* Error CSR */  ' /* Attempt to read the maximum block */   B     sector= baseucb.ucb$b_sectors;	/* Use highest sector number */W     drv   = ucb->ucb$l_drv_head+(baseucb.ucb$b_tracks-1); /* Use highest head number */*I     cyl   = baseucb.ucb$w_cylinders - 1;/* Use highest cylinder number */d  @ /* Obtain devicelock and write registers and send the command */  9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl); 8     out(WT_SEC_CNT,sector,ucb);		/* Set sectors/track */5     out(WT_DRV_HD,drv,ucb);		/* Set heads/cylinder */t@     out(WT_CMD,CMD_INIT_DRV,ucb);	/* Set the drive parameters */  8 /* Wait for the interrupt and all that goes with that */  <     status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  > /* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */I /*  else, if other error, then use DEVICE UNLOCK and return with error */         if (status == SS$_TIMEOUT) {G         erl_std$devictmo(1,(UCB *)ucb);	/* Handle the device timeout */l:         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);6         return SS$_TIMEOUT;		/* Return with timeout */     } else if ($FAIL(status)) {a?         device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);v0         return status;			/* Return with error */     }h   /* Drop back to fork IPL */s  6     status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);   /* Check the error status */  ;     sts = inp(RD_STATUS,ucb);		/* Get the current status */ :     if ( IS_SET(sts,STS_M_ERR) ) {	/* Check for ERR bit */9         err = inp(RD_ERROR,ucb);	/* Get the error code */s6         return SS$_IVADDR;		/*  and return an error */     }o  5     if (IS_CLEAR(sts,STS_M_DRDY)) 	/* If not READY */(:         return SS$_DRVERR;		/*  return with DRIVE ERROR */  2     return SS$_NORMAL;			/* Return with success */ }$  J /* read_sector - this routine is used to perform a simple read.  No data*/I /* is transferred to any buffers.  The routine simply tests whether or	*/[< /* not a read may be performed to a particular address.			*/
 /*									*/c /* Input:								*/  /*	sector	sector number						*// /*	head	head number						*//" /*	cylinder cylinder number					*/  /*	ucb	pointer to the UCB					*/
 /*									*/  /* Output:								*/ /*	none								*/e
 /*									*/  /* Status:								*/ /*	SS$_NORMAL	success						*/)) /*	SS$_IVADDR	failed to read sector				*/_8 /*	SS$_TIMEOUT	timeout (lower level routine failure)		*/9 /*	SS$_DRVERR	drive error (not ready after operation)		*/v  B int read_sector(int sector, int head, int cylinder, DQ_UCB *ucb) {  / int	status;				/* Routine return status code */o! BYTE	err;				/* Error register */u BYTE	sts;				/* Status CSR */	/ int	drv_head;			/* Drive/head register value */p" int	orig_ipl;			/* Original IPL */+ int	index;				/* Index for flushing data */ 3 WORD	data;				/* Dummy for storing data CSR word */	  . /* Wait for drive to be ready for a command */  @     if (!(status = wait_ready(ucb)))	/*  Wait for drive ready */0         return status;			/* Return with error */  ! /* Select and set up the drive */l  <     if (sector >= MAX_SECTOR)		/* Check the sector number */>         return SS$_IVADDR;		/* Return invalid address error */6     if (head >= MAX_HEAD)		/* Check the head number */>         return SS$_IVADDR;		/* Return invalid address error */  I     drv_head = ucb->ucb$l_drv_head+head;/* Compute drive and head info */e  @ /* Obtain devicelock and write registers and send the command */  9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl);=<     out(WT_DRV_HD,drv_head,ucb);	/* Select drive and head */2     out(WT_SEC_CNT,1,ucb);		/* Ask for 1 sector */>     out(WT_SECTOR,sector,ucb);		/* Put in the sector number */>     out(WT_CYL_LO,cylinder,ucb);	/* Low order cylinder bits */B     out(WT_CYL_HI,cylinder>>8,ucb);	/* High order cylinder bits */E     out(WT_CMD,CMD_READ_VERIFY,ucb);	/* Attempt to read the sector */e  8 /* Wait for the interrupt and all that goes with that */  <     status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  > /* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */I /*  else, if other error, then use DEVICE UNLOCK and return with error */u        if (status == SS$_TIMEOUT) {G         erl_std$devictmo(2,(UCB *)ucb);	/* Handle the device timeout */a:         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);6         return SS$_TIMEOUT;		/* Return with timeout */     } else if ($FAIL(status)) {$?         device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);t0         return status;			/* Return with error */     }    /* Drop back to fork IPL */n  6     status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);  3 /* Throw away the sector to keep the drive happy */G  4     for (index = 0; index < (BLK_SIZE/2); index++) {2         data = inpw(RD_DATA,ucb);	/* Get a word */     }	   /* Check the error status */  ;     sts = inp(RD_STATUS,ucb);		/* Get the current status */=:     if ( IS_SET(sts,STS_M_ERR) ) {	/* Check for ERR bit */9         err = inp(RD_ERROR,ucb);	/* Get the error code */e6         return SS$_IVADDR;		/*  and return an error */     }f  5     if (IS_CLEAR(sts,STS_M_DRDY)) 	/* If not READY */ :         return SS$_DRVERR;		/*  return with DRIVE ERROR */  2     return SS$_NORMAL;			/* Return with success */ }  r' /* seek - Perform SEEK operation					*/ 
 /*									*/ D /* IDE drives will return immediately upon issuing the first seek	*/E /* command.  Subsequent commands will actually wait until the seek	*/YG /* is completed.  This routine issues only one seek command and then	*/ J /* completes the I/O.  Any subsequent command will be stalled until the	*/ /* seek is completed.							*/
 /*									*/u /* Input:								*/  /*	ucb	pointer to UCB						*/l
 /*									*/c /* Output:								*/ /*	status value							*/" /*		SS$_NORMAL	seek complete				*/   int seek(DQ_UCB *ucb) {   $ int	status;				/* Status of calls */" int	orig_ipl;			/* Original IPL */! int	cyl;				/* Cylinder number */s BYTE	sts;				/* Status CSR */  BYTE	err;				/* Error CSR */  @     if (!(status = wait_ready(ucb)))	/*  Wait for drive ready */0         return status;			/* Return with error */   /* Set up seek parameters */  >     cyl = ucb->ucb$l_media.lbn;		/* Get the cylinder number */  @ /* Obtain devicelock and write registers and send the command */  9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl); G     out(WT_DRV_HD,ucb->ucb$l_drv_head,ucb);	/* Select drive and head */$9     out(WT_SECTOR,1,ucb);		/* Put in the sector number */_:     out(WT_CYL_LO,cyl,ucb);		/* Low order cylinder bits */>     out(WT_CYL_HI,cyl>>8,ucb);		/* High order cylinder bits */B     out(WT_CMD,CMD_SEEK,ucb);		/* Attempt to seek to the sector */  8 /* Wait for the interrupt and all that goes with that */  <     status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  > /* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */I /*  else, if other error, then use DEVICE UNLOCK and return with error */r        if (status == SS$_TIMEOUT) {G         erl_std$devictmo(3,(UCB *)ucb);	/* Handle the device timeout */S:         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);6         return SS$_TIMEOUT;		/* Return with timeout */     } else if ($FAIL(status)) {y?         device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);e0         return status;			/* Return with error */     }S   /* Drop back to fork IPL */u  6     status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);   /* Check the status */  8     sts = inp(RD_STATUS,ucb);		/* Get the status byte */?     if (IS_SET(sts,STS_M_ERR) ) {	/* Check for ERROR setting */h9         err = inp(RD_ERROR,ucb);	/* Get the error byte */	@         return SS$_DRVERR;		/* Return with DRIVE ERROR status */     }	  2     return SS$_NORMAL;			/* Return with success */ }	  / /* DRVCLR - Perform Drive Clear operation				*/S
 /*									*/m /* Input:								*/* /*	ucb	pointer to UCB						*/ 
 /*									*/r /* Output:								*/ /*	status value							*/   int drvclr(DQ_UCB *ucb) {n       return SS$_NORMAL; }* i5 /* read - Performs IO$_READxBLK driver function				*/e
 /*									*/ H /* This routine issues READ commands to the drive.  This routine will	*/I /* break up the request into segments of not more than 127 sectors per	*/  /* command.								*/_
 /*									*/  /* Input:								*/  /*	ucb	pointer to UCB						*/h
 /*									*/b /* Output:								*/ /*	status value							*/   int read(DQ_UCB *ucb) {i  ( int	xfer_size;			/* Size (in sectors) */3 int	xfer_cnt;			/* Number of sectors transferred */ $ int	base_lbn;			/* Index for read */+ int	byte_cnt;			/* Number of bytes moved */u1 int	xfer_req;			/* Number of sectors requested */ * int	status;				/* Routine return status */( int	retry_cnt;			/* Error retry count */, int	buf_ofs;			/* Offset into user buffer */3 BYTE	*user_va;			/* Returned user buffer address */   . /* Wait for drive to be ready for a command */  9     status = wait_ready(ucb);		/* Wait for drive ready */O5     if ($FAIL(status))			/* Check status for error */ 0         return status;			/* Return with error */  ) /* Compute number of blocks and set up */1  ?     xfer_size = (baseucb.ucb$l_bcnt + BLK_SIZE-1) >> BLK_SHIFT;e:     if (xfer_size == 0)			/* Was there any work to do ? */:         return SS$_NORMAL;		/* Exit with success if not */  N /* Loop over each segment.  BASE_LBN increments by MAX_XFER blocks per loop */  2     retry_cnt = 0;			/* Clear the retry counter *//     for (base_lbn = 0; base_lbn < xfer_size;) {kD         xfer_req = xfer_size-base_lbn;	/* Compute sectors to read */O         status = read_segment(ucb,xfer_req,&xfer_cnt,(BYTE *)ucb->ucb$ps_xfer);t   	/* Check the status. */6 	/* On success - clear the retry count and continue */A 	/* On error - if the xfer_cnt is non-zero, then we are making	*/o> 	/*	progress, so just continue.  If the xfer_cnt is 0, then	*/; 	/*	we are losing ground.  Retry for a while, then reset	*/O2 	/*	and then try some more.  Finally, give up.		*/           if ($FAIL(status)) {              if (xfer_cnt == 0) {6                 retry_cnt++;		/* Update retry count */-                 if (retry_cnt == MAX_RETRY/2)*:                     reset_ctrl(ucb);	/* Attempt a reset */N                 if (retry_cnt > MAX_RETRY) /* Were there too many retries ? */=                     return status;	/* Yes, exit with error */b
             }          } else {?             if (xfer_cnt > 0)		/* Was any data transferred ? */ G                 retry_cnt = 0;		/* Clear retry count on each success */l	         }s  =         if (xfer_cnt == 0)		/* Check that we got something */)>             return status;		/* Just exit with status if not */  G 	/* This segment is now in the transfer buffer.  Move it to the user */n  O         byte_cnt = xfer_cnt << BLK_SHIFT; /* Get byte count for this segment */ A         if (byte_cnt > ucb->ucb$l_bcr) 	/* Check for too large */t8             byte_cnt = ucb->ucb$l_bcr;	/* Minimize it */  K         buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE;SN         user_va = map_user_buffer(ucb,buf_ofs,byte_cnt); /* Map user buffer */2         memcpy(user_va,ucb->ucb$ps_xfer,byte_cnt);  " 	/* Update transfer information */  ?         ucb->ucb$l_bcr -= byte_cnt;	/* Update the byte count */ ;         ucb->ucb$l_media.lbn += xfer_cnt;/* Bump the LBN */$<         base_lbn += xfer_cnt;		/* Update the block number */     }D  2     return SS$_NORMAL;			/* Return with success */ }; *) /* read_segment - read one segment					*/_
 /*									*/$J /* This routine performs the read of a single I/O segment.  Each segment*/E /* is a single read command of not more the MAX_XFER sectors.  The	*/cJ /* overall read I/O routine calls this routine for each of the segments	*/- /* until the entire read is completed.					*/	
 /*									*/c /* Input:								*/C /*	ucb		pointer to UCB					*/ 6 /*	xfer_req	number of blocks remaining to transfer		*/6 /*	buffer		address of buffer to transfer data into		*/
 /*									*/r /* Output:								*/3 /*	xfer_cnt	actual count of sectors transferred		*/a /*	status value							*/  G int read_segment(DQ_UCB *ucb,int xfer_req,int *xfer_cnt,BYTE *buffer) {u  ; int	sec, head, cyl;			/* Disk location (sector/head/cyl) */O/ int	drv_head;			/* Drive/head register value */e/ int	int_cnt;			/* Interrupt (sector) counter */r/ BYTE	*xfer;				/* Pointer to transfer buffer */)1 int	status;				/* Returned status from routine */l int	orig_ipl;			/* Saved IPL */  BYTE	sts;				/* Status CSR */s BYTE	err;				/* Error CSR */% WORD	datal, datah;			/* Input data */u1 BYTE	*user_va;			/* Mapped user buffer address */i0 int	buf_ofs;			/* Offset to start of transfer */1 int	buf_len;			/* Length of user buffer to map *//   /* Set up for the transfer */I  9     *xfer_cnt = 0;			/* Set "sectors transferred" to 0 */b>     status = SS$_BADPARAM;		/* Init status to weird failure */7     drv_head= ucb->ucb$l_drv_head;	/* Get drive info */ 7     if (xfer_req > MAX_XFER)		/* Check for too large */*<         xfer_req = MAX_XFER;		/*  and minimize if too big */9     if (ucb->ucb$l_flags.bits.lba)	/* If LBA mode, ... */)6         drv_head |= DRVHD_M_LBA;	/* Set the LBA bit */H     compute_address(ucb,&sec,&head,&cyl); /* Compute physical address */  0 /* Obtain device lock and ask for the sectors */  9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl); A     out(WT_DRV_HD,drv_head|head,ucb);	/* Select drive and head */t;     out(WT_SEC_CNT,xfer_req,ucb);	/* Ask for "n" sectors */ ;     out(WT_SECTOR,sec,ucb);		/* Put in the sector number */i:     out(WT_CYL_LO,cyl,ucb);		/* Low order cylinder bits */>     out(WT_CYL_HI,cyl>>8,ucb);		/* High order cylinder bits */H     out(WT_CMD,ucb->ucb$l_read_cmd,ucb);/* Attempt to read the sector */  J /* Now, wait for each of the interrupts that will come with each sector */  4     xfer = buffer;				/* Point to transfer buffer */6     for (int_cnt = 0; int_cnt < xfer_req; int_cnt++) {@         status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  > /* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */D /*  else, if other error, then use DEVICE UNLOCK and return error */  $         if (status == SS$_TIMEOUT) {K             erl_std$devictmo(4,(UCB *)ucb);	/* Handle the device timeout */v5             exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);o;             break;			/* Exit the loop with STATUS intact */m#         } else if ($FAIL(status)) { C             device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);/(             break;			/* Exit the loop */	         }i  B /* Read STATUS (dismissing interrupt) and drop back to fork IPL */  ;         sts = inp(RD_STATUS,ucb);	/* Get the status byte */u:         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);  = /* Get the data from the silo and into the transfer buffer */b  8         *xfer_cnt += 1;			/* Increment sector counter */G         move_sec_from_drive(ucb,&xfer);	/* Get sector from the drive *//  ) /* Check the status (saved from above) */O  B         if (IS_SET(sts,STS_M_ERR) ) { 	/* If there was an error */=            err = inp(RD_ERROR,ucb);	/*  get the error byte */K;            status = SS$_DRVERR;		/* Set the error status */{,            break;			/*  and exit the loop */	         }e  = /* All is well for this sector - set the status to success */K  8         status = SS$_NORMAL;		/* Set "success" status */     }   +     return status;			/* Exit with status */e }l (B /* datacheck - Performs data check function for read and write		*/ /* requests.								*/
 /*									*/D /* Input:								*/* /*	ucb	pointer to UCB						*/u
 /*									*/( /* Output:								*/ /*	status value							*/ /*		SS$_NORMAL - success					*/h/ /*		SS$_DATACHECK - data failed to compare			*/    int datacheck(DQ_UCB *ucb) {  ( int	xfer_size;			/* Size (in sectors) */3 int	xfer_cnt;			/* Number of sectors transferred */r$ int	base_lbn;			/* Index for read */+ int	byte_cnt;			/* Number of bytes moved */c1 int	xfer_req;			/* Number of sectors requested */r* int	status;				/* Routine return status */( int	retry_cnt;			/* Error retry count */, int	buf_ofs;			/* Offset into user buffer */3 BYTE	*user_va;			/* Returned user buffer address */e  5 /* First, reset all the parameters that we'll need */   >     ucb->ucb$l_bcr = ucb->ucb$l_org_bcnt;	/* Get byte count */L     ucb->ucb$l_media.lbn = ucb->ucb$l_org_media;/* Get first block number */B     baseucb.ucb$l_bcnt = ucb->ucb$l_org_bcnt;	/* Get byte count */B     baseucb.ucb$l_svapte = ucb->ucb$l_org_svapte; /* Get SVAPTE */<     baseucb.ucb$l_boff = ucb->ucb$l_org_boff;	/* Get BOFF */  . /* Wait for drive to be ready for a command */  ?     status = wait_ready(ucb);		/* Wait for drive to be ready */a2     if ($FAIL(status))			/* Check return status */1         return status;			/*  and exit on error */f  ) /* Compute number of blocks and set up */   ?     xfer_size = (baseucb.ucb$l_bcnt + BLK_SIZE-1) >> BLK_SHIFT;o:     if (xfer_size == 0)			/* Was there any work to do ? */:         return SS$_NORMAL;		/* Exit with success if not */  2     retry_cnt = 0;			/* Clear the retry counter */  M /* Loop over each segment. BASE_LBN increments by MAX_XFER blocsk per loop *//  /     for (base_lbn = 0; base_lbn < xfer_size;) {;D         xfer_req = xfer_size-base_lbn;	/* Compute sectors to read */O         status = read_segment(ucb,xfer_req,&xfer_cnt,(BYTE *)ucb->ucb$ps_xfer);f   	/* Check the status. */6 	/* On success - clear the retry count and continue */A 	/* On error - if the xfer_cnt is non-zero, then we are making	*/c> 	/*	progress, so just continue.  If the xfer_cnt is 0, then	*/; 	/*	we are losing ground.  Retry for a while, then reset	*/ 2 	/*	and then try some more.  Finally, give up.		*/           if ($FAIL(status)) {              if (xfer_cnt == 0) {6                 retry_cnt++;		/* Update retry count */-                 if (retry_cnt == MAX_RETRY/2)t:                     reset_ctrl(ucb);	/* Attempt a reset */N                 if (retry_cnt > MAX_RETRY) /* Were there too many retries ? */=                     return status;	/* Yes, exit with error */w
             }t         } else {?             if (xfer_cnt > 0)		/* Was any data transferred ? */sG                 retry_cnt = 0;		/* Clear retry count on each success */U	         }   - 	/* This segment is now in the xfer buffer */T  @         byte_cnt = xfer_cnt<<BLK_SHIFT;	/* Compute byte count */@         if (byte_cnt > ucb->ucb$l_bcr)	/* Check for too large */8             byte_cnt = ucb->ucb$l_bcr;	/* Minimize it */  * 	/* Compare xfer buffer and user buffer */  K         buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE; R         user_va = map_user_buffer(ucb,buf_ofs,byte_cnt);	/* Map the user buffer */;         status = memcmp(ucb->ucb$ps_xfer,user_va,byte_cnt); 8         if (status != 0)		/* Check comparison results */G             return SS$_DATACHECK;	/* Failed - return DATACHECK error */s  ! 	/* Update transfer parameters */   ?         ucb->ucb$l_bcr -= byte_cnt;	/* Update the byte count */y;         ucb->ucb$l_media.lbn += xfer_cnt;/* Bump the LBN */ <         base_lbn += xfer_cnt;		/* Update the block number */       }u  2     return SS$_NORMAL;			/* Return with success */ }   7 /* write - Performs IO$_WRITExBLK driver functions			*/a
 /*									*// /* Input:								*/_ /*	ucb	pointer to UCB						*/ 
 /*									*/a /* Output:								*/ /*	status value							*/   int write(DQ_UCB *ucb) {  ( int	xfer_size;			/* Size (in sectors) */3 int	xfer_cnt;			/* Number of sectors transferred */f$ int	base_lbn;			/* Index for read */- int	byte_cnt;			/* Number of bytes written */w1 int	xfer_req;			/* Number of sectors requested */s# int	status;				/* Routine status */i$ int	retry_cnt;			/* Retry counter */  . /* Wait for drive to be ready for a command */  ?     status = wait_ready(ucb);		/* Wait for drive to be ready */a.     if ($FAIL(status))			/* Check the error */8         return status;			/*  if an error, then return */   /* Compute number of blocks */  ?     xfer_size = (baseucb.ucb$l_bcnt + BLK_SIZE-1) >> BLK_SHIFT;s2     if (xfer_size == 0)			/* Was there any work */:         return SS$_NORMAL;		/* Exit with success if not */   /* Loop over each segment */  /     for (base_lbn = 0; base_lbn < xfer_size;) {	I         xfer_req = xfer_size - base_lbn;/* Compute blocks left to xfer */rA         status = write_segment(ucb,xfer_req,&xfer_cnt,&byte_cnt);O   	/* Check the status. */6 	/* On success - clear the retry count and continue */A 	/* On error - if the xfer_cnt is non-zero, then we are making	*/ > 	/*	progress, so just continue.  If the xfer_cnt is 0, then	*/; 	/*	we are losing ground.  Retry for a while, then reset	*/r2 	/*	and then try some more.  Finally, give up.		*/           if ($FAIL(status)) {              if (xfer_cnt == 0) {6                 retry_cnt++;		/* Update retry count */-                 if (retry_cnt == MAX_RETRY/2)S:                     reset_ctrl(ucb);	/* Attempt a reset */N                 if (retry_cnt > MAX_RETRY) /* Were there too many retries ? */=                     return status;	/* Yes, exit with error */n
             }(         } else {?             if (xfer_cnt > 0)		/* Was any data transferred ? */ G                 retry_cnt = 0;		/* Clear retry count on each success */m	         })  E         ucb->ucb$l_bcr -= byte_cnt;	/* Update byte count remaining */r>         ucb->ucb$l_media.lbn += xfer_cnt; /* Update the LBN */7         base_lbn += xfer_cnt;		/* Update LBN in loop */e     }a  <     return SS$_NORMAL;			/* Return to caller with success */ }d a+ /* write_segment - write one segment					*/(
 /*									*/_D /* This routine performs the write of a single I/O segment.  Each	*/H /* segment is a single read command of not more the MAX_XFER sectors.	*/E /* The overall read I/O routine calls this routine for each of the	*/b5 /* segments until the entire read is completed.				*/m
 /*									*/s /* Input:								*/a( /*	ucb             pointer to UCB					*/= /*	xfer_req        number of blocks remaining to transfer		*/n
 /*									*/  /* Output:								*/: /*	xfer_cnt        actual count of sectors transferred		*/8 /*	byte_cnt        actual count of bytes transferred		*/ /*	status value							*/  I int write_segment(DQ_UCB *ucb,int xfer_req,int *xfer_cnt,int *byte_cnt) {t  ) int	sec;				/* Sector number and count */E& int	int_cnt;			/* Interrupt counter */& int	lw_cnt;				/* Data buffer index */ int	head;				/* Head number */0 int	cyl;				/* Cylinder number and components */! int	idx;				/* Zero fill index */t" int	xfer_idx;			/* Buffer index */) int	status;				/* Routine status value */c0 void	*temp;				/* Dummy for IOC$MOVFRUSER use */) int	drv_head;			/* Drive and head bits */R, BYTE	*buffer;			/* Pointer to disk buffer */" int	orig_ipl;			/* Original IPL */, BYTE	sts, err;			/* STATUS and ERROR CSRs */ WORD	data;				/* Data word */b1 int	remainder;			/* Bytes left at end of block */t1 BYTE	*user_va;			/* Mapped user buffer address */ , int	buf_ofs;			/* Offset into user buffer */   /* Set up for the transfer */c  8     *xfer_cnt = 0;			/* Clear count of sectors xfered */6     *byte_cnt = 0;			/* Clear count of bytes xfered */>     status = SS$_BADPARAM;		/* Init status to weird failure */=     drv_head = ucb->ucb$l_drv_head;	/* Get base drive info */ 9     if (ucb->ucb$l_flags.bits.lba)	/* If LBA mode, ... */	;         drv_head |= DRVHD_M_LBA;	/*  ... set the LBA bit */tC     compute_address(ucb,&sec,&head,&cyl); /* Compute the address */RB     if (xfer_req > MAX_XFER)		/* Check for too large a transfer */7         xfer_req = MAX_XFER;		/*  and limit it if so */a  ) /* Move the data segment from the user */q  ?     *byte_cnt = xfer_req << BLK_SHIFT;	/* Compute byte count */t=     if (*byte_cnt > ucb->ucb$l_bcr)	/* Check for too large */a5         *byte_cnt = ucb->ucb$l_bcr;	/* Minimize it */*  G     buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE;)O     user_va = map_user_buffer(ucb,buf_ofs,*byte_cnt);	/* Map the user buffer */o/     memcpy(ucb->ucb$ps_xfer,user_va,*byte_cnt);r  8 /* If less than a full block, then zero the remainder */  =     remainder = *byte_cnt & BLK_MASK;	/* Compute remainder */o     if ( remainder > 0) {	B         remainder = BLK_SIZE - remainder; /* Compute bytes left */A         buffer = (BYTE *) ucb->ucb$ps_xfer; /* Point to buffer */e-         for (idx=0; idx < remainder; idx++) {l8             buffer[*byte_cnt+idx]=0;	/* Zero the byte */         }              }-  .     xfer_idx = 0;			/* Byte index in buffer */  B /* Take out the device lock, raise IPL, and write the registers */  9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl);vA     out(WT_DRV_HD,drv_head|head,ucb);	/* Select drive and head */f;     out(WT_SEC_CNT,xfer_req,ucb);	/* Ask for "n" sectors */n;     out(WT_SECTOR,sec,ucb);		/* Put in the sector number */e:     out(WT_CYL_LO,cyl,ucb);		/* Low order cylinder bits */>     out(WT_CYL_HI,cyl>>8,ucb);		/* High order cylinder bits */K     out(WT_CMD,ucb->ucb$l_write_cmd,ucb); /* Attempt to write the sector */   3 /* Loop over each sector in the transfer segment */*  6     for (int_cnt = 0; int_cnt < xfer_req; int_cnt++) {<         status = wait_drq(ucb);		/* Wait for data request */1         if ($FAIL(status))		/* Check for error */n*             break;			/*  and exit if so */  ' 	/* Push out the sector to the drive */b  9         for (lw_cnt = 0; lw_cnt < BLK_SIZE/4; lw_cnt++) { W             outw(WT_DATA,ucb->ucb$ps_xfer[xfer_idx],ucb);	/* Write out the data word */u[             outw(WT_DATA,ucb->ucb$ps_xfer[xfer_idx]>>16,ucb); /* Write out the data word */n=             xfer_idx++;		/* Move to next longword in block */r	         }c  9 	/* Wait for the interrupt and all that goes with that */	  @         status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  ? 	/* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */IE 	/*  else, if other error, then use DEVICE UNLOCK and return error */n  $         if (status == SS$_TIMEOUT) {K             erl_std$devictmo(5,(UCB *)ucb);	/* Handle the device timeout *//5             exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);A7             break;			/*  and exit with status intact */ #         } else if ($FAIL(status)) {iC             device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);c0             break;			/*  and exit with status */	         }e  C 	/* Read STATUS (dismissing interrupt) and drop back to fork IPL *//  ;         sts = inp(RD_STATUS,ucb);	/* Get the status byte */t:         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);:         *xfer_cnt += 1;			/* Update sectors transferred */   	/* Check the status */$  B         if (IS_SET(sts,STS_M_ERR) ) { 	/* If there was an error */>             err = inp(RD_ERROR,ucb);	/*  get the error byte */E             status = SS$_DRVERR;	/* Return with DRIVE ERROR status */t)             break;			/*  and exit loop */s	         }c  * /* All is well, set the status for exit */  5         status = SS$_NORMAL;		/* Set sucess status */      }n  8 /* Make sure that the returned "byte_cnt" is accurate */  G     *byte_cnt = *xfer_cnt << BLK_SHIFT;	/* Compute bytes transferred */U=     if (*byte_cnt > ucb->ucb$l_bcr)	/* Check for too large */c5         *byte_cnt = ucb->ucb$l_bcr;	/* Minimize it *//  +     return status;			/* Return to caller */e }n $- /* READRCT - Perform READRCT operation					*/*
 /*									*/m8 /* This routine returns the drive information page.			*/
 /*									*/* /* Input:								*/  /*	ucb	pointer to UCB						*/*
 /*									*/	 /* Output:								*/ /*	none								*/(
 /*									*/  /* Return value:							*/( /*	status value							*/ /*		SS$_NORMAL - success					*/e4 /*		SS$_NODATA - failed to get drive information		*/   int readrct(DQ_UCB *ucb) {  * int	status;				/* Routine return status */" int	orig_ipl;			/* Original IPL */! BYTE	err;				/* Error register */	* WORD	datal, datah;			/* Data from drive */ int	index;				/* Data index */1 void	*temp;				/* Dummy for IOC$MOVTOUSER call */e/ BYTE	*xfer;				/* Pointer to transfer buffer */   . /* Wait for drive to be ready for a command */  :     status = wait_ready(ucb);		/*  Wait for drive ready */.     if ($FAIL(status))			/* Check for error */:         return status;			/*  and return if there is one */  6 /* Select the drive, then ask for drive information */  A 	/* Obtain devicelock and write registers and send the command */   9     device_lock(baseucb.ucb$l_dlck,RAISE_IPL, &orig_ipl);CI     out(WT_DRV_HD,ucb->ucb$l_drv_head,ucb); /* Select drive and head 0 */,:     out(WT_CMD,CMD_IDENTIFY,ucb);	/* Ask for drive info */  8 /* Wait for the interrupt and all that goes with that */  <     status = WFIKPCH(ucb->ucb$ps_kpb,TIMEOUT_TIME,orig_ipl);  > /* If TIMEOUT, then FORK and return with SS$_TIMEOUT status */I /*  else, if other error, then use DEVICE UNLOCK and return with error */o        if (status == SS$_TIMEOUT) {G         erl_std$devictmo(6,(UCB *)ucb);	/* Handle the device timeout */ :         status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);6         return SS$_TIMEOUT;		/* Return with timeout */     } else if ($FAIL(status)) { ?         device_unlock(baseucb.ucb$l_dlck,orig_ipl,SMP_RESTORE);e0         return status;			/* Return with error */     }i   /* Drop back to fork IPL */(  6     status = exe$kp_fork(ucb->ucb$ps_kpb,(FKB *) ucb);  : /* Check the error status and exit if an error occurred */  H     if ( IS_SET(inp(RD_STATUS,ucb),STS_M_ERR) ) /* Check for an error */:         return SS$_NODATA;		/* Failed - exit with error */  ! /* Get the data from the drive */d  D     xfer = (BYTE *) ucb->ucb$ps_xfer;	/* Point to transfer buffer */?     move_sec_from_drive(ucb,&xfer);	/* Move sector to buffer */c   /* Move the data to the user */w  L     ioc_std$movtouser(ucb->ucb$ps_xfer,baseucb.ucb$l_bcnt,(UCB *)ucb,&temp);  <     return SS$_NORMAL;			/* Return to caller with success */ }  n: BYTE *map_user_buffer(DQ_UCB *ucb,int offset,int length) {  I /* map_user_buffer - this routine is used to directly map a section of	*/a /* the users buffer.							*/	
 /*									*/t /* Input:								*/   /*	ucb	pointer to the UCB					*/5 /*	offset	offset to start of buffer to be mapped			*/e$ /*	length	total length to map					*/
 /*									*/_ /* Output:								*/1 /*	user_va	returned address of mapped buffer			*/t
 /*									*/t   int	pfn;				/* PFN */a' int	first_pte;			/* First PTE number */Q+ int	pte_cnt;			/* Number of pages to map */e int	i;				/* Loop counter */! int	byte_ofs;			/* Byte offset */n* PTE	*user_pte;			/* Current PTE pointer */( BYTE	*s0_va;				/* Current S0 address */+ PTE	*s0_pte;			/* Current S0 PTE address */r, BYTE	*user_va;			/* Mapped buffer address */2 uint64	*clr_pte;			/* Pointer used to clear PTE */  @ #define PTE_BITS PTE$C_KOWN + PTE$C_KW + PTE$M_VALID + PTE$M_ASM  2 /* Calculate sizes, base PTE addresses and such */  E     offset += baseucb.ucb$l_boff;	/* Compute true offset from page */*J     byte_ofs = offset & MMG$GL_BWP_MASK; /* Compute byte offset in page */.     first_pte = (offset >> MMG$GL_VPN_TO_VA) *=                 PTE$C_BYTES_PER_PTE;	/* Compute PTE offset */aJ     pte_cnt = (((offset & MMG$GL_BWP_MASK) + length) + MMG$GL_BWP_MASK) >>9               MMG$GL_VPN_TO_VA;		/* Compute page count */c  ^     user_pte = (PTE *)((int)baseucb.ucb$l_svapte + first_pte); /* Compute first PTE address */B     s0_va   = ucb->ucb$ps_s0_va;	/* S0 address of mapped region */=     s0_pte  = ucb->ucb$ps_s0_svapte;	/* Get S0 PTE address */.  J /* Loop over all of the PTEs and set them to double map the user buffer */       for (i=0; i<pte_cnt; i++) {cA         if (user_pte->pte$v_valid)	/* Check for VALID user PTE */MD             pfn = user_pte->pte$v_pfn;	/* It is - get copy of PFN */         elseI             pfn = ioc_std$ptetopfn(user_pte);	/* Find PFN the hard way */b  = 	/* The following should be set field by field, but PTEDEF	*/fB 	/* doesn't have a proper definition for this, and frankly it's	*/< 	/* a pain !  So, define some bits and use them directly.	*/< /*      s0_pte->pte$v_own = PTE$C_KOWN; /* Owner = Kernel */F /*      s0_pte->pte$v_prot = PTE$C_KW;	/* Protection = Kernel Write */1 /*      s0_pte->pte$v_valid = 1;	/* Valid page */n9 /*      s0_pte->pte$v_asm = 1;		/* Address space match */e  8         clr_pte = (void *)s0_pte;	/* Point to the PTE */G         *clr_pte = PTE_BITS;		/* Clear the PTE and set constant bits */m;         s0_pte->pte$v_pfn = pfn;	/* Now, include the PFN */c<         mmg$tbi_single(s0_va);		/* Invalidate the address */?         s0_va += MMG$GL_PAGE_SIZE;	/* Point to the next page */ .         s0_pte++;			/* Point to next S0 PTE */2         user_pte++;			/* Point to next user PTE */	         }h   /* Now, make a guard page */  4     clr_pte = (void *)s0_pte;		/* Get PTE address */&     *clr_pte= 0;			/*  and clear it */8     mmg$tbi_single(s0_va);		/* Invalidate the address */  ) /* Return the S0 VA of the user buffer */"  :     user_va = (BYTE *)((int)ucb->ucb$ps_s0_va + byte_ofs);2     return	user_va;		/* Return with the address */ }  iJ /* move_sec_from_drive - This routine is used to move a sector from the	*/) /* disk drive on a READ operation.					*/ 
 /*									*/r /* Input:								*/   /*	ucb	pointer to the UCB					*/8 /*	buffer	address of pointer to buffer to place data		*/
 /*									*/) /* Output:								*/' /*	buffer	updated buffer pointer					*// /*	none								*/(  6 void move_sec_from_drive(DQ_UCB *ucb, BYTE **buffer) {  . int	lw_cnt;				/* Counter for data transfer */% WORD	datal, datah;			/* Input data */;* UINT	*bp;				/* LONGWORD buffer pointer */  A /* Read all of the data from the silo into the driver's buffer */t  ;     bp = (UINT *) *buffer;		/* Use as a longword pointer */>  <         for (lw_cnt = 0; lw_cnt < (BLK_SIZE/4) ; lw_cnt++) {=            datal = inpw(RD_DATA,ucb);	/* Get the data word */t=            datah = inpw(RD_DATA,ucb);	/* Get the data word */tD            *bp = (datah<< 16) + datal;	/* Move data to the buffer */6            bp++;			/* And move to the next longword */	         }   :     *buffer = (BYTE *)bp;		/* Copy back updated pointer */       return;s }  _H /* COMPUTE_ADDRESS - this routine is used to compute the head, sector	*/J /* and track information from a logical block number.  Note that on IDE	*/H /* disks, sector numbers start at 1.  Head and cylinder numbers start	*/ /* at 0.								*/
 /*									*/eJ /* LBA mode addressing is handled if the LBA flag is set.  In LBA mode,	*/G /* the address is still returned in the sec, head and cyl locations,	*/rD /* but it is simply the sections of the LBA.  The callers of this	*/D /* routine simply write these value to the registers, so this all	*/ /* works just fine.							*/
 /*									*/	 /* Input:								*/n  /*	ucb	pointer to the UCB					*/
 /*									*/  /* Output:								*/ /*		CHS mode		LBA mode			*/r# /*	sec	sector number		LBA[0:7]			*/R$ /*	head	head number		LBA[24:27]			*/& /*	cyl	cylinder number		LBA[8:23]			*/  A void compute_address(DQ_UCB *ucb,int *sec, int *head, int *cyl) {s  " int temp;				/* Temporary value */  )     if (ucb->ucb$l_flags.bits.lba == 0) {NA         *sec  = ucb->ucb$l_media.lbn % baseucb.ucb$b_sectors + 1;e=         temp  = ucb->ucb$l_media.lbn / baseucb.ucb$b_sectors;<,         *head = temp % baseucb.ucb$b_tracks;,         *cyl  = temp / baseucb.ucb$b_tracks;     } else {E         *sec  =  ucb->ucb$l_media.lbn        & 0x00FF;	/* Bits 0-7 */nH         *cyl  = (ucb->ucb$l_media.lbn >> 8)  & 0xFFFF;	/* Bits 8 - 23 */I         *head = (ucb->ucb$l_media.lbn >> 24) & 0x000F;	/* Bits 24 - 27 */t     }e }	  4 /* unload - Perform IO$_UNLOAD driver function				*/
 /*									*/  /* Input:								*/t /*	ucb	pointer to UCB						*/*
 /*									*/* /* Output:								*/ /*	status value							*/2 /*		SS$_NORMAL	function completed successfully		*/   int unload(DQ_UCB *ucb) {i  7     baseucb.ucb$v_valid = 0;		/* Clear the VALID bit */	K     ucb->ucb$l_read_cmd  = CMD_READ;	/* Default read command is 1 sector */	M     ucb->ucb$l_write_cmd = CMD_WRITE;	/* Default write command is 1 sector */;2     return SS$_NORMAL;			/* Return with success */ }O UF /* wait_ready - Wait Until The Drive Is Ready.  This means that the	*/> /* BSY status bit is clear and the DRDY status bit is set.		*/
 /*									*/W /* Input:								*// /*	ucb	pointer to UCB						*/h
 /*									*// /* Output:								*/ /*	status value							*/2 /*		SS$_NORMAL	function completed successfully		*/) /*		SS$_DEVACTIVE	BUSY never cleared			*/    int wait_ready(DQ_UCB *ucb) {c  ) int	status;				/* Routine status value */l BYTE	sts;				/* Status byte */  @ /* First, check that BUSY is clear so we can select the drive */  :     status = wait_busy(ucb);		/* Wait for BUSY to clear */5     if ($FAIL(status))			/* Check status for error */a;         return status;			/* Exit with the error code */    g  ; /* Then select the drive that we're really interested in */s  I     out(WT_DRV_HD,ucb->ucb$l_drv_head,ucb); /* Select drive and head 0 */r  0 /* Then, wait for BUSY to clear on this drive */  :     status = wait_busy(ucb);		/* Wait for BUSY to clear */5     if ($FAIL(status))			/* Check status for error */);         return status;			/* Exit with the error code */    /  , /* Finally, check that the drive is ready */  9     sts = inp(RD_ALT_STS,ucb);		/* Get the status byte */ @     if ( IS_CLEAR(sts,STS_M_DRDY) )	/*  Check for drive READY */C         return SS$_DEVACTIVE;		/*   and exit with failure if not */b   /* Drive is ready */  -     return SS$_NORMAL;			/* Return success */f }I E< /* wait_drq - Wait for DRQ to be set and BSY to be clear		*/
 /*									*/$ /* Input:								*/  /*	ucb	pointer to UCB						*/e
 /*									*/d /* Output:								*/ /*	status value							*/   int wait_drq(DQ_UCB *ucb)    { ) int	status;				/* Routine status value */e BYTE	sts;				/* Status byte */0 __int64	delta_time;			/* Timedwait delta time */. __int64	end_value;			/* Timedwait end value */  2 /* Check to see if the drive is ready right now */  9     sts = inp(RD_ALT_STS,ucb);		/* Get the status byte */ ;     if ( IS_CLEAR(sts,STS_M_BSY)) {	/* If not busy, then */u;         if ( IS_SET(sts,STS_M_DRQ) )	/*  get the DRQ bit */	;             return SS$_NORMAL;		/* Drive is ready - exit */t     }C  6 /* Drive is busy or DRQ not set - wait a bit for it */   	/* Set up the timedwait */t  3     delta_time = DRQ_TIME;		/* Set DRQ wait time */u9     status = exe$timedwait_setup(&delta_time,&end_value);*1     if ($FAIL(status) )			/* Check for success */i=         return status;			/* Return with the failure status */e  " 	/* Spin until ready or timeout */  H     while((status=exe$timedwait_complete(&end_value)) == SS$_CONTINUE) {@         sts = inp(RD_ALT_STS,ucb);	/* No, so read status byte */'         if ( IS_CLEAR(sts,STS_M_BSY)) {a*             if ( IS_SET(sts,STS_M_DRQ) ) {D                 status = SS$_NORMAL;	/* Looks ok - set new status */'                 break;			/* And exit */a
             }P	         }s     }c  2     return status;			/* Return with status code */ }  s. /* wait_busy - Wait for BSY to be clear					*/
 /*									*/o /* Input:								*/p /*	ucb	pointer to UCB						*/ 
 /*									*/O /* Output:								*/ /*	status value							*/   int wait_busy(DQ_UCB *ucb)   { ) int	status;				/* Routine status value */M BYTE	sts;				/* Status byte */0 __int64	delta_time;			/* Timedwait delta time */. __int64	end_value;			/* Timedwait end value */  2 /* Check to see if the drive is ready right now */  9     sts = inp(RD_ALT_STS,ucb);		/* Get the status byte */ 9     if ( IS_CLEAR(sts,STS_M_BSY))	/* If not busy, then */*7         return SS$_NORMAL;		/* Drive is ready - exit */   ' /* Drive is busy - wait a bit for it */t   	/* Set up the timedwait */r  3     delta_time = DRQ_TIME;		/* Set DRQ wait time */ 9     status = exe$timedwait_setup(&delta_time,&end_value);F1     if ($FAIL(status) )			/* Check for success */p=         return status;			/* Return with the failure status */   " 	/* Spin until ready or timeout */  H     while((status=exe$timedwait_complete(&end_value)) == SS$_CONTINUE) {9         sts = inp(RD_ALT_STS,ucb);	/* Read status byte *//D         if ( IS_CLEAR(sts,STS_M_BSY))	/* Check for it to be clear */:             return SS$_NORMAL;		/* BUSY is clear - exit */     }*  E /* Ok - still not ready.  Let's reset the controller and try again */s  ,     reset_ctrl(ucb);			/* Reset the drive */9     sts = inp(RD_ALT_STS,ucb);		/* Get the status byte */r9     if ( IS_CLEAR(sts,STS_M_BSY))	/* If not busy, then */m6         return SS$_NORMAL;		/*  return with success */     else=         return SS$_CTRLERR;		/* Exit with controller error */  }  v #ifdef DEBUGD /* wfikpch_hist - Wait for Interrupt and Keep Channel w/Histogram	*/
 /*									*//F /* This routine is a jacket around the normal ioc$kp_wfikpch.  This	*/B /* routine will keep the time completion histogram up to date.		*/
 /*									*/  /* Input:								*/a  /*	kpb	pointer to the KPB					*/ /*	tmo	timeout value						*/ /*	newipl	new IPL value						*/f
 /*									*/r /* Output:								*/ /*	status value							*/  1 int wfikpch_hist(KPB *kpb, int tmo, int newipl) {t  ( int	before, after;			/* ABSTIM values */, int	status;				/* Returned routine status */$ DQ_UCB	*ucb;				/* Pointer to UCB */7 extern	int	EXE$GL_ABSTIM;		/* Current time (seconds) */*  7     before = EXE$GL_ABSTIM;		/* Get the current time */r,     status = ioc$kp_wfikpch(kpb,tmo,newipl);7     after  = EXE$GL_ABSTIM;		/* Get the current time */	:     ucb	= (DQ_UCB *)kpb->kpb$ps_ucb;	/* Get UCB pointer */)     if ( (after-before) <= TIMEOUT_TIME ) @         ucb->ucb$l_timeout[after-before]++; /* Bump histogram */     elseC         ucb->ucb$l_timeout[TIMEOUT_TIME+1]; /* Else inc overflow */t2     return status;			/*  and return with status */ }* #endif 	+ /* reset_ctrl - Reset the controller					*/o
 /*									*/lG /* This routine issues a RESET to the controller.  It then waits for	*/	D /* the BUSY bit to clear.  If the BUSY bit isn't cleared within a	*/< /* certain time, we decide that the controller is dead.			*/
 /*									*/e /* Input:								*/  /*	ucb	pointer to UCB						*/t
 /*									*/  /* Output:								*/ /*	status value							*/$ /*		SS$_NORMAL	successful reset			*/. /*		SS$_CTRLERR	controller failed to RESET		*/   int reset_ctrl(DQ_UCB *ucb)	   {*) int	status;				/* Routine status value */ - int	dev_value;			/* DEV_CTL value to write */n BYTE	sts;				/* Status byte */ int	loop;				/* Loop counter */	  7 /* Set and clear the RESET bit.  It's edge triggered */   J     dev_value = CTL_M_MBO | CTL_M_SRST | CTL_M_nIEN; /* Reset + no ints */:     out(WT_DEV_CTL,dev_value,ucb);	/* Set the reset bit */<     dev_value = CTL_M_MBO;		/* Turn off RESET and ints on */:     out(WT_DEV_CTL,dev_value,ucb);	/* Set the reset bit */  2 /* Check to see if the drive is ready right now */  9     sts = inp(RD_ALT_STS,ucb);		/* Get the status byte */*9     if ( IS_CLEAR(sts,STS_M_BSY))	/* If not busy, then */c7         return SS$_NORMAL;		/* Drive is ready - exit */7  ' /* Drive is busy - wait a bit for it */	  .     for (loop=0 ; loop < RESET_TIME; loop++) {?         status	= exe$kp_fork_wait(ucb->ucb$ps_kpb,(FKB *) ucb); 5         if ($FAIL(status))		/* Check the KP status */ 7             return status;		/* Failed - exit w/error */ <         sts = inp(RD_ALT_STS,ucb);	/* Get the status byte */=         if ( IS_CLEAR(sts,STS_M_BSY))	/* If not busy, then */p;             return SS$_NORMAL;		/* Drive is ready - exit */>      }  A /* Controller is stuck on BUSY - return a fatal error for this */_  :     return SS$_CTRLERR;			/* Exit with controller error */ }b c) /* ISR - Interrupt Service Routine					*/ 
 /*									*/ < /*	This is the interrupt service routine for the driver.		*/
 /*									*/  /* Usage:								*/  /*	ISR (idb)							*/	
 /*									*/	 /* Input:								*/	 /*	idb	pointer to IDB						*//
 /*									*/L /* Output:								*/ /*	none								*/n
 /*									*/  /* Return value:							*/$ /*	none								*/e   void isr(IDB *idb)  {   ( DQ_UCB *ucb;				/* Pointer to the UCB */  K /* Get pointer to the UCB;  If null, then there is none and we just exit */w  J     ucb = (DQ_UCB *) idb->idb$ps_owner;	/* Get UCB address from the IDB */     if (ucb == NULL)9         return;				/* Unowned and unexpected - dismiss *// #ifdef DEBUG=     ucb->ucb$l_total_ints++;		/* Increment interrupt count */* #endif  J /* There's an owner.  If the interrupt is expected, then restart the KP */  =     device_lock(baseucb.ucb$l_dlck, NORAISE_IPL, NOSAVE_IPL);e 					/* Acquire devicelock */E  A     if (baseucb.ucb$v_int) {		/* If this is an expected int... */ @         baseucb.ucb$v_int = 0;		/* Clear "interrupt expected" */@         baseucb.ucb$v_tim = 0;		/* Clear TIMEOUT expected bit */3         exe$kp_restart(ucb->ucb$ps_kpb,SS$_NORMAL);o' 					/* ... then restart stalled KPB */)     }h #ifdef DEBUG     elseL         ucb->ucb$l_unsol_ints++;	/* Increment unsolicited interrupt count */ #endif  >     device_unlock(baseucb.ucb$l_dlck,NOLOWER_IPL,SMP_RESTORE);! 					/* Release the devicelock */v3     return;				/* Return to interrupt dispatcher */n }i r; /* INP - This routine is used to read a byte from a CSR.	*/l /*								*/ /* Input:							*/ /*	reg	register index					*/ /*	ucb	pointer to the UCB				*/w /*								*/ /* Output:							*/n /*	none							*/ /*								*/ /* Return value:						*/' /*	byte of data read from the CSR				*/    BYTE inp(int reg,DQ_UCB *ucb) {   ' CRAM	*cram_ptr;			/* Pointer to CRAM */u# int	status;				/* Routine status */  BYTE	data;				/* Data byte */i  >     cram_ptr = ucb->ucb$ps_crams[reg];	/* Point to the CRAM */9     status   = ioc$cram_io(cram_ptr);	/* Read the byte */rC     data = (cram_ptr->cram$q_rdata >> cram_init[reg].shift) & 0xFF;	)     return data;			/* Return the value */  }s u< /* INPW - This routine is used to read a word from a CSR.	*/ /*								*/ /* Input:							*/ /*	reg	register index					*/ /*	ucb	pointer to the UCB				*/d /*								*/ /* Output:							*/u /*	none							*/ /*								*/ /* Return value:						*/' /*	word of data read from the CSR				*/n    WORD inpw(int reg,DQ_UCB *ucb) {  + CRAM	*cram_ptr;			/* Pointer to the CRAM */	) int	status;				/* Routine status value */E WORD	data;				/* Data value */  :     cram_ptr = ucb->ucb$ps_crams[reg];	/* Point to CRAM */9     status   = ioc$cram_io(cram_ptr);	/* Read the word */tC     data = cram_ptr->cram$q_rdata >> cram_init[reg].shift & 0xFFFF;D+     return data;			/* Send back the data */s }e t; /* OUT - This routine is used to write a byte to a CSR.		*/s /*								*/ /* Input:							*/ /*	reg	register index					*/. /*	data	data byte to be written to the CSR		*/ /*	ucb	pointer to the UCB				*/( /*								*/ /* Output:							*/_ /*	none							*/  ) void out(int reg,BYTE data,DQ_UCB *ucb) {/  + CRAM	*cram_ptr;			/* Pointer to the CRAM */L$ int	status;				/* Returned status */  =     cram_ptr = ucb->ucb$ps_crams[reg];	/* Get correct CRAM */;M     cram_ptr->cram$q_wdata = data << cram_init[reg].shift;/* Position data */ =     status   = ioc$cram_io(cram_ptr);	/* Perform the write */n }t tB /* OUTW - This routine is used to write a word of data to a CSR.*/ /*								*/ /* Input:							*/ /*	reg	register index					*/. /*	data	data word to be written to the CSR		*/ /*	ucb	pointer to the UCB				*/t /*								*/ /* Output:							*/s /*	none							*/  * void outw(int reg,WORD data,DQ_UCB *ucb) {  ' CRAM	*cram_ptr;			/* Pointer to CRAM */t# int	status;				/* Routine status */w  >     cram_ptr = ucb->ucb$ps_crams[reg];	/* Point to the CRAM */R     cram_ptr->cram$q_wdata = data << cram_init[reg].shift; /* Position the data */:     status   = ioc$cram_io(cram_ptr);	/* Write the word */ }N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          