5 $ VERIFY = 'F$VERIFY(F$TRNLNM("DSNLINK_NEW_VERIFY"))' 
 $ SET = "SET" % $ SET SYMBOL/SCOPE=(noGLOBAL,noLOCAL)  $ GOTO _START_DSNLINK_NEW   	 ABSTRACT: F      This program automates checking the DSNlink ITS databases for new      articles.     E      It will get list of new DSNlink article titles from the DSN host A      system, optionally compare the list to a history database of H      articles retreived by DSNlink_NEW, and mail the article titles thatA      weren't in the history database to a user or group of users.   M      DSNlink_NEW can also automatically retrieve the text of specific DSNlink E      articles and mail them to a user or group of users (called "GET        Processing").     K      DSNlink is a free service offered by Digital for software support.  It G      is available in the US and Canada, as well as most other countries E      (DSNlink is called "AES" in some regions).  Contact your Digital I      salesperson, or account representative, for information on obtaining       DSNlink for your site.    PARAMETERS: ?      P1 - [optional] Configuration filename.  If not specified, I           DSNLINK_NEW_DIR:DSNLINK_NEW_CONFIG.DAT is used.  If the logical L           DSNLINK_NEW_DIR isn't defined, the location of DSNLINK_NEW.COM is            used.   L  {** Note -- parameters P2 through P6 are used by DSNlink_NEW.COM internallyG      when it submits itself to batch.  They aren't necessary to use any J      of the features of DSNlink_NEW.  To do Get processing, simply extractN      the mail from DSNlink_NEW into a a file called SYS$LOGIN:DSNLINK_GET.DAT M      and then type "@DSNLINK_NEW" and it'll see the file and get the articles L      for you automatically.  Also see DSNLINK_NEW.DOC for more information.}  K      P2 - [optional] COMPRESS, which will remove all History records older  K           than SINCE-2 days (SINCE is specified in your configuration file) L       or  [optional] $GET$, which causes GET processing to be performed (to            get article text).  D             NOTE:  Using this parameter is NOT normally required, asG                    DSNlink_NEW will automatically invoke GET Processing I                    if the Get file is found (the name of the get file is  J                    specified with .GET_FILE in the configuration file, and?                    defaults to SYS$LOGIN:DSNLINK_GET.DAT).  See I                    DSNLINK_NEW.DOC for more information on how to use GET                     Processing.E       or  [optional] $CHECKOPEN$, $CHECKCLOSED$, or $CHECKDATABASES$, %           which, are used internally.   L      P3 - get file - This is the file containing database names and article C           titles we're trying to retrieve; only used if P2 is $GET$   5      P4 - mail group name - only used if P2 is $GET$.   H      P5 - [optional] $ERROR$ rewrite username, used only if P2 is $GET$.F           Also used in the "sent by:" line (in mail messages) if this F           username is different from the username running DSNlink_NEW.  G      P6 - Name of original GET file, used only if P2 is $GET$.  If this I           parameter is non-null, and GET Processing is successful, we'll  D           delete the file in P6.  If GET Processing is unsuccessful,B           we'll include the filename in P6 to our mail sent to theI           $ERROR$ group, allowing the user to resubmit the GET Processing ;           job after the DSNlink problem has been corrected.    PRIVILEGES REQUIRED:K      No special VMS privileges are required.  Access to DSN ITS, DSN$BATCH  F      queue, and ability to send DSNlink mail are necessary to use all       features.   ENVIRONMENT:G      DCL.  Expected to work on all versions of VMS supported by DSNlink -      software, on both VAX and AXP platforms.   	 REQUIRES: >      "DSNlink for OpenVMS VAX" or "DSNlink for OpenVMS AXP".         I  =----------------------------------------------------------------------=   J Original idea taken from DSNlink article "[DSNlink] V1.n How To Get Daily M List of New Database Articles" in the DSNLINK database.  An early version of  $ DSNlink_NEW can also be found there.  G Copyright  1991-1996 by Dan Wing.  This code may be freely distributed G and modified for no commercial gain as long as this copyright notice is B retained.  This program is supplied 'as-is', and with no warranty.  D Created December 31, 1991, by Dan Wing, University Hospital, Denver.0 Internet:  wing@tgv.com or wing@eisner.decus.org  I  =----------------------------------------------------------------------=   ,   REVERSE CHRONOLOGICAL MODIFICATION HISTORY,   ------------------------------------------  -   5.4-2   18-JAN-1996  Dan Wing, wing@tgv.com B      Allow .CHECK_DATABASES to be omitted from configuration file.-   5.4-1   14-NOV-1995  Dan Wing, wing@tgv.com F      Improved history file compression by analyzing resulting file andF      re-tuning after Merging.  New history file format, with automaticH      conversion from old format to new format (longer field for database      name). -   5.4     13-NOV-1995  Dan Wing, wing@tgv.com I      Added .CHECK_DATABASES, to check for newly-available and missing DSN B      databases.  Allow user to control Get Processing defaults via      configuration file.         -   5.3-1   30-OCT-1995  Dan Wing, wing@tgv.com -      Collapse exclude strings during compare. -   5.3      2-OCT-1995  Dan Wing, wing@tgv.com E      Allow user to exclude specific article titles (which are updated H      often by Digital, causing them to re-appear in the DSNlink_NEW mail      messages).          -   5.2-1   11-APR-1995  Dan Wing, wing@tgv.com K      Allow user to choose when to delete Get file, so that we don't delete  &      GET file if GET Processing fails.-   5.2     31-OCT-1994  Dan Wing, wing@tgv.com G      Don't attempt to reconnect to DSNlink host if we receive "CSC call F      tracking database is unavailable" (CSCERRACC), or "application isG      not registered for this access number" (NOTREGSTRD) errors.  V1.2A F      apparently needs the same handling for GET that was introduced inA      V5.1-1, so make the "slow" GET processing happen if V1.2A is K      detected (reported by rdickens@datastream.co.uk).  Include support for G      PMDF/DELIVER for Get Processing in file PMDF_DELIVER.COM_TEMPLATE.   -   5.1-3    3-AUG-1994  Dan Wing, wing@tgv.com M      Allow GET file to have ">" or "#" as first character (in case Forwarding M      automatically inserts 'quote' characters).  Allow specifying priority of F      DSNlink_NEW when it is doing batch job work with .BATCH_PRIORITY.-   5.1-2   10-MAY-1994  Dan Wing, wing@tgv.com I      Use /KEY=&HISTORY_KEY to eliminate problem with single quotes in the D      title retreived from the DSNlink host.  Thanks to Larry Stone. 8   5.1-1    4-NOV-1993  Dan Wing, dwing@uh01.colorado.eduL      Automatically sense if we're using a version of DSNlink older than V1.2N      -- old versions (V1.1 and V1.1-1) cannot use EDT as their callable editorK      and don't work with GET processing's use of EDT -- so we automatically K      switch to a less efficient method of retrieving articles (pulling them       over the modem twice). 8   5.1     22-SEP-1993  Dan Wing, dwing@uh01.colorado.eduL      Enhancements to GET processing to work with the MX SITE agent, DELIVER,I      and PMDF.  Fix bug when .CHECK_OPENCALLS wasn't in the configuration L      file, and stopped playing with protection of the temporary file createdI      for GET processing.  New .SCRATCH_DIR configuration file setting for I      DSNlink_NEW temporary files.  Added .CHECK_CLOSEDCALLS to complement       .CHECK_OPENCALLS.  8   5.0     11-SEP-1993  Dan Wing, dwing@uh01.colorado.eduL      Ability to automatically retrieve article text (not just titles).  ShowM      number of articles retrieved from each database.  Inform $ERROR$ when we G      get UNKDBNAM error (instead of everyone).  Ability to send mail to J      DSN%OPENCALLS on a schedule.  Don't update history date every time weL      re-retrieve an article -- only update the date when it is new, or if itN      was last retrieved ALLOW_IF_OLDER (or more) days ago.  Configuration fileF      parser no longer uppercases everything.  Fixed other problems andK      inconsistencies with case-sensitivity and error message display.  Send M      Email for configuration file errors when running in batch.  Deliver mail J      to all recipients even if DECnet mail can't be sent to certain nodes.  8   4.3-1   27-JUN-1993  Dan Wing, dwing@uh01.colorado.eduB      Ensure history file exists before trying to display its size.8   4.3     24-JUN-1993  Dan Wing, dwing@uh01.colorado.edu8      Add ability to automatically compress history file.  8   4.2-2   13-JUN-1993  Dan Wing, dwing@uh01.colorado.eduJ      Fixed bug so database name is now displayed when history is disabled.8   4.2-1    5-MAY-1993  Dan Wing, dwing@uh01.colorado.eduH      When Emailing about errors, use several common message files to get?      more information.  Changed default SINCE time to TODAY-10. 8   4.2     19-APR-1993  Dan Wing, dwing@uh01.colorado.eduH      Separate history for flash and normal databases by using uppercase/=      lowercase for database name within the history database.    K   Older modification history is available in the DSNlink_NEW documentation.   I  =----------------------------------------------------------------------=    $! K $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $  $_START_DSNLINK_NEW: $  $  ON WARNING THEN GOTO _ERROR  $  ON CONTROL_Y THEN GOTO _ABORT $  $! $ ! $  DSNLINK_NEW_VERSION = "V5.4-2"  $  $  IF P1 .EQS. "$VERSION$" $  THEN  $    SET SYMBOL/SCOPE=GLOBAL/ $    DSNLINK_NEW_VERSION == DSNLINK_NEW_VERSION  $    VERIFY = F$VERIFY(VERIFY)% $    EXIT   ! Leaving DSNlink_NEW ...  $  ENDIF $ h $  WRITE SYS$OUTPUT F$FAO("!/DSNlink_NEW, version !AS.!/Started by !AS on node !AS on !AS, !AS !8AS.", -B      DSNLINK_NEW_VERSION, F$EDIT(F$GETJPI(0,"USERNAME"),"TRIM"), -c      F$GETSYI("NODENAME"), F$CVTIME(,,"WEEKDAY"), F$CVTIME(,"ABSOLUTE","DATE"), F$CVTIME(,,"TIME"))  $  $  GOSUB _INIT_DEFAULTS  $ H $  IF F$SEARCH("SYS$SYSTEM:DSN$MAIN.EXE") .EQS. "" THEN GOTO _NO_DSNLINK $ @ $  WRITE SYS$OUTPUT F$FAO("DSNlink version !AS.!/", DSN$VERSION) $ F $  IF F$SEARCH(DSN_CONFIG_FILENAME) .EQS. "" THEN GOTO _NO_CONFIG_FILE  $  GOSUB _INIT_PARSE_CONFIG_FILE( $  IF CONFIG_ERROR THEN GOTO _EXIT_ERROR^ $  IF BATCH .AND. (LOW_PRIORITY .NE. PRIB) THEN SET PROCESS/PRIORITY='LOW_PRIORITY''DEBUG_LOG' $ d $  ALLOW_IF_OLDER = F$CVTIME("''F$CVTIME(DSN_SINCE,"ABSOLUTE","DATE")'-2-00:00","COMPARISON","DATE") $ < $  IF (INTERACTIVE .AND. F$SEARCH(GET_FILE) .NES. "") .OR. -/       (P2 .EQS. "$GET$") THEN GOTO _DSNLINK_GET  $ + $  IF (BATCH .AND. P2 .EQS. "$CHECKOPEN$")   $  THEN  $    GOSUB _DO_CHECK_OPENCALLS $    FINISHED_OK = TRUE  $    GOTO _EXIT  $  ENDIF $ , $  IF (BATCH .AND. P2 .EQS. "$CHECKCLOSED$") $  THEN   $    GOSUB _DO_CHECK_CLOSEDCALLS $    FINISHED_OK = TRUE  $    GOTO _EXIT  $  ENDIF $ M $  IF (BATCH .AND. P2 .EQS. "$CHECKDATABASES$") THEN GOTO _SHOW_CONFIGURATION  $  $  IF P2 .EQS. "COMPRESS"  $  THEN  $    GOSUB _COMPRESS_HISTORY $    GOTO _EXIT  $  ENDIF $ # $  IF P2 .NES. "" THEN GOTO _BAD_P2  $  $! G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $  $_SHOW_CONFIGURATION:  $  COUNT = 0J $  WRITE SYS$OUTPUT F$FAO("  !24<Connection retries:!>!UL", DSN_RETRY_MAX)- $  IF F$EDIT(DSN_AFTER,"UPCASE") .NES. "ONE"   $  THEN C $    WRITE SYS$OUTPUT F$FAO("  !24<Next run at:!>!AS (!AS, !AS)", -       DSN_AFTER, - &      F$CVTIME(DSN_AFTER,,"WEEKDAY"), -7      F$CVTIME(DSN_AFTER,"ABSOLUTE") - ":00.00" - ".00")  $  ELSE A $    WRITE SYS$OUTPUT F$FAO("  !24<Next run at:!>(only one run)")  $  ENDIFG $  WRITE SYS$OUTPUT F$FAO("  !24<History file:!>!AS", DSN_HISTORY_FILE)  $ M $  IF DSN_HISTORY_FILE .NES. "NONE" .AND. F$SEARCH(DSN_HISTORY_FILE) .NES. ""  $  THEN ) $    IF DSN_HISTORY_AUTO_COMPRESS .GT. 0  	 $    THEN h $      WRITE SYS$OUTPUT F$FAO("  !24<History auto compress:!>at !UL blocks (current size !UL blocks)", -J      DSN_HISTORY_AUTO_COMPRESS, F$FILE_ATTRIBUTES(DSN_HISTORY_FILE,"EOF"))R $      IF F$FILE_ATTRIBUTES(DSN_HISTORY_FILE,"EOF") .GT. DSN_HISTORY_AUTO_COMPRESS $      THEN E $        WRITE SYS$OUTPUT F$FAO("!26* compression will be performed") % $        PERFORM_AUTO_COMPRESS = TRUE 6 $      ENDIF ! history auto compress will be performed	 $    ELSE G $      WRITE SYS$OUTPUT F$FAO("  !24<History auto compress:!>Disabled") + $    ENDIF  ! history auto compress enabled 0 $    ! convert from old history file to new one ; $    IF F$FILE(DSN_HISTORY_FILE,"MRS") .EQ. 108 .AND. BATCH 
 $    THEN ! $      GOSUB _NEW_HISTORY_FORMAT  G $      IF DSN_HISTORY_AUTO_COMPRESS .GT. 0 THEN GOSUB _COMPRESS_HISTORY $ $    ENDIF ! old history file format# $  ENDIF ! dsn_history_file <> none  $ h $  IF WRITE_TITLES .NES. "" THEN WRITE SYS$OUTPUT F$FAO("  !24<Write all titles to:!>!AS", WRITE_TITLES) $ ( $  IF F$TYPE(EXCLUDE_ARTICLE_0) .NES. "" $  THEN L $    WRITE SYS$OUTPUT F$FAO("  Excluded article!0UL!%S:", MAX_EXC_COUNT + 1) $    EXC_COUNT = 0 $    _DIS_EXC_LOOP: 5 $    IF F$TYPE(EXCLUDE_ARTICLE_'EXC_COUNT') .NES. ""  
 $    THEN 7 $      IF F$LENGTH(EXCLUDE_ARTICLE_'EXC_COUNT') .GT. 52  $      THEN q $        WRITE SYS$OUTPUT F$FAO("    !20<!AS!>  !52<!AS!>~", EXCLUDE_DB_'EXC_COUNT', EXCLUDE_ARTICLE_'EXC_COUNT')  $      ELSE p $        WRITE SYS$OUTPUT F$FAO("    !20<!AS!>  !52<!AS!>", EXCLUDE_DB_'EXC_COUNT', EXCLUDE_ARTICLE_'EXC_COUNT') $      ENDIF
 $    ENDIF $    EXC_COUNT = EXC_COUNT + 1< $    IF EXC_COUNT .LE. MAX_EXC_COUNT THEN GOTO _DIS_EXC_LOOP $  ENDIF $ 9 $  IF F$EDIT(DSN_CHECK_OPENCALLS,"UPCASE") .NES. "NEVER"   $  THEN t $    WRITE SYS$OUTPUT F$FAO("  !24<Check opencalls:!>!AS, user: !AS", DSN_CHECK_OPENCALLS, DSN_CHECK_OPENCALLS_USER) $  ELSE < $    WRITE SYS$OUTPUT F$FAO("  !24<Check opencalls:!>Never") $  ENDIF $ : $  IF F$EDIT(DSN_CHECK_CLOSEDCALLS,"UPCASE") .NES. "NEVER" $  THEN z $    WRITE SYS$OUTPUT F$FAO("  !24<Check closedcalls:!>!AS, user: !AS", DSN_CHECK_CLOSEDCALLS, DSN_CHECK_CLOSEDCALLS_USER) $  ELSE > $    WRITE SYS$OUTPUT F$FAO("  !24<Check closedcalls:!>Never") $  ENDIF $ 8 $  IF F$EDIT(DSN_CHECK_DATABASES,"UPCASE") .NES. "NEVER" $  THEN ~ $    WRITE SYS$OUTPUT F$FAO("  !24<Check new databases:!>!AS, mail group: !AS", DSN_CHECK_DATABASES, DSN_CHECK_DATABASES_USER)@ $    IF F$GETQUI("DISPLAY_QUEUE","JOB_LIMIT","DSN$BATCH") .LT. 2	 $    THEN f $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-JOB_LIM, To help performance, increase job limit on DSN$BATCH"X $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-JOB_LIM, queue to 2 when using CHECK_DATABASES."
 $    ENDIF $  ELSE @ $    WRITE SYS$OUTPUT F$FAO("  !24<Check new databases:!>Never") $  ENDIF $ L $  IF DSN_CHECK_DATABASES_FILE_DEFAULT .NES. DSN_CHECK_DATABASES_FILE THEN -W      WRITE SYS$OUTPUT F$FAO("  !24<New databases file:!>!AS", DSN_CHECK_DATABASES_FILE)  $ F $  WRITE SYS$OUTPUT F$FAO("  !24<Since:!>!AS (!AS, !AS)", DSN_SINCE, -K      F$CVTIME(DSN_SINCE,,"WEEKDAY"), F$CVTIME(DSN_SINCE,"ABSOLUTE","DATE"))  $  IF DSN_MAIL_EMPTY $  THEN = $    WRITE SYS$OUTPUT F$FAO("  !24<Send mail if empty:!>Yes")  $  ELSE < $    WRITE SYS$OUTPUT F$FAO("  !24<Send mail if empty:!>No") $  ENDIFP $  WRITE SYS$OUTPUT F$FAO("  !24<Batch log file:!>!AS", F$PARSE(LOG_FILE) - ";")e $  IF LOW_PRIORITY .NES. PRIB THEN WRITE SYS$OUTPUT F$FAO("  !24<Batch priority:!>!UL", LOW_PRIORITY) J $  WRITE SYS$OUTPUT F$FAO("  !24<Get file:!>!AS", F$PARSE(GET_FILE) - ";") $  $_DB_DISPLAY_LOOP:. $  IF MAIL_GROUP_NAME_'COUNT' .NES. "$ERROR$"  $  THEN C $    TMP = F$FAO("!/Will send !AS new articles from databases: ", - !        MAIL_GROUP_USERS_'COUNT')  ) $    GROUP_NAME = MAIL_GROUP_NAME_'COUNT' D $    CALL _DISPLAY_DATABASES SYS$OUTPUT 0 "''TMP'" "''GROUP_NAME'" 2 $  ELSE T $    WRITE SYS$OUTPUT F$FAO("!/Will send !AS any errors.", MAIL_GROUP_USERS_'COUNT') $  ENDIF  ! not error group  $  COUNT = COUNT + 1< $  IF COUNT .LE. MAIL_GROUP_COUNT THEN GOTO _DB_DISPLAY_LOOP $  $  WRITE SYS$OUTPUT ""B $  IF BATCH THEN SET OUTPUT_RATE        ! flush stuff to LOG file  $ G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $ E $  ! this needs to be down here so we display the config. informationR0 $  IF (BATCH .AND. P2 .EQS. "$CHECKDATABASES$")  $  THENC $    GOSUB _DO_CHECK_DATABASES $    FINISHED_OK = TRUE  $    GOTO _EXIT  $  ENDIF $DG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $n $  IF INTERACTIVEt $  THENm1 $    ASK "* Is this correct? [Y] " OK_TO_CONTINUE O $    IF (.NOT. OK_TO_CONTINUE) .AND. (OK_TO_CONTINUE .NES. "") THEN GOTO _ABORTt $  ENDIF $t $!hG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $ # $  IF DSN_HISTORY_FILE .NES. "NONE"e $  THENe, $    IF F$SEARCH(DSN_HISTORY_FILE) .EQS. "" 	 $    THENo3 $      CREATE/FDL=SYS$INPUT:/LOG 'DSN_HISTORY_FILE's FILE   BEST_TRY_CONTIGUOUS  yes   ORGANIZATION         INDEXEDE   EXTENSION            9           ! in case it never gets COMPRESSedl RECORD   FORMAT  FIXED J   SIZE    120        ! date (YYYY-MM-DD) + database + title = 10 + 32 + 78 KEY 0s   INDEX_COMPRESSION  noe   DUPLICATES         noo   NULL_KEY           nok   SEG0_LENGTH        110   SEG0_POSITION      10a	 $    ELSEa3 $      ! test to ensure we can R+W the history file_A $      OPEN/READ/WRITE/SHARE=WRITE DSN_OUTFILE 'DSN_HISTORY_FILE'  $      CLOSE DSN_OUTFILE! $    ENDIF  ! history file existsM $  ENDIF ! history disabled* $tG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $e= $  IF INTERACTIVE .OR. F$EDIT(DSN_AFTER,"UPCASE") .NES. "ONE"  $  THEN . $    IF F$EDIT(DSN_AFTER,"UPCASE") .EQS. "ONE"	 $    THENe) $      AFTER_QUAL = ""        ! right now 	 $    ELSElN $      AFTER_QUAL = "/AFTER=" + QUOTE + F$CVTIME(DSN_AFTER,"ABSOLUTE") + QUOTE
 $    ENDIF $t
 $    SUBMIT -       /NOTIFY -      /QUEUE=DSN$BATCH -L      /noPRINTER -e      /KEEP -      'AFTER_QUAL' -a8      /PARAMETERS=('F$PARSE(";",DSN_CONFIG_FILENAME)')  -      /NAME="DSNlink_NEW" -      /LOG_FILE='LOG_FILE' - .      'F$PARSE(";",F$ENVIRONMENT("PROCEDURE"))' $h? $    IF F$EDIT(DSN_AFTER,"UPCASE") .EQS. "ONE" .OR. INTERACTIVEi	 $    THEN  $      FINISHED_OK = TRUEt $      GOTO _EXITT. $    ENDIF  ! dsn_after = "one" or interactive+ $  ENDIF ! interactive or dsn_after = "one"n $  $! G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! D $! See if we need to send mail to DSN%OPENCALLS and DSN%CLOSEDCALLS.K $! we delay sending the actual mail to immediately before we connect to the G $! host system to try to get two 'streams' going to the host system at  8 $! once to shorten the total time we're using the modem.G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!y $  $  DO_CHECK_OPENCALLS   = FALSEe $l9 $  IF F$EDIT(DSN_CHECK_OPENCALLS,"UPCASE") .NES. "NEVER" w $  THENn $    COUNT = 0 $    _OPENCALLS_CHECK:; $    CHECK_VALUE = F$ELEMENT(COUNT,",",DSN_CHECK_OPENCALLS) = $    IF CHECK_VALUE .EQS. "," THEN GOTO _STOP_OPENCALLS_CHECKi+ $    IF F$TYPE(CHECK_VALUE) .EQS. "INTEGER":	 $    THENm) $    ! it is a day of the month (1, 2, 3)i, $      IF F$CVTIME(,,"DAY") .EQ. CHECK_VALUE $      THENP" $        DO_CHECK_OPENCALLS = TRUEj $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, OPENCALLS triggered by \", CHECK_VALUE, "\" $      ENDIF	 $    ELSE 5 $    ! it is the day of a week (Monday, Tuesday, ...)eT $      IF F$EDIT(F$CVTIME(,,"WEEKDAY"),"UPCASE") .EQS. F$EDIT(CHECK_VALUE,"UPCASE")  $      THENt" $        DO_CHECK_OPENCALLS = TRUEj $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, OPENCALLS triggered by \", CHECK_VALUE, "\" $      ENDIF5 $      IF F$EDIT(CHECK_VALUE,"UPCASE") .EQS. "ALWAYS"b $      THEN " $        DO_CHECK_OPENCALLS = TRUEj $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, OPENCALLS triggered by \", CHECK_VALUE, "\" $      ENDIF
 $    ENDIF $    COUNT = COUNT + 1; $    IF .NOT. DO_CHECK_OPENCALLS THEN GOTO _OPENCALLS_CHECKO $  ENDIF ! dont check  $- $_STOP_OPENCALLS_CHECK:-7 $  IF DO_CHECK_OPENCALLS THEN GOSUB _DO_CHECK_OPENCALLSi $  $! $!!! $! $k $  DO_CHECK_CLOSEDCALLS = FALSEe $a; $  IF F$EDIT(DSN_CHECK_CLOSEDCALLS,"UPCASE") .NES. "NEVER"   $  THEN  $    COUNT = 0 $    _CLOSEDCALLS_CHECK:= $    CHECK_VALUE = F$ELEMENT(COUNT,",",DSN_CHECK_CLOSEDCALLS)e? $    IF CHECK_VALUE .EQS. "," THEN GOTO _STOP_CLOSEDCALLS_CHECK + $    IF F$TYPE(CHECK_VALUE) .EQS. "INTEGER" 	 $    THENs) $    ! it is a day of the month (1, 2, 3)r, $      IF F$CVTIME(,,"DAY") .EQ. CHECK_VALUE $      THEND$ $        DO_CHECK_CLOSEDCALLS = TRUEl $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, CLOSEDCALLS triggered by \", CHECK_VALUE, "\" $      ENDIF	 $    ELSEN5 $    ! it is the day of a week (Monday, Tuesday, ...) T $      IF F$EDIT(F$CVTIME(,,"WEEKDAY"),"UPCASE") .EQS. F$EDIT(CHECK_VALUE,"UPCASE")  $      THENn$ $        DO_CHECK_CLOSEDCALLS = TRUEl $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, CLOSEDCALLS triggered by \", CHECK_VALUE, "\" $      ENDIF5 $      IF F$EDIT(CHECK_VALUE,"UPCASE") .EQS. "ALWAYS"n $      THENo$ $        DO_CHECK_CLOSEDCALLS = TRUEl $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, CLOSEDCALLS triggered by \", CHECK_VALUE, "\" $      ENDIF
 $    ENDIF $    COUNT = COUNT + 1? $    IF .NOT. DO_CHECK_CLOSEDCALLS THEN GOTO _CLOSEDCALLS_CHECKc $  ENDIF ! dont check  $  $_STOP_CLOSEDCALLS_CHECK:n; $  IF DO_CHECK_CLOSEDCALLS THEN GOSUB _DO_CHECK_CLOSEDCALLSm $e $! $!!! $! $O $  DO_CHECK_DATABASES = FALSE  $ 9 $  IF F$EDIT(DSN_CHECK_DATABASES,"UPCASE") .NES. "NEVER"   $  THEN  $    COUNT = 0 $    _DATABASES_CHECK:; $    CHECK_VALUE = F$ELEMENT(COUNT,",",DSN_CHECK_DATABASES) = $    IF CHECK_VALUE .EQS. "," THEN GOTO _STOP_DATABASES_CHECK + $    IF F$TYPE(CHECK_VALUE) .EQS. "INTEGER" 	 $    THENe) $    ! it is a day of the month (1, 2, 3) , $      IF F$CVTIME(,,"DAY") .EQ. CHECK_VALUE $      THENa" $        DO_CHECK_DATABASES = TRUEj $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, CHECKDATA triggered by \", CHECK_VALUE, "\" $      ENDIF	 $    ELSE 5 $    ! it is the day of a week (Monday, Tuesday, ...)eT $      IF F$EDIT(F$CVTIME(,,"WEEKDAY"),"UPCASE") .EQS. F$EDIT(CHECK_VALUE,"UPCASE")  $      THENg" $        DO_CHECK_DATABASES = TRUEj $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, CHECKDATA triggered by \", CHECK_VALUE, "\" $      ENDIF5 $      IF F$EDIT(CHECK_VALUE,"UPCASE") .EQS. "ALWAYS"@ $      THEN " $        DO_CHECK_DATABASES = TRUEj $        IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, CHECKDATA triggered by \", CHECK_VALUE, "\" $      ENDIF
 $    ENDIF $    COUNT = COUNT + 1; $    IF .NOT. DO_CHECK_DATABASES THEN GOTO _DATABASES_CHECKW $  ENDIF ! dont check  $e $_STOP_DATABASES_CHECK:m2 $! following just causes batch job to be submitted7 $  IF DO_CHECK_DATABASES THEN GOSUB _DO_CHECK_DATABASES  $  $- $!4G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! , $!!!  Build input file for "DSN ITS" commandG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!l $d $  GOSUB _DELETE_TMP_FILES $  T' $  OPEN/WRITE DSN_OUTFILE 'TMP_DSNFILE'i $l $  COUNT = 0 $  DB_NAME = ""i $_FILE_LOOP_1: $  IF DB_NAME .NES. "" g $  THEN ( $    WRITE DSN_OUTFILE "close ", DB_NAME $    WRITE DSN_OUTFILE ""0 $  ENDIF $  DB_NAME = DB_NAME_'COUNT'7 $  DB_DIRFILE = TMP_EXTRACTFILE + "_" + F$STRING(COUNT) + $  DB_DIRFILE_FLASH = DB_DIRFILE + "_FLASH"n% $  WRITE DSN_OUTFILE "open ", DB_NAMEdY $  WRITE DSN_OUTFILE "directory/all/since=", QUOTE, F$CVTIME(DSN_SINCE,"ABSOLUTE"), QUOTEe5 $  WRITE DSN_OUTFILE "extract/directory ", DB_DIRFILEN $  IF DB_FLASH_'COUNT' $  THEN.a $    WRITE DSN_OUTFILE "directory/all/flash/since=", QUOTE, F$CVTIME(DSN_SINCE,"ABSOLUTE"), QUOTEu= $    WRITE DSN_OUTFILE "extract/directory ", DB_DIRFILE_FLASHe $  ENDIF ! symbol is TRUEh $  COUNT = COUNT + 15 $  IF COUNT .LE. DB_NAME_COUNT THEN GOTO _FILE_LOOP_1n $  $  WRITE DSN_OUTFILE "exit"s $  CLOSE DSN_OUTFILE $tm $  WRITE SYS$OUTPUT F$FAO("!/%DSNlink_NEW-I-COUNT, !UL database!%S will be checked for new articles.", COUNT)e $  $!# $!!! connect to DSNlink host systems $! $r $  GOSUB _PHONE_DCL_HOST $eO $  IF F$SEARCH("''TMP_EXTRACTFILE'*",2) .EQS. "" THEN GOTO _NO_DSNLINK_ARTICLESp $c $!eG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!i $!!!  Found DSNlink articles.yJ $!!!  We need to remove articles we've already seen (history records), and1 $!!!  then generate the appropriate mail messages G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!d $gB $  IF BATCH THEN SET RESTART_VALUE="Processing retreived articles"_ $  WRITE SYS$OUTPUT "%DSNlink_NEW-S-NEWART, DSNlink articles were retrieved from DSNlink host."  $o $! Remove history records  $  COUNT = 0 $_PROCESS_HIST_LOOP: $  DB_NAME = DB_NAME_'COUNT' $  $  DSNLINK_FLASH = TRUEmB $  DB_DIRFILE = TMP_EXTRACTFILE + "_" + F$STRING(COUNT) + "_FLASH"I $  IF F$SEARCH(DB_DIRFILE) .NES. "" THEN GOSUB _ELIMINATE_HISTORY_RECORDSv $l $  DSNLINK_FLASH = FALSE8 $  DB_DIRFILE = TMP_EXTRACTFILE + "_" + F$STRING(COUNT) I $  IF F$SEARCH(DB_DIRFILE) .NES. "" THEN GOSUB _ELIMINATE_HISTORY_RECORDSS $r $  COUNT = COUNT + 1; $  IF COUNT .LE. DB_NAME_COUNT THEN GOTO _PROCESS_HIST_LOOPd $  s $_GENERATE_MAIL_MESSAGES:a $!C $! generate mail messages for each group, as defined in config fileW $  MAIL_COUNT = 0  $  _GEN_ART_LOOP:-8 $  SELECT_MAIL_GROUP_NAME = MAIL_GROUP_NAME_'MAIL_COUNT', $  IF SELECT_MAIL_GROUP_NAME .NES. "$ERROR$" $  THEN!m $    WRITE SYS$OUTPUT F$FAO("!/%DSNlink_NEW-S-GENART, Generating mail for group !AS", SELECT_MAIL_GROUP_NAME)G $    GOSUB _BUILD_MESSAGED' $    IF F$SEARCH(TMP_MAILFILE) .NES. "" 	 $    THENV $      TMP1 = F$FAO(FAO_SUBJECT, TOTAL_FLASH_ARTICLES, TOTAL_NORMAL_ARTICLES, TOTAL_FLASH_ARTICLES + TOTAL_NORMAL_ARTICLES, SELECT_MAIL_GROUP_NAME, TOTAL_DATABASES) $      TMP2 = F$FAO(FAO_PERSONAL, TOTAL_FLASH_ARTICLES, TOTAL_NORMAL_ARTICLES, TOTAL_FLASH_ARTICLES + TOTAL_NORMAL_ARTICLES, SELECT_MAIL_GROUP_NAME, TOTAL_DATABASES)(  $      IF WRITE_TITLES .NES. ""  $      THENMY $        WRITE SYS$OUTPUT "%DSNlink_NEW-I-WRITETITLES, Writing titles to: ", WRITE_TITLESB= $        APPEND 'TMP_MAILFILE' 'WRITE_TITLES'/NEW_VERSION/LOG  $      ENDIF  $      CALL _SEND_MAIL_MESSAGE -      'TMP_MAILFILE' -v      "''TMP1'" -"      "''SELECT_MAIL_GROUP_NAME'" -      "''TMP2'" $      DELETE 'TMP_MAILFILE';*X $    ELSE   ! everything was rejected because of history and/or database wasn't selectedc $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-NOSELECTED, No articles for group ", SELECT_MAIL_GROUP_NAME_ $      IF DSN_MAIL_EMPTY E $      THEN  $        CREATE 'TMP_MAILFILE'G No new DSNlink articles were found that matched configuration criteria.  $        CALL _SEND_MAIL_MESSAGE 'TMP_MAILFILE' "No new ''SELECT_MAIL_GROUP_NAME' DSNlink articles" "''SELECT_MAIL_GROUP_NAME'"_  $        DELETE 'TMP_MAILFILE';* $      ENDIF ! dsn_mail_empty  $    ENDIF ! no file to mail $  ENDIF ! error group $  MAIL_COUNT = MAIL_COUNT + 1> $  IF MAIL_COUNT .LE. MAIL_GROUP_COUNT THEN GOTO _GEN_ART_LOOP $  FINISHED_OK = TRUE. $  GOTO _POST_PROCESSING $S $!HG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! - $!  Call DSNlink host, and retry as necessary I $!  This routine is used by "normal" DSNlink_NEW as well as DSNlink_NEW's! $!  "get" routines.!G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!= $_PHONE_DCL_HOST:T9 $  IF BATCH THEN SET RESTART_VALUE="Calling DSNlink host" / $! build DCL jacket around the DSN ITS commands E $! (we have to use this method instead of the old DSN$ITS_INIT method"K $!  because EDT was rewinding the input file every time it was invoked, butM6 $!  it doesn't rewind stuff fed to it in this manner).) $  SET FILE/VERSION_LIMIT=2 'TMP_DSNFILE' < $  OPEN/WRITE DSN_OUTFILE 'TMP_DSNFILE';       ! new version $4 $  IF PERFORMING_GET $  THENR $    IF GET_STYLE .EQS. "EDT"_	 $    THEN"- $      WRITE DSN_OUTFILE "$! GET_STYLE = EDT" G $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE DSN$ITS_EDIT CALLABLE_EDT" : $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE EDTSYS NLA0:": $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE EDTINI NLA0:"G $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE SYS$ERROR ", TMP_ERRORFILEAL $      ! defining SYS$OUTPUT seems to mess up EDT (gives %SYSTEM-F-IVDEVNAM) $ - $      ! Note on SYS$SCRATCH (DSNlink V1.2b): O $      !   when run from user DSN$SERVER, DSN$MAIN.EXE seems to leave on SYSPRVoO $      !   which causes problems when trying to delete edit-journal file owned !M $      !   by the owner of the scratch directory ([SYSTEM]) -- so, as a work-bK $      !   around, we set DSN$SCRATCH to point to a directory that is ownedSH $      !   by our UIC no matter what (this controls the creation of the G $      !   DSN$ITS_pid.TMP file which contains the file we're editing).RF $      !   This problem doesn't seem to exist with other usernames....H $      !   In case future versions of DSNlink use SYS$SCRATCH instead ofK $      !   DSN$SCRATCH for the location of this temporary file, we're goingEC $      !   to set both SYS$SCRATCH and DSN$SCRATCH just to be sure.e $      !K $      !   Note that this means the DSN ITS commands (which we're about to IM $      !   execute) cannot contain references to the logicals SYS$SCRATCH or HK $      !   DSN$SCRATCH, as we're only temporarily re-defining them to pointU $      !   to SYS$LOGIN.W $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE DSN$SCRATCH ", F$PARSE("SYS$LOGIN") - ".;"WW $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE SYS$SCRATCH ", F$PARSE("SYS$LOGIN") - ".;"_
 $    ENDIF! $    IF GET_STYLE .EQS. "EXTRACT"C	 $    THENC1 $      WRITE DSN_OUTFILE "$! GET_STYLE = EXTRACT"EG $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE SYS$ERROR ", TMP_ERRORFILEAF $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE SYS$OUTPUT ", TMP_OUTFILE
 $    ENDIF $  ELSEr  $    IF .NOT. CHECKING_DATABASES	 $    THENL; $      WRITE DSN_OUTFILE "$! normal DSNlink_NEW processing"oG $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE SYS$ERROR ", TMP_ERRORFILEAF $      WRITE DSN_OUTFILE "$ DEFINE/USER_MODE SYS$OUTPUT ", TMP_OUTFILE	 $    ELSE!C $      WRITE DSN_OUTFILE "$! check database DSNlink_NEW processing" D $      WRITE DSN_OUTFILE "$! (cannot use /USER_MODE on the DEFINEs)"= $      WRITE DSN_OUTFILE "$ DEFINE SYS$ERROR ", TMP_ERRORFILEE< $      WRITE DSN_OUTFILE "$ DEFINE SYS$OUTPUT ", TMP_OUTFILE
 $    ENDIF $  ENDIF $l $  WRITE DSN_OUTFILE "$"< $  WRITE DSN_OUTFILE "$ DEFINE/USER_MODE DSN$ITS_INIT NLA0:" $  WRITE DSN_OUTFILE "$"! $  WRITE DSN_OUTFILE "$ SET noON"I  $  WRITE DSN_OUTFILE "$ DSN ITS" $  CLOSE DSN_OUTFILE $ ( $  APPEND 'TMP_DSNFILE';-1 'TMP_DSNFILE' $E( $  OPEN/APPEND DSN_OUTFILE 'TMP_DSNFILE' $  IF F$EXTRACT(1,-1,DSN$VERSION) .LTS. "1.2" THEN WRITE DSN_OUTFILE "no"  ! in case DSN ITS asks for a survey (V1.2 and up don't ask for surveys if we're running in batch mode)E $  IF CHECKING_DATABASES $  THEN . $    WRITE DSN_OUTFILE "$ DEASSIGN SYS$OUTPUT"- $    WRITE DSN_OUTFILE "$ DEASSIGN SYS$ERROR"  $  ENDIF' $  WRITE DSN_OUTFILE "$ EXIT '$STATUS'"S $  CLOSE DSN_OUTFILE $C $  IF DEBUGC $  THENAS $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, .COM file to connect to DSNlink host:"I $    TYPE 'TMP_DSNFILE'4 $  ENDIF   ! DEBUG $e $! $!!! $! $  $_DSN_RETRY: $  WRITE SYS$OUTPUT ""Q $  WRITE SYS$OUTPUT "%DSNlink_NEW-I-ATTCONN, Attempting connection at ", F$TIME()A; $  IF BATCH THEN SET OUTPUT_RATE  ! flush stuff to LOG fileH $W, $  ATTEMPT_CONNECT_TIME = F$CVTIME(,,"TIME"), $  ATTEMPT_CONNECT_DATE = F$CVTIME(,,"DATE"), $  DSN_ATTEMPT_COUNT = DSN_ATTEMPT_COUNT + 1 $)D $  IF F$SEARCH(TMP_ERRORFILE) .NES. "" THEN DELETE 'TMP_ERRORFILE';*@ $  IF F$SEARCH(TMP_OUTFILE) .NES. "" THEN DELETE 'TMP_OUTFILE';* $aF $! we're currently running at LOW_PRIORITY; if this is lower than whatH $! we started with, go back up...  Note some *old* versions of VMS can'tI $! handle this properly, so we ignore any possible errors just to be sureyJ $! (I believe it was after VMS V5.0, but not sure if V5.1 or V5.2 had this $! behavior, too...).N $  SET noONRH $  IF LOW_PRIORITY .LT. PRIB THEN SET PROCESS/PRIORITY='PRIB''DEBUG_LOG'	 $  SET ONT $T $  SET noON  $  @'TMP_DSNFILE'L$ $  DSNLINK_ITS_EXIT_STATUS = $STATUS	 $  SET ON! $!P $  IF LOW_PRIORITY .NE. PRIB THEN SET PROCESS/PRIORITY='LOW_PRIORITY''DEBUG_LOG' $   N $  WRITE SYS$OUTPUT "%DSNlink_NEW-I-RETURNED, Attempt completed at ", F$TIME()f $  WRITE SYS$OUTPUT "%DSNlink_NEW-I-EXITSTATUS, DSN ITS exit $STATUS value: ", DSNLINK_ITS_EXIT_STATUSB $! calculate elapsed connection time (only works for the same day)@ $! (from James Thompson, DECUServe VMS conference, note 1270.20) $  SET noON  $  DEFINE SYS$OUTPUT NLA0: $  DEFINE SYS$ERROR NLA0:EC $  ELAPSED_CONN_TIME = F$CVTIME("-''ATTEMPT_CONNECT_TIME'",,"TIME")! $  STATUS = $STATUS! $  DEASSIGN SYS$OUTPUT $  DEASSIGN SYS$ERRORR	 $  SET ON.y $  IF (.NOT. STATUS) .OR. (TOTAL_ELAPSED_CONN_TIME .EQS. "--:--:--") .OR. (ATTEMPT_CONNECT_DATE .NES. F$CVTIME(,,"DATE"))_ $  THEN    ! The day changed, ) $    TOTAL_ELAPSED_CONN_TIME = "--:--:--" _ $    WRITE SYS$OUTPUT "%DSNlink_NEW-W-ELAPSED, Unable to calculate elapsed time (", STATUS, ")" [ $    WRITE SYS$OUTPUT "-DSNlink_NEW-W-2DAYS, Can only calculate elapsed time for same day."Pc $    WRITE SYS$OUTPUT "-DSNlink_NEW-W-2DAYS, Connect time will be set to ", TOTAL_ELAPSED_CONN_TIMES $  ELSE a $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-ELAPSED, Connect time to DSNlink host: ", ELAPSED_CONN_TIMEEb $    TOTAL_ELAPSED_CONN_TIME = F$CVTIME("''TOTAL_ELAPSED_CONN_TIME'+''ELAPSED_CONN_TIME'",,"TIME") $  ENDIF ! .not. statusb $  WRITE SYS$OUTPUT "" $! $  IF DEBUG  $  THEN!_ $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, DSNlink connection attempt finished (''F$TIME()')" R $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Error file from DSN ITS (SYS$ERROR):") $    IF F$SEARCH(TMP_ERRORFILE) .NES. ""  	 $    THENR $      TYPE 'TMP_ERRORFILE'$	 $    ELSEAN $      WRITE SYS$OUTPUT "DSNlink_NEW-I-DEBUG, <No SYS$ERROR file was created>"
 $    ENDIFT $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Output file from DSN ITS (SYS$OUTPUT):"& $    IF F$SEARCH(TMP_OUTFILE) .NES. ""	 $    THENl $      TYPE 'TMP_OUTFILE''	 $    ELSE P $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, <No SYS$OUTPUT file was created>"
 $    ENDIFZ $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Contents of DSN ITS directory extract files:"2 $    IF F$SEARCH("''TMP_EXTRACTFILE'*",1) .NES. ""	 $    THENe $      TYPE 'TMP_EXTRACTFILE'*	 $    ELSE!a $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, <no DSN ITS directory extract files were created>"S $    ENDIF ! not found $  ENDIF  ! debuga $e $! G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!t' $!!!  Determine if encountered an erroroG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $! $  RETRY_OPERATION = FALSE $!K $! if we got an UNKDBNAM (unknown database) error, inform $ERROR$ group nowl8 $  IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$OUTPUT NLA0:7 $  IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$ERROR NLA0: 2 $  SEARCH/EXACT 'TMP_ERRORFILE' "%DSN-E-UNKDBNAM"  $  IF $STATUS .EQ. SS$_NORMAL  $  THEN K $    ! if we had an UNKDBNAM (unknown database) error, assume (cough cough) L $    ! that it was the only error, and we don't need to retry the operation. $    RETRY_OPERATION = FALSE. $    SET FILE/VERSION_LIMIT=2 'TMP_ERRORFILE';R $    SEARCH/EXACT 'F$SEARCH(TMP_ERRORFILE)' "%DSN-","-DSN-"/OUTPUT='TMP_ERRORFILE'M $    CALL _SEND_MAIL_MESSAGE 'TMP_ERRORFILE' "DSNlink UNKDBNAM error" $ERROR$y $  ELSE,O $    ! Check to see if we got any errors and if we need to retry the connection,: $    IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$OUTPUT NLA0:9 $    IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$ERROR NLA0:EI $    SEARCH/EXACT 'TMP_ERRORFILE' "%DSN-F-","%DSN-E-","-DSN-E-","-DSN-F-"$N $    IF $STATUS .EQ. SS$_NORMAL THEN RETRY_OPERATION = TRUE   ! found an error $  ENDIF $ = $  IF RETRY_OPERATION   ! we got an error other than UNKDBNAMO, $  THEN       ! some sort of DSNlink failure/ $    SEARCH/EXACT/noHIGHLIGHT 'TMP_ERRORFILE' - L           "-F-","-E-"    ! show error in .LOG file (%DSN and %SYSTEM errors) $    WRITE SYS$OUTPUT "" $ER $    ! see if the error was "CSCERRACC, CSC call tracking database is unavailable"F $    ! if so, get out now -- retrying isn't going to make it available: $    IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$OUTPUT NLA0:9 $    IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$ERROR NLA0:"- $    SEARCH/EXACT 'TMP_ERRORFILE' "CSCERRACC"E $    IF $STATUS .EQ. SS$_NORMALL	 $    THEN 8 $      ! we found it!  That must have been why we failed" $      EXCEEDED_RETRY_LIMIT = TRUE" $      RECEIVED_FATAL_ERROR = TRUEg $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-QUITTING, Detected CSCERRACC error -- not attempting to retry."U  $      GOTO _NO_DSNLINK_ARTICLES
 $    ENDIF $ ^ $    ! see if the error was "NOTREGSTRD, application is not registered for this access number"F $    ! if so, get out now -- retrying isn't going to make it available: $    IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$OUTPUT NLA0:9 $    IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$ERROR NLA0:l. $    SEARCH/EXACT 'TMP_ERRORFILE' "NOTREGSTRD" $    IF $STATUS .EQ. SS$_NORMAL 	 $    THENT8 $      ! we found it!  That must have been why we failed" $      EXCEEDED_RETRY_LIMIT = TRUE" $      RECEIVED_FATAL_ERROR = TRUEh $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-QUITTING, Detected NOTREGSTRD error -- not attempting to retry."  $      GOTO _NO_DSNLINK_ARTICLES
 $    ENDIF $S0 $    IF (DSN_RETRY_COUNT + 1) .LE. DSN_RETRY_MAX
 $    THEN , $      DSN_RETRY_COUNT = DSN_RETRY_COUNT + 1T $      IF BATCH THEN SET RESTART_VALUE="Connection retry count = ''DSN_RETRY_COUNT'"e $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-RETRY, Waiting ", DSN_RETRY_WAIT_TIME, " to retry connection" N $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-RETRY, Retry number ", DSN_RETRY_COUNT! $      WAIT 'DSN_RETRY_WAIT_TIME'N $      GOTO _DSN_RETRY	 $    ELSEI" $      EXCEEDED_RETRY_LIMIT = TRUE  $      GOTO _NO_DSNLINK_ARTICLES% $    ENDIF    ! retry limit exceeded?V $  ENDIF ! retry_operation" $  IF BATCH THEN SET RESTART_VALUE$ $  RETURN  ! Leave CALL_DSN_HOST ... $W $!SG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!sG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!( $_BUILD_MESSAGE:; $! put FLASH articles together for all (selected) databases  $  COUNT = 0 $  TOTAL_NORMAL_ARTICLES = 0 $  TOTAL_FLASH_ARTICLES = 0r $  TOTAL_DATABASES = 0 $  DSNLINK_FLASH = TRUEI $$ $  _FILE_LOOP_2: $  DB_NAME = DB_NAME_'COUNT'+ $  MAIL_CHECK = "," + DB_MAIL_'COUNT' + "," n $  IF F$LOCATE(",''SELECT_MAIL_GROUP_NAME',",MAIL_CHECK) .EQ. F$LENGTH(MAIL_CHECK) THEN GOTO _SKIP_FILE_LOOP_2B $  DB_DIRFILE = TMP_EXTRACTFILE + "_" + F$STRING(COUNT) + "_FLASH"$ $  IF F$SEARCH(DB_DIRFILE) .NES. ""  $  THENFl $    WRITE SYS$OUTPUT F$FAO("%DSNlink_NEW-I-BUILDMSG, Writing !UL new FLASH article!%S from !AS database", -(      DB_ARTICLES_FLASH_'COUNT', DB_NAME)3 $    APPEND/NEW_VERSION 'DB_DIRFILE' 'TMP_MAILFILE'!L $    TOTAL_FLASH_ARTICLES = TOTAL_FLASH_ARTICLES + DB_ARTICLES_FLASH_'COUNT'* $    TOTAL_DATABASES = TOTAL_DATABASES + 1 $  ENDIF $  _SKIP_FILE_LOOP_2:l $  COUNT = COUNT + 15 $  IF COUNT .LE. DB_NAME_COUNT THEN GOTO _FILE_LOOP_2E $ H $! put normal (non-FLASH) articles together for all (selected) databases $  COUNT = 0 $  DSNLINK_FLASH = FALSE $  _FILE_LOOP_3: $  DB_NAME = DB_NAME_'COUNT'+ $  MAIL_CHECK = "," + DB_MAIL_'COUNT' + ","Fn $  IF F$LOCATE(",''SELECT_MAIL_GROUP_NAME',",MAIL_CHECK) .EQ. F$LENGTH(MAIL_CHECK) THEN GOTO _SKIP_FILE_LOOP_37 $  DB_DIRFILE = TMP_EXTRACTFILE + "_" + F$STRING(COUNT)/$ $  IF F$SEARCH(DB_DIRFILE) .NES. ""  $  THEN f $    WRITE SYS$OUTPUT F$FAO("%DSNlink_NEW-I-BUILDMSG, Writing !UL new article!%S from !AS database", -)      DB_ARTICLES_NORMAL_'COUNT', DB_NAME)=3 $    APPEND/NEW_VERSION 'DB_DIRFILE' 'TMP_MAILFILE' O $    TOTAL_NORMAL_ARTICLES = TOTAL_NORMAL_ARTICLES + DB_ARTICLES_NORMAL_'COUNT'T* $    TOTAL_DATABASES = TOTAL_DATABASES + 1 $  ENDIF $  _SKIP_FILE_LOOP_3:O $  COUNT = COUNT + 15 $  IF COUNT .LE. DB_NAME_COUNT THEN GOTO _FILE_LOOP_3S $T! $  RETURN   ! from _BUILD_MESSAGE! $d $!sG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $_ELIMINATE_HISTORY_RECORDS: $  ACCEPTED_ARTICLE_COUNT = 0  $  REJECTED_ARTICLE_COUNT = 0' $  NEW_ARTICLE_FOUND = FALSE $  DEBUG_HISTORY_REJECT = FALSE! $!E $! determine if these should be accepted or rejected based on historyo( $  SET FILE/VERSION_LIMIT=3 'DB_DIRFILE'$ $  OPEN/READ DSN_INFILE 'DB_DIRFILE' $yY $  CREATE 'DB_DIRFILE';               ! create a new version, which contains 'real' stuff!' $  OPEN/APPEND DSN_OUTFILE 'DB_DIRFILE'! $!$ $  IF DSN_HISTORY_FILE .EQS. "NONE"  $  THENcL $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-HISTDIS, History processing disabled." $    GOTO _HISTORY_DISABLEDm $  ENDIF $. $  WRITE SYS$OUTPUT -r_      F$FAO("%DSNlink_NEW-I-CHECKHIST, Checking history for !0UL!1%CFLASH !%E!%Fdatabase !AS", -H      DSNLINK_FLASH, DB_NAME) $R> $  OPEN/READ/WRITE/SHARE=WRITE HISTORY_FILE 'DSN_HISTORY_FILE' $L $! $! $! $N $_CHK_HIST_LOOP:< $  READ/END_OF_FILE=_EXIT_CHK_HIST_LOOP DSN_INFILE ART_TITLEL $  ARTICLE_TITLE = F$EXTRACT(8,78,ART_TITLE)     ! strip off article numbers $  GOSUB _CHECK_EXCLUDEIA $  IF ARTICLE_TITLE .EQS. "" THEN GOTO _CHK_HIST_LOOP  ! excludedC6 $  ACCEPTED_ARTICLE_COUNT = ACCEPTED_ARTICLE_COUNT + 1 $E: $! "flash" history records have database name in lowercase; $! "normal" history records have database name in uppercase- $  IF DSNLINK_FLASHP $  THENAR $    HISTORY_KEY = F$FAO("!32AS!78AS", F$EDIT(DB_NAME,"LOWERCASE"), ARTICLE_TITLE) $  ELSEEO $    HISTORY_KEY = F$FAO("!32AS!78AS", F$EDIT(DB_NAME,"UPCASE"), ARTICLE_TITLE)T $  ENDIF $A3 $  _HIS_KEY_LOOP:   ! remove all quotes from stringP< $  IF F$LOCATE(QUOTE,HISTORY_KEY) .NE. F$LENGTH(HISTORY_KEY) $  THENL6 $    HISTORY_KEY[F$LOCATE(QUOTE,HISTORY_KEY),1] := "\" $    GOTO _HIS_KEY_LOOPL $  ENDIF $IR $  IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-HISTORYKEY, \", HISTORY_KEY, "\"K $  READ/KEY=&HISTORY_KEY/ERROR=_NOT_IN_HIST/noLOCK HISTORY_FILE HIST_RECORDC $A $!$ $!!! we found the article in history $! $_ $!!+ .M $!! backed out so history date reflects the first day we saw the article, notW+ $!! the most recent day we saw the article.A $!! 3 $!!  ! update history file record with today's date @ $!!  READ/KEY=&HISTORY_KEY/ERROR=_ERROR HISTORY_FILE HIST_RECORDK $!!  WRITE/UPDATE HISTORY_FILE F$CVTIME(,"COMPARISON","DATE") + HISTORY_KEYD $!!- $P7 $  IF F$EXTRACT(0,10,HIST_RECORD) .GTS. ALLOW_IF_OLDER s $  THEN V $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-HISTORY, Rejected article \", ARTICLE_TITLE, "\"n $    WRITE SYS$OUTPUT "-DSNlink_NEW-I-HISTORY, because it was last retrieved at ", F$EXTRACT(0,10,HIST_RECORD) $    IF DEBUG 
 $    THEN l $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, Rejected article will be tagged and included in mail message"h $      WRITE DSN_OUTFILE F$FAO("!80AS", "Hist/DBG:" + F$EXTRACT(0,10,HIST_RECORD) + ":" + ARTICLE_TITLE)" $      DEBUG_HISTORY_REJECT = TRUE $    ENDIF  ! debuge8 $    REJECTED_ARTICLE_COUNT = REJECTED_ARTICLE_COUNT + 1 $    GOTO _CHK_HIST_LOOP% $  ENDIF  ! already seen this article_ $P] $  WRITE SYS$OUTPUT "%DSNlink_NEW-I-AGAIN, Article re-appeared from history: ", ARTICLE_TITLE!1 $  ! update history file record with today's dateN> $  READ/KEY=&HISTORY_KEY/ERROR=_ERROR HISTORY_FILE HIST_RECORDI $  WRITE/UPDATE HISTORY_FILE F$CVTIME(,"COMPARISON","DATE") + HISTORY_KEY! $  GOTO _INCLUDE_TITLE $!* $_NOT_IN_HIST:      ! we've never seen it. $  IF DEBUG THEN WRITE SYS$OUTPUT F$FAO("%DSNlink_NEW-I-DEBUG, Writing: !/!5* !AS!AS", F$CVTIME(,"COMPARISON","DATE"), HISTORY_KEY)hB $  WRITE HISTORY_FILE F$CVTIME(,"COMPARISON","DATE") + HISTORY_KEY $a $_INCLUDE_TITLE:( $  WRITE DSN_OUTFILE "  ", ARTICLE_TITLEJ $  WRITE SYS$OUTPUT "%DSNlink_NEW-I-HISTORY, New article: ", ARTICLE_TITLE $  NEW_ARTICLE_FOUND = TRUEE $  GOTO _CHK_HIST_LOOP $L $_EXIT_CHK_HIST_LOOP:! $  CLOSE DSN_INFILEI $  CLOSE DSN_OUTFILE? $  IF F$TRNLNM("HISTORY_FILE") .NES. "" THEN CLOSE HISTORY_FILEN $T1 $  IF NEW_ARTICLE_FOUND .OR. DEBUG_HISTORY_REJECTE $  THENE $    WRITE SYS$OUTPUT F$FAO( -u      "%DSNlink_NEW-I-SUMMARY, Total of !UL new article!%S in !0UL!1%CFLASH !%E!%F!AS, !UL rejected, !UL accepted.", - }      ACCEPTED_ARTICLE_COUNT, DSNLINK_FLASH, DB_NAME, REJECTED_ARTICLE_COUNT, ACCEPTED_ARTICLE_COUNT - REJECTED_ARTICLE_COUNT) C $    CREATE 'DB_DIRFILE';     ! create new version that has headersl) $    OPEN/APPEND DSN_OUTFILE 'DB_DIRFILE'  $    IF DSNLINK_FLASHE	 $    THENe $      WRITE DSN_OUTFILE F$FAO("FLASH !AS database, !UL article!%S:", DB_NAME, ACCEPTED_ARTICLE_COUNT - REJECTED_ARTICLE_COUNT)sR $      DB_ARTICLES_FLASH_'COUNT' = ACCEPTED_ARTICLE_COUNT - REJECTED_ARTICLE_COUNT	 $    ELSEty $      WRITE DSN_OUTFILE F$FAO("!AS database, !UL article!%S:", DB_NAME, ACCEPTED_ARTICLE_COUNT - REJECTED_ARTICLE_COUNT)pS $      DB_ARTICLES_NORMAL_'COUNT' = ACCEPTED_ARTICLE_COUNT - REJECTED_ARTICLE_COUNT  $    ENDIF ! flash $    CLOSE DSN_OUTFILE( $    APPEND 'DB_DIRFILE';-1 'DB_DIRFILE' $  ELSEC $    WRITE SYS$OUTPUT F$FAO( -g      "%DSNlink_NEW-I-SUMMARY, Total of !UL new article!%S in !0UL!1%CFLASH !%E!%F!AS, all rejected.", -N4      ACCEPTED_ARTICLE_COUNT, DSNLINK_FLASH, DB_NAME) $    DELETE 'DB_DIRFILE';* $  ENDIF ! new article found $ ' $  RETURN  ! from CHECK_DSNLINK_HISTORYn $  $_HISTORY_DISABLED:C $  NEW_ARTICLE_FOUND = TRUER $_HISTORY_DISABLED_LOOP:< $  READ/END_OF_FILE=_EXIT_CHK_HIST_LOOP DSN_INFILE ART_TITLEJ $  ARTICLE_TITLE = F$EXTRACT(8,78,ART_TITLE)   ! strip off article numbers $  GOSUB _CHECK_EXCLUDEDI $  IF ARTICLE_TITLE .EQS. "" THEN GOTO _HISTORY_DISABLED_LOOP  ! excluded ( $  WRITE DSN_OUTFILE "  ", ARTICLE_TITLE6 $  ACCEPTED_ARTICLE_COUNT = ACCEPTED_ARTICLE_COUNT + 1 $  GOTO _HISTORY_DISABLED_LOOP $I $! G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $_CHECK_EXCLUDE:D $! Determine if the article is one of the articles we're supposed to $! exclude from checking.  $  EXC_COUNT = 0\ $  IF F$TYPE(EXCLUDE_ARTICLE_0) .EQS. "" THEN RETURN  ! if we don't have anything to exclude $_CHECK_EXCLUDE_LOOP: s $  IF (F$EDIT(EXCLUDE_ARTICLE_'EXC_COUNT',"UPCASE,COLLAPSE") .EQS. F$EDIT(ARTICLE_TITLE,"UPCASE,COLLAPSE")) .AND. -tt       (F$EDIT(DB_NAME,"UPCASE") .EQS. F$EDIT(EXCLUDE_DB_'EXC_COUNT',"UPCASE") .OR. EXCLUDE_DB_'EXC_COUNT' .EQS. "*") $  THEN"l $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-EXCLUDED, Article \", ARTICLE_TITLE, "\ from database \", DB_NAME, "\": $    TOTAL_EXCLUDED_ARTICLES = TOTAL_EXCLUDED_ARTICLES + 1 $    ARTICLE_TITLE = ""N $  ENDIF $  EXC_COUNT = EXC_COUNT + 1@ $  IF EXC_COUNT .LE. MAX_EXC_COUNT THEN GOTO _CHECK_EXCLUDE_LOOP	 $  RETURNC $E $!OG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!D $_NO_DSNLINK_ARTICLES:G $! There were no articles retrieved, and no errors (some other code haso $!  already checked for errors)u $y8 $  IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$OUTPUT NLA0:7 $  IF .NOT. DEBUG THEN DEFINE/USER_MODE SYS$ERROR NLA0:E8 $  SEARCH/EXACT 'TMP_ERRORFILE' "Connection established"B $  IF ($STATUS .EQ. SS$_NORMAL) .AND. (.NOT. EXCEEDED_RETRY_LIMIT)0 $  THEN   ! good connection, just no articles...Q $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-NONEW, No new DSNlink articles were found."N $    IF (DSN_MAIL_EMPTY) P
 $    THEN # $      GOTO _GENERATE_MAIL_MESSAGES 
 $    ENDIF $    FINISHED_OK = TRUE d $  ELSE   ! never established a connection, or we exceeded retry limit (errors after the connection)c $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-PROBLEM, Problem connecting to DSNlink host (", F$TIME(), ")"AY $    CALL _SEND_MAIL_MESSAGE 'TMP_ERRORFILE' "Problem connecting to DSNlink host" $ERROR$  $  ENDIF $H $  GOTO _POST_PROCESSING $  $!EG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!_ $_POST_PROCESSING:E $!  check to see if history file should be auto-compressed, then exitw $t $  IF PERFORM_AUTO_COMPRESS  $  THENl $    GOSUB _COMPRESS_HISTORY $  ENDIF $o
 $  GOTO _EXITn $  $!oG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!n $_EXIT:f $  IF FINISHED_OKh $  THEN _ $    WRITE SYS$OUTPUT F$FAO("!/%DSNlink_NEW-S-OK, DSNlink_NEW completed successfully at !%T",0)U4 $    EXIT_STATUS = (SS$_NORMAL .OR. STS$M_INHIB_MSG) $  ELSENV $    WRITE SYS$OUTPUT F$FAO("!/%DSNlink_NEW-E-NOTOK, DSNlink_NEW encountered errors.")U $    WRITE SYS$OUTPUT "-DSNlink_NEW-E-NOTOK, No new DSNlink articles were retrieved."U3 $    EXIT_STATUS = (SS$_ABORT .OR. STS$M_INHIB_MSG)O $  ENDIF $  GOSUB _DELETE_TMP_FILES $_EXIT_NOCLEANUP:l $  VERIFY = F$VERIFY(VERIFY)1 $  EXIT 'EXIT_STATUS'   ! Leaving DSNlink_NEW ...f $tG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!0
 $_EXIT_ERROR:O? $  IF F$TYPE(ERROR_STATUS) .EQS. "" THEN ERROR_STATUS = $STATUSA# $  IF ERROR_MESSAGE .EQS. "" THEN -_A      ERROR_MESSAGE = "Unexpected condition; exact error unknown."PR $  WRITE SYS$OUTPUT "%DSNlink_NEW-E-ERROR, error occurred; DSNlink_NEW error was:"' $  WRITE SYS$OUTPUT "  ", ERROR_MESSAGEN $  WRITE SYS$OUTPUT ""U $  WRITE SYS$OUTPUT F$FAO("-DSNlink_NEW-E-ERROR, DCL error was: %X!XL", ERROR_STATUS) ) $  DISPLAY_MESSAGES_OUTPUT = "SYS$OUTPUT"P $  GOSUB _DISPLAY_MESSAGES s $  WRITE SYS$OUTPUT "" $ B $  IF (.NOT. INTERACTIVE) .AND. ("''MAIL_GROUP_$ERROR$'" .NES. "") $  THENrP $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-MAILING, Informing $ERROR$ group of error"0 $    SET noON       ! in case error-handler dies $    CLOSE/noLOG DSN_OUTFILE* $    OPEN/WRITE DSN_OUTFILE 'TMP_MAILFILE'D $    WRITE DSN_OUTFILE "*** An error caused DSNlink_NEW to fail ***" $    WRITE DSN_OUTFILE ""_? $    WRITE DSN_OUTFILE "The error detected by DSNlink_NEW was:"U* $    WRITE DSN_OUTFILE "  ", ERROR_MESSAGE $    WRITE DSN_OUTFILE ""-, $    DISPLAY_MESSAGES_OUTPUT = "DSN_OUTFILE" $    GOSUB _DISPLAY_MESSAGES T $    CLOSE DSN_OUTFILEJ $    CALL _SEND_MAIL_MESSAGE 'TMP_MAILFILE' "Error in DSNlink_NEW" $ERROR$/ $  ENDIF  ! error group exists, not interactive$ $  GOSUB _DELETE_TMP_FILES $  VERIFY = F$VERIFY(VERIFY)B $  EXIT SS$_ABORT      ! Leaving DSNlink_NEW (on error status) ... $%G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!E $_DISPLAY_MESSAGES: I $  WRITE 'DISPLAY_MESSAGES_OUTPUT' F$FAO("$STATUS = %X!XL", ERROR_STATUS)OA $  WRITE 'DISPLAY_MESSAGES_OUTPUT' " = ", F$MESSAGE(ERROR_STATUS) _ $  IF F$SEARCH("SYS$MESSAGE:CLIUTLMSG.EXE") .NES. "" THEN SET MESSAGE SYS$MESSAGE:CLIUTLMSG.EXE"A $  WRITE 'DISPLAY_MESSAGES_OUTPUT' " = ", F$MESSAGE(ERROR_STATUS) _ $  IF F$SEARCH("SYS$MESSAGE:SYSMGTMSG.EXE") .NES. "" THEN SET MESSAGE SYS$MESSAGE:SYSMGTMSG.EXEIA $  WRITE 'DISPLAY_MESSAGES_OUTPUT' " = ", F$MESSAGE(ERROR_STATUS) e $  IF F$SEARCH("SYS$MESSAGE:DSN$MESSAGES.EXE") .NES. "" THEN SET MESSAGE SYS$MESSAGE:DSN$MESSAGES.EXE A $  WRITE 'DISPLAY_MESSAGES_OUTPUT' " = ", F$MESSAGE(ERROR_STATUS)! $  SET MESSAGE/DELETE!% $  WRITE 'DISPLAY_MESSAGES_OUTPUT' ""E$ $  RETURN ! Leaving DISPLAY_MESSAGES $NF $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! $_DELETE_TMP_FILES:D= $  IF F$TRNLNM("DSN_REFFILE") .NES. "" THEN CLOSE DSN_REFFILE$C $  IF F$TRNLNM("DSN_SEARCHFILE") .NES. "" THEN CLOSE DSN_SEARCHFILEI7 $  IF F$TRNLNM("DSN_FILE") .NES. "" THEN CLOSE DSN_FILE = $  IF F$TRNLNM("DSN_OUTFILE") .NES. "" THEN CLOSE DSN_OUTFILE!; $  IF F$TRNLNM("DSN_INFILE") .NES. "" THEN CLOSE DSN_INFILEpC $  IF F$TRNLNM("DSN_CONFIGFILE") .NES. "" THEN CLOSE DSN_CONFIGFILE : $  IF (F$SEARCH("''TMP_EXTRACTFILE'*",3) .NES. "") .AND. -E      ("''TMP_EXTRACTFILE'" .NES. "") THEN DELETE 'TMP_EXTRACTFILE'*;*'D $  IF F$SEARCH(TMP_ERRORFILE) .NES. "" THEN DELETE 'TMP_ERRORFILE';*@ $  IF F$SEARCH(TMP_DSNFILE) .NES. "" THEN DELETE 'TMP_DSNFILE';*D $  IF F$SEARCH(TMP_CHECKFILE) .NES. "" THEN DELETE 'TMP_CHECKFILE';*@ $  IF F$SEARCH(TMP_OUTFILE) .NES. "" THEN DELETE 'TMP_OUTFILE';*A $  IF F$SEARCH(TMP_MAILFILE) .NES. "" THEN DELETE 'TMP_MAILFILE;* @ $  IF F$SEARCH(TMP_YESFILE) .NES. "" THEN DELETE 'TMP_YESFILE';*K $  IF F$SEARCH(P3) .NES. "" .AND. PERFORMING_GET THEN DELETE 'F$SEARCH(P3)'n" $  RETURN  ! from DELETE_TMP_FILES $fG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $_ERROR: $  ERROR_STATUS = $STATUSOT $  WRITE SYS$OUTPUT "%DSNlink_NEW-E-ERROR, Unexpected error occurred in DSNlink_NEW" $  GOTO _EXIT_ERROR  $lG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $_ABORT:D $  WRITE SYS$OUTPUT "%DSNlink_NEW-E-ABORT, User aborted DSNlink_NEW" $  FINISHED_OK = TRUEN
 $  GOTO _EXITD $NG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!C
 $_NO_DSNLINK:A^ $  WRITE SYS$OUTPUT "%DSNlink_NEW-E-NOTPRESENT, You do not have DSNlink software on this node"d $  WRITE SYS$OUTPUT "-DSNlink_NEW-E-NOTPRESENT, Contact your local Digital office to obtain DSNlink" $  FINISHED_OK = TRUEd
 $  GOTO _EXITr $ G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $_NO_CONFIG_FILE:hQ $  ERROR_MESSAGE = "%DSNlink_NEW-E-CONFIG, Missing file \''DSN_CONFIG_FILENAME'\"   $  ERROR_STATUS = SS$_NOSUCHFILE $  GOTO _EXIT_ERRORt $aG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!I	 $_BAD_P2:UC $  ERROR_MESSAGE = "%DSNlink_NEW-E-INVP2, Bad parameter P2 \''P2'\"R $  ERROR_STATUS = SS$_BADPARAM $  GOTO _EXIT_ERROR  $  $!TG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!E $_DISPLAY_DATABASES: SUBROUTINEI1 $! P1 = output file (file must already be opened)S/ $! P2 = number spaces at beginning of each line-8 $! P3 = String to put at front of output text [optional] $! P4 = mail group nameI: $! P5 = additional indentation after first line [optional] $D $  FIRST_LINE = TRUE $  IF P2 .EQS. "" THEN P2 = 0  $  P2 = F$INTEGER(P2)" $  P5 = F$INTEGER(P5)=C $  AVAILABLE_WIDTH = 80 - P2 - 2          ! 2 = comma + extra spaceW $  DB_NUMBER = 0 $  OUTPUT_STRING = P3  $  NEED_COMMA = FALSEI $S/ $! first make sure prefix string isn't too longD $_CHECK_STR_LENGTH: 2 $  IF F$LENGTH(OUTPUT_STRING) .GT. AVAILABLE_WIDTH $  THENS $    START = 0 $    END = AVAILABLE_WIDTH $    _DISPLAY_PREFIX_LOOP:* $    CHAR = F$EXTRACT(END,1,OUTPUT_STRING)A $    IF CHAR .NES. "," .AND. CHAR .NES. " " .AND. CHAR .NES. "." T	 $    THENe $      END = END - 13 $      IF END .GT. 0 THEN GOTO _DISPLAY_PREFIX_LOOP!H $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-DISPdb, Display database error." $      GOTO _ABORT_DISP_LOOP
 $    ENDIFI $    WRITE SYS$OUTPUT F$EDIT(F$EXTRACT(START,END+1,OUTPUT_STRING),"TRIM"):6 $    OUTPUT_STRING = F$EXTRACT(END+1,-1,OUTPUT_STRING) $    GOTO _CHECK_STR_LENGTHL $  ENDIF $L $  _ABORT_DISP_LOOP: $T $_DISPLAY_DB_LOOP:= $  IF DB_NUMBER .GT. DB_NAME_COUNT THEN GOTO _DISPLAY_DB_EXIT / $  MAIL_CHECK = "," + DB_MAIL_'DB_NUMBER' + "," > $  IF F$LOCATE(",''P4',",MAIL_CHECK) .EQ. F$LENGTH(MAIL_CHECK) $  THENIr $!!!    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DISPLAY, Not displaying ", DB_NAME_'DB_NUMBER', " for ", P4 $    GOTO _DISPLAY_DB_NEXT $  ENDIF  ! not for this group* $  ADDITIONAL_STRING = DB_NAME_'DB_NUMBER'L $  IF F$LENGTH(OUTPUT_STRING + "," + ADDITIONAL_STRING) .GE. AVAILABLE_WIDTH2 $  THEN  ! not enough room to all fit on this line $    IF NEED_COMMA M	 $    THEN!6 $      WRITE 'P1' F$FAO("!#* !AS,", P2, OUTPUT_STRING)	 $    ELSEA5 $      WRITE 'P1' F$FAO("!#* !AS", P2, OUTPUT_STRING) 
 $    ENDIF $    IF FIRST_LINE  	 $    THENC $      FIRST_LINE = FALSED $      P2 = P2 + P5O- $      AVAILABLE_WIDTH = AVAILABLE_WIDTH - P5r
 $    ENDIF& $    OUTPUT_STRING = ADDITIONAL_STRING $    NEED_COMMA = TRUE. $  ELSE ! yes, enough room to fit on this line $    IF OUTPUT_STRING .EQS. ""	 $    THENU( $      OUTPUT_STRING = ADDITIONAL_STRING $      NEED_COMMA = TRUE	 $    ELSEG $      IF NEED_COMMA O $      THEN @ $        OUTPUT_STRING = OUTPUT_STRING + "," + ADDITIONAL_STRING $      ELSED: $        OUTPUT_STRING = OUTPUT_STRING + ADDITIONAL_STRING $        NEED_COMMA = TRUE $      ENDIF ! need_commao# $    ENDIF ! output_string .eqs. ""N+ $  ENDIF ! enough room to fit on this line?S $_DISPLAY_DB_NEXT: $  DB_NUMBER = DB_NUMBER + 1 $  GOTO _DISPLAY_DB_LOOP $I $_DISPLAY_DB_EXIT: $  IF OUTPUT_STRING .NES. P3 $  THENT3 $    WRITE 'P1' F$FAO("!#* !AS", P2, OUTPUT_STRING)  $  ELSE=j $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Display_databases: No DBs for group \", P4, "\" $  ENDIF% $  EXIT           ! display_databases!% $  ENDSUBROUTINE  ! display_databasesM $T $!TG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $_SEND_MAIL_MESSAGE: SUBROUTINE 6 $! P1 = append information to this file, then Email it' $! P2 = Subject to use for Mail messageo/ $! P3 = name of mail group we're sending to... LF $!      if there is an equal sign with text afterwards, the text afterA $!      the equal sign is the username(s) we're going to send to. , $! P4 = Personal name (if empty, P2 is used) $  $  IF P4 .EQS. "" THEN P4 = P2 $T  $  GRPNAME = F$ELEMENT(0,"=",P3) $_ $  MAIL_USERS = "<none>" $  MAIL_GROUPS = "<unknown>" $S $  IF GRPNAME .EQS. "Retain"   $  THENS $    COUNT = 0 $    _RETAIN_LOOP:H $    IF F$EDIT(DATABASE,"UPCASE") .EQS. F$EDIT(DB_NAME_'COUNT',"UPCASE")< $    THEN                               ! found the databaseT $      MAIL_GROUPS = DB_MAIL_'COUNT'    ! list of mail groups (Programmers, Systems) $      OFFSET = 0IM $      _RETAIN_LOOP_2:                  ! now get list of users for the group!3 $      ELEMENT = F$ELEMENT(OFFSET,",",MAIL_GROUPS)  2 $      IF ELEMENT .EQS. "," THEN GOTO _DONE_RETAIN* $      GROUP_NUMBER = MAIL_GROUP_'ELEMENT'$ $      IF MAIL_USERS .EQS. "<none>"  $      THEN 6 $         MAIL_USERS = MAIL_GROUP_USERS_'GROUP_NUMBER' $      ELSEaI $         MAIL_USERS = MAIL_USERS + "," + MAIL_GROUP_USERS_'GROUP_NUMBER'Y $      ENDIF $      OFFSET = OFFSET + 1 $      GOTO _RETAIN_LOOP_2* $    ENDIF ! if database = db_name_'count' $    COUNT = COUNT + 1N $    IF COUNT .LE. DB_NAME_COUNT THEN GOTO _RETAIN_LOOP  ! check next database $  ELSE ! retain' $    MAIL_NUMBER = MAIL_GROUP_'GRPNAME'T1 $    MAIL_USERS  = MAIL_GROUP_USERS_'MAIL_NUMBER'( $  ENDIF ! retain1 $=# $  IF F$ELEMENT(1,"=",P3) .NES. "="D $  THEN % $    MAIL_USERS = F$ELEMENT(1,"=",P3)n $  ENDIF $R $_DONE_RETAIN: $E $"= $  IF F$TRNLNM("DSN_OUTFILE") .NES. "" THEN CLOSE DSN_OUTFILEF $  OPEN/APPEND DSN_OUTFILE 'P1'  $  WRITE DSN_OUTFILE "_____" $  WRITE DSN_OUTFILE ""d $t $  WRITE DSN_OUTFILE F$FAO("Message sent by DSNlink_NEW version !AS on node !AS, using:", DSNLINK_NEW_VERSION, F$GETSYI("NODENAME"))J $  WRITE DSN_OUTFILE F$FAO("  !14<Config file:!>!AS", DSN_CONFIG_FILENAME) $  IF PERFORMING_GET O $  THEN 4 $    WRITE DSN_OUTFILE "  Performing GET processing"% $    IF F$TYPE(GET_FILENAME) .NES. ""R	 $    THENSD $      WRITE DSN_OUTFILE F$FAO("  !14<Get file:!>!AS", GET_FILENAME)	 $    ELSE-; $      WRITE DSN_OUTFILE F$FAO("  !14<Get file:!><unknown>"S
 $    ENDIF $  ENDIF ! performing_getu) $  TMP_GROUP_COUNT = MAIL_GROUP_'GRPNAME'1W $  WRITE DSN_OUTFILE F$FAO("  !14<Mail group:!>!AS", MAIL_GROUP_NAME_'TMP_GROUP_COUNT'),- $  IF F$TYPE(ORIGINALLY_FROM) .NES. "" THEN -n-      IF ORIGINALLY_FROM .NES. USERNAME THEN -"D      WRITE DSN_OUTFILE F$FAO("  !14<Sent by:!>!AS", ORIGINALLY_FROM)~ $  IF PERFORMING_GET .AND. MAIL_GROUPS .NES. "<unknown>" THEN WRITE DSN_OUTFILE F$FAO("!15* = !AS", MAIL_GROUPS)  ! for RETAIN $C $  IF MAIL_USERS .EQS. "<none>"  $  THEN  $    MAIL_USERS = USERNAMEf $    WRITE DSN_OUTFILE "%DSNlink_NEW-E-MAILUSERS, Undefined mail users for this database; using SELF."Y $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-MAILUSERS, Undefined mail users for this database."D $  ENDIF $      $! $_ $  IF .NOT. PERFORMING_GET $  THEN & $    IF GRPNAME .NES. "$ERROR$" THEN -L        CALL _DISPLAY_DATABASES DSN_OUTFILE 2 "Databases:    " "''GRPNAME'" 2 $  A> $    WRITE DSN_OUTFILE F$FAO("  !14<Since:!>!AS (!AS, !AS)", -        DSN_SINCE, -O(        F$CVTIME(DSN_SINCE,,"WEEKDAY"), --        F$CVTIME(DSN_SINCE,"ABSOLUTE","DATE"))D% $    IF DSN_HISTORY_FILE .NES. "NONE"T	 $    THEN T $      WRITE DSN_OUTFILE F$EXTRACT(0,79,F$FAO("  !14<History:!>!AS  (!UL blocks)", -G           DSN_HISTORY_FILE, F$FILE_ATTRIBUTES(DSN_HISTORY_FILE,"EOF"))) 	 $    ELSEI6 $      WRITE DSN_OUTFILE F$FAO("  !14<History:!>NONE")% $    ENDIF ! history enabled/disabled  $  ENDIF ! performing GET  $.* $  IF BATCH .AND. GRPNAME .EQS. "$ERROR$"  $  THEN  $    WRITE DSN_OUTFILE F$FAO("  !14<Log file:!>!AS", F$PARSE(F$GETQUI("DISPLAY_JOB","LOG_SPECIFICATION",,"THIS_JOB"),LOG_FILE)) . $    IF "''ORIGINAL_GET_FILE'" .NES. "" THEN -L      WRITE DSN_OUTFILE F$FAO("  !14<Orig GET file:!>!AS", ORIGINAL_GET_FILE) $  ENDIF $T= $  IF EXCEEDED_RETRY_LIMIT .AND. (.NOT. RECEIVED_FATAL_ERROR)  $  THEN  $    WRITE DSN_OUTFILE "" E $    WRITE DSN_OUTFILE "%DSNlink_NEW-E-EXRETRY, Exceeded retry limit"L $    WRITE DSN_OUTFILE ""l $  ENDIF $  IF RECEIVED_FATAL_ERROR $  THENT $    WRITE DSN_OUTFILE ""D` $    WRITE DSN_OUTFILE "%DSNlink_NEW-E-NORETRY, Received fatal error - aborting retry attempts." $    WRITE DSN_OUTFILE ""a $  ENDIF $r $  IF DSN_ATTEMPT_COUNT .GT. 0 I $  THEN  $    IF MAX_EXC_COUNT .GT. 0	 $    THENIp $      WRITE DSN_OUTFILE F$FAO("Total connect time: !8AS, !UL reconnection!%S.  !UL total articles excluded.", -I        TOTAL_ELAPSED_CONN_TIME, DSN_RETRY_COUNT, TOTAL_EXCLUDED_ARTICLES) 	 $    ELSE R $      WRITE DSN_OUTFILE F$FAO("Total connect time: !8AS, !UL reconnection!%S.", -0        TOTAL_ELAPSED_CONN_TIME, DSN_RETRY_COUNT)
 $    ENDIF $  ENDIF $  IF PERFORM_AUTO_COMPRESS THEN WRITE DSN_OUTFILE "History file auto-compression was triggered (history file > ", DSN_HISTORY_AUTO_COMPRESS, " blocks)."T $R $  CLOSE DSN_OUTFILE $: $  IF DEBUG  $  THEN L $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Mail message about to be sent:"H $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, +-+ begin mail message +-+" $    TYPE 'P1'F $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, -+- end mail message -+-" $  ENDIF $T$ $  IF F$SEARCH(TMP_YESFILE) .EQS. "" $  THENCL $    ! create file to 'feed' Mail in case a DECnet link is down -- this will $    ! answer Mail's question "!& $    OPEN/WRITE DSN_FILE 'TMP_YESFILE' $    WRITE DSN_FILE "Y"s $    CLOSE DSN_FILEw $  ENDIF $  o $  SET noONf+ $  DEFINE/USER_MODE SYS$INPUT 'TMP_YESFILE'E	 $  MAIL -T      'P1' -       "''MAIL_USERS'" -      /SUBJECT="''P2'" -c      /PERSONAL_NAME="''P4'" - 
      /noSELF L $  STATUS = $STATUST	 $  SET ONO $P
 $  IF STATUS I $  THEN _ $    WRITE SYS$OUTPUT F$FAO("%DSNlink_NEW-I-SENTMAIL, Message sent to user!0UL!%S !AS (!%T)", -C=      (F$LENGTH(MAIL_USERS) - F$LOCATE(",",MAIL_USERS) + 1), -"      MAIL_USERS, 0)UO $    WRITE SYS$OUTPUT F$FAO("-DSNlink_NEW-I-SENTMAIL, Mail subject: \!AS\", P2)M $  ENDIF $  T $  C% $  EXIT           ! SEND_MAIL_MESSAGES% $  ENDSUBROUTINE  ! SEND_MAIL_MESSAGEF $  $!CG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!_ $_COMPRESS_HISTORY:R# $  IF DSN_HISTORY_FILE .EQS. "NONE"! $  THEN!c $    WRITE SYS$OUTPUT "%DSNlink_NEW-W-COMPRESS, History is disabled in your configuration file, so"aR $    WRITE SYS$OUTPUT "-DSNlink_NEW-W-COMPRESS, no compression will be performed."$ $    RETURN  ! from COMPRESS_HISTORY $  ENDIF $   / $! if old format file, convert it to new formatEL $  IF F$FILE(DSN_HISTORY_FILE,"MRS") .EQ. 108 THEN GOSUB _NEW_HISTORY_FORMAT $Se $  WRITE SYS$OUTPUT F$FAO("%DSNlink_NEW-I-COMPRESS, Beginning to compress history file (size=!UL)", -I/      F$FILE_ATTRIBUTES(DSN_HISTORY_FILE,"EOF"))nO $  WRITE SYS$OUTPUT "-DSNlink_NEW-I-HISTORY, File ", F$SEARCH(DSN_HISTORY_FILE)N $TU $  TMP_SPEC_FILE = DSN_SCRATCH_DIR + "DSNLINK_NEW_SPEC_" + F$GETJPI(0,"PID") + ".TMP" X $  TMP_HIST_FILE = DSN_SCRATCH_DIR + "DSNLINK_NEW_HISTORY_" + F$GETJPI(0,"PID") + ".TMP"T $  TMP_FDL_FILE  = DSN_SCRATCH_DIR + "DSNLINK_NEW_FDL_" + F$GETJPI(0,"PID") + ".TMP" $L& $  OPEN/WRITE DSN_FILE 'TMP_SPEC_FILE'A $  WRITE DSN_FILE "/FIELD=(NAME=HISTORY_DATE,POSITION:1,SIZE:10)"P> $  WRITE DSN_FILE "/FIELD=(NAME=DATABASE,POSITION:10,SIZE:32)"; $  WRITE DSN_FILE "/FIELD=(NAME=TITLE,POSITION:42,SIZE:78)"hC $  WRITE DSN_FILE "/FIELD=(NAME=DATABASE_KEY,POSITION:10,SIZE:110)" ' $  WRITE DSN_FILE "/KEY=(DATABASE_KEY)" k $  WRITE DSN_FILE "/CONDITION=(NAME=KEEP_RECORD,TEST=(HISTORY_DATE GE ", QUOTE, ALLOW_IF_OLDER, QUOTE, "))"!4 $  WRITE DSN_FILE "/INCLUDE=(CONDITION=KEEP_RECORD)" $  CLOSE DSN_FILE  $WE $! generate an FDL, and 'tune' it (using EDIT/FDL/noINTERACTIVE) bests $! we can for repopulation; $  ANALYZE/RMS/FDL/OUTPUT='TMP_FDL_FILE' 'DSN_HISTORY_FILE'W* $  SET FILE/VERSION_LIMIT=2 'TMP_FDL_FILE'? $  EDIT/FDL/noINTERACTIVE/ANALYZE='TMP_FDL_FILE' 'TMP_FDL_FILE'l, $  CREATE/FDL='TMP_FDL_FILE' 'TMP_HIST_FILE' $rK $  MERGE/SPECIFICATION='TMP_SPEC_FILE'/STATISTICS/STABLE/noCHECK_SEQUENCE -G      'DSN_HISTORY_FILE' -X      'TMP_HIST_FILE'/OVERLAY $IC $! a lot of records have been removed by the MERGE, so re-tune the !9 $! file and use Convert to move it to its normal location!8 $  ANALYZE/RMS/FDL/OUTPUT='TMP_FDL_FILE' 'TMP_HIST_FILE'? $  EDIT/FDL/noINTERACTIVE/ANALYZE='TMP_FDL_FILE' 'TMP_FDL_FILE'T@ $  CONVERT/FDL='TMP_FDL_FILE' 'TMP_HIST_FILE' 'DSN_HISTORY_FILE' $w< $  DELETE 'TMP_SPEC_FILE';,'TMP_FDL_FILE';*,'TMP_HIST_FILE'; $  PURGE 'DSN_HISTORY_FILE' 1 $  RENAME 'DSN_HISTORY_FILE' 'DSN_HISTORY_FILE';1S $Tg $  WRITE SYS$OUTPUT F$FAO("!/%DSNlink_NEW-S-COMPRESS, Compression has completed normally (size=!UL)", -Y/      F$FILE_ATTRIBUTES(DSN_HISTORY_FILE,"EOF"))A $E $  FINISHED_OK = TRUEO" $  RETURN  ! from COMPRESS_HISTORY $  $! G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!l $_INIT_DEFAULTS: $f $  TRUE  = 1 $  FALSE = 0 $ M $  FINISHED_OK = FALSE  ! indicate we failed in case we error out prematurely  $ 3 $  USERNAME = F$EDIT(F$GETJPI(0,"USERNAME"),"TRIM")N $T $!!! $  $  PERFORMING_GET = FALSE  $  CHECKING_DATABASES = FALSET $  PRIB = F$GETJPI(0,"PRIB") $"$ $  IF F$TRNLNM("DSNLINK_NEW_DEBUG")  $  THENW $    DEBUG = TRUE  $    DEBUG_LOG = "/LOG"IL $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, DSNlink_NEW debugging enabled." $  ELSEE $    DEBUG = FALSE $    DEBUG_LOG = ""L $  ENDIF $MI $  DSNLINK_DIRECTORY = F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"DEVICE") + -u6      F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"DIRECTORY")1 $  IF F$TRNLNM("DSNLINK_NEW_DIR") .NES. "" THEN - 4      DSNLINK_DIRECTORY = F$TRNLNM("DSNLINK_NEW_DIR") $! $  DSN_RETRY_MAX = 53 $  IF F$TRNLNM("DSNLINK_NEW_RETRY") .NES. "" THEN -_2      DSN_RETRY_MAX = F$TRNLNM("DSNLINK_NEW_RETRY") $S $  DSN_SINCE = "TODAY-10-00:00" 3 $  IF F$TRNLNM("DSNLINK_NEW_SINCE") .NES. "" THEN -O.      DSN_SINCE = F$TRNLNM("DSNLINK_NEW_SINCE") $X $  DSN_MAIL_EMPTY = FALSEG8 $  IF F$TRNLNM("DSNLINK_NEW_MAIL_EMPTY") .NES. "" THEN -8      DSN_MAIL_EMPTY = F$TRNLNM("DSNLINK_NEW_MAIL_EMPTY") $E" $  DSN_AFTER = "TOMORROW+01:00:00"3 $  IF F$TRNLNM("DSNLINK_NEW_AFTER") .NES. "" THEN -P.      DSN_AFTER = F$TRNLNM("DSNLINK_NEW_AFTER") $ 1 $  DSN_RETRY_WAIT_TIME = "00:00:30"  ! 30 secondsE7 $  IF F$TRNLNM("DSNLINK_NEW_WAIT_TIME") .NES. "" THEN -W<      DSN_RETRY_WAIT_TIME = F$TRNLNM("DSNLINK_NEW_WAIT_TIME") $ C $  DSN_HISTORY_FILE = "''DSNLINK_DIRECTORY'DSNLINK_NEW_HISTORY.DAT"R5 $  IF F$TRNLNM("DSNLINK_NEW_HISTORY") .NES. "" THEN -!Q      DSN_HISTORY_FILE = F$PARSE(F$TRNLNM("DSNLINK_NEW_HISTORY"),DSN_HISTORY_FILE)L $"" $  DSN_HISTORY_AUTO_COMPRESS = 300; $  IF F$TRNLNM("DSNLINK_NEW_AUTO_COMPRESS") .NES. "" THEN -OQ      DSN_HISTORY_AUTO_COMPRESS = F$INTEGER(F$TRNLNM("DSNLINK_NEW_AUTO_COMPRESS"))  $R  $  DSN_CHECK_OPENCALLS = "Never"= $  IF F$TRNLNM("DSNLINK_NEW_CHECK_OPENCALLS") .NES. "" THEN -CB      DSN_CHECK_OPENCALLS = F$TRNLNM("DSNLINK_NEW_CHECK_OPENCALLS")& $  DSN_CHECK_OPENCALLS_USER = USERNAME $E" $  DSN_CHECK_CLOSEDCALLS = "Never"? $  IF F$TRNLNM("DSNLINK_NEW_CHECK_CLOSEDCALLS") .NES. "" THEN -'F      DSN_CHECK_CLOSEDCALLS = F$TRNLNM("DSNLINK_NEW_CHECK_CLOSEDCALLS")( $  DSN_CHECK_CLOSEDCALLS_USER = USERNAME $   $  DSN_CHECK_DATABASES = "Never"= $  IF F$TRNLNM("DSNLINK_NEW_CHECK_DATABASES") .NES. "" THEN -IB      DSN_CHECK_DATABASES = F$TRNLNM("DSNLINK_NEW_CHECK_DATABASES")& $  DSN_CHECK_DATABASES_USER = USERNAME^ $  DSN_CHECK_DATABASES_FILE_DEFAULT = F$PARSE(DSNLINK_DIRECTORY + "DSNLINK_NEW_DATABASES.DAT")\ $  DSN_CHECK_DATABASES_FILE = DSN_CHECK_DATABASES_FILE_DEFAULT  ! until we're told otherwise $  FE $  DSN_CONFIG_FILENAME = F$PARSE(P1,F$TRNLNM("DSNLINK_NEW_CONFIG"), -!2      "''DSNLINK_DIRECTORY'DSNLINK_NEW_CONFIG.DAT") $I3 $  LOG_FILE = "''DSNLINK_DIRECTORY'DSNLINK_NEW.LOG"  $u) $  GET_FILE = "SYS$LOGIN:DSNLINK_GET.DAT" 6 $  IF F$TRNLNM("DSNLINK_NEW_GET_FILE") .NES. "" THEN -B      GET_FILE = F$PARSE(F$TRNLNM("DSNLINK_NEW_GET_FILE"),GET_FILE) $R1 $  GET_LOG_FILE = "SYS$LOGIN:DSNLINK_NEW_GET.LOG"N: $  IF F$TRNLNM("DSNLINK_NEW_GET_LOG_FILE") .NES. "" THEN -N      GET_LOG_FILE = F$PARSE(F$TRNLNM("DSNLINK_NEW_GET_LOG_FILE"),GET_LOG_FILE) $E $  LOW_PRIORITY = PRIB< $  IF F$TRNLNM("DSNLINK_NEW_BATCH_PRIORITY") .NES. "" THEN -E      LOW_PRIORITY = F$INTEGER(F$TRNLNM("DSNLINK_NEW_BATCH_PRIORITY"))S $n3 $  DSN_SCRATCH_DIR = F$PARSE("DSN$SCRATCH:") - ".;"!T $  IF DSN_SCRATCH_DIR .EQS. "" THEN DSN_SCRATCH_DIR = F$PARSE("SYS$SCRATCH:") - ".;"R $  IF DSN_SCRATCH_DIR .EQS. "" THEN DSN_SCRATCH_DIR = F$PARSE("SYS$LOGIN:") - ".;"G $  IF DSN_SCRATCH_DIR .EQS. "" THEN DSN_SCRATCH_DIR = DSNLINK_DIRECTORY!9 $  IF F$TRNLNM("DSNLINK_NEW_SCRATCH_DIR") .NES. "" THEN -IJ      DSN_SCRATCH_DIR = F$PARSE(F$TRNLNM("DSNLINK_NEW_SCRATCH_DIR")) - ".;" $\K $! undocumented symbol DSN$VERSION (only works with DSNlink V1.2 and above)!O $  DSN$VERSION = "V1.1"       ! assume we're running V1.1 unless told otherwiseE $SL $! disable error handling in case the DSN command doesn't exist (we haven't K $! tested for SYS$SYSTEM:DSN$MAIN.EXE yet), and also disable error handlingtH $! in case DSN SHOW VERSION doesn't work (it is apparently undocumented) $  SET noON         $ $  DEFINE/USER_MODE SYS$OUTPUT NLA0:# $  DEFINE/USER_MODE SYS$ERROR NLA0:N $  DSN SHOW VERSION$	 $  SET ON=q $  IF F$TRNLNM("SYS$OUTPUT","LNM$PROCESS_TABLE",,,,"ACCESS_MODE") .EQS. "USER" THEN DEASSIGN/USER_MODE SYS$OUTPUT o $  IF F$TRNLNM("SYS$ERROR","LNM$PROCESS_TABLE",,,,"ACCESS_MODE") .EQS. "USER" THEN DEASSIGN/USER_MODE SYS$ERRORO $UI $! determine the get-style we'll use.  If it is an old version of DSNlinkBK $! (less than V1.2) we have to use EXTRACT:  DSNlink V1.0 (which isn't usedNK $! anywhere as far as I know) doesn't allow READ/EDIT, and DSNlink V1.1 andTF $! V1.1-1 have a bug preventing READ/EDIT from working with EDT as theE $! editor (which is how we're doing GET Processing with DSNlink_NEW).a $! V1.2A also has the problemD $  GET_STYLE = "EDT"H $  IF F$EXTRACT(1,-1,DSN$VERSION) .LTS. "1.2" THEN GET_STYLE = "EXTRACT"I $  IF F$EXTRACT(1,-1,DSN$VERSION) .EQS. "1.2A" THEN GET_STYLE = "EXTRACT"SB $  WRITE_TITLES = ""  ! null filename = don't write titles to file $ H $  FAO_SUBJECT = "!+!+!UL new !AS DSNlink article!%S in !UL database!%S"3 $  FAO_PERSONAL = "!+!+DSNlink article!0UL!%S, !AS"E $  FAO_GET_SUBJECT = "!AS: !AS"G, $  FAO_GET_PERSONAL = "!AS database article" $R $  QUOTE[0,8] = 34 $  EXCEEDED_RETRY_LIMIT = FALSEg $  RECEIVED_FATAL_ERROR = FALSE ! $  ELAPSED_CONN_TIME = "00:00:00"E' $  TOTAL_ELAPSED_CONN_TIME = "00:00:00"_  $  PERFORM_AUTO_COMPRESS = FALSE $  DSN_RETRY_COUNT = 0 $  DSN_ATTEMPT_COUNT = 0 $GV $  ERROR_MESSAGE = "%DSNlink_NEW-?-UNK, Unknown/unexpected error.  Please investigate" $  EXCLUDE_WARNING = TRUEI $  TOTAL_EXCLUDED_ARTICLES = 0 $TT $  TMP_MAILFILE    = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_1.TMP"T $  TMP_ERRORFILE   = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_2.TMP"T $  TMP_DSNFILE     = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_3.TMP"T $  TMP_CHECKFILE   = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_4.TMP"T $  TMP_OUTFILE     = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_5.TMP"T $  TMP_EXTRACTFILE = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_6.TMP"T $  TMP_YESFILE     = DSN_SCRATCH_DIR + "DSNLINK_NEW_" + F$GETJPI(0,"PID") + "_7.TMP" $T- $  INTERACTIVE = F$MODE() .EQS. "INTERACTIVE" ! $  BATCH = F$MODE() .EQS. "BATCH"!5 $  ASK := READ SYS$COMMAND/END_OF_FILE=_ABORT/PROMPT=E $F $  SS$_NORMAL      = %X00000001e $  SS$_ABORT       = %X0000002CB $  SS$_NOSUCHFILE  = %X00000912L $  SS$_BADPARAM    = %X00000012: $  STS$M_INHIB_MSG = %X10000000  $Ey $  TOO_LONG_CHAR  = "~"       ! used by GET Processing on lines that are too long for VMSmail Subject and Personal lines.U $D& $  RETURN      ! leaving INIT_DEFAULTS $" $! G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!a $_INIT_PARSE_CONFIG_FILE:! $!? $  IF BATCH THEN SET RESTART_VALUE="Reading configuration file" 6 $  DSN_CONFIG_FILENAME = F$SEARCH(DSN_CONFIG_FILENAME)P $  WRITE SYS$OUTPUT F$FAO("  !24<Configuration file:!>!AS", DSN_CONFIG_FILENAME)> $  OPEN/READ/ERROR=_ERROR DSN_CONFIGFILE 'DSN_CONFIG_FILENAME' $  DB_NAME_COUNT = 0 $  MAIL_GROUP_COUNT = 0t $  EXC_COUNT = 0 $  CONFIG_ERROR = FALSEs $  LINE_NUMBER = 0 $    $_PARSE_CONFIG_LOOP:  $  LINE_NUMBER = LINE_NUMBER + 1M $  READ/ERROR=_ERROR/END_OF_FILE=_END_PARSE_CONFIG DSN_CONFIGFILE ORIG_RECORDS9 $  RECORD = F$EDIT(ORIG_RECORD,"COMPRESS,TRIM,UNCOMMENT")N2 $  IF RECORD .EQS. "" THEN GOTO _PARSE_CONFIG_LOOP $  VALID_RECORD = FALSE$ $T1 $  PARM1 = F$EDIT(F$ELEMENT(0," ",RECORD),"TRIM")P1 $  PARM2 = F$EDIT(F$ELEMENT(1," ",RECORD),"TRIM")o1 $  PARM3 = F$EDIT(F$ELEMENT(2," ",RECORD),"TRIM")N1 $  PARM4 = F$EDIT(F$ELEMENT(3," ",RECORD),"TRIM") $ $  PARM1_UP = F$EDIT(PARM1,"UPCASE")$ $  PARM2_UP = F$EDIT(PARM2,"UPCASE") $sN $  IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-READ, Record \", RECORD, "\" $  $! $!!! $! $ $ $  IF F$EXTRACT(0,1,PARM1) .NES. "." $  THEN  ! it's a databaseK $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Database: \", -MG      PARM1, "\", ", Group: \", PARM3, "\, Flash: ", PARM2 .EQS. "FLASH"_# $    PARM2 = F$EDIT(PARM2,"UPCASE")_7 $    IF PARM2 .NES. "FLASH" .AND. PARM2 .NES. "NOFLASH" 	 $    THENIc $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Database ", PARM1, " missing FLASH/NOFLASH setting"A $      CONFIG_ERROR = TRUE3 $    ENDIF ! if parm2 <> flash and parm2 <> noflashI$ $    DB_NAME_'DB_NAME_COUNT' = PARM13 $    DB_FLASH_'DB_NAME_COUNT' = PARM2 .EQS. "FLASH"D$ $    DB_MAIL_'DB_NAME_COUNT' = PARM3 $    COUNT = 0 $    _CONFIG_DB_LOOP:S, $    CHECK_MAIL = F$ELEMENT(COUNT,",",PARM3)T $    IF CHECK_MAIL .EQS. "," .OR. CHECK_MAIL .EQS. " " THEN GOTO _END_CONFIG_DB_LOOP0 $    IF F$TYPE(MAIL_GROUP_'CHECK_MAIL') .EQS. ""	 $    THEN r $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Database ", PARM1, " uses undefined mail group \", CHECK_MAIL, "\" $      CONFIG_ERROR = TRUE	 $    ELSEN* $      TMP_COUNT = MAIL_GROUP_'CHECK_MAIL'6 $      IF MAIL_GROUP_NAME_'TMP_COUNT' .NES. CHECK_MAIL $      THENEv $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Database ", PARM1, " has incorrect case for mail group ", CHECK_MAIL $        WRITE SYS$OUTPUT "-DSNlink_NEW-E-CONFIG, Case of \", CHECK_MAIL, "\ is different from \", MAIL_GROUP_NAME_'TMP_COUNT', "\"  $        CONFIG_ERROR = TRUE $      ENDIF
 $    ENDIF $    COUNT = COUNT + 1 $    GOTO _CONFIG_DB_LOOPF $    _END_CONFIG_DB_LOOP:,& $    DB_NAME_COUNT = DB_NAME_COUNT + 1B $    GOTO _PARSE_CONFIG_LOOP                 ! to speed up parsing $  ENDIF  ! extract <> "." $W $  IF PARM1_UP .EQS. ".MAIL" $  THEN> $    IF DEBUG 
 $    THEN e $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Mail group name: \", PARM2, "\, Users: \", PARM3, "\"Oa $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, assigned to mail group number ", MAIL_GROUP_COUNT  $    ENDIF ! debug+ $    IF F$TYPE(MAIL_GROUP_'PARM2') .NES. ""s	 $    THENa` $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Multiple definition of mail group \", PARM2, "\" $      CONFIG_ERROR = TRUE
 $    ENDIFY $    IF PARM2_UP .EQS. "SELF" .OR. PARM2_UP .EQS. "RETAIN" .OR. PARM2_UP .EQS. "SPECIFIC" 	 $    THENTd $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, SELF, RETAIN, and SPECIFIC are illegal mail groups." $      CONFIG_ERROR = TRUE
 $    ENDIF/ $    MAIL_GROUP_NAME_'MAIL_GROUP_COUNT' = PARM2 0 $    MAIL_GROUP_USERS_'MAIL_GROUP_COUNT' = PARM3* $    MAIL_GROUP_'PARM2' = MAIL_GROUP_COUNT, $    MAIL_GROUP_COUNT = MAIL_GROUP_COUNT + 1B $    GOTO _PARSE_CONFIG_LOOP                 ! to speed up parsing $  ENDIF $I $  IF PARM1_UP .EQS. ".RETRY"  $  THENS% $    DSN_RETRY_MAX = F$INTEGER(PARM2)1Y $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Retry set to ", DSN_RETRY_MAX  $    VALID_RECORD = TRUE $  ENDIF $$  $  IF PARM1_UP .EQS. ".LOG_FILE" $  THEN"' $    LOG_FILE = F$PARSE(PARM2,LOG_FILE)DW $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, LOG file set to ", LOG_FILE. $    VALID_RECORD = TRUE $  ENDIF $F  $  IF PARM1_UP .EQS. ".GET_FILE" $  THENG' $    GET_FILE = F$PARSE(PARM2,GET_FILE)TW $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, GET file set to ", GET_FILEW $    VALID_RECORD = TRUE $  ENDIF $Y$ $  IF PARM1_UP .EQS. ".GET_LOG_FILE" $  THENE/ $    GET_LOG_FILE = F$PARSE(PARM2,GET_LOG_FILE)E $    IF GET_LOG_FILE .EQS. "" 	 $    THEND $      VALID_RECORD = FALSERS $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Invalid get log file \", PARM2, "\" 	 $    ELSE a $      IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, GET log file set to ", GET_LOG_FILED $      VALID_RECORD = TRUE
 $    ENDIF $  ENDIF $n' $  IF PARM1_UP .EQS. ".GET_DELETE_TYPE", $  THEN ^ $    IF PARM2_UP .NES. "IMMEDIATE" .AND. PARM2_UP .NES. "NEVER" .AND. PARM2_UP .NES. "SUCCESS"	 $    THENFH $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Invalid GET_DELETE_TYPE"Z $      WRITE SYS$OUTPUT "-DSNlink_NEW-E-CONFIG, Valid types are IMMEDIATE, NEVER, SUCCESS" $      VALID_RECORD = FALSEa	 $    ELSEs $      GET_DELETE_TYPE = PARM2 $      VALID_RECORD = TRUE] $      IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, GET Delete Type set to ", PARM2%
 $    ENDIF $  ENDIF $   $  IF PARM1_UP .EQS. ".GET_TIME" $  THENO[ $    IF PARM2_UP .NES. "EVENING" .AND. PARM2_UP .NES. "NOW" .AND. PARM2_UP .NES. "TOMORROW"U	 $    THEN_ $      VALID_RECORD = FALSEsA $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Invalid GET_TIME"E[ $      WRITE SYS$OUTPUT "-DSNlink_NEW-E-CONFIG, Valid times are EVENING, NOW, and TOMORROW"e	 $    ELSEe $      VALID_RECORD = TRUE $      GET_TIME = PARM2 Y $      IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, GET TIME set to ", GET_TIMED
 $    ENDIF $  ENDIF $E# $  IF PARM1_UP .EQS. ".SCRATCH_DIR"A $  THEN" $    DSN_SCRATCH_DIR = PARM2_UP g $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, SCRATCH directory set to ", DSN_SCRATCH_DIR 7 $    VALID_RECORD = TRUE  ! until one of the tests faile) $    IF F$PARSE(DSN_SCRATCH_DIR) .EQS. "" 	 $    THENHU $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, .SCRATCH_DIR isn't a valid directory"OU $      WRITE SYS$OUTPUT "-DSNlink_NEW-E-CONFIG, .SCRATCH_DIR value is: \''PARM2_UP'\"  $      VALID_RECORD = FALSE_
 $    ENDIF $  ENDIF $E $  IF PARM1_UP .EQS. ".SINCE"C $  THEN!W $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Since set to \", PARM2, "\"  $    DSN_SINCE = PARM2 $    VALID_RECORD = TRUE $  ENDIF $T" $  IF PARM1_UP .EQS. ".MAIL_EMPTY" $  THENb] $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Mail emptry set to \", PARM2, "\"s $    DSN_MAIL_EMPTY = PARM2  $    VALID_RECORD = TRUE $  ENDIF $D$ $  IF PARM1_UP .EQS. ".WRITE_TITLES" $  THENn> $    WRITE_TITLES = F$PARSE(PARM2,"SYS$LOGIN:DSNLINK_GET.DAT")k $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Titles will be written to \", WRITE_TITLES, "\"r $    VALID_RECORD = TRUE $  ENDIF $R& $  IF PARM1_UP .EQS. ".NEXT_EXECUTION" $  THENT` $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Next execution set to \", PARM2, "\" $    DSN_AFTER = PARM2 $    VALID_RECORD = TRUE $  ENDIF $T$ $  IF PARM1_UP .EQS. ".HISTORY_FILE" $  THENIZ $    DSN_HISTORY_FILE = F$PARSE(PARM2,"''DSNLINK_DIRECTORY'DSNLINK_NEW_HISTORY.DAT") - ";"J $    IF F$EDIT(PARM2,"UPCASE") .EQS. "NONE" THEN DSN_HISTORY_FILE = "NONE"i $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, History file set to \", DSN_HISTORY_FILE, "\"E $    VALID_RECORD = TRUE $  ENDIF $L' $  IF PARM1_UP .EQS. ".RETRY_WAIT_TIME") $  THENIa $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Retry wait time set to \", PARM2, "\"E  $    DSN_RETRY_WAIT_TIME = PARM2 $    VALID_RECORD = TRUE $  ENDIF $   - $  IF PARM1_UP .EQS. ".HISTORY_AUTO_COMPRESS"E $  THEN g $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, History auto compress set to \", PARM2, "\"/1 $    DSN_HISTORY_AUTO_COMPRESS = F$INTEGER(PARM2)n $    VALID_RECORD = TRUE $  ENDIF $L' $  IF PARM1_UP .EQS. ".CHECK_OPENCALLS"O $  THEN , $    IF PARM3 .EQS. "" THEN PARM3 = USERNAMEp $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Check opencalls: \", PARM2, "\, user: \", PARM3, "\"  $    DSN_CHECK_OPENCALLS = PARM2 $    ! now validate it $    COUNT = 0E $    VALID_RECORD = TRUE    ! assume the best unless proven otherwiseo $    _CONFIG_OPENCALLS_LOOP:5 $    CHECK = F$ELEMENT(COUNT,",",DSN_CHECK_OPENCALLS)l5 $    IF CHECK .EQS. "," THEN GOTO _EXIT_CFG_OPENCALLS_% $    IF F$TYPE(CHECK) .EQS. "INTEGER"N	 $    THENFC $    ! day of month.  Don't allow anything > 28 because of FebruaryE $      CHECK = F$INTEGER(CHECK)T) $      IF CHECK .LT. 1 .OR. CHECK .GT. 28S $      THENPZ $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Value for Check_OpenCalls must be 1-28.") $        WRITE SYS$OUTPUT "\", CHECK, "\"  $        VALID_RECORD = FALSEl $      ENDIF	 $    ELSEF* $    ! day of week (Monday, Tuesday, wec.)[ $      VALID_DAYS = "Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday,Always,Never"!} $      IF F$LOCATE("," + F$EDIT(CHECK,"UPCASE") + ",", "," + F$EDIT(VALID_DAYS,"UPCASE") + ",") .EQ. F$LENGTH(VALID_DAYS) + 2L $      THENec $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Valid days for Check_OpenCalls are: ", VALID_DAYSN) $        WRITE SYS$OUTPUT "\", CHECK, "\"  $        VALID_RECORD = FALSE  $      ENDIF $    ENDIF ! type is integer $    COUNT = COUNT + 1  $    GOTO _CONFIG_OPENCALLS_LOOP $    _EXIT_CFG_OPENCALLS: % $    DSN_CHECK_OPENCALLS_USER = PARM3U/ $    IF DSN_CHECK_OPENCALLS_USER .NES. USERNAME / $    THEN      ! specified a different usernameM4 $      AUTHPRIV = "," + F$GETJPI(0,"AUTHPRIV") + ","G $      IF F$LOCATE(",CMKRNL,",AUTHPRIV) .EQ. F$LENGTH(AUTHPRIV) .AND. -O?           F$LOCATE(",SETPRV,",AUTHPRIV) .EQ. F$LENGTH(AUTHPRIV)N1 $      THEN  ! don't have the necessary privilege , $        DSN_CHECK_OPENCALLS_USER = USERNAME, $        IF (DEBUG) .OR. (.NOT. INTERACTIVE) $        THEN w $          WRITE SYS$OUTPUT "%DSNlink_NEW-W-CONFIG, CHECK_OPENCALLS needs CMKRNL or SETPRV to specify a different user"Nv $          WRITE SYS$OUTPUT "-DSNlink_NEW-W-CONFIG, CHECK_OPENCALLS output will be sent to ", DSN_CHECK_OPENCALLS_USER $        ENDIF ! debug $      ENDIF ! no priv $    ENDIF ! different username= $  ENDIF ! check_opencalls $R) $  IF PARM1_UP .EQS. ".CHECK_CLOSEDCALLS"  $  THENA, $    IF PARM3 .EQS. "" THEN PARM3 = USERNAMEr $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Check closedcalls: \", PARM2, "\, user: \", PARM3, "\"" $    DSN_CHECK_CLOSEDCALLS = PARM2 $    ! now validate it $    COUNT = 0E $    VALID_RECORD = TRUE    ! assume the best unless proven otherwiseN $    _CONFIG_CLOSEDCALLS_LOOP:7 $    CHECK = F$ELEMENT(COUNT,",",DSN_CHECK_CLOSEDCALLS)I7 $    IF CHECK .EQS. "," THEN GOTO _EXIT_CFG_CLOSEDCALLSE% $    IF F$TYPE(CHECK) .EQS. "INTEGER"U	 $    THEN"C $    ! day of month.  Don't allow anything > 28 because of FebruaryN $      CHECK = F$INTEGER(CHECK) ) $      IF CHECK .LT. 1 .OR. CHECK .GT. 28  $      THENL\ $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Value for Check_ClosedCalls must be 1-28.") $        WRITE SYS$OUTPUT "\", CHECK, "\"E $        VALID_RECORD = FALSEC $      ENDIF	 $    ELSEI* $    ! day of week (Monday, Tuesday, wec.)[ $      VALID_DAYS = "Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday,Always,Never"D} $      IF F$LOCATE("," + F$EDIT(CHECK,"UPCASE") + ",", "," + F$EDIT(VALID_DAYS,"UPCASE") + ",") .EQ. F$LENGTH(VALID_DAYS) + 2  $      THEN e $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Valid days for Check_ClosedCalls are: ", VALID_DAYSE) $        WRITE SYS$OUTPUT "\", CHECK, "\"A $        VALID_RECORD = FALSEK $      ENDIF $    ENDIF ! type is integer $    COUNT = COUNT + 1" $    GOTO _CONFIG_CLOSEDCALLS_LOOP $    _EXIT_CFG_CLOSEDCALLS:I' $    DSN_CHECK_CLOSEDCALLS_USER = PARM3_1 $    IF DSN_CHECK_CLOSEDCALLS_USER .NES. USERNAME_/ $    THEN      ! specified a different usernameR4 $      AUTHPRIV = "," + F$GETJPI(0,"AUTHPRIV") + ","G $      IF F$LOCATE(",CMKRNL,",AUTHPRIV) .EQ. F$LENGTH(AUTHPRIV) .AND. --?           F$LOCATE(",SETPRV,",AUTHPRIV) .EQ. F$LENGTH(AUTHPRIV)L1 $      THEN  ! don't have the necessary privilegeT. $        DSN_CHECK_CLOSEDCALLS_USER = USERNAME, $        IF (DEBUG) .OR. (.NOT. INTERACTIVE) $        THEN y $          WRITE SYS$OUTPUT "%DSNlink_NEW-W-CONFIG, CHECK_CLOSEDCALLS needs CMKRNL or SETPRV to specify a different user"Nz $          WRITE SYS$OUTPUT "-DSNlink_NEW-W-CONFIG, CHECK_CLOSEDCALLS output will be sent to ", DSN_CHECK_CLOSEDCALLS_USER $        ENDIF ! debug $      ENDIF ! no priv $    ENDIF ! different usernameT $  ENDIF ! check_closedcalls $I' $  IF PARM1_UP .EQS. ".CHECK_DATABASES"( $  THENN- $    IF PARM3 .EQS. "" THEN PARM3 = "$ERROR$" _ $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Check new databases: \", PARM2, "\"   $    DSN_CHECK_DATABASES = PARM2O $    DSN_CHECK_DATABASES_FILE = F$PARSE(PARM4,DSN_CHECK_DATABASES_FILE_DEFAULT)( $    ! now validate it $    COUNT = 0E $    VALID_RECORD = TRUE    ! assume the best unless proven otherwise  $    _CONFIG_DATABASES_LOOP:5 $    CHECK = F$ELEMENT(COUNT,",",DSN_CHECK_DATABASES)a5 $    IF CHECK .EQS. "," THEN GOTO _EXIT_CFG_DATABASES % $    IF F$TYPE(CHECK) .EQS. "INTEGER"e	 $    THENEC $    ! day of month.  Don't allow anything > 28 because of February  $      CHECK = F$INTEGER(CHECK)T) $      IF CHECK .LT. 1 .OR. CHECK .GT. 28N $      THEN Z $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Value for Check_databases must be 1-28.") $        WRITE SYS$OUTPUT "\", CHECK, "\"  $        VALID_RECORD = FALSEN $      ENDIF	 $    ELSES* $    ! day of week (Monday, Tuesday, wec.)[ $      VALID_DAYS = "Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday,Always,Never" } $      IF F$LOCATE("," + F$EDIT(CHECK,"UPCASE") + ",", "," + F$EDIT(VALID_DAYS,"UPCASE") + ",") .EQ. F$LENGTH(VALID_DAYS) + 2E $      THENic $        WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Valid days for Check_databases are: ", VALID_DAYSh) $        WRITE SYS$OUTPUT "\", CHECK, "\"l $        VALID_RECORD = FALSEh $      ENDIF $    ENDIF ! type is integer $    COUNT = COUNT + 1  $    GOTO _CONFIG_DATABASES_LOOP $    _EXIT_CFG_DATABASES:D% $    DSN_CHECK_DATABASES_USER = PARM3 > $    IF F$TYPE(MAIL_GROUP_'DSN_CHECK_DATABASES_USER') .EQS. ""	 $    THEN d $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, No such mail group \", DSN_CHECK_DATABASES_USER, "\" $      VALID_RECORD = FALSE!
 $    ENDIF $  ENDIF ! check_databases $F# $  IF PARM1_UP .EQS. ".FAO_SUBJECT"l $  THEN 1 $    FAO_SUBJECT = F$ELEMENT(1,QUOTE,ORIG_RECORD)  $    IF DEBUG 
 $    THEN W $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, FAO Subject set to \", FAO_SUBJECT, "\"RU $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, FAO test (11,22,33,SYSTEMS,88): \", -R7      F$FAO(FAO_SUBJECT, 11, 22, 33, "SYSTEMS", 88), "\"rU $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, FAO test (1,1,1,SYSTEMS,1)    : \", - 3      F$FAO(FAO_SUBJECT, 1, 1, 1, "SYSTEMS", 1), "\" 
 $    ENDIF $    VALID_RECORD = TRUE $  ENDIF $=$ $  IF PARM1_UP .EQS. ".FAO_PERSONAL" $  THEN"2 $    FAO_PERSONAL = F$ELEMENT(1,QUOTE,ORIG_RECORD) $    IF DEBUG 
 $    THEN Y $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, FAO Personal set to \", FAO_PERSONAL, "\""U $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, FAO test (11,22,33,SYSTEMS,88): \", -I8      F$FAO(FAO_PERSONAL, 11, 22, 33, "SYSTEMS", 88), "\"V $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, FAO test (1,1,1,SYSTEMS,1)     : \", -4      F$FAO(FAO_PERSONAL, 1, 1, 1, "SYSTEMS", 1), "\"
 $    ENDIF $    VALID_RECORD = TRUE $  ENDIF $F' $  IF PARM1_UP .EQS. ".FAO_GET_SUBJECT"S $  THENE5 $    FAO_GET_SUBJECT = F$ELEMENT(1,QUOTE,ORIG_RECORD)0
 $    IF DEBUG$	 $    THEN _ $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, FAO GET Subject set to \", FAO_GET_SUBJECT, "\"BP $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, FAO test (Database,Title): \", -.      F$FAO(FAO_GET_SUBJECT,"Database","Title")
 $    ENDIF $    VALID_RECORD = TRUE $  ENDIF $_( $  IF PARM1_UP .EQS. ".FAO_GET_PERSONAL" $  THEN!6 $    FAO_GET_PERSONAL = F$ELEMENT(1,QUOTE,ORIG_RECORD)
 $    IF DEBUG!	 $    THENCa $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, FAO GET Personal set to \", FAO_GET_PERSONAL, "\"GP $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, FAO test (Database,Title): \", -/      F$FAO(FAO_GET_PERSONAL,"Database","Title")I
 $    ENDIF $    VALID_RECORD = TRUE $  ENDIF $MC $! allow forced override of GET_STYLE (mostly for testing purposes)L! $  IF PARM1_UP .EQS. ".GET_STYLE"G $  THEN  $    GET_STYLE = PARM2_ $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Get style set to \", GET_STYLE, "\"  $    VALID_RECORD = TRUE $  ENDIF $O& $  IF PARM1_UP .EQS. ".BATCH_PRIORITY" $  THENC$ $    LOW_PRIORITY = F$INTEGER(PARM2)O $    IF (F$INTEGER(LOW_PRIORITY) .GT. PRIB) .AND. (.NOT. F$PRIVILEGE("ALTPRI"))N	 $    THENO] $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-PRIORITY, Priority setting of \", PARM2, "\ ignored.",h $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-PRIORITY, ", PARM2, " is larger than base priority (", PRIB, ")"] $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-PRIORITY, ALTPRI is required to set higher priority."  $      LOW_PRIORITY = PRIB
 $    ENDIF $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, Batch priority set to \", LOW_PRIORITY, "\ (current PRIB=", PRIB, ")": $    VALID_RECORD = TRUE $  ENDIF $F $  IF PARM1_UP .EQS. ".EXCLUDE", $  THEN_ $    VALID_RECORD = TRUEH $    EXCLUDE_ARTICLE_'EXC_COUNT' = F$EDIT(RECORD - PARM1 - PARM2,"TRIM")# $    EXCLUDE_DB_'EXC_COUNT' = PARM2,8 $    IF PARM2 .EQS. "*" THEN GOTO _END_EXC_DB_CHECK_LOOP $E $    CC = 0! $    _EXC_DB_CHECK_LOOP: $    IF F$TYPE(DB_NAME_'CC') .NES. "" THEN IF F$EDIT(PARM2,"UPCASE") .EQS. F$EDIT(DB_NAME_'CC',"UPCASE") THEN GOTO _END_EXC_DB_CHECK_LOOPP $    CC = CC + 1: $    IF CC .LT. DB_NAME_COUNT THEN GOTO _EXC_DB_CHECK_LOOP^ $    WRITE SYS$OUTPUT "%DSNlink_NEW-W-CONFIG, .EXCLUDE database /", PARM2, "/ is not defined." $    VALID_RECORD = FALSEU $C $    _END_EXC_DB_CHECK_LOOP:t $    IF F$LOCATE(QUOTE,EXCLUDE_ARTICLE_'EXC_COUNT') .NE. F$LENGTH(EXCLUDE_ARTICLE_'EXC_COUNT') .AND. EXCLUDE_WARNING	 $    THENN} $      WRITE SYS$OUTPUT "%DSNlink_NEW-W-CONFIG, Exclude on line ", LINE_NUMBER, " may unnecessarily include quote character."Ld $      WRITE SYS$OUTPUT "-DSNlink-NEW-W-CONFIG, Use .EXCLUDE_WARNING FALSE to disable this warning."
 $    ENDIFr $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Excluding article \", EXCLUDE_ARTICLE_'EXC_COUNT', "\" $    EXC_COUNT = EXC_COUNT + 1 $  ENDIF $ ' $  IF PARM1_UP .EQS. ".EXCLUDE_WARNING"  $  THEN A $    EXCLUDE_WARNING = 'PARM2_UP'       ! should be TRUE or FALSEDe $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, EXCLUDE_WARNING set to ", EXCLUDE_WARNINGe $    VALID_RECORD = TRUE $  ENDIF $" $W $  $! $!!! $! $. $  IF .NOT. VALID_RECORD   $  THEN e $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, Invalid record \", ORIG_RECORD, "\, line ", LINE_NUMBERR $    CONFIG_ERROR = TRUE $  ENDIF $l $  GOTO _PARSE_CONFIG_LOOP $aG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!M $_ $_END_PARSE_CONFIG:" $  CLOSE DSN_CONFIGFILEI$ $  DB_NAME_COUNT = DB_NAME_COUNT - 1* $  MAIL_GROUP_COUNT = MAIL_GROUP_COUNT - 1 $  EXC_COUNT = EXC_COUNT - 1 $  MAX_EXC_COUNT = EXC_COUNT $.* $  IF F$TYPE(MAIL_GROUP_$ERROR$) .EQS. ""  $  THENPJ $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-MISGRP, Missing $ERROR$ mail group." $    CONFIG_ERROR = TRUE $  ELSEi< $    IF MAIL_GROUP_NAME_'MAIL_GROUP_$ERROR$' .NES. "$ERROR$"	 $    THENRV $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-MISGRP, $ERROR$ mail group must be uppercase." $      CONFIG_ERROR = TRUE
 $    ENDIF $  ENDIF $_G $! the MX SITE agent's subprocess doesn't have SYS$LOGIN defined, whcih C $! causes problems when using SUBMIT/LOG_FILE -- so, we point it atTK $! the DSNLINK_DIR location; then we make a test to see if that'll work....I% $  IF F$TRNLNM("SYS$LOGIN") .EQS. "" e $  THEN ) $    DEFINE SYS$LOGIN 'DSNLINK_DIRECTORY'Er $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, SYS$LOGIN was undefined; it has been set to ", F$TRNLNM("SYS$LOGIN") $  ENDIF $Sh $! in case the above trick didn't do it, we force the log file to the specific filename and location....? $  IF F$PARSE(GET_LOG_FILE) .EQS. "" .OR. GET_LOG_FILE .EQS. ""A	 $  THEN  E= $    GET_LOG_FILE = DSNLINK_DIRECTORY + "DSNLINK_NEW_GET.LOG" W $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, GET_LOG_FILE is undefined; attempting to".t $    WRITE SYS$OUTPUT "-DSNlink_NEW-I-CONFIG, use DSNLINK_NEW_DIR:DSNLINK_NEW_GET.LOG (", F$PARSE(GET_LOG_FILE), ")" $  ENDIF $L5 $! accept "NO" and "0" to mean 'disable history file'Ef $  IF F$PARSE(DSN_HISTORY_FILE,,,"NAME") .EQS. "NO" .OR. F$PARSE(DSN_HISTORY_FILE,,,"NAME") .EQS. "0"  $  THEN-m $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, History file disabled.  \", DSN_HISTORY_FILE, "\"M $    DSN_HISTORY_FILE = "NONE" $  ENDIF $ ; $  IF GET_STYLE .NES. "EDT" .AND. GET_STYLE .NES. "EXTRACT"A $  THEN_P $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, GET_STYLE must be EXTRACT or EDT." $    CONFIG_ERROR = TRUE $  ENDIF $S  $  IF F$TYPE(DB_NAME_0) .EQS. "" $  THEN ] $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-CONFIG, No databases have been defined in config file."E $    CONFIG_ERROR = TRUE $  ENDIF $ D $! accept "NONE" and "0" to mean 'don't schedule another execution.'5 $  IF DSN_AFTER .EQS. "NONE" .OR. DSN_AFTER .EQS. "0"  $  THEN.e $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-CONFIG, DSN_AFTER set to ONE.  \", DSN_AFTER, "\". $    DSN_AFTER = "ONE" $  ENDIF $V $  IF CONFIG_ERROR   $  THEN n $    WRITE SYS$OUTPUT F$FAO("!/%DSNlink_NEW-E-CONFIGERR, Configuration error(s) prevent running DSNlink_NEW.") $    ERROR_STATUS = SS$_ABORTOa $    ERROR_MESSAGE = "%DSNlink_NEW-E-CONFIGERR, Configuration error(s) in ''DSN_CONFIG_FILENAME'"EK $    ! we will send a message to the user that submitted this DSNlink_NEW,  K $    ! and (when this configuration routine exits) also try to send a mail H- $    ! message to the $ERROR$ group about it.O $    IF (.NOT. INTERACTIVE) 	 $    THENe $      SEND_TO = USERNAME_I $      IF F$TYPE(ORIGINALLY_FROM) .NES. "" THEN SEND_TO = ORIGINALLY_FROMA $      SET noONI $      MAIL/noSELF -      SYS$INPUT: 'SEND_TO' -%K      /SUBJECT="DSNlink_NEW configuration error in ''DSN_CONFIG_FILENAME'" -S5      /PERSONAL_NAME="DSNlink_NEW configuration error"\E DSNlink_NEW encountered a configuration error while executing in non- ' interactive mode (Batch or Detached).     < For further information, check .LOG file and the DSNlink_NEWH configuration file; if using DELIVER or MX SITE agents, check those logs as well.  TI ... attempting to also inform user(s) in group $ERROR$ about the problem.S  / This message sent automatically by DSNlink_NEW.\
 $      SET ON  $    ENDIF  ! interactive  $  ENDIF ! configuration error $F" $  IF BATCH THEN SET RESTART_VALUE, $  RETURN       !  leaving INIT_PARSE_CONFIG $M $!SG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!EG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!RG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!E $_DSNLINK_GET: $  PERFORMING_GET = TRUEY $  IF .NOT. BATCH THEN WRITE SYS$OUTPUT F$FAO("  !24<Batch log file:!>!AS", GET_LOG_FILE)LZ $  IF BATCH THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-GET, Performing article GET processing."Y $  IF DEBUG .OR. BATCH THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-GET, Get style: ", GET_STYLEDT $  WRITE SYS$OUTPUT F$FAO("  !24<Connection retries:!>!AS", F$STRING(DSN_RETRY_MAX)) $S $! modify mail groups a bit....  $t $  COUNT = 0 $_REWRITE_LOOP:_. $  IF MAIL_GROUP_NAME_'COUNT' .EQS. "$ERROR$"  $  THEN  $    IF P5 .EQS. ""Y	 $    THEN)* $      MAIL_GROUP_USERS_'COUNT' = USERNAME! $      ORIGINALLY_FROM = USERNAMEa	 $    ELSE $ $      MAIL_GROUP_USERS_'COUNT' = P5 $      ORIGINALLY_FROM = P5C
 $    ENDIF $    IF (DEBUG) .OR. (.NOT. INTERACTIVE) THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-REWROTE, Rewrote $ERROR$ group to ", MAIL_GROUP_USERS_'COUNT' $  ENDIF  ! error groupP $  COUNT = COUNT + 19 $  IF COUNT .LE. MAIL_GROUP_COUNT THEN GOTO _REWRITE_LOOP p $  IF ORIGINALLY_FROM .NES. USERNAME THEN WRITE SYS$OUTPUT F$FAO("  !24<Originally from:!>!AS", ORIGINALLY_FROM) $EH $  MAIL_GROUP_COUNT = MAIL_GROUP_COUNT + 1        ! create another group. $  MAIL_GROUP_NAME_'MAIL_GROUP_COUNT' = "Self"1 $  MAIL_GROUP_USERS_'MAIL_GROUP_COUNT' = USERNAME % $  MAIL_GROUP_Self = MAIL_GROUP_COUNTE $  PREFERRED = MAIL_GROUP_COUNTe $tF $  MAIL_GROUP_COUNT = MAIL_GROUP_COUNT + 1        ! even another group0 $  MAIL_GROUP_NAME_'MAIL_GROUP_COUNT' = "Retain"I $  MAIL_GROUP_USERS_'MAIL_GROUP_COUNT' = "<send to assigned mail groups>"T' $  MAIL_GROUP_Retain = MAIL_GROUP_COUNTn $iF $  MAIL_GROUP_COUNT = MAIL_GROUP_COUNT + 1        ! even another group2 $  MAIL_GROUP_NAME_'MAIL_GROUP_COUNT' = "Specific"E $  MAIL_GROUP_USERS_'MAIL_GROUP_COUNT' = "<send to specific user(s)>"l) $  MAIL_GROUP_Specific = MAIL_GROUP_COUNT  $, $  IF P3 .NES. ""  $  THEN  $    GET_FILENAME = P3 $  ELSE  $    GET_FILENAME = GET_FILE $  ENDIF% $  IF F$SEARCH(GET_FILENAME) .EQS. "", $  THENeM $    ERROR_MESSAGE = "%DSNlink_NEW-E-GETFILE, Missing file \''GET_FILENAME'\"+" $    ERROR_STATUS = SS$_NOSUCHFILE $    GOTO _EXIT_ERRORA $  ENDIF( $  GET_FILENAME = F$SEARCH(GET_FILENAME)C $  WRITE SYS$OUTPUT F$FAO("  !24<Get filename:!>!AS", GET_FILENAME)r $ev $  IF (BATCH) .AND. (P6 .NES. "")  ! if P6 is non-null, then we should delete file after we're done (if all works out) $  THENE$ $    DELETE_ORIGINAL_GET_FILE = TRUE $    ORIGINAL_GET_FILE = P6PV $    WRITE SYS$OUTPUT F$FAO("  !24<Delete orig GET file:!>Yes, !AS",ORIGINAL_GET_FILE) $  ELSEC% $    DELETE_ORIGINAL_GET_FILE = FALSET> $    WRITE SYS$OUTPUT F$FAO("  !24<Delete orig GET file:!>No") $  ENDIF $0 $  CREATE_CMD = FALSE " $  IF BATCH THEN CREATE_CMD = TRUE $. $  GOSUB _PROCESS_GET_FILE $   $  IF TOTAL_ARTICLE_COUNT .EQ. 0 $  THENFT $    WRITE SYS$OUTPUT "%DSNlink_NEW-E-NOGET, No articles to get - invalid GET file."T $    WRITE SYS$OUTPUT "-DSNlink_NEW-E-NOGET, Enable DSNlink_NEW debugging or delete"L $    WRITE SYS$OUTPUT "-DSNlink_NEW-E-NOGET, ", GET_FILE, " and start over."U $    ERROR_MESSAGE = "%DSNlink_NEW-E-GETFILE, No articles to get - invalid GET file."n4 $    ERROR_STATUS = (SS$_ABORT .OR. STS$M_INHIB_MSG) $    GOTO _EXIT_ERROR_ $  ENDIF $   $  IF BATCH THEN GOTO _GET_BATCH $v $  IF .NOT. INTERACTIVE  $  THEN ! validate group namec" $    GRPNAME = F$ELEMENT(0,"=",P4)" $    USRNAME = F$ELEMENT(1,"=",P4)- $    IF F$TYPE(MAIL_GROUP_'GRPNAME') .NES. ""E	 $    THENI) $      WHICH_GROUP = MAIL_GROUP_'GRPNAME' 8 $      IF USRNAME .NES. "=" THEN SPECIFIC_USER = USRNAME $      AFTER_QUAL = "" $      GOTO _GET_SKIP_PROMPTS  $    ENDIF  ! found itV $    ERROR_MESSAGE = "%DSNlink_NEW-E-GROUP, Invalid or missing group name P4: \''P4'\"  $    ERROR_STATUS = SS$_BADPARAM $    GOTO _EXIT_ERRORS $  ENDIF ! .not. interactive $G7 $  WRITE SYS$OUTPUT F$FAO("!/  !24<Mail groups!>Users")I $  COUNT = 0 $  LOW = 99! $  HIGH = -1 $_DB_DISPLAY_LOOP_2:. $  IF MAIL_GROUP_NAME_'COUNT' .NES. "$ERROR$"  $  THENKe $    TMP = F$FAO(" !2UL. !15AS      !50AS", COUNT, MAIL_GROUP_NAME_'COUNT', MAIL_GROUP_USERS_'COUNT')-Q $    IF F$LENGTH(MAIL_GROUP_USERS_'COUNT') .GT. 50 THEN TMP = TMP + TOO_LONG_CHARC $    WRITE SYS$OUTPUT TMPR) $    IF COUNT .GT. HIGH THEN HIGH = COUNT ' $    IF COUNT .LT. LOW THEN LOW = COUNT  $  ENDIF $  COUNT = COUNT + 1> $  IF COUNT .LE. MAIL_GROUP_COUNT THEN GOTO _DB_DISPLAY_LOOP_2 $ M $  WRITE SYS$OUTPUT F$FAO("!/Ready to retrieve articles and Email to users.")E $_GET_GRP_NUMBER:NQ $  ASK "* Send mail to which group? (''LOW'-''HIGH') [''PREFERRED'] " WHICH_GROUPG+ $  WHICH_GROUP = F$EDIT(WHICH_GROUP,"TRIM")L7 $  IF WHICH_GROUP .EQS. "" THEN WHICH_GROUP = PREFERRED * $  IF F$TYPE(WHICH_GROUP) .NES. "INTEGER"  $  THEN!2 $    WRITE SYS$OUTPUT "Invalid - must be a number" $    GOTO _GET_GRP_NUMBER  $  ENDIF' $  WHICH_GROUP = F$INTEGER(WHICH_GROUP)L5 $  IF F$TYPE(MAIL_GROUP_NAME_'WHICH_GROUP') .EQS. "" E $  THENM1 $    WRITE SYS$OUTPUT "Invalid mail group number"R $    GOTO _GET_GRP_NUMBER$ $  ENDIF ! valid number"3 $  IF MAIL_GROUP_NAME_'WHICH_GROUP' .EQS. "$ERROR$"T $  THENVM $    WRITE SYS$OUTPUT "Invalid mail group number - cannot use $ERROR$ group."  $    GOTO _GET_GRP_NUMBER  $  ENDIF ! $error$ $   2 $  IF MAIL_GROUP_NAME_'WHICH_GROUP' .EQS. "Retain"q $  THEN        ! check to make sure the config file has user mappings for the Databases specified in the GET fileS $    RETAIN_OKAY = TRUEE $    OLD_DB = "" $    COUNT1 = 0  $    _CHECK_RETAIN_LOOP_1: $    COUNT2 = 0O $    _CHECK_RETAIN_LOOP_2:V $    IF F$EDIT(GET_DATABASE_'COUNT1',"UPCASE") .EQS. F$EDIT(DB_NAME_'COUNT2',"UPCASE")< $    THEN                               ! found the database $      IF OLD_DB .NES. GET_DATABASE_'COUNT1' THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-USERS, Text from ", GET_DATABASE_'COUNT1', " will be mailed to ", DB_MAIL_'COUNT2'-% $      OLD_DB = GET_DATABASE_'COUNT1'  $      COUNT1 = COUNT1 + 1H $      IF COUNT1 .LT. TOTAL_ARTICLE_COUNT THEN GOTO _CHECK_RETAIN_LOOP_1 $      GOTO _EXIT_CHECK_RETAIN  $    ENDIF ! database nout found $    COUNT2 = COUNT2 + 1V $    IF COUNT2 .LT. DB_NAME_COUNT THEN GOTO _CHECK_RETAIN_LOOP_2  ! check next DB name $    IF OLD_DB .NES. GET_DATABASE_'COUNT1' THEN WRITE SYS$OUTPUT "%DSNlink_NEW-E-NOUSER, Can't use RETAIN: Config doesn't have ", GET_DATABASE_'COUNT1'd# $    OLD_DB = GET_DATABASE_'COUNT1'2 $    RETAIN_OKAY = FALSE $    COUNT1 = COUNT1 + 1F $    IF COUNT1 .LT. TOTAL_ARTICLE_COUNT THEN GOTO _CHECK_RETAIN_LOOP_1 $  _EXIT_CHECK_RETAIN:3 $    IF .NOT. RETAIN_OKAY THEN GOTO _GET_GRP_NUMBER- $  ENDIF ! retainE $S $  SPECIFIC_USER = "" 4 $  IF MAIL_GROUP_NAME_'WHICH_GROUP' .EQS. "Specific" $  THEN  $    _GET_SPECIFIC_USERNAME:5 $    ASK "* Enter specific usernames: " SPECIFIC_USER,` $    IF SPECIFIC_USER .EQS. "" .OR. F$LOCATE(QUOTE,SPECIFIC_USER) .NE. F$LENGTH(SPECIFIC_USER) -!      .OR. SPECIFIC_USER .EQS. "?"E	 $    THENEa $      WRITE SYS$OUTPUT "%DSNlink_NEW-E-INVUSER, Invalid: cannot be blank, cannot contain quotes" " $      GOTO _GET_SPECIFIC_USERNAME
 $    ENDIF5 $    SPECIFIC_USER = F$EDIT(SPECIFIC_USER,"COLLAPSE")DI $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-USERS, Sending to: ", SPECIFIC_USERC $  ENDIF ! specificC $I $! $!!! $! $  $  AFTER_QUAL = "\"S@ $  IF DSN_AFTER .EQS. "ONE" THEN DSN_AFTER = "TOMORROW+01:00:00" $  PREFERRED = "T"Z $  IF F$TYPE(GET_TIME) .NES. ""  THEN PREFERRED = F$EXTRACT(0,1,F$EDIT(GET_TIME,"UPCASE")) $_REPROMPT_WHEN: $  WRITE SYS$OUTPUT ""U $  ASK "* Submit Now, this Evening, or Tomorrow? (N/E/T) [''PREFERRED'] " SUBMIT_TIMEME $  SUBMIT_TIME = F$EXTRACT(0,1,F$EDIT(SUBMIT_TIME,"UPCASE,COLLAPSE"))O7 $  IF SUBMIT_TIME .EQS. "" THEN SUBMIT_TIME = PREFERREDE0 $  IF SUBMIT_TIME .EQS. "N" THEN AFTER_QUAL = ""< $  IF SUBMIT_TIME .EQS. "E" THEN AFTER_QUAL = "/AFTER=18:00"h $  IF SUBMIT_TIME .EQS. "T" THEN AFTER_QUAL = "/AFTER=" + QUOTE + F$CVTIME(DSN_AFTER,"ABSOLUTE") + QUOTE $  IF AFTER_QUAL .EQS. "\" $  THENn4 $    WRITE SYS$OUTPUT "Invalid - must be N, E, or T" $    GOTO _REPROMPT_WHEN $  ENDIFZ $  IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, AFTER_QUAL is \", AFTER_QUAL, "\" $F $_GET_SKIP_PROMPTS:"T $  GET_TEMPFILE = DSN_SCRATCH_DIR + "DSNLINK_NEW_GET_" + F$GETJPI(0,"PID") + "_" + -N      F$CVTIME(,,"HOUR") + F$CVTIME(,,"MINUTE") + F$CVTIME(,,"SECOND") + ".DAT" $  CREATE 'GET_TEMPFILE') $  OPEN/APPEND DSN_OUTFILE 'GET_TEMPFILE'21 $  WRITE DSN_OUTFILE "! ", F$SEARCH(GET_TEMPFILE)1N $  WRITE DSN_OUTFILE "! Created by DSNlink_NEW, version ", DSNLINK_NEW_VERSION6 $  WRITE DSN_OUTFILE "! file used for GET processing."c $  WRITE DSN_OUTFILE F$FAO("!! Created at !%D by user !AS::!AS", 0, F$GETSYI("NODENAME"), USERNAME)_ $  WRITE DSN_OUTFILE "!" $  CLOSE DSN_OUTFILE' $  APPEND 'GET_FILENAME' 'GET_TEMPFILE'O $0 $  IF SPECIFIC_USER .EQS. "" $  THENI( $    TMP = MAIL_GROUP_NAME_'WHICH_GROUP' $  ELSEc> $    TMP = MAIL_GROUP_NAME_'WHICH_GROUP' + "=" + SPECIFIC_USER $  ENDIF $O$ $  IF ORIGINALLY_FROM .EQS. USERNAME $  THENF $    NOTIFY_QUAL = "/NOTIFY" $  ELSE h $    NOTIFY_QUAL = "/noNOTIFY"     ! we're doing this 100% on someone else's behalf (MX SITE or DELIVER) $  ENDIF $R $  ORIGINAL_GET_FILE = ""R $R $! see if there's a new defaultC $  PREFERRED = "S"U $  IF F$TYPE(GET_DELETE_TYPE) .EQS. "STRING"    ! use default from configuration file  $  THENSO $    IF F$EDIT(GET_DELETE_TYPE,"UPCASE") .EQS. "IMMEDIATE" THEN PREFERRED = "Y"GO $    IF F$EDIT(GET_DELETE_TYPE,"UPCASE") .EQS. "NEVER"     THEN PREFERRED = "N" O $    IF F$EDIT(GET_DELETE_TYPE,"UPCASE") .EQS. "SUCCESS"   THEN PREFERRED = "S"A $  ENDIF $" $  IF INTERACTIVEE $  THENG $    _ASK_DEL_GET_FILE:  $    WRITE SYS$OUTPUT ""W $    ASK "* Delete all versions of your GET file? (Y/N/S/?) [''PREFERRED'] " DELETE_GET E $    DELETE_GET = F$EXTRACT(0,1,F$EDIT(DELETE_GET,"UPCASE,COLLAPSE"))W7 $    IF DELETE_GET .EQS. "" THEN DELETE_GET = PREFERREDR $    IF DELETE_GET .EQS. "?" P	 $    THENL_ $      WRITE SYS$OUTPUT "Your GET file (", F$PARSE(";*",GET_FILENAME), ") is no longer needed."Ad $      WRITE SYS$OUTPUT "DSNlink_NEW has made a copy of your get file for its use in the batch job.": $      WRITE SYS$OUTPUT "You can safely delete this file."; $      WRITE SYS$OUTPUT "  Y - Delete GET file immediately" 5 $      WRITE SYS$OUTPUT "  N - Don't delete GET file"NT $      WRITE SYS$OUTPUT "  S - Only delete GET file if GET Processing is Successful" $      GOTO _ASK_DEL_GET_FILE 
 $    ENDIFI $    IF DELETE_GET .EQS. "Y" THEN DELETE/LOG 'F$PARSE(";*",GET_FILENAME)'LP $    IF DELETE_GET .EQS. "S" THEN ORIGINAL_GET_FILE = F$PARSE(";*",GET_FILENAME)R $    IF DELETE_GET .NES. "Y" .AND. DELETE_GET .NES. "N" .AND. DELETE_GET .NES. "S"	 $    THENH6 $      WRITE SYS$OUTPUT "Invalid - must be Y, N, or ?" $      GOTO _ASK_DEL_GET_FILE.
 $    ENDIF $  ENDIF ! interactive $. $  SUBMIT -M      'NOTIFY_QUAL' -      /QUEUE=DSN$BATCH -O      /noPRINTER -1      'AFTER_QUAL' -N      /KEEP -      /PARAMETERS=( -F           'DSN_CONFIG_FILENAME', -      ! P1 (keep the version number),           "$GET$", -                    ! P2           'F$SEARCH(GET_TEMPFILE)', -   ! P3 - remove logicals -- another node may have different ideas about where SYS$SCRATCH is located,           "''TMP'",   -                 ! P4,           "''ORIGINALLY_FROM'", -       ! P5,           "''ORIGINAL_GET_FILE'") -     ! P6      /NAME="DSNlink_NEW:get" -      /LOG_FILE='GET_LOG_FILE' -O.      'F$PARSE(";",F$ENVIRONMENT("PROCEDURE"))' $r $  FINISHED_OK = TRUE 
 $  GOTO _EXITW $E $!OG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!C $_GET_BATCH: $  C $  GOSUB _PHONE_DCL_HOST $D $  CURRENT_COUNT = 0 $_GET_SENDMAIL_LOOP:* $  DATABASE = GET_DATABASE_'CURRENT_COUNT'$ $  TITLE = GET_TITLE_'CURRENT_COUNT' $  TITLE_NOQUOTES = TITLES $  _REMOVE_QUOTES:B $  IF F$LOCATE(QUOTE,TITLE_NOQUOTES) .NE. F$LENGTH(TITLE_NOQUOTES) $  THEN < $    TITLE_NOQUOTES[F$LOCATE(QUOTE,TITLE_NOQUOTES),1] := " " $    GOTO _REMOVE_QUOTES $  ENDIF $T= $  FILENAME = TMP_EXTRACTFILE + "_" + F$STRING(CURRENT_COUNT) ! $  IF F$SEARCH(FILENAME) .EQS. ""R $  THENE $    CREATE 'FILENAME'  $    OPEN/APPEND FILE 'FILENAME', $    WRITE FILE "Couldn't find the article:") $    WRITE FILE "  Database:  ", DATABASE 7 $    WRITE FILE F$EXTRACT(0,79,"  Title:     " + TITLE)T# $    WRITE FILE "  For group: ", P4P $    CLOSE FILEC $    CALL _SEND_MAIL_MESSAGE -      'FILENAME' -T8      "DSNlink article not found; ''DATABASE' database" -      $ERROR$ -,      "''DATABASE' DSNlink article not found" $  ELSEo: $    TMP1 = F$FAO(FAO_GET_SUBJECT,DATABASE,TITLE_NOQUOTES)D $    IF F$LENGTH(TMP1) .GT. 71 THEN TMP1[71,1] := "''TOO_LONG_CHAR'"  $    TMP1 = F$EXTRACT(0,72,TMP1) $R; $    TMP2 = F$FAO(FAO_GET_PERSONAL,DATABASE,TITLE_NOQUOTES)E $ ( $    SET FILE/VERSION_LIMIT=2 'FILENAME' $s0 $! get title (second record) and count the lines $    OPEN/READ FILE 'FILENAME' $    LINE_COUNT = 2,0 $    READ FILE JUNK/END_OF_FILE=_LINE_COUNT_EXIT9 $    READ FILE SECOND_RECORD/END_OF_FILE=_LINE_COUNT_EXITM $Y $    _LINE_COUNT_LOOP:2 $    READ FILE RECORD/END_OF_FILE=_LINE_COUNT_EXIT  $    LINE_COUNT = LINE_COUNT + 1 $    GOTO _LINE_COUNT_LOOP $    _LINE_COUNT_EXIT: $  $    CLOSE FILEL7 $    CREATE 'FILENAME';            ! create new versiono  $    OPEN/APPEND FILE 'FILENAME'. $    WRITE FILE "  Database:      " + DATABASE. $    TMP = "  Title:         " + SECOND_RECORDB $    IF F$LENGTH(TMP) .GT. 79 THEN TMP[79,1] := "''TOO_LONG_CHAR'"# $    WRITE FILE F$EXTRACT(0,80,TMP)% $l' $    ! display warning if they mismatcheV $    IF F$EDIT(SECOND_RECORD,"UPCASE,COLLAPSE") .NES. F$EDIT(TITLE,"UPCASE,COLLAPSE") 
 $    THEN ) $      TMP =  "  Desired title: " + TITLEDD $      IF F$LENGTH(TMP) .GT. 79 THEN TMP[79,1] := "''TOO_LONG_CHAR'"% $      WRITE FILE F$EXTRACT(0,80,TMP).7 $      WRITE FILE "  Warning:       Titles don't match" [ $      WRITE FILE "                 Article may need to be retrieved from DSNlink manually" 8 $      TMP1 = F$EXTRACT(0,72,"(title mismatch) " + TMP1) $    ENDIF ! title mismatchL $N/ $    WRITE FILE "  Lines:         ", LINE_COUNTE $    CLOSE FILES& $    APPEND 'FILENAME';-1 'FILENAME'   $    CALL _SEND_MAIL_MESSAGE -      'FILENAME' -E      "''TMP1'" -      "''P4'" -      "''TMP2'" $  ENDIF ! extract file exists $S$ $  CURRENT_COUNT = CURRENT_COUNT + 1I $  IF CURRENT_COUNT .LT. TOTAL_ARTICLE_COUNT THEN GOTO _GET_SENDMAIL_LOOPa $p $  FINISHED_OK = TRUEnI $  IF DELETE_ORIGINAL_GET_FILE THEN DELETE'DEBUG_LOG' 'ORIGINAL_GET_FILE'_
 $  GOTO _EXIT  $  $!.G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!e $_PROCESS_GET_FILE:TH $! process contents of GET file and (optionally) create ITS command file $  $  IF DEBUGS $  THEN C $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Contents of GET file:"n $    TYPE 'GET_FILENAME' $  ENDIF  ! debugB $O& $  OPEN/READ DSN_INFILE 'GET_FILENAME' $I $  IF CREATE_CMD   $  THEN ) $    OPEN/WRITE DSN_OUTFILE 'TMP_DSNFILE's $    WRITE DSN_OUTFILE ""h $  ENDIF $t $  ARTICLE_COUNT = 0 $  TOTAL_ARTICLE_COUNT = 0 $  LAST_CLOSED_DB = "" $  LAST_OPENED_DB = ""
 $  DB = "" $t $_GET_VALID_LOOP: : $  READ/END_OF_FILE=_DONE_GET_VALID_LOOP DSN_INFILE RECORDQ $  IF F$EXTRACT(0,1,RECORD) .EQS. ">" .OR. F$EXTRACT(0,1,RECORD) .EQS. "#" THEN -G$      RECORD = F$EXTRACT(1,-1,RECORD)9 $  IF RECORD .EQS. "_____" THEN GOTO _DONE_GET_VALID_LOOP=j $  IF ((F$ELEMENT(1," ",RECORD) .EQS. "database," .OR. F$ELEMENT(2," ",RECORD) .EQS. "database,")) .AND. -}       ((F$LOCATE(" article:",RECORD) .NE. F$LENGTH(RECORD) .OR. F$LOCATE(" articles:",RECORD) .NE. F$LENGTH(RECORD))) .AND. - '       (F$EXTRACT(0,1,RECORD) .NES. " ")a $  THENNs $    IF F$ELEMENT(1," ",RECORD) .EQS. "database," THEN DB = F$ELEMENT(0," ",RECORD)  ! "xxx database, NN articles:"ly $    IF F$ELEMENT(2," ",RECORD) .EQS. "database," THEN DB = F$ELEMENT(1," ",RECORD)  ! "FLASH xxx database, NN articles:"  $  ELSEF) $    IF F$EXTRACT(0,2,RECORD) .EQS. "  " e? $    THEN      ! first two characters of this record are spacesl= $      RECORD = F$EDIT(RECORD,"COMPRESS,TRIM")  ! remove junk! $! $!" $      ! new database opened yet? J $      ! (we hold off on doing the OPEN until we've got an artilce title, B $      !  to prevent OPENing a database and retrieving 0 articles)! $      IF DB .NES. LAST_OPENED_DB_ $      THEN  $ D $        ! check to see if we have to close the last-opened databaseb $        IF LAST_OPENED_DB .NES. DB .AND. LAST_OPENED_DB .NES. ""  ! If we're on to a new database $        THEN H $          IF CREATE_CMD THEN WRITE DSN_OUTFILE "close ", LAST_OPENED_DB* $          LAST_CLOSED_DB = LAST_OPENED_DBa $          WRITE SYS$OUTPUT F$FAO("!28* !20AS get !UL article!%S", LAST_OPENED_DB, ARTICLE_COUNT)U $        ENDIF _ $P- $        ! now ready to open the new database$ $        LAST_OPENED_DB = DB $        ARTICLE_COUNT = 0 $        IF CREATE_CMD S
 $        THENO $          WRITE DSN_OUTFILE ""E( $          WRITE DSN_OUTFILE "open ", DB $        ENDIF ! create_cmdC# $      ENDIF ! db <> last_opened_dbN $ ! $      IF LAST_OPENED_DB .NES. """ $      THENI) $        ! if we've opened a database ...G $        IF CREATE_CMD
 $        THENr $          ! perform the search 6 $          WRITE DSN_OUTFILE "search/english ", RECORDa $          IF DEBUG THEN WRITE DSN_OUTFILE "directory  ! this line only present during debugging"N# $          IF GET_STYLE .EQS. "EDT"  $          THEN+, $            WRITE DSN_OUTFILE "read/edit 1"' $            ! now we're talking to EDTI^ $            WRITE DSN_OUTFILE "EXIT " + TMP_EXTRACTFILE + "_" + F$STRING(TOTAL_ARTICLE_COUNT)0 $            ! now we're back talking to DSN ITS $          ENDIF ! get_style' $          IF GET_STYLE .EQS. "EXTRACT"A $          THEN ' $            WRITE DSN_OUTFILE "read 1"_a $            WRITE DSN_OUTFILE "extract " + TMP_EXTRACTFILE + "_" + F$STRING(TOTAL_ARTICLE_COUNT)R $          ENDIF ! get_style $        ENDIF ! create_cmd 1 $        GET_TITLE_'TOTAL_ARTICLE_COUNT' = RECORD"0 $        GET_DATABASE_'TOTAL_ARTICLE_COUNT' = DB* $        ARTICLE_COUNT = ARTICLE_COUNT + 16 $        TOTAL_ARTICLE_COUNT = TOTAL_ARTICLE_COUNT + 1# $      ENDIF ! LAST_OPENED_DB <> "" V $    ELSE  ! there was some text in the first two spaces, but it wasn't a new database $      LAST_OPENED_DB = "" $      DB = ""* $    ENDIF ! F$EXTRACT(0,2,RECORD) = "  " N $  ENDIF  ! record type (database, title, or 'other' [ignore 'other' records]) $  GOTO _GET_VALID_LOOP  $I $_DONE_GET_VALID_LOOP:j $  IF ARTICLE_COUNT .GT. 0 THEN WRITE SYS$OUTPUT F$FAO("!28* !20AS get !UL article!%S", DB, ARTICLE_COUNT) $  CLOSE DSN_INFILEt $  IF CREATE_CMD l $  THEN  $    WRITE DSN_OUTFILE ""R $    WRITE DSN_OUTFILE "exit"I $    CLOSE DSN_OUTFILE $  ENDIF $O" $  RETURN  ! from PROCESS_GET_FILE $:G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!T $  $_DO_CHECK_OPENCALLS:A- $  IF DSN_CHECK_OPENCALLS_USER .NES. USERNAME  $  THENE0 $    ! need to submit under a different username $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-OPENCALLS, Submitting DSNlink_NEW with CHECKOPEN with username: ", DSN_CHECK_OPENCALLS_USER 
 $    IF DEBUG 	 $    THENE_ $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Will attempt to create log file in .SCRATCH_DIR" e $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, this may fail if the user can't write to .SCRATCH_DIR"i] $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, .SCRATCH_DIR is set in DSNLINK_NEW_CONFIG.DAT" Q $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, Value is: \", DSN_SCRATCH_DIR, "\"BP $      CHECKOPEN_LOG = "/LOG_FILE=" + DSN_SCRATCH_DIR + "DSNLINK_NEW_CHECK.LOG" 	 $    ELSE0$ $      CHECKOPEN_LOG = "/noLOG_FILE"
 $    ENDIFN $    OLDPRIV = F$SETPRV("CMKRNL")  ! save current privilege setting in OLDPRIV
 $    SUBMIT -E      /NOTIFY -$      /NAME="DSNlink_NEW_checkopen" -      'CHECKOPEN_LOG' -      /noPRINTER -       /QUEUE=DSN$BATCH -E'      /USER='DSN_CHECK_OPENCALLS_USER' -D      /PARAMETERS=( -F           'DSN_CONFIG_FILENAME', -      ! P1 (keep the version number)-           "$CHECKOPEN$") -              ! P2 t!      'F$ENVIRONMENT("PROCEDURE")'$F $    OLDPRIV = F$SETPRV(OLDPRIV)  ! restore previous setting of CMKRNL $    GOTO _DONE_CHECK_OPENCALLS  $  ELSEP $    ! this usernamea $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-OPENCALLS, Sending mail to DSN%OPENCALLS. (", F$TIME(), ")"L $    MAIL -'      /noSELF -      SYS$INPUT: -U      DSN%OPENCALLS -B      /SUBJECT="DSNlink_NEW-initiated check of DSNlink open calls" J This check of DSNlink open calls was initiated by code within DSNlink_NEW. $    WAIT 00:00:010 $    DSN SHOW BATCH      ! see if we see our job $  ENDIF ! separate user $2 $_DONE_CHECK_OPENCALLS: $ $  RETURN ! from _DO_CHECK_OPENCALLS $mG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $!W $_DO_CHECK_CLOSEDCALLS: / $  IF DSN_CHECK_CLOSEDCALLS_USER .NES. USERNAMEU $  THENL0 $    ! need to submit under a different username $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-CLOSEDCALLS, Submitting DSNlink_NEW with CHECKCLOSED with username: ", DSN_CHECK_CLOSEDCALLS_USER 
 $    IF DEBUG 	 $    THENO_ $      WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Will attempt to create log file in .SCRATCH_DIR" e $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, this may fail if the user can't write to .SCRATCH_DIR" ] $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, .SCRATCH_DIR is set in DSNLINK_NEW_CONFIG.DAT"mQ $      WRITE SYS$OUTPUT "-DSNlink_NEW-I-DEBUG, Value is: \", DSN_SCRATCH_DIR, "\"FR $      CHECKCLOSED_LOG = "/LOG_FILE=" + DSN_SCRATCH_DIR + "DSNLINK_NEW_CHECK.LOG" 	 $    ELSE & $      CHECKCLOSED_LOG = "/noLOG_FILE"
 $    ENDIFN $    OLDPRIV = F$SETPRV("CMKRNL")  ! save current privilege setting in OLDPRIV
 $    SUBMIT -       /NOTIFY -&      /NAME="DSNlink_NEW_checkclosed" -      'CHECKCLOSED_LOG' -      /noPRINTER -B      /QUEUE=DSN$BATCH -Q)      /USER='DSN_CHECK_CLOSEDCALLS_USER' -T      /PARAMETERS=( -F           'DSN_CONFIG_FILENAME', -      ! P1 (keep the version number)/           "$CHECKCLOSED$") -              ! P2 S!      'F$ENVIRONMENT("PROCEDURE")''F $    OLDPRIV = F$SETPRV(OLDPRIV)  ! restore previous setting of CMKRNL! $    GOTO _DONE_CHECK_CLOSEDCALLS+ $  ELSE  $    ! this usernamee $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-CLOSEDCALLS, Sending mail to DSN%CLOSEDCALLS. (", F$TIME(), ")"t $    MAIL -C      /noSELF -      SYS$INPUT: -.      DSN%CLOSEDCALLS -D      /SUBJECT="DSNlink_NEW-initiated check of DSNlink closed calls" L This check of DSNlink closed calls was initiated by code within DSNlink_NEW. $    WAIT 00:00:010 $    DSN SHOW BATCH      ! see if we see our job $  ENDIF ! separate user $T $_DONE_CHECK_CLOSEDCALLS:T& $  RETURN ! from _DO_CHECK_CLOSEDCALLS $RG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!I $!T $_DO_CHECK_DATABASES:  $  CHECKING_DATABASES = TRUE! $  IF P2 .EQS. "$CHECKDATABASES$"  $  THENLA $    ! we really have to do it (there's an ELSE way down there..)C& $    OPEN/WRITE DSN_FILE 'TMP_DSNFILE'# $    WRITE DSN_FILE "SHOW DATABASE"I $    WRITE DSN_FILE "EXIT" $    CLOSE DSN_FILEI $_I $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-CHECKDB, Performing database check"  $    GOSUB _PHONE_DCL_HOST% $    OPEN/READ DSN_FILE 'TMP_OUTFILE' * $    CREATE 'TMP_CHECKFILE'/FDL=SYS$INPUT: FILE   BEST_TRY_CONTIGUOUS  yes   ORGANIZATION         INDEXED RECORD   FORMAT  FIXEDLG   SIZE    43                  ! database + date (DD-MMM-YYYY) = 32 + 11C KEY 0E   INDEX_COMPRESSION  no    DUPLICATES         noA   NULL_KEY           noS   SEG0_LENGTH        32D   SEG0_POSITION      00 $    OPEN/READ/WRITE DSN_OUTFILE 'TMP_CHECKFILE' $E $!A $! populate indexed file with data from the output of the record R $! SHOW DATABASE command $! $    _CHK_DB_LOOP_1:E $    READ/END_OF_FILE=_CHK_DB_LOOP_1_END/ERROR=_ERROR DSN_FILE RECORD R $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Record: \", RECORD, "\"V $    IF RECORD .NES. "The currently available databases are:" THEN GOTO _CHK_DB_LOOP_1 $    _CHK_DB_LOOP_2:E $    READ/END_OF_FILE=_CHK_DB_LOOP_2_END/ERROR=_ERROR DSN_FILE RECORD ; $! all databases start with database name in first position"G $! end of database list is the string "No databases are currently open"O/ $    IF F$EXTRACT(1,1,RECORD) .NES. " " .AND. -R>         RECORD .NES. "No databases are currently open" .AND. -;         F$EDIT(F$ELEMENT(1," ",RECORD),"COLLAPSE") .NES. ""_	 $    THENSl $      IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Found database \", F$ELEMENT(1," ",RECORD), "\"H $      WRITE DSN_OUTFILE F$FAO("!32AS!11%D", F$ELEMENT(1," ",RECORD), 0)
 $    ENDIF $    GOTO _CHK_DB_LOOP_2 $E $    _CHK_DB_LOOP_1_END: $    _CHK_DB_LOOP_2_END: $    CLOSE DSN_OUTFILE $    CLOSE DSN_FILE  $    iJ $    IF DEBUG THEN WRITE SYS$OUTPUT "%DSNlink_NEW-I-DEBUG, Database file:"' $    IF DEBUG THEN TYPE 'TMP_CHECKFILE'F $OQ $    OPEN/WRITE DSN_OUTFILE 'TMP_MAILFILE'       ! for the generated mail messageE $NG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!E' $!!!!!  LOOK FOR MISSING DATABASES ....T $I $    MISSING_COUNT = 04 $    IF F$SEARCH(DSN_CHECK_DATABASES_FILE) .EQS. "" 
 $    THEN 7 $      CREATE 'DSN_CHECK_DATABASES_FILE'/FDL=SYS$INPUT:Y FILE   BEST_TRY_CONTIGUOUS  yes   ORGANIZATION         INDEXED RECORD   FORMAT  FIXED"B   SIZE    43             ! database + date (DD-MMM-YYYY) = 32 + 11 KEY 0    INDEX_COMPRESSION  no    DUPLICATES         no    NULL_KEY           noe   SEG0_LENGTH        32=   SEG0_POSITION      0 $T
 $    ENDIF $S $!% $!   Database file records look like:f- $!   xxxxxxxxxxxxxxxxxxxxxxxxxxxxxDD-MMM-YYYY": $!     Where "xxx..." is the database name (32 characters)C $!     The date is used to indicate when the database was last seen  $!* $    ! open the reference ("old") database5 $    OPEN/READ DSN_REFFILE 'DSN_CHECK_DATABASES_FILE'  $    ! open the new database- $    OPEN/READ DSN_SEARCHFILE 'TMP_CHECKFILE'  $A $    _CHK_DB_LOOP_3:. $    ! read record from reference ("old") fileH $    READ/END_OF_FILE=_CHK_DB_LOOP_3_END/ERROR=_ERROR DSN_REFFILE RECORD) $    REF_DATE   = F$EXTRACT(32,11,RECORD)N( $    REF_RECORD = F$EXTRACT(0,32,RECORD) $.1 $    ! now try to find the record in the new fileuF $    READ/KEY=&REF_RECORD/ERROR=_CHK_DB_MISSING_NF DSN_SEARCHFILE JUNK $    GOTO _CHK_DB_LOOP_3 $k $    _CHK_DB_MISSING_NF: $    ! we didn't find itJ $    IF MISSING_COUNT .EQ. 0 THEN WRITE DSN_OUTFILE "Missing database(s):" $    MISSING_COUNT = 1Q $    WRITE DSN_OUTFILE F$FAO("  Database !32AS last seen !AS, !AS", REF_RECORD, - -      F$CVTIME(REF_DATE,,"WEEKDAY"), REF_DATE)  $    GOTO _CHK_DB_LOOP_3 $    _CHK_DB_LOOP_3_END: $    CLOSE DSN_SEARCHFILE  $    CLOSE DSN_REFFILE $E $TG $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!G# $!!!!!  LOOK FOR NEW DATABASES ....  $A $    NEW_COUNT = 0& $    ! open the reference ("old") file5 $    OPEN/READ DSN_REFFILE 'DSN_CHECK_DATABASES_FILE'E $    ! open the new file- $    OPEN/READ DSN_SEARCHFILE 'TMP_CHECKFILE'A $D $    _CHK_DB_LOOP_4:  $    ! read record from new fileK $    READ/END_OF_FILE=_CHK_DB_LOOP_4_END/ERROR=_ERROR DSN_SEARCHFILE RECORD17 $    NEW_RECORD = F$FAO("!32AS",F$EXTRACT(0,32,RECORD))- $ 1 $    ! see if record is in reference ("old") filee? $    READ/KEY=&NEW_RECORD/ERROR=_CHK_DB_NEW_NF DSN_REFFILE JUNK  $    GOTO _CHK_DB_LOOP_4 $E $    _CHK_DB_NEW_NF:
 $xx = $statust+ $write sys$output "--debug ", f$message(xx)  $    ! we didn't find itB $    IF NEW_COUNT .EQ. 0 THEN WRITE DSN_OUTFILE "New database(s):" $    NEW_COUNT = NEW_COUNT + 1' $    WRITE DSN_OUTFILE "  ", NEW_RECORD/ $    GOTO _CHK_DB_LOOP_4 $  $    _CHK_DB_LOOP_4_END: $    CLOSE DSN_REFFILE $    CLOSE DSN_SEARCHFILE  $    CLOSE DSN_OUTFILE $ 9 $    IF NEW_COUNT .GT. 0 .OR. MISSING_COUNT .GT. 0 THEN -!p      CALL _SEND_MAIL_MESSAGE 'TMP_MAILFILE' "DSNlink_NEW - new/missing ITS databases" 'DSN_CHECK_DATABASES_USER' $_> $! delete old reference file, make new file the reference file' $    DELETE 'DSN_CHECK_DATABASES_FILE'*E4 $    COPY 'TMP_CHECKFILE' 'DSN_CHECK_DATABASES_FILE' $    T $  ELSEOd $    WRITE SYS$OUTPUT "%DSNlink_NEW-I-DATABASES, Submitting DSNlink_NEW (again) to check databases."` $    WRITE SYS$OUTPUT "-DSNlink_NEW-I-TWICE, Attempting to get two connections to DSNlink host."F $    DATABASE_LOG_FILE = F$PARSE("DSNLINK_NEW_DATABASES.LOG",LOG_FILE)
 $    SUBMIT -O      /NOTIFY -!      /NAME="DSNlink_NEW:chk_db" -'      /LOG='DATABASE_LOG_FILE' -F      /noPRINTER -,      /QUEUE=DSN$BATCH -L      /PARAMETERS=( -H           'DSN_CONFIG_FILENAME', -        ! P1 (keep the version number)/           "$CHECKDATABASES$") -           ! P2 E!      'F$ENVIRONMENT("PROCEDURE")'n $  ENDIF $' $_DONE_CHECK_DATABASES:$$ $  RETURN ! from _DO_CHECK_DATABASES $  $!"G $!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  $IG $! Convert history file to the new format (old format has 20-character  ? $! database names, new format has 32 character database names).T $! $I $_NEW_HISTORY_FORMAT: X $  WRITE SYS$OUTPUT "%DSNlink_NEW-I-HISTCONV, Converting history file to new format ..."O $  WRITE SYS$OUTPUT "-DSNlink_NEW-I-HISTORY, File ", F$SEARCH(DSN_HISTORY_FILE)F $L, $  OPEN/READ  DSN_FILE    'DSN_HISTORY_FILE'& $  CREATE/FDL=SYS$INPUT: 'TMP_DSNFILE' FILE   BEST_TRY_CONTIGUOUS  yes   ORGANIZATION         INDEXEDE   EXTENSION            9           ! in case it never gets COMPRESSed  RECORD   FORMAT  FIXED J   SIZE    120        ! date (YYYY-MM-DD) + database + title = 10 + 32 + 78 KEY 0E   INDEX_COMPRESSION  no    DUPLICATES         nos   NULL_KEY           no    SEG0_LENGTH        110   SEG0_POSITION      10  $E, $  OPEN/READ/WRITE DSN_OUTFILE 'TMP_DSNFILE' $  JUNK = 0  $I $  _NEW_HIST_LOOP:6 $  READ/END_OF_FILE=_END_NEW_HIST_LOOP DSN_FILE RECORDO $  RECORD = F$EXTRACT(0,30,RECORD) + F$FAO("!#* ",12) + F$EXTRACT(30,-1,RECORD)S" $  WRITE/SYMBOL DSN_OUTFILE RECORD $  JUNK = JUNK + 1z $  IF (JUNK / 200) * 200 .EQ. JUNK THEN WRITE SYS$OUTPUT "-DSNlink_NEW-I-HISTCONV, Converting history file, record ", JUNK $  GOTO _NEW_HIST_LOOP $  _END_NEW_HIST_LOOP: $  $  CLOSE DSN_FILE  $  CLOSE DSN_OUTFILE( $  COPY 'TMP_DSNFILE' 'DSN_HISTORY_FILE' $  PURGE 'DSN_HISTORY_FILE'C $  DELETE 'TMP_DSNFILE';Y $  WRITE SYS$OUTPUT "%DSNlink_NEW-S-HISTCONV, Done converting history file to new format"E $  WRITE SYS$OUTPUT ""	 $  RETURNL