 #module UAF_DW_ENTRY "X-2"   /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **< **		This module contains the various DECwindows entry window@ **		support routines needed by the DECwindows AUTHORIZE utility. **9 **  AUTHORS:	L. Mark Pilant			CREATION DATE:  30-Oct-1992  ** **  MODIFICATION HISTORY:  **/ **	X-2	LMP		L. Mark Pilant,		 5-MAR-1993  12:47 $ **		Convert to C from BLISS sources. **( **	X-1	LMP		L. Mark Pilant,		30-Oct-1992 **		Original version.  ** **-- */   /* ** **  INCLUDE FILES  ** */   #include ctype #include stdlib    #include <decw$include:mrmappl>    #include "uaf_header"    /* ** **  FORWARD ROUTINES ** */  * #pragma noinline (AUTHORIZE$ENTRY_PROCESS)) #pragma noinline (AUTHORIZE$FINISH_ENTRY) & #pragma noinline (AUTHORIZE$GET_ENTRY)) #pragma noinline (AUTHORIZE$SET_UP_ENTRY)   < extern void AUTHORIZE$ENTRY_PROCESS (widget_id, tag, reason)   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **6 **	This routine is called to initiate processing of an **	authorization entry.  ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  & extern void			AUTHORIZE$DECW_ERROR ();0 extern unsigned int		AUTHORIZE$GET_USER_INFO ();+ extern void			AUTHORIZE$ITMLST_ADD_ITEM (); ( extern void			AUTHORIZE$SET_UP_ENTRY ();+ extern void			AUTHORIZE$SET_UP_USERNAME ();    /* Global references. */  M globalref unsigned int		uaf_l_current_user_index;	/* Index of current user */ T globalref unsigned int		uaf_l_current_user_max;		/* Count of entries in user list */e globalref Widget		uaf_r_access_pri_window_widget;	/* Primary access restriction window widget info */ g globalref Widget		uaf_r_access_sec_window_widget;	/* Secondary access restriction window widget info */ R globalref struct ITMDEF		(*uaf_r_current_user_info)[];	/* Current user UAF info */K globalref Widget		uaf_r_entry_window_widget;	/* Entry window widget info */ Z globalref struct ITMDEF		(*uaf_r_template_info)[];	/* Modification template information */A globalref char			uaf_t_current_username[];	/* Current username */    /* Local storage. */  $ int				index;				/* General index */3 unsigned int			status;				/* Routine exit status */  int				widget_number = *tag;   /* Debug information. */   #ifdef DEBUGGING printf ("entry process\n");  #endif /* DEBUGGING */  > /* Call the appropriate routine, based upon the pushbutton. */   switch (widget_number)     {      case uaf$c_entry_cancel: 	{- 	XtUnmanageChild (uaf_r_entry_window_widget);   4 /* If there is an access window up, tear it down. */  2 	if (XtIsManaged (uaf_r_access_pri_window_widget))6 	    XtUnmanageChild (uaf_r_access_pri_window_widget);2 	if (XtIsManaged (uaf_r_access_sec_window_widget))6 	    XtUnmanageChild (uaf_r_access_sec_window_widget); 	break;  	}     case uaf$c_entry_ok_next:  	{  I /* If I am positioned to the last possible entry, don't attempt to go any O ** further.  Otherwise finish up with the current entry and do the next one. */   7 	if (uaf_l_current_user_index < uaf_l_current_user_max)  	    {  + /* Set up for the next user in the list. */     	    ++uaf_l_current_user_index;% 	    AUTHORIZE$SET_UP_USERNAME (NULL, % 				       uaf_l_current_user_index);   ( /* Get the authorization information. */  @ 	    if (FALSE (AUTHORIZE$GET_USER_INFO (uaf_t_current_username,! 						&uaf_r_current_user_info)))  		{   L /* Since an error has occurred getting the authorization information for theJ ** next user, reset the username, note the error, and dismiss; leaving the  ** existing window unchanged. */   		--uaf_l_current_user_index; " 		AUTHORIZE$SET_UP_USERNAME (NULL," 					   uaf_l_current_user_index);) 		AUTHORIZE$DECW_ERROR (UAF$_UAFREADERR); 	 		return;  		}   5 /* Now set up the information in the entry window. */   6 	    AUTHORIZE$SET_UP_ENTRY (uaf_r_current_user_info); 	    }+ 	XtManageChild (uaf_r_entry_window_widget);  	break;  	}  !     case uaf$c_entry_ok_previous:  	{  J /* If I am positioned to the first possible entry, don't attempt to go anyO ** further.  Otherwise finish up with the current entry and do the next one. */   " 	if (uaf_l_current_user_index > 1) 	    {  / /* Set up for the previous user in the list. */     	    --uaf_l_current_user_index;% 	    AUTHORIZE$SET_UP_USERNAME (NULL, % 				       uaf_l_current_user_index);   ( /* Get the authorization information. */  @ 	    if (FALSE (AUTHORIZE$GET_USER_INFO (uaf_t_current_username,! 						&uaf_r_current_user_info)))  		{   L /* Since an error has occurred getting the authorization information for theJ ** next user, reset the username, note the error, and dismiss; leaving the  ** existing window unchanged. */   		++uaf_l_current_user_index; " 		AUTHORIZE$SET_UP_USERNAME (NULL," 					   uaf_l_current_user_index);) 		AUTHORIZE$DECW_ERROR (UAF$_UAFREADERR); 	 		return;  		}   5 /* Now set up the information in the entry window. */   6 	    AUTHORIZE$SET_UP_ENTRY (uaf_r_current_user_info); 	    }+ 	XtManageChild (uaf_r_entry_window_widget);  	break;  	}  $     case uaf$c_entry_apply_template: 	{  N /* Apply the template information to the current authorization entry.  This isK ** done by taking each of the (template) item list entries and updating the  ** current user information. */   J 	for (index = 0; (*uaf_r_template_info)[index].itm$w_itmcod != 0; index++) 	    {  K /* Don't modify the username of the current entry.  This allows the user to H ** put some meaningful information in the username field of the template ** authorization entry. */  E 	    if ((*uaf_r_template_info)[index].itm$w_itmcod != UAI$_USERNAME) 6 		AUTHORIZE$ITMLST_ADD_ITEM (&uaf_r_current_user_info,3 					   (*uaf_r_template_info)[index].itm$w_itmcod, 3 					   (*uaf_r_template_info)[index].itm$w_bufsiz, 4 					   (*uaf_r_template_info)[index].itm$l_bufadr); 	    }  L /* Use the updated information to set up the authorization window.  It wouldL ** be possible to simply update those fields that changed, but doing it this ** way simplifies the code. */  2 	AUTHORIZE$SET_UP_ENTRY (uaf_r_current_user_info);+ 	XtManageChild (uaf_r_entry_window_widget);  	break;  	}     }  }   ; extern void AUTHORIZE$FINISH_ENTRY (widget_id, tag, reason)    Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **; **	This routine is called to finish up the processing of an  **	authorization entry.  ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  1 extern unsigned int		AUTHORIZE$ADD_LIST_ENTRY (); 0 extern unsigned int		AUTHORIZE$CRE_USER_INFO ();& extern void			AUTHORIZE$DECW_ERROR ();2 extern unsigned int		AUTHORIZE$FIND_USER_ENTRY ();, extern unsigned int		AUTHORIZE$GET_ENTRY ();+ extern void			AUTHORIZE$ITMLST_ADD_ITEM (); * extern void			AUTHORIZE$ITMLST_COMPARE ();) extern void			AUTHORIZE$ITMLST_DELETE (); ( extern void			AUTHORIZE$ITMLST_MERGE ();) extern void			AUTHORIZE$ITMLST_UPDATE (); + extern void			AUTHORIZE$SET_UP_USERNAME (); 0 extern unsigned int		AUTHORIZE$SET_USER_INFO ();- extern unsigned int		AUTHORIZE$MATCH_NAME ();    /* Global references. */  U globalref unsigned int		uaf_l_current_group_max;	/* Count of entries in group list */ T globalref unsigned int		uaf_l_current_user_max;		/* Count of entries in user list */S globalref int			uaf_l_main_operation;		/* Operation (i.e., create, modify, etc.) */ e globalref Widget		uaf_r_access_pri_window_widget;	/* Primary access restriction window widget info */ g globalref Widget		uaf_r_access_sec_window_widget;	/* Secondary access restriction window widget info */ T globalref struct ITMDEF		(*uaf_r_current_group_info)[];	/* Current group UAF info */R globalref struct ITMDEF		(*uaf_r_current_user_info)[];	/* Current user UAF info */K globalref Widget		uaf_r_entry_window_widget;	/* Entry window widget info */ M globalref struct USRLSTDEF	uaf_r_group_list;		/* Group user name list head */ W globalref struct USRLSTDEF	uaf_r_master_list;		/* Complete user list (from the file) */ Z globalref struct ITMDEF		(*uaf_r_template_info)[];	/* Modification template information */F globalref struct USRLSTDEF	uaf_r_user_list;		/* User name list head */K globalref Widget		uaf_r_widget_id_array[];	/* Array of Widget IDs in use */ A globalref char			uaf_t_current_username[];	/* Current username */ v globalref char			uaf_t_username_filter[sizeof uaf_r_user_list.uaf$t_usrlst_name];	/* Current username filter string */   /* Local storage. */  H XmString			current_username;		/* Compound string for current username */$ int				index;				/* General index */N unsigned char			*item_bufadr;			/* Item buffer address from item list entry */I unsigned int			item_bufsiz;			/* Item buffer size from item list entry */ @ unsigned int			item_code;			/* Item code from item list entry */K int				list_count;			/* Number of list entries passed before adding item */ @ struct USRLSTDEF		*new_entry;			/* User list entry just added */2 int				new_entry_uic = 0;		/* UIC for new entry */L struct ITMDEF			(*new_user_info)[] = 0;		/* Item list for new information */3 unsigned int			status;				/* Routine exit status */ > struct USRLSTDEF		*user_entry;			/* Current user list entry */ int				widget_number = *tag;   /* Debug information. */   #ifdef DEBUGGING printf ("finish entry\n"); #endif /* DEBUGGING */  # /* Do any needed initialization. */   A current_username = XmStringCreateSimple (uaf_t_current_username);   G /* Look through all the item list entries for the current user, and see H ** if a UAI$_UIC entry is present.  If it is, note the UIC for later. */  M for (index = 0; (*uaf_r_current_user_info)[index].itm$w_itmcod != 0; index++)      {   . /* Set up information from item list entry. */  ?     item_code = (*uaf_r_current_user_info)[index].itm$w_itmcod; A     item_bufsiz = (*uaf_r_current_user_info)[index].itm$w_bufsiz; A     item_bufadr = (*uaf_r_current_user_info)[index].itm$l_bufadr;   O /* If a UIC entry is found, note the UIC for later and trip out of the loop. */        if (item_code == UAI$_UIC) 	{7 	new_entry_uic = (*(unsigned int (*)[])item_bufadr)[0];  	break;  	}     }   I /* Based upon the operation being performed, do the necessary final steps H ** to complete the operation started (i.e., create, modify, etc.) on the ** authorization entry. */   switch (uaf_l_main_operation)      {   , /* The modification template is complete. */  #     case uaf$c_cmd_modify_template:  	{  J /* Get the information from the (template) authorization entry window, and% ** build an appropriate item list. */   0 	if (FALSE (AUTHORIZE$GET_ENTRY (&new_user_info,	 					1)))  	    { 	    XtFree (current_username); ; 	    return;					/* Return with windows still up on error*/  	    }  J /* Compare the new information with the existing template information, and3 ** build an item list with just the differences. */   ) 	AUTHORIZE$ITMLST_COMPARE (new_user_info,  				  uaf_r_template_info, 				  &new_user_info);  K /* The changed item list entries must now be added to the original template M ** information.  This is done by taking each of the changed item list entries A ** and adding it to the original template information in turn. */   D 	for (index = 0; (*new_user_info)[index].itm$w_itmcod != 0; index++) 	    {5 	    AUTHORIZE$ITMLST_ADD_ITEM (&uaf_r_template_info, 0 				       (*new_user_info)[index].itm$w_itmcod,0 				       (*new_user_info)[index].itm$w_bufsiz,1 				       (*new_user_info)[index].itm$l_bufadr);  	    }  < /* Delete the temporary (new user information) item list. */  * 	AUTHORIZE$ITMLST_DELETE (&new_user_info); 	break;  	}  # /* A new entry is being created. */        case uaf$c_main_create:  	{  H /* Get the information from the authorization entry window, and build an ** appropriate item list. */  : 	if (FALSE (AUTHORIZE$GET_ENTRY (&uaf_r_current_user_info,	 					0)))  	    { 	    XtFree (current_username); ; 	    return;					/* Return with windows still up on error*/  	    }  G /* Merge the new user info item list with the current default info item K ** list.  This will insure all information is present and accounted for. */   1 	AUTHORIZE$ITMLST_MERGE (uaf_r_current_user_info,  				uaf_r_current_group_info,  				&uaf_r_current_user_info);  F /* Create a new authorization entry with the specified information. */  < 	if (FALSE (AUTHORIZE$CRE_USER_INFO (uaf_t_current_username,# 					    uaf_r_current_user_info)))  	    {  M /* Since an error has occurred creating the authorization information for the N ** user, note the error and dismiss; leaving the existing window unchanged. */  , 	    AUTHORIZE$DECW_ERROR (UAF$_UAFWRITERR); 	    XtFree (current_username);  	    return; 	    }  + /* Add the new entry to the master list. */   2 	AUTHORIZE$ADD_LIST_ENTRY (uaf_t_current_username, 				  new_entry_uic,, 				  &uaf_r_master_list.uaf$l_usrlst_flink, 				  &new_entry);  H /* If the newly created entry passes the filter check, add it to the use ** list. */   A 	if (TRUE (AUTHORIZE$MATCH_NAME (strlen (uaf_t_current_username),  					uaf_t_current_username,$ 					strlen (uaf_t_username_filter), 					uaf_t_username_filter)))  	    {  P /* Locate the entry in the user list after which the new entry will be added. */  D 	    AUTHORIZE$FIND_USER_ENTRY (&uaf_r_user_list.uaf$l_usrlst_flink," 				       uaf_t_current_username, 				       FIND_NAME_LESS, 				       &list_count,  				       &user_entry);  I /* USER_ENTRY now points to the "list head"; where the new entry is to be  ** added.  Do it. */  6 	    AUTHORIZE$ADD_LIST_ENTRY (uaf_t_current_username, 				      NULL, * 				      &user_entry->uaf$l_usrlst_flink, 				      &new_entry);5 	    ++uaf_l_current_user_max;				/* One more user */ @ 	    XmListAddItem (uaf_r_widget_id_array[uaf$c_main_user_list], 			   current_username,  			   list_count);  6 /* Set up the current username as the selected one. */  7 	    AUTHORIZE$SET_UP_USERNAME (uaf_t_current_username,  				       NULL);  	    }  K /* If the newly created entry represents a new group (member number 177777) $ ** add it to the group user list. */  N 	for (index = 0; (*uaf_r_current_user_info)[index].itm$w_itmcod != 0; index++) 	    {  . /* Set up information from item list entry. */  @ 	    item_code = (*uaf_r_current_user_info)[index].itm$w_itmcod;B 	    item_bufsiz = (*uaf_r_current_user_info)[index].itm$w_bufsiz;B 	    item_bufadr = (*uaf_r_current_user_info)[index].itm$l_bufadr;  G /* Look through all the item list entries for the current user, and see H ** if a UAI$_UIC entry is present.  If it is, check to see if the member+ ** portion of the UIC is 177777 (octal). */    	    if (item_code == UAI$_UIC)  		{ = 		if ((*(unsigned short int (*)[])item_bufadr)[0] == 0177777)  		    {   Q /* Locate the entry in the group list after which the new entry will be added. */   F 		    AUTHORIZE$FIND_USER_ENTRY (&uaf_r_group_list.uaf$l_usrlst_flink,# 					       uaf_t_current_username,  					       FIND_NAME_LESS,  					       &list_count, 					       &user_entry);   G /* USER_ENTRY now points to the list head; where the new entry is to be  ** added.  Do it. */  7 		    AUTHORIZE$ADD_LIST_ENTRY (uaf_t_current_username,  					      NULL,+ 					      &user_entry->uaf$l_usrlst_flink,  					      &new_entry); 8 		    ++uaf_l_current_group_max;				/* One more group */B 		    XmListAddItem (uaf_r_widget_id_array[uaf$c_main_group_list], 				   uaf_t_current_username, 				   list_count);  		    }  		}  	    } 	break;  	}  * /* An existing entry is being modified. */       case uaf$c_main_modify:  	{  H /* Get the information from the authorization entry window, and build an ** appropriate item list. */  0 	if (FALSE (AUTHORIZE$GET_ENTRY (&new_user_info,	 					0)))  	    { 	    XtFree (current_username); ; 	    return;					/* Return with windows still up on error*/  	    }  N /* Compare the new information with the current information, and build an item% ** list with just the differences. */   ) 	AUTHORIZE$ITMLST_COMPARE (new_user_info,  				  uaf_r_current_user_info, 				  &new_user_info);  D /* Update the authorization entry with the specified information. */  < 	if (FALSE (AUTHORIZE$SET_USER_INFO (uaf_t_current_username, 					    new_user_info)))s 	    {  L /* Since an error has occurred setting the authorization information for theN ** user, note the error and dismiss; leaving the existing window unchanged. */  , 	    AUTHORIZE$DECW_ERROR (UAF$_UAFWRITERR); 	    XtFree (current_username);	 	    return; 	    }  < /* Delete the temporary (new user information) item list. */  * 	AUTHORIZE$ITMLST_DELETE (&new_user_info); 	break;  	}     }<  M /* Since I am finished with then authorization entry window, tear it down. */   , XtUnmanageChild (uaf_r_entry_window_widget);  4 /* If there is an access window up, tear it down. */  1 if (XtIsManaged (uaf_r_access_pri_window_widget))U5     XtUnmanageChild (uaf_r_access_pri_window_widget);_1 if (XtIsManaged (uaf_r_access_sec_window_widget))t5     XtUnmanageChild (uaf_r_access_sec_window_widget);    XtFree (current_username); }I  D extern unsigned int AUTHORIZE$GET_ENTRY (itmlst, ignore_null_fields)   struct ITMDEF		(**itmlst)[]; int			ignore_null_fields;a {} /* **++ **  FUNCTIONAL DESCRIPTION:  **G **	This routine is called to get the information from the authorizationtF **	entry window, and convert it to the appropriate ($xxxUAI) item list
 **	format. ** **  FORMAL PARAMETERS: **9 **	ITMLST			- Address of a pointer containing the pointerH **				  to the new item list@ **	IGNORE_NULL_FIELDS	- = 0 to accept empty (zero length) fields0 **				  = 1 to ignore empty (zero length) fields ** **  RETURN VALUE:  **
 **	SS$_NORMAL  ** **  SIDE EFFECTS:r ** **	None	 ** **-- */   /* External routines. */  . extern unsigned int		AUTHORIZE$CONVERT_UIC ();& extern void			AUTHORIZE$DECW_ERROR ();3 extern unsigned int		AUTHORIZE$GET_LIST_ENTRIES ();i+ extern void			AUTHORIZE$ITMLST_ADD_ITEM ();w) extern void			AUTHORIZE$ITMLST_DELETE ();u   /* Global references. */  J globalref struct UAFLAG		uaf_r_flags;				/* Miscellaneous utility flags */S globalref struct FMTABL		uaf_r_item_table[];			/* Entry window info format table */i` globalref Widget		uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */U globalref char			*uaf_t_no_date_time;			/* String to use when no date/time present */u[ globalref char			*uaf_t_pre_expired;			/* String to use when no pwd chg dat/time present */    /* Local storage. */  O unsigned char			ascii_string[MAX_TEMP_STRING];		/* ASCII string of some form */bJ char				device_terminator = ':';		/* Device string terminator character */% int				index;					/* General index */(C unsigned int			simple_desc[2];				/* Simple character descriptor */e4 unsigned int			status;					/* Routine exit status */2 char				*temp_string;				/* Temp string pointer */8 int				temp_string_length;			/* Length of temp string */   /* Debug information. */   #ifdef DEBUGGING printf ("get entry info\n"); #endif /* DEBUGGING */  $ /* Delete any existing item list. */  ! AUTHORIZE$ITMLST_DELETE (itmlst);t  F /* Loop through each entry in the item table and get the corresponding ** widget value. */*  4 for (index = 0; index < UAI$_MAX_ITEM_CODE; index++)     {   K /* Clear out any previous buffer contents by filling the target buffer withu$ ** the appropriate pad character. */  X     memset (ascii_string, uaf_r_item_table[index].item_b_pad_char, sizeof ascii_string);  E /* If there is a widget-id for the item table entry, get the value (a ) ** string) associated with the widget. */   7     if ((uaf_r_item_table[index].item_l_widget != 0) &&fE 	(uaf_r_widget_id_array[uaf_r_item_table[index].item_l_widget] != 0))  	{^ 	temp_string = XmTextGetString (uaf_r_widget_id_array[uaf_r_item_table[index].item_l_widget]);+ 	temp_string_length = strlen (temp_string);n  J /* Only attempt to decode the information if there was something specified/ ** in the field.  Otherwise, simply skip it. */o  ! 	if ((temp_string_length != 0) ||  	    (ignore_null_fields == 0))} 	    {  I /* Now that I have a string, it is time to decode it.  The method used tooH ** decode the information is determined by various flags set in the item ** table entry. */  H /* A counted ASCII string.  This is done by placing the string length inJ ** the first byte of the target string, and then copying the actual string ** text. */n  W 	    if (uaf_r_item_table[index].item_r_flag_overlay.item_r_flag_bits.item_v_flag_cstr)  		{   J /* Make sure the string copy will not exceed the maximum size of a counted ** ASCII string (255 bytes). */S  4 		if (temp_string_length > 255) return SS$_BADPARAM;' 		ascii_string[0] = temp_string_length;a   /* Copy the string text. */a  ; 		memmove (&ascii_string[1], temp_string, ascii_string[0]);e. 		++temp_string_length;			/* For count byte */ 		}d  J /* A simple ASCII string.  This is done by first filling the target stringM ** with the appropriate pad character, and then copying the actual string. */E  V 	    if (uaf_r_item_table[index].item_r_flag_overlay.item_r_flag_bits.item_v_flag_asc) 		{T  N /* Make sure the text string is not too large for the authorization record. */  X 		if (temp_string_length > uaf_r_item_table[index].item_w_byte_cnt) return SS$_BADPARAM;   /* Copy the string text. */r  : 		memmove (ascii_string, temp_string, temp_string_length); 		}t  I /* A value to be converted from a string.  This is done by converting the J ** numeric string to the corresponding binary value.  The resulting binaryI ** value is placed in the target "string" to make the logic a little morew- ** simple; by allowing a common code path. */i  V 	    if (uaf_r_item_table[index].item_r_flag_overlay.item_r_flag_bits.item_v_flag_val) 		{t; 		(*(int *)ascii_string) = strtoul (temp_string, NULL, 10);Tc 		temp_string_length = uaf_r_item_table[index].item_w_byte_cnt;	/* Byte count of converted value */  		}a  M /* A date string.  This is pretty simple, but there is the special case wheretN ** the date string is "(none)".  In this case, the resulting value is zero. */  V 	    if (uaf_r_item_table[index].item_r_flag_overlay.item_r_flag_bits.item_v_flag_dat) 		{h  M /* Check for date/time specified.  If there is no date/time specified, simply_P ** do nothing.  This will result in a zero value (because of the buffer preset)." ** Otherwise, convert the date. */  8 		if ((strcmp (temp_string, uaf_t_no_date_time) != 0) &&5 		    (strcmp (temp_string, uaf_t_pre_expired) != 0))  		    {L  J /* Initialize a simple character descriptor for the temp string buffer. */  * 		    simple_desc[0] = temp_string_length;# 		    simple_desc[1] = temp_string;*   /* Convert the time string. */  , 		    CHECK_RETURN (SYS$BINTIM (simple_desc, 					      ascii_string)); 		    }tG 		temp_string_length = QUADWORD;				/* Converted value is a quadword */s 		}   ) /* An item requiring special handling. */	  V 	    if (uaf_r_item_table[index].item_r_flag_overlay.item_r_flag_bits.item_v_flag_spc) 		{  		if (index == UAI$_CPUTIM)  		    {i  M /* Check for date/time specified.  If there is no date/time specified, simplyxP ** do nothing.  This will result in a zero value (because of the buffer preset)." ** Otherwise, convert the date. */  8 		    if (strcmp (temp_string, uaf_t_no_date_time) != 0) 			{  I /* Decode the CPU time limit.  This is done as a standard delta time, andN6 ** then the second longword of the time is dropped. */  J /* Initialize a simple character descriptor for the temp string buffer. */  ' 			simple_desc[0] = temp_string_length;/  			simple_desc[1] = temp_string;   /* Convert the time string. */  ) 			CHECK_RETURN (SYS$BINTIM (simple_desc,c 						  ascii_string));	 			}K 		    temp_string_length = LONGWORD;				/* Converted value is a longword */  		    }e 		if (index == UAI$_UIC) 		    {i  K /* Decode the UIC.  In the simple case, this could simply mean interpretingIH ** a comma separated pair of octal numbers.  However, in the interest ofH ** flexibility, a separate routine is called to use TPARSE to decode theJ ** UIC string.  This allows octal numbers or identifiers to be used in the ** UIC string. */u   /* Convert the UIC string. */*  7 		    CHECK_RETURN (AUTHORIZE$CONVERT_UIC (temp_string,u 							 ascii_string));pK 		    temp_string_length = LONGWORD;				/* Converted value is a longword */_ 		    }/ 		}i  E /* If necessary, use the maximal item size instead of the actual sizeiE ** (from the entry window).  This is necessary for such things as the[ ** account field. */  V 	    if (uaf_r_item_table[index].item_r_flag_overlay.item_r_flag_bits.item_v_flag_max)? 		temp_string_length = uaf_r_item_table[index].item_w_byte_cnt;l  H /* Add the information to the item list; if it is not the username.  TheG ** username item is not added because it is a formal input parameter tonE ** the routines that actually create or modify the user authorizationI ** information. */    	    if (index != UAI$_USERNAME)$ 		AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 					   index, 					   temp_string_length,_ 					   ascii_string); 	    }  8 /* Free up any storage allocated for the text string. */   	XtFree (temp_string); 	}     }t RH /* Since all the standard information has been processed, do the specialH ** case information.  These are usually bit masks (streams) or composite
 ** fields. */o  # /* Default device and directory. */a  4 if (uaf_r_widget_id_array[uaf$c_entry_default] != 0)     {r   /* Get the default string. *//  O     temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_entry_default]);n.     temp_string_length = strlen (temp_string);        if (temp_string_length == 0) 	{  N /* If the default string is empty, and enpty fields are being accepted, createO ** the appropriate item list entries; otherwise simply ignore the field.  TheseeN ** fields are all zero, indicating a null counted string, but still having the ** maximal size. */i   	if (ignore_null_fields == 0)  	    {w 	    memset (ascii_string, uaf_r_item_table[UAI$_DEFDEV].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */ B 	    AUTHORIZE$ITMLST_ADD_ITEM (itmlst,						/* ITEM_M_FLAG_MAX */ 				       UAI$_DEFDEV,u 				       MAX_DEFDEV, 				       ascii_string);Iw 	    memset (ascii_string, uaf_r_item_table[UAI$_DEFDIR].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */uB 	    AUTHORIZE$ITMLST_ADD_ITEM (itmlst,						/* ITEM_M_FLAG_MAX */ 				       UAI$_DEFDIR,t 				       MAX_DEFDIR, 				       ascii_string);  	    } 	}     else 	{  T /* Loop through the  source string looking for the device (terminated by a colon. */  s 	memset (ascii_string, uaf_r_item_table[UAI$_DEFDEV].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */{1 	ascii_string[0] = 0;						/* Reset byte count */o5 	for (index = 0; index < temp_string_length; index++)m 	    {U 	    ascii_string[ascii_string[0] + 1] = temp_string[index];	/* Copy one character */ C 	    ++ascii_string[0];						/* One more character in count byte */p1 	    if (temp_string[index] == device_terminator)i 		{t  E /* Add the default device name item.  This must have maximal size. */   > 		AUTHORIZE$ITMLST_ADD_ITEM (itmlst,					/* ITEM_M_FLAG_MAX */ 					   UAI$_DEFDEV, 					   MAX_DEFDEV,e 					   ascii_string);u 		memset (ascii_string, uaf_r_item_table[UAI$_DEFDIR].item_b_pad_char, sizeof ascii_string);  /* Clear out and pad */h1 		ascii_string[0] = 0;					/* Reset byte count */r 		}l 	    }  M /* At this point, the count byte will contain the number of characters in theo ** directory string. */   > 	AUTHORIZE$ITMLST_ADD_ITEM (itmlst,						/* ITEM_M_FLAG_MAX */ 				   UAI$_DEFDIR,e 				   MAX_DEFDIR, 				   ascii_string);o 	}  8 /* Free up any storage allocated for the text string. */       XtFree (temp_string);t     }e   /* Default privilege mask. */e  $ if (uaf_r_flags.uaf_v_mod_def_privs)     {ex     memset (ascii_string, uaf_r_item_table[UAI$_DEF_PRIV].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */:     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_entry_def_priv_list, 				ascii_string,  				sizeof ascii_string);$&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_DEF_PRIV, 			       QUADWORD,) 			       ascii_string);     }t   /* Login flags. */  & if (uaf_r_flags.uaf_v_mod_login_flags)     {eu     memset (ascii_string, uaf_r_item_table[UAI$_FLAGS].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */ <     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_entry_login_flag_list, 				ascii_string,n 				sizeof ascii_string);e&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_FLAGS,i 			       LONGWORD,  			       ascii_string);     }F   /* Primary days. */m  % if (uaf_r_flags.uaf_v_mod_prime_days)      { y     memset (ascii_string, uaf_r_item_table[UAI$_PRIMEDAYS].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */i:     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_entry_primeday_list, 				ascii_string,E 				sizeof ascii_string);u  M /* In the primary day mask, the primary days are 0 and the secondary days are O ** 1.  This means the resulting bit stream must be complemented prior to adding 8 ** it to the item list (for the authorization entry). */  $     COMPLEMENT (BYTE, ascii_string);&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_PRIMEDAYS,T 			       BYTE,  			       ascii_string);     }    /* Authorized privileges. */  % if (uaf_r_flags.uaf_v_mod_auth_privs)	     {ut     memset (ascii_string, uaf_r_item_table[UAI$_PRIV].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */;     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_entry_auth_priv_list,n 				ascii_string,t 				sizeof ascii_string); &     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_PRIV, 			       QUADWORD,N 			       ascii_string);     };   /* Access restrictions. */  + if (uaf_r_flags.uaf_v_mod_pri_local_access)S     { ~     memset (ascii_string, uaf_r_item_table[UAI$_LOCAL_ACCESS_P].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */<     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_pri_local_list, 				ascii_string,[ 				sizeof ascii_string);   R /* In the local access mask, access is granted if the hour bit is clear and deniedO ** if the hour bit is set.  In other words, a bit stream of all zeros indicates O ** full access.  This means the resulting bit stream must be complemented priorrB ** to adding it to the item list (for the authorization entry). */  +     COMPLEMENT (ACCESS_SIZE, ascii_string);i&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_LOCAL_ACCESS_P, 			       ACCESS_SIZE, 			       ascii_string);     }e  + if (uaf_r_flags.uaf_v_mod_sec_local_access)r     {e~     memset (ascii_string, uaf_r_item_table[UAI$_LOCAL_ACCESS_S].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */<     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_sec_local_list, 				ascii_string,  				sizeof ascii_string);hN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_LOCAL_ACCESS_S, 			       ACCESS_SIZE, 			       ascii_string);     }s  + if (uaf_r_flags.uaf_v_mod_pri_batch_access)      { ~     memset (ascii_string, uaf_r_item_table[UAI$_BATCH_ACCESS_P].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */<     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_pri_batch_list, 				ascii_string,o 				sizeof ascii_string);eN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_BATCH_ACCESS_P, 			       ACCESS_SIZE, 			       ascii_string);     }_  + if (uaf_r_flags.uaf_v_mod_sec_batch_access)	     {i~     memset (ascii_string, uaf_r_item_table[UAI$_BATCH_ACCESS_S].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */<     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_sec_batch_list, 				ascii_string,f 				sizeof ascii_string);GN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_BATCH_ACCESS_S, 			       ACCESS_SIZE, 			       ascii_string);     }   , if (uaf_r_flags.uaf_v_mod_pri_dialup_access)     {      memset (ascii_string, uaf_r_item_table[UAI$_DIALUP_ACCESS_P].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */ =     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_pri_dialup_list,r 				ascii_string,	 				sizeof ascii_string);dN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_DIALUP_ACCESS_P,s 			       ACCESS_SIZE, 			       ascii_string);     }t  , if (uaf_r_flags.uaf_v_mod_sec_dialup_access)     {      memset (ascii_string, uaf_r_item_table[UAI$_DIALUP_ACCESS_S].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */n=     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_sec_dialup_list,e 				ascii_string,  				sizeof ascii_string);SN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_DIALUP_ACCESS_S,f 			       ACCESS_SIZE, 			       ascii_string);     }o  , if (uaf_r_flags.uaf_v_mod_pri_remote_access)     {_     memset (ascii_string, uaf_r_item_table[UAI$_REMOTE_ACCESS_P].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */ =     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_pri_remote_list,e 				ascii_string,; 				sizeof ascii_string);nN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_REMOTE_ACCESS_P,  			       ACCESS_SIZE, 			       ascii_string);     }o  , if (uaf_r_flags.uaf_v_mod_sec_remote_access)     {o     memset (ascii_string, uaf_r_item_table[UAI$_REMOTE_ACCESS_S].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */h=     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_sec_remote_list,	 				ascii_string,t 				sizeof ascii_string);	N     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst, 			       UAI$_REMOTE_ACCESS_S,a 			       ACCESS_SIZE, 			       ascii_string);     }U  - if (uaf_r_flags.uaf_v_mod_pri_network_access)x     {s     memset (ascii_string, uaf_r_item_table[UAI$_NETWORK_ACCESS_P].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */>     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_pri_network_list, 				ascii_string,l 				sizeof ascii_string);lN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst,  			       UAI$_NETWORK_ACCESS_P, 			       ACCESS_SIZE, 			       ascii_string);     }t  - if (uaf_r_flags.uaf_v_mod_sec_network_access)e     {      memset (ascii_string, uaf_r_item_table[UAI$_NETWORK_ACCESS_S].item_b_pad_char, sizeof ascii_string);	/* Clear out and pad */>     AUTHORIZE$GET_LIST_ENTRIES (uaf$c_access_sec_network_list, 				ascii_string,i 				sizeof ascii_string);vN     COMPLEMENT (ACCESS_SIZE, ascii_string);			/* See comments on above call */&     AUTHORIZE$ITMLST_ADD_ITEM (itmlst,  			       UAI$_NETWORK_ACCESS_S, 			       ACCESS_SIZE, 			       ascii_string);     }m   /* Primary password. */   5 if (uaf_r_widget_id_array[uaf$c_entry_password] != 0)p     {    /* Get the password string. */  P     temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_entry_password]);.     temp_string_length = strlen (temp_string);        if (temp_string_length != 0) 	{  Q /* If a password string was specified, create the appropriate item list entry. */x  # 	AUTHORIZE$ITMLST_ADD_ITEM (itmlst,+ 				   UAI$_PASSWORD,o 				   temp_string_length, 				   temp_string);  H /* Since the password should not remain visible, clear out the field. */  > 	XmTextSetString (uaf_r_widget_id_array[uaf$c_entry_password], 			 &NULL);  	}  8 /* Free up any storage allocated for the text string. */       XtFree (temp_string);t     }e   /* Secondary password. */_  6 if (uaf_r_widget_id_array[uaf$c_entry_password2] != 0)     {_   /* Get the password string. */  Q     temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_entry_password2]);i.     temp_string_length = strlen (temp_string);        if (temp_string_length != 0) 	{  Q /* If a password string was specified, create the appropriate item list entry. */s  # 	AUTHORIZE$ITMLST_ADD_ITEM (itmlst,r 				   UAI$_PASSWORD2, 				   temp_string_length, 				   temp_string);  H /* Since the password should not remain visible, clear out the field. */  > 	XmTextSetString (uaf_r_widget_id_array[uaf$c_entry_password], 			 &NULL);y 	}  8 /* Free up any storage allocated for the text string. */       XtFree (temp_string);t     }f  3 /* The item list is complete.  Exit stage right. */    return SS$_NORMAL; }u r+ extern void AUTHORIZE$SET_UP_ENTRY (itmlst)_   struct ITMDEF			(*itmlst)[]; {  /* **++ **  FUNCTIONAL DESCRIPTION:  **H **	This routine is called to set up the information in the authorizationJ **	entry window.  The information is obtained from the supplied item list. ** **  FORMAL PARAMETERS: **% **	ITMLST		- Address of the item listi ** **  RETURN VALUE:i ** **	{@description or none@} ** **  SIDE EFFECTS:b ** **	{@description or none@} ** **-- */   /* External routines. */  / extern void			AUTHORIZE$SELECT_LIST_ENTRIES ();c) extern void			AUTHORIZE$SET_UP_ACCESS ();E   /* Global references. */  e globalref Widget		uaf_r_access_pri_window_widget;	/* Primary access restriction window widget info */og globalref Widget		uaf_r_access_sec_window_widget;	/* Secondary access restriction window widget info */_I globalref struct UAFLAG		uaf_r_flags;			/* Miscellaneous utility flags */ R globalref struct FMTABL		uaf_r_item_table[];		/* Entry window info format table */` globalref Widget		uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */T globalref char			*uaf_t_no_date_time;		/* String to use when no date/time present */Z globalref char			*uaf_t_pre_expired;		/* String to use when no pwd chg dat/time present */   /* Local storage. */  9 unsigned int			date_time[2];			/* Temp date time value */iA char				default_dev[MAX_DEFDEV] = "";	/* Default device string */=D char				default_dir[MAX_DEFDIR] = "";	/* Default directory string */$ int				index;				/* General index */, int				index2;				/* Second general index */N unsigned char			*item_bufadr;			/* Item buffer address from item list entry */I unsigned int			item_bufsiz;			/* Item buffer size from item list entry */_@ unsigned int			item_code;			/* Item code from item list entry */B unsigned int			simple_desc[2];			/* Simple character descriptor */3 unsigned int			status;				/* Routine exit status */ D char				temp_string[MAX_TEMP_STRING];	/* Temporary string storage */? int				temp_string_length;		/* Length of temp string (built) */a? int				widget_number;			/* Widget number for item list entry */a   /* Debug information. */   #ifdef DEBUGGING printf ("set up entry\n"); #endif /* DEBUGGING */  K /* Before setting up the new information in the authorization entry window,_& ** clear out any stale information. */  4 for (index = 0; index < UAI$_MAX_ITEM_CODE; index++)     {;  I /* If there is a widget-id for the item table entry, reset the associatedl ** text string. */  7     if ((uaf_r_item_table[index].item_l_widget != 0) &&lE 	(uaf_r_widget_id_array[uaf_r_item_table[index].item_l_widget] != 0)) O 	XmTextSetString (uaf_r_widget_id_array[uaf_r_item_table[index].item_l_widget],  			 &NULL);.     }w  2 /* Reset the default device & directory string. */  < XmTextSetString (uaf_r_widget_id_array[uaf$c_entry_default],
 		 &NULL);  Q /* Reset the various lists.  This is done by deselecting all the list entries. */a  J XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_entry_def_priv_list]);K XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_entry_auth_priv_list]);/L XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_entry_login_flag_list]);J XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_entry_primeday_list]);  L XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_pri_local_list]);L XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_pri_batch_list]);M XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_pri_dialup_list]);nM XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_pri_remote_list]);*N XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_pri_network_list]);  L XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_sec_local_list]);L XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_sec_batch_list]);M XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_sec_dialup_list]);NM XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_sec_remote_list]);rN XmListDeselectAllItems (uaf_r_widget_id_array[uaf$c_access_sec_network_list]);  5 /* If the item list pointer is zero, trip out now. */u   if (itmlst == 0) return;  L /* Loop through the item list entries and set the appropriate information in% ** the authorization entry window. */e  < for (index = 0; (*itmlst)[index].itm$w_itmcod != 0; index++)     {i     ; /* Get the information from the current item list entry. */i  .     item_code = (*itmlst)[index].itm$w_itmcod;0     item_bufsiz = (*itmlst)[index].itm$w_bufsiz;0     item_bufadr = (*itmlst)[index].itm$l_bufadr;  K /* Depending on the type of information (i.e., value, counted string, etc.)rN ** do some limit checking.  There are two possible cases: too much informationM ** supplied, and not enough information supplied.  The former case would mostlM ** likely occur with some form of ASCII text and the latter would most likelyo! ** occur with some form of value.r **O ** If the limit check fails, return an SS$_BADPARAM error.  This also indicates_Q ** the uaf_r_item_table probably needs to be updated; i.e., an internal error. */*  ^     if ((uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_cstr) ||T 	(uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_asc)) 	{\ 	if (item_bufsiz > uaf_r_item_table[item_code].item_w_byte_cnt) LIB$SIGNAL (UAF$_INTERNAL1); 	}     else 	{\ 	if (item_bufsiz < uaf_r_item_table[item_code].item_w_byte_cnt) LIB$SIGNAL (UAF$_INTERNAL1); 	}  U /* Get the widget number corresponding to the widget associated with the information. M ** This may be zero, which usually indicates special processing is needed. */c  >     widget_number = uaf_r_item_table[item_code].item_l_widget;  K /* Clear out any previous buffer contents.  This also assumes the typical CXF ** character string storage is terminated by a null (\0) character. */  3     memset (temp_string, NULL, sizeof temp_string);r  J /* Initialize a simple character descriptor for the temp string buffer. */  I     simple_desc[0] = (sizeof temp_string) - 1;		/* -1 for ASCIZ string */ !     simple_desc[1] = temp_string;   K /* Determine how the information in the item list entry is to be formatted.aQ ** This is done by examining the flags associated with the format table entry. */a   /* A counted ASCII string. **E ** For this case, the first byte of the buffer contains the number ofo ** ASCII characters to copy. ** */  Z     if (uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_cstr) 	{  L /* Make sure the temp storage area is not exceeded when copying the text. */  S 	temp_string_length = item_bufadr[0];			/* Assume it will all fit (-1 for count) */d  K /* If the size of the supplied buffer is greater than the internal storage,E/ ** truncate the supplied information to fit. */$  - 	if (temp_string_length > sizeof temp_string)i3 	    temp_string_length = (sizeof temp_string) - 1;E  @ /* Copy the appropriate amount of text, minus the count byte. */  < 	memmove (temp_string, &item_bufadr[1], temp_string_length); 	}   /* A simple ASCII string. */  Y     if (uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_asc)M 	{  G /* Copy the string up to the first occurrance of the pad character, theMB ** input string is exhausted, or the target buffer is exceeded. */  b 	for (temp_string_length = 0; temp_string_length < (sizeof temp_string) - 1; temp_string_length++) 	    {2 	    if (temp_string_length == item_bufsiz) break;_ 	    if (item_bufadr[temp_string_length] == uaf_r_item_table[item_code].item_b_pad_char) break;uG 	    temp_string[temp_string_length] = item_bufadr[temp_string_length];  	    } 	}  * /* A value to be converted to a string. */  Y     if (uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_val)_ 	{  Q /* Format the value.  Because the buffer is zeroed (above) prior to the FAO call, 0 ** the formatting results in an ASCIZ string. */  ; 	SYS$FAO (&uaf_r_item_table[item_code].item_l_fao_ctrs_len,d 		 simple_desc,Z 		 simple_desc,S! 		 (*(int (*)[])item_bufadr)[0]);	 	}  J /* Format a date/time quadword.  This may be an absolute or delta time. */  ]     if ((uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_dat) &&yG 	(item_bufsiz >= 8))	/* Must be at least a quadword...otherwise skip */i 	{  P /* If the quadword time value is zero, substitute a reasonable string instead of< ** the usual "1858" date :-).  Otherwise, format the time.*/  L 	if ((*(int (*)[])item_bufadr)[0] == 0 && (*(int (*)[])item_bufadr)[1] == 0) 	    {  N /* If the zero time value is for a password change date (primary or secondary)E ** change the string used to "(pre-expired)" rather than "(none)". */e  ( 	    if ((item_code == UAI$_PWD_DATE) ||  		(item_code == UAI$_PWD2_DATE))* 		strcpy (temp_string, uaf_t_pre_expired);	 	    else + 		strcpy (temp_string, uaf_t_no_date_time);  	    } 	else; 	    SYS$ASCTIM (simple_desc,l 			simple_desc,a 			item_bufadr,o	 			NULL);s 	}  O /* Handle those items which require special formatting; but nothing more in theo# ** way of additional processing. */   Y     if (uaf_r_item_table[item_code].item_r_flag_overlay.item_r_flag_bits.item_v_flag_spc)e 	{ 	if (item_code == UAI$_CPUTIM) 	    {  O /* Format the CPU time limit.  This requires special processing because the CPU;P ** time limit is stored as the low longword of a delta time.  In order to formatQ ** it as a real delta time, set the date/time quadword to -1 before adding in theb; ** supplied buffer information (the remaining longword). */   0 	    memset (date_time, 0xFF, sizeof date_time);1 	    date_time[0] = (*(int (*)[])item_bufadr)[0];   P /* If the CPU time limit is zero, substitute a reasonable string instead of some ** random time string. */e   	    if (date_time[0] == 0)m+ 		strcpy (temp_string, uaf_t_no_date_time);i	 	    else  		SYS$ASCTIM (simple_desc, 			    simple_desc,  			    date_time,t
 			    NULL);o 	    } 	if (item_code == UAI$_UIC)  	    {  P /* Format the UIC.  This is done as a special case to allow the item table to beP ** used for input as well as output.  Because the buffer is zeroed (above) priorA ** to the FAO call, the formatting results in an ASCIZ string. */s  ? 	    SYS$FAO (&uaf_r_item_table[item_code].item_l_fao_ctrs_len,s 		     simple_desc,/ 		     simple_desc,/% 		     (*(int (*)[])item_bufadr)[0]);_ 	    } 	}  P /* If there is a widget number associated with the UAI item code, simply set the! ** string in the entry window. */t  w     if (uaf_r_widget_id_array[widget_number] != 0) XmTextSetString (uaf_r_widget_id_array[widget_number], temp_string);  sQ /* There are several authorization items that require special processing.  MostlyeR ** because they cannot be represented as simple values or strings.  See if any are0 ** present and do the appropriate processing. */  Q /* If a default privilege entry is seen, set the state of all the various defaulti ** privilege list entries. */E  #     if (item_code == UAI$_DEF_PRIV)t: 	AUTHORIZE$SELECT_LIST_ENTRIES (uaf$c_entry_def_priv_list, 				       item_bufadr,S 				       item_bufsiz);  H /* If a default device entry is seen, copy the device name for later. */  D     if (item_code == UAI$_DEFDEV) strcpy (default_dev, temp_string);  N /* If a default directory entry is seen, copy the directory name for later. */  D     if (item_code == UAI$_DEFDIR) strcpy (default_dir, temp_string);  M /* If a login flag entry is seen, set the state of all the various login flage ** list entries. */l        if (item_code == UAI$_FLAGS)< 	AUTHORIZE$SELECT_LIST_ENTRIES (uaf$c_entry_login_flag_list, 				       item_bufadr,g 				       item_bufsiz);  O /* If a primary day entry is seen, set the state of all the various primary daye ** list entries. */]  $     if (item_code == UAI$_PRIMEDAYS) 	{  M /* In the primary day mask, the primary days are 0 and the secondary days aretR ** 1.  This means the resulting bit stream must be complemented prior to selecting ** the items in the list. */  ' 	COMPLEMENT (item_bufsiz, item_bufadr);I: 	AUTHORIZE$SELECT_LIST_ENTRIES (uaf$c_entry_primeday_list, 				       item_bufadr,i 				       item_bufsiz); 	}  M /* If an authorized privilege entry is seen, set the state of all the variousm( ** authorized privilege list entries. */       if (item_code == UAI$_PRIV)o; 	AUTHORIZE$SELECT_LIST_ENTRIES (uaf$c_entry_auth_priv_list,s 				       item_bufadr,i 				       item_bufsiz);     }n  M /* Since the default device and default directory must be set up in the entry I ** window in a particular order, the display of this information has beenf ** deferred until now. **J ** If there is either a default device or a default directory, display the ** information at this time. */i  7 temp_string[0] = '\0';		/* Null string to start with */   @ if (strlen (default_dev) > 0) strcat (temp_string, default_dev);@ if (strlen (default_dir) > 0) strcat (temp_string, default_dir);  T if ((strlen (temp_string) > 0) && (uaf_r_widget_id_array[uaf$c_entry_default] != 0))@     XmTextSetString (uaf_r_widget_id_array[uaf$c_entry_default], 		     temp_string);  L /* If the primary access restriction window is managed, set up the lists. */  1 if (XtIsManaged (uaf_r_access_pri_window_widget))i$     AUTHORIZE$SET_UP_ACCESS (itmlst, 			     1);e  N /* If the secondary access restriction window is managed, set up the lists. */  1 if (XtIsManaged (uaf_r_access_sec_window_widget))_$     AUTHORIZE$SET_UP_ACCESS (itmlst, 			     2);T  H /* Note no list modifications performed as yet.  This must be done afterH ** the list have been set up by AUTHORIZE$SELECT_LIST_ENTRIES (otherwiseG ** AUTHORIZE$SELECT_LIST_ENTRIES would cause the list modification flago ** to get set. */s  $ uaf_r_flags.uaf_v_mod_def_privs = 0;& uaf_r_flags.uaf_v_mod_login_flags = 0;% uaf_r_flags.uaf_v_mod_prime_days = 0; % uaf_r_flags.uaf_v_mod_auth_privs = 0;_+ uaf_r_flags.uaf_v_mod_pri_local_access = 0; + uaf_r_flags.uaf_v_mod_pri_batch_access = 0;l, uaf_r_flags.uaf_v_mod_pri_dialup_access = 0;, uaf_r_flags.uaf_v_mod_pri_remote_access = 0;- uaf_r_flags.uaf_v_mod_pri_network_access = 0;T+ uaf_r_flags.uaf_v_mod_sec_local_access = 0; + uaf_r_flags.uaf_v_mod_sec_batch_access = 0;., uaf_r_flags.uaf_v_mod_sec_dialup_access = 0;, uaf_r_flags.uaf_v_mod_sec_remote_access = 0;- uaf_r_flags.uaf_v_mod_sec_network_access = 0;i };