  #module UAF_DW_IDENTIFIERS "X-1"   /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **? **		This module contains the various support routines needed by ; **		the DECwindows AUTHORIZE utility to manage identifiers.  **9 **  AUTHORS:	L. Mark Pilant			CREATION DATE:   4-Jun-1993  ** **  MODIFICATION HISTORY:  **( **	X-1	LMP		L. Mark Pilant,		 4-Jun-1993 **		Original version.  ** **-- */   /* ** **  INCLUDE FILES  ** */   #include <UICDEF>    #include ctype #include stdlib    #include <decw$include:mrmappl>    #include "uaf_header"    /* ** **  FORWARD ROUTINES ** */  ( #pragma noinline (AUTHORIZE$IDENTIFIERS)/ #pragma noinline (AUTHORIZE$IDENTIFIERS_UPDATE) . #pragma noinline (AUTHORIZE$MODIFY_IDENTIFIER). #pragma noinline (AUTHORIZE$SET_UP_ATTRIBUTES). #pragma noinline (AUTHORIZE$SET_UP_IDENTIFIER)- #pragma noinline (AUTHORIZE$SET_UP_SYSTEM_ID)   : extern void AUTHORIZE$IDENTIFIERS (widget_id, tag, reason)   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **? **	This routine is called to initiate processing of identifiers  **	for an authorization entry. ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  & extern void			AUTHORIZE$DECW_ERROR ();2 extern unsigned int		AUTHORIZE$FIND_USER_ENTRY ();. extern void			AUTHORIZE$IDENTIFIERS_UPDATE ();- extern void			AUTHORIZE$MODIFY_IDENTIFIER (); - extern void			AUTHORIZE$SET_UP_ATTRIBUTES (); - extern void			AUTHORIZE$SET_UP_IDENTIFIER (); , extern void			AUTHORIZE$SET_UP_SYSTEM_ID ();   /* Global references. */  G globalref unsigned int		uaf_l_current_user_uic;		/* Current user UIC */ U globalref Widget		uaf_r_identifier_window_widget;	/* Identifier window widget info */ W globalref struct USRLSTDEF	uaf_r_master_list;		/* Complete user list (from the file) */ [ globalref Widget		uaf_r_system_id_window_widget;	/* System identifier window widget info */ K globalref Widget		uaf_r_widget_id_array[];	/* Array of Widget IDs in use */    /* Local storage. */  ; unsigned int			id_attributes;			/* Identifier attributes */ 1 char				**identifier;			/* Identifier selected */ $ int				index;				/* General index */3 unsigned int			status;				/* Routine exit status */ 1 char				*temp_string;			/* Temp string pointer */ P char				text_string [MAX_USERNAME];	/* Text string (from main window) storage */> struct USRLSTDEF		*user_entry;			/* Current user list entry */ int				widget_number = *tag;8 short int			wildcard_name = 0;		/* Wildcard indicator */   /* Debug information. */   #ifdef DEBUGGING# printf ("identifier processing\n");  #endif /* DEBUGGING */  B /* Based upon the widget number, determine what should be done. */   switch (widget_number)     {       case uaf$c_main_identifiers: 	{  O /* Get the supplied username from the main window, convert it to all upper case 8 ** characters and see if there are wildcards present. */  L 	temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_main_username]);B 	strcpy (text_string, temp_string);					/* Copy the widget text */7 	for (index = 0; index < strlen (text_string); index++)  	    {P 	    text_string[index] = toupper (text_string[index]);			/* Upcase character */H 	    if (text_string[index] == '*') wildcard_name = 1;			/* Check for */J 	    if (text_string[index] == '%') wildcard_name = 1;			/*   wildcards */ 	    } 	XtFree (temp_string);  F /* Since the name is now uppercased, reflect it in the main window. */  = 	XmTextSetString (uaf_r_widget_id_array[uaf$c_main_username],  			 text_string);   C /* If there are any wildcards, complain and abort the operation. */    	if (wildcard_name != 0) 	    {- 	    AUTHORIZE$DECW_ERROR (UAF$_NOWILDCARDS);  	    return; 	    }  ( /* Make sure the user already exists. */  M 	if (FALSE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_master_list.uaf$l_usrlst_flink,  					      &text_string, 					      FIND_NAME_EQUAL, 
 					      0,  					      &user_entry)))  	    {  > /* The user does not exist.  Let the user know, and return. */  , 	    AUTHORIZE$DECW_ERROR (UAF$_NOSUCHUSER); 	    return; 	    }  ; /* Fill the identifier list with those held by the user. */   O 	uaf_l_current_user_uic = user_entry->uaf$l_usrlst_own_id;	/* Save for later */ 7 	AUTHORIZE$IDENTIFIERS_UPDATE (uaf_l_current_user_uic);   . /* Select the first identifier in the list. */  # 	AUTHORIZE$SET_UP_IDENTIFIER (NULL,  				     1);  ) /* Make the identifier window visible. */   0 	XtManageChild (uaf_r_identifier_window_widget); 	break;  	}  !     case uaf$c_identifier_system:  	{  F /* A list of the system identifiers is needed.  Build it and then make ** it visible. */    	AUTHORIZE$SET_UP_SYSTEM_ID (); / 	XtManageChild (uaf_r_system_id_window_widget);  	break;  	}  (     case uaf$c_system_identifier_cancel: 	{  K /* Simply tear down the system identifier window without doing anything. */   1 	XtUnmanageChild (uaf_r_system_id_window_widget);  	break;  	}  !     case uaf$c_identifier_modify:       case uaf$c_identifier_grant:!     case uaf$c_identifier_remove:  	{  I /* An identifier's attributes are being modified.  Get the attribute list * ** state and set the apptoprizte flags. */  ( 	AUTHORIZE$MODIFY_IDENTIFIER (widget_id,
 				     tag,  				     reason);  	break;  	}       case uaf$c_identifier_ok:  	{  J /* The "OK" action is the same as a modify, except the window will be torn ** down upon completion. */   & /* Tear down the identifier window. */  ( 	AUTHORIZE$MODIFY_IDENTIFIER (widget_id,
 				     tag,  				     reason); 2 	XtUnmanageChild (uaf_r_identifier_window_widget);  ; /* If necessary, tear down the system identifier window. */   1 	if (XtIsManaged (uaf_r_system_id_window_widget)) 5 	    XtUnmanageChild (uaf_r_system_id_window_widget);  	break;  	}  !     case uaf$c_identifier_cancel:  	{  D /* Simply tear down the identifier window without doing anything. */  2 	XtUnmanageChild (uaf_r_identifier_window_widget);  ; /* If necessary, tear down the system identifier window. */   1 	if (XtIsManaged (uaf_r_system_id_window_widget)) 5 	    XtUnmanageChild (uaf_r_system_id_window_widget);  	break;  	}     }  }   . extern void AUTHORIZE$IDENTIFIERS_UPDATE (uic)   int				uic;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **@ **	This routine is called to get the list of identifiers held byC **	the supplied UIC.  These are then placed in the identifier list.  ** **  FORMAL PARAMETERS: **4 **	UIC		- UIC for which the held identifiers will be **			  obtained  ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* Global references. */  K globalref Widget		uaf_r_widget_id_array[];	/* Array of Widget IDs in use */    /* Local storage. */  6 unsigned int			context = 0;			/* $FIND_HELD context */7 unsigned int			holder[2];			/* Holder for $FIND_HELD */ ? XmString			id_name;			/* Compound string for identifier name */ C char				id_name_buf[MAX_ID_SIZE];	/* Storage for identifier name */ L unsigned int			id_name_desc[2];		/* Simple descriptor for identifier name */? unsigned short int		id_name_len;			/* Identifier name length */ A unsigned int			identifier;			/* Identifier found by $FIND_HELD */ 3 unsigned int			status;				/* Routine exit status */    /* Debug information. */   #ifdef DEBUGGING  printf ("identifiers update\n"); #endif /* DEBUGGING */    /* Initialize needed storage. */  % id_name_desc[0] = sizeof id_name_buf;  id_name_desc[1] = &id_name_buf;    holder[0] = uic; holder[1] = 0;  > /* Delete all the entries currently in the identifier list. */  D XmListDeleteAllItems (uaf_r_widget_id_array[uaf$c_identifier_list]);  G /* Loop getting all the identifiers held by the specified holder id. */   $ while (TRUE (SYS$FIND_HELD (&holder, 			    &identifier,  			    NULL, 			    &context)))     {   ; /* Convert the identifier from a value to a text string. */        SYS$IDTOASC (identifier, 		 &id_name_len, 		 &id_name_desc,  		 NULL, 		 NULL,	 		 NULL); >     id_name_buf[id_name_len] = '\0';		/* Terminate the name */  % /* Add the identifier to the list. */   1     id_name = XmStringCreateSimple (id_name_buf); @     XmListAddItem (uaf_r_widget_id_array[uaf$c_identifier_list],
 		   id_name,  		   0);     XtFree (id_name);      }  }   @ extern void AUTHORIZE$MODIFY_IDENTIFIER (widget_id, tag, reason)   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **G **	This routine is called when it is necessary to modify the attributes I **	of an identifier.  The identifier name is obtained from the identifier G **	window and the attributes from the attribute list.  This information ' **	is then used with the holder record.  ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */  D /* The following is a mask to clear all id attributes available to aB ** holder of an identifier.  This must track the definition of theH ** symbol KGB$M_VALID_HOLDER_ATTRIB in the module [LOADSS]RDBSHR.B32. */  # #define			id_attrib_clear_mask	0x1f    /* External routines. */  + extern void		AUTHORIZE$GET_LIST_ENTRIES (); - extern void		AUTHORIZE$IDENTIFIERS_UPDATE (); , extern void		AUTHORIZE$SET_UP_ATTRIBUTES ();, extern void		AUTHORIZE$SET_UP_IDENTIFIER ();   /* Global references. */  F globalref unsigned int	uaf_l_current_user_uic;		/* Current user UIC */J globalref Widget	uaf_r_widget_id_array[];	/* Array of Widget IDs in use */   /* Local storage. */  9 XmString		compound_string;		/* General compound string */ 7 unsigned int		holder[2];			/* Holder for $xxx_HOLDER */ 4 unsigned int		identifier;			/* Identifier's value */M unsigned int		identifier_attributes = 0;	/* Identifier's attributes to set */ # int			index;				/* General index */ A unsigned int		simple_desc[2];			/* Simple character descriptor */ 2 unsigned int		status;				/* Routine exit status */0 char			*temp_string;			/* Temp string pointer */O char			text_string [MAX_USERNAME];	/* Text string (from main window) storage */  int			widget_number = *tag;    /* Debug information. */   #ifdef DEBUGGING printf ("modify identifier\n");  #endif /* DEBUGGING */  J /* Get the supplied identifier name from the identifier window and convert& ** it to all upper case characters. */  M temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_identifier_name]); A strcpy (text_string, temp_string);					/* Copy the widget text */ 6 for (index = 0; index < strlen (text_string); index++)O     text_string[index] = toupper (text_string[index]);			/* Upcase character */  XtFree (temp_string);   L /* Since the name is now uppercased, reflect it in the identifier window. */  > XmTextSetString (uaf_r_widget_id_array[uaf$c_identifier_name], 		 text_string);  E /* Get the state of the attributes in the identifier attribute list.  G ** This doesn't really need to be done for the remove, but it is easier B ** to make this call in the main line as it does affect most other ** operations. */   9 AUTHORIZE$GET_LIST_ENTRIES (uaf$c_identifier_attrib_list,  			    &identifier_attributes,% 			    sizeof identifier_attributes);   C /* Convert the text identifier name to a value; for $xxx_HOLDER. */   & simple_desc[0] = strlen (text_string); simple_desc[1] = text_string;    SYS$ASCTOID (&simple_desc, 	     &identifier,6 	     NULL);						/* Don't need the attributes here */  $ /* Set up the holder information. */  # holder[0] = uaf_l_current_user_uic;  holder[1] = 0;  B /* Based upon the widget number, determine what should be done. */   switch (widget_number)     { !     case uaf$c_identifier_modify:  	{  L /* Because it is possible for the user to specify the granting of attributesH ** the identifier does not currently have enabled, explicitly modify theJ ** identifier to enable the attributes being granted.  This will allow theM ** $ADD_HOLDER to proceed as expected.  This is done quietly, unless an error  ** is encountered. **K ** It would be possible to pop up a warning dialog box to query the user to O ** determine whether or not this should be done...but that is more work :-). */    	SYS$MOD_IDENT (identifier,  		       identifier_attributes,  		       NULL, 		       NULL, 		       NULL);   I /* Modify the holder record as appropriate. Clear all existing attributes - ** held before setting the new attributes. */    	SYS$MOD_HOLDER (identifier, 			&holder,  			identifier_attributes,  			id_attrib_clear_mask);  	break;  	}        case uaf$c_identifier_grant: 	{  L /* Because it is possible for the user to specify the granting of attributesH ** the identifier does not currently have enabled, explicitly modify theJ ** identifier to enable the attributes being granted.  This will allow theM ** $ADD_HOLDER to proceed as expected.  This is done quietly, unless an error  ** is encountered. **K ** It would be possible to pop up a warning dialog box to query the user to O ** determine whether or not this should be done...but that is more work :-). */    	SYS$MOD_IDENT (identifier,  		       identifier_attributes,  		       NULL, 		       NULL, 		       NULL);   ; /* Add a new holder record for the specified identifier. */    	SYS$ADD_HOLDER (identifier, 			&holder,  			identifier_attributes);  M /* Add the new identifier to the list.  This is done by simply rebuilding the L ** list; rather than adding the single item.  Because the usual case is onlyI ** holding a handful of identifiers, this is not a big performance issue.  **K ** However, this is an area for a performance tweek, should an account hold $ ** a large number of identifiers. */  7 	AUTHORIZE$IDENTIFIERS_UPDATE (uaf_l_current_user_uic);   . /* Select the currently entered identifier. */  * 	AUTHORIZE$SET_UP_IDENTIFIER (text_string, 				     NULL);  	break;  	}  !     case uaf$c_identifier_remove:  	{  : /* Remove a holder record for the specified identifier. */   	SYS$REM_HOLDER (identifier, 		        &holder);   L /* Since the entry is to be removed from the identifier list, do it directly: ** (and simply) rather than rebuilding the entire list. */  6 	compound_string = XmStringCreateSimple (text_string);@ 	XmListDeleteItem (uaf_r_widget_id_array[uaf$c_identifier_list], 			  compound_string); 	XtFree (compound_string); 	break;  	}     }  }   4 extern void AUTHORIZE$SET_UP_ATTRIBUTES (identifier)   char				*identifier; {  /* **++ **  FUNCTIONAL DESCRIPTION:  **> **	This routine is called to set the list of attributes for anA **	identifier (held by the current UIC).  If an identifier is not < **	specified the currently selected identifier will be used. ** **  FORMAL PARAMETERS: **5 **	IDENTIFIER	- pointer to the identifier name string  ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. *.  . extern void		AUTHORIZE$SELECT_LIST_ENTRIES ();   /* Global references. */  F globalref unsigned int	uaf_l_current_user_uic;		/* Current user UIC */J globalref Widget	uaf_r_widget_id_array[];	/* Array of Widget IDs in use */   /* Local storage. */  5 unsigned int		context = 0;			/* $FIND_HELD context */ 6 unsigned int		holder[2];			/* Holder for $FIND_HELD */6 char			*id;				/* Name of identifier for attributes */: unsigned int		id_attributes;			/* Identifier attributes */B char			id_name_buf[MAX_ID_SIZE];	/* Storage for identifier name */K unsigned int		id_name_desc[2];		/* Simple descriptor for identifier name */ > unsigned short int	id_name_len;			/* Identifier name length */A unsigned int		identifier2;			/* Identifier found by $FIND_HELD */ # int			index;				/* General index */ 9 int			(*position_list)[];		/* List of entries selected */ ; int			position_count = 0;		/* Number of entries selected */ 2 unsigned int		status;				/* Routine exit status */   /* Debug information. */   #ifdef DEBUGGING* printf ("set up identifier attributes\n"); #endif /* DEBUGGING */    /* Initialize needed storage. */  % id_name_desc[0] = sizeof id_name_buf;  id_name_desc[1] = &id_name_buf;   # holder[0] = uaf_l_current_user_uic;  holder[1] = 0;  F /* Get the name of the identifier to use.  This will either be the one5 ** specified or the currently selected identifier. */P   if (identifier != 0)     id = identifier; else     {u  H /* Find out which entry has been selected.  There should only be one. */  G     XmListGetSelectedPos (uaf_r_widget_id_array[uaf$c_identifier_list],  			  &position_list, 			  &position_count);  / /* Release the memory for the position list. */        XtFree (position_list);      }   G /* Loop getting all the identifiers held by the specified holder id. */e  $ while (TRUE (SYS$FIND_HELD (&holder, 			    &identifier2, 			    &id_attributes, 			    &context)))     {U  ; /* Convert the identifier from a value to a text string. */P       SYS$IDTOASC (identifier2,Z 		 &id_name_len, 		 &id_name_desc,e 		 NULL, 		 NULL,	 		 NULL); >     id_name_buf[id_name_len] = '\0';		/* Terminate the name */  I /* If the identifier found matches the supplied identifier, set the state_2 ** of the attributes in the list appropriately. */  &     if (strcmp (id, id_name_buf) == 0) 	{= 	AUTHORIZE$SELECT_LIST_ENTRIES (uaf$c_identifier_attrib_list,  				       &id_attributes,! 				       sizeof id_attributes); / 	SYS$FINISH_RDB (&context);					/* Finish up */a 	break;  	}     }V }E  > extern void AUTHORIZE$SET_UP_IDENTIFIER (identifier, position)   char				*identifier; int				position; {/ /* **++ **  FUNCTIONAL DESCRIPTION:( **
 **	{@tbs@} ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:I ** **	{@description or none@} ** **  SIDE EFFECTS:E ** **	{@description or none@} ** **-- */   /* Global references. */  _ globalref Widget	uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */    /* Local storage. */  9 XmString		compound_string;		/* General compound string */l2 unsigned int		status;				/* Routine exit status */0 char			*temp_string;			/* Temp string pointer */   /* Debug information. */   #ifdef DEBUGGING printf ("set up identifier\n");i #endif /* DEBUGGING */  J /* If the set up is being done by identifier, set the position in the listH ** to the specified identifier.  Otherwise, set the position in the listJ ** to the specified (numeric) position.  In addition, select the list item' ** to simulate a mouse button click. */d   if (identifier != 0)     {a  M /* See if the specified identifier exists in the list.  If it is in the list,t ** select it. */  8     compound_string = XmStringCreateSimple (identifier);G     if (XmListItemExists (uaf_r_widget_id_array[uaf$c_identifier_list],/ 			  compound_string)) 	{= 	XmListSetItem (uaf_r_widget_id_array[uaf$c_identifier_list],	 		       compound_string);@ 	XmListSelectItem (uaf_r_widget_id_array[uaf$c_identifier_list], 			  compound_string,f 			  1); 	}     XtFree (compound_string);n     }d else     {   9 /* Otherwise, get the position in the list and use it. */e  ?     XmListSetPos (uaf_r_widget_id_array[uaf$c_identifier_list],h 		  position);B     XmListSelectPos (uaf_r_widget_id_array[uaf$c_identifier_list], 		     position,
 		     1);     }X }x t) extern void AUTHORIZE$SET_UP_SYSTEM_ID ()e   {] /* **++ **  FUNCTIONAL DESCRIPTION:	 **? **	This routine is called to set up the system identifier list._ ** **  FORMAL PARAMETERS: ** **	None. ** **  RETURN VALUE:x ** **	Nonex ** **  SIDE EFFECTS:e ** **	{@description or none@} ** **-- */   /* External routines. */  + extern void			AUTHORIZE$WATCH_CURSOR_ON ();a, extern void			AUTHORIZE$WATCH_CURSOR_OFF ();   /* Global references. */  U globalref Widget		uaf_r_identifier_window_widget;	/* Identifier window widget info */_R globalref Widget		uaf_r_main_top_level_widget;	/* Main window widget shell info */I globalref Widget		uaf_r_main_window_widget;	/* Main window widget info */)K globalref Cursor		uaf_r_wait_cursor_main;		/* Main window wait cursor id */}` globalref Widget		uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */   /* Local storage. */  4 unsigned int			context = 0;			/* $IDTOASC context */; XmString			id_name;			/* Identifier name compound string */*C char				id_name_buf[MAX_ID_SIZE];	/* Storage for identifier name */AL unsigned int			id_name_desc[2];		/* Simple descriptor for identifier name */? unsigned short int		id_name_len;			/* Identifier name length */u3 unsigned int			status;				/* Routine exit status */r1 char				*temp_string;			/* Temp string pointer */r   /* Debug information. */   #ifdef DEBUGGING' printf ("set up system identifiers\n");D #endif /* DEBUGGING */    /* Initialize needed storage. */  % id_name_desc[0] = sizeof id_name_buf;_ id_name_desc[1] = &id_name_buf;k  T /* Since building the identifier list may take some time, set up the wait cursor. */  7 AUTHORIZE$WATCH_CURSOR_ON (uaf_r_main_top_level_widget,A 			   uaf_r_main_window_widget,X 			   uaf_r_wait_cursor_main);7 AUTHORIZE$WATCH_CURSOR_ON (uaf_r_main_top_level_widget,n% 			   uaf_r_identifier_window_widget,w 			   uaf_r_wait_cursor_main);  E /* Delete all the entries currently in the system identifier list. */d  K XmListDeleteAllItems (uaf_r_widget_id_array[uaf$c_system_identifier_list]);t  0 /* Loop, getting all the defined identifiers. */  * while (TRUE (SYS$IDTOASC (UIC$K_MATCH_ALL, 			  &id_name_len, 			  &id_name_desc,e
 			  NULL,
 			  NULL, 			  &context)))     {M  8 /* An identifier has been found.  Add it to the list. */  >     id_name_buf[id_name_len] = '\0';		/* Terminate the name */1     id_name = XmStringCreateSimple (id_name_buf);nG     XmListAddItem (uaf_r_widget_id_array[uaf$c_system_identifier_list],f
 		   id_name,  		   0);     XtFree (id_name);i     },   /* Reset the cursor. */r  8 AUTHORIZE$WATCH_CURSOR_OFF (uaf_r_main_top_level_widget,! 			    uaf_r_main_window_widget);s8 AUTHORIZE$WATCH_CURSOR_OFF (uaf_r_main_top_level_widget,' 			    uaf_r_identifier_window_widget);C }d