 #module UAF_DW_MAIN "X-3"    /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **; **		This module contains the various DECwindows main window @ **		support routines needed by the DECwindows AUTHORIZE utility. **9 **  AUTHORS:	L. Mark Pilant			CREATION DATE:  30-Oct-1992  ** **  MODIFICATION HISTORY:  **/ **	X-3	LMP		L. Mark Pilant,		 5-JUN-1995  13:51 = **		Fix ACCVIO bug resulting from from incorrect indirection.  **/ **	X-2	LMP		L. Mark Pilant,		 5-MAR-1993  12:47 $ **		Convert to C from BLISS sources. **( **	X-1	LMP		L. Mark Pilant,		30-Oct-1992 **		Original version.  ** **-- */   /* ** **  INCLUDE FILES  ** */   #include ctype #include stdlib    #include <decw$include:mrmappl>    #include "uaf_header"    /* ** **  FORWARD ROUTINES ** */  ) #pragma noinline (AUTHORIZE$COMMAND_MENU) ) #pragma noinline (AUTHORIZE$CREATE_ENTRY) ) #pragma noinline (AUTHORIZE$DELETE_ENTRY) & #pragma noinline (AUTHORIZE$FILE_MENU)& #pragma noinline (AUTHORIZE$HELP_MENU)) #pragma noinline (AUTHORIZE$MAIN_PROCESS) ) #pragma noinline (AUTHORIZE$MODIFY_ENTRY) ( #pragma noinline (AUTHORIZE$RESET_ENTRY)) #pragma noinline (AUTHORIZE$SELECT_ENTRY) / #pragma noinline (AUTHORIZE$SET_DEFAULT_FILTER) ) #pragma noinline (AUTHORIZE$SET_UP_GROUP) , #pragma noinline (AUTHORIZE$SET_UP_USERNAME)  ; extern void AUTHORIZE$COMMAND_MENU (widget_id, tag, reason)    Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **N **	This routine is called to process requests from the command menu list item. ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  ) extern void	AUTHORIZE$MODIFY_TEMPLATE ();    /* Global references. */  Q globalref int	uaf_l_main_operation;		/* Operation (i.e., create, modify, etc.) */    /* Local storage. */  1 unsigned int	status;				/* Routine exit status */  int		widget_number = *tag;   /* Debug information. */   #ifdef DEBUGGING printf ("command menu\n"); #endif /* DEBUGGING */  3 /* Set the operation (main window widget number) */   % uaf_l_main_operation = widget_number;   B /* Call the appropriate routine, based upon the menu list item. */   switch (widget_number)     { #     case uaf$c_cmd_modify_template:  	{& 	AUTHORIZE$MODIFY_TEMPLATE (widget_id, 				   tag,  				   reason);  	break;  	}     }  }   ; extern void AUTHORIZE$CREATE_ENTRY (widget_id, tag, reason)    Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **L **	This routine is called when it is necessary to create a new authorizationI **	entry.  It will be necesary to get the username (or UIC) from the main B **	window to determine which authorization entry is to be created. ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  & extern void			AUTHORIZE$DECW_ERROR ();2 extern unsigned int		AUTHORIZE$FIND_USER_ENTRY ();' extern void			AUTHORIZE$ITMLST_COPY (); ) extern void			AUTHORIZE$ITMLST_UPDATE (); ( extern void			AUTHORIZE$SET_UP_ENTRY ();   /* Global references. */  T globalref struct ITMDEF		(*uaf_r_current_group_info)[];	/* Current group UAF info */R globalref struct ITMDEF		(*uaf_r_current_user_info)[];	/* Current user UAF info */K globalref Widget		uaf_r_entry_window_widget;	/* Entry window widget info */ W globalref struct USRLSTDEF	uaf_r_master_list;		/* Complete user list (from the file) */ K globalref Widget		uaf_r_widget_id_array[];	/* Array of Widget IDs in use */ A globalref char			uaf_t_current_username[];	/* Current username */    /* Local storage. */  $ int				index;				/* General index */3 unsigned int			status;				/* Routine exit status */ 1 char				*temp_string;			/* Temp string pointer */ P char				text_string [MAX_USERNAME];	/* Text string (from main window) storage */> struct USRLSTDEF		*user_entry;			/* Current user list entry */ int				widget_number = *tag;8 short int			wildcard_name = 0;		/* Wildcard indicator */   /* Debug information. */   #ifdef DEBUGGING printf ("create entry\n"); #endif /* DEBUGGING */  O /* Get the supplied username from the main window, convert it to all upper case 8 ** characters and see if there are wildcards present. */  K temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_main_username]); A strcpy (text_string, temp_string);					/* Copy the widget text */ 6 for (index = 0; index < strlen (text_string); index++)     { O     text_string[index] = toupper (text_string[index]);			/* Upcase character */ G     if (text_string[index] == '*') wildcard_name = 1;			/* Check for */ I     if (text_string[index] == '%') wildcard_name = 1;			/*   wildcards */      }  XtFree (temp_string);   F /* Since the name is now uppercased, reflect it in the main window. */  < XmTextSetString (uaf_r_widget_id_array[uaf$c_main_username], 		 text_string);  . /* Note the current username for later use. */  - strcpy (uaf_t_current_username, text_string);    #ifdef DEBUGGING0 printf ("creating new user: %s\n", text_string); #endif /* DEBUGGING */  C /* If there are any wildcards, complain and abort the operation. */    if (wildcard_name != 0)      { ,     AUTHORIZE$DECW_ERROR (UAF$_NOWILDCARDS);     return;      }   % /* See if the user already exists. */   K if (TRUE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_master_list.uaf$l_usrlst_flink,   				     uaf_t_current_username, 				     FIND_NAME_EQUAL,  				     0, 
 				     0)))      {   > /* The user already exists.  Let the user know, and return. */  +     AUTHORIZE$DECW_ERROR (UAF$_USEREXISTS);      return;      }   R /* The user doesn't exist.  Set up a new entry using the selected group "default".P ** The selected default may be a specific group default entry or the traditional ** default entry. */  0 AUTHORIZE$ITMLST_COPY (uaf_r_current_group_info," 		       &uaf_r_current_user_info, 		       0);  M /* Update the username in the copied item list to reflect the username of the  ** entry to create. */  2 AUTHORIZE$ITMLST_UPDATE (&uaf_r_current_user_info, 			 UAI$_USERNAME,$ 			 strlen (uaf_t_current_username), 			 uaf_t_current_username);  ? /* Set up the information in the authorization entry window. */   1 AUTHORIZE$SET_UP_ENTRY (uaf_r_current_user_info);   $ /* Make the entry window visible. */  * XtManageChild (uaf_r_entry_window_widget); }   ; extern void AUTHORIZE$DELETE_ENTRY (widget_id, tag, reason)    Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **; **	This routine is called to delete an authorization entry.  ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  & extern void			AUTHORIZE$DECW_ERROR ();* extern void			AUTHORIZE$DEL_LIST_ENTRY ();0 extern unsigned int		AUTHORIZE$DEL_USER_INFO ();2 extern unsigned int		AUTHORIZE$FIND_USER_ENTRY ();( extern void			AUTHORIZE$SET_UP_GROUP ();+ extern void			AUTHORIZE$SET_UP_USERNAME ();    /* Global references. */  U globalref unsigned int		uaf_l_current_group_max;	/* Count of entries in group list */ T globalref unsigned int		uaf_l_current_user_max;		/* Count of entries in user list */M globalref struct USRLSTDEF	uaf_r_group_list;		/* Group user name list head */ W globalref struct USRLSTDEF	uaf_r_master_list;		/* Complete user list (from the file) */ F globalref struct USRLSTDEF	uaf_r_user_list;		/* User name list head */K globalref Widget		uaf_r_widget_id_array[];	/* Array of Widget IDs in use */ A globalref char			uaf_t_current_username[];	/* Current username */    /* Local storage. */  D XmString			current_username;		/* Current username compound string */$ int				index;				/* General index */K int				list_count;			/* Number of list entries passed before adding item */ 3 unsigned int			status;				/* Routine exit status */ 1 char				*temp_string;			/* Temp string pointer */ P char				text_string [MAX_USERNAME];	/* Text string (from main window) storage */> struct USRLSTDEF		*user_entry;			/* Current user list entry */ int				widget_number = *tag;8 short int			wildcard_name = 0;		/* Wildcard indicator */   /* Debug information. */   #ifdef DEBUGGING printf ("delete entry\n"); #endif /* DEBUGGING */  O /* Get the supplied username from the main window, convert it to all upper case 8 ** characters and see if there are wildcards present. */  K temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_main_username]); A strcpy (text_string, temp_string);					/* Copy the widget text */ 6 for (index = 0; index < strlen (text_string); index++)     { O     text_string[index] = toupper (text_string[index]);			/* Upcase character */ G     if (text_string[index] == '*') wildcard_name = 1;			/* Check for */ I     if (text_string[index] == '%') wildcard_name = 1;			/*   wildcards */      }  XtFree (temp_string);   F /* Since the name is now uppercased, reflect it in the main window. */  < XmTextSetString (uaf_r_widget_id_array[uaf$c_main_username], 		 text_string);  . /* Note the current username for later use. */  - strcpy (uaf_t_current_username, text_string); [ current_username = XmStringCreateSimple (uaf_t_current_username);	/* After being upcased */   ( /* Make sure the user already exists. */  L if (FALSE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_master_list.uaf$l_usrlst_flink, 				      &text_string,  				      FIND_NAME_EQUAL, 				      0, 				      0)))     {   > /* The user does not exist.  Let the user know, and return. */  +     AUTHORIZE$DECW_ERROR (UAF$_NOSUCHUSER);      XtFree (current_username);     return;      }   B /* Delete the requested entry from the user authorization file. */  = if (FALSE (AUTHORIZE$DEL_USER_INFO (uaf_t_current_username)))      {   H /* There was some error deleting the authorization record.  Let the user ** know and return. */  +     AUTHORIZE$DECW_ERROR (UAF$_UAFWRITERR);      XtFree (current_username);     return;      }   G /* Since the authorization record has been successfully deleted, remove  ** the internal information. */   A /* Check the master list of users to find the entry to remove. */   K if (TRUE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_master_list.uaf$l_usrlst_flink,  				     &text_string, 				     FIND_NAME_EQUAL,  				     0,  				     &user_entry))) ?     AUTHORIZE$DEL_LIST_ENTRY (&user_entry->uaf$l_usrlst_flink);   : /* Check the list of users to find the entry to remove. */  I if (TRUE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_user_list.uaf$l_usrlst_flink,  				     &text_string, 				     FIND_NAME_EQUAL,  				     &list_count,  				     &user_entry)))      { ?     AUTHORIZE$DEL_LIST_ENTRY (&user_entry->uaf$l_usrlst_flink); 4     --uaf_l_current_user_max;				/* One less user */B     XmListDeleteItem (uaf_r_widget_id_array[uaf$c_main_user_list], 		      current_username);     }   ( /* Limit check the list entry number. */  M if (list_count > uaf_l_current_user_max) list_count = uaf_l_current_user_max;   I /* Since the username has been removed from the list, select the previous  ** entry. */    AUTHORIZE$SET_UP_USERNAME (NULL, 			   list_count);  ; /* Check the list of groups to find the entry to remove. */   J if (TRUE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_group_list.uaf$l_usrlst_flink, 				     &text_string, 				     FIND_NAME_EQUAL,  				     &list_count,  				     &user_entry)))      { ?     AUTHORIZE$DEL_LIST_ENTRY (&user_entry->uaf$l_usrlst_flink); 4     --uaf_l_current_user_max;				/* One less user */C     XmListDeleteItem (uaf_r_widget_id_array[uaf$c_main_group_list],  		      current_username);     }   ( /* Limit check the list entry number. */  O if (list_count > uaf_l_current_group_max) list_count = uaf_l_current_group_max;   I /* Since the username has been removed from the list, select the previous  ** entry. */   AUTHORIZE$SET_UP_GROUP (NULL,  			list_count);    XtFree (current_username); }   8 extern void AUTHORIZE$FILE_MENU (widget_id, tag, reason)   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **K **	This routine is called to process requests from the file menu list item.  ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  4 extern unsigned int		AUTHORIZE$BUILD_MASTER_LIST ();, extern void 			AUTHORIZE$BUILD_USER_LIST ();& extern void			AUTHORIZE$DECW_ERROR ();+ extern void			AUTHORIZE$WATCH_CURSOR_ON (); , extern void			AUTHORIZE$WATCH_CURSOR_OFF ();   /* Global references. */  L globalref Widget		uaf_r_file_window_widget;	/* File selection widget info */R globalref Widget		uaf_r_main_top_level_widget;	/* Main window widget shell info */I globalref Widget		uaf_r_main_window_widget;	/* Main window widget info */ K globalref Cursor		uaf_r_wait_cursor_main;		/* Main window wait cursor id */ N globalref unsigned short int	uaf_w_uai_context[2];		/* $xxxUAI context cell */   /* Local storage. */  3 unsigned int			status;				/* Routine exit status */  int				widget_number = *tag;   /* Debug information. */   #ifdef DEBUGGING printf ("file menu\n");  #endif /* DEBUGGING */  B /* Based upon the widget number, determine what should be done. */   switch (widget_number)     {      case uaf$c_ctl_open: 	{  & /* Bring up the file selection box. */  * 	XtManageChild (uaf_r_file_window_widget); 	break;  	}     case uaf$c_ctl_quit: 	{  # /* All through with the session. */    	SYS$EXIT (SS$_NORMAL);  	break;  	}     case uaf$c_ctl_refresh:  	{  M /* If there is no authorization file open, indicated by the uaf_w_uai_context F ** cell being something other than -1, there is nothing to refresh. */  $ 	if (uaf_w_uai_context[0] != 0xFFFF) 	    {  N /* Since building the user list may take some time, set up the wait cursor. */  < 	    AUTHORIZE$WATCH_CURSOR_ON (uaf_r_main_top_level_widget,$ 				       uaf_r_main_window_widget,# 				       uaf_r_wait_cursor_main);   C /* Rebuild the in memory user lists from the authorization file. */   0 	    if (FALSE (AUTHORIZE$BUILD_MASTER_LIST ()))) 		AUTHORIZE$DECW_ERROR (UAF$_UAFREADERR); " 	    AUTHORIZE$BUILD_USER_LIST ();   /* Reset the cursor. */   = 	    AUTHORIZE$WATCH_CURSOR_OFF (uaf_r_main_top_level_widget,  					uaf_r_main_window_widget);  	    } 	break;  	}     }  }   8 extern void AUTHORIZE$HELP_MENU (widget_id, tag, reason)   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **
 **	{@tbs@} ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* Local storage. */  3 unsigned int			status;				/* Routine exit status */  int				widget_number = *tag;   /* Debug information. */   #ifdef DEBUGGING printf ("help menu\n");  #endif /* DEBUGGING */ }   ; extern void AUTHORIZE$MAIN_PROCESS (widget_id, tag, reason)    Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **A **	This routine is called to process requests via the main window  **	pushbuttons.  ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  & extern void	AUTHORIZE$CREATE_ENTRY ();& extern void	AUTHORIZE$DELETE_ENTRY ();& extern void	AUTHORIZE$MODIFY_ENTRY ();% extern void	AUTHORIZE$RESET_ENTRY (); & extern void	AUTHORIZE$SELECT_ENTRY ();   /* Global references. */  Q globalref int	uaf_l_main_operation;		/* Operation (i.e., create, modify, etc.) */    /* Local storage. */  1 unsigned int	status;				/* Routine exit status */  int		widget_number = *tag;   /* Debug information. */   #ifdef DEBUGGING printf ("main process\n"); #endif /* DEBUGGING */  3 /* Set the operation (main window widget number) */   % uaf_l_main_operation = widget_number;   > /* Call the appropriate routine, based upon the pushbutton. */   switch (widget_number)     {      case uaf$c_main_create:I 	{# 	AUTHORIZE$CREATE_ENTRY (widget_id,i 				tag, 				reason); 	break;  	}     case uaf$c_main_modify:v 	{[ 	uaf_l_main_operation = widget_number;		/* Set the operation (main window widget number) */ # 	AUTHORIZE$MODIFY_ENTRY (widget_id,A 				tag, 				reason); 	break;  	}     case uaf$c_main_reset: 	{[ 	uaf_l_main_operation = widget_number;		/* Set the operation (main window widget number) */d" 	AUTHORIZE$RESET_ENTRY (widget_id, 			       tag, 			       reason); 	break;C 	}     case uaf$c_main_select:L 	{[ 	uaf_l_main_operation = widget_number;		/* Set the operation (main window widget number) */E# 	AUTHORIZE$SELECT_ENTRY (widget_id,e 				tag, 				reason); 	break;e 	}     case uaf$c_main_delete:r 	{[ 	uaf_l_main_operation = widget_number;		/* Set the operation (main window widget number) */ # 	AUTHORIZE$DELETE_ENTRY (widget_id,p 				tag, 				reason); 	break;E 	}     }a }  n; extern void AUTHORIZE$MODIFY_ENTRY (widget_id, tag, reason)M   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;U {R /* **++ **  FUNCTIONAL DESCRIPTION:U **D **	This routine is called when it is necessary to modify an existingD **	authorization entry.  It will be necesary to get the username (orE **	UIC) from the main window to determine which authorization entriesn **	are to be affected. ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:m ** **	Noner ** **  SIDE EFFECTS:  ** **	{@description or none@} ** **-- */   /* External routines. */  & extern void			AUTHORIZE$DECW_ERROR ();2 extern unsigned int		AUTHORIZE$FIND_USER_ENTRY ();) extern void			AUTHORIZE$GET_USER_INFO ();*( extern void			AUTHORIZE$SET_UP_ENTRY ();   /* Global references. */  R globalref struct ITMDEF		(*uaf_r_current_user_info)[];	/* Current user UAF info */K globalref Widget		uaf_r_entry_window_widget;	/* Entry window widget info */mW globalref struct USRLSTDEF	uaf_r_master_list;		/* Complete user list (from the file) */sK globalref Widget		uaf_r_widget_id_array[];	/* Array of Widget IDs in use */IA globalref char			uaf_t_current_username[];	/* Current username */e   /* Local storage. */  $ int				index;				/* General index */3 unsigned int			status;				/* Routine exit status */n1 char				*temp_string;			/* Temp string pointer */gP char				text_string [MAX_USERNAME];	/* Text string (from main window) storage */> struct USRLSTDEF		*user_entry;			/* Current user list entry */ int				widget_number = *tag;8 short int			wildcard_name = 0;		/* Wildcard indicator */   /* Debug information. */   #ifdef DEBUGGING printf ("modify entry\n"); #endif /* DEBUGGING */  O /* Get the supplied username from the main window, convert it to all upper casei8 ** characters and see if there are wildcards present. */  K temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_main_username]); A strcpy (text_string, temp_string);					/* Copy the widget text */E6 for (index = 0; index < strlen (text_string); index++)     {sO     text_string[index] = toupper (text_string[index]);			/* Upcase character */HG     if (text_string[index] == '*') wildcard_name = 1;			/* Check for */ I     if (text_string[index] == '%') wildcard_name = 1;			/*   wildcards */D     }  XtFree (temp_string);Z  F /* Since the name is now uppercased, reflect it in the main window. */  < XmTextSetString (uaf_r_widget_id_array[uaf$c_main_username], 		 text_string);  C /* If there are any wildcards, complain and abort the operation. */e   if (wildcard_name != 0)w     {;,     AUTHORIZE$DECW_ERROR (UAF$_NOWILDCARDS);     return;F     }m  . /* Note the current username for later use. */  - strcpy (uaf_t_current_username, text_string);/    /* Make sure the user exists. */  L if (FALSE (AUTHORIZE$FIND_USER_ENTRY (&uaf_r_master_list.uaf$l_usrlst_flink,! 				      uaf_t_current_username,e 				      FIND_NAME_EQUAL, 				      0, 				      0)))     {   > /* The user does not exist.  Let the user know, and return. */  +     AUTHORIZE$DECW_ERROR (UAF$_NOSUCHUSER);i     return;r     }   N /* Since an existing entry is being modified, set the initial state of all the  ** information in the window. */  0 AUTHORIZE$GET_USER_INFO (uaf_t_current_username, 			 &uaf_r_current_user_info);1 AUTHORIZE$SET_UP_ENTRY (uaf_r_current_user_info);   $ /* Make the entry window visible. */  * XtManageChild (uaf_r_entry_window_widget); }a t: extern void AUTHORIZE$RESET_ENTRY (widget_id, tag, reason)   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;t {y /* **++ **  FUNCTIONAL DESCRIPTION:y **G **	This routine is called when it is necessary to reset the main window  **	to an initial state.n ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:( ** **	Nonen ** **  SIDE EFFECTS:a ** **	{@description or none@} ** **-- */   /* External routines. */  * extern void		AUTHORIZE$BUILD_USER_LIST ();- extern void		AUTHORIZE$SET_DEFAULT_FILTER ();r* extern void		AUTHORIZE$SET_UP_USERNAME ();* extern void		AUTHORIZE$WATCH_CURSOR_ON ();+ extern void		AUTHORIZE$WATCH_CURSOR_OFF ();    /* Global references. */  Q globalref Widget	uaf_r_main_top_level_widget;	/* Main window widget shell info */nH globalref Widget	uaf_r_main_window_widget;	/* Main window widget info */J globalref Cursor	uaf_r_wait_cursor_main;		/* Main window wait cursor id */E globalref char		*uaf_t_default_filter;		/* Default username filter */;   /* Local storage. */  2 unsigned int		status;				/* Routine exit status */ int			widget_number = *tag;a   /* Debug information. */   #ifdef DEBUGGING printf ("reset entry\n");	 #endif /* DEBUGGING */  N /* Since building the user list may take some time, set up the wait cursor. */  7 AUTHORIZE$WATCH_CURSOR_ON (uaf_r_main_top_level_widget,E 			   uaf_r_main_window_widget,  			   uaf_r_wait_cursor_main);  ) /* Set up the default username filter. */u  4 AUTHORIZE$SET_DEFAULT_FILTER (uaf_t_default_filter);  * /* Get a list of the user's and groups. */   AUTHORIZE$BUILD_USER_LIST ();u  = /* If possible, set up for the first username in the list. */     AUTHORIZE$SET_UP_USERNAME (NULL,	 			   1);d   /* Reset the cursor. */s  8 AUTHORIZE$WATCH_CURSOR_OFF (uaf_r_main_top_level_widget,! 			    uaf_r_main_window_widget);	 }A U; extern void AUTHORIZE$SELECT_ENTRY (widget_id, tag, reason)r   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;y {n /* **++ **  FUNCTIONAL DESCRIPTION:_ **E **	This routine is called when it is necessary to select a new set ofhH **	authorization entries.  These will be reflected in the user and group	 **	lists.i ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:r ** **	None  ** **  SIDE EFFECTS:C ** **	{@description or none@} ** **-- */   /* External routines. */  * extern void		AUTHORIZE$BUILD_USER_LIST ();- extern void		AUTHORIZE$SET_DEFAULT_FILTER ();N* extern void		AUTHORIZE$SET_UP_USERNAME ();* extern void		AUTHORIZE$WATCH_CURSOR_ON ();+ extern void		AUTHORIZE$WATCH_CURSOR_OFF ();W   /* Global references. */  Q globalref Widget	uaf_r_main_top_level_widget;	/* Main window widget shell info */uH globalref Widget	uaf_r_main_window_widget;	/* Main window widget info */J globalref Cursor	uaf_r_wait_cursor_main;		/* Main window wait cursor id */J globalref Widget	uaf_r_widget_id_array[];	/* Array of Widget IDs in use */   /* Local storage. */  # int			index;				/* General index */s0 char			*temp_string;			/* Temp string pointer */O char			text_string [MAX_USERNAME];	/* Text string (from main window) storage */l int			widget_number = *tag;s   /* Debug information. */   #ifdef DEBUGGING printf ("select entry\n"); #endif /* DEBUGGING */  R /* Get the supplied filter string from the main window and convert it to all upper ** case characters. */  I temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_main_filter]);aA strcpy (text_string, temp_string);					/* Copy the widget text */d4 for (index = 0; index < sizeof text_string; index++)O     text_string[index] = toupper (text_string[index]);			/* Upcase character */d  R XmTextSetString (uaf_r_widget_id_array[uaf$c_main_filter],		/* Reflect upcasing */ 		 text_string); XtFree (temp_string);N  N /* Since building the user list may take some time, set up the wait cursor. */  7 AUTHORIZE$WATCH_CURSOR_ON (uaf_r_main_top_level_widget,a 			   uaf_r_main_window_widget,; 			   uaf_r_wait_cursor_main);  N /* Set up the new filter and build the new lists using the supplied filter. */  + AUTHORIZE$SET_DEFAULT_FILTER (text_string);o AUTHORIZE$BUILD_USER_LIST ();o  AUTHORIZE$SET_UP_USERNAME (NULL,	 			   1);e   /* Reset the cursor. *//  8 AUTHORIZE$WATCH_CURSOR_OFF (uaf_r_main_top_level_widget,! 			    uaf_r_main_window_widget);s }n t1 extern void AUTHORIZE$SET_DEFAULT_FILTER (filter)i   char				*filter; {n /* **++ **  FUNCTIONAL DESCRIPTION:e **? **	This routine is called to set up the default username filterr. **	string.  This string may contain wildcards. ** **  FORMAL PARAMETERS: **' **	FILTER		- pointer to the filter textr ** **  RETURN VALUE:c ** **	None. ** **  SIDE EFFECTS:) ** **	{@description or none@} ** **-- */   /* Global references. */  K globalref Widget	uaf_r_widget_id_array[];		/* Array of Widget IDs in use */iN globalref char		uaf_t_username_filter[];		/* Current username filter string */   /* Local storage. */  2 unsigned int		status;				/* Routine exit status */   /* Debug information. */   #ifdef DEBUGGING  printf ("set default filter\n"); #endif /* DEBUGGING */  + /* Set up the filter in the main window. */r  : XmTextSetString (uaf_r_widget_id_array[uaf$c_main_filter], 		 filter);   - /* Stash a copy of the new default filter. */t  ' strcpy (uaf_t_username_filter, filter);  }  U4 extern void AUTHORIZE$SET_UP_GROUP (group, position)   char				*group;  int				position; {  /* **++ **  FUNCTIONAL DESCRIPTION:u **
 **	{@tbs@} ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:e ** **	None  ** **  SIDE EFFECTS:o ** **	{@description or none@} ** **-- */   /* Global references. */  ` globalref Widget	uaf_r_widget_id_array[uaf$c_max_widget_code];		/* Array of Widget IDs in use */   /* Local storage. */  9 XmString		compound_string;		/* General compound string */e2 unsigned int		status;				/* Routine exit status */   /* Debug information. */   #ifdef DEBUGGING printf ("set up group\n"); #endif /* DEBUGGING */  J /* If the set up is being done by group name, set the position in the listH ** to the specified group name.  Otherwise, set the position in the listJ ** to the specified (numeric) position.  In addition, select the list item' ** to simulate a mouse button click. */I   if (group != 0)_     {l  K /* See if the specified name exists in the list.  (This is done by checking	N ** the actual list rather than the in-memory queue.  Either method would work,M ** but I wanted to practice with Motif.)  If it is in the list, select it. */n  3     compound_string = XmStringCreateSimple (group);rG     if (XmListItemExists (uaf_r_widget_id_array[uaf$c_main_group_list],t 			  compound_string)) 	{= 	XmListSetItem (uaf_r_widget_id_array[uaf$c_main_group_list],a 		       compound_string);@ 	XmListSelectItem (uaf_r_widget_id_array[uaf$c_main_group_list], 			  compound_string,  			  1); 	}     XtFree (compound_string);c     }  else     {e  < /* Otherwise, get the first entry in the list and use it. */  ?     XmListSetPos (uaf_r_widget_id_array[uaf$c_main_group_list],	 		  position);B     XmListSelectPos (uaf_r_widget_id_array[uaf$c_main_group_list], 		     position,
 		     1);     }E }I E: extern void AUTHORIZE$SET_UP_USERNAME (username, position)   char				*username; int				position; {i /* **++ **  FUNCTIONAL DESCRIPTION:$ **
 **	{@tbs@} ** **  FORMAL PARAMETERS: ** **	{@subtags@} ** **  RETURN VALUE:r ** **	None  ** **  SIDE EFFECTS:l ** **	{@description or none@} ** **-- */   /* Global references. */  N globalref unsigned int	uaf_l_current_user_index;			/* Index of current user */_ globalref Widget	uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */ B globalref char		uaf_t_current_username[];			/* Current username */   /* Local storage. */  9 XmString		compound_string;		/* General compound string */I0 char			*temp_string;			/* Temp string pointer */   /* Debug information. */   #ifdef DEBUGGING printf ("set up username\n");a #endif /* DEBUGGING */  H /* If the set up is being done by username, set the position in the listF ** to the specified username.  Otherwise, set the position in the listJ ** to the specified (numeric) position.  In addition, select the list item' ** to simulate a mouse button click. */n   if (username != 0)     {R  K /* See if the specified name exists in the list.  (This is done by checking N ** the actual list rather than the in-memory queue.  Either method would work,M ** but I wanted to practice with Motif.)  If it is in the list, select it. */i  6     compound_string = XmStringCreateSimple (username);F     if (XmListItemExists (uaf_r_widget_id_array[uaf$c_main_user_list], 			  compound_string)) 	{W 	uaf_l_current_user_index = XmListItemPos (uaf_r_widget_id_array[uaf$c_main_user_list],L 						  compound_string);d< 	XmListSetItem (uaf_r_widget_id_array[uaf$c_main_user_list], 		       compound_string);? 	XmListSelectItem (uaf_r_widget_id_array[uaf$c_main_user_list],f 			  compound_string,B 			  1); 	}     XtFree (compound_string);h     }  else     {w  9 /* Otherwise, get the position in the list and use it. */   H     uaf_l_current_user_index = position;				/* Get specified position */W     if (uaf_l_current_user_index == 0) uaf_l_current_user_index = 1;	/* Default to 1 */*>     XmListSetPos (uaf_r_widget_id_array[uaf$c_main_user_list], 		  uaf_l_current_user_index);A     XmListSelectPos (uaf_r_widget_id_array[uaf$c_main_user_list],*  		     uaf_l_current_user_index,
 		     1);     }   L /* Since the current username in the main window has been set, get the value= ** back and set it up in memory.  This will be used later. *//  K temp_string = XmTextGetString (uaf_r_widget_id_array[uaf$c_main_username]);fK strcpy (uaf_t_current_username, temp_string);				/* Copy the widget text */e XtFree (temp_string);r }t$Q:JVIUJ`?,~s_
sw	qA;6`aI~Ph@YdӀu9~qdS})Kk2OܵD",F#7Qǲp-bU%41k>|rur!~7Qh.C,RnƱcOHmEN Ga۩~{TUd+A.Ju|JkQ..:Iv'4G\Rhh,@|wpln~JZ,ܞic~=k3wz]tDk#G܄+gL	GF0p/c>/bT6f-pGyq=A/}CE2M9vTP	;nyuLnr#7'H壜IwKSaZ0	(@|[L4~} h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                