 #module uaf_file_subs "X-2"      /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **= **		This module contains the routines necessary to manage the  **		authorization file.  **7 **  AUTHORS:	L. Mark Pilant		CREATION DATE:	18-Sep-1992  ** **  MODIFICATION HISTORY:  **/ **	X-2	LMP		L. Mark Pilant,		26-FEB-1993  13:13 $ **		Convert to C from BLISS sources. **( **	X-1	LMP		L. Mark Pilant,		18-Sep-1992 **		Original Version.  ** **-- */   /* ** **  INCLUDE FILES  ** */   #include	descrip #include	fab #include	nam #include	rab #include	rmsdef  #include	string  #include	xab   #include	<decw$include:mrmappl>    #include	"uaf_header"    /* ** **  FORWARD ROUTINES ** */  + #pragma noinline (AUTHORIZE$ADD_LIST_ENTRY) . #pragma noinline (AUTHORIZE$BUILD_MASTER_LIST), #pragma noinline (AUTHORIZE$BUILD_USER_LIST)* #pragma noinline (AUTHORIZE$CRE_USER_INFO)+ #pragma noinline (AUTHORIZE$DEL_LIST_ENTRY) * #pragma noinline (AUTHORIZE$DEL_USER_INFO)) #pragma noinline (AUTHORIZE$FILE_PROCESS) , #pragma noinline (AUTHORIZE$FIND_USER_ENTRY)* #pragma noinline (AUTHORIZE$GET_USER_INFO)% #pragma noinline (AUTHORIZE$OPEN_UAF) / #pragma noinline (AUTHORIZE$RELEASE_UAF_RECORD) * #pragma noinline (AUTHORIZE$SET_USER_INFO)/ #pragma noinline (AUTHORIZE$VALIDATE_USER_NAME)   : /* RMS structure storage, used across several routines. */  B static char		sysuaf_esn[NAM$C_MAXRSS];	/* Expanded name storage */< static struct FAB	sysuaf_fab;			/* Authorization file FAB */Z static struct XABKEY	sysuaf_key0;			/* Authorization file primary lookup key (username) */W static struct XABKEY	sysuaf_key1;			/* Authorization file secondary lookup key (UIC) */ ] static struct XABKEY	sysuaf_key2;			/* Authorization file unused lookup key (extended UIC) */ Z static struct XABKEY	sysuaf_key3;			/* Authorization file unused lookup key (parent ID) */C static struct NAM	sysuaf_nam;			/* Authorization file NAMe block */ < static struct RAB	sysuaf_rab;			/* Authorization file RAB */M static struct UAFDEF	sysuaf_record;			/* Authorization file record storage */ C static char		sysuaf_rsn[NAM$C_MAXRSS];	/* Resultant name storage */ ^ static struct XABPRO	sysuaf_xabpro;			/* Authorization file protection XAB; no world access */    F extern void AUTHORIZE$ADD_LIST_ENTRY (username, uic, list_head, entry)   char			*username; 
 int			uic; struct USRLSTDEF	*list_head; struct USRLSTDEF	**entry;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **H **	This routine allocates a user list entry, fills it and adds it to the$ **	list whose list head is supplied. **G **	NOTE:	The new list entry is added to the list in alphabetical order. G **		(With an optimization to see if the supplied "list head" is already F **		positioned to the correct place.)  This only affects the in memory: **		list.  It DOES NOT affect the list in the main window. ** **  FORMAL PARAMETERS: *** **	USERNAME	- pointer to the username text$ **	UIC		- (binary) UIC for new entryF **	LIST_HEAD	- list head for the list to which the entry will be added+ **	ENTRY		- pointer to the entry just added  ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	None. ** **-- */   /* External routines. */  2 extern unsigned int		AUTHORIZE$FIND_USER_ENTRY ();   /* Global storage. */   W globalref struct USRLSTDEF	uaf_r_master_list;		/* Complete user list (from the file) */    /* Local storage. */  > struct USRLSTDEF		*list_entry;			/* Current user list entry */D struct USRLSTDEF		*new_entry;			/* Pointer to new (created) entry */H struct USRLSTDEF		*next_entry;			/* Pointer to entry after queue head */A int				simple_uic_desc[2];		/* Simple descriptor for octal UIC */ I int				simple_uic_id_desc[2];		/* Simple descriptor for identifier UIC */ b char				simple_uic_text[sizeof uaf_r_master_list.uaf$t_usrlst_uic];	/* Octal UIC (text) storage */e char				simple_uic_id_text[sizeof uaf_r_master_list.uaf$t_usrlst_uic_id];	/* Identifer UIC storage */ 3 unsigned int			status;				/* Routine exit status */   M $DESCRIPTOR			(fao_uic, "!%U");		/* Format UIC with octal group and member */ E $DESCRIPTOR			(fao_uic_id, "!%I");		/* Format UIC with identifiers */     /* Initialize needed storage. */  , simple_uic_desc[0] = sizeof simple_uic_text;& simple_uic_desc[1] = &simple_uic_text;2 simple_uic_id_desc[0] = sizeof simple_uic_id_text;, simple_uic_id_desc[1] = &simple_uic_id_text;  8 /* Allocate and clear the storage for the list entry. */  , new_entry = calloc (1, uaf$c_usrlst_length);0 if (new_entry == 0) LIB$SIGNAL (UAF$_NOPROCMEM);  * /* Fill the newly allocated list entry. */  E memmove (&new_entry->uaf$t_usrlst_name, username, strlen (username));   
 if (uic != 0)      { K     new_entry->uaf$l_usrlst_own_id = uic;			/* Save binary UIC for later */   K /* Convert the binary UIC value in the authorization record to two strings. J ** The first is a straight numeric (to octal) conversion.  The second usesK ** any identifiers available.  These are needed for UIC based filtering. */   D     simple_uic_desc[0] = sizeof simple_uic_text;		/* Reset length */M     memset (simple_uic_text, 0, sizeof simple_uic_text);	/* Reset contents */ J     simple_uic_id_desc[0] = sizeof simple_uic_id_text;		/* Reset length */S     memset (simple_uic_id_text, 0, sizeof simple_uic_id_text);	/* Reset contents */        SYS$FAO (&fao_uic, 	     simple_uic_desc, 	     simple_uic_desc, 	     uic);      SYS$FAO (&fao_uic_id,  	     simple_uic_id_desc,  	     simple_uic_id_desc,  	     uic);   V     memmove (&new_entry->uaf$t_usrlst_uic, simple_uic_text, strlen (simple_uic_text));_     memmove (&new_entry->uaf$t_usrlst_uic_id, simple_uic_id_text, strlen (simple_uic_id_text));      }   E /* Now add the new entry to the list.  As a performance optimization, H ** check to see if the "list head" is positioned such that the new entryE ** can be added immediately after it.  If this is not the case, chase M ** down the entire list to find the correct place to insert the new entry. */   O list_entry = &list_head->uaf$l_usrlst_flink;	/* Get pointer to current entry */ K next_entry = list_head->uaf$l_usrlst_flink;	/* Get pointer to next entry */   Y if (((strlen (list_entry->uaf$t_usrlst_name) != 0) &&			/* List entry name length != 0 */ g      (strcmp (list_entry->uaf$t_usrlst_name, username) > 0)) ||		/* List entry name > new entry name */ Y     ((strlen (next_entry->uaf$t_usrlst_name) != 0) &&			/* Next entry name length != 0 */ e      (strcmp (next_entry->uaf$t_usrlst_name, username) < 0)))		/* Next entry name < new entry name */      {   A /* Search the list to find the appropriate spot for insertion. */   )     AUTHORIZE$FIND_USER_ENTRY (list_head,  			       username,  			       FIND_NAME_LESS,  			       0, 			       &list_entry);   , /* Now get the address of the next entry. */  0     next_entry = list_entry->uaf$l_usrlst_flink;     }   G /* Add the entry after the queue list entry.  This could have been done M ** with an INSQUE instruction, but I didn't want to add explicit architecture  ** dependencies. */   u list_entry->uaf$l_usrlst_flink = &new_entry->uaf$l_usrlst_flink;	/* Forward link in list entry points to new entry */ r next_entry->uaf$l_usrlst_blink = &new_entry->uaf$l_usrlst_flink;	/* Back link in next entry points to new entry */  l new_entry->uaf$l_usrlst_flink = &next_entry->uaf$l_usrlst_flink;	/* Forward link points to old next entry */e new_entry->uaf$l_usrlst_blink = &list_entry->uaf$l_usrlst_flink;	/* Back link points to list entry */   7 /* Return a pointer to the newly created list entry. */    *entry = new_entry;  }   2 extern unsigned int AUTHORIZE$BUILD_MASTER_LIST () {  /* **++ **  FUNCTIONAL DESCRIPTION:  **G **	This routine reads the authorization file and builds the master user I **	list.  This list is then used to build the user and group lists, using J **	the appropriate wildcard criteria.  This means that it is not necessaryJ **	to read every record in the file when the wildcard criteria is changed.3 **	However, it does mean the list can become stale.  ** **  FORMAL PARAMETERS: ** **	None  ** **  RETURN VALUE:  **2 **	SS$_NORMAL if successful, error code otherwise. ** **  SIDE EFFECTS:  ** **	None. ** **-- */   /* External routines. */  * extern void			AUTHORIZE$ADD_LIST_ENTRY ();5 extern unsigned int		AUTHORIZE$VALIDATE_USER_NAME ();    /* Global storage. */   X globalref struct USRLSTDEF	uaf_r_master_list;			/* Complete user list (from the file) */   /* Local storage. */  = struct USRLSTDEF		*current_entry;				/* Current list entry */ % int				index;					/* General index */ A struct USRLSTDEF		*new_entry;				/* User list entry just added */ 7 struct USRLSTDEF		*next_entry;				/* Next list entry */ ; struct USRLSTDEF		*prev_entry;				/* Previous list entry */ 4 unsigned int			status;					/* Routine exit status */= char				username[MAX_USERNAME];			/* Username text storage */   H /* Since a new master list is being built, clear out any existing master ** list entries. */   U while (uaf_r_master_list.uaf$l_usrlst_flink != &uaf_r_master_list.uaf$l_usrlst_flink)      {   P /* Remove the first entry.  This could have been done with a REMQUE instruction,B ** but I didn't want to add explicit architecture dependencies. */  9     current_entry = uaf_r_master_list.uaf$l_usrlst_flink; 3     prev_entry = current_entry->uaf$l_usrlst_blink; 3     next_entry = current_entry->uaf$l_usrlst_flink;   E     prev_entry->uaf$l_usrlst_flink = &next_entry->uaf$l_usrlst_flink; E     next_entry->uaf$l_usrlst_blink = &prev_entry->uaf$l_usrlst_flink;        free (current_entry);      }   M /* Position the currently opened authorization file back to the beginning. */   ( CHECK_RETURN (SYS$REWIND (&sysuaf_rab));  G /* Read each record in the authorization file and build the master user F ** list.  The user list is simply an entry for each user record in the ** authorization file. */   & sysuaf_rab.rab$l_ubf = &sysuaf_record;, sysuaf_rab.rab$w_usz = sizeof sysuaf_record;! sysuaf_rab.rab$b_rac = RAB$C_SEQ;    do     {   J /* Check the status of the $GET.  Only upon success do we actually process ** the record. */   .     if (TRUE (status = SYS$GET (&sysuaf_rab))) 	{  J /* Since the $GET succeeded, release the record so that it does not remain
 ** locked. */    	SYS$RELEASE (&sysuaf_rab);   H /* Since C understands ASCIZ strings better than blank filled strings orR ** character descriptors, convert the blank filled username from the authorization4 ** record to an ASCIZ string in a local variable. */  e 	memmove (username, &sysuaf_record.UAF$r_fill_0.UAF$T_USERNAME, sizeof username);	/* Copy the text */ 7 	for (index = sizeof username - 1; index >= 0; --index) R 	    if (username[index] != ' ') break;				/* Exit on first non-blank character */Y 	memset (&username[index + 1], 0, sizeof username - index - 1);	/* Zero fill remainder */   N /* Becuse there are "username" entries in the UAF which are not for real usersM ** (notably the system password entry), validate the syntax of the entry.  If K ** the syntax is valid, add it to the appropriate lists.  Otherwise, simply K ** ignore it.  (This assumes the syntax of the name is checked prior to the $ ** creation of the new UAF entry. */  2 	if (TRUE (AUTHORIZE$VALIDATE_USER_NAME (username,
 						0)))  0 /* Add the new entry to the master user list. */  ( 	    AUTHORIZE$ADD_LIST_ENTRY (username,/ 				      sysuaf_record.UAF$r_fill_2.UAF$L_UIC, @ 				      uaf_r_master_list.uaf$l_usrlst_blink,	/* To the end */ 				      &new_entry); 	}  G /* If the $GET failed, check the failure status.  Certain errors can be L ** considered benign, and are ignored.  Others will terminate processing. */  4     if ((status == RMS$_RLK) ||		/* Record locked */0 	(status == RMS$_RNF) ||		/* Record not found */7 	(status == RMS$_RTB))		/* record too big for buffer */  	status = RMS$_NORMAL;     }  while (TRUE (status));   /* Return success. */    return SS$_NORMAL; }   ( extern void AUTHORIZE$BUILD_USER_LIST () {  /* **++ **  FUNCTIONAL DESCRIPTION:  **O **	This routine reads the authorization file and builds two lists of usernames. O **	The first list is contains all the usernames in the authorization file.  The K **	second list contains only those usernames representing groups (i.e., the O **	member portion of the UIC is 177777 [octal]).  These lists are then used for L **	processing.  This is to allow the use of $GETUAI and $SETUAI which do not; **	currently understand how to perform wildcard operations.  ** **  FORMAL PARAMETERS: ** **	None  ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	None. ** **-- */   /* External routines. */  * extern void			AUTHORIZE$ADD_LIST_ENTRY ();5 extern unsigned int		AUTHORIZE$VALIDATE_USER_NAME (); - extern unsigned int		AUTHORIZE$MATCH_NAME ();   H /* The following storage is defined first, to allow storage following to ** be correctly sized. */   N globalref struct USRLSTDEF	uaf_r_group_list;			/* Group user name list head */X globalref struct USRLSTDEF	uaf_r_master_list;			/* Complete user list (from the file) */G globalref struct USRLSTDEF	uaf_r_user_list;			/* User name list head */    /* Remaining global storage. */   V globalref unsigned int		uaf_l_current_group_max;		/* Count of entries in group list */U globalref unsigned int		uaf_l_current_user_max;			/* Count of entries in user list */ ` globalref Widget		uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */I globalref char			*uaf_t_default_username;		/* Default account username */ y globalref char			uaf_t_username_filter[sizeof uaf_r_user_list.uaf$t_usrlst_name];    /* Current username filter string */    /* Local storage. */  = struct USRLSTDEF		*current_entry;				/* Current list entry */ % int				index;					/* General index */ @ struct USRLSTDEF		*master_entry;				/* Master user list entry */W XmString			master_entry_username;			/* Compound string for username from master list */ A struct USRLSTDEF		*new_entry;				/* User list entry just added */ 7 struct USRLSTDEF		*next_entry;				/* Next list entry */ ; struct USRLSTDEF		*prev_entry;				/* Previous list entry */ 4 unsigned int			status;					/* Routine exit status */= char				username[MAX_USERNAME];			/* Username text storage */   I /* Since a new user list is being built, clear out any existing user list " ** entries; on both user lists. */  Q while (uaf_r_user_list.uaf$l_usrlst_flink != &uaf_r_user_list.uaf$l_usrlst_flink)      {   P /* Remove the first entry.  This could have been done with a REMQUE instruction,B ** but I didn't want to add explicit architecture dependencies. */  7     current_entry = uaf_r_user_list.uaf$l_usrlst_flink; 3     prev_entry = current_entry->uaf$l_usrlst_blink; 3     next_entry = current_entry->uaf$l_usrlst_flink;   E     prev_entry->uaf$l_usrlst_flink = &next_entry->uaf$l_usrlst_flink; E     next_entry->uaf$l_usrlst_blink = &prev_entry->uaf$l_usrlst_flink;        free (current_entry);      }   S while (uaf_r_group_list.uaf$l_usrlst_flink != &uaf_r_group_list.uaf$l_usrlst_flink)      {   P /* Remove the first entry.  This could have been done with a REMQUE instruction,B ** but I didn't want to add explicit architecture dependencies. */  8     current_entry = uaf_r_group_list.uaf$l_usrlst_flink;3     prev_entry = current_entry->uaf$l_usrlst_blink; 3     next_entry = current_entry->uaf$l_usrlst_flink;   E     prev_entry->uaf$l_usrlst_flink = &next_entry->uaf$l_usrlst_flink; E     next_entry->uaf$l_usrlst_blink = &prev_entry->uaf$l_usrlst_flink;        free (current_entry);      }   G /* Delete all the items from the username and group name list boxes. */   C XmListDeleteAllItems (uaf_r_widget_id_array[uaf$c_main_user_list]); D XmListDeleteAllItems (uaf_r_widget_id_array[uaf$c_main_group_list]);  H /* Traverse the master user list looking for candidates for the user and ** group lists. */  4 master_entry = uaf_r_master_list.uaf$l_usrlst_flink;  = while (master_entry != &uaf_r_master_list.uaf$l_usrlst_flink)      { S     master_entry_username = XmStringCreateSimple (master_entry->uaf$t_usrlst_name);   H /* Check each entry in the master user list and build the user and groupG ** lists.  The user list is simply an entry for each user record in the I ** authorization file.  The group list is an entry for each record in the D ** authorization file that has a member number of -1 (177777 octal). **J ** See if the entry matches the filter criteria.  Filtering is done in one ** of two ways:  **J **  1)	If the first character of the filter string is not a square bracketI **	or angle bracket, compare the supplied string with the username field.2 **I **  2)	If the first character of the filter string is a suqare bracket orrF **	an angle bracket, compare the supplied string with the coverted UIC/ **	(octal form as well as the identifier form).i **K ** Note this is only done for the username list.  The filter does not applyu' ** for candidates for the group list */        if ( 	(											/* First case */OM 	 ((uaf_t_username_filter[0] != '[') && (uaf_t_username_filter[0] != '<')) && H 	 (TRUE (AUTHORIZE$MATCH_NAME (strlen (master_entry->uaf$t_usrlst_name),* 				      master_entry->uaf$t_usrlst_name,) 				      strlen (uaf_t_username_filter),_" 				      uaf_t_username_filter))) 	) ||E 	(											/* Second case */M 	 ((uaf_t_username_filter[0] == '[') || (uaf_t_username_filter[0] == '<')) &&  	 (iI 	  ((TRUE (AUTHORIZE$MATCH_NAME (strlen (master_entry->uaf$t_usrlst_uic),m$ 					master_entry->uaf$t_usrlst_uic,$ 					strlen (uaf_t_username_filter),  					uaf_t_username_filter))) ||L 	   (TRUE (AUTHORIZE$MATCH_NAME (strlen (master_entry->uaf$t_usrlst_uic_id),' 					master_entry->uaf$t_usrlst_uic_id,A$ 					strlen (uaf_t_username_filter), 					uaf_t_username_filter)))b 	  ) 	 )o 	)        ) 	{  - /* Add the new entry to the username list. */i  ; 	AUTHORIZE$ADD_LIST_ENTRY (master_entry->uaf$t_usrlst_name,K 				  0,: 				  uaf_r_user_list.uaf$l_usrlst_blink,	/* To the end */ 				  &new_entry);  ) /* Add the entry to the user list box. */d  < 	XmListAddItem (uaf_r_widget_id_array[uaf$c_main_user_list], 		       master_entry_username,l 		       0); 	++uaf_l_current_user_max; 	}  M /* If this entry is a group entry, add it to the group name queue as well. */	  D     if (sysuaf_record.UAF$r_fill_2.UAF$r_fill_3.UAF$W_MEM == 0xffff) 	{  * /* Add the new entry to the group list. */  ; 	AUTHORIZE$ADD_LIST_ENTRY (master_entry->uaf$t_usrlst_name,c 				  0,; 				  uaf_r_group_list.uaf$l_usrlst_blink,	/* To the end */o 				  &new_entry);  * /* Add the entry to the group list box. */  = 	XmListAddItem (uaf_r_widget_id_array[uaf$c_main_group_list],t 		       master_entry_username,t 		       0); 	++uaf_l_current_group_max;C 	}  K /* In this entry is the DEFAULT entry, add it to the group queue and set it & ** up as the default selected item. */  N     if (strcmp (uaf_t_default_username, master_entry->uaf$t_usrlst_name) == 0) 	{  * /* Add the new entry to the group list. */  ; 	AUTHORIZE$ADD_LIST_ENTRY (master_entry->uaf$t_usrlst_name,  				  0,; 				  uaf_r_group_list.uaf$l_usrlst_blink,	/* To the end */  				  &new_entry);  * /* Add the entry to the group list box. */  = 	XmListAddItem (uaf_r_widget_id_array[uaf$c_main_group_list],r 		       master_entry_username,e 		       0); 	++uaf_l_current_group_max;a  , /* Select and highlight the DEFAULT item. */  9 	AUTHORIZE$SET_UP_GROUP (master_entry->uaf$t_usrlst_name,S
 				NULL); 	}#     XtFree (master_entry_username);s  8 /* Set up for the next entry in the master user list. */  4     master_entry = master_entry->uaf$l_usrlst_flink;     }s }_ t> extern unsigned int AUTHORIZE$CRE_USER_INFO (username, itmlst)   char			*username;D struct ITMDEF		(*itmlst)[];  {r /* **++ **  FUNCTIONAL DESCRIPTION:e **F **	This routine creates the user authorization entry for the specified( **	user, using the information supplied. ** **  FORMAL PARAMETERS: *** **	USERNAME	- pointer to the username text- **	ITMLST		- pointer to the dynamic item listo ** **  RETURN VALUE:h ** **	Status from $CREUAI ** **  SIDE EFFECTS:t ** **	None. ** **-- */   /* Global storage. */	  N globalref unsigned short int	uaf_w_uai_context[2];		/* $xxxUAI context cell */   /* Local storage. */  B unsigned int			username_desc[2];		/* Simple username descriptor */  B /* Since $CREUAI wants the username as a descriptor, set it up. */  % username_desc[0] = strlen (username);i username_desc[1] = username;  4 /* Create the specified user authorization entry. */   return SYS$CREUAI (NULL, #ifdef NONSHARED_UAI_CONTEXT
 		   NULL, #else  		   uaf_w_uai_context,;" #endif /* NONSHARED_UAI_CONTEXT */ 		   username_desc,c 		   itmlst,
 		   NULL,
 		   NULL, 		   NULL);  }_ r1 extern void AUTHORIZE$DEL_LIST_ENTRY (list_entry)    struct USRLSTDEF	*list_entry;; {  /* **++ **  FUNCTIONAL DESCRIPTION:  **; **	This routine removes user list entry and deallocates thes> **	associated memory.  This could have been done with a REMQUE> **	instruction, but I didn't want to add explicit architecture **	dependencies. ** **  FORMAL PARAMETERS: **$ **	LIST_ENTRY	- list entry to delete ** **  RETURN VALUE:l ** **	None. ** **  SIDE EFFECTS:y ** **	None. ** **-- */   /* Local storage. */  F struct USRLSTDEF	*next_entry;		/* Pointer to entry after queue head */K struct USRLSTDEF	*prev_entry;		/* Pointer to entry before the queue head */   4 /* Get pointers to the previous and next entries. */  P prev_entry = list_entry->uaf$l_usrlst_blink;	/* Get pointer to previous entry */L next_entry = list_entry->uaf$l_usrlst_flink;	/* Get pointer to next entry */  @ /* Adjust the link pointers to eliminate the list head entry. */  m prev_entry->uaf$l_usrlst_flink = &next_entry->uaf$l_usrlst_flink;	/* Forward link points to old next entry */tn next_entry->uaf$l_usrlst_blink = &prev_entry->uaf$l_usrlst_flink;	/* Back link points to old previous entry */  1 /* Return the memory from the list head entry. */    free (list_entry); }t h6 extern unsigned int AUTHORIZE$DEL_USER_INFO (username)   char			*username;i {o /* **++ **  FUNCTIONAL DESCRIPTION:n **F **	This routine deletes the user authorization entry for the specified **	user. ** **  FORMAL PARAMETERS: *** **	USERNAME	- pointer to the username text ** **  RETURN VALUE:_ ** **	Status from $DELUAI ** **  SIDE EFFECTS:t ** **	None. ** **-- */   /* Global storage. */   N globalref unsigned short int	uaf_w_uai_context[2];		/* $xxxUAI context cell */   /* Local storage. */  B unsigned int			username_desc[2];		/* Simple username descriptor */  B /* Since $DELUAI wants the username as a descriptor, set it up. */  % username_desc[0] = strlen (username);a username_desc[1] = username;  4 /* Create the specified user authorization entry. */   return SYS$DELUAI (NULL, #ifdef NONSHARED_UAI_CONTEXT
 		   NULL, #elsee 		   uaf_w_uai_context,e" #endif /* NONSHARED_UAI_CONTEXT */ 		   username_desc, 
 		   NULL,
 		   NULL,
 		   NULL, 		   NULL);  }   ; extern void AUTHORIZE$FILE_PROCESS (widget_id, tag, reason)h   Widget				widget_id; int				*tag; XmAnyCallbackStruct		*reason;  {  /* **++ **  FUNCTIONAL DESCRIPTION:l **B **	This routine process the various actions for the file selection **	box widget. ** **  FORMAL PARAMETERS: **F **	LIST_HEAD	- list head for the list to which the entry will be added ** **  RETURN VALUE:w ** **	Nonei ** **  SIDE EFFECTS:e ** **	None. ** **-- */   /* External routines. */  3 extern unsigned int	AUTHORIZE$BUILD_MASTER_LIST (); * extern void		AUTHORIZE$BUILD_USER_LIST ();% extern void		AUTHORIZE$DECW_ERROR (); * extern unsigned int	AUTHORIZE$OPEN_UAF ();* extern void		AUTHORIZE$SET_UP_USERNAME ();* extern void		AUTHORIZE$WATCH_CURSOR_ON ();+ extern void		AUTHORIZE$WATCH_CURSOR_OFF ();w   /* Global references. */  K globalref Widget	uaf_r_file_window_widget;	/* File selection widget info */ Q globalref Widget	uaf_r_main_top_level_widget;	/* Main window widget shell info */rH globalref Widget	uaf_r_main_window_widget;	/* Main window widget info */J globalref Cursor	uaf_r_wait_cursor_main;		/* Main window wait cursor id */   /* Local storage. */  I Widget			file_selection_box_text;	/* File selection box text widget id */t2 unsigned int		status;				/* Routine exit status */0 char			*temp_string;			/* Temp string pointer */ int			widget_number = *tag;L   /* Debug information. */   #ifdef DEBUGGING printf ("file process\n"); #endif /* DEBUGGING */  D /* Call the appropriate routine, based upon the requested action. */   switch (widget_number)     {n     case uaf$c_file_open_file: 	{  + /* Get the name of the new file to open. */U  P 	file_selection_box_text = XmFileSelectionBoxGetChild (uaf_r_file_window_widget, 							      XmDIALOG_TEXT);9 	temp_string = XmTextGetString (file_selection_box_text);x  & /* Open the new authorization file. */  . 	if (FALSE (AUTHORIZE$OPEN_UAF (temp_string))) 	    {  ( /* If the open fails, note the error. */  , 	    AUTHORIZE$DECW_ERROR (UAF$_UAFOPENERR); 	    return; 	    }  % /* Dismiss the file selection box. */x  , 	XtUnmanageChild (uaf_r_file_window_widget);9 	XFlush (XtDisplay (uaf_r_file_window_widget));	/* Now */i  N /* Since building the user list may take some time, set up the wait cursor. */  8 	AUTHORIZE$WATCH_CURSOR_ON (uaf_r_main_top_level_widget,  				   uaf_r_main_window_widget, 				   uaf_r_wait_cursor_main);v  * /* Get a list of the user's and groups. */  , 	if (FALSE (AUTHORIZE$BUILD_MASTER_LIST ())) 	    {  * /* If the build fails, not the failure. */  , 	    AUTHORIZE$DECW_ERROR (UAF$_UAFREADERR); 	    return; 	    } 	AUTHORIZE$BUILD_USER_LIST ();  = /* If possible, set up for the first username in the list. */=   	AUTHORIZE$SET_UP_USERNAME (0,
 				   1);   /* Reset the cursor. */&  9 	AUTHORIZE$WATCH_CURSOR_OFF (uaf_r_main_top_level_widget, " 				    uaf_r_main_window_widget);  8 /* Free up any storage allocated for the text string. */   	XtFree (temp_string); 	break;) 	}       case uaf$c_file_cancel:t 	{, 	XtUnmanageChild (uaf_r_file_window_widget); 	break;s 	}     }s }l ne extern unsigned int AUTHORIZE$FIND_USER_ENTRY (list_head, username, match_type, position, list_entry);   struct USRLSTDEF	*list_head; char			*username;u int			match_type;R int			**position;  struct USRLSTDEF	**list_entry; {$ /* **++ **  FUNCTIONAL DESCRIPTION:p **C **	This routine checks the specified list and locates an entry that)& **	meets the specified match criteria. **A **	Note: There is an implicit assumption that the candidate entryL. **	      will not exist in the specified list. ** **  FORMAL PARAMETERS: **/ **	LIST_HEAD	- list head for the list to searchr6 **	USERNAME	- pointer to the (candidate) username text@ **	MATCH_TYPE	- type code that determines name matching criteria  **			  (less, equal, or greater)< **	POSITION	- address of a cell to contain the list position ** **  RETURN VALUE:  ** **	1 if found, 0 otherwise.i ** **  SIDE EFFECTS:  ** **	None. ** **-- */   /* Local storage. */  8 struct USRLSTDEF	*entry;			/* Current user list entry */6 int			found_entry;		/* Flag to indicate entry found */@ int			list_position = 1;	/* Position in the list; NOTE 1 bias */  M /* Loop through each entry in the list looking for the specified username. */s  A entry = list_head->uaf$l_usrlst_flink;		/* Get the first entry */   / while (entry != &list_head->uaf$l_usrlst_flink)      {k4     found_entry = 0;				/* Assume entry not found */  : /* Do the check based upon the type of match requested. */       switch (match_type)y 	{ 	case FIND_NAME_LESS:/ 	    {  A /* Since we are looking for the target entry (just) less than theiB ** candidate entry, it is necessary to find the first entry (just)A ** greater than the candidate entry, and position to the previous,A ** entry.  So the logic is similar to the FIND_NAME_GREATER case;e ** but with a twist. */t  S 	    if (entry->uaf$t_usrlst_name[0] >= username[0])				/* Check first character */  		{(S 		if (strcmp (&entry->uaf$t_usrlst_name, username) >= 0)			/* Then entire string */  		    {u3 		    found_entry = 1;							/* entry > username */ D 		    entry = entry->uaf$l_usrlst_blink;					/* Point to previous */ 		    }  		}R 	    break;R 	    }   	case FIND_NAME_EQUAL: 	    {  I /* If a check for equality is being made, a performance boost can be madeiJ ** by comparing the first byte of each string.  If they do not match, thenI ** there is no point comparing the entire string.  If they do match, thene! ** compare the entire strings. */e  S 	    if (entry->uaf$t_usrlst_name[0] == username[0])				/* Check first character */. 		{sS 		if (strcmp (&entry->uaf$t_usrlst_name, username) == 0)			/* Then entire string */ 2 		    found_entry = 1;							/* username = entry*/ 		}R 	    break;n 	    }   	case FIND_NAME_GREATER: 	    {  D /* Since we are looking for the target entry (just) greater than theD ** candidate entry, all target entries whose first byte is less thanF ** the first byte of the candidate entry can be excluded from the full ** comparison. */T  S 	    if (entry->uaf$t_usrlst_name[0] >= username[0])				/* Check first character */i 		{*R 		if (strcmp (&entry->uaf$t_usrlst_name, username) > 0)			/* Then entire string */3 		    found_entry = 1;							/* entry > username */C 		}t 	    break;f 	    } 	}  H /* If the entry was found, post any information requested and return. */       if (found_entry != 0)r 	{. 	if (position != 0) *position = list_position;* 	if (list_entry != 0) *list_entry = entry;
 	return 1; 	}  = /* Otherwise try the next entry; and up the list position. */   &     entry = entry->uaf$l_usrlst_flink;     ++list_position;     }]  G /* At this point, all the entries have been checked.  Since nothing waseE ** found, the entry "found" is the list head, and the position is thet! ** first position in the list. */l  ! if (position != 0) *position = 1;eB if (list_entry != 0) *list_entry = &list_head->uaf$l_usrlst_flink;   /* Return a failure. */t  	 return 0;	 }d 	> extern unsigned int AUTHORIZE$GET_USER_INFO (username, itmlst)   char			*username;r struct ITMDEF		(**itmlst)[]; {r /* **++ **  FUNCTIONAL DESCRIPTION:  **B **	This routine obtains the user authorization information for the@ **	specified user.  The information is returned in the form of a **	dynamic item list.D ** **  FORMAL PARAMETERS: *** **	USERNAME	- pointer to the username text< **	ITMLST		- address of a cell to contain the pointer to the **			  dynamic item list ** **  RETURN VALUE:  ** **	Status from $GETUAI ** **  SIDE EFFECTS:s ** **	None. ** **-- */   /* External routines. */  ' extern void			AUTHORIZE$ITMLST_COPY ();l5 extern unsigned int		AUTHORIZE$RELEASE_UAF_RECORD ();    /* Global storage. */e  H globalref struct ITMDEF		uaf_r_user_auth_info[];	/* $xxxUAI item list */M globalref unsigned short int	uaf_w_uai_context[2];	/* $xxxUAI context cell */f   /* Local storage. */  2 unsigned int			status;			/* Routine exit status */A unsigned int			username_desc[2];	/* Simple username descriptor */t  B /* Since $GETUAI wants the username as a descriptor, set it up. */  % username_desc[0] = strlen (username);k username_desc[1] = username;  L /* Get the information for the specified user.  If the NONSHARED_UAI_CONTEXTD ** symbol is defined, the UAF is not kept open across $xxxUAI calls.D ** This means when information is needed, the UAF must be opened and3 ** closed for the request (internal to $GETUAI). */_  $ if (TRUE (status = SYS$GETUAI (NULL, #ifdef NONSHARED_UAI_CONTEXT 			       NULL,l #elsek 			       uaf_w_uai_context," #endif /* NONSHARED_UAI_CONTEXT */ 			       username_desc, 			       uaf_r_user_auth_info,i 			       NULL,t 			       NULL,b 			       NULL)))>     {s  " /* Release the RMS record lock. */  $     AUTHORIZE$RELEASE_UAF_RECORD ();  9 /* If there is already a dynamic item list, delete it. */e  7     if (*itmlst != 0) AUTHORIZE$ITMLST_DELETE (itmlst);   K /* Copy the information from the local item list to a dynamic item list. */e  0     AUTHORIZE$ITMLST_COPY (uaf_r_user_auth_info,
 			   itmlst,*	 			   0);s     }   % /* Return with the $GETUAI status. */r   return status; }m e1 extern unsigned int AUTHORIZE$OPEN_UAF (uaf_file)    char			*uaf_file;t {u /* **++ **  FUNCTIONAL DESCRIPTION:e **D **	This routine opens the existing user authorization file specifiedG **	by the caller.  If an authorization file has been breviously opened,  **	it is closed. ** **  FORMAL PARAMETERS: **= **	UAF_FILE	- Pointer to the authorization file specificationo ** **  RETURN VALUE:a **2 **	SS$_NORMAL if successful, error code otherwise. ** **  SIDE EFFECTS:r ** **	None. ** **-- */   /* Global references. */  V globalref char			*default_sysuaf_file_name;	/* Authorization file default file name */V globalref char			*default_sysuaf_file_type;	/* Authorization file default file type */R globalref char			*default_sysuaf_file_spec;	/* Authorization filed default spec */N globalref unsigned short int	uaf_w_uai_context[2];		/* $xxxUAI context cell */   /* Local storage. */  3 unsigned int			status;				/* Routine exit status */r  U /* If there is an open authorization file, as indicated by the uaf_w_uai_context celli2 ** being something other than -1, close it now. */  # if (uaf_w_uai_context[0] != 0xFFFF)      {U  J /* Initialize the RMS data structures with the information needed to close' ** the open user authorization file. */   /     memset (&sysuaf_fab, 0, sizeof sysuaf_fab);_/     memset (&sysuaf_rab, 0, sizeof sysuaf_rab);d  %     sysuaf_fab.fab$b_bid = FAB$C_BID; %     sysuaf_fab.fab$b_bln = FAB$C_BLN;'0     sysuaf_fab.fab$w_ifi = uaf_w_uai_context[0];  %     sysuaf_rab.rab$b_bid = RAB$C_BID;	%     sysuaf_rab.rab$b_bln = RAB$C_BLN;	0     sysuaf_rab.rab$w_isi = uaf_w_uai_context[1];  !     SYS$DISCONNECT (&sysuaf_rab);E     SYS$CLOSE (&sysuaf_rab);     }f  T /* Initialize the RMS data structures needed to open the user authorization file. */  * /* Unused lookup key - UAF$Q_PARENT_ID. */  : sysuaf_key3 = cc$rms_xabkey;			/* Prototype information */9 sysuaf_key3.xab$b_ref = 3;									/* Key of reference */uq sysuaf_key3.xab$w_pos0 = (int)(&sysuaf_record.UAF$Q_PARENT_ID) - (int)(&sysuaf_record);		/* Position in record */AS sysuaf_key3.xab$b_siz0 = sizeof sysuaf_record.UAF$Q_PARENT_ID;					/* Field size */_9 sysuaf_key3.xab$b_dtp = XAB$C_BN8;								/* Data type */ D sysuaf_key3.xab$b_flg = XAB$M_CHG | XAB$M_DUP;							/* Key flags */  I /* Unused lookup key - UAF$L_UIC and UAF$L_SUB_ID (assumed to be adjacent$ ** fields in the UAF record. */=  : sysuaf_key2 = cc$rms_xabkey;			/* Prototype information */9 sysuaf_key2.xab$b_ref = 2;									/* Key of reference */cw sysuaf_key2.xab$w_pos0 = (int)(&sysuaf_record.UAF$r_fill_2.UAF$L_UIC) - (int)(&sysuaf_record);	/* Position in record */rz sysuaf_key2.xab$b_siz0 = sizeof sysuaf_record.UAF$r_fill_2.UAF$L_UIC + sizeof sysuaf_record.UAF$L_SUB_ID;	/* Field size */9 sysuaf_key2.xab$b_dtp = XAB$C_BN8;								/* Data type */yD sysuaf_key2.xab$b_flg = XAB$M_CHG | XAB$M_DUP;							/* Key flags */; sysuaf_key2.xab$l_nxt = &sysuaf_key3;								/* Next XAB */l 	s' /* Secondary lookup key - UAF$L_UIC. */=  : sysuaf_key1 = cc$rms_xabkey;			/* Prototype information */9 sysuaf_key1.xab$b_ref = 1;									/* Key of reference */	w sysuaf_key1.xab$w_pos0 = (int)(&sysuaf_record.UAF$r_fill_2.UAF$L_UIC) - (int)(&sysuaf_record);	/* Position in record */ Y sysuaf_key1.xab$b_siz0 = sizeof sysuaf_record.UAF$r_fill_2.UAF$L_UIC;				/* Field size */s9 sysuaf_key1.xab$b_dtp = XAB$C_BN4;								/* Data type */mD sysuaf_key1.xab$b_flg = XAB$M_CHG | XAB$M_DUP;							/* Key flags */; sysuaf_key1.xab$l_nxt = &sysuaf_key2;								/* Next XAB */   * /* Primary lookup key - UAF$T_USERNAME. */  : sysuaf_key0 = cc$rms_xabkey;			/* Prototype information */9 sysuaf_key0.xab$b_ref = 0;									/* Key of reference */t| sysuaf_key0.xab$w_pos0 = (int)(&sysuaf_record.UAF$r_fill_0.UAF$T_USERNAME) - (int)(&sysuaf_record);	/* Position in record */^ sysuaf_key0.xab$b_siz0 = sizeof sysuaf_record.UAF$r_fill_0.UAF$T_USERNAME;				/* Field size */9 sysuaf_key0.xab$b_dtp = XAB$C_STG;								/* Data type */*; sysuaf_key0.xab$l_nxt = &sysuaf_key2;								/* Next XAB */e  ! /* Authorization file NAMe block.h  J /* Since the prototyping doesn't work for the NAMe block, the block id andJ ** block length fields have to be set in the usual way; after clearing out ** the block. */  9 /* sysuaf_nam = cc$rms_nam;			/* Prototype information */   + memset (&sysuaf_nam, 0, sizeof sysuaf_nam);m! sysuaf_nam.nam$b_bid = NAM$C_BID;r! sysuaf_nam.nam$b_bln = NAM$C_BLN;t  F sysuaf_nam.nam$l_esa = sysuaf_esn;		/* Expanded name string storage */T sysuaf_nam.nam$b_ess = sizeof sysuaf_esn;	/* Size of expanded name string storage */G sysuaf_nam.nam$l_rsa = sysuaf_rsn;		/* Resultant name string storage */ U sysuaf_nam.nam$b_rss = sizeof sysuaf_rsn;	/* Size of resultant name string storage */n  & /* Authorization File Access Block. */  6 sysuaf_fab = cc$rms_fab;			/* Prototype information */! sysuaf_fab.fab$l_fop = FAB$M_CBT;RE sysuaf_fab.fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_DEL | FAB$M_UPD;*E sysuaf_fab.fab$b_shr = FAB$M_GET | FAB$M_PUT | FAB$M_DEL | FAB$M_UPD;e! sysuaf_fab.fab$b_org = FAB$C_IDX;e! sysuaf_fab.fab$b_rfm = FAB$C_VAR; $ sysuaf_fab.fab$w_mrs = UAF$C_LENGTH; sysuaf_fab.fab$l_alq = 10; sysuaf_fab.fab$w_deq = 10;# sysuaf_fab.fab$l_nam = &sysuaf_nam; $ sysuaf_fab.fab$l_xab = &sysuaf_key0;  C /* If a file name was supplied, use it.  Otherwise, use the default  ** file name string. */e   if (strlen (uaf_file) == 0)a     {e  C /* If the SYSUAF_LOGICAL symbol is defined, set up the FAB to allowhD ** the authorization file to be accessed via the appropriate logicalC ** name.  Otherwise, set up the FAB to allow the authorization filep3 ** to be accessed via a full file specification. */s   #ifdef	SYSUAF_LOGICALoP     sysuaf_fab.fab$l_fna = default_sysuaf_file_name;		/* For the logical name */=     sysuaf_fab.fab$b_fns = strlen (default_sysuaf_file_name);f4     sysuaf_fab.fab$l_dna = default_sysuaf_file_type;=     sysuaf_fab.fab$b_dns = strlen (default_sysuaf_file_type);	 #else K     sysuaf_fab.fab$l_fna = default_sysuaf_file_spec;		/* For a file spec */a=     sysuaf_fab.fab$b_fns = strlen (default_sysuaf_file_spec);  #endif	/* SYSUAF_LOGICAL */n     }  else     {a$     sysuaf_fab.fab$l_fna = uaf_file;-     sysuaf_fab.fab$b_fns = strlen (uaf_file);r     }i  - /* Authorization file Record Access Block. */   6 sysuaf_rab = cc$rms_rab;			/* Prototype information */# sysuaf_rab.rab$l_fab = &sysuaf_fab;  sysuaf_rab.rab$b_krf = 0; B sysuaf_rab.rab$l_kbf = &sysuaf_record.UAF$r_fill_0.UAF$T_USERNAME;H sysuaf_rab.rab$b_ksz = sizeof sysuaf_record.UAF$r_fill_0.UAF$T_USERNAME;, sysuaf_rab.rab$w_usz = sizeof sysuaf_record;! sysuaf_rab.rab$b_rac = RAB$C_KEY;l  9 /* Open the authorization file, and return any errors. */m  & CHECK_RETURN (SYS$OPEN (&sysuaf_fab));  ; /* Connect up a record stream to the authorization file. */   ) CHECK_RETURN (SYS$CONNECT (&sysuaf_rab));e  ) /* Save the RMS IFI and ISI for later. */N  , uaf_w_uai_context[0] = sysuaf_fab.fab$w_ifi;, uaf_w_uai_context[1] = sysuaf_rab.rab$w_isi;   return SS$_NORMAL; }e  3 extern unsigned int AUTHORIZE$RELEASE_UAF_RECORD ()    {  /* **++ **  FUNCTIONAL DESCRIPTION:g **F **	This routine is called to release the RMS locks associated with the> **	authorization record read by $GETUAI or written by $SETUAI. ** **  FORMAL PARAMETERS: ** **	None. ** **  RETURN VALUE:n **2 **	SS$_NORMAL if successful, error code otherwise. ** **  SIDE EFFECTS:t ** **	None. ** **-- */   /* Global storage. */U  N globalref unsigned short int	uaf_w_uai_context[2];		/* $xxxUAI context cell */  J /* Initialize the RMS data structures with the information needed to close' ** the open user authorization file. */(  + memset (&sysuaf_rab, 0, sizeof sysuaf_rab);e  ! sysuaf_rab.rab$b_bid = RAB$C_BID;;! sysuaf_rab.rab$b_bln = RAB$C_BLN;R, sysuaf_rab.rab$w_isi = uaf_w_uai_context[1];   /* Release the record. */E   SYS$RELEASE (&sysuaf_rab);   return SS$_NORMAL; }l l> extern unsigned int AUTHORIZE$SET_USER_INFO (username, itmlst)   char			*username;g struct ITMDEF		(*itmlst)[];t {* /* **++ **  FUNCTIONAL DESCRIPTION:b **C **	This routine modifies the user authorization information for theb **	specified user. ** **  FORMAL PARAMETERS: *** **	USERNAME	- pointer to the username text- **	ITMLST		- pointer to the dynamic item liste ** **  RETURN VALUE:d ** **	Status from $SETUAI ** **  SIDE EFFECTS:u ** **	None. ** **-- */   /* Global storage. *//  N globalref unsigned short int	uaf_w_uai_context[2];		/* $xxxUAI context cell */   /* Local storage. */  3 unsigned int			status;				/* Routine exit status */tB unsigned int			username_desc[2];		/* Simple username descriptor */  B /* Since $SETUAI wants the username as a descriptor, set it up. */  % username_desc[0] = strlen (username);o username_desc[1] = username;  O /* Create the specified user authorization entry.  If the NONSHARED_UAI_CONTEXTxD ** symbol is defined, the UAF is not kept open across $xxxUAI calls.D ** This means when information is needed, the UAF must be opened and3 ** closed for the request (internal to $GETUAI). */T   status = SYS$SETUAI (NULL, #ifdef NONSHARED_UAI_CONTEXT 		     NULL, #else  		     uaf_w_uai_context,m" #endif /* NONSHARED_UAI_CONTEXT */ 		     username_desc,( 		     itmlst, 		     NULL, 		     NULL,
 		     NULL);    /* Release RMS record lock. */    AUTHORIZE$RELEASE_UAF_RECORD ();  ! /* Return with $SETUAI status. */l   return status; }u rE extern unsigned int AUTHORIZE$VALIDATE_USER_NAME (username, wildcard)    char			*username;u int			wildcard;L {( /* **++ **  FUNCTIONAL DESCRIPTION:{ **< **	This routine checks the syntax of the specified username. ** **  FORMAL PARAMETERS: *** **	USERNAME	- pointer to the username text: **	WILDCARD	- = 0 to disallow wildcard characters as legal' **			  = 1 to allow wildcard charactersE ** **  RETURN VALUE:R **$ **	SS$_NORMAL if valid, 0 otherwise. ** **  SIDE EFFECTS:o ** **	None. ** **-- */   /* Local storage. */  7 char			*character_set;							/* Character set to use *//c char			*valid_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$_";	/* Valid non-wildcard characters */_i char			*valid_wc_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$_*%";	/* Valid characters and wildcards */d  R /* Set up the character set to use for the validation.  This is based upon whether- ** or not wildcard characters are allowed. */i  / if (wildcard == 0) character_set = valid_chars; $ else character_set = valid_wc_chars;  N /* If all of the characters in the supplied username are in the character set,& ** return a generic success status. */  D if (strspn (username, character_set) == strlen (username)) return 1;  1 /*  Otherwise return a generic failure status. */T  	 return 0;L }_