 #module uaf_global "X-2"   /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **; **		This module contains the global storage definitions and . **		the global storage initialization routine. **8 **  AUTHORS:	L. Mark Pilant		CREATION DATE:  25-Nov-1992 ** **  MODIFICATION HISTORY:  **/ **	X-2	LMP		L. Mark Pilant,		28-JAN-1993  13:24 $ **		Convert to C from BLISS sources. **( **	X-1	LMP		L. Mark Pilant,		25-NOV-1992 **		Original version.  ** **-- */   /* ** **  INCLUDE FILES  ** */   #include string    #include <decw$include:mrmappl>    #include "uaf_header"   = /* Define the macro used to populate the formatting table. */   R #define		ITEM_ENTRY(uai_code, widget_code, bytcnt, faoctrstr, flags, padchr)					\ 		    {													\ D 		    uaf_r_item_table[uai_code].item_l_widget = widget_code;						\O 		    uaf_r_item_table[uai_code].item_r_flag_overlay.item_b_flags = flags;				\ A 		    uaf_r_item_table[uai_code].item_b_pad_char = padchr;						\ A 		    uaf_r_item_table[uai_code].item_w_byte_cnt = bytcnt;						\ K 		    strcpy (uaf_r_item_table[uai_code].item_r_fao_ctrs, faoctrstr);					\ O 		    uaf_r_item_table[uai_code].item_l_fao_ctrs_len = strlen (faoctrstr);				\ e 		    uaf_r_item_table[uai_code].item_a_fao_ctrs_ptr = &uaf_r_item_table[uai_code].item_r_fao_ctrs;	\  		    }   H /* The following storage is used for the user authorization information.G ** This information is (defined) local to this routine; only the actual ! ** item list is defined globally.  **E ** This information is copied from the static item list (here) to the  ** dynamic item list.  **D **  The storage quantities must parallel the definitions in UAFDEF.H */  B static char			uaf_t_usr_account[MAX_ACCOUNT];		/* UAF$T_ACCOUNT */> static unsigned short int	uaf_w_usr_astlm;			/* UAF$W_ASTLM */S static unsigned char		uaf_b_batch_access_p[ACCESS_SIZE];	/* UAF$B_BATCH_ACCESS_P */ S static unsigned char		uaf_b_batch_access_s[ACCESS_SIZE];	/* UAF$B_BATCH_ACCESS_S */ > static unsigned short int	uaf_w_usr_biolm;			/* UAF$W_BIOLM */= static unsigned long int	uaf_l_usr_bytlm;			/* UAF$L_BYTLM */ F static char			uaf_t_usr_clitables[MAX_CLITABLE];	/* UAF$T_CLITABLES */? static unsigned long int	uaf_l_usr_cputim;			/* UAF$L_CPUTIM */ I static unsigned char		uaf_q_usr_def_priv[QUADWORD];		/* UAF$Q_DEF_PRIV */ ? static char			uaf_t_usr_defcli[MAX_DEFCLI];		/* UAF$T_DEFCLI */ ? static char			uaf_t_usr_defdev[MAX_DEFDEV];		/* UAF$T_DEFDEV */ ? static char			uaf_t_usr_defdir[MAX_DEFDIR];		/* UAF$T_DEFDIR */ A static unsigned long int	uaf_l_usr_dfwscnt;			/* UAF$L_DFWSCNT */ U static unsigned char		uaf_b_dialup_access_p[ACCESS_SIZE];	/* UAF$B_DIALUP_ACCESS_P */ U static unsigned char		uaf_b_dialup_access_s[ACCESS_SIZE];	/* UAF$B_DIALUP_ACCESS_S */ > static unsigned short int	uaf_w_usr_diolm;			/* UAF$W_DIOLM */> static unsigned short int	uaf_w_usr_enqlm;			/* UAF$W_ENQLM */M static unsigned char		uaf_q_usr_expiration[QUADWORD];		/* UAF$Q_EXPIRATION */ > static unsigned short int	uaf_w_usr_fillm;			/* UAF$W_FILLM */= static unsigned long int	uaf_l_usr_flags;			/* UAF$L_FLAGS */ A static unsigned long int	uaf_l_usr_jtquota;			/* UAF$L_JTQUOTA */ N static unsigned char		uaf_q_usr_lastlogin_i[QUADWORD];	/* UAF$Q_LASTLOGIN_I */N static unsigned char		uaf_q_usr_lastlogin_n[QUADWORD];	/* UAF$Q_LASTLOGIN_N */? static char			uaf_t_usr_lgicmd[MAX_LGICMD];		/* UAF$T_LGICMD */ S static unsigned char		uaf_b_local_access_p[ACCESS_SIZE];	/* UAF$B_LOCAL_ACCESS_P */ S static unsigned char		uaf_b_local_access_s[ACCESS_SIZE];	/* UAF$B_LOCAL_ACCESS_S */ D static unsigned short int	uaf_w_usr_logfails;			/* UAF$W_LOGFAILS */J static unsigned short int	uaf_w_usr_maxacctjobs;			/* UAF$W_MAXACCTJOBS */F static unsigned short int	uaf_w_usr_maxdetach;			/* UAF$W_MAXDETACH */B static unsigned short int	uaf_w_usr_maxjobs;			/* UAF$W_MAXJOBS */W static unsigned char		uaf_b_network_access_p[ACCESS_SIZE];	/* UAF$B_NETWORK_ACCESS_P */ W static unsigned char		uaf_b_network_access_s[ACCESS_SIZE];	/* UAF$B_NETWORK_ACCESS_S */ < static char			uaf_t_usr_owner[MAX_OWNER];		/* UAF$T_OWNER */? static unsigned long int	uaf_l_usr_pbytlm;			/* UAF$L_PBYTLM */ E static unsigned long int	uaf_l_usr_pgflquota;			/* UAF$L_PGFLQUOTA */ @ static unsigned short int	uaf_w_usr_prccnt;			/* UAF$W_PRCCNT */7 static unsigned char		uaf_b_usr_pri;				/* UAF$B_PRI */ B static unsigned char		uaf_b_usr_primedays;			/* UAF$B_PRIMEDAYS */A static unsigned char		uaf_q_usr_priv[QUADWORD];		/* UAF$Q_PRIV */ I static unsigned char		uaf_q_usr_pwd_date[QUADWORD];		/* UAF$Q_PWD_DATE */ D static unsigned char		uaf_b_usr_pwd_length;			/* UAF$B_PWD_LENGTH */P static unsigned char		uaf_q_usr_pwd_lifetime[QUADWORD];	/* UAF$Q_PWD_LIFETIME */K static unsigned char		uaf_q_usr_pwd2_date[QUADWORD];		/* UAF$Q_PWD2_DATE */ < static unsigned char		uaf_b_usr_quepri;			/* UAF$B_QUEPRI */U static unsigned char		uaf_b_remote_access_p[ACCESS_SIZE];	/* UAF$B_REMOTE_ACCESS_P */ U static unsigned char		uaf_b_remote_access_s[ACCESS_SIZE];	/* UAF$B_REMOTE_ACCESS_S */ D static unsigned short int	uaf_w_usr_shrfillm;			/* UAF$W_SHRFILLM */> static unsigned short int	uaf_w_usr_tqcnt;			/* UAF$W_TQCNT */: static unsigned long int	uaf_l_usr_uic;				/* UAF$L_UIC */D static char			uaf_t_usr_username[MAX_USERNAME];	/* UAF$T_USERNAME */C static unsigned long int	uaf_l_usr_wsextent;			/* UAF$L_WSEXTENT */ A static unsigned long int	uaf_l_usr_wsquota;			/* UAF$L_WSQUOTA */    /* ** **  DEFINE THE GLOBAL STORAGE. ** */  ( /* Storage needed by several modules. */  a globaldef char			*default_sysuaf_file_name = "SYSUAF";	/* Authorization file default file name */ _ globaldef char			*default_sysuaf_file_type = ".DAT";	/* Authorization file default file type */   E /* Define the default file specification to use for the authorization > ** file.  The rules for determining this are a little strange: **H ** If the NONSHARED_UAI_CONTEXT symbol is defined, it means this utilityM ** is to run on a VMS version 5.x system.  In this situation, the $GETUAI and I ** $SETUAI system services to not know how to deal with the authorization H ** file being opened outside the services.  For this reason, the defaultI ** specification should be SYS$SYSTEM:SYSUAF.DAT, to allow the (internal) 5 ** $CREUAI and $DELUAI services to use the same file.  **L ** If the NONSHARED_UAI_CONTEXT symbol is not defined, it means this utilityI ** is to run on a VMS version 6.x system.  In this situation, the $GETUAI E ** and $SETUAI system service are able to deal with the authorization G ** file being opened outside the services.  (Because of changes made to ? ** the context is handled and exec mode accessing of files.) */    #ifdef NONSHARED_UAI_CONTEXTl globaldef char			*default_sysuaf_file_spec = "SYS$SYSTEM:SYSUAF.DAT";	/* Authorization filed default spec */ #else j globaldef char			*default_sysuaf_file_spec = "SYS$DISK:SYSUAF.DAT";	/* Authorization filed default spec */" #endif /* NONSHARED_UAI_CONTEXT */  H /* The following storage is defined first, to allow storage following to ** be correctly sized. **I ** NOTE:  These lists are maintained in memory to allow for the insertion F **	  of new entries in alphabetical order.  Because it is not possibleD **	  to get all the entries currently in a list box, there is no wayF **	  to determine where a new entry is to be inserted, without outside **	  (the list box) help. */  S globaldef struct USRLSTDEF	uaf_r_group_list = 0;				/* Group user name list head */ ] globaldef struct USRLSTDEF	uaf_r_master_list = 0;				/* Complete user list (from the file) */ L globaldef struct USRLSTDEF	uaf_r_user_list = 0;				/* User name list head */   /* Remaining global storage. */   W globaldef unsigned int		uaf_l_current_group_max;			/* Count of entries in group list */ O globaldef unsigned int		uaf_l_current_user_index;			/* Index of current user */ V globaldef unsigned int		uaf_l_current_user_max;				/* Count of entries in user list */I globaldef unsigned int		uaf_l_current_user_uic;				/* Current user UIC */ U globaldef int			uaf_l_main_operation;				/* Operation (i.e., create, modify, etc.) */ g globaldef Widget		uaf_r_access_pri_window_widget;			/* Primary access restriction window widget info */ i globaldef Widget		uaf_r_access_sec_window_widget;			/* Secondary access restriction window widget info */ G globaldef XtAppContext		uaf_r_app_context;				/* Application context */ Y globaldef struct ITMDEF		(*uaf_r_current_group_info)[] = 0;		/* Current group UAF info */ W globaldef struct ITMDEF		(*uaf_r_current_user_info)[] = 0;		/* Current user UAF info */ [ globaldef Display		*uaf_r_entry_display;				/* Display id for authorization entry window */ P globaldef Widget		uaf_r_entry_popup_menu_widget;			/* Entry window popup menu */V globaldef Widget		uaf_r_entry_top_level_widget;			/* Entry window widget shell info */M globaldef Widget		uaf_r_entry_window_widget;			/* Entry window widget info */ L globaldef Widget		uaf_r_error_dialog_widget;			/* Error dialog box widget */U globaldef Display		*uaf_r_file_display;				/* Display id for file selection window */ V globaldef Widget		uaf_r_file_top_level_widget;			/* File selction widget shell info */N globaldef Widget		uaf_r_file_window_widget;			/* File selection widget info */K globaldef struct UAFLAG		uaf_r_flags;					/* Miscellaneous utility flags */ R globaldef Widget		uaf_r_id_popup_menu_widget;			/* Identifier window popup menu */W globaldef Widget		uaf_r_identifier_window_widget;			/* Identifier window widget info */ d globaldef struct FMTABL		uaf_r_item_table[UAI$_MAX_ITEM_CODE];		/* Entry window info format table */K globaldef Display		*uaf_r_main_display;				/* Display id for main window */ P globaldef Widget		uaf_r_main_shell_widget;			/* Main window widget shell info */T globaldef Widget		uaf_r_main_top_level_widget;			/* Main window widget shell info */K globaldef Widget		uaf_r_main_window_widget;			/* Main window widget info */ U globaldef MrmHierarchy		uaf_r_mrm_hierarchy;				/* Hierarchy info for .UID file(s) */ ] globaldef Widget		uaf_r_system_id_window_widget;			/* System identifier window widget info */ \ globaldef struct ITMDEF		(*uaf_r_template_info)[];			/* Modification template information */N globaldef Cursor		uaf_r_wait_cursor_entry;			/* Entry window wait cursor id */M globaldef Cursor		uaf_r_wait_cursor_main;				/* Main window wait cursor id */ ` globaldef Widget		uaf_r_widget_id_array[uaf$c_max_widget_code];	/* Array of Widget IDs in use */m globaldef char			uaf_t_current_groupname[sizeof uaf_r_group_list.uaf$t_usrlst_name];	/* Current group name */ i globaldef char			uaf_t_current_username[sizeof uaf_r_user_list.uaf$t_usrlst_name];	/* Current username */ M globaldef char			*uaf_t_default_filter = "*";			/* Default username filter */ U globaldef char			*uaf_t_default_username = "DEFAULT";		/* Default account username */ ` globaldef char			*uaf_t_no_date_time = "(none)";			/* String to use when no date/time present */l globaldef char			*uaf_t_pre_expired = "(pre-expired)";		/* String to use when no pwd chg dat/time present */v globaldef char			uaf_t_username_filter[sizeof uaf_r_user_list.uaf$t_usrlst_name];	/* Current username filter string */P globaldef unsigned short int	uaf_w_uai_context[2];				/* $xxxUAI context cell */  K globaldef struct ITMDEF		uaf_r_user_auth_info[] =			/* $xxxUAI item list */  				{ F 				 {sizeof uaf_t_usr_account,		UAI$_ACCOUNT,		uaf_t_usr_account,	0},A 				 {sizeof uaf_w_usr_astlm,		UAI$_ASTLM,		&uaf_w_usr_astlm,	0}, S 				 {sizeof uaf_b_batch_access_p,		UAI$_BATCH_ACCESS_P,	&uaf_b_batch_access_p,	0}, S 				 {sizeof uaf_b_batch_access_s,		UAI$_BATCH_ACCESS_S,	&uaf_b_batch_access_s,	0}, A 				 {sizeof uaf_w_usr_biolm,		UAI$_BIOLM,		&uaf_w_usr_biolm,	0}, A 				 {sizeof uaf_l_usr_bytlm,		UAI$_BYTLM,		&uaf_l_usr_bytlm,	0}, L 				 {sizeof uaf_t_usr_clitables,		UAI$_CLITABLES,		uaf_t_usr_clitables,	0},D 				 {sizeof uaf_l_usr_cputim,		UAI$_CPUTIM,		&uaf_l_usr_cputim,	0},I 				 {sizeof uaf_q_usr_def_priv,		UAI$_DEF_PRIV,		uaf_q_usr_def_priv,	0}, C 				 {sizeof uaf_t_usr_defcli,		UAI$_DEFCLI,		uaf_t_usr_defcli,	0}, C 				 {sizeof uaf_t_usr_defdev,		UAI$_DEFDEV,		uaf_t_usr_defdev,	0}, C 				 {sizeof uaf_t_usr_defdir,		UAI$_DEFDIR,		uaf_t_usr_defdir,	0}, G 				 {sizeof uaf_l_usr_dfwscnt,		UAI$_DFWSCNT,		&uaf_l_usr_dfwscnt,	0}, V 				 {sizeof uaf_b_dialup_access_p,		UAI$_DIALUP_ACCESS_P,	&uaf_b_dialup_access_p,	0},V 				 {sizeof uaf_b_dialup_access_s,		UAI$_DIALUP_ACCESS_S,	&uaf_b_dialup_access_s,	0},A 				 {sizeof uaf_w_usr_diolm,		UAI$_DIOLM,		&uaf_w_usr_diolm,	0}, A 				 {sizeof uaf_w_usr_enqlm,		UAI$_ENQLM,		&uaf_w_usr_enqlm,	0}, N 				 {sizeof uaf_q_usr_expiration,		UAI$_EXPIRATION,	uaf_q_usr_expiration,	0},A 				 {sizeof uaf_w_usr_fillm,		UAI$_FILLM,		&uaf_w_usr_fillm,	0}, A 				 {sizeof uaf_l_usr_flags,		UAI$_FLAGS,		&uaf_l_usr_flags,	0}, G 				 {sizeof uaf_l_usr_jtquota,		UAI$_JTQUOTA,		&uaf_l_usr_jtquota,	0}, Q 				 {sizeof uaf_q_usr_lastlogin_i,		UAI$_LASTLOGIN_I,	uaf_q_usr_lastlogin_i,	0}, Q 				 {sizeof uaf_q_usr_lastlogin_n,		UAI$_LASTLOGIN_N,	uaf_q_usr_lastlogin_n,	0}, C 				 {sizeof uaf_t_usr_lgicmd,		UAI$_LGICMD,		uaf_t_usr_lgicmd,	0}, S 				 {sizeof uaf_b_local_access_p,		UAI$_LOCAL_ACCESS_P,	&uaf_b_local_access_p,	0}, S 				 {sizeof uaf_b_local_access_s,		UAI$_LOCAL_ACCESS_S,	&uaf_b_local_access_s,	0}, J 				 {sizeof uaf_w_usr_logfails,		UAI$_LOGFAILS,		&uaf_w_usr_logfails,	0},R 				 {sizeof uaf_w_usr_maxacctjobs,		UAI$_MAXACCTJOBS,	&uaf_w_usr_maxacctjobs,	0},M 				 {sizeof uaf_w_usr_maxdetach,		UAI$_MAXDETACH,		&uaf_w_usr_maxdetach,	0}, G 				 {sizeof uaf_w_usr_maxjobs,		UAI$_MAXJOBS,		&uaf_w_usr_maxjobs,	0}, W 				 {sizeof uaf_b_network_access_p,	UAI$_NETWORK_ACCESS_P,	&uaf_b_network_access_p,0}, W 				 {sizeof uaf_b_network_access_s,	UAI$_NETWORK_ACCESS_S,	&uaf_b_network_access_s,0}, @ 				 {sizeof uaf_t_usr_owner,		UAI$_OWNER,		uaf_t_usr_owner,	0},D 				 {sizeof uaf_l_usr_pbytlm,		UAI$_PBYTLM,		&uaf_l_usr_pbytlm,	0},M 				 {sizeof uaf_l_usr_pgflquota,		UAI$_PGFLQUOTA,		&uaf_l_usr_pgflquota,	0}, D 				 {sizeof uaf_w_usr_prccnt,		UAI$_PRCCNT,		&uaf_w_usr_prccnt,	0},= 				 {sizeof uaf_b_usr_pri,			UAI$_PRI,		&uaf_b_usr_pri,		0}, M 				 {sizeof uaf_b_usr_primedays,		UAI$_PRIMEDAYS,		&uaf_b_usr_primedays,	0}, > 				 {sizeof uaf_q_usr_priv,		UAI$_PRIV,		uaf_q_usr_priv,		0},I 				 {sizeof uaf_q_usr_pwd_date,		UAI$_PWD_DATE,		uaf_q_usr_pwd_date,	0}, O 				 {sizeof uaf_b_usr_pwd_length,		UAI$_PWD_LENGTH,	&uaf_b_usr_pwd_length,	0}, S 				 {sizeof uaf_q_usr_pwd_lifetime,	UAI$_PWD_LIFETIME,	uaf_q_usr_pwd_lifetime,	0}, L 				 {sizeof uaf_q_usr_pwd2_date,		UAI$_PWD2_DATE,		uaf_q_usr_pwd2_date,	0},D 				 {sizeof uaf_b_usr_quepri,		UAI$_QUEPRI,		&uaf_b_usr_quepri,	0},V 				 {sizeof uaf_b_remote_access_p,		UAI$_REMOTE_ACCESS_P,	&uaf_b_remote_access_p,	0},V 				 {sizeof uaf_b_remote_access_s,		UAI$_REMOTE_ACCESS_S,	&uaf_b_remote_access_s,	0},J 				 {sizeof uaf_w_usr_shrfillm,		UAI$_SHRFILLM,		&uaf_w_usr_shrfillm,	0},A 				 {sizeof uaf_w_usr_tqcnt,		UAI$_TQCNT,		&uaf_w_usr_tqcnt,	0}, = 				 {sizeof uaf_l_usr_uic,			UAI$_UIC,		&uaf_l_usr_uic,		0}, I 				 {sizeof uaf_t_usr_username,		UAI$_USERNAME,		uaf_t_usr_username,	0}, J 				 {sizeof uaf_l_usr_wsextent,		UAI$_WSEXTENT,		&uaf_l_usr_wsextent,	0},G 				 {sizeof uaf_l_usr_wsquota,		UAI$_WSQUOTA,		&uaf_l_usr_wsquota,	0},    /* Terminate the item list. */   				 {0,				0,			0,			0} 				};  $ extern void AUTHORIZE$INIT_GLOBAL () {  /* **++ **  FUNCTIONAL DESCRIPTION:  **? **	This routine is called to initialize all the global storage.  ** **  FORMAL PARAMETERS: ** **	None  ** **  RETURN VALUE:  ** **      None ** **  SIDE EFFECTS:  ** **      None ** **-- */  $ /* Initialize the global strings. */  D memset (uaf_t_current_groupname, 0, sizeof uaf_t_current_groupname);B memset (uaf_t_current_username, 0, sizeof uaf_t_current_username);@ memset (uaf_t_username_filter, 0, sizeof uaf_t_username_filter);  % /* Initialize the widget ID array. */   @ memset (uaf_r_widget_id_array, 0, sizeof uaf_r_widget_id_array);  ' /* Initialize the dynamic item lists. /    uaf_r_current_group_info = 0;  uaf_r_current_user_info = 0;  ) /* Set up an empty template item list. */   J uaf_r_template_info = calloc (1, 4);				/* Just the longword terminator */  % /* Set up the $xxUAI context cell. */    uaf_w_uai_context[0] = -1; uaf_w_uai_context[1] = -1;  8 /* Initialize the master, group, and user list heads. */  K uaf_r_group_list.uaf$l_usrlst_flink = &uaf_r_group_list.uaf$l_usrlst_flink; K uaf_r_group_list.uaf$l_usrlst_blink = &uaf_r_group_list.uaf$l_usrlst_flink;T  M uaf_r_master_list.uaf$l_usrlst_flink = &uaf_r_master_list.uaf$l_usrlst_flink;iM uaf_r_master_list.uaf$l_usrlst_blink = &uaf_r_master_list.uaf$l_usrlst_flink;P  I uaf_r_user_list.uaf$l_usrlst_flink = &uaf_r_user_list.uaf$l_usrlst_flink;*I uaf_r_user_list.uaf$l_usrlst_blink = &uaf_r_user_list.uaf$l_usrlst_flink;m  L /* Initialize the item formatting table.  This is done at run time because IO ** do not know how to get C to set up the table at compile time (without havingt# ** to fill each entry in order). */	  R ITEM_ENTRY (UAI$_ACCOUNT,	uaf$c_entry_account,		MAX_ACCOUNT,	"",	ITEM_M_FLAG_ASC +! 											ITEM_M_FLAG_MAX,	' ');_R ITEM_ENTRY (UAI$_ASTLM,		uaf$c_entry_astlm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');R ITEM_ENTRY (UAI$_BIOLM,		uaf$c_entry_biolm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');U ITEM_ENTRY (UAI$_BYTLM,		uaf$c_entry_bytlm,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0'); W ITEM_ENTRY (UAI$_CLITABLES,	uaf$c_entry_clitable,		MAX_CLITABLE,	"",	ITEM_M_FLAG_CSTR + ! 											ITEM_M_FLAG_MAX,	' ');aP ITEM_ENTRY (UAI$_CPUTIM,	uaf$c_entry_cpu,		LONGWORD,	"",	ITEM_M_FLAG_SPC,	'\0');M ITEM_ENTRY (UAI$_DEFCLI,	uaf$c_entry_cli,		MAX_DEFCLI,	"",	ITEM_M_FLAG_CSTR +m! 											ITEM_M_FLAG_MAX,	' ');uA ITEM_ENTRY (UAI$_DEFDEV,	0,				MAX_DEFDEV,	"",	ITEM_M_FLAG_CSTR +T! 											ITEM_M_FLAG_MAX,	' ');sA ITEM_ENTRY (UAI$_DEFDIR,	0,				MAX_DEFDIR,	"",	ITEM_M_FLAG_CSTR + ! 											ITEM_M_FLAG_MAX,	' ');eV ITEM_ENTRY (UAI$_DFWSCNT,	uaf$c_entry_wsdef,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0');R ITEM_ENTRY (UAI$_DIOLM,		uaf$c_entry_diolm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');R ITEM_ENTRY (UAI$_ENQLM,		uaf$c_entry_enqlm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');[ ITEM_ENTRY (UAI$_EXPIRATION,	uaf$c_entry_expiration,		QUADWORD,	"",	ITEM_M_FLAG_DAT,	'\0');eR ITEM_ENTRY (UAI$_FILLM,		uaf$c_entry_fillm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');X ITEM_ENTRY (UAI$_JTQUOTA,	uaf$c_entry_jtquota,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0');\ ITEM_ENTRY (UAI$_LASTLOGIN_I,	uaf$c_entry_lastlogin_i,	QUADWORD,	"",	ITEM_M_FLAG_DAT,	'\0');\ ITEM_ENTRY (UAI$_LASTLOGIN_N,	uaf$c_entry_lastlogin_n,	QUADWORD,	"",	ITEM_M_FLAG_DAT,	'\0');P ITEM_ENTRY (UAI$_LGICMD,	uaf$c_entry_lgicmd,		MAX_LGICMD,	"",	ITEM_M_FLAG_CSTR +! 											ITEM_M_FLAG_MAX,	' ');_W ITEM_ENTRY (UAI$_LOGFAILS,	uaf$c_entry_logfails,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');	\ ITEM_ENTRY (UAI$_MAXACCTJOBS,	uaf$c_entry_maxacctjobs,	WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');Y ITEM_ENTRY (UAI$_MAXDETACH,	uaf$c_entry_maxdetach,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');_U ITEM_ENTRY (UAI$_MAXJOBS,	uaf$c_entry_maxjobs,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');sN ITEM_ENTRY (UAI$_OWNER,		uaf$c_entry_owner,		MAX_OWNER,	"",	ITEM_M_FLAG_CSTR +! 											ITEM_M_FLAG_MAX,	' ');$V ITEM_ENTRY (UAI$_PBYTLM,	uaf$c_entry_pbytlm,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0');Z ITEM_ENTRY (UAI$_PGFLQUOTA,	uaf$c_entry_pgflquo,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0');R ITEM_ENTRY (UAI$_PRCCNT,	uaf$c_entry_prclm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');O ITEM_ENTRY (UAI$_PRI,		uaf$c_entry_prio,		BYTE,		"!UB",	ITEM_M_FLAG_VAL,	'\0');DW ITEM_ENTRY (UAI$_PWD_DATE,	uaf$c_entry_pwd_date,		QUADWORD,	"",	ITEM_M_FLAG_DAT,	'\0');*[ ITEM_ENTRY (UAI$_PWD_LENGTH,	uaf$c_entry_pwd_length,		BYTE,		"!UB",	ITEM_M_FLAG_VAL,	'\0');t^ ITEM_ENTRY (UAI$_PWD_LIFETIME,	uaf$c_entry_pwd_lifetime,	QUADWORD,	"",	ITEM_M_FLAG_DAT,	'\0');Y ITEM_ENTRY (UAI$_PWD2_DATE,	uaf$c_entry_pwd2_date,		QUADWORD,	"",	ITEM_M_FLAG_DAT,	'\0');_T ITEM_ENTRY (UAI$_QUEPRI,	uaf$c_entry_queprio,		BYTE,		"!UB",	ITEM_M_FLAG_VAL,	'\0');W ITEM_ENTRY (UAI$_SHRFILLM,	uaf$c_entry_shrfillm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0'); R ITEM_ENTRY (UAI$_TQCNT,		uaf$c_entry_tqelm,		WORD,		"!UW",	ITEM_M_FLAG_VAL,	'\0');Q ITEM_ENTRY (UAI$_UIC,		uaf$c_entry_uic,		LONGWORD,	"!%U",	ITEM_M_FLAG_SPC,	'\0');RZ ITEM_ENTRY (UAI$_USERNAME,	uaf$c_entry_username,		MAX_USERNAME,	"",	ITEM_M_FLAG_ASC,	' ');Z ITEM_ENTRY (UAI$_WSEXTENT,	uaf$c_entry_wsextent,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0');V ITEM_ENTRY (UAI$_WSQUOTA,	uaf$c_entry_wsquo,		LONGWORD,	"!UL",	ITEM_M_FLAG_VAL,	'\0');  ) /* Other miscellaneous initialization. */;   uaf_l_current_group_max = 0; uaf_l_current_user_index = 0;; uaf_l_current_user_max = 0;t   }s