 #module UAF_MISC "X-3"   /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **= **		This module contains miscellaneous routines needed by the ! **		DECwindows AUTHORIZE utility.  **8 **  AUTHORS:	L. Mark Pilant		CREATION DATE:  12-Nov-1992 ** **  MODIFICATION HISTORY:  **/ **	X-3	LMP		L. Mark Pilant,		 8-OCT-1993  15:43 % **		Add AUTHORIZE$MATCH_NAME routine.  **/ **	X-2	LMP		L. Mark Pilant,		 2-MAR-1993  15:40 $ **		Convert to C from BLISS sources. **' **	X-1	LMP		L. Mark Pilant		12-Nov-1992  **		Original version.  ** **-- */   /* ** **  INCLUDE FILES  ** */   #include <SSDEF> #include <TPADEF>    #include "uaf_header"    /* ** **  FORWARD ROUTINES ** */  ( #pragma noinline (AUTHORIZE$CONVERT_UIC), #pragma noinline (AUTHORIZE$ITMLST_ADD_ITEM)+ #pragma noinline (AUTHORIZE$ITMLST_COMPARE) ( #pragma noinline (AUTHORIZE$ITMLST_COPY)* #pragma noinline (AUTHORIZE$ITMLST_DELETE)) #pragma noinline (AUTHORIZE$ITMLST_MERGE) * #pragma noinline (AUTHORIZE$ITMLST_UPDATE)' #pragma noinline (AUTHORIZE$MATCH_NAME)   A extern unsigned int AUTHORIZE$CONVERT_UIC (uic_string, uic_value)    char				*uic_string; unsigned int			*uic_value; {  /* **++ **  FUNCTIONAL DESCRIPTION:  **= **	This routine is called to convert a UIC string to a value.  ** **  FORMAL PARAMETERS: **) **	UIC_STRING	- Pointer to the UIC string = **	UIC_VALUE	- Address of a cell to contain the converted UIC  ** **  RETURN VALUE:  ** **	Status from LIB$TPARSE. ** **  SIDE EFFECTS:  ** **	None  ** **-- */   /* External routines. */  * #if defined (__ALPHA) || defined (__alpha) extern			LIB$TABLE_PARSE (); #else  extern			LIB$TPARSE (); 3 #endif /* defined (__ALPHA) || defined (__alpha) */    /* Global storage. */   A globalref unsigned int	converted_uic;			/* Converted UIC value */ < globalref unsigned char	uic_key[];			/* TPARSE key tables */@ globalref unsigned char	uic_state[];			/* TPARSE state tables */C globalref struct tpadef	tparse_block;			/* TPARSE argument block */    /* Local storage. */  2 unsigned int		status;				/* Routine exit status */    /* Initialize needed storage. */   converted_uic = 0;- status = SS$_NORMAL;					/* Assume success */   G /* In there is something to convert, do it.  Otherwise, simply skip the A ** following which will allow a zero UIC value to be returned. */    if (strlen (uic_string) != 0)      { 7     tparse_block.tpa$l_stringcnt = strlen (uic_string); .     tparse_block.tpa$l_stringptr = uic_string;  F /* On an OpenVMS/AXP system (and also OpenVMS/VAX Version 6) the parseI ** routine is called LIB$TABLE_PARSE.  On an OpenVMS/VAX system the parse D ** routine is called LIB$TPARSE.  Compile the appropriate source. */  * #if defined (__ALPHA) || defined (__alpha)A     status = LIB$TABLE_PARSE (&tparse_block, uic_state, uic_key);  #else <     status = LIB$TPARSE (&tparse_block, uic_state, uic_key);3 #endif /* defined (__ALPHA) || defined (__alpha) */      }   , /* Return the converted UIC if necessary. */  / if (uic_value != 0) *uic_value = converted_uic;    return status; }   L extern void AUTHORIZE$ITMLST_ADD_ITEM (itmlst, item_code, entry_size, entry)   struct ITMDEF			(**itmlst)[];  int				item_code;  int				entry_size; unsigned char			*entry;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **E **	This routine is called to add an entry to a dynamic item list.  To F **	do this, a buffer is allocated an the item list extended so the new2 **	entry may be added to the end of the item list. **C **	This routine assumes the buffer information is disjoint from the C **	actual item lust.  This allows just the item list to be freed up < **	without having to diddle with all the individual buffers. ** **  FORMAL PARAMETERS: **; **	ITMLST		- Address of a pointer containing the pointer to  **			  the dynamic item list4 **	ITEM_CODE	- Item code for the new item list entry; **	ENTRY_SIZE	- Number of bytes for the new item list entry < **	ENTRY		- Pointer to the buffer containing the information" **			  for the new item list entry ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	None  ** **-- */   /* External routines. */  ( extern void		AUTHORIZE$ITMLST_DELETE ();& extern void		AUTHORIZE$ITMLST_COPY ();   /* Local storage. */  > int			itmlst_size = 0;		/* Size of the item list to free up */3 int			itmlst_index = 0;		/* Index into item list */ B struct ITMDEF		(*new_itmlst)[] = 0;		/* New allocated item list */2 unsigned int		status;				/* Routine exit status */  H /* Copy the input item list, and request enough room to be added for the ** new item list entry. */   AUTHORIZE$ITMLST_COPY (*itmlst,  		       &new_itmlst,  		       itm$c_length);   ; /* Figure out where the current item list is terminated. */    if (*itmlst != 0)      { F     while ((**itmlst)[itmlst_index].itm$w_itmcod != 0) itmlst_index++;     }   F /* Allocate storage for the new item list entry buffer.  Also fill the. ** other parts of the new item list entry.  */  5 (*new_itmlst)[itmlst_index].itm$w_itmcod = item_code; 6 (*new_itmlst)[itmlst_index].itm$w_bufsiz = entry_size;? (*new_itmlst)[itmlst_index].itm$l_bufadr = malloc (entry_size);   I /* If the allocation fails, free up the memory allocated for the new item ( ** list, and signal a failure status. */  2 if ((*new_itmlst)[itmlst_index].itm$l_bufadr == 0)     { A     AUTHORIZE$ITMLST_DELETE (&new_itmlst);		/* Delete the copy */      free (new_itmlst);      LIB$SIGNAL (UAF$_NOPROCMEM);     return;      }   R /* Copy the information from the supplied buffer to the newly allocated buffer. */  F memmove ((*new_itmlst)[itmlst_index].itm$l_bufadr, entry, entry_size);  I /* Since the new item list is complete, delete the original item list. */   3 if (*itmlst != 0) AUTHORIZE$ITMLST_DELETE (itmlst);   , /* Return a pointer to the new item list. */   *itmlst = new_itmlst;  }   N extern void AUTHORIZE$ITMLST_COMPARE (first_itmlst, second_itmlst, itmlst_out)   struct ITMDEF			first_itmlst[];   struct ITMDEF			second_itmlst[];! struct ITMDEF			(**itmlst_out)[];  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **G **	This routine is called to compare two item lists and produce a third H **	item list with only the differences; using the first item list as the  **	source for the new item list. ** **  FORMAL PARAMETERS: **; **	FIRST_ITMLST	- Address of the first item list to compare = **	SECOND_ITMLST	- Address of the second item list to compare B **	ITMLST_OUT	- Address of a pointer containing the pointer to the **			  new item list ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	None  ** **-- */   /* External routines. */  * extern void		AUTHORIZE$ITMLST_ADD_ITEM ();& extern void		AUTHORIZE$ITMLST_COPY ();( extern void		AUTHORIZE$ITMLST_DELETE ();   /* Local storage. */  - short int		add_to_output;			/* Simple flag */ ; int			first_itmlst_index;		/* Index into first item list */ 8 struct ITMDEF		(*new_itmlst)[] = 0;		/* New item list */T struct ITMDEF		(*second_itmlst_copy)[] = 0;	/* Local copy of the second item list */= int			second_itmlst_index;		/* Index into second item list */ 2 unsigned int		status;				/* Routine exit status */  P /* Before starting, copy the second item list.  This will allow the item entriesQ ** to be flagged (by setting the item code to -1) as being processed.  This means R ** it is possible to transfer any remaining item entries from the second item list ** to the output item list. */  % AUTHORIZE$ITMLST_COPY (second_itmlst,  		       &second_itmlst_copy,  		       0);  I /* Compare the item list entries in each of the two input item lists, and M ** produce a third item list containing the differences (using the first item  ** list as the source).  **K ** Because there is no assumed order in either of the input item lists, the L ** comparison takes a little more time (but not a whole lot of effort).  TheL ** comparison is done by taking each item list entry from the first list (inJ ** turn) and checking to see if it exists in the ssecond item list.  If itN ** does not exist, or it exists and the data is different, add it to the third ** item list. */  ? /* Loop through each item list entry in the first item list. */   f for (first_itmlst_index = 0; first_itmlst[first_itmlst_index].itm$w_itmcod != 0; first_itmlst_index++)     { I     add_to_output = 1;				/* Assume entry will be added to output list */   @ /* Loop through each item list entry in the second item list. */  v     for (second_itmlst_index = 0; (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != 0; second_itmlst_index++) 	{  N /* Look for an item code match.  If the item codes match, check the item entry+ ** size and finally the buffer contents. */   n 	if (first_itmlst[first_itmlst_index].itm$w_itmcod == (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod) 	    {  . /* Flag this item entry as being processed. */  B 	    (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod = -1;  M /* If the buffer sizes do not match, trip out early since the buffer contents  ** cannot possibly match. */  y 	    if (first_itmlst[first_itmlst_index].itm$w_bufsiz != (*second_itmlst_copy)[second_itmlst_index].itm$w_bufsiz) break;   J /* Since the buffer sizes match, check the buffer contents.  If the bufferL ** contents match, do not add the item list entry to the third item list. */  ? 	    if (memcmp (first_itmlst[first_itmlst_index].itm$l_bufadr, ; 			(*second_itmlst_copy)[second_itmlst_index].itm$l_bufadr, 7 			first_itmlst[first_itmlst_index].itm$w_bufsiz) == 0) < 		add_to_output = 0;			/* Do not add entry to output list */  K /* Since the item codes from the two item list entries matched, there is no A ** need to continue on in the second item list.  Trip out now. */    	    break;  	    } 	}  O /* At this point, the second item list has been searched for the entry from the R ** first item list.  Either a match has been found, a similar entry with different8 ** data has been found, or the entry has not been found. **O ** If the entry has not been found or it is different, add it to the third item  ** list. */        if (add_to_output != 0) ( 	AUTHORIZE$ITMLST_ADD_ITEM (&new_itmlst,5 				   first_itmlst[first_itmlst_index].itm$w_itmcod, 5 				   first_itmlst[first_itmlst_index].itm$w_bufsiz, 6 				   first_itmlst[first_itmlst_index].itm$l_bufadr);     }   L /* Since the entire first item list has been processed, scan through all theN ** entries of the second item list looking for any item entries not processed.0 ** These are then added to the output item list. **M ** Note the USERNAME item entry is not copied, if it is present.  This is not I ** done because $SETUAI does not know to ignore it; and will return a bad . ** parameter error status if it is present. */  r for (second_itmlst_index = 0; (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != 0; second_itmlst_index++)     { L     if ((*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != 0xffff &&J 	(*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != UAI$_USERNAME) 	{( 	AUTHORIZE$ITMLST_ADD_ITEM (&new_itmlst,? 				   (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod, ? 				   (*second_itmlst_copy)[second_itmlst_index].itm$w_bufsiz, @ 				   (*second_itmlst_copy)[second_itmlst_index].itm$l_bufadr); 	}     }   2 /* Now delete the copy of the second item list. */  . AUTHORIZE$ITMLST_DELETE (&second_itmlst_copy);  D /* If there is an existing dynamic (output) item list, delete it. */  ; if (*itmlst_out != 0) AUTHORIZE$ITMLST_DELETE (itmlst_out);   I /* If no new item list was created, because the item lists were the same,  ** create a null item list. */   if (new_itmlst == 0)     { R     new_itmlst = calloc (1, LONGWORD);		/* Single longword item list terminator */5     if (new_itmlst == 0) LIB$SIGNAL (UAF$_NOPROCMEM);      }   . /* Return the address of the new item list. */   *itmlst_out = new_itmlst;  }   J extern void AUTHORIZE$ITMLST_COPY (itmlst_in, itmlst_out, additional_size)   struct ITMDEF			itmlst_in[];! struct ITMDEF			(**itmlst_out)[];  int				additional_size;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **K **	This routine is called to copy an item list.  This is done by allocating H **	a new item listand needed buffers and then copying the information in **	the original buffers. ** **  FORMAL PARAMETERS: **/ **	ITMLST_IN	- Address of the item list to copy B **	ITMLST_OUT	- Address of a pointer containing the pointer to the **			  new item listK **	ADDITIONAL_SIZE	- Number of additional bytes to add to the new item list  ** **  RETURN VALUE:  ** **	None  ** **  SIDE EFFECTS:  ** **	None  ** **-- */   /* External routines. */  ' extern void	AUTHORIZE$ITMLST_DELETE ();    /* Local storage. */  6 int		itmlst_size = 0;		/* Size of item list to copy */2 int		itmlst_index = 0;		/* Index into item list */= struct ITMDEF	(*new_itmlst)[];		/* New allocated item list */ 1 unsigned int	status;				/* Routine exit status */   D /* Special case when there is no input item list.  In this case, theE ** output item list will be created with the terminator (item code 0) - ** as the only thing in the new item list. */    if (itmlst_in == 0)      { ;     itmlst_size = 4;						/* For the terminator longword */ N     itmlst_size += additional_size;				/* Any additional space as requested */  ) /* Allocate and clear a new item list. */   )     new_itmlst = calloc (1, itmlst_size); 5     if (new_itmlst == 0) LIB$SIGNAL (UAF$_NOPROCMEM);   D /* If there is an existing dynamic (output) item list, delete it. */  ?     if (*itmlst_out != 0) AUTHORIZE$ITMLST_DELETE (itmlst_out);   . /* Return the address of the new item list. */       *itmlst_out = new_itmlst;    /* Exit stage left. */       return;      }   0 /* Figure out how big the input item list is. */  Q for (itmlst_index = 0; itmlst_in[itmlst_index].itm$w_itmcod != 0; itmlst_index++)       itmlst_size += itm$c_length;A itmlst_size += 4;						/* Account for the terminator longword. */   F /* If there is a need for additional bytes to be added to the new item0 ** list, add in the required number of bytes. */   itmlst_size += additional_size;   I /* Allocate the main body of the new item list.  This is done with calloc E ** instead of malloc because any additional space must be cleared. */   % new_itmlst = calloc (1, itmlst_size); 1 if (new_itmlst == 0) LIB$SIGNAL (UAF$_NOPROCMEM);   * /* Copy the main body of the item list. */  ? memmove (new_itmlst, itmlst_in, itmlst_size - additional_size);   H /* Now look at each item list entry, and copy the buffer information. */  6 itmlst_index = 0;						/* Reset the item list index */  Q for (itmlst_index = 0; itmlst_in[itmlst_index].itm$w_itmcod != 0; itmlst_index++)      {   K /* If the buffer size of the item list entry is zero, simply set the buffer H ** address to be that of the item list entry.  This avoids any potentialJ ** problems with bufer address validation; even through the buffer size is ** zero. */   2     if (itmlst_in[itmlst_index].itm$w_bufsiz == 0)I 	(*new_itmlst)[itmlst_index].itm$l_bufadr = &(*new_itmlst)[itmlst_index];      else 	{  = /* Othersize, allocate a new buffer and copy the contents. */   Z 	(*new_itmlst)[itmlst_index].itm$l_bufadr = malloc (itmlst_in[itmlst_index].itm$w_bufsiz);  I /* If the allocation fails, run through the new item list and free up any J ** memory allocated to buffers.  These buffers can be identified by havingI ** an address that is not the item list entry address and is not the same J ** as the input item list entry buffer address.  In the former case, thereI ** is nothing to deallocate, and in the latter case, a new buffer has not M ** yet been allocated (which also means the list processing can terminate. */   3 	if ((*new_itmlst)[itmlst_index].itm$l_bufadr == 0)  	    {V 	    for (itmlst_index = 0; itmlst_in[itmlst_index].itm$w_itmcod != 0; itmlst_index++) 		{   H /* If the buffer address in the input and output item lists is the same, ** list processing can stop. */   - 		if (itmlst_in[itmlst_index].itm$l_bufadr == 6 		    (*new_itmlst)[itmlst_index].itm$l_bufadr) break;  - /* See if there is anything to deallocate. */   1 		if ((*new_itmlst)[itmlst_index].itm$l_bufadr != T 		    &(*new_itmlst)[itmlst_index]) free ((*new_itmlst)[itmlst_index].itm$l_bufadr);   		}-  4 /* Deallocate the main body of the new item list. */   	    free (new_itmlst);U   /* Signal a failure status. */  ! 	    LIB$SIGNAL (UAF$_NOPROCMEM);e 	    }  ) /* Copy the actual buffer information. */   Y 	memmove ((*new_itmlst)[itmlst_index].itm$l_bufadr, itmlst_in[itmlst_index].itm$l_bufadr, 0 							   itmlst_in[itmlst_index].itm$w_bufsiz); 	}     }H  D /* If there is an existing dynamic (output) item list, delete it. */  ; if (*itmlst_out != 0) AUTHORIZE$ITMLST_DELETE (itmlst_out);	  . /* Return the address of the new item list. */   *itmlst_out = new_itmlst;* }N D, extern void AUTHORIZE$ITMLST_DELETE (itmlst)   struct ITMDEF			(**itmlst)[];r {  /* **++ **  FUNCTIONAL DESCRIPTION:  **G **	This routine is called free up a dynamic item list.  This is done byTG **	first traversing the item list, freeing up the memory for any of thee6 **	buffers.  Then the actual item list is deallocated. ** **  FORMAL PARAMETERS: **? **	ITMLST		- Address of a pointer containing the pointer to theT **			  item list to delete ** **  RETURN VALUE:x ** **	None  ** **  SIDE EFFECTS:I **$ **	The item list pointer is cleared. ** **-- */   /* Local storage. */  / int		itmlst_index;			/* Index into item list */T    /* Initialize needed storage. */   itmlst_index = 0;   J /* If there is an item list to delete, do it.  Otherwise simply return. */   if (*itmlst != 0)s     {eV     for (itmlst_index = 0; (**itmlst)[itmlst_index].itm$w_itmcod != 0; itmlst_index++) 	{  - /* See if there is anything to deallocate. */   ^ 	if ((**itmlst)[itmlst_index].itm$l_bufadr != 0) free ((**itmlst)[itmlst_index].itm$l_bufadr); 	}  4 /* Deallocate the main body of the new item list. */       free (*itmlst);l  - /* Note there is now no dynamic item list. */n       *itmlst = 0;     }	 }C eL extern void AUTHORIZE$ITMLST_MERGE (first_itmlst, second_itmlst, itmlst_out)   struct ITMDEF			first_itmlst[];t  struct ITMDEF			second_itmlst[];! struct ITMDEF			(**itmlst_out)[];k {	 /* **++ **  FUNCTIONAL DESCRIPTION:l **J **	This routine is called to merge two item lists and produce a third itemM **	list containing all the entries from the first item list and those entriese@ **	from the second item list not present in the first item list. ** **  FORMAL PARAMETERS: **; **	FIRST_ITMLST	- Address of the first item list to compare = **	SECOND_ITMLST	- Address of the second item list to comparesB **	ITMLST_OUT	- Address of a pointer containing the pointer to the **			  new item list ** **  RETURN VALUE:a ** **	NoneM ** **  SIDE EFFECTS:r ** **	Nonee ** **-- */   /* External routines. */  * extern void		AUTHORIZE$ITMLST_ADD_ITEM ();& extern void		AUTHORIZE$ITMLST_COPY ();( extern void		AUTHORIZE$ITMLST_DELETE ();   /* Local storage. */  R struct ITMDEF		(*first_itmlst_copy)[] = 0;	/* Local copy of the first item list */; int			first_itmlst_index;		/* Index into first item list */AT struct ITMDEF		(*second_itmlst_copy)[] = 0;	/* Local copy of the second item list */= int			second_itmlst_index;		/* Index into second item list */s  I /* Before starting, copy the item lists.  This will allow a new item listrG ** to be built using the first item list as a starting point.   It will	D ** also allow the item entries in the (copied) second itemlist to beK ** flagged (by setting the item code to -1) as being processed.  This meanseH ** it is possible to transfer any remaining item entries from the second% ** item list to the new item list. */e    $ AUTHORIZE$ITMLST_COPY (first_itmlst, 		       &first_itmlst_copy, 		       0);% AUTHORIZE$ITMLST_COPY (second_itmlst,a 		       &second_itmlst_copy,f 		       0);  K /* Compare the item list entries in each of the two input item lists.  FlagTF ** those common entries (in the second item list) to avoid using them.K ** After both lists have been processed, take the unflagged entries and adde ** them to the new list. **N ** Note: The process of traversing these lists is fairly brute force; an innerO ** loop (to traverse the second list entries) within an outer loop (to traverse*= ** the first list entries).  This does add a bit of overhead.  **O ** A more elegant solution would be to have a three phase approach in the outerAN ** loop.  The first phase (pass) would find the maximum item code seen for allN ** entries in the first item list.  This would allow an appropaitely sized bitL ** stream to be created.  The second phase (pass) would set a bit in the bitN ** stream (corresponding to the item code) indicating the item code was in useO ** in the first item list.  The third phase (third and successive passes) wouldHM ** simply have to check to see if the bit corresponding to the item code from K ** the second item list was set in the bit stream.  If it is, the item list A ** entry is present in the first item list and should be ignored.  **O ** In addition to having the first two phases size and populate the bit stream, M ** it would be possible to flag the item list entries in the second item list[0 ** at the same time; so no effort was wasted. */  ? /* Loop through each item list entry in the first item list. */t  n for (first_itmlst_index = 0; (*first_itmlst_copy)[first_itmlst_index].itm$w_itmcod != 0; first_itmlst_index++)     {   @ /* Loop through each item list entry in the second item list. */  v     for (second_itmlst_index = 0; (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != 0; second_itmlst_index++) 	{  N /* Look for an item code match.  If the item codes match, check the item entry+ ** size and finally the buffer contents. */o  v 	if ((*first_itmlst_copy)[first_itmlst_index].itm$w_itmcod == (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod) 	    {  . /* Flag this item entry as being processed. */  B 	    (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod = -1;  K /* Since the item codes from the two item list entries matched, there is no$A ** need to continue on in the second item list.  Trip out now. */I   	    break;t 	    } 	}     }M  L /* Since the entire first item list has been processed, scan through all theN ** entries of the second item list looking for any item entries not processed.- ** These are then added to the new item list.e **M ** Note the USERNAME item entry is not copied, if it is present.  This is not*I ** done because $SETUAI does not know to ignore it; and will return a badi. ** parameter error status if it is present. */  r for (second_itmlst_index = 0; (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != 0; second_itmlst_index++)     { L     if ((*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != 0xffff &&J 	(*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod != UAI$_USERNAME) 	{/ 	AUTHORIZE$ITMLST_ADD_ITEM (&first_itmlst_copy,v? 				   (*second_itmlst_copy)[second_itmlst_index].itm$w_itmcod, ? 				   (*second_itmlst_copy)[second_itmlst_index].itm$w_bufsiz,x@ 				   (*second_itmlst_copy)[second_itmlst_index].itm$l_bufadr); 	}     }   2 /* Now delete the copy of the second item list. */  . AUTHORIZE$ITMLST_DELETE (&second_itmlst_copy);  D /* If there is an existing dynamic (output) item list, delete it. */  ; if (*itmlst_out != 0) AUTHORIZE$ITMLST_DELETE (itmlst_out);g  . /* Return the address of the new item list. */    *itmlst_out = first_itmlst_copy; }i tJ extern void AUTHORIZE$ITMLST_UPDATE (itmlst, item_code, entry_size, entry)   struct ITMDEF			(**itmlst)[];s int				item_code;e int				entry_size; unsigned char			*entry;H {Z /* **++ **  FUNCTIONAL DESCRIPTION:  **D **	This routine is called to update an entry in a dynamic item list.J **	If an entry with the specified item code already exists, it is replacedJ **	with the information supplied (to this routine).  If it does not exist,  **	it is added to the item list. ** **  FORMAL PARAMETERS: **; **	ITMLST		- Address of a pointer containing the pointer to  **			  the dynamic item list4 **	ITEM_CODE	- Item code for the new item list entry; **	ENTRY_SIZE	- Number of bytes for the new item list entryt< **	ENTRY		- Pointer to the buffer containing the information" **			  for the new item list entry ** **  RETURN VALUE:e ** **	None  ** **  SIDE EFFECTS:e ** **	Nonei ** **-- */   /* External routines. */  ) extern void	AUTHORIZE$ITMLST_ADD_ITEM ();d   /* Local storage. */  / int		itmlst_index;			/* Index into item list */;1 unsigned int	status;				/* Routine exit status */     /* Initialize needed storage. */  . itmlst_index = 0;						/* Set initial index */  A /* Traverse the item list looking for the specified item code. */i  ' for (itmlst_index = 0;; itmlst_index++)*     {o  N /* If the end of the item list is reached, the entry did not exist.  Add a new1 ** entry to the end of the existing item list. */s  3     if ((**itmlst)[itmlst_index].itm$w_itmcod == 0)o 	{B 	AUTHORIZE$ITMLST_ADD_ITEM (itmlst, item_code, entry_size, entry); 	return; 	}  S /* If an entry was found with the specified item code, trip out of the loop now. */I  B     if ((**itmlst)[itmlst_index].itm$w_itmcod == item_code) break;     }*  P /* At this point, the index is pointing to the entry with the desired item code.M ** deallocate the existing buffer, if any, allocate a new buffer and copy theeO ** supplied information.  If the allocation failes, signal a failure status. */a  t if ((**itmlst)[itmlst_index].itm$l_bufadr != 0) free ((**itmlst)[itmlst_index].itm$l_bufadr);	/* Free up original */U (**itmlst)[itmlst_index].itm$l_bufadr = malloc (entry_size);					/* Allocate a new */se if ((**itmlst)[itmlst_index].itm$l_bufadr == 0) LIB$SIGNAL (UAF$_NOPROCMEM);			/* Abort on failure *//Z memmove ((**itmlst)[itmlst_index].itm$l_bufadr, entry, entry_size);				/* Move contents */K (**itmlst)[itmlst_index].itm$w_bufsiz = entry_size;						/* Set new size */  }   m extern unsigned int AUTHORIZE$MATCH_NAME (candidate_length, candidate_string, pattern_length, pattern_string)   % unsigned short int		candidate_length;i char				*candidate_string;# unsigned short int		pattern_length;o char				*pattern_string; {  /* **++ **  FUNCTIONAL DESCRIPTION:i **I **	This routine is a jacket for STR$MATCH_WILD.  Originally, this utilityIM **	used FMG$MATCH_NAME, but that was not generally available.  STR$MATCH_WILDcI **	does the same thing but the interface is much more cumbersome in C, soiM **	I am using this jacket routine to make things a little easier and cleaner.t ** **  FORMAL PARAMETERS: **= **	CANDIDATE_LENGTH	- Number of bytes in the candidate stringr: **	CANDIDATE_STRING	- Pointer to the candidate string text: **	PATTERN_LENGTH		- Number of bytes in the pattern string7 **	PATTERN_STRING		- Pointer to the pattern string texte ** **  RETURN VALUE:k ** **	Status from STR$MATCH_WILD  ** **  SIDE EFFECTS:r ** **	None  ** **-- */   /* Local storage. */  A int		candidate_desc[2];		/* Simple candidate string descriptor */0= int		pattern_desc[2];		/* Simple pattern string descriptor */[    /* Initialize needed storage. */  % candidate_desc[0] = candidate_length;_% candidate_desc[1] = candidate_string;N! pattern_desc[0] = pattern_length;M! pattern_desc[1] = pattern_string;l  # /* Return the comparison status. */c  5 return STR$MATCH_WILD (candidate_desc, pattern_desc);t }_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        