 #module UAF_XXXUAI "X-1"   /* **++6 **  FACILITY:	Authorization record maintenance utility ** **  MODULE DESCRIPTION:  **< **		This routine contains the routines needed to support the3 **		creation and deletion of authorization records.  **7 **  AUTHORS:	L. Mark Pilant		CREATION DATE:	12-Oct-1993  ** **  MODIFICATION HISTORY:  ** ** **-- */   /* ** **  INCLUDE FILES  ** */   #include	<PSLDEF>    #include	descrip #include	fab #include	rab #include	rmsdef  #include	string    #include	"uaf_header"    #pragma noinline (OPEN_UAF)  #pragma noinline (SYS$CREUAI)  #pragma noinline (SYS$DELUAI)   F /* Define the macro used to insure the authorization file is closed as: ** necessary prior to returning an error to the caller. */  * #define		RETURN_ERROR(_error_code)							\ 		    {										\; 		    if (close_file != 0) sys$close (&local_uaf_fab);				\ " 		    return _error_code;								\ 		    }										\    unsigned int OPEN_UAF (ifi, isi)   unsigned short int		*ifi;  unsigned short int		*isi;  {  /* **++ **  FUNCTIONAL DESCRIPTION:  **C **	This routine is calles to open the system authorization file for @ **	use by the $CREUAI and $DELUAI routines.  (This parallels the" **	code in [LOADSS]SYSUAISRV.B32.) ** **  FORMAL PARAMETERS: **: **	IFI		- Address of a cell to contain the IFI of the file: **	ISI		- Address of a cell to contain the ISI of the file ** **  RETURN VALUE:  ** **	Status of the RMS $OPEN.  ** **  SIDE EFFECTS:  ** **	None  ** **-- */   /* Global references. */  V globalref char			*default_sysuaf_file_name;	/* Authorization file default file name */V globalref char			*default_sysuaf_file_type;	/* Authorization file default file type */R globalref char			*default_sysuaf_file_spec;	/* Authorization filed default spec */   /* Local storage. */  2 unsigned int		status;				/* Routine exit status */3 struct FAB		uaf_fab;			/* Authorization file FAB */ 3 struct RAB		uaf_rab;			/* Authorization file RAB */   K /* Clear out the IFI and ISI arguments to indicate nothing was accessed. */   	 *ifi = 0; 	 *isi = 0;   T /* Initialize the RMS data structures needed to open the user authorization file. */  & /* Authorization File Access Block. */  3 uaf_fab = cc$rms_fab;			/* Prototype information */ B uaf_fab.fab$b_fac = FAB$M_GET | FAB$M_PUT | FAB$M_DEL | FAB$M_UPD;B uaf_fab.fab$b_shr = FAB$M_GET | FAB$M_PUT | FAB$M_DEL | FAB$M_UPD;  C /* If the SYSUAF_LOGICAL symbol is defined, set up the FAB to allow D ** the authorization file to be accessed via the appropriate logicalC ** name.  Otherwise, set up the FAB to allow the authorization file 3 ** to be accessed via a full file specification. */    #ifdef	SYSUAF_LOGICAL M     uaf_fab.fab$l_fna = default_sysuaf_file_name;		/* For the logical name */ :     uaf_fab.fab$b_fns = strlen (default_sysuaf_file_name);1     uaf_fab.fab$l_dna = default_sysuaf_file_type; :     uaf_fab.fab$b_dns = strlen (default_sysuaf_file_type);  E /* Since it is possible for the authorization file to be access via a D ** logical name, insure only exec mode logical name translations areE ** allowed.  This also means the $xxxUAI routines in this module will H ** open the file in the same way as the $GETUAI and $SETUAI services. */  (     uaf_fab.fab$v_lnm_mode = PSL$C_EXEC; #else H     uaf_fab.fab$l_fna = default_sysuaf_file_spec;		/* For a file spec */:     uaf_fab.fab$b_fns = strlen (default_sysuaf_file_spec); #endif	/* SYSUAF_LOGICAL */   - /* Authorization file Record Access Block. */   3 uaf_rab = cc$rms_rab;			/* Prototype information */  uaf_rab.rab$l_fab = &uaf_fab;  uaf_rab.rab$b_rac = RAB$C_KEY; uaf_rab.rab$l_rop = RAB$M_WAT;  9 /* Open the authorization file, and return any errors. */   # CHECK_RETURN (SYS$OPEN (&uaf_fab));   ; /* Connect up a record stream to the authorization file. */   & CHECK_RETURN (SYS$CONNECT (&uaf_rab));  ? /* Since the file was successfully opened, save the RMS IFI and  ** ISI for later. */   *ifi = uaf_fab.fab$w_ifi;  *isi = uaf_rab.rab$w_isi;    return SS$_NORMAL; }   W extern unsigned int SYS$CREUAI (null1, context, user_name, itmlst, null3, null4, null5)    unsigned int			null1; ! unsigned short int		(*context)[]; " struct dsc$descriptor		*user_name; struct ITMDEF			(*itmlst)[]; unsigned int			null3;  unsigned int			null4;  unsigned int			null5;  {  /* ** FUNCTIONAL DESCRIPTION: **  = **	This routine is used to create a user authorization entry.  ** **					NOTE  **A **	This routine is not expected to be used outside the DECwindows B **	Authorize utility environment.  As such, it does not do the allD **	the necessary argument probing to be secure.  Although this could **	be added at a later time. ** **					NOTE  **   ** FORMAL PARAMETERS:  **   **	NULL1:		Unused parameter ) **	CONTEXT:	Address of a context longword 0 **	USER_NAME:	Address of the username descriptor1 **	ITMLST:		Address of a list of item descriptors  **	NULL3:		Unused parameter  **	NULL4:		Unused parameter  **	NULL5:		Unused parameter  **   **   ** RETURN VALUE: **  % **	1 if the record successfully added < **	error code otherwise (various RMS and system error codes) **   ** SIDE EFFECTS: **   **	None  ** **-- */   /* Global references. */  U globalref struct ITMTABDEF	uai_itm_tab[];			/* $xxxUAI item code information table */    /* Local storage. */  A unsigned short int		close_file;			/* Set to close file on exit */ G unsigned char			encrypt_algorithm;		/* Password encryption algorithm */ 5 unsigned int			hashed_pwd[2];			/* Hashed password */ $ int				index;				/* General index */8 short int			item_code;			/* Item list entry item code */> short int			item_size;			/* Item list entry item entry size */E unsigned char			*item_addr;			/* Item list entry item info pointer */ @ struct FAB			local_uaf_fab;			/* Local authorization file FAB */@ struct RAB			local_uaf_rab;			/* Local authorization file RAB */: char				local_username[MAX_USERNAME];	/* Local username */L struct dsc$descriptor		local_username_desc;		/* Local username descriptor */G struct dsc$descriptor		password_desc;			/* Local password descriptor */ 3 unsigned int			status;				/* Routine exit status */ B short int			uaf_field_size;			/* Size of UAF field (from table) */2 unsigned short int		uaf_ifi;			/* UAF (RMS) IFI */2 unsigned short int		uaf_isi;			/* UAF (RMS) ISI */I struct UAFDEF			uaf_record;			/* Storage for authorization file record */ J unsigned char			*uaf_record_byte_stream;	/* UAF record as a byte stream */6 char				*username_text;			/* Supplied username text */   /* Initialize needed storage */   * memset (hashed_pwd, 0, sizeof hashed_pwd);= memset (&local_username_desc, 0, sizeof local_username_desc); 1 memset (&password_desc, 0, sizeof password_desc);    close_file = -1;
 uaf_ifi = -1; 
 uaf_isi = -1;   P /* Copy the supplied username to local storage, blank filling in the process. */   if (user_name != 0)      { -     username_text = user_name->dsc$a_pointer;   H /* Convert each character in the username string to upper case and blank< ** fill any unused portion of the local username storage. */  ;     for (index = 0; index < sizeof local_username; ++index)  	{& 	if (index >= user_name->dsc$w_length)! 	    local_username[index] = ' ';  	else < 	    local_username[index] = toupper (username_text[index]); 	}     }  else return SS$_INSFARG;  9 local_username_desc.dsc$w_length = sizeof local_username; 3 local_username_desc.dsc$a_pointer = local_username;   2 /* If a context parameter was supplied, get it. */   if (context != 0)      {      uaf_ifi = (*context)[0];     uaf_isi = (*context)[1];     }   M /* If the UAF has not already been opened, as indicated by a -1 value for the L ** UAF IFI, attempt to open it now.  This is done without privileges (at theL ** moment) to allow normal file accessing protection processing to apply. */   if (uaf_ifi == 0xFFFF)0     CHECK_RETURN (OPEN_UAF (&uaf_ifi, &uaf_isi)); else close_file = 0;				/* Note file is not to be closed */   M /* Since the authorization file is now known to be open, fabricate the needed K ** RMS data structured to allow the authorization records to be created. */   1 memset (&local_uaf_fab, 0, sizeof local_uaf_fab); 1 memset (&local_uaf_rab, 0, sizeof local_uaf_rab);   $ local_uaf_fab.fab$b_bid = FAB$C_BID;$ local_uaf_fab.fab$b_bid = FAB$C_BID;$ local_uaf_fab.fab$b_bln = FAB$C_BLN;" local_uaf_fab.fab$w_ifi = uaf_ifi;  $ local_uaf_rab.rab$b_bid = RAB$C_BID;$ local_uaf_rab.rab$b_bln = RAB$C_BLN;" local_uaf_rab.rab$w_isi = uaf_isi;$ local_uaf_rab.rab$b_rac = RAB$C_KEY;  5 /* Clear out the authorization record being built. */   + memset (&uaf_record, 0, sizeof uaf_record);   ; /* Set up the version and record type in the new record. */   * uaf_record.UAF$B_VERSION = UAF$C_VERSION1;' uaf_record.UAF$B_RTYPE = UAF$C_USER_ID;   = /* Move over the username to the new authorization record. */   X memmove (uaf_record.UAF$r_fill_0.UAF$T_USERNAME, local_username, sizeof local_username);  Q /* Fill in the information in the local authorization record from the information   ** supplied in the item list. */  < for (index = 0; (*itmlst)[index].itm$w_itmcod != 0; ++index)     {   L /* Get the necessary information for the current item from the item list. */  .     item_code = (*itmlst)[index].itm$w_itmcod;.     item_size = (*itmlst)[index].itm$w_bufsiz;.     item_addr = (*itmlst)[index].itm$l_bufadr;  ) /* Range check the item code supplied. */   W     if (item_code <= 0 || item_code >= UAI$_MAX_ITEM_CODE) RETURN_ERROR (SS$_BADPARAM);   / /* Validate the size of the item list entry. */   W     if ((TRUE ((uai_itm_tab)[item_code].uaf$r_fill_0.uaf$r_fill_1.uaf$v_itm_flg_var) && = 	 item_size > (uai_itm_tab)[item_code].uaf$w_itm_ent_size) || Q 	(FALSE ((uai_itm_tab)[item_code].uaf$r_fill_0.uaf$r_fill_1.uaf$v_itm_flg_var) && < 	 item_size != (uai_itm_tab)[item_code].uaf$w_itm_ent_size)) 	RETURN_ERROR (SS$_BADPARAM);   M /* Note how big the field in the authorization record is.  In the usual case, M ** this is used with the (above) FILL to copy the information supplied by the  ** caller in the item list. */  ?     uaf_field_size = uai_itm_tab[item_code].uaf$w_itm_ent_size;   7 /* If a plaintext password is specified, encrypt it. */   F     if ((item_code == UAI$_PASSWORD) || (item_code == UAI$_PASSWORD2)) 	{  M /* It is worth noting that the cleartext password will be encrypted using the P ** current algorithm if the UAF$B_ENCRYPTx field has not been set in the record.L ** This means the algorithm and encryption fields are order sensitive in the ** supplied item list. */   7 /* Set the appropriate password encyption algorithm. */     	if (item_code == UAI$_PASSWORD)3 	     encrypt_algorithm = uaf_record.UAF$B_ENCRYPT; 4 	else encrypt_algorithm = uaf_record.UAF$B_ENCRYPT2;  K /* If the encryption algorithm code is within the reserved to Digital range P ** but is not the latest, upgrade it.  Also note the change in the authorization
 ** record. */     1 	if (encrypt_algorithm < UAF$C_CURRENT_ALGORITHM)  	    {1 	    encrypt_algorithm = UAF$C_CURRENT_ALGORITHM; R 	    if (item_code == UAI$_PASSWORD)			/* Choose primary or secondary algorithm */0 		 uaf_record.UAF$B_ENCRYPT = encrypt_algorithm;8 	    else uaf_record.UAF$B_ENCRYPT2 = encrypt_algorithm; 	    }  5 /* If there is a non-null password given, hash it. */    	if (item_size > 0)  	    {, 	    password_desc.dsc$w_length = item_size;- 	    password_desc.dsc$a_pointer = item_addr; 0 	    status = SYS$HASH_PASSWORD (&password_desc, 					encrypt_algorithm,  					uaf_record.UAF$W_SALT,  					&local_username_desc, 					hashed_pwd); / 	    if (FALSE (status)) RETURN_ERROR (status); $ 	    if (item_code == UAI$_PASSWORD)f 		 memmove (&uaf_record.UAF$r_fill_4.UAF$Q_PWD, hashed_pwd, sizeof uaf_record.UAF$r_fill_4.UAF$Q_PWD);U 	    else memmove (&uaf_record.UAF$Q_PWD2, hashed_pwd, sizeof uaf_record.UAF$Q_PWD2);  	    }  L /* Since the plaintext password has been hashed, modify the item informationF ** to point to the internal storage (for this routine) rather than the ** caller supplied storage. */   	item_addr = hashed_pwd; 	item_size = sizeof hashed_pwd; ; 	uaf_field_size = uai_itm_tab[UAI$_PWD].uaf$w_itm_ent_size;   3 /* Mark the appropriate password as pre-expired. */   ? /*	if ((item_code == UAI$_PWD) || (item_code == UAI$_PASSWORD)) X **	    memset (local_uaf_record.UAF$Q_PWD_DATE, 0xff, sizeof uaf_record.UAF$Q_PWD_DATE);B **	if ((.item_code == UAI$_PWD2) || (item_code == UAI$_PASSWORD2))Z **	    memset (local_uaf_record.UAF$Q_PWD2_DATE, 0xff, sizeof uaf_record.UAF$Q_PWD2_DATE); */ 	}  L /* Copy the supplied information to the authorization record currently being ** built, if necessary. */  W     if (FALSE ((uai_itm_tab)[item_code].uaf$r_fill_0.uaf$r_fill_1.uaf$v_itm_flg_nop) &&  	uaf_field_size != 0)  	{  N /* Make the UAF record available as a byte stream for the offsets from the UAIO ** item table.  This could be done with casting, but copying pointers around is 
 ** easier. */   & 	uaf_record_byte_stream = &uaf_record;  P /* Preset with the fill character if necessary.  Since the buffer is set to zeroQ ** to begin with, it is only necessary to fill if the fill character is something  ** other than zero. */  T 	if (TRUE ((uai_itm_tab)[item_code].uaf$r_fill_0.uaf$r_fill_1.uaf$v_itm_flg_spfill))f 	    memset (&uaf_record_byte_stream[uai_itm_tab[item_code].uaf$w_itm_ent_base], ' ', uaf_field_size);  # /* Move the supplied information */   d 	memmove (&uaf_record_byte_stream[uai_itm_tab[item_code].uaf$w_itm_ent_base], item_addr, item_size); 	}     }   Q /* Now that all the information has been added to the authorization record, write ' ** it out to the authorization file. */   & local_uaf_rab.rab$w_rsz = UAF$C_FIXED;& local_uaf_rab.rab$l_rbf = &uaf_record;" status = SYS$PUT (&local_uaf_rab);> SYS$RELEASE (&local_uaf_rab);				/* Release for future use. */  N /* Since the operation has been completed successfully, see if it is necessary  ** to return the RMS context. */   if (context != 0)      {      (*context)[0] = uaf_ifi;     (*context)[1] = uaf_isi;     }   Q /* Return with the status from the $PUT.  Using the macro will insure the file is   ** closed if it is necessary. */   RETURN_ERROR (status); }   W extern unsigned int SYS$DELUAI (null1, context, user_name, itmlst, null3, null4, null5)    unsigned int			null1; ! unsigned short int		(*context)[]; " struct dsc$descriptor		*user_name; struct ITMDEF			(*itmlst)[]; unsigned int			null3;  unsigned int			null4;  unsigned int			null5;  {  /* ** FUNCTIONAL DESCRIPTION: **  I **	This routine is used to delete a user authorization entry.  If an item G **	list is supplied, a call to $GETUAI is done prior to the deletion to 1 **	allow the existing information to be returned.  ** **					NOTE  **A **	This routine is not expected to be used outside the DECwindows D **	the necessary argument probing to be secure.  Although this could **	be added at a later time. ** **					NOTE  **   ** FORMAL PARAMETERS:  **   **	NULL1:		Unused parameter ) **	CONTEXT:	Address of a context longword 0 **	USER_NAME:	Address of the username descriptorB **	ITMLST:		Address of a list of item descriptors (to be returned) **	NULL3:		Unused parameter  **	NULL4:		Unused parameter  **	NULL5:		Unused parameter  **   ** RETURN VALUE: **  % **	1 if the record successfully added < **	error code otherwise (various RMS and system error codes) **   ** SIDE EFFECTS: **   **	None  **   */   /* Local storage. */  A unsigned short int		close_file;			/* Set to close file on exit */ $ int				index;				/* General index */F unsigned short int		local_context[2];		/* Local copy of UAI context */@ struct FAB			local_uaf_fab;			/* Local authorization file FAB */@ struct RAB			local_uaf_rab;			/* Local authorization file RAB */: char				local_username[MAX_USERNAME];	/* Local username */L struct dsc$descriptor		local_username_desc;		/* Local username descriptor */3 unsigned int			status;				/* Routine exit status */ 2 unsigned short int		uaf_ifi;			/* UAF (RMS) IFI */2 unsigned short int		uaf_isi;			/* UAF (RMS) ISI */6 char				*username_text;			/* Supplied username text */   /* Initialize needed storage */   = memset (&local_username_desc, 0, sizeof local_username_desc);    close_file = -1;
 uaf_ifi = -1; 
 uaf_isi = -1;d  P /* Copy the supplied username to local storage, blank filling in the process. */   if (user_name != 0)S     {N-     username_text = user_name->dsc$a_pointer;n  H /* Convert each character in the username string to upper case and blank< ** fill any unused portion of the local username storage. */  ;     for (index = 0; index < sizeof local_username; ++index)  	{& 	if (index >= user_name->dsc$w_length)! 	    local_username[index] = ' ';  	elsee< 	    local_username[index] = toupper (username_text[index]); 	}     }a else return SS$_INSFARG;  9 local_username_desc.dsc$w_length = sizeof local_username; 3 local_username_desc.dsc$a_pointer = local_username;i  2 /* If a context parameter was supplied, get it. */   if (context != 0)r     {      uaf_ifi = (*context)[0];     uaf_isi = (*context)[1];     }   M /* If the UAF has not already been opened, as indicated by a -1 value for theeL ** UAF IFI, attempt to open it now.  This is done without privileges (at theL ** moment) to allow normal file accessing protection processing to apply. */   if (uaf_ifi == 0xFFFF)0     CHECK_RETURN (OPEN_UAF (&uaf_ifi, &uaf_isi)); else close_file = 0;				/* Note file is not to be closed */h  M /* Since the authorization file is now known to be open, fabricate the needed K ** RMS data structured to allow the authorization records to be created. */r  1 memset (&local_uaf_fab, 0, sizeof local_uaf_fab); 1 memset (&local_uaf_rab, 0, sizeof local_uaf_rab);*  $ local_uaf_fab.fab$b_bid = FAB$C_BID;$ local_uaf_fab.fab$b_bid = FAB$C_BID;$ local_uaf_fab.fab$b_bln = FAB$C_BLN;" local_uaf_fab.fab$w_ifi = uaf_ifi;  $ local_uaf_rab.rab$b_bid = RAB$C_BID;$ local_uaf_rab.rab$b_bln = RAB$C_BLN;" local_uaf_rab.rab$w_isi = uaf_isi;$ local_uaf_rab.rab$b_rac = RAB$C_KEY;  L /* If an item list is supplied, call $GETUAI to get the existing infomation.0 ** Otherwise locate the record to be deleted. */   if (itmlst != 0)     {e  E /* Make sure the context information is in a form $GETUAI can use. */r       local_context[0] = uaf_ifi;n     local_context[1] = uaf_isi;   $ /* Get the information requested. */       status = SYS$GETUAI (NULL, #ifdef NONSHARED_UAI_CONTEXT	 			 NULL,  #elseo 			 &local_context,B" #endif /* NONSHARED_UAI_CONTEXT */ 			 &local_username_desc,  			 itmlst,$	 			 NULL,$	 			 NULL,$
 			 NULL);  ) /* If the $GETUAI fails, bail out now. */_  .     if (FALSE (status)) RETURN_ERROR (status);     }U  K /* If the record position has not been set (or kept) by $GETUAI, it will belN ** necessary to set the record position using $FIND.  The following situations ** require an explicit $FIND:l **H **  1)	On a Version 5.x system, the context parameter is not used in theE **	call to $GETUAI, thus the record position is not known outside thei **	call to $GETUAI._ **J **  2)	On a Version 6.x system where an item list has not been supplied to **	this routine. **K ** In other words, if this is a Version 5.x system do the $FIND regardless;sH ** if this is a Verison 6.x system only do the $FIND if no item list was ** supplied. */    #ifndef NONSHARED_UAI_CONTEXTe if (itmlst == 0)     {m" #endif /* NONSHARED_UAI_CONTEXT */  @     local_uaf_rab.rab$l_kbf = local_username_desc.dsc$a_pointer;?     local_uaf_rab.rab$b_ksz = local_username_desc.dsc$w_length;s  '     status = SYS$FIND (&local_uaf_rab);f.     if (FALSE (status)) RETURN_ERROR (status);   #ifndef NONSHARED_UAI_CONTEXTf     }c" #endif /* NONSHARED_UAI_CONTEXT */  C /* Now that the record position has been set, delete the record. */	  % status = SYS$DELETE (&local_uaf_rab);a  N /* Since the operation has been completed successfully, see if it is necessary  ** to return the RMS context. */   if (context != 0)r     {      (*context)[0] = uaf_ifi;     (*context)[1] = uaf_isi;     }s  L /* Return with the status from the $DELETE.  Using the macro will insure the( ** file is closed if it is necessary. */   RETURN_ERROR (status); }I