 /*H  ***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *H  ***********************************************************************  */    #include "iufingerd.h"   USER_HASH_TABLE *userHashTable;  HOST_HASH_TABLE *hostHashTable;     I /************************************************************************   * Function:  *     InitCaches   *  * Description: 4  *     Initializes the username and hostname caches.  *
  * Arguments: 8  *     userTableSize -	desired username hash table size.8  *     hostTableSize -	desired hostname hash table size.  *  * Returns: *  *     True -   if caches were initialized  *     False -  if it was not J  ************************************************************************/4 int InitCaches(int userTableSize, int hostTableSize) { 7   if (debugFlag) SystemLog("creating user hash table"); 5   userHashTable = CreateUserHashTable(userTableSize);     if (rfc931Flag || resolveFlag)   { E     /* Create the host table only if resolving and/or doing rfc931 */ 9     if (debugFlag) SystemLog("creating host hash table"); 7     hostHashTable = CreateHostHashTable(hostTableSize); 5     return(userHashTable != ((USER_HASH_TABLE *)0) && - 	   hostHashTable != ((HOST_HASH_TABLE *)0));    }    else   { 2     return(userHashTable != (USER_HASH_TABLE *)0);   }  }     I /************************************************************************   * Function:  *     CacheUser  *  * Description: -  *     Cache a username's UAI data in memory.   *  * Returns: 3  *     True -   if the name is successfully cached. 0  *     False -  if it's not successfully cached.J  ************************************************************************/1 int CacheUser(struct user_cache_entry *userEntry)  {    USER_HASH_ENTRY *entry;   3   entry = UserHashInsert(userEntry, userHashTable); (   return(entry != (USER_HASH_ENTRY *)0); }     I /************************************************************************   * Function:  *     CacheHost  *  * Description: 3  *     Cache's a remote host's FQDN data in memory.   *  * Returns: 3  *     True -   if the name is successfully cached. 0  *     False -  if it's not successfully cached.J  ************************************************************************/1 int CacheHost(struct host_cache_entry *hostEntry)  {    HOST_HASH_ENTRY *entry;   3   entry = HostHashInsert(hostEntry, hostHashTable); (   return(entry != (HOST_HASH_ENTRY *)0); }     I /************************************************************************   * Function:  *     UserCached   *  * Description: B  *     Checks to see if a username's UAI data is cached in memory.  *  * Returns: &  *     True -   if the name is cached.#  *     False -  if it's not cached. J  ************************************************************************/2 int UserCached(struct user_cache_entry *userEntry) {    int retval = FALSE;    USER_HASH_ENTRY *entry;   1   entry = UserHashFind(userEntry, userHashTable);    if (entry)   {      retval = TRUE;K     memcpy(userEntry, &entry->cacheEntry, sizeof(struct user_cache_entry));    }    return(retval);  }     I /************************************************************************   * Function:  *     HostCached   *  * Description: F  *     Checks to see if a remote host's FQDN data is cached in memory.  *
  * Arguments: I  *     ipaddr   - pointer to applicable IP address in network byte order. F  *     hostName - field to copy remote host FQDN into, if it's cached.  *  * Returns: )  *     True -   if the address is cached. #  *     False -  if it's not cached. J  ************************************************************************/2 int HostCached(struct host_cache_entry *hostEntry) {    int retval = FALSE;    HOST_HASH_ENTRY *entry;   1   entry = HostHashFind(hostEntry, hostHashTable);    if (entry)   {      retval = TRUE;K     memcpy(hostEntry, &entry->cacheEntry, sizeof(struct host_cache_entry));    }    return(retval);  }     I /************************************************************************   * Function:  *     PurgeCaches  *  * Description: ?  *     Purge old entries from the username and hostname caches.   *
  * Arguments: M  *     userTimeToLive -	maximum time-to-live for username hash table entries. M  *     hostTimeToLive -	maximum time-to-live for hostname hash table entries.   *  * Returns:   *     Nothing. J  ************************************************************************/8 void PurgeCaches(int userTimeToLive, int hostTimeToLive) { -   if (debugFlag) SystemLog("purging caches");   F   if ((userTimeToLive > 0) && (userHashTable != (USER_HASH_TABLE *)0))6     PurgeUserHashTable(userTimeToLive, userHashTable);   else if (debugFlag) +     SystemLog("skipping user cache purge");   F   if ((hostTimeToLive > 0) && (hostHashTable != (HOST_HASH_TABLE *)0))6     PurgeHostHashTable(hostTimeToLive, hostHashTable);   else if (debugFlag) +     SystemLog("skipping host cache purge");  } 