H /***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *H  ***********************************************************************  *
  * Module:6  *     jpi.c - routines related to jobs and processes.  *  * Description: 7  *     This module contains routine related to jobs and $  *     processes on the vms machine.  *  * Routines:&  *     FixRemote   - fix remote string(  *     GetJpi      - get JPI information'  *     LoggedIn    - is user logged in?   *J  ************************************************************************/  I /************************************************************************ 
  * #include's J  ************************************************************************/ #include "iufingerd.h"    I /************************************************************************   * Function:)  *     FixRemote - fix the remote string.   *  * Description: >  *     This routine fixes the "remote" (login from) string by:&  *         1) Removes trailing spaces.4  *         2) Removes port number from ip addresses.  *
  * Arguments: $  *     string - the "remote" string.  *  * Returns:   *     Nothing. J  ************************************************************************/ void FixRemote(char *remote) {    int     dotCount = 0;    char   *front, *back;    char    tmpBuffer[256];      strcpy(tmpBuffer, remote);   front = tmpBuffer;  
 #ifdef UCX  ,   /* "Host: aaa.bbb.ccc.ddd     Port ppp" */2   if (strncmp("Host: ", front, 6) == 0) front +=6;   if (!isdigit(*front)) return;    back = front;    while (*back)    {      if (isspace(*back))      {        *back = '\0';        break;     }      back++;    }   
 #elif WINS     /* "aaa.bbb.ccc.ddd.ppp" */    if (!isdigit(*front)) return;    back = front;    while (*back)    {      if (*back == '.')      {        if (++dotCount == 4)       {          *back = '\0';          break;       }      }      back++;    }    #elif MULTINET     /* "[aaa.bbb.ccc.ddd]" */    if (*front != '[') return;
   front++;#   back = front + strlen(front) - 1;    *back = '\0';    #else /* TCPWARE */      /* "(aaa.bbb.ccc.ddd)" */    if (*front != '(') return;
   front++;#   back = front + strlen(front) - 1;    *back = '\0';    #endif     strcpy(remote, front); }     I /************************************************************************   * Function:
  *     GetJpi   *  * Description: #  *     Get job process infomration.   *
  * Arguments:   *     pid - process ID   *     job - jpi data structure   *  * Returns: &  *     Return code from sys$getjpiw().J  ************************************************************************/) int GetJpi(int *pid, struct jpiData *job)  {  #ifndef JPI$_TT_ACCPORNAM  #define JPI$_TT_ACCPORNAM 813  #endif   int  status;   char *tmp;   struct item_list outlist[] =   { F     { sizeof(job->username),  JPI$_USERNAME,     job->username,   0 },F     { sizeof(job->terminal),  JPI$_TERMINAL,     job->terminal,   0 },F     { sizeof(job->image),     JPI$_IMAGNAME,     job->image,      0 },F     { sizeof(job->remote),    JPI$_TT_ACCPORNAM, job->remote,     0 },F     { sizeof(job->loginTime), JPI$_LOGINTIM,     job->loginTime,  0 },F     { sizeof(job->pid),       JPI$_PID,          &job->pid,       0 },F     { sizeof(job->masterPid), JPI$_MASTER_PID,   &job->masterPid, 0 },F     { sizeof(job->type),      JPI$_JOBTYPE,      &job->type,      0 },F     { sizeof(job->mode),      JPI$_MODE,         &job->mode,      0 },F     { sizeof(job->procName),  JPI$_PRCNAM,       &job->procName,  0 },     { 0, 0, 0, 0 },    };  4   status = sys$getjpiw(0, pid, 0, outlist, 0, 0, 0);   if (!VmsError(status))   {      char *s;  #     /* trim spaces from username */ )     if (tmp = strchr(job->username, ' '))        *tmp = '\0';  %     /* zap garbage in process name */ &     for (s = job->procName;  *s;  s++)        if (iscntrl(*s)) *s = '.';       /* fix the remote */     if (!*job->remote)     { /       if (strncmp(job->terminal, "OP", 2) == 0) +         strcpy(job->remote, "VAX console");      }      else     {        FixRemote(job->remote);        if (resolveFlag)       { *         struct host_cache_entry hostEntry;5         hostEntry.IPaddress = inet_addr(job->remote); +         if ((int)hostEntry.IPaddress != -1) 	         { &           if (!HostCached(&hostEntry))           { C             ResolveRemote(hostEntry.IPaddress, hostEntry.hostName); 2             hostEntry.rfc931Status = RFC931_MAYBE;"             CacheHost(&hostEntry);           } 2           strcpy(job->remote, hostEntry.hostName);	         }        }      }   N     /* fix the image name from "sys$somedisk:[somewhere]some.exe" to "some" */     TrimImage(job->image);       /* fix the login time */     switch (timeFormat)      {        case TIME_TEXT: <         WayCoolTime(job->loginTime, job->numericTimeString);         break;       default:<         NumericTime(job->loginTime, job->numericTimeString);         break;     }   0     VmsTime(job->loginTime, job->vmsTimeString);,     sprintf(job->pidString, "%X", job->pid);   }    return(status);  }     I /************************************************************************   * Function:$  *     LoggedIn - is user logged in?  *  * Description: 7  *     This routine returns prints some information and 9  *     returns true if a user is logged in; otherwise, it   *     returns false.   *
  * Arguments:   *  * Returns: <  *     TRUE  -  if user is logged on (and it printed stuff).  *     FALSE -  otherwise.J  ************************************************************************/( int LoggedIn(struct user_data *userData) {    long status;   long pid = -1;   int  loggedIn = FALSE;   int  working = TRUE;   int  onCount = 0;    struct jpiData job;   !   /*** scan the process list ***/ -   while (working  && (onCount < MAX_ONSINCE))    {       status = GetJpi(&pid, &job);     switch(status)     {        case SS$_NORMAL::         if (strcmp(job.username, userData->username) == 0)	         { *           if ((job.type != JPI$K_BATCH) &&-               (job.type != JPI$K_DETACHED) && +               (job.pid == job.masterPid) && .               (job.mode == JPI$K_INTERACTIVE))           {              loggedIn = TRUE;             if (loginFlag) 	      if (*job.remote) I                 sprintf(userData->onSince[onCount++], "%s on %s from %s", ?                   job.vmsTimeString, job.terminal, job.remote);  	      else A                 sprintf(userData->onSince[onCount++], "%s on %s", 3                   job.vmsTimeString, job.terminal);            } 	         }          break;         case SS$_SUSPENDED:          break;         case SS$_NOMOREPROC:         working = FALSE;         break;         default:         working = FALSE;?         SystemLog("sys$getjpiw error: %s", VmsMessage(status));          break;     }    }    return(loggedIn);  } 