H /***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *H  ***********************************************************************  *
  * Module:  *     main.c - main module.  *  * Description:   *     The main module.   *  * Routines:4  *     AppMainLoop - all the real stuff starts here.2  *     main -        entry point into the program.  *H  ***********************************************************************  *  * Program History:   *-  *     Revision 3.0 93/10/22  hughes & harvey I  *     Nearly a complete rewrite.  Create a QIO-driven asynchronous event D  *     loop, to fix the bug that caused server to hang in V2.x.  AddH  *     support for all CLD command line options and associated features.  *%  *     Revision 2.1  93/02/16  hughes @  *     Set keepalive on socket to try to avoid hanging on brokenA  *     connections, say "No plan." when there is none, plus a few   *     other minor changes.   *%  *     Revision 2.0  92/11/25  hughes B  *     Major changes to optimize performance.  Highlights:  betterC  *     logging facility, caching of usernames and home directories, A  *     calling hoggy sys$getuai() only when absolutely necessary.   *1  *     Revision 1.4  92/09/22  15:48:06  cfraizer 2  *     Modified main() to work as a -real- server.  *1  *     Revision 1.3  92/09/22  15:21:45  cfraizer   *     Added AppMainLoop().   *1  *     Revision 1.2  92/09/17  14:49:04  cfraizer   *     Miscellaneous changes.   *1  *     Revision 1.1  92/09/15  21:39:22  cfraizer   *     Initial revision   *J  ************************************************************************/  I /************************************************************************ 
  * #include's J  ************************************************************************/ #include "iufingerd.h" #include "version.h"  
 #ifdef UCX #include <ucx$inetdef.h> #else  #include <sys/ioctl.h> #endif  I /************************************************************************   * global variables J  ************************************************************************/   int attnState;   struct IOSB connectIosb;   int portNumber;    struct client_data clientData; struct user_data   userData; struct jpiInfo     jpiConfig;    int userCacheSize; int userCacheTtl;    int hostCacheSize; int hostCacheTtl;    time_t lastPurgeTime;    int debugFlag;
 int sortFlag;  int sortPosition; 
 int sortSize;    int rfc931Flag;  int rfc931Timeout;   int headerFlag;  int systatFlag; 
 int planFlag;  int projectFlag;
 int mailFlag;  int resolveFlag; int homeDirFlag; int loginFlag;   int purgeInterval;   int timeFormat;   6 char planNames[MAX_PLAN_NAMES+1][MAX_PLAN_FILENAME+1];9 char projectNames[MAX_PLAN_NAMES+1][MAX_PLAN_FILENAME+1];   I /************************************************************************   * Function:4  *     AppMainLoop - all the real stuff starts here.  *  * Description: F  *     This routine just loops, and dispatches work to the appropriate  *     routines.  *
  * Arguments: 2  *     sd -        the socket on which to operate.  *  * Returns:   *     Never returns. J  ************************************************************************/ void AppMainLoop(int sd) {    int serving;
   int status; 
   time_t now;      sys$setast(0);#   serving = IssueNewConnectQio(sd);    sys$setast(1);     while (serving)    {      status = sys$hiber();      if (VmsError(status))      { 5       SystemLog("sys$hiber: %s", VmsMessage(status));        serving = FALSE;       break;     }        switch (attnState)     {        case ATTN_CONNECT:1         if (debugFlag) SystemLog("ATTN_CONNECT"); 4         memset(&userData,   '\0', sizeof(userData));6         memset(&clientData, '\0', sizeof(clientData));5         if (NetworkAcceptConnection(sd, &clientData)) 	         {            IssueReadDataQio();             IssueReadTimeoutQio();	         }          else           serving = FALSE;         break;         case ATTN_TIMEOUT:1         if (debugFlag) SystemLog("ATTN_TIMEOUT"); /         SystemLog("timeout waiting for input"); ,         NetworkCloseConnection(&clientData);)         serving = IssueNewConnectQio(sd);          break;         case ATTN_DISCONNECT: 4         if (debugFlag) SystemLog("ATTN_DISCONNECT");         CancelReadTimeoutQio(); ,         NetworkCloseConnection(&clientData);)         serving = IssueNewConnectQio(sd);          break;         case ATTN_DATA: .         if (debugFlag) SystemLog("ATTN_DATA");%         if (!clientData.readComplete)            IssueReadDataQio();          else	         { !           CancelReadTimeoutQio();            ProcessRequest(); .           NetworkCloseConnection(&clientData);           time(&now); >           if (((int)now - (int)lastPurgeTime) > purgeInterval)           { 4             PurgeCaches(userCacheTtl, hostCacheTtl);              lastPurgeTime = now;           } +           serving = IssueNewConnectQio(sd); 	         }          break;         default:6         SystemLog("invalid attnState: %d", attnState);         serving = FALSE;         break;     }    } 
   nclose(sd);  }     I /************************************************************************   * Function:  *     ProcessRequest   *  * Description: '  *     Process a client finger request.   *
  * Arguments:   *     None.    * Returns:   *     Nothing. J  ************************************************************************/ ProcessRequest() {    int fuip; 
   int status;    static int one = 1;    static char unsupported[] = =       "%IUFINGERD-F-UNSUPPORTED, unsupported query type\r\n";   8   if (debugFlag) SystemLog("entering ProcessRequest()");  ,   /* first, set socket to non-blocked I/O */;   status = ioctl(clientData.socket, FIONBIO, (long *)&one); 9   if (status == -1) SystemLog("error: ioctl: %d", errno);   ,   /* second, make the size something sane */1   if (strlen(clientData.request) > SIZE_USERNAME) -     clientData.request[SIZE_USERNAME] = '\0';   4   Tokenize(clientData.request, clientData.username);$   fuip = FType(clientData.username);   switch(fuip)   {      case FUIP_Q1: "       UpCase(clientData.username);G       if (debugFlag) SystemLog("query user '%s'", clientData.username); 5       strcpy(userData.username, clientData.username); 1       FSingleQuery(clientData.socket, &userData);        break;       case FUIP_C:-       if (debugFlag) SystemLog("query list"); $       FListQuery(clientData.socket);       break;       case FUIP_CLOSED: +       if (debugFlag) SystemLog("no query");        break;       case FUIP_TIMEOUT:/       if (debugFlag) SystemLog("read timeout");        break;       case FUIP_Q2:      case FUIP_Q1W:     default:7       SystemLog("unsupported query, fuip == %d", fuip); B       nwrite(clientData.socket, unsupported, strlen(unsupported));       break;   }   7   if (debugFlag) SystemLog("exiting ProcessRequest()");  }     I /************************************************************************   * Function:+  *     main - entry point into the program.   *  * Description: >  *     This routien contains the entry point into the program.  *
  * Arguments: !  *     argc -   argument counter.    *     argv -   argument vector.  *  * Returns:   *     Nothing. J  ************************************************************************/  int main(int argc, char *argv[]) { 	   int sd;   '   bzero(&jpiConfig, sizeof(jpiConfig));      ProcessArgs();  6   SystemLog("IUFINGERD version %s starting", VERSION);  +   InitCaches(userCacheSize, hostCacheSize);    time(&lastPurgeTime);   +   if ((sd = NetworkOpen(portNumber)) != -1)      AppMainLoop(sd); } 