H /***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *I  ************************************************************************   *
  * Module:/  *     net.c - routines related to the network.   *  * Description: 6  *     This module contains information related to the  *     network.   *  * Routines:/  *     NetworkOpen             - open a socket. =  *     NetworkAcceptConnection - accept a network connection. <  *     NetworkCloseConnection  - close a network connection.<  *     NetworkConnectAst       - new connection AST handler.F  *     ResolveRemote           - resolve an IP address to a host name.  *J  ************************************************************************/  I /************************************************************************ 
  * #include's J  ************************************************************************/ #include "iufingerd.h"    I /************************************************************************   * Function:=  *     NetworkAcceptConnection - accept a network connection.   *  * Description: 5  *     This routine accepts a connection on a socket.   *
  * Arguments: 8  *     sd -    the socket descriptor on which to accept.  *  * Returns:   *     A new socket.J  ************************************************************************/C int NetworkAcceptConnection(int sd, struct client_data *clientData)  {    int mySocket;    int retval = FALSE; 
   int status; 0   int clientLength = sizeof(struct sockaddr_in);   static int one = 1; 0   static int socketBufferSize = 32768; /* 32K */  C   clientData->socket = accept(sd, &clientData->sin, &clientLength);     if (clientData->socket == -1) *     SystemLog("error: accept: %d", errno);   else   {        if (rfc931Flag)      {        char   *remoteUser;        u_long remoteAddress;   H       memcpy(&remoteAddress, &clientData->sin.sin_addr, sizeof(u_long));0       remoteUser = RemoteUsername(remoteAddress,B                      ntohs(clientData->sin.sin_port), portNumber);:       if (remoteUser == (char *)0) remoteUser = "unknown";&       SystemLog("request from %s %s", 5                 inet_ntoa(clientData->sin.sin_addr),                   remoteUser);     }      else     { I       SystemLog("request from %s", inet_ntoa(clientData->sin.sin_addr));       }   
 #ifdef UCX;     clientData->channel = vaxc$get_sdc(clientData->socket); ' #else /* WINS || MULTINET || TCPWARE */ -     clientData->channel = clientData->socket; 
 #endif UCX       /* set keepalive */ F     status = setsockopt(clientData->socket, SOL_SOCKET, SO_KEEPALIVE, +                 (char *)&one, sizeof(one)); K     if (status == -1) SystemLog("error: setsockopt(keepalive): %d", errno);         /* set socket buffer size */B     status = setsockopt(clientData->socket, SOL_SOCKET, SO_SNDBUF,D                (char *)&socketBufferSize, sizeof(socketBufferSize));L     if (status == -1) SystemLog("error: setsockopt(buffersize): %d", errno);       retval = TRUE;    }   return(retval);  }   I /************************************************************************   * Function:  *     NetworkCloseConnection J  ************************************************************************/; void NetworkCloseConnection(struct client_data *clientData)  { )   (void) sys$cancel(clientData->channel);    nclose(clientData->socket);  }   I /************************************************************************   * Function:5  *     NetworkConnectAst - New connection AST handler J  ************************************************************************/ void NetworkConnectAst() { #   if (VmsError(connectIosb.status)) I     SystemLog("error: connect iosb: %s", VmsMessage(connectIosb.status));    attnState = ATTN_CONNECT;    sys$wake(0, 0);  }   I /************************************************************************   * Function:#  *     NetworkOpen - open a socket.   *  * Description: ?  *     This routine opens a socket and starts the ball rolling,   *     so to speak.   *
  * Arguments: +  *     portNum -    the port number to use.   *  * Returns: ,  *      -1 if error, or a socket descriptor.J  ************************************************************************/' int NetworkOpen(unsigned short portNum)  {    int mySocket;    int myStatus; #   struct sockaddr_in serverAddress;    -   mySocket = socket(AF_INET, SOCK_STREAM, 0);    if (mySocket == -1) *     SystemLog("error: socket: %d", errno);   else   { 6     bzero(&serverAddress, sizeof(struct sockaddr_in));3     serverAddress.sin_family =             AF_INET; =     serverAddress.sin_addr.s_addr =        htonl(INADDR_ANY); :     serverAddress.sin_port =               htons(portNum);@     myStatus = bind(mySocket, (struct sockaddr *)&serverAddress,       sizeof(serverAddress));      if (myStatus == -1)      { *       SystemLog("error: bind: %d", errno);       nclose(mySocket);        mySocket = -1;     }      else     { -       myStatus = listen(mySocket, SOMAXCONN);        if (myStatus == -1)        { .         SystemLog("error: listen: %d", errno);         nclose(mySocket);          mySocket = -1;       }      }    }    return(mySocket);  }   I /************************************************************************   * Function:  *     ResolveRemote  *  * Description: H  *     This routine resolves remote name as IP address to FQDN hostname.  *
  * Arguments: 6  *     IPaddress  - the remote address to be resolved.L  *     remoteName - location to store resolved name (or ascii representation.  *                  of dotted decimal address.  *  * Returns: .  *     TRUE  - name was resolved successfully.2  *     FALSE - name was NOT resolved successfully.J  ************************************************************************/5 int ResolveRemote(u_long IPaddress, char *remoteName)  {    struct hostent *hp;   J   hp = gethostbyaddr((char *)&IPaddress, sizeof(struct in_addr), AF_INET);    if (hp != (struct hostent *)0)   { #     strcpy(remoteName, hp->h_name);      return(TRUE);    }    else   { -     strcpy(remoteName, inet_ntoa(IPaddress));      return(FALSE);   }  } 