H /***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *H  ***********************************************************************  *
  * Module:'  *     qio.c - routines related to QIOs   *  * Routines:  *     CancelReadTimeoutQio   *     IssueNewConnectQio   *     IssueReadDataQio   *     IssueReadTimeoutQio  *     ReadAst  *     ReadTimeoutAst   *J  ************************************************************************/   #include "iufingerd.h"  I /************************************************************************   * Function:  *     CancelReadTimeoutQio   *  * Description: -  *     Cancels the timer on the network read.   *
  * Arguments:   *     None.  *  * Returns:   *     Nothing. J  ************************************************************************/ void CancelReadTimeoutQio()  { 
   int status;   5   if (debugFlag) SystemLog("CancelReadTimeoutQio()");    status = sys$cantim(0, 0);   if (VmsError(status)) 4     SystemLog("sys$cantim: %s", VmsMessage(status)); };  I /************************************************************************   * Function:  *     IssueNewConnectQio   *  * Description: I  *     Issues the asynchronous QIO for the notification of a new connect.   *
  * Arguments: %  *     sd - network socket descriptor   *  * Returns: +  *     TRUE if successful, FALSE if failed. J  ************************************************************************/ int IssueNewConnectQio(int sd) { 
   int status;   3   if (debugFlag) SystemLog("IssueNewConnectQio()"); 
 #ifdef UCX1   status = sys$qio(0, (unsigned)vaxc$get_sdc(sd), B                   IO$_SETMODE | IO$M_READATTN, &connectIosb, 0, 0,5                   &NetworkConnectAst, 0, 0, 0, 0, 0);  #else 8   status = sys$qio(0, sd, IO$_ACCEPT_WAIT, &connectIosb,<                    &NetworkConnectAst, 0, 0, 0, 0, 0, 0, 0); #endif   if (VmsError(status))    { @     SystemLog("error: new connect qio: %s", VmsMessage(status));     return(FALSE);   }    else     return(TRUE);  }   I /************************************************************************   * Function:  *     IssueReadDataQio   *  * Description: D  *     Issues the asynchronous QIO for the network read from client.  *
  * Arguments:   *     None.  *  * Returns: )  *     VMS status code returned from qio. J  ************************************************************************/ int IssueReadDataQio() { 
   int status;   1   if (debugFlag) SystemLog("IssueReadDataQio()"); E   memset(clientData.readBuffer, '\0', sizeof(clientData.readBuffer)); 8   status = sys$qio(0, clientData.channel, IO$_READVBLK, C               &clientData.iosb, ReadAst, 0, clientData.readBuffer,  ;               sizeof(clientData.readBuffer)-1, 0, 0, 0, 0);    if (VmsError(status)) 7     SystemLog( "read sys$qio: %s", VmsMessage(status));    return(status);  }   I /************************************************************************   * Function:  *     IssueReadTimeoutQio  *  * Description: G  *     Issues a timer to trap 10 seconds of client silence on the read.   *
  * Arguments:   *     None.  *  * Returns: +  *     TRUE if successful, FALSE if failed. J  ************************************************************************/ int IssueReadTimeoutQio()  { 
   int status;    int value = FALSE;   int interval[2];)   $DESCRIPTOR(time_desc,"0 00:00:10.00");   4   if (debugFlag) SystemLog("IssueReadTimeoutQio()");,   status = sys$bintim(&time_desc, interval);   if (VmsError(status)) 4     SystemLog("sys$bintim: %s", VmsMessage(status));   else   { ;     status = sys$setimr(0, interval, ReadTimeoutAst, 0, 0);      if (VmsError(status)) 6       SystemLog("sys$setimr: %s", VmsMessage(status));     else       value = TRUE;    }    return(value); }   I /************************************************************************   * Function:  *     ReadAst  *  * Description:    *     Network read AST handler.  *
  * Arguments:   *     None.  *  * Returns:   *     Nothing. J  ************************************************************************/ void ReadAst() {    int size;   (   if (debugFlag) SystemLog("ReadAst()");  +   if (clientData.iosb.status == SS$_CANCEL)    {      attnState = ATTN_TIMEOUT;    } 
 #ifdef UCX4   else if (clientData.iosb.status == SS$_LINKDISCON) #else /* WINS */2   else if (clientData.iosb.terminator_offset == 0) #endif   { %     SystemLog("abnormal disconnect");       attnState = ATTN_DISCONNECT;   }    else   { -     if (clientData.iosb.status != SS$_NORMAL) K       SystemLog("read iosb error: %s", VmsMessage(clientData.iosb.status));   F     size = strlen(clientData.request) + strlen(clientData.readBuffer);,     if (size < sizeof(clientData.request)-1)     { 8       strcat(clientData.request, clientData.readBuffer);<       if (strchr(clientData.readBuffer, '\n') != (char *)0) '         clientData.readComplete = TRUE;      }      else     { I       size = sizeof(clientData.request) - strlen(clientData.request) - 2; )       clientData.readBuffer[size] = '\0'; 8       strcat(clientData.request, clientData.readBuffer);%       clientData.readComplete = TRUE;      }        attnState = ATTN_DATA;   }    sys$wake(0, 0);  }   I /************************************************************************   * Function:  *     ReadTimeoutAst   *  * Description: <  *     Routine that traps timeout on network read to client.  *
  * Arguments:   *     None.  *  * Returns:   *     Nothing. J  ************************************************************************/ void ReadTimeoutAst()  { =   /* Just cancel, and let ReadAst() handle the event later */ /   if (debugFlag) SystemLog("ReadTimeoutAst()"); !   sys$cancel(clientData.channel);  }   