H /***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *H  ***********************************************************************  *
  * Module:,  *     rfc931.c - routines related to rfc931  *  * Routines:  *     RemoteUsername   *J  ************************************************************************/   #include "iufingerd.h"  
 #ifdef UCX #include <ucx$inetdef.h> #else  #include <sys/ioctl.h> #endif   #ifdef TCPWARE  
 #undef accept  #undef bind 
 #undef socket 
 #undef listen  #undef connect
 #undef select  #undef ioctl #undef setsockopt 
 #undef nclose  #undef nread
 #undef nwrite    #define nread  socket_read #define nwrite socket_write  #define nclose socket_close    #endif TCPWARE  I /************************************************************************   * Function:  *     RemoteUsername   *  * Description: M  *     Obtains the remote username if the system is running an RFC931 daemon.   *
  * Arguments:   *     remoteAddress  *     remotePort   *     localPort  *  * Returns: 8  *     NULL if failed, pointer to username if succeeded.J  ************************************************************************/I char *RemoteUsername(u_long remoteAddress, int remotePort, int localPort)  {    int bytes;&   int checkRemotePort, checkLocalPort;   int mySocket;    int numScanned;    int numSelected;   int wasCached;   struct sockaddr_in server;   char buffer[256];    char *remoteUser = NULL;   static char username[256];$   struct host_cache_entry hostEntry;   fd_set ibits;    struct timeval timeout;   "   timeout.tv_sec  = rfc931Timeout;   timeout.tv_usec = 0;  '   bzero(&hostEntry, sizeof(hostEntry)); &   hostEntry.IPaddress = remoteAddress;%   wasCached = HostCached(&hostEntry);    if (wasCached)   { :     /* If it was cached, check the rfc931 daemon status */     if (debugFlag)M       SystemLog("host is cached, rfc931Status = %d", hostEntry.rfc931Status); :     if (hostEntry.rfc931Status == RFC931_NO) return(NULL);   }    else if (debugFlag) (     SystemLog("host is not yet cached");  %   hostEntry.rfc931Status = RFC931_NO;      server.sin_family = AF_INET;'   server.sin_port = htons(RFC931_PORT); .   memcpy(&server.sin_addr, &remoteAddress, 4);  9   if ((mySocket = socket(AF_INET, SOCK_STREAM, 0)) == -1) *     SystemLog("error: socket: %d", errno);8   else if (connect(mySocket, (struct sockaddr *)&server,5                    sizeof(struct sockaddr_in)) == -1)    {      /* No daemon */ 9     if (debugFlag) SystemLog("no RFC931 daemon present");    }    else   { ,     /* Daemon is there, send it the query */8     sprintf(buffer, "%u,%u\r\n", remotePort, localPort);M     if (debugFlag) SystemLog(">rfc931: \"%-.*s\"", strlen(buffer)-2, buffer); 5     bytes = nwrite(mySocket, buffer, strlen(buffer));      if (bytes > 0)     { 6       /* Now read the query, but don't wait forever */       FD_ZERO(&ibits);       FD_SET(mySocket, &ibits); ?       numSelected = select(FD_SETSIZE, &ibits, 0, 0, &timeout); =       if ((numSelected == 1) && (FD_ISSET(mySocket, &ibits)))        { &         bzero(buffer, sizeof(buffer));8         bytes = nread(mySocket, buffer, sizeof(buffer));         if (bytes > 0)	         { ( 	  /* Trim trailing CRLF off response */0 	  while (bytes > 0 && iscntrl(buffer[bytes-1]))#             buffer[--bytes] = '\0';   E           /* We got a reply, so make sure it's in the valid format */ >           if (debugFlag) SystemLog("<rfc931: \"%s\"", buffer);G           numScanned = sscanf(buffer, "%d , %d : USERID :%*[^:]:%255s", K                               &checkRemotePort, &checkLocalPort, username); "           if ((numScanned == 3) &&0               (remotePort == checkRemotePort) &&,               (localPort == checkLocalPort))           { 0             hostEntry.rfc931Status = RFC931_YES;"             remoteUser = username;           }            elseF             SystemLog("invalid reply from rfc931 daemon: %s", buffer);	         }        }        else if (debugFlag) (         SystemLog("select() timed out");     }    }      nclose(mySocket);      /* Now cache the host */   if (!wasCached)    {      if (resolveFlag)7       ResolveRemote(remoteAddress, hostEntry.hostName);      else<       strcpy( hostEntry.hostName, inet_ntoa(remoteAddress));     CacheHost(&hostEntry);   }      return(remoteUser);  } 