H /***********************************************************************  *>  *  (C) Copyright 1992-1993 The Trustees of Indiana University  *E  *   Permission to use, copy, modify, and distribute this program for H  *   non-commercial use and without fee is hereby granted, provided thatB  *   this copyright and permission notice appear on all copies andI  *   supporting documentation, the name of Indiana University not be used J  *   in advertising or publicity pertaining to distribution of the programI  *   without specific prior permission, and notice be given in supporting D  *   documentation that copying and distribution is by permission of  *   Indiana University.  *I  *   Indiana University makes no representations about the suitability of J  *   this software for any purpose. It is provided "as is" without express  *   or implied warranty.   *I  ************************************************************************   *
  * Module:?  *     uai.c - routines related to the user authorization file.   *  * Description: 3  *     This module contains routines related to the   *     user authorization file.   *  * Routines:$  *     Last Login  - get last login.'  *     UaiRetrieve - get user UAI info.   *J  ************************************************************************/    I /************************************************************************ 
  * #include's J  ************************************************************************/ #include "iufingerd.h"  I /************************************************************************   * Function:-  *     LastLogin - retrieves last login time.   *  * Description: 2  *     This routine retrieves the last login time.  *
  * Arguments: 1  *     userData - pointer to user data structure.   *  * Returns:   *     Nothing. J  ************************************************************************/* void LastLogin(struct user_data *userData) {    quadword lastLogin;    long     uaiStatus; -   $DESCRIPTOR(user_desc, userData->username);    itemlist outlist[] =   { :     { sizeof(lastLogin), UAI$_LASTLOGIN_I, lastLogin, 0 },     { 0, 0, 0, 0 }   };  6   user_desc.dsc$w_length = strlen(userData->username);=   uaiStatus = sys$getuai(0, 0, &user_desc, outlist, 0, 0, 0);    if (VmsError(uaiStatus))7     SystemLog("sys$getuai: %s", VmsMessage(uaiStatus));    else,     VmsTime(lastLogin, userData->lastLogin); }     I /************************************************************************   * Function:,  *     UaiRetrieve - retrieve user UAI info.  *  * Description: 7  *     This routine looks up information in the sysuaf.   *
  * Arguments: 1  *     userData - pointer to user data structure.   *  * Returns:   *     Nothing. J  ************************************************************************/, void UaiRetrieve(struct user_data *userData) {    char owner[80];    char defDir[80];   char defDevice[80];    long uaiStatus; $   struct user_cache_entry userEntry;-   $DESCRIPTOR(user_desc, userData->username);    quadword lastLogin;    itemlist outlist[] =   { :     { sizeof(owner),     UAI$_OWNER,       owner,     0 },:     { sizeof(defDevice), UAI$_DEFDEV,      defDevice, 0 },:     { sizeof(defDir),    UAI$_DEFDIR,      defDir,    0 },:     { sizeof(lastLogin), UAI$_LASTLOGIN_I, lastLogin, 0 },     { 0, 0, 0, 0 }   };  ,   if (debugFlag) SystemLog("UaiRetrieve()");  1   strcpy(userEntry.username, userData->username);    if (UserCached(&userEntry))    { 3     strcpy(userData->realName, userEntry.realName); 2     strcpy(userData->homeDir,  userEntry.homeDir);     userData->validUser = TRUE;      userData->wasCached = TRUE;      return;    }   6   user_desc.dsc$w_length = strlen(userData->username);=   uaiStatus = sys$getuai(0, 0, &user_desc, outlist, 0, 0, 0);    if (VmsError(uaiStatus))   { -     if (debugFlag || (uaiStatus != RMS$_RNF)) -       SystemLog("%s", VmsMessage(uaiStatus));       userData->validUser = FALSE;&     strcpy(userData->realName, "???");   }    else   {      int  size;     char *s;       userData->validUser = TRUE;       userData->wasCached = FALSE;  +     /*** null terminate pascal strings ***/ 8     size = owner[0];     *(owner     + 1 + size) = '\0';8     size = defDevice[0]; *(defDevice + 1 + size) = '\0';8     size = defDir[0];    *(defDir    + 1 + size) = '\0';  '     /*** zap garbage in owner name ***/       for (s = owner+1;  *s;  s++)       if (iscntrl(*s))
 	*s = '.';  (     strcpy(userData->realName, owner+1);>     sprintf(userData->homeDir, "%s%s", defDevice+1, defDir+1);       if (loginFlag).       VmsTime(lastLogin, userData->lastLogin);  3     strcpy(userEntry.realName, userData->realName); 1     strcpy(userEntry.homeDir, userData->homeDir);      CacheUser(&userEntry);   }  } 