P C                                                                         !00001P C  FLECS subroutine support:                                              !00002P C                                                                         !00003P C  The subroutines below form the machine and I/O interface               !00004P C  for the FLECS translator.  Please see the FLECS system                 !00005P C  modification guide for details.                                        !00006P C                                                                         !00007P C  The FLECS system modification guide may be obtained                    !00008P C  by writing to                                                          !00009P C                    Terry Beyer                                          !00010P C                    Computing Center                                     !00011P C                    University of Oregon                                 !00012P c                    Eugene, Oregon 97403                                 !00013P C                                                                         !00014P C                                                                         !00015P C---------------------------------------                                  !00016P C                                                                         !00017P C  Disclaimer                                                             !00018P C                                                                         !00019P C     Neither the author nor the University of Oregon shall be            !00020P C  libel for any direct or indirect, incidental, consequential,           !00021P C  or specific damages of any kind or from any cause whatsoever           !00022P C  arising out of or in any way connected with the use or                 !00023P C  performance of this program.                                           !00024P C                                                                         !00025P C---------------------------------------                                  !00026P C                                                                         !00027P C  Permission                                                             !00028P C                                                                         !00029P C     This program is in the public domain and may be altered             !00030P C  or reproduced without explicit permission of the author.               !00031P C                                                                         !00032P C----------------------------------------                                 !00033P C Modified by William Tanenbaum 7-13-79                                   !00034P C for Digital VAX 11/780 using CHARACTER data type                        !00035P C All subroutines except NEWNO have been extensively                      !00036P C changed from original versions described in                             !00037P C the FLEX modification guide.  Several subroutines                       !00038P C have even disappeared!                                                  !00039P C                                                                         !00040P C-----------------------------------------                                !00041P C                                                                         !00042P       SUBROUTINE OPENF(CALLNO,DONE,SVER)                                  !00043P C                                                                         !00044P C  OPENF IS THE FILE OPENING SUBROUTINE FOR THE FLECS TRANSLATOR.         !00045P C  FOR A DESCRIPTION SEE THE FLECS SYSTEM MODIFICATION GUIDE,             !00046P C  SECTION 6.1.                                                           !00047P C                                                                         !00048P C                                                                         !00049P       COMMON /FILES/ DOLIST, DOFORT, DEBUGG                               !00050P       COMMON /INCFIL/ LVERBOSE, DOINC, NOLIST, INCFLI, LINC               !00051P       LOGICAL LVERBOSE,                                                   !00052P      1DOFORT, DOLIST, DEBUGG, DOINC, INCFLI, LINC                         !00053P       INTEGER CALLNO,SVER,IX,INDEX,LONG,ISLEN,ISBEG,IY,IEND               !00054P       LOGICAL DONE                                                        !00055P       DIMENSION SVER(1)                                                   !00056P c       clns - increase length of fortran and listing file spec max       !00057P c       12 was too short for 9.3, even. 80 should be ok for 39.39         !00058P       CHARACTER INPUT*72,FORTRAN*80,LISTING*80,STRING*80                  !00059P       DONE=.TRUE.                                                         !00061P       DEBUGG=.FALSE.                                                      !00062P       LVERBOSE=.FALSE.        !CLNS                                       !00063P       DOLIST=.TRUE.                                                       !00064P       DOFORT=.TRUE.                                                       !00065P       DOINC = .TRUE.                                                      !00066P       INPUT=' '                                                           !00067P       LISTING=' '                                                         !00068P       FORTRAN=' '                                                         !00069P       IF(CALLNO.EQ.1)THEN                                                 !00070P         ISTAT=LIB$GET_FOREIGN(STRING,,ISLEN)                              !00071P         IF(ISLEN.EQ.0)THEN                                                !00072P           TYPE 100                                                        !00073P   100     FORMAT(' File(s): '$)                                           !00074P           ACCEPT 110, ISLEN,STRING                                        !00075P   110     FORMAT(Q,A)                                                     !00076P           ENDIF                                                           !00077P         ISBEG=1                                                           !00078P         ENDIF                                                             !00079P       IF(.NOT.(ISBEG.GT.ISLEN))THEN                                       !00080P         IX=INDEX(STRING(1:ISLEN),',')                                     !00081P         IY=INDEX(STRING(1:ISLEN),'+')                                     !00082P         IF(IX*IY.EQ.0)THEN                                                !00083P           IEND=IX+IY                                                      !00083P         ELSE                                                              !00084P           IEND=MIN0(IX,IY)                                                !00084P           ENDIF                                                           !00084P         IF(IEND.EQ.0)THEN                                                 !00085P           IEND=ISLEN+1                                                    !00085P         ELSE                                                              !00086P           STRING(IEND:IEND)=' '                                           !00086P           ENDIF                                                           !00086P         LONG=IEND-ISBEG                                                   !00087P         INPUT(1:LONG)=STRING(ISBEG:IEND-1)                                !00088P         ISBEG=IEND+1                                                      !00089P         IX=INDEX(INPUT(1:LONG),'/')                                       !00090P         IF(IX.NE.0)THEN                                                   !00091P C          PROCESS-SWITCHES                                               !00092P           ASSIGN 99998 TO I99999                                          !00092P           GO TO 99999                                                     !00092P 99998     CONTINUE                                                        !00092P           LONG=IX-1                                                       !00093P C                                                                         !00095P C  MODIFIDED 9/17/81 TO ALLOW FLEXING OUTSIDE DEFAULT AREA                !00096P C       updated 5/25/83 to allow just DEV:FILE.EXT;ver                    !00097P C                                                                         !00098P           ENDIF                                                           !00094P         ICOLN=INDEX(INPUT(1:LONG),':')                                    !00099P         IBRKT=INDEX(INPUT(1:LONG),']')                                    !00100P         IF(IBRKT.EQ.0)THEN! NO ']'                                        !00101P           IF(ICOLN.EQ.0)THEN                                              !00102P             ISTART=1                                                      !00102P           ELSE                                                            !00103P             ISTART=ICOLN+1                             !MAYBE JUST DEV:   !00103P             ENDIF                                                         !00103P         ELSE! FILE ELSEWHERE                                              !00105P           ISTART=IBRKT+1                                                  !00106P           ENDIF                                                           !00107P         IX=INDEX(INPUT(ISTART:LONG),'.')                ! NEW             !00108P C                                                                         !00109P C       IX=INDEX(INPUT(1:LONG),'.')                     ! OLD             !00110P C                                                                         !00111P         IF(IX.EQ.0)THEN                                                   !00112P           INPUT(LONG+1:LONG+4)='.FLX'                                     !00112P         ELSE                                                              !00113P           LONG=ISTART+IX-2                           !clns                !00113P C                                                                         !00114P C THIS OPENS THE FOR AND FLI FILES IN THE CURRENT AREA                    !00115P C                                                                         !00116P C       LISTING(1:LONG)=INPUT(1:LONG)                   ! OLD             !00117P C       LISTING(LONG+1:LONG+4)='.FLI'                   ! OLD             !00118P C       FORTRAN(1:LONG)=INPUT(1:LONG)                   ! OLD             !00119P C       FORTRAN(LONG+1:LONG+4)='.FOR'                   ! OLD             !00120P C                                                                         !00121P           ENDIF                                                           !00113P         NEWLONG=LONG-ISTART+1                           ! NEW             !00122P         LISTING(1:NEWLONG)=INPUT(ISTART:LONG)           ! NEW             !00123P         LISTING(NEWLONG+1:NEWLONG+4)='.FLI'             ! NEW             !00124P         FORTRAN(1:NEWLONG)=INPUT(ISTART:LONG)           ! NEW             !00125P         FORTRAN(NEWLONG+1:NEWLONG+4)='.FOR'             ! NEW             !00126P C                                                                         !00127P C END OF MODIDIFICATIONS - 9/17/81                                        !00128P C                                                                         !00129P clns    don't type file names unless /VERBOSE is set                      !00130P         IF (LVERBOSE)   TYPE 1000, INPUT(1:LONG+4)                        !00131P  1000   FORMAT(1X,A)                                                      !00132P         OPEN(UNIT=1,FILE=INPUT(1:LONG+4),STATUS='OLD',READONLY,SHARED)    !00133P         IF(DOLIST)THEN                                                    !00134P           OPEN(UNIT=3,FILE=LISTING,STATUS='NEW',CARRIAGECONTROL='LIST')   !00135P           IF (LVERBOSE)   TYPE 1000, LISTING                              !00136P           ENDIF                                                           !00137P         IF(DOFORT)THEN                                                    !00138P           OPEN(UNIT=2,FILE=FORTRAN,STATUS='NEW',CARRIAGECONTROL='LIST')   !00139P           IF (LVERBOSE)   TYPE 1000, FORTRAN                              !00140P           ENDIF                                                           !00141P         DONE=.FALSE.                                                      !00142P         ENDIF                                                             !00143P       RETURN                                                              !00144P C                                                                         !     P C----------------------------------------                                 !     P C                                                                         !     P C        TO PROCESS-SWITCHES                                              !00145P 99999 CONTINUE                                                            !00145P         IF (INDEX(INPUT(IX:LONG),'/D').NE.0) DEBUGG=.TRUE.                !00146P         IF (INDEX(INPUT(IX:LONG),'/NOL').NE.0) DOLIST=.FALSE.             !00147P         IF (INDEX(INPUT(IX:LONG),'/NOF').NE.0) DOFORT=.FALSE.             !00148P         IF (INDEX(INPUT(IX:LONG),'/NOI').NE.0) DOINC = .FALSE.            !00149P clns    add verbosity switch for echo of output file names                !00150P         IF (INDEX(INPUT(IX:LONG),'/VER').NE.0) LVERBOSE = .TRUE.          !00151P         INPUT(IX:LONG)=' '                                                !00152P       GO TO I99999                                                        !00153P       END                                                                 !00154P C                                                                         !00155P C*************************************************************************!00156P C*************************************************************************!00157P       SUBROUTINE GET(LSTR,LINENO,STRING,ENDFIL)                           !00158P C                                                                         !00159P C  GET IS THE INPUT SUBROUTINE FOR THE FLECS TRANSLATOR.                  !00160P C  FOR A DESCRIPTION SEE THE FLECS SYSTEM MODIFICATION GUIDE,             !00161P C  SECTION 6.2.                                                           !00162P C                                                                         !00163P       COMMON /INCFIL/ LVERBOSE, DOINC, NOLIST, INCFLI, LINC               !00164P       LOGICAL LVERBOSE                                                    !00165P       LOGICAL ENDFIL, DOINC, LINC, INCFLI, NOVAX                          !00166P       CHARACTER*80 TEMP, STRING                                           !00167P       CHARACTER*30 INKLUDE_FILE                                           !00168P       CHARACTER*1 TAB, VT, FF, APOS,ITERM                                 !00169P       INTEGER LINENO, LEN, LSTR, I, K, MOD, NSPACE                        !00170P       DATA TAB/9/, VT/11/, FF/12/, APOS/39/                               !00171P       DATA IIN/1/, LINC/.FALSE./                                          !00172P    10 FORMAT(Q,A)                                                         !00173P C                                                                         !00174P       IF(.TRUE.)GOTO99999                                                 !00175P       DO WHILE(.NOT.(K.GT.0))                                             !00175P 99999   CONTINUE                                                          !00175P    15   READ(IIN,10,END=20) LEN,TEMP                                      !00176P C        REMOVE-TAB-CHARACTERS                                            !00177P         ASSIGN 99997 TO I99998                                            !00177P         GO TO 99998                                                       !00177P 99997   CONTINUE                                                          !00177P         LINENO=LINENO+1                                                   !00178P         DO WHILE(STRING(K:K).EQ.' ')                                      !00179P           K=K-1                                                           !00179P           ENDDO                                                           !00179P         INX=INDEX(STRING(1:K),'!')                                        !00180P         IF(INX.EQ.0)THEN                                                  !00182P         ELSEIF(INDEX(STRING(INX:K),'VAX').NE.0)THEN                       !00183P           IF(STRING(1:1).NE.'C')THEN                                      !00185P           ELSEIF(STRING(1:2).EQ.'CD')THEN                                 !00186P             STRING(1:2)='D '                                              !00186P           ELSE                                                            !00187P             STRING(1:1)=' '                                               !00187P             ENDIF                                                         !00187P         ELSEIF(INDEX(STRING(INX:K),'PDP10').NE.0)THEN                     !00190P           STRING(1:1)='C'                                                 !00190P           ENDIF                                                           !00190P C                                                                         !00192P C       Intercept the include's:                                          !00193P C                                                                         !00194P         IF(DOINC .AND. STRING(1:1).NE.'C')THEN                            !00195P           INX = INDEX(STRING(1:K),'INCLUDE')      !look for the keyword   !00196P C                                                                         !00197P           IF(INX.GT.0)THEN                                                !00198P C            SCAN-INCLUDE-FILE                                            !00199P             ASSIGN 99995 TO I99996                                        !00199P             GO TO 99996                                                   !00199P 99995       CONTINUE                                                      !00199P C                                                                         !00200P             IF(.NOT.NOVAX)THEN                                            !00201P C       There were !vax and/or !pdp10 lines, so have FLECS                !00202P C       process the INCLUDE file:                                         !00203P               INCFLI = (NOLIST.EQ.0)          !put INCLUDE file in the FLI!00204P               STRING(1:1) = 'C'                                           !00205P               LINC = .TRUE.                                               !00206P               IIN = 4                                                     !00207P C                                                                         !00209P               ENDIF                                                       !00208P C                                                                         !00211P             ENDIF                                                         !00210P C                                                                         !00213P           ENDIF                                                           !00212P         IF(K.GT.80)THEN                                                   !00214P           K = 80                                                          !00215P C                                                                         !00216P           DO WHILE(STRING(K:K).EQ.' ')                                    !00217P             K = K - 1                                                     !00217P             ENDDO                                                         !00217P C                                                                         !00218P C                                                                         !00220P           ENDIF                                                           !00219P         ENDDO                                                             !00221P C                                                                         !00222P       LSTR = K                                                            !00223P       RETURN                                                              !00224P C                                                                         !00225P    20 CONTINUE                                                            !00226P C                                                                         !00227P       IF(LINC)THEN                                                        !00228P         LINC = .FALSE.                                                    !00229P         CLOSE(UNIT=4)                                                     !00230P         IIN = 1                                                           !00231P         GO TO 15                                                          !00232P C                                                                         !00234P         ENDIF                                                             !00233P       ENDFIL = .TRUE.                                                     !00235P       LINENO = 0                                                          !00236P       RETURN                                                              !00237P C                                                                         !00238P C*************************************************************************!00239P C*************************************************************************!00240P C                                                                         !00241P C                                                                         !00242P C-------------------------------------------------------------------------!00243P C                                                                         !00244P C                                                                         !     P C----------------------------------------                                 !     P C                                                                         !     P C        TO REMOVE-TAB-CHARACTERS                                         !00245P 99998 CONTINUE                                                            !00245P C                                                                         !00246P         I = 0                                                             !00247P         K = 0                                                             !00248P C                                                                         !00249P         DO WHILE(K.LT.80 .AND. I.LT.LEN)                                  !00250P           I = I + 1                                                       !00251P C                                                                         !00252P C                                                                         !00254P           IF((TAB).EQ.(TEMP(I:I)))THEN                                    !00255P             NSPACE = 8 - MOD(K,8)                                         !00256P C                                                                         !00257P             DO J=1,NSPACE                                                 !00258P               K = K + 1                                                   !00259P               STRING(K:K) = ' '                                           !00260P               ENDDO                                                       !00261P C                                                                         !00262P C                                                                         !00264P           ELSEIF((FF).EQ.(TEMP(I:I)))THEN                                 !00265P C                                                                         !00266P           ELSEIF((VT).EQ.(TEMP(I:I)))THEN                                 !00267P C                                                                         !00268P           ELSE                                                            !00269P             K = K + 1                                                     !00270P             STRING(K:K) = TEMP(I:I)                                       !00271P C                                                                         !00273P             ENDIF                                                         !00272P C                                                                         !00275P           ENDDO                                                           !00276P C                                                                         !00277P       GO TO I99998                                                        !00278P C                                                                         !00279P C-------------------------------------------------------------------------!00280P C                                                                         !00281P C                                                                         !     P C----------------------------------------                                 !     P C                                                                         !     P C        TO SCAN-INCLUDE-FILE                                             !00282P 99996 CONTINUE                                                            !00282P C                                                                         !00283P C       Added by Tom Gentile 4/1/82 to make FLECS process INCLUDE files.  !00284P C-------                                                                  !00285P C       Modified 5/12/83 by S.Ball to be compatible with DEC-10 formats:  !00286P C       1. always include file if double quote sign seen                  !00287P C       2. never include file if apostrophe-parenthesis seen              !00288P C               (VMS text library module extraction done by FORTRAN)      !00289P C       3. always include file if parenthesis seen alone (10 FLI)         !00290P C       4. conditionally include file if apostrophe seen alone            !00291P C               (previous VMS inclusion format)                           !00292P D       type *, 'scan-include-file'                                       !00294P D       type *,'line="',string(1:k),'"'                                   !00295P         NOVAX = .TRUE.                                                    !00296P C                                                                         !00297P C       Pick off the file specification:                                  !00298P         IST1 = INDEX(STRING(1:K),'"') + 1       !find 1st quote           !00299P         IST2 = INDEX(STRING(1:K),'''(') + 1     ! apostrophe parenthesis  !00300P         IST3 = INDEX(STRING(1:K),'(') + 1       ! Parenthesis             !00301P         IST4 = INDEX(STRING(1:K),APOS) + 1      ! apostrophe              !00302P D       TYPE *,'IST1=',IST1,', IST2=',IST2,', IST3=',IST3,', IST4=',IST4  !00303P         IF(IST1.GT.1)THEN                                                 !00305P C       A quote seen: always include the file                             !00306P           ITERM='"'                                                       !00307P           IST=IST1                                                        !00308P         ELSEIF(IST2.GT.1)THEN                                             !00310P C       Apostrophe parenthesis seen: never include the file               !00311P           NOVAX=.TRUE.                                                    !00312P           GOTO 240                                                        !00313P         ELSEIF(IST3.GT.1)THEN                                             !00315P C       A parenthesis seen: always include file                           !00316P           ITERM=')'                                                       !00317P           IST=IST3                                                        !00318P         ELSEIF(IST4.GT.1)THEN                                             !00320P C       Apostrophe seen: maybe include file                               !00321P           ITERM=''''                                                      !00322P           IST=IST4                                                        !00323P         ELSE                                                              !00325P C       No file spec seen                                                 !00326P           NOVAX=.TRUE.                                                    !00327P           GOTO 240                                                        !00328P           ENDIF                                                           !00329P         IF(IST.GT.INX)THEN                                                !00332P C       Position of 1st quote must be > than position of INCLUDE          !00333P C                                                                         !00334P C       CLNS:                                                             !00335P C       Scan the interval between "INCLUDE" and the file spec:            !00336P C       there should be only spaces or tabs there.                        !00337P C                                                                         !00338P           IP=INX+6                                                        !00339P           IPBAD=0                                                         !00340P           IF(.TRUE.)GOTO99994                                             !00341P           DO WHILE(IPBAD.EQ.0 .AND. IP.LT.IST-2)                          !00341P 99994       CONTINUE                                                      !00341P             IP=IP+1                                                       !00342P             IPBAD=INDEX(                                                  !00343P      1      'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'        !00344P      1      //'1234567890@#$%^&*);:|\}{?><,./`~+=-_',                     !00345P      2      string(IP:IP) )                                               !00346P             ENDDO                                                         !00347P           IF(IPBAD.NE.0)THEN                                              !00348P D       TYPE *,' IPBAD=',IPBAD                                            !00349P D       TYPE 1313,STRING(:IP-1),'/\',STRING(IP:)                          !00350P D1313   FORMAT(1X,3A)                                                     !00351P             NOVAX=.TRUE.                                                  !00352P             GOTO 240                                                      !00353P C                                                                         !00355P             ENDIF                                                         !00354P           NOLIST = INDEX(STRING(1:K),'/NOL')      !check for a /NOLIST opt!00356P           ISLASH = INDEX(STRING(1:K),'/')   !clns: might be another qualif!00357P C                                                                         !00358P           IF(ISLASH.EQ.0)THEN                                             !00359P C       There wasn't a qualifier, so just find the next terminator:       !00360P             IFN = INDEX(STRING(IST+1:K),iterm) - 1                        !00361P             IFN = INDEX(STRING(IST+1:K),iterm) - 1                        !00362P C                                                                         !00364P           ELSE                                                            !00365P C       There was a qualifier, so the end of the file name is             !00366P C       just before the /:                                                !00367P             IFN = ISLASH - IST - 1                                        !00368P C                                                                         !00370P             ENDIF                                                         !00369P           INKLUDE_FILE = STRING(IST:IST+IFN)      !get the file specificat!00371P D       type *,' inklude_file=',inklude_file                              !00372P           OPEN(UNIT=4,FILE=INKLUDE_FILE,STATUS='OLD',                     !00373P      *    READONLY,SHARED,ERR=220)                                        !00374P C                                                                         !00375P CLNS    if a quote (")  or parenthesis was seen,                          !00376P Clns    Always include the file - the user has specified it               !00377P C                                                                         !00378P           IF(IST.EQ.IST1 .OR. IST.EQ.IST3) NOVAX=.FALSE.  !CLNS           !00379P C                                                                         !00380P C       Now scan through the file and see if any lines have a "pdp10"     !00381P C       or a "vax": at this point, NOVAX=.true. iff ITST4 .GT. 1          !00382P C                                                                         !00383P           DO WHILE(NOVAX)                                                 !00384P             READ(4,10,END=210) LEN, TEMP                                  !00385P             INX = INDEX(TEMP(1:LEN),'VAX') + INDEX(TEMP(1:LEN),'PDP10')   !00386P             IF(INX.NE.0) NOVAX = .FALSE.                                  !00387P             ENDDO                                                         !00388P C                                                                         !00389P   210     IF(.NOT.NOVAX) REWIND 4                                         !00390P C                                                                         !00392P           ENDIF                                                           !00391P         GO TO 240               !jump over the OPEN error handler         !00393P C                                                                         !00394P   220   CONTINUE                                                          !00395P         INKMXC=INDEX(INKLUDE_FILE,'    ')                                 !00396P         TYPE 230, INKLUDE_FILE(1:INKMXC)                                  !00397P   230   FORMAT(' %FLECS-W-NOINCL - INCLUDE file ''', A, ''' not found.')  !00398P   240   CONTINUE                                                          !00399P       GO TO I99996                                                        !00399P C                                                                         !00400P       END                                                                 !00401P C                                                                         !00402P C*************************************************************************!00403P C                                                                         !00404P       SUBROUTINE PUT(SLINE,STRING,IOCLAS)                                 !00405P C                                                                         !00406P C  PUT IS THE OUTPUT ROUTINE FOR THE FLECS TRANSLATOR.                    !00407P C  FOR A DESCRIPTION SEE THE FLECS SYSTEM MODIFICATION GUIDE,             !00408P C  SECTION 6.3.                                                           !00409P C                                                                         !00410P C  ASSUMPTIONS--                                                          !00411P C     -- FILE FORTOUT IS WRITTEN ON FORTRAN UNIT FOUT.                    !00412P C        (SEE DATA STATEMENT BELOW)                                       !00413P C     -- FILE LISTOUT IS WRITTEN ON FORTRAN UNIT LOUT.                    !00414P C        (SEE DATA STATEMENT BELOW)                                       !00415P C     -- THE LINE NUMBERS TO BE WRITTEN TO FORTOUT SHOULD APPEAR          !00416P C        IN COLUMNS 76 THROUGH 80.                                        !00417P C     -- OUTPUT CLASS ERR IS TO APPEAR ONLY ON THE LISTING.               !00418P C                                                                         !00419P C  NOTE TIMESHARING SYSTEMS SHOULD HAVE CODE ADDED WHICH SENDS ALL        !00420P C  ERR CLASS OUTPUT TO THE USERS TERMINAL AS WELL AS TO THE LISTING.      !00421P C                                                                         !00422P       CHARACTER*(*) STRING                                                !00423P       CHARACTER*80 BLANKS                                                 !00424P       CHARACTER*5 SLINE                                                   !00425P       CHARACTER*1 TAB                                                     !00426P       INTEGER ERR                                                         !00427P       INTEGER FOUT, LOUT                                                  !00428P       LOGICAL DOLIST, DOFORT, DEBUGG, DOINC, INCFLI, LINC                 !00429P C                                                                         !00430P C                                                                         !00431P C  OUTPUT CONTROL PARAMETERS                                              !00432P       COMMON/FILES/DOLIST,DOFORT,DEBUGG                                   !00433P       COMMON /INCFIL/ LVERBOSE, DOINC, NOLIST, INCFLI, LINC               !00434P C                                                                         !00435P C  MNEMONICS FOR IOCLASSES                                                !00436P       DATA  LIST/2/, ERR/3/                                               !00437P C                                                                         !00438P C  FORTOUT AND LISTOUT UNIT NUMBERS                                       !00439P       DATA FOUT/2/, LOUT/3/                                               !00440P C                                                                         !00441P C BLANKS WILL BE RIGHT FILLED WITH SPACES                                 !00442P       DATA BLANKS(1:74)/' '/                                              !00443P       DATA BLANKS(75:75)/'!'/                                             !00444P       DATA TAB/9/                                                         !00445P C                                                                         !00446P       LSTR = LEN(STRING)                                                  !00447P C                                                                         !00448P       IF(DOLIST)THEN                                                      !00449P C                                                                         !00450P         IF(LINC)THEN                                                      !00451P C       If we are processing an INCLUDE file, only write it out to the    !00452P C       FLI file if it had !vax or !pdp10 lines and did not               !00453P C       have a /NOLIST option:                                            !00454P C                                                                         !00455P           IF(NOLIST.GT.0)THEN                                             !00456P             STRING(1:1) = ' '                                             !00457P             NOLIST = 0                                                    !00458P C                                                                         !00460P             ENDIF                                                         !00459P           IF(INCFLI .OR. NOLIST.EQ.0)THEN                                 !00461P             WRITE(LOUT,40) ' '//SLINE//' '//STRING(1:LSTR)                !00462P             NOLIST = -1     !NOLIST = 0 forces the INCLUDE statement to be!00463P C                                                                         !00465P             ENDIF                                                         !00464P C                                                                         !00467P         ELSE                                                              !00468P           WRITE(LOUT,40) ' '//SLINE//' '//STRING(1:LSTR)                  !00469P C                                                                         !00471P           ENDIF                                                           !00470P C                                                                         !00473P         ENDIF                                                             !00472P       IF (IOCLAS.EQ.ERR) TYPE 40, ' '//SLINE//' '//STRING(1:LSTR)         !00474P       RETURN                                                              !00475P C                                                                         !00476P C-------------------------------------------------------------------------!00477P C                                                                         !00478P       ENTRY PUTZ(STRING,IOCLAS)                                           !00479P       LSTR=LEN(STRING)                                                    !00480P       IF(DOLIST)THEN                                                      !00481P         WRITE(LOUT,40) BLANKS(1:7)//STRING(1:LSTR)                        !00482P         ENDIF                                                             !00483P       IF (IOCLAS.EQ.ERR) TYPE 40, BLANKS(1:7)//STRING(1:LSTR)             !00484P       RETURN                                                              !00485P C                                                                         !00486P C-------------------------------------------------------------------------!00487P C                                                                         !00488P       ENTRY PUTF(SLINE,STRING)                                            !00489P       IF(DOFORT)THEN                                                      !00490P         LSTR=MIN0(LEN(STRING),74)                                         !00491P         WRITE(FOUT,40) STRING(1:LSTR)//BLANKS(LSTR+1:75)//SLINE           !00492P         ENDIF                                                             !00493P       RETURN                                                              !00494P    40 FORMAT(A)                                                           !00495P       END                                                                 !00496P C                                                                         !00497P C*************************************************************************!00498P C                                                                         !00499P       SUBROUTINE PUTN(SLINE,STRING,IOCLAS)                                !00500P       CHARACTER*(*) STRING                                                !00501P       CHARACTER*5 SLINE                                                   !00502P       LOGICAL DOLIST,DOFORT,DEBUGG                                        !00503P C                                                                         !00504P C                                                                         !00505P C  OUTPUT CONTROL PARAMETERS                                              !00506P       COMMON/FILES/DOLIST,DOFORT,DEBUGG                                   !00507P C                                                                         !00508P C  MNEMONICS FOR IOCLASSES                                                !00509P       DATA  LIST/2/, ERR/3/                                               !00510P C                                                                         !00511P C  FORTOUT AND LISTOUT UNIT NUMBERS                                       !00512P       DATA FOUT/2/, LOUT/3/                                               !00513P C  OUTPUT FORMAT USED TO INDICATE DELETED LINE.                           !00514P    30 FORMAT('+-----')                                                    !00515P       CALL PUT(SLINE,STRING,IOCLAS)                                       !00516P       IF (DOLIST) WRITE(LOUT,30)                                          !00517P       RETURN                                                              !00518P       END                                                                 !00519P C                                                                         !00520P C*************************************************************************!00521P C                                                                         !00522P       SUBROUTINE CLOSEF(MINCNT,MAJCNT)                                    !00523P       INTEGER MINCNT,MAJCNT                                               !00524P       LOGICAL DOLIST,DOFORT,DEBUGG                                        !00525P C                                                                         !00526P C  OUTPUT PARAMETERS                                                      !00527P       COMMON/FILES/DOLIST,DOFORT,DEBUGG                                   !00528P C                                                                         !00529P C  CLOSEF IS THE FILE CLOSING SUBROUTINE FOR THE FLECS TRANSLATOR         !00530P C  FOR A DESCRIPTION SEE THE FLECS SYSTEM MODIFICATION GUIDE,             !00531P C  SECTION 6.4.                                                           !00532P C                                                                         !00533P clns    no output message if no errors                                    !00534P       IF(MINCNT+MAJCNT.GE.1)THEN                                          !00535P         TYPE 100, MINCNT,MAJCNT                                           !00536P   100   FORMAT(' There were',I4,' Minor and',I4,' Major errors.')         !00537P         ENDIF                                                             !00538P       CLOSE(UNIT=1)                                                       !00539P       IF (DOFORT) CLOSE(UNIT=2)                                           !00540P       IF (DOLIST) CLOSE(UNIT=3)                                           !00541P       RETURN                                                              !00542P       END                                                                 !00543P C                                                                         !00544P C*************************************************************************!00545P C                                                                         !00546P       INTEGER FUNCTION HASH(A,PRIME)                                      !00547P C                                                                         !00548P C  HASH COMPUTES AN INTEGER IN THE RANGE 0 TO PRIME-1 BY HASHING          !00549P C  THE STRING A INCLUDING ITS LENGTH.                                     !00550P C  FOR A DESCRIPTION SEE THE FLECS SYSTEM MODIFICATION GUIDE,             !00551P C  SECTION 4.8.                                                           !00552P C                                                                         !00553P       INTEGER PRIME,LEN,L,I,ICH                                           !00554P C                                                                         !00555P       CHARACTER*(*) A                                                     !00556P C                                                                         !00557P       L=LEN(A)                                                            !00558P C                                                                         !00559P C  HASH THE LENGTH AND ALL WORDS, REDUCING                                !00560P C  EACH MOD PRIME BEFORE SUMMING TO AVOID INTEGER OVERFLOW.               !00561P       HASH=L                                                              !00562P       DO I=1,L                                                            !00563P         ICH=ICHAR(A(I:I))                                                 !00564P         HASH=HASH+ICH-(ICH/PRIME)*PRIME                                   !00565P         ENDDO                                                             !00566P C                                                                         !00567P C  COMPLETE HASHING                                                       !00568P       IF(HASH.LT.0) HASH=-HASH                                            !00569P       HASH=HASH-(HASH/PRIME)*PRIME                                        !00570P       RETURN                                                              !00571P       END                                                                 !00572P       INTEGER FUNCTION NEWNO(N)                                           !00573P C                                                                         !00574P C  NEWNO IS A SEQUENTIAL NUMBER GENERATOR.                                !00575P C  FOR A DESCRIPTION SEE THE FLECS SYSTEM MODIFICATION GUIDE.             !00576P C                                                                         !00577P C  AUTHOR -- TERRY BEYER                                                  !00578P C  VERSION -- 2.1                                                         !00579P C  DATE -- AUGUST 12, 1974                                                !00580P C                                                                         !00581P C  THIS SUBPROGRAM IS MACHINE INDEPENDENT.                                !00582P C                                                                         !00583P       INTEGER N,OLDNO                                                     !00584P       DATA OLDNO/0/                                                       !00585P       IF(N.NE.0)THEN                                                      !00586P         NEWNO=N                                                           !00586P       ELSE                                                                !00587P         NEWNO=OLDNO-1                                                     !00587P         ENDIF                                                             !00587P       OLDNO = NEWNO                                                       !00588P       RETURN                                                              !00589P       END                                                                 !00590