/********************************************************************
 Changes from Alan Coopersmith's second set of gopher 2.016 patches:
     - properly hexify URL's generated by URLfromGS()
 ********************************************************************/

/********************************************************************
 * lindner
 * 3.7
 * 1994/03/04 17:42:57
 * /home/mudhoney/GopherSrc/CVS/gopher+/object/url.c,v
 * Exp
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: url.c
 * Simplified method of getting urls..
 *********************************************************************
 * Revision History:
 * url.c,v
 * Revision 3.7  1994/03/04  17:42:57  lindner
 * Fixes from Alan Coopersmith
 *
 * Revision 3.6  1994/01/21  04:25:41  lindner
 * Add support for tn3270 and better gopher url handling
 *
 * Revision 3.5  1993/12/30  04:18:08  lindner
 * translate telnet url correctly
 *
 * Revision 3.4  1993/12/27  16:14:03  lindner
 * Enlarge buffer size, make html docs on gopher server into http: refs
 *
 * Revision 3.3  1993/11/02  06:14:09  lindner
 * Add url html hack
 *
 *
 *********************************************************************/

#include "url.h"
#include "GSgopherobj.h"
#include "Malloc.h"
#include "String.h"

Url *
URLnew()
{
     Url *temp;

     temp = (Url *) malloc(sizeof(Url));
     temp->url = STRnew();
     
     return(temp);
}


void
URLdestroy(url)
  Url *url;
{
     STRdestroy(url->url);
     free(url);
}

/*
 * Make a default url from the current Gopher Object...
 */

void
URLfromGS(url, gs)
  Url       *url;
  GopherObj *gs;
{
     char u[2048], *path, *cp;

     *u = '\0';
     path  = GSgetPath(gs);

     if ((GSgetType(gs) == A_TN3270) || (GSgetType(gs) == A_TELNET)) {
	  /* [telnet|tn3270]://[host]@[login]:[port] */
	  if (GSgetType(gs) == A_TELNET)
	       strcpy(u,"telnet://");
	  else
	       strcpy(u,"tn3270://");
	  Tohexstr(GSgetHost(gs), u + 9);
	  if ( (path != NULL) && (*path != '\0') ) {
	       cp = u + strlen(u);
	       *(cp++) = '@';
	       Tohexstr(path, cp);
	  }
	  sprintf(u + strlen(u), ":%d", GSgetPort(gs));
     } else if (path == NULL)
	  return;
     else if (strncmp(path, "GET /", 5) == 0) {
	  /* http://[host]:[port][path without "GET "] */
	  strcpy(u, "http://");
	  Tohexstr(GSgetHost(gs), u+7);
	  sprintf(u + strlen(u), ":%d", GSgetPort(gs));
	  Tohexstr(path + 4, u + strlen(u));
     }
     else {
	  /* gopher://[host]:[port]/[type][path] */
	  strcpy(u, "gopher://");
	  Tohexstr(GSgetHost(gs), u + 9);
	  sprintf(u + strlen(u), ":%d/%c", GSgetPort(gs), GSgetType(gs));
	  Tohexstr(path, u + strlen(u));
     }

     URLset(url, u);
}

/*
 * Hack gopher directories into an HTML type...
 */

void
URLmakeHTML(url)
  Url *url;
{
     char *cp = URLget(url);
     char *host;

     if (cp == NULL) 
	  return;

     if (strncmp(cp, "gopher://", 9) != 0)
	  return;

     /** find the type character **/
     cp = strchr(cp+10, '/');
     
     if (cp ==NULL)
	  return;

     /** Test link for current host **/
/*   host = cp+10; 
     if (strcasecmp(host, hostname) != 0) 
	  return;*/
     
     cp ++;
     /** cp is now pointed at the type character **/
     
     if (*cp == '1' && *(cp+1) == '1') {
	  /** It's a directory **/
	  *cp = 'h';
	  *(cp+1) = 'h';
     }
}


/*
 * Get the transport of the specified URL
 */

char *
URLgetTransport(url)
  Url *url;
{
     static char trans[16];  /** Shouldn't need more than that.. yet.. */
     char *urlcp, *cp;

     urlcp = URLget(url);
     if (urlcp == NULL)
	  return(NULL);

     cp = strchr(urlcp, ':');
     if (cp == NULL)
	  return(NULL);
     
     strncpy(trans, urlcp, (int)(cp-urlcp));
     return (trans);
}

