+ /******************************************    &   HOTJOT - A Quick Note Taking Program  *   Written by - Patrick.Meyer@msfc.nasa.gov     Date - October 31, 1995   + ******************************************/    /*** INCLUDE FILES       ***/  #include <stdio.h> #include <stdlib.h>  #include <ctype.h> #include <time.h>  #include <X11/StringDefs.h>  #include <X11/Intrinsic.h> #include <Xm/AtomMgr.h>  #include <Xm/Xm.h> #include <Xm/Form.h> #include <Xm/RowColumn.h>  #include <Xm/MessageB.h> #include <Xm/Protocols.h>  #include <Xm/PushB.h>  #include <Xm/SelectioB.H>  #include <Xm/ToggleB.H>  #include <Xm/MwmUtil.h>  #include <Xm/Text.h> #include <Xm/MrmAppl.h>  #include <DXm/DECSpecific.h> #include <DXm/DXmPrint.h>  #include "hotjot.xbm"      /*** DATA TYPE DEFS      ***/ S #define MAX_JOTS          100        /* The maximum number of jots on screen     */ S #define MAX_TITLE_LENGTH  100        /* Maximum characters in a Jot title        */      /* Main Jot Structure */ typedef struct {  S    Position  x,y;                    /* Jot position on screen                   */ S    Dimension height, width;          /* Jot dimension                            */ S    int       screen;                 /* Jot's screen for multi-screen systems    */ S    time_t    alarm;                  /* Unused currently                         */ S    Boolean   open;                   /* Jot's open state                         */ S    Boolean   hidden;                 /* Jot's hidden status - unused currently   */ S    char      *colorname;             /* Jot's current colorname                  */  } JotStuff;        /*** GLOBAL VARIABLES    ***/   S XtAppContext app_context;            /* Program Application Context              */ S Widget   toplevel, toplevel2;        /* Toplevel Shells for screens 1 and 2      */ S Boolean  edited = FALSE;             /* Once in 15 minutes, true if a jot edited */   S Pixmap icon;                         /* HOTJOT ICON Pixmap                       */ S Widget HotJots[MAX_JOTS];            /* Array of JOT Windows                     */ S Widget printDB = NULL;               /* Printer dialog box                       */ S Widget search_current = NULL;        /* Search dialog box                        */ S int    HotJot_count = 0;             /* Count of live JOTS                       */ S int    print_which = 0;              /* Index of which jot to print              */ S GC     gc;                           /* Graphic context for colors               */      /*** INTERNAL PROTOTYPES ***/ < void CreateNewNote(Position x, Position y, Dimension height,I                    Dimension width, Boolean, int screen, Boolean hidden,  0                    char *colorname, char *note);) void DeleteHotJot(Widget w, Boolean ask); 3 void ExtractTitle(char *data, char *title_string);  E void MapDialogCB(Widget dialog, void *nada, XmAnyCallbackStruct *cb); A void MenuCB(Widget w, int item, XmPushButtonCallbackStruct *cb);  F void MenuColorCB(Widget w, int item, XmPushButtonCallbackStruct *cb); 7 void MenuPostEH(Widget w, Widget menu, XEvent *event);  E void MenuPrintCB(Widget w, int item, XmPushButtonCallbackStruct *cb); I void ModifyTextCB(Widget w, void *nada, XmTextVerifyCallbackStruct *cb);   void PrintCreateDB(void); I void PrintDialogCB(Widget w, void *nada, XmPushButtonCallbackStruct *cb); % void PrintJot(Widget w, Boolean all); F void PrintWhichCB(Widget w, int item, XmPushButtonCallbackStruct *cb);@ void Sash(Widget w, void *nada, XmPushButtonCallbackStruct *cb); void SaveHotJot(void);E void SearchJotSearch(Widget w, void *nada, XmAnyCallbackStruct *cb);  I void SearchCB(Widget w, Widget toggle, XmSelectionBoxCallbackStruct *cb);  void SwitchScreens(Widget w);  void UpJotUp(void); C Boolean VerifyAction(char *title, char *message, Boolean warning);  C void VerifyActionCB(Widget w, char *done, XmAnyCallbackStruct *cb);   ? /************************************************************** ? *                      AutoSaveEH                             * ? * Function:                                                   * ? *    Auto save event handler waits 15 minutes and check to    * ? *    see if any edits have been made.  If so, it saves your   * ? *    jots - don't want you to lose them ;)                    * ? *************************************************************** 
 * Parameters: $ *   w        in:  A widget - unused.# *   id       in:  Timeout Timer Id.  */, void AutoSaveEH(Widget w, XtIntervalId id) {  .     /* Save if edited and reset edited flag */     if (edited) SaveHotJot();      edited = FALSE;   #     /* Check again in 15 minutes */ R     XtAppAddTimeOut(app_context, 15*60*1000, (XtTimerCallbackProc) AutoSaveEH, w); }       ? /************************************************************** ? *                      CreateNewNote                          * ? * Function:                                                   * ? *    Creates a jot.                                           * ? *************************************************************** 
 * Parameters: 2 *    x            in:  Jot's X position on screen.2 *    y            in:  Jot's Y position on screen.$ *    height       in:  Jot's Height.# *    width        in:  Jot's Width. 3 *    open         in:  Jot's open state (TRUE=OPEN) 5 *    screen       in:  Which screen for dual screens.  *    hidden       in:  Unused.$ *    colorname    in:  Color of Jot.9 *    note         in:  Starting note data (usually none).  */+ void CreateNewNote(Position x, Position y,  6                    Dimension height, Dimension width, <                    Boolean open, int screen, Boolean hidden,#                    char *colorname,                      char *note) {    Arg      args[20];     Cardinal n;    Widget   button;     Widget   text;     Widget   popup_menu;     Widget   color_pulldown;     Widget   print_pulldown;     XmString title;    JotStuff *new_jot;     Widget   new_toplevel;     char     title_string[100];  !    if (HotJot_count < MAX_JOTS) {      8       new_jot = (JotStuff *) XtMalloc(sizeof(JotStuff));         new_jot->hidden = FALSE;         n = 0;       if (x != -255) {           new_jot->x         = x;           new_jot->y         = y; 	 new_jot->screen    = screen; 	 new_jot->height    = height; 	 new_jot->width     = width;  	 new_jot->open      = open;%          new_jot->hidden    = hidden; . 	 new_jot->colorname = XtNewString(colorname);            if (hidden) {@             XtSetArg(args[n], XmNmappedWhenManaged, FALSE); n++;
          }  " 	 XtSetArg(args[n], XmNx, x); n++;" 	 XtSetArg(args[n], XmNy, y); n++;            if (open) {6             XtSetArg(args[n], XmNheight, height); n++;
          }  * 	 XtSetArg(args[n], XmNwidth, width); n++;       } else {"          new_jot->x         = 100;"          new_jot->y         = 100;$          new_jot->hidden    = FALSE; 	 new_jot->open      = TRUE;+ 	 new_jot->colorname = XtNewString("None");        }    8       if (screen == XDefaultScreen(XtDisplay(toplevel)))!          new_toplevel = toplevel; 
       else"          new_toplevel = toplevel2;4       XtSetArg(args[n], XmNmwmDecorations, 2); n++; 3       XtSetArg(args[n], XmNuserData, new_jot); n++; 5       XtSetArg(args[n], XmNautoUnmanage, FALSE); n++; 8       XtSetArg(args[n], XmNdefaultPosition, FALSE); n++;P       HotJots[HotJot_count] = XmCreateFormDialog(new_toplevel, "form", args, n);  '       ExtractTitle(note, title_string);          n = 0;1       title = XmStringCreateSimple(title_string); @       XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;?       XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; >       XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;4       XtSetArg(args[n], XmNlabelString, title); n++;2       XtSetArg(args[n], XmNresizable, FALSE); n++;       if (!open)D          XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;L       button = XmCreatePushButton(HotJots[HotJot_count], "button", args, n);N       XtAddCallback(button, XmNactivateCallback, (XtCallbackProc) Sash, NULL);       XtManageChild(button);       XmStringFree(title);         n = 0;A       XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++; @       XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;?       XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; @       XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;3       XtSetArg(args[n], XmNtopWidget, button); n++; =       XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++; 2       XtSetArg(args[n], XmNmaxLength, 10000); n++;-       XtSetArg(args[n], XmNvalue, note); n++; 3       XtSetArg(args[n], XmNresizable, FALSE); n++;  C       text = XmCreateText(HotJots[HotJot_count], "Text", args, n);         if (open)           XtManageChild(text); X       XtAddCallback(text, XmNmodifyVerifyCallback, (XtCallbackProc) ModifyTextCB, NULL);         { / 	 XmString save = XmStringCreateSimple("Save"); 1 	 XmString new = XmStringCreateSimple("New Jot"); < 	 XmString delete = XmStringCreateSimple("Delete This Jot");9 	 XmString colors = XmStringCreateSimple("Change Color"); <          XmString lower = XmStringCreateSimple("Lower All");<          XmString raise = XmStringCreateSimple("Raise All");A          XmString swscr = XmStringCreateSimple("Switch Screens"); =          XmString search = XmStringCreateSimple("Search..."); 8          XmString print = XmStringCreateSimple("Print");/ 	 XmString exit = XmStringCreateSimple("Exit"); b 	 popup_menu = XmVaCreateSimplePopupMenu(HotJots[HotJot_count], "popup", (XtCallbackProc) MenuCB, & 	      XmVaCASCADEBUTTON, colors, 'C',, 	      XmVaPUSHBUTTON, new, 'N', NULL, NULL,/ 	      XmVaPUSHBUTTON, delete, 'D', NULL, NULL, . 	      XmVaPUSHBUTTON, lower, 'L', NULL, NULL,. 	      XmVaPUSHBUTTON, raise, 'R', NULL, NULL,. 	      XmVaPUSHBUTTON, swscr, 'w', NULL, NULL,/ 	      XmVaPUSHBUTTON, search, 'H', NULL, NULL, % 	      XmVaCASCADEBUTTON, print, 'P', - 	      XmVaPUSHBUTTON, save, 'S', NULL, NULL, - 	      XmVaPUSHBUTTON, exit, 'E', NULL, NULL, 
 	      NULL);  	 XmStringFree(save);  	 XmStringFree(new); 	 XmStringFree(exit);  	 XmStringFree(delete);  	 XmStringFree(colors);  	 XmStringFree(lower); 	 XmStringFree(raise);          XmStringFree(swscr);           XmStringFree(search);          XmStringFree(print);        }          { 4 	 XmString defaul = XmStringCreateSimple("Default");3 	 XmString blue = XmStringCreateSimple("Sky Blue"); 3 	 XmString violet = XmStringCreateSimple("Violet"); / 	 XmString gold = XmStringCreateSimple("Gold"); 3 	 XmString tomato = XmStringCreateSimple("Tomato"); : 	 XmString palegreen = XmStringCreateSimple("Pale Green");: 	 XmString darkkhaki = XmStringCreateSimple("Dark Khaki");: 	 XmString slateblue = XmStringCreateSimple("Slate Blue");: 	 XmString violetred = XmStringCreateSimple("Violet Red");> 	 XmString forestgreen = XmStringCreateSimple("Forest Green");I 	 color_pulldown = XmVaCreateSimplePulldownMenu(popup_menu, "colors", 0,  % 			     (XtCallbackProc) MenuColorCB, - 	    XmVaPUSHBUTTON, defaul, 'e', NULL, NULL, + 	    XmVaPUSHBUTTON, blue, 'S', NULL, NULL, - 	    XmVaPUSHBUTTON, violet, 'V', NULL, NULL, + 	    XmVaPUSHBUTTON, gold, 'G', NULL, NULL, - 	    XmVaPUSHBUTTON, tomato, 'T', NULL, NULL, 0 	    XmVaPUSHBUTTON, palegreen, 'P', NULL, NULL,0 	    XmVaPUSHBUTTON, darkkhaki, 'D', NULL, NULL,0 	    XmVaPUSHBUTTON, slateblue, 'B', NULL, NULL,0 	    XmVaPUSHBUTTON, violetred, 'R', NULL, NULL,2 	    XmVaPUSHBUTTON, forestgreen, 'F', NULL, NULL, 	    NULL);  	 XmStringFree(defaul);  	 XmStringFree(blue);  	 XmStringFree(violet);  	 XmStringFree(gold);  	 XmStringFree(violetred); 	 XmStringFree(tomato);  	 XmStringFree(palegreen); 	 XmStringFree(darkkhaki); 	 XmStringFree(slateblue);! 	 XmStringFree(forestgreen);             }          { 3 	 XmString this = XmStringCreateSimple("This Jot"); 2 	 XmString all = XmStringCreateSimple("All Jots");5          XmString dots = XmStringCreateSimple("..."); I 	 print_pulldown = XmVaCreateSimplePulldownMenu(popup_menu, "prints", 7,  % 			     (XtCallbackProc) MenuPrintCB, + 	    XmVaPUSHBUTTON, this, 'T', NULL, NULL, * 	    XmVaPUSHBUTTON, all, 'A', NULL, NULL,+ 	    XmVaPUSHBUTTON, dots, 'A', NULL, NULL,  	    NULL);  	 XmStringFree(this);  	 XmStringFree(all);          XmStringFree(dots);       }   d       XtAddEventHandler(HotJots[HotJot_count], ButtonPressMask, FALSE, (XtEventHandler) MenuPostEH,  			popup_menu);   +       if (strcmp(colorname, "None") != 0) { t 	 XtVaSetValues(HotJots[HotJot_count], XtVaTypedArg,  XmNbackground, XmRString, colorname, strlen(colorname), NULL);e 	 XtVaSetValues(text,   XtVaTypedArg,  XmNbackground, XmRString, colorname, strlen(colorname), NULL); e 	 XtVaSetValues(button, XtVaTypedArg,  XmNbackground, XmRString, colorname, strlen(colorname), NULL);        }   +       XtManageChild(HotJots[HotJot_count]);          HotJot_count++;     } else { #       if (VerifyAction("Too Many",  2 	  "You have too many notes 100 is max.", TRUE)) { 	 ;        }     } }   ? /************************************************************** ? *                      DownJotDown                            * ? * Function:                                                   * ? *    Lowers all jot windows                                   * ? *************************************************************** 
 * Parameters:  *    None.   */ void DownJotDown(void) {  9    XLowerWindow(XtDisplay(toplevel), XtWindow(toplevel));       /* If 2 screens, do both */    if (toplevel != toplevel2) >       XLowerWindow(XtDisplay(toplevel2), XtWindow(toplevel2)); }   ? /************************************************************** ? *                      ExtractTitle                           * ? * Function:                                                   * ? *    Extracts a title from the first line in a jot to display * ? *    on button when closed.                                   * ? *************************************************************** 
 * Parameters: D *   data           in:  The contents of a jot.                      B *   title_string  out:  The returned title.                        */3 void ExtractTitle(char *data, char *title_string) { 6    int i,j;               /* Loop control variables */    Boolean done, start;         done = start = FALSE;  /    /* While not end of text search for title */ N    for (i = j = 0; i < strlen(data) && !done && j < MAX_TITLE_LENGTH-1; i++) {  ?       /* Don't start collecting letters 'til first non-space */        if (!isspace(data[i])) 	 start = TRUE; -       if (data[i] == '\n' || data[i] == '\0')  	 done = TRUE;       if (start) 	 title_string[j++] = data[i];      }    /* Null terminate */     title_string[j++] = '\0';     #    /* Remove any trailing spaces */     j = strlen(title_string);'    while (isspace(title_string[j-1])) {        title_string[j-1] = '\0'; 
       j--;    }  (    /* If no title found, say no title */'    if (strcmp(title_string, "") == 0) { '       strcpy(title_string, "No Title");     } }   ? /************************************************************** ? *                      DeleteHotJot                           * ? * Function:                                                   * ? *    Deletes and unsed jot... confirm it first.               * ? *************************************************************** 
 * Parameters: ' *    w      in:   Delete button widget. 7 *    ask    in:   Whether to ask if use is sure.  FALSE 0 *                 if called from switch screens. */* void DeleteHotJot(Widget w, Boolean ask) {    Widget parent;     Widget form; 	    int i;     JotStuff *jot_data;  ,    parent = XtParent(XtParent(XtParent(w)));  &    if (!ask || VerifyAction("Delete", I                      "Are you sure you wish to delete this Jot", TRUE)) {          if (HotJot_count > 1) {  	 i = 0;2 	 while (i < HotJot_count && parent != HotJots[i])	 	    i++;    	 if (i < HotJot_count) { 9 	    XtVaGetValues(parent, XmNuserData, &jot_data, NULL); * 	    XtFree((char *) jot_data->colorname); 	    XtFree((char *) jot_data);  	    XtDestroyWidget(parent); P 	    memmove(&HotJots[i], &HotJots[i+1], ((HotJot_count-i-1) * sizeof(Widget))); 	    HotJot_count--; 	    edited = TRUE;* 	 }*       } else {0 	 Widget text = XtNameToWidget(parent, "*Text"); 	 XmTextSetString(text, "");       }a    } }b  ? /***************************************************************? *                      HideJot                                *h? * Function:                                                   *e? *    Currently unused.  I would like to have hidden jots.     *c? *************************************************************** 
 * Parameters:s */ void HideJot(Widget w) {    Widget  parent, form;    JotStuff *jot_data;
    int     i;u  6    parent = XtParent(XtParent(XtParent(XtParent(w))));,    form   = XtNameToWidget(parent, "*form");5    XtVaGetValues(form, XmNuserData, &jot_data, NULL);e      jot_data->hidden;    XtUnmapWidget(parent);    }n          ? /***************************************************************? *                      JotSearch                              * ? * Function:                                                   *u? *    Searches a single jot, or all jots for the given string  *c? ***************************************************************/
 * Parameters: > *   current  in:  The JOT initiating the search.              + *   string   in:  The string to search for. G *   all      in:  Indicates whether to search only current or all jots.  */; void JotSearch(Widget current, char *string, Boolean all) { ?    char           *data;          /* Pointer to jot's string */ ?    char           *p;             /* Ptr. used during search */a?    int            i;              /* Loop control            */ !    int            pass = 0;      *    Boolean        done = FALSE;t    JotStuff       *jot_data;    Widget         text;o    Widget         temp;     XmTextPosition position;2  	    i = 0;o9    while (current != HotJots[i] && i < HotJot_count) i++;       if (i < HotJot_count) {1       text = XtNameToWidget(HotJots[i], "*Text");o1       XtVaGetValues(text, XmNvalue, &data, NULL); /       position = XmTextGetCursorPosition(text);   
       do { 	 if (current == HotJots[i]) { 	   pass++;  	 }t  - 	 text = XtNameToWidget(HotJots[i], "*Text");b4          XtVaGetValues(text, XmNvalue, &data, NULL);-          p = strstr(&data[position], string);   Q          /* If not found from current position, search from beginning */                     if (p == NULL && !all) !    	    p = strstr(data, string);j            if (!all) {             if (p != NULL) {6                position = (XmTextPosition) (p - data);:                XmTextSetInsertionPosition(text, position);X                XmTextSetSelection(text, position, position+strlen(string), CurrentTime);  G                XtVaGetValues(HotJots[i], XmNuserData, &jot_data, NULL);e%                if (!jot_data->open) { ?                   temp = XtNameToWidget(HotJots[i], "*button");d)                   Sash(temp, NULL, NULL);n                }                done = TRUE;n             } else { l-                XBell(XtDisplay(toplevel), 0);i
             }B          } else {              if (p != NULL) {6                position = (XmTextPosition) (p - data);:                XmTextSetInsertionPosition(text, position);X                XmTextSetSelection(text, position, position+strlen(string), CurrentTime);                iG                XtVaGetValues(HotJots[i], XmNuserData, &jot_data, NULL);t%                if (!jot_data->open) {t?                   temp = XtNameToWidget(HotJots[i], "*button");d)                   Sash(temp, NULL, NULL);l                }                done = TRUE;S             } else {&                i = (i+1)%HotJot_count;                position = 0;
             }S
          }  -          if (pass == 2) done = TRUE;         )         } while (!done);         if (p == NULL)! 	 XBell(XtDisplay(toplevel), 0); r    }   }o  ? /************************************************************** ? *                      LoadHotJot                             * ? * Function:                                                   * ? *    Loads Hot Jot from ".HOTJOT" file.                       * ? *************************************************************** 
 * Parameters:n
 *    None. */ void LoadHotJot(void) {y:    FILE *fp;              /* File Ptr. for .HOTJOT file */:    char buffer[10000];    /* Buffer to hold single JOT  */:    char colorname[30];    /* Colorname string           */    int ch;                	    int i;u    int screen;    int x,y;v    int height, width;l    int open, hidden;      /* Open JOT file */(    fp = fopen("SYS$LOGIN:.HotJot", "r");  '    /* Load in jot info. for each jot */n    if (fp != NULL) {       while (!feof(fp)) {x          i = 0;tR 	 fscanf(fp, "%d %d %d %d %d %d %d %s\n", &x, &y, &height, &width, &open, &screen,9                                                  &hidden,w<                                                  colorname);
          do {              ch = fgetc(fp);e3             if (ch != 255 && i < 9999 && ch != EOF)                  buffer[i++] = ch;6          } while (ch != EOF && ch != 255 && i < 9999);          buffer[i] = '\0';M          CreateNewNote(x,y,height,width,open,screen,hidden,colorname,buffer);i       }        fclose(fp);     }  (    /* If no jots, create at least one */    if (!HotJot_count) {t3       CreateNewNote(-255,0,0,0,TRUE,0,0,"None","");o    } }r    ? /**************************************************************o? *                      MapDialogCB                            * ? * Function:                                                   * ? *    Centers verify action dialog.                            *e? ***************************************************************l
 * Parameters: , *    dialog   in:  The verify action dialog.$ *    nada     in:  Nothing (unused).% *    cb       in:  Map callback data.o */F void MapDialogCB(Widget dialog, void *nada, XmAnyCallbackStruct *cb) {    Position x,y;    Dimension w, h;    Dimension s_w, s_h;   <    XtVaGetValues(dialog, XmNwidth, &w, XmNheight, &h, NULL);)    s_w = WidthOfScreen(XtScreen(dialog));)*    s_h = HeightOfScreen(XtScreen(dialog));    x = (s_w/2) - (w/2);     y = (s_h/2) - (h/2);-1    XtVaSetValues(dialog, XmNx, x, XmNy, y, NULL);n }j    ? /************************************************************** ? *                      MenuPostEH                             * ? * Function:                                                   *r? *    Event handler to post the MB3 popup menu.                * ? *************************************************************** 
 * Parameters:g> *   w        in:  The event widget.                           # *   string   in:  The menu to post.e  *   event    in:  The MB3 event. */7 void MenuPostEH(Widget w, Widget menu, XEvent *event) {;       /* Position and post */6    XmMenuPosition(menu, (XButtonPressedEvent *)event);    XtManageChild(menu);n }   ? /**************************************************************w? *                      MenuCB                                 *n? * Function:                                                   * ? *    Acts on users choice from popup menu.                    * ? ***************************************************************,
 * Parameters: > *   w        in:  Push button on menu.                        + *   item     in:  Selected item number.     G *   cb       in:  Push button callback data.                           m */A void MenuCB(Widget w, int item, XmPushButtonCallbackStruct *cb) {;    Widget parent;t    int    decor;      switch (item) {       case 1:  /* New Jot */          { A              Widget parent, form;$             Dimension height, width;             Position x,y;g             JotStuff *jot_data;F             ?             parent = XtParent(XtParent(XtParent(XtParent(w))));g5             form   = XtNameToWidget(parent, "*form"); R             XtVaGetValues(form, XmNx, &x, XmNy, &y, XmNuserData, &jot_data, NULL);!             if (jot_data->open) {cO                XtVaGetValues(form, XmNheight, &height, XmNwidth, &width, NULL);a             } else {)                height = jot_data->height;t'                width = jot_data->width;t
             }   Q             CreateNewNote(x,y+=50,height,width,TRUE,XDefaultScreen(XtDisplay(w)),t+                           FALSE,"None","");]
          }          break;_       case 2:  /* Delete Jot */[          DeleteHotJot(w, TRUE);D          break;        case 3:  /* Lower Jots */u          DownJotDown();A          break;i       case 4:  /* Raise Jots */           UpJotUp();]          break;0#       case 5:  /* Switch screens */m          SwitchScreens(w);          break;        case 6:  /* Do search */(          SearchJotSearch(w, NULL, NULL);          break;,       case 8:  /* Save jot  */          SaveHotJot();          break;b       case 9:  /* Exit      */          if (edited) {%             if (VerifyAction("Exit", gK                 "There are unsaved edits.  Save before exiting?", FALSE)) {(                SaveHotJot();
             }a          } e          exit(0);m          break;m    } }a  ? /**************************************************************e? *                      MenuPrintCB                            *p? * Function:                                                   *"? *    Acts on users choice from popup menu.                    *l? ***************************************************************"
 * Parameters:t> *   w        in:  Push button on menu.                        + *   item     in:  Selected item number.    pG *   cb       in:  Push button callback data.                             */F void MenuPrintCB(Widget w, int item, XmPushButtonCallbackStruct *cb) {    Widget parent;       switch (item) {       case 0:   /* This jot */          PrintJot(w, FALSE);          break;        case 1:   /* All jots */          PrintJot(w, TRUE);O          break;U%       case 2:   /* Give dialog box */r          if (printDB == NULL)O             PrintCreateDB();6          XtVaSetValues(printDB, XmNuserData, w, NULL);           XtManageChild(printDB);          break;     } }g  ? /************************************************************** ? *                      MenuColorCB                            *e? * Function:                                                   *(? *    Acts on users choice from popup menu.                    *e? ***************************************************************l
 * Parameters:i> *   w        in:  Push button on menu.                        + *   item     in:  Selected item number.    mG *   cb       in:  Push button callback data.                           e */F void MenuColorCB(Widget w, int item, XmPushButtonCallbackStruct *cb) {    Widget parent;g    Widget form;r    Widget text;S    Widget button;t    char   *colorname;n    JotStuff *jot_data;  @    parent = XtParent(XtParent(XtParent(XtParent(XtParent(w)))));*    form = XtNameToWidget(parent, "*form");*    text = XtNameToWidget(parent, "*Text");.    button = XtNameToWidget(parent, "*button");5    XtVaGetValues(form, XmNuserData, &jot_data, NULL);,      edited = TRUE;       switch (item) {
       case 0:           colorname = "None";          break;U
       case 1:P          colorname = "SkyBlue";L          break;B
       case 2:n          colorname = "Violet";          break;i
       case 3:L          colorname = "Gold";          break;N
       case 4:P          colorname = "Tomato";          break;P
       case 5:s!          colorname = "PaleGreen";)          break;e
       case 6:m!          colorname = "DarkKhaki";v          break;i
       case 7: !          colorname = "SlateBlue";i          break; 
       case 8:p!          colorname = "VioletRed";i          break;e
       case 9: #          colorname = "ForestGreen";           break;     }  (    if (strcmp(colorname, "None") != 0) {i       XtVaSetValues(form,   XtVaTypedArg,  XmNbackground, XmRString, colorname, strlen(colorname), NULL);)i       XtVaSetValues(text,   XtVaTypedArg,  XmNbackground, XmRString, colorname, strlen(colorname), NULL);ni       XtVaSetValues(button, XtVaTypedArg,  XmNbackground, XmRString, colorname, strlen(colorname), NULL);X    } else {,       Pixel background; @       XtVaGetValues(toplevel, XmNbackground, &background, NULL);;       XtVaSetValues(form, XmNbackground, background, NULL);o;       XtVaSetValues(text, XmNbackground, background, NULL); =       XtVaSetValues(button, XmNbackground, background, NULL);N    }  (    XtFree((char *) jot_data->colorname);3    jot_data->colorname = XtNewString(colorname);   m }s  ? /**************************************************************N? *                      ModifyTextCB                           *t? * Function:                                                   *r? *    Toggle edited flag when user edits any jot.              *(? *************************************************************** 
 * Parameters:y' *    w     in:   The text field widget.n *    nada  in:   Unused.& *    cb    in:   Unused callback data. */I void ModifyTextCB(Widget w, void *nada, XmTextVerifyCallbackStruct *cb) {     edited = TRUE;  }     ? /************************************************************** ? *                      PrintCreateDB                          * ? * Function:                                                   **? *    Creates the print dialog box.                            *o? ***************************************************************v
 * Parameters:  *    None.   */ void PrintCreateDB(void) {L    Arg      args[15];     /* Widget resources to change                   */L    Cardinal n;            /* Widget resource count                        */L    Widget   which_menu;   /* Which jot to print menu                      */L    int      suppress;     /* BIT flag for which print options to suppress */  $    /* Create the print dialog box */	    n = 0;e%    suppress = DXmSUPPRESS_PAGE_RANGE; =    XtSetArg(args[n], DXmNsuppressOptionsMask, suppress); n++;*6    XtSetArg(args[n], DXmNunmanageOnCancel, TRUE); n++;2    XtSetArg(args[n], DXmNunmanageOnOk, TRUE); n++;5    XtSetArg(args[n], XmNdefaultPosition, FALSE); n++; E    printDB = DXmCreatePrintDialog(toplevel, "Print Dialog", args, n);   <    /* Create the popup menu which asks which jot to print */    {7       XmString this = XmStringCreateSimple("This Jot"); 6       XmString all = XmStringCreateSimple("All Jots");`       which_menu = XmVaCreateSimpleRadioBox(printDB, "which", 0, (XtCallbackProc) PrintWhichCB, + 	   XmVaRADIOBUTTON, this, 'D', NULL, NULL, * 	   XmVaRADIOBUTTON, all, 'L', NULL, NULL,
 	   NULL);       XmStringFree(this);        XmStringFree(all);    }    XtManageChild(which_menu);u      /* Add callbacks */N    XtAddCallback(printDB, XmNmapCallback, (XtCallbackProc) MapDialogCB, NULL);O    XtAddCallback(printDB, XmNokCallback, (XtCallbackProc) PrintDialogCB, NULL);  }\  ? /************************************************************** ? *                      PrintDialogCB                          *n? * Function:                                                   **? *    Searches a single jot, or all jots for the given string  * ? *************************************************************** 
 * Parameters: > *   w        in:  Print Dialog Box widget.                    # *   nada     in:  Nothing (unused).*' *   cb       in:  Unused callback data.  */J void PrintDialogCB(Widget w, void *nada, XmPushButtonCallbackStruct *cb) {B    /* If print_which is non-zero, we print all.  Else print one */    if (print_which) {        PrintJot(w, TRUE);    } else {)>       /* Find the jot to print and send the button which will 0        * be used to indicate which jot to print.	        */        Widget button;9       XtVaGetValues(printDB, XmNuserData, &button, NULL);w       PrintJot(button, FALSE);    } }   ? /**************************************************************p? *                      PrintWhichCB                           * ? * Function:                                                   *F? *    Sets which jot to print when selected from print dialog  *)? ***************************************************************t
 * Parameters:t2 *    w     in:  The toggle Button on print dialog.% *    item  in:  The selected item no. C *    cb    in:  Push button/ Toggle button callback data. (unused).e */G void PrintWhichCB(Widget w, int item, XmPushButtonCallbackStruct *cb) {*    print_which = item; }*  ? /************************************************************** ? *                      PrintJot                               * ? * Function:                                                   * ? *    Creates and prints print file.                           * ? ***************************************************************f
 * Parameters:f *     w    in:  Jot to print. % *     all  in:  True if to print all.X */& void PrintJot(Widget w, Boolean all) {    FILE      *fp;     int       i;r    char      *data;d    Widget    text;    Widget    top_parent;    XmString  file_pointer[1];       if (printDB == NULL)*       PrintCreateDB();  +    fp = fopen("SYS$LOGIN:HotJot.txt", "w");r  
    if (all) { 8       /* Loop through all jots and print them to file */*       for (i = 0; i < HotJot_count; i++) {- 	 text = XtNameToWidget(HotJots[i], "*Text"); - 	 XtVaGetValues(text, XmNvalue, &data, NULL);*   	 fprintf(fp, data); 	 if (i+1 < HotJot_count) {h 	    fputc('\f', fp);a 	 }        }     } else {g       top_parent = w;e4       while(strcmp(XtName(top_parent), "form") != 0)$ 	 top_parent = XtParent(top_parent);  1       text = XtNameToWidget(top_parent, "*Text");l1       XtVaGetValues(text, XmNvalue, &data, NULL);t       fprintf(fp, data);    }      fclose(fp);  B    file_pointer[0] = XmStringCreateSimple("SYS$LOGIN:HOTJOT.TXT");1    DXmPrintWgtPrintJob(printDB, file_pointer, 1);a }=  ? /**************************************************************t? *                      Sash                                   *T? * Function:                                                   *s? *    Opens and closes a jot window.                           * ? ***************************************************************e
 * Parameters:e# *    w       in:  Sash push button.T# *    nada    in:  Nothing (unused). , *    cb      in:  Push button callback data. */A void Sash(Widget w, void *nada, XmPushButtonCallbackStruct *cb) {X    Widget parent;X    Widget form;U    Widget text;=    char   *data;    char   title_string[100];    Dimension high,wide;n    int     i,j;h    Boolean done,start;    XmString title;    JotStuff *jot_data;  "    parent = XtParent(XtParent(w));,    form   = XtNameToWidget(parent, "*form");5    XtVaGetValues(form, XmNuserData, &jot_data, NULL);;(    text = XtNameToWidget(form, "*Text");      edited = TRUE;   "    /* Open because text managed */    if (XtIsManaged(text)) {iC       XtVaGetValues(form, XmNheight, &high, XmNwidth, &wide, NULL);r         XtUnmanageChild(text);  .       /* Get current size ... here if minimal E       XtVaGetValues(parent, XmNheight, &high, XmNwidth, &wide, NULL);h       */  &       /* Get text data to get title */1       XtVaGetValues(text, XmNvalue, &data, NULL);   '       ExtractTitle(data, title_string);   7       title = XmStringCreateSimple(title_string);                jot_data->height = high;       jot_data->width  = wide;       jot_data->open   = FALSE;e:       XtVaSetValues(w, XmNbottomAttachment, XmATTACH_FORM,'                        XmNwidth, wide, e-                        XmNlabelString, title,u                        NULL);t2       XtVaSetValues(parent, XmNwidth, wide, NULL);       XmStringFree(title);    } else {e  1       XtVaGetValues(form, XmNwidth, &wide, NULL);mA       XtVaSetValues(w, XmNbottomAttachment, XmATTACH_NONE, NULL); 0       XtVaSetValues(text, XmNwidth, wide, NULL);       XtManageChild(text);?       XtVaSetValues(parent, XmNheight, jot_data->height, NULL); 7       XtVaSetValues(form, XmNheight, jot_data->height,  *                           XmNwidth, wide,                             NULL);  8       XRaiseWindow(XtDisplay(parent), XtWindow(parent));  .       title = XmStringCreateSimple(" ");      -       XtVaSetValues(w, XmNlabelString, title,                         NULL);        jot_data->open = TRUE;       XmStringFree(title);  3       XmProcessTraversal(text, XmTRAVERSE_CURRENT);*    } }*    ? /************************************************************** ? *                      SaveHotJot                             *r? * Function:                                                   *0? *    Saves the jot info.                                      * ? ***************************************************************l
 * Parameters:h
 *    None. */ void SaveHotJot() {f    FILE      *fp;N    int       i;     char      *data;n    Widget    text;    Position  x,y;)    Dimension height, width;x    Boolean    open;     JotStuff   *jot_data;    d(    fp = fopen("SYS$LOGIN:.HotJot", "w");  '    for (i = 0; i < HotJot_count; i++) { 1       XtVaGetValues(HotJots[i], XmNx,        &x,  0                                 XmNy,        &y,6                                 XmNheight,   &height, 4                                 XmNwidth,    &width,&                                 NULL);1       text = XtNameToWidget(HotJots[i], "*Text"); >       XtVaGetValues(HotJots[i], XmNuserData, &jot_data, NULL);1       XtVaGetValues(text, XmNvalue, &data, NULL);          if (!jot_data->open) {#          height = jot_data->height; "          width  = jot_data->width;       }"  5       fprintf(fp, "%d %d %d %d %d %d %d %s\n", x, y, *5                                       height, width, p5                                       jot_data->open, 7                                       jot_data->screen,n7                                       jot_data->hidden, ;                                       jot_data->colorname);*       fprintf(fp, data);       if (i+1 < HotJot_count) {a          fputc(255, fp);          fputc('\n', fp);        }M    }      fclose(fp);    edited = FALSE; }     ? /**************************************************************D? *                      SearchJotSearch                        *o? * Function:                                                   *S? *    Creates and manages search dialog.                       *x? ***************************************************************d
 * Parameters: > *   w        in:  Unused widget.                              , *   nada     in:  Nothing (unused).         G *   cb       in:  Unused callback data.                                  */E void SearchJotSearch(Widget w, void *nada, XmAnyCallbackStruct *cb) {p&    static Widget search_dialog = NULL;      if (search_dialog == NULL) {*       Cardinal n;        Arg      args[10];       XmString title;t       Widget   toggle;           n = 0;5       title = XmStringCreateSimple("Hot Jot Search");n4       XtSetArg(args[n], XmNdialogTitle, title); n++;8       XtSetArg(args[n], XmNdefaultPosition, FALSE); n++;J       search_dialog = XmCreatePromptDialog(toplevel, "SearchEm", args, n);W       XtAddCallback(search_dialog, XmNmapCallback, (XtCallbackProc) MapDialogCB, NULL);n       XmStringFree(title);         n = 0;J       toggle = XmCreateToggleButton(search_dialog, "Search All", args, n);       XtManageChild(toggle);  U       XtAddCallback(search_dialog, XmNokCallback, (XtCallbackProc) SearchCB, toggle);     }  4    search_current = XtParent(XtParent(XtParent(w)));       XtManageChild(search_dialog); }t      ? /************************************************************** ? *                      SearchCB                               *h? * Function:                                                   *;? *    Extracts string from search dialog and initiate search   *A? *************************************************************** 
 * Parameters: # *    w      in:  The search dialog.u8 *    toggle in:  Search toggle widget (all or this jot)./ *    cb     in:  The dialog callback structure.  */J void SearchCB(Widget w, Widget toggle, XmSelectionBoxCallbackStruct *cb) {    char *string;  eG    if (XmStringGetLtoR(cb->value, XmSTRING_DEFAULT_CHARSET, &string)) { H       JotSearch(search_current, string, XmToggleButtonGetState(toggle));    } }   ? /**************************************************************w? *                      SwitchScreens                          *N? * Function:                                                   * ? *    Deletes a jot on one screen after duplicating it on the  *e? *    other.  Only useful for two screen systems.              *T? *************************************************************** 
 * Parameters:)> *    w     in:  The menu button for the jot to switch screens. */ void SwitchScreens(Widget w) {:    int      i;           /* Loop control variable       */:    JotStuff *jot_data;   /* Jot data structure          */:    Widget   parent;      /* Parent shell of menu button */:    Widget   form;        /* Form widget in found JOT    */:    Widget   text;        /* Text widget in found JOT    */  %    /* switching screens is an edit */     edited = TRUE;e  (    /* Figure which jot is being moved */6    parent = XtParent(XtParent(XtParent(XtParent(w))));,    form   = XtNameToWidget(parent, "*form");,    text   = XtNameToWidget(parent, "*Text");  -    /* If we have two screens, begin switch */     if (toplevel != toplevel2) { @       Position x,y;               /* Jot's position on screen */@       Dimension height, width;    /* Jot's dimensions         */@       Boolean hidden = FALSE;     /* Not used                 */@       Boolean open;               /* Open state               */@       int     screen;             /* New Screen               */@       char    *data;              /* Text data                */         /* Get jot data */8       XtVaGetValues(form, XmNuserData, &jot_data, NULL);  &       /* Get position and dimension */.       XtVaGetValues(parent,  XmNx,        &x, -                              XmNy,        &y, 3                              XmNheight,   &height, T1                              XmNwidth,    &width,i#                              NULL); 5       /* Get from jot data if it was open because thea8        *  height and width would be incorrect otherwise 	        */;       if (!jot_data->open) {#          height = jot_data->height;*"          width  = jot_data->width;       } 1       XtVaGetValues(text, XmNvalue, &data, NULL);        open = jot_data->open;2       screen = !XDefaultScreen(XtDisplay(parent));  =       /* Create new jot on other screen and delete old jot */*L       CreateNewNote(x,y,height,width,open,screen,hidden,jot_data->colorname,                     data);       DeleteHotJot(w, FALSE);     } }e    ? /**************************************************************.? *                      UpJotUp                                *i? * Function:                                                   *d? *    Raises all Jot windows to foreground.                    *r? ***************************************************************t
 * Parameters:(
 *    None. */ void UpJotUp(void) {9    XRaiseWindow(XtDisplay(toplevel), XtWindow(toplevel));T      /* If 2 screens, do both */    if (toplevel != toplevel2)t>       XRaiseWindow(XtDisplay(toplevel2), XtWindow(toplevel2)); }     ? /************************************************************** ? *                      VerifyAction                           * ? * Function:                                                   * ? *    Builds verify dialog and loops until user response is    * ? *    given.  Note re-entrant, but thats okay.                 * ? ***************************************************************)
 * Parameters:k" *    title     in:   Dialog title.( *    message   in:   Message to display.: *    warning   in:   Type of dialog box (TRUE if warning). */C Boolean VerifyAction(char *title, char *message, Boolean warning) {eR    static   Widget question_dialog = NULL;     /* Question dialog               */R    static   int    done;                       /* Loop controlling variable     */R    Arg      args[6];                           /* Widget resource args          */R    Atom     wm_delete_window;                  /* Make close do a NO action     */R    Cardinal n;                                 /* Count of resource changes     */R    XmString new_title;                         /* Replacement title XmString    */R    XmString new_message;                       /* Replacement message XmString  */R    XmString yes_string;                        /* Replacement OK XmString       */R    XmString no_string;                         /* Replacement CANCEL XmString   */R    XEvent   event;                             /* Used for Blocking events      */  +    /* If dialog does not exist create it */*!    if (question_dialog == NULL) {        n = 0;8       XtSetArg(args[n], XmNdefaultPosition, FALSE); n++;K       XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_CANCEL_BUTTON); n++; R       question_dialog = XmCreateWarningDialog(toplevel, "verify_action", args, n);\       XtAddCallback(question_dialog, XmNokCallback, (XtCallbackProc) VerifyActionCB, &done);`       XtAddCallback(question_dialog, XmNcancelCallback, (XtCallbackProc) VerifyActionCB, &done);Y       XtAddCallback(question_dialog, XmNmapCallback, (XtCallbackProc) MapDialogCB, NULL);*]       wm_delete_window = XmInternAtom(XtDisplay(question_dialog), "WM_DELETE_WINDOW", FALSE); K       XmAddWMProtocolCallback(XtParent(question_dialog), wm_delete_window,  F                               (XtCallbackProc) VerifyActionCB, &done);    }  -    /* Modify to either YES,NO or OK,CANCEL */ 	    n = 0;s    if (warning) {/.       yes_string = XmStringCreateSimple("OK");1       no_string = XmStringCreateSimple("Cancel"); ;       XtSetArg(args[n], XmNokLabelString, yes_string); n++; >       XtSetArg(args[n], XmNcancelLabelString, no_string); n++;>       XtSetArg(args[n], XmNdialogType, XmDIALOG_WARNING); n++;    } else {o/       yes_string = XmStringCreateSimple("Yes");a.       no_string  = XmStringCreateSimple("No");;       XtSetArg(args[n], XmNokLabelString, yes_string); n++;r>       XtSetArg(args[n], XmNcancelLabelString, no_string); n++;?       XtSetArg(args[n], XmNdialogType, XmDIALOG_QUESTION); n++;T    }  !    /* Update message and title */P+    new_title = XmStringCreateSimple(title);eG    new_message = XmStringCreateLtoR(message, XmSTRING_DEFAULT_CHARSET);p5    XtSetArg(args[n], XmNdialogTitle, new_title); n++;t9    XtSetArg(args[n], XmNmessageString, new_message); n++;i)    XtSetValues(question_dialog, args, n);     XmStringFree(new_title);S    XmStringFree(new_message);     XmStringFree(yes_string);    XmStringFree(no_string);i      /* Bring up dialog */%    XtManageChild(question_dialog);        done = 0;      while (!done) {*       XtAppNextEvent(app_context, &event);       XtDispatchEvent(&event);    }      if (done == 1)l       return TRUE;    else        return FALSE;i }g    ? /************************************************************** ? *                      VerifyActionCB                         **? * Function:                                                   *B? *    Callback to accept users response to action verification * ? ***************************************************************j
 * Parameters:e> *   w        in:  Verify action dialog.                       9 *   done     in:  Loop control variable for verification.l- *   cb       in:  Dialog callback structure.   */D void VerifyActionCB(Widget w, char *done, XmAnyCallbackStruct *cb) {    if (cb->reason == XmCR_OK) {n       *done = 1;    } else {        *done = 2;  &       if (cb->reason != XmCR_CANCEL) {          XtUnmanageChild(w);       }     } }n    ? /************************************************************** ? *                      main                                   * ? ***************************************************************n */" int main(int argc, char *argv[]) {Q    Display     *display;                     /* Ptr. to X Display when open    */*Q    int         fake_argc = 1;                /* We are not really a C program  */ Q    char        *fake_argv[5];                /* Fake version of argv           */cQ    int         num_screens;                  /* Number of screens for X Device */*Q    char        second_display[50];           /* Name of secondary display      */ Q    XGCValues   gcv;                          /* For Color GC setup             */o  T6    /* Fake args for AppInitialize, so we can configure     * for a two screen system.     */    fake_argv[0] = "HOTJOT";t    fake_argv[1] = "-display";*!    fake_argv[2] = second_display;*  ,    /* Ask Display how many screens it has */     display = XOpenDisplay(NULL);'    num_screens = XScreenCount(display);     XCloseDisplay(display);  ,    /* Initialize Dxm and Mrm for PrintBox */    DXmInitialize();*    MrmInitialize();*      /* Create toplevel shell */A    toplevel = XtVaAppInitialize(&app_context, "HotJot", NULL, 0, :9                                 &argc, argv, NULL, NULL);a      /* Create icon */:    icon = XCreatePixmapFromBitmapData(XtDisplay(toplevel),3             RootWindowOfScreen(XtScreen(toplevel)),nH             (char *) HOTJOT_bits, HOTJOT_width, HOTJOT_height, 1, 0, 1);6    XtVaSetValues(toplevel, XmNiconPixmap, icon, NULL);    *>    /* If more than one screen, create second toplevel shell */    if (num_screens > 1) {{       char *screen_str;(       char temp_str[5];   8       if ((screen_str = getenv("SYS$REM_NODE")) == NULL)0 	 if ((screen_str = getenv("SYS$NODE")) == NULL)
 	    exit(0);           if (screen_str != NULL) {_ 	 fake_argc += 2; % 	 strcpy(second_display, screen_str);) 	 XtFree(screen_str);X  ) 	 if (strcmp(screen_str, "FALSE") != 0) {W9 	    sprintf(temp_str, "0.%d", !XDefaultScreen(display));v5 	    strcat(second_display, temp_str);                 	 }l   	 XtFree(screen_str);e         } else {6 	 sprintf(temp_str, "0.%d", !XDefaultScreen(display));# 	 strcat(second_display, temp_str);        }*    }      if (fake_argc > 1) {*       Display *second_display;  9       second_display =  XtOpenDisplay(app_context, NULL, c 				      "HOTJOT2", "HOTJOT",   				      NULL, 0,  ! 				      &fake_argc, fake_argv);d4       toplevel2 = XtAppCreateShell("HOTJOT2", NULL, 8 				       applicationShellWidgetClass, second_display,  				       NULL, 0);:       XtVaSetValues(toplevel2, XmNiconPixmap, icon, NULL);!       XtRealizeWidget(toplevel2);k    } else {o       toplevel2 = toplevel;     }      XtRealizeWidget(toplevel);W  K    /* Place little window either off screen or in upper left hand corner */ I    XtVaSetValues(toplevel, XmNmwmDecorations, 2, XmNx, -100, XmNy, -100, d1                  XmNdeleteResponse, XmDO_NOTHING,t                  NULL);tJ    XtVaSetValues(toplevel2, XmNmwmDecorations, 2, XmNx, -100, XmNy, -100, 1                  XmNdeleteResponse, XmDO_NOTHING,                   NULL);x      /* Load in HOT JOT file *//    LoadHotJot();  "    /* Create a graphics context */    gcv.function   = GXxor;  '    gc = XCreateGC(XtDisplay(toplevel), )M                   DefaultRootWindow(XtDisplay(toplevel)), GCFunction, &gcv); i      /* Start autosave loop */    AutoSaveEH(toplevel,0);      XtAppMainLoop(app_context); }*