6 /* $Header: ico.c,v 1.4 88/02/09 13:15:08 jim Exp $ */< /***********************************************************H Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,H and the Massachusetts Institute of Technology, Cambridge, Massachusetts.  +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/ O /******************************************************************************   * DescriptionG  *	Display a wire-frame rotating icosahedron, with hidden lines removed   *
  * Arguments: ;  *	-r		display on root window instead of creating a new one @  *	=wxh+x+y	X geometry for new window (default 600x600 centered))  *	host:display	X display on which to run %  * (plus a host of others, try -help) O  *****************************************************************************/  /* Additions by jimmc@sci:  *  faces and colors#  *  double buffering on the display   *  additional polyhedra  *  sleep switch  */      #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xutil.h> #include <stdio.h>   #include "jw_b_rtns.h"   /*  F  * This example demonstrates how X Version 11 clients are supported onK  * DECwindows. It is a copy of the ICO demo program from the MIT X Version  I  * 11 Release 2 distribution. The only modifications made to this program H  * are the addition of this comment block and the two #define statements)  * for the random and srandom procedures.   *  D  * Please see the decw$examples:demo_build.com command procedure for8  * instructions on how to compile and link this program.  *    * To run this program, type:   *  !  * 	$ ico == "$decw$examples:ico"   *  2  * and follow the MIT provided instructions below.  *  &  * ICO 1 "1 March 1988" "X Version 11"  *    * NAME   *  7  *     ico - animate an icosahedron or other polyhedron   *    * SYNOPSIS   *  G  *     ico [-display display] [-geometry geometry] [-title windowtitle] 5  * 	[-r] [-d pattern] [-i] [-dbl] [-faces] [-noedges] <  * 	[-sleep n] [-obj object] [-objhelp] [-colors color-list]  *    * DESCRIPTION  *  G  *     Ico displays a wire-frame rotating polyhedron, with hidden lines L  *     removed, or a solid-fill polyhedron with hidden faces removed. There C  *     are a number of different polyhedra available; adding a new  1  *     polyhedron to the program is quite simple.   *  
  * OPTIONS  *    *   -r @  * 	Display on the root window instead of creating a new window.  *    *   -d pattern C  * 	Specify a bit pattern for drawing dashed lines for wire frames.   *    *   -i (  * 	Use inverted colors for wire frames.  *	  *   -dbl C  * 	Use double buffering on the display. This works for either wire E  * 	frame or solid fill drawings. For solid fill drawings, using this E  * 	switch results in substantially smoother movement. Note that this H  * 	requires twice as many bit planes as without double buffering. Since?  * 	some colors are typically allocated by other programs, most E  * 	eight-bit-plane displays will probably be limited to eight colors    * 	when using double buffering.  *    *   -faces -  * 	Draw filled faces instead of wire frames.   *  
  *   -noedges   * 	Don't draw the wire frames. ,  * 	Typically used only when -faces is used.  *  
  *   -sleep n 4  * 	Sleep n seconds between each move of the object.  *    *   -title windowtitle %  * 	Specify the title for the window. 2  * 	If no title is specified "Ico" is the default.  *  *   -obj object   * 	Specify what object to draw.7  * 	If no object is specified, an icosahedron is drawn.   *  
  *   -objhelp E  * 	Print out a list of the available objects, along with information   * 	about each object.  *    *   -colors color color ...F  * 	Specify what colors should be used to draw the filled faces of theG  * 	object. If less colors than faces are given, the colors are reused.   *    * ADDING POLYHEDRA   *  H  * If you have the source to ico, it is very easy to add more polyhedra.I  * Each polyhedron is defined in an include file by the name of objXXX.h, @  * where XXX is something related to the name of the polyhedron.D  * The format of the include file is defined in the file polyinfo.h.I  * Look at the file objcube.h to see what the exact format of an objXXX.h A  * file should be, then create your objXXX.h file in that format.   *  C  * After making the new objXXX.h file (or copying in a new one from E  * elsewhere), simply do a 'make depend'. This will recreate the file C  * allobjs.h, which lists all of the objXXX.h files. Doing a 'make' ?  * after this will rebuild ico with the new object information.   *    * BUGS   *  H  * A separate color cell is allocated for each name in the -colors list,2  * even when the same name may be specified twice.  *    * COPYRIGHT  *  9  * Copyright 1988, Massachusetts Institute of Technology.   *  */    #define random rand  #define srandom srand   ! typedef double Transform3D[4][4];   ; #include "polyinfo.h"	/* define format of one polyhedron */   A /* Now include all the files which define the actual polyhedra */  Polyinfo polys[] = { #include "allobjs.h" };. int polysize = sizeof(polys)/sizeof(polys[0]);   typedef struct { 	int prevX, prevY;A 	unsigned long *plane_masks;	/* points into dbpair.plane_masks */ < 	unsigned long enplanemask;	/* what we enable for drawing *// 	XColor *colors;		/* size = 2 ** totalplanes */ 6 	unsigned long *pixels;	/* size = 2 ** planesperbuf */ } DBufInfo;    typedef struct { 	int planesperbuf;* 	int pixelsperbuf;	/* = 1<<planesperbuf */( 	int totalplanes;	/* = 2*planesperbuf */( 	int totalpixels;	/* = 1<<totalplanes */5 	unsigned long *plane_masks;	/* size = totalplanes */  	unsigned long pixels[1]; 
 	int dbufnum;  	DBufInfo bufs[2]; 	DBufInfo *drawbuf, *dpybuf; } DBufPair;    DBufPair dbpair;   XColor bgcolor,fgcolor;    extern GC XCreateGC(); extern long time();  extern long random();    char *window_title = "Ico";  char *ProgramName;
 Display *dpy;  Window win;  int winWidth, winHeight; Colormap cmap; GC gc;   int dsync = 0; int dblbuf = 0;  int sleepcount = 0;  int isleepcount = 5; int numcolors = 0;) char **colornames;	/* points into argv */  int dofaces = 0; int doedges = 1;   Polyinfo *findpoly();    static char *help_message[] = {  "Where options include:", 7 "    -display host:dpy                X server to use", I "    -geometry geom                   Geometry of window to use WxH+X+Y", ? "    -r                               Draw in the root window", > "    -title windowtitle               Title for Ico's window",K "    -d number                        Dashed line pattern for wire frames", > "    -colors color ...                Colors to use on sides",< "    -dbl                             Use double buffering",C "    -noedges                         Don't draw wire frame edges", 2 "    -faces                           Draw faces",. "    -i                               Invert",I "    -sleep number                    Seconds to sleep in between draws", I "    -obj objname                     Type of polyhedral object to draw", I "    -objhelp                         List polyhedral objects available",  NULL};  O /******************************************************************************/  * DescriptionH  *	Main routine.  Process command-line arguments, then bounce a boundingD  *	box inside the window.  Call DrawIco() to redraw the icosahedron.O  *****************************************************************************/    main(argc, argv)	 int argc;t char **argv; 	{ 	char *display = NULL; 	char *geom = NULL;u 	int useRoot = 0;u 	int fg, bg; 	int invert = 0; 	int dash = 0; 	int winX, winY, winW, winH; 	XSetWindowAttributes xswa;n 	XWindowAttributes xwa;h( 	Polyinfo *poly;		/* the poly to draw */ 	int icoX, icoY; 	int icoDeltaX, icoDeltaY; 	int icoW, icoH; 	XEvent xev; 	XGCValues xgcv;   	ProgramName = argv[0];o   	/* Process arguments: */e  . 	poly = findpoly("icosahedron");	/* default */   	while (*++argv) {$ 		if (!strcmp (*argv, "-display")) { 			display = *++argv;E) 		} else if (!strncmp (*argv, "-g", 2)) {, 			geom = *++argv;7                 } else if (!strcmp (*argv, "-title")) {I/                         window_title = *++argv;F, 		} else if (**argv == '=') 		/* obsolete */ 			geom = *argv;  		else if (!strcmp(*argv, "-r")) 			useRoot = 1; ! 		else if (!strcmp (*argv, "-d"))E 			dash = atoi(*++argv);' 		else if (!strcmp(*argv, "-colors")) {* 			colornames = ++argv;*, 			for ( ; *argv && *argv[0]!='-'; argv++) ;! 			numcolors = argv - colornames;*
 			--argv; 		}*# 		else if (!strcmp (*argv, "-dbl"))  			dblbuf = 1;& 		else if (!strcmp(*argv, "-noedges")) 			doedges = 0;-$ 		else if (!strcmp(*argv, "-faces")) 			dofaces = 1;   		else if (!strcmp(*argv, "-i")) 			invert = 1;% 		else if (!strcmp (*argv, "-sleep"))p 			sleepcount = atoi(*++argv);& 		else if (!strcmp (*argv, "-isleep")) 			isleepcount = atoi(*++argv);*# 		else if (!strcmp (*argv, "-obj"))  			poly = findpoly(*++argv);$ 		else if (!strcmp(*argv, "-dsync"))
 			dsync = 1;a( 		else if (!strcmp(*argv, "-objhelp")) { 			giveObjHelp();c 			exit(1);b 		}  		else {	/* unknown arg */ 		    char **cpp;   
 		  usage:/                     fprintf (stderr," \n");    xA 		    fprintf (stderr, "Usage:  %s [-options]\n\n", ProgramName);C- 		    for (cpp = help_message; *cpp; cpp++) {r" 			fprintf (stderr, "%s\n", *cpp); 		    }i 		    fprintf (stderr, "\n");m 		    exit (1);a 		}* 	}  7 	if (!dofaces && !doedges) icoFatal("nothing to draw");t  # 	if (!(dpy= XOpenDisplay(display)))r
 	        {" 		perror("Cannot open display\n"); 		exit(-1);c
 	        }   	if (invert) 		{r+ 		fg = BlackPixel(dpy, DefaultScreen(dpy));a+ 		bg = WhitePixel(dpy, DefaultScreen(dpy));  		}	 	else= 		{c+ 		fg = WhitePixel(dpy, DefaultScreen(dpy)); + 		bg = BlackPixel(dpy, DefaultScreen(dpy));" 		}c  D 	/* Set up window parameters, create and map window if necessary: */  
 	if (useRoot)r 		{h 		win = DefaultRootWindow(dpy);  		winX = 0;d 		winY = 0;y/ 		winW = DisplayWidth(dpy, DefaultScreen(dpy));	0 		winH = DisplayHeight(dpy, DefaultScreen(dpy)); 		}	 	else  		{o
 		winW = 600;j
 		winH = 600;c= 		winX = (DisplayWidth(dpy, DefaultScreen(dpy)) - winW) >> 1;i> 		winY = (DisplayHeight(dpy, DefaultScreen(dpy)) - winH) >> 1; 		if (geom) 4 			XParseGeometry(geom, &winX, &winY, &winW, &winH);   		xswa.event_mask = 0; 		xswa.background_pixel = bg;a 		xswa.border_pixel = fg;o3 		win = XCreateWindow(dpy, DefaultRootWindow(dpy),  ! 		    winX, winY, winW, winH, 0,  - 		    DefaultDepth(dpy, DefaultScreen(dpy)),  : 		    InputOutput, DefaultVisual(dpy, DefaultScreen(dpy)),8 		    CWEventMask | CWBackPixel | CWBorderPixel, &xswa);1                 XStoreName(dpy,win,window_title); 
         /*8 	 *	XChangeProperty(dpy, win, XA_WM_NAME, XA_STRING, 8, ( 	 *			PropModeReplace, window_title, 3);
         */ 		XMapWindow(dpy, win);l. 		if (XGetWindowAttributes(dpy,win,&xwa)==0) {1 			icoFatal("cant get window attributes (size)");t 		}d 		winWidth = xwa.width;* 		winHeight = xwa.height;  		}a    ! 	/* Set up a graphics context: */-  # 	gc = XCreateGC(dpy, win, 0, NULL);i 	XSetForeground(dpy, gc, fg);u 	XSetBackground(dpy, gc, bg);*  
 	if (dash) 		{w# 		xgcv.line_style = LineDoubleDash;  		xgcv.dashes = dash; 6 		XChangeGC(dpy, gc, GCLineStyle | GCDashList, &xgcv); 		}n   	if (dofaces && numcolors>=1) {  	    int i,t,bits; 		bits = 0;a& 		for (t=numcolors; t; t=t>>1) bits++; 		initDBufs(fg,bg,bits);& 		/* don't set the background color */ 		for (i=0; i<numcolors; i++) {e$ 			setBufColname(i+1,colornames[i]); 		}h4 		setDisplayBuf(dblbuf?1:0);	/* insert new colors */ 	} 	else if (dblbuf || dofaces) { 		initDBufs(fg,bg,1);  	} 	if (!numcolors) numcolors=1;o   	if (dsync)t 		XSync(dpy, 0);  E 	/* Get the initial position, size, and speed of the bounding-box: */h   	icoW = icoH = 150;e 	srandom((int) time(0) % 231);1 	icoX = ((winW - icoW) * (random() & 0xFF)) >> 8;r1 	icoY = ((winH - icoH) * (random() & 0xFF)) >> 8;  	icoDeltaX = 13; 	icoDeltaY = 9;e    $ 	/* Bounce the box in the window: */  	 	for (;;)e 		{  		int prevX; 		int prevY;   		if (XPending(dpy)) 			XNextEvent(dpy, &xev);    		prevX = icoX;p 		prevY = icoY;e   		icoX += icoDeltaX;% 		if (icoX < 0 || icoX + icoW > winW)  			{ 			icoX -= (icoDeltaX << 1); 			icoDeltaX = - icoDeltaX;o 			} 		icoY += icoDeltaY;% 		if (icoY < 0 || icoY + icoH > winH)  			{ 			icoY -= (icoDeltaY << 1); 			icoDeltaY = - icoDeltaY;  			}  @ 		drawPoly(poly, win, gc, icoX, icoY, icoW, icoH, prevX, prevY); 		}e 	}  
 giveObjHelp()s {  int i; Polyinfo *poly;j6 	printf("%-16s%-12s  #Vert.  #Edges  #Faces  %-16s\n", 		"Name", "ShortName", "Dual");i$         for (i=0; i<polysize; i++) { 		poly = polys+i;l* 		printf("%-16s%-12s%6d%8d%8d    %-16s\n",# 			poly->longname, poly->shortname,c2 			poly->numverts, poly->numedges, poly->numfaces, 			poly->dual);t 	} }i  
 Polyinfo * findpoly(name) char *name;a {m int i; Polyinfo *poly;r 	for (i=0; i<polysize; i++) {m 		poly = polys+i;u' 		if (strcmp(name,poly->longname)==0 ||o3 		    strcmp(name,poly->shortname)==0) return poly;f 	}( 	icoFatal("can't find object %s", name); }{   icoClearArea(x,y,w,h); int x,y,w,h; {s 	if (dblbuf || dofaces) {]5 		XSetForeground(dpy, gc, dbpair.drawbuf->pixels[0]);o4 			/* use background as foreground color for fill */% 		XFillRectangle(dpy,win,gc,x,y,w,h);e 	} 	else {r  		XClearArea(dpy,win,x,y,w,h,0); 	} }*  O /******************************************************************************o  * Description<  *	Undraw previous polyhedron (by erasing its bounding box).&  *	Rotate and draw the new polyhedron.  *  * Input  *	poly		the polyhedron to drawe  *	win		window on which to draw;2  *	gc		X11 graphics context to be used for drawing4  *	icoX, icoY	position of upper left of bounding-box"  *	icoW, icoH	size of bounding-box1  *	prevX, prevY	position of previous bounding-boxGO  *****************************************************************************/e char drawn[MAXNV][MAXNV];m  = drawPoly(poly, win, gc, icoX, icoY, icoW, icoH, prevX, prevY)m Polyinfo *poly;  Window win;  GC gc; int icoX, icoY, icoW, icoH;= int prevX, prevY;n 	{ 	static int initialized = 0;   	Point3D *v = poly->v; 	int *f = poly->f; 	int NV = poly->numverts;  	int NF = poly->numfaces;    	static Transform3D xform; 	static Point3D xv[2][MAXNV];  	static int buffer;y 	register int p0;e 	register int p1;  	register XPoint *pv2; 	XSegment *pe; 	register Point3D *pxv;+ 	static double wo2, ho2; 	XPoint v2[MAXNV]; 	XSegment edges[MAXEDGES]; 	register int i;	 	int j,k;  	register int *pf; 	int facecolor;-   	int pcount;
 	double pxvz;  	XPoint ppts[MAXEDGESPERPOLY];  ( 	/* Set up points, transforms, etc.:  */   	if (!initialized)	s 		{  		Transform3D r1;  		Transform3D r2;   / 		FormatRotateMat('x', 5 * 3.1416 / 180.0, r1); / 		FormatRotateMat('y', 5 * 3.1416 / 180.0, r2);  		ConcatMat(r1, r2, xform);w  : 		bcopy((char *) v, (char *) xv[0], NV * sizeof(Point3D));
 		buffer = 0;    		wo2 = icoW / 2.0;d 		ho2 = icoH / 2.0;    		initialized = 1; 		}     0 	/* Switch double-buffer and rotate vertices: */   	buffer = !buffer;< 	PartialNonHomTransform(NV, xform, xv[!buffer], xv[buffer]);    7 	/* Convert 3D coordinates to 2D window coordinates: */*   	pxv = xv[buffer];
 	pv2 = v2; 	for (i = NV - 1; i >= 0; --i) 		{m/ 		pv2->x = (int) ((pxv->x + 1.0) * wo2) + icoX;x/ 		pv2->y = (int) ((pxv->y + 1.0) * ho2) + icoY;  		++pxv; 		++pv2; 		}*    F 	/* Accumulate edges to be drawn, eliminating duplicates for speed: */   	pxv = xv[buffer];
 	pv2 = v2; 	pf = f; 	pe = edges; 	bzero(drawn, sizeof(drawn));    	if (dblbuf) 		setDrawBuf(dbpair.dbufnum); 2 			/* switch drawing buffers if double buffered */> 	if (dofaces) {	/* for faces, need to clear before FillPoly */
 		if (dblbuf)p 			icoClearArea(1 				dbpair.drawbuf->prevX, dbpair.drawbuf->prevY,o 				icoW + 1, icoH + 1);1 		icoClearArea(prevX, prevY, icoW + 1, icoH + 1);r 	}   	if (dsync)e 		XSync(dpy, 0);  , 	for (i = NF - 1; i >= 0; --i, pf += pcount) 		{{  5 		pcount = *pf++;	/* number of edges for this face */r
 		pxvz = 0.0;i 		for (j=0; j<pcount; j++) { 			p0 = pf[j]; 			pxvz += pxv[p0].z;  		}e  ; 		/* If facet faces away from viewer, don't consider it: */d 		if (pxvz<0.0)v 			continue;   		if (dofaces) { 			if (numcolors)g  				facecolor = i%numcolors + 1; 			else	facecolor = 1; 			XSetForeground(dpy, gc,' 				dbpair.drawbuf->pixels[facecolor]);  			for (j=0; j<pcount; j++) {o 				p0 = pf[j];r 				ppts[j].x = pv2[p0].x; 				ppts[j].y = pv2[p0].y; 			}+ 			XFillPolygon(dpy, win, gc, ppts, pcount,g 				Convex, CoordModeOrigin);a 		}"   		if (doedges) { 			for (j=0; j<pcount; j++) {  				if (j<pcount-1) k=j+1;
 				else k=0;! 				p0 = pf[j];a 				p1 = pf[k];s 				if (!drawn[p0][p1]) {* 					drawn[p0][p1] = 1;  					drawn[p1][p0] = 1;a 					pe->x1 = pv2[p0].x; 					pe->y1 = pv2[p0].y; 					pe->x2 = pv2[p1].x; 					pe->y2 = pv2[p1].y;
 					++pe; 				}  			} 		}! 		}p  F 	/* Erase previous, draw current icosahedrons; sync for smoothness. */   	if (doedges) {y 		if (dofaces) {6 			XSetForeground(dpy, gc, dbpair.drawbuf->pixels[0]);, 				/* use background as foreground color */ 		}  		else { 			if (dblbuf)' 				icoClearArea(dbpair.drawbuf->prevX,n 					dbpair.drawbuf->prevY,r 					icoW + 1, icoH + 1);\2 			icoClearArea(prevX, prevY, icoW + 1, icoH + 1); 			if (dblbuf || dofaces)(3 				XSetForeground(dpy, gc, dbpair.drawbuf->pixels[r 					dbpair.pixelsperbuf-1]);	 		}}1 		XDrawSegments(dpy, win, gc, edges, pe - edges);  	}   	if (dsync)d 		XSync(dpy, 0);   	if (dblbuf) { 		dbpair.drawbuf->prevX = icoX;a 		dbpair.drawbuf->prevY = icoY;   		setDisplayBuf(dbpair.dbufnum); 	} 	XSync(dpy, 0);e 	if (dblbuf)& 		dbpair.dbufnum = 1 - dbpair.dbufnum;# 	if (sleepcount) sleep(sleepcount);i 	}   char *xalloc(nbytes) int nbytes;a {i char *p, *malloc();n  " 	p = malloc((unsigned int)nbytes); 	if (p) return p;d) 	fprintf(stderr,"ico: no more memory\n");t	 	exit(1);	 }    initDBufs(fg,bg,planesperbuf)X
 int fg,bg; int planesperbuf;D {l int i,j,jj,j0,j1,k,m,t;n DBufInfo *b, *otherb;l  $ 	dbpair.planesperbuf = planesperbuf;' 	dbpair.pixelsperbuf = 1<<planesperbuf;60 	dbpair.totalplanes = (dblbuf?2:1)*planesperbuf;, 	dbpair.totalpixels = 1<<dbpair.totalplanes;' 	dbpair.plane_masks = (unsigned long *)f5 		xalloc(dbpair.totalplanes * sizeof(unsigned long));& 	dbpair.dbufnum = 0;! 	for (i=0; i<(dblbuf?2:1); i++) {  		b = dbpair.bufs+i;9 		b->plane_masks = dbpair.plane_masks + (i*planesperbuf);d 		b->colors = (XColor *)/ 			xalloc(dbpair.totalpixels * sizeof(XColor));S 		b->pixels = (unsigned long *),7 			xalloc(dbpair.pixelsperbuf * sizeof(unsigned long));s 	}  1 	cmap = XDefaultColormap(dpy,DefaultScreen(dpy)); 
 	if (!cmap) {w) 		icoFatal("can't get default colormap");P 	}! 	t = XAllocColorCells(dpy,cmap,0,,: 		dbpair.plane_masks,dbpair.totalplanes, dbpair.pixels,1); 			/* allocate color planes */ 	if (t==0) {* 		icoFatal("can't allocate color planes"); 	}   	fgcolor.pixel = fg; 	bgcolor.pixel = bg;  	XQueryColor(dpy,cmap,&fgcolor);  	XQueryColor(dpy,cmap,&bgcolor);   	setBufColor(0,&bgcolor);  	setBufColor(1,&fgcolor);L! 	for (i=0; i<(dblbuf?2:1); i++) {u 		b = dbpair.bufs+i;
 		if (dblbuf)i 			otherb = dbpair.bufs+(1-i);7 		for (j0=0; j0<(dblbuf?dbpair.pixelsperbuf:1); j0++) {(0 		    for (j1=0; j1<dbpair.pixelsperbuf; j1++) {$ 			j = (j0<<dbpair.planesperbuf)|j1; 			if (i==0) jj=j;) 			else jj= (j1<<dbpair.planesperbuf)|j0;b* 			b->colors[jj].pixel = dbpair.pixels[0];# 			for (k=0, m=j; m; k++, m=m>>1) {i 				if (m&1)4 				   b->colors[jj].pixel |= dbpair.plane_masks[k]; 			}2 			b->colors[jj].flags = DoRed | DoGreen | DoBlue; 		    }f 		}b 		b->prevX = b->prevY = 0; 		b->enplanemask = 0;!" 		for (j=0; j<planesperbuf; j++) {' 			b->enplanemask |= b->plane_masks[j];t 		}o) 		for (j=0; j<dbpair.pixelsperbuf; j++) {:# 			b->pixels[j] = dbpair.pixels[0];m# 			for (k=0, m=j; m; k++, m=m>>1) {W 				if (m&1)) 				   b->pixels[j] |= b->plane_masks[k];o 			} 		}m 	}   	setDrawBuf(0);o  3 	XSetBackground(dpy, gc, dbpair.bufs[0].pixels[0]);i# 	XSetPlaneMask(dpy, gc, AllPlanes); C 	icoClearArea(0, 0, winWidth, winHeight); /* clear entire window */,9 	sleep(isleepcount);	/*** doesn't work without this!!! */  	XSync(dpy,0);   	setDisplayBuf(dblbuf?1:0);W }    setBufColname(n,colname) int n; char *colname; {o int t; XColor dcolor, color;l  3 	t = XLookupColor(dpy,cmap,colname,&dcolor,&color);i  	if (t==0) {	/* no such color */' 		icoFatal("no such color %s",colname);p 	} 	setBufColor(n,&color);W }c   setBufColor(n,color) int n;		/* color index */ ! XColor *color;	/* color to set */% {s int i,j,cx;  DBufInfo *b; unsigned long pix;  ! 	for (i=0; i<(dblbuf?2:1); i++) {o 		b = dbpair.bufs+i;4 		for (j=0; j<(dblbuf?dbpair.pixelsperbuf:1); j++) {" 			cx = n + j*dbpair.pixelsperbuf; 			pix = b->colors[cx].pixel;e 			b->colors[cx] = *color; 			b->colors[cx].pixel = pix; 2 			b->colors[cx].flags = DoRed | DoGreen | DoBlue; 		}; 	} }n  
 setDrawBuf(n)( int n; {s XGCValues xgcv;o unsigned long mask;(    	dbpair.drawbuf = dbpair.bufs+n;/ 	xgcv.plane_mask = dbpair.drawbuf->enplanemask;yA 	xgcv.foreground = dbpair.drawbuf->pixels[dbpair.pixelsperbuf-1];a- 	xgcv.background = dbpair.drawbuf->pixels[0];f$ 	mask = GCForeground | GCBackground;! 	if (dblbuf) mask |= GCPlaneMask;s! 	XChangeGC(dpy, gc, mask, &xgcv);r }l   setDisplayBuf(n) int n; {g 	dbpair.dpybuf= dbpair.bufs+n;A 	XStoreColors(dpy,cmap,dbpair.dpybuf->colors,dbpair.totalpixels);* }*   icoFatal(fmt,a0)
 char *fmt; {* 	fprintf(stderr,"ico: ");n 	fprintf(stderr,fmt,a0); 	fprintf(stderr,"\n");	 	exit(1);. }*  O /******************************************************************************e  * Description2  *	Concatenate two 4-by-4 transformation matrices.  *  * Input!  *	l		multiplicand (left operand)e   *	r		multiplier (right operand)  *	  * Outputn  *	*m		Result matrixO  *****************************************************************************/*   ConcatMat(l, r, m) register Transform3D l;a register Transform3D r;w register Transform3D m;  	{ 	register int i; 	register int j; 	register int k;   	for (i = 0; i < 4; ++i) 		for (j = 0; j < 4; ++j), 			m[i][j] = l[i][0] * r[0][j] 			    + l[i][1] * r[1][j] 			    + l[i][2] * r[2][j] 			    + l[i][3] * r[3][j];  	}      O /******************************************************************************s  * Description>  *	Format a matrix that will perform a rotation transformation<  *	about the specified axis.  The rotation angle is measured9  *	counterclockwise about the specified axis when lookingr(  *	at the origin from the positive axis.  *  * Input=  *	axis		Axis ('x', 'y', 'z') about which to perform rotationP(  *	angle		Angle (in radians) of rotation   *	A		Pointer to rotation matrix  *	  * Outputf   *	*m		Formatted rotation matrixO  *****************************************************************************/1   FormatRotateMat(axis, angle, m)2
 char axis;
 double angle;  register Transform3D m;* 	{
 	double s, c;  	double sin(), cos();   
 	IdentMat(m);	   	s = sin(angle); 	c = cos(angle);  
 	switch(axis)  		{h 		case 'x':r 			m[1][1] = m[2][2] = c;  			m[1][2] = s;; 			m[2][1] = -s;	 			break;  		case 'y':f 			m[0][0] = m[2][2] = c;  			m[2][0] = s;n 			m[0][2] = -s;	 			break;: 		case 'z':= 			m[0][0] = m[1][1] = c;f 			m[0][1] = s;  			m[1][0] = -s;	 			break;( 		}( 	}      O /******************************************************************************   * Description   *	Format a 4x4 identity matrix.  *	  * Output    *	*m		Formatted identity matrixO  *****************************************************************************/    IdentMat(m)  register Transform3D m;u 	{ 	register int i; 	register int j;   	for (i = 3; i >= 0; --i)s 		{* 		for (j = 3; j >= 0; --j) 			m[i][j] = 0.0;	 		m[i][i] = 1.0; 		}a 	}      O /******************************************************************************C  * Description9  *	Perform a partial transform on non-homogeneous points.pA  *	Given an array of non-homogeneous (3-coordinate) input points,cB  *	this routine multiplies them by the 3-by-3 upper left submatrixH  *	of a standard 4-by-4 transform matrix.  The resulting non-homogeneous  *	points are returned.w  *  * Input#  *	n		number of points to transform0  *	m		4-by-4 transform matrixa,  *	in		array of non-homogeneous input points  *	  * Output ;  *	*out		array of transformed non-homogeneous output pointsrO  *****************************************************************************/   % PartialNonHomTransform(n, m, in, out)  int n; register Transform3D m;o register Point3D *in;c register Point3D *out; 	{  	for (; n > 0; --n, ++in, ++out) 		{	? 		out->x = in->x * m[0][0] + in->y * m[1][0] + in->z * m[2][0];e? 		out->y = in->x * m[0][1] + in->y * m[1][1] + in->z * m[2][1];]? 		out->z = in->x * m[0][2] + in->y * m[1][2] + in->z * m[2][2];- 		}  	}