 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: = %    -backdrop           display image centered on a backdrop 9 %    -blur               apply a filter to blur the image > %    -border geometry    surround image with a border of color* %    -colormap type      Shared or Private@ %    -colors value       preferred number of colors in the imageH %    -colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV6 %    -comment string     annotate image with comment",5 %    -compress type      RunlengthEncoded or QEncoded = %    -contrast           enhance or reduce the image contrast I %    -crop geometry      preferred size and location of the cropped image = %    -delay seconds      display the next image after pausing E %    -density geometry   vertical and horizontal density of the image < %    -despeckle          reduce the speckles within an image7 %    -display server     display image to this X server G %    -dither             apply Floyd/Steinberg error diffusion to image D %    -edge               apply a filter to detect edges in the imageH %    -enhance            apply a digital filter to enhance a noisy imageC %    -equalize           perform histogram equalization to an image = %    -flip               flip image in the vertical direction ? %    -flop               flop image in the horizontal direction 2 %    -gamma value        level of gamma correctionH %    -geometry geometry  preferred size and location of the image window- %    -interlace type     NONE, LINE, or PLANE 3 %    -label name         assign a label to an image C %    -map type           display image using this Standard Colormap A %    -matte              store matte channel if the image has one A %    -modulate value     vary the brightness, saturation, and hue ; %    -monochrome         transform image to black and white 7 %    -negate             apply color inversion to image J %    -noise              reduce noise with a noise peak elimination filterM %    -normalize          transform image to span the full the range of colors A %    -page geometry      size and location of the Postscript page - %    -quality value      JPEG quality setting A %    -roll geometry      roll an image vertically or horizontally : %    -rotate degrees     apply Paeth rotation to the image8 %    -sample geometry    scale image with pixel sampling+ %    -scene value        image scene number 2 %    -size geometry      width and height of image< %    -sharpen            apply a filter to sharpen the imageJ %    -shear geometry     slide one edge of the image along the X or Y axis2 %    -size geometry      width and height of image? %    -treedepth value    depth of the color classification tree I %    -update seconds     detect when image file is modified and redisplay C %    -verbose            print detailed information about the image = %    -visual type        display image using this visual type C %    -window id          display image to background of this window . %    -write filename     write image to a file % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, > %  -name, -panGeometry, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 8 %    1    press and drag to select a command from a menuG %    2    press and drag to select an image editing command from a menu C %    3    press to magnify a region or load an image from a montage  %  %  Keyboard accelerators: - %    i    display information about the image # %    w    write the image to a file 1 %    p    print the image to a Postscript printer  %    d    delete the image file  %    C    create a blank canvas ' %    F2   grab an image from the screen # %    l    load an image from a file   %    n    display the next image" %    f    display the former image7 %    F3   select an image to load from the command line ( %    u    undo last image transformation0 %    r    restore the image to its original size" %    @    refresh the image window7 %    F7   toggle the colormap type: : Shared or Private . %    ,    display the next image after pausing %    <    half the image size  %    o    original image size  %    >    double the image size  %    %    resize the image %    t    trim the image edges %    [    crop the image %    ]    cut the image 0 %    |    flop image in the horizontal direction. %    -    flip image in the vertical direction/ %    /    rotate the image 90 degrees clockwise 7 %    \    rotate the image 90 degrees counter-clockwise  %    *    rotate the image %    s    shear the image # %    F8   vary the color brightness # %    F9   vary the color saturation  %    F10  vary the image hue! %    g    gamma correct the image $ %    F11  sharpen the image contrast! %    F12  dull the image contrast 5 %    =    perform histogram equalization on the image 6 %    N    perform histogram normalization on the image( %    ~    invert the colors of the image- %    D    reduce the speckles within an image , %    P    eliminate peak noise from an image %    S    sharpen the image  %    B    blur the image& %    E    detect edges within an image %    M    emboss an image  %    O    oil paint an image( %    G    convert the image to grayscale> %    #    set the maximum number of unique colors in the image& %    a    annotate the image with text# %    b    add a border to the image & %    x    composite image with another# %    c    edit an image pixel color * %    m    edit the image matte information %    !    add an image comment0 %    h    display information about this program0 %    v    display version number of this program- %    q    discard all images and exit program + %    1-9  change the level of magnification  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "widget.h"  #include "PreRvIcccm.h"    /*   Define declarations. */ #define MinPanSize  96 #define MaxStacksize  (1 << 15) # #define Push(up,left,right,delta) \ F   if ((p < (segment_stack+MaxStacksize)) && (((up)+(delta)) >= 0) && \'       (((up)+(delta)) < image->rows)) \      { \        p->y1=(up); \        p->x1=(left); \        p->x2=(right); \       p->y2=(delta); \       p++; \     }  /*   State declarations.  */ #define DefaultState  0x0000 #define EscapeState  0x0001  #define ExitState  0x0002   #define FormerImageState  0x0004 #define ModifierState  0x0008 ! #define MontageImageState  0x0010  #define NextImageState  0x0020( #define UpdateConfigurationState  0x0040   /*   Global declarations. */ static Display   *display;    static XWindows    *windows;    /*   Forward declarations.  */ static ImageN   *XMagickCommand _Declare((Display *,XResourceInfo *,XWindows *,unsigned int,     KeySym,Image **)),K   *XTileImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image *,      XEvent *));   
 static int5   XScreenEvent _Declare((Display *,XEvent *,char *));    static unsigned int G   XConfigureImageWindow _Declare((Display *,XResourceInfo *,XWindows *,      Image *)),G   XMatteEditImageWindow _Declare((Display *,XResourceInfo *,XWindows *,      Image *)),N   XNoisyImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image **)),F   XOilPaintImageWindow _Declare((Display *,XResourceInfo *,XWindows *,     Image **)), M   XPrintImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image *)), K   XRotateImageWindow _Declare((Display *,XResourceInfo *,XWindows *,double,      Image **)), P   XSharpenImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image **)),N   XShearImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image **)),L   XTrimImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image *)),M   XWriteImageWindow _Declare((Display *,XResourceInfo *,XWindows *,Image *));    static void I   XConfigureImageColormap _Declare((Display *,XResourceInfo *,XWindows *,      Image *)),5   XDrawPanRectangle _Declare((Display *,XWindows *)), @   XMagnifyImageWindow _Declare((Display *,XWindows *,XEvent *)),I   XMakePanImage _Declare((Display *,XResourceInfo *,XWindows *,Image *)), <   XPanImageWindow _Declare((Display *,XWindows *,XEvent *)),@   XMagnifyWindowCommand _Declare((Display *,XWindows *,KeySym)),L   XSetCropGeometry _Declare((Display *,XWindows *,RectangleInfo *,Image *)),H   XTranslateImageWindow _Declare((Display *,XWindows *,Image *,KeySym)),%   XWarning _Declare((char *,char *));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(terminate)  % + %  A description of each parameter follows:  % J %    o terminate: A value other than zero is returned if the program is to %      terminate immediately.  %  */ static void Usage(terminate) unsigned int   terminate; {    char     **p;  
   static char      *buttons[]=      { <       "1    press and drag to select a command from a menu",K       "2    press and drag to select an image editing command from a menu", G       "3    press to magnify a region or load an image from a montage",        (char *) NULL      },     *keys[]=     { 1       "i    display information about the image", '       "w    write the image to a file", 5       "p    print the image to a Postscript printer", #       "d    delete the image file", #       "C    create a blank canvas", +       "F2   grab an image from the screen", '       "l    load an image from a file", $       "n    display the next image",&       "f    display the former image",;       "F3   select an image to load from the command line", ,       "u    undo last image transformation",4       "r    restore the image to its original size",&       "@    refresh the image window",9       "F7   toggle the colormap type: Shared or Private", 2       ",    display the next image after pausing",!       "<    half the image size", !       "o    original image size", #       ">    double the image size",        "%    resize the image","       "t    trim the image edges",       "[    crop the image",       "]    cut the image", 4       "|    flop image in the horizontal direction",2       "-    flip image in the vertical direction",3       "/    rotate the image 90 degrees clockwise", <       "\\    rotate the image 90 degrees counter-clockwise",       "*    rotate the image",       "s    shear the image", '       "F8   vary the color brightness", '       "F9   vary the color saturation",         "F10  vary the image hue",%       "g    gamma correct the image", (       "F11  sharpen the image contrast",%       "F12  dull the image contrast", 9       "=    perform histogram equalization on the image", :       "N    perform histogram normalization on the image",,       "~    invert the colors of the image",1       "D    reduce the speckles within an image", 0       "P    eliminate peak noise from an image",       "S    sharpen the image",        "B    blur the image",*       "E    detect edges within an image",       "M    emboss an image",         "O    oil paint an image",,       "G    convert the image to grayscale",B       "#    set the maximum number of unique colors in the image",*       "a    annotate the image with text",'       "b    add a border to the image", *       "x    composite image with another",'       "c    edit an image pixel color", .       "m    edit the image matte information","       "!    add an image comment",4       "h    display information about this program",4       "v    display version number of this program",1       "q    discard all images and exit program", /       "1-9  change the level of magnification",        (char *) NULL      },     *options[]=      { A       "-backdrop           display image centered on a backdrop", =       "-blur               apply a filter to blur the image", B       "-border geometry    surround image with a border of color",.       "-colormap type      Shared or Private",D       "-colors value       preferred number of colors in the image",L       "-colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV",8       "-comment string     annotate image with comment",9       "-compress type      RunlengthEncoded or QEncoded", A       "-contrast           enhance or reduce the image contrast", M       "-crop geometry      preferred size and location of the cropped image", A       "-delay seconds      display the next image after pausing", I       "-density geometry   vertical and horizontal density of the image", @       "-despeckle          reduce the speckles within an image",;       "-display server     display image to this X server", K       "-dither             apply Floyd/Steinberg error diffusion to image", H       "-edge               apply a filter to detect edges in the image",L       "-enhance            apply a digital filter to enhance a noisy image",G       "-equalize           perform histogram equalization to an image", A       "-flip               flip image in the vertical direction", C       "-flop               flop image in the horizontal direction", 6       "-gamma value        level of gamma correction",L       "-geometry geometry  preferred size and location of the image window",1       "-interlace type     NONE, LINE, or PLANE", 7       "-label name         assign a label to an image", G       "-map type           display image using this Standard Colormap", E       "-matte              store matte channel if the image has one", E       "-modulate value     vary the brightness, saturation, and hue", ?       "-monochrome         transform image to black and white", ;       "-negate             apply color inversion to image", N       "-noise              reduce noise with a noise peak elimination filter",M       "-normalize          transform image to span the full range of colors", E       "-page geometry      size and location of the Postscript page", 1       "-quality value      JPEG quality setting", E       "-roll geometry      roll an image vertically or horizontally", >       "-rotate degrees     apply Paeth rotation to the image",/       "-scene value        image scene number", 6       "-size geometry      width and height of image",<       "-sample geometry    scale image with pixel sampling",@       "-sharpen            apply a filter to sharpen the image",N       "-shear geometry     slide one edge of the image along the X or Y axis",6       "-size geometry      width and height of image",C       "-treedepth value    depth of the color classification tree", M       "-update seconds     detect when image file is modified and redisplay", G       "-verbose            print detailed information about the image", A       "-visual type        display image using this visual type", G       "-window id          display image to background of this window", 2       "-write filename     write image to a file",       (char *) NULL      };  3   (void) fprintf(stderr,"Version: %s\n\n",Version);    (void) fprintf(stderr,N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);7   (void) fprintf(stderr,"\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++) '     (void) fprintf(stderr,"  %s\n",*p);    (void) fprintf(stderr,O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) fprintf(stderr,H     "resources as command line options:  -background, -bordercolor,\n");   (void) fprintf(stderr,P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) fprintf(stderr,E     "-name, -shared_memory, -panGeometry, -usePixmap, or -title.\n");    (void) fprintf(stderr,M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) fprintf(stderr,M     "example, specify +matte to store the image without a matte channel.\n");    (void) fprintf(stderr,M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) fprintf(stderr,M     "number.  To specify a particular image format, precede the filename\n");    (void) fprintf(stderr,N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) fprintf(stderr,O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); ?   (void) fprintf(stderr,"'-' for standard input or output.\n"); )   (void) fprintf(stderr,"\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++) '     (void) fprintf(stderr,"  %s\n",*p); 7   (void) fprintf(stderr,"\nKeyboard accelerators: \n"); (   for (p=keys; *p != (char *) NULL; p++)'     (void) fprintf(stderr,"  %s\n",*p);    if (terminate)     exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e W i n d o w                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Function XAnnotateImageWindow annotates the image with text.  % 5 %  The format of the XAnnotateImageWindow routine is:  % > %    XAnnotateImageWindow(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */M static unsigned int XAnnotateImageWindow(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { 
   static char      *ImageAnnotateHelp[]=      { 0       "Press a button to affect this behavior:",	       "", B       "1    Press to select a location within an image window to","       "     begin entering text.",	       "", A       "2    Press and drag to select a font color from a pop-up", 3       "     menu.  Choose from these font colors:", 	       "",        "         black",        "         blue",       "         cyan",       "         green",        "         gray",       "         red",        "         magenta",        "         yellow",       "         white",        "         Browser...",	       "", @       "If you select the color browser and press Grab, you can",C       "choose the font color by moving the pointer to the desired", 2       "color on the screen and press any button.",	       "", A       "3    Press and drag to select a font from a pop-up menu.", &       "     Choose from these fonts:",	       "",        "         fixed",        "         variable",       "         5x8",        "         6x10",       "         7x13bold",       "         8x13bold",       "         9x15bold",       "         10x20",        "         12x24",        "         Browser...",	       "", C       "     Other fonts can be specified with the font browser or", =       "     by setting the X resources font1 through font9.", 	       "", E       "Choosing a font and its color is optional.  The default font", D       "is fixed and the default color is black.  However, you must",E       "choose a location to begin entering text and press button 1.", C       "An underscore character will appear at the location of the", D       "cursor where you pressed button 1.  The cursor changes to a",:       "pencil to indicate you are in text mode.  To exit",        "immediately, press ESC.",	       "", D       "In text mode, any key presses will display the character at",>       "the location of the cursor and advance the underscore",A       "cursor.  Enter your text and once completed press ESC to", ?       "finish your image annotation.  To correct errors press", D       "BACKSPACE.  To delete an entire line of text, press DELETE.",D       "Any text that exceeds the boundaries of the image window is",4       "automatically continued onto the next line.",	       "", B       "The actual color you request for the font is saved in the",E       "image.  However, the color that appears in your image window", E       "could be different.  For example, on a monochrome screen the", E       "text will appear black or white even if you choose the color", C       "red as the font color.  However, the image saved to a file", ?       "with 'Write' is written with red lettering.  To assure", C       "the correct color text in the final image, any PseudoClass", *       "image is promoted to DirectClass.",       (char *) NULL,     };     char     *p,      text[MaxTextLength];     Cursor     cursor;      GC     annotate_context;      int      i,     x,     y;     static unsigned int      font_id = 0,     pen_id = 0;      unsigned int     height, 	     mask,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      Window     xwindow;     XAnnotateInfo      *annotate_info,      *previous_info;   
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map info window.   */   state=DefaultState; N   (void) sprintf(text," +%u+%u  ",windows->image.width,windows->image.height);1   XSetWindowExtents(display,&windows->info,text); '   XMapWindow(display,windows->info.id);    /*,     Track pointer until button 1 is pressed.   */O   XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,&mask); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);8         XDisplayInfoString(display,&windows->info,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { 4             XPanImageWindow(display,windows,&event);;             XSetWindowExtents(display,&windows->info,text);              break;           } 6         if (event.xbutton.window != windows->image.id)           break;%         switch (event.xbutton.button) 	         {            case Button1:            {              /*+               Change to text entering mode.              */             x=event.xbutton.x;             y=event.xbutton.y;             state|=ExitState;              break;           }            case Button2:            {              char(               color_name[MaxTextLength],*               *ColorMenu[MaxNumberPens+1];               int                pen_number;                /*)               Initialize menu selections.              */-             for (i=0; i < MaxNumberPens; i++) 7               ColorMenu[i]=resource_info->pen_color[i]; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */             pen_number= M               XMenuWidget(display,windows,"Font Color",ColorMenu,color_name); 0             if (pen_number == (MaxNumberPens-1))               {                  static char 3                   color_name[MaxTextLength]="gray";                    /*3                   Select a pen color from a dialog.                  */E                 resource_info->pen_color[MaxNumberPens-1]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }               if (pen_number >= 0)               {                  /*                    Set pen color.                 */"                 pen_id=pen_number;K                 (void) strcpy(color_name,resource_info->pen_color[pen_id]); M                 status=XParseColor(display,windows->image.map_info->colormap, L                   color_name,&windows->image.pixel_info->pen_color[pen_id]);                  if (status == 0)P                   XNoticeWidget(display,windows,"Color is unknown to X server:",                      color_name);E                 XBestPixel(display,windows->image.map_info->colormap, 0                   (XColor *) NULL,(unsigned int)E                   Min(windows->image.visual_info->colormap_size,256), A                   &windows->image.pixel_info->pen_color[pen_id]);                }              break;           }            case Button3:            {              char'               font_name[MaxTextLength], *               *FontMenu[MaxNumberFonts+1];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-1]="Browser...";3             FontMenu[MaxNumberFonts]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */             font_number=J               XMenuWidget(display,windows,"Font Name",FontMenu,font_name);2             if (font_number == (MaxNumberFonts-1))               {                  static char 3                   font_name[MaxTextLength]="fixed";                    /*4                   Select a font name from a browser.                 */E                 resource_info->font_name[MaxNumberFonts-1]=font_name; G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               } !             if (font_number >= 0)                {                  /*'                   Initialize font info.                  */O                 (void) strcpy(font_name,resource_info->font_name[font_number]); <                 font_info=XLoadQueryFont(display,font_name);6                 if (font_info == (XFontStruct *) NULL)G                   XNoticeWidget(display,windows,"Unable to load font:",                      font_name);                  else                   { (                     font_id=font_number;1                     XFreeFont(display,font_info);                    }                }              break;           } 	         }          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap info window as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    XFlush(display);   if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; =   annotate_info->height=font_info->ascent+font_info->descent; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetForeground(display,annotate_context,8     windows->image.pixel_info->pen_color[pen_id].pixel);   /*)     Begin annotating the image with text.    */   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { 4             XPanImageWindow(display,windows,&event);             break;           } ,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { E               XDrawString(display,windows->image.id,annotate_context, :                 text_info->x,text_info->y,text_info->text,)                 strlen(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          char!           command[MaxTextLength];            int            length;            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { #               key_symbol=XK_Delete;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=strlen(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case XK_Delete:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);L             XDrawString(display,windows->image.id,annotate_context,x,y,p,1);)             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               strlen(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             strlen(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } /           annotate_info->next=(XAnnotateInfo *) *             malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState)); C   XSetFont(display,annotate_context,windows->image.font_info->fid); *   XSetForeground(display,annotate_context,7     windows->image.pixel_info->foreground_color.pixel);    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;2         (void) free((char *) annotate_info->text);,         (void) free((char *) annotate_info);$         annotate_info=previous_info;         continue;        }      /*6       Determine foreground pixel index for font color.     */.     windows->image.pixel_info->annotate_color=3       windows->image.pixel_info->pen_color[pen_id]; 0     windows->image.pixel_info->annotate_index=0;/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == ?             windows->image.pixel_info->pen_color[pen_id].pixel)            { 8             windows->image.pixel_info->annotate_index=i;             break;           }      /**       Define the annotate geometry string.     */9     x_factor=UpShift(width)/windows->image.ximage->width; '     annotate_info->x+=windows->image.x; :     annotate_info->x=DownShift(annotate_info->x*x_factor);;     y_factor=UpShift(height)/windows->image.ximage->height; ;     annotate_info->y+=(windows->image.y-font_info->ascent); :     annotate_info->y=DownShift(annotate_info->y*y_factor);9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       (unsigned int) DownShift(annotate_info->width*x_factor),?       (unsigned int) DownShift(annotate_info->height*y_factor), -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */J     status=XAnnotateImage(display,windows->image.pixel_info,annotate_info,       False,image);      if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;.     (void) free((char *) annotate_info->text);(     (void) free((char *) annotate_info);      annotate_info=previous_info;   } A   XDefineCursor(display,windows->image.id,windows->image.cursor);    XFreeFont(display,font_info);    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image); D   (void) XConfigureImageWindow(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B l u r I m a g e W i n d o w                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % , %  Function XBlurImageWindow blurs an image. % 1 %  The format of the XBlurImageWindow routine is:  % A %    status=XBlurImageWindow(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o status: Function XBlurImageWindow return True if the image isF %      blurred.  False is returned is there is a memory shortage or if# %      the image cannot be blurred.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */I static unsigned int XBlurImageWindow(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { . #define BlurImageText  "  Blurring image...  "     Image      *blurred_image;      /*     Map info window.   */:   XSetWindowExtents(display,&windows->info,BlurImageText);'   XMapWindow(display,windows->info.id); ;   XDisplayInfoString(display,&windows->info,BlurImageText);    /*     Blur image scanlines.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);"   blurred_image=BlurImage(*image);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); &   if (blurred_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=blurred_image;    /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B o r d e r I m a g e W i n d o w                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Function XBorderImageWindow adds a border to an image.  % 3 %  The format of the XBorderImageWindow routine is:  % C %    status=XBorderImageWindow(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % G %    o status: Function XBorderImageWindow return True if the border is B %      added to the image.  False is returned is there is a memory1 %      shortage or if the border cannot be added.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */K static unsigned int XBorderImageWindow(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { 
   ColorPacket      border_color;      int 
     flags;     Image      *bordered_image;     RectangleInfo      border_info;  
   static char '     color_name[MaxTextLength] = "gray", &     geometry[MaxTextLength] = "10x10";     XColor
     color;     /*     Add a border to the image.   */;   XColorBrowserWidget(display,windows,"Select",color_name);    if (*color_name == '\0')     return(True); J   (void) XParseColor(display,windows->image.map_info->colormap,color_name,     &color);)   border_color.red=ColorShift(color.red); -   border_color.green=ColorShift(color.green); +   border_color.blue=ColorShift(color.blue); F   XDialogWidget(display,windows,"Add Border","Enter border geometry:",     geometry);   if (*geometry == '\0')     return(True); F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);8   if ((windows->image.crop_geometry != (char *) NULL) ||<       ((*image)->columns != windows->image.ximage->width) ||8       ((*image)->rows != windows->image.ximage->height))     { 
       char&         image_geometry[MaxTextLength];         /**         Update image with user transforms.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height); H       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         { =           (void) free((char *) windows->image.crop_geometry); 5           windows->image.crop_geometry=(char *) NULL; 	         }        windows->image.x=0;        windows->image.y=0;      } A   XDefineCursor(display,windows->image.id,windows->image.cursor);    border_info.width=0;   border_info.height=0; >   flags=XParseGeometry(geometry,&border_info.x,&border_info.y,,     &border_info.width,&border_info.height);!   if ((flags & HeightValue) == 0) )     border_info.height=border_info.width; @   bordered_image=BorderImage(*image,&border_info,&border_color);'   if (bordered_image == (Image *) NULL)      return(False);   DestroyImage(*image); $   bordered_image->class=DirectClass;   *image=bordered_image;8   windows->image.window_changes.width=(*image)->columns;6   windows->image.window_changes.height=(*image)->rows;@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e W i n d o w                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XColorEditImageWindow allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for G %  a PseudoClass image.  The floodfill algorithm is strongly based on a : %  similiar algorithm in "Graphics Gems" by Paul Heckbert. % 6 %  The format of the XColorEditImageWindow routine is: % ? %    XColorEditImageWindow(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */  + static void ColorFloodfill(image,x,y,color)  Image 	   *image;    int    x,   y;   XColor   color; {    int 
     delta,	     skip, 
     start,     x1,      x2;      register RunlengthPacket     *pixel;      register XSegment      *p;      RunlengthPacket      target;   
   XSegment     *segment_stack;      /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; .   if ((target.red == ColorShift(color.red)) &&2       (target.green == ColorShift(color.green)) &&.       (target.blue == ColorShift(color.blue)))     return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { D       Warning("Unable to recolor image","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (p > segment_stack)    {      /*       Pop segment off stack.     */     p--;
     x1=p->x1; 
     x2=p->x2;      delta=p->y2;     y=p->y1+delta;     /*!       Recolor neighboring pixels.      */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); '       if ((pixel->red != target.red) || +           (pixel->green != target.green) || '           (pixel->blue != target.blue))          break;'       pixel->red=ColorShift(color.red); +       pixel->green=ColorShift(color.green); )       pixel->blue=ColorShift(color.blue);      }      skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) $           Push(y,start,x1-1,-delta);         x=x1+1;        }      do     {        if (!skip)	         { *           for ( ; x < image->columns; x++)           { 5             pixel=image->pixels+(y*image->columns+x); -             if ((pixel->red != target.red) || 1                 (pixel->green != target.green) || -                 (pixel->blue != target.blue))                break;-             pixel->red=ColorShift(color.red); 1             pixel->green=ColorShift(color.green); /             pixel->blue=ColorShift(color.blue);            } "           Push(y,start,x-1,delta);           if (x > (x2+1)) $             Push(y,x2+1,x-1,-delta);	         }        skip=False;        for (x++; x <= x2 ; x++)       { 1         pixel=image->pixels+(y*image->columns+x); )         if ((pixel->red == target.red) && -             (pixel->green == target.green) && )             (pixel->blue == target.blue))            break;       }        start=x;     } while (x <= x2);   } &   (void) free((char *) segment_stack); }   N static unsigned int XColorEditImageWindow(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { 
   static char      *ImageColorEditHelp[]=     { 0       "Press a button to affect this behavior:",	       "", ?       "1    Press to select a pixel within an image window to", C       "     change its color.  Additional pixels may be recolored", B       "     as prescibed by the method you choose with button 3.",	       "", B       "2    Press and drag to select a pixel color from a pop-up",4       "     menu.  Choose from these pixel colors:",	       "",        "         black",        "         blue",       "         cyan",       "         green",        "         gray",       "         red",        "         magenta",        "         yellow",       "         white",        "         Browser...",	       "", E       "     Other pixel colors are specified with the color browser", E       "     or by setting the X resources pen1 through pen9.  Refer", .       "     to X RESOURCES for more details.",	       "", D       "3    Press and drag to select a color editing method from a",6       "     pop-up menu.  Choose from these methods:",	       "",        "         point",        "         replace",        "         floodfill", 	       "", F       "     The point method recolors just the single pixel selected",F       "     with the pointer.  The replace method recolors any pixel",H       "     that matches the color of the pixel you select with button",H       "     1.  Floodfill recolors any pixel that matches the color of",C       "     the pixel you select with button 1 and is a neighbor.", 	       "", C       "The actual color you request for the pixel is saved in the", E       "image.  However, the color that appears in your image window", C       "may be different.  For example, on a monochrome screen the", C       "pixel will appear black or white even if you choose red as", B       "the pixel color.  However, the image saved to a file with",:       "'Write' is written with red color.  To assure the",@       "correct color pixel in the final image, any PseudoClass",)       "image is promoted to DirectClass",        (char *) NULL,     };     char     text[MaxTextLength];     Cursor     cursor;      int      i,     x,
     x_offset,      y,
     y_offset;      static unsigned int      method = FloodfillMethodOp,      pen_id = 0;      unsigned int     height, 	     mask,      status, 
     width;     unsigned long 
     state,
     x_factor, 
     y_factor;      Window     xwindow;     XColor
     color;     XEvent
     event;     /*     Map info window.   */   state=DefaultState; N   (void) sprintf(text," +%u+%u  ",windows->image.width,windows->image.height);1   XSetWindowExtents(display,&windows->info,text); '   XMapWindow(display,windows->info.id);    /*,     Track pointer until button 1 is pressed.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */O   XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,&mask); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);8         XDisplayInfoString(display,&windows->info,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { 4             XPanImageWindow(display,windows,&event);;             XSetWindowExtents(display,&windows->info,text);              break;           } %         switch (event.xbutton.button) 	         {            case Button1:            {              /*               Exit loop.             */%             x_offset=event.xbutton.x; %             y_offset=event.xbutton.y; ,             state|=UpdateConfigurationState;             break;           }            case Button2:            {              char(               color_name[MaxTextLength],*               *ColorMenu[MaxNumberPens+1];               int                pen_number;                /*)               Initialize menu selections.              */-             for (i=0; i < MaxNumberPens; i++) 7               ColorMenu[i]=resource_info->pen_color[i]; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */             pen_number= N               XMenuWidget(display,windows,"Pixel Color",ColorMenu,color_name);0             if (pen_number == (MaxNumberPens-1))               {                  static char 3                   color_name[MaxTextLength]="gray";                    /*3                   Select a pen color from a dialog.                  */E                 resource_info->pen_color[MaxNumberPens-1]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }               if (pen_number >= 0)               {                  /*                    Set pen color.                 */"                 pen_id=pen_number;K                 (void) strcpy(color_name,resource_info->pen_color[pen_id]); M                 status=XParseColor(display,windows->image.map_info->colormap, L                   color_name,&windows->image.pixel_info->pen_color[pen_id]);                  if (status == 0)P                   XNoticeWidget(display,windows,"Color is unknown to X server:",                      color_name);E                 XBestPixel(display,windows->image.map_info->colormap, 0                   (XColor *) NULL,(unsigned int)E                   Min(windows->image.visual_info->colormap_size,256), A                   &windows->image.pixel_info->pen_color[pen_id]);                } <             XDefineCursor(display,windows->image.id,cursor);             break;           }            case Button3:            {              char%               command[MaxTextLength];                static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */L             method=XMenuWidget(display,windows,"Method",MethodMenu,command);<             XDefineCursor(display,windows->image.id,cursor);             break;           } 	         }          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap info window as cursor crosses its boundaries. 
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } )     if (state & UpdateConfigurationState)        {          int            x,           y;            register RunlengthPacket
           *p;   
         /*8           Pixel edit is relative to image configuration.
         */         x=0;         y=0;         width=image->columns;          height=image->rows; :         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); =         x_factor=UpShift(width)/windows->image.ximage->width; C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x; ?         y_factor=UpShift(height)/windows->image.ximage->height; C         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y; ;         color=windows->image.pixel_info->pen_color[pen_id];          switch (method) 	         {            case PointMethodOp:            default:           {              /*=               Update color information using point algorithm.              */%             image->class=DirectClass; (             if (!UncompressImage(image))               break;?             p=image->pixels+(y_offset*image->columns+x_offset); )             p->red=ColorShift(color.red); -             p->green=ColorShift(color.green); +             p->blue=ColorShift(color.blue);              break;           }            case ReplaceMethodOp:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=image->pixels;.             for (i=0; i < image->packets; i++)
             {                x+=(p->length+1); :               if (x >= (y_offset*image->columns+x_offset))                 break;               p++;
             } $             target=image->pixels[i];,             if (image->class == DirectClass)               {                   p=image->pixels;2                 for (i=0; i < image->packets; i++)                 { /                   if ((p->red == target.red) && 3                       (p->green == target.green) && /                       (p->blue == target.blue))                      { 3                       p->red=ColorShift(color.red); 7                       p->green=ColorShift(color.green); 5                       p->blue=ColorShift(color.blue);                      }                    p++;                 }                }              else               { '                 register unsigned short                    index;  #                 index=target.index; A                 image->colormap[index].red=ColorShift(color.red); E                 image->colormap[index].green=ColorShift(color.green); C                 image->colormap[index].blue=ColorShift(color.blue); !                 SyncImage(image);                }              break;           } !           case FloodfillMethodOp:            {              /*A               Update color information using floodfill algorithm.              */%             image->class=DirectClass; (             if (!UncompressImage(image))               break;:             ColorFloodfill(image,x_offset,y_offset,color);             break;           } 	         } 
         /*<           Update image colormap and return to color editing.
         */E         XConfigureImageColormap(display,resource_info,windows,image); J         (void) XConfigureImageWindow(display,resource_info,windows,image);7         XSetWindowExtents(display,&windows->info,text); 8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);        } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); A   XDefineCursor(display,windows->image.id,windows->image.cursor);    XFreeCursor(display,cursor);   XFlush(display);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e W i n d o w                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XCompositeImageWindow requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 6 %  The format of the XCompositeImageWindow routine is: % F %    status=XCompositeImageWindow(display,resource_info,windows,image) % + %  A description of each parameter follows:  % J %    o status: Function XCompositeImageWindow returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */N static unsigned int XCompositeImageWindow(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { 
   static char      *ImageCompositeHelp[]=     { E       "First a popup window is displayed requesting you to enter an", @       "image name. Press Composite, enter 'X:', or type a file",D       "name.  Press Cancel if you choose not to create a composite",D       "image.  When you specify X: as your file name, the filename",D       "has special meaning.  It specifies an X window by id, name,",E       "or root.  If no name is specified, the window is selected by", 2       "clicking the mouse in the desired window.",	       "", E       "A small window appears showing the location of the cursor in", C       "the image window.  You are now in composite mode.  To exit", D       "immediately, press ESC.  In composite mode,  Press a button",!       "to affect this behavior:", 	       "", ?       "1    Press to select a location within image window to", #       "     composite your image.", 	       "", C       "2    Press and drag to select a composite operation from a", C       "     pop-up menu.  Choose from these composite operations:", 	       "",        "         over",       "         in",       "         out",        "         atop",       "         xor",        "         plus",       "         minus",        "         add",        "         subtract",       "         difference",       "         replace", 	       "", D       "How each operator behaves is described below.  image window",D       "is the image currently displayed on your X server and image",<       "is the image obtained with the File Browser widget.",	       "", B       "over     The result is the union of the two image shapes,",A       "         with image obscuring image window in the region",        "         of overlap.", 	       "", @       "in       The result is simply image cut by the shape of",@       "         image window.  None of the image data of image",*       "         window is in the result.",	       "", @       "out      The resulting image is image with the shape of",'       "         image window cut out.", 	       "", E       "atop     The result is the same shape as image image window,", C       "         with image obscuring image window where the image", >       "         shapes overlap.  Note this differs from over",E       "         because the portion of image outside image window's", 6       "         shape does not appear in the result.",	       "", B       "xor      The result is the image data from both image and",B       "         image window that is outside the overlap region.",.       "         The overlap region is blank.",	       "", ?       "plus     The result is just the sum of the image data.", A       "         Output values are cropped to 255 (no overflow).", <       "         This operation is independent of the matte",       "         channels.", 	       "", D       "minus    The result of image - image window, with underflow",E       "         cropped to zero.  The matte channel is ignored (set", )       "         to 255, full coverage).", 	       "", C       "add      The result of image + image window, with overflow", ,       "         wrapping around (mod 256).",	       "", D       "subtract The result of image - image window, with underflow",B       "         wrapping around (mod 256).  The add and subtract",=       "         operators can be used to perform reversible", "       "         transformations.",	       "",        "difference", C       "         The result of abs(image - image window).  This is", ?       "         useful for comparing two very similar images.", 	       "", C       "replace  The resulting image is image window replaced with", @       "         image.  Here the matte information is ignored.",	       "", C       "The image compositor requires a matte, or alpha channel in", C       "the image for some operations.  This extra channel usually", B       "defines a mask which represents a sort of a cookie-cutter",A       "for the image.  This is the case when matte is 255 (full", A       "coverage) for pixels inside the shape, zero outside, and", A       "between zero and 255 on the boundary.  If image does not", ?       "have a matte channel, it is initialized with 0 for any", C       "pixel matching in color to pixel location (0,0), otherwise", 
       "255.", 	       "", E       "Note that matte information for image window is not retained", <       "for colormapped X server visuals (e.g. StaticColor,",C       "StaticColor, GrayScale, PseudoColor).  Correct compositing", D       "behavior may require a TrueColor or DirectColor visual or a",       "Standard Colormap.", 	       "", @       "Choosing a composite operator is optional.  The default",B       "operator is over.  However, you must choose a location to",A       "composite your image and press button 1.  Press and hold", C       "button 1 before releasing and an outline of the image will", 3       "appear to help you identify your location.", 	       "", E       "The actual colors of the composite image is saved.  However,", A       "the color that appears in image window may be different.", E       "For example, on a monochrome screen image window will appear", B       "black or white even though your composited image may have",D       "many colors.  If the image is saved to a file it is written",C       "with the correct colors.  To assure the correct colors are", D       "saved in the final image, any PseudoClass image is promoted",       "to DirectClass.",       (char *) NULL,     };     char     filename[MaxTextLength],     text[MaxTextLength];     Cursor     cursor;      Image      *composite_image;      int      i,     x,     y;     RectangleInfo      composite_info;      static unsigned int "     operator = ReplaceCompositeOp;     unsigned int     height, 	     mask, 
     width;     unsigned long      scale_factor, 
     state;     Window     xwindow;     XEvent
     event;     /*&     Request image file name from user.   */   (void) strcpy(filename,"x:"); ;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True); F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   /*     Read image.    */>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); A   XDefineCursor(display,windows->image.id,windows->image.cursor); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    /*     Map info window.   */   state=DefaultState; N   (void) sprintf(text," +%u+%u  ",windows->image.width,windows->image.height);1   XSetWindowExtents(display,&windows->info,text); '   XMapWindow(display,windows->info.id);    /*,     Track pointer until button 1 is pressed.   */O   XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,&mask);    composite_info.x=x;    composite_info.y=y;    composite_info.width=0;    composite_info.height=0;O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask); 0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);8         XDisplayInfoString(display,&windows->info,text);       } P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &composite_info);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows); P     XHighlightRegion(display,windows->image.id,windows->image.highlight_context,       &composite_info);      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 4         if (event.xbutton.window == windows->pan.id)           { 4             XPanImageWindow(display,windows,&event);;             XSetWindowExtents(display,&windows->info,text);              break;           } %         switch (event.xbutton.button) 	         {            case Button1:            { :             composite_info.width=composite_image->columns;8             composite_info.height=composite_image->rows;<             XDefineCursor(display,windows->image.id,cursor);             break;           }            case Button2:            {              char%               command[MaxTextLength];                static char                *CompositeMenu[]=                {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             operator= P               XMenuWidget(display,windows,"Operations",CompositeMenu,command)+1;             break;           }            default:             break;	         }          break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); ,         if (event.xbutton.button == Button1)J           if ((composite_info.width != 0) && (composite_info.height != 0))
             {                /*F                 User has selected the location of the composite image.               *//               composite_info.x=event.xbutton.x; /               composite_info.y=event.xbutton.y;                state|=ExitState; 
             }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;            int            length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap info window as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          composite_info.x=x;          composite_info.y=y;          break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XDefineCursor(display,windows->image.id,windows->image.cursor);    XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    XFlush(display);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width; %   composite_info.x+=windows->image.x; <   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height; %   composite_info.y+=windows->image.y; <   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *scaled_image;         /*         Scale composite image.       */       scaled_image= O         ScaleImage(composite_image,composite_info.width,composite_info.height); $       DestroyImage(composite_image);)       if (scaled_image == (Image *) NULL) 	         { I           XDefineCursor(display,windows->image.id,windows->image.cursor);            return(False);	         } #       composite_image=scaled_image;      }    /*(     Composite image with X image window.   */D   CompositeImage(*image,operator,composite_image,composite_info.x+x,     composite_info.y+y);    DestroyImage(composite_image);A   XDefineCursor(display,windows->image.id,windows->image.cursor);    /*     Update image colormap.   */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static void XConfigureImageColormap(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { < #define ConfigureColormapText  "  Configuring colormap...  "  
   Colormap
     colormap;      /*     Map info window.   *//   XCheckRefreshWindow(display,&windows->image); B   XSetWindowExtents(display,&windows->info,ConfigureColormapText);'   XMapWindow(display,windows->info.id); C   XDisplayInfoString(display,&windows->info,ConfigureColormapText); F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   /*     Make standard colormap.    */I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); 9   XSetWindowColormap(display,windows->popup.id,colormap);    if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e W i n d o w                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XConfigureImageWindow creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 6 %  The format of the XConfigureImageWindow routine is: % F %    status=XConfigureImageWindow(display,resource_info,windows,image) % + %  A description of each parameter follows:  % K %    o status: Function XConfigureImageWindow returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N static unsigned int XConfigureImageWindow(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  { ; #define ConfigureImageText  "  Configuring image...       "      unsigned int     height, 	     mask,      status, 
     width,
     x_factor, 
     y_factor;      XSizeHints     *size_hints;     XWindowChanges     window_changes;      /*)     Return if window dimensions are zero.    */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*     Map info window.   */?   XSetWindowExtents(display,&windows->info,ConfigureImageText); '   XMapWindow(display,windows->info.id); @   XDisplayInfoString(display,&windows->info,ConfigureImageText);F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   /*0     Resize image to fit image window dimensions.   */7   x_factor=UpShift(width)/windows->image.ximage->width; 9   y_factor=UpShift(height)/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */;   if (width > XDisplayWidth(display,windows->image.screen)) 7     width=XDisplayWidth(display,windows->image.screen);    window_changes.width=width; =   if (height > XDisplayHeight(display,windows->image.screen)) 9     height=XDisplayHeight(display,windows->image.screen);    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes); ;   if ((x_factor == UpShift(1)) && (y_factor == UpShift(1))) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update magnify window configuration.   */<   windows->magnify.x=DownShift(x_factor*windows->magnify.x);<   windows->magnify.y=DownShift(y_factor*windows->magnify.y);   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */   if (windows->pan.mapped)     { C       XWithdrawWindow(display,windows->pan.id,windows->pan.screen); ?       if ((x_factor == UpShift(1)) || (y_factor == UpShift(1))) ,         XMapWindow(display,windows->pan.id);     } 8   windows->image.x=DownShift(x_factor*windows->image.x);8   windows->image.y=DownShift(y_factor*windows->image.y);:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } 4   windows->pan.geometry=resource_info->pan_geometry;-   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,        &windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);A   XWithdrawWindow(display,windows->info.id,windows->info.screen); A   XDefineCursor(display,windows->image.id,windows->image.cursor);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e W i n d o w                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 4 %  Function XCropImageWindow crops the image window. % 1 %  The format of the XCropImageWindow routine is:  % A %    status=XCropImageWindow(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o status: Function XCropImageWindow returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */I static unsigned int XCropImageWindow(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {  #define RoiDelta  8   
   static char      *ImageCropHelp[]=      { C       "To define a cropping region, press button 1 and drag.  The", C       "cropping region is defined by a highlighted rectangle that", B       "expands or contracts as it follows the pointer.  Once you",D       "are satisfied with the cropping region, release the button.",E       "You can make adjustments by moving the pointer to one of the", E       "cropping rectangle corners, pressing a button, and dragging.", 	       "", B       "Finally, press RETURN to commit your cropping region.  To",4       "exit without cropping the image, press ESC.",       (char *) NULL,     };     char     text[MaxTextLength];     Cursor     cursor;      int      i,     x,     y;     RectangleInfo      crop_info,     highlight_info;      unsigned int	     mask;      unsigned long 
     state;     Window     xwindow;     XEvent
     event;     /*     Map info window.   */   state=DefaultState; ?   (void) sprintf(text," +%u+%u  ",windows->image.ximage->width, #     windows->image.ximage->height); 1   XSetWindowExtents(display,&windows->info,text); '   XMapWindow(display,windows->info.id);    /*,     Track pointer until button 1 is pressed.   */O   XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,&mask); !   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);8         XDisplayInfoString(display,&windows->info,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { 4             XPanImageWindow(display,windows,&event);;             XSetWindowExtents(display,&windows->info,text);              break;           } ,         if (event.xbutton.button == Button1)           {              /*B               Note first corner of cropping rectangle-- exit loop.             */<             XDefineCursor(display,windows->image.id,cursor);9             crop_info.x=windows->image.x+event.xbutton.x; 9             crop_info.y=windows->image.y+event.xbutton.y;              state|=ExitState;              break;           }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Cropping",ImageCropHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap info window as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);    if (state & EscapeState)     {        /*+         User want to exit without cropping.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } C   (void) sprintf(text," %ux%u+%u+%u ",windows->image.ximage->width, ?     windows->image.ximage->height,windows->image.ximage->width, #     windows->image.ximage->height); 1   XSetWindowExtents(display,&windows->info,text); B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState; +     XSelectInput(display,windows->image.id, @       windows->image.attributes.event_mask | PointerMotionMask);     do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); :           XDisplayInfoString(display,&windows->info,text);5           XHighlightRegion(display,windows->image.id, >             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */=       XIfEvent(display,&event,XScreenEvent,(char *) windows); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))3         XHighlightRegion(display,windows->image.id, <           windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*5             User has committed to cropping rectangle.            */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y; I           XDefineCursor(display,windows->image.id,windows->image.cursor);            state|=ExitState;            break;	         }          case Expose:           break;         case MotionNotify:	         {            /*1             Discard pending button motion events.            */C           while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } 3       if ((crop_info.x != x) && (crop_info.y != y)) 	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;            if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             { =               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }            if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         } #     } while (!(state & ExitState)); +     XSelectInput(display,windows->image.id, ,       windows->image.attributes.event_mask);     /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     { 1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);=       XIfEvent(display,&event,XScreenEvent,(char *) windows); 1       XHighlightRegion(display,windows->image.id, :         windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 6           if (event.xbutton.window == windows->pan.id)
             { 6               XPanImageWindow(display,windows,&event);=               XSetWindowExtents(display,&windows->info,text);                break;
             } 8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease:            break;         case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0) 9               XHighlightRegion(display,windows->image.id, B                 windows->image.highlight_context,&highlight_info);           break;	         }          case KeyPress:	         {            char#             command[MaxTextLength];              KeySym             key_symbol;              /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Cropping",ImageCropHelp);N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True); 6   if ((crop_info.width > 3) && (crop_info.height > 3))<     if ((crop_info.width != windows->image.ximage->width) ||<         (crop_info.height != windows->image.ximage->height))       { 
         /*D           Reconfigure image window as defined by cropping rectangle.
         */;         XSetCropGeometry(display,windows,&crop_info,image); <         windows->image.window_changes.width=crop_info.width;>         windows->image.window_changes.height=crop_info.height;J         (void) XConfigureImageWindow(display,resource_info,windows,image);       }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C u t I m a g e W i n d o w                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % - %  Function XCutImageWindow cuts the X image.  % 0 %  The format of the XCutImageWindow routine is: % @ %    status=XCutImageWindow(display,resource_info,windows,image) % + %  A description of each parameter follows:  % C %    o status: Function XCutImageWindow return True if the image is F %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static unsigned int XCutImageWindow(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { , #define CutImageText  "  Cutting image...  " #define HorizontalCutOp  0 #define VerticalCutOp  1  
   static char      *ImageCutHelp[]=     { 0       "Press a button to affect this behavior:",	       "", D       "1    Select a location within an image window to begin your",E       "     cut, press and hold.  Next, move the pointer to another", E       "     location in the image.  As you move a line will connect", E       "     the initial location and the pointer.  When you release", <       "     the button, the area within an image to cut is",?       "     determined by which cut direction you choose with",        "     button 3.", 	       "", C       "3    Press and drag to select a cut operator from a pop-up", 5       "     menu.  Choose from these cut operators:", 	       "",        "         horizontal",       "         vertical",	       "", E       "If the operator is horizontal, the area of the image between", A       "the two horizontal endpoints of the cut line is removed.", B       "Otherwise, the area of the image between the two vertical",.       "endpoints of the cut line is removed.",	       "", B       "To cancel the image cutting, move the pointer back to the",;       "starting point of the line and release the button.",        (char *) NULL,     };     char     text[MaxTextLength];     Image      *cut_image;      int      i,     x,     y;     RectangleInfo 
     cut_info;      static unsigned int      operator = HorizontalCutOp;      unsigned int
     distance,      height, 	     mask, 
     width;     unsigned long      scale_factor, 
     state;     Window     xwindow;     XEvent
     event;  
   XSegment     segment_info;      /*     Map info window.   */   state=DefaultState; N   (void) sprintf(text," +%u+%u  ",windows->image.width,windows->image.height);1   XSetWindowExtents(display,&windows->info,text); '   XMapWindow(display,windows->info.id);    /*,     Track pointer until button 1 is pressed.   */O   XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,&mask); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |      PointerMotionMask);    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);8         XDisplayInfoString(display,&windows->info,text);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 4         if (event.xbutton.window == windows->pan.id)           { 4             XPanImageWindow(display,windows,&event);;             XSetWindowExtents(display,&windows->info,text);              break;           } %         switch (event.xbutton.button) 	         {            case Button1:            {              /*@               User has committed to start point of cutting line.             */,             segment_info.x1=event.xbutton.x;,             segment_info.x2=event.xbutton.x;,             segment_info.y1=event.xbutton.y;,             segment_info.y2=event.xbutton.y;             state|=ExitState;              break;           }            case Button3:            {              char%               command[MaxTextLength];                static char                *CutMenu[]=                {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             operator= H               XMenuWidget(display,windows,"Operations",CutMenu,command);             break;           } 	         }          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextLength];            KeySym           key_symbol;   
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,:               "Help Viewer - Image Cutting",ImageCutHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*J           Map and unmap info window as text cursor crosses its boundaries.
         */!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); O   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */
   distance=0; ;   (void) sprintf(text," %ux%u+%u+%u ",windows->image.width, F     windows->image.height,windows->image.width,windows->image.height);1   XSetWindowExtents(display,&windows->info,text); B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      /*       Compute cutting geometry.      */$     if (operator == HorizontalCutOp)       { 9         cut_info.width=segment_info.x2-segment_info.x1+1; #         cut_info.x=segment_info.x1;          cut_info.height=0;         cut_info.y=0; .         if (segment_info.x1 > segment_info.x2)           { =             cut_info.width=segment_info.x1-segment_info.x2+1; '             cut_info.x=segment_info.x2;            }        }      else       {          cut_info.width=0; :         cut_info.height=segment_info.y2-segment_info.y1+1;         cut_info.x=0; #         cut_info.y=segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { >             cut_info.height=segment_info.y1-segment_info.y2+1;'             cut_info.y=segment_info.y2;            }        }      if (distance > 9)        { 
         /*-           Display info and draw cutting line. 
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); J         (void) sprintf(text," %ux%u%+d%+d",cut_info.width,cut_info.height,!           cut_info.x,cut_info.y); 8         XDisplayInfoString(display,&windows->info,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:          break;       case ButtonRelease:        { 
         /*-           User has committed to cutting line. 
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else1       if (segment_info.x2 > windows->image.width) -         segment_info.x2=windows->image.width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else2       if (segment_info.y2 > windows->image.height).         segment_info.y2=windows->image.height;     /*       Compute distance.      */
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));!   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*     Map info window.   */'   XMapWindow(display,windows->info.id); :   XDisplayInfoString(display,&windows->info,CutImageText);F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   /*5     Image cutting is relative to image configuration.    */8   if ((windows->image.crop_geometry != (char *) NULL) ||<       ((*image)->columns != windows->image.ximage->width) ||8       ((*image)->rows != windows->image.ximage->height))     { 
       char&         image_geometry[MaxTextLength];         /**         Update image with user transforms.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height); H       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         { =           (void) free((char *) windows->image.crop_geometry); 5           windows->image.crop_geometry=(char *) NULL; 	         }        windows->image.x=0;        windows->image.y=0;      } &   windows->image.window_changes.width=0     windows->image.ximage->width-cut_info.width;'   windows->image.window_changes.height= 2     windows->image.ximage->height-cut_info.height;   x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    cut_info.x+=windows->image.x; 0   cut_info.x=DownShift(cut_info.x*scale_factor);8   cut_info.width=DownShift(cut_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    cut_info.y+=windows->image.y; 0   cut_info.y=DownShift(cut_info.y*scale_factor);:   cut_info.height=DownShift(cut_info.height*scale_factor);   /*     Cut image.   */'   cut_image=CutImage(*image,&cut_info); A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); "   if (cut_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=cut_image;    /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e s p e c k l e I m a g e W i n d o w                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDespeckleImageWindow reduces the speckles within an image.  % 6 %  The format of the XDespeckleImageWindow routine is: % F %    status=XDespeckleImageWindow(display,resource_info,windows,image) % + %  A description of each parameter follows:  % M %    o status: Function XDespeckleImageWindow return True if the edges within F %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N static unsigned int XDespeckleImageWindow(display,resource_info,windows,image) Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { 6 #define DespeckleImageText  "  Despeckling image...  "     Image      *despeckled_image;     /*     Map info window.   */?   XSetWindowExtents(display,&windows->info,DespeckleImageText);%'   XMapWindow(display,windows->info.id);%@   XDisplayInfoString(display,&windows->info,DespeckleImageText);   /*     Despeckle image.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);*   despeckled_image=DespeckleImage(*image);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);P)   if (despeckled_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=despeckled_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. % 8 %  The format of the XDisplayBackgroundImage routine is: %u; %      XDisplayBackgroundImage(display,resource_info,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned fromo %      XOpenDisplay. %dK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.p %iE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.r %t %t */@ static void XDisplayBackgroundImage(display,resource_info,image) Displayt   *display;   
 XResourceInfo    *resource_info;    Imagea	   *image;n {b   char     visual_type[MaxTextLength];n     Image      *transformed_image;f     unsigned int     height,      status, 
     width;     Window     root_window;     XGCValuess     context_values;      XPixelInfo     pixel_info;s     XResourceInfos     resources;     XStandardColormapd     *map_info;  
   XVisualInfos     *visual_info;y     XWindowAttributes      window_attributes;  
   XWindowInfo      window_info;     /*     Determine target window.   */   window_info.id=(Window) NULL;c%   window_info.ximage=(XImage *) NULL; *   window_info.matte_image=(XImage *) NULL;#   window_info.pixmap=(Pixmap) NULL; )   window_info.matte_pixmap=(Pixmap) NULL;n"   window_info.shared_memory=False;;   root_window=XRootWindow(display,XDefaultScreen(display));o:   if (Latin1Compare(resource_info->window_id,"root") == 0)     window_info.id=root_window;r   else     {n-       if (isdigit(*resource_info->window_id))u7         window_info.id=XWindowByID(display,root_window, O           (Window) strtol((char *) resource_info->window_id,(char **) NULL,0)); *       if (window_info.id == (Window) NULL)         window_info.id=%F           XWindowByName(display,root_window,resource_info->window_id);*       if (window_info.id == (Window) NULL)M         Error("No window with specified id exists",resource_info->window_id);      }o   /*     Determine window visual id.X   */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display));fK   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display));u'   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);t   if (status != False)'     (void) sprintf(visual_type,"0x%lx",e5       XVisualIDFromVisual(window_attributes.visual));    transformed_image=image;5   if (resource_info->image_geometry == (char *) NULL)o!     if (!resource_info->backdrop)n       {t
         Imager           *sampled_image;r  
         /*%           Make image fill the screen.m
         */         sampled_image=N           SampleImage(image,window_attributes.width,window_attributes.height);,         if (sampled_image != (Image *) NULL)           image=sampled_image;       }]   /*     Allocate standard colormap.-   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)fK     Error("Unable to create standard colormap","Memory allocation failed");e%   map_info->colormap=(Colormap) NULL;a+   pixel_info.pixels=(unsigned long *) NULL;e   /*     Initialize visual info.    */   resources=(*resource_info);R#   resources.map_type=(char *) NULL; $   resources.visual_type=visual_type;;   visual_info=XBestVisualInfo(display,map_info,&resources);Q*   if (visual_info == (XVisualInfo *) NULL)=     Error("Unable to get visual",resource_info->visual_type);d   /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.e   */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground |s"     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize image window attributes.o   */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,i      resource_info,&window_info);   /*     Create the X image.    */#   window_info.width=image->columns; 3   if (window_info.width >= window_attributes.width)a.     window_info.width=window_attributes.width;!   window_info.height=image->rows; 5   if (window_info.height >= window_attributes.height) 0     window_info.height=window_attributes.height;O   status=XMakeImage(display,resource_info,&window_info,image,window_info.width,      window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   /*I     Adjust image dimensions as specified by backdrop or geometry options.n   */   width=window_info.width;   height=window_info.height;   if (resource_info->backdrop)     {        /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)- )         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     }e5   if (resource_info->image_geometry != (char *) NULL)      { 
       char(         default_geometry[MaxTextLength];  	       inta         flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints();m,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);4       flags=XWMGeometry(display,visual_info->screen,7         resource_info->image_geometry,default_geometry,dJ         window_info.border_width,size_hints,&window_info.x,&window_info.y,1         (int *) &width,(int *) &height,&gravity);e$       if (flags & (XValue | YValue))	         {o(           width=window_attributes.width;*           height=window_attributes.height;	         }g!       XFree((void *) size_hints);      }a   /*     Create the X pixmap.   */   window_info.pixmap= I     XCreatePixmap(display,window_info.id,width,height,window_info.depth);t*   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);u   /*!     Display pixmap on the window.    */C   if ((width > window_info.width) || (height > window_info.height)) K     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,m       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,      window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);C$   if (window_info.id == root_window)-     XRetainWindowColors(display,root_window);a   /*     Free resources.n   */!   if (transformed_image != image)p     DestroyImage(image);*   XFreePixmap(display,window_info.pixmap);$   XDestroyImage(window_info.ximage);0   XFreeGC(display,window_info.annotate_context);*   XFreeCursor(display,window_info.cursor);/   XFreeCursor(display,window_info.busy_cursor);d2   if (pixel_info.pixels != (unsigned long *) NULL),     (void) free((char *) pixel_info.pixels);   XFree((void *) map_info);    XFree((void *) visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %pO %                                                                             % O %                                                                             %iO %   X D i s p l a y I m a g e                                                 % O %                                                                             % O %                                                                             %sO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%D % L %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.e %e. %  The format of the XDisplayImage routine is: % N %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) % + %  A description of each parameter follows:a % F %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Load Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.n %aE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %e7 %    o argv: Specifies the application's argument list.e %r/ %    o argc: Specifies the number of arguments.g %"G %    o image: Specifies an address to an address of an Image structure;" %      returned from ReadImage.h %  %  */H static Image *XDisplayImage(display,resource_info,argv,argc,image,state) Display    *display;h  
 XResourceInfol   *resource_info;(   char	   **argv;a   int)   argc;)   Image 
   **image;  
 unsigned longt	   *state;- {w4 #define MagnifySize  256  /* must be a power of 2 */ #define MaxWindows  10  
   static char-     *ImagePanHelp[]=     { B       "When an image exceeds the width or height of the X server",D       "screen, display maps a small panning window.  The rectangle",B       "within an panning window shows the area that is currently",?       "displayed in the the image window.  To 'pan' about the",pB       "image, press and drag the mouse within an panning window.",A       "The panning rectangle moves with the mouse and the image", C       "window is updated to reflect the location of the rectangle",cC       "within an panning window.  When you have selected the area",I>       "of the image you wish to view, just release the mouse",       "button.",	       "", @       "Use the arrow keys to pan the image one pixel up, down,",/       "left, or right within an image window.",i	       "",nB       "The panning window goes away if the image becomes smaller",4       "than the dimensions of the X server screen.",	       "",nB       "If you force the panning window to withdraw, the image is",'       "restored to its original size.",O       (char *) NULL,     };     static unsigned charB     HighlightBitmap[] = {0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55},?     ShadowBitmap[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};e     char     command[MaxTextLength];w     Image      *displayed_image,S     *loaded_image;     inti     status;u     KeySym     key_symbol;)     register int     i;  
   static char,"     home_directory[MaxTextLength],%     working_directory[MaxTextLength];y     static WindowX     root_window;     static XClassHint      *class_hint;     static XFontStruct     *font_info;      static XImageC     former_ximage;     static XPixelInfoR     icon_pixel,n     pixel_info;g     static XPointe     montage_info;i     static XResourceInfo     icon_resources;D     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual,I(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHintsn     *manager_hints;S     static unsigned intD     number_windows;e  
   struct statg     file_info;     time_t
     timer,     time_stamp,o     update_time;     unsigned int     context_mask;r     XEvent
     event;     XGCValues%     context_values;%     XWindowChanges     window_changes;   *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {        /*#         Allocate standard colormap.        */       if (resource_info->debug) 	         { %           XSynchronize(display,True); 9           (void) fprintf(stderr,"Version: %s\n",Version); 	         } (       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) || 3           (icon_map == (XStandardColormap *) NULL)) O         Error("Unable to create standard colormap","Memory allocation failed");%)       map_info->colormap=(Colormap) NULL;%)       icon_map->colormap=(Colormap) NULL;s/       pixel_info.pixels=(unsigned long *) NULL;f,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL;f*       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL;i/       icon_pixel.pixels=(unsigned long *) NULL;t       /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default";u-       icon_resources.colormap=SharedColormap;gB       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);        if (resource_info->debug)l	         { -           (void) fprintf(stderr,"Visual:\n");bN           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth); C           (void) fprintf(stderr,"  size of colormap: %d entries\n",s(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",i'             visual_info->bits_per_rgb);,	         }        /*         Allocate atoms.p       */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL)aG         Error("Unable to create X windows","Memory allocation failed");gF       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);       if (resource_info->debug)B	         {e0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols); =           (void) fprintf(stderr,"    delete window: 0x%lx\n",l'             windows->wm_delete_window);t:           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n",m#             windows->im_protocols);,?           (void) fprintf(stderr,"    update colormap: 0x%lx\n",t)             windows->im_update_colormap);a<           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);F           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);	         }        /*)         Allocate class and manager hints.d       */#       class_hint=XAllocClassHint();c$       manager_hints=XAllocWMHints();0       if ((class_hint == (XClassHint *) NULL) ||/           (manager_hints == (XWMHints *) NULL))o:         Error("Unable to allocate X hints",(char *) NULL);       /*         Initialize window id's.m       */;       root_window=XRootWindow(display,visual_info->screen);o       number_windows=0; <       magick_windows[number_windows++]=(&windows->backdrop);8       magick_windows[number_windows++]=(&windows->icon);9       magick_windows[number_windows++]=(&windows->image); 8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->magnify); 7       magick_windows[number_windows++]=(&windows->pan);e;       magick_windows[number_windows++]=(&windows->command); 9       magick_windows[number_windows++]=(&windows->popup); (       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       montage_info.x=0;t       montage_info.y=0;i4       (void) getcwd(home_directory,MaxTextLength-1);     }l   /*!     Initialize Standard Colormap.    */   loaded_image=(Image *) NULL;   displayed_image=(*image);    if (resource_info->debug)r     { M       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename,eO         displayed_image->scene,displayed_image->columns,displayed_image->rows);l'       if (displayed_image->colors != 0) >         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     } J   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.    */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); 3   font_info=XBestFont(display,resource_info,False);o(   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);t   /*     Initialize graphic context.f   */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);e$   class_hint->res_name="superclass";&   class_hint->res_class="ImageMagick";-   manager_hints->flags=InputHint | StateHint;-   manager_hints->input=False;n.   manager_hints->initial_state=WithdrawnState;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,p     &windows->context);    if (resource_info->debug)aN     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid;p>   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;/   if (pixel_info.annotate_context != (GC) NULL)i1     XFreeGC(display,pixel_info.annotate_context);tJ   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;   pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)r<     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel;"-   if (pixel_info.widget_context != (GC) NULL)e/     XFreeGC(display,pixel_info.widget_context);    pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)s<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id,r0     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.r   */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL,n$     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;)   class_hint->res_name="icon";-   manager_hints->flags=InputHint | StateHint;,   manager_hints->input=False; +   manager_hints->initial_state=IconicState; E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,      &windows->icon);   if (resource_info->debug)%H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.    */>   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id, 1     GCBackground | GCForeground,&context_values); /   if (icon_pixel.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;    /*     Initialize image window.   */)   if (windows->image.id != (Window) NULL)%     {%0       (void) free((char *) windows->image.name);5       (void) free((char *) windows->image.icon_name);      } D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image);iB   windows->image.name=(char *) malloc(MaxTextLength*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextLength*sizeof(char));oJ   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))u     {u       /*#         User specified window name.u       */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);s     }n   else     { 
       char         *p;c         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+strlen(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator))          p--;:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);
       elseC         (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p, "           displayed_image->scene);0       (void) strcpy(windows->image.icon_name,p);     } 8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;H   if (windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;J   if (windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |t<     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);I   if (resource_info->backdrop || (windows->backdrop.id != (Window) NULL))      {c       /*#         Initialize backdrop window.s       */4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen);nK       windows->backdrop.height=XDisplayHeight(display,visual_info->screen);I'       windows->backdrop.border_width=0; '       windows->backdrop.immutable=True;fJ       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;&       class_hint->res_name="backdrop";B       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state=i:         resource_info->iconic ? IconicState : NormalState;I       XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,y         &windows->backdrop);       if (resource_info->debug) >         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id);n1       XClearWindow(display,windows->backdrop.id);t-       if (windows->image.id != (Window) NULL)r	         { 4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }        /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition; I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)- $         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);      },+   if (resource_info->name == (char *) NULL)o%     class_hint->res_name=client_name;i   else-     class_hint->res_name=resource_info->name;s>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state=e6     resource_info->iconic ? IconicState : NormalState;   XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),8     argv,argc,class_hint,manager_hints,&windows->image);   if (resource_info->debug) J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.d   */   windows->image.x=0;l   windows->image.y=0;iJ   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);    if (resource_info->use_pixmap)>     (void) XMakePixmap(display,resource_info,&windows->image);(   XMapWindow(display,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.ximage->width == former_ximage.width) &&@         (windows->image.ximage->height == former_ximage.height))>       XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*     Initialize info window.    */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);(   windows->info.name="ImageMagick Info";   windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition; +   windows->info.attributes.save_under=True;e4   windows->info.attributes.win_gravity=UnmapGravity;L   windows->info.attributes.event_mask=ButtonPressMask | StructureNotifyMask;   class_hint->res_name="info";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False;_+   manager_hints->initial_state=NormalState;a0   manager_hints->window_group=windows->image.id;K   XMakeWindow(display,windows->image.id,argv,argc,class_hint,manager_hints,c     &windows->info);   if (resource_info->debug) H     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*)     Initialize magnify window and cursor.r   */+   if (windows->magnify.id != (Window) NULL) 0     (void) free((char *) windows->magnify.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify); D   windows->magnify.name=(char *) malloc(MaxTextLength*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify);e@   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color, %     resource_info->foreground_color);i/   if (windows->magnify.cursor == (Cursor) NULL)_3     Error("Unable to create cursor",(char *) NULL);n%   windows->magnify.width=MagnifySize; &   windows->magnify.height=MagnifySize;I   windows->magnify.x=XDisplayWidth(display,windows->magnify.screen) >> 1; J   windows->magnify.y=XDisplayHeight(display,windows->magnify.screen) >> 1;)   windows->magnify.min_width=MagnifySize; *   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize;N*   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify; .   windows->magnify.attributes.save_under=True;=   windows->magnify.attributes.cursor=windows->magnify.cursor; N   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;!   class_hint->res_name="magnify"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState;e0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,      &windows->magnify);    if (resource_info->debug)eN     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);    windows->pan.name="Pan Icon"; 7   XBestIconSize(display,&windows->pan,displayed_image); -   while ((windows->pan.width < MinPanSize) &&r,          (windows->pan.height < MinPanSize))   {i     windows->pan.width<<=1;,     windows->pan.height<<=1;   }f4   windows->pan.geometry=resource_info->pan_geometry;-   if (windows->pan.geometry != (char *) NULL) A     ParseImageGeometry(windows->pan.geometry,&windows->pan.width,n       &windows->pan.height);A   windows->pan.x=XDisplayWidth(display,windows->pan.screen) >> 1;nB   windows->pan.y=XDisplayHeight(display,windows->pan.screen) >> 1;   windows->pan.immutable=True;*   windows->pan.attributes.save_under=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask | F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hint->res_name="pan";e?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,r     &windows->pan);a   if (resource_info->debug)SF     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Initialize command window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command); "   windows->command.border_width=0;$   windows->command.flags|=PPosition;7   windows->command.attributes.backing_store=WhenMapped; .   windows->command.attributes.save_under=True;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | *     LeaveWindowMask | StructureNotifyMask;5   windows->command.attributes.override_redirect=True;r!   class_hint->res_name="command"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;k   manager_hints->input=False;t+   manager_hints->initial_state=NormalState;*0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,      &windows->command);    if (resource_info->debug)dN     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);C   windows->command.highlight_stipple=XCreateBitmapFromData(display,>6     windows->command.id,(char *) HighlightBitmap,8,8);@   windows->command.shadow_stipple=XCreateBitmapFromData(display,3     windows->command.id,(char *) ShadowBitmap,8,8); F   XSetTransientForHint(display,windows->command.id,windows->image.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL)p.     (void) free((char *) windows->popup.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup);;B   windows->popup.name=(char *) malloc(MaxTextLength*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create popup window","Memory allocation failed");    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped; ,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask |wG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |_;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;n   class_hint->res_name="popup";t?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;m   manager_hints->input=True;+   manager_hints->initial_state=NormalState;m0   manager_hints->window_group=windows->image.id;E   XMakeWindow(display,root_window,argv,argc,class_hint,manager_hints,c     &windows->popup);;   if (resource_info->debug)nK     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id); A   windows->popup.highlight_stipple=XCreateBitmapFromData(display,h4     windows->popup.id,(char *) HighlightBitmap,8,8);>   windows->popup.shadow_stipple=XCreateBitmapFromData(display,1     windows->popup.id,(char *) ShadowBitmap,8,8);uD   XSetTransientForHint(display,windows->popup.id,windows->image.id);   SetWarningHandler(XWarning);   /*     Respond to events.   */3   timer=time((time_t *) NULL)+resource_info->delay;_   update_time=0;   if (resource_info->update)     {s       /*3         Determine when file data was last modified.S       */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;r     }]   *state&=(~FormerImageState);   *state&=(~MontageImageState);    *state&=(~NextImageState);   do   {p     /*       Handle a window event.     */"     if (resource_info->delay != 0)       {t*         if (timer < time((time_t *) NULL))%           if (!resource_info->update)s/             *state|=NextImageState | ExitState;n           else
             {                /*5                 Determine if image file was modified.(               */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {.                     /*&                       Redisplay image.                     */F                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL) 9                       *state|=NextImageState | ExitState;)                   } ?               timer=time((time_t *) NULL)+resource_info->delay;;
             } 9         if (XEventsQueued(display,QueuedAfterFlush) == 0)            {*             /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);_             continue;            }e       }n%     time_stamp=time((time_t *) NULL);      XNextEvent(display,&event);      if (!windows->image.stasis) C       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0;f     switch (event.type)n     {        case ButtonPress:        {s!         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))e           {x             /*-               Convert Alt-Button3 to Button2.e             */)             event.xbutton.button=Button2; -             event.xbutton.state&=(~Mod1Mask);w           }n9         if (event.xbutton.window == windows->backdrop.id)            { G             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           }_6         if (event.xbutton.window == windows->image.id)           { )             switch (event.xbutton.button)n
             {y               case Button1:                {o                 /*9                   Select a command from the command menu.e                 */C                 key_symbol=XCommandWidget(display,windows,command);S0                 if (key_symbol != XK_VoidSymbol)N                   loaded_image=XMagickCommand(display,resource_info,windows,0,1                     key_symbol,&displayed_image);_                 break;               }                case Button2:                {;                 /*8                   User pressed the image magnify button.                 */,                 if (windows->magnify.mapped)<                   XRaiseWindow(display,windows->magnify.id);                 else                   {e                     /*)                       Make magnify image.                      */N                     status=XMakeImage(display,resource_info,&windows->magnify,<                       (Image *) NULL,windows->magnify.width,/                       windows->magnify.height);n                     status|=K                       XMakePixmap(display,resource_info,&windows->magnify);e(                     if (status == False)L                       Error("Unable to create magnify image",(char *) NULL);<                     XMapRaised(display,windows->magnify.id);                   }t<                 XMagnifyImageWindow(display,windows,&event);                 break;               }>               case Button3:                {d>                 if (displayed_image->montage == (char *) NULL)                   {e%                     XBell(display,0);                      break;                   }                  /*F                   Load or delete a tile from a visual image directory.                 */L                 loaded_image=XTileImageWindow(display,resource_info,windows,*                   displayed_image,&event);3                 if (loaded_image != (Image *) NULL) I                   *state|=MontageImageState | NextImageState | ExitState; 0                 montage_info.x=windows->image.x;0                 montage_info.y=windows->image.y;                 break;               }t               default:                 break;
             }              break;           }i8         if (event.xbutton.window == windows->magnify.id)           {              char%               command[MaxTextLength];                int                factor;                static char                *MagnifyMenu[]=                {                  "2",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 "3",                 (char *) NULL,               };               static KeySym                MagnifyKeys[]=               {w                 XK_2,                  XK_4,                  XK_5,_                 XK_6,e                 XK_7,                  XK_8,                  XK_9,t                 XK_3               };               /*;               Select a magnify factor from the pop-up menu.o             */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)I               XMagnifyWindowCommand(display,windows,MagnifyKeys[factor]);a             break;           } 4         if (event.xbutton.window == windows->pan.id)           {=4             XPanImageWindow(display,windows,&event);             break;           }f9         timer=time((time_t *) NULL)+resource_info->delay;          break;       }X       case ButtonRelease:o         break;       case ClientMessage:e       {x!         if (resource_info->debug) I           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n", <             event.xclient.window,event.xclient.message_type,:             event.xclient.format,event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           {iE             if (*event.xclient.data.l == windows->im_update_colormap)f               {*                 /*=                   Update graphic context and window colormap.-                 */2                 for (i=0; i < number_windows; i++)                 {e@                   if (magick_windows[i]->id == windows->icon.id)                     continue; N                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context,h@                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel=e6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=n2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,M                      magick_windows[i]->mask,&magick_windows[i]->attributes);                  }i:                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);n                 break;               } B             if (*event.xclient.data.l == windows->im_former_image)               {a5                 *state|=FormerImageState | ExitState;t                 break;               };@             if (*event.xclient.data.l == windows->im_next_image)               { 3                 *state|=NextImageState | ExitState;                  break;               }t:             if (*event.xclient.data.l == windows->im_exit)               {t"                 *state|=ExitState;                 break;               }              break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)            break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {              *state|=ExitState;             break;           }x4         if (event.xclient.window == windows->pan.id)           {              /*E               Restore original image size when pan window is deleted.e             */M             windows->image.window_changes.width=windows->image.ximage->width;lO             windows->image.window_changes.height=windows->image.ximage->height;eG             (void) XConfigureImageWindow(display,resource_info,windows,                displayed_image);o           }=         break;       }        case ConfigureNotify:>       {>!         if (resource_info->debug)eH           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d\n",;             event.xconfigure.window,event.xconfigure.width,nK             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y);(9         if (event.xconfigure.window == windows->image.id)            {;             /*3               Image window has a new configuration.t             */C             if ((event.xconfigure.width == windows->image.width) &&xC                 (event.xconfigure.height == windows->image.height))C               break;8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;e             windows->image.y=0; :             if (displayed_image->montage != (char *) NULL)               { 0                 windows->image.x=montage_info.x;0                 windows->image.y=montage_info.y;               };?             if (windows->image.mapped && windows->image.stasis)                {                  /*4                   Update image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;iM                 windows->image.window_changes.height=event.xconfigure.height;cK                 (void) XConfigureImageWindow(display,resource_info,windows,e#                   displayed_image);                }i             elseL               if ((event.xconfigure.width < windows->image.ximage->width) ||L                   (event.xconfigure.height < windows->image.ximage->height))                 {d6                   XMapRaised(display,windows->pan.id);5                   XDrawPanRectangle(display,windows);(                 }l               else(                 if (windows->pan.mapped)O                   XWithdrawWindow(display,windows->pan.id,windows->pan.screen);n             break;           };;         if (event.xconfigure.window == windows->magnify.id)r           {              unsigned int               magnify;               /*5               Magnify window has a new configuration.D             */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)y               break;             magnify=1;5             while (magnify <= event.xconfigure.width)                magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))g               {--                 window_changes.width=magnify;m.                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id,aN                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               }eF             status=XMakeImage(display,resource_info,&windows->magnify,M               (Image *) NULL,windows->magnify.width,windows->magnify.height);eI             status|=XMakePixmap(display,resource_info,&windows->magnify);m              if (status == False)D               Error("Unable to create magnify image",(char *) NULL);/             XMakeMagnifyImage(display,windows);%             break;           } 7         if (event.xconfigure.window == windows->pan.id)            {              /*2               Icon window has a new configuration.             */6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           } 8         if (event.xconfigure.window == windows->icon.id)           {              /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width; 9             windows->icon.height=event.xconfigure.height;%             break;           }%         break;       }%       case EnterNotify:        { 
         /*'           Selectively install colormap.f
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)f8             XInductColormap(display,map_info->colormap);         break;       }        case Expose:       {u!         if (resource_info->debug)o>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y);o
         /*/           Refresh windows that are now exposed.e
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             {R=               XRefreshWindow(display,&windows->image,&event);s?               timer=time((time_t *) NULL)+resource_info->delay;s               break;
             }n8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0)m(             if (windows->magnify.mapped)               { 3                 XMakeMagnifyImage(display,windows);a                 break;               }n4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0)a
             { 1               XDrawPanRectangle(display,windows);i               break;
             };5         if (event.xexpose.window == windows->icon.id)i'           if (event.xexpose.count == 0)r
             {d<               XRefreshWindow(display,&windows->icon,&event);               break;
             }          break;       }t       case KeyPress:       {u         int            length;a  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL);%         *(command+length)='\0';%!         if (resource_info->debug)%N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);3         if (event.xkey.window == windows->image.id) D           loaded_image=XMagickCommand(display,resource_info,windows,:             event.xkey.state,key_symbol,&displayed_image);5         if (event.xkey.window == windows->magnify.id) <           XMagnifyWindowCommand(display,windows,key_symbol);1         if (event.xkey.window == windows->pan.id)            { #             if (key_symbol == XK_q) K               XWithdrawWindow(display,windows->pan.id,windows->pan.screen); A             if ((key_symbol == XK_F1) || (key_symbol == XK_Help))%B               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);           }t9         timer=time((time_t *) NULL)+resource_info->delay;c         break;       }        case KeyRelease:       {t
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL);o!         if (resource_info->debug)pG           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,              *command);         break;       }a       case LeaveNotify:u       { 
         /*)           Selectively uninstall colormap.t
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)i:             XUninductColormap(display,map_info->colormap);         break;       }        case MapNotify:W       { !         if (resource_info->debug) I           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window); 6         if (event.xmap.window == windows->backdrop.id)           {aD             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime);              break;           }r3         if (event.xmap.window == windows->image.id)i           {"6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap);>3             if (*displayed_image->filename == '\0')dO               loaded_image=XMagickCommand(display,resource_info,windows,0,XK_l,r"                 &displayed_image);H             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;s             break;           } 5         if (event.xmap.window == windows->magnify.id)m           {|/             XMakeMagnifyImage(display,windows);>)             windows->magnify.mapped=True;_             break;           } 1         if (event.xmap.window == windows->pan.id)            {vD             XRefreshWindow(display,&windows->image,(XEvent *) NULL);I             XMakePanImage(display,resource_info,windows,displayed_image);>%             windows->pan.mapped=True;              break;           }t2         if (event.xmap.window == windows->info.id)           {w&             windows->info.mapped=True;             break;           }h2         if (event.xmap.window == windows->icon.id)           {w             /*#               Create an icon image.w             */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon,HH               displayed_image,windows->icon.width,windows->icon.height);G             (void) XMakePixmap(display,&icon_resources,&windows->icon);a@             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id);_&             windows->icon.mapped=True;             break;           }(7         if (event.xunmap.window == windows->command.id)e           {,)             windows->command.mapped=True;s             break;           })5         if (event.xunmap.window == windows->popup.id)%           {%'             windows->popup.mapped=True;%             break;           }          break;       }        case MappingNotify:        { 1         XRefreshKeyboardMapping(&event.xmapping);          break;       }        case NoExpose:         break;       case ReparentNotify:       { !         if (resource_info->debug) B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }        case UnmapNotify:        { !         if (resource_info->debug) M           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);%5         if (event.xunmap.window == windows->image.id)%           { (             windows->image.mapped=False;             break;           } 7         if (event.xunmap.window == windows->magnify.id)l           {o*             windows->magnify.mapped=False;             break;           } 3         if (event.xunmap.window == windows->pan.id)b           {T&             windows->pan.mapped=False;             break;           }a4         if (event.xunmap.window == windows->info.id)           {n'             windows->info.mapped=False;d             break;           } 4         if (event.xunmap.window == windows->icon.id)           {u9             if (map_info->colormap == icon_map->colormap)uD               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image);nL             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;m             break;           } 5         if (event.xunmap.window == windows->popup.id)p           {,6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);e(             windows->popup.mapped=False;             break;           }(7         if (event.xunmap.window == windows->command.id)i           {)*             windows->command.mapped=False;             break;           }.         break;       }e       default:       {e!         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }k     }/   }e    while (!(*state & ExitState));?   if ((*state & FormerImageState) || (*state & NextImageState))*     *state&=(~ExitState);n)   former_ximage=(*windows->image.ximage);a   /*     Alert user we are busy.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);5   if (resource_info->write_filename != (char *) NULL)*     {        /**         Update image with user transforms.       */<       if ((windows->image.crop_geometry != (char *) NULL) ||G           (displayed_image->columns != windows->image.ximage->width) || C           (displayed_image->rows != windows->image.ximage->height))>	         {e           char*             image_geometry[MaxTextLength];             /*.             Crop and/or scale displayed image.           */N           (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,+             windows->image.ximage->height);pG           TransformImage(&displayed_image,windows->image.crop_geometry,r             image_geometry);	         }l,       if (resource_info->number_colors != 0)	         {f           /*5             Reduce the number of colors in the image.            */8           if ((displayed_image->class == DirectClass) ||I               (displayed_image->colors > resource_info->number_colors) ||t<               (resource_info->colorspace == GRAYColorspace))G             QuantizeImage(displayed_image,resource_info->number_colors, >               resource_info->tree_depth,resource_info->dither,)               resource_info->colorspace); %           SyncImage(displayed_image);a	         }      }    /*$     Withdraw pan and magnify window.   */   if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);p   if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);e/   XCheckRefreshWindow(display,&windows->image);b   if (*state & ExitState)      {        /*         Destroy X windows.       */(       for (i=0; i < number_windows; i++)       {u3         if (magick_windows[i]->id != (Window) NULL)f8           XDestroyWindow(display,magick_windows[i]->id);9         if (magick_windows[i]->ximage != (XImage *) NULL) 3           XDestroyImage(magick_windows[i]->ximage);[7         if (magick_windows[i]->pixmap != (Pixmap) NULL):9           XFreePixmap(display,magick_windows[i]->pixmap);a       }i       /*         Free Standard Colormap.A       */3       if (resource_info->map_type == (char *) NULL)bH         XFreeStandardColormap(display,visual_info,map_info,&pixel_info);$       (void) free((void *) windows);!       XFree((void *) class_hint); $       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);        XFree((void *) map_info); '       visual_info=(XVisualInfo *) NULL;      }    XFlush(display);3   (void) getcwd(working_directory,MaxTextLength-1);    (void) chdir(home_directory);o   *image=displayed_image;    return(loaded_image);  }  b /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %gO %                                                                             %"O %                                                                             %lO %   X D r a w P a n R e c t a n g l e                                         %eO %                                                                             % O %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %oK %  Function XDrawPanRectangle draws a rectangle in the pan window.  The panoJ %  window displays a scaled image and the rectangle shows which portion of. %  the image is displayed in the image window. %l2 %  The format of the XDrawPanRectangle routine is: % ' %    XDrawPanRectangle(display,windows)  %e+ %  A description of each parameter follows:  %hE %    o display: Specifies a connection to an X server;  returned fromm %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %; */. static void XDrawPanRectangle(display,windows) Display    *display;    XWindows   *windows;t {    unsigned longs     scale_factor;s     RectangleInfoh     highlight_info;p     /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width);d<   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height);a<   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);I   XHighlightRegion(display,windows->pan.id,windows->pan.annotate_context,r     &highlight_info);a }i u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %lO %                                                                             %sO %                                                                             % O %   X E m b o s s I m a g e W i n d o w                                       %wO %                                                                             %-O %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %i1 %  Function XEmbossImageWindow embosses an image.a %i3 %  The format of the XEmbossImageWindow routine is:, %nC %    status=XEmbossImageWindow(display,resource_info,windows,image)( %n+ %  A description of each parameter follows:e %tJ %    o status: Function XEmbossImageWindow return True if the edges withinF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.t % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.1 % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.m %P %; */K static unsigned int XEmbossImageWindow(display,resource_info,windows,image)o DisplayN   *display;"  
 XResourceInfo    *resource_info;a   XWindows   *windows;L   Image 
   **image; { 1 #define EmbossImageText  "  Embossing image...  "      Image/     *embossed_image;     /*     Map info window.   */<   XSetWindowExtents(display,&windows->info,EmbossImageText);'   XMapWindow(display,windows->info.id); =   XDisplayInfoString(display,&windows->info,EmbossImageText);o   /*     Emboss image scanlines.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);%   embossed_image=EmbossImage(*image);xA   XDefineCursor(display,windows->image.id,windows->image.cursor);pA   XWithdrawWindow(display,windows->info.id,windows->info.screen); '   if (embossed_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=embossed_image;   /*     Update image configuration.o   */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);s }a C /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%wO %                                                                             % O %                                                                             % O %                                                                             %_O %   X E d g e I m a g e W i n d o w                                           % O %                                                                             %oO %                                                                             %CO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%L %t; %  Function XEdgeImageWindow detects edges within an image.= % 1 %  The format of the XEdgeImageWindow routine is:  % A %    status=XEdgeImageWindow(display,resource_info,windows,image)) %L+ %  A description of each parameter follows:  % H %    o status: Function XEdgeImageWindow return True if the edges withinF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %SF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage./ %  %  */I static unsigned int XEdgeImageWindow(display,resource_info,windows,image)  Displayy   *display;p  
 XResourceInfo)   *resource_info;(   XWindows   *windows;    Image 
   **image; { / #define EdgeImageText  "  Detecting edges...  "      Image      *edged_image;      /*     Map info window.   */:   XSetWindowExtents(display,&windows->info,EdgeImageText);'   XMapWindow(display,windows->info.id); ;   XDisplayInfoString(display,&windows->info,EdgeImageText);i   /*     Edge image scanlines.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);    edged_image=EdgeImage(*image);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); $   if (edged_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=edged_image;y   /*     Update image configuration.=   */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);- }f a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             % O %                                                                             % O %   X F l i p I m a g e W i n d o w                                           %wO %                                                                             % O %                                                                             % O %                                                                             %*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= % N %  Function XFlipImageWindow flips the scanlines of an image in the horizontal
 %  direction.- %a1 %  The format of the XFlipImageWindow routine is:) %aA %    status=XFlipImageWindow(display,resource_info,windows,image)  %i+ %  A description of each parameter follows:w %iL %    o status: Function XFlipImageWindow return True if the window scanlinesJ %      reverse.  False is returned is there is a memory shortage or if the) %      window scanlines fails to reverse.a %yD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.l % < %    o windows: Specifies a pointer to a XWindows structure. %iF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %( */I static unsigned int XFlipImageWindow(display,resource_info,windows,image)o Displayg   *display;o  
 XResourceInfo    *resource_info;f   XWindows   *windows;    Imagen
   **image; {o. #define FlipImageText  "  Flipping image...  "     Image      *flipped_image;      /*     Map info window.   */:   XSetWindowExtents(display,&windows->info,FlipImageText);'   XMapWindow(display,windows->info.id); ;   XDisplayInfoString(display,&windows->info,FlipImageText);    /*     Flip image scanlines.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);"   flipped_image=FlipImage(*image);A   XDefineCursor(display,windows->image.id,windows->image.cursor);rA   XWithdrawWindow(display,windows->info.id,windows->info.screen);>&   if (flipped_image == (Image *) NULL)     return(False);   DestroyImage(*image);    *image=flipped_image; 4   if (windows->image.crop_geometry != (char *) NULL)     { 	       int 
         x,
         y;         unsigned int         height,          width;         /*         Flip crop geometry.        */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);(M       (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height, /         x,(int) (*image)->rows-(int) height-y);      }    /*     Update image configuration.    */E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);r }s e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %cO %                                                                             %nO %                                                                             % O %   X F l o p I m a g e W i n d o w                                           % O %                                                                             %aO %                                                                             %fO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XFlopImageWindow flops the scanlines of an image in the horizontal
 %  direction.g %l1 %  The format of the XFlopImageWindow routine is:  %vA %    status=XFlopImageWindow(display,resource_info,windows,image)  % + %  A description of each parameter follows:x % L %    o status: Function XFlopImageWindow return True if the window scanlinesJ %      reverse.  False is returned is there is a memory shortage or if the) %      window scanlines fails to reverse.o %>D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %)K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %r< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */I static unsigned int XFlopImageWindow(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 
   **image; { . #define FlopImageText  "  Flopping image...  "     Image      *flopped_image;      /*     Map info window.   */:   XSetWindowExtents(display,&windows->info,FlopImageText);'   XMapWindow(display,windows->info.id); ;   XDisplayInfoString(display,&windows->info,FlopImageText);    /*     Flop image scanlines.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);"   flopped_image=FlopImage(*image);A   XDefineCursor(display,windows->image.id,windows->image.cursor);hA   XWithdrawWindow(display,windows->info.id,windows->info.screen);a&   if (flopped_image == (Image *) NULL)     return(False);   DestroyImage(*image);o   *image=flopped_image;e4   if (windows->image.crop_geometry != (char *) NULL)     {i	       int,
         x,
         y;         unsigned int         height,          width;         /*         Flop crop geometry.i       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);hM       (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,c1         (int) (*image)->columns-(int) width-x,y);i     }    /*     Update image configuration.o   */E   (void) XConfigureImageWindow(display,resource_info,windows,*image);n   return(True);  }u r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             % O %                                                                             %pO %   X L o a d I m a g e W i n d o w                                           %eO %                                                                             % O %                                                                             %WO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %h8 %  Function XLoadImageWindow loads an image from a file. %d1 %  The format of the XLoadImageWindow routine is:  %eO %    loaded_image=XLoadImageWindow(display,resource_info,windows,command,image)o %n+ %  A description of each parameter follows:e % J %    o status: Function XLoadImageWindow returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.n %tD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %f< %    o windows: Specifies a pointer to a XWindows structure. %vK %    o command: A value other than zero indicates that the file is selected + %      from the command line argument list.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.i %r %e */K static Image *XLoadImageWindow(display,resource_info,windows,command,image)e Displaye   *display;i  
 XResourceInfo    *resource_info;    XWindows   *windows;r   unsigned int
   command;   Imagea	   *image;h {i- #define LoadImageText  "  Loading image...  "      char     filename[MaxTextLength];     Image,     *loaded_image;     /*      Request file name from user.   */*   (void) strcpy(filename,image->filename);   if (!command) 8     XFileBrowserWidget(display,windows,"Load",filename);   else     {i
       char         **filelist,i         **files;  	       inti         count,         status;          register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         {oA           Warning("Unable to select image","XGetCommand failed");e!           return((Image *) NULL);,	         } 6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL)p	         {rG           Warning("Unable to select image","Memory allocation failed");o!           XFreeStringList(files);g!           return((Image *) NULL);p	         } 
       j=0;       for (i=1; i < count; i++),         if (*files[i] != '-')h!           filelist[j++]=files[i];g        filelist[j]=(char *) NULL;9       XListBrowserWidget(display,windows,filelist,"Load", *         "Select Image to Load:",filename);%       (void) free((char *) filelist);        XFreeStringList(files);t     }g   if (*filename == '\0')     return((Image *) NULL);p   /*     Map info window.   */:   XSetWindowExtents(display,&windows->info,LoadImageText);'   XMapWindow(display,windows->info.id);o;   XDisplayInfoString(display,&windows->info,LoadImageText);pF   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   /*     Load the image.    */>   (void) strcpy(resource_info->image_info->filename,filename);4   loaded_image=ReadImage(resource_info->image_info);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); %   if (loaded_image != (Image *) NULL)o     {i5       (void) strcpy(loaded_image->filename,filename);tE       XClientMessage(display,windows->image.id,windows->im_protocols,e,         windows->im_next_image,CurrentTime);     }    else     {m
       char         *text,         **textlist;   
       FILE         *file;  	       int 
         c;         register charf         *p;h         unsigned int         length;r         /*         Unknown image format.        */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);        length=MaxTextLength;e0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)n       {r         c=fgetc(file);         if (c == EOF)2           break;!         if ((p-text+1) >= length)n           {n             *p='\0';             length<<=1;XE             text=(char *) realloc((char *) text,length*sizeof(char));e&             if (text == (char *) NULL)               break;              p=text+strlen(text);           }          *p=(unsigned char) c;        }        (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);,       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL)d	         {            char!             title[MaxTextLength];e             register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);i6           for (i=0; textlist[i] != (char *) NULL; i++).             (void) free((char *) textlist[i]);)           (void) free((char *) textlist);m	         }g!       (void) free((char *) text);I     }m   return(loaded_image);  }w t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%vO %                                                                             %.O %                                                                             %tO %                                                                             % O %   X M a g i c k C o m m a n d                                               %tO %                                                                             %tO %                                                                             % O %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%y %nI %  Function XMagickCommand makes a transform to the image or image window : %  as specified by a user menu button or keyboard command. %u/ %  The format of the XMagickCommand routine is:r %(E %    loaded_image=XMagickCommand(display,resource_info,windows,state,m %      key_symbol,image) %)+ %  A description of each parameter follows:, %dG %    o loaded_image:  Function XMagickCommand returns an image when the I %      user chooses 'Load Image' from the command menu.  Otherwise a null  %      image is returned.* % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.t %)< %    o windows: Specifies a pointer to a XWindows structure. %n %    o state: key mask.s %.2 %    o key_symbol: Specifies a command to perform. %dG %    o image: Specifies a pointer to a Image structure;  XMagickCommando> %      may transform the image and return a new image pointer. %S %c */L static Image *XMagickCommand(display,resource_info,windows,state,key_symbol,   image) Display    *display;e  
 XResourceInfoy   *resource_info;S   XWindows   *windows;s   unsigned int   state;   KeySym
   key_symbol;    Imaged
   **image; {d= #define DullContrastText  "  Dulling the image contrast...  " C #define GrayImageText  "  Converting the image colors to gray...  ",F #define HistogramEqualizeText  "  Equalizing the image histogram...  "H #define HistogramNormalizeText  "  Normalizing the image histogram...  "; #define NegateImageText  "  Negating the image colors...  " C #define SharpenContrastText  "  Sharpening the image contrast...  "E     typedef struct _ImageState   {g     unsigned int       width,
       height;g       char       *crop_geometry;i  	     Image 
       *image;.   } ImageState;   
   static chare     *ImageMagickHelp[]=f     {rC       "Press F1 whenever you feel you need help.  There is a help",xC       "pane associated with most of the image functions described",,       "below.", 	       "",        "BUTTONS",G       "   The effects of each button press is described below.  Three", B       "   buttons are required.  If you have a two button mouse,",C       "   button 1 and 3 are returned.  Press ALT and button 3 to",        "   simulate button 2.",	       "",nG       "   1    Press and drag to select a command from a pop-up menu.",s	       "",dB       "   2    Press and drag to define a region of the image to",       "        magnify.", 	       "",CE       "   3    Choose a particular tile of a visual image directory", H       "        and press this button and drag to select a command from",>       "        a pop-up menu.  Choose from these menu items:",	       "",o       "           Load",       "           Delete",	       "", H       "        If you choose Delete, the image represented by the tile",G       "        is deleted.  Otherwise, it is displayed.  To return to", A       "        the visual image directory, choose Next from the",f2       "        command menu (refer to Button 1).",	       "",)	       "",        "KEYBOARD ACCELERATORS",>       "   i    Press to display information about the image.",	       "", 4       "   w    Press to write the image to a file.",	       "",aB       "   p    Press to print the image to a Postscript printer.",	       "",e0       "   d    Press to delete the image file.",	       "", 0       "   C    Press to create a blank canvas.",	       "",e8       "   F2   Press to grab an image from the screen.",	       "",x4       "   l    Press to load an image from a file.",	       "",t1       "   n    Press to display the next image.", 	       "",f3       "   f    Press to display the former image.",m	       "",.G       "   F3   Press to select an image to load from the command line", 	       "", 9       "   u    Press to undo last image transformation.",m	       "", A       "   r    Press to restore the image to its original size.", 	       "",p3       "   @    Press to refresh the image window.",E	       "", F       "   F7   Press to toggle the colormap type: Shared or Private.",	       "", ?       "   ,    Press to display the next image after pausing.",L	       "", .       "   <    Press to half the image size.",	       "", ;       "   o    Press to return to the original image size", 	       "", 0       "   >    Press to double the image size.",	       "",yD       "   %    Press to resize the image to a width and height you",       "        specify.",e	       "", /       "   t    Press to trim the image edges.",v	       "",f)       "   [    Press to crop the image.",l	       "", (       "   ]    Press to cut the image.",	       "",aA       "   |    Press to flop image in the horizontal direction.",*	       "", ?       "   -    Press to flip image in the vertical direction.",c	       "",a@       "   /    Press to rotate the image 90 degrees clockwise.",	       "", I       "   \\    Press to rotate the image 90 degrees counter-clockwise.", 	       "", D       "   *    Press to rotate the image the number of degrees you",       "        specify.",V	       "",iC       "   s    Press to shear the image the number of degrees you",e       "        specify.",e	       "", 4       "   F8   Press to vary the color brightness.",	       "",n4       "   F9   Press to vary the color saturation.",	       "", -       "   F10  Press to vary the image hue.", 	       "",;2       "   g    Press to gamma correct the image.",	       "",e5       "   F11  Press to sharpen the image contrast.", 	       "",n2       "   F12  Press to dull the image contrast.",	       "",dF       "   =    Press to perform histogram equalization on the image.",	       "",tF       "   N    Press to perform histogram normalization on the image",	       "",b9       "   ~    Press to invert the colors of the image.", 	       "", >       "   D    Press to reduce the speckles within an image.",	       "", >       "   P    Press to  eliminate peak noise from an image.",	       "",a,       "   S    Press to sharpen the image.",	       "", )       "   B    Press to blur the image.",x	       "",-7       "   E    Press to detect edges within an image.",d	       "",+*       "   M    Press to emboss an image.",	       "",y-       "   O    Press to oil paint an image.",x	       "", ;       "   G    Press to convert the image colors to gray.",:	       "", H       "   #    Press to set the maximum number of unique colors in the",       "        image.", 	       "",r7       "   a    Press to annotate the image with text.", 	       "",c4       "   b    Press to add a border to the image.",	       "",I;       "   x    Press to composite the image with another.",t	       "", 4       "   c    Press to edit an image pixel color.",	       "", ;       "   m    Press to edit the image matte information.",d	       "",d/       "   !    Press to add an image comment.",f	       "",sG       "   h    Press to display helpful information about display(1).",o	       "",iH       "        Function keys HELP or F1 are synonomous with the h key.",	       "",rC       "   v    Press to display the version number of display(1).", 	       "",a>       "   q    Press to discard all images and exit program.",	       "",)<       "   1-9  Press to change the level of magnification.",	       "",cG       "Use the arrow keys to move the image one pixel up, down, left,",oE       "or right within an magnify window.  Be sure to first map the",c,       "magnify window by pressing button 2",	       "",iG       "Press ALT and one of the arrow keys to trim off one pixel from",i       "any side of the image.",y       (char *) NULL,     };     char     geometry[MaxTextLength];     Image;     *loaded_image;  
   static charo     delta[MaxTextLength] = "",     Digits[]="01234567890";t     static KeySyme     last_symbol = XK_0;m     static ImageStateo7     undo_image = {0, 0, (char *) NULL, (Image *) NULL};a     unsigned int     status;   /   XCheckRefreshWindow(display,&windows->image);e3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9)).     {o<       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))         *delta='\0';       last_symbol=key_symbol; "       delta[strlen(delta)+1]='\0';3       delta[strlen(delta)]=Digits[key_symbol-XK_0];e       return((Image *) NULL);      }t   last_symbol=key_symbol; 6   if ((key_symbol == XK_u) || (key_symbol == XK_Undo))     {p       /*+         Undo the last image transformation.f       */-       if (undo_image.image == (Image *) NULL)e	         {            XBell(display,0);-!           return((Image *) NULL); 	         }p4       status=RunlengthDecodeImage(undo_image.image);       if (status == False)	         { I           XNoticeWidget(display,windows,"Unable to undo last operation:",e              (*image)->filename);           XBell(display,0);%!           return((Image *) NULL);%	         } ;       windows->image.window_changes.width=undo_image.width; =       windows->image.window_changes.height=undo_image.height; 8       if (windows->image.crop_geometry != (char *) NULL);         (void) free((char *) windows->image.crop_geometry); <       windows->image.crop_geometry=undo_image.crop_geometry;       DestroyImage(*image);        *image=undo_image.image;D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image); -       undo_image.crop_geometry=(char *) NULL; &       undo_image.image=(Image *) NULL;       return((Image *) NULL);%     }%   switch (key_symbol)    {i     case XK_less:r     case XK_o:     case XK_greater:     case XK_percent:     case XK_t:     case XK_bracketright:g     case XK_minus:     case XK_bar:     case XK_slash:     case XK_backslash:     case XK_asterisk:      case XK_s:     case XK_asciitilde:n     case XK_equal:     case XK_N:     case XK_F8:      case XK_F9:c     case XK_F10:     case XK_g:     case XK_F11:     case XK_F12:     case XK_D:     case XK_P:     case XK_S:     case XK_B:     case XK_E:     case XK_M:     case XK_O:     case XK_G:     case XK_numbersign:      case XK_a:     case XK_b:     case XK_x:     case XK_c:     case XK_m:     case XK_exclam:d     case XK_Up:u     case XK_KP_Up:     case XK_Down:s     case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:      {p       /*)         Save image before transformation.        */J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);4       undo_image.width=windows->image.ximage->width;6       undo_image.height=windows->image.ximage->height;4       if (undo_image.crop_geometry != (char *) NULL)7         (void) free((char *) undo_image.crop_geometry); <       undo_image.crop_geometry=windows->image.crop_geometry;8       if (windows->image.crop_geometry != (char *) NULL)	         {eO           undo_image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));m8           if (undo_image.crop_geometry != (char *) NULL)3             (void) strcpy(undo_image.crop_geometry,.,               windows->image.crop_geometry);	         }u-       if (undo_image.image != (Image *) NULL))'         DestroyImage(undo_image.image);>       (*image)->orphan=True;O       undo_image.image=CopyImage(*image,(*image)->columns,(*image)->rows,True);        (*image)->orphan=False;w       /*+         Pack image data to conserve memory.p       */4       (void) RunlengthEncodeImage(undo_image.image);5       (void) free((char *) undo_image.image->pixels); 8       undo_image.image->pixels=(RunlengthPacket *) NULL;E       XDefineCursor(display,windows->image.id,windows->image.cursor);%       break;     }      default:       break;   }    /*     Process user command.    */   loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width; E   windows->image.window_changes.height=windows->image.ximage->height;    switch (key_symbol)    {      case XK_i:     { >       XDisplayImageInfo(display,resource_info,windows,*image);       break;     }      case XK_w:     {        /*         Write image.       */E       status=XWriteImageWindow(display,resource_info,windows,*image);        if (status == False)	         {%C           XNoticeWidget(display,windows,"Unable to write X image:",%              (*image)->filename);           break;	         }g       break;     }t     case XK_p:     {f       /*         Print image.       */E       status=XPrintImageWindow(display,resource_info,windows,*image);i       if (status == False)	         {oC           XNoticeWidget(display,windows,"Unable to print X image:",p              (*image)->filename);           break;	         }W       break;     }      case XK_d:     {r
       char          filename[MaxTextLength];         /*         Delete image file.       */2       (void) sprintf(filename,(*image)->filename);<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=unlink(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);c       break;     }      case XK_C:     {        ImageInfos         image_info;m         static charo,         geometry[MaxTextLength] = "640x480";         /*         Create canvas.       */P       XDialogWidget(display,windows,"Canvas","Enter canvas geometry:",geometry);       if (*geometry == '\0')         break;        GetImageInfo(&image_info);/       (void) strcpy(image_info.filename,"xc:");        image_info.size=geometry; *       loaded_image=ReadImage(&image_info);0       (void) free((char *) image_info.filename);E       XClientMessage(display,windows->image.id,windows->im_protocols,m,         windows->im_next_image,CurrentTime);       break;     })     case XK_F2:C     {e       /*&         Grab an image from the screen.       */>       (void) strcpy(resource_info->image_info->filename,"x:");8       loaded_image=ReadImage(resource_info->image_info);)       if (loaded_image != (Image *) NULL)sG         XClientMessage(display,windows->image.id,windows->im_protocols, .           windows->im_next_image,CurrentTime);       break;     }f     case XK_l:     {w       /*         Load image._       */P       loaded_image=XLoadImageWindow(display,resource_info,windows,False,*image);       break;     }d     case XK_n:     case XK_Next:      case XK_space:     {w       /*         Display next image.s       */E       XClientMessage(display,windows->image.id,windows->im_protocols,o,         windows->im_next_image,CurrentTime);       break;     }o     case XK_f:     case XK_Prior:     case XK_KP_Prior:e     case XK_BackSpace:     {n       /*         Display former image.n       */E       XClientMessage(display,windows->image.id,windows->im_protocols,i.         windows->im_former_image,CurrentTime);       break;     }l     case XK_F3:i     {i       /*         Select image.w       */O       loaded_image=XLoadImageWindow(display,resource_info,windows,True,*image);i       break;     }i     case XK_F7:e     {        /*2         Toggle X colormap type: Shared or Private.       */4       if (resource_info->colormap == SharedColormap)	         {c2           resource_info->colormap=PrivateColormap;F           XNoticeWidget(display,windows,"X Colormap Type:","Private");	         }h
       else	         {e1           resource_info->colormap=SharedColormap;uE           XNoticeWidget(display,windows,"X Colormap Type:","Shared");w	         }eD       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);e       break;     }g     case XK_comma:     {m       static charx#         delay[MaxTextLength] = "5";w         /*)         Display next image after pausing.        */       resource_info->delay=0;g1       XDialogWidget(display,windows,"Slide Show",w8         "Pause how many seconds between images:",delay);       if (*delay == '\0')(         break;'       resource_info->delay=atoi(delay);(E       XClientMessage(display,windows->image.id,windows->im_protocols,d,         windows->im_next_image,CurrentTime);       break;     }x     case XK_less:a     {        /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;I       (void) XConfigureImageWindow(display,resource_info,windows,*image);p       break;     }i     case XK_o:     {        /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;I       (void) XConfigureImageWindow(display,resource_info,windows,*image);;       break;     }i     case XK_greater:     {i       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;I       (void) XConfigureImageWindow(display,resource_info,windows,*image);        break;     }t     case XK_percent:     {i       unsigned int         height,h         width;         /*         Resize image.        */)       width=windows->image.ximage->width; +       height=windows->image.ximage->height;e4       (void) sprintf(geometry,"%ux%u",width,height);-       XDialogWidget(display,windows,"Resize",w@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;2       ParseImageGeometry(geometry,&width,&height);0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;I       (void) XConfigureImageWindow(display,resource_info,windows,*image);d       break;     }i     case XK_r:     {        /*2         Restore image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {%           XBell(display,0);%           break;	         } <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         { =           (void) free((char *) windows->image.crop_geometry); 5           windows->image.crop_geometry=(char *) NULL;            windows->image.x=0;            windows->image.y=0; 	         } I       (void) XConfigureImageWindow(display,resource_info,windows,*image);        break;     }      case XK_at:      { I       (void) XConfigureImageWindow(display,resource_info,windows,*image);%       break;     }%     case XK_t:     {        /*         Trim image.c       */D       status=XTrimImageWindow(display,resource_info,windows,*image);       if (status == False)	         {yA           XNoticeWidget(display,windows,"Unable to trim X image",t              (*image)->filename);           break;	         }r       break;     }i     case XK_bracketleft:     {u       /*         Crop image.a       */D       (void) XCropImageWindow(display,resource_info,windows,*image);       break;     }s     case XK_bracketright:      {i       /*         Cut image.       */B       status=XCutImageWindow(display,resource_info,windows,image);       if (status == False)	         {u@           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }e       break;     }w     case XK_bar:     {n       /*         Flop image scanlines.R       */C       status=XFlopImageWindow(display,resource_info,windows,image);        if (status == False)	         {cA           XNoticeWidget(display,windows,"Unable to flop X image",e              (*image)->filename);           break;	         }i       break;     }g     case XK_minus:     {        /*         Flip image scanlines.        */C       status=XFlipImageWindow(display,resource_info,windows,image);e       if (status == False)	         {eA           XNoticeWidget(display,windows,"Unable to flip X image",l              (*image)->filename);           break;	         }        break;     }U     case XK_slash:     {r       /**         Rotate image 90 degrees clockwise.       */J       status=XRotateImageWindow(display,resource_info,windows,90.0,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }        break;     }o     case XK_backslash:     {        /*2         Rotate image 90 degrees counter-clockwise.       */K       status=XRotateImageWindow(display,resource_info,windows,-90.0,image);h       if (status == False)	         {wC           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }n       break;     }i     case XK_asterisk:o     {,       /*         Rotate image.d       */I       status=XRotateImageWindow(display,resource_info,windows,0.0,image);f       if (status == False)	         {rC           XNoticeWidget(display,windows,"Unable to rotate X image",s              (*image)->filename);           break;	         }o       break;     }w     case XK_s:     {        /*         Shear image.       */D       status=XShearImageWindow(display,resource_info,windows,image);       if (status == False)	         {oB           XNoticeWidget(display,windows,"Unable to shear X image",              (*image)->filename);           break;	         }t       break;     }      case XK_F8:.     {        static charB0         brightness_percent[MaxTextLength] = "3";         /*"         Vary the color brightness.       */,       XDialogWidget(display,windows,"Apply",H         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);/       ModulateImage(*image,brightness_percent);aE       XDefineCursor(display,windows->image.id,windows->image.cursor);eD       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);        break;     }      case XK_F9:s     { 
       char          modulate[MaxTextLength];         static char 1         saturation_percent[MaxTextLength] = "10";          /*"         Vary the color saturation.       */,       XDialogWidget(display,windows,"Apply",H         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);%       (void) strcpy(modulate,"0.0,"); 1       (void) strcat(modulate,saturation_percent); %       ModulateImage(*image,modulate); E       XDefineCursor(display,windows->image.id,windows->image.cursor); D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);        break;     }      case XK_F10:     {:
       char          modulate[MaxTextLength];         static char )         hue_percent[MaxTextLength] = "3";          /*         Vary the image hue.        */,       XDialogWidget(display,windows,"Apply",:         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')          break;J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);)       (void) strcpy(modulate,"0.0,0.0,");f*       (void) strcat(modulate,hue_percent);%       ModulateImage(*image,modulate);wE       XDefineCursor(display,windows->image.id,windows->image.cursor);.D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);w       break;     }f     case XK_g:     {        static chari%         gamma[MaxTextLength] = "1.6";          /*         Gamma correct image.       */H       XDialogWidget(display,windows,"Gamma","Enter gamma value:",gamma);       if (*gamma == '\0')          break;J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);       GammaImage(*image,gamma);mE       XDefineCursor(display,windows->image.id,windows->image.cursor); D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);        break;     }      case XK_F11:     {t       /*#         Sharpen the image contrast.h       */D       XSetWindowExtents(display,&windows->info,SharpenContrastText);+       XMapWindow(display,windows->info.id);tE       XDisplayInfoString(display,&windows->info,SharpenContrastText);.J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);!       ContrastImage(*image,True);        XDelay(display,2000);iE       XWithdrawWindow(display,windows->info.id,windows->info.screen);aE       XDefineCursor(display,windows->image.id,windows->image.cursor);-D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);>       break;     }i     case XK_F12:     {n       /*          Dull the image contrast.       */A       XSetWindowExtents(display,&windows->info,DullContrastText); +       XMapWindow(display,windows->info.id); B       XDisplayInfoString(display,&windows->info,DullContrastText);J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);"       ContrastImage(*image,False);       XDelay(display,2000); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);eE       XDefineCursor(display,windows->image.id,windows->image.cursor);cD       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);>       break;     }      case XK_equal:     {v       /*4         Perform histogram equalization on the image.       */F       XSetWindowExtents(display,&windows->info,HistogramEqualizeText);+       XMapWindow(display,windows->info.id);>G       XDisplayInfoString(display,&windows->info,HistogramEqualizeText); J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);       EqualizeImage(*image);       XDelay(display,2000);iE       XWithdrawWindow(display,windows->info.id,windows->info.screen); E       XDefineCursor(display,windows->image.id,windows->image.cursor);mD       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);e       break;     }      case XK_N:     {a       /*5         Perform histogram normalization on the image.i       */G       XSetWindowExtents(display,&windows->info,HistogramNormalizeText); +       XMapWindow(display,windows->info.id); H       XDisplayInfoString(display,&windows->info,HistogramNormalizeText);J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);       NormalizeImage(*image);        XDelay(display,2000);yE       XWithdrawWindow(display,windows->info.id,windows->info.screen); E       XDefineCursor(display,windows->image.id,windows->image.cursor); D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);        break;     }f     case XK_asciitilde:g     {h       /*         Negate colors in image.e       */@       XSetWindowExtents(display,&windows->info,NegateImageText);+       XMapWindow(display,windows->info.id); A       XDisplayInfoString(display,&windows->info,NegateImageText);(J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);       NegateImage(*image);       XDelay(display,2000);rE       XWithdrawWindow(display,windows->info.id,windows->info.screen);iE       XDefineCursor(display,windows->image.id,windows->image.cursor); D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);;       break;     }i     case XK_D:     {        /*(         Reduce speckles within an image.       */H       status=XDespeckleImageWindow(display,resource_info,windows,image);       if (status == False)	         {gD           XNoticeWidget(display,windows,"Unable to reduce speckles",              (*image)->filename);           break;	         }o       break;     }      case XK_P:     {g       /*%         Reduce noise within an image.l       */D       status=XNoisyImageWindow(display,resource_info,windows,image);       if (status == False)	         {hA           XNoticeWidget(display,windows,"Unable to reduce noise",               (*image)->filename);           break;	         }n       break;     }i     case XK_S:     {        /*         Sharpen an image.(       */F       status=XSharpenImageWindow(display,resource_info,windows,image);       if (status == False)	         { A           XNoticeWidget(display,windows,"Unable to detect edges",               (*image)->filename);           break;	         }        break;     }i     case XK_B:     {        /*         Blur an image.       */C       status=XBlurImageWindow(display,resource_info,windows,image);+       if (status == False)	         {a?           XNoticeWidget(display,windows,"Unable to blur image",i              (*image)->filename);           break;	         }g       break;     }t     case XK_E:     {n       /*%         Detect edges within an image.        */C       status=XEdgeImageWindow(display,resource_info,windows,image);        if (status == False)	         {eA           XNoticeWidget(display,windows,"Unable to detect edges",t              (*image)->filename);           break;	         }f       break;     }      case XK_M:     {d       /*         Emboss an image.       */E       status=XEmbossImageWindow(display,resource_info,windows,image);a       if (status == False)	         {+A           XNoticeWidget(display,windows,"Unable to emboss image",D              (*image)->filename);           break;	         }        break;     }r     case XK_O:     {g       /*         Oil painting an image.       */G       status=XOilPaintImageWindow(display,resource_info,windows,image);r       if (status == False)	         { D           XNoticeWidget(display,windows,"Unable to oil paint image",              (*image)->filename);           break;	         }y       break;     }i     case XK_G:     {        /*#         Convert image to grayscale.i       */>       XSetWindowExtents(display,&windows->info,GrayImageText);+       XMapWindow(display,windows->info.id); ?       XDisplayInfoString(display,&windows->info,GrayImageText); J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);G       QuantizeImage(*image,256,8,resource_info->dither,GRAYColorspace);&       XDelay(display,2000);rE       XWithdrawWindow(display,windows->info.id,windows->info.screen); E       XDefineCursor(display,windows->image.id,windows->image.cursor);_D       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);d       break;     }f     case XK_numbersign:o     {a       static char &         colors[MaxTextLength] = "256";         /*         Color reduce the image.a       */I       XDialogWidget(display,windows,"Colors","Maximum number of colors:",          colors);       if (*colors == '\0')         break;J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);7       QuantizeImage(*image,(unsigned int) atoi(colors),X8         resource_info->tree_depth,resource_info->dither,#         resource_info->colorspace);lE       XDefineCursor(display,windows->image.id,windows->image.cursor);dD       XConfigureImageColormap(display,resource_info,windows,*image);I       (void) XConfigureImageWindow(display,resource_info,windows,*image);l       break;     }      case XK_a:     {        /*%         Annotate the image with text.        */H       status=XAnnotateImageWindow(display,resource_info,windows,*image);       if (status == False)	         {rE           XNoticeWidget(display,windows,"Unable to annotate X image",               (*image)->filename);           break;	         }        break;     }      case XK_b:     {E       /*         Border an image.       */E       status=XBorderImageWindow(display,resource_info,windows,image);        if (status == False)	         {,A           XNoticeWidget(display,windows,"Unable to border image",d              (*image)->filename);           break;	         }n       break;     }_     case XK_x:     {p       /*         Composite image.       */H       status=XCompositeImageWindow(display,resource_info,windows,image);       if (status == False)	         { F           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }i       break;     }      case XK_c:     {h       /*         Color edit.        */I       status=XColorEditImageWindow(display,resource_info,windows,*image);r       if (status == False)	         {oG           XNoticeWidget(display,windows,"Unable to pixel edit X image",%              (*image)->filename);           break;	         }        break;     }      case XK_m:     {        /*         Matte edit.        */I       status=XMatteEditImageWindow(display,resource_info,windows,*image);        if (status == False)	         { G           XNoticeWidget(display,windows,"Unable to matte edit X image",               (*image)->filename);           break;	         }        break;     }      case XK_exclam:      { 
       char         command[MaxTextLength],           filename[MaxTextLength];  
       FILE         *file;         /*         Edit image comment.        */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {            register charW             *p;i  #           file=fopen(filename,"w");a$           if (file == (FILE *) NULL)
             {(K               XNoticeWidget(display,windows,"Unable to edit image comment",f                 filename);               break;
             } 5           for (p=(*image)->comments; *p != '\0'; p++)r'             (void) putc((int) *p,file);i!           (void) putc('\n',file);l           (void) fclose(file);	         }r5       (void) sprintf(command,EditorCommand,filename);_9       if (resource_info->editor_command != (char *) NULL) G         (void) sprintf(command,resource_info->editor_command,filename); J       XDefineCursor(display,windows->image.id,windows->image.busy_cursor);       XFlush(display);$       status=SystemCommand(command);       if (status)fN         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         { 1           (void) sprintf(command,"@%s",filename); '           CommentImage(*image,command);u	         }f       (void) unlink(filename);E       XDefineCursor(display,windows->image.id,windows->image.cursor);h       break;     }      case XK_h:     case XK_F1:o     case XK_Help:i     { :       XTextViewWidget(display,resource_info,windows,False,5         "Help Viewer - ImageMagick",ImageMagickHelp);m       break;     }i     case XK_v:     { ,       XNoticeWidget(display,windows,Version,C         "Copyright (c) 1994 E. I. du Pont de Nemours and Company");e       break;     }      case XK_q:     {        /*         Exit program.        */E       XClientMessage(display,windows->image.id,windows->im_protocols,o&         windows->im_exit,CurrentTime);       break;     }e     case XK_Home:      case XK_KP_Home:     {o?       XTranslateImageWindow(display,windows,*image,key_symbol);        break;     }l     case XK_Up:      case XK_KP_Up:     case XK_Down:n     case XK_KP_Down:     case XK_Left:"     case XK_KP_Left:     case XK_Right:     case XK_KP_Right:c     {        if (state & Mod1Mask)e	         {.
           int              quantum;             RectangleInfot             crop_info;             /*.             Trim one pixel from edge of image.           */           quantum=1;           if (*delta != '\0')               if (atoi(delta) > 0)"               quantum=atoi(delta);           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width;e9           crop_info.height=windows->image.ximage->height; @           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             {;-               if (quantum > crop_info.height) )                 quantum=crop_info.height;e(               crop_info.height-=quantum;
             }hD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             {i;               if (quantum > (crop_info.height-crop_info.y))i5                 quantum=crop_info.height-crop_info.y;i#               crop_info.y+=quantum;&(               crop_info.height-=quantum;
             }dD           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             {f,               if (quantum > crop_info.width)(                 quantum=crop_info.width;'               crop_info.width-=quantum;+
             }sF           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {;:               if (quantum > (crop_info.width-crop_info.x))4                 quantum=crop_info.width-crop_info.x;#               crop_info.x+=quantum; '               crop_info.width-=quantum; 
             }t>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None);tM           (void) XConfigureImageWindow(display,resource_info,windows,*image);            break;	         } ?       XTranslateImageWindow(display,windows,*image,key_symbol);        break;     }n     case XK_Return:      case XK_KP_Enter:n       break;     default:     {n%       if (!IsModifierKey(key_symbol))t         XBell(display,0);        break;     }    }    return(loaded_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a g n i f y I m a g e W i n d o w                                     %tO %                                                                             % O %                                                                             %aO %                                                                             %]O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %eL %  Function XMagnifyImageWindow magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. % 4 %  The format of the XMagnifyImageWindow routine is: %_/ %    XMagnifyImageWindow(display,windows,event)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned frome %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.( %p %, */6 static void XMagnifyImageWindow(display,windows,event) Displayi   *display;e   XWindows   *windows;c   XEvent	   *event;> {g   char     text[MaxTextLength];     register int     x,     y;     unsigned long 
     state;     /*     Map info window.   */   state=DefaultState; M   (void) sprintf(text," +%u+%u ",windows->image.width,windows->image.height); 1   XSetWindowExtents(display,&windows->info,text);n'   XMapWindow(display,windows->info.id);c   /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);w   x=event->xbutton.x;o   y=event->xbutton.y; (   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {.     /*F       Map and unmap info window as text cursor crosses its boundaries.     */     if (windows->info.mapped)o       {,:         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height))).I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        }      else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))>-         XMapWindow(display,windows->info.id);      if (windows->info.mapped)d       {.
         /*#           Display pointer position.t
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);8         XDisplayInfoString(display,&windows->info,text);       },     /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {o       case ButtonPress:d         break;       case ButtonRelease:n       { 
         /*-           User has finished magnifying image.t
         */         x=event->xbutton.x;=         y=event->xbutton.y;          state|=ExitState;e         break;       }1       case Expose:         break;       case MotionNotify:       { 
         /*/           Discard pending button motion events._
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));         x=event->xmotion.x;o         y=event->xmotion.y;          break;       }        default:         break;     }      /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;o     if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1;e!   } while (!(state & ExitState));    /*     Display magnified image.   */A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);o }> o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %fO %                                                                             %iO %                                                                             %fO %   X M a g n i f y W i n d o w C o m m a n d                                 %)O %                                                                             %eO %                                                                             %wO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %tM %  Function XMagnifyWindowCommand moves the image within an magnify window bye, %  one pixel as specified by the key symbol. %t6 %  The format of the XMagnifyWindowCommand routine is: %t6 %    XMagnifyWindowCommand(display,windows,key_symbol) %s+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %X< %    o windows: Specifies a pointer to a XWindows structure. %nM %    o key_symbol: Specifies a KeySym which indicates which side of the image  %      to trim.  %  %r */= static void XMagnifyWindowCommand(display,windows,key_symbol)  Displayn   *display;)   XWindows   *windows;;   KeySym
   key_symbol;m {_   /*0     User specified a magnify factor or position.   */   switch (key_symbol)    {e     case XK_q:     { K       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);i       break;     }_     case XK_Home:a     case XK_KP_Home:     {p3       windows->magnify.x=windows->image.width >> 1;n4       windows->magnify.y=windows->image.height >> 1;       break;     }m     case XK_Left:_     case XK_KP_Left:     {m!       if (windows->magnify.x > 0)&         windows->magnify.x--;d       break;     }.     case XK_Up:,     case XK_KP_Up:     {(!       if (windows->magnify.y > 0)n         windows->magnify.y--;        break;     }      case XK_Right:     case XK_KP_Right:i     {s8       if (windows->magnify.x < (windows->image.width-1))         windows->magnify.x++;D       break;     }i     case XK_Down:d     case XK_KP_Down:     {F9       if (windows->magnify.y < (windows->image.height-1))e         windows->magnify.y++;w       break;     }o     case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     { ,       windows->magnify.data=key_symbol-XK_0;       break;     }i     case XK_KP_0:s     case XK_KP_1:      case XK_KP_2:i     case XK_KP_3:d     case XK_KP_4:i     case XK_KP_5:      case XK_KP_6:m     case XK_KP_7:      case XK_KP_8:a     case XK_KP_9:r     {e/       windows->magnify.data=key_symbol-XK_KP_0;o       break;     })     default:       break;   }i%   XMakeMagnifyImage(display,windows);o }r   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %iO %                                                                             %hO %                                                                             %;O %   X M a k e P a n I m a g e                                                 %_O %                                                                             %yO %                                                                             %dO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%U %iM %  Function XMakePanImage creates a thumbnail of the image and displays it in  %  the pan icon window.i %.. %  The format of the XMakePanImage routine is: %n9 %      XMakePanImage(display,resource_info,windows,image)_ %g+ %  A description of each parameter follows:o %iE %    o display: Specifies a connection to an X server;  returned fromp %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %t< %    o windows: Specifies a pointer to a XWindows structure. %cF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.v %) %o */> static void XMakePanImage(display,resource_info,windows,image) Display    *display;%  
 XResourceInfo%   *resource_info;%   XWindows   *windows;%   Image%	   *image;  {    unsigned int     status;      /*.     Create and display image for panning icon.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);;   status|=XMakePixmap(display,resource_info,&windows->pan);    if (status == False);     Error("Unable to create pan icon image",(char *) NULL); J   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);eA   XDefineCursor(display,windows->image.id,windows->image.cursor);a }f e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             % O %                                                                             % O %                                                                             %gO %   X M a t t a E d i t I m a g e W i n d o w                                 %nO %                                                                             %pO %                                                                             %eO %                                                                             %IO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %DI %  Function XMatteEditImageWindow allows the user to interactively changelM %  the Matte channel of an image.  If the image is PseudoClass it is promoted H %  to DirectClass before the matte information is stored.  The floodfillL %  algorithm is strongly based on a similiar algorithm in "Graphics Gems" by %  Paul Heckbert., %n6 %  The format of the XMatteEditImageWindow routine is: %o? %    XMatteEditImageWindow(display,resource_info,windows,image)c %I+ %  A description of each parameter follows:  %DE %    o display: Specifies a connection to an X server;  returned fromF %      XOpenDisplay. %lK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.i %w< %    o windows: Specifies a pointer to a XWindows structure. %nE %    o image: Specifies a pointer to a Image structure; returned frome %      ReadImage.t %I */  + static void MatteFloodfill(image,x,y,matte)  Imagee	   *image;i   intn   x,   y;   intu   matte; {a   inta
     delta,	     skip,,
     start,     x1,o     x2;a     register RunlengthPacket     *pixel;g     register XSegment      *p;*     RunlengthPacket%     target;%  
   XSegment     *segment_stack;%     /*     Check boundary conditions.   */$   if ((y < 0) || (y >= image->rows))     return; '   if ((x < 0) || (x >= image->columns))      return; +   target=image->pixels[y*image->columns+x]; -   if (target.index == (unsigned short) matte)      return;    /*     Allocate segment stack.    */C   segment_stack=(XSegment *) malloc(MaxStacksize*sizeof(XSegment)); )   if (segment_stack == (XSegment *) NULL)      { @       Warning("Unable to floodfill","Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */   p=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);%   while (p > segment_stack)%   {%     /*       Pop segment off stack.     */     p--;
     x1=p->x1;e
     x2=p->x2;a     delta=p->y2;     y=p->y1+delta;     /*5       Update matte information in neighboring pixels.o     */     for (x=x1; x >= 0 ; x--)     { /       pixel=image->pixels+(y*image->columns+x); '       if ((pixel->red != target.red) ||n+           (pixel->green != target.green) ||a)           (pixel->blue != target.blue) ||o)           (pixel->index != target.index))i         break;*       pixel->index=(unsigned short) matte;     }f     skip=x >= x1;a     if (!skip)       {v         start=x+1;         if (start < x1)i$           Push(y,start,x1-1,-delta);         x=x1+1;        }_     do     {a       if (!skip)	         { *           for ( ; x < image->columns; x++)           {d5             pixel=image->pixels+(y*image->columns+x); -             if ((pixel->red != target.red) ||G1                 (pixel->green != target.green) || /                 (pixel->blue != target.blue) || /                 (pixel->index != target.index))a               break;0             pixel->index=(unsigned short) matte;           }o"           Push(y,start,x-1,delta);           if (x > (x2+1)) $             Push(y,x2+1,x-1,-delta);	         }i       skip=False;*       for (x++; x <= x2 ; x++)       {g1         pixel=image->pixels+(y*image->columns+x); )         if ((pixel->red == target.red) && -             (pixel->green == target.green) &&=+             (pixel->blue == target.blue) &&o+             (pixel->index == target.index))d           break;       }i       start=x;     } while (x <= x2);   }f&   (void) free((char *) segment_stack); }   N static unsigned int XMatteEditImageWindow(display,resource_info,windows,image) Displays   *display;i  
 XResourceInfo    *resource_info;f   XWindows   *windows;o   Image 	   *image;d {i
   static char      *ImageMatteEditHelp[]=     {o=       "Matte information within an image is useful for some",oB       "operations such as image compositing.  This extra channel",<       "usually defines a mask which represents a sort of a",B       "cookie-cutter for the image.  This is the case when matte",A       "is 255 (full coverage) for pixels inside the shape, zero",p;       "outside, and between zero and 255 on the boundary.",d	       "", E       "A small window appears showing the location of the cursor in",)D       "the image window.  You are now in matte edit mode.  To exit",B       "immediately, press ESC. In matte edit mode a button press",C       "has a different effect than described in BUTTONS.  Press a",o(       "button to affect this behavior:",	       "", F       "1    Press to select a pixel within an image window to change",F       "     its matte value.  Additional pixels may have their matte",F       "     value changed as prescibed by the method you choose with",       "     button 3.",g	       "", A       "2    Press an a dialog appears requesting a matte value.",r=       "     Enter a value between 0 and 255.  This value is",(B       "     assigned as the matte value of the selected pixel or",       "     pixels.",e	       "",tD       "3    Press and drag to select a matte editing method from a",6       "     pop-up menu.  Choose from these methods:",	       "",        "         point",r       "         replace",_       "         floodfill",r	       "",tD       "     The point method changes the matte value of the single",J       "     pixel selected with the pointer.  The replace method changes",H       "     the matte value of any pixel that matches the color of the",J       "     pixel you select with button 1.  Floodfill changes the matte",H       "     value of any pixel that matches the color of the pixel you",5       "     select with button 1 and is a neighbor.",,	       "",,@       "Matte information is only valid in a DirectClass image.",8       "Therefore, any PseudoClass image is promoted to",B       "DirectClass.  Note that matte information for PseudoClass",?       "is not retained for colormapped X server visuals (e.g.",tA       "StaticColor, StaticColor, GrayScale, PseudoColor) unless",x?       "you immediately save the image to a file with 'Write'.", B       "Correct matte editing behavior may require a TrueColor or",3       "DirectColor visual or a Standard Colormap.",d       (char *) NULL,     };     char     text[MaxTextLength];     Cursor     cursor;w     into     i,     x,
     x_offset,e     y,
     y_offset;.  
   static charm     matte[MaxTextLength] = "0";w     static unsigned int      method = FloodfillMethodOp;i     unsigned int     height,g	     mask,o
     width;     unsigned long>
     state,
     x_factor, 
     y_factor;f     Window     xwindow;     XEvent
     event;     /*     Map info window.   */N   (void) sprintf(text," +%u+%u  ",windows->image.width,windows->image.height);1   XSetWindowExtents(display,&windows->info,text);L'   XMapWindow(display,windows->info.id);s   /*,     Track pointer until button 1 is pressed.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color);i2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */O   XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,&mask);tO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask |(     PointerMotionMask);e   state=DefaultState;    do   {      if (windows->info.mapped)y       {e
         /*#           Display pointer position.v
         */N         (void) sprintf(text," %+d%+d ",x-windows->image.x,y-windows->image.y);8         XDisplayInfoString(display,&windows->info,text);       }n     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type))     {        case ButtonPress:u       {r4         if (event.xbutton.window == windows->pan.id)           {f4             XPanImageWindow(display,windows,&event);;             XSetWindowExtents(display,&windows->info,text);w             break;           } %         switch (event.xbutton.button)v	         {            case Button1:V           {              /*                Update matte data.             */%             x_offset=event.xbutton.x; %             y_offset=event.xbutton.y;a,             state|=UpdateConfigurationState;             break;           }a           case Button2:w           {i             /*0               Request matte value from the user.             */N             XDialogWidget(display,windows,"Matte","Enter matte value:",matte);<             XDefineCursor(display,windows->image.id,cursor);             break;           }d           case Button3:,           {n             char%               command[MaxTextLength];i               static charn               *MethodMenu[]=               {a                 "point",                 "replace",                 "floodfill",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.i             */L             method=XMenuWidget(display,windows,"Method",MethodMenu,command);<             XDefineCursor(display,windows->image.id,cursor);             break;           }i	         }w         break;       }y       case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {.         char!           command[MaxTextLength];c           KeySym           key_symbol;i  
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),%/           &key_symbol,(XComposeStatus *) NULL);%         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }%       case MotionNotify:       {%
         /*0           Discard pending pointer motion events.
         */B         while (XCheckMaskEvent(display,PointerMotionMask,&event));         x=event.xmotion.x;         y=event.xmotion.y;
         /*E           Map and unmap info window as cursor crosses its boundaries.m
         */!         if (windows->info.mapped))           {s>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))hM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }t         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);X         break;       }        default:         break;     }i)     if (state & UpdateConfigurationState)i       {n         intm           x,           y;            register RunlengthPacket
           *p;u  
         /*8           Matte edit is relative to image configuration.
         */         x=0;         y=0;         width=image->columns;l         height=image->rows;s:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,2             &width,&height);=         x_factor=UpShift(width)/windows->image.ximage->width;=C         x_offset=DownShift((windows->image.x+x_offset)*x_factor)+x;e?         y_factor=UpShift(height)/windows->image.ximage->height;rC         y_offset=DownShift((windows->image.y+y_offset)*y_factor)+y;r!         image->class=DirectClass;h         if (!image->matte)           {              /*$               Initialize matte data.             */             p=image->pixels;.             for (i=0; i < image->packets; i++)
             {e               p->index=255;t               p++;
             }w             image->matte=True;           }          switch (method)h	         {u           case PointMethodOp:b           default:           {t             /*=               Update matte information using point algorithm.h             */(             if (!UncompressImage(image))               break;?             p=image->pixels+(y_offset*image->columns+x_offset);r(             p->index=atoi(matte) & 0xff;             break;           }            case ReplaceMethodOp:o           {              RunlengthPacket,               target;s               /*?               Update matte information using replace algorithm.              */             x=0;             p=image->pixels;.             for (i=0; i < image->packets; i++)
             {d               x+=(p->length+1); :               if (x >= (y_offset*image->columns+x_offset))                 break;               p++;
             }t$             target=image->pixels[i];             p=image->pixels;.             for (i=0; i < image->packets; i++)
             { +               if ((p->red == target.red) &&t/                   (p->green == target.green) &&e+                   (p->blue == target.blue)) ,                 p->index=atoi(matte) & 0xff;               p++;
             }s             break;           } !           case FloodfillMethodOp:            {l             /*A               Update matte information using floodfill algorithm.d             */(             if (!UncompressImage(image))               break;G             MatteFloodfill(image,x_offset,y_offset,atoi(matte) & 0xff);              break;           }e	         }e
         /*           Update X matte image. 
         */E         XConfigureImageColormap(display,resource_info,windows,image); 0         XClearWindow(display,windows->image.id);J         (void) XConfigureImageWindow(display,resource_info,windows,image);7         XSetWindowExtents(display,&windows->info,text);p8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);        }i!   } while (!(state & ExitState));eO   XSelectInput(display,windows->image.id,windows->image.attributes.event_mask);lA   XWithdrawWindow(display,windows->info.id,windows->info.screen);)A   XDefineCursor(display,windows->image.id,windows->image.cursor);    XFreeCursor(display,cursor);   return(True);" }o a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %iO %                                                                             %LO %                                                                             %UO %   X D e s p e c k l e I m a g e W i n d o w                                 %eO %                                                                             %mO %                                                                             %rO %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %cC %  Function XNoisyImageWindow reduces the speckles within an image.i %_2 %  The format of the XNoisyImageWindow routine is: % B %    status=XNoisyImageWindow(display,resource_info,windows,image) %d+ %  A description of each parameter follows:s %rI %    o status: Function XNoisyImageWindow return True if the edges withinsF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %fK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.a %i< %    o windows: Specifies a pointer to a XWindows structure. %0F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %i %l */J static unsigned int XNoisyImageWindow(display,resource_info,windows,image) Display\   *display;   
 XResourceInfob   *resource_info;    XWindows   *windows;    Imagea
   **image; {/7 #define NoisyImageText  "  Eliminating peak noise...  "      Imaged     *noisy_image;      /*     Map info window.   */;   XSetWindowExtents(display,&windows->info,NoisyImageText);w'   XMapWindow(display,windows->info.id);C<   XDisplayInfoString(display,&windows->info,NoisyImageText);   /*     Noisy image.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);!   noisy_image=NoisyImage(*image);_A   XDefineCursor(display,windows->image.id,windows->image.cursor);tA   XWithdrawWindow(display,windows->info.id,windows->info.screen);m$   if (noisy_image == (Image *) NULL)     return(False);   DestroyImage(*image);e   *image=noisy_image;M   /*     Update image configuration._   */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);n }s r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)O %                                                                             %nO %                                                                             %iO %                                                                             %mO %   X O i l P a i n t I m a g e W i n d o w                                   %tO %                                                                             %iO %                                                                             %aO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %_1 %  Function XOilPaintImageWindow paints an image.s %d3 %  The format of the XEmbossImageWindow routine is:a %iE %    status=XOilPaintImageWindow(display,resource_info,windows,image)( %a+ %  A description of each parameter follows:= %XL %    o status: Function XOilPaintImageWindow return True if the edges withinF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.u %rD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %sK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.( %n< %    o windows: Specifies a pointer to a XWindows structure. %>F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.n %e %i */M static unsigned int XOilPaintImageWindow(display,resource_info,windows,image)n Display    *display;o  
 XResourceInfo+   *resource_info;)   XWindows   *windows;u   Imageo
   **image; { 6 #define OilPaintImageText  "  Oil painting image...  "     Image      *painted_image;i     /*     Map info window.   */>   XSetWindowExtents(display,&windows->info,OilPaintImageText);'   XMapWindow(display,windows->info.id);;?   XDisplayInfoString(display,&windows->info,OilPaintImageText);    /*     OilPaint image scanlines.e   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);&   painted_image=OilPaintImage(*image);A   XDefineCursor(display,windows->image.id,windows->image.cursor);"A   XWithdrawWindow(display,windows->info.id,windows->info.screen);l&   if (painted_image == (Image *) NULL)     return(False);   DestroyImage(*image);f   *image=painted_image;a   /*     Update image configuration.i   */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);,   return(True);o }i   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*O %                                                                             % O %                                                                             %iO %                                                                             %_O %   X P a n I m a g e W i n d o w                                             %iO %                                                                             %(O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %.N %  Function XPanImageWindow pans the image until the mouse button is released. %n0 %  The format of the XPanImageWindow routine is: %_+ %    XPanImageWindow(display,windows,event)o %x+ %  A description of each parameter follows:n %aE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %eH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.t %r */2 static void XPanImageWindow(display,windows,event) Display_   *display;l   XWindows   *windows;n   XEvent	   *event;( {    char     text[MaxTextLength];     Cursor     cursor;      unsigned longo
     state;     unsigned longi
     x_factor,i
     y_factor;&     XRectangle
     pan_info;n     /*     Map info window.   */<   (void) sprintf(text," %ux%u%+d%+d  ",windows->image.width,7     windows->image.height,windows->image.ximage->width,e#     windows->image.ximage->height);_1   XSetWindowExtents(display,&windows->info,text);e'   XMapWindow(display,windows->info.id);o   /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);x   else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);"     else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow);u
       else3         cursor=XCreateFontCursor(display,XC_arrow);e0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;;   y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height;e   pan_info.x=event->xbutton.x;   pan_info.y=event->xbutton.y;K   pan_info.width=(unsigned short) (UpShift(windows->image.width)/x_factor); M   pan_info.height=(unsigned short) (UpShift(windows->image.height)/y_factor);n    windows->image.x=pan_info.x+1;    windows->image.y=pan_info.y+1;!   state=UpdateConfigurationState;w   do   {;     /*       Wait for next event.     */:     XIfEvent(display,event,XScreenEvent,(char *) windows);     switch (event->type)     {_       case ButtonRelease:l       {n
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=ExitState | UpdateConfigurationState;         break;       }x       case MotionNotify:       {.
         /*/           Discard pending button motion events.t
         */@         while (XCheckMaskEvent(display,ButtonMotionMask,event));$         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }w       default:         break;     }l)     if (state & UpdateConfigurationState)s       {i
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)a           pan_info.x=0;i         elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width);I             pan_info.x=windows->image.ximage->width-windows->image.width;tK         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);          if (pan_info.y < 0)e           pan_info.y=0;e         else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height) K             pan_info.y=windows->image.ximage->height-windows->image.height; /         if ((windows->image.x != pan_info.x) ||l-             (windows->image.y != pan_info.y))p           {f             /*'               Display image pan offset.;             */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,iG               windows->image.height,windows->image.x,windows->image.y); <             XDisplayInfoString(display,&windows->info,text);             /*#               Refresh image window.p             *//             XDrawPanRectangle(display,windows);=D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           } +         state&=(~UpdateConfigurationState);l       }_!   } while (!(state & ExitState));w   /*     Restore cursor.v   */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);    XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);h }D l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%MO %                                                                             %eO %                                                                             %kO %                                                                             %lO %   X P r i n t I m a g e W i n d o w                                         %cO %                                                                             %tO %                                                                             %kO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%g %XF %  Function XPrintImageWindow prints an image to a Postscript printer. %r2 %  The format of the XPrintImageWindow routine is: % B %    status=XPrintImageWindow(display,resource_info,windows,image) %|+ %  A description of each parameter follows:b %dE %    o status: Function XPrintImageWindow return True if the image isuJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. %kD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %-K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %i< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */J static unsigned int XPrintImageWindow(display,resource_info,windows,image) Displayn   *display;   
 XResourceInfo    *resource_info;c   XWindows   *windows;d   Imagey	   *image;a {r/ #define PrintImageText  "  Printing image...  "k     char     command[MaxTextLength],      filename[MaxTextLength],     geometry[MaxTextLength];     Images     *print_image;      ImageInfoa     *image_info;     int      status;*  
   static charn     *PageSizes[]=r     {c       "612x792   Letter",d       "540x720   Note",i       "612x1008  Legal",       "842x1190  A3",a       "595x842   A4",>       "421x595   A5",s       "297x421   A6",        "709x1002  B4",D        "612x936   U.S. Foolscap",$       "612x936   European Foolscap",       "396x612   Half Letter",       "792x1224  11x17",       "1224x792  Ledger",t       (char *) NULLe     };     /*/     Request Postscript page geometry from user.a   */'   image_info=resource_info->image_info;t*   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page);e8   XListBrowserWidget(display,windows,PageSizes,"Select",1     "Select Postscript Page Geometry:",geometry);i   if (*geometry == '\0')     return(True);a   /*     Copy page geometry.i   */F   image_info->page=(char *) malloc((strlen(geometry)+1)*sizeof(char));(   if (image_info->page != (char *) NULL)     {        register chare         *p,          *q;w         q=image_info->page;a:       for (p=geometry; ((*p != ' ') && (*p != '\0')); p++)         *q++=(*p);       *q='\0';     }g   /*      Request file name from user.   *//   XCheckRefreshWindow(display,&windows->image);"   TemporaryFilename(filename);@   (void) sprintf(command,resource_info->print_command,filename);B   XDialogWidget(display,windows,"Print","Print command:",command);   if (*command == '\0')      return(True);.   /*     Alert user we are busy.h   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);;   XSetWindowExtents(display,&windows->info,PrintImageText);*'   XMapWindow(display,windows->info.id);G<   XDisplayInfoString(display,&windows->info,PrintImageText);   XFlush(display);   /*0     Copy image before applying image transforms.   */   image->orphan=True; ?   print_image=CopyImage(image,image->columns,image->rows,True);-   image->orphan=False;$   if (print_image == (Image *) NULL)     {aE       XDefineCursor(display,windows->image.id,windows->image.cursor);sE       XWithdrawWindow(display,windows->info.id,windows->info.screen);t       return(False);     }t8   if ((windows->image.crop_geometry != (char *) NULL) ||>      (print_image->columns != windows->image.ximage->width) ||:      (print_image->rows != windows->image.ximage->height))     {,
       char&         image_geometry[MaxTextLength];         /*          Crop and/or scale image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);(O       TransformImage(&print_image,windows->image.crop_geometry,image_geometry);.     } (   if (resource_info->number_colors != 0)     {x       /*1         Reduce the number of colors in the image.        */0       if ((print_image->class == DirectClass) ||A           (print_image->colors > resource_info->number_colors) ||c8           (resource_info->colorspace == GRAYColorspace))?         QuantizeImage(print_image,resource_info->number_colors,n:           resource_info->tree_depth,resource_info->dither,%           resource_info->colorspace);s       SyncImage(print_image);      }o9   (void) sprintf(print_image->filename,"ps:%s",filename);o,   status=WriteImage(image_info,print_image);   DestroyImage(print_image);"   status&=!SystemCommand(command);   (void) unlink(filename);A   XDefineCursor(display,windows->image.id,windows->image.cursor);>A   XWithdrawWindow(display,windows->info.id,windows->info.screen);,   return(status);r })   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SO %                                                                             %aO %                                                                             %aO %                                                                             %.O %   X R o t a t e I m a g e W i n d o w                                       %eO %                                                                             % O %                                                                             %aO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %iM %  Function XRotateImageWindow rotates the X image.  If the degrees parameter L %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. % 3 %  The format of the XRotateImageWindow routine is:r %tK %    status=XRotateImageWindow(display,resource_info,windows,degrees,image)g %n+ %  A description of each parameter follows:n %mF %    o status: Function XRotateImageWindow return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.p %wD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %dK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %f< %    o windows: Specifies a pointer to a XWindows structure. % D %    o degrees: Specifies the number of degrees to rotate the image. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %i %w */M static unsigned int XRotateImageWindow(display,resource_info,windows,degrees,e   image) Displayp   *display;.  
 XResourceInfo    *resource_info;i   XWindows   *windows;t   double
   degrees;   Image 
   **image; {M0 #define RotateImageText  "  Rotating image...  " #define HorizontalRotateOp  0  #define VerticalRotateOp  1   
   static charf     *ImageRotateHelp[]=t     {oC       "A small horizontal line is drawn next to the pointer.  You",sA       "are now in rotation mode. To exit immediately, press any",;C       "button and release.  In rotation mode a button press has a",sD       "different effect than described in BUTTONS.  Press a button",!       "to affect this behavior:",\	       "",>?       "1    Choose a point in the image window and press this",>A       "     button and hold.  Next, move the pointer to another",iE       "     location in the image.  As you move a line connects the",<E       "     initial location and the pointer.  When you release the",.C       "     button, the degree of image rotation is determined by",s2       "     the slope of the line you just drew.",	       "",i@       "2    Press and drag to select a background color from a",@       "     pop-up menu.  Choose from these background colors:",	       "",=       "         black",c       "         blue",       "         cyan",       "         green",a       "         gray",       "         red",u       "         magenta",o       "         yellow",       "         white",n       "         Browser...",	       "",-D       "    If you select the color browser and press Grab, you can",E       "    choose the empty triangle color by moving the pointer to",iB       "    the desired color on the screen and press any button.",	       "",eC       "3    Press and drag to select a rotate plane from a pop-up",i5       "     menu.  Choose from these rotate planes:", 	       "",s       "         horizontal",       "         vertical",	       "",,C       "To cancel the image rotation, move the pointer back to the",a;       "starting point of the line and release the button.",d       (char *) NULL,     };     char     text[MaxTextLength];  
   ColorPacketC     background;t     double     normalized_degrees;c     Imageo     *rotated_image;t     intF     i,     x,     y;     static unsigned int.     pen_id = 0,n     plane = HorizontalRotateOp;f     unsigned int     height,      rotations,     status, 
     width;     if (degrees == 0.0)w     {s       unsigned int         distance,o
         mask;e         unsigned longo         state;         Window         xwindow;         XEvent         event;         XSegment         rotate_info;         /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);-       XSelectInput(display,windows->image.id,aB         windows->image.attributes.event_mask | PointerMotionMask);L       XQueryPointer(display,windows->image.id,&xwindow,&xwindow,&i,&i,&x,&y,         &mask);n       rotate_info.x1=x;K       rotate_info.y1=y;l       rotate_info.x2=x;k       rotate_info.y2=y;        state=DefaultState;u       do       {t1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info);e
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);m1         XHighlightLine(display,windows->image.id,r9           windows->image.highlight_context,&rotate_info);l         switch (event.type)i	         {d           case ButtonPress:X           {r8             if (event.xbutton.window == windows->pan.id)               {i8                 XPanImageWindow(display,windows,&event);?                 XSetWindowExtents(display,&windows->info,text);i                 break;               }oJ             XSetFunction(display,windows->image.highlight_context,GXcopy);)             switch (event.xbutton.button)r
             {_               case Button1:o               {)                 /*                   Exit loop.                 *//                 rotate_info.x1=event.xbutton.x;f/                 rotate_info.y1=event.xbutton.y; !                 state|=ExitState;r                 break;               }                case Button2:)               {e                 char,                   color_name[MaxTextLength],.                   *ColorMenu[MaxNumberPens+1];                   int                    pen_number;                    /*-                   Initialize menu selections.E                 */1                 for (i=0; i < MaxNumberPens; i++) ;                   ColorMenu[i]=resource_info->pen_color[i];/8                 ColorMenu[MaxNumberPens-1]="Browser...";7                 ColorMenu[MaxNumberPens]=(char *) NULL;                  /*:                   Select a pen color from the pop-up menu.                 */O                 pen_number=XMenuWidget(display,windows,"Pixel Color",ColorMenu,e                   color_name);4                 if (pen_number == (MaxNumberPens-1))                   {                      static chare7                       color_name[MaxTextLength]="gray";=                       /*7                       Select a pen color from a dialog.e                     */I                     resource_info->pen_color[MaxNumberPens-1]=color_name;eM                     XColorBrowserWidget(display,windows,"Select",color_name); ,                     if (*color_name == '\0')                       break;                   }d$                 if (pen_number >= 0)                   {i                     /*$                       Set pen color.                     */&                     pen_id=pen_number;O                     (void) strcpy(color_name,resource_info->pen_color[pen_id]); /                     status=XParseColor(display,tC                       windows->image.map_info->colormap,color_name,bE                       &windows->image.pixel_info->pen_color[pen_id]); $                     if (status == 0)4                       XNoticeWidget(display,windows,C                         "Color is unknown to X server",color_name);tI                     XBestPixel(display,windows->image.map_info->colormap, 4                       (XColor *) NULL,(unsigned int)I                       Min(windows->image.visual_info->colormap_size,256),,E                       &windows->image.pixel_info->pen_color[pen_id]);;                   }                  break;               }a               case Button3:                {.                 char)                   command[MaxTextLength];                    static char                     *RotateMenu[]=                   { !                     "horizontal",                      "vertical",("                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */                 plane=O                   XMenuWidget(display,windows,"Operations",RotateMenu,command);                  break;               } 
             } L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }y           case ButtonRelease:i             break;           case Expose:             break;           case KeyPress:           {              char%               command[MaxTextLength];                KeySym               key_symbol;g               /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command,iC               sizeof(command),&key_symbol,(XComposeStatus *) NULL);a             switch (key_symbol)>
             {                case XK_Escape:a               case XK_F20:               {c                 /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;W                 break;               }                case XK_F1:                case XK_Help:3               { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }p               default:               { !                 XBell(display,0);                  break;               }U
             }              break;           }            case MotionNotify:           {              /*4               Discard pending pointer motion events.             */F             while (XCheckMaskEvent(display,PointerMotionMask,&event));+             rotate_info.x1=event.xmotion.x; +             rotate_info.y1=event.xmotion.y;t           } 	         }g&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;(         if (plane == HorizontalRotateOp)           rotate_info.x2+=32;          else           rotate_info.y2-=32; %       } while (!(state & ExitState)); -       XSelectInput(display,windows->image.id,6.         windows->image.attributes.event_mask);D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);n       if (state & EscapeState)         return(True);        /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0;K*       (void) sprintf(text," %.2f",-180.0);5       XSetWindowExtents(display,&windows->info,text); F       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;s       do       {f         if (distance > 9)            {(             /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id); (             (void) sprintf(text," %.2f",B               plane == VerticalRotateOp ? degrees-90.0 : degrees);<             XDisplayInfoString(display,&windows->info,text);5             XHighlightLine(display,windows->image.id,a=               windows->image.highlight_context,&rotate_info);i           }          else#           if (windows->info.mapped)%K             XWithdrawWindow(display,windows->info.id,windows->info.screen);e
         /*           Wait for next event.
         */?         XIfEvent(display,&event,XScreenEvent,(char *) windows);_         if (distance > 9) 3           XHighlightLine(display,windows->image.id,d;             windows->image.highlight_context,&rotate_info);          switch (event.type)e	         {o           case ButtonPress:              break;           case ButtonRelease:+           {              /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x;t+             rotate_info.y2=event.xbutton.y;o             state|=ExitState;o             break;           }o           case Expose:             break;           case MotionNotify:           {t             /*3               Discard pending button motion events.              */E             while (XCheckMaskEvent(display,ButtonMotionMask,&event));o+             rotate_info.x2=event.xmotion.x; +             rotate_info.y2=event.xmotion.y;o           }e           default:             break;	         }e
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)            rotate_info.x2=0;          else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)&           rotate_info.y2=0;          else5           if (rotate_info.y2 > windows->image.height) 1             rotate_info.y2=windows->image.height; 
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=iP           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9)iC           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2-cG             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1)));p%       } while (!(state & ExitState));aD       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);g       if (distance <= 9)         return(True);      }     if (plane == VerticalRotateOp)     degrees-=90.0;   if (degrees == 0.0)      return(True);    /*     Map info window.   */<   XSetWindowExtents(display,&windows->info,RotateImageText);'   XMapWindow(display,windows->info.id);>=   XDisplayInfoString(display,&windows->info,RotateImageText);    /*     Rotate image.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   normalized_degrees=degrees; $   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)t     normalized_degrees-=90.0;     if (normalized_degrees != 0.0):     if ((windows->image.crop_geometry != (char *) NULL) ||>         ((*image)->columns != windows->image.ximage->width) ||:         ((*image)->rows != windows->image.ximage->height))       {.         char(           image_geometry[MaxTextLength];  
         /*,           Update image with user transforms.
         */L         (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,)           windows->image.ximage->height);dJ         TransformImage(image,windows->image.crop_geometry,image_geometry);:         if (windows->image.crop_geometry != (char *) NULL)           { ?             (void) free((char *) windows->image.crop_geometry); 7             windows->image.crop_geometry=(char *) NULL;e           }e         windows->image.x=0;d         windows->image.y=0;%       }dN   background.red=ColorShift(windows->image.pixel_info->pen_color[pen_id].red);   background.green=hC     ColorShift(windows->image.pixel_info->pen_color[pen_id].green);uP   background.blue=ColorShift(windows->image.pixel_info->pen_color[pen_id].blue);>   rotated_image=RotateImage(*image,degrees,&background,False);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen); &   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);i   *image=rotated_image;.4   if (windows->image.crop_geometry != (char *) NULL)     {        /*         Rotate crop geometry.(       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);e       switch (rotations % 4)       {d         default:         case 0:            break;         case 1:-	         {e           /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);.           break;	         }          case 2:a	         {h           /*             Rotate 180 degrees.            */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);e           break;	         }o         case 3:i	         {e           /*             Rotate 270 degrees.o           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);P           break;	         }(       }      }     if (normalized_degrees != 0.0)     {f       /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {            /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,f             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         } D       XConfigureImageColormap(display,resource_info,windows,*image);     }    else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))h       { J         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }g   /*     Update image configuration.d   */E   (void) XConfigureImageWindow(display,resource_info,windows,*image);    return(True);c }i e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %IO %                                                                             %sO %   X S h a r p e n I m a g e W i n d o w                                     %=O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 2 %  Function XSharpenImageWindow sharpens an image. % 4 %  The format of the XSharpenImageWindow routine is: % D %    status=XSharpenImageWindow(display,resource_info,windows,image) %n+ %  A description of each parameter follows:  % K %    o status: Function XSharpenImageWindow return True if the edges withinoF %      the image are detected.  False is returned is there is a memory3 %      shortage or if the edges cannot be detected.% % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %nK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.m %d< %    o windows: Specifies a pointer to a XWindows structure. %!F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */L static unsigned int XSharpenImageWindow(display,resource_info,windows,image) Displayf   *display;s  
 XResourceInfo+   *resource_info;    XWindows   *windows;t   Imagew
   **image; {o3 #define SharpenImageText  "  Sharpening image...  ".     Image      *sharpened_image;      /*     Map info window.   */=   XSetWindowExtents(display,&windows->info,SharpenImageText); '   XMapWindow(display,windows->info.id); >   XDisplayInfoString(display,&windows->info,SharpenImageText);   /*     Sharpen image scanlines.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);'   sharpened_image=SharpenImage(*image); A   XDefineCursor(display,windows->image.id,windows->image.cursor);gA   XWithdrawWindow(display,windows->info.id,windows->info.screen);i(   if (sharpened_image == (Image *) NULL)     return(False);   DestroyImage(*image);i   *image=sharpened_image;    /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);i   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%yO %                                                                             % O %                                                                             % O %                                                                             %tO %   X S h e a r I m a g e W i n d o w                                         %XO %                                                                             %iO %                                                                             %lO %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %y1 %  Function XShearImageWindow shears the X image.w %o2 %  The format of the XShearImageWindow routine is: %mB %    status=XShearImageWindow(display,resource_info,windows,image) %o+ %  A description of each parameter follows:e %yE %    o status: Function XShearImageWindow return True if the image isiJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.x %eD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %gK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.d %y< %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.g %K %v */J static unsigned int XShearImageWindow(display,resource_info,windows,image) DisplayL   *display;   
 XResourceInfo-   *resource_info;    XWindows   *windows;y   Image 
   **image; {e/ #define ShearImageText  "  Shearing image...  ";  
   ColorPacket      border_color;      float      x_shear,     y_shear;     Imagel     *sheared_image;   
   static chara'     color_name[MaxTextLength] = "gray",l%     geometry[MaxTextLength] = "10.0";(     XColor
     color;     /*!     Get color of empty triangles.a   */;   XColorBrowserWidget(display,windows,"Select",color_name);e   if (*color_name == '\0')     return(True);fJ   XDialogWidget(display,windows,"Shear","Enter shear geometry:",geometry);   if (*geometry == '\0')     return(True);w   /*     Map info window.   */;   XSetWindowExtents(display,&windows->info,ShearImageText);T'   XMapWindow(display,windows->info.id); <   XDisplayInfoString(display,&windows->info,ShearImageText);F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);8   if ((windows->image.crop_geometry != (char *) NULL) ||<       ((*image)->columns != windows->image.ximage->width) ||8       ((*image)->rows != windows->image.ximage->height))     {d
       char&         image_geometry[MaxTextLength];         /**         Update image with user transforms.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);oH       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         {m=           (void) free((char *) windows->image.crop_geometry);>5           windows->image.crop_geometry=(char *) NULL; 	         }        windows->image.x=0;n       windows->image.y=0;a     }    /*     Add a border to the image.   */   x_shear=0.0;   y_shear=0.0;4   (void) sscanf(geometry,"%fx%f",&x_shear,&y_shear);J   (void) XParseColor(display,windows->image.map_info->colormap,color_name,     &color);)   border_color.red=ColorShift(color.red); -   border_color.green=ColorShift(color.green); +   border_color.blue=ColorShift(color.blue);;   sheared_image=M     ShearImage(*image,(double) x_shear,(double) y_shear,&border_color,False); A   XDefineCursor(display,windows->image.id,windows->image.cursor);MA   XWithdrawWindow(display,windows->info.id,windows->info.screen); &   if (sheared_image == (Image *) NULL)     return(False);   DestroyImage(*image);o   *image=sheared_image;n8   windows->image.window_changes.width=(*image)->columns;6   windows->image.window_changes.height=(*image)->rows;@   XConfigureImageColormap(display,resource_info,windows,*image);E   (void) XConfigureImageWindow(display,resource_info,windows,*image);p   return(True);C }r d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             % O %                                                                             % O %   X S c r e e n E v e n t                                                   %aO %                                                                             %nO %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%. %pK %  Function XScreenEvent returns True if the certain events on the X serverU8 %  queue is associated with the image or magnify window. % . %  The format of the XScreenEvent function is: %n' %      XScreenEvent(display,event,data)n %u+ %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %n< %    o event: Specifies a pointer to a X11 XEvent structure. %m9 %    o data: Specifies a pointer to a XWindows structure.  %  %( */+ static int XScreenEvent(display,event,data)  Display    *display;w   XEvent	   *event;    char   *data; {    register int     x,     y;     register XWindows>
     *windows;      windows=(XWindows *) data;   switch (event->type)   {      case ButtonPress:      {f/       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {o           /*+             Convert Alt-Button3 to Button2.o           */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }n8       if (event->xbutton.window == windows->backdrop.id)D         XSetInputFocus(display,event->xbutton.window,RevertToParent,           event->xbutton.time);        return(True);i     }b     case ButtonRelease:L     { 5       if (event->xbutton.window == windows->image.id)r$         if (windows->magnify.mapped)           {              /*%               Update magnified image.              */             x=event->xbutton.x;n             y=event->xbutton.y;              if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;i2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;x2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);r           }        return(True);n     }(     case ClientMessage:,     {-       /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)a         break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id)i	         {)O           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);            return(True); 	         }g       break;     }g     case Expose:     { 5       if (event->xexpose.window == windows->image.id)/	         { 8           XRefreshWindow(display,&windows->image,event);           return(True);i	         }e3       if (event->xexpose.window == windows->pan.id)e&         if (event->xexpose.count == 0)           {m/             XDrawPanRectangle(display,windows);f             return(True);            }        break;     }e     case KeyPress:     {n
       char         command[MaxTextLength];s         KeySym         key_symbol;|         /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);r4       if (event->xkey.window == windows->magnify.id):         XMagnifyWindowCommand(display,windows,key_symbol);       return(True);      }      case MapNotify:m     { 4       if (event->xmap.window == windows->magnify.id)	         { -           XMakeMagnifyImage(display,windows);n'           windows->magnify.mapped=True;s           return(True);m	         }e1       if (event->xmap.window == windows->info.id),	         {g$           windows->info.mapped=True;           return(True);b	         }a       break;     }      case MotionNotify:     { 5       if (event->xmotion.window == windows->image.id) $         if (windows->magnify.mapped)           {=             /*%               Update magnified image.c             */             x=event->xmotion.x;-             y=event->xmotion.y;              if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;s2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;o2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);n           }        return(True);i     }u     case UnmapNotify:      {a6       if (event->xunmap.window == windows->magnify.id)	         {p(           windows->magnify.mapped=False;           return(True);h	         } 3       if (event->xunmap.window == windows->info.id) 	         {d%           windows->info.mapped=False;d           return(True);_	         }        break;     }%     case KeyRelease:     case SelectionNotify:%       return(True);      default:       break;   }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t C l i p G e o m e t r y                                           % O %                                                                             % O %                                                                             %%O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %oH %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  image window and translates it to a cropping geometry relative to the	 %  image.  %A1 %  The format of the XSetCropGeometry routine is:o %s6 %    XSetCropGeometry(display,windows,crop_info,image) %m+ %  A description of each parameter follows:p %fD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %w< %    o windows: Specifies a pointer to a XWindows structure. %nL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      image window to crop. % 7 %    o image: Specifies a pointer to a Image structure.  %  %S */= static void XSetCropGeometry(display,windows,crop_info,image)h DisplayD   *display;o   XWindows   *windows;;  
 RectangleInfoo
   *crop_info;t   Image>	   *image;* {l   char     text[MaxTextLength];     int      x,     y;     unsigned int     height,e
     width;     unsigned long_     scale_factor;n     if (windows->info.mapped)      {h       /*+         Display info on cropping rectangle.t       */?       (void) sprintf(text," %ux%u+%u+%u ",windows->image.width,yJ         windows->image.height,windows->image.width,windows->image.height);5       XSetWindowExtents(display,&windows->info,text); +       XMapWindow(display,windows->info.id);%L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y);l6       XDisplayInfoString(display,&windows->info,text);     }    /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    else     {        /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextLength*sizeof(char));%8       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }e   /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;    if (crop_info->x > 0)p,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);n   if (width == 0)a     width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;h   if (crop_info->y > 0)d,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);    if (height == 0)
     height=1; N   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); }e o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %dO %                                                                             % O %                                                                             % O %   X T i l e I m a g e W i n d o w                                           % O %                                                                             %IO %                                                                             %yO %                                                                             %DO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %;K %  Function XTileImageWindow loads or deletes a selected tile from a visualaG %  image directory.  The load or delete command is choosen from a menu.d %n1 %  The format of the XTileImageWindow routine is:e % L %    tiled_image=XTileImageWindow(display,resource_info,windows,image,event) % + %  A description of each parameter follows:  %nF %    o tiled_image:  XTileImageWindow reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %)E %    o display: Specifies a connection to an X server;  returned from% %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %_H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %  %  */I static Image *XTileImageWindow(display,resource_info,windows,image,event)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;    XEvent	   *event;% {% #define DeleteVerbOp  0% #define LoadVerbOp  1%, #define LoadVerbText  "  Loading image...  "     char     command[MaxTextLength],e     filename[MaxTextLength];     Imagen     *tiled_image;      inta	     tile,a	     verb,s     x,     y;     register char      *p,d     *q;n     register int     i;  
   static chara     *VerbMenu[]=     {i       "Delete",i
       "Load",h       (char *) NULL,     };     unsigned int     height,e
     width;     unsigned longr     scale_factor;t     /**     Select a command from the pop-up menu.   */A   verb=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);s   if (verb < 0)f     return((Image *) NULL);r   /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows;r4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);i;   scale_factor=UpShift(width)/windows->image.ximage->width; %   event->xbutton.x+=windows->image.x;m>   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height; %   event->xbutton.y+=windows->image.y;n>   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*L     Determine size and location of each tile in tghe visual image directory.   */   x=0;   y=0;   width=image->columns;-   height=image->rows;e=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);a@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;,   if (tile < 0)w     {>       /*)         Button press is outside any tile.        */       XBell(display,0);*       return((Image *) NULL);y     }    /*0     Determine file name from the tile directory.   */   p=image->directory;f*   for (i=tile; (i != 0) && (*p != '\0'); )   {w     if (*p == '\n')o
       i--;     p++;   }n   if (*p == '\0')*     {%       /*)         Button press is outside any tile.%       */       XBell(display,0);        return((Image *) NULL);      }    q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);    filename[q-p]='\0';    /**     Perform command for the selected tile.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   XFlush(display);   tiled_image=(Image *) NULL;    switch (verb)    {      case DeleteVerbOp:     { 	       int          status,          x_offset,          y_offset;          register RunlengthPacket         *p;          /*         Delete tile image.       */L       status=XConfirmWidget(display,windows,"Really delete tile?",filename);       if (status == False)         break;       status=unlink(filename);       if (status != False)	         {rG           XNoticeWidget(display,windows,"Unable to delete image file:",w             filename);           break;	         }r       /*-         Overwrite tile with background color.n       */"       if (!UncompressImage(image))         return((Image *) NULL);l;       x_offset=width*(tile % ((image->columns-x)/width))+x; :       y_offset=height*(tile/((image->columns-x)/width))+y;        for (y=0; y < height; y++)       {e?         p=image->pixels+((y_offset+y)*image->columns+x_offset); !         for (x=0; x < width; x++)r            *p++=(*image->pixels);       }o9       windows->image.window_changes.width=image->columns; 7       windows->image.window_changes.height=image->rows;aC       XConfigureImageColormap(display,resource_info,windows,image);sH       (void) XConfigureImageWindow(display,resource_info,windows,image);       break;     }n     case LoadVerbOp:     default:     {o       /*         Load tile image.       */=       XSetWindowExtents(display,&windows->info,LoadVerbText);o+       XMapWindow(display,windows->info.id);s>       XDisplayInfoString(display,&windows->info,LoadVerbText);B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info);aE       XWithdrawWindow(display,windows->info.id,windows->info.screen);        break;     }g   }aA   XDefineCursor(display,windows->image.id,windows->image.cursor);o   return(tiled_image); }p , /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %-O %                                                                             %;O %                                                                             %pO %   X T r a n s l a t e I m a g e W i n d o w                                 %tO %                                                                             %xO %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%M %  Function XTranslateImageWindow translates the image within an image window M %  by one pixel as specified by the key symbol.  If the image has a `montage' M %  string the translation is respect to the width and height contained within  %  the string. % 6 %  The format of the XTranslateImageWindow routine is: % < %    XTranslateImageWindow(display,windows,image,key_symbol) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.% %%M %    o key_symbol: Specifies a KeySym which indicates which side of the imageo %      to trim.  %i %t */C static void XTranslateImageWindow(display,windows,image,key_symbol)  Display    *display;I   XWindows   *windows;c   Imagen	   *image;    KeySym
   key_symbol;  {h   intt     x,     y;     unsigned int
     x_offset,a
     y_offset;      /*)     User specified a pan position offset.e   */
   x_offset=1; 
   y_offset=1;r&   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)    {      case XK_Home:      case XK_KP_Home:     {e1       windows->image.x=windows->image.width >> 1; 2       windows->image.y=windows->image.height >> 1;       break;     }i     case XK_Left:o     case XK_KP_Left:     {r!       windows->image.x-=x_offset;        break;     }g     case XK_Up:e     case XK_KP_Up:     {o!       windows->image.y-=y_offset;l       break;     }      case XK_Right:     case XK_KP_Right:s     {m!       windows->image.x+=x_offset;m       break;     }i     case XK_Down:g     case XK_KP_Down:     { !       windows->image.y+=y_offset;S       break;     }a     default:       break;   }    /*     Check boundary conditions.   */   if (windows->image.x < 0)i     windows->image.x=0;)   elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width)dI       windows->image.x=windows->image.ximage->width-windows->image.width;a   if (windows->image.y < 0),     windows->image.y=0;-   elseQ     if ((windows->image.y+windows->image.height) > windows->image.ximage->height)(K       windows->image.y=windows->image.ximage->height-windows->image.height;o   /*     Refresh image window.(   */%   XDrawPanRectangle(display,windows);):   XRefreshWindow(display,&windows->image,(XEvent *) NULL); }i   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %cO %   X T r i m I m a g e W i n d o w                                           %sO %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XTrimImageWindow trims the edges from the image window.  % 1 %  The format of the XTrimImageWindow routine is:  % A %    status=XTrimImageWindow(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o status: Function XTrimImageWindow returns True if the image is J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.% %%D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %XK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %u< %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. %w7 %    o image: Specifies a pointer to a Image structure.  %e %s */I static unsigned int XTrimImageWindow(display,resource_info,windows,image)X Displayr   *display;   
 XResourceInfoa   *resource_info;u   XWindows   *windows;n   ImageX	   *image;e {o. #define TrimImageText  "  Trimming image...  "     RectangleInfo      trim_info;     register int     x,     y;     unsigned longt     background,c
     pixel;     /*     Alert user we are busy.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);:   XSetWindowExtents(display,&windows->info,TrimImageText);'   XMapWindow(display,windows->info.id);i;   XDisplayInfoString(display,&windows->info,TrimImageText);_   XFlush(display);   /*     Trim edges from image.   */2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;x2   for (x=0; x < windows->image.ximage->width; x++)   { 5     for (y=0; y < windows->image.ximage->height; y++)e     {a1       pixel=XGetPixel(windows->image.ximage,x,y);i       if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   }i   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     { E       XDefineCursor(display,windows->image.id,windows->image.cursor); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);        return(False);     }o4   for (x=windows->image.ximage->width-1; x > 0; x--)   {a5     for (y=0; y < windows->image.ximage->height; y++)      { 1       pixel=XGetPixel(windows->image.ximage,x,y);        if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   })"   trim_info.width=x-trim_info.x+1;1   trim_info.height=windows->image.ximage->height; 3   for (y=0; y < windows->image.ximage->height; y++)    {f4     for (x=0; x < windows->image.ximage->width; x++)     {i1       pixel=XGetPixel(windows->image.ximage,x,y);d       if (pixel != background)         break;     } )     if (x < windows->image.ximage->width)a       break;   }    trim_info.y=y;5   for (y=windows->image.ximage->height-1; y > 0; y--)n   {g4     for (x=0; x < windows->image.ximage->width; x++)     {x1       pixel=XGetPixel(windows->image.ximage,x,y);p       if (pixel != background)         break;     }g)     if (x < windows->image.ximage->width)        break;   }a#   trim_info.height=y-trim_info.y+1;s2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {l       /*F         Reconfigure image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image);W:       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;H       (void) XConfigureImageWindow(display,resource_info,windows,image);     }.A   XDefineCursor(display,windows->image.id,windows->image.cursor);iA   XWithdrawWindow(display,windows->info.id,windows->info.screen);*   return(True);  }I   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %*O %   X W a r n i n g                                                           % O %                                                                             % O %                                                                             %gO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %eC %  Function XWarning displays a warning message in a Notice widget.  %v) %  The format of the XWarning routine is:  %N" %      XWarning(message,qualifier) % + %  A description of each parameter follows:e %;G %    o message: Specifies the message to display before terminating the  %      program.T %L9 %    o qualifier: Specifies any qualifier to the message.  %  %i */' static void XWarning(message,qualifier)e char   *message,V
   *qualifier;a {e   char     text[MaxTextLength];     if (message == (char *) NULL)i     return;r   (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }  g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   X W r i t e I m a g e W i n d o w                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%8 %  Function XWriteImageWindow writes an image to a file. %%2 %  The format of the XWriteImageWindow routine is: %aB %    status=XWriteImageWindow(display,resource_info,windows,image) %t+ %  A description of each parameter follows:f %eE %    o status: Function XWriteImageWindow return True if the image islJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.u %d< %    o windows: Specifies a pointer to a XWindows structure. %tF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.e %r %n */J static unsigned int XWriteImageWindow(display,resource_info,windows,image) Display    *display;   
 XResourceInfoo   *resource_info;i   XWindows   *windows;    Imageo	   *image;c {e. #define WriteImageText  "  Writing image...  "     char     filename[MaxTextLength];     Image      *write_image;      ImageInfoI     *image_info;     inty     status;o     register chars     *p;      /*      Request file name from user.   */.   p=image->filename+strlen(image->filename)-1;A   while ((p > image->filename) && (*(p-1) != *BasenameSeparator))m     p--;   (void) strcpy(filename,p);5   if (resource_info->write_filename != (char *) NULL) :     (void) strcpy(filename,resource_info->write_filename);7   XFileBrowserWidget(display,windows,"Write",filename);"   if (*filename == '\0')     return(True);i'   image_info=resource_info->image_info;a/   (void) strcpy(image_info->filename,filename); ,   SetImageMagick(resource_info->image_info);1   if ((strcmp(image_info->magick,"JPEG") == 0) ||a.       (strcmp(image_info->magick,"JPG") == 0))     {g
       char         quality[MaxTextLength];m         /*'         Request JPEG quality from user.a       */7       (void) sprintf(quality,"%u",image_info->quality);fK       XDialogWidget(display,windows,"Write","Enter JPEG quality:",quality);h       if (*quality == '\0'),         return(True); (       image_info->quality=atoi(quality);     }f0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) ||o.       (strcmp(image_info->magick,"PS2") == 0))     {.
       char          geometry[MaxTextLength];         static char          *PageSizes[]=P	         {a           "612x792   Letter",p           "540x720   Note",            "612x1008  Legal",           "842x1190  A3",            "595x842   A4",y           "421x595   A5",            "297x421   A6",l           "709x1002  B4",r$           "612x936   U.S. Foolscap",(           "612x936   European Foolscap","           "396x612   Half Letter",           "792x1224  11x17",           "1224x792  Ledger",d           (char *) NULLe
         };         /*3         Request Postscript page geometry from user.b       */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page); <       XListBrowserWidget(display,windows,PageSizes,"Select",5         "Select Postscript Page Geometry:",geometry);        if (*geometry != '\0')	         {h           /*             Copy page geometry.            */N           image_info->page=(char *) malloc((strlen(geometry)+1)*sizeof(char));0           if (image_info->page != (char *) NULL)
             {a               register char                  *p,a                 *q;   !               q=image_info->page;rB               for (p=geometry; ((*p != ' ') && (*p != '\0')); p++)                 *q++=(*p);               *q='\0';
             }i	         }e     }e   /*     Alert user we are busy.e   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);;   XSetWindowExtents(display,&windows->info,WriteImageText); '   XMapWindow(display,windows->info.id);r<   XDisplayInfoString(display,&windows->info,WriteImageText);   XFlush(display);   /*0     Copy image before applying image transforms.   */   image->orphan=True; ?   write_image=CopyImage(image,image->columns,image->rows,True);v   image->orphan=False;$   if (write_image == (Image *) NULL)     {tE       XDefineCursor(display,windows->image.id,windows->image.cursor);.E       XWithdrawWindow(display,windows->info.id,windows->info.screen);z       return(False);     } &   write_image->montage=image->montage;*   write_image->directory=image->directory;8   if ((windows->image.crop_geometry != (char *) NULL) ||>      (write_image->columns != windows->image.ximage->width) ||:      (write_image->rows != windows->image.ximage->height))     {"
       char&         image_geometry[MaxTextLength];         /*          Crop and/or scale image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height); O       TransformImage(&write_image,windows->image.crop_geometry,image_geometry);      } (   if (resource_info->number_colors != 0)     {"       /*1         Reduce the number of colors in the image.n       */0       if ((write_image->class == DirectClass) ||A           (write_image->colors > resource_info->number_colors) ||o8           (resource_info->colorspace == GRAYColorspace))?         QuantizeImage(write_image,resource_info->number_colors,9:           resource_info->tree_depth,resource_info->dither,%           resource_info->colorspace);        SyncImage(write_image);e     }a0   (void) strcpy(write_image->filename,filename);,   status=WriteImage(image_info,write_image);   DestroyImage(write_image);A   XDefineCursor(display,windows->image.id,windows->image.cursor); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    return(status);f }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %hO %                                                                             % O %                                                                             % O %    M a i n                                                                  %eO %                                                                             %.O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" %  %  */ int main(argc,argv)e int    argc;t   char	   **argv;" { + #define NotInitialized  (unsigned int) (~0)d     char     *option,     *resource_value,     *server_name;      Imagei     *image,t     *next_image;     ImageInfos     image_info;      into     i,     x;     unsigned int     compression,     first_scene,     *image_marker,     image_number,e     last_scene,e
     matte,
     scene;     unsigned longe
     state;     XResourceInfoo     resource_info;  
   XrmDatabase      resource_database,     server_database;     /*     Set defaults.    */   client_name=(*argv);   display=(Display *) NULL;r   first_scene=0;F   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)i     image_marker[i]=argc;    image_number=0;a   GetImageInfo(&image_info);   matte=NotInitialized;m   last_scene=0;p'   resource_database=(XrmDatabase) NULL;e   server_name=(char *) NULL;   state=DefaultState;l   /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);t   for (i=1; i < argc; i++)   {_     /*)       Check command line for server name.=     */     option=argv[i];9M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+'))) -       if (strncmp("display",option+1,3) == 0)L	         {n           /*'             User specified server name.a           */           i++;           if (i == argc)C             Error("Missing server name on -display",(char *) NULL);t           server_name=argv[i];           break;	         }e   }b   /*     Open X server connection.0   */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));)   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);n   /*!     Initialize resource database.a   */   XrmInitialize();+   XGetDefault(display,client_name,"dummy"); ,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display);e&   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value); 8   XrmMergeDatabases(server_database,&resource_database);   /*/     Get user defaults from X resource database.    */A   XGetResourceInfo(resource_database,client_name,&resource_info);iO   resource_value=XGetResourceClass(resource_database,client_name,"compression",m     "RunlengthEncoded");4   if (Latin1Compare("qencoded",resource_value) == 0)$     compression=QEncodedCompression;   else,     compression=RunlengthEncodedCompression;   image_info.density=_M     XGetResourceClass(resource_database,client_name,"density",(char *) NULL);e   resource_value=oH     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace; 0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace; 1   if (Latin1Compare("plane",resource_value) == 0)_(     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace) :     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value= D     XGetResourceClass(resource_database,client_name,"quality","85");*   image_info.quality=atoi(resource_value);N   resource_value=XGetResourceClass(resource_database,client_name,"scene","0");   scene=atoi(resource_value);e   resource_value=_G     XGetResourceClass(resource_database,client_name,"verbose","False");a,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.    */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)f   {r     if (i < argc)        option=argv[i];o     else       if (image_number == 0)         option="xc:"; 
       else         break;M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+')))a       switch (*(option+1))       {a         case 'b': 	         {L2           if (strncmp("backdrop",option+1,5) == 0)
             { 6               resource_info.backdrop=(*option == '-');               break;
             }y4           if (strncmp("background",option+1,5) == 0)
             {h;               resource_info.background_color=(char *) NULL;o!               if (*option == '-')L                 {i                   i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];                  }u               break;
             }*.           if (strncmp("blur",option+1,2) == 0)             break;-           if (strcmp("border",option+1) == 0)o
             {y!               if (*option == '-')h                 {a                   i++;                    if (i == argc)G                     Error("Missing geometry on -border",(char *) NULL);                  }a               break;
             }r5           if (strncmp("bordercolor",option+1,7) == 0);
             { 7               resource_info.border_color=(char *) NULL;N!               if (*option == '-')e                 {a                   i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);_5                   resource_info.border_color=argv[i];f                 }                break;
             } 5           if (strncmp("borderwidth",option+1,7) == 0) 
             {a+               resource_info.border_width=0;)!               if (*option == '-')                  {N                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL); ;                   resource_info.border_width=atoi(argv[i]);r                 }l               break;
             } .           Error("Unrecognized option",option);           break;	         },         case 'c':i	         { 2           if (strncmp("colormap",option+1,6) == 0)
             { 5               resource_info.colormap=PrivateColormap; !               if (*option == '-')                  {e                   i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL);e!                   option=argv[i];);                   resource_info.colormap=UndefinedColormap;t;                   if (Latin1Compare("private",option) == 0) ;                     resource_info.colormap=PrivateColormap; :                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);                  }0               break;
             }o0           if (strncmp("colors",option+1,7) == 0)
             { ,               resource_info.number_colors=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }                break;
             }e4           if (strncmp("colorspace",option+1,7) == 0)
             {u5               resource_info.colorspace=RGBColorspace;e!               if (*option == '-')d                 {g                   i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL);*!                   option=argv[i]; ?                   resource_info.colorspace=UndefinedColorspace;a8                   if (Latin1Compare("gray",option) == 0)                     {X>                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;C                     }a8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0)d;                     resource_info.colorspace=RGBColorspace;d7                   if (Latin1Compare("xyz",option) == 0) ;                     resource_info.colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0)e=                     resource_info.colorspace=YCbCrColorspace;_7                   if (Latin1Compare("yiq",option) == 0)h;                     resource_info.colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0)l=                     resource_info.colorspace=YPbPrColorspace;,7                   if (Latin1Compare("yuv",option) == 0) ;                     resource_info.colorspace=YUVColorspace; F                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);e                 }o               break;
             }n1           if (strncmp("comment",option+1,4) == 0)e
             { !               if (*option == '-')a                 {"                   i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);,                 }"               break;
             }e2           if (strncmp("compress",option+1,3) == 0)
             { (               compression=NoCompression;!               if (*option == '-')s                 {>                   i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL); !                   option=argv[i];iD                   if (Latin1Compare("runlengthencoded",option) == 0)<                     compression=RunlengthEncodedCompression;                   else>                     if (Latin1Compare("qencoded",option) == 0)6                       compression=QEncodedCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }i               break;
             }r2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')z                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);v                 }e               break;
             }*.           Error("Unrecognized option",option);           break;	         }i         case 'd':h	         {i/           if (strncmp("debug",option+1,3) == 0)/
             {i3               resource_info.debug=(*option == '-');m               break;
             }r/           if (strncmp("delay",option+1,3) == 0)o
             {,$               resource_info.delay=0;!               if (*option == '-'),                 {f                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL);e4                   resource_info.delay=atoi(argv[i]);                 }y               break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')a                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];n                 }*               break;
             }e3           if (strncmp("despeckle",option+1,3) == 0)d             break;1           if (strncmp("display",option+1,3) == 0))
             {w(               server_name=(char *) NULL;!               if (*option == '-')*                 {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL);g&                   server_name=argv[i];                 } 4               resource_info.server_name=server_name;               break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 4               resource_info.dither=(*option == '-');               break;
             }a.           Error("Unrecognized option",option);           break;	         }m         case 'e': 	         {i.           if (strncmp("edge",option+1,2) == 0)             break;1           if (strncmp("enhance",option+1,2) == 0)i             break;2           if (strncmp("equalize",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }m         case 'f': 	         {u.           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             { /               resource_info.font=(char *) NULL;a!               if (*option == '-')                  {n                   i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];f                 }                break;
             } 3          if (strncmp("foreground",option+1,3) == 0)X            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;(                  if (i == argc) L                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }.           Error("Unrecognized option",option);           break;	         }W         case 'g':r	         {d/           if (strncmp("gamma",option+1,2) == 0) 
             { !               if (*option == '-')a                 {g                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);o                 }                break;
             }o2           if (strncmp("geometry",option+1,2) == 0)
             { 9               resource_info.image_geometry=(char *) NULL;,!               if (*option == '-')                  {e                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL);n7                   resource_info.image_geometry=argv[i];(                 }                break;
             }p.           Error("Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             {a               Usage(True);               break;
             }c.           Error("Unrecognized option",option);           break;	         }t         case 'i':i	         {l6           if (strncmp("iconGeometry",option+1,5) == 0)
             {;8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')g                 {e                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))M                     Error("Missing geometry on -iconGeometry",(char *) NULL);n6                   resource_info.icon_geometry=argv[i];                 }                break;
             }i0           if (strncmp("iconic",option+1,5) == 0)
             {y4               resource_info.iconic=(*option == '-');               break;
             }i3           if (strncmp("interlace",option+1,3) == 0)g
             {a1               image_info.interlace=NoneInterlace;f!               if (*option == '-')n                 {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i];":                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace;e8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace;-9                   if (Latin1Compare("plane",option) == 0)s8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace)DI                     Error("Invalid interlace type on -interlace",option);i                 }i               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'l': 	         {_/           if (strncmp("label",option+1,2) == 0)t
             { !               if (*option == '-')[                 {"                   i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }p               break;
             }\.           Error("Unrecognized option",option);           break;	         }i         case 'm': 	         {h1           if (strncmp("magnify",option+1,3) == 0))
             {)&               resource_info.magnify=2;!               if (*option == '-')                  {p                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL);y6                   resource_info.magnify=atoi(argv[i]);                 }                break;
             }[-           if (strncmp("map",option+1,3) == 0)a
             {g3               resource_info.map_type=(char *) NULL;m!               if (*option == '-')                  {\                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];p                 }i               break;
             }n,           if (strcmp("matte",option+1) == 0)
             { %               matte=(*option == '-');y               break;
             } 4           if (strncmp("mattecolor",option+1,6) == 0)
             { 6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')a                 {p                   i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 };               break;
             } 2           if (strncmp("modulate",option+1,3) == 0)
             {-!               if (*option == '-')                  {i                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing value on -modulate",(char *) NULL);                 }g               break;
             }X4           if (strncmp("monochrome",option+1,3) == 0)
             { 8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)n                 {s0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8;a:                   resource_info.colorspace=GRAYColorspace;                 }(               break;
             }2.           Error("Unrecognized option",option);           break;	         }e         case 'n':o	         {i.           if (strncmp("name",option+1,2) == 0)
             {C/               resource_info.name=(char *) NULL; !               if (*option == '-')s                 {w                   i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL);m-                   resource_info.name=argv[i];,                 }o               break;
             }d0           if (strncmp("negate",option+1,2) == 0)             break;/           if (strncmp("noise",option+1,3) == 0)o             break;3           if (strncmp("normalize",option+1,3) == 0)s             break;.           Error("Unrecognized option",option);           break;	         },         case 'p':n	         {s.           if (strncmp("page",option+1,3) == 0)
             {-,               image_info.page=(char *) NULL;!               if (*option == '-')a                 {X                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing page geometry on -page",(char *) NULL);*                   image_info.page=argv[i];                 }n               break;
             }M5           if (strncmp("panGeometry",option+1,3) == 0)o
             {&7               resource_info.pan_geometry=(char *) NULL;o!               if (*option == '-')-                 {;                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))L                     Error("Missing geometry on -panGeometry",(char *) NULL);5                   resource_info.pan_geometry=argv[i];c                 }n               break;
             }i.           Error("Unrecognized option",option);           break;	         }o         case 'q': 	         {;           i++;6           if ((i == argc) || !sscanf(argv[i],"%d",&x))?             Error("Missing quality on -quality",(char *) NULL);s,           image_info.quality=atoi(argv[i]);;           break;	         }          case 'r':g	         {i.           if (strncmp("roll",option+1,3) == 0)
             {d!               if (*option == '-')u                 {h                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -roll",(char *) NULL);o                 }i               break;
             } 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')d                 {o                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }o               break;
             }).           Error("Unrecognized option",option);           break;	         }l         case 's':*	         {e0           if (strncmp("sample",option+1,2) == 0)
             {a!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing geometry on -sample",(char *) NULL);a                 }o               break;
             })/           if (strncmp("scene",option+1,3) == 0) 
             {                first_scene=0;               last_scene=0;(!               if (*option == '-')a                 {s                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene;*J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 },               break;
             } 1           if (strncmp("sharpen",option+1,3) == 0),             break;/           if (strncmp("shear",option+1,3) == 0) 
             { !               if (*option == '-')X                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))L                     Error("Missing shear geometry on -shear",(char *) NULL);                 },               break;
             } 7           if (strncmp("shared_memory",option+1,4) == 0) 
             {;?               resource_info.use_shared_memory=(*option == '-');g               break;
             }g.           if (strncmp("size",option+1,2) == 0)
             {s,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -size",(char *) NULL);t*                   image_info.size=argv[i];                 }r               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't':i	         { 3           if (strncmp("text_font",option+1,3) == 0) 
             { 4               resource_info.text_font=(char *) NULL;!               if (*option == '-')p                 {G                   i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL);D2                   resource_info.text_font=argv[i];                 }                break;
             }g/           if (strncmp("title",option+1,2) == 0)c
             {l0               resource_info.title=(char *) NULL;!               if (*option == '-')e                 {C                   i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL); .                   resource_info.title=argv[i];                 }m               break;
             }e3           if (strncmp("treedepth",option+1,2) == 0) 
             {e)               resource_info.tree_depth=0;e!               if (*option == '-')D                 {,                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL);w9                   resource_info.tree_depth=atoi(argv[i]);i                 }i               break;
             }o.           Error("Unrecognized option",option);           break;	         }c         case 'u':C	         {a0           if (strncmp("update",option+1,2) == 0)
             {g4               resource_info.update=(*option == '-');!               if (*option == '-')l                 {n                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }r               break;
             }d4           if (strncmp("use_pixmap",option+1,2) == 0)
             { 8               resource_info.use_pixmap=(*option == '-');               break;
             }o.           Error("Unrecognized option",option);           break;	         }f         case 'v': 	         {t1           if (strncmp("verbose",option+1,2) == 0)(
             {,2               image_info.verbose=(*option == '-');               break;
             }n0           if (strncmp("visual",option+1,2) == 0)
             { 6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')s                 {(                   i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL); 4                   resource_info.visual_type=argv[i];                 }h               break;
             } .           Error("Unrecognized option",option);           break;	         })         case 'w':s	         { 0           if (strncmp("window",option+1,2) == 0)
             {x4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window",*%                       (char *) NULL); 2                   resource_info.window_id=argv[i];                 }                break;
             }e/           if (strncmp("write",option+1,2) == 0);
             {a9               resource_info.write_filename=(char *) NULL;L!               if (*option == '-')e                 {E                   i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL);n7                   resource_info.write_filename=argv[i];WB                   if (access(resource_info.write_filename,0) == 0)                     {N                       char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ", 6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }C                 }                break;
             }n.           Error("Unrecognized option",option);           break;	         }m         default:	         {n.           Error("Unrecognized option",option);           break;	         }d       }      else<       for (scene=first_scene; scene <= last_scene ; scene++)       {i
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {i             char&               filename[MaxTextLength];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene);,:             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene);e8             (void) strcpy(image_info.filename,filename);           }e9         image_info.server_name=resource_info.server_name;_+         image_info.font=resource_info.font; /         image_info.dither=resource_info.dither;m7         image_info.monochrome=resource_info.monochrome;C/         resource_info.image_info=(&image_info);o%         image=ReadImage(&image_info); $         if (image == (Image *) NULL)           if (i < (argc-1))              continue;e           else
             {                state|=ExitState;D               break;
             }_
         do	         {i&           if (matte != NotInitialized)             image->matte=matte; 2           if (compression != UndefinedCompression)+             image->compression=compression;            if (scene != 0)r             image->scene=scene;            /*J             Transmogrify image as defined by the image processing options.           */2           MogrifyImage(&image_info,i,argv,&image);           /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL)s
             {>               /*6                 Display image to a specified X window.               */D               XDisplayBackgroundImage(display,&resource_info,image);               state&=ExitState; 
             }g           else             do
             {y               Image|                 *loaded_image;                 /**                 Display image to X server.               */               loaded_image=eN                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)k                 break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               { ;                 if (loaded_image->montage != (char *) NULL)t                   {                      /*G                       User selected a visual directory image (montage).                      */(                     DestroyImage(image);'                     image=loaded_image;.                     break;                   } ?                 MogrifyImage(&image_info,i,argv,&loaded_image);rJ                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image)-                   DestroyImage(loaded_image);i(                 loaded_image=next_image;               }o+             } while (!(state & ExitState));o<           if (resource_info.write_filename != (char *) NULL)
             {a               /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image);a
             }r!           if (image_info.verbose)_!             DescribeImage(image);%           /*+             Proceed to next/previous image.%           */'           if (state & FormerImageState) '             next_image=image->previous;            else#             next_image=image->next; +           if (next_image != (Image *) NULL)              image=next_image; I         } while ((next_image != (Image *) NULL) && !(state & ExitState)); 
         /*           Free image resources. 
         */1         while (image->previous != (Image *) NULL)             image=image->previous;         DestroyImages(image); (         if (!(state & FormerImageState)))           image_marker[i]=image_number++;          else           {%             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--)f6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;n           }w         if (state & ExitState)           break;       }e     if (i == (argc-1))<       if ((resource_info.delay != 0) && (image_number != 1))	         {i           /*#             Proceed to first image.p           */           i=0;           image_number=0;w	         }.   }    XCloseDisplay(display);o%   (void) free((char *) image_marker);N,   (void) free((char *) image_info.filename);
   exit(0);   return(False); }m