 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                 IIIII  M   M  PPPP    OOO   RRRR   TTTTT                    % O %                   I    MM MM  P   P  O   O  R   R    T                      % O %                   I    M M M  PPPP   O   O  RRRR     T                      % O %                   I    M   M  P      O   O  R R      T                      % O %                 IIIII  M   M  P       OOO   R  R     T                      % O %                                                                             % O %                                                                             % O %             Import X11 image to a machine independent format.               % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Import is an X Window System window dumping utility.  Import allows XI %  users to store window images in a specially formatted dump file.  This H %  file can then be read by the Display utility for redisplay, printing,E %  editing, formatting, archiving, image processing, etc.  The target G %  window can be specified by id or name or be selected by clicking the F %  mouse in the desired window.  The keyboard bell is rung once at the> %  beginning of the dump and twice when the dump is completed. % ( %  The import program command syntax is: % # %  Usage: import [options ...] file  %  %  Where options include: B %    -border             include image borders in the output image@ %    -colors value       preferred number of colors in the imageH %    -colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV4 %    -comment string     annotate image with comment5 %    -compress type      RunlengthEncoded or QEncoded I %    -crop geometry      preferred size and location of the cropped image = %    -delay seconds      pause before selecting target window E %    -density geometry   vertical and horizontal density of the image D %    -descend            obtain image by descending window hierarchy, %    -display server     X server to contact5 %    -frame              include window manager frame @ %    -geometry geometry  perferred size or location of the image- %    -interlace type     NONE, LINE, or PLANE 3 %    -label name         assign a label to an image ; %    -monochrome         transform image to black and white 7 %    -negate             apply color inversion to image A %    -page geometry      size and location of the Postscript page - %    -quality value      JPEG quality setting : %    -rotate degrees     apply Paeth rotation to the image+ %    -scene value        image scene number 6 %    -screen             select image from root window? %    -treedepth value    depth of the color classification tree C %    -verbose            print detailed information about the image ; %    -window id          select window with this id or name  % ? %  Change '-' to '+' in any option above to reverse its effect. 9 %  For example, +frame means do not window manager frame.  % L %  By default, 'file' is written in the Postscript image format.  To specifyG %  a particular image format, precede the filename with an image format D %  name and a colon (i.e. ps:image) or specify the image type as theG %  filename suffix (i.e. image.ps).  Specify 'file' as '-' for standard  %  input or output.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "X.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % & %  The format of the Usage routine is: %  %      Usage() %  %  */ static void Usage()  {    char     **p;  
   static char      *options[]=      { F       "-border             include image borders in the output image",D       "-colors value       preferred number of colors in the image",L       "-colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV",8       "-comment string     annotate image with comment",9       "-compress type      RunlengthEncoded or QEncoded", M       "-crop geometry      preferred size and location of the cropped image", A       "-delay seconds      pause before selecting target window", I       "-density geometry   vertical and horizontal density of the image", H       "-descend            obtain image by descending window hierarchy",0       "-display server     X server to contact",9       "-frame              include window manager frame", D       "-geometry geometry  perferred size or location of the image",1       "-interlace type     NONE, LINE, or PLANE", 7       "-label name         assign a label to an image", ?       "-monochrome         transform image to black and white", ;       "-negate             apply color inversion to image", E       "-page geometry      size and location of the Postscript page", 1       "-quality value      JPEG quality setting", >       "-rotate degrees     apply Paeth rotation to the image",/       "-scene value        image scene number", C       "-treedepth value    depth of the color classification tree", :       "-screen             select image from root window",G       "-verbose            print detailed information about the image", ?       "-window id          select window with this id or name",        (char *) NULL      };  3   (void) fprintf(stderr,"Version: %s\n\n",Version); F   (void) fprintf(stderr,"Usage: %s [options ...] file\n",client_name);6   (void) fprintf(stderr,"\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++) '     (void) fprintf(stderr,"  %s\n",*p);    (void) fprintf(stderr,H     "\nChange '-' to '+' in any option above to reverse its effect.\n");   (void) fprintf(stderr,H     "For example, +frame means do not include window manager frame.\n");   (void) fprintf(stderr,K   "\nBy default, 'file' is written in the Postscript image format.  To\n");    (void) fprintf(stderr,O     "specify a particular image format, precede the filename with an image\n");    (void) fprintf(stderr,N     "format name and a colon (i.e. ps:image) or specify the image type as\n");   (void) fprintf(stderr,I     "the filename suffix (i.e. image.ps).  Specify 'file' as '-' for\n"); 7   (void) fprintf(stderr,"standard input or output.\n"); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %    M a i n                                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(argc,argv)  int    argc;    char
   *argv[]; {    char     *filename,     *option,     *resource_value,     *target_window;   	   Display 
     *display;      Image      *image;      ImageInfo      image_info;      int      i,     x;     unsigned int     borders,     compression,     descend,
     frame,
     scene,     screen;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database,     server_database;     /*A     Display usage profile if there are no command line arguments.    */   client_name=(*argv);   if (argc < 2)      Usage();   /*     Connect to X server.   */'   image_info.server_name=(char *) NULL;    for (i=1; i < argc; i++)   {      /*)       Check command line for server name.      */     option=argv[i]; M     if (((int) strlen(option) > 1) && ((*option == '-') || (*option == '+'))) )       if (strncmp("dis",option+1,3) == 0) 	         {            /*'             User specified server name.            */           i++;           if (i == argc)C             Error("Missing server name on -display",(char *) NULL); )           image_info.server_name=argv[i];            break;	         }    } /   display=XOpenDisplay(image_info.server_name); "   if (display == (Display *) NULL)P     Error("Unable to connect to X server",XDisplayName(image_info.server_name));   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*!     Initialize resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy"); ,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display); &   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value); 8   XrmMergeDatabases(server_database,&resource_database);   /*/     Get user defaults from X resource database.    */   GetImageInfo(&image_info);A   XGetResourceInfo(resource_database,client_name,&resource_info);    resource_value= F     XGetResourceClass(resource_database,client_name,"border","False");!   borders=IsTrue(resource_value);    resource_value= O     XGetResourceClass(resource_database,client_name,"compression","Runlength"); 4   if (Latin1Compare("qencoded",resource_value) == 0)$     compression=QEncodedCompression;   else,     compression=RunlengthEncodedCompression;O   image_info.density=XGetResourceClass(resource_database,client_name,"density",      (char *) NULL);    resource_value= F     XGetResourceClass(resource_database,client_name,"descend","True");!   descend=IsTrue(resource_value);    resource_value= E     XGetResourceClass(resource_database,client_name,"frame","False");    frame=IsTrue(resource_value);    resource_value= H     XGetResourceClass(resource_database,client_name,"interlace","none");*   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace; 0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace; 1   if (Latin1Compare("plane",resource_value) == 0) (     image_info.interlace=PlaneInterlace;1   if (image_info.interlace == UndefinedInterlace) :     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value= D     XGetResourceClass(resource_database,client_name,"quality","85");*   image_info.quality=atoi(resource_value);O   resource_value=XGetResourceClass(resource_database,client_name,"rotate","0"); N   resource_value=XGetResourceClass(resource_database,client_name,"scene","0");   scene=atoi(resource_value);    resource_value= F     XGetResourceClass(resource_database,client_name,"screen","False");    screen=IsTrue(resource_value);   resource_value= G     XGetResourceClass(resource_database,client_name,"verbose","False"); ,   image_info.verbose=IsTrue(resource_value);   /*     Check command syntax.    */   filename=(char *) NULL;    target_window=(char *) NULL;   for (i=1; i < argc; i++)   {      option=argv[i]; M     if (((int) strlen(option) < 2) || ((*option != '-') && (*option != '+')))        filename=argv[i];      else       switch(*(option+1))        {          case 'b': 	         { -           if (strcmp("border",option+1) == 0) 
             { '               borders=(*option == '-');                break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             { 7               resource_info.border_color=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL); 5                   resource_info.border_color=argv[i];                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'c': 	         { 0           if (strncmp("colors",option+1,7) == 0)
             { ,               resource_info.number_colors=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL); <                   resource_info.number_colors=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { 5               resource_info.colorspace=RGBColorspace; !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; ?                   resource_info.colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { >                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      } 8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) ;                     resource_info.colorspace=RGBColorspace; 7                   if (Latin1Compare("xyz",option) == 0) ;                     resource_info.colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0) =                     resource_info.colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) ;                     resource_info.colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0) =                     resource_info.colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0) ;                     resource_info.colorspace=YUVColorspace; F                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);                  }                break;
             } 2           if (strncmp("compress",option+1,3) == 0)
             { (               compression=NoCompression;!               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL); !                   option=argv[i]; D                   if (Latin1Compare("runlengthencoded",option) == 0)<                     compression=RunlengthEncodedCompression;                   else>                     if (Latin1Compare("qencoded",option) == 0)6                       compression=QEncodedCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }                break;
             } .           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing geometry on -crop",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { /           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL); 4                   resource_info.delay=atoi(argv[i]);                 }                break;
             } 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } 1           if (strncmp("descend",option+1,3) == 0) 
             { '               descend=(*option == '-');                break;
             } 1           if (strncmp("display",option+1,3) == 0) 
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); 1                   image_info.server_name=argv[i];                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { !           frame=(*option == '-');            break;	         }          case 'g': 	         { 2           if (strncmp("geometry",option+1,2) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing geometry on -geometry",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'h': 	         {            Usage();           break;	         }          case 'i': 	         { 3           if (strncmp("interlace",option+1,3) == 0) 
             { 1               image_info.interlace=NoneInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm': 	         { 4           if (strncmp("monochrome",option+1,2) == 0)
             { 5               image_info.monochrome=(*option == '-'); (               if (image_info.monochrome)                 { 0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8; :                   resource_info.colorspace=GRAYColorspace;                 }                break;
             } .           Error("Unrecognized option",option);	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,2) == 0)             break;.           Error("Unrecognized option",option);	         }          case 'p': 	         { .           if (strncmp("page",option+1,2) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing page geometry on -page",(char *) NULL);*                   image_info.page=argv[i];                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'q': 	         {            i++;6           if ((i == argc) || !sscanf(argv[i],"%d",&x))?             Error("Missing quality on -quality",(char *) NULL); +           image_info.quality=atoi(argv[i]);            break;	         }          case 'r': 	         { 0           if (strncmp("rotate",option+1,3) == 0)
             { !               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))G                      Error("Missing degrees on -rotate",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 's': 	         { /           if (strncmp("scene",option+1,3) == 0) 
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))?                 Error("Missing scene on -scene",(char *) NULL); "               scene=atoi(argv[i]);               break;
             } 0           if (strncmp("screen",option+1,3) == 0)
             { &               screen=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't': 	         { 3           if (strncmp("treedepth",option+1,2) == 0) 
             { )               resource_info.tree_depth=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL); 9                   resource_info.tree_depth=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'w': 	         {            i++;           if (i == argc)J             Error("Missing id, name, or 'root' on -window",(char *) NULL);            target_window=argv[i];           break;	         }          case 'v': 	         { .           image_info.verbose=(*option == '-');           break;	         }          default:	         { .           Error("Unrecognized option",option);           break;	         }        }    }     if (filename == (char *) NULL)6     Error("Missing an image file name",(char *) NULL);   /*     Read image from X server.    */%   if (target_window != (char *) NULL) 5     (void) strcpy(image_info.filename,target_window);    if (resource_info.delay != 0) &     (void) sleep(resource_info.delay);=   image=ReadXImage(&image_info,frame,borders,screen,descend);    if (image == (Image *) NULL)     exit(1);#   (void) strcpy(image->magick,"X");    /*B     Transmogrify image as defined by the image processing options.   */-   MogrifyImage(&image_info,argc,argv,&image);    /*     Write import X image.    */   image->scene=scene; *   if (compression != UndefinedCompression)#     image->compression=compression; .   (void) strcpy(image_info.filename,filename);$   (void) strcpy(image->magick,"PS");*   (void) strcpy(image->filename,filename);'   (void) WriteImage(&image_info,image);    if (image_info.verbose)      DescribeImage(image);    DestroyImage(image);,   (void) free((char *) image_info.filename);   XCloseDisplay(display); 
   exit(0);   return(False); } 