 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "compress.h"  #include "utility.h" #include "X.h" #include "XWDFile.h"   /*   Forward declarations.  */ Image %   *ReadImage _Declare((ImageInfo *));    static Image)   *ReadMIFFImage _Declare((ImageInfo *)), (   *ReadPNMImage _Declare((ImageInfo *));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadAVSImage(image_info)	 ImageInfo    *image_info; {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;      register int     i;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *avs_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read AVS image.    */H   status=ReadData((char *) &avs_header,1,sizeof(AVSHeader),image->file);   if (status == False)     { 4       Warning("Not a AVS image file",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    do   {      /*!       Initialize image structure.      */     image->matte=True;$     image->columns=avs_header.width;"     image->rows=avs_header.height;.     image->packets=image->columns*image->rows;P     avs_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char));%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((avs_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert AVS raster image to runlength-encoded packets.     */L     (void) ReadData((char *) avs_pixels,4,(int) image->packets,image->file);     p=avs_pixels;      q=image->pixels;&     for (i=0; i < image->packets; i++)     { &       q->index=(unsigned char) (*p++);       q->red=(*p++);       q->green=(*p++);       q->blue=(*p++);        q->length=0;
       q++;     } %     (void) free((char *) avs_pixels); J     status=ReadData((char *) &avs_header,1,sizeof(AVSHeader),image->file);     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadBMPImage(image_info)	 ImageInfo    *image_info; {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))       { 6         Warning("Not a BMP image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } 7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; 0         image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL))            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            }          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;@         (void) ReadData((char *) bmp_colormap,(int) packet_size,+           (int) image->colors,image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { )           image->colormap[i].blue=(*p++); *           image->colormap[i].green=(*p++);(           image->colormap[i].red=(*p++);$           if (bmp_header.size != 12)             p++;	         } +         (void) free((char *) bmp_colormap);        }      /*       Read image data.     */#     if (bmp_header.image_size == 0)        bmp_header.image_size=L         ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;     bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL)        { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        } D     status=ReadData((char *) bmp_data,1,(int) bmp_header.image_size,       image->file);      if (status == False)       { B         Warning("Unable to read image data",image_info->filename);         DestroyImages(image);          return((Image *) NULL);        }      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=N           ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            } 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1; '         (void) free((char *) bmp_data);        }      /*!       Initialize image structure.      */$     image->columns=bmp_header.width;"     image->rows=bmp_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 1           for (x=0; x < (image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } 	         }          SyncImage(image);           CompressColormap(image);         break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 	         }          SyncImage(image);           CompressColormap(image);         break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           { B             q->index=(unsigned short) (image->matte ? (*p++) : 0);             q->blue=(*p++);              q->green=(*p++);             q->red=(*p++);             q->length=0;             q++;           } 	         }          break;       }        default:       { 6         Warning("Not a BMP image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        }      } %     (void) free((char *) bmp_pixels);      /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadCMYKImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char 
     black,     *cmyk_pixels, 	     cyan,      magenta,     yellow;      unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;O   cmyk_pixels=(unsigned char *) malloc(4*image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((cmyk_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))     { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*6     Convert raster image to runlength-encoded packets.   */K   (void) ReadData((char *) cmyk_pixels,4,(int) image->packets,image->file);    p=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->green=(*p++);         q->blue=(*p++);          q->index=(*p++);         q->length=0;         q++;       }        break;     }      case LineInterlace:      {        /*K         Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK...        */%       for (y=0; y < image->rows; y++)        { )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->red=(*p++);           q->length=0;           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->green=(*p++);           q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->blue=(*p++);            q++;	         } )         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {            q->index=(*p++);           q++;	         }        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->length=0;         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->green=(*p++);         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->blue=(*p++);          q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->index=(*p++);         q++;       }        break;     }    }    /*     Transform image to CMYK.   */   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      cyan=q->red;     magenta=q->green;      yellow=q->blue;      black=q->index; -     if ((unsigned int) (cyan+black) > MaxRGB)        q->red=0;      else!       q->red=MaxRGB-(cyan+black); 0     if ((unsigned int) (magenta+black) > MaxRGB)       q->green=0;      else&       q->green=MaxRGB-(magenta+black);/     if ((unsigned int) (yellow+black) > MaxRGB)        q->blue=0;     else$       q->blue=MaxRGB-(yellow+black);     q->index=0;      q->length=0;     q++;   } $   (void) free((char *) cmyk_pixels);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadFAXImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=1728;   image->rows=2156; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)     { 9       Warning("Unable to read image data",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    SyncImage(image);    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */' static Image *ReadFITSImage(image_info) 	 ImageInfo    *image_info; {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     keyword[MaxTextLength],      value[MaxTextLength];      double
     pixel,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      packet_size;     long
     count,     quantum;     register int     c,     i,     j;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    while (count < 2880)   {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       } (     while (isspace(c) && (count < 2880))     {        c=fgetc(image->file);        count++;     }    }     for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 3) || 2       (fits_header.columns*fits_header.rows) == 0)     { F       Warning("Unable to read FITS image","image type not supported");       DestroyImage(image);       return((Image *) NULL);      }    /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } #   for (i=0; i < image->colors; i++)    { -     image->colormap[i].red=(unsigned char) i; /     image->colormap[i].green=(unsigned char) i; .     image->colormap[i].blue=(unsigned char) i;   }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*5     Convert FITS pixels to runlength-encoded packets.    */N   status=ReadData((char *) fits_pixels,(int) packet_size,(int) image->packets,     image->file);    if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       quantum=(*p++); )       for (j=0; j < (packet_size-1); j++) (         quantum=(quantum << 8) | (*p++);       pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) *           quantum=(quantum << 8) | (*p++);         pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); >         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   p=fits_pixels;   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      quantum=(*p++); '     for (j=0; j < (packet_size-1); j++) &       quantum=(quantum << 8) | (*p++);     pixel=(double) quantum; *     if (fits_header.bits_per_pixel == -32)-       pixel=(double) (*((float *) &quantum)); B     scaled_pixel=MaxRGB*(pixel*fits_header.scale+fits_header.zero-H       fits_header.min_data)/(fits_header.max_data-fits_header.min_data);+     q->index=(unsigned short) scaled_pixel;      q->length=0;     q++;   } $   (void) free((char *) fits_pixels);   SyncImage(image);    CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadGIFImage(image_info)	 ImageInfo    *image_info; { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     Image      *image;      int 	     pass,      status,      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      c,     *global_colormap,      header[MaxTextLength],     magick[12];      unsigned int     global_colors,     image_count,     interlace,     local_colormap;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); 4   status|=ReadData((char *) header,1,7,image->file);H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0)))      { 6       Warning("Not a GIF image file",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    global_colors=0;)   global_colormap=(unsigned char *) NULL;    if (BitSet(header[4],0x80))      {        /*         Read global colormap.        */0       global_colors=1 << ((header[4] & 0x07)+1);'       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)	         { N           Warning("Unable to read image colormap","Memory allocation failed");           DestroyImage(image);!           return((Image *) NULL); 	         } E       (void) ReadData((char *) global_colormap,3,(int) global_colors,          image->file);      }    transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)           { D             Warning("Unable to read extention block",(char *) NULL);!             DestroyImages(image); #             return((Image *) NULL);            }          switch (c)	         {            case 0xf9:           {              /*+               Transparency extension block.              */D             while (ReadDataBlock((char *) header,image->file) != 0);(             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*&               Comment extension block.             */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;3               if (image->comments != (char *) NULL) J                 image->comments=(char *) realloc((char *) image->comments,C                   (strlen(image->comments)+length+1)*sizeof(char));                else                 { K                   image->comments=(char *) malloc((length+1)*sizeof(char)); 7                   if (image->comments != (char *) NULL) *                     *image->comments='\0';                 } 3               if (image->comments == (char *) NULL)                  { C                   Warning("Memory allocation error",(char *) NULL); '                   DestroyImages(image); )                   return((Image *) NULL);                  } "               header[length]='\0';=               (void) strcat(image->comments,(char *) header); 
             }              break;           }            default:           { D             while (ReadDataBlock((char *) header,image->file) != 0);             break;           } 	         }        }      if (c != ',')        continue;      /*       Read image attributes.     */     if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;5     status=ReadData((char *) header,1,9,image->file);      if (status == False)       { F         Warning("Unable to read left/top/width/height",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } %     interlace=BitSet(header[8],0x40); *     local_colormap=BitSet(header[8],0x80);     /*       Allocate image.      */6     image->columns=LSBFirstOrder(header[4],header[5]);3     image->rows=LSBFirstOrder(header[6],header[7]); .     image->packets=image->columns*image->rows;2     if (image->pixels != (RunlengthPacket *) NULL)*       (void) free((char *) image->pixels);%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      /*       Inititialize colormap.     */     image->class=PseudoClass; P     image->colors=!local_colormap ? global_colors : 1 << ((header[8] & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)       { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      if (!local_colormap)       { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { (           image->colormap[i].red=(*p++);*           image->colormap[i].green=(*p++);)           image->colormap[i].blue=(*p++); 	         }        }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL)            { P             Warning("Unable to read local colormap","Memory allocation failed");!             DestroyImages(image); #             return((Image *) NULL);            } M         (void) ReadData((char *) colormap,3,(int) image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { (           image->colormap[i].red=(*p++);*           image->colormap[i].green=(*p++);)           image->colormap[i].blue=(*p++); 	         } '         (void) free((char *) colormap);        }      /*       Decode image.      */!     status=LZWDecodeImage(image);      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }      if (interlace)       { 
         Image            *interlaced_image;            register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL)            { G             Warning("Unable to read image","Memory allocation failed"); !             DestroyImages(image); #             return((Image *) NULL);            } #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }       if (transparency_index >= 0)       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }    } 0   if (global_colormap != (unsigned char *) NULL)*     (void) free((char *) global_colormap);0   if (image->pixels == (RunlengthPacket *) NULL)     { 3       Warning("Corrupt GIF image",image->filename);        DestroyImages(image);        return((Image *) NULL);      } +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadGRAYImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *gray_pixels;      unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Create linear colormap.    */   image->class=PseudoClass;    image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } #   for (i=0; i < image->colors; i++)    { -     image->colormap[i].red=(unsigned char) i; /     image->colormap[i].green=(unsigned char) i; .     image->colormap[i].blue=(unsigned char) i;   }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;M   gray_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((gray_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*6     Convert raster image to runlength-encoded packets.   */K   (void) ReadData((char *) gray_pixels,1,(int) image->packets,image->file);    p=gray_pixels;   q=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=(*p++);      q->red=index;      q->green=index;      q->blue=index;$     q->index=(unsigned short) index;     q->length=0;     q++;   } $   (void) free((char *) gray_pixels);   CompressColormap(image);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */, static Image *ReadHISTOGRAMImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   ?   Warning("Cannot read HISTOGRAM images",image_info->filename); "   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d I R I S I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadIRISImage reads a SGI RGB image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadIRISImage routine is: % & %      image=ReadIRISImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadIRISImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  & static void IRISDecode(packets,pixels)
 unsigned char    *packets, 
   *pixels; {    unsigned char 
     count,
     pixel;     for ( ; ;)   {      pixel=(*packets++);      count=pixel & 0x7f;      if (count == 0)        break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       {          *pixels=(*packets++);          pixels+=4;       }      else       {          pixel=(*packets++); $         for ( ; count != 0; count--)	         {            *pixels=pixel;           pixels+=4;	         }        }    }  }   ' static Image *ReadIRISImage(image_info) 	 ImageInfo    *image_info; {    typedef struct _IRISHeader   {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } IRISHeader;      Image      *image;      IRISHeader     iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *iris_pixels;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read IRIS raster header.   */3   iris_header.magic=MSBFirstReadShort(image->file);    do   {      /*       Verify IRIS identifier.      */$     if (iris_header.magic != 0x01DA)       { 9         Warning("Not a IRIS RGB image,",image->filename);          DestroyImages(image);          return((Image *) NULL);        } +     iris_header.storage=fgetc(image->file); 3     iris_header.bytes_per_pixel=fgetc(image->file); )     if (iris_header.bytes_per_pixel != 1)        { M         Warning("Image must have 1 byte per pixel channel,",image->filename);          DestroyImages(image);          return((Image *) NULL);        } 9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file); 4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file); <     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);M     (void) ReadData((char *) iris_header.filler,1,sizeof(iris_header.filler),        image->file);      /*       Allocate IRIS pixels.      */!     iris_pixels=(unsigned char *) K       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)       { ;         Warning("Memory allocation error",image->filename);          DestroyImages(image);          return((Image *) NULL);        } $     if (iris_header.storage != 0x01)       {          unsigned char            *scanline;  
         /*%           Read standard image format. 
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL)            { ?             Warning("Memory allocation error",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            } 3         for (z=0; z < (int) iris_header.depth; z++) 	         {            p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           { J             (void) ReadData((char *) scanline,1,(int) iris_header.columns,               image->file); 9             for (x=0; x < (int) iris_header.columns; x++) 
             {                *p=scanline[x];                p+=4; 
             }            } 	         } '         (void) free((char *) scanline);        }      else       {          unsigned char            *packets;            unsigned int           data_order;            unsigned long            offset,            *offsets,            *runlength;   
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); !         packets=(unsigned char *) H           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL))           { ?             Warning("Memory allocation error",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            } F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file); 
         /*           Check data order. 
         */         offset=0;          data_order=0; E         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++) H           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           { 7             if (offsets[y+z*iris_header.rows] < offset)                data_order=1; 1             offset=offsets[y+z*iris_header.rows];            } A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);          if (data_order == 1)           { 7             for (z=0; z < (int) iris_header.depth; z++) 
             {                p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1, E                   (int) runlength[y+z*iris_header.rows],image->file); 8                 offset+=runlength[y+z*iris_header.rows];(                 IRISDecode(packets,p+z);+                 p+=(iris_header.columns*4);                } 
             }            }          else           {              p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             { 9               for (z=0; z < (int) iris_header.depth; z++)                { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; =                     (void) fseek(image->file,(int) offset,0);                    } 3                 (void) ReadData((char *) packets,1, E                   (int) runlength[y+z*iris_header.rows],image->file); 8                 offset+=runlength[y+z*iris_header.rows];(                 IRISDecode(packets,p+z);               } )               p+=(iris_header.columns*4); 
             }            }          (void) free(runlength);          (void) free(packets);          (void) free(offsets);        }      /*!       Initialize image structure.      */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns; !     image->rows=iris_header.rows; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*=       Convert IRIS raster image to runlength-encoded packets.      */     q=image->pixels;     if (iris_header.depth >= 3)        { 
         /*F           Convert IRIS image to DirectClass runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           {              q->red=(*p);             q->green=(*(p+1));             q->blue=(*(p+2));              q->index=(*(p+3));             q->length=0;             p+=4;              q++;           } 	         }        }      else       {          unsigned short           index;  
         /*           Create grayscale map. 
         */!         image->class=PseudoClass;          image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           { G             Warning("Unable to read image","Memory allocation failed");               DestroyImage(image);#             return((Image *) NULL);            } )         for (i=0; i < image->colors; i++) 	         { 3           image->colormap[i].red=(unsigned char) i; 5           image->colormap[i].green=(unsigned char) i; 4           image->colormap[i].blue=(unsigned char) i;	         } 
         /*F           Convert IRIS image to PseudoClass runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); ,           for (x=0; x < image->columns; x++)           { (             index=(unsigned short) (*p);.             q->red=image->colormap[index].red;2             q->green=image->colormap[index].green;0             q->blue=image->colormap[index].blue;             q->index=index;              q->length=0;             p+=4;              q++;           } 	         }        } &     (void) free((char *) iris_pixels);     /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file); $     if (iris_header.magic == 0x01DA)       { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } (   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    #ifdef HasJPEG #include <setjmp.h>  #include "jpeglib.h" #include "jerror.h"    static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */  + static unsigned int GetCharacter(jpeg_info)  j_decompress_ptr   jpeg_info; {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   $ static int CommentHandler(jpeg_info) j_decompress_ptr   jpeg_info; { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (strlen(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+strlen(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }     static void ErrorExit(jpeg_info) j_common_ptr   jpeg_info; {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { 	   JSAMPLE      *jpeg_pixels,      **scanlines;     register int     i,     j;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned char      gray_value;      unsigned int
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       jpeg_destroy_decompress(&jpeg_info);       CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {            DestroyImage(image);!           return((Image *) NULL); 	         }        return(image);     } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True);  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); A   packets=jpeg_info.output_components*image->rows*image->columns; :   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));?   scanlines=(JSAMPLE **) malloc(image->rows*sizeof(JSAMPLE *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||L       (jpeg_pixels == (JSAMPLE *) NULL) || (scanlines == (JSAMPLE **) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         { P           Warning("Unable to create image colormap","Memory allocation failed");           DestroyImage(image);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { 1         image->colormap[i].red=(unsigned char) i; 3         image->colormap[i].green=(unsigned char) i; 2         image->colormap[i].blue=(unsigned char) i;       }      }    /*     Initialize image.    */   q=image->pixels;$   for (i=0; i < image->packets; i++)   { 
     q->red=0;      q->green=0;      q->blue=0;     q->index=0;      q->length=0;     q++;   }    /*5     Convert JPEG pixels to runlength-encoded packets.    */!   for (i=0; i < image->rows; i++) L     scanlines[i]=jpeg_pixels+(i*image->columns*jpeg_info.output_components);   q=image->pixels;&   for (i=0; i < image->rows; i+=count)   { B     count=jpeg_read_scanlines(&jpeg_info,scanlines+i,image->rows);     p=scanlines[i]; %     if (jpeg_info.data_precision > 8)        { 7         if (jpeg_info.out_color_space == JCS_GRAYSCALE) 4           for (j=0; j < (count*image->columns); j++)           { +             gray_value=GETJSAMPLE(*p) >> 4; .             q->red=(unsigned char) gray_value;0             q->green=(unsigned char) gray_value;/             q->blue=(unsigned char) gray_value; 1             q->index=(unsigned short) gray_value;              q->length=0;             p++;             q++;           }          else4           for (j=0; j < (count*image->columns); j++)           { ;             q->red=(unsigned char) (GETJSAMPLE(*p++) >> 4); =             q->green=(unsigned char) (GETJSAMPLE(*p++) >> 4); <             q->blue=(unsigned char) (GETJSAMPLE(*p++) >> 4);             q->index=0;              q->length=0;             q++;           }        }      else5       if (jpeg_info.out_color_space == JCS_GRAYSCALE) 2         for (j=0; j < (count*image->columns); j++)	         { $           gray_value=GETJSAMPLE(*p);,           q->red=(unsigned char) gray_value;.           q->green=(unsigned char) gray_value;-           q->blue=(unsigned char) gray_value; /           q->index=(unsigned short) gray_value;            q->length=0;           p++;           q++;	         } 
       else2         for (j=0; j < (count*image->columns); j++)	         { 2           q->red=(unsigned char) GETJSAMPLE(*p++);4           q->green=(unsigned char) GETJSAMPLE(*p++);3           q->blue=(unsigned char) GETJSAMPLE(*p++);            q->index=0;            q->length=0;           q++;	         }    }    /*     Free memory.   */"   (void) free((char *) scanlines);$   (void) free((char *) jpeg_pixels);,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else ' static Image *ReadJPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMAPImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;   packet_size=1;   if (image->colors > 256)     packet_size++;K   colormap=(unsigned char *) malloc(3*image->colors*sizeof(unsigned char)); L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *)=     malloc(image->packets*packet_size*sizeof(unsigned char)); -   if ((colormap == (unsigned char *) NULL) || 2       (image->colormap == (ColorPacket *) NULL) ||7       (image->packed_pixels == (unsigned char *) NULL))      { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read image colormap.   */G   (void) ReadData((char *) colormap,3,(int) image->colors,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { "     image->colormap[i].red=(*p++);$     image->colormap[i].green=(*p++);#     image->colormap[i].blue=(*p++);    } !   (void) free((char *) colormap);    /*6     Convert raster image to runlength-encoded packets.   */B   (void) ReadData((char *) image->packed_pixels,(int) packet_size,&     (int) image->packets,image->file);%   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */( static Image *ReadMATTEImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int      x,     y;     register int     i;     register RunlengthPacket     *q;      register unsigned char
     index,     *p;      unsigned char      *matte_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->matte=True;   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;N   matte_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 1   if ((matte_pixels == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*6     Convert raster image to runlength-encoded packets.   */L   (void) ReadData((char *) matte_pixels,1,(int) image->packets,image->file);   p=matte_pixels;    q=image->pixels;$   for (i=0; i < image->packets; i++)   {      index=(*p++); 
     q->red=0;      q->green=0;      q->blue=0;$     q->index=(unsigned short) index;     q->length=0;     q++;   } %   (void) free((char *) matte_pixels);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMIFFImage(image_info) 	 ImageInfo    *image_info; {    char     keyword[MaxTextLength],      value[MaxTextLength];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=strlen(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextLength; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+strlen(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) 
             { I               Warning("Unable to read image","Memory allocation failed"); #               DestroyImages(image); %               return((Image *) NULL); 
             }            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;-             while (!isspace(c) && (c != EOF)) 
             { 0               if ((p-value) < (MaxTextLength-1))                 *p++=(char) c;#               c=fgetc(image->file); 
             }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) 0               if (strcmp(value,"QEncoded") == 0)7                 image->compression=QEncodedCompression;                else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);*             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(strlen(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)                   { O                     Warning("Unable to read image","Memory allocation failed"); )                     DestroyImages(image); +                     return((Image *) NULL);                    } 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((strlen(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)                   { O                     Warning("Unable to read image","Memory allocation failed"); )                     DestroyImages(image); +                     return((Image *) NULL);                    } 6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0))        { B         Warning("Incorrect image header in file",image->filename);         DestroyImages(image);          return((Image *) NULL);        } 4     if ((image->columns*image->rows) > MaxImageSize)       { ?         Warning("Unable to read image","image size too large");          DestroyImages(image);          return((Image *) NULL);        } (     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextLength*sizeof(char)); .         if (image->directory == (char *) NULL)           { G             Warning("Unable to read image","Memory allocation failed"); !             DestroyImages(image); #             return((Image *) NULL);            }          p=image->directory; 
         do	         { H           if ((((int) strlen(image->directory)+1) % MaxTextLength) == 0)
             {                /*=                 Allocate more memory for the image directory.                */               *p='\0';J               image->directory=(char *) realloc((char *) image->directory,I                 (strlen(image->directory)+MaxTextLength+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)                 { M                   Warning("Unable to read image","Memory allocation failed"); '                   DestroyImages(image); )                   return((Image *) NULL);                  } :               p=image->directory+strlen(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;          } while (c != '\0');       } $     if (image->class == PseudoClass)       {          unsigned int           colors;   
         /*B           PseudoClass image cannot have matte data or be QEncoded.
         */         if (image->matte)            { O             Warning("Unable to read image","matte images must be DirectClass"); !             DestroyImages(image); #             return((Image *) NULL);            } 6         if (image->compression == QEncodedCompression)           { +             Warning("Unable to read image", 5               "QEncoded images must be DirectClass"); !             DestroyImages(image); #             return((Image *) NULL);            } 
         /*            Create image colormap.
         */         colors=image->colors;          if (colors == 0)           colors=256; K         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket)); 4         if (image->colormap == (ColorPacket *) NULL)           { G             Warning("Unable to read image","Memory allocation failed"); !             DestroyImages(image); #             return((Image *) NULL);            }          if (image->colors == 0) $           for (i=0; i < colors; i++)           { 5             image->colormap[i].red=(unsigned char) i; 7             image->colormap[i].green=(unsigned char) i; 6             image->colormap[i].blue=(unsigned char) i;             image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */&             colormap=(unsigned char *)<               malloc(3*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL)                { K                 Warning("Unable to read image","Memory allocation failed"); %                 DestroyImages(image); '                 return((Image *) NULL);                } H             (void) ReadData((char *) colormap,1,(int) (3*image->colors),               image->file);              p=colormap; -             for (i=0; i < image->colors; i++) 
             { ,               image->colormap[i].red=(*p++);.               image->colormap[i].green=(*p++);-               image->colormap[i].blue=(*p++); 
             } +             (void) free((char *) colormap);            }        }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {          image->packet_size=1;           if (image->colors > 256)           image->packet_size++;        }      else       {          image->packet_size=3;          if (image->matte)            image->packet_size++;        } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++; #     packet_size=image->packet_size; 2     if (image->compression == QEncodedCompression)       packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char)); 7     if (image->packed_pixels == (unsigned char *) NULL)        { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))6       (void) ReadData((char *) image->packed_pixels,1,1         (int) (packets*packet_size),image->file);      else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels; 
         do	         { F           (void) ReadData((char *) p,1,(int) packet_size,image->file);           image->packets++;            p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } 3     if (image->compression ==  QEncodedCompression)        {          unsigned char            *compressed_pixels;   
         /*2           Uncompress image pixels with Q encoding.
         */2         image->packets=image->columns*image->rows;/         compressed_pixels=image->packed_pixels; D         image->packed_pixels=(unsigned char *) malloc((unsigned int)C           image->packets*image->packet_size*sizeof(unsigned char)); ;         if (image->packed_pixels == (unsigned char *) NULL)            { H             Warning("Unable to write image","Memory allocation failed");              DestroyImage(image);#             return((Image *) NULL);            } D         packets=QDecodeImage(compressed_pixels,image->packed_pixels,?           image->columns*(int) image->packet_size,image->rows); ;         if (packets != (image->packets*image->packet_size))            { 9             Warning("Q encoding failed",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            } 0         (void) free((char *) compressed_pixels);       }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */     do     {        c=fgetc(image->file); (     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #ifdef HasMPEG #undef BitmapPad #include "mpeg.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMPEGImage reads a MPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;      ImageDesc      mpeg_info;     register int     i;     register unsigned char     *p;      register RunlengthPacket     *q;      unsigned char      *mpeg_pixels;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char)); ,   if (mpeg_pixels == (unsigned char *) NULL)     { A       Warning("Unable to read image","Memory allocation failed");        DestroyImages(image);        return((Image *) NULL);      }    /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);   if (status == False)     { 4       Warning("Corrupt MPEG image",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { C         Warning("Unable to read image","Memory allocation failed");          DestroyImages(image);          return((Image *) NULL);        }      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;&     for (i=0; i < image->packets; i++)     { 
       p++;       q->blue=(*p++);        q->green=(*p++);       q->red=(*p++);       q->length=0;
       q++;     }      if (image_info->verbose)       DescribeImage(image); .     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } $   (void) free((char *) mpeg_pixels);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  #else ' static Image *ReadMPEGImage(image_info) 	 ImageInfo    *image_info; { @   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M T V I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadMTVImage routine is:  % % %      image=ReadMTVImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMTVImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadMTVImage(image_info)	 ImageInfo    *image_info; {    Image      *image;      int 
     count;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *mtv_pixels;     unsigned int     columns,	     rows;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*     Read MTV image.    */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);    if (count == 0)      { 2       Warning("Not a MTV image,",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows; .     image->packets=image->columns*image->rows;P     mtv_pixels=(unsigned char *) malloc(3*image->packets*sizeof(unsigned char));%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((mtv_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert MTV raster image to runlength-encoded packets.     */L     (void) ReadData((char *) mtv_pixels,3,(int) image->packets,image->file);     p=mtv_pixels;      q=image->pixels;&     for (i=0; i < image->packets; i++)     {        q->red=(*p++);       q->green=(*p++);       q->blue=(*p++);        q->index=0;        q->length=0;
       q++;     } %     (void) free((char *) mtv_pixels);      /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);      if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d N U L L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadNULLImage reads a NULL image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadNULLImage routine is: % & %      image=ReadNULLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadNULLImage(image_info) 	 ImageInfo    *image_info; {    Image      *image;   :   Warning("Cannot read NULL images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C D I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a F %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. % - %  The format of the ReadPCDImage routine is:  % % %      image=ReadPCDImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  ; static Image *OverviewImage(image_info,image,number_images) 	 ImageInfo    *image_info;   Image 	   *image;    unsigned int   number_images; {  #define ClientName  "montage"      char     *resource_value;  	   Display 
     *display;      Image 
     **images;      register int     i,     j;     XMontageInfo     montage_info;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database,     server_database;     /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        return((Image *) NULL);      }    /*     Allocate images array.   */:   images=(Image **) malloc(number_images*sizeof(Image *));    if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);      }    /*!     Initialize resource database.    */   XSetErrorHandler(XError);    XrmInitialize();*   XGetDefault(display,ClientName,"dummy");,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display); &   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value); 8   XrmMergeDatabases(server_database,&resource_database);@   XGetResourceInfo(resource_database,ClientName,&resource_info);H   resource_info.background_color=XGetResourceInstance(resource_database,3     ClientName,"background",DefaultTileBackground); N   resource_value=XGetResourceClass(resource_database,ClientName,"borderWidth",     DefaultTileBorderwidth);2   resource_info.border_width=atoi(resource_value);&   resource_info.font=image_info->font;H   resource_info.foreground_color=XGetResourceInstance(resource_database,3     ClientName,"foreground",DefaultTileForeground); F   resource_info.image_geometry=XGetResourceInstance(resource_database,4     ClientName,"imageGeometry",DefaultTileGeometry);N   resource_info.matte_color=XGetResourceInstance(resource_database,ClientName,#     "mattecolor",DefaultTileMatte); !   XGetMontageInfo(&montage_info); *   montage_info.number_tiles=number_images;   /*/     Read each image and convert them to a tile.    */   j=0;#   for (i=0; i < number_images; i++)    {      LabelImage(image,"%f"); F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)       DescribeImage(image);      images[j]=image;     image=image->next;     j++;   }    /*"     Create the PCD Overview image.   */%   if (montage_info.number_tiles != 0) =     image=XMontageImage(display,&resource_info,&montage_info, #       image_info->filename,images);    XCloseDisplay(display);    (void) free((char *) images);    if (image == (Image *) NULL)     { F       Warning("PCD Overview translation failed",image_info->filename);       return((Image *) NULL);      }    return(image); }   & static Image *ReadPCDImage(image_info)	 ImageInfo    *image_info; {    Image      *image;   
   long int     offset;      register int     i;     register RunlengthPacket     *p;      register unsigned char     *c1,     *c2,     *y;      unsigned char 
     *chroma1, 
     *chroma2,      *header,
     *luma;     unsigned int     height, 
     overview,      rotate,      status, 
     subimage, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char)); '   if (header == (unsigned char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } 9   status=ReadData((char *) header,1,3*0x800,image->file); 5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;    if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview))      { 4       Warning("Not a PCD image file",(char *) NULL);       DestroyImages(image);        return((Image *) NULL);      }    rotate=header[0x0e02] & 0x03;    (void) free((char *) header); 
   subimage=3;     if (image_info->subimage != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     { 	       int 
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512; C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 1       for (subimage=1; subimage <= 6; subimage++)        { .         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;        }      }    if (overview)      subimage=1;    /*     Initialize image structure.    */   width=192;
   height=128; %   for (i=1; i < Min(subimage,3); i++)    {      width<<=1;     height<<=1;    }    image->columns=width;    image->rows=height;    for ( ; i < subimage; i++)   {      image->columns<<=1;      image->rows<<=1;   }    /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;I   chroma1=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); I   chroma2=(unsigned char *) malloc(image->packets*sizeof(unsigned char)); F   luma=(unsigned char *) malloc(image->packets*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Advance to image data.   */   offset=93;   if (overview) 
     offset=2;    else   if (subimage == 2)     offset=20;   else     if (subimage == 1)       offset=1; $   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)      {        Image          *overview_image;         register int
         j;         unsigned int         number_images;         /*,         Read thumbnails from overview image.       */3       number_images=(header[10] << 8) | header[11]; (       for (j=1; j <= number_images; j++)       { 8         (void) sprintf(image->filename,"img%04d.pcd",j);         image->scene=j;          image->columns=width;          image->rows=height; 2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) 9           malloc(image->packets*sizeof(RunlengthPacket)); 6         if (image->pixels == (RunlengthPacket *) NULL)           { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            }          y=luma;          c1=chroma1;          c2=chroma2; #         for (i=0; i < height; i+=2) 	         { :           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns; @           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns; 	         } N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;          c1=chroma1;          c2=chroma2; *         for (i=0; i < image->packets; i++)	         {            p->red=(*y++);           p->green=(*c1++);            p->blue=(*c2++);           p->index=0;            p->length=0;           p++;	         } /         TransformRGBImage(image,YCCColorspace);          if (j < number_images)           {              /*'               Allocate image structure.              */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               { %                 DestroyImages(image); '                 return((Image *) NULL);                } *             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           }        }        (void) free(chroma2);        (void) free(chroma1);        (void) free(luma);/       while (image->previous != (Image *) NULL)          image=image->previous;       CloseImage(image);C       overview_image=OverviewImage(image_info,image,number_images);        return(overview_image);      }    /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);        DestroyImages(image);        return((Image *) NULL);      }    /*     Read interleaved image.    */	   y=luma; 
   c1=chroma1; 
   c2=chroma2;    for (i=0; i < height; i+=2)    { 4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns; :     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;    }    if (subimage >= 4)     {        /*5         Recover luminance deltas for 1536x1024 image.        */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1); /       Upsample(384,256,image->columns,chroma2);        image->rows=1024; #       for (i=0; i < (4*0x800); i++) "         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {            /*9             Recover luminance deltas for 3072x2048 image.            */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1); 3           Upsample(768,512,image->columns,chroma2);            image->rows=2048; -           offset=ftell(image->file)/0x800+12; 3           (void) fseek(image->file,offset*0x800,0); <           (void) PCDDecodeImage(image,luma,chroma1,chroma2);	         }      } H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma; 
   c1=chroma1; 
   c2=chroma2; $   for (i=0; i < image->packets; i++)   {      p->red=(*y++);     p->green=(*c1++);      p->blue=(*c2++);     p->index=0;      p->length=0;     p++;   }    (void) free(chroma2);    (void) free(chroma1);    (void) free(luma);)   TransformRGBImage(image,YCCColorspace); %   if ((rotate == 1) || (rotate == 3))      {        double         degrees;         Image          *rotated_image;          /*         Rotate image.        */)       degrees=rotate == 1 ? -90.0 : 90.0;        image->orphan=True; J       rotated_image=RotateImage(image,degrees,(ColorPacket *) NULL,False);       image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {            DestroyImage(image);           image=rotated_image;	         }      }    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d P C X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % - %  The format of the ReadPCXImage routine is:  % % %      image=ReadPCXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadPCXImage(image_info)	 ImageInfo    *image_info; {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      Image      *image;      int 
     count,     packets;     register int     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      packet,      *pcx_colormap,     *pcx_pixels;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*$     Determine if this is a PCX file.   */C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);    do   {      /*       Verify PCX identifier.     */=     if ((status == False) || (pcx_header.identifier != 0x0a))        { 6         Warning("Not a PCX image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file); I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file); 3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file); D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.      */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;      image->class=PseudoClass;      image->colors=16; D     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); 4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL))        { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        } M     (void) ReadData((char *) pcx_colormap,3,(int) image->colors,image->file);      p=pcx_colormap; %     for (i=0; i < image->colors; i++)      { $       image->colormap[i].red=(*p++);&       image->colormap[i].green=(*p++);%       image->colormap[i].blue=(*p++);      } C     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file); A     (void) ReadData((char *) &pcx_header.planes,1,1,image->file); =     pcx_header.bytes_per_line=LSBFirstReadShort(image->file); ;     pcx_header.palette_info=LSBFirstReadShort(image->file);      for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */D     packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;G     pcx_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); -     if (pcx_pixels == (unsigned char *) NULL)        { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*       Uncompress image data.     */     p=pcx_pixels;      while (packets > 0)      {         packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {            *p++=packet;           packets--;           continue; 	         }        count=packet & 0x3f;        packet=fgetc(image->file);       packets-=count;        while (--count >= 0)         *p++=packet;     } E     image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes);      if (image->colors > 16)        { 
         /*G           256 color images have their color map at the end of the file. 
         */D         (void) ReadData((char *) &pcx_header.colormap_signature,1,1,           image->file); D         (void) ReadData((char *) pcx_colormap,3,(int) image->colors,           image->file);          p=pcx_colormap; )         for (i=0; i < image->colors; i++) 	         { (           image->colormap[i].red=(*p++);*           image->colormap[i].green=(*p++);)           image->colormap[i].blue=(*p++); 	         }        }      else       if (image->colors == 2) K         if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))            {              /*"               Monochrome colormap.             */*             image->colormap[0].red=MaxRGB;,             image->colormap[0].green=MaxRGB;+             image->colormap[0].blue=MaxRGB; %             image->colormap[1].red=0; '             image->colormap[1].green=0; &             image->colormap[1].blue=0;           } '     (void) free((char *) pcx_colormap);      /*!       Initialize image structure.      */.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       { 9         Warning("Memory allocation error",(char *) NULL);          DestroyImages(image);          return((Image *) NULL);        }      /*<       Convert PCX raster image to runlength-encoded packets.     */     q=image->pixels;     if (pcx_header.planes > 1)       {          register int           bits,            mask;   
         /*C           Convert multi-plane format into runlength-encoded pixels. 
         */*         for (i=0; i < image->packets; i++)	         {            q->index=0;            q->length=0;           q++;	         } '         for (y=0; y < image->rows; y++) 	         { G           p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes); 5           for (i=0; i < (int) pcx_header.planes; i++)            { -             q=image->pixels+y*image->columns; 9             for (x=0; x < pcx_header.bytes_per_line; x++) 
             {                bits=(*p++);2               for (mask=0x80; mask != 0; mask>>=1)               {                   if (bits & mask)#                   q->index|=1 << i;                  q++;               } 
             }            } 	         }        }      else%       for (y=0; y < image->rows; y++)        { 1         p=pcx_pixels+y*pcx_header.bytes_per_line; *         switch (pcx_header.bits_per_pixel)	         {            case 1:            {              register int               bit;  3             for (x=0; x < (image->columns-7); x+=8) 
             { *               for (bit=7; bit >= 0; bit--)               { >                 q->index=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } *             if ((image->columns % 8) != 0)               { C                 for (bit=7; bit >= (8-(image->columns % 8)); bit--)                  { @                   q->index=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   q->length=0;                   q++;                 }                  p++;               }              break;           }            case 2:            { 3             for (x=0; x < (image->columns-3); x+=4) 
             { '               q->index=(*p >> 6) & 0x3;                q->length=0;               q++;'               q->index=(*p >> 4) & 0x3;                q->length=0;               q++;'               q->index=(*p >> 2) & 0x3;%               q->length=0;               q++;"               q->index=(*p) & 0x3;               q->length=0;               q++;               p++;
             } *             if ((image->columns % 4) != 0)               { =                 for (i=3; i >= (4-(image->columns % 4)); i--)                  { 0                   q->index=(*p >> (i*2)) & 0x03;                   q->length=0;                   q++;                 }O                 p++;               }              break;           }            case 4:            { 3             for (x=0; x < (image->columns-1); x+=2) 
             {E'               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;"               q->index=(*p) & 0xf;               q->length=0;               q++;               p++;
             } *             if ((image->columns % 2) != 0)               { )                 q->index=(*p >> 4) & 0xf;a                 q->length=0;                 q++;                 p++;               }              break;           }            case 8:            { .             for (x=0; x < image->columns; x++)
             {                q->index=(*p);               q->length=0;               q++;               p++;
             }              break;           }            default:             break;	         }        } %     (void) free((char *) pcx_pixels);      SyncImage(image);      /*       Proceed to next image.     */E     status=ReadData((char *) &pcx_header.identifier,1,1,image->file); <     if ((status == True) && (pcx_header.identifier == 0x0a))       { 
         /*#           Allocate image structure.a
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);y#             return((Image *) NULL);a           }iB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } @   } while ((status == True) && (pcx_header.identifier == 0x0a));+   while (image->previous != (Image *) NULL)n     image=image->previous;   CloseImage(image);   return(image); }s b /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.O %                                                                             %sO %                                                                             %tO %                                                                             % O %  R e a d P I C T I m a g e                                                  %oO %                                                                             %fO %                                                                             %sO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %eL %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new Imaget4 %  structure and returns a pointer to the new image. %s. %  The format of the ReadPICTImage routine is: % & %      image=ReadPICTImage(image_info) % + %  A description of each parameter follows:% %%J %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read./ %iA %    o image_info: Specifies a pointer to an ImageInfo structure.c %e %t */' static Image *ReadPICTImage(image_info)"	 ImageInfo    *image_info; {s   char     filename[MaxTextLength];     Image*     *image,c     *next_image;     /*     Allocate image structure.a   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);%   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    CloseImage(image);   DestroyImage(image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename); @   (void) sprintf(image_info->filename,"|picttoppm %s",filename);!   image=ReadPNMImage(image_info);    if (image == (Image *) NULL)     { >       Warning("PICT translation failed",image_info->filename);       return((Image *) NULL);%     }%   /*     Assign proper filename.%   */   do   {t,     (void) strcpy(image->filename,filename);     next_image=image->next;s%     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL);r+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }r i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %aO %                                                                             %SO %                                                                             %IO %  R e a d P N M I m a g e                                                    % O %                                                                             %vO %                                                                             %gO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u % K %  Function ReadPNMImage reads a Portable Anymap image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %E- %  The format of the ReadPNMImage routine is:e %i% %      image=ReadPNMImage(image_info)a %i+ %  A description of each parameter follows:  % I %    o image:  Function ReadPNMImage returns a pointer to the image afterzL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.o %  %  */* static unsigned int GetInteger(image,base) Image 	   *image;e   unsigned int   base;s {s   int.     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {v     c=fgetc(image->file);m     if (c == EOF)e       return(0);     if (c == '#')-       {R         register char 
           *p;>           unsigned int           length;(  
         /*           Read comment.|
         */-         if (image->comments != (char *) NULL)            { +             length=strlen(image->comments);N%             p=image->comments+length;            }n         else           { !             length=MaxTextLength;iA             image->comments=(char *) malloc(length*sizeof(char));a             p=image->comments;           }>6         for ( ; image->comments != (char *) NULL; p++)	         { .           if ((p-image->comments+2) >= length)
             {p               *p='\0';               length<<=1; &               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)i                 break;8               p=image->comments+strlen(image->comments);
             }            c=fgetc(image->file);=(           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c; 	         }a-         if (image->comments == (char *) NULL))           { =             Warning("Memory allocation error",(char *) NULL);e             return(0);           }g         *p++='\n';         *p='\0';       }n   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {i     value*=10;     value+=c-'0';      c=fgetc(image->file);      if (c == EOF);       return(0);   }    while (isdigit(c));%   return(value); }%  & static Image *ReadPNMImage(image_info)	 ImageInfo    *image_info; {    char     format;      Image      *image;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *pixels,     *scale;      unsigned int     max_value,     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);%       DestroyImage(image);       return((Image *) NULL);%     }%   /*     Read PNM image.I   */4   status=ReadData((char *) &format,1,1,image->file);   do   {t     /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P'))        {.6         Warning("Not a PNM image file",(char *) NULL);         DestroyImage(image);         return((Image *) NULL);o       }r     /*!       Initialize image structure.o     */     format=fgetc(image->file);     if (format == '7')"       (void) GetInteger(image,10);(     image->columns=GetInteger(image,10);%     image->rows=GetInteger(image,10);i.     image->packets=image->columns*image->rows;     if (image->packets == 0)       {eD         Warning("Unable to read image","image dimensions are zero");         return((Image *) NULL);d       } %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));t2     if (image->pixels == (RunlengthPacket *) NULL)       {d9         Warning("Memory allocation error",(char *) NULL);n         DestroyImages(image);m         return((Image *) NULL);        }s+     if ((format == '1') || (format == '4'))a        max_value=1;  /* bitmap */     else%       max_value=GetInteger(image,10); !     scale=(unsigned char *) NULL;      if (max_value != MaxRGB)       {k
         /*&           Compute pixel scaling table.
         */L         scale=(unsigned char *) malloc((max_value+1)*sizeof(unsigned char));,         if (scale == (unsigned char *) NULL)           {aG             Warning("Unable to read image","Memory allocation failed");(!             DestroyImages(image);)#             return((Image *) NULL);            }m&         for (i=0; i <= max_value; i++)K           scale[i]=(unsigned char) ((i*MaxRGB+(max_value >> 1))/max_value);        }e+     if ((format != '3') && (format != '6'))L       { 
         /*           Create colormap.
         */!         image->class=PseudoClass;,.         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *)a4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           {;=             Warning("Memory allocation error",(char *) NULL);)!             DestroyImages(image);i#             return((Image *) NULL);            }r         if (format != '7')+           for (i=0; i < image->colors; i++)B           {t@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);i           }          else           {r             intl               blue,t               green,               red;               /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++)c/               for (green=0; green < 8; green++)_.                 for (blue=0; blue < 4; blue++)                 { 8                   image->colormap[i].red=(red*MaxRGB)/7;<                   image->colormap[i].green=(green*MaxRGB)/7;:                   image->colormap[i].blue=(blue*MaxRGB)/3;                   i++;                 }d           }i       }      /*;       Convert PNM pixels to runlength-encoded MIFF packets.e     */     q=image->pixels;     switch (format)      {_       case '1':n       {R
         /*9           Convert PBM image to runlength-encoded packets.i
         */*         for (i=0; i < image->packets; i++)	         {i(           q->index=!GetInteger(image,2);           q->length=0;           q++;	         }o         SyncImage(image);-         break;       }d       case '2':n       {t
         /*9           Convert PGM image to runlength-encoded packets.)
         */          if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           { *             q->index=GetInteger(image,10);             q->length=0;             q++;           }          else,           for (i=0; i < image->packets; i++)           {a1             q->index=scale[GetInteger(image,10)];a             q->length=0;             q++;           }          SyncImage(image);o         break;       }        case '3':m       {n
         /*9           Convert PNM image to runlength-encoded packets. 
         */          if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           {L(             q->red=GetInteger(image,10);*             q->green=GetInteger(image,10);)             q->blue=GetInteger(image,10);              q->index=0;              q->length=0;             q++;           }e         else,           for (i=0; i < image->packets; i++)           { /             q->red=scale[GetInteger(image,10)];t1             q->green=scale[GetInteger(image,10)];m0             q->blue=scale[GetInteger(image,10)];             q->index=0;g             q->length=0;             q++;           }]         break;       }        case '4':]       {+         unsigned chare           bit,           byte;;           unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets.i
         */'         for (y=0; y < image->rows; y++) 	         {d           bit=0;           byte=0;*,           for (x=0; x < image->columns; x++)           {              if (bit == 0)e&               byte=fgetc(image->file);+             q->index=(byte & 0x80) ? 0 : 1;              q->length=0;             q++;             bit++;             if (bit == 8)                bit=0;             byte<<=1;t           }(	         }p         SyncImage(image);a         break;       }l       case '5':t       case '7':        { 
         /*=           Convert PGM raw image to runlength-encoded packets.t
         */         if (max_value > 255)           {              /*"               Two byte PNM images.             */.             for (i=0; i < image->packets; i++)
             { =               q->index=scale[LSBFirstReadShort(image->file)];                q->length=0;               q++;
             }e             SyncImage(image);r             break;           }cN         pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)            {s=             Warning("Memory allocation error",(char *) NULL);(!             DestroyImages(image);N#             return((Image *) NULL);g           } L         status=ReadData((char *) pixels,1,(int) image->packets,image->file);         if (status == False)           {bG             Warning("Insufficient image data in file",image->filename);e!             DestroyImages(image); #             return((Image *) NULL);            }d
         /*=           Convert PNM raw image to runlength-encoded packets. 
         */         p=pixels;c          if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           {              q->index=(*p++);             q->length=0;             q++;           }          else,           for (i=0; i < image->packets; i++)           { !             q->index=scale[*p++];              q->length=0;             q++;           }L         SyncImage(image);(%         (void) free((char *) pixels);)         break;       }        case '6':t       {t
         /*@           Convert PNM raster image to runlength-encoded packets.
         */         if (max_value > 255)           {t             /*"               Two byte PNM images.             */.             for (i=0; i < image->packets; i++)
             { ;               q->red=scale[LSBFirstReadShort(image->file)]; =               q->green=scale[LSBFirstReadShort(image->file)]; <               q->blue=scale[LSBFirstReadShort(image->file)];               q->index=0;+               q->length=0;               q++;
             }              break;           }dP         pixels=(unsigned char *) malloc(image->packets*3*sizeof(unsigned char));-         if (pixels == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            }iN         status=ReadData((char *) pixels,1,(int) image->packets*3,image->file);         if (status == False)           { G             Warning("Insufficient image data in file",image->filename); !             DestroyImages(image); #             return((Image *) NULL);            }c         p=pixels;-          if (max_value == MaxRGB),           for (i=0; i < image->packets; i++)           {              q->red=(*p++);             q->green=(*p++);             q->blue=(*p++);a             q->index=0;              q->length=0;             q++;           }          else,           for (i=0; i < image->packets; i++)           {              q->red=scale[*p++]; !             q->green=scale[*p++];               q->blue=scale[*p++];             q->index=0;f             q->length=0;             q++;           } %         (void) free((char *) pixels);          break;       }        default:       { 6         Warning("Not a PNM image file",(char *) NULL);         DestroyImages(image);i         return((Image *) NULL);        }e     } (     if (scale != (unsigned char *) NULL)"       (void) free((char *) scale);$     if (image->class == PseudoClass)       CompressColormap(image);     /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       { 
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);          if (status == False)           break;       } while (format != '\n');o6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       {t
         /*#           Allocate image structure..
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {p!             DestroyImages(image);+#             return((Image *) NULL);x           }-B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       };0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)(     image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %cO %                                                                             %)O %                                                                             % O %  R e a d P S I m a g e                                                      % O %                                                                             %mO %                                                                             %nO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % O %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns al %  pointer to the new image. %;, %  The format of the ReadPSImage routine is: %%$ %      image=ReadPSImage(image_info) %%+ %  A description of each parameter follows:  % H %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */% static Image *ReadPSImage(image_info) 	 ImageInfo    *image_info; { % #define BoundingBox  "%%BoundingBox:" - #define PageBoundingBox  "%%PageBoundingBox:"      char     command[MaxTextLength], !     crop_geometry[MaxTextLength],      *device,     filename[MaxTextLength],     options[MaxTextLength],%'     postscript_filename[MaxTextLength];      FILE
     *file;     Imagea     *image,t     *next_image;     intt     status;s  
   long int
     filesize;      unsigned int
     showpage;s     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);)   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)u     {o5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);h     }    /*     Open temporary output file.:   */)   TemporaryFilename(postscript_filename); &   file=fopen(postscript_filename,"w");   if (file == (FILE *) NULL)     {f:       Warning("Unable to write file",postscript_filename);       return((Image *) NULL);i     }n   /*5     Determine if Postscript specifies a bounding box.    */   showpage=False;l   *options='\0';   *crop_geometry='\0';E   while (fgets(command,MaxTextLength-1,image->file) != (char *) NULL)    {      if (!(*command == '%')) 5       showpage|=GlobExpression(command,"*showpage*");=B     if ((strncmp(BoundingBox,command,strlen(BoundingBox)) == 0) ||H         (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0))       {          intn           count,           flags,           lower_x,           lower_y,           upper_x,           upper_y,           x,           y;           unsigned int           dx_resolution,           dy_resolution,           x_resolution,            y_resolution;m  B         if (strncmp(BoundingBox,command,strlen(BoundingBox)) == 0)P           count=sscanf(command,"%%%%BoundingBox: %d %d %d %d",&lower_x,&lower_y,             &upper_x,&upper_y);mJ         if (strncmp(PageBoundingBox,command,strlen(PageBoundingBox)) == 0)B           count=sscanf(command,"%%%%PageBoundingBox: %d %d %d %d",1             &lower_x,&lower_y,&upper_x,&upper_y);s         if (count != 4)            continue; 
         /*!           Determine bounding box.n
         */E         (void) XParseGeometry(PSDensityGeometry,&x,&y,&dx_resolution,n           &dy_resolution);#         x_resolution=dx_resolution;l#         y_resolution=dy_resolution;)E         flags=XParseGeometry(image_info->density,&x,&y,&x_resolution,            &y_resolution);m'         if ((flags & HeightValue) == 0)I$           y_resolution=x_resolution;.         if (image_info->page == (char *) NULL)           {              unsigned int               height,                width;               /*-               Set Postscript render geometry.              */H             width=((lower_x+upper_x)*x_resolution+(dx_resolution >> 1))/               dx_resolution;I             height=((lower_x+upper_y)*y_resolution+(dy_resolution >> 1))/M               dy_resolution;:             (void) sprintf(options,"-g%ux%u",width,width);             if (width < height)l>               (void) sprintf(options,"-g%ux%u",height,height);/             (void) strcpy(crop_geometry,"0x0");            }        }      (void) fputs(command,file);-   }l   if (!showpage)$     (void) fputs("showpage\n",file);   if (ferror(file))      { K       Warning("An error has occurred writing to file",postscript_filename);g       (void) fclose(file);       return((Image *) NULL);      }    (void) fclose(file);   CloseImage(image);   filesize=image->filesize;p   DestroyImage(image);   /*@     Determine if page geometry or density options are specified.   */(   if (image_info->page != (char *) NULL)     { #       (void) strcat(options," -g");l.       (void) strcat(options,image_info->page);     }C+   if (image_info->density != (char *) NULL)      {m#       (void) strcat(options," -r");g1       (void) strcat(options,image_info->density);      }    /*0     Use Ghostscript to convert Postscript image.   */   device="ppmraw";   if (image_info->monochrome)      device="pbmraw";/   (void) strcpy(filename,image_info->filename);;*   TemporaryFilename(image_info->filename);O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,;     postscript_filename);-    status=SystemCommand(command);
   if (status);     { D       Warning("Postscript translation failed",image_info->filename);)       (void) unlink(postscript_filename);        return((Image *) NULL);      } !   image=ReadPNMImage(image_info);n%   (void) unlink(postscript_filename);i&   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     {lD       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);e     }    do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;      if (*crop_geometry != '\0')l0       if (Intensity(image->pixels[0]) == MaxRGB)	         {            /*!             Crop to bounding box.a           */=           TransformImage(&image,crop_geometry,(char *) NULL);%,           if (image->next != (Image *) NULL)(             image->next->previous=image;	         }      next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }A I /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %  R e a d R A D I A N C E I m a g e                                          %AO %                                                                             %rO %                                                                             %gO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % I %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it.gL %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %i2 %  The format of the ReadRADIANCEImage routine is: %e* %      image=ReadRADIANCEImage(image_info) %e+ %  A description of each parameter follows:g % N %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %( %E */+ static Image *ReadRADIANCEImage(image_info) 	 ImageInfo-   *image_info; {    char     command[MaxTextLength],m     filename[MaxTextLength];     Imagei     *image,c     *next_image;     ints     status;      /*     Allocate image structure.=   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);i   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)a     {a5       Warning("Unable to open file",image->filename);=       DestroyImage(image);       return((Image *) NULL);C     }k   CloseImage(image);   DestroyImage(image);   /*)     Use ra_ppm to convert RADIANCE image.a   *//   (void) strcpy(filename,image_info->filename);**   TemporaryFilename(image_info->filename);G   (void) sprintf(command,"ra_ppm %s %s",filename,image_info->filename);r    status=SystemCommand(command);
   if (status)      {gB       Warning("RADIANCE translation failed",image_info->filename);       return((Image *) NULL);(     }=!   image=ReadPNMImage(image_info);a&   (void) unlink(image_info->filename);   if (image == (Image *) NULL)     {uB       Warning("RADIANCE translation failed",image_info->filename);       return((Image *) NULL);      }n   /*     Assign proper filename.%   */   do   {%,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d R G B I m a g e                                                    %%O %                                                                             % O %                                                                             %pO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %sM %  Function ReadRGBImage reads an image of raw red, green, and blue bytes andeM %  returns it.  It allocates the memory necessary for the new Image structurer* %  and returns a pointer to the new image. % - %  The format of the ReadRGBImage routine is:  %d% %      image=ReadRGBImage(image_info)m %(+ %  A description of each parameter follows:  %yI %    o image:  Function ReadRGBImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.l %  %  */& static Image *ReadRGBImage(image_info)	 ImageInfo    *image_info; {t   Image      *image;i     int      x,     y;     register int     i;     register RunlengthPacket     *q;n     register unsigned char     *p;o     unsigned char      *rgb_pixels;     unsigned int     height,i
     width;     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)m     {(5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);g     }    /*-     Determine width and height, e.g. 640x512.o   */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);s   /*     Initialize image structure.i   */   image->columns=width;.   image->rows=height;e,   image->packets=image->columns*image->rows;N   rgb_pixels=(unsigned char *) malloc(3*image->packets*sizeof(unsigned char));#   image->pixels=(RunlengthPacket *)e3     malloc(image->packets*sizeof(RunlengthPacket));n/   if ((rgb_pixels == (unsigned char *) NULL) ||e2       (image->pixels == (RunlengthPacket *) NULL))     {c7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);l     }    /*6     Convert raster image to runlength-encoded packets.   */J   (void) ReadData((char *) rgb_pixels,3,(int) image->packets,image->file);   p=rgb_pixels;     switch (image_info->interlace)   {g     case NoneInterlace:(     default:     {=       /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {0         q->red=(*p++);         q->green=(*p++);         q->blue=(*p++);e         q->index=0;          q->length=0;         q++;       }        break;     };     case LineInterlace:-     {        /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...        */%       for (y=0; y < image->rows; y++)        {c)         q=image->pixels+y*image->columns;)*         for (x=0; x < image->columns; x++)	         {1           q->red=(*p++);           q->index=0;(           q->length=0;           q++;	         } )         q=image->pixels+y*image->columns;a*         for (x=0; x < image->columns; x++)	         {f           q->green=(*p++);           q++;	         }.)         q=image->pixels+y*image->columns; *         for (x=0; x < image->columns; x++)	         {i           q->blue=(*p++);n           q++;	         }        }(       break;     }"     case PlaneInterlace:     {u       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...d       */       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->red=(*p++);         q->index=0;          q->length=0;         q++;       }        q=image->pixels;(       for (i=0; i < image->packets; i++)       {s         q->green=(*p++);         q++;       }o       q=image->pixels;(       for (i=0; i < image->packets; i++)       {          q->blue=(*p++);I         q++;       }i       break;     }o   }u#   (void) free((char *) rgb_pixels);R   CloseImage(image);   return(image); }( u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%lO %                                                                             %mO %                                                                             % O %                                                                             %eO %  R e a d R L E I m a g e                                                    % O %                                                                             %rO %                                                                             %uO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %gG %  Function ReadRLEImage reads a run-length encoded Utah Raster Toolkit=L %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. % - %  The format of the ReadRLEImage routine is:a %)% %      image=ReadRLEImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadRLEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.n %aA %    o image_info: Specifies a pointer to an ImageInfo structure.- %w %  */& static Image *ReadRLEImage(image_info)	 ImageInfo>   *image_info; {e #define SkipLinesOp  0x01z #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06= #define EOFOp  0x07      char     magick[12];k     Imagee     *image;h     int      opcode,i     operand,     status,      x,     y;     register int     i,     j;     register RunlengthPacket     *q;l     register unsigned char     *p;      unsigned chare     background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel,D
     flags,     map_length,)     number_colormaps,e     number_planes;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);i   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      {/5       Warning("Unable to open file",image->filename);o       DestroyImage(image);       return((Image *) NULL);m     }|   /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file);d?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0))l     {e4       Warning("Not a RLE image file",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);1     }m   do   {s     /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file);=.     image->packets=image->columns*image->rows;     flags=fgetc(image->file);e     image->matte=flags & 0x04;%     number_planes=fgetc(image->file); &     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file);aP     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))       {=<         Warning("Unsupported RLE image file",(char *) NULL);         DestroyImage(image);         return((Image *) NULL);        }u     if (flags & 0x02)+       {i
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++)c0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }_     else       {s
         /*&           Initialize background color.
         */         p=background_color; )         for (i=0; i < number_planes; i++) 2           *p++=(unsigned char) fgetc(image->file);       }e$     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       { 
         /*           Read image colormaps. 
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL)            {G=             Warning("Memory allocation error",(char *) NULL);               DestroyImage(image);#             return((Image *) NULL);            }          p=colormap; ,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=ColorShift(LSBFirstReadShort(image->file));       }%     if (flags & 0x08)%       {%         unsigned int           length;n  
         /*           Read image comment.s
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char)); -         if (image->comments == (char *) NULL)F           { =             Warning("Memory allocation error",(char *) NULL);r              DestroyImage(image);#             return((Image *) NULL);I           }aO         (void) ReadData((char *) image->comments,1,(int) length-1,image->file);i'         image->comments[length-1]='\0'; !         if ((length & 0x01) == 0)e$           (void) fgetc(image->file);       }      /*       Allocate RLE pixels.     */     if (image->matte)a       number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char));g-     if (rle_pixels == (unsigned char *) NULL)t       { 9         Warning("Memory allocation error",(char *) NULL);h         DestroyImage(image);         return((Image *) NULL);r       } *     if ((flags & 0x01) && !(flags & 0x02))       { 
         /*           Set background color.h
         */         p=rle_pixels;i*         for (i=0; i < image->packets; i++)	         {,           if (!image->matte)-             for (j=0; j < number_planes; j++)='               *p++=background_color[j];=           else
             {m3               for (j=0; j < (number_planes-1); j++)p)                 *p++=background_color[j];(5               *p++=0;  /* initialize matte channel */i
             }n	         }        }I     /*#       Read runlength-encoded image.      */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {c       switch (opcode & 0x3f)       {a         case SkipLinesOp:>	         {f%           operand=fgetc(image->file);*           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);            x=0;           y+=operand;l           break;	         }e         case SetColorOp:	         {g%           operand=fgetc(image->file);;           plane=operand;           if (plane == 255)S"             plane=number_planes-1;           x=0;           break;	         }          case SkipPixelsOp:	         {0%           operand=fgetc(image->file);e           if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);l           x+=operand;c           break;	         }          case ByteDataOp:	         {o%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++)t           {(%             pixel=fgetc(image->file);(>             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;f             p+=number_planes;            }            if (operand & 0x01)/&             (void) fgetc(image->file);           x+=operand;            break;	         }          case RunDataOp:n	         {o%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); #           pixel=fgetc(image->file); $           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)&           { >             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;              p+=number_planes;            }            x+=operand;            break;	         }          default:           break;       }         opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {          unsigned int           mask;(  
         /*1           Apply colormap transformation to image.t
         */         mask=(map_length-1);         p=rle_pixels;s"         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           { 3             *p=(unsigned char) colormap[*p & mask];)             p++;           }          else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)                { F                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }        }u     /*!       Initialize image structure.      */%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       {:9         Warning("Memory allocation error",(char *) NULL);e         DestroyImage(image);         return((Image *) NULL);        }      q=image->pixels;     if (number_planes >= 3)*       {e
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels; *         for (i=0; i < image->packets; i++)	         {            q->red=(*p++);           q->green=(*p++);           q->blue=(*p++);e@           q->index=(unsigned short) (image->matte ? (*p++) : 0);           q->length=0;           q++;	         }o       }e     else       {n
         /*           Create colormap.
         */!         image->class=PseudoClass;-"         if (number_colormaps == 0)           map_length=256;g!         image->colors=map_length;a'         image->colormap=(ColorPacket *)t4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           {mG             Warning("Unable to read image","Memory allocation failed");h              DestroyImage(image);#             return((Image *) NULL);            }i         p=colormap;m"         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)e           {r             /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);g           }(         else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++)d
             {e               /*                 Pseudocolor.               */7               image->colormap[i].red=(unsigned char) i;c9               image->colormap[i].green=(unsigned char) i;b8               image->colormap[i].blue=(unsigned char) i;
             }t           else-             for (i=0; i < image->colors; i++)c
             {o*               image->colormap[i].red=(*p);9               image->colormap[i].green=(*(p+map_length)); :               image->colormap[i].blue=(*(p+map_length*2));               p++;
             }          p=rle_pixels;          if (!image->matte)           {              /*L               Convert raster image to PseudoClass runlength-encoded packets.             */.             for (i=0; i < image->packets; i++)
             { /               q->index=(unsigned short) (*p++);                q->length=0;               q++;
             }              SyncImage(image);            }c         else           {              /*A               Image has a matte channel-- promote to DirectClass.c             */.             for (i=0; i < image->packets; i++)
             { -               q->red=image->colormap[*p].red;m1               q->green=image->colormap[*p].green;(1               q->blue=image->colormap[*p++].blue; /               q->index=(unsigned short) (*p++);a               q->length=0;               q++;
             } "             free(image->colormap);1             image->colormap=(ColorPacket *) NULL;(%             image->class=DirectClass;e             image->colors=0;           }u       }      if (number_colormaps != 0)%       (void) free((char *) colormap);*%     (void) free((char *) rle_pixels);t     /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file);;@     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       {a
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {,!             DestroyImages(image);n#             return((Image *) NULL);m           }rB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }aD   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }p = /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %qO %                                                                             %tO %  R e a d S U N I m a g e                                                    %gO %                                                                             % O %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%d %TM %  Function ReadSUNImage reads a SUN image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  %(- %  The format of the ReadSUNImage routine is:) %o% %      image=ReadSUNImage(image_info)( %l+ %  A description of each parameter follows:C %uI %    o image:  Function ReadSUNImage returns a pointer to the image afternL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.i %eA %    o image_info: Specifies a pointer to an ImageInfo structure.% %% %% */& static Image *ReadSUNImage(image_info)	 ImageInfo    *image_info; {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0  #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2  #define RT_FORMAT_RGB  3     typedef struct _SUNHeader    {      unsigned long        magic,       width,
       height,        depth,
       length,        type,        maptype,       maplength;   } SUNHeader;     Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      SUNHeader      sun_header;      unsigned char%     *sun_data,     *sun_pixels;     unsigned int     status;%     /*     Allocate image structure.d   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);a   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)r     {i5       Warning("Unable to open file",image->filename);A       DestroyImage(image);       return((Image *) NULL);      }o   /*     Read SUN raster header.o   */1   sun_header.magic=MSBFirstReadLong(image->file);e   do   {i     /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95)S       {a5         Warning("Not a SUN raster,",image->filename);c         DestroyImages(image);o         return((Image *) NULL);        } 3     sun_header.width=MSBFirstReadLong(image->file);r4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file); 4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file); 7     sun_header.maplength=MSBFirstReadLong(image->file);)     switch (sun_header.maptype)      {p       case RMT_NONE:       {g"         if (sun_header.depth < 24)           {(             /*'               Create linear color ramp.a             */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *)e8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)               { A                 Warning("Memory allocation error",(char *) NULL);e'                 return((Image *) NULL);e               }e-             for (i=0; i < image->colors; i++) 
             {iB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);6
             }            }          break;       }g       case RMT_EQUAL_RGB:L       {v         unsigned charg           *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */-         image->colors=sun_header.maplength/3;m'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL))*           { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image);u#             return((Image *) NULL);            }tD         (void) ReadData((char *) sun_colormap,1,(int) image->colors,           image->file);a)         for (i=0; i < image->colors; i++);1           image->colormap[i].red=sun_colormap[i];sD         (void) ReadData((char *) sun_colormap,1,(int) image->colors,           image->file); )         for (i=0; i < image->colors; i++)-3           image->colormap[i].green=sun_colormap[i];aD         (void) ReadData((char *) sun_colormap,1,(int) image->colors,           image->file);%)         for (i=0; i < image->colors; i++)%2           image->colormap[i].blue=sun_colormap[i];+         (void) free((char *) sun_colormap);          break;       }        case RMT_RAW:        {          unsigned char            *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            } K         (void) ReadData((char *) sun_colormap,1,(int) sun_header.maplength,%           image->file);F+         (void) free((char *) sun_colormap);i         break;       }        default:       {mB         Warning("Colormap type is not supported",image->filename);         DestroyImages(image);f         return((Image *) NULL);o       }      } O     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char));r+     if (sun_data == (unsigned char *) NULL)I       {a9         Warning("Memory allocation error",(char *) NULL);A         DestroyImages(image);e         return((Image *) NULL);        }mM     status=ReadData((char *) sun_data,1,(int) sun_header.length,image->file);o=     if ((status == False) && (sun_header.type != RT_ENCODED))e       {mB         Warning("Unable to read image data",image_info->filename);         DestroyImages(image);a         return((Image *) NULL);d       }(     sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {%         unsigned int           width,           height;   
         /*0           Read run-length encoded raster pixels.
         */?         width=sun_header.width*(((sun_header.depth-1) >> 3)+1); !         height=sun_header.height; P         sun_pixels=(unsigned char *) malloc(width*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL)            { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            } @         (void) SUNDecodeImage(sun_data,sun_pixels,width,height);'         (void) free((char *) sun_data);%       }%     /*!       Initialize image structure.%     */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass);h$     image->columns=sun_header.width;"     image->rows=sun_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *))5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)       {e9         Warning("Memory allocation error",(char *) NULL);t         DestroyImages(image);          return((Image *) NULL);d       }      /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;e     q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++)n       {i
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */1         for (x=0; x < (image->columns >> 3); x++)o	         { &           for (bit=7; bit >= 0; bit--)           {):             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }-           p++;	         }p&         if ((image->columns % 8) != 0)           { ?             for (bit=7; bit >= (8-(image->columns % 8)); bit--)f
             {f<               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             }e             p++;           }oI         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0)i           p++;       }_     else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++) 	         {            /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;	         })
       else'         for (y=0; y < image->rows; y++)f	         {            /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {uB             q->index=(unsigned short) (image->matte ? (*p++) : 0);/             if (sun_header.type == RT_STANDARD)f               {                  q->blue=(*p++);i                  q->green=(*p++);                 q->red=(*p++);               }t             else               {)                 q->red=(*p++);                  q->green=(*p++);                 q->blue=(*p++);r               }f#             if (image->colors != 0)e               {l3                 q->red=image->colormap[q->red].red; 9                 q->green=image->colormap[q->green].green;n6                 q->blue=image->colormap[q->blue].blue;               }(             q->length=0;             q++;           }FE           if (((image->columns % 2) != 0) && (image->matte == False))(             p++;	         }e%     (void) free((char *) sun_pixels); $     if (image->class == PseudoClass)       {f         SyncImage(image);i          CompressColormap(image);       }      /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file);r'     if (sun_header.magic == 0x59a66a95)        {-
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);c#             return((Image *) NULL);n           }oB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } +   } while (sun_header.magic == 0x59a66a95); +   while (image->previous != (Image *) NULL)l     image=image->previous;   CloseImage(image);   return(image); }  s /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %NO %                                                                             % O %                                                                             % O %  R e a d T A R G A I m a g e                                                %aO %                                                                             %hO %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % J %  Function ReadTARGAImage reads a Truevision Targa image file and returnsI %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. %f/ %  The format of the ReadTARGAImage routine is:g % ' %      image=ReadTARGAImage(image_info)h %e+ %  A description of each parameter follows:k %=K %    o image:  Function ReadTARGAImage returns a pointer to the image afternL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.s %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */( static Image *ReadTARGAImage(image_info)	 ImageInfoe   *image_info; {o #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3, #define TargaRLEColormap  9  #define TargaRLERGB  10  #define TargaRLEMonochrome  11     typedef struct _TargaHeaderi   {      unsigned charr       id_length,       colormap_type,       image_type;s       unsigned short       colormap_index,        colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,        y_origin,        width,
       height;        unsigned char0       pixel_size,d       attributes;    } TargaHeader;     Image.     *image;a     register int     i,     x,     y;     register RunlengthPacket     *q;)  
   TargaHeader      targa_header;(     unsigned chara	     blue, 
     green,     j,     k,     red,     runlength;     unsigned int	     base,r	     flag, 	     real, 	     skip,t     status,_	     true;*     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)f     { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }    /*"     Read TARGA header information.   */D   status=ReadData((char *) &targa_header.id_length,1,1,image->file);0   targa_header.colormap_type=fgetc(image->file);-   targa_header.image_type=fgetc(image->file);    do   {u>     if ((status == False) || (targa_header.image_type == 0) ||'         (targa_header.image_type > 11)).       {)8         Warning("Not a TARGA image file",(char *) NULL);         DestroyImages(image);          return((Image *) NULL);        } ?     targa_header.colormap_index=LSBFirstReadShort(image->file);z@     targa_header.colormap_length=LSBFirstReadShort(image->file);2     targa_header.colormap_size=fgetc(image->file);9     targa_header.x_origin=LSBFirstReadShort(image->file);y9     targa_header.y_origin=LSBFirstReadShort(image->file);a6     targa_header.width=LSBFirstReadShort(image->file);7     targa_header.height=LSBFirstReadShort(image->file); /     targa_header.pixel_size=fgetc(image->file);g/     targa_header.attributes=fgetc(image->file);*     /*!       Initialize image structure.o     *//     image->matte=targa_header.pixel_size == 32;s&     image->columns=targa_header.width;$     image->rows=targa_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)*5       malloc(image->packets*sizeof(RunlengthPacket));-2     if (image->pixels == (RunlengthPacket *) NULL)       {r9         Warning("Memory allocation error",(char *) NULL);p         DestroyImages(image);w         return((Image *) NULL);a       } $     if (targa_header.id_length != 0)       {k
         /*           TARGA image comment.
         */          image->comments=(char *):           malloc((targa_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)            {*=             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);            } G         (void) ReadData(image->comments,1,(int) targa_header.id_length,            image->file);05         image->comments[targa_header.id_length]='\0';p       }m(     if (targa_header.colormap_type != 0)       { 
         /*%           Read TARGA raster colormap. 
         */<         if ((targa_header.image_type == TargaRLEColormap) ||5             (targa_header.image_type == TargaRLERGB))-#           image->class=PseudoClass; 3         image->colors=targa_header.colormap_length;l'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL)           {g=             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image);o#             return((Image *) NULL);a           }c)         for (i=0; i < image->colors; i++)n	         { -           switch (targa_header.colormap_size)            {t             case 8:              default:
             {                /*                 Gray scale.i               */%               red=fgetc(image->file);n               green=red;               blue=red;n               break;
             }l             case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file); #               k=fgetc(image->file);mH               red=(unsigned char) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);#               green=(unsigned char)nP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);D               blue=(unsigned char) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }              case 32:             case 24:
             {4               /*2                 8 bits each of blue green and red.               */&               blue=fgetc(image->file);'               green=fgetc(image->file);F%               red=fgetc(image->file);r               break;
             }            } %           image->colormap[i].red=red; )           image->colormap[i].green=green;m'           image->colormap[i].blue=blue;m	         })       }      /*8       Convert TARGA pixels to runlength-encoded packets.     */     base=0;      flag=0;      index=0;     skip=False;n     real=0;o     runlength=0;     true=0;x#     for (y=0; y < image->rows; y++)n     {e       real=true;G       if (((unsigned char) (targa_header.attributes & 0x20) >> 5) == 0)           real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       {e<         if ((targa_header.image_type == TargaRLEColormap) ||7             (targa_header.image_type == TargaRLERGB) || <             (targa_header.image_type == TargaRLEMonochrome))           if (runlength != 0)%
             {%               runlength--;               skip=flag != 0; 
             }            else
             { C               status=ReadData((char *) &runlength,1,1,image->file); "               if (status == False)                 { L                   Warning("Unable to read image data",image_info->filename);'                   DestroyImages(image); )                   return((Image *) NULL);                  } $               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;                skip=False; 
             }          if (!skip)*           switch (targa_header.pixel_size)           {%             case 8:%             default:
             {                /*                 Gray scale.f               */'               index=fgetc(image->file); 2               if (targa_header.colormap_type == 0)                 { ,                   red=(unsigned char) index;.                   green=(unsigned char) index;-                   blue=(unsigned char) index;o                 }a               else                 {o1                   red=image->colormap[index].red;m5                   green=image->colormap[index].green; 3                   blue=image->colormap[index].blue;:                 }e               break;
             }              case 15:             case 16:
             {p               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file); #               k=fgetc(image->file);gH               red=(unsigned char) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);#               green=(unsigned char)aP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);D               blue=(unsigned char) ((MaxRGB*((int) (j & 0x1f)))/31);.               index=((unsigned int) k << 8)+j;               break;
             }e             case 24:             case 32:
             {g               /*2                 8 bits each of blue green and red.               */&               blue=fgetc(image->file);'               green=fgetc(image->file);a%               red=fgetc(image->file);n0               if (targa_header.pixel_size == 32))                 index=fgetc(image->file);s               break;
             }            }U         if (status == False)           {iF             Warning("Unable to read image data",image_info->filename);!             DestroyImages(image);t#             return((Image *) NULL);-           }          q->red=red;e         q->green=green;;         q->blue=blue;          q->index=index;(         q->length=0;         q++;       } G       if (((unsigned char) (targa_header.attributes & 0xc0) >> 6) == 4)j         true+=4;
       elseI         if (((unsigned char) (targa_header.attributes & 0xc0) >> 6) == 2)f           true+=2;         else           true++;e       if (true >= image->rows)	         {>           base++;            true=base;	         }i     }i$     if (image->class == PseudoClass)       SyncImage(image); F     status=ReadData((char *) &targa_header.id_length,1,1,image->file);2     targa_header.colormap_type=fgetc(image->file);/     targa_header.image_type=fgetc(image->file);sP     status&=((targa_header.image_type != 0) && (targa_header.image_type <= 11));     if (status == True)        {e
         /*#           Allocate image structure.*
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);_           }gB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }N   } while (status == True);f+   while (image->previous != (Image *) NULL)m     image=image->previous;   CloseImage(image);   return(image); }e m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             %=O %                                                                             %rO %  R e a d T E X T I m a g e                                                  %rO %                                                                             %=O %                                                                             % O %                                                                             %_O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%H %lK %  Function ReadTEXTImage reads a text file and returns it as an image.  ItjK %  allocates the memory necessary for the new Image structure and returns aA %  pointer to the new image. %s. %  The format of the ReadTEXTImage routine is: %i& %      image=ReadTEXTImage(image_info) %;+ %  A description of each parameter follows:; % J %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. %cA %    o image_info: Specifies a pointer to an ImageInfo structure.* %e %J */' static Image *ReadTEXTImage(image_info)g	 ImageInfo    *image_info; {e   char     *resource_value,     *text_status,S     text[MaxTextLength];  	   Display(
     *display;i     Imagec     *image;      inte     status,a     offset,e     x,     y;     register int     i;     register RunlengthPacket     *p;      RunlengthPacket      background_color;a     unsigned int     height,m
     width;     XAnnotateInfo      annotate_info;  
   XFontStructr     *font_info;*     XPixelInfo     pixel_info;o     XResourceInfof     resource_info;  
   XrmDatabaseN     resource_database,     server_database;     XStandardColormap,     *map_info;  
   XVisualInfo      *visual_info;i     /*     Allocate image structure.)   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);i   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)b     {s5       Warning("Unable to open file",image->filename);i       DestroyImage(image);       return((Image *) NULL);c     }+   /*     Open X server connection.n   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {x.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));e       DestroyImage(image);       return((Image *) NULL);      }-   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);n   /*/     Get user defaults from X resource database.i   */   XrmInitialize();+   XGetDefault(display,client_name,"dummy");(,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display);)&   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value); 8   XrmMergeDatabases(server_database,&resource_database);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;    /*     Allocate standard colormap.    */#   XGetAnnotateInfo(&annotate_info); $   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)AM     Warning("Unable to create standard colormap","Memory allocation failed");)   else     {        /*         Initialize visual info.>       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL;i       /*         Initialize font info.n       */,       if (image_info->font != (char *) NULL),         resource_info.font=image_info->font;8       font_info=XBestFont(display,&resource_info,False);,       if (font_info == (XFontStruct *) NULL):         Warning("Unable to load font",resource_info.font);(       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;     } 1   if ((map_info == (XStandardColormap *) NULL) || .       (visual_info == (XVisualInfo *) NULL) ||*       (font_info == (XFontStruct *) NULL))     {rF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);        DestroyImage(image);       return((Image *) NULL);;     }u   /*!     Initialize Standard Colormap.d   */H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,      &pixel_info);%F   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   pixel_info.annotate_index=1;C   background_color.red=ColorShift(pixel_info.background_color.red); E   background_color.green=ColorShift(pixel_info.background_color.red); D   background_color.blue=ColorShift(pixel_info.background_color.red);   background_color.index=0;    background_color.length=0;   /*     Initialize Image structure.    */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height); (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    image->columns=width;    image->rows=height;%,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)F3     malloc(image->packets*sizeof(RunlengthPacket));a   image->class=PseudoClass;s   image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))     {mD       Warning("Unable to allocate image","Memory allocation error");F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);        DestroyImage(image);       return((Image *) NULL);      }o   /*     Initialize colormap.   */E   image->colormap[0].red=ColorShift(pixel_info.background_color.red);fI   image->colormap[0].green=ColorShift(pixel_info.background_color.green);oG   image->colormap[0].blue=ColorShift(pixel_info.background_color.blue); E   image->colormap[1].red=ColorShift(pixel_info.foreground_color.red);aI   image->colormap[1].green=ColorShift(pixel_info.foreground_color.green); G   image->colormap[1].blue=ColorShift(pixel_info.foreground_color.blue);)   /*.     Initialize text image to background color.   */   p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background_color;   /*     Annotate the text image.   */A   annotate_info.text=(char *) malloc(MaxTextLength*sizeof(char)); *   if (annotate_info.text == (char *) NULL)     { A       Warning("Unable to read image","Memory allocation failed"); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,7         font_info,&resource_info,(XWindowInfo *) NULL);)       DestroyImage(image);       return((Image *) NULL);c     }e   text[MaxTextLength-1]='\0';n6   text_status=fgets(text,MaxTextLength-1,image->file);   if ((int) strlen(text) > 0)o     text[strlen(text)-1]='\0';   offset=0;r&   while (text_status != (char *) NULL)   {      *annotate_info.text='\0';o     if (*text != '\0')       {m
         /*            Compute width of text.
         *//         (void) strcpy(annotate_info.text,text);c         annotate_info.width=N           XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));6         if ((annotate_info.width+4) >= image->columns)           {o             /*7               Reduce text until width is within bounds.d             */)             i=strlen(annotate_info.text);eI             for (; (annotate_info.width+(x << 1)) >= image->columns; i--)N"               annotate_info.width=J                 XTextWidth(font_info,annotate_info.text,(unsigned int) i);'             annotate_info.text[i]='\0';0>             while ((i > 0) && !isspace(annotate_info.text[i]))               i--;             if (i > 0))               annotate_info.text[i]='\0'; H             annotate_info.width=XTextWidth(font_info,annotate_info.text,*               strlen(annotate_info.text));           }i
         /*#           Annotate image with text. 
         */<         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",?           annotate_info.width,annotate_info.height,x,y+offset);eN         status=XAnnotateImage(display,&pixel_info,&annotate_info,False,image);         if (status == 0)           {%J             Warning("Unable to annotate image","Memory allocation error");             break;           }        }      /*       Get next string.     */3     if (strlen(text) != strlen(annotate_info.text)) <       (void) strcpy(text,text+strlen(annotate_info.text)+1);     else       {R<         text_status=fgets(text,MaxTextLength-1,image->file);#         if ((int) strlen(text) > 0) $           text[strlen(text)-1]='\0';       } !     offset+=annotate_info.height; )     if ((text_status != (char *) NULL) && @         (((y << 1)+offset+annotate_info.height) >= image->rows))       { 
         /*7           Page is full-- allocate next image structure.%
         */         image->orphan=True;nF         image->next=CopyImage(image,image->columns,image->rows,False);         image->orphan=False;*         if (image->next == (Image *) NULL)           {tJ             Warning("Unable to annotate image","Memory allocation error");             break;           }mB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;
         /*4           Initialize text image to background color.
         */         p=image->pixels;*         for (i=0; i < image->packets; i++)            *p++=background_color;         offset=0;        }    }a   /*     Force class to PseudoClass.i   */+   while (image->previous != (Image *) NULL)    {      image->class=PseudoClass;      image=image->previous;   }a   image->class=PseudoClass;n   CloseImage(image);   /*     Free resources.    */+   (void) free((char *) annotate_info.text);mB   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,3     font_info,&resource_info,(XWindowInfo *) NULL);m   return(image); }f m #ifdef HasTIFF #ifndef va_start, #if defined(__STDC__) && !defined(NOSTDHDRS) #include <stdarg.h>e #elsea #include <varargs.h> #endif #endif #include "tiffio.h"  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             %yO %                                                                             %TO %                                                                             %oO %  R e a d T I F F I m a g e                                                  %(O %                                                                             %*O %                                                                             % O %                                                                             %lO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %NG %  Function ReadTIFFImage reads a Tagged image file and returns it.  IttK %  allocates the memory necessary for the new Image structure and returns ae %  pointer to the new image. %=. %  The format of the ReadTIFFImage routine is: %)& %      image=ReadTIFFImage(image_info) % + %  A description of each parameter follows:x %nJ %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.% %%A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  5 static void TIFFWarningMessage(module,format,warning) 
 const char
   *module,
   *format;   va_list 
   warning; {    char     message[MaxTextLength];      register char      *p;      p=message;   if (module != (char *) NULL)     {        sprintf(p,"%s: ",module);        p+=strlen(message);      }    vsprintf(p,format,warning);    strcat(p,".");!   Warning(message,(char *) NULL);  }   ' static Image *ReadTIFFImage(image_info) 	 ImageInfo    *image_info; {    char
     *comment;      Image      *image;%     int%
     range;     register int     i,     quantum,     x,     y;     register RunlengthPacket     *q;I     TIFF
     *tiff;     unsigned int     height,m     status,r
     width;     unsigned short     bits_per_sample,     max_sample_value,      min_sample_value,R     photometric,     samples_per_pixel;     /*     Allocate image structure.r   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image.i   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      {h5       Warning("Unable to open file",image->filename);i       DestroyImage(image);       return((Image *) NULL);c     }*,   if ((image->file == stdin) || image->pipe)     {;
       FILE         *file;  	       int 
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);,       file=fopen(image_info->filename,"wb");        if (file == (FILE *) NULL)	         {a:           Warning("Unable to write file",image->filename);!           return((Image *) NULL);(	         }m       c=fgetc(image->file);g       while (c != EOF)       {e         (void) putc(c,file);         c=fgetc(image->file);(       }U       (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     })   CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);&   tiff=TIFFOpen(image->filename,"rb");   if (tiff == (TIFF *) NULL)     {n5       Warning("Unable to open file",image->filename);e       DestroyImage(image);       return((Image *) NULL);a     }    do   {      if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);     /*5       Allocate memory for the image and pixel buffer.      */1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width);t3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height);c/     for (quantum=1; quantum <= 16; quantum<<=1)      { #       image->columns=width/quantum; !       image->rows=height/quantum; 0       image->packets=image->columns*image->rows;'       image->pixels=(RunlengthPacket *) 7         malloc(image->packets*sizeof(RunlengthPacket));h6       if ((image->pixels != (RunlengthPacket *) NULL))         break;     }g2     if (image->pixels == (RunlengthPacket *) NULL)       { ;         Warning("Unable to allocate memory",(char *) NULL);}         DestroyImages(image);          TIFFClose(tiff);         return((Image *) NULL);        } G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample);cI     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value);*I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value); A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric);eK     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel);      comment=(char *) NULL;9     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&comment);n!     if (comment != (char *) NULL)a$       if ((int) strlen(comment) > 4)	         {("           image->comments=(char *)D             malloc((unsigned int) (strlen(comment)+1)*sizeof(char));/           if (image->comments == (char *) NULL)(
             { A               Warning("Unable to allocate memory",(char *) NULL);t#               DestroyImages(image);                TIFFClose(tiff);%               return((Image *) NULL);d
             }g1           (void) strcpy(image->comments,comment); 	         }m,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;eN     if ((bits_per_sample > 8) || (samples_per_pixel > 1) || TIFFIsTiled(tiff))       {          register uint32c
           *p,            *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image.;
         */+         image->matte=samples_per_pixel > 3; @         pixels=(uint32 *) malloc(image->packets*sizeof(uint32));&         if (pixels == (uint32 *) NULL)           { ?             Warning("Unable to allocate memory",(char *) NULL);e!             DestroyImages(image);              TIFFClose(tiff);#             return((Image *) NULL);            }l         if (quantum > 1);           Warning("Not enough memory","cropping required"); K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);k         if (status == False)           {-?             Warning("Unable to read TIFF image",(char *) NULL);o)             (void) free((char *) pixels);(!             DestroyImages(image);              TIFFClose(tiff);#             return((Image *) NULL);            } 
         /*A           Convert image to DirectClass runlength-encoded packets.m
         */         q=image->pixels;*         for (y=image->rows-1; y >= 0; y--)	         {s$           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           {-              q->red=TIFFGetR(*p);"             q->green=TIFFGetG(*p);!             q->blue=TIFFGetB(*p);pH             q->index=(unsigned short) (image->matte ? TIFFGetA(*p) : 0);             q->length=0;             p++;             q++;           }s	         }r%         (void) free((char *) pixels);s#         if (samples_per_pixel == 1) J           QuantizeImage(image,(unsigned int) range,8,False,RGBColorspace);       }      else       {u         unsigned char 
           *p, 
           *r,l           *quantum_scanline,           *scanline;  
         /*7           Convert TIFF image to PseudoClass MIFF image.r
         */!         image->class=PseudoClass;f         image->colors=range+1;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));O         quantum_scanline=(unsigned char *) malloc(width*sizeof(unsigned char));nB         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));8         if ((image->colormap == (ColorPacket *) NULL) ||;             (quantum_scanline == (unsigned char *) NULL) ||c1             (scanline == (unsigned char *) NULL))t           {"?             Warning("Unable to allocate memory",(char *) NULL);)!             DestroyImages(image);"             TIFFClose(tiff);#             return((Image *) NULL);e           } 
         /*           Create colormap.
         */         switch (photometric)	         {(&           case PHOTOMETRIC_MINISBLACK:           {s-             for (i=0; i < image->colors; i++)a
             {)6               image->colormap[i].red=(MaxRGB*i)/range;8               image->colormap[i].green=(MaxRGB*i)/range;7               image->colormap[i].blue=(MaxRGB*i)/range; 
             }g             break;           } &           case PHOTOMETRIC_MINISWHITE:           {e-             for (i=0; i < image->colors; i++)e
             {g>               image->colormap[i].red=((range-i)*MaxRGB)/range;@               image->colormap[i].green=((range-i)*MaxRGB)/range;?               image->colormap[i].blue=((range-i)*MaxRGB)/range; 
             }=             break;           }=#           case PHOTOMETRIC_PALETTE:>           {=             unsigned short               *blue_colormap,                *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,u               &blue_colormap);-             for (i=0; i < image->colors; i++)S
             { J               image->colormap[i].red=((int) red_colormap[i]*MaxRGB)/65535;N               image->colormap[i].green=((int) green_colormap[i]*MaxRGB)/65535;L               image->colormap[i].blue=((int) blue_colormap[i]*MaxRGB)/65535;
             }              break;           }            default:             break;	         }t
         /*A           Convert image to PseudoClass runlength-encoded packets. 
         */         if (quantum > 1)>           Warning("Not enough memory","subsampling required");         q=image->pixels;'         for (y=0; y < image->rows; y++) 	         {g%           for (i=0; i < quantum; i++) :             TIFFReadScanline(tiff,scanline,y*quantum+i,0);           p=scanline;            r=quantum_scanline; "           switch (bits_per_sample)           {o             case 1:/
             {                register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               {c,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } #               if ((width % 8) != 0)l                 { <                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }                break;
             }              case 2:c
             { 2               for (x=0; x < ((int) width-3); x+=4)               {)%                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3;s%                 *r++=(*p >> 2) & 0x3;o                  *r++=(*p) & 0x3;                 p++;               } #               if ((width % 4) != 0)"                 { 6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }d               break;
             }              case 4:o
             { 2               for (x=0; x < ((int) width-1); x+=2)               {e%                 *r++=(*p >> 4) & 0xf;n                  *r++=(*p) & 0xf;                 p++;               }r#               if ((width % 2) != 0)e                 { '                   *r++=(*p >> 4) & 0xf;                    p++;                 }l               break;
             }              case 8:a
             {e'               for (x=0; x < width; x++)n               {a                 *r++=(*p);                 p++;               }m               break;
             }N             default:               break;           }            /*'             Subsample quantum scanline.            */           r=quantum_scanline;i,           for (x=0; x < image->columns; x++)           {              q->index=(*r);             q->length=0;             q++;             r+=quantum;            }l	         } /         (void) free((char *) quantum_scanline);c'         (void) free((char *) scanline);        }e$     if (image->class == PseudoClass)       {          SyncImage(image);)          CompressColormap(image);       }o     /*       Proceed to next image.     */#     status=TIFFReadDirectory(tiff);      if (status == True)a       {a
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {)!             DestroyImages(image); #             return((Image *) NULL);g           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True);    TIFFClose(tiff);   if (image->temporary) (     (void) unlink(image_info->filename);+   while (image->previous != (Image *) NULL)=     image=image->previous;   return(image); }i #else ' static Image *ReadTIFFImage(image_info) 	 ImageInfoc   *image_info; { @   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }_ #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %EO %                                                                             % O %                                                                             %oO %   R e a d V I C A R I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             %UO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function ReadVICARImage reads a VICAR image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns an %  pointer to the new image. %0/ %  The format of the ReadVICARImage routine is:p %l' %      image=ReadVICARImage(image_info), %g+ %  A description of each parameter follows:  % J %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or ifa  %      the image cannot be read. %i9 %    o filename: Specifies the name of the image to read.a %t %z */( static Image *ReadVICARImage(image_info)	 ImageInfo    *image_info; {c   char     keyword[MaxTextLength],      value[MaxTextLength];c     Image=     *image;m     long
     count;     register int     c,     i;     register RunlengthPacket     *q;      register unsigned char     *p;e     unsigned char/     *vicar_pixels;     unsigned int     header_length,     status,d     value_expected;_     /*     Allocate image structure.(   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);r   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)n     {a5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);L     }    /*     Decode image header.   */   c=fgetc(image->file);e
   count=1;   if (c == EOF)m     {l       DestroyImage(image);       return((Image *) NULL);a     }=   header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))d   {a     if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }N     else       {          register charc
           *p;e  
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));o         *p='\0';         value_expected=False;t(         while (isspace(c) || (c == '='))	         {O           if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         }e$         if (value_expected == False)           continue;L         p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextLength-1))             *p++=(char) c;           c=fgetc(image->file);e           count++;	         }l         *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0) 3           header_length=(unsigned int) atoi(value);U+         if (strcmp(keyword,"LBLSIZE") == 0)e3           header_length=(unsigned int) atoi(value);f0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0) 1           image->rows=(unsigned int) atoi(value); &         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);G       }e     while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    /*      Read the rest of the header.   */   while (count < header_length)    {      c=fgetc(image->file);      count++;   }    /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0)     {%@       Warning("Incorrect image header in file",image->filename);       DestroyImage(image);       return((Image *) NULL);s     }m   /*     Create linear colormap.u   */   image->class=PseudoClass;    image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     {o7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }d#   for (i=0; i < image->colors; i++)f   { -     image->colormap[i].red=(unsigned char) i;i/     image->colormap[i].green=(unsigned char) i;e.     image->colormap[i].blue=(unsigned char) i;   }o   /*     Initialize image structure.m   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)r3     malloc(image->packets*sizeof(RunlengthPacket));tN   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL))m     {N7       Warning("Memory allocation error",(char *) NULL);f       DestroyImage(image);       return((Image *) NULL);(     }    /*6     Convert VICAR pixels to runlength-encoded packets.   */L   status=ReadData((char *) vicar_pixels,1,(int) image->packets,image->file);   if (status == False)     {/A       Warning("Insufficient image data in file",image->filename);e       DestroyImage(image);       return((Image *) NULL);      }g   /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;y   q=image->pixels;$   for (i=0; i < image->packets; i++)   {u     q->red=(*p);     q->green=(*p);     q->blue=(*p); !     q->index=(unsigned short) *p;)     q->length=0;     p++;     q++;   } %   (void) free((char *) vicar_pixels);i   CompressColormap(image);   CloseImage(image);   return(image); }L   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %kO %                                                                             %xO %  R e a d M I D I m a g e                                                    %"O %                                                                             %mO %                                                                             %cO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %pL %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Image(4 %  structure and returns a pointer to the new image. % - %  The format of the ReadVIDImage routine is:e % % %      image=ReadVIDImage(image_info)e %g+ %  A description of each parameter follows:m % I %    o image:  Function ReadVIDImage returns a pointer to the image afteruL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.g %nA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadVIDImage(image_info)	 ImageInfo;   *image_info; {  #define ClientName  "montage"s     char     **filelist,s     *resource_value;  	   Displayg
     *display;      Imagei     *image,u
     **images;      ImageInfoI     local_info;g     intn     number_files;      register int     i,     j;     XMontageInfo     montage_info;>     XResourceInfon     resource_info;  
   XrmDatabased     resource_database,     server_database;     /*     Expand the filename.   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return((Image *) NULL);      }    number_files=1; #   filelist[0]=image_info->filename; +   ExpandFilenames(&number_files,&filelist);    if (number_files == 0)     { =       Warning("VID translation failed",image_info->filename);        return((Image *) NULL);      }    /*     Allocate images array.   */9   images=(Image **) malloc(number_files*sizeof(Image *));     if (images == (Image **) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);%&       for (i=0; i < number_files; i++)*         (void) free((char *) filelist[i]);%       (void) free((char *) filelist);e       return((Image *) NULL);m     }u   /*     Open X server connection.e   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {g.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));a&       for (i=0; i < number_files; i++)*         (void) free((char *) filelist[i]);%       (void) free((char *) filelist); #       (void) free((char *) images);        return((Image *) NULL);p     }t   /*!     Initialize resource database.t   */   XSetErrorHandler(XError);)   XrmInitialize();*   XGetDefault(display,ClientName,"dummy");,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display);s&   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value);a8   XrmMergeDatabases(server_database,&resource_database);@   XGetResourceInfo(resource_database,ClientName,&resource_info);H   resource_info.background_color=XGetResourceInstance(resource_database,3     ClientName,"background",DefaultTileBackground);lN   resource_value=XGetResourceClass(resource_database,ClientName,"borderWidth",     DefaultTileBorderwidth);2   resource_info.border_width=atoi(resource_value);&   resource_info.font=image_info->font;H   resource_info.foreground_color=XGetResourceInstance(resource_database,3     ClientName,"foreground",DefaultTileForeground);)F   resource_info.image_geometry=XGetResourceInstance(resource_database,4     ClientName,"imageGeometry",DefaultTileGeometry);N   resource_info.matte_color=XGetResourceInstance(resource_database,ClientName,#     "mattecolor",DefaultTileMatte);n   /*/     Read each image and convert them to a tile.    */   j=0;   local_info=(*image_info);h"   for (i=0; i < number_files; i++)   {n$     local_info.filename=filelist[i];!     image=ReadImage(&local_info);)&     (void) free((char *) filelist[i]);      if (image == (Image *) NULL)       continue;e     image->scene=j;e     LabelImage(image,"%f"); F     TransformImage(&image,(char *) NULL,resource_info.image_geometry);     if (image_info->verbose)       DescribeImage(image);m     images[j]=image;     j++;   }_!   (void) free((char *) filelist);    /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);;   montage_info.number_tiles=j;   image=(Image *) NULL;n%   if (montage_info.number_tiles != 0)f=     image=XMontageImage(display,&resource_info,&montage_info,.#       image_info->filename,images);e   XCloseDisplay(display);    (void) free((char *) images);    if (image == (Image *) NULL)     { =       Warning("VID translation failed",image_info->filename);_       return((Image *) NULL);      }g   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             %mO %                                                                             %tO %   R e a d V I F F I m a g e                                                 % O %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadVIFFImage reads a Khoros Visualization image file and returns I %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. % . %  The format of the ReadVIFFImage routine is: % & %      image=ReadVIFFImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadVIFFImage returns a pointer to the image after%O %      reading.  A null image is returned if there is a a memory shortage or ifa  %      the image cannot be read. %c9 %    o filename: Specifies the name of the image to read.e %n %  */' static Image *ReadVIFFImage(image_info)r	 ImageInfoR   *image_info; {e #define VFF_CM_genericRGB  15I #define VFF_CM_ntscRGB  1d #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4e #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1n #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1a #define VFF_TYP_2_BYTE  2o #define VFF_TYP_4_BYTE  4f     typedef struct _ViffHeader   {a     unsigned charN       identifier,n       file_type,       release,       version,       machine_dependency,        reserve[3];%       char       comment[512];%       unsigned long%       rows,        columns,       subrows;       long       x_offset,        y_offset;   	     float        x_pixel_size,        y_pixel_size;        unsigned long        location_type,       location_dimension,        number_of_images,        number_data_bands,       data_storage_type,       data_encode_scheme,        map_scheme,        map_storage_type,        map_rows,        map_columns,       map_subrows,       map_enable,        maps_per_cycle,        color_space_model;   } ViffHeader;      Image      *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;%     register unsigned char     *p;t     unsigned chara     buffer[7],     *viff_pixels;s     unsigned int     bytes_per_pixel,     status;e     unsigned longn     packets;     ViffHeader     viff_header;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)o     { 5       Warning("Unable to open file",image->filename);f       DestroyImage(image);       return((Image *) NULL);      }o   /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {      /*       Verify VIFF identifier.m     */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))       { 6         Warning("Not a VIFF raster,",image->filename);         DestroyImages(image);          return((Image *) NULL);m       }      /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file); $     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3];aD     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';.     if ((int) strlen(viff_header.comment) > 4)       {           image->comments=(char *)N           malloc((unsigned int) (strlen(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL)a           { =             Warning("Memory allocation error",(char *) NULL); !             DestroyImages(image); #             return((Image *) NULL);a           }/;         (void) strcpy(image->comments,viff_header.comment);a       }a?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||y<         (viff_header.machine_dependency == VFF_DEP_NSORDER))       {v7         viff_header.rows=LSBFirstReadLong(image->file);d:         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);;         viff_header.x_offset=LSBFirstReadLong(image->file);e;         viff_header.y_offset=LSBFirstReadLong(image->file);,G         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file);XG         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file);T@         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file);cC         viff_header.number_of_images=LSBFirstReadLong(image->file);uD         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file);c=         viff_header.map_scheme=LSBFirstReadLong(image->file); C         viff_header.map_storage_type=LSBFirstReadLong(image->file);i;         viff_header.map_rows=LSBFirstReadLong(image->file); >         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=LSBFirstReadLong(image->file);-D         viff_header.color_space_model=LSBFirstReadLong(image->file);       }o     else       {i7         viff_header.rows=MSBFirstReadLong(image->file);o:         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);;         viff_header.x_offset=MSBFirstReadLong(image->file);v;         viff_header.y_offset=MSBFirstReadLong(image->file);(G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file);aG         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file); @         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file);,C         viff_header.number_of_images=MSBFirstReadLong(image->file);hD         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file);(=         viff_header.map_scheme=MSBFirstReadLong(image->file); C         viff_header.map_storage_type=MSBFirstReadLong(image->file); ;         viff_header.map_rows=MSBFirstReadLong(image->file);e>         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file);sA         viff_header.maps_per_cycle=MSBFirstReadLong(image->file); D         viff_header.color_space_model=MSBFirstReadLong(image->file);       }e     for (i=0; i < 420; i++)L        (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)       { M         Warning("Image column or row size is not supported",image->filename);          DestroyImages(image);(         return((Image *) NULL);e       } 9     if ((viff_header.data_storage_type != VFF_TYP_BIT) &&x<         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))       {nF         Warning("Data storage type is not supported",image->filename);         DestroyImages(image);          return((Image *) NULL);        })6     if (viff_header.data_encode_scheme != VFF_DES_RAW)       {oI         Warning("Data encoding scheme is not supported",image->filename);          DestroyImages(image);          return((Image *) NULL);        }g<     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))       {1E         Warning("Map storage type is not supported",image->filename);          DestroyImages(image);l         return((Image *) NULL);t       } 9     if ((viff_header.color_space_model != VFF_CM_NONE) && <         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB))o       {gF         Warning("Color space model is not supported",image->filename);         DestroyImages(image);a         return((Image *) NULL);        }i6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       {(B         Warning("Location type is not supported",image->filename);         DestroyImages(image);g         return((Image *) NULL);        }M*     if (viff_header.number_of_images != 1)       {oE         Warning("Number of images is not supported",image->filename);c         DestroyImages(image);t         return((Image *) NULL);t       }l#     switch (viff_header.map_scheme)2     {l       case VFF_MS_NONE:)       {f.         if (viff_header.number_data_bands < 3)           {e             /*'               Create linear color ramp.              */=             if (viff_header.data_storage_type == VFF_TYP_BIT)t               image->colors=2;             elseC               image->colors=1 << (viff_header.number_data_bands*8);e+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)               {cA                 Warning("Memory allocation error",(char *) NULL);s'                 return((Image *) NULL);g               }g-             for (i=0; i < image->colors; i++)i
             {aB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);)
             }            }          break;       }r       case VFF_MS_ONEPERBAND:        case VFF_MS_SHARED:        {          unsigned chari           *viff_colormap;d  
         /*$           Read VIFF raster colormap.
         */.         image->colors=viff_header.map_columns;'         image->colormap=(ColorPacket *))4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *)i6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL))           { =             Warning("Memory allocation error",(char *) NULL);r!             DestroyImages(image);f#             return((Image *) NULL);.           } E         (void) ReadData((char *) viff_colormap,1,(int) image->colors,            image->file);o)         for (i=0; i < image->colors; i++) 	         { 2           image->colormap[i].red=viff_colormap[i];4           image->colormap[i].green=viff_colormap[i];3           image->colormap[i].blue=viff_colormap[i];r	         }m%         if (viff_header.map_rows > 1)(           {aI             (void) ReadData((char *) viff_colormap,1,(int) image->colors,                image->file); -             for (i=0; i < image->colors; i++) 8               image->colormap[i].green=viff_colormap[i];           } %         if (viff_header.map_rows > 2)            {gI             (void) ReadData((char *) viff_colormap,1,(int) image->colors,                image->file);i-             for (i=0; i < image->colors; i++) 7               image->colormap[i].blue=viff_colormap[i];v           }o,         (void) free((char *) viff_colormap);         break;       }e       default:       {=B         Warning("Colormap type is not supported",image->filename);         DestroyImages(image);b         return((Image *) NULL);e       }      }      /*       Allocate VIFF pixels.      */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT)(>       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands;t!     viff_pixels=(unsigned char *) <       malloc(bytes_per_pixel*packets*sizeof(unsigned char));.     if (viff_pixels == (unsigned char *) NULL)       {t9         Warning("Memory allocation error",(char *) NULL);l         DestroyImages(image);a         return((Image *) NULL);;       }=M     (void) ReadData((char *) viff_pixels,(int) bytes_per_pixel,(int) packets,        image->file);18     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       {u         register short int
           *p;,           register unsigned char
           *q;,           short intg           max_value,           min_value,           value;           unsigned long;           scale_factor;m  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header, 6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor.>
         */$         p=(short int *) viff_pixels;         max_value=(*p);          min_value=(*p);g#         for (i=0; i < packets; i++) 	         {            if (*p > max_value)1             max_value=(*p);m           else             if (*p < min_value)e               min_value=(*p);m           p++;	         }m1         if ((min_value == 0) && (max_value == 0))p           scale_factor=0;r         else%           if (min_value == max_value)s
             { 5               scale_factor=UpShift(MaxRGB)/min_value;*               min_value=0;
             }            else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);(
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;         q=viff_pixels;#         for (i=0; i < packets; i++) 	         {*7           value=DownShift((*p-min_value)*scale_factor);=           if (value > MaxRGB)g             value=MaxRGB;a           else             if (value < 0)               value=0;#           *q=(unsigned char) value;o           p++;           q++;	         }        } 8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       {          intI           max_value,           min_value,           value;           register int
           *p;%           register unsigned char
           *q;            unsigned long            scale_factor;   
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || @             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */         p=(int *) viff_pixels;         max_value=(*p);          min_value=(*p); #         for (i=0; i < packets; i++)%	         {%           if (*p > max_value)%             max_value=(*p);d           else             if (*p < min_value)                min_value=(*p);h           p++;	         }n1         if ((min_value == 0) && (max_value == 0))            scale_factor=0;a         else%           if (min_value == max_value)R
             {g5               scale_factor=UpShift(MaxRGB)/min_value;s               min_value=0;
             }e           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value); 
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;         q=viff_pixels;#         for (i=0; i < packets; i++)I	         {C7           value=DownShift((*p-min_value)*scale_factor);e           if (value > MaxRGB)              value=MaxRGB;n           else             if (value < 0)               value=0;#           *q=(unsigned char) value;            p++;           q++;	         }o       }r     /*!       Initialize image structure.      */6     image->matte=(viff_header.number_data_bands == 4);     image->class=eF       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);$     image->columns=viff_header.rows;$     image->rows=viff_header.columns;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));s2     if (image->pixels == (RunlengthPacket *) NULL)       {p9         Warning("Memory allocation error",(char *) NULL);s         DestroyImages(image);s         return((Image *) NULL);e       }g     /*=       Convert VIFF raster image to runlength-encoded packets.      */     p=viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)        {n         unsigned int           polarity;   
         /*E           Convert bitmap scanline to runlength-encoded color packets.m
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++)(	         {i           /*G             Convert bitmap scanline to runlength-encoded color packets.            */3           for (x=0; x < (image->columns >> 3); x++)            {v'             for (bit=0; bit < 8; bit++)n
             {eE               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);                q->length=0;               q++;
             }m             p++;           }f(           if ((image->columns % 8) != 0)
             {B<               for (bit=0; bit < (image->columns % 8); bit++)               {eG                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);r                 q->length=0;                 q++;               }r               p++;
             }o	         }i       }      else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)e	         {            /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {(             q->index=(*p++);             q->length=0;             q++;           } 	         }i
       else	         {r           unsigned long              offset;n             /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++))           {,.             for (x=0; x < image->columns; x++)
             {                q->red=(*p);%               q->green=(*(p+offset));]&               q->blue=(*(p+offset*2));%               if (image->colors != 0)b                 { 5                   q->red=image->colormap[q->red].red;,;                   q->green=image->colormap[q->green].green;e8                   q->blue=image->colormap[q->blue].blue;                 }fM               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);i               q->length=0;               p++;               q++;
             }            }a	         }-&     (void) free((char *) viff_pixels);$     if (image->class == PseudoClass)       {l         SyncImage(image);           CompressColormap(image);       }h     /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))e       {d
         /*#           Allocate image structure.e
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {c!             DestroyImages(image); #             return((Image *) NULL);=           };B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } A   } while ((status == True) && (viff_header.identifier == 0xab));e+   while (image->previous != (Image *) NULL))     image=image->previous;   CloseImage(image);   return(image); }- l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %+O %                                                                             %aO %                                                                             % O %   R e a d X I m a g e                                                       %aO %                                                                             % O %                                                                             %GO %                                                                             %bO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%[ %g8 %  Procedure ReadXImage reads an image from an X window. % + %  The format of the ReadXImage routine is:  %*@ %      image=ReadXImage(image_info,frame,borders,screen,descend) %e+ %  A description of each parameter follows:n %gA %    o image_info: Specifies a pointer to an ImageInfo structure.  % L %    o frame: Specifies whether to include the window manager frame with the
 %      image.n %rE %    o borders: Specifies whether borders pixels are to be saved withm %      the image.  % N %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specifiedi %      window. % O %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWSnJ %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the window+= %      hierarchy and reading each subwindow and its colormap.  %  %  */: Image *ReadXImage(image_info,frame,borders,screen,descend)	 ImageInfo    *image_info;   unsigned int   frame,
   borders,	   screen, 
   descend; {m
   Colormap     *colormaps;   	   Display 
     *display;c     Imaget     *image;x     int      status,      x;     RectangleInfo      crop_info;     Window     *children,     client, 	     root,      target;      XTextProperty      window_name;     /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));(       return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Select target window.e   */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0; 4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL; 0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       {t
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename)) O           target=XWindowByID(display,root,(Window) strtol(image_info->filename,              (char **) NULL,0));+$         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);t       }    /*>     If target window is not defined, interactively select one.   */   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);    client=target;   if (target != root)      {        unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {u           if (frame)             for ( ; ; ) 
             {=               Window                 parent;                  /**                 Find window manager frame.               */K               status=XQueryTree(display,target,&root,&parent,&children,&d); K               if (!status || (parent == (Window) NULL) || (parent == root))                  break;               target=parent;:               if (status && (children != (Window *) NULL)))                 XFree((char *) children);+
             }            /*             Get client window.           *//           client=XClientWindow(display,target);            if (!frame)o             target=client;	         }      } 
   if (screen)p     {&	       int 
         y;         Window         child;         XWindowAttributes          window_attributes;         /*1         Obtain window image directly from screen.        */E       status=XGetWindowAttributes(display,target,&window_attributes);p       if (status == False)	         { M           Warning("Unable to read X window attributes",image_info->filename); !           XCloseDisplay(display);r!           return((Image *) NULL);i	         }aB       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {            /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1; @           crop_info.height+=window_attributes.border_width << 1;	         }        target=root;     }f   if (descend)     {x	       inta         number_colormaps,-         number_windows;          /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0; M       status=XGetWMColormapWindows(display,target,&children,&number_windows);%3       if ((status == True) && (number_windows > 0))%	         {%           descend=True; $           XFree ((char *) children);	         } J       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0) 	         { #           if (number_colormaps > 1)              descend=True;R$           XFree((char *) colormaps);	         }      }    /*+     Alert the user not to alter the screen.    */   XBell(display,0);    /*     Get image by window id.    */   XGrabServer(display); 8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display); 6   (void) strcpy(image->filename,image_info->filename);   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     {i<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {s           Imagem             *cropped_image;s             /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {I"               DestroyImage(image);"               image=cropped_image;
             } 	         } 5       status=XGetWMName(display,target,&window_name);e       if (status == True):	         {a8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {s               /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0'; 
             }g	         }"     }f   /*     Alert the user we're done.   */   XBell(display,0);o   XBell(display,0);l   XCloseDisplay(display);e   return(image); }n m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %fO %                                                                             % O %                                                                             % O %  R e a d X B M I m a g e                                                    %NO %                                                                             %sO %                                                                             %eO %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % K %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  It%K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %a- %  The format of the ReadXBMImage routine is:  % % %      image=ReadXBMImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadXBMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.g %  %  */& static Image *ReadXBMImage(image_info)	 ImageInfo    *image_info; {    char     data[MaxTextLength];     Image%     *image;%     int%     c;     register int     x,     y;     register RunlengthPacket     *q;e     register unsigned char     bit;     register unsigned shorts
     index;     unsigned int	     byte;      /*     Allocate image structure.a   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);t   /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      {i5       Warning("Unable to open file",image->filename);o       DestroyImage(image);       return((Image *) NULL);i     }f   /*     Read X bitmap header.e   */B   while (fgets(data,MaxTextLength-1,image->file) != (char *) NULL)=     if (sscanf(data,"#define %*32s %u",&image->columns) == 1);       break;B   while (fgets(data,MaxTextLength-1,image->file) != (char *) NULL):     if (sscanf(data,"#define %*32s %u",&image->rows) == 1)       break;   /*     Scan until {.    */   c=fgetc(image->file);    while (c != EOF)   {n     if (c == '{')        break;     c=fgetc(image->file);c   }tG   if ((image->columns == 0) || (image->rows == 0) || feof(image->file))      { G       Warning("XBM file is not in the correct format",image->filename);e       DestroyImage(image);       return((Image *) NULL);      }h   /*     Initialize image structure.m   */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)>3     malloc(image->packets*sizeof(RunlengthPacket));+0   if (image->pixels == (RunlengthPacket *) NULL)     {n7       Warning("Memory allocation error",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      }    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)     { 7       Warning("Memory allocation error",(char *) NULL);c       DestroyImage(image);       return((Image *) NULL);)     }    image->colormap[0].red=0;c   image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    /*8     Convert X bitmap image to runlength-encoded packets.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)a   {;
     bit=0;&     for (x=0; x < image->columns; x++)     {t       if (bit == 0) /         (void) fscanf(image->file,"%i,",&byte);i"       index=(byte & 0x01) ? 0 : 1;(       q->red=image->colormap[index].red;,       q->green=image->colormap[index].green;*       q->blue=image->colormap[index].blue;       q->index=index;i       q->length=0;
       q++;       bit++;       byte>>=1;        if (bit == 8)a         bit=0;     }s   }    CloseImage(image);   return(image); }t   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %fO %                                                                             % O %                                                                             %eO %  R e a d X C I m a g e                                                      %tO %                                                                             %yO %                                                                             %.O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %cG %  Function ReadXCImage creates a constant image and initializes to the H %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the new*	 %  image.; % , %  The format of the ReadXCImage routine is: %n$ %      image=ReadXCImage(image_info) %o+ %  A description of each parameter follows:) % H %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %oA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %u */% static Image *ReadXCImage(image_info)r	 ImageInfo    *image_info; {a   char     *resource_value;  	   Displaye
     *display;u     Imager     *image;      int=     x,     y;     register int     i;     register RunlengthPacket     *q;      unsigned int     height,l
     width;     XPixelInfo     pixel_info;*     XResourceInfo+     resource_info;  
   XrmDatabasef     resource_database,     server_database;     XStandardColormap(     *map_info;  
   XVisualInfol     *visual_info;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);[   /*     Open X server connection.l   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {*.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));r       DestroyImage(image);       return((Image *) NULL);a     }a   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);r   /*/     Get user defaults from X resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy");I,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display); &   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value);;8   XrmMergeDatabases(server_database,&resource_database);A   XGetResourceInfo(resource_database,client_name,&resource_info);c   /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)eM     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */C       visual_info=XBestVisualInfo(display,map_info,&resource_info);u.       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL;B     } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {lF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);/     }    /*6     Determine image color-- specified by the filename.   */$   if (*image_info->filename != '\0')8     resource_info.background_color=image_info->filename;H   XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),     map_info);K   XGetPixelInfo(display,visual_info,map_info,&resource_info,(Image *) NULL,      &pixel_info); F   pixel_info.annotate_context=XDefaultGC(display,visual_info->screen);   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);,   /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;a   image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->class=PseudoClass;    image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))     { D       Warning("Unable to allocate image","Memory allocation error");F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);      }l   /*     Initialize colormap.   */E   image->colormap[0].red=ColorShift(pixel_info.background_color.red);nI   image->colormap[0].green=ColorShift(pixel_info.background_color.green); G   image->colormap[0].blue=ColorShift(pixel_info.background_color.blue);e   q=image->pixels;$   for (i=0; i < image->packets; i++)   {-     q->index=0;      q->length=0;     q++;   }    SyncImage(image);    /*     Free resources.s   */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   return(image); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d X P M I m a g e                                                    %aO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %eK %  Function ReadXBMImage reads an X11 pixmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadXPMImage routine is:  % % %      image=ReadXPMImage(image_info), %i+ %  A description of each parameter follows:( %tI %    o image:  Function ReadXPMImage returns a pointer to the image after L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasXPMs #include "xpm.h"& static Image *ReadXPMImage(image_info)	 ImageInfop   *image_info; {    char     *resource_value,     *xpm_buffer;  	   Display;
     *display;+     Image      *image;      int      length,0     status,p     x,     y;     register char      *q;d     register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     XColor     *colors;     XImage     *matte_image,      *ximage;     XpmAttributes      xpm_attributes;      XResourceInfoi     resource_info;  
   XrmDatabase      resource_database,     server_database;     XStandardColormap      *map_info;  
   XVisualInfo.     *visual_info;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   /*     Open image file.   */   OpenImage(image,"r");-#   if (image->file == (FILE *) NULL)f     { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);      }d   /*     Read XPM file.   */   length=MaxTextLength;32   xpm_buffer=(char *) malloc(length*sizeof(char));"   if (xpm_buffer != (char *) NULL)     {        q=xpm_buffer;lC       while (fgets(q,MaxTextLength-1,image->file) != (char *) NULL)        {          q+=strlen(q);)2         if ((q-xpm_buffer+MaxTextLength) > length)           {              *q='\0';             length<<=1;t             xpm_buffer=(char *) ?               realloc((char *) xpm_buffer,length*sizeof(char)); ,             if (xpm_buffer == (char *) NULL)               break;,             q=xpm_buffer+strlen(xpm_buffer);           }a       }x     } "   if (xpm_buffer == (char *) NULL)     { E       Warning("Unable to read XPM image","Memory allocation failed");        DestroyImage(image);       return((Image *) NULL);      }    CloseImage(image);   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));        DestroyImage(image);       return((Image *) NULL);v     }e   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy"); ,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display);-&   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value);'8   XrmMergeDatabases(server_database,&resource_database);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.l   */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {)       /*         Initialize visual info.i       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;s     }m1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {sF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);m     }g   /*     Initialize X colormap.   */-   map_info->colormap=XCreateColormap(display,%A     XRootWindow(display,visual_info->screen),visual_info->visual, >     visual_info->class == DirectColor ? AllocAll : AllocNone);,   if (map_info->colormap == (Colormap) NULL)     { 9       Warning("Unable to create colormap",(char *) NULL); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    /*     Initialize XPM attributes.   */L   xpm_attributes.valuemask=XpmColorKey | XpmColormap | XpmDepth | XpmVisual;,   xpm_attributes.visual=visual_info->visual;-   xpm_attributes.colormap=map_info->colormap;%*   xpm_attributes.depth=visual_info->depth;%   xpm_attributes.color_key=XPM_COLOR;d   /*>     Read in a file in the XPM format into a X image structure.   */J   status=XpmCreateImageFromBuffer(display,xpm_buffer,&ximage,&matte_image,     &xpm_attributes);f   if (status != XpmSuccess)      { 8       Warning("Unable to read XPM image",(char *) NULL);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return((Image *) NULL);g     }t%   XpmFreeAttributes(&xpm_attributes);i   /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {n9       Warning("Unable to read X colormap",(char *) NULL); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);      }tO   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))i2     for (i=0; i < visual_info->colormap_size; i++)     {u       colors[i].pixel=i;       colors[i].pad=0;     }g   else     {N       unsigned longg
         blue,          blue_bit,f         green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0;uC       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1);iF       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       {N+         colors[i].pixel=red | green | blue;r         colors[i].pad=0;         red+=red_bit;F(         if (red > visual_info->red_mask)           red=0;         green+=green_bit;1,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit;x*         if (blue > visual_info->blue_mask)           blue=0;c       }r     }nM   XQueryColors(display,map_info->colormap,colors,visual_info->colormap_size);g   /*#     Convert X image to MIFF format.    */O   if ((visual_info->class != TrueColor) && (visual_info->class != DirectColor)),     image->class=PseudoClass;    image->columns=ximage->width;n   image->rows=ximage->height;,,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));B0   if (image->pixels == (RunlengthPacket *) NULL)     {o#       (void) free((char *) colors); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);      }f   p=image->pixels;   switch (image->class)    {      case DirectClass:i     {n       register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,o         green_mask,l         green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } )       green_mask=visual_info->green_mask;;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;i         green_shift++;       }o'       blue_mask=visual_info->blue_mask;x       blue_shift=0; %       while ((blue_mask & 0x01) == 0)i       {s         blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) &&o.           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=ColorShift(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=ColorShift(colors[index].green);;4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=ColorShift(colors[index].blue);i             p->index=0;              p->length=0;             p++;           }v	         }(
       else'         for (y=0; y < image->rows; y++)n,           for (x=0; x < image->columns; x++)           {U(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             p->red=ColorShift(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             p->green=ColorShift(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             p->blue=ColorShift(((unsigned long) color*65535)/blue_mask);             p->index=0;              p->length=0;             p++;           }        break;     }r     case PseudoClass:,     {n       /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {N'           (void) free((char *) colors);rJ           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);            XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL);x	         } '       for (i=0; i < image->colors; i++)o       {xG         image->colormap[colors[i].pixel].red=ColorShift(colors[i].red);NK         image->colormap[colors[i].pixel].green=ColorShift(colors[i].green);-I         image->colormap[colors[i].pixel].blue=ColorShift(colors[i].blue);a       }a       /*/         Convert X image to PseudoClass packets.g       */%       for (y=0; y < image->rows; y++)!*         for (x=0; x < image->columns; x++)	         {n:           p->index=(unsigned short) XGetPixel(ximage,x,y);           p->length=0;           p++;	         }        SyncImage(image);        break;     }    } %   if (matte_image != (XImage *) NULL)      {        /*         Initialize image matte.        */       image->class=DirectClass;        image->matte=True;       p=image->pixels;%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         {            p->index=Opaque;*           if (!XGetPixel(matte_image,x,y))!             p->index=Transparent;            p++;	         } !       XDestroyImage(matte_image);      } "   if (image->class == PseudoClass)     CompressColormap(image);   /*     Free resources.%   */   (void) free((char *) colors);    XDestroyImage(ximage);B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   return(image); }  #else & static Image *ReadXPMImage(image_info)	 ImageInfoi   *image_info; {e?   Warning("XPM library is not available",image_info->filename);m$   return(ReadMIFFImage(image_info)); }o #endif N /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %tO %                                                                             % O %  R e a d X W D I m a g e                                                    %eO %                                                                             %eO %                                                                             % O %                                                                             %"O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %,L %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. %(- %  The format of the ReadXWDImage routine is:l %m% %      image=ReadXWDImage(image_info)n %c+ %  A description of each parameter follows:l %mI %    o image:  Function ReadXWDImage returns a pointer to the image afternL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.e %aA %    o image_info: Specifies a pointer to an ImageInfo structure.( %g %) */& static Image *ReadXWDImage(image_info)	 ImageInfol   *image_info; {e   char     *window_name;      Image      *image;      intn     status,a     x,     y;     register int     i;     register RunlengthPacket     *q;a     register unsigned shortt
     index;     register unsigned long
     pixel;     unsigned longm     lsb_first,     packets;     XColor     *colors;     XImage     *ximage;     XWDFileHeader      header;;     /*     Allocate image structure.%   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */   OpenImage(image,"rb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        DestroyImage(image);       return((Image *) NULL);g     }    /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);    if (status == False)     { A       Warning("Unable to read dump file header",image->filename);p       DestroyImage(image);       return((Image *) NULL);      }    /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first)a5     MSBFirstOrderLong((char *) &header,sz_XWDheader);e   /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)     { B       Warning("XWD file format version mismatch",image->filename);       DestroyImage(image);       return((Image *) NULL);m     }l(   if (header.header_size < sz_XWDheader)     {r>       Warning("XWD header size is too small",image->filename);       DestroyImage(image);       return((Image *) NULL);i     }m,   packets=(header.header_size-sz_XWDheader);C   window_name=(char *) malloc((unsigned int) packets*sizeof(char));a#   if (window_name == (char *) NULL)f     {i9       Warning("Unable to allocate memory",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);t     }qD   status=ReadData((char *) window_name,1,(int) packets,image->file);   if (status == False)     { K       Warning("Unable to read window name from dump file",image->filename);l       DestroyImage(image);       return((Image *) NULL);      }n   /*     Initialize the X image.i   */+   ximage=(XImage *) malloc(sizeof(XImage));m    if (ximage == (XImage *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);e       DestroyImage(image);       return((Image *) NULL);      } $   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;    ximage->data=(char *) NULL;e$   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad; /   ximage->bytes_per_line=header.bytes_per_line;u'   ximage->byte_order=header.byte_order;c)   ximage->bitmap_unit=header.bitmap_unit;n3   ximage->bitmap_bit_order=header.bitmap_bit_order; /   ximage->bits_per_pixel=header.bits_per_pixel; #   ximage->red_mask=header.red_mask;)'   ximage->green_mask=header.green_mask;e%   ximage->blue_mask=header.blue_mask;n   status=XInitImage(ximage);   if (status == False)     {I2       Warning("Invalid XWD header",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);t     }/   /*     Read colormap.   */   colors=(XColor *) NULL;e   if (header.ncolors != 0)     {        XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor));r$       if (colors == (XColor *) NULL)	         {==           Warning("Unable to allocate memory",(char *) NULL);            DestroyImage(image);!           return((Image *) NULL);u	         } (       for (i=0; i < header.ncolors; i++)       { C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);          if (status == False)           {.O             Warning("Unable to read color map from dump file",image->filename);               DestroyImage(image);#             return((Image *) NULL);0           }c$         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first)o*         for (i=0; i < header.ncolors; i++)	         { M           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long)); O           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short));G	         }B     }    /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)     {g9       Warning("Unable to allocate memory",(char *) NULL);        DestroyImage(image);       return((Image *) NULL);      } <   status=ReadData(ximage->data,1,(int) packets,image->file);   if (status == False)     {(<       Warning("Unable to read dump pixmap",image->filename);       DestroyImage(image);       return((Image *) NULL);      }    /*!     Convert image to MIFF format.m   */   image->columns=ximage->width;    image->rows=ximage->height; ?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) || <       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;    else     image->class=PseudoClass;    image->colors=header.ncolors; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {%9       Warning("Unable to allocate memory",(char *) NULL);%       DestroyImage(image);       return((Image *) NULL);t     }e   q=image->pixels;   switch (image->class)u   {t     case DirectClass:o     {s       register unsigned long         color;         unsigned long          blue_mask,         blue_shift,m         green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {r         red_mask>>=1;a         red_shift++;       }e$       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {m         green_mask>>=1;          green_shift++;       }d"       blue_mask=ximage->blue_mask;       blue_shift=0;n%       while ((blue_mask & 0x01) == 0)0       {f         blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.t       */       if (image->colors != 0) '         for (y=0; y < image->rows; y++)t	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask);r1             q->red=ColorShift(colors[index].red);cI             index=(unsigned short) ((pixel >> green_shift) & green_mask);/5             q->green=ColorShift(colors[index].green);mG             index=(unsigned short) ((pixel >> blue_shift) & blue_mask); 3             q->blue=ColorShift(colors[index].blue);I             q->index=0;              q->length=0;             q++;           } 	         }e
       else'         for (y=0; y < image->rows; y++)*,           for (x=0; x < image->columns; x++)           {D(             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             q->red=ColorShift(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             q->green=ColorShift(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             q->blue=ColorShift(((unsigned long) color*65535)/blue_mask);             q->index=0;r             q->length=0;             q++;           }u       break;     }      case PseudoClass:)     {        /*/         Convert X image to PseudoClass packets.f       */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {==           Warning("Unable to allocate memory",(char *) NULL);            DestroyImage(image);!           return((Image *) NULL);E	         }"'       for (i=0; i < image->colors; i++)a       { 9         image->colormap[i].red=ColorShift(colors[i].red);2=         image->colormap[i].green=ColorShift(colors[i].green);a;         image->colormap[i].blue=ColorShift(colors[i].blue);e       } %       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);/           q->red=ColorShift(colors[pixel].red); 3           q->green=ColorShift(colors[pixel].green);p1           q->blue=ColorShift(colors[pixel].blue);i*           q->index=(unsigned short) pixel;           q->length=0;           q++;	         }        CompressColormap(image);       break;     }c   }a   /*     Free image and colormap.   */$   (void) free((char *) window_name);   if (header.ncolors != 0)!     (void) free((char *) colors);m   XDestroyImage(ximage);   CloseImage(image);   return(image); }g   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%NO %                                                                             % O %                                                                             % O %                                                                             %hO %  R e a d Y U V I m a g e                                                    %iO %                                                                             % O %                                                                             %mO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytes G %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %n- %  The format of the ReadYUVImage routine is:e %i% %      image=ReadYUVImage(image_info)R %p+ %  A description of each parameter follows:  %bI %    o image:  Function ReadYUVImage returns a pointer to the image after*L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.M %rA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */& static Image *ReadYUVImage(image_info)	 ImageInfo0   *image_info; {2   Image      *image,*     *zoomed_image;     intl     x,     y;     register int     i;     register RunlengthPacket     *q;+     register unsigned char     *p;>     unsigned char      *yuv_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */)   zoomed_image=AllocateImage(image_info);s%   if (zoomed_image == (Image *) NULL)o     return((Image *) NULL);    /*     Open image file.   */=   (void) strcpy(zoomed_image->filename,image_info->filename);d   OpenImage(zoomed_image,"rb");/*   if (zoomed_image->file == (FILE *) NULL)     {c<       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);>       return((Image *) NULL);=     }m   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;f(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read Y channel.t   */#   zoomed_image->columns=width >> 1; !   zoomed_image->rows=height >> 1; A   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;    yuv_pixels=(unsigned char *)7     malloc((3*(width*height)/2)*sizeof(unsigned char)); *   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));/   if ((yuv_pixels == (unsigned char *) NULL) ||D9       (zoomed_image->pixels == (RunlengthPacket *) NULL))      { 7       Warning("Memory allocation error",(char *) NULL);r!       DestroyImage(zoomed_image);i       return((Image *) NULL);c     }nC   (void) ReadData((char *) yuv_pixels,1,(int) (3*(width*height)/2),+     zoomed_image->file);   /*     Initialize U channel.    */   p=yuv_pixels+(width*height);   q=zoomed_image->pixels;>+   for (i=0; i < zoomed_image->packets; i++)    {p     q->green=(*p);     q->index=0;s     q->length=0;     p++;     q++;   }x   /*     Initialize V channel.a   */   q=zoomed_image->pixels; +   for (i=0; i < zoomed_image->packets; i++)R   {a     q->blue=(*p);      p++;     q++;   }g   /*     Scale image.   */   zoomed_image->orphan=True;    image=ZoomImage(zoomed_image);   zoomed_image->orphan=False;f   DestroyImage(zoomed_image);i   if (image == (Image *) NULL)     { A       Warning("Unable to read image","Memory allocation failed");+       return((Image *) NULL);l     }    p=yuv_pixels;    q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {      q->red=(*p);     p++;     q++;   } #   (void) free((char *) yuv_pixels); +   TransformRGBImage(image,YCbCrColorspace);r   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             % O %                                                                             %oO %                                                                             % O %  R e a d Y U V 3 I m a g e                                                  %-O %                                                                             %)O %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %nJ %  Function ReadYUV3Image reads an image with digital YUV (CCIR 601 2:1:1)M %  bytes and returns it.  It allocates the memory necessary for the new Image K %  structure and returns a pointer to the new image.  This function differsgJ %  from ReadYUVImage in that it reads the Y, U, and V planes from separate) %  files (image.Y, image.U, and image.V).c % . %  The format of the ReadYUV3Image routine is: %e& %      image=ReadYUV3Image(image_info) %g+ %  A description of each parameter follows:  %eJ %    o image:  Function ReadYUV3Image returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.- %dA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */' static Image *ReadYUV3Image(image_info)+	 ImageInfo    *image_info; {;   char     filename[MaxTextLength];     Image      *image,      *zoomed_image;     intr     x,     y;     register int     i;     register RunlengthPacket     *q;s     register unsigned char     *p;      unsigned char=     *uv_pixels,      *y_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.    */)   zoomed_image=AllocateImage(image_info); %   if (zoomed_image == (Image *) NULL)o     return((Image *) NULL);o   /*     Open image file.   *//   (void) strcpy(filename,image_info->filename); 1   (void) strcpy(zoomed_image->filename,filename);u.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".Y");    OpenImage(zoomed_image,"rb"); *   if (zoomed_image->file == (FILE *) NULL)     {i<       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);        return((Image *) NULL);x     }(   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read Y channel.    */#   zoomed_image->columns=width >> 1;c!   zoomed_image->rows=height >> 1;gA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;s   uv_pixels=(unsigned char *) 8     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL))l     {l7       Warning("Memory allocation error",(char *) NULL);i!       DestroyImage(zoomed_image);        return((Image *) NULL);x     }nB   (void) ReadData((char *) y_pixels,4,(int) zoomed_image->packets,     zoomed_image->file);   CloseImage(zoomed_image);    /*     Read U channel.    */1   (void) strcpy(zoomed_image->filename,filename);n.   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".U");    OpenImage(zoomed_image,"rb");d*   if (zoomed_image->file == (FILE *) NULL)     {i<       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);i       return((Image *) NULL);      } C   (void) ReadData((char *) uv_pixels,1,(int) zoomed_image->packets,r     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;L+   for (i=0; i < zoomed_image->packets; i++)    {      q->green=(*p);     q->index=0;      q->length=0;     p++;     q++;   }    CloseImage(zoomed_image);a   /*     Read V channel.    */1   (void) strcpy(zoomed_image->filename,filename); .   if (strcmp(zoomed_image->filename,"-") != 0)/     (void) strcat(zoomed_image->filename,".V");    OpenImage(zoomed_image,"rb");m*   if (zoomed_image->file == (FILE *) NULL)     { <       Warning("Unable to open file",zoomed_image->filename);!       DestroyImage(zoomed_image);;       return((Image *) NULL);m     }NC   (void) ReadData((char *) uv_pixels,1,(int) zoomed_image->packets,e     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;x+   for (i=0; i < zoomed_image->packets; i++)m   {n     q->blue=(*p);l     p++;     q++;   }s   CloseImage(zoomed_image); "   (void) free((char *) uv_pixels);   /*     Scale image.   */   zoomed_image->orphan=True;    image=ZoomImage(zoomed_image);   zoomed_image->orphan=False;s   DestroyImage(zoomed_image);=   if (image == (Image *) NULL)     { A       Warning("Unable to read image","Memory allocation failed");%       return((Image *) NULL);%     }%
   p=y_pixels;    q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {      q->red=(*p);     p++;     q++;   } !   (void) free((char *) y_pixels); +   TransformRGBImage(image,YCbCrColorspace); *   (void) strcpy(image->filename,filename);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   R e a d I m a g e                                                         %aO %                                                                             % O %                                                                             %RO %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %sB %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an M %  explicit image format name and a colon (i.e.  ps:image) or as the filenameT %  suffix  (i.e. image.ps).D % * %  The format of the ReadImage routine is: %t" %      image=ReadImage(image_info) % + %  A description of each parameter follows:  % E %    o image: Function ReadImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.h %kA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %_ */ Image *ReadImage(image_info)	 ImageInfo    *image_info; {    char     magic_number[12];      Imagel     decode_image,u     *image;      ImageInfom     decode_info;     SetImageMagick(image_info);    decode_info=(*image_info);   decode_image.temporary=False; K   if (!decode_info.assert || (strncmp(decode_info.magick,"IRIS",4) == 0) ||a1       (strncmp(decode_info.magick,"PCD",3) == 0))      {o       /*/         Determine type from image magic number.*       */       *magic_number='\0'; @       (void) strcpy(decode_image.filename,decode_info.filename);$       OpenImage(&decode_image,"rb");-       if (decode_image.file != (FILE *) NULL) >         if ((decode_image.file == stdin) || decode_image.pipe)           {t             FILE               *file;               int                c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename);>7             decode_info.filename=decode_image.filename;;3             file=fopen(decode_image.filename,"wb");)&             if (file == (FILE *) NULL)               {)E                 Warning("Unable to write file",decode_info.filename); '                 return((Image *) NULL);                } '             c=fgetc(decode_image.file);o             while (c != EOF)
             {-"               (void) putc(c,file);)               c=fgetc(decode_image.file); 
             }l              (void) fclose(file);&             CloseImage(&decode_image);*             OpenImage(&decode_image,"rb");           } -       if (decode_image.file != (FILE *) NULL))	         {            /*             Read magic number.           */I           (void) ReadData(magic_number,sizeof(char),sizeof(magic_number),-             decode_image.file);e:           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {(               register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */>               for (i=0; i < (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);M               (void) ReadData(magic_number,sizeof(char),sizeof(magic_number),i#                 decode_image.file); 
             }m$           CloseImage(&decode_image);	         }o       /*#         Determine the image format.>       */,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");.       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");2       if (strncmp(magic_number,"\001\332",2) == 0)1         (void) strcpy(decode_info.magick,"IRIS");,6       if (strncmp(magic_number,"\377\330\377",3) == 0)1         (void) strcpy(decode_info.magick,"JPEG");-
       else7         if ((strcmp(decode_info.magick,"JPEG") == 0) ||s4             (strcmp(decode_info.magick,"JPG") == 0))3           (void) strcpy(decode_info.magick,"MIFF"); -       if (strncmp(magic_number,"PCD",3) == 0)]0         (void) strcpy(decode_info.magick,"PCD");0       if ((unsigned char) *magic_number == 0x0a)0         (void) strcpy(decode_info.magick,"PCX");=       if ((*magic_number == 'P') && isdigit(magic_number[1]))e0         (void) strcpy(decode_info.magick,"PNM");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS"); 5       if (strncmp(magic_number,"#?RADIANCE",10) == 0) 0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");6       if ((strncmp(magic_number,"\115\115",2) == 0) ||4           (strncmp(magic_number,"\111\111",2) == 0))1         (void) strcpy(decode_info.magick,"TIFF");F5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) || 1          (strncmp(magic_number,"NJPL1I",6) == 0)) 2         (void) strcpy(decode_info.magick,"VICAR");0       if ((unsigned char) *magic_number == 0xab)1         (void) strcpy(decode_info.magick,"VIFF");a1       if (strncmp(magic_number,"#define",7) == 0)f0         (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0)o0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00))sC         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00)) E           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07))m4             (void) strcpy(decode_info.magick,"XWD");     }e   /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   {t
     case 'A':_     {t'       image=ReadAVSImage(&decode_info);i       break;     }i
     case 'B':      { '       image=ReadBMPImage(&decode_info);        break;     }.
     case 'C':      {i(       image=ReadCMYKImage(&decode_info);       break;     } 
     case 'E':e     {t&       image=ReadPSImage(&decode_info);       break;     }s
     case 'F':c     { 0       if (strcmp(decode_info.magick,"FAX") == 0))         image=ReadFAXImage(&decode_info); 
       else*         image=ReadFITSImage(&decode_info);       break;     } 
     case 'G':m     {N0       if (strcmp(decode_info.magick,"GIF") == 0))         image=ReadGIFImage(&decode_info); 
       else4         if (strcmp(decode_info.magick,"GIF87") == 0)+           image=ReadGIFImage(&decode_info);t         else5           if (strcmp(decode_info.magick,"GRAY") == 0) .             image=ReadGRAYImage(&decode_info);           else-             image=ReadFAXImage(&decode_info);m       break;     }o
     case 'H':w     { -       image=ReadHISTOGRAMImage(&decode_info);c       break;     }f
     case 'I':t     { (       image=ReadIRISImage(&decode_info);       break;     } 
     case 'J':m     {o(       image=ReadJPEGImage(&decode_info);       break;     } 
     case 'M':(     {)0       if (strcmp(decode_info.magick,"MAP") == 0))         image=ReadMAPImage(&decode_info); 
       else4         if (strcmp(decode_info.magick,"MATTE") == 0)-           image=ReadMATTEImage(&decode_info);+         else5           if (strcmp(decode_info.magick,"MIFF") == 0)g.             image=ReadMIFFImage(&decode_info);           else;             if ((strcmp(decode_info.magick,"MPEG") == 0) || 8                 (strcmp(decode_info.magick,"MPG") == 0))0               image=ReadMPEGImage(&decode_info);             else/               image=ReadMTVImage(&decode_info);p       break;     }>
     case 'N':      { (       image=ReadNULLImage(&decode_info);       break;     })
     case 'P':      { 0       if (strcmp(decode_info.magick,"PCD") == 0))         image=ReadPCDImage(&decode_info); 
       else2         if (strcmp(decode_info.magick,"PCX") == 0)+           image=ReadPCXImage(&decode_info);c         else5           if (strcmp(decode_info.magick,"PICT") == 0) .             image=ReadPICTImage(&decode_info);           else5             if (strcmp(decode_info.magick,"PM") == 0) /               image=ReadXPMImage(&decode_info);              else;               if ((strcmp(decode_info.magick,"PS") == 0) || :                   (strcmp(decode_info.magick,"PS2") == 0))0                 image=ReadPSImage(&decode_info);               else1                 image=ReadPNMImage(&decode_info);        break;     } 
     case 'R':+     { 0       if (strcmp(decode_info.magick,"RAD") == 0).         image=ReadRADIANCEImage(&decode_info);
       else2         if (strcmp(decode_info.magick,"RAS") == 0)+           image=ReadSUNImage(&decode_info);o         else4           if (strcmp(decode_info.magick,"RGB") == 0)-             image=ReadRGBImage(&decode_info);            else-             image=ReadRLEImage(&decode_info);        break;     } 
     case 'S':t     { '       image=ReadSUNImage(&decode_info);        break;     } 
     case 'T':-     {(0       if (strcmp(decode_info.magick,"TGA") == 0)+         image=ReadTARGAImage(&decode_info);e
       else6         if ((strcmp(decode_info.magick,"TIF") == 0) ||5             (strcmp(decode_info.magick,"TIFF") == 0))],           image=ReadTIFFImage(&decode_info);         else,           image=ReadTEXTImage(&decode_info);       break;     } 
     case 'V':      { 2       if (strcmp(decode_info.magick,"VICAR") == 0)+         image=ReadVICARImage(&decode_info);v
       else2         if (strcmp(decode_info.magick,"VID") == 0)           { #             if (decode_info.assert) /               image=ReadVIDImage(&decode_info);              else0               image=ReadMIFFImage(&decode_info);           }l         else,           image=ReadVIFFImage(&decode_info);       break;     }l
     case 'X':r     { .       if (strcmp(decode_info.magick,"X") == 0)>         image=ReadXImage(&decode_info,False,False,False,True);
       else1         if (strcmp(decode_info.magick,"XC") == 0)(*           image=ReadXCImage(&decode_info);         else4           if (strcmp(decode_info.magick,"XBM") == 0)-             image=ReadXBMImage(&decode_info);-           else6             if (strcmp(decode_info.magick,"XPM") == 0)/               image=ReadXPMImage(&decode_info);.             else7               if (strcmp(decode_info.magick,"XV") == 0)m2                 image=ReadVIFFImage(&decode_info);               else1                 image=ReadXWDImage(&decode_info);%       break;     }%
     case 'Y':      { 0       if (strcmp(decode_info.magick,"YUV") == 0))         image=ReadYUVImage(&decode_info); 
       else*         image=ReadYUV3Image(&decode_info);       break;     }      default:     { /       (void) strcpy(decode_info.magick,"MIFF");T(       image=ReadMIFFImage(&decode_info);     }    }    if (decode_image.temporary) (     (void) unlink(decode_info.filename);   if (image != (Image *) NULL)     {        if (image->status)K         Warning("An error has occurred reading from file",image->filename); !       if (decode_image.temporary) <         (void) strcpy(image->filename,image_info->filename);+       if (image->comments == (char *) NULL)d;         CommentImage(image,"  Imported from %m image: %f"); A       (void) strcpy(image->magick_filename,image_info->filename); +       image->magick_columns=image->columns; %       image->magick_rows=image->rows;      }    return(image); }e