 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                   E      NN  N  C      O   O  D   D  E                      % O %                   EEE    N N N  C      O   O  D   D  EEE                    % O %                   E      N  NN  C      O   O  D   D  E                      % O %                   EEEEE  N   N   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Write Image Formats                  % O %                                                                             % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "X.h" #include "compress.h"  #include "utility.h" #include "XWDFile.h"   /*   Forward declarations.  */ static unsigned int 1   WriteMIFFImage _Declare((ImageInfo *,Image *)), 0   WriteSUNImage _Declare((ImageInfo *,Image *));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e A V S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function WriteAVSImage writes an image to a file in AVS X image format. % . %  The format of the WriteAVSImage routine is: % - %      status=WriteAVSImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteAVSImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteAVSImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *avs_pixels;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*"     Initialize raster file header.   */"   avs_header.width=image->columns;    avs_header.height=image->rows;   avs_pixels=(unsigned char *)?     malloc(4*image->columns*image->rows*sizeof(unsigned char)); +   if (avs_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     } F   (void) fwrite((char *) &avs_header,sizeof(AVSHeader),1,image->file);   p=image->pixels;   q=avs_pixels; $   for (i=0; i < image->packets; i++)   { (     for (j=0; j <= (int) p->length; j++)     { 9       *q++=(unsigned char) (image->matte ? p->index : 0);        *q++=p->red;       *q++=p->green;       *q++=p->blue;      }      p++;   } H   (void) fwrite((char *) avs_pixels,4,(int)(image->columns*image->rows),     image->file);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e B M P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteBMPImage writes an image in Microsoft Windows bitmap encoded  %  image format. % . %  The format of the WriteBMPImage routine is: % - %      status=WriteBMPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteBMPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteBMPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *bmp_data,     *bmp_pixels;     unsigned int     bytes_per_line;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Initialize BMP raster file header.   */   bmp_header.file_size=14+40;    bmp_header.offset_bits=14+40;    if (!IsPseudoClass(image))     {        /*         Full color BMP raster.       */       bmp_header.bit_count=24;!       bmp_header.number_colors=0;      }    else     {        /*         Colormapped BMP raster.        */       bmp_header.bit_count=8; 5       if (IsGrayImage(image) && (image->colors == 2))          bmp_header.bit_count=1; :       bmp_header.file_size+=4*(1 << bmp_header.bit_count);<       bmp_header.offset_bits+=4*(1 << bmp_header.bit_count);9       bmp_header.number_colors=1 << bmp_header.bit_count;      }    bmp_header.reserved[0]=0;    bmp_header.reserved[1]=0;    bmp_header.size=40; "   bmp_header.width=image->columns;    bmp_header.height=image->rows;   bmp_header.planes=1;   bmp_header.compression=0; A   bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; 3   bmp_header.image_size=bytes_per_line*image->rows; .   bmp_header.file_size+=bmp_header.image_size;   bmp_header.x_pixels=75*39;   bmp_header.y_pixels=75*39;7   bmp_header.colors_important=bmp_header.number_colors;    /*&     Convert MIFF to BMP raster pixels.   */   bmp_pixels=(unsigned char *)8     malloc(bmp_header.image_size*sizeof(unsigned char));+   if (bmp_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   x=0;   y=image->rows-1;   switch (bmp_header.bit_count)    {      case 1:      {        register unsigned char         bit,
         byte,          polarity;          /*<         Convert PseudoClass image to a BMP monochrome image.       */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[1]) > Intensity(image->colormap[0]);        bit=0;
       byte=0; $       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;            }	         }          p++;       }        break;     }      case 8:      {        /*0         Convert PseudoClass packet to BMP pixel.       */$       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *q++=p->index;           x++;"           if (x == image->columns)
             {                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;
             } 	         }          p++;       }        break;     }      case 24:     {        /*4         Convert DirectClass packet to BMP RGB pixel.       */$       q=bmp_pixels+y*bytes_per_line;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *q++=p->blue;            *q++=p->green;           *q++=p->red;           x++;"           if (x == image->columns)
             {                x=0;               y--;,               q=bmp_pixels+y*bytes_per_line;
             } 	         }          p++;       }        break;     }    }     if (bmp_header.bit_count == 8)     { <       if (image->compression == RunlengthEncodedCompression)         CompressImage(image); <       if (image->compression == RunlengthEncodedCompression)	         {            unsigned int             packets;             /*5             Convert run-length encoded raster pixels.            */@           packets=(bytes_per_line*(bmp_header.height+2)+1) << 1;K           bmp_data=(unsigned char *) malloc(packets*sizeof(unsigned char)); 3           if (bmp_pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL); /               (void) free((char *) bmp_pixels);                return(False);
             }             bmp_header.image_size=K             BMPEncodeImage(bmp_pixels,bmp_data,image->columns,image->rows); +           (void) free((char *) bmp_pixels);            bmp_pixels=bmp_data;#           bmp_header.compression=1; 	         }      }    /*     Write BMP header.    */&   (void) fwrite("BM",1,2,image->file);6   LSBFirstWriteLong(bmp_header.file_size,image->file);9   LSBFirstWriteShort(bmp_header.reserved[0],image->file); 9   LSBFirstWriteShort(bmp_header.reserved[1],image->file); 8   LSBFirstWriteLong(bmp_header.offset_bits,image->file);1   LSBFirstWriteLong(bmp_header.size,image->file); 2   LSBFirstWriteLong(bmp_header.width,image->file);3   LSBFirstWriteLong(bmp_header.height,image->file); 4   LSBFirstWriteShort(bmp_header.planes,image->file);7   LSBFirstWriteShort(bmp_header.bit_count,image->file); 8   LSBFirstWriteLong(bmp_header.compression,image->file);7   LSBFirstWriteLong(bmp_header.image_size,image->file); 5   LSBFirstWriteLong(bmp_header.x_pixels,image->file); 5   LSBFirstWriteLong(bmp_header.y_pixels,image->file); :   LSBFirstWriteLong(bmp_header.number_colors,image->file);=   LSBFirstWriteLong(bmp_header.colors_important,image->file); "   if (image->class == PseudoClass)     {        unsigned char          *bmp_colormap;         /*         Dump colormap to file.       */$       bmp_colormap=(unsigned char *)D         malloc(4*(1 << bmp_header.bit_count)*sizeof(unsigned char));1       if (bmp_colormap == (unsigned char *) NULL) 	         { =           Warning("Unable to allocate memory",(char *) NULL);            return(False);	         }        q=bmp_colormap; '       for (i=0; i < image->colors; i++)        { %         *q++=image->colormap[i].blue; &         *q++=image->colormap[i].green;$         *q++=image->colormap[i].red;         q++;       } F       (void) fwrite((char *) bmp_colormap,4,1 << bmp_header.bit_count,         image->file); )       (void) free((char *) bmp_colormap);      } O   (void) fwrite((char *) bmp_pixels,1,(int) bmp_header.image_size,image->file); #   (void) free((char *) bmp_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e C M Y K I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function WriteCMYKImage writes an image to a file in cyan, magenta,' %  yellow, and black rasterfile format.  % / %  The format of the WriteCMYKImage routine is:  % . %      status=WriteCMYKImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteCMYKImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteCMYKImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    float      black_generation,      undercolor;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     black,	     cyan,      magenta,     *cmyk_pixels,      yellow;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*'     Convert MIFF to CMYK raster pixels.    */   cmyk_pixels=(unsigned char *) ?     malloc(4*image->columns*image->rows*sizeof(unsigned char)); ,   if (cmyk_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    undercolor=1.0;    black_generation=1.0; .   if (image_info->undercolor != (char *) NULL)     { ?       (void) sscanf(image_info->undercolor,"%fx%f",&undercolor,          &black_generation); "       if (black_generation == 1.0)$         black_generation=undercolor;     }    q=cmyk_pixels;    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*4         No interlacing:  CMYKCMYKCMYKCMYKCMYKCMYK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; %           *q++=cyan-undercolor*black; (           *q++=magenta-undercolor*black;'           *q++=yellow-undercolor*black; &           *q++=black_generation*black;	         }          p++;       }        break;     }      case LineInterlace:      {        register int
         x,
         y;         /*?         Line interlacing:  CCC...MMM...YYY...CCC...MMM...YYY...        */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)        { +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; %           *q++=cyan-undercolor*black;            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; (           *q++=magenta-undercolor*black;           p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; '           *q++=yellow-undercolor*black;            p++;	         } +         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; &           *q++=black_generation*black;           p++;	         }        }        break;     }      case PlaneInterlace:     {        /*@         Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; %           *q++=cyan-undercolor*black; 	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; (           *q++=magenta-undercolor*black;	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {             cyan=MaxRGB-p->red;#            magenta=MaxRGB-p->green; !            yellow=MaxRGB-p->blue;             black=cyan;            if (magenta < black)               black=magenta;             if (yellow < black)              black=yellow;(            *q++=yellow-undercolor*black;	         }          p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            cyan=MaxRGB-p->red; "           magenta=MaxRGB-p->green;            yellow=MaxRGB-p->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow; &           *q++=black_generation*black;	         }          p++;       }        break;     }    } J   (void) fwrite((char *) cmyk_pixels,4,(int) (image->columns*image->rows),     image->file); $   (void) free((char *) cmyk_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F A X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteFAXImage writes an image to a file in 1 dimensional Huffman  %  encoded format. % . %  The format of the WriteFAXImage routine is: % - %      status=WriteFAXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteFAXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteFAXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Convert MIFF to monochrome.    */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);    SyncImage(image); #   status=HuffmanEncodeImage(image);    CloseImage(image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e F I T S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteFITSImage writes a Flexible Image Transport System image to a+ %  file as gray scale intensities [0..255].  % / %  The format of the WriteFITSImage routine is:  % . %      status=WriteFITSImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteFITSImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteFITSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    char     buffer[81],      *fits_header;      register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *fits_pixels;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate image header.   */:   fits_header=(char *) malloc(2880*sizeof(unsigned char));#   if (fits_header == (char *) NULL)      { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }    /*     Initialize image header.   */   for (i=0; i < 2880; i++)     fits_header[i]=' '; 9   (void) strcpy(buffer,"SIMPLE  =                    T"); 6   (void) strncpy(fits_header+0,buffer,strlen(buffer));9   (void) strcpy(buffer,"BITPIX  =                    8"); 7   (void) strncpy(fits_header+80,buffer,strlen(buffer)); 9   (void) strcpy(buffer,"NAXIS   =                    2"); 8   (void) strncpy(fits_header+160,buffer,strlen(buffer));C   (void) sprintf(buffer,"NAXIS1  =           %10u",image->columns); 8   (void) strncpy(fits_header+240,buffer,strlen(buffer));@   (void) sprintf(buffer,"NAXIS2  =           %10u",image->rows);8   (void) strncpy(fits_header+320,buffer,strlen(buffer));:   (void) strcpy(buffer,"HISTORY Created by ImageMagick.");8   (void) strncpy(fits_header+400,buffer,strlen(buffer));   (void) strcpy(buffer,"END");8   (void) strncpy(fits_header+480,buffer,strlen(buffer));9   (void) fwrite((char *) fits_header,1,2880,image->file); $   (void) free((char *) fits_header);   /*2     Convert image to fits scale PseudoColor class.   */   fits_pixels=(unsigned char *) =     malloc(image->columns*image->rows*sizeof(unsigned char)); ,   if (fits_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=fits_pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)       *q++=Intensity(*p);      p++;   } J   (void) fwrite((char *) fits_pixels,1,(int) (image->columns*image->rows),     image->file); $   (void) free((char *) fits_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G I F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteGIFImage writes an image to a file in the Compuserve Graphics %  image format. % . %  The format of the WriteGIFImage routine is: % - %      status=WriteGIFImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteGIFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteGIFImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     x;     register RunlengthPacket     *p;      unsigned char      bits_per_pixel,      c,     *matte_image;      unsigned int     colors,      status;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     } 
   colors=256; %   matte_image=(unsigned char *) NULL;    if (image->matte)      {        /*,         Allocate and initialize matte image.       */"       if (!UncompressImage(image))         return(False);       p=image->pixels;
       x=0;#       matte_image=(unsigned char *) A         malloc(image->columns*image->rows*sizeof(unsigned char)); 0       if (matte_image == (unsigned char *) NULL)N         Warning("Unable to set transparent pixel","Memory allocation failed");
       else8         for (i=0; i < (image->columns*image->rows); i++)	         { ;           matte_image[x]=(unsigned char) (p->index & 0xff);            x++;           p++;	         }        colors--;      } @   if ((image->class == DirectClass) || (image->colors > colors))     {        /**         Demote DirectClass to PseudoClass.       */E       QuantizeImage(image,colors,8,image_info->dither,RGBColorspace);        SyncImage(image);      }    colors=image->colors; ,   if (matte_image != (unsigned char *) NULL)
     colors++; >   for (bits_per_pixel=1; bits_per_pixel < 8; bits_per_pixel++)(     if ((1 << bits_per_pixel) >= colors)       break;   /*     Write GIF header.    */)   if (strcmp(image->magick,"GIF87") == 0) ,     (void) fwrite("GIF87a",1,6,image->file);   else,     (void) fwrite("GIF89a",1,6,image->file);1   LSBFirstWriteShort(image->columns,image->file); .   LSBFirstWriteShort(image->rows,image->file);    c=0x80;  /* global colormap */(   c|=(8-1) << 4;  /* color resolution */8   c|=(bits_per_pixel-1);   /* size of global colormap */%   (void) fputc((char) c,image->file); 8   (void) fputc(0x0,image->file);  /* background color */0   (void) fputc(0x0,image->file);  /* reserved */   /*     Write colormap.    */#   for (i=0; i < image->colors; i++)    { <     (void) fputc((char) image->colormap[i].red,image->file);>     (void) fputc((char) image->colormap[i].green,image->file);=     (void) fputc((char) image->colormap[i].blue,image->file);    } /   for ( ; i < (int) (1 << bits_per_pixel); i++)    { "     (void) fputc(0x0,image->file);"     (void) fputc(0x0,image->file);"     (void) fputc(0x0,image->file);   } )   if (strcmp(image->magick,"GIF87") != 0)      { 0       if (matte_image != (unsigned char *) NULL)#         if (UncompressImage(image))            {              /*>               Write out extension for transparent color index.             */+             (void) fputc(0x21,image->file); +             (void) fputc(0xf9,image->file); *             (void) fputc(0x4,image->file);*             (void) fputc(0x1,image->file);*             (void) fputc(0x0,image->file);*             (void) fputc(0x0,image->file);;             (void) fputc((char) image->colors,image->file); *             (void) fputc(0x0,image->file);             /*D               Set transparent pixels to the transparent color index.             */             x=0;             p=image->pixels;<             for (i=0; i < (image->columns*image->rows); i++)
             { 0               if (matte_image[x] == Transparent)'                 p->index=image->colors;                x++;               p++;
             } .             (void) free((char *) matte_image);           } +       if (image->comments != (char *) NULL) 	         {            register char              *p;              register unsigned int              count;             /**             Write comment extension block.           */)           (void) fputc(0x21,image->file); )           (void) fputc(0xfe,image->file);            p=image->comments;%           while ((int) strlen(p) > 0)            { +             count=Min((int) strlen(p),255); ,             (void) fputc(count,image->file);%             for (i=0; i < count; i++) -               (void) fputc(*p++,image->file);            } (           (void) fputc(0x0,image->file);	         }      } 7   (void) fputc(',',image->file);  /* image separator */    /*     Write the image header.    */$   LSBFirstWriteShort(0,image->file);$   LSBFirstWriteShort(0,image->file);1   LSBFirstWriteShort(image->columns,image->file); .   LSBFirstWriteShort(image->rows,image->file);    (void) fputc(0x0,image->file);   c=Max(bits_per_pixel,2);%   (void) fputc((char) c,image->file); 7   status=LZWEncodeImage(image,Max(bits_per_pixel,2)+1);    if (status == False)     { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }     (void) fputc(0x0,image->file);1   (void) fputc(';',image->file); /* terminator */    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteGRAYImage writes an image to a file as gray scale intensity %  values [0..255].  % / %  The format of the WriteGRAYImage routine is:  % . %      status=WriteGRAYImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteGRAYImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *gray_pixels;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*2     Convert image to gray scale PseudoColor class.   */   gray_pixels=(unsigned char *) =     malloc(image->columns*image->rows*sizeof(unsigned char)); ,   if (gray_pixels == (unsigned char *) NULL)     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=gray_pixels;$   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)       *q++=Intensity(*p);      p++;   } J   (void) fwrite((char *) gray_pixels,1,(int) (image->columns*image->rows),     image->file); $   (void) free((char *) gray_pixels);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H I S T O G R A M I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteHISTOGRAMImage writes an image to a file in HISTOGRAM format.K %  A list of unique pixel values and the number of times each occurs in the   %  image is written to the file. % 4 %  The format of the WriteHISTOGRAMImage routine is: % 3 %      status=WriteHISTOGRAMImage(image_info,image)  % + %  A description of each parameter follows.  % P %    o status: Function WriteHISTOGRAMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */9 static unsigned int WriteHISTOGRAMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     } "   NumberColors(image,image->file);   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e I R I S I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteIRISImage writes an image in SGI RGB encoded image format.  % / %  The format of the WriteIRISImage routine is:  % . %      status=WriteIRISImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteIRISImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  + static int IRISEncode(pixels,count,packets) 
 unsigned char 
   *pixels;   int    count;  
 unsigned char    *packets;  {    short      runlength;     unsigned char      *limit, 
     *mark,     *p,      *q;      p=pixels;    limit=p+count*4;   q=packets;   while (p < limit)    {      mark=p; 	     p+=8; A     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))        p+=4; 	     p-=8;      count=((p-mark) >> 2);     while (count)      { *       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)        {          *q++=(*mark);          mark+=4;       }      }      mark=p; 	     p+=4; (     while ((p < limit) && (*p == *mark))       p+=4;      count=((p-mark) >> 2);     while (count)      { *       runlength=count > 126 ? 126 : count;       count-=runlength;        *q++=runlength;        *q++=(*mark);      }    } 	   *q++=0;    return(q-packets); }   4 static unsigned int WriteIRISImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _IRISHeader   {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } IRISHeader;      IRISHeader     iris_header;     register int     i,     j,     x,     y,     z;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *iris_pixels, 
     *packets;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*'     Initialize IRIS raster file header.    */   iris_header.magic=0x01DA; *   if (image->compression == NoCompression)     iris_header.storage=0x00;    else     iris_header.storage=0x01; :   iris_header.bytes_per_pixel=1;  /* one byte per pixel */   iris_header.dimension=3;%   iris_header.columns=image->columns;    iris_header.rows=image->rows; )   iris_header.depth=image->matte ? 4 : 3; :   if ((image->class == PseudoClass) && IsGrayImage(image))     {        iris_header.dimension=2;       iris_header.depth=1;     }    iris_header.minimum_value=0;#   iris_header.maximum_value=MaxRGB; 0   for (i=0; i < sizeof(iris_header.filler); i++)     iris_header.filler[i]=0;   /*     Write IRIS header.   */4   MSBFirstWriteShort(iris_header.magic,image->file);0   (void) fputc(iris_header.storage,image->file);8   (void) fputc(iris_header.bytes_per_pixel,image->file);8   MSBFirstWriteShort(iris_header.dimension,image->file);6   MSBFirstWriteShort(iris_header.columns,image->file);3   MSBFirstWriteShort(iris_header.rows,image->file); 4   MSBFirstWriteShort(iris_header.depth,image->file);;   MSBFirstWriteLong(iris_header.minimum_value,image->file); ;   MSBFirstWriteLong(iris_header.maximum_value,image->file); M   (void) fwrite(iris_header.filler,1,sizeof(iris_header.filler),image->file);    /*     Allocate IRIS pixels.    */   iris_pixels=(unsigned char *) ?     malloc(4*image->columns*image->rows*sizeof(unsigned char)); ,   if (iris_pixels == (unsigned char *) NULL)     { 9       Warning("Memory allocation error",image->filename);        return(False);     }    /*B     Convert runlength-encoded packets to uncompressed IRIS pixels.   */   x=0;   y=0;   p=image->pixels;=   q=iris_pixels+(iris_header.rows-1)*(iris_header.columns*4); $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        *q++=p->red;       *q++=p->green;       *q++=p->blue; $       *q++=(unsigned char) p->index;
       x++;       if (x == image->columns)	         {            y++;I           q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4);            x=0;	         }      }      p++;   } *   if (image->compression == NoCompression)     {        unsigned char          *scanline;         /*'         Write uncompressed IRIS pixels.        */        scanline=(unsigned char *):         malloc(iris_header.columns*sizeof(unsigned char));-       if (scanline == (unsigned char *) NULL) 	         { =           Warning("Memory allocation error",image->filename);            return(False);	         } 1       for (z=0; z < (int) iris_header.depth; z++)        {          q=iris_pixels+z;2         for (y=0; y < (int) iris_header.rows; y++)	         { 7           for (x=0; x < (int) iris_header.columns; x++)            {              scanline[x]=(*q);              q+=4;            } K           (void) fwrite(scanline,sizeof(unsigned char),iris_header.columns,              image->file); 	         }        }        (void) free(scanline);     }    else     {        unsigned long          length,          number_packets,          offset,          *offsets,          *runlength;          /*E         Convert IRIS uncompressed pixels to runlength-encoded pixels.        */       offsets=(unsigned long *) I         malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); I       packets=(unsigned char *) malloc(4*((iris_header.columns << 1)+10)* +         image->rows*sizeof(unsigned char)); !       runlength=(unsigned long *) I         malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long)); 0       if ((offsets == (unsigned long *) NULL) ||0           (packets == (unsigned char *) NULL) ||0           (runlength == (unsigned long *) NULL))	         { =           Warning("Memory allocation error",image->filename);            return(False);	         } ?       offset=512+4*((iris_header.rows*iris_header.depth) << 1);        number_packets=0;        q=iris_pixels;0       for (y=0; y < (int) iris_header.rows; y++)       { 3         for (z=0; z < (int) iris_header.depth; z++) 	         {            length= M             IRISEncode(q+z,(int) iris_header.columns,packets+number_packets); !           number_packets+=length; /           offsets[y+z*iris_header.rows]=offset; 1           runlength[y+z*iris_header.rows]=length;            offset+=length; 	         } #         q+=(iris_header.columns*4);        }        /*L         Write out line start and length tables and runlength-encoded pixels.       */D       for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)2         MSBFirstWriteLong(offsets[i],image->file);D       for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)4         MSBFirstWriteLong(runlength[i],image->file);N       (void) fwrite(packets,sizeof(unsigned char),number_packets,image->file);       /*         Free memory.       */       (void) free(runlength);        (void) free(packets);        (void) free(offsets);      }    (void) free(iris_pixels);    CloseImage(image);   return(True);  }    #ifdef HasJPEG #include "jpeglib.h" #include "jerror.h"    static Image	   *image;  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % / %  The format of the WriteJPEGImage routine is:  % . %      status=WriteJPEGImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  ( static void EmitMessage(jpeg_info,level) j_common_ptr   jpeg_info;   int    level; {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { H       if (jpeg_error->num_warnings == 0 || jpeg_error->trace_level >= 3)2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 	   JSAMPLE      *jpeg_pixels,      **scanlines;     register int     i,     j;     register JSAMPLE     *q;      register RunlengthPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int
     count,     packets;     /*     Open image file.   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;#   jpeg_create_compress(&jpeg_info); *   jpeg_stdio_dest(&jpeg_info,image->file);'   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB;    if (IsGrayImage(image))      { #       jpeg_info.input_components=1; -       jpeg_info.in_color_space=JCS_GRAYSCALE;      }     jpeg_set_defaults(&jpeg_info);8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True;  #ifdef DCT_FLOAT_SUPPORTED"   jpeg_info.dct_method=JDCT_FLOAT; #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) :     for (i=0; i < (int) strlen(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,C         (unsigned int) Min((int) strlen(image->comments+i),65533));    /*'     Convert MIFF to JPEG raster pixels.    */@   packets=jpeg_info.input_components*image->columns*image->rows;:   jpeg_pixels=(JSAMPLE *) malloc(packets*sizeof(JSAMPLE));?   scanlines=(JSAMPLE **) malloc(image->rows*sizeof(JSAMPLE *)); L   if ((jpeg_pixels == (JSAMPLE *) NULL) || (scanlines == (JSAMPLE **) NULL))     { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }    p=image->pixels;   q=jpeg_pixels;#   if (jpeg_info.data_precision > 8)      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)0             *q++=(JSAMPLE) (Intensity(*p) << 4);           p++;	         } 
       else*         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           { )             *q++=(JSAMPLE) (p->red << 4); +             *q++=(JSAMPLE) (p->green << 4); *             *q++=(JSAMPLE) (p->blue << 4);           }            p++;	         }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)'           *q++=(JSAMPLE) Intensity(*p);          p++;       }      else(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {             *q++=(JSAMPLE) p->red;"           *q++=(JSAMPLE) p->green;!           *q++=(JSAMPLE) p->blue; 	         }          p++;       }    /*     Write JPEG raster pixels.    */!   for (i=0; i < image->rows; i++) K     scanlines[i]=jpeg_pixels+(i*image->columns*jpeg_info.input_components); &   for (i=0; i < image->rows; i+=count)E     count=jpeg_write_scanlines(&jpeg_info,scanlines+i,image->rows-i); #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */"   (void) free((char *) scanlines);$   (void) free((char *) jpeg_pixels);$   jpeg_destroy_compress(&jpeg_info);   CloseImage(image);   return(True);  }  #else 4 static unsigned int WriteJPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   ;   Warning("JPEG library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A P I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMAPImage writes an image to a file as red, green, and blue 3 %  colormap bytes followed by the colormap indexes.  % . %  The format of the WriteMAPImage routine is: % - %      status=WriteMAPImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMAPImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMAPImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     register unsigned char     *q;      unsigned char      *colormap;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate colormap.   */"   if (image->class == DirectClass)     {        /**         Demote DirectClass to PseudoClass.       */N       QuantizeImage(image,MaxColormapSize,8,image_info->dither,RGBColorspace);       SyncImage(image);      } K   colormap=(unsigned char *) malloc(3*image->colors*sizeof(unsigned char)); )   if (colormap == (unsigned char *) NULL)      { B       Warning("Unable to write image","Memory allocation failed");       return(False);     }    /*     Write colormap to file.    */
   q=colormap; #   for (i=0; i < image->colors; i++)    {       *q++=image->colormap[i].red;"     *q++=image->colormap[i].green;!     *q++=image->colormap[i].blue;    } E   (void) fwrite((char *) colormap,3,(int) image->colors,image->file); !   (void) free((char *) colormap);    /*     Write image pixels to file.    */#   image->compression=NoCompression; %   (void) RunlengthEncodeImage(image); G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size, &     (int) image->packets,image->file);-   (void) free((char *) image->packed_pixels); .   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M A T T E I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WriteMATTEImage writes an mage of matte bytes to a file.  ItC %  consists of data from the matte component of the image [0..255].  % 0 %  The format of the WriteMATTEImage routine is: % / %      status=WriteMATTEImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteMATTEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */5 static unsigned int WriteMATTEImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *matte_pixels;     if (!image->matte)     { E       Warning("Image does not have a matte channel",image->filename);        return(False);     }    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate matte pixels.   */    matte_pixels=(unsigned char *)=     malloc(image->columns*image->rows*sizeof(unsigned char)); -   if (matte_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=matte_pixels; $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)$       *q++=(unsigned char) p->index;     p++;   } K   (void) fwrite((char *) matte_pixels,1,(int) (image->columns*image->rows),      image->file); %   (void) free((char *) matte_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 5 %  Function WriteMIFFImage writes an image to a file.  % / %  The format of the WriteMIFFImage routine is:  % . %      status=WriteMIFFImage(image_info,image) % + %  A description of each parameter follows:  % K %    o status: Function WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */4 static unsigned int WriteMIFFImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i;     unsigned long      packets;  E   if ((image->class != DirectClass) && (image->class != PseudoClass))      { =       Warning("Unable to write image","unknown image class");        return(False);     } <   if ((image->compression != RunlengthEncodedCompression) &&4       (image->compression != QEncodedCompression) &&,       (image->compression != NoCompression))     { C       Warning("Unable to write image","unknown image compression");        return(False);     }    /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     } &   (void) strcpy(image->magick,"MIFF");   /*     Pack image pixels.   */J   if (IsPseudoClass(image) && (image->compression == QEncodedCompression))     image->class=DirectClass; %   (void) RunlengthEncodeImage(image);    packets=image->packets; 0   if (image->compression == QEncodedCompression)     {        unsigned char          *compressed_pixels;          /*.         Compress image pixels with Q encoding.       */)       compressed_pixels=(unsigned char *) P         malloc((unsigned int) packets*image->packet_size*sizeof(unsigned char));6       if (compressed_pixels == (unsigned char *) NULL)	         { F           Warning("Unable to write image","Memory allocation failed");           return(False);	         } B       packets=QEncodeImage(image->packed_pixels,compressed_pixels,=         image->columns*(int) image->packet_size,image->rows); 1       (void) free((char *) image->packed_pixels); -       image->packed_pixels=compressed_pixels;        image->packet_size=1;      } "   if (image->class == PseudoClass)     ColormapSignature(image);    /*     Write header to file.    */'   if (image->comments != (char *) NULL) =     (void) fprintf(image->file,"{\n%s\n}\n",image->comments); 1   (void) fprintf(image->file,"id=ImageMagick\n"); "   if (image->class == PseudoClass)N     (void) fprintf(image->file,"class=PseudoClass  colors=%u  signature=%s\n",&       image->colors,image->signature);   else     if (image->matte) D       (void) fprintf(image->file,"class=DirectClass  matte=True\n");     else8       (void) fprintf(image->file,"class=DirectClass\n");8   if (image->compression == RunlengthEncodedCompression)M     (void) fprintf(image->file,"compression=RunlengthEncoded  packets=%lu\n",        packets);    else2     if (image->compression == QEncodedCompression)P       (void) fprintf(image->file,"compression=QEncoded  packets=%lu\n",packets);D   (void) fprintf(image->file,"columns=%u  rows=%u\n",image->columns,     image->rows);    if (image->scene != 0):     (void) fprintf(image->file,"scene=%u\n",image->scene);&   if (image->montage != (char *) NULL)>     (void) fprintf(image->file,"montage=%s\n",image->montage);(   (void) fprintf(image->file,"\f\n:\n");&   if (image->montage != (char *) NULL)     {        /*%         Write montage tile directory.        */,       if (image->directory != (char *) NULL):         (void) fprintf(image->file,"%s",image->directory);%       (void) fputc('\0',image->file);      } "   if (image->class == PseudoClass)     {        register unsigned char         *q;          unsigned char          *colormap;         /*         Allocate colormap.       */O       colormap=(unsigned char *) malloc(3*image->colors*sizeof(unsigned char)); -       if (colormap == (unsigned char *) NULL) 	         { F           Warning("Unable to write image","Memory allocation failed");           return(False);	         }        q=colormap; '       for (i=0; i < image->colors; i++)        { $         *q++=image->colormap[i].red;&         *q++=image->colormap[i].green;%         *q++=image->colormap[i].blue;        }        /*         Write colormap to file.        */I       (void) fwrite((char *) colormap,3,(int) image->colors,image->file); %       (void) free((char *) colormap);      }    /*     Write image pixels to file.    */G   (void) fwrite((char *) image->packed_pixels,(int) image->packet_size,      (int) packets,image->file); -   (void) free((char *) image->packed_pixels); .   image->packed_pixels=(unsigned char *) NULL;   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M P E G I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteMPEGImage writes an image in the MPEG encoded image format. % / %  The format of the WriteMPEGImage routine is:  % . %      status=WriteMPEGImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteMPEGImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteMPEGImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   6   Warning("Cannot write MPEG images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % . %  The format of the WriteMTVImage routine is: % - %      status=WriteMTVImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteMTVImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *mtv_pixels;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Convert MIFF to MTV raster pixels.   */   mtv_pixels=(unsigned char *)?     malloc(3*image->columns*image->rows*sizeof(unsigned char)); +   if (mtv_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=mtv_pixels; $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {        *q++=p->red;       *q++=p->green;       *q++=p->blue;      }      p++;   } C   (void) fprintf(image->file,"%u %u\n",image->columns,image->rows); I   (void) fwrite((char *) mtv_pixels,3,(int) (image->columns*image->rows),      image->file); #   (void) free((char *) mtv_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePCDImage writes an image in the Photo CD encoded image 
 %  format. % . %  The format of the WritePCDImage routine is: % - %      status=WritePCDImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCDImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   5   Warning("Cannot write PCD images",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P C X I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WritePCXImage writes an image in the ZSoft IBM PC Paintbrush file 
 %  format. % . %  The format of the WritePCXImage routine is: % - %      status=WritePCXImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePCXImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePCXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    typedef struct _PCXHeader    {      unsigned char        identifier,        version,       encoding,        bits_per_pixel;   
     short int        left, 
       top,       right,
       bottom,        horizontal_resolution,       vertical_resolution;       unsigned char        reserved, 
       planes;   
     short int        bytes_per_line,        palette_info;        unsigned char        colormap_signature;    } PCXHeader;     PCXHeader      pcx_header;      register int     i,     j,     x,     y;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char 
     count,     packet,      *pcx_colormap,     *pcx_pixels,
     previous;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*&     Initialize PCX raster file header.   */=   if ((image->class == DirectClass) || (image->colors > 256))      {        /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);      }    pcx_header.identifier=0x0a;    pcx_header.version=5;    pcx_header.encoding=1;   pcx_header.bits_per_pixel=8;1   if (IsGrayImage(image) && (image->colors == 2))       pcx_header.bits_per_pixel=1;   pcx_header.left=0;   pcx_header.top=0; $   pcx_header.right=image->columns-1;"   pcx_header.bottom=image->rows-1;2   pcx_header.horizontal_resolution=image->columns;-   pcx_header.vertical_resolution=image->rows;    pcx_header.reserved=0;   pcx_header.planes=1;K   pcx_header.bytes_per_line=(image->columns*pcx_header.bits_per_pixel+7)/8;    pcx_header.palette_info=1;%   pcx_header.colormap_signature=0x0c;    /*     Write PCX header.    */8   (void) fwrite(&pcx_header.identifier,1,1,image->file);5   (void) fwrite(&pcx_header.version,1,1,image->file); 6   (void) fwrite(&pcx_header.encoding,1,1,image->file);<   (void) fwrite(&pcx_header.bits_per_pixel,1,1,image->file);A   LSBFirstWriteShort((unsigned int) pcx_header.left,image->file); @   LSBFirstWriteShort((unsigned int) pcx_header.top,image->file);B   LSBFirstWriteShort((unsigned int) pcx_header.right,image->file);C   LSBFirstWriteShort((unsigned int) pcx_header.bottom,image->file); E   LSBFirstWriteShort((unsigned int) pcx_header.horizontal_resolution,      image->file); P   LSBFirstWriteShort((unsigned int) pcx_header.vertical_resolution,image->file);   /*     Dump colormap to file.   */E   pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); -   if (pcx_colormap == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    q=pcx_colormap; #   for (i=0; i < image->colors; i++)    {       *q++=image->colormap[i].red;"     *q++=image->colormap[i].green;!     *q++=image->colormap[i].blue;    } 8   (void) fwrite((char *) pcx_colormap,3,16,image->file);6   (void) fwrite(&pcx_header.reserved,1,1,image->file);4   (void) fwrite(&pcx_header.planes,1,1,image->file);K   LSBFirstWriteShort((unsigned int) pcx_header.bytes_per_line,image->file); I   LSBFirstWriteShort((unsigned int) pcx_header.palette_info,image->file);    for (i=0; i < 58; i++)(     (void) fwrite("\0",1,1,image->file);   /*&     Convert MIFF to PCX raster pixels.   */   pcx_pixels=(unsigned char *)H     malloc(pcx_header.bytes_per_line*image->rows*sizeof(unsigned char));+   if (pcx_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    x=0;   y=0;   p=image->pixels;   q=pcx_pixels; $   if (pcx_header.bits_per_pixel > 1)&     for (i=0; i < image->packets; i++)     { *       for (j=0; j <= (int) p->length; j++)       {          *q++=p->index;         x++;          if (x == image->columns)           {              x=0;             y++;5             q=pcx_pixels+y*pcx_header.bytes_per_line;            }        } 
       p++;     }    else     {        register unsigned char         bit,
         byte,          polarity;          /*<         Convert PseudoClass image to a PCX monochrome image.       */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;               y++;7               q=pcx_pixels+y*pcx_header.bytes_per_line;             }	         }          p++;       }      }    /*!     Runlength-encoded PCX pixels.    */!   for (y=0; y < image->rows; y++)    { -     q=pcx_pixels+y*pcx_header.bytes_per_line;      previous=(*q++);     count=1;5     for (x=0; x < (pcx_header.bytes_per_line-1); x++)      {        packet=(*q++);/       if ((packet == previous) && (count < 63)) 	         {            count++;           continue; 	         } 5       if ((count > 1) || ((previous & 0xc0) == 0xc0)) 	         {            count|=0xc0;0           (void) fwrite(&count,1,1,image->file);	         } /       (void) fwrite(&previous,1,1,image->file);        previous=packet;       count=1;     } 3     if ((count > 1) || ((previous & 0xc0) == 0xc0))        {          count|=0xc0;.         (void) fwrite(&count,1,1,image->file);       } -     (void) fwrite(&previous,1,1,image->file);    }    if (image->colors > 16)      { D       (void) fwrite(&pcx_header.colormap_signature,1,1,image->file);=       (void) fwrite((char *) pcx_colormap,3,256,image->file);      } #   (void) free((char *) pcx_pixels); %   (void) free((char *) pcx_colormap);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P I C T I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WritePICTImage writes an image to a file in the Apple Macintosh  %  QuickDraw/PICT image format.  % / %  The format of the WritePICTImage routine is:  % . %      status=WritePICTImage(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WritePICTImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WritePICTImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {  #define MaxCount  128  #define PictCropRegionOp  0x01  #define PictEndOfPictureOp  0xff #define PictHeaderOp  0x0C00 #define PictHeaderSize  512  #define PictPixmapOp  0x9A #define PictPackbitsOp  0x98 #define PictVersion  0x11      typedef struct _PICTRectangle    {      unsigned short
       top,       left, 
       bottom,        right;   } PICTRectangle;     typedef struct _PICTPixmap   {      unsigned short       base_address,        row_bytes;       PICTRectangle 
       bounds;        unsigned short       version,       pack_type;       unsigned long        pack_size,       horizontal_resolution,       vertical_resolution;       unsigned short       pixel_type,        pixel_size,        component_count,       component_size;        unsigned short       plane_bytes,       table,       reserved;    } PICTPixmap;      int 
     count;     PICTPixmap     pixmap;      PICTRectangle      crop_rectangle,      destination_rectangle,     frame_rectangle,     size_rectangle,      source_rectangle;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *buffer,     *packed_scanline,      *scanline;     unsigned int     bytes_per_line;      unsigned short     transfer_mode;     unsigned long      horizontal_resolution,     vertical_resolution;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Allocate memory.   */    bytes_per_line=image->columns;"   if (image->class == DirectClass)     bytes_per_line*=3;H   buffer=(unsigned char *) malloc(PictHeaderSize*sizeof(unsigned char));#   packed_scanline=(unsigned char *) M     malloc((bytes_per_line+bytes_per_line/MaxCount+1)*sizeof(unsigned char)); J   scanline=(unsigned char *) malloc(bytes_per_line*sizeof(unsigned char));+   if ((buffer == (unsigned char *) NULL) || 4       (packed_scanline == (unsigned char *) NULL) ||+       (scanline == (unsigned char *) NULL))      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    /*     Initialize image info.   */   size_rectangle.top=0;    size_rectangle.left=0;#   size_rectangle.right=image->rows; '   size_rectangle.bottom=image->columns; !   frame_rectangle=size_rectangle;     crop_rectangle=size_rectangle;"   source_rectangle=size_rectangle;'   destination_rectangle=size_rectangle; #   horizontal_resolution=0x00480000; !   vertical_resolution=0x00480000;    pixmap.base_address=0xff;    pixmap.row_bytes= D     ((image->class == DirectClass ? 4 : 1)*image->columns) | 0x8000;   pixmap.version=0;    pixmap.bounds.top=0;   pixmap.bounds.left=0; "   pixmap.bounds.right=image->rows;&   pixmap.bounds.bottom=image->columns;=   pixmap.pack_type=(image->class == DirectClass ? 0x4 : 0x0);    pixmap.pack_size=0; 5   pixmap.horizontal_resolution=horizontal_resolution; 1   pixmap.vertical_resolution=vertical_resolution; ;   pixmap.pixel_type=(image->class == DirectClass ? 16 : 0); ;   pixmap.pixel_size=(image->class == DirectClass ? 32 : 8); ?   pixmap.component_count=(image->class == DirectClass ? 3 : 1);    pixmap.component_size=8;   pixmap.plane_bytes=0;    pixmap.table=0;    pixmap.reserved=0;9   transfer_mode=(image->class == DirectClass ? 0x40 : 0);    /*H     Write header, header size, size bounding box, version, and reserved.   */$   for (i=0; i < PictHeaderSize; i++)     buffer[i]=0;>   (void) fwrite((char *) buffer,1,PictHeaderSize,image->file);$   MSBFirstWriteShort(0,image->file);5   MSBFirstWriteShort(size_rectangle.top,image->file); 6   MSBFirstWriteShort(size_rectangle.left,image->file);7   MSBFirstWriteShort(size_rectangle.right,image->file); 8   MSBFirstWriteShort(size_rectangle.bottom,image->file);.   MSBFirstWriteShort(PictVersion,image->file);)   MSBFirstWriteShort(0x02FF,image->file); /   MSBFirstWriteShort(PictHeaderOp,image->file);    /*N     Write full size of the file, resolution, frame bounding box, and reserved.   */-   MSBFirstWriteLong(0xFFFE0000L,image->file); 7   MSBFirstWriteLong(horizontal_resolution,image->file); 5   MSBFirstWriteLong(vertical_resolution,image->file); 6   MSBFirstWriteShort(frame_rectangle.top,image->file);7   MSBFirstWriteShort(frame_rectangle.left,image->file); 8   MSBFirstWriteShort(frame_rectangle.right,image->file);9   MSBFirstWriteShort(frame_rectangle.bottom,image->file); $   MSBFirstWriteLong(0L,image->file);   /*3     Write crop region opcode and crop bounding box.    */3   MSBFirstWriteShort(PictCropRegionOp,image->file); &   MSBFirstWriteShort(0xA,image->file);5   MSBFirstWriteShort(crop_rectangle.top,image->file); 6   MSBFirstWriteShort(crop_rectangle.left,image->file);7   MSBFirstWriteShort(crop_rectangle.right,image->file); 8   MSBFirstWriteShort(crop_rectangle.bottom,image->file);   /*K     Write picture opcode, row bytes, and picture bounding box, and version.    */"   if (image->class == PseudoClass)3     MSBFirstWriteShort(PictPackbitsOp,image->file);    else     { 3       MSBFirstWriteShort(PictPixmapOp,image->file); I       MSBFirstWriteLong((unsigned long) pixmap.base_address,image->file);      }    if (pixmap.row_bytes & 0x01)     pixmap.row_bytes++; <   MSBFirstWriteShort(pixmap.row_bytes | 0x8000,image->file);4   MSBFirstWriteShort(pixmap.bounds.top,image->file);5   MSBFirstWriteShort(pixmap.bounds.left,image->file); 6   MSBFirstWriteShort(pixmap.bounds.right,image->file);7   MSBFirstWriteShort(pixmap.bounds.bottom,image->file); 1   MSBFirstWriteShort(pixmap.version,image->file);    /*G     Write pack type, pack size, resolution, pixel type, and pixel size.    */3   MSBFirstWriteShort(pixmap.pack_type,image->file); 2   MSBFirstWriteLong(pixmap.pack_size,image->file);>   MSBFirstWriteLong(pixmap.horizontal_resolution,image->file);<   MSBFirstWriteLong(pixmap.vertical_resolution,image->file);4   MSBFirstWriteShort(pixmap.pixel_type,image->file);4   MSBFirstWriteShort(pixmap.pixel_size,image->file);   /*G     Write component count, size, plane bytes, table size, and reserved.    */9   MSBFirstWriteShort(pixmap.component_count,image->file); 8   MSBFirstWriteShort(pixmap.component_size,image->file);D   MSBFirstWriteLong((unsigned long) pixmap.plane_bytes,image->file);>   MSBFirstWriteLong((unsigned long) pixmap.table,image->file);A   MSBFirstWriteLong((unsigned long) pixmap.reserved,image->file); "   if (image->class == PseudoClass)     {        unsigned short         red,         green,
         blue;          /*         Write image colormap.        */:       MSBFirstWriteLong(0L,image->file);  /* color seed */<       MSBFirstWriteShort(0L,image->file);  /* color flags */I       MSBFirstWriteShort((unsigned short) (image->colors-1),image->file); '       for (i=0; i < image->colors; i++)        { A         red=(image->colormap[i].red*65535)/(unsigned int) MaxRGB; E         green=(image->colormap[i].green*65535)/(unsigned int) MaxRGB; C         blue=(image->colormap[i].blue*65535)/(unsigned int) MaxRGB; 9         MSBFirstWriteShort((unsigned int) i,image->file); ,         MSBFirstWriteShort(red,image->file);.         MSBFirstWriteShort(green,image->file);-         MSBFirstWriteShort(blue,image->file);        }      }    /*+     Write source and destination rectangle.    */7   MSBFirstWriteShort(source_rectangle.top,image->file); 8   MSBFirstWriteShort(source_rectangle.left,image->file);9   MSBFirstWriteShort(source_rectangle.right,image->file); :   MSBFirstWriteShort(source_rectangle.bottom,image->file);<   MSBFirstWriteShort(destination_rectangle.top,image->file);=   MSBFirstWriteShort(destination_rectangle.left,image->file); >   MSBFirstWriteShort(destination_rectangle.right,image->file);?   MSBFirstWriteShort(destination_rectangle.bottom,image->file); 0   MSBFirstWriteShort(transfer_mode,image->file);   /*     Write picture data.    */
   count=0;   x=0;   p=image->pixels;"   if (image->class == PseudoClass)     {        register unsigned char         *index;          index=scanline; (       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         { ,           *index++=(unsigned char) p->index;           x++;"           if (x == image->columns)
             { I               count+=PackbitsEncodeImage(image,scanline,packed_scanline);                index=scanline;                x=0;
             } 	         }          p++;       }      }    else     {        register unsigned char         *blue,
         *red,          *green;          red=scanline; $       green=scanline+image->columns;*       blue=scanline+(image->columns << 1);(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            *red++=p->red;           *green++=p->green;           *blue++=p->blue;           x++;"           if (x == image->columns)
             {                red=scanline; ,               green=scanline+image->columns;2               blue=scanline+(image->columns << 1);D               count+=PackbitsEncodeImage(image,red,packed_scanline);               x=0;
             } 	         }          p++;       }      }    if (count & 0x1)#     (void) fputc('\0',image->file); 5   MSBFirstWriteShort(PictEndOfPictureOp,image->file); !   (void) free((char *) scanline); (   (void) free((char *) packed_scanline);   (void) free((char *) buffer);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P N M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. % . %  The format of the WritePNMImage routine is: % - %      status=WritePNMImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WritePNMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      format,      *pnm_pixels;     unsigned int     packets;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*-     Promote/Demote image based on image type.    */'   if (strcmp(image->magick,"PPM") == 0)      image->class=DirectClass;    else)     if (strcmp(image->magick,"PGM") == 0)        { E         QuantizeImage(image,256,8,image_info->dither,GRAYColorspace);          SyncImage(image);        }      else+       if (strcmp(image->magick,"PBM") == 0) 	         { E           QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);            SyncImage(image); 	         }    /*     Write PNM file header.   */%   packets=image->columns*image->rows;    if (!IsPseudoClass(image))     {        /*         Full color PNM image.        */       format='6';        packets*=3;      }    else     {        /*         Colormapped PNM image.       */       format='6'; D       if (!IsGrayImage(image) || (strcmp(image->magick,"PPM") == 0))         packets*=3; 
       else	         {            /*              Grayscale PNM image.           */           format='5'; /           if (strcmp(image->magick,"PGM") != 0) #             if (image->colors == 2)                format='4'; 	         }      } -   (void) fprintf(image->file,"P%c\n",format); '   if (image->comments != (char *) NULL)      {        register char          *p;          /*         Write comments to file.        */'       (void) fprintf(image->file,"# "); .       for (p=image->comments; *p != '\0'; p++)       { %         (void) fputc(*p,image->file);          if (*p == '\n') +           (void) fprintf(image->file,"# ");        } %       (void) fputc('\n',image->file);      } C   (void) fprintf(image->file,"%u %u\n",image->columns,image->rows);    /*&     Convert MIFF to PNM raster pixels.   */E   pnm_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); +   if (pnm_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=pnm_pixels;    switch (format)    { 
     case '4':      {        register unsigned char         bit,
         byte,          polarity;          unsigned int
         x;         /*%         Convert image to a PBM image.        */       polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);        bit=0;
       byte=0; 
       x=0;(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;"           if (x == image->columns)
             {                /*-                 Advance to the next scanline.                */               if (bit != 0) %                 *q++=byte << (8-bit);                bit=0;               byte=0;                x=0;            }	         }          p++;       }        packets=q-pnm_pixels;        break;     } 
     case '5':      {        /*%         Convert image to a PGM image.        */0       (void) fprintf(image->file,"%d\n",MaxRGB);(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)-           *q++=image->colormap[p->index].red;          p++;       }        break;     } 
     case '6':      {        /*%         Convert image to a PNM image.        */0       (void) fprintf(image->file,"%d\n",MaxRGB);(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            *q++=p->red;           *q++=p->green;           *q++=p->blue; 	         }          p++;       }        break;     }    } A   (void) fwrite((char *) pnm_pixels,1,(int) packets,image->file); #   (void) free((char *) pnm_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R A D I A N C E I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function WriteRADIANCEImage writes an image in the RADIANCE encoded image
 %  format. % 3 %  The format of the WriteRADIANCEImage routine is:  % 2 %      status=WriteRADIANCEImage(image_info,image) % + %  A description of each parameter follows.  % O %    o status: Function WriteRADIANCEImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */8 static unsigned int WriteRADIANCEImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("Cannot write RADIANCE images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R L E I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function WriteRLEImage writes an image in the Utah Run length encoded image
 %  format. % . %  The format of the WriteRLEImage routine is: % - %      status=WriteRLEImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteRLEImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteRLEImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    Image      *flipped_image;      unsigned int     status;   %   TemporaryFilename(image->filename); !   flipped_image=FlipImage(image); &   if (flipped_image == (Image *) NULL)+     status=WriteSUNImage(image_info,image);    else     { 5       status=WriteSUNImage(image_info,flipped_image); "       DestroyImage(flipped_image);     } 
   if (status)      { 
       char         command[MaxTextLength];   H       (void) sprintf(command,"rastorle -o %s %s\n",image_info->filename,         image->filename); $       status=SystemCommand(command);%       (void) unlink(image->filename);        if (!status)2         Warning("RLE translation failed",command);     }    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WritePSImage translates an image to encapsulated Postscript H %  Level I for printing.  If the supplied geometry is null, the image isJ %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % - %  The format of the WritePSImage routine is:  % , %      status=WritePSImage(image_info,image) % + %  A description of each parameter follows:  % I %    o status: Function WritePSImage return True if the image is printed. I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */2 static unsigned int WritePSImage(image_info,image)	 ImageInfo    *image_info;   Image 	   *image;  { 
   static char      *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on", G       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def",        "/byte 1 string def", #       "/color_packet 3 string def",        "/pixels 768 string def", 	       "",        "/DirectClassPacket", 
       "{",       "  %",&       "  % Get a DirectClass packet.",       "  %",       "  % Parameters: ",        "  %   red.",        "  %   green.",        "  %   blue.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop",        "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",'       "  systemdict /colorimage known",        "  {",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { DirectClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",        "    %",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayDirectClassPacket } image",       "  } ifelse",        "} bind def", 	       "",        "/GrayDirectClassPacket", 
       "{",       "  %",=       "  % Get a DirectClass packet;  convert to grayscale.",        "  %",       "  % Parameters: ",        "  %   red",       "  %   green",       "  %   blue", K       "  %   length: number of pixels minus one of this color (optional).",        "  %",9       "  currentfile color_packet readhexstring pop pop", '       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/GrayPseudoClassPacket", 
       "{",       "  %",=       "  % Get a PseudoClass packet;  convert to grayscale.",        "  %",       "  % Parameters: ", .       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",'       "  color_packet 0 get 0.299 mul", +       "  color_packet 1 get 0.587 mul add", +       "  color_packet 2 get 0.114 mul add",        "  cvi",        "  /gray_packet exch def",       "  compression 0 gt",        "  {",!       "    /number_pixels 1 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", *       "    /number_pixels exch 1 add def",       "  } ifelse", "       "  0 1 number_pixels 1 sub",       "  {",(       "    pixels exch gray_packet put",       "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassPacket", 
       "{",       "  %",&       "  % Get a PseudoClass packet.",       "  %",       "  % Parameters: ", .       "  %   index: index into the colormap.",K       "  %   length: number of pixels minus one of this color (optional).",        "  %",3       "  currentfile byte readhexstring pop 0 get", !       "  /offset exch 3 mul def", :       "  /color_packet colormap offset 3 getinterval def",       "  compression 0 gt",        "  {",!       "    /number_pixels 3 def",        "  }",       "  {",5       "    currentfile byte readhexstring pop 0 get", 0       "    /number_pixels exch 1 add 3 mul def",       "  } ifelse", "       "  0 3 number_pixels 1 sub",       "  {",1       "    pixels exch color_packet putinterval",        "  } for",-       "  pixels 0 number_pixels getinterval",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",        "  %",       "  % Parameters: ", 8       "  %   colors: number of colors in the colormap.",8       "  %   colormap: red, green, blue color packets.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop", #       "  /colors colors 3 mul def", &       "  /colormap colors string def",5       "  currentfile colormap readhexstring pop pop", '       "  systemdict /colorimage known",        "  {",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",5       "    { PseudoClassPacket } false 3 colorimage",        "  }",       "  {",       "    %",=       "    % No colorimage operator;  convert to grayscale.",        "    %",       "    columns rows 8",        "    [",       "      columns 0 0",       "      rows neg 0 rows",       "    ]",,       "    { GrayPseudoClassPacket } image",       "  } ifelse",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters: ", !       "  %   x & y translation.",        "  %   x & y scale.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        "  showpage",        "} bind def",        "%%EndProlog",       "%%Page:  1 1", 
       NULL     };     char     *label,      **q;     int      sans_offset,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned int     dx_resolution,     dy_resolution,     height,      text_size,     x_resolution,      y_resolution, 
     width;     /*     Open output image file.    */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*+     Scale image to size of Postscript page.    */3   text_size=image->label == (char *) NULL ? 0 : 36;    x=0;   y=0;   width=image->columns;    height=image->rows; &   if (strcmp(image->magick,"PS") == 0)     { 	       int          flags;         unsigned int         page_height,         page_width;          /*(         Center image on Postscript page.       */K       (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height); L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);,       if (((page_width-(x << 1)) < width) ||6           ((page_height-(y << 1)-text_size) < height))	         {            unsigned long              scale_factor;              /*4             Scale image relative to Postscript page.           */:           scale_factor=UpShift(page_width-(x << 1))/width;N           if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))H             scale_factor=UpShift(page_height-(y << 1)-text_size)/height;.           width=DownShift(width*scale_factor);0           height=DownShift(height*scale_factor);	         } =       if (((flags & XValue) == 0) && ((flags & YValue) == 0)) 	         { 
           int              delta_x,             delta_y;  .           delta_x=page_width-(width+(x << 1));:           delta_y=page_height-(height+(y << 1))-text_size;           if (delta_x >= 0)              x=(delta_x >> 1)+x;            if (delta_y >= 0)              y=(delta_y >> 1)+y; 	         }      }    /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);    x_resolution=dx_resolution;    y_resolution=dy_resolution; F   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,!     &x_resolution,&y_resolution); +   width=(width*dx_resolution)/x_resolution; -   height=(height*dy_resolution)/y_resolution;    /*     Output Postscript header.    */&   if (strcmp(image->magick,"PS") == 0)4     (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");   else=     (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); @   (void) fprintf(image->file,"%%%%Title: %s\n",image->filename);;   (void) fprintf(image->file,"%%%%Creator: ImageMagick\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); C   (void) fprintf(image->file,"%%%%CreationDate: %s",ctime(&timer)); P   (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,x+(int) width,     y+(int) height+text_size);&   if (strcmp(image->magick,"PS") == 0)     { @       (void) fprintf(image->file,"%%%%Orientation: Portrait\n");<       (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");     } P   (void) fprintf(image->file,"%%%%Pages: %d\n",strcmp(image->magick,"PS") == 0);2   (void) fprintf(image->file,"%%%%EndComments\n");(   if (strcmp(image->magick,"EPSI") == 0)     {        Image          *preview_image;          register unsigned char         bit,
         byte,          polarity;          unsigned int         count;         /*-         Initialize bordered image attributes.        */       image->orphan=True; E       preview_image=CopyImage(image,image->columns,image->rows,True);        image->orphan=False;*       if (preview_image == (Image *) NULL)	         { P           Warning("Unable to include preview image","Memory allocation failed");           return(False);	         }        /*&         Convert MIFF to bitmap pixels.       */I       QuantizeImage(preview_image,2,8,image_info->dither,GRAYColorspace);        polarity=0;        if (image->colors == 2) O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);        bit=0;
       byte=0;        count=0;
       x=0;       p=preview_image->pixels;G       (void) fprintf(image->file,"%%%%BeginPreview: %u %u %u %u\n%%  ", D         preview_image->columns,preview_image->rows,(unsigned int) 1,G         (((preview_image->columns+7) >> 3)*preview_image->rows+35)/36); 0       for (i=0; i < preview_image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=0x01;            bit++;           if (bit == 8) 
             {                /*6                 Write a bitmap byte to the image file.               */=               (void) fprintf(image->file,"%02x",byte & 0xff);                count++;               if (count == 36)                 { 7                   (void) fprintf(image->file,"\n%%  ");                    count=0;                 };               bit=0;               byte=0; 
             }            x++;*           if (x == preview_image->columns)
             {                if (bit != 0)                  {                    /*:                     Write a bitmap byte to the image file.                   */!                   byte<<=(8-bit); A                   (void) fprintf(image->file,"%02x",byte & 0xff);                    count++;"                   if (count == 36)                     { ;                       (void) fprintf(image->file,"\n%%  ");                        count=0;                     };                   bit=0;                   byte=0;                  };               x=0;
             }            }            p++;	         } 9         (void) fprintf(image->file,"\n%%%%EndPreview\n"); $         DestroyImage(preview_image);       }    /*     Output Postscript commands.    */   for (q=Postscript; *q; q++) *     (void) fprintf(image->file,"%s\n",*q);&   if (strcmp(image->magick,"PS") != 0)3     (void) fprintf(image->file,"userdict begin\n"); 1   (void) fprintf(image->file,"%%%%BeginData:\n"); /   (void) fprintf(image->file,"DisplayImage\n");    /*     Output image data.   */8   if (image->compression == RunlengthEncodedCompression)     CompressImage(image);    label=image->label;    if (label == (char *) NULL)      label=" ";   p=image->pixels;   switch (image->class)    {      case DirectClass:      { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression); !       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {            /*7             Dump runlength-encoded DirectColor packets.            */           x=0;,           for (i=0; i < image->packets; i++)           {              x++;J             (void) fprintf(image->file,"%02x%02x%02x%02x",p->red,p->green,!               p->blue,p->length);              if (x == 9)                {                  x=0;1                 (void) fprintf(image->file,"\n");                }              p++;           }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                x++;H               (void) fprintf(image->file,"%02x%02x%02x",p->red,p->green,                 p->blue);                if (x == 12)                 {                    x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }              p++;           }            break;	         }        }        break;     }      case PseudoClass:      { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression);        /*+         Dump number of colors and colormap.        */7       (void) fprintf(image->file,"%u\n",image->colors); '       for (i=0; i < image->colors; i++) K         (void) fprintf(image->file,"%02x%02x%02x\n",image->colormap[i].red, <           image->colormap[i].green,image->colormap[i].blue);!       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {            /*7             Dump runlength-encoded PseudoColor packets.            */           x=0;,           for (i=0; i < image->packets; i++)           {              x++;F             (void) fprintf(image->file,"%02x%02x",p->index,p->length);             if (x == 18)               {                  x=0;1                 (void) fprintf(image->file,"\n");                }              p++;           }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed PseudoColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                x++;:               (void) fprintf(image->file,"%02x",p->index);               if (x == 36)                 {                    x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }              p++;           }            break;	         }        }      }    } #   (void) fprintf(image->file,"\n"); .   (void) fprintf(image->file,"%%%%EndData\n");&   if (strcmp(image->magick,"PS") != 0)(     (void) fprintf(image->file,"end\n");2   (void) fprintf(image->file,"%%%%PageTrailer\n");.   (void) fprintf(image->file,"%%%%Trailer\n");*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S 2 I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image is J %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % . %  The format of the WritePS2Image routine is: % - %      status=WritePS2Image(image_info,image)  % + %  A description of each parameter follows:  % J %    o status: Function WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */3 static unsigned int WritePS2Image(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  { 
   static char      *Postscript[]=     {        "%%BeginProlog",
       "%",E       "% Display a color image.  The image is displayed in color on", G       "% Postscript viewers or printers that support color, otherwise", (       "% it is displayed as grayscale.",
       "%",       "/buffer 512 string def", 	       "",        "/DirectClassImage",
       "{",       "  %",)       "  % Display a DirectClass image.",        "  %",#       "  /DeviceRGB setcolorspace", 
       "  <<",        "    /ImageType 1",        "    /Interpolate true",       "    /Width columns",        "    /Height rows",         "    /BitsPerComponent 8","       "    /Decode [0 1 0 1 0 1]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",        "    compression 0 gt",        "    {",=       "      /DataSource currentfile /ASCIIHexDecode filter",        "    }",       "    {",O       "      /DataSource currentfile /ASCIIHexDecode filter /LZWDecode filter",        "    } ifelse",        "  >> image",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",       "  %",)       "  % Display a PseudoClass image.",        "  %",       "  % Parameters: ", 8       "  %   colors: number of colors in the colormap.",8       "  %   colormap: red, green, blue color packets.",       "  %",*       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop", ,       "  /colormap colors 3 mul string def",5       "  currentfile colormap readhexstring pop pop", F       "  [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",
       "  <<",        "    /ImageType 1",        "    /Interpolate true",       "    /Width columns",        "    /Height rows",         "    /BitsPerComponent 8",       "    /Decode [0 255]",7       "    /ImageMatrix [columns 0 0 rows neg 0 rows]",        "    compression 0 gt",        "    {",=       "      /DataSource currentfile /ASCIIHexDecode filter",        "    }",       "    {",O       "      /DataSource currentfile /ASCIIHexDecode filter /LZWDecode filter",        "    } ifelse",        "  >> image",        "} bind def", 	       "",        "/DisplayImage",
       "{",       "  %",8       "  % Display a DirectClass or PseudoClass image.",       "  %",       "  % Parameters: ", !       "  %   x & y translation.",        "  %   x & y scale.",        "  %   image label.", $       "  %   image columns & rows.",5       "  %   class: 0-DirectClass or 1-PseudoClass.", M       "  %   compression: 0-RunlengthEncodedCompression or 1-NoCompression.", !       "  %   hex color packets.",        "  %",       "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",@       "  /NewCenturySchlbk-Roman findfont 24 scalefont setfont",*       "  currentfile buffer readline pop",,       "  0 y 12 add moveto buffer show pop",       "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        "  showpage",        "} bind def",        "%%EndProlog",       "%%Page:  1 1", 
       NULL     };     char     *label,      **q;     int      sans_offset,     x,     y;     register RunlengthPacket     *p;      register int     i,     j;     time_t
     timer;     unsigned char      *pixels;     unsigned int     dx_resolution,     dy_resolution,     height,      number_packets,      text_size,     x_resolution,      y_resolution, 
     width;     /*     Open output image file.    */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);        return(False);     }    /*+     Scale image to size of Postscript page.    */3   text_size=image->label == (char *) NULL ? 0 : 36;    x=0;   y=0;   width=image->columns;    height=image->rows; &   if (strcmp(image->magick,"PS") == 0)     { 	       int          flags;         unsigned int         page_height,         page_width;          /*(         Center image on Postscript page.       */K       (void) XParseGeometry(PSPageGeometry,&x,&y,&page_width,&page_height); L       flags=XParseGeometry(image_info->page,&x,&y,&page_width,&page_height);,       if (((page_width-(x << 1)) < width) ||6           ((page_height-(y << 1)-text_size) < height))	         {            unsigned long              scale_factor;              /*4             Scale image relative to Postscript page.           */:           scale_factor=UpShift(page_width-(x << 1))/width;N           if (scale_factor > (UpShift(page_height-(y << 1)-text_size)/height))H             scale_factor=UpShift(page_height-(y << 1)-text_size)/height;.           width=DownShift(width*scale_factor);0           height=DownShift(height*scale_factor);	         } =       if (((flags & XValue) == 0) && ((flags & YValue) == 0)) 	         { 
           int              delta_x,             delta_y;  .           delta_x=page_width-(width+(x << 1));:           delta_y=page_height-(height+(y << 1))-text_size;           if (delta_x >= 0)              x=(delta_x >> 1)+x;            if (delta_y >= 0)              y=(delta_y >> 1)+y; 	         }      }    /*$     Scale relative to dots-per-inch.   */D   (void) XParseGeometry(PSDensityGeometry,&sans_offset,&sans_offset,#     &dx_resolution,&dy_resolution);    x_resolution=dx_resolution;    y_resolution=dy_resolution; F   (void) XParseGeometry(image_info->density,&sans_offset,&sans_offset,!     &x_resolution,&y_resolution); +   width=(width*dx_resolution)/x_resolution; -   height=(height*dy_resolution)/y_resolution;    /*     Output Postscript header.    */&   if (strcmp(image->magick,"PS") == 0)4     (void) fprintf(image->file,"%%!PS-Adobe-3.0\n");   else=     (void) fprintf(image->file,"%%!PS-Adobe-3.0 EPSF-3.0\n"); @   (void) fprintf(image->file,"%%%%Title: %s\n",image->filename);;   (void) fprintf(image->file,"%%%%Creator: ImageMagick\n");    timer=time((time_t *) NULL);   (void) localtime(&timer); C   (void) fprintf(image->file,"%%%%CreationDate: %s",ctime(&timer)); P   (void) fprintf(image->file,"%%%%BoundingBox: %d %d %d %d\n",x,y,x+(int) width,     y+(int) height+text_size);&   if (strcmp(image->magick,"PS") == 0)     { @       (void) fprintf(image->file,"%%%%Orientation: Portrait\n");<       (void) fprintf(image->file,"%%%%PageOrder: Ascend\n");     } P   (void) fprintf(image->file,"%%%%Pages: %d\n",strcmp(image->magick,"PS") == 0);2   (void) fprintf(image->file,"%%%%EndComments\n");   /*     Output Postscript commands.    */   for (q=Postscript; *q; q++) *     (void) fprintf(image->file,"%s\n",*q);&   if (strcmp(image->magick,"PS") != 0)3     (void) fprintf(image->file,"userdict begin\n"); 1   (void) fprintf(image->file,"%%%%BeginData:\n"); /   (void) fprintf(image->file,"DisplayImage\n");    /*     Output image data.   */   label=image->label;    if (label == (char *) NULL)      label=" ";   p=image->pixels;   if (!IsPseudoClass(image))     { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression); !       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {             register unsigned char             *q;              /*!             Allocate pixel array.            */6           number_packets=3*image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL);                return(False);
             }            /*$             Dump LZW encoded pixels.           */           q=pixels; ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)
             {                *q++=p->red;               *q++=p->green;               *q++=p->blue; 
             }              p++;           } D           (void) LZWEncodeFilter(image->file,pixels,number_packets);*           (void) fprintf(image->file,">");'           (void) free((char *) pixels);            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                x++;H               (void) fprintf(image->file,"%02x%02x%02x",p->red,p->green,                 p->blue);                if (x == 12)                 {                    x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }              p++;           }            break;	         }        }      }    else     { P       (void) fprintf(image->file,"%d %d\n%u %u\n%s           \n%u %u\n%d\n%d\n",:         x,y,width,height,label,image->columns,image->rows,I         image->class == PseudoClass,image->compression == NoCompression);        /*+         Dump number of colors and colormap.        */7       (void) fprintf(image->file,"%u\n",image->colors); '       for (i=0; i < image->colors; i++) K         (void) fprintf(image->file,"%02x%02x%02x\n",image->colormap[i].red, <           image->colormap[i].green,image->colormap[i].blue);!       switch (image->compression)        { )         case RunlengthEncodedCompression:          default:	         {             register unsigned char             *q;              /*!             Allocate pixel array.            */4           number_packets=image->columns*image->rows;P           pixels=(unsigned char *) malloc(number_packets*sizeof(unsigned char));/           if (pixels == (unsigned char *) NULL) 
             { ?               Warning("Memory allocation error",(char *) NULL);                return(False);
             }            /*$             Dump LZW encoded pixels.           */           q=pixels; ,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++),               *q++=(unsigned char) p->index;             p++;           } D           (void) LZWEncodeFilter(image->file,pixels,number_packets);*           (void) fprintf(image->file,">");'           (void) free((char *) pixels);            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed PseudoColor packets.           */           x=0;,           for (i=0; i < image->packets; i++)           { 2             for (j=0; j <= ((int) p->length); j++)
             {                x++;:               (void) fprintf(image->file,"%02x",p->index);               if (x == 36)                 {                    x=0;3                   (void) fprintf(image->file,"\n");                  } 
             }              p++;           }            break;	         }        }      } #   (void) fprintf(image->file,"\n"); .   (void) fprintf(image->file,"%%%%EndData\n");&   if (strcmp(image->magick,"PS") != 0)(     (void) fprintf(image->file,"end\n");2   (void) fprintf(image->file,"%%%%PageTrailer\n");.   (void) fprintf(image->file,"%%%%Trailer\n");*   (void) fprintf(image->file,"%%%%EOF\n");   CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %EO %                                                                             % O %                                                                             %EO %   W r i t e R G B I m a g e                                                 % O %                                                                             %EO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % F %  Function WriteRGBImage writes an image to a file in red, green, and %  blue rasterfile format. % . %  The format of the WriteRGBImage routine is: % - %      status=WriteRGBImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteRGBImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {C   register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *rgb_pixels;     /*     Open output image file.y   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)n     {f5       Warning("Unable to open file",image->filename);        return(False);     }e   /*&     Convert MIFF to RGB raster pixels.   */   rgb_pixels=(unsigned char *)?     malloc(3*image->columns*image->rows*sizeof(unsigned char));n+   if (rgb_pixels == (unsigned char *) NULL)u     {e9       Warning("Unable to allocate memory",(char *) NULL);r       return(False);     }    q=rgb_pixels;b    switch (image_info->interlace)   {      case NoneInterlace:      default:     {        /*.         No interlacing:  RGBRGBRGBRGBRGBRGB...       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            *q++=p->red;           *q++=p->green;           *q++=p->blue; 	         }          p++;       }E       break;     }r     case LineInterlace:l     {n       register int
         x,
         y;         /*?         Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...n       */"       if (!UncompressImage(image))         return(False);%       for (y=0; y < image->rows; y++)u       {m+         p=image->pixels+(y*image->columns);e*         for (x=0; x < image->columns; x++)	         {            *q++=p->red;           p++;	         }h+         p=image->pixels+(y*image->columns); *         for (x=0; x < image->columns; x++)	         {f           *q++=p->green;           p++;	         } +         p=image->pixels+(y*image->columns);%*         for (x=0; x < image->columns; x++)	         {%           *q++=p->blue;            p++;	         }a       }t       break;     }i     case PlaneInterlace:     {g       /*7         Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...u       */       p=image->pixels;(       for (i=0; i < image->packets; i++)       {".         for (j=0; j <= ((int) p->length); j++)           *q++=p->red;         p++;       }        p=image->pixels;(       for (i=0; i < image->packets; i++)       {(.         for (j=0; j <= ((int) p->length); j++)           *q++=p->green;         p++;       }%       p=image->pixels;(       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)           *q++=p->blue;          p++;       }        break;     }    } I   (void) fwrite((char *) rgb_pixels,3,(int) (image->columns*image->rows),      image->file); #   (void) free((char *) rgb_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %gO %   W r i t e S U N I m a g e                                                 %eO %                                                                             % O %                                                                             %fO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %rG %  Function WriteSUNImage writes an image in the SUN rasterfile format.u %r. %  The format of the WriteSUNImage routine is: %m- %      status=WriteSUNImage(image_info,image)  %g+ %  A description of each parameter follows.e % J %    o status: Function WriteSUNImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filea %      fails to write. %rA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %g %w */3 static unsigned int WriteSUNImage(image_info,image) 	 ImageInfoa   *image_info;   Imagef	   *image;  {  #define RMT_EQUAL_RGB  1 #define RMT_NONE  0r #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_FORMAT_RGB  3     typedef struct _SUNHeader_   {s     unsigned long        magic,       width,
       height,e       depth,
       length,v       type,u       maptype,       maplength;   } SUNHeader;     register int     i,     j,     x;     register RunlengthPacket     *p;f     register unsigned char     *q;H     SUNHeader>     sun_header;-     unsigned chari     *sun_pixels;     /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)a     {g5       Warning("Unable to open file",image->filename);q       return(False);     }l   /*&     Initialize SUN raster file header.   */   sun_header.magic=0x59a66a95;"   sun_header.width=image->columns;    sun_header.height=image->rows;N   sun_header.type=(image->class == DirectClass ? RT_FORMAT_RGB : RT_STANDARD);   sun_header.maptype=RMT_NONE;   sun_header.maplength=0;    if (!IsPseudoClass(image))     {        /*         Full color SUN raster.       */0       sun_header.depth=(image->matte ? 32 : 24);J       sun_header.length=image->columns*image->rows*(image->matte ? 4 : 3);>       sun_header.length+=image->columns % 2 ? image->rows : 0;     }    else3     if (IsGrayImage(image) && (image->colors == 2))        { 
         /*            Monochrome SUN raster.
         */         sun_header.depth=1; @         sun_header.length=((image->columns+7) >> 3)*image->rows;N         sun_header.length+=((image->columns/8)+(image->columns % 8 ? 1 : 0)) %           2 ? image->rows : 0;       }      else       {s
         /*!           Colormapped SUN raster. 
         */         sun_header.depth=8;e5         sun_header.length=image->columns*image->rows;m@         sun_header.length+=image->columns % 2 ? image->rows : 0;)         sun_header.maptype=RMT_EQUAL_RGB;P-         sun_header.maplength=image->colors*3;        }i   /*     Write SUN header.r   */2   MSBFirstWriteLong(sun_header.magic,image->file);2   MSBFirstWriteLong(sun_header.width,image->file);3   MSBFirstWriteLong(sun_header.height,image->file); 2   MSBFirstWriteLong(sun_header.depth,image->file);3   MSBFirstWriteLong(sun_header.length,image->file);i1   MSBFirstWriteLong(sun_header.type,image->file);M4   MSBFirstWriteLong(sun_header.maptype,image->file);6   MSBFirstWriteLong(sun_header.maplength,image->file);   /*&     Convert MIFF to SUN raster pixels.   */O   sun_pixels=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char)); +   if (sun_pixels == (unsigned char *) NULL)g     { 9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }    p=image->pixels;   q=sun_pixels;e   x=0;   if (!IsPseudoClass(image))     {        /*4         Convert DirectClass packet to SUN RGB pixel.       */(       for (i=0; i < image->packets; i++)       { ,         for (j=0; j <= (int) p->length; j++)	         {            if (image->matte) *             *q++=(unsigned char) p->index;           *q++=p->red;           *q++=p->green;           *q++=p->blue;e           x++;"           if (x == image->columns)
             {a,               if ((image->columns % 2) != 0)(                 q++;  /* pad scanline */               x=0;
             }i	         }          p++;       }u     }r   else3     if (IsGrayImage(image) && (image->colors == 2))        {r         register unsigned char           bit,           byte,o           polarity;   
         /*>           Convert PseudoClass image to a SUN monochrome image.
         */O         polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);_         bit=0;         byte=0;d*         for (i=0; i < image->packets; i++)	         {m.           for (j=0; j <= (int) p->length; j++)           {              byte<<=1;0%             if (p->index == polarity)_               byte|=0x01;d             bit++;             if (bit == 8)m               {_                 *q++=byte;                 bit=0;                 byte=0;u               }t             x++;$             if (x == image->columns)               {                  /*/                   Advance to the next scanline.=                 */                 if (bit != 0)c'                   *q++=byte << (8-bit); )                 if ((((image->columns/8)+l<                     (image->columns % 8 ? 1 : 0)) % 2) != 0)*                   q++;  /* pad scanline */                 bit=0;                 byte=0;                  x=0;              }           }L           p++;	         }        }      else       {          unsigned char;           *sun_colormap;  
         /*            Dump colormap to file.
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char)); 3         if (sun_colormap == (unsigned char *) NULL)0           {(?             Warning("Unable to allocate memory",(char *) NULL);1             return(False);           }          q=sun_colormap; )         for (i=0; i < image->colors; i++) &           *q++=image->colormap[i].red;)         for (i=0; i < image->colors; i++)h(           *q++=image->colormap[i].green;)         for (i=0; i < image->colors; i++) '           *q++=image->colormap[i].blue; I         (void) fwrite((char *) sun_colormap,1,(int) sun_header.maplength,            image->file);y+         (void) free((char *) sun_colormap); 
         /*>           Convert PseudoClass packet to SUN colormapped pixel.
         */         q=sun_pixels; *         for (i=0; i < image->packets; i++)	         { .           for (j=0; j <= (int) p->length; j++)           {              *q++=p->index;             x++;$             if (x == image->columns)               { .                 if ((image->columns % 2) != 0)*                   q++;  /* pad scanline */                 x=0;               }            }            p++;	         }m       }yK   (void) fwrite((char *) sun_pixels,1,(int) sun_header.length,image->file); #   (void) free((char *) sun_pixels);    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %sO %   W r i t e T A R G A I m a g e                                             %oO %                                                                             % O %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function WriteTARGAImage writes a image in the Truevision Targa rasterfilem
 %  format. %n0 %  The format of the WriteTARGAImage routine is: %g/ %      status=WriteTARGAImage(image_info,image)n %E+ %  A description of each parameter follows.i %dL %    o status: Function WriteTARGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image filea %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.r % . %    o image:  A pointer to a Image structure. %L %  */5 static unsigned int WriteTARGAImage(image_info,image)r	 ImageInfo)   *image_info;   Imagev	   *image;c {  #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3  #define TargaRLEColormap  9  #define TargaRLERGB  10p #define TargaRLEMonochrome  11     typedef struct _TargaHeadere   {a     unsigned char        id_length,       colormap_type,       image_type;s       unsigned short       colormap_index,        colormap_length;       unsigned chari       colormap_size;       unsigned short       x_origin,>       y_origin,t       width,
       height;d       unsigned char        pixel_size,b       attributes;1   } TargaHeader;     intt
     count,     runlength;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q,a     *r;;  
   TargaHeaderL     targa_header;h     unsigned char      *targa_pixels;     /*     Open output image file.F   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)n     {e5       Warning("Unable to open file",image->filename);_       return(False);     })   /*     Reflect image.   */   image=FlopImage(image);    if (image == (Image *) NULL)     {,8       Warning("Unable to reflect file",image->filename);       return(False);     }r8   if (image->compression == RunlengthEncodedCompression)     CompressImage(image);)   /*(     Initialize TARGA raster file header.   */   targa_header.id_length=0;l'   if (image->comments != (char *) NULL)mB     targa_header.id_length=Min((int) strlen(image->comments),255);   targa_header.colormap_type=0;(    targa_header.colormap_index=0;!   targa_header.colormap_length=0;n   targa_header.colormap_size=0;a   targa_header.x_origin=0;   targa_header.y_origin=0;$   targa_header.width=image->columns;"   targa_header.height=image->rows;   targa_header.pixel_size=8;   targa_header.attributes=0;   if (!IsPseudoClass(image))     {>       /*          Full color TARGA raster.       */'       targa_header.image_type=TargaRGB;h<       if (image->compression == RunlengthEncodedCompression),         targa_header.image_type=TargaRLERGB;5       targa_header.pixel_size=image->matte ? 32 : 24;g     })   else     {e       /*!         Colormapped TARGA raster.;       */,       targa_header.image_type=TargaColormap;<       if (image->compression == RunlengthEncodedCompression)1         targa_header.image_type=TargaRLEColormap; 6       if (!IsGrayImage(image) || (image->colors != 2))	         { '           targa_header.colormap_type=1; (           targa_header.colormap_index=0;5           targa_header.colormap_length=image->colors; (           targa_header.colormap_size=24;	         } 
       else	         {            /*$             Monochrome TARGA raster.           */2           targa_header.image_type=TargaMonochrome;@           if (image->compression == RunlengthEncodedCompression)7             targa_header.image_type=TargaRLEMonochrome;%	         }%     }%   /*     Write TARGA header.%   */:   (void) fputc((char) targa_header.id_length,image->file);>   (void) fputc((char) targa_header.colormap_type,image->file);;   (void) fputc((char) targa_header.image_type,image->file); >   LSBFirstWriteShort(targa_header.colormap_index,image->file);?   LSBFirstWriteShort(targa_header.colormap_length,image->file); >   (void) fputc((char) targa_header.colormap_size,image->file);8   LSBFirstWriteShort(targa_header.x_origin,image->file);8   LSBFirstWriteShort(targa_header.y_origin,image->file);5   LSBFirstWriteShort(targa_header.width,image->file); 6   LSBFirstWriteShort(targa_header.height,image->file);;   (void) fputc((char) targa_header.pixel_size,image->file);f;   (void) fputc((char) targa_header.attributes,image->file);l"   if (targa_header.id_length != 0)D     (void) fwrite((char *) image->comments,1,targa_header.id_length,       image->file);g   /*(     Convert MIFF to TARGA raster pixels.   */   count=(unsigned int)J     (targa_header.pixel_size*targa_header.width*targa_header.height) >> 3;8   if (image->compression == RunlengthEncodedCompression)     count+=(count/128)+1;nE   targa_pixels=(unsigned char *) malloc(count*sizeof(unsigned char)); -   if (targa_pixels == (unsigned char *) NULL)      { 9       Warning("Unable to allocate memory",(char *) NULL);n       return(False);     } %   p=image->pixels+(image->packets-1);d   q=targa_pixels;    if (!IsPseudoClass(image))     {        /*6         Convert DirectClass packet to TARGA RGB pixel.       */<       if (image->compression != RunlengthEncodedCompression)*         for (i=0; i < image->packets; i++)	         {e.           for (j=0; j <= (int) p->length; j++)           {              *q++=p->blue;              *q++=p->green;             *q++=p->red;             if (image->matte)_               *q++=p->index;           }a           p--;	         } 
       else*         for (i=0; i < image->packets; i++)	         {             runlength=p->length+1;           if (runlength > 128)
             {                *q++=0xff;               *q++=p->blue;                *q++=p->green;               *q++=p->red;               if (image->matte)x                 *q++=p->index;               runlength-=128;l
             }            r=q;"           *q++=0x80+(runlength-1);           *q++=p->blue;            *q++=p->green;           *q++=p->red;           if (image->matte);             *q++=p->index;           if (runlength != 1)b             p--;           else
             { .               for ( ; i < image->packets; i++)               {                  p--;;                 if ((p->length != 0) || (runlength == 128))C                   break;                 *q++=p->blue;(                 *q++=p->green;                 *q++=p->red;!                 if (image->matte)                     *q++=p->index;                 runlength++;               }m               *r=runlength-1; 
             }r	         }      }e   else4     if (!IsGrayImage(image) || (image->colors != 2))       {=         unsigned chara           *targa_colormap;  
         /*>           Dump colormap to file (blue, green, red byte order).
         */(         targa_colormap=(unsigned char *)G           malloc(3*targa_header.colormap_length*sizeof(unsigned char));05         if (targa_colormap == (unsigned char *) NULL)M           { ?             Warning("Unable to allocate memory",(char *) NULL);b             return(False);           }f         q=targa_colormap; )         for (i=0; i < image->colors; i++)b	         { '           *q++=image->colormap[i].blue;g(           *q++=image->colormap[i].green;&           *q++=image->colormap[i].red;	         })0         (void) fwrite((char *) targa_colormap,1,<           (int) 3*targa_header.colormap_length,image->file);-         (void) free((char *) targa_colormap);;
         /*@           Convert PseudoClass packet to TARGA colormapped pixel.
         */         q=targa_pixels; >         if (image->compression != RunlengthEncodedCompression),           for (i=0; i < image->packets; i++)           {+0             for (j=0; j <= (int) p->length; j++)               *q++=p->index;             p--;           }          else,           for (i=0; i < image->packets; i++)           { "             runlength=p->length+1;              if (runlength > 128)               {                  *q++=0xff;                 *q++=p->index;                 runlength-=128;                }              r=q;$             *q++=0x80+(runlength-1);             *q++=p->index;             if (runlength != 1).               p--;             else               {p0                 for ( ; i < image->packets; i++)                 {o                   p--;=                   if ((p->length != 0) || (runlength == 128))                      break;                    *q++=p->index;                   runlength++;                 }l                 *r=runlength-1;                }l           }        }      else       {          unsigned int           polarity;   
         /*@           Convert PseudoClass image to a TARGA monochrome image.
         */         polarity=0;          if (image->colors == 2)            polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);>         if (image->compression != RunlengthEncodedCompression),           for (i=0; i < image->packets; i++)           {l0             for (j=0; j <= (int) p->length; j++)5               *q++=p->index == polarity ? 0 : MaxRGB;+             p--;           }x         else,           for (i=0; i < image->packets; i++)           {0"             runlength=p->length+1;              if (runlength > 128)               {m                 *q++=0xff;7                 *q++=p->index == polarity ? 0 : MaxRGB;                  runlength-=128;                }k             r=q;$             *q++=0x80+(runlength-1);3             *q++=p->index == polarity ? 0 : MaxRGB;c             if (runlength != 1)                p--;             else               {-0                 for ( ; i < image->packets; i++)                 {+                   p--;=                   if ((p->length != 0) || (runlength == 128))                      break;9                   *q++=p->index == polarity ? 0 : MaxRGB;                    runlength++;                 }a                 *r=runlength-1;                }a           }*       } L   (void) fwrite((char *) targa_pixels,1,(int) (q-targa_pixels),image->file);%   (void) free((char *) targa_pixels);l   CloseImage(image);   return(True);  }v ) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e T E X T I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%C %  Function WriteTEXTImage writes an image in the TEXT image forma.% % / %  The format of the WriteTEXTImage routine is:  %i. %      status=WriteTEXTImage(image_info,image) % + %  A description of each parameter follows.i % K %    o status: Function WriteTEXTImage return True if the image is written.aK %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.e %l. %    o image:  A pointer to a Image structure. %S %i */4 static unsigned int WriteTEXTImage(image_info,image)	 ImageInfot   *image_info;   Image 	   *image;  {t   unsigned int     status;(  6   Warning("Cannot write TEXT images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);o }u m #ifdef HasTIFF #include "tiff.h", #include "tiffio.h"f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %uO %                                                                             % O %                                                                             % O %   W r i t e T I F F I m a g e                                               %%O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteTIFFImage writes an image in the Tagged image file format.  % / %  The format of the WriteTIFFImage routine is:  % . %      status=WriteTIFFImage(image_info,image) % + %  A description of each parameter follows:  % L %    o status:  Function WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the imagea) %      file cannot be opened for writing.c % A %    o image_info: Specifies a pointer to an ImageInfo structure.t % . %    o image:  A pointer to a Image structure. %m %) */4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfo:   *image_info;   Imager	   *image;i {h   Images     encode_image;F     register RunlengthPacket     *p;h     register int     i,     j,     x,     y;     register unsigned char     *q;a     TIFF
     *tiff;     unsigned char      *scanline;     unsigned short     photometric,     rows_per_strip;      /*     Open TIFF file.,   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      {f5       Warning("Unable to open file",image->filename);        return(False);     }h   (void) CloseImage(image);r.   if ((image->file != stdout) && !image->pipe)#     (void) unlink(image->filename);t   else     {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);l       image->temporary=True;     }e&   tiff=TIFFOpen(image->filename,"wb");   if (tiff == (TIFF *) NULL)     return(False);   /*     Initialize TIFF fields.    */:   TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);4   TIFFSetField(tiff,TIFFTAG_SOFTWARE,"ImageMagick");'   if (image->comments != (char *) NULL))@     TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);   if (!IsPseudoClass(image))     {y       /*         Full color TIFF raster.v       */"       photometric=PHOTOMETRIC_RGB;1       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);rH       TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));     }i   else     {_       /*          Colormapped TIFF raster.       */&       photometric=PHOTOMETRIC_PALETTE;3       TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1);t1       TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8);        if (IsGrayImage(image)) 	         {c           /*"             Grayscale TIFF raster.           */-           photometric=PHOTOMETRIC_MINISBLACK;)!           if (image->colors == 2)l7             TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1);r	         }e     }05   TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric);_5   TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,image->rows);t7   TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,image->columns);o9   TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB);l=   TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT);i>   TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);9   TIFFSetField(tiff,TIFFTAG_COMPRESSION,COMPRESSION_LZW);e*   if (image->compression == NoCompression)<     TIFFSetField(tiff,TIFFTAG_COMPRESSION,COMPRESSION_NONE);-   rows_per_strip=8192/TIFFScanlineSize(tiff);n   if (rows_per_strip == 0)     rows_per_strip=1;)9   TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,rows_per_strip);g<   scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff));)   if (scanline == (unsigned char *) NULL)%     {%7       Warning("Memory allocation error",(char *) NULL);%       return(False);     }    p=image->pixels;
   q=scanline;    x=0;   y=0;%   if (photometric == PHOTOMETRIC_RGB) &     for (i=0; i < image->packets; i++)     { *       for (j=0; j <= (int) p->length; j++)       { 
         /*B           Convert DirectClass packets to contiguous RGB scanlines.
         */         *q++=p->red;         *q++=p->green;         *q++=p->blue;          if (image->matte) (           *q++=(unsigned char) p->index;         x++;          if (x == image->columns)           { 9             if (TIFFWriteScanline(tiff,scanline,y,0) < 0)                break;             q=scanline;%             x=0;             y++;           }F       }r
       p++;     }a   else+     if (photometric == PHOTOMETRIC_PALETTE)e       {          unsigned short           *blue,           *green,            *red;m  
         /*!           Allocate TIFF colormap.a
         */M         blue=(unsigned short *) malloc(image->colors*sizeof(unsigned short));iN         green=(unsigned short *) malloc(image->colors*sizeof(unsigned short));L         red=(unsigned short *) malloc(image->colors*sizeof(unsigned short));0         if ((blue == (unsigned short *) NULL) ||1             (green == (unsigned short *) NULL) ||s-             (red == (unsigned short *) NULL))g           {aL             Warning("Unable to read TIFF image","Memory allocation failed");             return(False);           }d
         /*#           Initialize TIFF colormap.i
         */)         for (i=0; i < image->colors; i++) 	         {p!           red[i]=(unsigned short)nC             ((image->colormap[i].red*65535)/(unsigned int) MaxRGB); #           green[i]=(unsigned short)-E             ((image->colormap[i].green*65535)/(unsigned int) MaxRGB);g"           blue[i]=(unsigned short)D             ((image->colormap[i].blue*65535)/(unsigned int) MaxRGB);	         } ;         TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);e
         /*O           Convert PseudoClass packets to contiguous colormap indexed scanlines.i
         */*         for (i=0; i < image->packets; i++)	         {_.           for (j=0; j <= (int) p->length; j++)           {s*             *q++=(unsigned char) p->index;             x++;$             if (x == image->columns)               {+=                 if (TIFFWriteScanline(tiff,scanline,y,0) < 0)d                   break;                 q=scanline;                  x=0;                 y++;               }s           }c           p++;	         } "         (void) free((char *) red);$         (void) free((char *) green);#         (void) free((char *) blue);t       }l     else       if (image->colors > 2)*         for (i=0; i < image->packets; i++)	         {n.           for (j=0; j <= (int) p->length; j++)           {;             /*L               Convert PseudoClass packets to contiguous grayscale scanlines.             */?             *q++=(unsigned char) image->colormap[p->index].red;              x++;$             if (x == image->columns)               {G=                 if (TIFFWriteScanline(tiff,scanline,y,0) < 0)m                   break;                 q=scanline;i                 x=0;                 y++;               }c           }o           p++;	         }1
       else	         {c            register unsigned char             bit,             byte,i             polarity;o             /*K             Convert PseudoClass packets to contiguous monochrome scanlines.            */           polarity=0;+!           if (image->colors == 2)m             polarity=aL               Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           bit=0;           byte=0;[           x=0;,           for (i=0; i < image->packets; i++)           {+0             for (j=0; j <= (int) p->length; j++)
             {0               byte<<=1;)'               if (p->index == polarity)c                 byte|=0x01;0               bit++;               if (bit == 8)                  {f                   *q++=byte;                   bit=0;                   byte=0;x                 }r               x++;&               if (x == image->columns)                 {                    /*1                     Advance to the next scanline.4                   */                   if (bit != 0)e)                     *q++=byte << (8-bit);e?                   if (TIFFWriteScanline(tiff,scanline,y,0) < 0))                     break;                   q=scanline;i                   bit=0;                   byte=0;                    x=0;                   y++;                }
             }              p++;           }-	         } !   (void) free((char *) scanline);u   (void) TIFFFlushData(tiff); "   if (image_info->verbose == True)*     TIFFPrintDirectory(tiff,stderr,False);   (void) TIFFClose(tiff);    if (image->temporary)      { 
       FILE         *file;  	       inta
         c;         /*7         Copy temporary file to standard output or pipe.        */'       file=fopen(image->filename,"rb");         if (file == (FILE *) NULL)	         { 9           Warning("Unable to read file",image->filename);s           return(False);	         }v       c=fgetc(file);       while (c != EOF)       {0)         (void) putc(c,encode_image.file);e         c=fgetc(file);       }e       (void) fclose(file);%       (void) unlink(image->filename);)'       (void) CloseImage(&encode_image);>     }    return(True);i }  #elsen4 static unsigned int WriteTIFFImage(image_info,image)	 ImageInfo    *image_info;   Imageu	   *image;e {i   unsigned int     status;v  ;   Warning("TIFF library is not available",image->filename); *   status=WriteMIFFImage(image_info,image);   return(status);i }; #endif t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%FO %                                                                             %aO %                                                                             %mO %                                                                             %nO %   W r i t e V I C A R I m a g e                                             % O %                                                                             %tO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function WriteVICARImage writes an image in the VICAR rasterfile format.  % 0 %  The format of the WriteVICARImage routine is: % / %      status=WriteVICARImage(image_info,image)  % + %  A description of each parameter follows.  % L %    o status: Function WriteVICARImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.% %%. %    o image:  A pointer to a Image structure. %  %  */5 static unsigned int WriteVICARImage(image_info,image)y	 ImageInfon   *image_info;   Image 	   *image;e {r   unsigned int     status;t  7   Warning("Cannot write VICAR images",image->filename);)*   status=WriteMIFFImage(image_info,image);   return(status);s }u F /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%dO %                                                                             % O %                                                                             %aO %                                                                             %aO %   W r i t e V I F F I m a g e                                               %iO %                                                                             %sO %                                                                             %tO %                                                                             %UO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%n %lN %  Function WriteVIFFImage writes an image to a file in the VIFF image format. %y/ %  The format of the WriteVIFFImage routine is:u %*. %      status=WriteVIFFImage(image_info,image) %x+ %  A description of each parameter follows.  %nK %    o status: Function WriteVIFFImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %iA %    o image_info: Specifies a pointer to an ImageInfo structure.  %i. %    o image:  A pointer to a Image structure. %m %i */4 static unsigned int WriteVIFFImage(image_info,image)	 ImageInfo;   *image_info;   Image 	   *image;) {  #define VFF_CM_genericRGB  15% #define VFF_CM_NONE  0 #define VFF_DEP_IEEEORDER  0x2 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1      typedef struct _ViffHeader   {      char       identifier,        file_type,       release,       version,       machine_dependency,        reserve[3],        comment[512];        unsigned long        rows,        columns,       subrows;       long       x_offset,        y_offset;        unsigned int       x_pixel_size,        y_pixel_size;%       unsigned long%       location_type,       location_dimension,%       number_of_images,H       number_data_bands,       data_storage_type,       data_encode_scheme,u       map_scheme,t       map_storage_type,c       map_rows,i       map_columns,       map_subrows,       map_enable,e       maps_per_cycle,i       color_space_model;   } ViffHeader;m     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;m     unsigned chart     buffer[8],     *viff_pixels;i     unsigned long      packets;     ViffHeader     viff_header;     /*     Open output image file.i   */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)e     {i5       Warning("Unable to open file",image->filename);        return(False);     }_   /*$     Initialize VIFF image structure.   */   viff_header.identifier=0xab;   viff_header.file_type=1;   viff_header.release=1;   viff_header.version=3;M   viff_header.machine_dependency=VFF_DEP_IEEEORDER;  /* IEEE byte ordering */    *viff_header.comment='\0';'   if (image->comments != (char *) NULL)a     {e9       (void) strncpy(viff_header.comment,image->comments,%0         Min((int) strlen(image->comments),511));G       viff_header.comment[Min((int) strlen(image->comments),511)]='\0';      } "   viff_header.rows=image->columns;"   viff_header.columns=image->rows;   viff_header.subrows=0;   viff_header.x_offset=(~0);   viff_header.y_offset=(~0);   viff_header.x_pixel_size=0;    viff_header.y_pixel_size=0; -   viff_header.location_type=VFF_LOC_IMPLICIT; #   viff_header.location_dimension=0; !   viff_header.number_of_images=1; -   viff_header.data_encode_scheme=VFF_DES_RAW; %   viff_header.map_scheme=VFF_MS_NONE; /   viff_header.map_storage_type=VFF_MAPTYP_NONE;    viff_header.map_rows=0;%   viff_header.map_columns=0;   viff_header.map_subrows=0;.   viff_header.map_enable=1;  /* no colormap */   viff_header.maps_per_cycle=0;    if (!IsPseudoClass(image))     {i       /*         Full color VIFF raster.=       */9       viff_header.number_data_bands=image->matte ? 4 : 3;t6       viff_header.color_space_model=VFF_CM_genericRGB;3       viff_header.data_storage_type=VFF_TYP_1_BYTE;iG       packets=image->columns*image->rows*viff_header.number_data_bands;i     }r   else     {o&       viff_header.number_data_bands=1;0       viff_header.color_space_model=VFF_CM_NONE;3       viff_header.data_storage_type=VFF_TYP_1_BYTE;E)       packets=image->columns*image->rows;        if (!IsGrayImage(image))	         {c           /*$             Colormapped VIFF raster.           */3           viff_header.map_scheme=VFF_MS_ONEPERBAND; 9           viff_header.map_storage_type=VFF_MAPTYP_1_BYTE;l!           viff_header.map_rows=3;80           viff_header.map_columns=image->colors;	         }!
       else         if (image->colors == 2)=           {2             /*%               Monochrome VIFF raster.              */6             viff_header.data_storage_type=VFF_TYP_BIT;:             packets=((image->columns+7) >> 3)*image->rows;           }m     }    /*0     Write VIFF image header (pad to 1024 bytes).   */#   buffer[0]=viff_header.identifier;k"   buffer[1]=viff_header.file_type;    buffer[2]=viff_header.release;    buffer[3]=viff_header.version;+   buffer[4]=viff_header.machine_dependency; #   buffer[5]=viff_header.reserve[0]; #   buffer[6]=viff_header.reserve[1];q#   buffer[7]=viff_header.reserve[2]; 1   (void) fwrite((char *) buffer,1,8,image->file);a@   (void) fwrite((char *) viff_header.comment,1,512,image->file);2   MSBFirstWriteLong(viff_header.rows,image->file);5   MSBFirstWriteLong(viff_header.columns,image->file); 5   MSBFirstWriteLong(viff_header.subrows,image->file); F   MSBFirstWriteLong((unsigned long) viff_header.x_offset,image->file);F   MSBFirstWriteLong((unsigned long) viff_header.y_offset,image->file);J   MSBFirstWriteLong((unsigned long) viff_header.x_pixel_size,image->file);J   MSBFirstWriteLong((unsigned long) viff_header.y_pixel_size,image->file);;   MSBFirstWriteLong(viff_header.location_type,image->file); @   MSBFirstWriteLong(viff_header.location_dimension,image->file);>   MSBFirstWriteLong(viff_header.number_of_images,image->file);?   MSBFirstWriteLong(viff_header.number_data_bands,image->file);e?   MSBFirstWriteLong(viff_header.data_storage_type,image->file);r@   MSBFirstWriteLong(viff_header.data_encode_scheme,image->file);8   MSBFirstWriteLong(viff_header.map_scheme,image->file);>   MSBFirstWriteLong(viff_header.map_storage_type,image->file);6   MSBFirstWriteLong(viff_header.map_rows,image->file);9   MSBFirstWriteLong(viff_header.map_columns,image->file);i9   MSBFirstWriteLong(viff_header.map_subrows,image->file); 8   MSBFirstWriteLong(viff_header.map_enable,image->file);<   MSBFirstWriteLong(viff_header.maps_per_cycle,image->file);?   MSBFirstWriteLong(viff_header.color_space_model,image->file);u   for (i=0; i < 420; i++)0#     (void) fputc('\0',image->file);)   /*'     Convert MIFF to VIFF raster pixels.    */F   viff_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char));,   if (viff_pixels == (unsigned char *) NULL)     {)9       Warning("Unable to allocate memory",(char *) NULL);t       return(False);     }i   p=image->pixels;   q=viff_pixels;   if (!IsPseudoClass(image))     {        unsigned longi         offset;g         /*5         Convert DirectClass packet to VIFF RGB pixel.        */(       offset=image->columns*image->rows;(       for (i=0; i < image->packets; i++)       {u,         for (j=0; j <= (int) p->length; j++)	         {z           *q=p->red;           *(q+offset)=p->green;a            *(q+offset*2)=p->blue;           if (image->matte)a3             *(q+offset*3)=(unsigned char) p->index;r           q++;	         }(         p++;       }      }    else     if (!IsGrayImage(image))       {f         unsigned charn           *viff_colormap;   
         /*            Dump colormap to file.
         */'         viff_colormap=(unsigned char *)l8           malloc(image->colors*3*sizeof(unsigned char));4         if (viff_colormap == (unsigned char *) NULL)           { ?             Warning("Unable to allocate memory",(char *) NULL);q             return(False);           }          q=viff_colormap;)         for (i=0; i < image->colors; i++)u&           *q++=image->colormap[i].red;)         for (i=0; i < image->colors; i++)((           *q++=image->colormap[i].green;)         for (i=0; i < image->colors; i++)m'           *q++=image->colormap[i].blue; E         (void) fwrite((char *) viff_colormap,1,(int) image->colors*3,n           image->file); ,         (void) free((char *) viff_colormap);
         /*@           Convert PseudoClass packet to VIFF colormapped pixels.
         */         q=viff_pixels;*         for (i=0; i < image->packets; i++)	         {f.           for (j=0; j <= (int) p->length; j++)             *q++=p->index;           p++;	         }        }      else       if (image->colors == 2) 	         {r            register unsigned char             bit,             byte,a             polarity;              register int             x;             /*A             Convert PseudoClass image to a VIFF monochrome image.c           */           polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);           x=0;           bit=0;           byte=0;g,           for (i=0; i < image->packets; i++)           {o0             for (j=0; j <= (int) p->length; j++)
             {u               byte>>=1;l'               if (p->index == polarity)f                 byte|=0x80;                bit++;               if (bit == 8)f                 {                    *q++=byte;                   bit=0;                   byte=0;                  }u               x++;&               if (x == image->columns)                 {r                   /*1                     Advance to the next scanline.u                   */                   if (bit != 0)e)                     *q++=byte >> (8-bit);                    bit=0;                   byte=0;n                   x=0;                }
             }              p++;           } 	         }2
       else	         {r           /*?             Convert PseudoClass packet to VIFF grayscale pixel.            */,           for (i=0; i < image->packets; i++)           { 0             for (j=0; j <= (int) p->length; j++)               *q++=p->red;             p++;           }r	         }cB   (void) fwrite((char *) viff_pixels,1,(int) packets,image->file);$   (void) free((char *) viff_pixels);   CloseImage(image);   return(True);. }s e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             %.O %                                                                             % O %   W r i t e X I m a g e                                                     %uO %                                                                             %rO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %f7 %  Function WriteXImage writes an image to an X server.t %c, %  The format of the WriteXImage routine is: %%+ %      status=WriteXImage(image_info,image)% %%+ %  A description of each parameter follows.  % L %    o status: Function WriteXImage return True if the image is displayed onK %      the X server.  False is returned is there is a memory shortage or if % %      the image file fails to write.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */1 static unsigned int WriteXImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    Atom     wm_delete_window,      wm_protocols;      char     *resource_value;  	   Display%
     *display;%     register char%     *p;%     unsigned int     status;      XResourceInfoJ     resource_info;  
   XrmDatabase      resource_database,     server_database;     XEvent
     event;     XPixelInfo     pixel_info;t     XStandardColormap      *map_info;  
   XVisualInfom     *visual_info;   
   XWindowInfor     window_info;     /*     Open X server connection.a   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {t.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));n       return(False);     }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);o   /*/     Get user defaults from X resource database.    */   XrmInitialize();+   XGetDefault(display,client_name,"dummy");f,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display); &   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value); 8   XrmMergeDatabases(server_database,&resource_database);A   XGetResourceInfo(resource_database,client_name,&resource_info);e   /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)iM     Warning("Unable to create standard colormap","Memory allocation failed");m   else     {a       /*         Initialize visual info.L       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;r/       pixel_info.pixels=(unsigned long *) NULL;      }    /*     Initialize atoms.p   */9   wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False); A   wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);uI   if ((wm_protocols == (Atom) NULL) || (wm_delete_window == (Atom) NULL))f7     Warning("Unable to create property",(char *) NULL);_1   if ((map_info == (XStandardColormap *) NULL) ||i.       (visual_info == (XVisualInfo *) NULL) ||I       (wm_protocols == (Atom) NULL) || (wm_delete_window == (Atom) NULL))e     { F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }    /*!     Initialize Standard Colormap.    */J   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);T(   pixel_info.annotate_context=(GC) NULL;)   pixel_info.highlight_context=(GC) NULL;j&   pixel_info.widget_context=(GC) NULL;   /*%     Initialize window info structure.t   */   window_info.id=(Window) NULL; O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL, !     &resource_info,&window_info);m.   p=image->filename+strlen(image->filename)-1;2   while ((p > image->filename) && (*(p-1) != '/'))     p--;   window_info.name=p;*#   window_info.width=image->columns;*!   window_info.height=image->rows; C   window_info.attributes.event_mask=ButtonPressMask | ExposureMask;fP   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);   /*     Initialize graphic context.    */   window_info.annotate_context= ;     XCreateGC(display,window_info.id,0,(XGCValues *) NULL);f0   if (window_info.annotate_context == (GC) NULL)7     Warning("Unable to create property",(char *) NULL);j   /*     Initialize X image.    */M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,l     image->rows);0   if (status == False)4     Warning("Unable to make X image",(char *) NULL);G   if ((status == False) || (window_info.annotate_context == (GC) NULL))      {q>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);       return(False);     }n   /*4     Display image and wait for button press to exit.   */%   XMapWindow(display,window_info.id);=
   for ( ; ; )h   {)     XNextEvent(display,&event);i"     if (event.type == ButtonPress)       break;$     if (event.type == ClientMessage)5       if (event.xclient.message_type == wm_protocols) 6         if (*event.xclient.data.l == wm_delete_window)5           if (event.xclient.window == window_info.id)e             break;     if (event.type == Expose)r2       XRefreshWindow(display,&window_info,&event);   }w=   XWithdrawWindow(display,window_info.id,window_info.screen);n   /*     Free X resources.    */O   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,,!     &resource_info,&window_info);p   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %TO %                                                                             %fO %                                                                             %aO %   W r i t e X B M I m a g e                                                 %(O %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure WriteXBMImage writes an image to a file in the X bitmap format. % . %  The format of the WriteXBMImage routine is: % - %      status=WriteXBMImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteXBMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file% %      fails to write. %%A %    o image_info: Specifies a pointer to an ImageInfo structure.t %P. %    o image:  A pointer to a Image structure. %b %  */3 static unsigned int WriteXBMImage(image_info,image) 	 ImageInfor   *image_info;   Imager	   *image;  {    char     name[MaxTextLength];     register int     i,     j,     x;     register char      *q;      register RunlengthPacket     *p;n     register unsigned char     bit,	     byte,e
     polarity;      unsigned int
     count;     /*     Open output image file.    */   OpenImage(image,"w");s#   if (image->file == (FILE *) NULL)      { 5       Warning("Unable to open file",image->filename);/       return(False);     }P   /*     Write X bitmap header.   */&   (void) strcpy(name,image->filename);	   q=name;i%   while ((*q != '.') && (*q != '\0'))      q++;   if (*q == '.')     *q='\0';J   (void) fprintf(image->file,"#define %s_width %u\n",name,image->columns);H   (void) fprintf(image->file,"#define %s_height %u\n",name,image->rows);A   (void) fprintf(image->file,"static char %s_bits[] = {\n",name);l"   (void) fprintf(image->file," ");   /*$     Convert MIFF to X bitmap pixels.   */=   QuantizeImage(image,2,8,image_info->dither,GRAYColorspace);g   SyncImage(image);z
   polarity=0;>   if (image->colors == 2) K     polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]);l   bit=0;	   byte=0;h
   count=0;   x=0;   p=image->pixels;"   (void) fprintf(image->file," ");$   for (i=0; i < image->packets; i++)   {i*     for (j=0; j <= ((int) p->length); j++)     {t       byte>>=1;e       if (p->index == polarity)i         byte|=0x80;;       bit++;       if (bit == 8)m	         {            /*2             Write a bitmap byte to the image file.           */=           (void) fprintf(image->file,"0x%02x, ",byte & 0xff);l           count++;           if (count == 12)
             { 1               (void) fprintf(image->file,"\n  ");r               count=0;             };           bit=0;           byte=0;a	         }p
       x++;       if (x == image->columns)	         {e           if (bit != 0))
             {i               /*6                 Write a bitmap byte to the image file.               */               byte>>=(8-bit); A               (void) fprintf(image->file,"0x%02x, ",byte & 0xff);%               count++;               if (count == 12)                 { 5                   (void) fprintf(image->file,"\n  ");                    count=0;                 };               bit=0;               byte=0;              };           x=0;	         }      }      p++;   } %   (void) fprintf(image->file,"};\n");    CloseImage(image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %aO %   W r i t e X C I m a g e                                                   % O %                                                                             % O %                                                                             %mO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eH %  Function WriteXCImage writes an image in the X constant image format. % - %  The format of the WriteXCImage routine is:p %t, %      status=WriteXCImage(image_info,image) %g+ %  A description of each parameter follows.m %II %    o status: Function WriteXCImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image fileq %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.e %e. %    o image:  A pointer to a Image structure. %  %e */2 static unsigned int WriteXCImage(image_info,image)	 ImageInfop   *image_info;   Imagef	   *image;l {=   unsigned int     status;   4   Warning("Cannot write XC images",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);/ }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %lO %                                                                             %pO %                                                                             %jO %   W r i t e X P M I m a g e                                                 % O %                                                                             % O %                                                                             %;O %                                                                             %%O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure WriteXPMImage writes an image to a file in the X pixmap format. % . %  The format of the WriteXPMImage routine is: % - %      status=WriteXPMImage(image_info,image)  % + %  A description of each parameter follows.  % J %    o status: Function WriteXPMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %% %% */
 #ifdef HasXPM% #include "xpm.h"3 static unsigned int WriteXPMImage(image_info,image)e	 ImageInfot   *image_info;   Imager	   *image;W {e   char     *resource_value,     *xpm_buffer;  	   Displaye
     *display;      ints     status;a     register chars     *p;      XResourceInfoo     resource_info;  
   XrmDatabasem     resource_database,     server_database;     XImage     *matte_image;f     XPixelInfo     pixel_info;      XpmAttributesi     xpm_attributes;a     XStandardColormapo     *map_info;  
   XVisualInfo      *visual_info;s  
   XWindowInfo      window_info;     /*     Open output image file.g   */   OpenImage(image,"w"); #   if (image->file == (FILE *) NULL)i     { 5       Warning("Unable to open file",image->filename);l       return(False);     }-   /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     {a.       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));i       return(False);     }s   /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);i   /*/     Get user defaults from X resource database.*   */   XrmInitialize();+   XGetDefault(display,client_name,"dummy");m,   resource_database=XrmGetDatabase(display);1   resource_value=XResourceManagerString(display); &   if (resource_value == (char *) NULL)     resource_value="";7   server_database=XrmGetStringDatabase(resource_value);(8   XrmMergeDatabases(server_database,&resource_database);A   XGetResourceInfo(resource_database,client_name,&resource_info); )   resource_info.colormap=PrivateColormap;c   /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL)pM     Warning("Unable to create standard colormap","Memory allocation failed");    else     {n       /*         Initialize visual info.o       */C       visual_info=XBestVisualInfo(display,map_info,&resource_info); .       if (visual_info == (XVisualInfo *) NULL)B         Warning("Unable to get visual",resource_info.visual_type);)       map_info->colormap=(Colormap) NULL;p/       pixel_info.pixels=(unsigned long *) NULL;(     }a1   if ((map_info == (XStandardColormap *) NULL) ||c,       (visual_info == (XVisualInfo *) NULL))     {iF       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       DestroyImage(image);       return(False);     }(   matte_image=(XImage *) NULL;   if (image->matte)\     {m       /*         Create X shape image.>       */H       matte_image=XCreateImage(display,visual_info->visual,1,XYBitmap,0,H         (char *) NULL,image->columns,image->rows,XBitmapPad(display),0);)       if (matte_image == (XImage *) NULL)m>         Warning("Unable to create matte image",(char *) NULL);
       else	         {            /*(             Allocate X shape image data.           */$           matte_image->data=(char *)D             malloc(matte_image->bytes_per_line*matte_image->height);1           if (matte_image->data == (char *) NULL) O             Warning("Unable to create matte image","Memory allocation failed");e           else
             {=               int                  x,                 y;                 register int                 i,                 j;  &               register RunlengthPacket                 *p;                  /*)                 Initialize X shape image.e               */               x=0;               y=0;               p=image->pixels;0               for (i=0; i < image->packets; i++)               {t4                 for (j=0; j <= (int) p->length; j++)                 {LM                   XPutPixel(matte_image,x,y,p->index == Transparent ? 0 : 1);u                   x++;*                   if (x == image->columns)                     {u                       x=0;                       y++;                     }                  }e                 p++;               }n
             }m	         }g     }r   /*!     Initialize Standard Colormap.o   */=   if ((image->class == DirectClass) || (image->colors > 256))l     {i       /**         Demote DirectClass to PseudoClass.       */B       QuantizeImage(image,256,8,image_info->dither,RGBColorspace);       SyncImage(image);      }aJ   XMakeStandardColormap(display,visual_info,&resource_info,image,map_info,     &pixel_info);l(   pixel_info.annotate_context=(GC) NULL;)   pixel_info.highlight_context=(GC) NULL;r&   pixel_info.widget_context=(GC) NULL;   /*%     Initialize window info structure.)   */   window_info.id=(Window) NULL;mO   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,m!     &resource_info,&window_info);t.   p=image->filename+strlen(image->filename)-1;2   while ((p > image->filename) && (*(p-1) != '/'))     p--;   window_info.name=p;;#   window_info.width=image->columns;%!   window_info.height=image->rows;%P   XMakeWindow(display,XRootWindow(display,visual_info->screen),(char **) NULL,0,8     (XClassHint *) NULL,(XWMHints *) NULL,&window_info);   /*     Initialize X image.    */M   status=XMakeImage(display,&resource_info,&window_info,image,image->columns,      image->rows);    if (status == False)     { 6       Warning("Unable to make X image",(char *) NULL);>       XFreeResources(display,visual_info,map_info,&pixel_info,:         (XFontStruct *) NULL,&resource_info,&window_info);       return(False);     }    /*     Intialize XPM attributes.    */   xpm_attributes.valuemask= B     XpmColormap | XpmDepth | XpmRgbFilename | XpmSize | XpmVisual;,   xpm_attributes.visual=visual_info->visual;*   xpm_attributes.depth=visual_info->depth;-   xpm_attributes.colormap=map_info->colormap;t,   xpm_attributes.rgb_fname=RGBColorDatabase;&   xpm_attributes.width=image->columns;$   xpm_attributes.height=image->rows;I   status=XpmCreateBufferFromImage(display,&xpm_buffer,window_info.ximage,g!     matte_image,&xpm_attributes);u   /*     Free X resources.r   */%   if (matte_image != (XImage *) NULL)r     XDestroyImage(matte_image);i%   XpmFreeAttributes(&xpm_attributes);eO   XFreeResources(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,e!     &resource_info,&window_info);g   if (status != XpmSuccess);     {g5       Warning("Unable to write image",(char *) NULL);a       return(False);     }e   /*     Write XPM image.   */'   status=fputs(xpm_buffer,image->file);s#   (void) free((char *) xpm_buffer);%   CloseImage(image);   return(status != EOF); }% #else%3 static unsigned int WriteXPMImage(image_info,image) 	 ImageInfo    *image_info;   Image 	   *image;  {    unsigned int     status;   :   Warning("XPM library is not available",image->filename);*   status=WriteMIFFImage(image_info,image);   return(status);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   W r i t e Y U V I m a g e                                                 %rO %                                                                             % O %                                                                             %mO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %uF %  Function WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.f %S. %  The format of the WriteYUVImage routine is: % - %      status=WriteYUVImage(image_info,image)  % + %  A description of each parameter follows.g %nJ %    o status: Function WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image files %      fails to write. %nA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %( %E */3 static unsigned int WriteYUVImage(image_info,image)m	 ImageInfom   *image_info;   Image;	   *image;  {    Imager     *reduced_image;p     register int     i;     register RunlengthPacket     *p;>     register unsigned char     *q;h     unsigned chari     *yuv_pixels;     if (!UncompressImage(image))     return(False);   /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)i     { 5       Warning("Unable to open file",image->filename);-       return(False);     }    /*     Initialize Y channel.;   */   yuv_pixels=(unsigned char *)E     malloc((3*(image->columns*image->rows)/2)*sizeof(unsigned char));r+   if (yuv_pixels == (unsigned char *) NULL),     {i9       Warning("Unable to allocate memory",(char *) NULL);f       return(False);     } +   RGBTransformImage(image,YCbCrColorspace);    p=image->pixels;   q=yuv_pixels;%2   for (i=0; i < (image->rows*image->columns); i++)   {      *q=p->red;     p++;     q++;   }    /*     Scale image.   */   image->orphan=True; #   reduced_image=ReduceImage(image);    image->orphan=False;&   if (reduced_image == (Image *) NULL)     { 7       Warning("Unable to scale image",image->filename);        return(False);     }    /*     Initialize U channel.    */   p=reduced_image->pixels;B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {      *q=p->green;     p++;     q++;   }    /*     Initialize V channel.    */   p=reduced_image->pixels;B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {%     *q=p->blue;%     p++;     q++;   }tO   (void) fwrite((char *) yuv_pixels,1,(int) (3*(image->columns*image->rows)/2),f     image->file);C#   (void) free((char *) yuv_pixels);=   DestroyImage(reduced_image);+   TransformRGBImage(image,YCbCrColorspace);o   return(True);s }u F /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %eO %                                                                             %(O %   W r i t e Y U V 3 I m a g e                                               %nO %                                                                             % O %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function WriteYUV3Image writes an image to a file in the digital YUV M %  (CCIR 601 4:1:1) format.  This function differs from WriteYUVImage in that K %  it write the Y, U, and V planes to separate files (image.Y, image.U, and  %  image.V). % / %  The format of the WriteYUV3Image routine is:  % . %      status=WriteYUV3Image(image_info,image) % + %  A description of each parameter follows.  % K %    o status: Function WriteYUV3Image return True if the image is written.%K %      False is returned is there is a memory shortage or if the image file  %      fails to write. %gA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */4 static unsigned int WriteYUV3Image(image_info,image)	 ImageInfoa   *image_info;   Image 	   *image;a {:   char     filename[MaxTextLength];     Imagei     *reduced_image;l     register int     i;     register RunlengthPacket     *p;      register unsigned char     *q;i     unsigned chars     *yuv_pixels;     if (!UncompressImage(image))     return(False);   /*     Open output image file.t   */*   (void) strcpy(filename,image->filename);'   if (strcmp(image->filename,"-") != 0)i(     (void) strcat(image->filename,".Y");   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)      {o5       Warning("Unable to open file",image->filename);        return(False);     }h   /*     Write Y channel.   */   yuv_pixels=(unsigned char *)=     malloc(image->columns*image->rows*sizeof(unsigned char));s+   if (yuv_pixels == (unsigned char *) NULL)      {a9       Warning("Unable to allocate memory",(char *) NULL);e       return(False);     }a+   RGBTransformImage(image,YCbCrColorspace);    p=image->pixels;   q=yuv_pixels;t2   for (i=0; i < (image->rows*image->columns); i++)   {      *q=p->red;     p++;     q++;   } I   (void) fwrite((char *) yuv_pixels,1,(int) (image->columns*image->rows),      image->file);g   CloseImage(image);   /*     Scale image.   */   image->orphan=True;L#   reduced_image=ReduceImage(image);o   image->orphan=False;&   if (reduced_image == (Image *) NULL)     {n7       Warning("Unable to scale image",image->filename);s       return(False);     }c   /*     Write U channel.   */2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0)h0     (void) strcat(reduced_image->filename,".U");    OpenImage(reduced_image,"wb");+   if (reduced_image->file == (FILE *) NULL)d     { =       Warning("Unable to open file",reduced_image->filename);a"       DestroyImage(reduced_image);       return(False);     }r   p=reduced_image->pixels;   q=yuv_pixels;rB   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {h     *q=p->green;     p++;     q++;   }_+   (void) fwrite((char *) yuv_pixels,1,(int)cF     (reduced_image->columns*reduced_image->rows),reduced_image->file);   CloseImage(reduced_image);   /*     Write V channel.   */2   (void) strcpy(reduced_image->filename,filename);/   if (strcmp(reduced_image->filename,"-") != 0))0     (void) strcat(reduced_image->filename,".V");    OpenImage(reduced_image,"wb");+   if (reduced_image->file == (FILE *) NULL)a     {o=       Warning("Unable to open file",reduced_image->filename);x"       DestroyImage(reduced_image);       return(False);     }d   p=reduced_image->pixels;   q=yuv_pixels;(B   for (i=0; i < (reduced_image->rows*reduced_image->columns); i++)   {d     *q=p->blue;r     p++;     q++;   }F+   (void) fwrite((char *) yuv_pixels,1,(int)oF     (reduced_image->columns*reduced_image->rows),reduced_image->file);   CloseImage(reduced_image);   DestroyImage(reduced_image);#   (void) free((char *) yuv_pixels);u+   TransformRGBImage(image,YCbCrColorspace);o+   (void) sprintf(image->filename,filename);)   return(True);e }u g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%UO %                                                                             %_O %                                                                             %iO %                                                                             % O %   W r i t e X W D I m a g e                                                 %xO %                                                                             %>O %                                                                             %)O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %ID %  Function WriteXWDImage writes an image to a file in X window dump %  rasterfile format.e %i. %  The format of the WriteXWDImage routine is: %i- %      status=WriteXWDImage(image_info,image)  %n+ %  A description of each parameter follows.) % J %    o status: Function WriteXWDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image files %      fails to write. %jA %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */3 static unsigned int WriteXWDImage(image_info,image)e	 ImageInfoa   *image_info;   Image 	   *image;  {    int      x;     register int     i,     j;     register RunlengthPacket     *p;      register unsigned char     *q;      unsigned char      *xwd_pixels;     unsigned int     bits_per_pixel,      bytes_per_line,      scanline_pad;      unsigned longa     lsb_first,     packets;     XWDFileHeadera     xwd_header;      /*     Open output image file.    */   OpenImage(image,"wb");#   if (image->file == (FILE *) NULL)(     {>5       Warning("Unable to open file",image->filename);        return(False);     }    /*     Initialize XWD file header.+   */@   xwd_header.header_size=sz_XWDheader+strlen(image->filename)+1;;   xwd_header.file_version=(unsigned long) XWD_FILE_VERSION; 3   xwd_header.pixmap_format=(unsigned long) ZPixmap; )   xwd_header.pixmap_depth=(unsigned long) +     (image->class == DirectClass ? 24 : 8); 9   xwd_header.pixmap_width=(unsigned long) image->columns;b7   xwd_header.pixmap_height=(unsigned long) image->rows;e'   xwd_header.xoffset=(unsigned long) 0;+1   xwd_header.byte_order=(unsigned long) MSBFirst;eP   xwd_header.bitmap_unit=(unsigned long) (image->class == DirectClass ? 32 : 8);7   xwd_header.bitmap_bit_order=(unsigned long) MSBFirst;rO   xwd_header.bitmap_pad=(unsigned long) (image->class == DirectClass ? 32 : 8);q8   bits_per_pixel=(image->class == DirectClass ? 24 : 8);;   xwd_header.bits_per_pixel=(unsigned long) bits_per_pixel;c?   bytes_per_line=(unsigned long) ((((xwd_header.bits_per_pixel*;:     xwd_header.pixmap_width)+((xwd_header.bitmap_pad)-1))/=     (xwd_header.bitmap_pad))*((xwd_header.bitmap_pad) >> 3));c;   xwd_header.bytes_per_line=(unsigned long) bytes_per_line; )   xwd_header.visual_class=(unsigned long)->     (image->class == DirectClass ? DirectColor : PseudoColor);%   xwd_header.red_mask=(unsigned long)01     (image->class == DirectClass ? 0xff0000 : 0);i'   xwd_header.green_mask=(unsigned long) /     (image->class == DirectClass ? 0xff00 : 0); P   xwd_header.blue_mask=(unsigned long) (image->class == DirectClass ? 0xff : 0);)   xwd_header.bits_per_rgb=(unsigned long))+     (image->class == DirectClass ? 24 : 8);l-   xwd_header.colormap_entries=(unsigned long))8     (image->class == DirectClass ? 256 : image->colors);G   xwd_header.ncolors=(image->class == DirectClass ? 0 : image->colors);%9   xwd_header.window_width=(unsigned long) image->columns; 7   xwd_header.window_height=(unsigned long) image->rows;    xwd_header.window_x=0;   xwd_header.window_y=0;/   xwd_header.window_bdrwidth=(unsigned long) 0;    /*     Write XWD header.    */   lsb_first=1;   if (*(char *) &lsb_first) ?     MSBFirstOrderLong((char *) &xwd_header,sizeof(xwd_header)); A   (void) fwrite((char *) &xwd_header,sz_XWDheader,1,image->file); E   (void) fwrite((char *) image->filename,1,strlen(image->filename)+1,      image->file); "   if (image->class == PseudoClass)     {        XColor         *colors;         XWDColor         color;         /*         Dump colormap to file.       */=       colors=(XColor *) malloc(image->colors*sizeof(XColor));i$       if (colors == (XColor *) NULL)	         {g=           Warning("Unable to allocate memory",(char *) NULL);            return(False);	         }a'       for (i=0; i < image->colors; i++)a       {t         colors[i].pixel=i;2         colors[i].red=image->colormap[i].red << 8;6         colors[i].green=image->colormap[i].green << 8;4         colors[i].blue=image->colormap[i].blue << 8;1         colors[i].flags=DoRed | DoGreen | DoBlue;t         colors[i].pad=0;!         if (*(char *) &lsb_first)            {rF             MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(long));H             MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(short));           }t       }n'       for (i=0; i < image->colors; i++)f       { $         color.pixel=colors[i].pixel;          color.red=colors[i].red;$         color.green=colors[i].green;"         color.blue=colors[i].blue;$         color.flags=colors[i].flags;A         (void) fwrite((char *) &color,sz_XWDColor,1,image->file);h       }I#       (void) free((char *) colors);T     }    /*&     Convert MIFF to XWD raster pixels.   */%   packets=bytes_per_line*image->rows;    xwd_pixels=(unsigned char *)9     malloc((unsigned int) packets*sizeof(unsigned char)); +   if (xwd_pixels == (unsigned char *) NULL)      {e9       Warning("Unable to allocate memory",(char *) NULL);        return(False);     }o   scanline_pad=(unsigned int)_<     (bytes_per_line-((image->columns*bits_per_pixel) >> 3));   x=0;   p=image->pixels;   q=xwd_pixels; $   for (i=0; i < image->packets; i++)   { *     for (j=0; j <= ((int) p->length); j++)     {n&       if (image->class == PseudoClass)         *q++=p->index;
       else	         {            *q++=p->red;           *q++=p->green;           *q++=p->blue;p	         }i
       x++;       if (x == image->columns)	         {s           q+=scanline_pad;           x=0;	         }n     }s     p++;   }f   /*     Dump pixels to file.   */A   (void) fwrite((char *) xwd_pixels,1,(int) packets,image->file);u#   (void) free((char *) xwd_pixels);g   CloseImage(image);   return(True);  }L   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %(O %                                                                             %mO %                                                                             % O %   W r i t e I m a g e                                                       % O %                                                                             %(O %                                                                             %*O %                                                                             %UO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %nD %  Function WriteImage writes an image to a file.  You can specify aJ %  particular image format by prefixing the file with the image type and aI %  colon (i.e. ps:image) or specify the image type as the filename suffixt %  (i.e. image.ps).a %e+ %  The format of the WriteImage routine is:e %c* %      status=WriteImage(image_info,image) % + %  A description of each parameter follows:b %_G %    o status: Function WriteImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file; %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.o %n- %    o image: A pointer to a Image structure.l %  %x */) unsigned int WriteImage(image_info,image)r	 ImageInfoo   *image_info;   Imagei	   *image;m {v   unsigned int     status;e     /*6     Call appropriate image writer based on image type.   */6   (void) strcpy(image_info->filename,image->filename);2   (void) strcpy(image_info->magick,image->magick);   SetImageMagick(image_info);p6   (void) strcpy(image->filename,image_info->filename);2   (void) strcpy(image->magick,image_info->magick);   switch (*image_info->magick)   { 
     case 'A':t     {r-       status=WriteAVSImage(image_info,image);r       break;     } 
     case 'B':e     {e-       status=WriteBMPImage(image_info,image);        break;     }r
     case 'C':e     {S.       status=WriteCMYKImage(image_info,image);       break;     }.
     case 'E':)     {S,       status=WritePSImage(image_info,image);       break;     }S
     case 'F':n     {h0       if (strcmp(image_info->magick,"FAX") == 0)/         status=WriteFAXImage(image_info,image);c
       else0         status=WriteFITSImage(image_info,image);       break;     }S
     case 'G':O     {-0       if (strcmp(image_info->magick,"GIF") == 0)/         status=WriteGIFImage(image_info,image);/
       else4         if (strcmp(image_info->magick,"GIF87") == 0)1           status=WriteGIFImage(image_info,image);t         else5           if (strcmp(image_info->magick,"GRAY") == 0)a4             status=WriteGRAYImage(image_info,image);           else3             status=WriteFAXImage(image_info,image);g       break;     };
     case 'H':t     {f3       status=WriteHISTOGRAMImage(image_info,image);L       break;     } 
     case 'I':      {g.       status=WriteIRISImage(image_info,image);       break;     }o
     case 'J':-     { .       status=WriteJPEGImage(image_info,image);       break;     }e
     case 'M':g     {)0       if (strcmp(image_info->magick,"MAP") == 0)/         status=WriteMAPImage(image_info,image);h
       else4         if (strcmp(image_info->magick,"MATTE") == 0)3           status=WriteMATTEImage(image_info,image);a         else5           if (strcmp(image_info->magick,"MIFF") == 0)s4             status=WriteMIFFImage(image_info,image);           else;             if ((strcmp(image_info->magick,"MPEG") == 0) ||)8                 (strcmp(image_info->magick,"MPG") == 0))6               status=WriteMPEGImage(image_info,image);             else5               status=WriteMTVImage(image_info,image);x       break;     } 
     case 'N':o       break;
     case 'P':i     { 0       if (strcmp(image_info->magick,"PCD") == 0)/         status=WritePCDImage(image_info,image);e
       else2         if (strcmp(image_info->magick,"PCX") == 0)1           status=WritePCXImage(image_info,image);)         else5           if (strcmp(image_info->magick,"PICT") == 0) 4             status=WritePICTImage(image_info,image);           else5             if (strcmp(image_info->magick,"PM") == 0) 5               status=WriteXPMImage(image_info,image);>             else7               if (strcmp(image_info->magick,"PS") == 0)F6                 status=WritePSImage(image_info,image);               else:                 if (strcmp(image_info->magick,"PS2") == 0)                   status=e4                     WritePS2Image(image_info,image);                 else9                   status=WritePNMImage(image_info,image);i       break;     }L
     case 'R':o     {m0       if (strcmp(image_info->magick,"RAD") == 0)4         status=WriteRADIANCEImage(image_info,image);
       else2         if (strcmp(image_info->magick,"RAS") == 0)1           status=WriteSUNImage(image_info,image);d         else4           if (strcmp(image_info->magick,"RGB") == 0)3             status=WriteRGBImage(image_info,image);t           else3             status=WriteRLEImage(image_info,image);t       break;     } 
     case 'S':      {S-       status=WriteSUNImage(image_info,image);s       break;     } 
     case 'T':      {-0       if (strcmp(image_info->magick,"TGA") == 0)1         status=WriteTARGAImage(image_info,image); 
       else6         if ((strcmp(image_info->magick,"TIF") == 0) ||5             (strcmp(image_info->magick,"TIFF") == 0)) 2           status=WriteTIFFImage(image_info,image);         else2           status=WriteTEXTImage(image_info,image);       break;     }o
     case 'V':>     { 2       if (strcmp(image_info->magick,"VICAR") == 0)1         status=WriteVICARImage(image_info,image);n
       else2         if (strcmp(image_info->magick,"VID") == 0)2           status=WriteMIFFImage(image_info,image);         else2           status=WriteVIFFImage(image_info,image);       break;     }r
     case 'X':u     {t.       if (strcmp(image_info->magick,"X") == 0)-         status=WriteXImage(image_info,image);F
       else2         if (strcmp(image_info->magick,"XBM") == 0)1           status=WriteXBMImage(image_info,image);i         else3           if (strcmp(image_info->magick,"XC") == 0))2             status=WriteXCImage(image_info,image);           else6             if (strcmp(image_info->magick,"XPM") == 0)5               status=WriteXPMImage(image_info,image);              else7               if (strcmp(image_info->magick,"XV") == 0) 8                 status=WriteVIFFImage(image_info,image);               else7                 status=WriteXWDImage(image_info,image);a       break;     } 
     case 'Y':      { 0       if (strcmp(image_info->magick,"YUV") == 0)/         status=WriteYUVImage(image_info,image);s
       else0         status=WriteYUV3Image(image_info,image);       break;     }      default:.       status=WriteMIFFImage(image_info,image);   }t   if (image->status)     {uG       Warning("An error has occurred writing to file",image->filename);=       return(False);     }    return(status);a }>