 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %           QQQ   U   U   AAA   N   N  TTTTT  IIIII   ZZZZZ  EEEEE            % O %          Q   Q  U   U  A   A  NN  N    T      I        ZZ  E                % O %          Q   Q  U   U  AAAAA  N N N    T      I      ZZZ   EEEEE            % O %          Q  QQ  U   U  A   A  N  NN    T      I     ZZ     E                % O %           QQQQ   UUU   A   A  N   N    T    IIIII   ZZZZZ  EEEEE            % O %                                                                             % O %                                                                             % O %              Reduce the Number of Unique Colors in an Image                 % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Realism in computer graphics typically requires using 24 bits/pixel to F %  generate an image.  Yet many graphic display devices do not contain@ %  the amount of memory necessary to match the spatial and colorD %  resolution of the human eye.  The QUANTIZE program takes a 24 bitC %  image and reduces the number of colors so it can be displayed on B %  raster device with less bits per pixel.  In most instances, theB %  quantized image closely resembles the original reference image. % @ %  A reduction of colors in an image is also desirable for image( %  transmission and real-time animation. % L %  Function Quantize takes a standard RGB or monochrome images and quantizes, %  them down to some fixed number of colors. % I %  For purposes of color allocation, an image is a set of n pixels, where D %  each pixel is a point in RGB space.  RGB space is a 3-dimensionalH %  vector space, and each pixel, pi,  is defined by an ordered triple of2 %  red, green, and blue coordinates, (ri, gi, bi). % C %  Each primary color component (red, green, or blue) represents an I %  intensity which varies linearly from 0 to a maximum value, cmax, which E %  corresponds to full saturation of that color.  Color allocation is A %  defined over a domain consisting of the cube in RGB space with H %  opposite vertices at (0,0,0) and (cmax,cmax,cmax).  QUANTIZE requires %  cmax = 255. % @ %  The algorithm maps this domain onto a tree in which each nodeE %  represents a cube within that domain.  In the following discussion F %  these cubes are defined by the coordinate of two opposite vertices:E %  The vertex nearest the origin in RGB space and the vertex farthest  %  from the origin.  % I %  The tree's root node represents the the entire domain, (0,0,0) through B %  (cmax,cmax,cmax).  Each lower level in the tree is generated byF %  subdividing one node's cube into eight smaller cubes of equal size.D %  This corresponds to bisecting the parent cube with planes passing& %  through the midpoints of each edge. % @ %  The basic algorithm operates in three phases: Classification,< %  Reduction, and Assignment.  Classification builds a colorF %  description tree for the image.  Reduction collapses the tree untilI %  the number it represents, at most, the number of colors desired in the E %  output image.  Assignment defines the output image's color map and C %  sets each pixel's color by reclassification in the reduced tree.  % D %  Classification begins by initializing a color description tree ofE %  sufficient depth to represent each possible input color in a leaf. > %  However, it is impractical to generate a fully-formed colorG %  description tree in the classification phase for realistic values of H %  cmax.  If colors components in the input image are quantized to k-bitH %  precision, so that cmax= 2k-1, the tree would need k levels below theG %  root node to allow representing each possible input color in a leaf. G %  This becomes prohibitive because the tree's total number of nodes is  %  1 + sum(i=1,k,8k).  % H %  A complete tree would require 19,173,961 nodes for k = 8, cmax = 255.E %  Therefore, to avoid building a fully populated tree, QUANTIZE: (1) F %  Initializes data structures for nodes only as they are needed;  (2)D %  Chooses a maximum depth for the tree as a function of the desiredH %  number of colors in the output image (currently log2(colormap size)). % H %  For each pixel in the input image, classification scans downward fromH %  the root of the color description tree.  At each level of the tree itB %  identifies the single node which represents a cube in RGB spaceH %  containing the pixel's color.  It updates the following data for each
 %  such node:  % C %    n1 : Number of pixels whose color is contained in the RGB cube   %    which this node represents; % F %    n2 : Number of pixels whose color is not represented in a node atF %    lower depth in the tree;  initially,  n2 = 0 for all nodes except %    leaves of the tree. % G %    Sr, Sg, Sb : Sums of the red, green, and blue component values for C %    all pixels not classified at a lower depth. The combination of H %    these sums and n2  will ultimately characterize the mean color of a, %    set of pixels represented by this node. % F %  Reduction repeatedly prunes the tree until the number of nodes withG %  n2 > 0 is less than or equal to the maximum number of colors allowed I %  in the output image.  On any given iteration over the tree, it selects F %  those nodes whose n1  count is minimal for pruning and merges theirF %  color statistics upward. It uses a pruning threshold, ns, to govern %  node selection as follows:  %  %    ns = 0 L %    while number of nodes with (n2 > 0) > required maximum number of colors) %      prune all nodes such that n1 <= ns . %      Set ns to minimum n1 in remaining nodes % H %  When a node to be pruned has offspring, the pruning procedure invokesH %  itself recursively in order to prune the tree from the leaves upward.G %  n2,  Sr, Sg,  and  Sb in a node being pruned are always added to the E %  corresponding data in that node's parent.  This retains the pruned 4 %  node's color characteristics for later averaging. % D %  For each node, n2 pixels exist for which that node represents theI %  smallest volume in RGB space containing those pixel's colors.  When n2 H %  > 0 the node will uniquely define a color in the output image. At theH %  beginning of reduction,  n2 = 0  for all nodes except a the leaves of> %  the tree which represent colors present in the input image. % B %  The other pixel count, n1, indicates the total number of colorsI %  within the cubic volume which the node represents.  This includes n1 - I %  n2  pixels whose colors should be defined by nodes at a lower level in  %  the tree. % C %  Assignment generates the output image from the pruned tree.  The D %  output image consists of two parts: (1)  A color map, which is anF %  array of color descriptions (RGB triples) for each color present inH %  the output image;  (2)  A pixel array, which represents each pixel as% %  an index into the color map array.  % C %  First, the assignment phase makes one pass over the pruned color F %  description tree to establish the image's color map.  For each nodeE %  with n2  > 0, it divides Sr, Sg, and Sb by n2 .  This produces the H %  mean color of all pixels that classify no lower than this node.  Each5 %  of these colors becomes an entry in the color map.  % G %  Finally,  the assignment phase reclassifies each pixel in the pruned G %  tree to identify the deepest node containing the pixel's color.  The I %  pixel's value in the pixel array becomes the index of this node's mean  %  color in the color map. % E %  For efficiency, QUANTIZE requires that the reference image be in a  %  run-length encoded format.  % L %  With the permission of USC Information Sciences Institute, 4676 AdmiraltyL %  Way, Marina del Rey, California  90292, this code was adapted from module# %  ALCOLS written by Paul Raveling.  % D %  The names of ISI and USC are not used in advertising or publicityD %  pertaining to distribution of the software without prior specific %  written permission from ISI.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h"   /*   Define declarations. */# #define color_number  number_colors  #define MaxNodes  266817 #define MaxShift  8 + #define MaxTreeDepth  8  /* Log2(MaxRGB) */  #define NodesInAList  2048   /*
   Structures.  */ typedef struct _Node {    struct _Node     *parent,     *child[8];     unsigned char      id, 
     level,     census,      mid_red,     mid_green,
     mid_blue;      unsigned long      number_colors,     number_unique,     total_red,     total_green,     total_blue;  } Node;    typedef struct _Nodes  {    Node     nodes[NodesInAList];     struct _Nodes 
     *next; } Nodes;   typedef struct _Cube {    Node
     *root;  
   ColorPacket 
     color,     *colormap;     unsigned int
     depth;     unsigned long      colors,      pruning_threshold,     next_pruning_threshold, 
     distance,      squares[MaxRGB+MaxRGB+1];      unsigned int     shift[MaxTreeDepth+1],
     nodes,     free_nodes,      color_number;      Node     *next_node;      Nodes      *node_queue; } Cube;    /*   Global variables.  */ static Cube    cube;    /*   Forward declarations.  */ static Node J   *InitializeNode _Declare((unsigned int,unsigned int,Node *,unsigned int,      unsigned int,unsigned int));   static unsigned int "   DitherImage _Declare((Image *));   static void "   ClosestColor _Declare((Node *)),   Colormap _Declare((Node *)),    PruneLevel _Declare((Node *));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  A s s i g n m e n t                                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure Assignment generates the output image from the pruned tree.  The D %  output image consists of two parts: (1)  A color map, which is anF %  array of color descriptions (RGB triples) for each color present inH %  the output image;  (2)  A pixel array, which represents each pixel as% %  an index into the color map array.  % C %  First, the assignment phase makes one pass over the pruned color F %  description tree to establish the image's color map.  For each nodeE %  with n2  > 0, it divides Sr, Sg, and Sb by n2 .  This produces the H %  mean color of all pixels that classify no lower than this node.  Each5 %  of these colors becomes an entry in the color map.  % G %  Finally,  the assignment phase reclassifies each pixel in the pruned G %  tree to identify the deepest node containing the pixel's color.  The I %  pixel's value in the pixel array becomes the index of this node's mean  %  color in the color map. % + %  The format of the Assignment routine is:  % 8 %      Assignment(image,number_colors,dither,colorspace) % + %  A description of each parameter follows.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % H %    o number_colors: This integer value indicates the maximum number ofI %      colors in the quantized image or colormap.  Here we use this value < %      to determine the depth of the color description tree. % E %    o dither: Set this integer value to something other than zero to I %      dither the quantized image.  The basic strategy of dithering is to I %      trade intensity resolution for spatial resolution by averaging the F %      intensities of several neighboring pixels.  Images which sufferE %      from severe contouring when quantized can be improved with the G %      technique of dithering.  Severe contouring generally occurs when E %      quantizing to very few colors, or to a poorly-chosen colormap. F %      Note, dithering is a computationally expensive process and will. %      increase processing time significantly. % K %    o colorspace: An unsigned integer value that indicates the colorspace.  %  %  */= static void Assignment(image,number_colors,dither,colorspace)  Image 	   *image;    unsigned int   number_colors,	   dither, 
   colorspace;  {    register int     i;     register Node 
     *node;     register RunlengthPacket     *p;      register unsigned int      id;      /*     Allocate image colormap.   */.   if (image->colormap != (ColorPacket *) NULL)*     (void) free((char *) image->colormap);!   image->colormap=(ColorPacket *) ;     malloc((unsigned int) cube.colors*sizeof(ColorPacket)); .   if (image->colormap == (ColorPacket *) NULL)     { E       Warning("Unable to quantize image","Memory allocation failed");        exit(1);     } (   if (image->signature != (char *) NULL)+     (void) free((char *) image->signature); !   image->signature=(char *) NULL;     cube.colormap=image->colormap;   cube.colors=0;   Colormap(cube.root);>   if ((number_colors == 2)  && (colorspace == GRAYColorspace))     {        unsigned int         polarity;          /*         Monochrome image.        */M       polarity=Intensity(image->colormap[0]) > Intensity(image->colormap[1]); &       image->colormap[polarity].red=0;(       image->colormap[polarity].green=0;'       image->colormap[polarity].blue=0; ,       image->colormap[!polarity].red=MaxRGB;.       image->colormap[!polarity].green=MaxRGB;-       image->colormap[!polarity].blue=MaxRGB;      }    image->matte=False;    image->class=PseudoClass; +   image->colors=(unsigned int) cube.colors;    /*!     Create a reduced color image.    */
   if (dither)      dither=!DitherImage(image);    p=image->pixels;   if (!dither)&     for (i=0; i < image->packets; i++)     {        /*?         Identify the deepest node containing the pixel's color.        */       node=cube.root;        for ( ; ; )        { -         id=(p->red > node->mid_red ? 1 : 0) | 5           (p->green > node->mid_green ? 1 : 0) << 1 | 1          (p->blue > node->mid_blue ? 1 : 0) << 2; +        if ((node->census & (1 << id)) == 0)           break;         node=node->child[id];      }      /* <        Find closest color among siblings and their children.      */       cube.color.red=p->red;       cube.color.green=p->green;       cube.color.blue=p->blue; (      cube.distance=(unsigned long) (~0);       ClosestColor(node->parent);       p->index=cube.color_number;	      p++;     } }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  C l a s s i f i c a t i o n                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Procedure Classification begins by initializing a color description tree H %  of sufficient depth to represent each possible input color in a leaf.> %  However, it is impractical to generate a fully-formed colorG %  description tree in the classification phase for realistic values of H %  cmax.  If colors components in the input image are quantized to k-bitH %  precision, so that cmax= 2k-1, the tree would need k levels below theG %  root node to allow representing each possible input color in a leaf. G %  This becomes prohibitive because the tree's total number of nodes is  %  1 + sum(i=1,k,8k).  % H %  A complete tree would require 19,173,961 nodes for k = 8, cmax = 255.E %  Therefore, to avoid building a fully populated tree, QUANTIZE: (1) F %  Initializes data structures for nodes only as they are needed;  (2)D %  Chooses a maximum depth for the tree as a function of the desiredH %  number of colors in the output image (currently log2(colormap size)). % H %  For each pixel in the input image, classification scans downward fromH %  the root of the color description tree.  At each level of the tree itB %  identifies the single node which represents a cube in RGB space? %  containing It updates the following data for each such node:  % C %    n1 : Number of pixels whose color is contained in the RGB cube   %    which this node represents; % F %    n2 : Number of pixels whose color is not represented in a node atF %    lower depth in the tree;  initially,  n2 = 0 for all nodes except %    leaves of the tree. % G %    Sr, Sg, Sb : Sums of the red, green, and blue component values for C %    all pixels not classified at a lower depth. The combination of H %    these sums and n2  will ultimately characterize the mean color of a, %    set of pixels represented by this node. % / %  The format of the Classification routine is:  %  %      Classification(image) % + %  A description of each parameter follows.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  %  %  */! static void Classification(image)  Image 	   *image;  {    register int     i;     register Node 
     *node;     register RunlengthPacket     *p;      register unsigned int      bisect, 
     count,     id, 
     level;     p=image->pixels;$   for (i=0; i < image->packets; i++)   {      if (cube.nodes > MaxNodes)       { 
         /*9           Prune one level if the color tree is too large. 
         */         PruneLevel(cube.root);         cube.depth--;        }      /*8       Start at the root and descend the color cube tree.     */     count=p->length+1;     node=cube.root; /     for (level=1; level <= cube.depth; level++)      { +       id=(p->red > node->mid_red ? 1 : 0) | 3         (p->green > node->mid_green ? 1 : 0) << 1 | 0         (p->blue > node->mid_blue ? 1 : 0) << 2;+       if (node->child[id] == (Node *) NULL) 	         {            /*4             Set colors of new node to contain pixel.           */            node->census|=1 << id;A           bisect=(unsigned int) (1 << (MaxTreeDepth-level)) >> 1; 7           node->child[id]=InitializeNode(id,level,node, 6             node->mid_red+(id & 1 ? bisect : -bisect),8             node->mid_green+(id & 2 ? bisect : -bisect),8             node->mid_blue+(id & 4 ? bisect : -bisect));/           if (node->child[id] == (Node *) NULL) 
             { M               Warning("Unable to quantize image","Memory allocation failed");                exit(1);
             } "           if (level == cube.depth)             cube.colors++;	         }        /*M         Record the number of colors represented by this node.  Shift by level &         in the color description tree.       */       node=node->child[id]; 6       node->number_colors+=count << cube.shift[level];     }      /*M       Increment unique color count and sum RGB values for this leaf for later (       derivation of the mean cube color.     */     node->number_unique+=count; "     node->total_red+=p->red*count;&     node->total_green+=p->green*count;$     node->total_blue+=p->blue*count;     p++;   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  C l o s e s t C o l o r                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Procedure ClosestColor traverses the color cube tree at a particular nodeG %  and determines which colormap entry best represents the input color.  % - %  The format of the ClosestColor routine is:  %  %      ClosestColor(node)  % + %  A description of each parameter follows.  % F %    o node: The address of a structure of type Node which points to a8 %      node in the color cube tree that is to be pruned. %  %  */ static void ClosestColor(node)
 register Node    *node; {    register unsigned int      id;      /*     Traverse any children.   */   if (node->census != 0)     for (id=0; id < 8; id++)#       if (node->census & (1 << id)) &         ClosestColor(node->child[id]);   if (node->number_unique != 0)      {        register ColorPacket         *color;          register unsigned int          blue_distance,         green_distance,          red_distance;          register unsigned long         distance;          /*-         Determine if this color is "closest".        */-       color=cube.colormap+node->color_number; @       red_distance=(int) color->red-(int) cube.color.red+MaxRGB;F       green_distance=(int) color->green-(int) cube.color.green+MaxRGB;C       blue_distance=(int) color->blue-(int) cube.color.blue+MaxRGB; G       distance=cube.squares[red_distance]+cube.squares[green_distance]+ $         cube.squares[blue_distance];#       if (distance < cube.distance) 	         { !           cube.distance=distance; @           cube.color_number=(unsigned short) node->color_number;	         }      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  C o l o r m a p                                                            % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Procedure Colormap traverses the color cube tree and notes each colormap H %  entry.  A colormap entry is any node in the color cube tree where the' %  number of unique colors is not zero.  % ) %  The format of the Colormap routine is:  %  %      Colormap(node)  % + %  A description of each parameter follows.  % F %    o node: The address of a structure of type Node which points to a8 %      node in the color cube tree that is to be pruned. %  %  */ static void Colormap(node)
 register Node    *node; {    register unsigned int      id;      /*     Traverse any children.   */   if (node->census != 0)     for (id=0; id < 8; id++)#       if (node->census & (1 << id)) "         Colormap(node->child[id]);   if (node->number_unique != 0)      {        /*A         Colormap entry is defined by the mean color in this cube.        */4       cube.colormap[cube.colors].red=(unsigned char)K         ((node->total_red+(node->number_unique >> 1))/node->number_unique); 6       cube.colormap[cube.colors].green=(unsigned char)M         ((node->total_green+(node->number_unique >> 1))/node->number_unique); 5       cube.colormap[cube.colors].blue=(unsigned char) L         ((node->total_blue+(node->number_unique >> 1))/node->number_unique);'       node->color_number=cube.colors++;      }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  D i t h e r I m a g e                                                      % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Procedure DitherImage uses the Floyd-Steinberg algorithm to dither the M %  image.  Refer to "An Adaptive Algorithm for Spatial GreySscale", Robert W. L %  Floyd and Louis Steinberg, Proceedings of the S.I.D., Volume 17(2), 1976. % L %  First find the closest representation to the reference pixel color in theM %  colormap, the node pixel is assigned this color.  Next, the colormap color E %  is subtracted from the reference pixels color, this represents the M %  quantization error.  Various amounts of this error are added to the pixels G %  ahead and below the node pixel to correct for this error.  The error  %  proportions are:  %  %            P     7/16  %      3/16  5/16  1/16  % N %  The error is distributed left-to-right for even scanlines and right-to-left %  for odd scanlines.  % , %  The format of the DitherImage routine is: %  %      DitherImage(image)  % + %  A description of each parameter follows.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  %  %  */& static unsigned int DitherImage(image) Image 	   *image;  {    typedef struct _ErrorPacket    {      int 
       red,       green,       blue;    } ErrorPacket;  
   ErrorPacket      *error;      int      *cache, 	     step;      Node
     *node;     register int     i,     blue_error,      *error_limit,      green_error,     red_error;     register RunlengthPacket     *q;      register ErrorPacket     *cs,     *ns;     register unsigned char     *range_limit;      unsigned char 	     blue, 
     green,     red;     unsigned int     id,      quantum,     x,     y;     unsigned short
     index;     /*     Image must be uncompressed.    */   if (!UncompressImage(image))     return(True);    /*     Allocate memory.   */.   cache=(int *) malloc((1 << 18)*sizeof(int));N   error=(ErrorPacket *) malloc(((image->columns+2) << 1)*sizeof(ErrorPacket));7   error_limit=(int *) malloc((MaxRGB*2+1)*sizeof(int)); K   range_limit=(unsigned char *) malloc(3*(MaxRGB+1)*sizeof(unsigned char)); C   if ((cache == (int *) NULL) || (error == (ErrorPacket *) NULL) || O       (error_limit == (int *) NULL) || (range_limit == (unsigned char *) NULL))      { C       Warning("Unable to dither image","Memory allocation failed");        return(True);      }    /*     Initialize color cache.    */   for (i=0; i < (1 << 18); i++)      cache[i]=(-1);   /*     Initialize error tables.   *//   for (i=0; i < ((image->columns+2) << 1); i++)    {      error[i].red=0;      error[i].green=0;      error[i].blue=0;   }    /*-     Initialize error limit (constrain error).    */$   quantum=Max(image->colors >> 4,1);   error_limit+=MaxRGB;	   step=0; *   for (i=0; i < ((MaxRGB+1)/quantum); i++)   {      error_limit[i]=step;     error_limit[-i]=(-step);     step++;    }    if (quantum > 3),     for ( ; i < (3*(MaxRGB+1)/quantum); i++)     {        error_limit[i]=step;       error_limit[-i]=(-step);       step+=(i & 0x01) ? 0 : 1;      }    for ( ; i <= MaxRGB; i++)    {      error_limit[i]=step;     error_limit[-i]=(-step);   }    /*     Initialize range tables.   */   for (i=0; i <= MaxRGB; i++)    {      range_limit[i]=0; 0     range_limit[i+(MaxRGB+1)]=(unsigned char) i;'     range_limit[i+(MaxRGB+1)*2]=MaxRGB;    }    range_limit+=(MaxRGB+1);   /*     Dither image.    */!   for (y=0; y < image->rows; y++)    { %     q=image->pixels+image->columns*y;      cs=error+1;      ns=cs+image->columns+2;      step=y & 0x01 ? -1 : 1;      if (step < 0)        { 
         /*;           Distribute error right-to-left for odd scanlines. 
         */         q+=(image->columns-1);          ns=error+image->columns;         cs=ns+image->columns+2;        } &     for (x=0; x < image->columns; x++)     { ,       red_error=error_limit[(cs->red+8)/16];0       green_error=error_limit[(cs->green+8)/16];.       blue_error=error_limit[(cs->blue+8)/16];.       red=range_limit[(int) q->red+red_error];4       green=range_limit[(int) q->green+green_error];1       blue=range_limit[(int) q->blue+blue_error]; 9       i=(blue >> 2) << 12 | (green >> 2) << 6 | red >> 2;        if (cache[i] < 0) 	         {            /*C             Identify the deepest node containing the pixel's color.            */           node=cube.root;            for ( ; ; )            { .             id=(red > node->mid_red ? 1 : 0) |6               (green > node->mid_green ? 1 : 0) << 1 |3               (blue > node->mid_blue ? 1 : 0) << 2; 0             if ((node->census & (1 << id)) == 0)               break;!             node=node->child[id];            }            /*A             Find closest color among siblings and their children.            */           cube.color.red=red; !           cube.color.green=green;            cube.color.blue=blue; -           cube.distance=(unsigned long) (~0); %           ClosestColor(node->parent); %           cache[i]=cube.color_number; 	         } &       index=(unsigned short) cache[i];9       red_error=(int) red-(int) cube.colormap[index].red; ?       green_error=(int) green-(int) cube.colormap[index].green; <       blue_error=(int) blue-(int) cube.colormap[index].blue;       q->index=index;        q+=step;       /*1         Propagate the error in these proportions:                  Q     7/16           3/16  5/16  1/16       */       cs->red=0;       cs->green=0;       cs->blue=0;        cs+=step;        cs->red+=7*red_error;        cs->green+=7*green_error;        cs->blue+=7*blue_error;        ns-=step;        ns->red+=3*red_error;        ns->green+=3*green_error;        ns->blue+=3*blue_error;        ns+=step;        ns->red+=5*red_error;        ns->green+=5*green_error;        ns->blue+=5*blue_error;        ns+=step;        ns->red+=red_error;        ns->green+=green_error;        ns->blue+=blue_error;      }    }    /*     Free up memory.    */   range_limit-=(MaxRGB+1);$   (void) free((char *) range_limit);   error_limit-=MaxRGB;$   (void) free((char *) error_limit);   (void) free((char *) error);   (void) free((char *) cache);   return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  I n i t i a l i z e C u b e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function InitializeCube initialize the Cube data structure. % / %  The format of the InitializeCube routine is:  % * %      InitializeCube(number_pixels,depth) % + %  A description of each parameter follows.  % M %    o number_pixels: Specifies the number of individual pixels in the image.  % E %    o depth: Normally, this integer value is zero or one.  A zero or P %      one tells Quantize to choose a optimal tree depth of Log4(number_colors).K %      A tree of this depth generally allows the best representation of the F %      reference image with the least amount of memory and the fastestK %      computational speed.  In some cases, such as an image with low color > %      dispersion (a few number of colors), a value other thanM %      Log4(number_colors) is required.  To expand the color tree completely,  %      use a value of 8. %  *// static void InitializeCube(number_pixels,depth)  unsigned int   number_pixels;   int    depth; {    char     c;     register int     i;     unsigned int	     bits, 
     level,     max_shift;     /*+     Initialize tree to describe color cube.    */!   cube.node_queue=(Nodes *) NULL;    cube.nodes=0;    cube.free_nodes=0;   if (depth > MaxTreeDepth)      depth=8;   if (depth < 2)     depth=2;   cube.depth=depth;    /*      Initialize the shift values.   */   c=1;%   for (bits=0; c != (char) 0; bits++) 
     c<<=1;L   for (max_shift=sizeof(unsigned int)*bits; number_pixels != 0; max_shift--)     number_pixels>>=1;-   for (level=0; level <= cube.depth; level++)    {       cube.shift[level]=max_shift;     if (max_shift != 0)        max_shift--;   }    /*     Initialize root node.    */M   cube.root=InitializeNode(0,0,(Node *) NULL,(MaxRGB+1) >> 1,(MaxRGB+1) >> 1,      (MaxRGB+1) >> 1); !   if (cube.root == (Node *) NULL)      { E       Warning("Unable to quantize image","Memory allocation failed");        exit(1);     }    cube.root->parent=cube.root;0   cube.root->number_colors=(unsigned long) (~0);   cube.colors=0;   /*!     Initialize the square values.    */%   for (i=(-MaxRGB); i <= MaxRGB; i++)      cube.squares[i+MaxRGB]=i*i;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  I n i t i a l i z e N o d e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function InitializeNode allocates memory for a new node in the color cube' %  tree and presets all fields to zero.  % / %  The format of the InitializeNode routine is:  % D %      node=InitializeNode(node,id,level,mid_red,mid_green,mid_blue) % + %  A description of each parameter follows.  % E %    o node: The InitializeNode routine returns this integer address.  % 2 %    o id: Specifies the child number of the node. % I %    o level: Specifies the level in the classification the node resides.  % F %    o mid_red: Specifies the mid point of the red axis for this node. % J %    o mid_green: Specifies the mid point of the green axis for this node. % H %    o mid_blue: Specifies the mid point of the blue axis for this node. %  %  */G static Node *InitializeNode(id,level,parent,mid_red,mid_green,mid_blue)  unsigned int   id,    level;   Node
   *parent;   unsigned int
   mid_red,   mid_green,   mid_blue;  {    register int     i;     register Node 
     *node;     if (cube.free_nodes == 0)      {        register Nodes         *nodes;          /*&         Allocate a new nodes of nodes.       */,       nodes=(Nodes *) malloc(sizeof(Nodes));"       if (nodes == (Nodes *) NULL)         return((Node *) NULL);"       nodes->next=cube.node_queue;       cube.node_queue=nodes;"       cube.next_node=nodes->nodes;#       cube.free_nodes=NodesInAList;      }    cube.nodes++;    cube.free_nodes--;   node=cube.next_node++;   node->parent=parent;   for (i=0; i < 8; i++) !     node->child[i]=(Node *) NULL;    node->id=id;   node->level=level;   node->census=0;    node->mid_red=mid_red;   node->mid_green=mid_green;   node->mid_blue=mid_blue;   node->number_colors=0;   node->number_unique=0;   node->total_red=0;   node->total_green=0;   node->total_blue=0;    return(node);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  P r u n e C h i l d                                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function PruneChild deletes the given node and merges its statistics into %  its parent. % - %  The format of the PruneSubtree routine is:  %  %      PruneChild(node)  % + %  A description of each parameter follows.  % E %    o node: pointer to node in color cube tree that is to be pruned.  %  %  */ static void PruneChild(node)
 register Node    *node; {    register Node      *parent;     /*'     Merge color statistics into parent.    */   parent=node->parent;#   parent->census&=~(1 << node->id); -   parent->number_unique+=node->number_unique; %   parent->total_red+=node->total_red; )   parent->total_green+=node->total_green; '   parent->total_blue+=node->total_blue;    cube.nodes--;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  P r u n e L e v e l                                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Procedure PruneLevel deletes all nodes at the bottom level of the color> %  tree merging their color statistics into their parent node. % + %  The format of the PruneLevel routine is:  %  %      PruneLevel(node)  % + %  A description of each parameter follows.  % E %    o node: pointer to node in color cube tree that is to be pruned.  %  %  */ static void PruneLevel(node)
 register Node    *node; {    register int     id;      /*     Traverse any children.   */   if (node->census != 0)     for (id=0; id < 8; id++)#       if (node->census & (1 << id)) $         PruneLevel(node->child[id]);    if (node->level == cube.depth)     PruneChild(node);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e d u c e                                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function Reduce traverses the color cube tree and prunes any node whose6 %  number of colors fall below a particular threshold. % ' %  The format of the Reduce routine is:  %  %      Reduce(node)  % + %  A description of each parameter follows.  % E %    o node: pointer to node in color cube tree that is to be pruned.  %  %  */ static void Reduce(node)
 register Node    *node; {    register unsigned int      id;      /*     Traverse any children.   */   if (node->census != 0)     for (id=0; id < 8; id++)#       if (node->census & (1 << id))           Reduce(node->child[id]);4   if (node->number_colors <= cube.pruning_threshold)     PruneChild(node);    else     {        /*'         Find minimum pruning threshold.        */"       if (node->number_unique > 0)         cube.colors++;<       if (node->number_colors < cube.next_pruning_threshold)8         cube.next_pruning_threshold=node->number_colors;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e d u c t i o n                                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function Reduction repeatedly prunes the tree until the number of nodesL %  with n2 > 0 is less than or equal to the maximum number of colors allowedI %  in the output image.  On any given iteration over the tree, it selects F %  those nodes whose n1  count is minimal for pruning and merges theirF %  color statistics upward. It uses a pruning threshold, ns, to govern %  node selection as follows:  %  %    ns = 0 L %    while number of nodes with (n2 > 0) > required maximum number of colors) %      prune all nodes such that n1 <= ns . %      Set ns to minimum n1 in remaining nodes % H %  When a node to be pruned has offspring, the pruning procedure invokesH %  itself recursively in order to prune the tree from the leaves upward.G %  n2,  Sr, Sg,  and  Sb in a node being pruned are always added to the E %  corresponding data in that node's parent.  This retains the pruned 4 %  node's color characteristics for later averaging. % D %  For each node, n2 pixels exist for which that node represents theI %  smallest volume in RGB space containing those pixel's colors.  When n2 H %  > 0 the node will uniquely define a color in the output image. At theH %  beginning of reduction,  n2 = 0  for all nodes except a the leaves of> %  the tree which represent colors present in the input image. % B %  The other pixel count, n1, indicates the total number of colorsI %  within the cubic volume which the node represents.  This includes n1 - I %  n2  pixels whose colors should be defined by nodes at a lower level in  %  the tree. % * %  The format of the Reduction routine is: %  %      Reduction(number_colors)  % + %  A description of each parameter follows.  % H %    o number_colors: This integer value indicates the maximum number ofG %      colors in the quantized image or colormap.  The actual number of H %      colors allocated to the colormap may be less than this value, butG %      never more.  Note, the number of colors is restricted to a value I %      less than or equal to 65536 if the continuous_tone parameter has a  %      value of zero.  %  %  */$ static void Reduction(number_colors) unsigned int   number_colors; {     cube.next_pruning_threshold=1;%   while (cube.colors > number_colors)    { 7     cube.pruning_threshold=cube.next_pruning_threshold; ;     cube.next_pruning_threshold=cube.root->number_colors-1;      cube.colors=0;     Reduce(cube.root);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a p I m a g e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  MapImage replaces the colors of an image with the closest color from  %  a reference image.  % ) %  The format of the MapImage routine is:  % ' %      MapImage(image,map_image,dither)  % + %  A description of each parameter follows:  % ? %    o image: Specifies a pointer to a set of Image structures.  % C %    o map_image: Specifies a pointer to a Image structure.  Reduce : %      image to a set of colors represented by this image. % E %    o dither: Set this integer value to something other than zero to I %      dither the quantized image.  The basic strategy of dithering is to I %      trade intensity resolution for spatial resolution by averaging the F %      intensities of several neighboring pixels.  Images which sufferE %      from severe contouring when quantized can be improved with the G %      technique of dithering.  Severe contouring generally occurs when E %      quantizing to very few colors, or to a poorly-chosen colormap. F %      Note, dithering is a computationally expensive process and will. %      increase processing time significantly. %  %  */% void MapImage(image,map_image,dither)  Image 	   *image, 
   *map_image;    unsigned int	   dither;  {    Nodes      *nodes;      /*3     Classify image colors from the reference image.    */(   InitializeCube((unsigned int) (~0),8);   Classification(map_image);D   Assignment(image,(unsigned int) cube.colors,dither,RGBColorspace);   CompressColormap(image);   /*$     Release color cube tree storage.   */   do   {       nodes=cube.node_queue->next;*     (void) free((char *) cube.node_queue);     cube.node_queue=nodes;   } ,   while (cube.node_queue != (Nodes *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  Q u a n t i z a t i o n E r r o r                                          % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function QuantizationError measures the difference between the originalJ %  and quantized images.  This difference is the total quantization error.L %  The error is computed by summing over all pixels in an image the distanceL %  squared in RGB space between each reference pixel value and its quantized% %  value.  These values are computed:  % I %    o mean_error_per_pixel:  This value is the mean error for any single  %      pixel in the image. % G %    o normalized_mean_square_error:  This value is the normalized mean K %      quantization error for any single pixel in the image.  This distance K %      measure is normalized to a range between 0 and 1.  It is independent @ %      of the range of red, green, and blue values in the image. % E %    o normalized_maximum_square_error:  Thsi value is the normalized J %      maximum quantization error for any single pixel in the image.  ThisH %      distance measure is normalized to a range between 0 and 1.  It isM %      independent of the range of red, green, and blue values in your image.  %  % 2 %  The format of the QuantizationError routine is: %  %      QuantizationError(image)  % + %  A description of each parameter follows.  % @ %    o image: The address of a byte (8 bits) array of run-lengthB %      encoded pixel data of your reference image.  The sum of theJ %      run-length counts in the reference image must be equal to or exceed %      the number of pixels. %  %  */ void QuantizationError(image)  Image 	   *image;  {    register int     i;     register RunlengthPacket     *p;      register unsigned int      blue_distance,     green_distance,      red_distance;      unsigned long 
     distance,      maximum_error_per_pixel,     total_error;     /*-     For each pixel, collect error statistics.    */%   for (i=(-MaxRGB); i <= MaxRGB; i++)      cube.squares[i+MaxRGB]=i*i;    maximum_error_per_pixel=0;   total_error=0;   p=image->pixels;$   for (i=0; i < image->packets; i++)   { I     red_distance=(int) p->red-(int) image->colormap[p->index].red+MaxRGB; O     green_distance=(int) p->green-(int) image->colormap[p->index].green+MaxRGB; L     blue_distance=(int) p->blue-(int) image->colormap[p->index].blue+MaxRGB;E     distance=cube.squares[red_distance]+cube.squares[green_distance]+ "       cube.squares[blue_distance];*     total_error+=(distance*(p->length+1));+     if (distance > maximum_error_per_pixel) '       maximum_error_per_pixel=distance;      p++;   }    /*#     Compute final error statistics.    */,   image->mean_error_per_pixel=(unsigned int)-     total_error/(image->columns*image->rows);    image->normalized_mean_error= G     ((double) image->mean_error_per_pixel)/(3.0*(MaxRGB+1)*(MaxRGB+1)); E   image->normalized_maximum_error=((double) maximum_error_per_pixel)/       (3.0*(MaxRGB+1)*(MaxRGB+1));$   NumberColors(image,(FILE *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  Q u a n t i z e I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function QuantizeImage analyzes the colors within a reference image andL %  chooses a fixed number of colors to represent the image.  The goal of theM %  algorithm is to minimize the difference between the input and output image ( %  while minimizing the processing time. % . %  The format of the QuantizeImage routine is: % B %      colors=QuantizeImage(image,number_colors,tree_depth,dither) % + %  A description of each parameter follows.  % > %    o colors: The QuantizeImage function returns this integerA %      value.  It is the actual number of colors allocated in the I %      colormap.  Note, the actual number of colors allocated may be less ; %      than the number of colors requested, but never more.  % G %    o image: Specifies a pointer to an Image structure;  returned from  %      ReadImage.  % H %    o number_colors: This integer value indicates the maximum number ofG %      colors in the quantized image or colormap.  The actual number of H %      colors allocated to the colormap may be less than this value, butG %      never more.  Note, the number of colors is restricted to a value I %      less than or equal to 65536 if the continuous_tone parameter has a  %      value of zero.  % J %    o tree_depth: Normally, this integer value is zero or one.  A zero or; %      one tells Quantize to choose a optimal tree depth of K %      Log4(number_colors).  A tree of this depth generally allows the best L %      representation of the reference image with the least amount of memoryL %      and the fastest computational speed.  In some cases, such as an imageM %      with low color dispersion (a few number of colors), a value other than M %      Log4(number_colors) is required.  To expand the color tree completely,  %      use a value of 8. % E %    o dither: Set this integer value to something other than zero to I %      dither the quantized image.  The basic strategy of dithering is to I %      trade intensity resolution for spatial resolution by averaging the F %      intensities of several neighboring pixels.  Images which sufferE %      from severe contouring when quantized can be improved with the G %      technique of dithering.  Severe contouring generally occurs when E %      quantizing to very few colors, or to a poorly-chosen colormap. F %      Note, dithering is a computationally expensive process and will. %      increase processing time significantly. % K %    o colorspace: An unsigned integer value that indicates the colorspace. M %      Empirical evidence suggests that distances in YUV or YIQ correspond to I %      perceptual color differences more closely than do distances in RGB G %      space.  The image is then returned to RGB colorspace after color  %      reduction.  %  %  */D void QuantizeImage(image,number_colors,tree_depth,dither,colorspace) Image 	   *image;    unsigned int   number_colors,
   tree_depth, 	   dither, 
   colorspace;  {    int 
     depth;     Nodes      *nodes;   &   if (number_colors > MaxColormapSize)"     number_colors=MaxColormapSize;5   if (image->packets == (image->columns*image->rows))      CompressImage(image);    depth=tree_depth;    if (depth == 0)      {        unsigned int         colors;          /*E         Depth of color classification tree is: Log4(colormap size)+2.        */       colors=number_colors; )       for (depth=1; colors != 0; depth++)          colors>>=2;        if (dither)          depth--;O       if (((float) image->packets/(float) (image->columns*image->rows)) >= 0.9)          depth--;&       if (image->class == PseudoClass)         depth+=2;      } 3   InitializeCube(image->columns*image->rows,depth); "   if (colorspace != RGBColorspace)(     RGBTransformImage(image,colorspace);   Classification(image);   /*=     Reduce the number of colors in the continuous tone image.    */   Reduction(number_colors); 4   Assignment(image,number_colors,dither,colorspace);"   if (colorspace != RGBColorspace)(     TransformRGBImage(image,colorspace);   /*$     Release color cube tree storage.   */   do   {       nodes=cube.node_queue->next;*     (void) free((char *) cube.node_queue);     cube.node_queue=nodes;   } ,   while (cube.node_queue != (Nodes *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   Q u a n t i z e I m a g e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  QuantizeImages analyzes the colors within a set of reference images andJ %  chooses a fixed number of colors to represent the set.  The goal of theN %  algorithm is to minimize the difference between the input and output images( %  while minimizing the processing time. % / %  The format of the QuantizeImages routine is:  % K %      QuantizeImages(images,number_images,number_colors,tree_depth,dither)  % + %  A description of each parameter follows:  % @ %    o images: Specifies a pointer to a set of Image structures. % L %    o number_images:  Specifies an unsigned integer representing the number %      images in the image set.  % H %    o number_colors: This integer value indicates the maximum number ofN %      colors in the quantized image or colormap.  The actual number of colorsM %      allocated to the colormap may be less than this value, but never more. M %      Note, the number of colors is restricted to a value less than or equal : %      to 65536 if the quantized image is not DirectClass. % J %    o tree_depth: Normally, this integer value is zero or one.  A zero orK %      one tells QUANTIZE to choose a optimal tree depth.  An optimal depth O %      generally allows the best representation of the reference image with the L %      fastest computational speed and the least amount of memory.  However,N %      the default depth is inappropriate for some images.  To assure the bestE %      representation, try values between 2 and 8 for this parameter.  % E %    o dither: Set this integer value to something other than zero to I %      dither the quantized image.  The basic strategy of dithering is to I %      trade intensity resolution for spatial resolution by averaging the F %      intensities of several neighboring pixels.  Images which sufferE %      from severe contouring when quantized can be improved with the G %      technique of dithering.  Severe contouring generally occurs when E %      quantizing to very few colors, or to a poorly-chosen colormap. F %      Note, dithering is a computationally expensive process and will. %      increase processing time significantly. % K %    o colorspace: An unsigned integer value that indicates the colorspace. M %      Empirical evidence suggests that distances in YUV or YIQ correspond to I %      perceptual color differences more closely than do distances in RGB G %      space.  The image is then returned to RGB colorspace after color  %      reduction.  %  %  */I void QuantizeImages(images,number_images,number_colors,tree_depth,dither, 
   colorspace)  Image    **images;    unsigned int   number_images;   unsigned int   number_colors,
   tree_depth, 	   dither, 
   colorspace;  {    int 
     depth;     Nodes      *nodes;      register unsigned int      i;  &   if (number_colors > MaxColormapSize)"     number_colors=MaxColormapSize;   depth=tree_depth;    if (depth == 0)      { 	       int          pseudo_class;          unsigned int         colors;          /*E         Depth of color classification tree is: Log4(colormap size)+2.        */       colors=number_colors; )       for (depth=1; colors != 0; depth++)          colors>>=2;        if (dither)          depth--;       depth--;       pseudo_class=True;'       for (i=0; i < number_images; i++) 8         pseudo_class|=(images[i]->class == PseudoClass);       if (pseudo_class)          depth+=2;      } ,   InitializeCube((unsigned int) (~0),depth);A   for (i=0; i < number_images; i+=Max((number_images+16) >> 5,1))    { C     if (images[i]->packets == (images[i]->columns*images[i]->rows))        CompressImage(images[i]); $     if (colorspace != RGBColorspace).       RGBTransformImage(images[i],colorspace);     Classification(images[i]);   }    /*F     Reduce the number of colors in the continuous tone image sequence.   */   Reduction(number_colors); #   for (i=0; i < number_images; i++)    { :     Assignment(images[i],number_colors,dither,colorspace);$     if (colorspace != RGBColorspace).       TransformRGBImage(images[i],colorspace);   }    /*$     Release color cube tree storage.   */   do   {       nodes=cube.node_queue->next;*     (void) free((char *) cube.node_queue);     cube.node_queue=nodes;   } ,   while (cube.node_queue != (Nodes *) NULL); } 