 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                  W   W  IIIII  DDDD    GGGG  EEEEE  TTTTT                   % O %                  W   W    I    D   D  G      E        T                     % O %                  W W W    I    D   D  G  GG  EEE      T                     % O %                  WW WW    I    D   D  G   G  E        T                     % O %                  W   W  IIIII  DDDD    GGGG  EEEEE    T                     % O %                                                                             % O %                X11 User Interface Routines for ImageMagick.                 % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                              September 1993                                 % O %                                                                             % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "utility.h" #include "X.h" #include "widget.h"  #include "PreRvIcccm.h"    /*   Define declarations. */- #define MatteIsActive(matte_info,position)  \ =   ((position.x >= (matte_info.x-matte_info.bevel_width)) && \ >    (position.y >= (matte_info.y-matte_info.bevel_width)) &&  \N    (position.x < (matte_info.x+matte_info.width+matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width))) /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002 # #define InactiveWidgetState  0x0004 6 #define MaxTextWidth  (80*XTextWidth(font_info,"_",1))6 #define MinTextWidth  (25*XTextWidth(font_info,"_",1))! #define RedrawActionState  0x0008  #define RedrawListState  0x0010 ! #define RedrawWidgetState  0x0020 ( #define UpdateConfigurationState  0x0040 #define UpdateListState  0x0080    /*   Forward declarations.  */ static void ?   XDrawMatte _Declare((Display *,XWindowInfo *,XWidgetInfo *)), B   XSetBevelColor _Declare((Display *,XWindowInfo *,unsigned int)),B   XSetMatteColor _Declare((Display *,XWindowInfo *,unsigned int)),A   XSetTextColor _Declare((Display *,XWindowInfo *,unsigned int));    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawBevel "sets off" an area with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % , %  The format of the XDrawBevel function is: % 1 %      XDrawBevel(display,window_info,bevel_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o bevel_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the bevel.  %  %  */6 static void XDrawBevel(display,window_info,bevel_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *bevel_info; {    int      x1,      x2,      y1,      y2;      unsigned int     bevel_width;     XPoint     points[6];     /*'     Draw upper and left beveled border.    */   x1=bevel_info->x; &   y1=bevel_info->y+bevel_info->height;%   x2=bevel_info->x+bevel_info->width;    y2=bevel_info->y; &   bevel_width=bevel_info->bevel_width;   points[0].x=x1;    points[0].y=y1;    points[1].x=x1;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x1-bevel_width;    points[4].y=y2-bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; 9   XSetBevelColor(display,window_info,bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin);    /*(     Draw lower and right beveled border.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y1;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x2+bevel_width;    points[4].y=y1+bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; I   XSetBevelColor(display,window_info,(unsigned int) !bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d B u t t o n                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDrawBeveledButton draws a button with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawBeveledButton function is: % : %      XDrawBeveledButton(display,window_info,button_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o button_info: Specifies a pointer to a XWidgetInfo structure.  It * %      contains the extents of the button. %  %  */? static void XDrawBeveledButton(display,window_info,button_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *button_info;  {    int      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Draw matte.    */.   XDrawBevel(display,window_info,button_info);:   XSetMatteColor(display,window_info,button_info->raised);E   XFillRectangle(display,window_info->id,window_info->widget_context, J     button_info->x,button_info->y,button_info->width,button_info->height);.   x=button_info->x-button_info->bevel_width-1;.   y=button_info->y-button_info->bevel_width-1;5   XSetForeground(display,window_info->widget_context, 1     window_info->pixel_info->trough_color.pixel); 7   if (button_info->raised || (window_info->depth == 1)) K     XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, O       button_info->width+(button_info->bevel_width << 1)+1,button_info->height+ )       (button_info->bevel_width << 1)+1); )   if (button_info->text == (char *) NULL)      return;    /*     Set cropping region.   */%   crop_info.width=button_info->width; '   crop_info.height=button_info->height;    crop_info.x=button_info->x;    crop_info.y=button_info->y;    /*     Draw text.   */#   font_info=window_info->font_info; J   width=XTextWidth(font_info,button_info->text,strlen(button_info->text));:   x=button_info->x+(button_info->width >> 1)-(width >> 1);   if (x < button_info->x)      x=button_info->x;    y=button_info->y+ H     ((button_info->height-(font_info->ascent+font_info->descent)) >> 1);   if (y < button_info->y)      y=button_info->y; $   y+=window_info->font_info->ascent;J   XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,     Unsorted);9   XSetTextColor(display,window_info,button_info->raised); F   XDrawString(display,window_info->id,window_info->widget_context,x,y,1     button_info->text,strlen(button_info->text)); 9   XSetClipMask(display,window_info->widget_context,None);    if (!button_info->raised) %     XDelay(display,SuspendTime << 2);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d M a t t e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawBeveledMatte draws a matte with a shadowed upper and K %  left bevel and a highlighted lower and right bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawBeveledMatte function is:  % 8 %      XDrawBeveledMatte(display,window_info,matte_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */= static void XDrawBeveledMatte(display,window_info,matte_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */-   XDrawBevel(display,window_info,matte_info); -   XDrawMatte(display,window_info,matte_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawMatte fills a rectangular area with the matte color.  % , %  The format of the XDrawMatte function is: % 1 %      XDrawMatte(display,window_info,matte_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */6 static void XDrawMatte(display,window_info,matte_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *matte_info; {    /*     Draw matte.    */7   if (!matte_info->trough || (window_info->depth == 1)) J     XFillRectangle(display,window_info->id,window_info->highlight_context,H       matte_info->x,matte_info->y,matte_info->width,matte_info->height);   else     { 9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->trough_color.pixel); I       XFillRectangle(display,window_info->id,window_info->widget_context, J         matte_info->x,matte_info->y,matte_info->width,matte_info->height);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e T e x t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDrawMatteText draws a matte with text.  If the text exceeds theG %  extents of the text, a portion of the text relative to the cursor is 
 %  displayed.  % 0 %  The format of the XDrawMatteText function is: % 4 %      XDrawMatteText(display,window_info,text_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. %  %  */9 static void XDrawMatteText(display,window_info,text_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    char
     *text;     int      x,     y;     register int     i;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   */,   XSetMatteColor(display,window_info,False);E   XFillRectangle(display,window_info->id,window_info->widget_context, B     text_info->x,text_info->y,text_info->width,text_info->height);'   if (text_info->text == (char *) NULL)      return; :   XSetTextColor(display,window_info,text_info->highlight);#   font_info=window_info->font_info; 4   x=text_info->x+(font_info->max_bounds.width >> 2);<   y=text_info->y+font_info->ascent+(text_info->height >> 2);<   width=text_info->width-(font_info->max_bounds.width >> 1);.   height=font_info->ascent+font_info->descent;   if (*text_info->text == '\0')      {        /*#         No text-- just draw cursor.        */L       XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,         x,y-height+3);
       return;      }    /*     Set cropping region.   */#   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*,     Determine beginning of the visible text.   */,   if (text_info->cursor < text_info->marker)(     text_info->marker=text_info->cursor;   else     {        text=text_info->marker; D       if (XTextWidth(font_info,text,text_info->cursor-text) > width)	         {            text=text_info->text; 0           for (i=0; i < (int) strlen(text); i++)O             if (XTextWidth(font_info,text+i,text_info->cursor-text-i) <= width)                break;#           text_info->marker=text+i; 	         }      }    /*     Draw text and cursor.    */   if (!text_info->highlight)     { N       XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,         Unsorted);J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         text_info->marker,strlen(text_info->marker)); =       XSetClipMask(display,window_info->widget_context,None);      }    else     { N       XSetClipRectangles(display,window_info->annotate_context,0,0,&crop_info,         1,Unsorted);N       width=XTextWidth(font_info,text_info->marker,strlen(text_info->marker));M       XFillRectangle(display,window_info->id,window_info->annotate_context,x, *         y-font_info->ascent,width,height);?       XSetClipMask(display,window_info->annotate_context,None); O       XSetClipRectangles(display,window_info->highlight_context,0,0,&crop_info,          1,Unsorted);M       XDrawString(display,window_info->id,window_info->highlight_context,x,y, 5         text_info->marker,strlen(text_info->marker)); @       XSetClipMask(display,window_info->highlight_context,None);     }    x+= P     XTextWidth(font_info,text_info->marker,text_info->cursor-text_info->marker);H   XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,     x,y-height+3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e E a s t                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawTriangleEast draws a triangle with a highlighted leftC %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawTriangleEast function is:  % ; %      XDrawTriangleEast(display,window_info,triangle_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */@ static void XDrawTriangleEast(display,window_info,triangle_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;+   x2=triangle_info->x+triangle_info->width; 3   y2=triangle_info->y+(triangle_info->height >> 1);    x3=triangle_info->x;,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw bottom bevel.   */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3-bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2+bevel_width;    points[3].y=y2; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw Left bevel.   */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width+1;    points[2].y=y1-bevel_width;    points[3].x=x3-bevel_width+1;    points[3].y=y3+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2+bevel_width;    points[2].y=y2;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e N o r t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDrawTriangleNorth draws a triangle with a highlighted left C %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawTriangleNorth function is: % < %      XDrawTriangleNorth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleNorth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;,   y1=triangle_info->y+triangle_info->height;2   x2=triangle_info->x+(triangle_info->width >> 1);   y2=triangle_info->y;+   x3=triangle_info->x+triangle_info->width; ,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2-bevel_width-2;    points[3].x=x1-bevel_width-1;    points[3].y=y1+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3+bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2;    points[3].y=y2-bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw lower bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1+bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3+bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e S o u t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XDrawTriangleSouth draws a border with a highlighted left and H %  right bevel and a shadowed lower bevel.  The highlighted and shadowed %  bevels create a 3-D effect. % 4 %  The format of the XDrawTriangleSouth function is: % < %      XDrawTriangleSouth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */A static void XDrawTriangleSouth(display,window_info,triangle_info)  Display    *display;    XWindowInfo    *window_info;    XWidgetInfo    *triangle_info;  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;2   x2=triangle_info->x+(triangle_info->width >> 1);,   y2=triangle_info->y+triangle_info->height;+   x3=triangle_info->x+triangle_info->width;    y3=triangle_info->y;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1-bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3+1;    points[1].y=y3-bevel_width;    points[2].x=x3+bevel_width;    points[2].y=y3-bevel_width;    points[3].x=x2;    points[3].y=y2+bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2+bevel_width;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w W i d g e t T e x t                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDrawWidgetText first clears the widget and draws a text string H %  justifed left in the x-direction and centered within the y-direction. % 1 %  The format of the XDrawWidgetText function is:  % 5 %      XDrawWidgetText(display,window_info,text_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowText structure.  % ? %    o text_info: Specifies a pointer to XWidgetInfo structure.  %  %  */: static void XDrawWidgetText(display,window_info,text_info) Display    *display;    XWindowInfo    *window_info;    XWidgetInfo 
   *text_info;  {    GC     widget_context;      int      x,     y;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   *//   widget_context=window_info->annotate_context;    if (text_info->raised)A     XClearArea(display,window_info->id,text_info->x,text_info->y, 0       text_info->width,text_info->height,False);   else     { I       XFillRectangle(display,window_info->id,widget_context,text_info->x, 9         text_info->y,text_info->width,text_info->height); 4       widget_context=window_info->highlight_context;     } '   if (text_info->text == (char *) NULL)      return;    if (*text_info->text == '\0')      return;    /*     Set cropping region.   */#   font_info=window_info->font_info; #   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*     Draw text.   */F   width=XTextWidth(font_info,text_info->text,strlen(text_info->text));4   x=text_info->x+(font_info->max_bounds.width >> 1);=   if (width > (text_info->width-font_info->max_bounds.width)) <     x+=(text_info->width-font_info->max_bounds.width-width);.   height=font_info->ascent+font_info->descent;E   y=text_info->y+((text_info->height-height) >> 1)+font_info->ascent; G   XSetClipRectangles(display,widget_context,0,0,&crop_info,1,Unsorted); 9   XDrawString(display,window_info->id,widget_context,x,y, -     text_info->text,strlen(text_info->text)); ,   XSetClipMask(display,widget_context,None);   if (x < text_info->x) D     XDrawLine(display,window_info->id,window_info->annotate_context,O       text_info->x,text_info->y,text_info->x,text_info->y+text_info->height-1);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E d i t T e x t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XEditText edits a text string as indicated by the key symbol.  % + %  The format of the XEditText function is:  % 9 %      XEditText(display,text_info,key_symbol,text,state)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. % H %    o key_symbol:  A X11 KeySym that indicates what editing function to %      perform to the text.  % 8 %    o text: A character string to insert into the text. % J %    o state:  An unsigned long that indicates whether the key symbol is a  %      control character or not. %  %  */> static void XEditText(display,text_info,key_symbol,text,state) Display    *display;    XWidgetInfo 
   *text_info;    KeySym
   key_symbol;    char   *text;  
 unsigned long    state; {    switch (key_symbol)    {      case XK_BackSpace:     case XK_Delete:      {        /*         Erase one character.       *//       if (text_info->cursor != text_info->text) 	         {            text_info->cursor--;?           (void) strcpy(text_info->cursor,text_info->cursor+1); %           text_info->highlight=False;            break;	         }      }      case XK_Left:      case XK_KP_Left:     {        /*&         Move cursor one position left.       *//       if (text_info->cursor == text_info->text)          break;       text_info->cursor--;       break;     }      case XK_Right:     case XK_KP_Right:      {        /*'         Move cursor one position right.        */I       if (text_info->cursor == (text_info->text+strlen(text_info->text)))          break;       text_info->cursor++;       break;     }      default:     {        register char          *p,          *q;          register int
         i;         if (state & ControlState)          break;       if (*text == '\0')         break;=       if (((int) strlen(text_info->text)+1) >= MaxTextLength)          XBell(display,0); 
       else	         {            /**             Insert a string into the text.           */#           if (text_info->highlight) 
             {                /*.                 Erase the entire line of text.               */$               *text_info->text='\0';0               text_info->cursor=text_info->text;0               text_info->marker=text_info->text;)               text_info->highlight=False; 
             } A           q=text_info->text+strlen(text_info->text)+strlen(text); >           for (i=0; i <= (int) strlen(text_info->cursor); i++)           { #             *q=(*(q-strlen(text)));              q--;           }            p=text; 0           for (i=0; i < (int) strlen(text); i++)(             *text_info->cursor++=(*p++);	         }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i d g e t I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWidgetInfo initializes the XWidgetInfo structure.  % 0 %  The format of the XGetWidgetInfo function is: % ' %      XGetWidgetInfo(text,widget_info)  % + %  A description of each parameter follows:  % ? %    o text: A string of characters associated with the widget.  % G %    o widget_info: Specifies a pointer to a X11 XWidgetInfo structure.  %  %  */, static void XGetWidgetInfo(text,widget_info) char   *text;   XWidgetInfo    *widget_info;  {    /*     Initialize widget info.    */    widget_info->id=(~0);    widget_info->bevel_width=3;    widget_info->width=1;    widget_info->height=1;     widget_info->x=0;    widget_info->y=0;    widget_info->min_y=0;    widget_info->max_y=0;    widget_info->raised=True;    widget_info->active=False;     widget_info->trough=False;      widget_info->highlight=False;    widget_info->text=text;    widget_info->cursor=text;    if (text != (char *) NULL) '      widget_info->cursor+=strlen(text);     widget_info->marker=text; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t W i d g e t                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightWidget draws a highlighted border around a window. % 2 %  The format of the XHighlightWidget function is: % 0 %      XHighlightWidget(display,window_info,x,y) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o x: Specifies an integer representing the rectangle offset in the  %      x-direction.  % G %    o y: Specifies an integer representing the rectangle offset in the  %      y-direction.  %  %  */5 static void XHighlightWidget(display,window_info,x,y)  Display    *display;    XWindowInfo    *window_info;    int    x,   y; {    /*+     Draw the widget highlighting rectangle.    */+   XSetBevelColor(display,window_info,True); I   XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, >     window_info->width-(x << 1),window_info->height-(y << 1));M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, B     window_info->width-(x << 1)+1,window_info->height-(y << 1)+1);,   XSetBevelColor(display,window_info,False);M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, >     window_info->width-(x << 1),window_info->height-(y << 1));?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S c r e e n E v e n t                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XScreenEvent returns True if the any event on the X server queue( %  is associated with the widget window. % . %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */+ static int XScreenEvent(display,event,data)  Display    *display;    XEvent	   *event;    char   *data; { 
   XWindows
     *windows;      windows=(XWindows *) data;.   if (event->xany.window == windows->popup.id)     { #       if (event->type == MapNotify) #         windows->popup.mapped=True; %       if (event->type == UnmapNotify) $         windows->popup.mapped=False;       return(True);      } 0   if (event->xany.window == windows->command.id)     { #       if (event->type == MapNotify) %         windows->command.mapped=True; %       if (event->type == UnmapNotify) &         windows->command.mapped=False;       return(True);      }    switch (event->type)   {      case ButtonPress:      { /       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }        return(True);      }      case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)&           if (windows->magnify.mapped)
             { 1               XMakeMagnifyImage(display,windows);                break;
             }        break;     }      case FocusOut:     {        /*,         Set input focus for backdrop window.       */4       if (event->xfocus.window == windows->image.id)K         XSetInputFocus(display,windows->image.id,RevertToNone,CurrentTime);        return(True);      }      case ButtonRelease:      case KeyPress:     case KeyRelease:     case MotionNotify:     case SelectionNotify:        return(True);      default:       break;   }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t B e v e l C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XSetBevelColor sets the graphic context for drawing a beveled 
 %  border. % 0 %  The format of the XSetBevelColor function is: % 1 %      XSetBevelColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */6 static void XSetBevelColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        Pixmap         stipple;         /*         Monochrome window.       */9       XSetBackground(display,window_info->widget_context, 2         XBlackPixel(display,window_info->screen));9       XSetForeground(display,window_info->widget_context, 2         XWhitePixel(display,window_info->screen));L       XSetFillStyle(display,window_info->widget_context,FillOpaqueStippled);-       stipple=window_info->highlight_stipple;        if (!raised),         stipple=window_info->shadow_stipple;?       XSetStipple(display,window_info->widget_context,stipple);      }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 8         window_info->pixel_info->highlight_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->shadow_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t M a t t e C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XSetMatteColor sets the graphic context for drawing the matte. % 0 %  The format of the XSetMatteColor function is: % 1 %      XSetMatteColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o raised: A value other than zero indicates the matte is active.  %  %  */6 static void XSetMatteColor(display,window_info,raised) Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));     }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->matte_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->depth_color.pixel); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t T e x t C o l o r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XSetTextColor sets the graphic context for drawing text on a	 %  matte.  % / %  The format of the XSetTextColor function is:  % 0 %      XSetTextColor(display,window_info,raised) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */5 static void XSetTextColor(display,window_info,raised)  Display    *display;    XWindowInfo    *window_info;    unsigned int	   raised;  {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));     }    else7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->foreground_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r B r o w s e r W i d g e t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XColorBrowserWidget displays a popup window with a color query to K %  the user.  The user keys a reply and presses the Action or Cancel button H %  to exit.  The typed text is returned as the reply function parameter. % 4 %  The format of the XColorBrowserWidget routine is: % 6 %    XColorBrowserWidget(display,windows,action,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XColorBrowserWidget(display,windows,action,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *reply;  { " #define CancelButtonText  "Cancel" #define ColornameText  "Name:"$ #define ColorPatternText  "Pattern:" #define GrabButtonText  "Grab"  #define ResetButtonText  "Reset"     char     **colorlist,%     primary_selection[MaxTextLength], !     reset_pattern[MaxTextLength],      text[MaxTextLength];     int      colors,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";     unsigned int     height, 
     limit,	     mask,      status,      text_width,      visible_colors, 
     width;     unsigned long 
     delay,
     state;     Window     root_window;     XColor
     color;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     grab_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*/     Get color list and sort in ascending order.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);/   XCheckRefreshWindow(display,&windows->image); #   (void) strcpy(reset_pattern,"*"); -   colorlist=ListColors(glob_pattern,&colors); "   if (colorlist == (char **) NULL)     {        /*.         Pattern failed, obtain all the colors.       */&       (void) strcpy(glob_pattern,"*");1       colorlist=ListColors(glob_pattern,&colors); &       if (colorlist == (char **) NULL)	         { I           XNoticeWidget(display,windows,"Unable to obtain colors names:",              glob_pattern);J           XDialogWidget(display,windows,action,"Enter color name:",reply);           return; 	         }      }    /*&     Determine popup window attributes.   */%   font_info=windows->popup.font_info;    text_width=0;    for (i=0; i < colors; i++)M     if (XTextWidth(font_info,colorlist[i],strlen(colorlist[i])) > text_width) I       text_width=XTextWidth(font_info,colorlist[i],strlen(colorlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,strlen(GrabButtonText));%   width+=font_info->max_bounds.width; N   if (XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText)) > width)J     width=XTextWidth(font_info,ColorPatternText,strlen(ColorPatternText));H   if (XTextWidth(font_info,ColornameText,strlen(ColornameText)) > width)D     width=XTextWidth(font_info,ColornameText,strlen(ColornameText));.   height=font_info->ascent+font_info->descent;   windows->popup.width= E     width+Min(text_width,MaxTextWidth)+6*font_info->max_bounds.width;    windows->popup.height=A     ((81*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4; L   windows->popup.min_width=width+MinTextWidth+4*font_info->max_bounds.width;   windows->popup.min_height=A     ((23*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;    /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;4   windows->popup.x-=((3*windows->popup.width) >> 2);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)      windows->popup.x=0;    else!     if (windows->popup.x > limit)        windows->popup.x=limit; 8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;1   windows->popup.y-=(windows->popup.height >> 1); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;    else!     if (windows->popup.y > limit)        windows->popup.y=limit;    /*     Map popup window.    */B   (void) sprintf(windows->popup.name,"Browse and Select a Color");H   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name); ,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_colors=0;    delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; =         cancel_info.x=windows->popup.width-cancel_info.width- (           font_info->max_bounds.width-2;?         cancel_info.y=windows->popup.height-cancel_info.height- &           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+ M           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1)); $         action_info.y=cancel_info.y;2         XGetWidgetInfo(GrabButtonText,&grab_info);         grab_info.width=width;)         grab_info.height=(3*height) >> 1; 0         grab_info.x=font_info->max_bounds.width;B         grab_info.y=((5*font_info->max_bounds.width) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width; *         reset_info.height=(3*height) >> 1;1         reset_info.x=font_info->max_bounds.width; N         reset_info.y=grab_info.y+grab_info.height+font_info->max_bounds.width;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; 4         reply_info.width=windows->popup.width-width-1           ((6*font_info->max_bounds.width) >> 1); &         reply_info.height=height << 1;>         reply_info.x=width+(font_info->max_bounds.width << 1);         reply_info.y= F           action_info.y-reply_info.height-font_info->max_bounds.width;
         /*&           Initialize mode information.
         */1         XGetWidgetInfo((char *) NULL,&mode_info);           mode_info.bevel_width=0;O         mode_info.width=action_info.x-reply_info.x-font_info->max_bounds.width; ,         mode_info.height=action_info.height;!         mode_info.x=reply_info.x; "         mode_info.y=action_info.y;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;          scroll_info.height= F           reply_info.y-grab_info.y-(font_info->max_bounds.width >> 1);H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=grab_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_colors= A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3); $         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;#         if (!windows->popup.mapped) $           for (i=0; i < colors; i++)0             if (strcmp(colorlist[i],reply) == 0)               list_info.id=i; 
         /*&           Initialize text information.
         */(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;           text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1); 0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*&           Redraw Color Browser window.
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; N         XDrawString(display,windows->popup.id,windows->popup.annotate_context,9           x,y,ColorPatternText,strlen(ColorPatternText)); 9         (void) sprintf(text_info.text,"%s",glob_pattern); <         XDrawWidgetText(display,&windows->popup,&text_info);?         XDrawBeveledButton(display,&windows->popup,&grab_info); @         XDrawBeveledButton(display,&windows->popup,&reset_info);>         XDrawBeveledMatte(display,&windows->popup,&list_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info); @         XDrawTriangleSouth(display,&windows->popup,&south_info);&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; N         XDrawString(display,windows->popup.id,windows->popup.annotate_context,3           x,y,ColornameText,strlen(ColornameText)); ?         XDrawBeveledMatte(display,&windows->popup,&reply_info); <         XDrawMatteText(display,&windows->popup,&reply_info);A         XDrawBeveledButton(display,&windows->popup,&action_info); A         XDrawBeveledButton(display,&windows->popup,&cancel_info); 6         XHighlightWidget(display,&windows->popup,4,4);         selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {          char           **checklist;           int            number_colors;  E         status=XParseColor(display,windows->popup.map_info->colormap,            glob_pattern,&color);          if (status != 0)           {              /*2               Reply is a single color name-- exit.             */.             (void) strcpy(reply,glob_pattern);6             (void) strcpy(glob_pattern,reset_pattern);%             action_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } 
         /*           Update color list.
         */:         checklist=ListColors(glob_pattern,&number_colors);         if (number_colors == 0)            { 6             (void) strcpy(glob_pattern,reset_pattern);             XBell(display,0);            }          else           { &             for (i=0; i < colors; i++)1               (void) free((char *) colorlist[i]); ,             if (colorlist != (char **) NULL).               (void) free((char *) colorlist);              colorlist=checklist;!             colors=number_colors;            } 
         /*-           Sort color list in ascending order. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;$         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*$           Redraw color name & reply.
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); <         XDrawWidgetText(display,&windows->popup,&text_info);<         XDrawMatteText(display,&windows->popup,&reply_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info); @         XDrawTriangleSouth(display,&windows->popup,&south_info);6         XHighlightWidget(display,&windows->popup,4,4);"         state&=(~UpdateListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */<         if (slider_info.id >= (int) (colors-visible_colors))/           slider_info.id=colors-visible_colors; ?         if ((slider_info.id < 0) || (colors <= visible_colors))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (colors > 0)            slider_info.y+= J             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/colors;0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; .             for (i=0; i < visible_colors; i++)
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;.               if ((slider_info.id+i) < colors)@                 selection_info.text=colorlist[slider_info.id+i];G               XDrawWidgetText(display,&windows->popup,&selection_info); <               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } D             XDrawTriangleNorth(display,&windows->popup,&north_info);=             XDrawMatte(display,&windows->popup,&expose_info); E             XDrawBeveledButton(display,&windows->popup,&slider_info); D             XDrawTriangleSouth(display,&windows->popup,&south_info);(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       { 
         /*7           Display the selected color in a drawing area. 
         */5         color=windows->popup.pixel_info->matte_color; E         (void) XParseColor(display,windows->popup.map_info->colormap, C           reply_info.text,&windows->popup.pixel_info->matte_color); M         XBestPixel(display,windows->popup.map_info->colormap,(XColor *) NULL, C           (unsigned int) windows->popup.visual_info->colormap_size, 3           &windows->popup.pixel_info->matte_color); ?         XDrawBeveledButton(display,&windows->popup,&mode_info); 5         windows->popup.pixel_info->matte_color=color; $         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) &           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))&           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)1               slider_info.id-=(visible_colors-1);              else1               slider_info.id+=(visible_colors-1); #             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= colors)                break;9             (void) strcpy(reply_info.text,colorlist[id]); '             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);@             XDrawMatteText(display,&windows->popup,&reply_info);%             state|=RedrawActionState; #             if (id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(grab_info,event.xbutton))            {              /*'               User pressed Grab button.              */#             grab_info.raised=False; C             XDrawBeveledButton(display,&windows->popup,&grab_info);              break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;D             XDrawBeveledButton(display,&windows->popup,&reset_info);             break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);              break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); H                 XSetSelectionOwner(display,XA_PRIMARY,windows->popup.id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==$                   windows->popup.id;               } @             XDrawMatteText(display,&windows->popup,&reply_info);*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 0           windows->popup.id,event.xbutton.time);         break;       }        case ButtonRelease:        { #         if (!windows->popup.mapped)            break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; D             XDrawTriangleNorth(display,&windows->popup,&north_info);           }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; D             XDrawTriangleSouth(display,&windows->popup,&south_info);           }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!grab_info.raised)           { :             if (event.xbutton.window == windows->popup.id)9               if (MatteIsActive(grab_info,event.xbutton))                  {                    unsigned int                     status;                      XColor                     color;                     /*9                     Select a pen color from the X server.                    */9                   status=XGetWindowColor(display,&color); &                   if (status != False)                     { E                       (void) sprintf(reply_info.text,"#%02x%02x%02x", F                         ColorShift(color.red),ColorShift(color.green),0                         ColorShift(color.blue));8                       reply_info.marker=reply_info.text;P                       reply_info.cursor=reply_info.text+strlen(reply_info.text);J                       XDrawMatteText(display,&windows->popup,&reply_info);/                       state|=RedrawActionState;                      }                  } "             grab_info.raised=True;C             XDrawBeveledButton(display,&windows->popup,&grab_info);            }          if (!reset_info.raised)            { :             if (event.xbutton.window == windows->popup.id):               if (MatteIsActive(reset_info,event.xbutton))                 { <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  } #             reset_info.raised=True; D             XDrawBeveledButton(display,&windows->popup,&reset_info);           }           if (!action_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&action_info);            }           if (!cancel_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&cancel_info);            } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;6         if (event.xclient.window == windows->popup.id)           { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)            break;?         if ((event.xconfigure.width == windows->popup.width) && ?             (event.xconfigure.height == windows->popup.height))            break;         windows->popup.width= ?           Max(event.xconfigure.width,windows->popup.min_width);          windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height); (         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 2         if (MatteIsActive(scroll_info,event.xkey))           {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { /                 slider_info.id-=visible_colors;                  break;               }                case XK_Next:                case XK_KP_Next:               { /                 slider_info.id+=visible_colors;                  break;               }                case XK_End:               case XK_KP_End:                { &                 slider_info.id=colors;                 break;               } 
             } #             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*-               Read new color or glob patterm.              */)             if (*reply_info.text == '\0')                break;8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);<         XDrawMatteText(display,&windows->popup,&reply_info);E         status=XParseColor(display,windows->popup.map_info->colormap, "           reply_info.text,&color);         if (status != 0)#           state|=RedrawActionState;          break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) J               slider_info.id=(colors*(slider_info.y-slider_info.min_y+1))/8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (grab_info.raised == MatteIsActive(grab_info,event.xmotion))            {              /*)               Grab button status changed.              *//             grab_info.raised=!grab_info.raised; C             XDrawBeveledButton(display,&windows->popup,&grab_info);              break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised; D             XDrawBeveledButton(display,&windows->popup,&reset_info);             break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);              break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; <         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case SelectionNotify:        {          Atom           type;            int            format,            status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); @             XDrawMatteText(display,&windows->popup,&reply_info);%             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); A   XDefineCursor(display,windows->image.id,windows->image.cursor); C   XWithdrawWindow(display,windows->popup.id,windows->popup.screen); /   XCheckRefreshWindow(display,&windows->image);    /*     Free color list.   */   for (i=0; i < colors; i++)'     (void) free((char *) colorlist[i]); "   if (colorlist != (char **) NULL)$     (void) free((char *) colorlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m m a n d W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCommandWidget maps a menu and returns the command pointed to by( %  the user when the button is released. % / %  The format of the XCommandWidget routine is:  % : %    selection_number=XCommandWidget(display,windows,item) % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. % J %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %  %  */+ KeySym XCommandWidget(display,windows,item)  Display    *display;    XWindows   *windows;    char   *item; {  #define MenuTitle  "Commands"  #define NumberMenus  8  
   static char      *CommandMenu[]=      { 
       "File", 
       "Edit", 
       "Size",        "Pixel Transform",       "Color Enhance",       "Effects",       "Image Edit", 
       "Help", 
       "Quit",        (char *) NULL      },     *FileMenu[]=     {        "Image Info",        "Write...",        "Print...",        "Delete...",       "Canvas...",       "Grab...",       "Load...",
       "Next",        "Former",        "Select...",       (char *) NULL      },     *EditMenu[]=     { 
       "Undo",        "Restore",       "Refresh",       "Toggle Colormap",       "Slide Show...",       (char *) NULL      },     *SizeMenu[]=     {        "Half Size",       "Original Size",       "Double Size",       "Resize...",       (char *) NULL      },     *PixelTransformMenu[]=     {        "Trim Edges", 
       "Crop",        "Cut",
       "Flop", 
       "Flip",        "Rotate Right",        "Rotate Left",       "Rotate...",       "Shear...",        (char *) NULL      },     *ColorEnhanceMenu[]=     {        "Brightness...",       "Saturation...",       "Hue...",        "Gamma...",        "Spiff",
       "Dull",        "Equalize",        "Normalize",       "Negate",        (char *) NULL      },     *EffectsMenu[]=      {        "Despeckle",       "Peak Noise",        "Sharpen",
       "Blur",        "Edge Detect",       "Emboss",        "Oil Painting",        "Grayscale",       "Quantize...",       (char *) NULL      },     *ImageEditMenu[]=      {        "Annotate",        "Add Border...",       "Composite...",        "Color",       "Matte",       "Comment",       (char *) NULL      },     *HelpMenu[]=     {        "About Display",       "Version",       (char *) NULL      };  
   static char      **Menus[NumberMenus]=      {        FileMenu,        EditMenu,        SizeMenu,        PixelTransformMenu,        ColorEnhanceMenu,        EffectsMenu,       ImageEditMenu,       HelpMenu     };     static KeySym      CommandKeys[]=     {        XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_VoidSymbol,       XK_h, 
       XK_q     },     FileKeys[]=      {        XK_i,        XK_w,        XK_p,        XK_d,        XK_C,        XK_F2,       XK_l,        XK_n,        XK_f,        XK_F3      },     EditKeys[]=      {        XK_u,        XK_r,        XK_at,       XK_F7,       XK_comma     },     SizeKeys[]=      {        XK_less,       XK_o,        XK_greater,        XK_percent,      },     PixelTransformKeys[]=      {        XK_t,        XK_bracketleft,        XK_bracketright,
       XK_bar,        XK_minus,        XK_slash,        XK_backslash,        XK_asterisk,
       XK_s     },     ColorEnhanceKeys[]=      {        XK_F8,       XK_F9,
       XK_F10,        XK_g, 
       XK_F11, 
       XK_F12,        XK_equal,        XK_N,        XK_asciitilde      },     EffectsKeys[]=     {        XK_D,        XK_P,        XK_S,        XK_B,        XK_E,        XK_M,        XK_O,        XK_G,        XK_numbersign      },     ImageEditKeys[]=     {        XK_a,        XK_b,        XK_x,        XK_c,        XK_m,        XK_exclam      },     HelpKeys[]=      {        XK_h, 
       XK_v     };     static KeySym      *Keys[NumberMenus]=      {        FileKeys,        EditKeys,        SizeKeys,        PixelTransformKeys,        ColorEnhanceKeys,        EffectsKeys,       ImageEditKeys,       HelpKeys,      };     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      unsigned int     height, 
     limit,	     mask,      number_selections,     title_height, 
     width;     unsigned long 
     state;     Window     root_window;     XEvent
     event;  
   XFontStruct      *font_info;   
   XWidgetInfo      menu_info,     selection_info,      submenu_info;      XWindowChanges     window_changes;      /*(     Determine command window attributes.   *//   XCheckRefreshWindow(display,&windows->image); '   font_info=windows->command.font_info; K   windows->command.width=XTextWidth(font_info,MenuTitle,strlen(MenuTitle)); 4   for (id=0; CommandMenu[id] != (char *) NULL; id++)   { H     width=XTextWidth(font_info,CommandMenu[id],strlen(CommandMenu[id]))+#       XTextWidth(font_info," -",2); '     if (width > windows->command.width) #       windows->command.width=width;    }    number_selections=id; 8   windows->command.width+=font_info->max_bounds.width+8;;   title_height=(font_info->descent+font_info->ascent) << 1; :   width=XTextWidth(font_info,MenuTitle,strlen(MenuTitle));9   height=(5*(font_info->ascent+font_info->descent)) >> 2; +   XGetWidgetInfo((char *) NULL,&menu_info);    windows->command.height=G     title_height+number_selections*height+(menu_info.bevel_width << 1); 4   windows->command.min_width=windows->command.width;6   windows->command.min_height=windows->command.height;   /*     Position command window.   */E   XQueryPointer(display,XRootWindow(display,windows->command.screen), L     &root_window,&root_window,&x,&y,&windows->command.x,&windows->command.y,     &mask); :   windows->command.x=x-(font_info->max_bounds.width >> 1);N   limit=XDisplayWidth(display,windows->command.screen)-windows->command.width;   if (windows->command.x < 0)      windows->command.x=0;    else#     if (windows->command.x > limit)        windows->command.x=limit; /   windows->command.y=y-((3*title_height) >> 2); P   limit=XDisplayHeight(display,windows->command.screen)-windows->command.height;   if (windows->command.y < 0)      windows->command.y=0;    else#     if (windows->command.y > limit)        windows->command.y=limit;    /*     Map command window.    */.   window_changes.width=windows->command.width;0   window_changes.height=windows->command.height;&   window_changes.x=windows->command.x;&   window_changes.y=windows->command.y;K   XReconfigureWMWindow(display,windows->command.id,windows->command.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);*   XMapRaised(display,windows->command.id);    windows->command.mapped=False;   /*     Respond to X events.   */
   *item='\0';    key_symbol=XK_VoidSymbol;    selection_info.height=height; 1   cursor=XCreateFontCursor(display,XC_right_ptr); 2   XDefineCursor(display,windows->image.id,cursor);!   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        { 
         /*+           Initialize selection information. 
         */1         XGetWidgetInfo((char *) NULL,&menu_info);           menu_info.bevel_width--;N         menu_info.width=windows->command.width-((menu_info.bevel_width) << 1);P         menu_info.height=windows->command.height-((menu_info.bevel_width) << 1);*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=menu_info.width; %         selection_info.height=height; %         selection_info.x=menu_info.x; 4         XGetWidgetInfo((char *) NULL,&submenu_info);"         submenu_info.raised=False;#         submenu_info.bevel_width--; M         submenu_info.width=((5*(font_info->ascent+font_info->descent)) >> 3)- *           (submenu_info.bevel_width << 1);/         submenu_info.height=submenu_info.width; H         submenu_info.x=selection_info.width-font_info->max_bounds.width;+         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Command widget.
         */9         XDrawBevel(display,&windows->command,&menu_info);          y=title_height-1; 8         XSetBevelColor(display,&windows->command,False);N         XDrawLine(display,windows->command.id,windows->command.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1); 7         XSetBevelColor(display,&windows->command,True); N         XDrawLine(display,windows->command.id,windows->command.widget_context,;           selection_info.x,y,(int) selection_info.width,y); I         XSetFillStyle(display,windows->command.widget_context,FillSolid); 
         /*           Draw menu selections. 
         */#         selection_info.raised=True; +         selection_info.y=title_height >> 2; &         selection_info.text=MenuTitle;C         XDrawWidgetText(display,&windows->command,&selection_info); &         selection_info.y=title_height;0         for (id=0; id < number_selections; id++)	         { :           selection_info.raised=(id != selection_info.id);.           selection_info.text=CommandMenu[id];E           XDrawWidgetText(display,&windows->command,&selection_info); .           if ((id >= 0) && (id < NumberMenus))
             {                submenu_info.y= K                 selection_info.y+(windows->command.font_info->ascent >> 1); I               XDrawTriangleEast(display,&windows->command,&submenu_info); 
             } 8           selection_info.y+=(int) selection_info.height;	         } $         state&=(~RedrawWidgetState);       }      if (number_selections > 3)       { 
         /*           Redraw menu line. 
         */C         y=title_height+selection_info.height*(number_selections-1); 8         XSetBevelColor(display,&windows->command,False);N         XDrawLine(display,windows->command.id,windows->command.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1); 7         XSetBevelColor(display,&windows->command,True); N         XDrawLine(display,windows->command.id,windows->command.widget_context,;           selection_info.x,y,(int) selection_info.width,y); I         XSetFillStyle(display,windows->command.widget_context,FillSolid);        }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:          break;       case ButtonRelease:        { %         if (!windows->command.mapped)            break;
         /*           Exit menu.
         */P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           { ?             (void) strcpy(item,CommandMenu[selection_info.id]); 6             key_symbol=CommandKeys[selection_info.id];           }          state|=ExitState;          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */;         if (event.xconfigure.window != windows->command.id)            break;A         if ((event.xconfigure.width == windows->command.width) && A             (event.xconfigure.height == windows->command.height))            break;         windows->command.width= A           Max(event.xconfigure.width,windows->command.min_width);           windows->command.height=C           Max(event.xconfigure.height,windows->command.min_height); (         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { :         if (event.xcrossing.window != windows->command.id)           break;&         state&=(~InactiveWidgetState);J         id=((event.xcrossing.y-title_height)/(int) selection_info.height);2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */         selection_info.id=id; N         selection_info.y=title_height+selection_info.id*selection_info.height;$         selection_info.raised=False;;         selection_info.text=CommandMenu[selection_info.id]; C         XDrawWidgetText(display,&windows->command,&selection_info); ,         if ((id >= 0) && (id < NumberMenus))           {              submenu_info.y= I               selection_info.y+(windows->command.font_info->ascent >> 1); G             XDrawTriangleEast(display,&windows->command,&submenu_info);            }          break;       }        case Expose:       { 8         if (event.xexpose.window != windows->command.id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case LeaveNotify:        { :         if (event.xcrossing.window != windows->command.id)           break;#         state|=InactiveWidgetState;          id=selection_info.id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*%           Unhighlight last selection. 
         */         selection_info.id=(~0); ?         selection_info.y=title_height+id*selection_info.height; #         selection_info.raised=True; ,         selection_info.text=CommandMenu[id];C         XDrawWidgetText(display,&windows->command,&selection_info); ,         if ((id >= 0) && (id < NumberMenus))           {              submenu_info.y= I               selection_info.y+(windows->command.font_info->ascent >> 1); G             XDrawTriangleEast(display,&windows->command,&submenu_info);            }          break;       }        case MotionNotify:       {          int            entry;  
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 8         if (event.xmotion.window != windows->command.id)           break;(         if (state & InactiveWidgetState)           break;F         id=(event.xmotion.y-title_height)/(int) selection_info.height;P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           { (             if (id == selection_info.id)               { 6                 if (event.xmotion.x <= submenu_info.x)                   break;4                 if ((id < 0) || (id >= NumberMenus))                   break;                 /*,                   Select item from sub-menu.                 */A                 windows->command.x_origin=windows->command.width; 7                 windows->command.y_origin=title_height+ H                   id*selection_info.height+(selection_info.height >> 1);                 entry=L                   XMenuWidget(display,windows,(char *) NULL,Menus[id],item);@                 XDefineCursor(display,windows->image.id,cursor);                 if (entry >= 0)                    { 9                     (void) strcpy(item,Menus[id][entry]); /                     key_symbol=Keys[id][entry]; %                     state|=ExitState;                      break;                   }                }              /*)               Unhighlight last selection.              */             selection_info.y= C               title_height+selection_info.id*selection_info.height; '             selection_info.raised=True; ?             selection_info.text=CommandMenu[selection_info.id]; G             XDrawWidgetText(display,&windows->command,&selection_info); N             if ((selection_info.id >= 0) && (selection_info.id < NumberMenus))               {                  submenu_info.y= M                   selection_info.y+(windows->command.font_info->ascent >> 1); K                 XDrawTriangleEast(display,&windows->command,&submenu_info);                } (             if (id == selection_info.id)               break;           }          selection_info.id=id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */         XFlush(display);?         selection_info.y=title_height+id*selection_info.height; $         selection_info.raised=False;,         selection_info.text=CommandMenu[id];C         XDrawWidgetText(display,&windows->command,&selection_info); ,         if ((id >= 0) && (id < NumberMenus))           {              submenu_info.y= I               selection_info.y+(windows->command.font_info->ascent >> 1); G             XDrawTriangleEast(display,&windows->command,&submenu_info);            }          break;       }        case UnmapNotify:        { 6         if (event.xexpose.window != windows->popup.id)           break;9         XDrawBevel(display,&windows->command,&menu_info);          break;       }        default:         break;     } !   } while (!(state & ExitState)); A   XDefineCursor(display,windows->image.id,windows->image.cursor); G   XWithdrawWindow(display,windows->command.id,windows->command.screen); /   XCheckRefreshWindow(display,&windows->image);    return(key_symbol);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i r m W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XConfirmWidget displays a popup window with a notice to the user. G %  The function returns True if the user presses Yes otherwise False is  %  returned. % / %  The format of the XConfirmWidget routine is:  % = %    status=XConfirmWidget(display,windows,message,qualifier)  % + %  A description of each parameter follows:  % L %    o status:  Function XConfirmWidget returns True if the user presses Yes# %      otherwise False is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */> unsigned int XConfirmWidget(display,windows,message,qualifier) Display    *display;    XWindows   *windows;    char   *message, 
   *qualifier;  { " #define CancelButtonText  "Cancel" #define YesButtonText  "Yes"     int 
     limit,     x,     y;     unsigned int     confirm,     height, 	     mask, 
     width;     unsigned long 
     state;     Window     root_window;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      cancel_info,
     yes_info;      XWindowChanges     window_changes;      /*&     Determine popup window attributes.   *//   XCheckRefreshWindow(display,&windows->image); %   font_info=windows->popup.font_info; H   width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));H   if (XTextWidth(font_info,YesButtonText,strlen(YesButtonText)) > width)D     width=XTextWidth(font_info,YesButtonText,strlen(YesButtonText));   width<<=1;!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);;   windows->popup.width=width+7*font_info->max_bounds.width; "   windows->popup.height=12*height;D   windows->popup.min_width=width+(font_info->max_bounds.width << 2);%   windows->popup.min_height=7*height;    /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;0   windows->popup.x-=(windows->popup.width >> 1);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)      windows->popup.x=0;    else!     if (windows->popup.x > limit)        windows->popup.x=limit; 8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;5   windows->popup.y-=((5*windows->popup.height) >> 3); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;    else!     if (windows->popup.y > limit)        windows->popup.y=limit;    /*     Map popup window.    */0   (void) sprintf(windows->popup.name,"Confirm");H   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name); ,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   XBell(display,0);    /*     Respond to X events.   */   confirm=False;!   state=UpdateConfigurationState; F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   do   { )     if (state & UpdateConfigurationState)        { 
         /*+           Initialize No button information. 
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);6         cancel_info.width=font_info->max_bounds.width+J           XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));+         cancel_info.height=(3*height) >> 1; =         cancel_info.x=windows->popup.width-cancel_info.width- &           font_info->max_bounds.width;F         cancel_info.y=windows->popup.height-(cancel_info.height << 1);         yes_info=cancel_info; $         yes_info.text=YesButtonText;/         yes_info.x=font_info->max_bounds.width; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Confirm widget.
         */<         width=XTextWidth(font_info,message,strlen(message));3         x=(windows->popup.width >> 1)-(width >> 1); 5         y=(windows->popup.height >> 1)-(height << 1); N         XDrawString(display,windows->popup.id,windows->popup.annotate_context,'           x,y,message,strlen(message)); '         if (qualifier != (char *) NULL)            { D             width=XTextWidth(font_info,qualifier,strlen(qualifier));7             x=(windows->popup.width >> 1)-(width >> 1);              y+=height;2             XDrawString(display,windows->popup.id,O               windows->popup.annotate_context,x,y,qualifier,strlen(qualifier));            } A         XDrawBeveledButton(display,&windows->popup,&cancel_info); >         XDrawBeveledButton(display,&windows->popup,&yes_info);6         XHighlightWidget(display,&windows->popup,4,4);$         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*%               User pressed No button.              */%             cancel_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);              break;           } 2         if (MatteIsActive(yes_info,event.xbutton))           {              /*&               User pressed Yes button.             */"             yes_info.raised=False;B             XDrawBeveledButton(display,&windows->popup,&yes_info);             break;           }          break;       }        case ButtonRelease:        { #         if (!windows->popup.mapped)            break;          if (!cancel_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState; $             cancel_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&cancel_info);            }          if (!yes_info.raised)            { :             if (event.xbutton.window == windows->popup.id)8               if (MatteIsActive(yes_info,event.xbutton))                 {                    confirm=True; #                   state|=ExitState;                  } !             yes_info.raised=True; B             XDrawBeveledButton(display,&windows->popup,&yes_info);           }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;6         if (event.xclient.window == windows->popup.id)           {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)            break;?         if ((event.xconfigure.width == windows->popup.width) && ?             (event.xconfigure.height == windows->popup.height))            break;         windows->popup.width= ?           Max(event.xconfigure.width,windows->popup.min_width);          windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height); (         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             cancel_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);              state|=ExitState;              break;           }          break;       }        case LeaveNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*'               No button status changed.              */3             cancel_info.raised=!cancel_info.raised; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);              break;           } E         if (yes_info.raised == MatteIsActive(yes_info,event.xmotion))            {              /*(               Yes button status changed.             */-             yes_info.raised=!yes_info.raised; B             XDrawBeveledButton(display,&windows->popup,&yes_info);             break;           }          break;       }        default:         break;     } !   } while (!(state & ExitState)); A   XDefineCursor(display,windows->image.id,windows->image.cursor); C   XWithdrawWindow(display,windows->popup.id,windows->popup.screen); /   XCheckRefreshWindow(display,&windows->image);    return(confirm); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i a l o g W i d g e t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDialogWidget displays a popup window with a query to the user. J %  The user keys a reply and presses the Ok or Cancel button to exit.  The: %  typed text is returned as the reply function parameter. % . %  The format of the XDialogWidget routine is: % 6 %    XDialogWidget(display,windows,action,query,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. % G %    o reply: The response from the user is returned in this parameter.  %  %  */6 void XDialogWidget(display,windows,action,query,reply) Display    *display;    XWindows   *windows;    char
   *action,	   *query, 	   *reply;  { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];      int      x,     y;     register int     i;     unsigned int     height, 
     limit,	     mask, 
     width;     unsigned long 
     state;     Window     root_window;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     reply_info,      text_info;     XWindowChanges     window_changes;      /*&     Determine popup window attributes.   *//   XCheckRefreshWindow(display,&windows->image); %   font_info=windows->popup.font_info; 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));.   width+=(3*font_info->max_bounds.width) >> 1;.   height=font_info->ascent+font_info->descent;L   windows->popup.width=Max(width,XTextWidth(font_info,query,strlen(query)))+"     6*font_info->max_bounds.width;D   windows->popup.height=7*height+(font_info->max_bounds.width << 1);@   windows->popup.min_width=width+25*XTextWidth(font_info,"#",1)+"     4*font_info->max_bounds.width;2   windows->popup.min_height=windows->popup.height;   /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;0   windows->popup.x-=(windows->popup.width >> 1);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)      windows->popup.x=0;    else!     if (windows->popup.x > limit)        windows->popup.x=limit; 8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;1   windows->popup.y-=(windows->popup.height >> 1); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;    else!     if (windows->popup.y > limit)        windows->popup.y=limit;    /*     Map popup window.    *//   (void) sprintf(windows->popup.name,"Dialog"); H   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name); ,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */!   state=UpdateConfigurationState; F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; =         cancel_info.x=windows->popup.width-cancel_info.width- 1           ((3*font_info->max_bounds.width) >> 1); ?         cancel_info.y=windows->popup.height-cancel_info.height- 1           ((3*font_info->max_bounds.width) >> 1); ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+ F           font_info->max_bounds.width+(action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; N         reply_info.width=windows->popup.width-(3*font_info->max_bounds.width);&         reply_info.height=height << 1;:         reply_info.x=(3*font_info->max_bounds.width) >> 1;5         reply_info.y=action_info.y-reply_info.height- &           font_info->max_bounds.width;
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;D         text_info.x=reply_info.x-(font_info->max_bounds.width >> 1);0         text_info.y=font_info->max_bounds.width;+         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*           Redraw Dialog widget. 
         */<         XDrawWidgetText(display,&windows->popup,&text_info);?         XDrawBeveledMatte(display,&windows->popup,&reply_info); <         XDrawMatteText(display,&windows->popup,&reply_info);A         XDrawBeveledButton(display,&windows->popup,&action_info); A         XDrawBeveledButton(display,&windows->popup,&cancel_info); 6         XHighlightWidget(display,&windows->popup,4,4);$         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed Action button.              */%             action_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);              break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); H                 XSetSelectionOwner(display,XA_PRIMARY,windows->popup.id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==$                   windows->popup.id;               } @             XDrawMatteText(display,&windows->popup,&reply_info);*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 0           windows->popup.id,event.xbutton.time);         break;       }        case ButtonRelease:        { #         if (!windows->popup.mapped)            break;          if (!action_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(action_info,event.xbutton)) !                 state|=ExitState; $             action_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&action_info);            }           if (!cancel_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&cancel_info);            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;6         if (event.xclient.window == windows->popup.id)           { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)            break;?         if ((event.xconfigure.width == windows->popup.width) && ?             (event.xconfigure.height == windows->popup.height))            break;         windows->popup.width= ?           Max(event.xconfigure.width,windows->popup.min_width);          windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height); (         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextLength];            static int           length;            static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)%           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             action_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&action_info);              state|=ExitState;W             break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           }f@         XEditText(display,&reply_info,key_symbol,command,state);<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L)e!           state&=(~ControlState);r         break;       }a       case LeaveNotify:        {p8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;h         break;       }a       case MotionNotify:       {o
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))a           {e             /*+               Action button status changed.o             */3             action_info.raised=!action_info.raised;mE             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))l           {w             /*+               Cancel button status changed.r             */3             cancel_info.raised=!cancel_info.raised; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);a             break;           }g         break;       }        case SelectionClear:       {s#         reply_info.highlight=False; <         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case SelectionNotify:        {r         Atom           type;            int            format,            status;            unsigned char            *data;           unsigned long%           after,           length;%  
         /*1           Obtain response from primary selection.e
         */5         if (event.xselection.property == (Atom) None).           break;E         status=XGetWindowProperty(display,event.xselection.requestor,dJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||x             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);)         else           {              /*5               Insert primary selection in reply text.n             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,T               state);h@             XDrawMatteText(display,&windows->popup,&reply_info);           }          XFree((void *) data);t         break;       }a       case SelectionRequest:       {p         XSelectionEvent            notify;l           XSelectionRequestEvent           *request;s  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));sN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     }%!   } while (!(state & ExitState));%A   XDefineCursor(display,windows->image.id,windows->image.cursor);vC   XWithdrawWindow(display,windows->popup.id,windows->popup.screen); /   XCheckRefreshWindow(display,&windows->image);d }d   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             %oO %                                                                             %yO %                                                                             %eO %   X F i l e B r o w s e r W i d g e t                                       %pO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % K %  Function XFileBrowserWidget displays a popup window with a file query to K %  the user.  The user keys a reply and presses the Action or Cancel buttoniH %  to exit.  The typed text is returned as the reply function parameter. %e3 %  The format of the XFileBrowserWidget routine is:  %n5 %    XFileBrowserWidget(display,windows,action,reply)  %n+ %  A description of each parameter follows:  %oE %    o display: Specifies a connection to an X server;  returned from. %      XOpenDisplay. %n; %    o window: Specifies a pointer to a XWindows structure.S %e@ %    o action: Specifies a pointer to the action of this widget. %sG %    o reply: The response from the user is returned in this parameter.o %M %O */5 void XFileBrowserWidget(display,windows,action,reply)  Displayn   *display;    XWindows   *windows;n   char
   *action,	   *reply;  { " #define CancelButtonText  "Cancel"# #define DirectoryText  "Directory:"o" #define FilenameText  "File name:" #define HomeButtonText  "Home" #define UpButtonText  "Up"     char     **filelist, "     home_directory[MaxTextLength],%     primary_selection[MaxTextLength],n     text[MaxTextLength],%     working_directory[MaxTextLength];o     into
     files,     x,     y;     register int     i;  
   static chart&     glob_pattern[MaxTextLength] = "*";     unsigned int     height, 
     limit,	     mask,%     text_width,%     visible_files,
     width;     unsigned long 
     delay,
     state;     Window     root_window;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     list_info,     home_info,     north_info,      reply_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info,     up_info;     XWindowChanges     window_changes;      /*)     Read filelist from current directory.    */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);/   XCheckRefreshWindow(display,&windows->image);%0   (void) getcwd(home_directory,MaxTextLength-1);2   (void) strcpy(working_directory,home_directory);<   filelist=ListFiles(working_directory,glob_pattern,&files);!   if (filelist == (char **) NULL)e     {-       /*         Directory read failed.       */@       XNoticeWidget(display,windows,"Unable to read directory:",         working_directory);rD       XDialogWidget(display,windows,action,"Enter filename:",reply);
       return;s     }r   /*&     Determine popup window attributes.   */%   font_info=windows->popup.font_info;o   text_width=0;o   for (i=0; i < files; i++)oK     if (XTextWidth(font_info,filelist[i],strlen(filelist[i])) > text_width) G       text_width=XTextWidth(font_info,filelist[i],strlen(filelist[i]));s4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));J   if (XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText)) > width)F     width=XTextWidth(font_info,HomeButtonText,strlen(HomeButtonText));F   if (XTextWidth(font_info,UpButtonText,strlen(UpButtonText)) > width)B     width=XTextWidth(font_info,UpButtonText,strlen(UpButtonText));%   width+=font_info->max_bounds.width; H   if (XTextWidth(font_info,DirectoryText,strlen(DirectoryText)) > width)D     width=XTextWidth(font_info,DirectoryText,strlen(DirectoryText));F   if (XTextWidth(font_info,FilenameText,strlen(FilenameText)) > width)B     width=XTextWidth(font_info,FilenameText,strlen(FilenameText));.   height=font_info->ascent+font_info->descent;   windows->popup.width=-E     width+Min(text_width,MaxTextWidth)+6*font_info->max_bounds.width;b   windows->popup.height=A     ((81*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4; L   windows->popup.min_width=width+MinTextWidth+4*font_info->max_bounds.width;   windows->popup.min_height=A     ((23*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;f   /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;4   windows->popup.x-=((3*windows->popup.width) >> 2);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)p     windows->popup.x=0;_   else!     if (windows->popup.x > limit)        windows->popup.x=limit;p8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;1   windows->popup.y-=(windows->popup.height >> 1); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)y     windows->popup.y=0;    else!     if (windows->popup.y > limit)%       windows->popup.y=limit;%   /*     Map popup window.    */A   (void) sprintf(windows->popup.name,"Browse and Select a File"); H   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name); ,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);a,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_files=0;   delay=SuspendTime << 2;a!   state=UpdateConfigurationState;    do   {f)     if (state & UpdateConfigurationState)        {          inte
           id;w  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;p=         cancel_info.x=windows->popup.width-cancel_info.width-m(           font_info->max_bounds.width-2;?         cancel_info.y=windows->popup.height-cancel_info.height- &           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+nM           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1)); $         action_info.y=cancel_info.y;.         XGetWidgetInfo(UpButtonText,&up_info);         up_info.width=width;'         up_info.height=(3*height) >> 1; .         up_info.x=font_info->max_bounds.width;@         up_info.y=((5*font_info->max_bounds.width) >> 1)+height;2         XGetWidgetInfo(HomeButtonText,&home_info);         home_info.width=width;)         home_info.height=(3*height) >> 1; 0         home_info.x=font_info->max_bounds.width;I         home_info.y=up_info.y+up_info.height+font_info->max_bounds.width; 
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;%4         reply_info.width=windows->popup.width-width-1           ((6*font_info->max_bounds.width) >> 1);l&         reply_info.height=height << 1;>         reply_info.x=width+(font_info->max_bounds.width << 1);         reply_info.y=pF           action_info.y-reply_info.height-font_info->max_bounds.width;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);X"         scroll_info.bevel_width--;!         scroll_info.width=height;          scroll_info.height= D           reply_info.y-up_info.y-(font_info->max_bounds.width >> 1);H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);7         scroll_info.y=up_info.y-reply_info.bevel_width; !         scroll_info.raised=False;f          scroll_info.trough=True;         north_info=scroll_info;a         north_info.raised=True;o8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;l-         north_info.x+=north_info.bevel_width;_-         north_info.y+=north_info.bevel_width;x         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;%P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;M         visible_files=(scroll_info.height-(height >> 3)-4)/((9*height) >> 3); "         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);a         list_info.raised=False;y          list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;D"         list_info.y=scroll_info.y;#         if (!windows->popup.mapped)_#           for (i=0; i < files; i++)i/             if (strcmp(filelist[i],reply) == 0)f               list_info.id=i;s
         /*&           Initialize text information.
         */(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;y          text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1); 0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width;o.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);h       }o"     if (state & RedrawWidgetState)       { 
         /*%           Redraw File Browser window.w
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;eN         XDrawString(display,windows->popup.id,windows->popup.annotate_context,3           x,y,DirectoryText,strlen(DirectoryText));nA         (void) sprintf(text_info.text,"%s%s%s",working_directory, +           DirectorySeparator,glob_pattern);u<         XDrawWidgetText(display,&windows->popup,&text_info);=         XDrawBeveledButton(display,&windows->popup,&up_info); ?         XDrawBeveledButton(display,&windows->popup,&home_info);f>         XDrawBeveledMatte(display,&windows->popup,&list_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info);-@         XDrawTriangleSouth(display,&windows->popup,&south_info);&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; N         XDrawString(display,windows->popup.id,windows->popup.annotate_context,1           x,y,FilenameText,strlen(FilenameText)); ?         XDrawBeveledMatte(display,&windows->popup,&reply_info); <         XDrawMatteText(display,&windows->popup,&reply_info);A         XDrawBeveledButton(display,&windows->popup,&action_info);iA         XDrawBeveledButton(display,&windows->popup,&cancel_info);n6         XHighlightWidget(display,&windows->popup,4,4);         selection_info.id=(~0);l         state|=RedrawListState;S$         state&=(~RedrawWidgetState);       }N      if (state & UpdateListState)       {l         char           **checklist;           int0           number_files;n  
         /*           Update file list.t
         */J         checklist=ListFiles(working_directory,glob_pattern,&number_files);(         if (checklist == (char **) NULL)           {f             /*(               Reply is a filename, exit.             */%             action_info.raised=False;lE             XDrawBeveledButton(display,&windows->popup,&action_info);n             break;           }a!         for (i=0; i < files; i++)l,           (void) free((char *) filelist[i]);'         if (filelist != (char **) NULL)l)           (void) free((char *) filelist);x         filelist=checklist;          files=number_files;o
         /*           Update file list.k
         */'         if (filelist == (char **) NULL)-           {t             /*(               Reply is a filename, exit.             */%             action_info.raised=False;%E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           }          slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState;%
         /*(           Redraw directory name & reply.
         */%         if (!IsGlob(reply_info.text))i           { "             *reply_info.text='\0';.             reply_info.cursor=reply_info.text;           }-A         (void) sprintf(text_info.text,"%s%s%s",working_directory, +           DirectorySeparator,glob_pattern);_<         XDrawWidgetText(display,&windows->popup,&text_info);<         XDrawMatteText(display,&windows->popup,&reply_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info);u@         XDrawTriangleSouth(display,&windows->popup,&south_info);6         XHighlightWidget(display,&windows->popup,4,4);"         state&=(~UpdateListState);       }I      if (state & RedrawListState)       {t
         /*+           Determine slider id and position. 
         */:         if (slider_info.id >= (int) (files-visible_files))-           slider_info.id=files-visible_files; =         if ((slider_info.id < 0) || (files <= visible_files))            slider_info.id=0;i(         slider_info.y=slider_info.min_y;         if (files > 0)           slider_info.y+= I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/files;v0         if (slider_info.id != selection_info.id)           {.             /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2;c-             for (i=0; i < visible_files; i++) 
             {wG               selection_info.raised=(slider_info.id+i) != list_info.id;.0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < files)n?                 selection_info.text=filelist[slider_info.id+i];sG               XDrawWidgetText(display,&windows->popup,&selection_info);d<               selection_info.y+=(int) selection_info.height;
             }r             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               {>?                 expose_info.height=expose_info.y-slider_info.y;i?                 expose_info.y=slider_info.y+slider_info.height+o,                   slider_info.bevel_width+1;               }sD             XDrawTriangleNorth(display,&windows->popup,&north_info);=             XDrawMatte(display,&windows->popup,&expose_info);nE             XDrawBeveledButton(display,&windows->popup,&slider_info);dD             XDrawTriangleSouth(display,&windows->popup,&south_info);(             expose_info.y=slider_info.y;           }%"         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState;%
             }%         if (!south_info.raised)F%           if (slider_info.id < files)n
             {l               /*!                 Move slider down.                */               slider_info.id++;e%               state|=RedrawListState;f
             }g(         if (event.type != ButtonRelease)           continue;d       }r     switch (event.type)s     {n       case ButtonPress:s       { 5         if (MatteIsActive(slider_info,event.xbutton))u           {              /*               Track slider._             */$             slider_info.active=True;             break;           }p4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)i
             {                /*                 Move slider up.n               */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;1               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < files)r
             {t               /*!                 Move slider down.>               */&               south_info.raised=False;               slider_info.id++;_%               state|=RedrawListState;e               break;
             }+5         if (MatteIsActive(scroll_info,event.xbutton))v           {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_files-1);             else0               slider_info.id+=(visible_files-1);#             state|=RedrawListState;p             break;           } 3         if (MatteIsActive(list_info,event.xbutton))0           {o             unsigned int               id;2               /*&               User pressed file matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= files)               break;8             (void) strcpy(reply_info.text,filelist[id]);'             reply_info.highlight=False;n.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);@             XDrawMatteText(display,&windows->popup,&reply_info);#             if (id == list_info.id)t               {sA                 (void) strcpy(working_directory,reply_info.text);n'                 state|=UpdateListState;i               }r#             selection_info.id=(~0);=             list_info.id=id;#             state|=RedrawListState;              break;           }o1         if (MatteIsActive(up_info,event.xbutton))w           {n             /*%               User pressed Up button._             */!             up_info.raised=False; A             XDrawBeveledButton(display,&windows->popup,&up_info);d             break;           } 3         if (MatteIsActive(home_info,event.xbutton))%           {%             /*'               User pressed Home button.              */#             home_info.raised=False; C             XDrawBeveledButton(display,&windows->popup,&home_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.%             */%             cancel_info.raised=False;aE             XDrawBeveledButton(display,&windows->popup,&cancel_info);v             break;           }h5         if (!MatteIsActive(reply_info,event.xbutton))c           break;,         if (event.xbutton.button != Button2)           {w             static Timed               click_time;                /*;               Move text cursor to position of button press.o             */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);.H                 XSetSelectionOwner(display,XA_PRIMARY,windows->popup.id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==$                   windows->popup.id;               }f@             XDrawMatteText(display,&windows->popup,&reply_info);*             click_time=event.xbutton.time;             break;           }t
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,,0           windows->popup.id,event.xbutton.time);         break;       }n       case ButtonRelease:=       {o#         if (!windows->popup.mapped)            break;         if (!north_info.raised)l           {o             /*&               User released up button.             */#             delay=SuspendTime << 2;o#             north_info.raised=True;nD             XDrawTriangleNorth(display,&windows->popup,&north_info);           }          if (!south_info.raised)/           {.             /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True;oD             XDrawTriangleSouth(display,&windows->popup,&south_info);           }o         if (slider_info.active)a           {l             /*#               Stop tracking slider.c             */%             slider_info.active=False;              break;           }n         if (!up_info.raised)           {1:             if (event.xbutton.window == windows->popup.id)7               if (MatteIsActive(up_info,event.xbutton))o                 {w8                   (void) strcpy(working_directory,"..");)                   state|=UpdateListState;n                 }>              up_info.raised=True;A             XDrawBeveledButton(display,&windows->popup,&up_info);_           }o         if (!home_info.raised)           {%:             if (event.xbutton.window == windows->popup.id)9               if (MatteIsActive(home_info,event.xbutton))                  { B                   (void) strcpy(working_directory,home_directory);)                   state|=UpdateListState;                  } "             home_info.raised=True;C             XDrawBeveledButton(display,&windows->popup,&home_info);            }           if (!action_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);%                 else#                   state|=ExitState;%$             action_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&action_info);            }n          if (!cancel_info.raised)           {f:             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(cancel_info,event.xbutton))i                 {r(                   *reply_info.text='\0';#                   state|=ExitState;r                 } $             cancel_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&cancel_info);o           }          break;       }r       case ClientMessage:c       {a
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {;G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);g             break;           }c?         if (*event.xclient.data.l != windows->wm_delete_window)_           break;6         if (event.xclient.window == windows->popup.id)           { "             *reply_info.text='\0';             state|=ExitState;_             break;           }e         break;       }t       case ConfigureNotify:        {n
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)t           break;?         if ((event.xconfigure.width == windows->popup.width) &&i?             (event.xconfigure.height == windows->popup.height))f           break;         windows->popup.width=i?           Max(event.xconfigure.width,windows->popup.min_width);/         windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height);f(         state|=UpdateConfigurationState;         break;       }f       case EnterNotify:        {t8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       })       case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)g           break;!         state|=RedrawWidgetState;o         break;       }k       case KeyPress:       {          static charx!           command[MaxTextLength];f           static int           length;            static KeySym>           key_symbol;o  3         if (event.xkey.window != windows->popup.id)%           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 2         if (MatteIsActive(scroll_info,event.xkey))           {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               {%!                 slider_info.id--;%                 break;               }o               case XK_Down:n               case XK_KP_Down:               {r!                 slider_info.id++;                  break;               }y               case XK_Prior:               case XK_KP_Prior:l               {o.                 slider_info.id-=visible_files;                 break;               }                case XK_Next:                case XK_KP_Next:               { .                 slider_info.id+=visible_files;                 break;               }h               case XK_End:               case XK_KP_End:                {a%                 slider_info.id=files;                  break;               }d
             }t#             state|=RedrawListState;a             break;           }cE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))d           {W             /*1               Read new directory or glob patterm.x             */)             if (*reply_info.text == '\0')                break;(             if (IsGlob(reply_info.text)):               (void) strcpy(glob_pattern,reply_info.text);             else               { A                 (void) strcpy(working_directory,reply_info.text);(,                 if (*reply_info.text == '~')                   {l!                     register char                        *p;_                        /*)                       Get home directory.                      */%                     p=getenv("HOME");n+                     if (p != (char *) NULL)c                       { ;                         (void) strcpy(working_directory,p); K                         (void) strcat(working_directory,reply_info.text+1);-                       }x                   }e               }r#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)=           switch (key_symbol)f           {e             case XK_u:             case XK_U:
             {,               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;>               break;
             }c             default:               break;           }e@         XEditText(display,&reply_info,key_symbol,command,state);<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case KeyRelease:       {i         static char !           command[MaxTextLength];l           static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)x           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),%/           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y)XI               slider_info.id=(files*(slider_info.y-slider_info.min_y+1))/i8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;C         if (up_info.raised == MatteIsActive(up_info,event.xmotion))            {>             /*'               Up button status changed.d             */+             up_info.raised=!up_info.raised;hA             XDrawBeveledButton(display,&windows->popup,&up_info);x             break;           } G         if (home_info.raised == MatteIsActive(home_info,event.xmotion))            {o             /*)               Home button status changed.%             *//             home_info.raised=!home_info.raised; C             XDrawBeveledButton(display,&windows->popup,&home_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; E             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.%             */3             cancel_info.raised=!cancel_info.raised;HE             XDrawBeveledButton(display,&windows->popup,&cancel_info);f             break;           }c         break;       }h       case SelectionClear:       { #         reply_info.highlight=False;r<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case SelectionNotify:        {w         Atom           type;            intw           format,            status;e           unsigned char            *data;           unsigned longc           after,           length;t  
         /*1           Obtain response from primary selection.n
         */5         if (event.xselection.property == (Atom) None)y           break;E         status=XGetWindowProperty(display,event.xselection.requestor,*J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||i             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);d         else           {i             /*5               Insert primary selection in reply text.l             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,f               state); @             XDrawMatteText(display,&windows->popup,&reply_info);           }%         XFree((void *) data);%         break;       }%       case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }e       default:         break;     } !   } while (!(state & ExitState));eA   XDefineCursor(display,windows->image.id,windows->image.cursor);tC   XWithdrawWindow(display,windows->popup.id,windows->popup.screen);,/   XCheckRefreshWindow(display,&windows->image);    /*     Free file list.    */   for (i=0; i < files; i++) &     (void) free((char *) filelist[i]);!   if (filelist != (char **) NULL) #     (void) free((char *) filelist);o }y   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %dO %                                                                             % O %                                                                             %iO %   X F o n t B r o w s e r W i d g e t                                       %)O %                                                                             %nO %                                                                             % O %                                                                             %nO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %uK %  Function XFontBrowserWidget displays a popup window with a font query to K %  the user.  The user keys a reply and presses the Action or Cancel button-H %  to exit.  The typed text is returned as the reply function parameter. % 3 %  The format of the XFontBrowserWidget routine is:c %t5 %    XFontBrowserWidget(display,windows,action,reply)  % + %  A description of each parameter follows:i %wE %    o display: Specifies a connection to an X server;  returned froma %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. %cG %    o reply: The response from the user is returned in this parameter.u %  %  */ static int FontCompare(x,y) 
 const void   *x,    *y;K {e   register charM     *p,f     *q;a     p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {%     p++;     q++;   }%   return(*p-(*q)); }%  5 void XFontBrowserWidget(display,windows,action,reply)  Display    *display;    XWindows   *windows;    char
   *action,	   *reply;  {  #define BackButtonText  "Back"" #define CancelButtonText  "Cancel" #define FontnameText  "Name:" # #define FontPatternText  "Pattern:"   #define ResetButtonText  "Reset"     char      back_pattern[MaxTextLength],     **fontlist,      **listhead, %     primary_selection[MaxTextLength], !     reset_pattern[MaxTextLength],      text[MaxTextLength];     int 
     fonts,     x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextLength] = "*";     unsigned int     height,%
     limit,	     mask,      text_width,t     visible_fonts,
     width;     unsigned longe
     delay,
     state;     Window     root_window;     XEvent
     event;  
   XFontStructo     *font_info;w     XTextProperty      window_name;  
   XWidgetInfof     action_info,     back_info,     cancel_info,     expose_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,e     scroll_info,     selection_info,      slider_info,     south_info,e     text_info;     XWindowChanges     window_changes;r     /*.     Get font list and sort in ascending order.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);/   XCheckRefreshWindow(display,&windows->image); +   (void) strcpy(back_pattern,glob_pattern); #   (void) strcpy(reset_pattern,"*");;9   fontlist=XListFonts(display,glob_pattern,32767,&fonts);S   if (fonts == 0)y     {_       /*-         Pattern failed, obtain all the fonts.w       */D       XNoticeWidget(display,windows,"Unable to obtain fonts names:",         glob_pattern);&       (void) strcpy(glob_pattern,"*");=       fontlist=XListFonts(display,glob_pattern,32767,&fonts); %       if (fontlist == (char **) NULL)i	         { H           XNoticeWidget(display,windows,"Unable to obtain fonts names:",             glob_pattern);           return;l	         }      }e   /*&     Sort font list in ascending order.   */   listhead=fontlist;3   fontlist=(char **) malloc(fonts*sizeof(char **));r!   if (fontlist == (char **) NULL)r     {s<       XNoticeWidget(display,windows,"Unable to view fonts:",$         "Memory allocation failed");
       return;%     }%   for (i=0; i < fonts; i++)%     fontlist[i]=listhead[i];7   (void) qsort((void *) fontlist,fonts,sizeof(char **), B     (int (*) _Declare((const void *, const void *))) FontCompare);   /*&     Determine popup window attributes.   */%   font_info=windows->popup.font_info;    text_width=0;    for (i=0; i < fonts; i++) K     if (XTextWidth(font_info,fontlist[i],strlen(fontlist[i])) > text_width) G       text_width=XTextWidth(font_info,fontlist[i],strlen(fontlist[i])); 4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,strlen(ResetButtonText));J   if (XTextWidth(font_info,BackButtonText,strlen(BackButtonText)) > width)F     width=XTextWidth(font_info,BackButtonText,strlen(BackButtonText));%   width+=font_info->max_bounds.width;tL   if (XTextWidth(font_info,FontPatternText,strlen(FontPatternText)) > width)H     width=XTextWidth(font_info,FontPatternText,strlen(FontPatternText));F   if (XTextWidth(font_info,FontnameText,strlen(FontnameText)) > width)B     width=XTextWidth(font_info,FontnameText,strlen(FontnameText));.   height=font_info->ascent+font_info->descent;   windows->popup.width=dE     width+Min(text_width,MaxTextWidth)+6*font_info->max_bounds.width;    windows->popup.height=A     ((85*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4;eL   windows->popup.min_width=width+MinTextWidth+4*font_info->max_bounds.width;   windows->popup.min_height=A     ((27*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;    /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;4   windows->popup.x-=((3*windows->popup.width) >> 2);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)      windows->popup.x=0;    else!     if (windows->popup.x > limit)        windows->popup.x=limit; 8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;1   windows->popup.y-=(windows->popup.height >> 1); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;    else!     if (windows->popup.y > limit)        windows->popup.y=limit;%   /*     Map popup window.%   */A   (void) sprintf(windows->popup.name,"Browse and Select a Font");oH   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name);X,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);a,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_fonts=0;   delay=SuspendTime << 2;=!   state=UpdateConfigurationState;o   do   {o)     if (state & UpdateConfigurationState)S       {u         intn
           id;t  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; =         cancel_info.x=windows->popup.width-cancel_info.width- (           font_info->max_bounds.width-2;?         cancel_info.y=windows->popup.height-cancel_info.height-%&           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; 7         action_info.x=cancel_info.x-(cancel_info.width+ M           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1)); $         action_info.y=cancel_info.y;2         XGetWidgetInfo(BackButtonText,&back_info);         back_info.width=width;)         back_info.height=(3*height) >> 1; 0         back_info.x=font_info->max_bounds.width;B         back_info.y=((5*font_info->max_bounds.width) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width;%*         reset_info.height=(3*height) >> 1;1         reset_info.x=font_info->max_bounds.width;rN         reset_info.y=back_info.y+back_info.height+font_info->max_bounds.width;
         /*'           Initialize reply information.t
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;w4         reply_info.width=windows->popup.width-width-1           ((6*font_info->max_bounds.width) >> 1);o&         reply_info.height=height << 1;>         reply_info.x=width+(font_info->max_bounds.width << 1);         reply_info.y= N           action_info.y-(action_info.height << 1)-font_info->max_bounds.width;
         /*&           Initialize mode information.
         */)         XGetWidgetInfo(reply,&mode_info);d          mode_info.bevel_width=0;O         mode_info.width=action_info.x-reply_info.x-font_info->max_bounds.width; 1         mode_info.height=action_info.height << 1;m!         mode_info.x=reply_info.x;nM         mode_info.y=action_info.y-action_info.height+action_info.bevel_width;e
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);x"         scroll_info.bevel_width--;!         scroll_info.width=height;          scroll_info.height= F           reply_info.y-back_info.y-(font_info->max_bounds.width >> 1);H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=back_info.y-reply_info.bevel_width; !         scroll_info.raised=False;r          scroll_info.trough=True;         north_info=scroll_info;n         north_info.raised=True;d8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;t-         north_info.x+=north_info.bevel_width;e-         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;,         slider_info.id=id;         slider_info.width-=2;rP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=*J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_fonts=A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3);c"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;f          list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;o"         list_info.y=scroll_info.y;#         if (!windows->popup.mapped)e#           for (i=0; i < fonts; i++) /             if (strcmp(fontlist[i],reply) == 0)r               list_info.id=i;T
         /*&           Initialize text information.
         */(         XGetWidgetInfo(text,&text_info);)         text_info.width=reply_info.width;f          text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1);i0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information.o
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width;;.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;i+         state&=(~UpdateConfigurationState);o       }h"     if (state & RedrawWidgetState)       {)
         /*%           Redraw Font Browser window. 
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; N         XDrawString(display,windows->popup.id,windows->popup.annotate_context,7           x,y,FontPatternText,strlen(FontPatternText));w9         (void) sprintf(text_info.text,"%s",glob_pattern);d<         XDrawWidgetText(display,&windows->popup,&text_info);?         XDrawBeveledButton(display,&windows->popup,&back_info);s@         XDrawBeveledButton(display,&windows->popup,&reset_info);>         XDrawBeveledMatte(display,&windows->popup,&list_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info);n@         XDrawTriangleSouth(display,&windows->popup,&south_info);&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;pN         XDrawString(display,windows->popup.id,windows->popup.annotate_context,1           x,y,FontnameText,strlen(FontnameText));y?         XDrawBeveledMatte(display,&windows->popup,&reply_info);n<         XDrawMatteText(display,&windows->popup,&reply_info);A         XDrawBeveledButton(display,&windows->popup,&action_info);MA         XDrawBeveledButton(display,&windows->popup,&cancel_info);d6         XHighlightWidget(display,&windows->popup,4,4);         selection_info.id=(~0);s!         state|=RedrawActionState;g         state|=RedrawListState;i$         state&=(~RedrawWidgetState);       }>      if (state & UpdateListState)       {|         char           **checklist;           int>           number_fonts;p  
         /*           Update font list.e
         */G         checklist=XListFonts(display,glob_pattern,32767,&number_fonts); (         if (checklist == (char **) NULL)           {t>             if ((strchr(glob_pattern,'*') == (char *) NULL) &&<                 (strchr(glob_pattern,'?') == (char *) NULL))               {S                 /*3                   Might be a scaleable font-- exit.n                 */2                 (void) strcpy(reply,glob_pattern);9                 (void) strcpy(glob_pattern,back_pattern); )                 action_info.raised=False; I                 XDrawBeveledButton(display,&windows->popup,&action_info);                  break;               }a5             (void) strcpy(glob_pattern,back_pattern);              XBell(display,0);.           }          else            if (number_fonts == 1)
             {t               /*3                 Reply is a single font name-- exit.i               */0               (void) strcpy(reply,checklist[0]);7               (void) strcpy(glob_pattern,back_pattern); (               XFreeFontNames(checklist);'               action_info.raised=False;;G               XDrawBeveledButton(display,&windows->popup,&action_info);1               break;
             }x           else
             {f'               XFreeFontNames(listhead);)-               (void) free((char *) fontlist);t!               fontlist=checklist;w!               fonts=number_fonts;i
             }>
         /*,           Sort font list in ascending order.
         */         listhead=fontlist;9         fontlist=(char **) malloc(fonts*sizeof(char **)); '         if (fontlist == (char **) NULL)            {GB             XNoticeWidget(display,windows,"Unable to view fonts:",*               "Memory allocation failed");             return;o           }t!         for (i=0; i < fonts; i++)m"           fontlist[i]=listhead[i];=         (void) qsort((void *) fontlist,fonts,sizeof(char **),iH           (int (*) _Declare((const void *, const void *))) FontCompare);         slider_info.height=fJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0;i(         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*#           Redraw font name & reply.o
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern);=<         XDrawWidgetText(display,&windows->popup,&text_info);<         XDrawMatteText(display,&windows->popup,&reply_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info);n@         XDrawTriangleSouth(display,&windows->popup,&south_info);6         XHighlightWidget(display,&windows->popup,4,4);"         state&=(~UpdateListState);       }       if (state & RedrawListState)       {h
         /*+           Determine slider id and position. 
         */:         if (slider_info.id >= (int) (fonts-visible_fonts))-           slider_info.id=fonts-visible_fonts; =         if ((slider_info.id < 0) || (fonts <= visible_fonts))h           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (fonts > 0)           slider_info.y+=eI             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/fonts; 0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.i             */-             selection_info.id=slider_info.id;_9             selection_info.y=list_info.y+(height >> 3)+2;f-             for (i=0; i < visible_fonts; i++)i
             {fG               selection_info.raised=(slider_info.id+i) != list_info.id;e0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < fonts)n?                 selection_info.text=fontlist[slider_info.id+i];tG               XDrawWidgetText(display,&windows->popup,&selection_info);-<               selection_info.y+=(int) selection_info.height;
             }-             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {=?                 expose_info.height=slider_info.y-expose_info.y;o?                 expose_info.y=slider_info.y-expose_info.height-l,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y;.?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } D             XDrawTriangleNorth(display,&windows->popup,&north_info);=             XDrawMatte(display,&windows->popup,&expose_info);iE             XDrawBeveledButton(display,&windows->popup,&slider_info);lD             XDrawTriangleSouth(display,&windows->popup,&south_info);(             expose_info.y=slider_info.y;           }d"         state&=(~RedrawListState);       }t"     if (state & RedrawActionState)       {*         XFontStructl           *font_info,            *save_info;i  
         /*6           Display the selected font in a drawing area.
         */+         save_info=windows->popup.font_info;,:         font_info=XLoadQueryFont(display,reply_info.text);.         if (font_info != (XFontStruct *) NULL)           {v0             windows->popup.font_info=font_info;;K             XSetFont(display,windows->popup.widget_context,font_info->fid);v           }s?         XDrawBeveledButton(display,&windows->popup,&mode_info);s+         windows->popup.font_info=save_info;D.         if (font_info != (XFontStruct *) NULL)           { ;             XSetFont(display,windows->popup.widget_context, -               windows->popup.font_info->fid);&)             XFreeFont(display,font_info);s           }-6         XHighlightWidget(display,&windows->popup,4,4);<         XDrawMatteText(display,&windows->popup,&reply_info);$         state&=(~RedrawActionState);       }.     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)w=       XIfEvent(display,&event,XScreenEvent,(char *) windows);C     else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)p!           if (slider_info.id > 0)l
             {l               /*                 Move slider up.=               */               slider_info.id--; %               state|=RedrawListState;&
             }S         if (!south_info.raised) %           if (slider_info.id < fonts)r
             {h               /*!                 Move slider down.                */               slider_info.id++;a%               state|=RedrawListState;e
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)e     {        case ButtonPress:        {r5         if (MatteIsActive(slider_info,event.xbutton))b           {t             /*               Track slider.l             */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)c
             {s               /*                 Move slider up.c               */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < fonts)f
             {(               /*!                 Move slider down.l               */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))(           {m             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_fonts-1);             else0               slider_info.id+=(visible_fonts-1);#             state|=RedrawListState;.             break;           }d3         if (MatteIsActive(list_info,event.xbutton))            {t             unsigned int               id;;               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= fonts)               break;8             (void) strcpy(reply_info.text,fontlist[id]);'             reply_info.highlight=False;&.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);@             XDrawMatteText(display,&windows->popup,&reply_info);%             state|=RedrawActionState;a#             if (id == list_info.id)p               { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                }w#             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;l             break;           }i3         if (MatteIsActive(back_info,event.xbutton))_           {              /*'               User pressed Back button.)             */#             back_info.raised=False;.C             XDrawBeveledButton(display,&windows->popup,&back_info);.             break;           }(4         if (MatteIsActive(reset_info,event.xbutton))           {i             /*(               User pressed Reset button.             */$             reset_info.raised=False;D             XDrawBeveledButton(display,&windows->popup,&reset_info);             break;           }(5         if (MatteIsActive(action_info,event.xbutton))o           {              /*)               User pressed action button.o             */%             action_info.raised=False;tE             XDrawBeveledButton(display,&windows->popup,&action_info);              break;           }o5         if (MatteIsActive(cancel_info,event.xbutton))x           {n             /*)               User pressed Cancel button.o             */%             cancel_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);(             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))e           break;,         if (event.xbutton.button != Button2)           {i             static Time                click_time;t               /*;               Move text cursor to position of button press.o             */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;d             else               {;                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); H                 XSetSelectionOwner(display,XA_PRIMARY,windows->popup.id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==$                   windows->popup.id;               }a@             XDrawMatteText(display,&windows->popup,&reply_info);*             click_time=event.xbutton.time;             break;           }f
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,e0           windows->popup.id,event.xbutton.time);         break;       }t       case ButtonRelease:        { #         if (!windows->popup.mapped)            break;         if (!north_info.raised)d           {E             /*&               User released up button.             */#             delay=SuspendTime << 2;e#             north_info.raised=True;/D             XDrawTriangleNorth(display,&windows->popup,&north_info);           }(         if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; D             XDrawTriangleSouth(display,&windows->popup,&south_info);           }          if (slider_info.active)f           {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }d         if (!back_info.raised)           {s:             if (event.xbutton.window == windows->popup.id)9               if (MatteIsActive(back_info,event.xbutton))y                 { ;                   (void) strcpy(glob_pattern,back_pattern);r)                   state|=UpdateListState;                  } "             back_info.raised=True;C             XDrawBeveledButton(display,&windows->popup,&back_info);            }(         if (!reset_info.raised)u           { :             if (event.xbutton.window == windows->popup.id):               if (MatteIsActive(reset_info,event.xbutton))                 {o;                   (void) strcpy(back_pattern,glob_pattern); <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;e                 } #             reset_info.raised=True; D             XDrawBeveledButton(display,&windows->popup,&reset_info);           }           if (!action_info.raised)           { :             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(action_info,event.xbutton))I-                 if (*reply_info.text == '\0') #                   XBell(display,0);e                 else#                   state|=ExitState; $             action_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&action_info);f           }e          if (!cancel_info.raised)           {e:             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(cancel_info,event.xbutton))i                 { (                   *reply_info.text='\0';#                   state|=ExitState;                  }s$             cancel_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&cancel_info);            }          break;       }r       case ClientMessage:r       {_
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {-G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           }l?         if (*event.xclient.data.l != windows->wm_delete_window)a           break;6         if (event.xclient.window == windows->popup.id)           {i"             *reply_info.text='\0';             state|=ExitState;              break;           }(         break;       }        case ConfigureNotify:*       { 
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)l           break;?         if ((event.xconfigure.width == windows->popup.width) &&t?             (event.xconfigure.height == windows->popup.height))*           break;         windows->popup.width= ?           Max(event.xconfigure.width,windows->popup.min_width);B         windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height);a(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:e       {o8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)d           break;!         state|=RedrawWidgetState;i         break;       }        case KeyPress:       {y         static charc!           command[MaxTextLength];            static int           length;y           static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL);i         *(command+length)='\0'; 2         if (MatteIsActive(scroll_info,event.xkey))           {x             /*               Move slider.             */             switch (key_symbol)r
             {m               case XK_Home:v               case XK_KP_Home:               { !                 slider_info.id=0;e                 break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }o               case XK_Down:t               case XK_KP_Down:               {i!                 slider_info.id++;.                 break;               }g               case XK_Prior:               case XK_KP_Prior:                {;.                 slider_info.id-=visible_fonts;                 break;               }                case XK_Next:t               case XK_KP_Next:               { .                 slider_info.id+=visible_fonts;                 break;               },               case XK_End:               case XK_KP_End:i               {i%                 slider_info.id=fonts;a                 break;               }(
             }.#             state|=RedrawListState;f             break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*,               Read new font or glob patterm.             */)             if (*reply_info.text == '\0')&               break;5             (void) strcpy(back_pattern,glob_pattern); 8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;n             break;           }n'         if (key_symbol == XK_Control_L)l           {y              state|=ControlState;             break;           }f!         if (state & ControlState)            switch (key_symbol)n           {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;t               break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }(       case KeyRelease:       {          static char !           command[MaxTextLength];e           static KeySym            key_symbol;o  3         if (event.xkey.window != windows->popup.id)            break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL);d'         if (key_symbol == XK_Control_L) !           state&=(~ControlState);o         break;       }        case LeaveNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;          break;       }s       case MotionNotify:       {(
         /*/           Discard pending button motion events.(
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)p           {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(fonts*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;n             break;           } (         if (state & InactiveWidgetState)           break;G         if (back_info.raised == MatteIsActive(back_info,event.xmotion))            {              /*)               Back button status changed.E             *//             back_info.raised=!back_info.raised;uC             XDrawBeveledButton(display,&windows->popup,&back_info);f             break;           }MI         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised;cD             XDrawBeveledButton(display,&windows->popup,&reset_info);             break;           }nK         if (action_info.raised == MatteIsActive(action_info,event.xmotion))x           {,             /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;wE             XDrawBeveledButton(display,&windows->popup,&action_info);.             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {r             /*+               Cancel button status changed.i             */3             cancel_info.raised=!cancel_info.raised;tE             XDrawBeveledButton(display,&windows->popup,&cancel_info);.             break;           }f         break;       }        case SelectionClear:       { #         reply_info.highlight=False;w<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }n       case SelectionNotify:o       {i         Atom           type;h           int            format,u           status;p           unsigned char            *data;           unsigned long            after,           length;i  
         /*1           Obtain response from primary selection.p
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);e         else           {v             /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,)               state);o@             XDrawMatteText(display,&windows->popup,&reply_info);%             state|=RedrawActionState;n           }          XFree((void *) data);          break;       }        case SelectionRequest:       {b         XSelectionEvent            notify;o           XSelectionRequestEvent           *request;   
         /*#           Set XA_PRIMARY selection. 
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection)); $         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); A   XDefineCursor(display,windows->image.id,windows->image.cursor);rC   XWithdrawWindow(display,windows->popup.id,windows->popup.screen);b/   XCheckRefreshWindow(display,&windows->image);*   /*     Free font list.l   */   XFreeFontNames(listhead);/!   (void) free((char *) fontlist);= }\   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %eO %                                                                             % O %                                                                             %(O %   X L i s t B r o w s e r W i d g e t                                       % O %                                                                             % O %                                                                             %=O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %lJ %  Function XListBrowserWidget displays a popup window with a query to theJ %  user.  The user keys a reply or select a reply from the list.  Finally,K %  the user presses the Action or Cancel button to exit.  The typed text iso, %  returned as the reply function parameter. % 3 %  The format of the XListBrowserWidget routine is:a % @ %    XListBrowserWidget(display,windows,list,action,query,reply) % + %  A description of each parameter follows:] % E %    o display: Specifies a connection to an X server;  returned fromk %      XOpenDisplay. %u; %    o window: Specifies a pointer to a XWindows structure.u % F %    o list: Specifies a pointer to an array of strings.  The user can; %      select from these strings as a possible reply value.o %s@ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. %yG %    o reply: The response from the user is returned in this parameter.  %  %  */@ void XListBrowserWidget(display,windows,list,action,query,reply) Displaya   *display;f   XWindows   *windows;    char	   **list,e
   *action,	   *query,n	   *reply;  {/" #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextLength];d     intc     entries,     x,     y;     register int     i;     unsigned int     height, 
     limit,	     mask,.     text_width,-     visible_entries,
     width;     unsigned longl
     delay,
     state;     Window     root_window;     XEvent
     event;  
   XFontStruct.     *font_info;_     XTextProperty(     window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     list_info,     north_info,      reply_info,f     scroll_info,     selection_info,      slider_info,     south_info,f     text_info;     XWindowChanges     window_changes;m     /*,     Count the number of entries in the list.   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);/   XCheckRefreshWindow(display,&windows->image);.   if (list == (char **) NULL)f     {.H       XNoticeWidget(display,windows,"No text to browse:",(char *) NULL);
       return;      }    for (entries=0; ; entries++)'     if (list[entries] == (char *) NULL)v       break;   /*&     Determine popup window attributes.   */%   font_info=windows->popup.font_info;o7   text_width=XTextWidth(font_info,query,strlen(query));    for (i=0; i < entries; i++) C     if (XTextWidth(font_info,list[i],strlen(list[i])) > text_width)e?       text_width=XTextWidth(font_info,list[i],strlen(list[i]));n4   width=XTextWidth(font_info,action,strlen(action));N   if (XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,strlen(CancelButtonText));%   width+=font_info->max_bounds.width; .   height=font_info->ascent+font_info->descent;   windows->popup.width=uH     Min(text_width,MaxTextWidth)+((9*font_info->max_bounds.width) >> 1);   windows->popup.height=A     ((81*height) >> 2)+((13*font_info->max_bounds.width) >> 1)+4; F   windows->popup.min_width=MinTextWidth+4*font_info->max_bounds.width;   windows->popup.min_height=A     ((23*height) >> 1)+((13*font_info->max_bounds.width) >> 1)+4;s   /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;4   windows->popup.x-=((3*windows->popup.width) >> 2);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)      windows->popup.x=0;    else!     if (windows->popup.x > limit)n       windows->popup.x=limit;n8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;1   windows->popup.y-=(windows->popup.height >> 1); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;c   else!     if (windows->popup.y > limit)3       windows->popup.y=limit;0   /*     Map popup window.    *//   (void) sprintf(windows->popup.name,"Browse"); H   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name); ,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_entries=0;   delay=SuspendTime << 2;u!   state=UpdateConfigurationState;    do   {a)     if (state & UpdateConfigurationState)s       {s         int 
           id;s  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;q=         cancel_info.x=windows->popup.width-cancel_info.width- (           font_info->max_bounds.width-2;?         cancel_info.y=windows->popup.height-cancel_info.height-u&           font_info->max_bounds.width;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;v7         action_info.x=cancel_info.x-(cancel_info.width+,M           (font_info->max_bounds.width >> 1)+(action_info.bevel_width << 1)); $         action_info.y=cancel_info.y;
         /*'           Initialize reply information.i
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;a         reply_info.width= F           windows->popup.width-((4*font_info->max_bounds.width) >> 1);&         reply_info.height=height << 1;1         reply_info.x=font_info->max_bounds.width;l         reply_info.y=%F           action_info.y-reply_info.height-font_info->max_bounds.width;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;          scroll_info.height= E           reply_info.y-((6*font_info->max_bounds.width) >> 1)-height; H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);         scroll_info.y=O           ((5*font_info->max_bounds.width) >> 1)+height-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;%8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;s-         north_info.x+=north_info.bevel_width;e-         north_info.y+=north_info.bevel_width;X         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;c         slider_info.id=id;         slider_info.width-=2;pP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_entries=A           (scroll_info.height-(height >> 3)-4)/((9*height) >> 3);d&         if (entries > visible_entries)J           slider_info.height=(visible_entries*slider_info.height)/entries;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;         list_info.width=H           scroll_info.x-reply_info.x-(font_info->max_bounds.width >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;#         if (!windows->popup.mapped),%           for (i=0; i < entries; i++).+             if (strcmp(list[i],reply) == 0)r               list_info.id=i;T
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info);R)         text_info.width=reply_info.width;e          text_info.height=height;C         text_info.x=list_info.x-(font_info->max_bounds.width >> 1); 0         text_info.y=font_info->max_bounds.width;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width;,.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x;E+         state&=(~UpdateConfigurationState);s       } "     if (state & RedrawWidgetState)       { 
         /*%           Redraw List Browser window."
         */&         x=font_info->max_bounds.width;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; <         XDrawWidgetText(display,&windows->popup,&text_info);>         XDrawBeveledMatte(display,&windows->popup,&list_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info); @         XDrawTriangleSouth(display,&windows->popup,&south_info);&         x=font_info->max_bounds.width;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; ?         XDrawBeveledMatte(display,&windows->popup,&reply_info);e<         XDrawMatteText(display,&windows->popup,&reply_info);A         XDrawBeveledButton(display,&windows->popup,&action_info); A         XDrawBeveledButton(display,&windows->popup,&cancel_info);K6         XHighlightWidget(display,&windows->popup,4,4);         selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState;r$         state&=(~RedrawWidgetState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */>         if (slider_info.id >= (int) (entries-visible_entries))1           slider_info.id=entries-visible_entries; A         if ((slider_info.id < 0) || (entries <= visible_entries))F           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (entries > 0)           slider_info.y+= K             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/entries;G0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.m             */-             selection_info.id=slider_info.id;K9             selection_info.y=list_info.y+(height >> 3)+2;b/             for (i=0; i < visible_entries; i++)e
             {eG               selection_info.raised=(slider_info.id+i) != list_info.id;t0               selection_info.text=(char *) NULL;/               if ((slider_info.id+i) < entries) ;                 selection_info.text=list[slider_info.id+i];iG               XDrawWidgetText(display,&windows->popup,&selection_info);l<               selection_info.y+=(int) selection_info.height;
             }w             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-n,                   slider_info.bevel_width-1;               }n             else               {X?                 expose_info.height=expose_info.y-slider_info.y;C?                 expose_info.y=slider_info.y+slider_info.height+h,                   slider_info.bevel_width+1;               }xD             XDrawTriangleNorth(display,&windows->popup,&north_info);=             XDrawMatte(display,&windows->popup,&expose_info);=E             XDrawBeveledButton(display,&windows->popup,&slider_info);_D             XDrawTriangleSouth(display,&windows->popup,&south_info);(             expose_info.y=slider_info.y;           }*"         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)n=       XIfEvent(display,&event,XScreenEvent,(char *) windows);w     else       {h
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)s!           if (slider_info.id > 0) 
             {i               /*                 Move slider up.1               */               slider_info.id--;s%               state|=RedrawListState;i
             }x         if (!south_info.raised) '           if (slider_info.id < entries)m
             {d               /*!                 Move slider down.t               */               slider_info.id++;w%               state|=RedrawListState;d
             }((         if (event.type != ButtonRelease)           continue;        }d     switch (event.type)      {i       case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))o           {i             /*               Track slider.d             */$             slider_info.active=True;             break;           };4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)t
             {C               /*                 Move slider up.n               */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;b               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))'           if (slider_info.id < entries),
             {t               /*!                 Move slider down.t               */&               south_info.raised=False;               slider_info.id++;a%               state|=RedrawListState;n               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))d           {w             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)2               slider_info.id-=(visible_entries-1);             else2               slider_info.id+=(visible_entries-1);#             state|=RedrawListState;              break;           }w3         if (MatteIsActive(list_info,event.xbutton))            {n             unsigned int               id;h               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= entries)               break;4             (void) strcpy(reply_info.text,list[id]);'             reply_info.highlight=False;..             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+strlen(reply_info.text);@             XDrawMatteText(display,&windows->popup,&reply_info);#             selection_info.id=(~0);)#             if (id == list_info.id)                {d)                 action_info.raised=False;DI                 XDrawBeveledButton(display,&windows->popup,&action_info); !                 state|=ExitState;c               }-             list_info.id=id;#             state|=RedrawListState;              break;           }m5         if (MatteIsActive(action_info,event.xbutton))e           {y             /*)               User pressed action button.p             */%             action_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&action_info);n             break;           }o5         if (MatteIsActive(cancel_info,event.xbutton))x           {              /*)               User pressed Cancel button.n             */%             cancel_info.raised=False; E             XDrawBeveledButton(display,&windows->popup,&cancel_info);t             break;           }i5         if (!MatteIsActive(reply_info,event.xbutton));           break;,         if (event.xbutton.button != Button2)           {              static Timed               click_time;                /*;               Move text cursor to position of button press.-             */N             x=event.xbutton.x-reply_info.x-(font_info->max_bounds.width >> 2);@             for (i=1; i <= (int) strlen(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {w                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); H                 XSetSelectionOwner(display,XA_PRIMARY,windows->popup.id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==$                   windows->popup.id;               }d@             XDrawMatteText(display,&windows->popup,&reply_info);*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,o0           windows->popup.id,event.xbutton.time);         break;       }        case ButtonRelease:c       {.#         if (!windows->popup.mapped)e           break;         if (!north_info.raised)r           {a             /*&               User released up button.             */#             delay=SuspendTime << 2;t#             north_info.raised=True; D             XDrawTriangleNorth(display,&windows->popup,&north_info);           }o         if (!south_info.raised)            {n             /*(               User released down button.             */#             delay=SuspendTime << 2;n#             south_info.raised=True;fD             XDrawTriangleSouth(display,&windows->popup,&south_info);           }a         if (slider_info.active)c           {h             /*#               Stop tracking slider.a             */%             slider_info.active=False;w             break;           }           if (!action_info.raised)           {;:             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(action_info,event.xbutton))a-                 if (*reply_info.text == '\0') #                   XBell(display,0);h                 else#                   state|=ExitState;i$             action_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&action_info);            }_          if (!cancel_info.raised)           {i:             if (event.xbutton.window == windows->popup.id);               if (MatteIsActive(cancel_info,event.xbutton))n                 {](                   *reply_info.text='\0';#                   state|=ExitState;                  }($             cancel_info.raised=True;E             XDrawBeveledButton(display,&windows->popup,&cancel_info);a           }>5         if (!MatteIsActive(reply_info,event.xbutton))w           break;         break;       }        case ClientMessage:        {a
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {eG             XSetInputFocus(display,event.xclient.window,RevertToParent,d'               event.xclient.data.l[1]);a             break;           }l?         if (*event.xclient.data.l != windows->wm_delete_window)s           break;6         if (event.xclient.window == windows->popup.id)           { "             *reply_info.text='\0';             state|=ExitState;h             break;           }          break;       }=       case ConfigureNotify:o       {m
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)n           break;?         if ((event.xconfigure.width == windows->popup.width) &&i?             (event.xconfigure.height == windows->popup.height))l           break;         windows->popup.width= ?           Max(event.xconfigure.width,windows->popup.min_width);          windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height);n(         state|=UpdateConfigurationState;         break;       }o       case EnterNotify:        {.8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }o       case Expose:       {t6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }(       case KeyPress:       {.         static char !           command[MaxTextLength];)           static int           length;            static KeySym            key_symbol;e  3         if (event.xkey.window != windows->popup.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),e/           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';p2         if (MatteIsActive(scroll_info,event.xkey))           {n             /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:M               case XK_KP_Home:               {l!                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }y               case XK_Down:t               case XK_KP_Down:               { !                 slider_info.id++;                  break;               }n               case XK_Prior:               case XK_KP_Prior:n               {l0                 slider_info.id-=visible_entries;                 break;               }s               case XK_Next:                case XK_KP_Next:               {t0                 slider_info.id+=visible_entries;                 break;               }i               case XK_End:               case XK_KP_End:                {d'                 slider_info.id=entries;a                 break;               }i
             } #             state|=RedrawListState;o             break;           }*E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))l           {              /*               Read new entry..             */)             if (*reply_info.text == '\0')e               break;%             action_info.raised=False;pE             XDrawBeveledButton(display,&windows->popup,&action_info);<             state|=ExitState;              break;           } '         if (key_symbol == XK_Control_L)d           {s              state|=ControlState;             break;           }n!         if (state & ControlState)            switch (key_symbol)a           {y             case XK_u:             case XK_U:
             {p               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;W               break;
             }d             default:               break;           }n@         XEditText(display,&reply_info,key_symbol,command,state);<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case KeyRelease:       {          static char !           command[MaxTextLength];            static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;d         break;       }t       case MotionNotify:       {n
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));s         if (slider_info.active)o           {a             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;t3             if (slider_info.y != slider_info.min_y)cK               slider_info.id=(entries*(slider_info.y-slider_info.min_y+1))/(8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           }d(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.w             */3             action_info.raised=!action_info.raised;nE             XDrawBeveledButton(display,&windows->popup,&action_info);a             break;           }WK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))u           {              /*+               Cancel button status changed.i             */3             cancel_info.raised=!cancel_info.raised;xE             XDrawBeveledButton(display,&windows->popup,&cancel_info);s             break;           }          break;       }n       case SelectionClear:       {)#         reply_info.highlight=False;(<         XDrawMatteText(display,&windows->popup,&reply_info);         break;       }        case SelectionNotify:q       {s         Atom           type;f           int            format,x           status;a           unsigned char            *data;           unsigned longq           after,           length;t  
         /*1           Obtain response from primary selection.w
         */5         if (event.xselection.property == (Atom) None)i           break;E         status=XGetWindowProperty(display,event.xselection.requestor,pJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||x             (length == 0))           break;>         if ((strlen(reply_info.text)+length) >= MaxTextLength)           XBell(display,0);i         else           {o             /*5               Insert primary selection in reply text.w             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); @             XDrawMatteText(display,&windows->popup,&reply_info);%             state|=RedrawActionState;h           }d         XFree((void *) data);p         break;       }=       case SelectionRequest:       {c         XSelectionEventh           notify;p           XSelectionRequestEvent           *request;(  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));gN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));i$         notify.type=SelectionNotify;         notify.send_event=True;>(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState));oA   XDefineCursor(display,windows->image.id,windows->image.cursor);fC   XWithdrawWindow(display,windows->popup.id,windows->popup.screen);,/   XCheckRefreshWindow(display,&windows->image);e }t * /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             %BO %                                                                             %dO %   X M e n u W i d g e t                                                     % O %                                                                             %hO %                                                                             %hO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %,M %  Function XMenuWidget maps a menu and returns the command pointed to by the $ %  user when the button is released. %i, %  The format of the XMenuWidget routine is: %oH %    selection_number=XMenuWidget(display,windows,title,selections,item) %n+ %  A description of each parameter follows:i %wG %    o selection_number: Specifies the number of the selection that the  %      user choose.d %tE %    o display: Specifies a connection to an X server;  returned fromd %      XOpenDisplay. %e; %    o window: Specifies a pointer to a XWindows structure.4 % N %    o title: Specifies a character string that describes the menu selections. % K %    o selections: Specifies a pointer to one or more strings that compriset %      the choices in the menu.a %BJ %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %  %  */6 int XMenuWidget(display,windows,title,selections,item) Displaya   *display;s   XWindows   *windows;D   char	   *title,s   **selections;p   char   *item; {    Cursor     cursor;      int      id,(     x,     y;     unsigned int     height, 
     limit,	     mask,      number_selections,     title_height, 
     width;     unsigned longr
     state;     Window     root_window;     XEvent
     event;  
   XFontStruct      *font_info;      XSetWindowAttributes     window_attributes;  
   XWidgetInfo      menu_info,     selection_info;.     XWindowChanges     window_changes;c     /*&     Determine popup window attributes.   *//   XCheckRefreshWindow(display,&windows->image); %   font_info=windows->popup.font_info;.   windows->popup.width=0;    if (title != (char *) NULL) C     windows->popup.width=XTextWidth(font_info,title,strlen(title));d3   for (id=0; selections[id] != (char *) NULL; id++)(   {iF     width=XTextWidth(font_info,selections[id],strlen(selections[id]));%     if (width > windows->popup.width)I!       windows->popup.width=width;    }    number_selections=id; 6   windows->popup.width+=font_info->max_bounds.width+6;+   XGetWidgetInfo((char *) NULL,&menu_info);i*   title_height=menu_info.bevel_width << 1;
   width=0;   if (title != (char *) NULL)      { ?       title_height=(font_info->descent+font_info->ascent) << 1; 6       width=XTextWidth(font_info,title,strlen(title));     } 9   height=(5*(font_info->ascent+font_info->descent)) >> 2;_   windows->popup.height=G     title_height+number_selections*height+(menu_info.bevel_width << 1); 0   windows->popup.min_width=windows->popup.width;2   windows->popup.min_height=windows->popup.height;   /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);   if (title == (char *) NULL)t     {i5       x=windows->command.x+windows->command.x_origin;a5       y=windows->command.y+windows->command.y_origin;      }*8   windows->popup.x=x-(font_info->max_bounds.width >> 1);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)i     windows->popup.x=0;t   else!     if (windows->popup.x > limit)t       windows->popup.x=limit; -   windows->popup.y=y-((3*title_height) >> 2); L   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;h   else!     if (windows->popup.y > limit)t       windows->popup.y=limit;    /*     Map popup window.    */+   window_attributes.override_redirect=True;oG   XChangeWindowAttributes(display,windows->popup.id,CWOverrideRedirect,a     &window_attributes);,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */   selection_info.height=height; 1   cursor=XCreateFontCursor(display,XC_right_ptr);u2   XDefineCursor(display,windows->image.id,cursor);!   state=UpdateConfigurationState;a   do   {o)     if (state & UpdateConfigurationState)a       {L
         /*+           Initialize selection information.l
         */1         XGetWidgetInfo((char *) NULL,&menu_info);d          menu_info.bevel_width--;L         menu_info.width=windows->popup.width-((menu_info.bevel_width) << 1);N         menu_info.height=windows->popup.height-((menu_info.bevel_width) << 1);*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=menu_info.width; %         selection_info.height=height; %         selection_info.x=menu_info.x; +         state&=(~UpdateConfigurationState);o       }e"     if (state & RedrawWidgetState)       {t
         /*           Redraw Menu widget.f
         */7         XDrawBevel(display,&windows->popup,&menu_info); #         if (title != (char *) NULL)o           {g             y=title_height-1; :             XSetBevelColor(display,&windows->popup,False);N             XDrawLine(display,windows->popup.id,windows->popup.widget_context,C               selection_info.x,y-1,(int) selection_info.width,y-1);.9             XSetBevelColor(display,&windows->popup,True); N             XDrawLine(display,windows->popup.id,windows->popup.widget_context,?               selection_info.x,y,(int) selection_info.width,y);eK             XSetFillStyle(display,windows->popup.widget_context,FillSolid);e           } 
         /*           Draw menu selections.a
         */#         selection_info.raised=True;,+         selection_info.y=title_height >> 2;i"         selection_info.text=title;#         if (title != (char *) NULL)iC           XDrawWidgetText(display,&windows->popup,&selection_info);%&         selection_info.y=title_height;0         for (id=0; id < number_selections; id++)	         { :           selection_info.raised=(id != selection_info.id);-           selection_info.text=selections[id]; C           XDrawWidgetText(display,&windows->popup,&selection_info); 8           selection_info.y+=(int) selection_info.height;	         } $         state&=(~RedrawWidgetState);       } <     if ((title != (char *) NULL) && (number_selections > 3))       { 
         /*           Redraw Menu line. 
         */C         y=title_height+selection_info.height*(number_selections-1); 6         XSetBevelColor(display,&windows->popup,False);J         XDrawLine(display,windows->popup.id,windows->popup.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1);y5         XSetBevelColor(display,&windows->popup,True);eJ         XDrawLine(display,windows->popup.id,windows->popup.widget_context,;           selection_info.x,y,(int) selection_info.width,y);uG         XSetFillStyle(display,windows->popup.widget_context,FillSolid);        }r     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);f     switch (event.type).     {        case ButtonPress:p         break;       case ButtonRelease:o       {S#         if (!windows->popup.mapped)h           break;
         /*           Exit menu.
         */         *item='\0';.         state|=ExitState;p#         if (title == (char *) NULL)s(           XPutBackEvent(display,&event);         break;       },       case ConfigureNotify:s       { 
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)r           break;?         if ((event.xconfigure.width == windows->popup.width) &&;?             (event.xconfigure.height == windows->popup.height))t           break;         windows->popup.width= ?           Max(event.xconfigure.width,windows->popup.min_width);n         windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height);,(         state|=UpdateConfigurationState;         break;       }c       case EnterNotify:e       {u /*:         if (event.xcrossing.window == windows->command.id)           { #             selection_info.id=(-1);              state|=ExitState;a*             XPutBackEvent(display,&event);             break;           }n */8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);J         id=((event.xcrossing.y-title_height)/(int) selection_info.height);2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.i
         */         selection_info.id=id;xN         selection_info.y=title_height+selection_info.id*selection_info.height;$         selection_info.raised=False;:         selection_info.text=selections[selection_info.id];A         XDrawWidgetText(display,&windows->popup,&selection_info);W         break;       }p       case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)i           break;!         state|=RedrawWidgetState;t         break;       }w       case LeaveNotify:;       {=8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;p         id=selection_info.id;w2         if ((id < 0) || (id >= number_selections))           break;
         /*%           Unhighlight last selection.w
         */?         selection_info.y=title_height+id*selection_info.height;u         selection_info.id=(~0);y#         selection_info.raised=True;-+         selection_info.text=selections[id];yA         XDrawWidgetText(display,&windows->popup,&selection_info);>         break;       }p       case MotionNotify:       { 
         /*/           Discard pending button motion events.)
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); 8         if (event.xmotion.window == windows->command.id)           {wG             y=AbsoluteValue(windows->command.y_origin-event.xmotion.y);;1             if (y > (selection_info.height >> 1))a               state|=ExitState;n             break;           }o6         if (event.xmotion.window != windows->popup.id)           break;(         if (state & InactiveWidgetState)           break;F         id=(event.xmotion.y-title_height)/(int) selection_info.height;P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {;             /*)               Unhighlight last selection.              */(             if (id == selection_info.id)               break;             selection_info.y=xC               title_height+selection_info.id*selection_info.height;f'             selection_info.raised=True;l>             selection_info.text=selections[selection_info.id];E             XDrawWidgetText(display,&windows->popup,&selection_info);p           }c         selection_info.id=id;*2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection. 
         */?         selection_info.y=title_height+id*selection_info.height;.$         selection_info.raised=False;+         selection_info.text=selections[id];dA         XDrawWidgetText(display,&windows->popup,&selection_info);          break;       }r       default:         break;     }t!   } while (!(state & ExitState));eA   XDefineCursor(display,windows->image.id,windows->image.cursor); ,   window_attributes.override_redirect=False;G   XChangeWindowAttributes(display,windows->popup.id,CWOverrideRedirect,      &window_attributes);C   XWithdrawWindow(display,windows->popup.id,windows->popup.screen);f/   XCheckRefreshWindow(display,&windows->image);;J   if ((selection_info.id < 0) || (selection_info.id >= number_selections))     return(~0);y4   (void) strcpy(item,selections[selection_info.id]);   return(selection_info.id); }i ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %rO %                                                                             %tO %   X N o t i c e W i d g e t                                                 % O %                                                                             %tO %                                                                             %iO %                                                                             %4O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%v %.L %  Function XNoticeWidget displays a popup window with a notice to the user.C %  The function returns when the user presses the "Dismiss" button.  %f. %  The format of the XNoticeWidget routine is: % 5 %    XNoticeWidget(display,windows,message,qualifier)o %u+ %  A description of each parameter follows:f %aE %    o display: Specifies a connection to an X server;  returned fromc %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.v %.G %    o message: Specifies the message to display before terminating thee %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.D %B %l */5 void XNoticeWidget(display,windows,message,qualifier)  Display    *display;    XWindows   *windows;e   char   *message,t
   *qualifier;  {r$ #define DismissButtonText  "Dismiss" #define Timeout  8     int 
     limit,     x,     y;     time_t
     timer;     unsigned int     height, 	     mask,u
     width;     unsigned longs
     state;     Window     root_window;     XEvent
     event;  
   XFontStructd     *font_info;      XTextProperty      window_name;  
   XWidgetInfo)     dismiss_info;      XWindowChanges     window_changes;k     /*&     Determine popup window attributes.   *//   XCheckRefreshWindow(display,&windows->image);f%   font_info=windows->popup.font_info;lJ   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));   if (message != (char *) NULL) >     if (XTextWidth(font_info,message,strlen(message)) > width):       width=XTextWidth(font_info,message,strlen(message));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,strlen(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,strlen(qualifier));0   height=(font_info->ascent+font_info->descent);;   windows->popup.width=width+4*font_info->max_bounds.width; "   windows->popup.height=12*height;=   windows->popup.min_width=width+font_info->max_bounds.width;;%   windows->popup.min_height=7*height;    /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;0   windows->popup.x-=(windows->popup.width >> 1);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0).     windows->popup.x=0;    else!     if (windows->popup.x > limit)f       windows->popup.x=limit;a8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;5   windows->popup.y-=((5*windows->popup.height) >> 3);pL   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)      windows->popup.y=0;    else!     if (windows->popup.y > limit)        windows->popup.y=limit;l   /*     Map popup window.    *//   (void) sprintf(windows->popup.name,"Notice");fH   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name); ,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   XBell(display,0);t   /*     Respond to X events.   */&   timer=time((time_t *) NULL)+Timeout;!   state=UpdateConfigurationState;rF   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);   do   { &     if (time((time_t *) NULL) > timer)       break;)     if (state & UpdateConfigurationState)e       {o
         /*0           Initialize Dismiss button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);7         dismiss_info.width=font_info->max_bounds.width+xL           XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));,         dismiss_info.height=(3*height) >> 1;M         dismiss_info.x=(windows->popup.width >> 1)-(dismiss_info.width >> 1); H         dismiss_info.y=windows->popup.height-(dismiss_info.height << 1);+         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       {v
         /*           Redraw Notice widget. 
         */<         width=XTextWidth(font_info,message,strlen(message));3         x=(windows->popup.width >> 1)-(width >> 1);n5         y=(windows->popup.height >> 1)-(height << 1);;N         XDrawString(display,windows->popup.id,windows->popup.annotate_context,'           x,y,message,strlen(message)); '         if (qualifier != (char *) NULL)t           { D             width=XTextWidth(font_info,qualifier,strlen(qualifier));7             x=(windows->popup.width >> 1)-(width >> 1);              y+=height;2             XDrawString(display,windows->popup.id,O               windows->popup.annotate_context,x,y,qualifier,strlen(qualifier));p           }vB         XDrawBeveledButton(display,&windows->popup,&dismiss_info);6         XHighlightWidget(display,&windows->popup,4,4);$         state&=(~RedrawWidgetState);       }(     /*       Wait for next event.     */E     if (!XCheckIfEvent(display,&event,XScreenEvent,(char *) windows))d       {i
         /*$           Do not block if delay > 0.
         */)         XDelay(display,SuspendTime << 2);f         continue;C       }      switch (event.type)      {|       case ButtonPress:        { 6         if (MatteIsActive(dismiss_info,event.xbutton))           {e             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;F             XDrawBeveledButton(display,&windows->popup,&dismiss_info);             break;           }          break;       }l       case ButtonRelease:        {o#         if (!windows->popup.mapped)            break;!         if (!dismiss_info.raised)            { :             if (event.xbutton.window == windows->popup.id)<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;&%             dismiss_info.raised=True;rF             XDrawBeveledButton(display,&windows->popup,&dismiss_info);           }m         break;       }        case ClientMessage:        {y
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent,K'               event.xclient.data.l[1]);t             break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)i           break;6         if (event.xclient.window == windows->popup.id)           {              state|=ExitState;e             break;           }          break;       }d       case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)a           break;?         if ((event.xconfigure.width == windows->popup.width) && ?             (event.xconfigure.height == windows->popup.height))a           break;         windows->popup.width=a?           Max(event.xconfigure.width,windows->popup.min_width);y         windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height);=(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:c       { 8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }p       case Expose:       { 6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)t           break;!         state|=RedrawWidgetState;p         break;       }        case KeyPress:       {l         static char !           command[MaxTextLength];            static KeySym            key_symbol;t  3         if (event.xkey.window != windows->popup.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),n/           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {s&             dismiss_info.raised=False;F             XDrawBeveledButton(display,&windows->popup,&dismiss_info);             state|=ExitState;N             break;           }          break;       }        case LeaveNotify:s       {l8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;          break;       }a       case MotionNotify:       { 
         /*/           Discard pending button motion events.T
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));)(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))a           {S             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised; F             XDrawBeveledButton(display,&windows->popup,&dismiss_info);             break;           }          break;       }e       default:         break;     }g!   } while (!(state & ExitState));>A   XDefineCursor(display,windows->image.id,windows->image.cursor);eC   XWithdrawWindow(display,windows->popup.id,windows->popup.screen);s/   XCheckRefreshWindow(display,&windows->image);; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %uO %   X T e x t V i e w W i d g e t                                             %sO %                                                                             % O %                                                                             %iO %                                                                             %pO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%< %  Function XTextViewWidget displays text in a popup window. %%0 %  The format of the XTextViewWidget routine is: % G %    XTextViewWidget(display,resource_info,windows,mono,title,textlist)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % 8 %    o mono:  Use mono-spaced font when displaying text. % H %    o title: This character string is displayed at the top of the popup %      window. % G %    o textlist: This string list is displayed within the popup window.  %  %% */G void XTextViewWidget(display,resource_info,windows,mono,title,textlist); DisplayF   *display;B  
 XResourceInfol   *resource_info;w   XWindows   *windows;t   unsigned int   mono;    char	   *title,h
   **textlist;c {b$ #define DismissButtonText  "Dismiss"     char%     primary_selection[MaxTextLength];      inta     x,     y;     register int     i;     unsigned int     height,p
     limit,
     lines,	     mask,A     text_width,a     visible_lines,
     width;     unsigned longe
     delay,
     state;     Window     root_window;     XEvent
     event;  
   XFontStructi     *font_info,      *text_info;e     XTextPropertyo     window_name;  
   XWidgetInfon     dismiss_info,s     expose_info,     list_info,     north_info,n     scroll_info,     selection_info,d     slider_info,     south_info;,     XWindowChanges     window_changes;      /*'     Convert text string to a text list.p   */F   XDefineCursor(display,windows->image.id,windows->image.busy_cursor);/   XCheckRefreshWindow(display,&windows->image); !   if (textlist == (char **) NULL)u     {tF       XNoticeWidget(display,windows,"No text to view:",(char *) NULL);
       return;e     }a   /*&     Determine popup window attributes.   */%   font_info=windows->popup.font_info; !   text_info=(XFontStruct *) NULL;i   if (mono) 4     text_info=XBestFont(display,resource_info,True);(   if (text_info == (XFontStruct *) NULL)'     text_info=windows->popup.font_info;    text_width=0; .   for (i=0; textlist[i] != (char *) NULL; i++)K     if (XTextWidth(text_info,textlist[i],strlen(textlist[i])) > text_width) G       text_width=XTextWidth(text_info,textlist[i],strlen(textlist[i])); 
   lines=i;J   width=XTextWidth(font_info,DismissButtonText,strlen(DismissButtonText));%   width+=font_info->max_bounds.width; .   height=text_info->ascent+text_info->descent;   windows->popup.width= ?     Min(text_width,MaxTextWidth)+5*font_info->max_bounds.width;sG   windows->popup.height=Min(Max(lines,3),24)*height+((13*height) >> 1)+r+     ((9*font_info->max_bounds.width) >> 1);bF   windows->popup.min_width=MinTextWidth+4*font_info->max_bounds.width;8   windows->popup.min_height=3*height+((13*height) >> 1)++     ((9*font_info->max_bounds.width) >> 1);t.   height=font_info->ascent+font_info->descent;   /*     Position popup window.   */P   XQueryPointer(display,XRootWindow(display,windows->popup.screen),&root_window,B     &root_window,&x,&y,&windows->popup.x,&windows->popup.y,&mask);6   if (windows->popup.width < windows->popup.min_width)2     windows->popup.width=windows->popup.min_width;4   windows->popup.x-=((3*windows->popup.width) >> 2);J   limit=XDisplayWidth(display,windows->popup.screen)-windows->popup.width;   if (windows->popup.x < 0)o     windows->popup.x=0;i   else!     if (windows->popup.x > limit)e       windows->popup.x=limit;t8   if (windows->popup.height < windows->popup.min_height)4     windows->popup.height=windows->popup.min_height;1   windows->popup.y-=(windows->popup.height >> 1);tL   limit=XDisplayHeight(display,windows->popup.screen)-windows->popup.height;   if (windows->popup.y < 0)x     windows->popup.y=0;    else!     if (windows->popup.y > limit)m       windows->popup.y=limit;x   /*     Map popup window.n   */,   (void) sprintf(windows->popup.name,title);H   (void) XStringListToTextProperty(&windows->popup.name,1,&window_name);5   XSetWMName(display,windows->popup.id,&window_name);o,   window_changes.width=windows->popup.width;.   window_changes.height=windows->popup.height;$   window_changes.x=windows->popup.x;$   window_changes.y=windows->popup.y;P   XReconfigureWMWindow(display,windows->popup.id,windows->popup.screen,CWWidth |*     CWHeight | CWX | CWY,&window_changes);(   XMapRaised(display,windows->popup.id);   windows->popup.mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);1,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_lines=0;   delay=SuspendTime << 2;n!   state=UpdateConfigurationState;1   do   {-)     if (state & UpdateConfigurationState)i       {p         int/
           id;e  
         /*(           Initialize button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);!         dismiss_info.width=width;h,         dismiss_info.height=(3*height) >> 1;?         dismiss_info.x=windows->popup.width-dismiss_info.width-w(           font_info->max_bounds.width-2;A         dismiss_info.y=windows->popup.height-dismiss_info.height-d&           font_info->max_bounds.width;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);-"         scroll_info.bevel_width--;!         scroll_info.width=height;;*         scroll_info.height=dismiss_info.y-1           ((5*font_info->max_bounds.width) >> 1);oG         scroll_info.x=windows->popup.width-font_info->max_bounds.width-d           scroll_info.width;;         scroll_info.y=(3*font_info->max_bounds.width) >> 1;%!         scroll_info.raised=False;/          scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;r8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;w-         north_info.x+=north_info.bevel_width;c-         north_info.y+=north_info.bevel_width;c         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;d         slider_info.id=id;         slider_info.width-=2;;P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=oJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;;         visible_lines=(scroll_info.height-(height >> 3)-4)/t<           ((9*(text_info->ascent+text_info->descent)) >> 3);"         if (lines > visible_lines)F           slider_info.height=(visible_lines*slider_info.height)/lines;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);;         list_info.raised=False;e          list_info.bevel_width--;M         list_info.width=scroll_info.x-((3*font_info->max_bounds.width) >> 1); ,         list_info.height=scroll_info.height;0         list_info.x=font_info->max_bounds.width;"         list_info.y=scroll_info.y;
         /*+           Initialize selection information.>
         */6         XGetWidgetInfo((char *) NULL,&selection_info);-         selection_info.width=list_info.width;hN         selection_info.height=(9*(text_info->ascent+text_info->descent)) >> 3;%         selection_info.x=list_info.x;g+         state&=(~UpdateConfigurationState);x       }i"     if (state & RedrawWidgetState)       {e
         /*"           Redraw Text View window.
         */>         XDrawBeveledMatte(display,&windows->popup,&list_info);@         XDrawBeveledMatte(display,&windows->popup,&scroll_info);@         XDrawTriangleNorth(display,&windows->popup,&north_info);A         XDrawBeveledButton(display,&windows->popup,&slider_info); @         XDrawTriangleSouth(display,&windows->popup,&south_info);B         XDrawBeveledButton(display,&windows->popup,&dismiss_info);6         XHighlightWidget(display,&windows->popup,4,4);         selection_info.id=(~0);t         state|=RedrawListState; $         state&=(~RedrawWidgetState);       }o      if (state & RedrawListState)       {-
         /*+           Determine slider id and position.f
         */:         if (slider_info.id >= (int) (lines-visible_lines))-           slider_info.id=lines-visible_lines;e=         if ((slider_info.id < 0) || (lines <= visible_lines))f           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (lines != 0);           slider_info.y+=_I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/lines;i0         if (slider_info.id != selection_info.id)           {d             /*/               Redraw scroll bar and file names.o             *//             windows->popup.font_info=text_info;fM             XSetFont(display,windows->popup.annotate_context,text_info->fid);tN             XSetFont(display,windows->popup.highlight_context,text_info->fid);-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2;_-             for (i=0; i < visible_lines; i++)+
             {dG               selection_info.raised=(slider_info.id+i) != list_info.id;f0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < lines)-?                 selection_info.text=textlist[slider_info.id+i];_G               XDrawWidgetText(display,&windows->popup,&selection_info);i<               selection_info.y+=(int) selection_info.height;
             } /             windows->popup.font_info=font_info;.M             XSetFont(display,windows->popup.annotate_context,font_info->fid);iN             XSetFont(display,windows->popup.highlight_context,font_info->fid);             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {i?                 expose_info.height=slider_info.y-expose_info.y;t?                 expose_info.y=slider_info.y-expose_info.height-x,                   slider_info.bevel_width-1;               }h             else               {x?                 expose_info.height=expose_info.y-slider_info.y;u?                 expose_info.y=slider_info.y+slider_info.height+(,                   slider_info.bevel_width+1;               }sD             XDrawTriangleNorth(display,&windows->popup,&north_info);=             XDrawMatte(display,&windows->popup,&expose_info);eE             XDrawBeveledButton(display,&windows->popup,&slider_info);=D             XDrawTriangleSouth(display,&windows->popup,&south_info);(             expose_info.y=slider_info.y;           }t"         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)w=       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       {s
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)+!           if (slider_info.id > 0)n
             {e               /*                 Move slider up.d               */               slider_info.id--;r%               state|=RedrawListState; 
             }t         if (!south_info.raised)r%           if (slider_info.id < lines)g
             {                /*!                 Move slider down._               */               slider_info.id++;-%               state|=RedrawListState;d
             }&(         if (event.type != ButtonRelease)           continue;,       }>     switch (event.type)      {B       case ButtonPress:o       {,5         if (MatteIsActive(slider_info,event.xbutton))d           {o             /*               Track slider.y             */$             slider_info.active=True;             break;           }o4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0)e
             {                /*                 Move slider up.,               */&               north_info.raised=False;               slider_info.id--;a%               state|=RedrawListState;i               break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < lines)l
             {p               /*!                 Move slider down.y               */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             }t5         if (MatteIsActive(scroll_info,event.xbutton))a           {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_lines-1);             else0               slider_info.id+=(visible_lines-1);#             state|=RedrawListState;              break;           } 6         if (MatteIsActive(dismiss_info,event.xbutton))           {n             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;F             XDrawBeveledButton(display,&windows->popup,&dismiss_info);             break;           }(3         if (MatteIsActive(list_info,event.xbutton))c           {s             unsigned int               id;i               static Time                click_time;i               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= lines)               break;#             if (id != list_info.id)                {                   list_info.id=id;.                 click_time=event.xbutton.time;                 break;               }i             list_info.id=id;?             if (event.xbutton.time >= (click_time+DoubleClick))d               {t.                 click_time=event.xbutton.time;                 break;               }f*             click_time=event.xbutton.time;             /*4               Become the XA_PRIMARY selection owner.             */D             (void) strcpy(primary_selection,textlist[list_info.id]);D             XSetSelectionOwner(display,XA_PRIMARY,windows->popup.id,"               event.xbutton.time);L             if (XGetSelectionOwner(display,XA_PRIMARY) != windows->popup.id)               break;#             selection_info.id=(~0);%             list_info.id=id;#             state|=RedrawListState;r             break;           }p         break;       }_       case ButtonRelease:e       {y#         if (!windows->popup.mapped)            break;         if (!north_info.raised)_           {              /*&               User released up button.             */#             delay=SuspendTime << 2;p#             north_info.raised=True;lD             XDrawTriangleNorth(display,&windows->popup,&north_info);           }d         if (!south_info.raised)(           {a             /*(               User released down button.             */#             delay=SuspendTime << 2;i#             south_info.raised=True;iD             XDrawTriangleSouth(display,&windows->popup,&south_info);           }s         if (slider_info.active)            {<             /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           } !         if (!dismiss_info.raised)i           {d:             if (event.xbutton.window == windows->popup.id)<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState; %             dismiss_info.raised=True;oF             XDrawBeveledButton(display,&windows->popup,&dismiss_info);           }          break;       }i       case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);e             break;           }r?         if (*event.xclient.data.l != windows->wm_delete_window)            break;6         if (event.xclient.window == windows->popup.id)           {i             state|=ExitState;_             break;           }i         break;       }e       case ConfigureNotify:        {r
         /*&           Update widget configuration.
         */9         if (event.xconfigure.window != windows->popup.id)y           break;?         if ((event.xconfigure.width == windows->popup.width) && ?             (event.xconfigure.height == windows->popup.height))            break;         windows->popup.width=p?           Max(event.xconfigure.width,windows->popup.min_width);&         windows->popup.height=A           Max(event.xconfigure.height,windows->popup.min_height); (         state|=UpdateConfigurationState;         break;       }        case EnterNotify:f       { 8         if (event.xcrossing.window != windows->popup.id)           break;&         state&=(~InactiveWidgetState);         break;       }a       case Expose:       {y6         if (event.xexpose.window != windows->popup.id)           break;%         if (event.xexpose.count != 0)s           break;!         state|=RedrawWidgetState;;         break;       }m       case KeyPress:       {a         static char,!           command[MaxTextLength];r           static int           length;f           static KeySym            key_symbol;   3         if (event.xkey.window != windows->popup.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);i         *(command+length)='\0'; 2         if (MatteIsActive(scroll_info,event.xkey))           {e             /*               Move slider.             */             switch (key_symbol) 
             {n               case XK_Home:B               case XK_KP_Home:               {(!                 slider_info.id=0;                  break;               }c               case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;(                 break;               }                case XK_Down:>               case XK_KP_Down:               { !                 slider_info.id++;                  break;               }s               case XK_Prior:               case XK_KP_Prior:a               { .                 slider_info.id-=visible_lines;                 break;               }                case XK_Next:f               case XK_KP_Next:               { .                 slider_info.id+=visible_lines;                 break;               }                case XK_End:               case XK_KP_End:s               { %                 slider_info.id=lines;f                 break;               })
             } #             state|=RedrawListState;s             break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))v           {1&             dismiss_info.raised=False;F             XDrawBeveledButton(display,&windows->popup,&dismiss_info);             state|=ExitState;              break;           }f         break;       }        case KeyRelease:         break;       case LeaveNotify:        { 8         if (event.xcrossing.window != windows->popup.id)           break;#         state|=InactiveWidgetState;h         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events.i
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));e         if (slider_info.active)=           {x             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;|3             if (slider_info.y != slider_info.min_y) I               slider_info.id=(lines*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           }d(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {              /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;yF             XDrawBeveledButton(display,&windows->popup,&dismiss_info);             break;           }v         break;       }        case SelectionClear:       {r         list_info.id=(~0);         selection_info.id=(~0);i         state|=RedrawListState;D         break;       }&       case SelectionRequest:       {          XSelectionEvent            notify;A           XSelectionRequestEvent           *request;   !         if (list_info.id == (~0))C           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));pN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           strlen(primary_selection));t$         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }e       default:         break;     } !   } while (!(state & ExitState));M,   if (text_info != windows->popup.font_info)!     XFreeFont(display,text_info);eA   XDefineCursor(display,windows->image.id,windows->image.cursor);lC   XWithdrawWindow(display,windows->popup.id,windows->popup.screen);e/   XCheckRefreshWindow(display,&windows->image);c }n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                