 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                                   X   X                                     % O %                                    X X                                      % O %                                     X                                       % O %                                    X X                                      % O %                                   X   X                                     % O %                                                                             % O %                    X11 Utility Routines for ImageMagick.                    % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                  July 1992                                  % O %                                                                             % O %                                                                             % O %  Copyright 1994 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortuous action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "image.h" #include "utility.h" #include "compress.h"  #include "X.h" #include "widget.h"    /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002    /*   Forward declarations.  */ int *   Latin1Compare _Declare((char *,char *));   static void O   XMakeImageLSBFirst _Declare((XResourceInfo *,XWindowInfo *,Image *, XImage *,      XImage *)), O   XMakeImageMSBFirst _Declare((XResourceInfo *,XWindowInfo *,Image *, XImage *,      XImage *));   
 static Window 6   XWindowByProperty _Declare((Display *,Window,Atom));   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s T r u e                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function IsTrue returns True if the boolean is "true", "on", "yes" or "1".  % ' %  The format of the IsTrue routine is:  %  %      option=IsTrue(boolean)  % + %  A description of each parameter follows:  % G %    o option: either True or False depending on the boolean parameter.  % 9 %    o boolean: Specifies a pointer to a character array.  %  %  */ unsigned int IsTrue(boolean) char   *boolean;  {    if (boolean == (char *) NULL)      return(False);)   if (Latin1Compare(boolean,"true") == 0)      return(True); '   if (Latin1Compare(boolean,"on") == 0)      return(True); (   if (Latin1Compare(boolean,"yes") == 0)     return(True); &   if (Latin1Compare(boolean,"1") == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 C o m p a r e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function Latin1Compare compares two null terminated Latin-1 strings, H %  ignoring case differences, and returns an integer greater than, equalF %  to, or less than 0, according to whether first is lexicographicallyD %  greater than, equal to, or less than second.  The two strings are* %  assumed to be encoded using ISO 8859-1. % . %  The format of the Latin1Compare routine is: % " %      Latin1Compare(first,second) % + %  A description of each parameter follows:  % B %    o first: A pointer to the string to convert to Latin1 string. % C %    o second: A pointer to the string to convert to Latin1 string.  %  %  */ int Latin1Compare(first,second)  char	   *first, 
   *second; {    register unsigned char    *p,    *q;     p=(unsigned char *) first;   q=(unsigned char *) second; &   while ((*p != '\0') && (*q != '\0'))   {      register unsigned char       c,       d;       c=(*p);      d=(*q);      if (c != d)        { 
         /*(           Try lowercasing and try again.
         */'         if ((c >= XK_A) && (c <= XK_Z))            c+=(XK_a-XK_A);          else7           if ((c >= XK_Agrave) && (c <= XK_Odiaeresis)) %             c+=(XK_agrave-XK_Agrave);            else6             if ((c >= XK_Ooblique) && (c <= XK_Thorn)))               c+=(XK_oslash-XK_Ooblique); '         if ((d >= XK_A) && (d <= XK_Z))            d+=(XK_a-XK_A);          else7           if ((d >= XK_Agrave) && (d <= XK_Odiaeresis)) %             d+=(XK_agrave-XK_Agrave); 9           else if ((d >= XK_Ooblique) && (d <= XK_Thorn)) '             d+=(XK_oslash-XK_Ooblique);          if (c != d) &           return(((int) c)-((int) d));       }      p++;     q++;   }     return(((int) *p)-((int) *q)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a t i n 1 U p p e r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function Latin1Upper copies a null terminated string from source toK %  destination (including the null), changing all Latin-1 lowercase letters G %  to uppercase.  The string is assumed to be encoded using ISO 8859-1.  % , %  The format of the Latin1Upper routine is: %  %      Latin1Upper(string) % + %  A description of each parameter follows:  % G %    o string: A pointer to the string to convert to upper-case Latin1.  %  %  */ static void Latin1Upper(string)  char
   *string; {    unsigned char      c;     c=(*string);   while (c != '\0')    { #     if ((c >= XK_a) && (c <= XK_z))        *string=c-(XK_a-XK_A);     else3       if ((c >= XK_agrave) && (c <= XK_odiaeresis)) (         *string=c-(XK_agrave-XK_Agrave);
       else0         if ((c >= XK_oslash) && (c <= XK_thorn)),           *string=c-(XK_oslash-XK_Ooblique);
     string++;      c=(*string);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Function XAnnotateImage annotates the image with text.  % / %  The format of the XAnnotateImage routine is:  % M %    status=XAnnotateImage(display,pixel_info,annotate_info,background,image)  % + %  A description of each parameter follows:  % C %    o status: Function XAnnotateImage returns True if the image is I %      successfully annotated with text.  False is returned is there is a  %      memory shortage.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  % H %    o background: Specifies whether the background color is included in5 %      the annotation.  Must be either True or False;  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */N unsigned int XAnnotateImage(display,pixel_info,annotate_info,background,image) Display    *display;   
 XPixelInfo   *pixel_info;  
 XAnnotateInfo    *annotate_info;    unsigned int
   background;    Image 	   *image;  {    GC     annotate_context;      Image      *annotate_image;     int      x,     y;     Pixmap     annotate_pixmap;     register RunlengthPacket     *p,      *q;      unsigned int
     depth,     height, 
     width;     Window     root_window;     XGCValues      context_values;      XImage     *annotate_ximage;      /*     Initialize annotated image.    */   if (!UncompressImage(image))     return(False);   /*      Initialize annotated pixmap.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); 7   depth=XDefaultDepth(display,XDefaultScreen(display)); I   annotate_pixmap=XCreatePixmap(display,root_window,annotate_info->width, '     annotate_info->height,(int) depth); '   if (annotate_pixmap == (Pixmap) NULL)      return(False);   /*     Initialize graphics info.    */   context_values.background=0;1   context_values.foreground=(unsigned long) (~0); 4   context_values.font=annotate_info->font_info->fid;H   annotate_context=XCreateGC(display,root_window,GCBackground | GCFont |"     GCForeground,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*     Draw text to pixmap.   */>   XDrawImageString(display,annotate_pixmap,annotate_context,0,?     (int) annotate_info->font_info->ascent,annotate_info->text, !     strlen(annotate_info->text)); $   XFreeGC(display,annotate_context);   /*!     Initialize annotated X image.    */M   annotate_ximage=XGetImage(display,annotate_pixmap,0,0,annotate_info->width, -     annotate_info->height,AllPlanes,ZPixmap); )   if (annotate_ximage == (XImage *) NULL)      return(False);'   XFreePixmap(display,annotate_pixmap);    /*     Initialize annotated image.    */3   annotate_image=AllocateImage((ImageInfo *) NULL); '   if (annotate_image == (Image *) NULL)      return(False);/   annotate_image->columns=annotate_info->width; -   annotate_image->rows=annotate_info->height; G   annotate_image->packets=annotate_image->columns*annotate_image->rows; ,   annotate_image->pixels=(RunlengthPacket *)B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));9   if (annotate_image->pixels == (RunlengthPacket *) NULL)      { #       DestroyImage(annotate_image);        return(False);     }    /*(     Transfer annotated X image to image.   */   q=annotate_image->pixels; *   for (y=0; y < annotate_image->rows; y++)/     for (x=0; x < annotate_image->columns; x++)      { ?       q->index=(unsigned short) XGetPixel(annotate_ximage,x,y);        if (q->index == 0)	         {            /*3             Set this pixel to the background color.            */>           q->red=ColorShift(pixel_info->background_color.red);B           q->green=ColorShift(pixel_info->background_color.green);@           q->blue=ColorShift(pixel_info->background_color.blue);	         } 
       else	         {            /*,             Set this pixel to the pen color.           */<           q->red=ColorShift(pixel_info->annotate_color.red);@           q->green=ColorShift(pixel_info->annotate_color.green);>           q->blue=ColorShift(pixel_info->annotate_color.blue);	         }        q->length=0;
       q++;     } !   XDestroyImage(annotate_ximage);    /*      Determine annotate geometry.   */F   (void) XParseGeometry(annotate_info->geometry,&x,&y,&width,&height);M   if ((width != annotate_image->columns) || (height != annotate_image->rows))      {        Image          *sampled_image;          /*         Sample image.        */=       sampled_image=SampleImage(annotate_image,width,height); *       if (sampled_image == (Image *) NULL)         return(False);#       DestroyImage(annotate_image); #       annotate_image=sampled_image;      } $   if (annotate_info->degrees != 0.0)     {        ColorPacket          border_color;          Image          *rotated_image;          /*         Rotate image.        */@       border_color.red=ColorShift(pixel_info->border_color.red);D       border_color.green=ColorShift(pixel_info->border_color.green);B       border_color.blue=ColorShift(pixel_info->border_color.blue);       border_color.index=0;        rotated_image=O         RotateImage(annotate_image,annotate_info->degrees,&border_color,False); *       if (rotated_image == (Image *) NULL)         return(False);#       DestroyImage(annotate_image); #       annotate_image=rotated_image;      }    /*#     Paste annotated image to image.    */   image->class=DirectClass;    p=annotate_image->pixels; %   q=image->pixels+y*image->columns+x; *   for (y=0; y < annotate_image->rows; y++)   { /     for (x=0; x < annotate_image->columns; x++)      {        if (p->index != 0)	         {            /*,             Set this pixel to the pen color.           */           *q=(*p);.           q->index=pixel_info->annotate_index;	         } 
       else         if (background)            {              /*5               Set this pixel to the background color.              */             *q=(*p);2             q->index=pixel_info->background_index;           } 
       p++;
       q++;     } .     q+=image->columns-annotate_image->columns;   }    DestroyImage(annotate_image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t F o n t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestFont returns the "best" font.  "Best" is defined as a font J %  specified in the X resource database or a font such that the text widthG %  displayed with the font does not exceed the specified maximum width.  % * %  The format of the XBestFont routine is: % 6 %      font=XBestFont(display,resource_info,text_font) % + %  A description of each parameter follows:  % D %    o font: XBestFont returns a pointer to a XFontStruct structure. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % I %    o text_font:  True is font should be mono-spaced (typewriter style).  %  %  */7 XFontStruct *XBestFont(display,resource_info,text_font)  Display    *display;   
 XResourceInfo    *resource_info;    unsigned int   text_font; { 
   static char 
     *Fonts[]=      { 0       "-adobe-helvetica-medium-r-normal-*-14-*",'       "-*-helvetica-medium-r-*-*-14-*", $       "-*-lucida-medium-r-*-*-14-*",
       "8x13", 
       "6x13",        "fixed",       "variable",        (char *) NULL      },     *TextFonts[]=      { )       "-adobe-courier-medium-r-*-*-14-*", (       "-*-fixed-medium-r-normal-*-14-*",#       "-*-fixed-medium-r-*-*-14-*", 
       "8x13", 
       "6x13",        "fixed",       (char *) NULL      };     char     *font_name,      **p;  
   XFontStruct      *font_info;   !   font_info=(XFontStruct *) NULL;     font_name=resource_info->font;   if (text_font)'     font_name=resource_info->text_font; !   if (font_name != (char *) NULL)      {        /*A         Load preferred font specified in the X resource database.        */2       font_info=XLoadQueryFont(display,font_name);,       if (font_info == (XFontStruct *) NULL)1         Warning("Unable to load font",font_name);      }    /*5     Load fonts from list of fonts until one is found.    */
   p=Fonts;   if (text_font)     p=TextFonts;   while (*p != (char *) NULL)    { *     if (font_info != (XFontStruct *) NULL)       break;)     font_info=XLoadQueryFont(display,*p);      p++;   }    return(font_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t I c o n S i z e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XBestIconSize returns the "best" icon size.  "Best" is defined as L %  an icon size that maintains the aspect ratio of the image.  If the windowH %  manager has preferred icon sizes, one of the preferred sizes is used. % . %  The format of the XBestIconSize routine is: % * %      XBestIconSize(display,window,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */( void XBestIconSize(display,window,image) Display    *display;    XWindowInfo 
   *window;   Image 	   *image;  {  #define MaxIconSize  96      int      i,     number_sizes;      unsigned int     height,      icon_height,     icon_width, 
     width;     unsigned long      scale_factor;      Window     root_window;     XIconSize      *icon_size,      *size_list;      /*G     Determine if the window manager has specified preferred icon sizes.    */   window->width=MaxIconSize;   window->height=MaxIconSize;    icon_size=(XIconSize *) NULL;    number_sizes=0; 2   root_window=XRootWindow(display,window->screen);G   if (XGetIconSizes(display,root_window,&size_list,&number_sizes) != 0) @     if ((number_sizes > 0) && (size_list != (XIconSize *) NULL))       icon_size=size_list;&   if (icon_size == (XIconSize *) NULL)     {        /*3         Window manager does not restrict icon size.        */!       icon_size=XAllocIconSize(); *       if (icon_size == (XIconSize *) NULL)	         { P           Warning("Unable to choose best icon size","Memory allocation failed");           return; 	         }        icon_size->min_width=1; '       icon_size->max_width=MaxIconSize;        icon_size->min_height=1;(       icon_size->max_height=MaxIconSize;       icon_size->width_inc=1;        icon_size->height_inc=1;     }    /*$     Determine aspect ratio of image.   */   width=image->columns;    height=image->rows;    if (window->crop_geometry)F     (void) XParseGeometry(window->crop_geometry,&i,&i,&width,&height);   /*C     Look for an icon size that maintains the aspect ratio of image.    */3   scale_factor=UpShift(icon_size->max_width)/width; =   if (scale_factor > (UpShift(icon_size->max_height)/height)) 7     scale_factor=UpShift(icon_size->max_height)/height; "   icon_width=icon_size->min_width;+   while (icon_width < icon_size->max_width)    { 6     if (icon_width >= (DownShift(width*scale_factor)))       break;%     icon_width+=icon_size->width_inc;    } $   icon_height=icon_size->min_height;-   while (icon_height < icon_size->max_height)    { 8     if (icon_height >= (DownShift(height*scale_factor)))       break;'     icon_height+=icon_size->height_inc;    }    XFree((void *) icon_size);   window->width=icon_width;    window->height=icon_height;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t P i x e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBestPixel returns a pixel from an array of pixels that is closestO %  to the requested color.  If the color array is NULL, the colors are obtained  %  from the X server.  % + %  The format of the XBestPixel routine is:  % D %      pixel=XBestPixel(display,colormap,colors,number_colors,color) % + %  A description of each parameter follows:  % I %    o pixel: XBestPixel returns the pixel value closest to the requested 
 %      color.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o colormap: Specifies the ID of the X server colormap.  % 7 %    o colors: Specifies an array of XColor structures.  % F %    o number_colors: Specifies the number of XColor structures in the %      color definition array. % J %    o color: Specifies the desired RGB value to find in the colors array. %  %  */< void XBestPixel(display,colormap,colors,number_colors,color) Display    *display;    Colormap   colormap;    XColor
   *colors;   unsigned int   number_colors;   XColor	   *color;  {    int      j,     query_server,      status;      register int     blue_distance,     green_distance,      i,     red_distance;      unsigned long 
     distance,      min_distance;      /*<     Find closest representation for the requested RGB color.   */-   status=XAllocColor(display,colormap,color);    if (status != 0)     return; )   query_server=colors == (XColor *) NULL;    if (query_server)      {        /*         Read X server colormap.        */=       colors=(XColor *) malloc(number_colors*sizeof(XColor)); $       if (colors == (XColor *) NULL)M         Error("Unable to read X server colormap","Memory allocation failed"); '       for (i=0; i < number_colors; i++) *         colors[i].pixel=(unsigned long) i;       if (number_colors > 256)         number_colors=256;:       XQueryColors(display,colormap,colors,number_colors);     } $   min_distance=(unsigned long) (~0);   color->pixel=0;    j=0;#   for (i=0; i < number_colors; i++)    {      red_distance=(int)A       (ColorShift(colors[i].red))-(int) (ColorShift(color->red));      green_distance=(int)E       (ColorShift(colors[i].green))-(int) (ColorShift(color->green));      blue_distance=(int) C       (ColorShift(colors[i].blue))-(int) (ColorShift(color->blue)); E     distance=red_distance*red_distance+green_distance*green_distance+ "       blue_distance*blue_distance;      if (distance < min_distance)       {          min_distance=distance;%         color->pixel=colors[i].pixel;          j=i;       }    } 2   (void) XAllocColor(display,colormap,&colors[j]);   if (query_server) !     (void) free((char *) colors);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B e s t V i s u a l I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XBestVisualInfo returns visual information for a visual that is 9 %  the "best" the server supports.  "Best" is defined as:  % J %    1. Restrict the visual list to those supported by the default screen. % K %    2. If a visual type is specified, restrict the visual list to those of  %       that type. % I %    3. If a map type is specified, choose the visual that matches the id + %       specified by the Standard Colormap.  % F %    4  From the list of visuals, choose one that can display the mostJ %       simultaneous colors.  If more than one visual can display the sameF %       number of simultaneous colors, one is choosen based on a rank. % 0 %  The format of the XBestVisualInfo routine is: % B %      visual_info=XBestVisualInfo(display,map_info,resource_info) % + %  A description of each parameter follows:  % J %    o visual_info: XBestVisualInfo returns a pointer to a X11 XVisualInfo %      structure.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */< XVisualInfo *XBestVisualInfo(display,map_info,resource_info) Display    *display;    XStandardColormap    *map_info;  
 XResourceInfo    *resource_info;  {  #define MaxStandardColormaps  7 * #define XVisualColormapSize(visual_info) \O   ((visual_info->class == TrueColor) || (visual_info->class == DirectColor) ? \ P     visual_info->red_mask | visual_info->green_mask | visual_info->blue_mask : \     visual_info->colormap_size)      char     *map_type,     *visual_type;      int      number_visuals;      register int     i;     unsigned int     visual_mask;  
   XVisualInfo      *visual_info,      *visual_list,      visual_template;     /*,     Restrict visual search by screen number.   */#   map_type=resource_info->map_type; )   visual_type=resource_info->visual_type;    visual_mask=VisualScreenMask; 1   visual_template.screen=XDefaultScreen(display); #   if (visual_type != (char *) NULL)      {        /*5         Restrict visual search by class or visual id.        */7       if (Latin1Compare("staticgray",visual_type) == 0) 	         { '           visual_mask|=VisualClassMask; +           visual_template.class=StaticGray; 	         } 
       else8         if (Latin1Compare("grayscale",visual_type) == 0)           { )             visual_mask|=VisualClassMask; ,             visual_template.class=GrayScale;           }          else<           if (Latin1Compare("staticcolor",visual_type) == 0)
             { +               visual_mask|=VisualClassMask; 0               visual_template.class=StaticColor;
             }            else>             if (Latin1Compare("pseudocolor",visual_type) == 0)               { -                 visual_mask|=VisualClassMask; 2                 visual_template.class=PseudoColor;               }              else>               if (Latin1Compare("truecolor",visual_type) == 0)                 { /                   visual_mask|=VisualClassMask; 2                   visual_template.class=TrueColor;                 }                elseB                 if (Latin1Compare("directcolor",visual_type) == 0)                   { 1                     visual_mask|=VisualClassMask; 6                     visual_template.class=DirectColor;                   }                  else@                   if (Latin1Compare("default",visual_type) == 0)                     { 0                       visual_mask|=VisualIDMask;C                       visual_template.visualid=XVisualIDFromVisual( I                         XDefaultVisual(display,XDefaultScreen(display)));                      }                    else.                     if (isdigit(*visual_type))                       { 2                         visual_mask|=VisualIDMask;1                         visual_template.visualid= ?                           strtol(visual_type,(char **) NULL,0);                        }                      elseF                       Warning("Invalid visual specifier",visual_type);     }    /*2     Get all visuals that meet our criteria so far.   */   number_visuals=0; B   visual_list=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); .   visual_mask=VisualScreenMask | VisualIDMask;E   if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL))      {        /*<         Failed to get visual;  try using the default visual.       */2       Warning("Unable to get visual",visual_type);       visual_template.visualid= M         XVisualIDFromVisual(XDefaultVisual(display,XDefaultScreen(display))); F       visual_list=XGetVisualInfo(display,visual_mask,&visual_template,         &number_visuals); I       if ((number_visuals == 0) || (visual_list == (XVisualInfo *) NULL)) %         return((XVisualInfo *) NULL); K       Warning("Using default visual",XVisualClassName(visual_list->class));      } &   resource_info->color_recovery=False;    if (map_type != (char *) NULL)     { 
       Atom         map_property;   
       char          map_name[MaxTextLength];  	       int 
         j,         number_maps,         status;          Window         root_window;         XStandardColormap          *map_list;         /*<         Choose a visual associated with a standard colormap.       */?       root_window=XRootWindow(display,XDefaultScreen(display));        status=0; '       if (strcmp(map_type,"list") != 0) 	         {            /*-             User specified Standard Colormap.            */B           (void) sprintf((char *) map_name,"RGB_%s_MAP",map_type);            Latin1Upper(map_name);C           map_property=XInternAtom(display,(char *) map_name,True); *           if (map_property == (Atom) NULL)>             Error("Unable to get Standard Colormap",map_type);M           status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,              map_property);	         } 
       else	         {            static char              *colormap[]=
             { (               "_HP_RGB_SMOOTH_MAP_LIST",               "RGB_BEST_MAP",                 "RGB_DEFAULT_MAP",               "RGB_GRAY_MAP",                "RGB_RED_MAP",               "RGB_GREEN_MAP",               "RGB_BLUE_MAP",              };             /*3             Choose a standard colormap from a list.            */2           for (i=0; i < MaxStandardColormaps; i++)           { ?             map_property=XInternAtom(display,colormap[i],True); ,             if (map_property == (Atom) NULL)               continue; O             status=XGetRGBColormaps(display,root_window,&map_list,&number_maps,                map_property);             if (status != 0)               break;           } P           resource_info->color_recovery=(i == 0);  /* _HP_RGB_SMOOTH_MAP_LIST */	         }        if (status == 0):         Error("Unable to get Standard Colormap",map_type);       /*E         Search all Standard Colormaps and visuals for ids that match.        */       *map_info=map_list[0]; #ifndef PRE_R4_ICCCMJ       visual_template.visualid=XVisualIDFromVisual(visual_list[0].visual);%       for (i=0; i < number_maps; i++) *         for (j=0; j < number_visuals; j++)%           if (map_list[i].visualid == 9               XVisualIDFromVisual(visual_list[j].visual)) 
             { $               *map_info=map_list[i];'               visual_template.visualid= ;                 XVisualIDFromVisual(visual_list[j].visual);                break;
             } 9       if (map_info->visualid != visual_template.visualid) F         Error("Unable to match visual to Standard Colormap",map_type); #endif0       if (map_info->colormap == (Colormap) NULL)?         Error("Standard Colormap is not initialized",map_type);        XFree((void *) map_list);      }    else     {        static unsigned int          rank[]=            {              StaticGray,              GrayScale,             StaticColor,             DirectColor,             TrueColor,             PseudoColor            };         XVisualInfo          *p;          /*C         Pick one visual that displays the most simultaneous colors.        */       visual_info=visual_list;       p=visual_list;(       for (i=1; i < number_visuals; i++)       {          p++;F         if (XVisualColormapSize(p) > XVisualColormapSize(visual_info))           visual_info=p;         elseI           if (XVisualColormapSize(p) == XVisualColormapSize(visual_info)) :             if (rank[p->class] > rank[visual_info->class])               visual_info=p;       } H       visual_template.visualid=XVisualIDFromVisual(visual_info->visual);     }    XFree((void *) visual_list);   /*7     Retrieve only one visual by its screen & id number.    */B   visual_info=XGetVisualInfo(display,visual_mask,&visual_template,     &number_visuals); E   if ((number_visuals == 0) || (visual_info == (XVisualInfo *) NULL)) !     return((XVisualInfo *) NULL);    return(visual_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h e c k R e f r e s h W i n d o w                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XCheckRefreshWindow checks the X server for exposure events for L %  a particular window and updates the area associated withe exposure event. % 4 %  The format of the XCheckRefreshWindow routine is: % * %      XCheckRefreshWindow(display,window) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % > %    o window: Specifies a pointer to a XWindowInfo structure. %  %  */( void XCheckRefreshWindow(display,window) Display    *display;    XWindowInfo 
   *window; {    XEvent
     event;     XDelay(display,SuspendTime);B   while (XCheckTypedWindowEvent(display,window->id,Expose,&event))*     XRefreshWindow(display,window,&event);#   XDelay(display,SuspendTime << 1); B   while (XCheckTypedWindowEvent(display,window->id,Expose,&event))*     XRefreshWindow(display,window,&event); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t M e s s a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XClientMessage sends a message to a window with XSendEvent.  TheC %  message is initialized with a particular protocol type and atom.  % 0 %  The format of the XClientMessage function is: % @ %      XClientMessage(display,window,protocol,message,timestamp) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ) %    o protocol: Specifies an atom value.  % E %    o message: Specifies an atom value which is the message to send.  % 1 %    o timestamp: Specifies a value of type Time.  %  %  */> void XClientMessage(display,window,protocol,message,timestamp) Display    *display;    Window
    window;   Atom   protocol, 
   message;   Time   timestamp; {    XClientMessageEvent      client_event;   "   client_event.type=ClientMessage;   client_event.window=window; %   client_event.message_type=protocol;    client_event.format=32; !   client_event.data.l[0]=message; #   client_event.data.l[1]=timestamp; ?   XSendEvent(display,window,False,0L,(XEvent *) &client_event);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C l i e n t W i n d o w                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XClientWindow finds a window, at or below the specified window, M %  which has a WM_STATE property.  If such a window is found, it is returned, - %  otherwise the argument window is returned.  % / %  The format of the XClientWindow function is:  % 9 %      client_window=XClientWindow(display,target_window)  % + %  A description of each parameter follows:  % O %    o client_window: XClientWindow returns a window, at or below the specified C %      window, which has a WM_STATE property otherwise the argument ! %      target_window is returned.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o target_window: Specifies the window to find a WM_STATE property.  %  %  */+ Window XClientWindow(display,target_window)  Display    *display;    Window   target_window; {    Atom
     state,	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     number_items;      Window     client_window;  -   state=XInternAtom(display,"WM_STATE",True);    if (state == (Atom) NULL)      return(target_window);   type=(Atom) NULL; D   status=XGetWindowProperty(display,target_window,state,0L,0L,False,E     (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data); 3   if ((status == Success) && (type != (Atom) NULL))      return(target_window);?   client_window=XWindowByProperty(display,target_window,state); %   if (client_window == (Window) NULL)      return(target_window);   return(client_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e l a y                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDelay suspends program execution for the number of milliseconds
 %  specified.  % & %  The format of the Delay routine is: % # %      XDelay(display,milliseconds)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % I %    o milliseconds: Specifies the number of milliseconds to delay before  %      returning.  %  %  */! void XDelay(display,milliseconds)  Display    *display;   
 unsigned long    milliseconds;  {  #ifndef vms  #ifdef SYSV  #include <sys/poll.h>      struct pollfd      descriptor;      (void) XFlush(display);    if (milliseconds == 0)     return; ;   (void) poll((struct pollfd *) NULL,0,(int) milliseconds);  #else    struct timeval
     timer;     (void) XFlush(display);    if (milliseconds == 0)     return; !   timer.tv_sec=milliseconds/1000; +   timer.tv_usec=(milliseconds % 1000)*1000; M   (void) select(0,(XFD_SET *) NULL,(XFD_SET *) NULL,(XFD_SET *) NULL,&timer);  #endif #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D e s t r o y W i n d o w C o l o r s                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XDestroyWindowColors frees X11 color resources previously saved on= %  a window by XRetainWindowColors or programs like xsetroot.  % 5 %  The format of the XDestroyWindowColors routine is:  % + %      XDestroyWindowColors(display,window)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  %  %  */) void XDestroyWindowColors(display,window)  Display    *display;    Window	   window;  {    Atom
     property, 	     type;      int      format,      status;      unsigned char 
     *data;     unsigned long 
     after,     length;      /*E     If there are previous resources on the root window, destroy them.    */5   property=XInternAtom(display,"_XSETROOT_ID",False);    if (property == (Atom) NULL)     { <       Warning("Unable to create X property","_XSETROOT_ID");
       return;      } ?   status=XGetWindowProperty(display,window,property,0L,1L,True, ?     (Atom) AnyPropertyType,&type,&format,&length,&after,&data);    if (status != Success)     return; M   if ((type == XA_PIXMAP) && (format == 32) && (length == 1) && (after == 0))      { 6       XKillClient(display,(XID) (*((Pixmap *) data)));/       XDeleteProperty(display,window,property);      }    if (type != None)      XFree((void *) data);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I m a g e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XDisplayImageInfo displays information about an X image. % 2 %  The format of the XDisplayImageInfo routine is: % = %      XDisplayImageInfo(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */; void XDisplayImageInfo(display,resource_info,windows,image)  Display    *display;   
 XResourceInfo    *resource_info;    XWindows   *windows;    Image 	   *image;  {    char
     *text,     **textlist,      title[MaxTextLength];      int      length;      Image      *p;      unsigned int
     count;     /*@     Display information about the image in the Text View widget.   */   length=11*MaxTextLength;(   if (image->directory != (char *) NULL)%     length+=strlen(image->directory); '   if (image->comments != (char *) NULL) $     length+=strlen(image->comments);,   text=(char *) malloc(length*sizeof(char));   if (text == (char *) NULL)     { D       XNoticeWidget(display,windows,"Unable to display image info:",$         "Memory allocation failed");
       return;      } :   (void) sprintf(title," Image Info: %s",image->filename);*   (void) sprintf(text,"X\n  visual: %s\n",,     XVisualClassName(windows->image.class));C   (void) sprintf(text,"%s  depth: %d\n",text,windows->image.depth); 3   (void) sprintf(text,"%s  geometry: %dx%d\n",text, @     windows->image.ximage->width,windows->image.ximage->height);4   if (windows->image.crop_geometry != (char *) NULL)7     (void) sprintf(text,"%s  crop geometry: %s\n",text, $       windows->image.crop_geometry);-   if (windows->image.pixmap == (Pixmap) NULL) ,     (void) strcat(text,"  type: X Image\n");   else+     (void) strcat(text,"  type: Pixmap\n"); #   if (windows->image.shared_memory) 2     (void) strcat(text,"  shared memory: True\n");   else3     (void) strcat(text,"  shared memory: False\n"); /   if (resource_info->colormap== SharedColormap) 4     (void) strcat(text,"  colormap type: Shared\n");   else5     (void) strcat(text,"  colormap type: Private\n");    (void) strcat(text,"\n"); D   (void) sprintf(text,"%sImage\n  file: %s\n",text,image->filename);=   (void) sprintf(text,"%s  format: %s\n",text,image->magick);    if (image->filesize != 0) A     (void) sprintf(text,"%s  bytes: %ld\n",text,image->filesize); "   if (image->class == DirectClass)1     (void) strcat(text,"  class: DirectClass\n");    else1     (void) strcat(text,"  class: PseudoClass\n");    if (image->matte) *     (void) strcat(text,"  matte: True\n");   else+     (void) strcat(text,"  matte: False\n"); 3   (void) sprintf(text,"%s  geometry: %ux%u\n",text,       image->columns,image->rows);"   if (image->class == PseudoClass)     if (image->colors != 0) A       (void) sprintf(text,"%s  colors: %u\n",text,image->colors); (   if (image->signature != (char *) NULL)E     (void) sprintf(text,"%s  signature: %s\n",text,image->signature); 
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)I     (void) sprintf(text,"%s  scene: %u of %u\n",text,image->scene,count);    else     if (image->scene != 0)?       (void) sprintf(text,"%s  scene: %u\n",text,image->scene); &   if (image->montage != (char *) NULL)A     (void) sprintf(text,"%s  montage: %s\n",text,image->montage); (   if (image->directory != (char *) NULL)H     (void) sprintf(text,"%s  directory:\n\n%s\n",text,image->directory);$   if (image->label != (char *) NULL)=     (void) sprintf(text,"%s  label: %s\n",text,image->label); '   if (image->comments != (char *) NULL) D     (void) sprintf(text,"%s  comments:\n\n%s",text,image->comments);   textlist=StringToList(text);!   if (textlist != (char **) NULL)      {        register int
         i;  I       XTextViewWidget(display,resource_info,windows,True,title,textlist); 2       for (i=0; textlist[i] != (char *) NULL; i++)*         (void) free((char *) textlist[i]);%       (void) free((char *) textlist);      }    (void) free((char *) text);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I n f o S t r i n g                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDisplayInfoString first clears the info window and draws a G %  text string justifed left in the x-direction and centered within the  %  y-direction.  % 4 %  The format of the XDisplayInfoString function is: % 3 %      XDisplayInfoString(display,window_info,text)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowInfo structure.  % 2 %    o text: Specifies a pointer to a text string. %  %  */1 void XDisplayInfoString(display,window_info,text)  Display    *display;    XWindowInfo    *window_info;    char   *text; {    int      length,      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      /*+     Insure text will fit within the window.    */#   font_info=window_info->font_info; 7   width=window_info->width-font_info->max_bounds.width; 1   for (length=strlen(text); length > 0; length--) 3     if (XTextWidth(font_info,text,length) <= width)        break;   /*-     Clear the info window then draw the text.    */(   XClearWindow(display,window_info->id);%   x=font_info->max_bounds.width >> 1; 1   y=font_info->ascent+(window_info->height >> 3); H   XDrawString(display,window_info->id,window_info->annotate_context,x,y,     text,length);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     X D i t h e r I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDitherImage dithers the reference image as required by the HPM %  Color Recovery algorithm.  The color values are quantized to 3 bits of red J %  and green, and 2 bits of blue (3/3/2) and can be used as indices into a %  8-bit X standard colormap.  % - %  The format of the XDitherImage routine is:  % ! %      XDitherImage(image,ximage)  % + %  A description of each parameter follows:  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %  %  */& static void XDitherImage(image,ximage) Image 	   *image;    XImage
   *ximage; {    static short int     dither_red[2][16]=     { H       {-16,  4, -1, 11,-14,  6, -3,  9,-15,  5, -2, 10,-13,  7, -4,  8},G       { 15, -5,  0,-12, 13, -7,  2,-10, 14, -6,  1,-11, 12, -8,  3, -9}      },     dither_green[2][16]=     { H       { 11,-15,  7, -3,  8,-14,  4, -2, 10,-16,  6, -4,  9,-13,  5, -1},G       {-12, 14, -8,  2, -9, 13, -5,  1,-11, 15, -7,  3,-10, 12, -6,  0}      },     dither_blue[2][16]=      { H       { -3,  9,-13,  7, -1, 11,-15,  5, -4,  8,-14,  6, -2, 10,-16,  4},G       {  2,-10, 12, -8,  0,-12, 14, -6,  3, -9, 13, -7,  1,-11, 15, -5}      };  
   ColorPacket 
     color;     int 
     value,     y;     register char      *q;      register int     i,     j,     x;     register RunlengthPacket     *p;      unsigned char      *blue_map[2][16],      *green_map[2][16],     *red_map[2][16];     unsigned int     scanline_pad;      register unsigned long
     pixel;     if (!UncompressImage(image))     return;    /*(     Allocate and initialize dither maps.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { H       red_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));J       green_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char));I       blue_map[i][j]=(unsigned char *) malloc(256*sizeof(unsigned char)); 6       if ((red_map[i][j] == (unsigned char *) NULL) ||8           (green_map[i][j] == (unsigned char *) NULL) ||5           (blue_map[i][j] == (unsigned char *) NULL)) 	         { G           Warning("Unable to dither image","Memory allocation failed");            return; 	         }      }    /*     Initialize dither tables.    */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)       for (x=0; x < 256; x++)        {          value=x-16;          if (x < 48)            value=x/2+8;          value+=dither_red[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;          red_map[i][j][x]=value;          value=x-16;          if (x < 48)            value=x/2+8;"         value+=dither_green[i][j];         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB; !         green_map[i][j][x]=value;          value=x-32;          if (x < 112)           value=x/2+24; (         value+=(dither_blue[i][j] << 1);         if (value < 0)           value=0;         else           if (value > MaxRGB)              value=MaxRGB;           blue_map[i][j][x]=value;       }    /*     Dither image.    */&   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   i=0;   j=0;   p=image->pixels;   q=ximage->data; !   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { &       color.red=red_map[i][j][p->red];,       color.green=green_map[i][j][p->green];)       color.blue=blue_map[i][j][p->blue]; !       pixel=((color.red & 0xe0) | 5         ((unsigned char) (color.green & 0xe0) >> 3) | 4         ((unsigned char) (color.blue & 0xc0) >> 6));!       *q++=(unsigned char) pixel; 
       p++;
       j++;       if (j == 16)         j=0;     }      q+=scanline_pad;     i++;     if (i == 2) 
       i=0;   }    /*     Free allocated memory.   */   for (i=0; i < 2; i++)      for (j=0; j < 16; j++)     { ,       (void) free((char *) green_map[i][j]);+       (void) free((char *) blue_map[i][j]); *       (void) free((char *) red_map[i][j]);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E r r o r                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XError ignores BadWindow errors for XQueryTree andM %  XGetWindowAttributes, and ignores BadDrawable errors for XGetGeometry, and M %  ignores BadValue errors for XQueryColor.  It returns False in those cases.  %  Otherwise it returns True.  % ( %  The format of the XError function is: %  %      XError(display,error) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % ( %    o error: Specifies the error event. %  %  */ int XError(display,error)  Display    *display;    XErrorEvent 	   *error;  {    switch (error->request_code)   {      case X_GetGeometry:      { +       if (error->error_code == BadDrawable)          return(False);       break;     }      case X_GetWindowAttributes:      case X_QueryTree:      { )       if (error->error_code == BadWindow)          return(False);       break;     }      case X_QueryColors:      { (       if (error->error_code == BadValue)         return(False);       break;     }    }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e R e s o u r c e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % / %  Function XFreeResources frees X11 resources.  % / %  The format of the XFreeResources routine is:  % H %      XFreeResources(display,visual_info,map_info,pixel_info,font_info,# %        resource_info,window_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  %  %  */F void XFreeResources(display,visual_info,map_info,pixel_info,font_info,   resource_info,window_info) Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info;   XFontStruct 
   *font_info;   
 XResourceInfo    *resource_info;    XWindowInfo    *window_info;  { *   if (window_info != (XWindowInfo *) NULL)     {        /*         Free X image.        */1       if (window_info->ximage != (XImage *) NULL) +         XDestroyImage(window_info->ximage); +       if (window_info->id != (Window) NULL) 	         {            /*1             Free destroy window and free cursors.            */J           if (window_info->id != XRootWindow(display,visual_info->screen))4             XDestroyWindow(display,window_info->id);9           if (window_info->annotate_context != (GC) NULL) ;             XFreeGC(display,window_info->annotate_context); :           if (window_info->highlight_context != (GC) NULL)<             XFreeGC(display,window_info->highlight_context);7           if (window_info->widget_context != (GC) NULL) 9             XFreeGC(display,window_info->widget_context); 3           XFreeCursor(display,window_info->cursor); 8           XFreeCursor(display,window_info->busy_cursor);	         }      }    /*     Free font.   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info); -   if (map_info != (XStandardColormap *) NULL)      {        /*!         Free X Standard Colormap.        */3       if (resource_info->map_type == (char *) NULL) G         XFreeStandardColormap(display,visual_info,map_info,pixel_info);        XFree((void *) map_info);      }    /*     Free X visual info.    */*   if (visual_info != (XVisualInfo *) NULL)      XFree((void *) visual_info);   XCloseDisplay(display);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X F r e e S t a n d a r d C o l o r m a p                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Function XFreeStandardColormap frees an X11 colormap. % 6 %  The format of the XFreeStandardColormap routine is: % E %      XFreeStandardColormap(display,visual_info,map_info,pixel_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */C void XFreeStandardColormap(display,visual_info,map_info,pixel_info)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info; {    /*     Free colormap.   */   XFlush(display);,   if (map_info->colormap != (Colormap) NULL)L     if (map_info->colormap != XDefaultColormap(display,visual_info->screen))0       XFreeColormap(display,map_info->colormap);     else,       if (pixel_info != (XPixelInfo *) NULL)0         if ((visual_info->class != TrueColor) &&0             (visual_info->class != DirectColor))D           XFreeColors(display,map_info->colormap,pixel_info->pixels,(             (int) pixel_info->colors,0);%   map_info->colormap=(Colormap) NULL; (   if (pixel_info != (XPixelInfo *) NULL)     { 7       if (pixel_info->pixels != (unsigned long *) NULL) 1         (void) free((char *) pixel_info->pixels); 0       pixel_info->pixels=(unsigned long *) NULL;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t A n n o t a t e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetAnnotateInfo initializes the AnnotateInfo structure. % 0 %  The format of the GetAnnotateInfo routine is: % # %      XGetAnnotateInfo(image_info)  % + %  A description of each parameter follows:  % G %    o annotate_info: Specifies a pointer to a XAnnotateInfo structure.  %  %  */$ void XGetAnnotateInfo(annotate_info)
 XAnnotateInfo    *annotate_info;  {    /*"     Initialize annotate structure.   */   annotate_info->x=0;    annotate_info->y=0;    annotate_info->width=0;    annotate_info->height=0;   annotate_info->degrees=0.0; 0   annotate_info->font_info=(XFontStruct *) NULL;$   annotate_info->text=(char *) NULL;    *annotate_info->geometry='\0';1   annotate_info->previous=(XAnnotateInfo *) NULL; -   annotate_info->next=(XAnnotateInfo *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M a p I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetMapInfo initializes the XStandardColormap structure. % 2 %  The format of the XStandardColormap routine is: % 1 %      XGetMapInfo(visual_info,colormap,map_info)  % + %  A description of each parameter follows:  % ; %    o colormap: Specifies the ID of the X server colormap.  % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % J %    o map_info: Specifies a pointer to a X11 XStandardColormap structure. %  %  *// void XGetMapInfo(visual_info,colormap,map_info)  XVisualInfo    *visual_info;    Colormap   colormap;    XStandardColormap    *map_info; {    /*     Initialize map info.   */   map_info->colormap=colormap;*   map_info->red_max=visual_info->red_mask;4   map_info->red_mult=map_info->red_max != 0 ? 1 : 0;   if (map_info->red_max != 0) +     while ((map_info->red_max & 0x01) == 0)      {        map_info->red_max>>=1;       map_info->red_mult<<=1;      } .   map_info->green_max=visual_info->green_mask;8   map_info->green_mult=map_info->green_max != 0 ? 1 : 0;   if (map_info->green_max != 0) -     while ((map_info->green_max & 0x01) == 0)      {        map_info->green_max>>=1;       map_info->green_mult<<=1;      } ,   map_info->blue_max=visual_info->blue_mask;6   map_info->blue_mult=map_info->blue_max != 0 ? 1 : 0;   if (map_info->blue_max != 0),     while ((map_info->blue_max & 0x01) == 0)     {        map_info->blue_max>>=1;        map_info->blue_mult<<=1;     }    map_info->base_pixel=0;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t M o n t a g e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % B %  Function XGetMontageInfo initializes the MontageInfo structure. % 0 %  The format of the XGetMontageInfo routine is: % $ %      XGetMontageInfo(montage_info) % + %  A description of each parameter follows:  % D %    o montage_info: Specifies a pointer to a MontageInfo structure. %  %  */" void XGetMontageInfo(montage_info) XMontageInfo   *montage_info; {    montage_info->number_tiles=0;    montage_info->frame=True;    montage_info->shadow=True;+   montage_info->compose=ReplaceCompositeOp;    montage_info->tile="5x4";  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t P i x e l I n f o                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % > %  Function XGetPixelInfo initializes the PixelInfo structure. % . %  The format of the XGetPixelInfo routine is: % F %      XGetPixelInfo(display,visual_info,map_info,resource_info,image, %        pixel_info) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  %  %  */O void XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap    *map_info;  
 XResourceInfo    *resource_info;    Image 	   *image;   
 XPixelInfo   *pixel_info; { 
   static char      *PenColors[MaxNumberPens]=     {        Pen1Color,       Pen2Color,       Pen3Color,       Pen4Color,       Pen5Color,       Pen6Color,       Pen7Color,       Pen8Color,       Pen9Color,       Pen0Color,     };  
   Colormap
     colormap;      int 	     blue, 
     green,     red,     status;      register int     i;     unsigned int     packets;     /*     Initialize pixel info.   */   pixel_info->colors=0;    if (image != (Image *) NULL)$     if (image->class == PseudoClass)'       pixel_info->colors=image->colors; K   packets=Max(pixel_info->colors,visual_info->colormap_size)+MaxNumberPens; M   pixel_info->pixels=(unsigned long *) malloc(packets*sizeof(unsigned long)); 3   if (pixel_info->pixels == (unsigned long *) NULL) A     Error("Unable to get pixel info","Memory allocation failed");    /*     Set foreground color.    */   colormap=map_info->colormap;6   (void) XParseColor(display,colormap,ForegroundColor,#     &pixel_info->foreground_color); F   status=XParseColor(display,colormap,resource_info->foreground_color,#     &pixel_info->foreground_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->foreground_color);%   pixel_info->foreground_color.pixel= =     XStandardPixel(map_info,pixel_info->foreground_color,16); >   pixel_info->foreground_color.flags=DoRed | DoGreen | DoBlue;   /*     Set background color.    */6   (void) XParseColor(display,colormap,BackgroundColor,#     &pixel_info->background_color); F   status=XParseColor(display,colormap,resource_info->background_color,#     &pixel_info->background_color);    if (status == 0)N     Warning("Color is not known to X server",resource_info->background_color);%   pixel_info->background_color.pixel= =     XStandardPixel(map_info,pixel_info->background_color,16); >   pixel_info->background_color.flags=DoRed | DoGreen | DoBlue;   /*     Set border color.    */M   (void) XParseColor(display,colormap,BorderColor,&pixel_info->border_color); B   status=XParseColor(display,colormap,resource_info->border_color,     &pixel_info->border_color);    if (status == 0)J     Warning("Color is not known to X server",resource_info->border_color);!   pixel_info->border_color.pixel= 9     XStandardPixel(map_info,pixel_info->border_color,16); :   pixel_info->border_color.flags=DoRed | DoGreen | DoBlue;   /*     Set matte color.   */7   pixel_info->matte_color=pixel_info->background_color; 2   if (resource_info->matte_color != (char *) NULL)     {        /*J         Matte color is specified as a X resource or command line argument.       */E       status=XParseColor(display,colormap,resource_info->matte_color, "         &pixel_info->matte_color);       if (status == 0)M         Warning("Color is not known to X server",resource_info->matte_color); $       pixel_info->matte_color.pixel=<         XStandardPixel(map_info,pixel_info->matte_color,16);=       pixel_info->matte_color.flags=DoRed | DoGreen | DoBlue;      }    /*     Set highlight color.   */2   red=ColorShift(309*pixel_info->matte_color.red);>   pixel_info->highlight_color.red=(red > 65535 ? 65535 : red);6   green=ColorShift(309*pixel_info->matte_color.green);D   pixel_info->highlight_color.green=(green > 65535 ? 65535 : green);4   blue=ColorShift(309*pixel_info->matte_color.blue);A   pixel_info->highlight_color.blue=(blue > 65535 ? 65535 : blue); $   pixel_info->highlight_color.pixel=<     XStandardPixel(map_info,pixel_info->highlight_color,16);=   pixel_info->highlight_color.flags=DoRed | DoGreen | DoBlue;    /*     Set shadow color.    */K   pixel_info->shadow_color.red=ColorShift(148*pixel_info->matte_color.red); O   pixel_info->shadow_color.green=ColorShift(148*pixel_info->matte_color.green); M   pixel_info->shadow_color.blue=ColorShift(148*pixel_info->matte_color.blue); !   pixel_info->shadow_color.pixel= 9     XStandardPixel(map_info,pixel_info->shadow_color,16); :   pixel_info->shadow_color.flags=DoRed | DoGreen | DoBlue;   /*     Set depth color.   */J   pixel_info->depth_color.red=ColorShift(209*pixel_info->matte_color.red);N   pixel_info->depth_color.green=ColorShift(209*pixel_info->matte_color.green);L   pixel_info->depth_color.blue=ColorShift(209*pixel_info->matte_color.blue);    pixel_info->depth_color.pixel=8     XStandardPixel(map_info,pixel_info->depth_color,16);9   pixel_info->depth_color.flags=DoRed | DoGreen | DoBlue;    /*     Set trough color.    */K   pixel_info->trough_color.red=ColorShift(134*pixel_info->matte_color.red); O   pixel_info->trough_color.green=ColorShift(134*pixel_info->matte_color.green); M   pixel_info->trough_color.blue=ColorShift(134*pixel_info->matte_color.blue); !   pixel_info->trough_color.pixel= 9     XStandardPixel(map_info,pixel_info->trough_color,16); :   pixel_info->trough_color.flags=DoRed | DoGreen | DoBlue;   /*     Set pen color.   */#   for (i=0; i < MaxNumberPens; i++)    { P     (void) XParseColor(display,colormap,PenColors[i],&pixel_info->pen_color[i]);D     status=XParseColor(display,colormap,resource_info->pen_color[i],!       &pixel_info->pen_color[i]);      if (status == 0)L       Warning("Color is not known to X server",resource_info->pen_color[i]);#     pixel_info->pen_color[i].pixel= ;       XStandardPixel(map_info,pixel_info->pen_color[i],16); <     pixel_info->pen_color[i].flags=DoRed | DoGreen | DoBlue;   } :   pixel_info->annotate_color=pixel_info->foreground_color;   if (image != (Image *) NULL)$     if (image->class == PseudoClass)       { 
         /*@           Initialize pixel array for images of type PseudoClass.
         */)         for (i=0; i < image->colors; i++) N           pixel_info->pixels[i]=XStandardPixel(map_info,image->colormap[i],8);)         for (i=0; i < MaxNumberPens; i++) M           pixel_info->pixels[image->colors+i]=pixel_info->pen_color[i].pixel; *         pixel_info->colors+=MaxNumberPens;       }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e C l a s s                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XGetResourceClass queries the X server for the specified resource F %  name or class.  If the resource name or class is not defined in the4 %  database, the supplied default value is returned. % 2 %  The format of the XGetResourceClass routine is: % M %      value=XGetResourceClass(database,client_name,keyword,resource_default)  % + %  A description of each parameter follows:  % N %    o value: Function XGetResourceClass returns the resource value associatedO %      with the name or class.  If none is found, the supplied default value is  %      returned. % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % M %    o client_name:  Specifies the application name used to retrieve resource ' %      info from the X server database.  % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */F char *XGetResourceClass(database,client_name,keyword,resource_default) XrmDatabase    database;    char   *client_name,    *keyword,    *resource_default; {    char     *resource_type, "     resource_class[MaxTextLength],!     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   *resource_class='\0';    if (keyword != (char *) NULL)      {        unsigned char 
         c,
         k;         /*.         Initialize resource keyword and class.       */@       (void) sprintf(resource_name,"%s.%s",client_name,keyword);       c=(*client_name); %       if ((c >= XK_a) && (c <= XK_z))          c-=(XK_a-XK_A); 
       else5         if ((c >= XK_agrave) && (c <= XK_odiaeresis)) #           c-=(XK_agrave-XK_Agrave);          else2           if ((c >= XK_oslash) && (c <= XK_thorn))'             c-=(XK_oslash-XK_Ooblique);        k=(*keyword); %       if ((k >= XK_a) && (k <= XK_z))          k-=(XK_a-XK_A); 
       else5         if ((k >= XK_agrave) && (k <= XK_odiaeresis)) #           k-=(XK_agrave-XK_Agrave);          else2           if ((k >= XK_oslash) && (k <= XK_thorn))'             k-=(XK_oslash-XK_Ooblique); M       (void) sprintf(resource_class,"%c%s.%c%s",c,client_name+1,k,keyword+1);      } M   status=XrmGetResource(database,resource_name,resource_class,&resource_type,      &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Function XGetResourceInfo initializes the ResourceInfo structure. % 1 %  The format of the XGetResourceInfo routine is:  % D %      XGetResourceInfo(resource_database,client_name,resource_info) % + %  A description of each parameter follows:  % F %    o resource_database: Specifies a resource database; returned from %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */B void XGetResourceInfo(resource_database,client_name,resource_info) XrmDatabase    resource_database;   char   *client_name;   
 XResourceInfo    *resource_info;  {    char     *resource_value;     register char      *p;   #   if (client_name != (char *) NULL)      {        /*         Get basename of client.        */,       p=client_name+(strlen(client_name)-1);.       while ((p > client_name) && (*p != '/'))         p--;       if (*p == '/')         client_name=p+1;     }    /*$     Initialize resource info fields.   */5   resource_info->resource_database=resource_database;    resource_value= H     XGetResourceClass(resource_database,client_name,"backdrop","False");1   resource_info->backdrop=IsTrue(resource_value); I   resource_info->background_color=XGetResourceInstance(resource_database, .     client_name,"background",BackgroundColor);E   resource_info->border_color=XGetResourceInstance(resource_database, +     client_name,"borderColor",BorderColor);    resource_value= G     XGetResourceClass(resource_database,client_name,"borderWidth","2"); 3   resource_info->border_width=atoi(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"colormap","shared"); ,   resource_info->colormap=UndefinedColormap;3   if (Latin1Compare("private",resource_value) == 0) ,     resource_info->colormap=PrivateColormap;2   if (Latin1Compare("shared",resource_value) == 0)+     resource_info->colormap=SharedColormap; 3   if (resource_info->colormap == UndefinedColormap) 9     Warning("Unrecognized colormap type",resource_value); &   resource_info->color_recovery=False;O   resource_value=XGetResourceClass(resource_database,client_name,"colors","0"); 4   resource_info->number_colors=atoi(resource_value);   resource_value= H     XGetResourceClass(resource_database,client_name,"colorspace","rgb");0   resource_info->colorspace=UndefinedColorspace;0   if (Latin1Compare("gray",resource_value) == 0)-     resource_info->colorspace=GRAYColorspace; /   if (Latin1Compare("rgb",resource_value) == 0) ,     resource_info->colorspace=RGBColorspace;0   if (Latin1Compare("ohta",resource_value) == 0)-     resource_info->colorspace=OHTAColorspace; /   if (Latin1Compare("xyz",resource_value) == 0) ,     resource_info->colorspace=XYZColorspace;/   if (Latin1Compare("yiq",resource_value) == 0) ,     resource_info->colorspace=YIQColorspace;/   if (Latin1Compare("yuv",resource_value) == 0) ,     resource_info->colorspace=YUVColorspace;7   if (resource_info->colorspace == UndefinedColorspace) ;     Warning("Unrecognized colorspace type",resource_value); P   resource_info->editor_command=XGetResourceClass(resource_database,client_name,#     "editorCommand",EditorCommand);    resource_value= E     XGetResourceClass(resource_database,client_name,"debug","False"); .   resource_info->debug=IsTrue(resource_value);N   resource_value=XGetResourceClass(resource_database,client_name,"delay","0");,   resource_info->delay=atoi(resource_value);   resource_value= E     XGetResourceClass(resource_database,client_name,"dither","True"); /   resource_info->dither=IsTrue(resource_value);    resource_info->font=N     XGetResourceClass(resource_database,client_name,"fontList",(char *) NULL);   resource_info->font_name[0]=E     XGetResourceClass(resource_database,client_name,"font1","fixed");    resource_info->font_name[1]=H     XGetResourceClass(resource_database,client_name,"font2","variable");   resource_info->font_name[2]=C     XGetResourceClass(resource_database,client_name,"font3","5x8");    resource_info->font_name[3]=D     XGetResourceClass(resource_database,client_name,"font4","6x10");   resource_info->font_name[4]=H     XGetResourceClass(resource_database,client_name,"font5","7x13bold");   resource_info->font_name[5]=H     XGetResourceClass(resource_database,client_name,"font6","8x13bold");   resource_info->font_name[6]=H     XGetResourceClass(resource_database,client_name,"font7","9x15bold");   resource_info->font_name[7]=E     XGetResourceClass(resource_database,client_name,"font8","10x20");    resource_info->font_name[8]=E     XGetResourceClass(resource_database,client_name,"font9","12x24");    resource_info->font_name[9]=E     XGetResourceClass(resource_database,client_name,"font0","fixed"); I   resource_info->foreground_color=XGetResourceInstance(resource_database, .     client_name,"foreground",ForegroundColor);O   resource_info->icon_geometry=XGetResourceClass(resource_database,client_name, "     "iconGeometry",(char *) NULL);   resource_value= G     XGetResourceClass(resource_database,client_name,"gravity","North");    resource_info->gravity=(-1);2   if (Latin1Compare("Forget",resource_value) == 0))     resource_info->gravity=ForgetGravity; 5   if (Latin1Compare("NorthWest",resource_value) == 0) ,     resource_info->gravity=NorthWestGravity;1   if (Latin1Compare("North",resource_value) == 0) (     resource_info->gravity=NorthGravity;5   if (Latin1Compare("NorthEast",resource_value) == 0) ,     resource_info->gravity=NorthEastGravity;0   if (Latin1Compare("West",resource_value) == 0)'     resource_info->gravity=WestGravity; 2   if (Latin1Compare("Center",resource_value) == 0))     resource_info->gravity=CenterGravity; 0   if (Latin1Compare("East",resource_value) == 0)'     resource_info->gravity=EastGravity; 5   if (Latin1Compare("SouthWest",resource_value) == 0) ,     resource_info->gravity=SouthWestGravity;1   if (Latin1Compare("South",resource_value) == 0) (     resource_info->gravity=SouthGravity;5   if (Latin1Compare("SouthEast",resource_value) == 0) ,     resource_info->gravity=SouthEastGravity;2   if (Latin1Compare("Static",resource_value) == 0))     resource_info->gravity=StaticGravity; %   if (resource_info->gravity == (-1))      { :       Warning("Unrecognized gravity type",resource_value);+       resource_info->gravity=CenterGravity;      }    resource_value= F     XGetResourceClass(resource_database,client_name,"iconic","False");/   resource_info->iconic=IsTrue(resource_value); D   resource_info->image_geometry=XGetResourceClass(resource_database,/     client_name,"imageGeometry",(char *) NULL); P   resource_value=XGetResourceClass(resource_database,client_name,"magnify","3");.   resource_info->magnify=atoi(resource_value);   resource_info->map_type=I     XGetResourceClass(resource_database,client_name,"map",(char *) NULL); D   resource_info->matte_color=XGetResourceInstance(resource_database,,     client_name,"mattecolor",(char *) NULL);   resource_value= J     XGetResourceClass(resource_database,client_name,"monochrome","False");3   resource_info->monochrome=IsTrue(resource_value);    resource_info->name=J     XGetResourceClass(resource_database,client_name,"name",(char *) NULL);N   resource_info->pan_geometry=XGetResourceClass(resource_database,client_name,!     "panGeometry",(char *) NULL);    resource_info->pen_color[0]=D     XGetResourceClass(resource_database,client_name,"pen1","black");   resource_info->pen_color[1]=C     XGetResourceClass(resource_database,client_name,"pen2","blue");    resource_info->pen_color[2]=C     XGetResourceClass(resource_database,client_name,"pen3","cyan");    resource_info->pen_color[3]=D     XGetResourceClass(resource_database,client_name,"pen4","green");   resource_info->pen_color[4]=C     XGetResourceClass(resource_database,client_name,"pen5","gray");    resource_info->pen_color[5]=B     XGetResourceClass(resource_database,client_name,"pen6","red");   resource_info->pen_color[6]=F     XGetResourceClass(resource_database,client_name,"pen7","magenta");   resource_info->pen_color[7]=E     XGetResourceClass(resource_database,client_name,"pen8","yellow");    resource_info->pen_color[8]=D     XGetResourceClass(resource_database,client_name,"pen9","white");   resource_info->pen_color[9]=C     XGetResourceClass(resource_database,client_name,"pen0","gray"); O   resource_info->print_command=XGetResourceClass(resource_database,client_name, !     "printCommand",PrintCommand);    resource_info->server_name= P     XGetResourceClass(resource_database,client_name,"serverName",(char *) NULL);   resource_value= K     XGetResourceClass(resource_database,client_name,"sharedMemory","True"); :   resource_info->use_shared_memory=IsTrue(resource_value);   resource_info->text_font= N     XGetResourceClass(resource_database,client_name,"textFont",(char *) NULL);   resource_info->title= K     XGetResourceClass(resource_database,client_name,"title",(char *) NULL);    resource_value= E     XGetResourceClass(resource_database,client_name,"treeDepth","0"); 1   resource_info->tree_depth=atoi(resource_value);    resource_value= F     XGetResourceClass(resource_database,client_name,"update","False");/   resource_info->update=IsTrue(resource_value);    resource_value= I     XGetResourceClass(resource_database,client_name,"usePixmap","False"); 3   resource_info->use_pixmap=IsTrue(resource_value);    resource_info->visual_type= L     XGetResourceClass(resource_database,client_name,"visual",(char *) NULL);   resource_info->window_id= L     XGetResourceClass(resource_database,client_name,"window",(char *) NULL);D   resource_info->write_filename=XGetResourceClass(resource_database,/     client_name,"writeFilename",(char *) NULL);    /*     Handle side-effects.   */    if (resource_info->monochrome)     { %       resource_info->number_colors=2; "       resource_info->tree_depth=8;!       resource_info->dither=True; /       resource_info->colorspace=GRAYColorspace;      } 2   if (resource_info->colorspace == GRAYColorspace)     { '       resource_info->number_colors=256; "       resource_info->tree_depth=8;     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t R e s o u r c e I n s t a n c e                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XGetResourceInstance queries the X server for the specified K %  resource name.  If the resource name is not defined in the database, the & %  supplied default value is returned. % 5 %  The format of the XGetResourceInstance routine is:  % P %      value=XGetResourceInstance(database,client_name,keyword,resource_default) % + %  A description of each parameter follows:  % F %    o value: Function XGetResourceInstance returns the resource valueI %      associated with the name or class.  If none is found, the supplied ! %      default value is returned.  % = %    o database: Specifies a resource database; returned from  %      XrmGetStringDatabase. % D %    o client_name:  Specifies the application name used to retrieve0 %      resource info from the X server database. % C %    o keyword: Specifies the keyword of the value being retrieved.  % K %    o resource_default: Specifies the default value to return if the query 1 %      fails to find the specified keyword/class.  %  %  */I char *XGetResourceInstance(database,client_name,keyword,resource_default)  XrmDatabase    database;    char   *client_name,    *keyword,    *resource_default; {    char     *resource_type, !     resource_name[MaxTextLength];      int      status;   
   XrmValue     resource_value;   %   if (database == (XrmDatabase) NULL)      return(resource_default);    *resource_name='\0';   if (keyword != (char *) NULL) >     (void) sprintf(resource_name,"%s.%s",client_name,keyword);L   status=XrmGetResource(database,resource_name,(char *) NULL,&resource_type,     &resource_value);    if (status == False)     return(resource_default);    return(resource_value.addr); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w C o l o r                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XGetWindowColor returns the color of a pixel interactively choosen %  from the X server.  % 0 %  The format of the XGetWindowColor routine is: % , %      status=XGetWindowColor(display,color) % + %  A description of each parameter follows:  % M %    o status: Function XGetWindowColor returns True if the color is obtained B %      from the X server.  False is returned if any errors occurs. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % G %    o color: The color of the pixel choosen is returned in this XColor  %      structure.  %  %  */+ unsigned int XGetWindowColor(display,color)  Display    *display;    XColor	   *color;  {    int      x,     y;     RectangleInfo      crop_info;     unsigned int     status;      Window
     child,     client_window,     root_window,     target_window;     XImage     *ximage;     XWindowAttributes      window_attributes;     /*%     Choose a pixel from the X server.    */2   target_window=XSelectWindow(display,&crop_info);;   root_window=XRootWindow(display,XDefaultScreen(display));    client_window=target_window;#   if (target_window != root_window)      {        unsigned int
         d;         /*         Get client window.       */P       status=XGetGeometry(display,target_window,&root_window,&x,&x,&d,&d,&d,&d);       if (status != 0)	         { =           client_window=XClientWindow(display,target_window); &           target_window=client_window;	         }      }    /*     Verify window is viewable.   */H   status=XGetWindowAttributes(display,target_window,&window_attributes);G   if ((status == False) || (window_attributes.map_state != IsViewable))      return(False);   /*     Get window X image.    */F   XTranslateCoordinates(display,root_window,target_window,crop_info.x,     crop_info.y,&x,&y,&child);D   ximage=XGetImage(display,target_window,x,y,1,1,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return(False);%   color->pixel=XGetPixel(ximage,0,0);    XDestroyImage(ximage);   /*#     Query X server for pixel color.    */8   XQueryColor(display,window_attributes.colormap,color);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XGetWindowImage reads an image from the target X window and returns M %  it.  XGetWindowImage optionally descends the window hierarchy and overlays . %  the target image with each subwindow image. % 0 %  The format of the XGetWindowImage routine is: % : %      image=XGetWindowImage(display,window,borders,level) % + %  A description of each parameter follows:  % H %    o image: Function XGetWindowImage returns a MIFF image if it can beH %      successfully read from the X window.  A null image is returned if %      any errors occurs.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % = %    o window: Specifies the window to obtain the image from.  % E %    o borders: Specifies whether borders pixels are to be saved with  %      the image.  % E %    o level: Specifies an unsigned integer representing the level of I %      decent in the window hierarchy.  This value must be zero or one on J %      the initial call to XGetWindowImage.  A value of zero returns afterJ %      one call.  A value of one causes the function to descend the windowI %      hierarchy and overlays the target image with each subwindow image.  %  %  */4 Image *XGetWindowImage(display,window,borders,level) Display    *display;    Window	   window;    unsigned int
   borders,   level; {    typedef struct _ColormapList   {      Colormap       colormap;   
     XColor       *colors;       struct _ColormapList       *next;   } ColormapList;      GC     annotate_context;      Image      *image;      int      display_height,      display_width,     number_colors,     status, 
     x_offset, 
     y_offset;      RectangleInfo      crop_info;     register int     i,     x,     y;     register RunlengthPacket     *p;      register unsigned long
     pixel;     static ColormapList +     *colormap_list = (ColormapList *) NULL;      Window
     child,     root_window;     XColor     *colors;     XGCValues      context_values;      XImage     *ximage;     XWindowAttributes      window_attributes;     /*     Verify window is viewable.   */A   status=XGetWindowAttributes(display,window,&window_attributes); G   if ((status == False) || (window_attributes.map_state != IsViewable))      return((Image *) NULL);    /*2     Cropping rectangle is relative to root window.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); K   XTranslateCoordinates(display,window,root_window,0,0,&x_offset,&y_offset,      &child);   crop_info.x=x_offset;    crop_info.y=y_offset; *   crop_info.width=window_attributes.width;,   crop_info.height=window_attributes.height;   if (borders)     {        /*          Include border in image.       */2       crop_info.x-=window_attributes.border_width;2       crop_info.y-=window_attributes.border_width;;       crop_info.width+=window_attributes.border_width << 1; <       crop_info.height+=window_attributes.border_width << 1;     }    /*     Crop to root window.   */   if (crop_info.x < 0)     { 2       if ((crop_info.x+(int) crop_info.width) < 0)         return((Image *) NULL); #       crop_info.width+=crop_info.x;        crop_info.x=0;     }    if (crop_info.y < 0)     { 3       if ((crop_info.y+(int) crop_info.height) < 0)          return((Image *) NULL); $       crop_info.height+=crop_info.y;       crop_info.y=0;     } ?   display_width=XDisplayWidth(display,XDefaultScreen(display)); :   if ((crop_info.x+(int) crop_info.width) > display_width)     { '       if (crop_info.x >= display_width)          return((Image *) NULL); 0       crop_info.width=display_width-crop_info.x;     } A   display_height=XDisplayHeight(display,XDefaultScreen(display)); <   if ((crop_info.y+(int) crop_info.height) > display_height)     { (       if (crop_info.y >= display_height)         return((Image *) NULL); 2       crop_info.height=display_height-crop_info.y;     }    crop_info.x-=x_offset;   crop_info.y-=y_offset;   /*D     Alert user we are about to get an X region by flashing a border.   */I   context_values.background=XBlackPixel(display,XDefaultScreen(display)); I   context_values.foreground=XWhitePixel(display,XDefaultScreen(display)); #   context_values.function=GXinvert;    context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors; I   annotate_context=XCreateGC(display,window,GCBackground | GCForeground | @     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context != (GC) NULL)     { C       XHighlightRegion(display,window,annotate_context,&crop_info); 9       XDelay(display,(unsigned long) (SuspendTime << 2)); C       XHighlightRegion(display,window,annotate_context,&crop_info);      }    /*     Get window X image.    */J   ximage=XGetImage(display,window,crop_info.x,crop_info.y,crop_info.width,(     crop_info.height,AllPlanes,ZPixmap);    if (ximage == (XImage *) NULL)     return((Image *) NULL);    number_colors=0;   colors=(XColor *) NULL; 4   if (window_attributes.colormap != (Colormap) NULL)     {        ColormapList         *p;          /*1         Search colormap list for window colormap.        */:       number_colors=window_attributes.visual->map_entries;B       for (p=colormap_list; p != (ColormapList *) NULL; p=p->next)6         if (p->colormap == window_attributes.colormap)           break;%       if (p == (ColormapList *) NULL) 	         {            /*$             Get the window colormap.           */A           colors=(XColor *) malloc(number_colors*sizeof(XColor)); (           if (colors == (XColor *) NULL)
             { $               XDestroyImage(ximage);%               return((Image *) NULL); 
             } A           if ((window_attributes.visual->class != DirectColor) && =               (window_attributes.visual->class != TrueColor)) -             for (i=0; i < number_colors; i++) 
             {                 colors[i].pixel=i;               colors[i].pad=0;
             }            else
             {                unsigned long                  blue,                  blue_bit,                  green,                 green_bit,                 red,                 red_bit;                 /*0                 DirectColor or TrueColor visual.               */               red=0;               green=0;               blue=0; :               red_bit=window_attributes.visual->red_mask &:                 (~(window_attributes.visual->red_mask)+1);>               green_bit=window_attributes.visual->green_mask &<                 (~(window_attributes.visual->green_mask)+1);<               blue_bit=window_attributes.visual->blue_mask &;                 (~(window_attributes.visual->blue_mask)+1); /               for (i=0; i < number_colors; i++)                { 3                 colors[i].pixel=red | green | blue;                   colors[i].pad=0;                 red+=red_bit; =                 if (red > window_attributes.visual->red_mask)                    red=0;!                 green+=green_bit; A                 if (green > window_attributes.visual->green_mask)                    green=0;                 blue+=blue_bit; ?                 if (blue > window_attributes.visual->blue_mask)                    blue=0;                } 
             } A           XQueryColors(display,window_attributes.colormap,colors,              (int) number_colors);           /*-             Append colormap to colormap list.            */:           p=(ColormapList *) malloc(sizeof(ColormapList));1           p->colormap=window_attributes.colormap;            p->colors=colors;             p->next=colormap_list;           colormap_list=p;	         }        colors=p->colors;      }    /*     Allocate image structure.    */*   image=AllocateImage((ImageInfo *) NULL);   if (image == (Image *) NULL)     {        XDestroyImage(ximage);       return((Image *) NULL);      }    /*#     Convert X image to MIFF format.    */7   if ((window_attributes.visual->class != TrueColor) && 7       (window_attributes.visual->class != DirectColor))      image->class=PseudoClass;    image->columns=ximage->width;    image->rows=ximage->height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) B     malloc((unsigned int) image->packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)     {        XDestroyImage(ximage);       DestroyImage(image);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */2       red_mask=window_attributes.visual->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } 6       green_mask=window_attributes.visual->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } 4       blue_mask=window_attributes.visual->blue_mask;       blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */        if ((number_colors > 0) &&;           (window_attributes.visual->class == DirectColor)) '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             index=(pixel >> red_shift) & red_mask;1             p->red=ColorShift(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=ColorShift(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=ColorShift(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 	         } 
       else'         for (y=0; y < image->rows; y++) ,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;F             p->red=ColorShift(((unsigned long) color*65535)/red_mask);6             color=(pixel >> green_shift) & green_mask;J             p->green=ColorShift(((unsigned long) color*65535)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;H             p->blue=ColorShift(((unsigned long) color*65535)/blue_mask);             p->index=0;              p->length=0;             p++;           }        break;     }      case PseudoClass:      {        /*         Create colormap.       */"       image->colors=number_colors;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {             XDestroyImage(ximage);           DestroyImage(image);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=ColorShift(colors[i].red); K         image->colormap[colors[i].pixel].green=ColorShift(colors[i].green); I         image->colormap[colors[i].pixel].blue=ColorShift(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++) *         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);*           p->index=(unsigned short) pixel;           p->length=0;           p++;	         }        SyncImage(image);        break;     }    }    XDestroyImage(ximage);$   if (annotate_context != (GC) NULL)     {        /*<         Alert user we got the X region by flashing a border.       */C       XHighlightRegion(display,window,annotate_context,&crop_info);        XFlush(display);C       XHighlightRegion(display,window,annotate_context,&crop_info); (       XFreeGC(display,annotate_context);     }    if (level != 0)      {        unsigned int         number_children;         Window         *children,         parent;          /*K         Descend the window hierarchy and overlay with each subwindow image.        */F       status=XQueryTree(display,window,&root_window,&parent,&children,         &number_children);5       if ((status == True) && (number_children != 0)) 	         {            Image              *child_image;              /*:             Composite any children in back-to-front order.           */-           for (i=0; i < number_children; i++)            { K             child_image=XGetWindowImage(display,children[i],False,level+1); .             if (child_image != (Image *) NULL)               {                  /*/                   Composite child window image.                  */O                 XTranslateCoordinates(display,children[i],window,0,0,&x_offset, $                   &y_offset,&child);&                 x_offset-=crop_info.x;!                 if (x_offset < 0)                    x_offset=0; &                 y_offset-=crop_info.y;!                 if (y_offset < 0)                    y_offset=0; M                 CompositeImage(image,ReplaceCompositeOp,child_image,x_offset,                    y_offset);*                 DestroyImage(child_image);               }            } #           XFree((void *) children); 	         }      }    if (level <= 1)      {        ColormapList         *next;         /*         Free resources.        */4       while (colormap_list != (ColormapList *) NULL)       { !         next=colormap_list->next; 4         (void) free((char *) colormap_list->colors);,         (void) free((char *) colormap_list);         colormap_list=next;        } &       if (image->class == PseudoClass)          CompressColormap(image);     }    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i n d o w I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWindowInfo initializes the XWindowInfo structure.  % / %  The format of the XGetWindowInfo routine is:  % H %      XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info, %        resource_info,window) % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % H %    o map_info: If map_type is specified, this structure is initialized, %      with info from the Standard Colormap. % A %    o pixel_info: Specifies a pointer to a XPixelInfo structure.  % A %    o font_info: Specifies a pointer to a XFontStruct structure.  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %  %  */F void XGetWindowInfo(display,visual_info,map_info,pixel_info,font_info,   resource_info,window)  Display    *display;    XVisualInfo    *visual_info;    XStandardColormap   *map_info;   
 XPixelInfo   *pixel_info;   XFontStruct 
   *font_info;   
 XResourceInfo    *resource_info;    XWindowInfo 
   *window; {    /*     Initialize window info.    */"   if (window->id != (Window) NULL)     { *       XFreeCursor(display,window->cursor);/       XFreeCursor(display,window->busy_cursor); 5       if (window->highlight_stipple != (Pixmap) NULL) 7         XFreePixmap(display,window->highlight_stipple); 2       if (window->shadow_stipple != (Pixmap) NULL)4         XFreePixmap(display,window->shadow_stipple);     }    else     { 	       int 
         x;         window->id=(Window) NULL; %       window->ximage=(XImage *) NULL; *       window->matte_image=(XImage *) NULL;#       window->pixmap=(Pixmap) NULL; )       window->matte_pixmap=(Pixmap) NULL;        window->mapped=False;        window->stasis=False; "       window->shared_memory=False; #ifdef HasSharedMemory"       window->shared_memory=False;+       if (resource_info->use_shared_memory) H         (void) XShmQueryExtension(display,&x,&x,&window->shared_memory);-       window->ximage_segment_info.shmid=(-1); -       window->pixmap_segment_info.shmid=(-1);  #endif     } %   window->screen=visual_info->screen; %   window->visual=visual_info->visual; #   window->class=visual_info->class; #   window->depth=visual_info->depth; "   window->visual_info=visual_info;   window->map_info=map_info;    window->pixel_info=pixel_info;   window->font_info=font_info;8   window->cursor=XCreateFontCursor(display,XC_left_ptr);:   window->busy_cursor=XCreateFontCursor(display,XC_watch);   window->name=(char *) NULL; !   window->geometry=(char *) NULL; "   window->icon_name=(char *) NULL;5   window->icon_geometry=resource_info->icon_geometry; &   window->crop_geometry=(char *) NULL;   window->flags=PSize;   window->x=0;   window->y=0;   window->x_origin=0;    window->y_origin=0;    window->width=1;   window->height=1;    window->min_width=1;   window->min_height=1;    window->width_inc=1;   window->height_inc=1; 3   window->border_width=resource_info->border_width; 8   window->annotate_context=pixel_info->annotate_context;:   window->highlight_context=pixel_info->highlight_context;4   window->widget_context=pixel_info->widget_context;'   window->shadow_stipple=(Pixmap) NULL; *   window->highlight_stipple=(Pixmap) NULL;   window->immutable=False;K   window->mask=CWBackingStore | CWBackPixel | CWBackPixmap | CWBitGravity | K     CWBorderPixel | CWColormap | CWCursor | CWDontPropagate | CWEventMask | 4     CWOverrideRedirect | CWSaveUnder | CWWinGravity;I   window->attributes.background_pixel=pixel_info->background_color.pixel; 5   window->attributes.background_pixmap=(Pixmap) NULL; -   window->attributes.backing_store=NotUseful; /   window->attributes.bit_gravity=ForgetGravity; A   window->attributes.border_pixel=pixel_info->border_color.pixel; 1   window->attributes.colormap=map_info->colormap; +   window->attributes.cursor=window->cursor; 7   window->attributes.do_not_propagate_mask=NoEventMask; ,   window->attributes.event_mask=NoEventMask;-   window->attributes.override_redirect=False; &   window->attributes.save_under=False;2   window->attributes.win_gravity=NorthWestGravity; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t L i n e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightLine puts a border on the X server around a region %  defined by highlight_info.  % / %  The format of the XHighlightLine routine is:  % C %    XHighlightLine(display,window,annotate_context,highlight_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ? %    o annotate_context: Specifies a pointer to a GC structure.  % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %  %  */C void XHighlightLine(display,window,annotate_context,highlight_info)  Display    *display;    Window	   window;    GC   annotate_context;    XSegment   *highlight_info; { ?   XDrawLine(display,window,annotate_context,highlight_info->x1, >     highlight_info->y1,highlight_info->x2,highlight_info->y2);C /*  XDrawLine(display,window,annotate_context,highlight_info->x1+1, F     highlight_info->y1+1,highlight_info->x2+1,highlight_info->y2+1);*/ }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t R e g i o n                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XHighlightRegion puts a border on the X server around a region %  defined by highlight_info.  % 1 %  The format of the XHighlightRegion routine is:  % E %    XHighlightRegion(display,window,annotate_context,highlight_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % 9 %    o window: Specifies a pointer to a Window structure.  % ? %    o annotate_context: Specifies a pointer to a GC structure.  % L %    o highlight_info: Specifies a pointer to a RectangleInfo structure.  It: %      contains the extents of any highlighting rectangle. %  %  */E void XHighlightRegion(display,window,annotate_context,highlight_info)  Display    *display;    Window	   window;    GC   annotate_context;   
 RectangleInfo    *highlight_info; { B   if ((highlight_info->width < 4) || (highlight_info->height < 4))     return; C   XDrawRectangle(display,window,annotate_context,highlight_info->x, H     highlight_info->y,highlight_info->width-1,highlight_info->height-1);E   XDrawRectangle(display,window,annotate_context,highlight_info->x+1, J     highlight_info->y+1,highlight_info->width-3,highlight_info->height-3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a k e C u r s o r                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 8 %  Function XMakeCursor creates a crosshairs X11 cursor. % , %  The format of the XMakeCursor routine is: % M %      XMakeCursor(display,window,colormap,background_color,foreground_color)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o window: Specifies the ID of the window for which the cursor is  %      assigned. % K %    o colormap: Specifies the ID of the colormap from which the background . %      and foreground color will be retrieved. % N %    o background_color: Specifies the color to use for the cursor background. % N %    o foreground_color: Specifies the color to use for the cursor foreground. %  %  */M Cursor XMakeCursor(display,window,colormap,background_color,foreground_color)  Display    *display;    Window	   window;    Colormap   colormap;    char   *background_color,   *foreground_color; {  #define scope_height 17  #define scope_x_hot 8  #define scope_y_hot 8  #define scope_width 17     static unsigned char     scope_bits[] =     { G       0x80, 0x03, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, G       0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x7f, G       0xfc, 0x01, 0x01, 0x00, 0x01, 0x7f, 0xfc, 0x01, 0x80, 0x02, 0x00, G       0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, 0x00, 0x80, 0x02, .       0x00, 0x80, 0x02, 0x00, 0x80, 0x03, 0x00     };     static unsigned char     scope_mask_bits[] =      { G       0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, G       0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xff, 0xfe, 0x01, 0x7f, G       0xfc, 0x01, 0x03, 0x80, 0x01, 0x7f, 0xfc, 0x01, 0xff, 0xfe, 0x01, G       0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, 0x00, 0xc0, 0x06, .       0x00, 0xc0, 0x07, 0x00, 0xc0, 0x07, 0x00     };     Cursor     cursor;      Pixmap	     mask,      source;      XColor     background,      foreground;   N   source=XCreateBitmapFromData(display,window,(char *) scope_bits,scope_width,     scope_height);E   mask=XCreateBitmapFromData(display,window,(char *) scope_mask_bits,      scope_width,scope_height);;   if ((source == (Pixmap) NULL) || (mask == (Pixmap) NULL)) 3     Error("Unable to create pixmap",(char *) NULL); =   XParseColor(display,colormap,background_color,&background); =   XParseColor(display,colormap,foreground_color,&foreground); I   cursor=XCreatePixmapCursor(display,source,mask,&foreground,&background,      scope_x_hot,scope_y_hot);    XFreePixmap(display,source);   XFreePixmap(display,mask);   return(cursor);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X M a k e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XMakeImage creates an X11 image.  If the image size differs from2 %  the X11 image size, the image is first resized. % + %  The format of the XMakeImage routine is:  % I %      status=XMakeImage(display,resource_info,window,image,width,height)  % + %  A description of each parameter follows:  % A %    o status: Function XMakeImage returns True if the X image is N %      successfully created.  False is returned is there is a memory shortage. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % > %    o window: Specifies a pointer to a XWindowInfo structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % F %    o width: Specifies the width in pixels of the rectangular area to %      display.  % H %    o height: Specifies the height in pixels of the rectangular area to %      display.  %  %  */H unsigned int XMakeImage(display,resource_info,window,image,width,height) Display    *display;   
 XResourceInfo    *resource_info;    XWindowInfo 
   *window;   Image 	   *image;    unsigned int   width,	   height;  {    Image      *transformed_image;      int      format;    #ifdef HasSharedMemory   static XShmSegmentInfo     segment_info;  #endif     XImage     *matte_image,      *ximage;  4   if ((window->width == 0) || (window->height == 0))     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   transformed_image=image;   if (image != (Image *) NULL)     {        /*+         Apply user transforms to the image.        */        if (window->crop_geometry)	         {            Image              *cropped_image;              RectangleInfo              crop_info;             /*             Crop image.            */P           (void) XParseGeometry(window->crop_geometry,&crop_info.x,&crop_info.y,0             &crop_info.width,&crop_info.height);)           transformed_image->orphan=True; @           cropped_image=CropImage(transformed_image,&crop_info);*           transformed_image->orphan=False;)           if (transformed_image != image) ,             DestroyImage(transformed_image);.           if (cropped_image == (Image *) NULL)             return(False);*           transformed_image=cropped_image;	         } 2       if ((width != transformed_image->columns) ||.           (height != transformed_image->rows))	         {            Image              *scaled_image;             /*             Scale image.           */)           transformed_image->orphan=True; .           if (window->pixel_info->colors != 0)E             scaled_image=SampleImage(transformed_image,width,height);            elseD             scaled_image=ScaleImage(transformed_image,width,height);*           transformed_image->orphan=False;)           if (transformed_image != image) ,             DestroyImage(transformed_image);-           if (scaled_image == (Image *) NULL)              return(False);)           transformed_image=scaled_image; 	         } '       width=transformed_image->columns; %       height=transformed_image->rows;      }    /*     Create X image.    */3   format=(window->depth == 1) ? XYBitmap : ZPixmap;  #ifdef HasSharedMemory   if (window->shared_memory)     { K       ximage=XShmCreateImage(display,window->visual,window->depth,format,0, $         &segment_info,width,height);C       segment_info.shmid=shmget(IPC_PRIVATE,ximage->bytes_per_line* )         ximage->height,IPC_CREAT | 0777); 4       window->shared_memory=segment_info.shmid >= 0;        if (window->shared_memory)D         segment_info.shmaddr=(char *) shmat(segment_info.shmid,0,0);     }  #endif   if (!window->shared_memory) F     ximage=XCreateImage(display,window->visual,window->depth,format,0,8       (char *) NULL,width,height,XBitmapPad(display),0);    if (ximage == (XImage *) NULL)     {%       /*!         Unable to create X image.%       */7       XDefineCursor(display,window->id,window->cursor);        return(False);     }    if (resource_info->debug)      { )       (void) fprintf(stderr,"XImage:\n"); E       (void) fprintf(stderr,"  width, height: %dx%d\n",ximage->width,          ximage->height);=       (void) fprintf(stderr,"  format: %d\n",ximage->format); E       (void) fprintf(stderr,"  byte order: %d\n",ximage->byte_order); H       (void) fprintf(stderr,"  bitmap unit, bit order, pad: %d %d %d\n",I         ximage->bitmap_unit,ximage->bitmap_bit_order,ximage->bitmap_pad); ;       (void) fprintf(stderr,"  depth: %d\n",ximage->depth); M       (void) fprintf(stderr,"  bytes per line: %d\n",ximage->bytes_per_line); M       (void) fprintf(stderr,"  bits per pixel: %d\n",ximage->bits_per_pixel); L       (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",?         ximage->red_mask,ximage->green_mask,ximage->blue_mask);      }    /*      Allocate X image pixel data.   */ #ifdef HasSharedMemory   if (window->shared_memory)     { "       segment_info.readOnly=False;(       XShmAttach(display,&segment_info);       XSync(display,False); ,       shmctl(segment_info.shmid,IPC_RMID,0);(       ximage->data=segment_info.shmaddr;     }  #endif   if (!window->shared_memory) #     if (ximage->format == XYBitmap)        ximage->data=(char *) D         malloc(ximage->bytes_per_line*ximage->height*ximage->depth);     elseJ       ximage->data=(char *) malloc(ximage->bytes_per_line*ximage->height);$   if (ximage->data == (char *) NULL)     {        /*&         Unable to allocate pixel data.       */       XDestroyImage(ximage);7       XDefineCursor(display,window->id,window->cursor);i       return(False);     }d(   if (window->ximage != (XImage *) NULL)     {t #ifdef HasSharedMemory        if (window->shared_memory)	         {p;           XShmDetach(display,&window->ximage_segment_info);t(           XDestroyImage(window->ximage);5           shmdt(window->ximage_segment_info.shmaddr); 	         }I #endif!       if (!window->shared_memory)n&         XDestroyImage(window->ximage);     }n #ifdef HasSharedMemory+   window->ximage_segment_info=segment_info;r #endif   window->ximage=ximage;   matte_image=(XImage *) NULL;*   if (transformed_image != (Image *) NULL)!     if (transformed_image->matte)s       {o
         /*           Create matte image.s
         */E         matte_image=XCreateImage(display,window->visual,1,XYBitmap,0, <           (char *) NULL,width,height,XBitmapPad(display),0);+         if (matte_image != (XImage *) NULL)o           {m             /*.               Allocate matte image pixel data.             */J             matte_image->data=(char *) malloc(matte_image->bytes_per_line*6               matte_image->height*matte_image->depth);3             if (matte_image->data == (char *) NULL)                {d+                 XDestroyImage(matte_image); ,                 matte_image=(XImage *) NULL;               }g           }h       }u-   if (window->matte_image != (XImage *) NULL)c'     XDestroyImage(window->matte_image);s"   window->matte_image=matte_image;   window->stasis=False;    if (image == (Image *) NULL)     {%7       XDefineCursor(display,window->id,window->cursor);%       return(True);      }    /*5     Convert runlength-encoded pixels to X image data.    */)   if ((ximage->byte_order == LSBFirst) ||uO       ((ximage->format == XYBitmap) && (ximage->bitmap_bit_order == LSBFirst)))oE     XMakeImageLSBFirst(resource_info,window,transformed_image,ximage,d       matte_image);0   elseE     XMakeImageMSBFirst(resource_info,window,transformed_image,ximage,*       matte_image);v-   if (window->matte_image != (XImage *) NULL)n     {i       /*         Create matte pixmap.       */0       if (window->matte_pixmap != (Pixmap) NULL)2         XFreePixmap(display,window->matte_pixmap);L       window->matte_pixmap=XCreatePixmap(display,window->id,width,height,1);0       if (window->matte_pixmap != (Pixmap) NULL)	         {%           GC             graphics_context;              XGCValues              context_values;              /*-             Copy matte image to matte pixmap.            */&           context_values.background=1;&           context_values.foreground=0;P           graphics_context=XCreateGC(display,window->matte_pixmap,GCBackground |*             GCForeground,&context_values);B           XPutImage(display,window->matte_pixmap,graphics_context,6             window->matte_image,0,0,0,0,width,height);,           XFreeGC(display,graphics_context); #ifdef HasShape A           XShapeCombineMask(display,window->id,ShapeBounding,0,0,%+             window->matte_pixmap,ShapeSet);F=           XWithdrawWindow(display,window->id,window->screen);s)           XMapRaised(display,window->id);  #endif	         }      }t!   if (transformed_image != image)r$     DestroyImage(transformed_image);   /*     Restore cursor.e   */3   XDefineCursor(display,window->id,window->cursor);b   return(True);  }o e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %oO %                                                                             % O %                                                                             % O %   X M a k e I m a g e L S B F i r s t                                       % O %                                                                             %%O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XMakeImageLSBFirst initializes the pixel data of an X11 Image.H %  The X image pixels are copied in least-significant bit and byte firstL %  order.  The server's scanline pad is respected.  Rather than using one orL %  two general cases, many special cases are found here to help speed up the %  image conversion. % 3 %  The format of the XMakeImageLSBFirst routine is:% %%H %      XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) %m+ %  A description of each parameter follows:f %eK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %g> %    o window: Specifies a pointer to a XWindowInfo structure. %oF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %eH %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %iM %    o matte_image: Specifies a pointer to a XImage structure;  returned fromn %      XCreateImage. %  */M static void XMakeImageLSBFirst(resource_info,window,image,ximage,matte_image) 
 XResourceInfor   *resource_info;h   XWindowInfo 
   *window;   Imagei	   *image;e   XImage
   *ximage,   *matte_image;  {r   register int     i,     j,     x;     register RunlengthPacket     *p;'     register unsigned char     bit,	     byte,      *q;      register unsigned long
     pixel;     unsigned int     scanline_pad;      unsigned long      *pixels;     XStandardColormapc     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;   p=image->pixels;#   q=(unsigned char *) ximage->data;n   x=0;!   if (ximage->format == XYBitmap))     {        register unsigned short_         polarity;(         unsigned charl         background,>         foreground;          /*+         Convert image to big-endian bitmap.        */C       background=(Intensity(window->pixel_info->foreground_color) <oG         Intensity(window->pixel_info->background_color) ? 0x80 : 0x00);iC       foreground=(Intensity(window->pixel_info->background_color) <nG         Intensity(window->pixel_info->foreground_color) ? 0x80 : 0x00);%M       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte>>=1; #           if (p->index == polarity)              byte|=foreground;            else             byte|=background;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;!           if (x == ximage->width) 
             {                /*-                 Advance to the next scanline.%               */               if (bit != 0) #                 *q=byte >> (8-bit);e               q+=scanline_pad;               bit=0;               byte=0;                x=0;
             }t	         }.         p++;       }      }n   else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)t       {s         case 2:d	         {o           register unsigned int              nibble;r             /*2             Convert to 2 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf;a2             for (j=0; j <= ((int) p->length); j++)
             {f               switch (nibble)o               {                  case 0:X                 {l+                   *q=(unsigned char) pixel;t                   nibble++;X                   break;                 }=                 case 1:                  {%3                   *q|=(unsigned char) (pixel << 2);%                   nibble++;                    break;                 }                  case 2:                  { 3                   *q|=(unsigned char) (pixel << 4);                    nibble++;                    break;                 }                  case 3:                  { 3                   *q|=(unsigned char) (pixel << 6);                    q++;                   nibble=0;                    break;                 }                }                x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0;%"                   q+=scanline_pad;                 }%
             }F             p++;           }s           break;	         }          case 4:e	         {m           register unsigned int=             nibble;y             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0; ,           for (i=0; i < image->packets; i++)           {e)             pixel=pixels[p->index] & 0xf;x2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)n               {r                 case 0:                  { +                   *q=(unsigned char) pixel;                    nibble++;                    break;                 }X                 case 1:                  {n3                   *q|=(unsigned char) (pixel << 4);                    q++;                   nibble=0;l                   break;                 }o               }e               x++;%               if (x == ximage->width)i                 {i                   x=0;                   nibble=0;p"                   q+=scanline_pad;                 }n
             }a             p++;           }            break;	         }i         case 6:          case 8:e	         {m           /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither)i
             { )               XDitherImage(image,ximage);o               break;
             }x,           for (i=0; i < image->packets; i++)           { #             pixel=pixels[p->index]; 2             for (j=0; j <= ((int) p->length); j++)
             {i)               *q++=(unsigned char) pixel;R               x++;%               if (x == ximage->width)u                 {f                   x=0;"                   q+=scanline_pad;                 }o
             }h             p++;           }i           break;	         }p         default:	         {            register int             k;             register unsigned ints             bytes_per_pixel;             unsigned charg+             channel[sizeof(unsigned long)];-             /*7             Convert to multi-byte color-mapped X image.g           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           {x#             pixel=pixels[p->index];g/             for (k=0; k < bytes_per_pixel; k++) 
             {i/               channel[k]=(unsigned char) pixel;                pixel>>=8;
             }(2             for (j=0; j <= ((int) p->length); j++)
             { 1               for (k=0; k < bytes_per_pixel; k++)e                  *q++=channel[k];               x++;%               if (x == ximage->width)o                 {a                   x=0;"                   q+=scanline_pad;                 }*
             }e             p++;           }o           break;	         }g       }N     else%       switch (ximage->bits_per_pixel)        {n         case 2:a	         {o           register unsigned intn             nibble;n             /*@             Convert to contiguous 2 bit continuous-tone X image.           */           nibble=0;e,           for (i=0; i < image->packets; i++)           {c0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf;a2             for (j=0; j <= ((int) p->length); j++)
             {                switch (nibble)                {t                 case 0:/                 {e+                   *q=(unsigned char) pixel;o                   nibble++;n                   break;                 }-                 case 1:G                 {m3                   *q|=(unsigned char) (pixel << 2);                    nibble++;s                   break;                 }/                 case 2:h                 {k3                   *q|=(unsigned char) (pixel << 4);e                   nibble++;n                   break;                 }b                 case 3:                  {e3                   *q|=(unsigned char) (pixel << 6);l                   q++;                   nibble=0;l                   break;                 }                }l               x++;%               if (x == ximage->width)u                 {i                   x=0;                   nibble=0;t"                   q+=scanline_pad;                 }g
             }              p++;           }            break;	         }n         case 4:e	         {w           register unsigned intn             nibble;)             /*@             Convert to contiguous 4 bit continuous-tone X image.           */           nibble=0;a,           for (i=0; i < image->packets; i++)           {a0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf;u2             for (j=0; j <= ((int) p->length); j++)
             {a               switch (nibble)f               {d                 case 0:                  { +                   *q=(unsigned char) pixel;                    nibble++;                    break;                 }r                 case 1:e                 {r3                   *q|=(unsigned char) (pixel << 4);o                   q++;                   nibble=0;S                   break;                 }o               }0               x++;%               if (x == ximage->width)e                 {r                   x=0;                   nibble=0;="                   q+=scanline_pad;                 }I
             }m             p++;           }t           break;	         }          case 6:          case 8: 	         {g           /*@             Convert to contiguous 8 bit continuous-tone X image.           */E           if (resource_info->color_recovery && resource_info->dither)o
             {u)               XDitherImage(image,ximage);)               break;
             } ,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;p               x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 } 
             }i             p++;           }o           break;	         }a         default:	         {u/           if ((ximage->bits_per_pixel == 32) &&%+               (map_info->red_max == 255) &&%-               (map_info->green_max == 255) && ,               (map_info->blue_max == 255) &&.               (map_info->red_mult == 65536) &&.               (map_info->green_mult == 256) &&)               (map_info->blue_mult == 1)) 
             {                /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)                 {                    *q++=p->blue;                     *q++=p->green;                   *q++=p->red;                   *q++=0;%                 }%                 p++;               }B
             }            else1             if ((ximage->bits_per_pixel == 32) && -                 (map_info->red_max == 255) &&t/                 (map_info->green_max == 255) &&d.                 (map_info->blue_max == 255) &&,                 (map_info->red_mult == 1) &&0                 (map_info->green_mult == 256) &&/                 (map_info->blue_mult == 65536))                {t                 /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {o8                   for (j=0; j <= ((int) p->length); j++)                   {                       *q++=p->red;"                     *q++=p->green;!                     *q++=p->blue;u                     *q++=0;                    }s                   p++;                 }i               }              else               {                  register int                   k;  %                 register unsigned int-"                   bytes_per_pixel;                   unsigned char11                   channel[sizeof(unsigned long)];a                   /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 { 6                   pixel=XStandardPixel(map_info,*p,8);5                   for (k=0; k < bytes_per_pixel; k++)                    {e5                     channel[k]=(unsigned char) pixel;o                     pixel>>=8;                   }U8                   for (j=0; j <= ((int) p->length); j++)                   { 7                     for (k=0; k < bytes_per_pixel; k++)l&                       *q++=channel[k];                     x++;+                     if (x == ximage->width)                        {f                         x=0;(                         q+=scanline_pad;                       };                   }r                   p++;                 }n               }            break;	         }L       }o%   if (matte_image != (XImage *) NULL)u     {_       /*         Initialize matte image.%       *//       scanline_pad=matte_image->bytes_per_line- @         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte>>=1; &           if (p->index == Transparent)             byte|=0x01;            bit++;           if (bit == 8) 
             {                *q++=byte;               bit=0;               byte=0; 
             }            x++;&           if (x == matte_image->width)
             {%               /*-                 Advance to the next scanline.                */               if (bit != 0)s#                 *q=byte >> (8-bit);                q+=scanline_pad;               bit=0;               byte=0;                x=0;
             },	         }          p++;       }.     }  }e r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %eO %                                                                             % O %   X M a k e I m a g e M S B F i r s t                                       %nO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %mJ %  Function XMakeImageMSBFirst initializes the pixel data of an X11 Image.N %  The X image pixels are copied in most-significant bit and byte first order.M %  The server's scanline pad is also resprected. Rather than using one or two;N %  general cases, many special cases are found here to help speed up the image %  conversion. % 3 %  The format of the XMakeImageMSBFirst routine is:s %=H %      XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image) % + %  A description of each parameter follows:  % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.) %L> %    o window: Specifies a pointer to a XWindowInfo structure. %,F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % H %    o ximage: Specifies a pointer to a XImage structure;  returned from %      XCreateImage. %=M %    o matte_image: Specifies a pointer to a XImage structure;  returned from  %      XCreateImage. %  %e */M static void XMakeImageMSBFirst(resource_info,window,image,ximage,matte_image)i
 XResourceInfoe   *resource_info;a   XWindowInfod
   *window;   Image&	   *image;e   XImage
   *ximage,   *matte_image;  {t   register int     i,     j,     x;     register RunlengthPacket     *p;>     register unsigned char     bit,	     byte,(     *q;-     register unsigned long
     pixel;     unsigned int     scanline_pad;t     unsigned longo     *pixels;     XStandardColormapt     *map_info;  &   scanline_pad=ximage->bytes_per_line-2     ((ximage->width*ximage->bits_per_pixel) >> 3);   map_info=window->map_info;$   pixels=window->pixel_info->pixels;   p=image->pixels;#   q=(unsigned char *) ximage->data;    x=0;!   if (ximage->format == XYBitmap)g     {e       register unsigned shortc         polarity;e         unsigned char          background,i         foreground;=         /*+         Convert image to big-endian bitmap.        */C       background=(Intensity(window->pixel_info->foreground_color) < G         Intensity(window->pixel_info->background_color) ? 0x01 : 0x00); C       foreground=(Intensity(window->pixel_info->background_color) < G         Intensity(window->pixel_info->foreground_color) ? 0x01 : 0x00); M       polarity=Intensity(image->colormap[0]) < Intensity(image->colormap[1]);        bit=0;
       byte=0; (       for (i=0; i < image->packets; i++)       { .         for (j=0; j <= ((int) p->length); j++)	         {            byte<<=1; #           if (p->index == polarity)              byte|=foreground;            else             byte|=background;%           bit++;           if (bit == 8)%
             {%               *q++=byte;               bit=0;               byte=0;r
             }a           x++;!           if (x == ximage->width)l
             {L               /*-                 Advance to the next scanline.r               */               if (bit != 0)p#                 *q=byte << (8-bit);r               q+=scanline_pad;               bit=0;               byte=0;                x=0;
             }e	         }e         p++;       }e     }    else(     if (window->pixel_info->colors != 0)%       switch (ximage->bits_per_pixel)        {n         case 2: 	         {:           register unsigned int              nibble;o             /*2             Convert to 2 bit color-mapped X image.           */           nibble=0;C,           for (i=0; i < image->packets; i++)           { )             pixel=pixels[p->index] & 0xf;u2             for (j=0; j <= ((int) p->length); j++)
             {,               switch (nibble)o               {                  case 0:                  {r2                   *q=(unsigned char) (pixel << 6);                   nibble++;                    break;                 }                  case 1:s                 {i3                   *q|=(unsigned char) (pixel << 4);n                   nibble++;i                   break;                 }t                 case 2:                  {t3                   *q|=(unsigned char) (pixel << 2);s                   nibble++;_                   break;                 }r                 case 3:                  {s,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;f                   break;                 }U               }e               x++;%               if (x == ximage->width)0                 {;                   x=0;                   nibble=0; "                   q+=scanline_pad;                 };
             }o             p++;           }m           break;	         }i         case 4:l	         {            register unsigned int              nibble;r             /*2             Convert to 4 bit color-mapped X image.           */           nibble=0;),           for (i=0; i < image->packets; i++)           {r)             pixel=pixels[p->index] & 0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {o               switch (nibble)i               {c                 case 0:a                 { 2                   *q=(unsigned char) (pixel << 4);                   nibble++;                    break;                 }-                 case 1:                  { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;(                   break;                 }%               }%               x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0; "                   q+=scanline_pad;                 } 
             }              p++;           }            break;	         }          case 6:          case 8: 	         {            /*2             Convert to 8 bit color-mapped X image.           */E           if (resource_info->color_recovery && resource_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             } ,           for (i=0; i < image->packets; i++)           {%#             pixel=pixels[p->index];%2             for (j=0; j <= ((int) p->length); j++)
             {a)               *q++=(unsigned char) pixel;a               x++;%               if (x == ximage->width)e                 {                    x=0;"                   q+=scanline_pad;                 } 
             }              p++;           }            break;	         }          default:	         {f           register int             k;             register unsigned intp             bytes_per_pixel;             unsigned charl+             channel[sizeof(unsigned long)];h             /*2             Convert to 8 bit color-mapped X image.           */6           bytes_per_pixel=ximage->bits_per_pixel >> 3;,           for (i=0; i < image->packets; i++)           {r#             pixel=pixels[p->index];e2             for (k=bytes_per_pixel-1; k >= 0; k--)
             {o/               channel[k]=(unsigned char) pixel;o               pixel>>=8;
             }X2             for (j=0; j <= ((int) p->length); j++)
             { 1               for (k=0; k < bytes_per_pixel; k++)X                  *q++=channel[k];               x++;%               if (x == ximage->width)                  {                    x=0;"                   q+=scanline_pad;                 }X
             }r             p++;           }f           break;	         }p       }o     else%       switch (ximage->bits_per_pixel)l       {          case 2:s	         {            register unsigned inta             nibble;              /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0;=,           for (i=0; i < image->packets; i++)           {-0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {v               switch (nibble)                {i                 case 0:                  {v2                   *q=(unsigned char) (pixel << 6);                   nibble++;a                   break;                 }r                 case 1:                  {r3                   *q|=(unsigned char) (pixel << 4);k                   nibble++;X                   break;                 }=                 case 2:                  {e3                   *q|=(unsigned char) (pixel << 2);/                   nibble++;a                   break;                 }                  case 3:C                 { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;,                   break;                 }                }a               x++;%               if (x == ximage->width)                  {                    x=0;                   nibble=0;u"                   q+=scanline_pad;                 }s
             }a             p++;           }l           break;	         }          case 4: 	         {            register unsigned intc             nibble;              /*5             Convert to 4 bit continuous-tone X image.            */           nibble=0;=,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);             pixel&=0xf; 2             for (j=0; j <= ((int) p->length); j++)
             {i               switch (nibble)                {                  case 0:                  {i2                   *q=(unsigned char) (pixel << 4);                   nibble++;                    break;                 }                  case 1:.                 { ,                   *q|=(unsigned char) pixel;                   q++;                   nibble=0;p                   break;                 }                }m               x++;%               if (x == ximage->width)i                 {m                   x=0;                   nibble=0;l"                   q+=scanline_pad;                 } 
             }              p++;           }(           break;	         }          case 6:          case 8: 	         {u           /*5             Convert to 8 bit continuous-tone X image.l           */E           if (resource_info->color_recovery && resource_info->dither) 
             { )               XDitherImage(image,ximage);                break;
             }s,           for (i=0; i < image->packets; i++)           { 0             pixel=XStandardPixel(map_info,*p,8);2             for (j=0; j <= ((int) p->length); j++)
             { )               *q++=(unsigned char) pixel;e               x++;%               if (x == ximage->width)u                 {I                   x=0;"                   q+=scanline_pad;                 }d
             }              p++;           }            break;	         }          default:	         {d/           if ((ximage->bits_per_pixel == 32) &&s+               (map_info->red_max == 255) &&l-               (map_info->green_max == 255) &&l,               (map_info->blue_max == 255) &&.               (map_info->red_mult == 65536) &&.               (map_info->green_mult == 256) &&)               (map_info->blue_mult == 1))v
             {l               /*:                 Convert to 32 bit continuous-tone X image.               */0               for (i=0; i < image->packets; i++)               { 6                 for (j=0; j <= ((int) p->length); j++)                 {                    *q++=0;s                   *q++=p->red;                    *q++=p->green;                   *q++=p->blue;*                 }v                 p++;               }a
             }            else1             if ((ximage->bits_per_pixel == 32) && -                 (map_info->red_max == 255) && /                 (map_info->green_max == 255) &&r.                 (map_info->blue_max == 255) &&,                 (map_info->red_mult == 1) &&0                 (map_info->green_mult == 256) &&/                 (map_info->blue_mult == 65536))h               {u                 /*<                   Convert to 32 bit continuous-tone X image.                 */2                 for (i=0; i < image->packets; i++)                 {l8                   for (j=0; j <= ((int) p->length); j++)                   {                      *q++=0; !                     *q++=p->blue; "                     *q++=p->green;                      *q++=p->red;                   }                    p++;                 }_               }              else               {R                 register int                   k;  %                 register unsigned inth"                   bytes_per_pixel;                   unsigned chari1                   channel[sizeof(unsigned long)];                    /*@                   Convert to multi-byte continuous-tone X image.                 */<                 bytes_per_pixel=ximage->bits_per_pixel >> 3;2                 for (i=0; i < image->packets; i++)                 {r6                   pixel=XStandardPixel(map_info,*p,8);8                   for (k=bytes_per_pixel-1; k >= 0; k--)                   {M5                     channel[k]=(unsigned char) pixel;                      pixel>>=8;                   }e8                   for (j=0; j <= ((int) p->length); j++)                   {t7                     for (k=0; k < bytes_per_pixel; k++)_&                       *q++=channel[k];                     x++;+                     if (x == ximage->width)r                       {                          x=0;(                         q+=scanline_pad;                       }o                   }]                   p++;                 }m               }i           break;	         }l       }l%   if (matte_image != (XImage *) NULL)a     {l       /*         Initialize matte image.        *//       scanline_pad=matte_image->bytes_per_line-t@         ((matte_image->width*matte_image->bits_per_pixel) >> 3);       p=image->pixels;,       q=(unsigned char *) matte_image->data;       bit=0;
       byte=0;r(       for (i=0; i < image->packets; i++)       {F.         for (j=0; j <= ((int) p->length); j++)	         {t           byte<<=1; &           if (p->index == Transparent)             byte|=0x01;            bit++;           if (bit == 8) 
             {o               *q++=byte;               bit=0;               byte=0; 
             }            x++;&           if (x == matte_image->width)
             {o               /*-                 Advance to the next scanline.;               */               if (bit != 0)b#                 *q=byte << (8-bit);+               q+=scanline_pad;               bit=0;               byte=0;                x=0;
             }e	         }          p++;       }(     }V }a l /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             % O %                                                                             %uO %   X M a k e M a g n i f y I m a g e                                         %eO %                                                                             %fO %                                                                             %%O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XMakeMagnifyImage magnifies a region of an X image and displays it.  % 2 %  The format of the XMakeMagnifyImage routine is: % ) %      XMakeMagnifyImage(display,windows)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %  */' void XMakeMagnifyImage(display,windows)  Display%   *display;%   XWindows   *windows;% {%   register int     x,     y;     register unsigned char     *p,c     *q;s     register unsigned into     j,     k,     l;  
   static chare     text[MaxTextLength];     static unsigned intf     previous_magnify=0;h     static XWindowInfo     magnify_window;i     unsigned int     height,d     i,     magnify,     scanline_pad, 
     width;     XColor
     color;     XImage     *ximage;     /*     Check boundry conditions.    */   magnify=1;+   for (i=1; i < windows->magnify.data; i++)      magnify<<=1;I   while ((magnify*windows->image.ximage->width) < windows->magnify.width)w     magnify<<=1;K   while ((magnify*windows->image.ximage->height) < windows->magnify.height)v     magnify<<=1;*   while (magnify > windows->magnify.width)     magnify>>=1;+   while (magnify > windows->magnify.height)h     magnify>>=1;"   if (magnify != previous_magnify)     {)       unsigned int         status;e         XTextProperty%         window_name;         /*8         New magnify factor:  update magnify window name.       */
       i=0;!       while ((1 << i) <= magnify)          i++;<       (void) sprintf(windows->magnify.name,"Magnify %uX",i);N       status=XStringListToTextProperty(&windows->magnify.name,1,&window_name);       if (status != 0)=         XSetWMName(display,windows->magnify.id,&window_name);      }    previous_magnify=magnify;    ximage=windows->image.ximage; '   width=windows->magnify.ximage->width; )   height=windows->magnify.ximage->height; .   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0)     x=0;   else,     if (x > (ximage->width-(width/magnify)))$       x=ximage->width-width/magnify;/   y=windows->magnify.y-((height/magnify) >> 1);s   if (y < 0)     y=0;   else.     if (y > (ximage->height-(height/magnify)))&       y=ximage->height-height/magnify;4   q=(unsigned char *) windows->magnify.ximage->data;7   scanline_pad=windows->magnify.ximage->bytes_per_line-,;     ((width*windows->magnify.ximage->bits_per_pixel) >> 3); !   if (ximage->bits_per_pixel < 8)n     {t       register unsigned char         background,i
         byte,          foreground,a         p_bit,         q_bit;         register unsigned ints         plane;         XPixelInfo         *pixel_info;  -       pixel_info=windows->magnify.pixel_info;m'       switch (ximage->bitmap_bit_order)        {/         case LSBFirst:	         {w           /*)             Magnify little-endian bitmap.i           */           background=0x00;           foreground=0x80;)           if (ximage->format == XYBitmap)e
             {eC               background=(Intensity(pixel_info->foreground_color) <tG                 Intensity(pixel_info->background_color) ? 0x80 : 0x00);tC               foreground=(Intensity(pixel_info->background_color) <eG                 Intensity(pixel_info->foreground_color) ? 0x80 : 0x00);%
             }%+           for (i=0; i < height; i+=magnify)%           {              /*+               Propogate pixel magnify rows.              */'             for (j=0; j < magnify; j++) 
             { H               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {                  /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)                  {%                   /*-                     Propogate each bit plane.                    */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {u                     byte>>=1;u5                     if (*p & (0x01 << (p_bit+plane))) '                       byte|=foreground;n                     else'                       byte|=background;i                     q_bit++;#                     if (q_bit == 8)o                       {n"                         *q++=byte;                          q_bit=0;                         byte=0;e                       }r                   }d                 }l.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)p                   {e                     p++;                     p_bit=0;                   }d                 if (q_bit != 0)i'                   *q=byte >> (8-q_bit);                   q+=scanline_pad;               } 
             }              y++;           }i           break;	         }n         case MSBFirst:         default:	         {d           /*&             Magnify big-endian bitmap.           */           background=0x00;           foreground=0x01;)           if (ximage->format == XYBitmap)W
             {iC               background=(Intensity(pixel_info->foreground_color) <yG                 Intensity(pixel_info->background_color) ? 0x01 : 0x00);yC               foreground=(Intensity(pixel_info->background_color) <nG                 Intensity(pixel_info->foreground_color) ? 0x01 : 0x00);d
             } +           for (i=0; i < height; i+=magnify)w           {*             /*+               Propogate pixel magnify rows.%             */'             for (j=0; j < magnify; j++) 
             { H               p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+2                 ((x*ximage->bits_per_pixel) >> 3);6               p_bit=(x*ximage->bits_per_pixel) & 0x07;               q_bit=0;               byte=0; .               for (k=0; k < width; k+=magnify)               {                  /*2                   Propogate pixel magnify columns.                 */+                 for (l=0; l < magnify; l++)                  {                    /*-                     Propogate each bit plane.%                   */H                   for (plane=0; plane < ximage->bits_per_pixel; plane++)                   {a                     byte<<=1;i5                     if (*p & (0x80 >> (p_bit+plane)))l'                       byte|=foreground;,                     else'                       byte|=background;                      q_bit++;#                     if (q_bit == 8)t                       {i"                         *q++=byte;                          q_bit=0;                         byte=0;g                       }a                   }s                 }s.                 p_bit+=ximage->bits_per_pixel;                 if (p_bit == 8)u                   {                      p++;                     p_bit=0;                   }c                 if (q_bit != 0))'                   *q=byte << (8-q_bit);i                  q+=scanline_pad;               } 
             }(             y++;           }=           break;	         }v       }i     }/   else#     switch (ximage->bits_per_pixel)*     { 
       case 6:(
       case 8:U       {E
         /*            Magnify 8 bit X image.
         */)         for (i=0; i < height; i+=magnify)%	         {%           /*)             Propogate pixel magnify rows.            */%           for (j=0; j < magnify; j++)            { F             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {                /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)                  *q++=(*p);               p++;
             }              q+=scanline_pad;           }            y++;	         }          break;       }        default:       {%         register unsigned int%           bytes_per_pixel,           m;  
         /*%           Magnify multi-byte X image.e
         */4         bytes_per_pixel=ximage->bits_per_pixel >> 3;)         for (i=0; i < height; i+=magnify)e	         {C           /*)             Propogate pixel magnify rows.a           */%           for (j=0; j < magnify; j++)l           { F             p=(unsigned char *) ximage->data+y*ximage->bytes_per_line+0               ((x*ximage->bits_per_pixel) >> 3);,             for (k=0; k < width; k+=magnify)
             {o               /*0                 Propogate pixel magnify columns.               */)               for (l=0; l < magnify; l++)m3                 for (m=0; m < bytes_per_pixel; m++)                     *q++=(*(p+m));!               p+=bytes_per_pixel;p
             }e             q+=scanline_pad;           }            y++;	         }l         break;       }      }(   /*#     Copy X image to magnify pixmap.n   */.   x=windows->magnify.x-((width/magnify) >> 1);   if (x < 0).     x=(width >> 1)-windows->magnify.x*magnify;   else,     if (x > (ximage->width-(width/magnify)))@       x=(ximage->width-windows->magnify.x)*magnify-(width >> 1);     else
       x=0;/   y=windows->magnify.y-((height/magnify) >> 1);)   if (y < 0)/     y=(height >> 1)-windows->magnify.y*magnify;(   else.     if (y > (ximage->height-(height/magnify)))B       y=(ximage->height-windows->magnify.y)*magnify-(height >> 1);     else
       y=0;   if ((x != 0) || (y != 0))%3     XFillRectangle(display,windows->magnify.pixmap, :       windows->magnify.annotate_context,0,0,width,height);N   XPutImage(display,windows->magnify.pixmap,windows->magnify.annotate_context,6     windows->magnify.ximage,0,0,x,y,width-x,height-y);4   if ((magnify > 1) && ((magnify <= (width >> 1)) &&"       (magnify <= (height >> 1))))     {        RectangleInfo          highlight_info;          /*         Highlight center pixel.        */3       highlight_info.x=windows->magnify.width >> 1; 4       highlight_info.y=windows->magnify.height >> 1;#       highlight_info.width=magnify; $       highlight_info.height=magnify;5       XDrawRectangle(display,windows->magnify.pixmap,%M         windows->magnify.highlight_context,highlight_info.x,highlight_info.y,g8         highlight_info.width-1,highlight_info.height-1);       if (magnify > 2)7         XDrawRectangle(display,windows->magnify.pixmap,s?           windows->magnify.annotate_context,highlight_info.x+1,eM           highlight_info.y+1,highlight_info.width-3,highlight_info.height-3);o     }c   /*     Show center pixel color.   */   color.pixel=K     XGetPixel(windows->image.ximage,windows->magnify.x,windows->magnify.y); @   XQueryColor(display,windows->image.map_info->colormap,&color);"   if (windows->magnify.depth > 12)C     (void) sprintf(text,"%+d%+d  (%3u,%3u,%3u)",windows->magnify.x, G       windows->magnify.y,ColorShift(color.red),ColorShift(color.green),o       ColorShift(color.blue));   elseI     (void) sprintf(text,"%+d%+d  (%3u,%3u,%3u)  %lu ",windows->magnify.x,gG       windows->magnify.y,ColorShift(color.red),ColorShift(color.green),p*       ColorShift(color.blue),color.pixel);P   height=windows->magnify.font_info->ascent+windows->magnify.font_info->descent;:   x=(3*windows->magnify.font_info->max_bounds.width) >> 2;5   y=windows->magnify.font_info->ascent+(height >> 2);>3   XDrawImageString(display,windows->magnify.pixmap,)=     windows->magnify.annotate_context,x,y,text,strlen(text));i   /*     Refresh magnify window.a   */"   magnify_window=windows->magnify;   magnify_window.x=0;    magnify_window.y=0;f:   XRefreshWindow(display,&magnify_window,(XEvent *) NULL); }x X /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             %eO %                                                                             %gO %                                                                             %xO %   X M a k e P i x m a p                                                     %iO %                                                                             %"O %                                                                             %aO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %o. %  Function XMakePixmap creates an X11 pixmap. %S, %  The format of the XMakePixmap routine is: %o7 %      status=XMakePixmap(display,resource_info,window)  %i+ %  A description of each parameter follows:i %eC %    o status: Function XMakePixmap returns True if the X pixmap isgN %      successfully created.  False is returned is there is a memory shortage. %xK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %"D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %m> %    o window: Specifies a pointer to a XWindowInfo structure. %  %v */6 unsigned int XMakePixmap(display,resource_info,window) Displayo   *display;n  
 XResourceInfog   *resource_info;o   XWindowInfog
   *window; {u   unsigned int     height,r
     width;  (   if (window->ximage == (XImage *) NULL)     return(False);   /*     Display busy cursor.   */8   XDefineCursor(display,window->id,window->busy_cursor);   XFlush(display);   /*     Create pixmap.   */&   if (window->pixmap != (Pixmap) NULL)     { *       XFreePixmap(display,window->pixmap);#       window->pixmap=(Pixmap) NULL;  #ifdef HasSharedMemory        if (window->shared_memory)3         if (window->pixmap_segment_info.shmid >= 0)            {s>             XShmDetach(display, &window->pixmap_segment_info);!             XSync(display,False);i7             shmdt(window->pixmap_segment_info.shmaddr); 3             window->pixmap_segment_info.shmid=(-1);)           }, #endif     }\   width=window->ximage->width;    height=window->ximage->height; #ifdef HasSharedMemory   if (window->shared_memory)     {a       XShmSegmentInfom         segment_info;   2       segment_info.shmid=(int) shmget(IPC_PRIVATE,@         window->ximage->bytes_per_line*height,IPC_CREAT | 0777);"       if (segment_info.shmid >= 0)	         { F           segment_info.shmaddr=(char *) shmat(segment_info.shmid,0,0);&           segment_info.readOnly=False;0           if (XShmAttach(display,&segment_info))?             window->pixmap=XShmCreatePixmap(display,window->id, M               segment_info.shmaddr,&segment_info,width,height,window->depth);%.           if (window->pixmap != (Pixmap) NULL)5             window->pixmap_segment_info=segment_info;            else
             { *               shmdt(segment_info.shmaddr);0               XShmDetach(display,&segment_info);
             }            XSync(display,False); 0           shmctl(segment_info.shmid,IPC_RMID,0);	         }      }  #endif&   if (window->pixmap == (Pixmap) NULL)P     window->pixmap=XCreatePixmap(display,window->id,width,height,window->depth);&   if (window->pixmap == (Pixmap) NULL)     {        /*"         Unable to allocate pixmap.       */7       XDefineCursor(display,window->id,window->cursor);%       return(False);     }%   /*     Copy X image to pixmap.    */ #ifdef HasSharedMemory   if (window->shared_memory)P     XShmPutImage(display,window->pixmap,window->annotate_context,window->ximage,!       0,0,0,0,width,height,True);T #endif   if (!window->shared_memory)cM     XPutImage(display,window->pixmap,window->annotate_context,window->ximage,s       0,0,0,0,width,height);   if (resource_info->debug)p     { )       (void) fprintf(stderr,"Pixmap:\n");eE       (void) fprintf(stderr,"  width, height: %dx%d\n",width,height);e     }X   /*     Restore cursor.    */3   XDefineCursor(display,window->id,window->cursor);    return(True);I }S n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %tO %                                                                             %-O %   X M a k e S t a n d a r d C o l o r m a p                                 %gO %                                                                             % O %                                                                             %oO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %oC %  Function XMakeStandardColormap creates an X11 Standard Colormap.% %%6 %  The format of the XMakeStandardColormap routine is: % E %      XMakeStandardColormap(display,visual_info,resource_info,image,  %        map_info,pixel_info)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % G %    o visual_info: Specifies a pointer to a X11 XVisualInfo structure; $ %      returned from XGetVisualInfo. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.% %%L %    o map_info: If a Standard Colormap type is specified, this structure is8 %      initialized with info from the Standard Colormap. %aA %    o pixel_info: Specifies a pointer to a XPixelInfo structure.l %( %/ */  static int IntensityCompare(x,y)
 const void   *x,    *y;p {    DiversityPacketf
     *color_1,g
     *color_2;       color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }e  ! static int PopularityCompare(x,y)a
 const void   *x,o   *y;: {e   DiversityPacket 
     *color_1,u
     *color_2;r      color_1=(DiversityPacket *) x;    color_2=(DiversityPacket *) y;4   return((int) color_2->count-(int) color_1->count); }t  L void XMakeStandardColormap(display,visual_info,resource_info,image,map_info,
   pixel_info)  Display3   *display;,   XVisualInfo5   *visual_info;   
 XResourceInfo1   *resource_info;9   Image,	   *image;r   XStandardColormap    *map_info;  
 XPixelInfo   *pixel_info; {6
   Colormap
     colormap;      int2     status;      register int     i;     unsigned int     gray_value,      number_colors,     retain_colors;     XColor
     color,     *colors,     *p;2  /   if (resource_info->map_type != (char *) NULL)      {        /*=         Standard Colormap is already defined (i.e. xstdcmap).n       */7       if (pixel_info->pixels != (unsigned long *) NULL)i1         (void) free((char *) pixel_info->pixels);aK       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+[3         (map_info->green_max*map_info->green_mult)+n4         (map_info->blue_max*map_info->blue_mult)+1);3       if (image->matte || !resource_info->dither || M           resource_info->color_recovery || (number_colors > MaxColormapSize)) G         XGetPixelInfo(display,visual_info,map_info,resource_info,image,2           pixel_info);
       else	         {j           Image*             *map_image;n  "           register RunlengthPacket             *p;o             /*:             Improve image appearance with error diffusion.           */6           map_image=AllocateImage((ImageInfo *) NULL);*           if (map_image == (Image *) NULL)G             Error("Unable to dither image","Memory allocation failed");y+           map_image->columns=number_colors;            map_image->rows=1;@           map_image->packets=map_image->columns*map_image->rows;/           map_image->pixels=(RunlengthPacket *) ?             malloc(map_image->packets*sizeof(RunlengthPacket)); <           if (map_image->pixels == (RunlengthPacket *) NULL)G             Error("Unable to dither image","Memory allocation failed");            /*&             Initialize colormap image.           */           p=map_image->pixels;+           for (i=0; i < number_colors; i++)+           {[             p->red=0;u'             if (map_info->red_max != 0) $               p->red=(unsigned char)D                 (((i/map_info->red_mult)*MaxRGB)/map_info->red_max);             p->green=0; )             if (map_info->green_max != 0)uD               p->green=(unsigned char) ((((i/map_info->green_mult) %F                 (map_info->green_max+1))*MaxRGB)/map_info->green_max);             p->blue=0;(             if (map_info->blue_max != 0)%               p->blue=(unsigned char)bI                 (((i % map_info->green_mult)*MaxRGB)/map_info->blue_max);              p->index=0;;             p->length=0;             p++;           } )           MapImage(image,map_image,True);)I           XGetPixelInfo(display,visual_info,map_info,resource_info,image,a             pixel_info);#           image->class=DirectClass; "           DestroyImage(map_image);	         }n       if (resource_info->debug) 	         { 8           (void) fprintf(stderr,"Standard Colormap:\n");M           (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap); H           (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",F             map_info->red_max,map_info->green_max,map_info->blue_max);I           (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",pI             map_info->red_mult,map_info->green_mult,map_info->blue_mult);c	         }m
       return;      } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))%(     if ((image->class == DirectClass) ||5         (image->colors > visual_info->colormap_size))        { 
         /*9           Image has more colors than the visual supports. 
         */F         QuantizeImage(image,(unsigned int) visual_info->colormap_size,:           resource_info->tree_depth,resource_info->dither,%           resource_info->colorspace); ?         image->class=DirectClass;  /* promote to DirectClass */        }    /**     Free previous and create new colormap.   */A   XFreeStandardColormap(display,visual_info,map_info,pixel_info); 9   colormap=XDefaultColormap(display,visual_info->screen);%I   if (visual_info->visual != XDefaultVisual(display,visual_info->screen))iN     colormap=XCreateColormap(display,XRootWindow(display,visual_info->screen),=       visual_info->visual,visual_info->class == DirectColor ?X       AllocAll : AllocNone);"   if (colormap == (Colormap) NULL)5     Error("Unable to create colormap",(char *) NULL);i   /*1     Initialize the map and pixel info structures.n   */-   XGetMapInfo(visual_info,colormap,map_info);cM   XGetPixelInfo(display,visual_info,map_info,resource_info,image,pixel_info);    /*B     Allocating colors in server colormap is based on visual class.   */   switch (visual_info->class)    {r     case StaticGray:     case StaticColor:e     {)       /*F         Define Standard Colormap for StaticGray or StaticColor visual.       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       p=colors;f+       color.flags=DoRed | DoGreen | DoBlue;u,       if (visual_info->class == StaticColor))         for (i=0; i < image->colors; i++)%	         {%C           color.red=(unsigned short) (image->colormap[i].red << 8); G           color.green=(unsigned short) (image->colormap[i].green << 8); E           color.blue=(unsigned short) (image->colormap[i].blue << 8); 6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             { >               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color); 
             } ,           pixel_info->pixels[i]=color.pixel;           *p++=color; 	         } 
       else)         for (i=0; i < image->colors; i++) 	         { 3           gray_value=Intensity(image->colormap[i]);%7           color.red=(unsigned short) (gray_value << 8); 9           color.green=(unsigned short) (gray_value << 8);f8           color.blue=(unsigned short) (gray_value << 8);6           status=XAllocColor(display,colormap,&color);           if (status == 0)
             { >               colormap=XCopyColormapAndFree(display,colormap);3               XAllocColor(display,colormap,&color); 
             }p,           pixel_info->pixels[i]=color.pixel;           *p++=color;u	         }c       break;     }e     case GrayScale:.     case PseudoColor:I     {y       unsigned int         colormap_type;         /*E         Define Standard Colormap for GrayScale or PseudoColor visual.a       */"       number_colors=image->colors;J       colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*#         Preallocate our GUI colors./       */I       (void) XAllocColor(display,colormap,&pixel_info->foreground_color);iI       (void) XAllocColor(display,colormap,&pixel_info->background_color); E       (void) XAllocColor(display,colormap,&pixel_info->border_color);nD       (void) XAllocColor(display,colormap,&pixel_info->matte_color);H       (void) XAllocColor(display,colormap,&pixel_info->highlight_color);E       (void) XAllocColor(display,colormap,&pixel_info->shadow_color);iD       (void) XAllocColor(display,colormap,&pixel_info->depth_color);E       (void) XAllocColor(display,colormap,&pixel_info->trough_color); '       for (i=0; i < MaxNumberPens; i++) G         (void) XAllocColor(display,colormap,&pixel_info->pen_color[i]);i       /*D         Determine if image colors will "fit" into X server colormap.       */,       colormap_type=resource_info->colormap;N       status=XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0,*         pixel_info->pixels,image->colors);       if (status != 0)&         colormap_type=PrivateColormap;*       if (colormap_type == SharedColormap)	         {(           DiversityPackete             *diversity;w  "           register RunlengthPacket             *q;i             unsigned short             index;             /*P             Define Standard colormap for shared GrayScale or PseudoColor visual:           */'           diversity=(DiversityPacket *) :             malloc(image->colors*sizeof(DiversityPacket));4           if (diversity == (DiversityPacket *) NULL)J             Error("Unable to create colormap","Memory allocation failed");+           for (i=0; i < image->colors; i++)            {(4             diversity[i].red=image->colormap[i].red;8             diversity[i].green=image->colormap[i].green;6             diversity[i].blue=image->colormap[i].blue;2             diversity[i].index=(unsigned short) i;!             diversity[i].count=0;%           }            q=image->pixels;,           for (i=0; i < image->packets; i++)           { 5             diversity[q->index].count+=(q->length+1);              q++;           }            /*0             Sort colors by decreasing intensity.           */P           (void) qsort((void *) diversity,image->colors,sizeof(DiversityPacket),O             (int (*) _Declare((const void *, const void *))) IntensityCompare); D           for (i=0; i < image->colors; i+=Max(image->colors >> 4,2))J             diversity[i].count<<=4;  /* increase this colors popularity *//           diversity[image->colors-1].count<<=4;%P           (void) qsort((void *) diversity,image->colors,sizeof(DiversityPacket),P             (int (*) _Declare((const void *, const void *))) PopularityCompare);           /*             Allocate colors.           */           p=colors; /           color.flags=DoRed | DoGreen | DoBlue; 0           if (visual_info->class == PseudoColor)-             for (i=0; i < image->colors; i++) 
             { '               index=diversity[i].index;sK               color.red=(unsigned short) (image->colormap[index].red << 8);_O               color.green=(unsigned short) (image->colormap[index].green << 8);aM               color.blue=(unsigned short) (image->colormap[index].blue << 8);u:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color; 
             }            else-             for (i=0; i < image->colors; i++)_
             {!'               index=diversity[i].index;o;               gray_value=Intensity(image->colormap[index]); ;               color.red=(unsigned short) (gray_value << 8);f=               color.green=(unsigned short) (gray_value << 8);><               color.blue=(unsigned short) (gray_value << 8);:               status=XAllocColor(display,colormap,&color);               if (status == 0)                 break;4               pixel_info->pixels[index]=color.pixel;               *p++=color;)
             }             if (i < image->colors)
             {                register int                 j;                 XColor                 *server_colors;L                 /*'                 Read X server colormap.%               */&               server_colors=(XColor *)B                 malloc(visual_info->colormap_size*sizeof(XColor));3               if (server_colors == (XColor *) NULL) N                 Error("Unable to create colormap","Memory allocation failed");<               for (j=0; j < visual_info->colormap_size; j++)9                 server_colors[j].pixel=(unsigned long) j; :               XQueryColors(display,colormap,server_colors,;                 (int) Min(visual_info->colormap_size,256));                /*?                 Select remaining colors from X server colormap.                */4               if (visual_info->class == PseudoColor).                 for (; i < image->colors; i++)                 {e+                   index=diversity[i].index; O                   color.red=(unsigned short) (image->colormap[index].red << 8);(.                   color.green=(unsigned short)8                     (image->colormap[index].green << 8);-                   color.blue=(unsigned short) 7                     (image->colormap[index].blue << 8);a<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;n                 }                else.                 for (; i < image->colors; i++)                 {o+                   index=diversity[i].index; ?                   gray_value=Intensity(image->colormap[index]);%?                   color.red=(unsigned short) (gray_value << 8);%A                   color.green=(unsigned short) (gray_value << 8); @                   color.blue=(unsigned short) (gray_value << 8);<                   XBestPixel(display,colormap,server_colors,F                     (unsigned int) visual_info->colormap_size,&color);8                   pixel_info->pixels[index]=color.pixel;                   *p++=color;                  } =               if (image->colors < visual_info->colormap_size)                  {                    /*G                     Fill up colors array-- more choices for pen colors.                    */                    retain_colors=F                     Min(visual_info->colormap_size-image->colors,256);3                   for (i=0; i < retain_colors; i++) *                     *p++=server_colors[i];/                   number_colors+=retain_colors;l                 } 2               (void) free((char *) server_colors);
             }:*           (void) free((char *) diversity);           break;	         }c       /*M         Define Standard colormap for private GrayScale or PseudoColor visual.        */       if (status == 0)	         {1           /*P             Not enough colormap entries in the colormap-- Create a new colormap.           */+           colormap=XCreateColormap(display,SI             XRootWindow(display,visual_info->screen),visual_info->visual,              AllocNone);a*           if (colormap == (Colormap) NULL)=             Error("Unable to create colormap",(char *) NULL);(&           map_info->colormap=colormap;9           if (image->colors < visual_info->colormap_size)_
             {                /*K                 Retain colors from the default colormap to help lessens ther-                 effects of colormap flashing.f               */N               retain_colors=Min(visual_info->colormap_size-image->colors,256);%               p=colors+image->colors;e/               for (i=0; i < retain_colors; i++)_               { +                 p->pixel=(unsigned long) i;                  p++;               })#               XQueryColors(display,0>                 XDefaultColormap(display,visual_info->screen),:                 colors+image->colors,(int) retain_colors);               /*A                 Transfer colors from default to private colormap.                */O               XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0, 2                 pixel_info->pixels,retain_colors);%               p=colors+image->colors; /               for (i=0; i < retain_colors; i++)                { /                 p->pixel=pixel_info->pixels[i];                  p++;               } P               XStoreColors(display,colormap,colors+image->colors,retain_colors);+               number_colors+=retain_colors; 
             } K           XAllocColorCells(display,colormap,False,(unsigned long *) NULL,0, .             pixel_info->pixels,image->colors);	         }%       /*!         Store the image colormap.t       */       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;t,       if (visual_info->class == PseudoColor))         for (i=0; i < image->colors; i++)p	         {hC           color.red=(unsigned short) (image->colormap[i].red << 8); G           color.green=(unsigned short) (image->colormap[i].green << 8); E           color.blue=(unsigned short) (image->colormap[i].blue << 8); ,           color.pixel=pixel_info->pixels[i];           *p++=color;n	         }=
       else)         for (i=0; i < image->colors; i++) 	         {%3           gray_value=Intensity(image->colormap[i]);%7           color.red=(unsigned short) (gray_value << 8); 9           color.green=(unsigned short) (gray_value << 8); 8           color.blue=(unsigned short) (gray_value << 8);,           color.pixel=pixel_info->pixels[i];           *p++=color; 	         } :       XStoreColors(display,colormap,colors,image->colors);       break;     }      case TrueColor:      case DirectColor:      default:     {        unsigned int         linear_colormap;         /*E         Define Standard Colormap for TrueColor or DirectColor visual.        */K       number_colors=(unsigned int) ((map_info->red_max*map_info->red_mult)+%3         (map_info->green_max*map_info->green_mult)+ 4         (map_info->blue_max*map_info->blue_mult)+1);/       linear_colormap=(number_colors > 4096) ||nA         (((map_info->red_max+1) == visual_info->colormap_size) &&fC          ((map_info->green_max+1) == visual_info->colormap_size) && A          ((map_info->blue_max+1) == visual_info->colormap_size));n       if (linear_colormap)1         number_colors=visual_info->colormap_size;p       /*         Allocate color array.r       */=       colors=(XColor *) malloc(number_colors*sizeof(XColor));a$       if (colors == (XColor *) NULL)F         Error("Unable to create colormap","Memory allocation failed");       /*%         Initialize linear color ramp.r       */       p=colors; +       color.flags=DoRed | DoGreen | DoBlue;c       if (linear_colormap))         for (i=0; i < number_colors; i++)i	         {r(           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short) F               (((i % map_info->green_mult)*65535)/map_info->blue_max);!           color.green=color.blue;f           color.red=color.blue; 8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;u	         } 
       else)         for (i=0; i < number_colors; i++)o	         { '           color.red=(unsigned short) 0;o%           if (map_info->red_max != 0),&             color.red=(unsigned short)A               (((i/map_info->red_mult)*65535)/map_info->red_max);,)           color.green=(unsigned short) 0; '           if (map_info->green_max != 0) F             color.green=(unsigned short) ((((i/map_info->green_mult) %C               (map_info->green_max+1))*65535)/map_info->green_max); (           color.blue=(unsigned short) 0;&           if (map_info->blue_max != 0)'             color.blue=(unsigned short)nF               (((i % map_info->green_mult)*65535)/map_info->blue_max);8           color.pixel=XStandardPixel(map_info,color,16);           *p++=color;l	         }o0       if ((visual_info->class == DirectColor) &&F           (colormap != XDefaultColormap(display,visual_info->screen)))<         XStoreColors(display,colormap,colors,number_colors);
       else)         for (i=0; i < number_colors; i++)i3           XAllocColor(display,colormap,&colors[i]);o       break;     }=   } O   if ((visual_info->class != DirectColor) && (visual_info->class != TrueColor))      {n       /*8         Set foreground, background, border, etc. pixels.       */7       XBestPixel(display,colormap,colors,number_colors,d'         &pixel_info->foreground_color);r7       XBestPixel(display,colormap,colors,number_colors,,'         &pixel_info->background_color);o/       if (pixel_info->background_color.pixel ==a-           pixel_info->foreground_color.pixel)i	         {o           /*9             Foreground and background colors must differ.r           */O           pixel_info->background_color.red=(~pixel_info->foreground_color.red);x-           pixel_info->background_color.green= 2             (~pixel_info->foreground_color.green);,           pixel_info->background_color.blue=1             (~pixel_info->foreground_color.blue);,;           XBestPixel(display,colormap,colors,number_colors,l+             &pixel_info->background_color);l	         }e7       XBestPixel(display,colormap,colors,number_colors, #         &pixel_info->border_color);d7       XBestPixel(display,colormap,colors,number_colors,d"         &pixel_info->matte_color);7       XBestPixel(display,colormap,colors,number_colors,G&         &pixel_info->highlight_color);7       XBestPixel(display,colormap,colors,number_colors,d#         &pixel_info->shadow_color);c7       XBestPixel(display,colormap,colors,number_colors,o"         &pixel_info->depth_color);7       XBestPixel(display,colormap,colors,number_colors,r#         &pixel_info->trough_color);e'       for (i=0; i < MaxNumberPens; i++)r       { 9         XBestPixel(display,colormap,colors,number_colors,s%           &pixel_info->pen_color[i]); K         pixel_info->pixels[image->colors+i]=pixel_info->pen_color[i].pixel;o       }o5       pixel_info->colors=image->colors+MaxNumberPens;o     }    (void) free((char *) colors);i   if (resource_info->debug)o     {t4       (void) fprintf(stderr,"Standard Colormap:\n");I       (void) fprintf(stderr,"  colormap id: 0x%lx\n",map_info->colormap);iD       (void) fprintf(stderr,"  red, green, blue max: %lu %lu %lu\n",B         map_info->red_max,map_info->green_max,map_info->blue_max);E       (void) fprintf(stderr,"  red, green, blue mult: %lu %lu %lu\n",bE         map_info->red_mult,map_info->green_mult,map_info->blue_mult);f     }_ }o i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %iO %                                                                             %eO %                                                                             %lO %   X M a k e W i n d o w                                                     %lO %                                                                             %|O %                                                                             %eO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %f. %  Function XMakeWindow creates an X11 window. %>, %  The format of the XMakeWindow routine is: %iE %      XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,r %        window_info)  %e+ %  A description of each parameter follows:c %rD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %(0 %    o parent: Specifies the parent window_info. %r7 %    o argv: Specifies the application's argument list.u % / %    o argc: Specifies the number of arguments.r %xE %    o class_hint: Specifies a pointer to a X11 XClassHint structure.f %sF %    o manager_hints: Specifies a pointer to a X11 XWMHints structure. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.l %[ %& */O void XMakeWindow(display,parent,argv,argc,class_hint,manager_hints,window_info)n Display,   *display;l   Window	   parent;    char	   **argv;    int    argc;(  
 XClassHint   *class_hint;   XWMHints   *manager_hints;;   XWindowInfoo   *window_info;x {  #define MinWindowSize  64i     Atom     atom_list[2];1     int      gravity,     status;a     XSizeHints     *size_hints;     XTextPropertyo     icon_name,     window_name;     /*     Set window_info hints.   */   size_hints=XAllocSizeHints();)(   if (size_hints == (XSizeHints *) NULL)@     Error("Unable to make X window","Memory allocation failed");'   size_hints->flags=window_info->flags;    size_hints->x=window_info->x;d   size_hints->y=window_info->y;['   size_hints->width=window_info->width;n)   size_hints->height=window_info->height;e   size_hints->flags|=PMinSize;   if (window_info->immutable)o     {s       /*&         Window size cannot be changed.       */.       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;"       size_hints->flags|=PMaxSize;     }    else     {        /*#         Window size can be changed.        */3       size_hints->min_width=window_info->min_width; 5       size_hints->min_height=window_info->min_height; $       size_hints->flags|=PResizeInc;3       size_hints->width_inc=window_info->width_inc; 5       size_hints->height_inc=window_info->height_inc;  #ifndef PRE_R4_ICCCM#       size_hints->flags|=PBaseSize; 3       size_hints->base_width=size_hints->width_inc;%5       size_hints->base_height=size_hints->height_inc;o #endif     }e   gravity=NorthWestGravity;i-   if (window_info->geometry != (char *) NULL)e     {r
       char(         default_geometry[MaxTextLength],          geometry[MaxTextLength];  	       int          flags;         register char          *p;e         /*          User specified geometry.       */@       (void) sprintf(default_geometry,"%dx%d",size_hints->width,         size_hints->height);4       (void) strcpy(geometry,window_info->geometry);       p=geometry; !       while ((int) strlen(p) > 0)i       {t(         if (!isspace(*p) && (*p != '%'))           p++;         else           (void) strcpy(p,p+1);X       }nN       flags=XWMGeometry(display,window_info->screen,geometry,default_geometry,K         window_info->border_width,size_hints,&size_hints->x,&size_hints->y, 9         &size_hints->width,&size_hints->height,&gravity); 8       if ((flags & WidthValue) && (flags & HeightValue))"         size_hints->flags|=USSize;/       if ((flags & XValue) && (flags & YValue))r	         {r(           size_hints->flags|=USPosition;'           window_info->x=size_hints->x; '           window_info->y=size_hints->y; 	         }e     }  #ifndef PRE_R4_ICCCM"   size_hints->win_gravity=gravity;!   size_hints->flags|=PWinGravity;x #endif'   if (window_info->id == (Window) NULL) O     window_info->id=XCreateWindow(display,parent,window_info->x,window_info->y,cG       window_info->width,window_info->height,window_info->border_width,wK       window_info->depth,InputOutput,window_info->visual,window_info->mask,         &window_info->attributes);   else     {n       unsigned int
         mask;r         XEvent         sans_event;e         XWindowChanges         window_changes;c         /*;         Window already exists;  change relevant attributes.        */H       XChangeWindowAttributes(display,window_info->id,window_info->mask,"         &window_info->attributes);       mask=ConfigureNotify;)O       while (XCheckTypedWindowEvent(display,window_info->id,mask,&sans_event)); &       window_changes.x=window_info->x;&       window_changes.y=window_info->y;.       window_changes.width=window_info->width;0       window_changes.height=window_info->height;       mask=CWWidth | CWHeight;*       if (window_info->flags & USPosition)         mask|=CWX | CWY;L       XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,         &window_changes);r     }_'   if (window_info->id == (Window) NULL) 7     Error("Unable to create window",window_info->name);sF   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status == 0)>     Error("Unable to create text property",window_info->name);I   status=XStringListToTextProperty(&window_info->icon_name,1,&icon_name);    if (status == 0)C     Error("Unable to create text property",window_info->icon_name); 2   if (window_info->icon_geometry != (char *) NULL)     { 	       int          flags,         gravity,         height,          width;         /*%         User specified icon geometry.        */$       size_hints->flags|=USPosition;O       flags=XWMGeometry(display,window_info->screen,window_info->icon_geometry, :         (char *) NULL,0,size_hints,&manager_hints->icon_x,8         &manager_hints->icon_y,&width,&height,&gravity);/       if ((flags & XValue) && (flags & YValue))t/         manager_hints->flags|=IconPositionHint;      }rM   XSetWMProperties(display,window_info->id,&window_name,&icon_name,argv,argc,u)     size_hints,manager_hints,class_hint);r=   atom_list[0]=XInternAtom(display,"WM_DELETE_WINDOW",False); :   atom_list[1]=XInternAtom(display,"WM_TAKE_FOCUS",False);7   XSetWMProtocols(display,window_info->id,atom_list,2);n   XFree((void *) size_hints);i }n   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %XO %                                                                             %oO %                                                                             % O %   X M o n t a g e I m a g e                                                 % O %                                                                             % O %                                                                             %*O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %rH %  Function XMontageImage creates a composite image by combining several %  separate images.c %o. %  The format of the XMontageImage routine is: %uH %      XMontageImage(display,resource_info,montage_info,filename,images) %_+ %  A description of each parameter follows:g %nE %    o display: Specifies a connection to an X server;  returned froma %      XOpenDisplay. %,K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %dD %    o montage_info: Specifies a pointer to a MontageInfo structure. %t9 %    o filename: Specifies the name of the montage image.l %(B %    o image: Specifies a pointer to an array of Image structures. %c %r */   static int SceneCompare(x,y)
 const void   *x,e   *y;v {e   Image      **image_1,     **image_2;     image_1=(Image **) x;o   image_2=(Image **) y;a:   return((int) (*image_1)->scene-(int) (*image_2)->scene); }(  H Image *XMontageImage(display,resource_info,montage_info,filename,images) Displayp   *display;a  
 XResourceInfoe   *resource_info;r   XMontageInfo   *montage_info;   char   *filename;   Imagei   **images;o {,
   ColorPacketr     border_color,o     highlight_color,     matte_color,     shadow_color;r     Imageo     *image,,     *montage_image;c     int;     x,
     x_offset,r     y,
     y_offset;c     register charp     *q;"     register int     i;     register RunlengthPacket     *p;a     RectangleInfoo     label_info,r     tile_info;     unsigned int     border_width,l     bevel_width,
     count,     max_width,     number_images,     number_tiles,p     status,s	     tile,f     tiles_per_column,e     tiles_per_row;     XAnnotateInfo-     annotate_info;     XColor     background_color;e  
   XFontStruct0     *font_info;i     XPixelInfo     pixel_info;      XStandardColormap,     *map_info;  
   XVisualInfor     *visual_info;=     /**     Sort images by increasing tile number.   */*   number_tiles=montage_info->number_tiles;
   count=0;+   for (tile=0; tile < number_tiles; tile++)_     count+=images[tile]->scene;e   if (count != 0)m>     (void) qsort((void *) images,number_tiles,sizeof(Image *),E       (int (*) _Declare((const void *, const void *))) SceneCompare);    /*'     Determine tiles per row and column.    */   tiles_per_row=1;   tiles_per_column=1;e9   while ((tiles_per_row*tiles_per_column) < number_tiles)o   {v     tiles_per_row++;     tiles_per_column++;s   }o*   if (montage_info->tile != (char *) NULL)     {o2       tiles_per_column=montage_info->number_tiles;P       XParseGeometry(montage_info->tile,&x,&y,&tiles_per_row,&tiles_per_column);     }U   /*     Determine tile sizes.0   */   border_width=0;("   if (display != (Display *) NULL)     {d/       border_width=resource_info->border_width;o       if (montage_info->frame)	         {n,           bevel_width=(border_width >> 2)+1;)           border_width+=bevel_width << 1;,	         },     },*   tile_info.x=resource_info->border_width;*   tile_info.y=resource_info->border_width;5   if (resource_info->image_geometry != (char *) NULL)      {tM       XParseGeometry(resource_info->image_geometry,&tile_info.x,&tile_info.y,f,         &tile_info.width,&tile_info.height);       if (tile_info.x < 0)         tile_info.x=0;       if (tile_info.y < 0)         tile_info.y=0;     }t%   tile_info.width=images[0]->columns; #   tile_info.height=images[0]->rows;G9   for (tile=1; tile < montage_info->number_tiles; tile++)0   { 0     if (images[tile]->columns > tile_info.width),       tile_info.width=images[tile]->columns;.     if (images[tile]->rows > tile_info.height)*       tile_info.height=images[tile]->rows;   }0   /*     Initialize tile colors.g   */   background_color.red=0;r   background_color.green=0;t   background_color.blue=0;   border_color.red=0;f   border_color.green=0;u   border_color.blue=0;   highlight_color=border_color;r   shadow_color=border_color;#   XGetAnnotateInfo(&annotate_info);r"   if (display != (Display *) NULL)     {        /*         Initialize visual info.i       */(       map_info=XAllocStandardColormap();1       if (map_info == (XStandardColormap *) NULL)r	         {t7           Warning("Unable to create standard colormap",h(             "Memory allocation failed");!           return((Image *) NULL);e	         }iB       visual_info=XBestVisualInfo(display,map_info,resource_info);)       map_info->colormap=(Colormap) NULL;r/       pixel_info.pixels=(unsigned long *) NULL;)       /*         Initialize font info.a       */7       font_info=XBestFont(display,resource_info,False);oE       annotate_info.text=(char *) malloc(MaxTextLength*sizeof(char));_2       if ((visual_info == (XVisualInfo *) NULL) ||0           (font_info == (XFontStruct *) NULL) ||0           (annotate_info.text == (char *) NULL))	         {(I           Warning("Unable to montage images","Memory allocation failed");u!           return((Image *) NULL);u	         }o(       annotate_info.font_info=font_info;@       annotate_info.height=font_info->ascent+font_info->descent;       /*/         Determine background and border colors.(       */L       XGetMapInfo(visual_info,XDefaultColormap(display,visual_info->screen),         map_info);N       XGetPixelInfo(display,visual_info,map_info,resource_info,(Image *) NULL,         &pixel_info);b3       background_color=pixel_info.background_color;i?       border_color.red=ColorShift(pixel_info.border_color.red);GC       border_color.green=ColorShift(pixel_info.border_color.green);cA       border_color.blue=ColorShift(pixel_info.border_color.blue);e=       matte_color.red=ColorShift(pixel_info.matte_color.red);oA       matte_color.green=ColorShift(pixel_info.matte_color.green);o?       matte_color.blue=ColorShift(pixel_info.matte_color.blue);-E       highlight_color.red=ColorShift(pixel_info.highlight_color.red);mI       highlight_color.green=ColorShift(pixel_info.highlight_color.green);rG       highlight_color.blue=ColorShift(pixel_info.highlight_color.blue);m?       shadow_color.red=ColorShift(pixel_info.shadow_color.red);rC       shadow_color.green=ColorShift(pixel_info.shadow_color.green);rA       shadow_color.blue=ColorShift(pixel_info.shadow_color.blue);m     }    /*     Allocate image structure.o   */2   montage_image=AllocateImage((ImageInfo *) NULL);&   if (montage_image == (Image *) NULL)     {eE       Warning("Unable to montage images","Memory allocation failed");m       return((Image *) NULL);i     }n   montage_image->scene=1;e   number_images=F     (montage_info->number_tiles-1)/(tiles_per_row*tiles_per_column)+1;#   for (i=0; i < number_images; i++)l   {n     /*!       Initialize Image structure.c     */4     (void) strcpy(montage_image->filename,filename);     montage_image->columns=iC       (tile_info.width+(tile_info.x+border_width)*2)*tiles_per_row;mP     number_tiles=Min(montage_info->number_tiles,tiles_per_row*tiles_per_column);G     montage_image->rows=(tile_info.height+(tile_info.y+border_width)*2+ .       (display ? annotate_info.height+4 : 0))*J       (number_tiles/tiles_per_row+ ((number_tiles % tiles_per_row) != 0));.     if (resource_info->title != (char *) NULL)N       montage_image->rows+=((annotate_info.height+4) << 1)+(tile_info.y << 1);G     montage_image->montage=(char *) malloc(MaxTextLength*sizeof(char));s     count=1;-     for (tile=0; tile < number_tiles; tile++)).       count+=strlen(images[tile]->filename)+1;A     montage_image->directory=(char *) malloc(count*sizeof(char));;F     montage_image->packets=montage_image->columns*montage_image->rows;-     montage_image->pixels=(RunlengthPacket *)eL       malloc((unsigned int) montage_image->packets*sizeof(RunlengthPacket));4     if ((montage_image->montage == (char *) NULL) ||6         (montage_image->directory == (char *) NULL) ||<         (montage_image->pixels == (RunlengthPacket *) NULL))       {oG         Warning("Unable to montage images","Memory allocation failed");p%         DestroyImages(montage_image);=         return((Image *) NULL);e       }      /*       Set montage geometry.s     */     x_offset=0;a     y_offset=0;e.     if (resource_info->title != (char *) NULL)C       y_offset+=((annotate_info.height+4) << 1)+(tile_info.y << 1);i#     *montage_image->directory='\0';e8     (void) sprintf(montage_image->montage,"%dx%d%+d%+d",;       (int) (tile_info.width+(tile_info.x+border_width)*2),v;       (int) (tile_info.height+(tile_info.y+border_width)*2+tA       (display ? annotate_info.height+4 : 0)),x_offset,y_offset);;     /*3       Initialize montage image to background color.d     */     p=montage_image->pixels;.     for (x=0; x < montage_image->packets; x++)     { .       p->red=ColorShift(background_color.red);2       p->green=ColorShift(background_color.green);0       p->blue=ColorShift(background_color.blue);       p->index=0;r       p->length=0;
       p++;     } (     if ((display != (Display *) NULL) &&0         (resource_info->title != (char *) NULL))       {2
         /*,           Copy title to the composite image.
         */?         (void) strcpy(annotate_info.text,resource_info->title);%         annotate_info.width=N           XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));)         max_width=montage_image->columns; D         if (((annotate_info.width+tile_info.x*2) << 1) >= max_width)           {              /**               Label is too wide-- shorten.             */<             q=annotate_info.text+strlen(annotate_info.text);             do
             {                *--q='\0';7               if ((int) strlen(annotate_info.text) > 2) )                 (void) strcpy(q-2,"..."); J               annotate_info.width=XTextWidth(font_info,annotate_info.text,,                 strlen(annotate_info.text));P             } while ((2*(annotate_info.width+(tile_info.x << 1))) >= max_width);           } 6         label_info.width=(annotate_info.width << 1)-1;8         label_info.height=(annotate_info.height << 1)-1;E         label_info.x=tile_info.x+(int) (montage_image->columns >> 1)-e$           (int) annotate_info.width;#         label_info.y=tile_info.y+4;d<         (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",H           label_info.width,label_info.height,label_info.x,label_info.y);F         (void) XAnnotateImage(display,&pixel_info,&annotate_info,True,           montage_image);        }s     /*.       Copy tile images to the composite image.     */     x_offset=tile_info.x;c     y_offset=tile_info.y;a$     if (display != (Display *) NULL)0       if (resource_info->title != (char *) NULL)E         y_offset+=((annotate_info.height+4) << 1)+(tile_info.y << 1); #     *montage_image->directory='\0';t-     for (tile=0; tile < number_tiles; tile++)      {t       /*.         Copy this tile to the composite image.       */       image=images[tile];m>       (void) strcat(montage_image->directory,image->filename);3       (void) strcat(montage_image->directory,"\n");;)       status=RunlengthDecodeImage(image);o       if (status == False)	         { <           Warning("Unable to unpack image",image->filename);'           DestroyImages(montage_image);s!           return((Image *) NULL);'	         }(?       if ((display != (Display *) NULL) && (border_width != 0))%	         {a           ColorPacketX             black;             Imageh             *bordered_image;             RectangleInfo(             border_info;             /**             Put a border around the image.           */+           border_info.width=border_width-1;%,           border_info.height=border_width-1;"           if (montage_info->frame)
             { H               border_info.width=(tile_info.width-image->columns+1) >> 1;G               border_info.height=(tile_info.height-image->rows+1) >> 1; 
             } G           bordered_image=BorderImage(image,&border_info,&border_color); /           if (bordered_image != (Image *) NULL) 
             { "               DestroyImage(image);#               image=bordered_image; 
             }            border_info.width=1;           border_info.height=1;            black.red=0;           black.green=0;           black.blue=0;%@           bordered_image=BorderImage(image,&border_info,&black);/           if (bordered_image != (Image *) NULL)t
             {s"               DestroyImage(image);#               image=bordered_image;i
             } 	         }G       /*9         Gravitate image as specified by the tile gravity.f       */%       switch (resource_info->gravity)o       {n         case NorthWestGravity:	         {o           x=0;           y=0;           break;	         }          case NorthGravity:	         {tH           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;           y=0;           break;	         }h         case NorthEastGravity:	         { A           x=(tile_info.width+(border_width << 1))-image->columns;            y=0;           break;	         }          case WestGravity: 	         {;           x=0;F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }          case ForgetGravity:W         case StaticGravity:a         case CenterGravity:e         default:	         { H           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }r         case EastGravity: 	         {tA           x=(tile_info.width+(border_width << 1))-image->columns; F           y=((tile_info.height+(border_width << 1))-image->rows) >> 1;           break;	         }          case SouthWestGravity:	         {W           x=0;?           y=(tile_info.height+(border_width << 1))-image->rows;            break;	         }n         case SouthGravity:	         {nH           x=((tile_info.width+(border_width << 1))-image->columns) >> 1;?           y=(tile_info.height+(border_width << 1))-image->rows;u           break;	         }d         case SouthEastGravity:	         {(A           x=(tile_info.width+(border_width << 1))-image->columns;&?           y=(tile_info.height+(border_width << 1))-image->rows;l           break;	         }=       }        if (montage_info->frame)3         if ((tile_info.x > 4) && (tile_info.y > 4))(           {*             Imager               *framed_image;               RectangleInfoi               frame_info;e               /*8               Put an ornamental border around this tile.             */A             frame_info.width=tile_info.width+(border_width << 1); C             frame_info.height=tile_info.height+(border_width << 1)+ '               (annotate_info.height+4); 4             frame_info.x=(x > 0 ? x : border_width);4             frame_info.y=(y > 0 ? y : border_width);O             framed_image=FrameImage(image,&frame_info,bevel_width,&matte_color, .               &highlight_color,&shadow_color);/             if (framed_image != (Image *) NULL)                { $                 DestroyImage(image);#                 image=framed_image;                }              x=0;             y=0;           }%       /*3         Composite background image with tile image.i       */?       CompositeImage(montage_image,montage_info->compose,image,t         x_offset+x,y_offset+y);h@       if ((display != (Display *) NULL) && montage_info->shadow)	         {g           register int             columns,             rows,              shift;             /*6             Put a shadow under the tile to show depth.           */2           for (rows=0; rows < image->rows; rows++)           {fO             p=montage_image->pixels+montage_image->columns*(y_offset+y+rows+4)+ (               x_offset+x+image->columns;3             for (columns=0; columns < 4; columns++)u
             { 7               shift=((columns+rows) % 2) == 0 ? 9 : 10; 3               p->red=background_color.red >> shift;f7               p->green=background_color.green >> shift;t5               p->blue=background_color.blue >> shift;e               p++;
             }            }t(           for (rows=0; rows < 4; rows++)           { ;             p=montage_image->pixels+montage_image->columns*o9               (y_offset+y+image->rows+rows)+x_offset+x+4; @             for (columns=0; columns < image->columns; columns++)
             {t7               shift=((columns+rows) % 2) == 0 ? 9 : 10;a3               p->red=background_color.red >> shift;y7               p->green=background_color.green >> shift;e5               p->blue=background_color.blue >> shift;o               p++;
             }r           }r	         }tK       if ((display != (Display *) NULL) && (image->label != (char *) NULL))n	         {            /*3             Copy tile label to the composite image.i           */9           (void) strcpy(annotate_info.text,image->label);            annotate_info.width=P             XTextWidth(font_info,annotate_info.text,strlen(annotate_info.text));I           max_width=tile_info.width+(resource_info->border_width << 1)-8;l/           if (annotate_info.width >= max_width) 
             {                /*,                 Label is too wide-- shorten.               */>               q=annotate_info.text+strlen(annotate_info.text);               do               {v                 *--q='\0';9                 if ((int) strlen(annotate_info.text) > 2)f+                   (void) strcpy(q-2,"...");_L                 annotate_info.width=XTextWidth(font_info,annotate_info.text,.                   strlen(annotate_info.text));9               } while (annotate_info.width >= max_width);a
             }e/           label_info.width=annotate_info.width;s1           label_info.height=annotate_info.height;pM           label_info.x=x_offset+((tile_info.width+(border_width << 1)) >> 1)-g'             (annotate_info.width >> 1);r            label_info.y=y_offset;#           if (!montage_info->frame) 6             label_info.y+=y+tile_info.y+image->rows+2;           elseM             label_info.y+=tile_info.height+(border_width << 1)-bevel_width-2; >           (void) sprintf(annotate_info.geometry,"%ux%u%+d%+d",J             label_info.width,label_info.height,label_info.x,label_info.y);C           (void) XAnnotateImage(display,&pixel_info,&annotate_info,e0             !montage_info->frame,montage_image);	         }        DestroyImage(image);*       if (((tile+1) % tiles_per_row) != 0)?         x_offset+=tile_info.width+(tile_info.x+border_width)*2; 
       else	         {i           x_offset=tile_info.x;rB           y_offset+=tile_info.height+(tile_info.y+border_width)*2+3             (display ? annotate_info.height+4 : 0);o	         }i     }i     if (i < (number_images-1))       {s
         /*(           Allocate next image structure.
         */>         montage_image->next=AllocateImage((ImageInfo *) NULL);2         if (montage_image->next == (Image *) NULL)           {n)             DestroyImages(montage_image); #             return((Image *) NULL);h           } >         (void) strcpy(montage_image->next->filename,filename);6         montage_image->next->file=montage_image->file;:         montage_image->next->scene=montage_image->scene+1;4         montage_image->next->previous=montage_image;*         montage_image=montage_image->next;         images+=number_tiles;a1         montage_info->number_tiles-=number_tiles;d       }    }o+   (void) free((char *) annotate_info.text);a"   if (display != (Display *) NULL)     {o       /*         Free X resources.o       */#       XFreeFont(display,font_info); "       XFree((char *) visual_info);       XFree((char *) map_info);n     } 3   while (montage_image->previous != (Image *) NULL)_*     montage_image=montage_image->previous;   return(montage_image); }e n /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             %pO %                                                                             %yO %                                                                             %ZO %   X R e f r e s h W i n d o w                                               %rO %                                                                             %rO %                                                                             %cO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %n< %  Function XRefreshWindow refreshes an image in a X window. % / %  The format of the XRefreshWindow routine is:L % + %      XRefreshWindow(display,window,event)  %d+ %  A description of each parameter follows:( %lE %    o display: Specifies a connection to an X server;  returned fromX %      XOpenDisplay. % > %    o window: Specifies a pointer to a XWindowInfo structure. %mH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.  %n %_ */) void XRefreshWindow(display,window,event)  Display    *display;b   XWindowInfo 
   *window;   XEvent	   *event;o {s   inte     x,     y;     unsigned int     height, 
     width;     if (event != (XEvent *) NULL)      {i       /*-         Determine geometry from expose event.b       */       x=event->xexpose.x;        y=event->xexpose.y; !       width=event->xexpose.width;i#       height=event->xexpose.height;      }t   else     {l       XEvent         sans_event;          /*A         Refresh entire window; discard outstanding expose events.e       */
       x=0;
       y=0;       width=window->width;       height=window->height;L       while (XCheckTypedWindowEvent(display,window->id,Expose,&sans_event));     }    /*     Check boundary conditions.   */4   if ((window->ximage->width-(x+window->x)) < width).     width=window->ximage->width-(x+window->x);6   if ((window->ximage->height-(y+window->y)) < height)0     height=window->ximage->height-(y+window->y);   /*     Refresh image.   */F   XSetClipMask(display,window->annotate_context,window->matte_pixmap);&   if (window->pixmap != (Pixmap) NULL)     {u       if (window->depth > 1)M         XCopyArea(display,window->pixmap,window->id,window->annotate_context,e4           x+window->x,y+window->y,width,height,x,y);
       elseO         XCopyPlane(display,window->pixmap,window->id,window->highlight_context,t7           x+window->x,y+window->y,width,height,x,y,1L);      }    else     {  #ifdef HasSharedMemory        if (window->shared_memory)	         { C           XShmPutImage(display,window->id,window->annotate_context,cJ             window->ximage,x+window->x,y+window->y,x,y,width,height,True);           XSync(display,False); 	         }a #endif!       if (!window->shared_memory)-M         XPutImage(display,window->id,window->annotate_context,window->ximage, 4           x+window->x,y+window->y,x,y,width,height);     }a6   XSetClipMask(display,window->annotate_context,None); }o   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %sO %                                                                             %sO %   X R e t a i n W i n d o w C o l o r s                                     %*O %                                                                             %gO %                                                                             %NO %                                                                             %uO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XRetainWindowColors sets X11 color resources on a window.  This I %  perserves the colors associated with an image displayed on the window.  % 4 %  The format of the XRetainWindowColors routine is: %k* %      XRetainWindowColors(display,window) %e+ %  A description of each parameter follows:. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %e> %    o window: Specifies a pointer to a XWindowInfo structure. %_ %f */( void XRetainWindowColors(display,window) Displaya   *display;;   Window	   window;; {    Atom
     property;&     Pixmap     pixmap;      /*     Put property on the window.f   */5   property=XInternAtom(display,"_XSETROOT_ID",False);e   if (property == (Atom) NULL)     {l<       Warning("Unable to create X property","_XSETROOT_ID");
       return;s     } -   pixmap=XCreatePixmap(display,window,1,1,1);o   if (pixmap == (Pixmap) NULL)     { 9       Warning("Unable to create X pixmap",(char *) NULL);s
       return;i     }oG   XChangeProperty(display,window,property,XA_PIXMAP,32,PropModeReplace, !     (unsigned char *) &pixmap,1); -   XSetCloseDownMode(display,RetainPermanent);y }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %tO %                                                                             % O %   X S e l e c t W i n d o w                                                 % O %                                                                             %mO %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %mO %  Function XSelectWindow allows a user to select a window using the mouse.  If H %  the mouse moves, a cropping rectangle is drawn and the extents of the4 %  rectangle is returned in the crop_info structure. % / %  The format of the XSelectWindow function is:  % 5 %      target_window=XSelectWindow(display,crop_info)e %e+ %  A description of each parameter follows:c %r3 %    o window: XSelectWindow returns the window id.  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %=G %    o crop_info: Specifies a pointer to a RectangleInfo structure.  It 6 %      contains the extents of any cropping rectangle. %) %  */' Window XSelectWindow(display,crop_info); Display    *display;   
 RectangleInfo[
   *crop_info;] {d) #define MinimumCropArea  (unsigned int) 9-     Cursor     target_cursor;     GC     annotate_context;      intm     presses,     status,e
     x_offset,i
     y_offset;u     Window     root_window,     target_window;     XEvent
     event;     XGCValues      context_values;-     /*     Initialize graphic context.-   */;   root_window=XRootWindow(display,XDefaultScreen(display)); I   context_values.background=XBlackPixel(display,XDefaultScreen(display)); I   context_values.foreground=XWhitePixel(display,XDefaultScreen(display)); #   context_values.function=GXinvert;e   context_values.plane_mask=:     context_values.background ^ context_values.foreground;1   context_values.subwindow_mode=IncludeInferiors;lN   annotate_context=XCreateGC(display,root_window,GCBackground | GCForeground |@     GCFunction | GCPlaneMask | GCSubwindowMode,&context_values);$   if (annotate_context == (GC) NULL)     return(False);   /*)     Grab the pointer using target cursor.d   */0   target_cursor=XMakeCursor(display,root_window,G     XDefaultColormap(display,XDefaultScreen(display)),"white","black");h>   status=XGrabPointer(display,root_window,False,(unsigned int)J     (ButtonPressMask | ButtonReleaseMask | ButtonMotionMask),GrabModeSync,9     GrabModeAsync,root_window,target_cursor,CurrentTime);    if (status != GrabSuccess)4     Error("Unable to grab the mouse",(char *) NULL);   /*     Select a window.   */   crop_info->width=0;    crop_info->height=0;   presses=0;   target_window=(Window) NULL;
   x_offset=0;d
   y_offset=0;,   do   {,@     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x,i=         crop_info->y,crop_info->width-1,crop_info->height-1);r     /*       Allow another event.     */2     XAllowEvents(display,SyncPointer,CurrentTime);J     XWindowEvent(display,root_window,ButtonPressMask | ButtonReleaseMask |       ButtonMotionMask,&event); @     if ((crop_info->width*crop_info->height) >= MinimumCropArea)G       XDrawRectangle(display,root_window,annotate_context,crop_info->x,p=         crop_info->y,crop_info->width-1,crop_info->height-1);s     switch (event.type)t     {e       case ButtonPress:        { +         if (target_window == (Window) NULL))           { 2             target_window=event.xbutton.subwindow;/             if (target_window == (Window) NULL)s(               target_window=root_window;           }r&         x_offset=event.xbutton.x_root;&         y_offset=event.xbutton.y_root;         crop_info->x=x_offset;         crop_info->y=y_offset;         crop_info->width=0;o         crop_info->height=0;         presses++;         break;       }        case ButtonRelease:        {          presses--;         break;       }%       case MotionNotify:       {%
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); %         crop_info->x=event.xmotion.x; %         crop_info->y=event.xmotion.y; 
         /*$           Check boundary conditions.
         */$         if (crop_info->x < x_offset)B           crop_info->width=(unsigned int) (x_offset-crop_info->x);         else           { D             crop_info->width=(unsigned int) (crop_info->x-x_offset);"             crop_info->x=x_offset;           } $         if (crop_info->y < y_offset)C           crop_info->height=(unsigned int) (y_offset-crop_info->y);%         else           {%E             crop_info->height=(unsigned int) (crop_info->y-y_offset);r"             crop_info->y=y_offset;           }        }s       default:         break;     }i   }i<   while ((target_window == (Window) NULL) || (presses > 0));&   XUngrabPointer(display,CurrentTime);%   XFreeCursor(display,target_cursor);c$   XFreeGC(display,annotate_context);=   if ((crop_info->width*crop_info->height) < MinimumCropArea)f     {o       crop_info->width=0;s       crop_info->height=0;     }e:   if ((crop_info->width != 0) && (crop_info->height != 0))     target_window=root_window;   return(target_window); }n d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             % O %                                                                             %eO %   X S e t W i n d o w E x t e n t s                                         %dO %                                                                             %_O %                                                                             %*O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%y %rL %  Function XSetWindowExtents resizes the window to a size determined by the %  text and the font size. %_3 %  The format of the XSetWindowExtents function is:a %N- %      XSetWindowExtents(display,window,text)w %i+ %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %m> %    o window: Specifies a pointer to a XWindowInfo structure. %i2 %    o text: Specifies a pointer to a text string. %d %l */+ void XSetWindowExtents(display,window,text)> Displaym   *display;i   XWindowInfoe
   *window;   char   *text; {=   unsigned int     height;f     XWindowChanges     window_changes;h  @   window->width=XTextWidth(window->font_info,text,strlen(text))+3     ((3*window->font_info->max_bounds.width) >> 1);m>   height=window->font_info->ascent+window->font_info->descent;!   window->height=(5*height) >> 2;u%   window_changes.width=window->width;s'   window_changes.height=window->height;iL   XReconfigureWMWindow(display,window->id,window->screen,CWWidth | CWHeight,     &window_changes);_ }o x /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%XO %                                                                             %wO %                                                                             %cO %                                                                             %rO %   X V i s u a l C l a s s N a m e                                           %;O %                                                                             %eO %                                                                             %;O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%t %=I %  Function XVisualClassName returns the visual class name as a character_
 %  string. %d1 %  The format of the XVisualClassName routine is:i %_* %      visual_type=XVisualClassName(class) %s+ %  A description of each parameter follows:e % L %    o visual_type: XVisualClassName returns the visual class as a character %      string. %v) %    o class: Specifies the visual class.U %r %C */ char *XVisualClassName(class)b into   class; {e   switch (class)   {r*     case StaticGray: return("StaticGray");(     case GrayScale: return("GrayScale");,     case StaticColor: return("StaticColor");,     case PseudoColor: return("PseudoColor");(     case TrueColor: return("TrueColor");,     case DirectColor: return("DirectColor");   }>!   return("unknown visual class");r }= d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             % O %                                                                             %rO %                                                                             %%O %   X W i n d o w B y I D                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XWindowByID locates a child window with a given ID.  If not windowK %  with the given name is found, 0 is returned.   Only the window specified # %  and its subwindows are searched.% %%- %  The format of the XWindowByID function is:% %%+ %      child=XWindowByID(display,window,id)  %o+ %  A description of each parameter follows:n %b? %    o child: XWindowByID returns the window with the specifiedn; %      id.  If no windows are found, XWindowByID returns 0.x %iL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %c4 %    o id: Specifies the id of the window to locate. %  %  */* Window XWindowByID(display,root_window,id) Display    *display;a   Window   root_window;  
 unsigned longC   id;u {    register int     i;     unsigned int     number_children;     Window
     child,     *children,     window;y     if (root_window == id)     return(id);iP   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL; %   for (i=0; i < number_children; i++)D   {n     /*+       Search each child and their children.      *//     window=XWindowByID(display,children[i],id);o      if (window != (Window) NULL)       break;   },"   if (children != (Window *) NULL)     XFree((void *) children);+   return(window);2 };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   X W i n d o w B y N a m e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%J %  Function XWindowByName locates a window with a given name on a display.I %  If no window with the given name is found, 0 is returned. If more thanRK %  one window has the given name, the first one is returned.  Only root and, %  its children are searched.r %i/ %  The format of the XWindowByName function is:y %p5 %      window=XWindowByName(display,root_window,name)  %X+ %  A description of each parameter follows:p %t3 %    o window: XWindowByName returns the window id.x %SL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %f8 %    o root_window: Specifies the id of the root window. %t8 %    o name: Specifies the name of the window to locate. %d %a */. Window XWindowByName(display,root_window,name) Displayi   *display;w   Window   root_window;   char   *name; {    register int     i;     unsigned int     number_children;     Window     *children,
     child,     window;c     XTextPropertyo     window_name;  8   if (XGetWMName(display,root_window,&window_name) != 0)5     if (strcmp((char *) window_name.value,name) == 0)s       return(root_window);P   if (!XQueryTree(display,root_window,&child,&child,&children,&number_children))     return((Window) NULL);   window=(Window) NULL;%%   for (i=0; i < number_children; i++)%   {%     /*+       Search each child and their children.      */3     window=XWindowByName(display,children[i],name);       if (window != (Window) NULL)       break;   } "   if (children != (Window *) NULL)     XFree((void *) children);    return(window);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   X W i n d o w B y P r o p e r y                                           %tO %                                                                             %uO %                                                                             %,O %                                                                             %dO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % K %  Function XWindowByProperty locates a child window with a given property. J %  If no window with the given name is found, 0 is returned.  If more thanJ %  one window has the given property, the first one is returned.  Only the4 %  window specified and its subwindows are searched. % 3 %  The format of the XWindowByProperty function is:i %s7 %      child=XWindowByProperty(display,window,property)  %s+ %  A description of each parameter follows:o %_H %    o child: XWindowByProperty returns the window id with the specifiedG %      property.  If no windows are found, XWindowByProperty returns 0.; % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % @ %    o property: Specifies the property of the window to locate. %x %  */8 static Window XWindowByProperty(display,window,property) Display2   *display;    Window	   window;2   Atom   property;  {c   Atom	     type;      intf     format,      status;x     unsigned charx
     *data;     unsigned int     i,     number_children;     unsigned longx
     after,     number_items;      Window
     child,     *children,     parent, 	     root;   M   status=XQueryTree(display,window,&root,&parent,&children,&number_children);0   if (status == 0)     return((Window) NULL);   type=(Atom) NULL;    child=(Window) NULL;C   for (i=0; (i < number_children) && (child == (Window) NULL); i++)x   {xG     status=XGetWindowProperty(display,children[i],property,0L,0L,False,xG       (Atom) AnyPropertyType,&type,&format,&number_items,&after,&data); 5     if ((status == Success) && (type != (Atom) NULL))u       child=children[i];   }rC   for (i=0; (i < number_children) && (child == (Window) NULL); i++)g:     child=XWindowByProperty(display,children[i],property);"   if (children != (Window *) NULL)     XFree((void *) children);(   return(child); }k