= /***	LASER - A Single-Threaded Asynchronous Symbiont to drive  *		any Postscript LaserWriter. * 7 *	Copyright (C) 1987, The University of Texas at Austin  * 
 *	Rick Watson # *	The University of Texas at Austin  *	Computation Center *	Austin, TX 78712 *	512/471-3241 * $ *	arpa:	ccaw001@utadnx.cc.utexas.edu *	bitnet:	ccaw001@utadnx *	span:	utspan::ccaw001  *	uucp:	...seismo!ut-ngp!rick  * B *	This user-writter symbiont is tailored specifically to the Apple. *	LaserWriter.  It has the following features: * = *	1. Page counting is done by reading the page count from the ; *	   laserwriter at the beginning and the end of each file. = *	   This mechanism also "synchronizes" the user job with the = *	   laserwriter.  If the laserwriter does not respond to the > *	   first request for a page count, the symbiont notifies the> *	   operator, and continues to poll the laserwriter.  This is? *	   usefull if the laserwriter is being shared with MAC users.  * @ *	2. Parameters may be passed to postscript modules in the setupC *	   library via 2 mechanisms.  The text from a $PRINT /NOTE=<text>   *	   command will be sent first.? *	   The /PARAMETER switch may also be used.  Each entry can be > *	   one of two formats. An entry without the "=" character in? * 	   it is sent as (param<n>) <parameter>.  An entry with the  ? *	   "=" character in is is sent as (<left side>) <right side>. : *	   The parameters are defined in an array called /param.; *	   Example:  /PARAMETER=(1,SIZE=5,"str=(a+b)") generates: 1 *	   /param [(param1) 1 (size) 5 (str) (a+b)] def D *	   All alphabetics are forced to lower case.  Using the /PARAMETER? *	   switch forces sending PARSER from LASER.TLB as part of the 6 *	   PostScript program sent to the printer.  Look at > *	   other files in LASER.TLB for examples of using the PARSER *	   module. * @ *	3. If the name of a setup module ends with "_HEX" the file to C *	   be printed is "hexified" to the laser printer.  This is useful 3 *	   for sending bitimage files to the laserwriter.  * B *	4. A log of responses from the laserwriter is created.  This is D *	   usefull for debugging postscript programs.  The file is createdB *	   as <printfilespec>.LASER_LOG.  In the case of spooled output,D *	   the log file is written to LASER$LOG:<printfilespec>.LASER_LOG.4 *	   These files are automatically deleted if empty. * F *	5. Printer error messages from the laserwriter are sent to operators2 *	   enabled to receive PRINT messages from OPCOM. * ? *	6. receiving a %%[Flushing from the printer aborts data until ! *		the next 'EOD' or end of file.  * D *	7. Spooled files:  Spooled files normally default to FORMS=HEADERS? *	   if the recommended queue initialize procedure is followed. ? *	   By specifying special filenames, the user can override the 9 *	   forms used, and pass parameters to the setup module. 4 *	   The syntax is:  "_<formname>._<parameter list>"6 *	   where <formname> is the name of a form to use and@ *	   <parameter list> is of the form: <parameter>-<value>[_...].: *	   (Note the use of "-" instead of "=" for a separator.)? *	   For example:  $ copy zeta.plt alw:_zeta._ncopies-5_scale-2 & *	   (The kludge of the century, huh?) * ? *	8. Handles LAT devices, LAT passwords, laserwriter passwords, ? *	   saves printers pages count into a file. Default parameters : *	   may be given to a queue, physical or generic with the< *	   LASER$PARAMETER_<queue name> logical. Handles stalling. * 6 *	Outputs (in the following order) to the laserwriter: * " *	1. "/note <notestring> def\r\n".G *	2.  /param definition and library module PARSER if /PARAMETER switch  
 *	    present 2 *	3. If the setup module is "HEADERS", the string  *		"/filename <filename> def" ( *	    and "/formname <name of form> def"7 *	3. The first file or forms setup module if specified. @ *	4. The file to be printed itself.  If the setup module ends in9 *	   "_HEX" the file is hex-ified to the printer instead.  * B *	where: <notestring> is the string from $PRINT /NOTE=<notestring>G *	       <paramstring> is the string from $PRINT /PARAM=("<string>"...) D *	       <filename> is the file specification for the file to print. *  *	Limitations, bugs, etc:  *  *	1. No checkpointing is done.C *	2. $PRINT/COPIES=n sends the job to the LaserWriter n times. This B *	   is not optimal, but is how the job controller handles things.A *	   It makes sense for most printers.  Multiple copy handling is @ *	   better handled in most of the postscript setup files.  Also. *	   /note="/#copies n def" will usually work.' *	3. $PRINT/SPACE=n is not implemented. > *	4. BURST pages are not implemented. (But TRAILER pages are).B *	   Trailer pages are used because the stack on "top" of the job.: *	5. FORTRAN carriage control is incompletely implemented., *	6. Does not handle lists of setup modules. *  *	Recommended device setup:  * E *	$ define/system/exec/trans=(concealed,terminal) alw <term>: ! laser ; *	$ set term /perm /speed=9600 /nomodem /notype /nohang alw D *	$ set term /perm /hostsync /pasthru /ttsync /eightbit /nobroad alw *	$ set term /perm /noauto alw *	$ set prot=o:rwlp /dev alw0 *	$ set device /spooled=(ALW,sys$sysdevice:) alw *  *	Recommended queue initialize:  *  *	$ initialize/queue/start -; *	/default=(noburst,nofeed,noflag,notrailer,form=headers) - ' *	/separate=(noburst,noflag,trailer) -  - *	/library=laser /base_prio=8 /form=headers -  *	/processor=laser /on=alw: alw  *  *	Modification History:   *	12-Feb-1987 R. Watson	Created.B *	15-Apr-1987 R. Watson   Added some record format processing (cr, *				fortran).; *	16-Apr-1987 R. Watson	Allow ':' as a parameter separator. D *	21-Apr-1987 R. Watson	Some mods to trailer page. Send PATCH module *				if v 23.0 printer. C *	24-Apr-1987 R. Watson	This version submitted to Spring '87 Decus. 1 *	22-feb-1995 gg		This versin submitted to decus.  */   /* ***	notes de ralisation:	(GG)8 ***	il ne faut *jamais* faire appel aux routines d'I/O CB ***	car au premier appel vaxcio ouvre sys$error, ce qui fait raler= ***	JOB_CONTROL car sys$error *est* la mbx de JOB_CONTROL ...  */     #include <ctype.h> #include <errno.h>) #include <signal.h>			/* GG pour sleep */  #include <stdarg.h>			/* GG */ #include <stdio.h> #include <stdlib.h>			/* GG */ #include <string.h>			/* GG */   #include <acldef.h>			/* GG */ #include <armdef.h>			/* GG */ #include <assert.h>			/* GG */ #include <brkdef.h>			/* GG */ #include <chpdef.h>			/* GG */ #include <dcdef.h>			/* GG */  #include <descrip.h> #include <dvidef.h>			/* GG */	  #include <iodef.h> #include <jpidef.h>			/* GG */ #include <fscndef.h>			/* GG */  #include <latdef.h>			/* GG */
 #ifdef __DECC  #include <latmsgdef.h> #else 3 #include "latmsg.h"	/* LAT$_DISCONNECTED missing */  #endif #include <lbrdef.h>   #include <libdtdef.h>			/* GG */ #include <lnmdef.h>			/* GG */ #include <opcdef.h>  #include <prvdef.h>  #include <quidef.h>  #include <rms.h> #include <sjcdef.h>			/* GG */ #include <ssdef.h> #include <syidef.h>			/* GG */ #include <ttdef.h> #include <tt2def.h>    #include "laser.h" #include "smbdef.h"    int  	SYS$HIBER(void),  	SYS$SETAST(int),  	SYS$WAKE(); int  	SYS$ASSIGN(), 	SYS$DASSGN(), 	SYS$QIO(),  	SYS$QIOW(); int 
 	SYS$CLOSE(),  	SYS$CREATE(), 	SYS$CONNECT(),  	SYS$DISCONNECT(), 	SYS$GET(), 
 	SYS$OPEN(),   	SYS$PUT(),  	SYS$UPDATE();   int  	STR$APPEND(), 	STR$COPY_DX(),  	STR$COPY_R(), 	STR$FREE1_DX();  + typedef enum {false,true} boolean;	/* GG */ " #define istrue(x) (x&1)			/* GG */) #define isfalse(x) ((x&1) == 0)		/* GG */   ) #define min(a,b) ((a>b) ? b : a)	/* GG */   O typedef enum   {itm_string, itm_numeric, itm_uic, itm_time, itm_fid, itm_other, 
 		itm_vector}  		itm_type;   1 static	itm_type	itemtype[SMBMSG$K_MAX_ITEM_CODE];      /* debug data (GG) */  static int	debug;  static struct	FAB	dbg_fab; static struct	RAB	dbg_rab;   static void dbg_init(file) char * file; { , static	const	char dbglogname[] = "LASERSMB";6 static	const	char dbgdefname[] = "LASER$LOG:.DBG_LOG";
 	int stat;  & 	dbg_fab = cc$rms_fab;		/* init fab */  * 	dbg_fab.fab$l_dna = (char *) &dbgdefname;* 	dbg_fab.fab$b_dns = sizeof dbgdefname -1;   	if (file==NULL) {+ 		dbg_fab.fab$l_fna = (char *) &dbglogname; + 		dbg_fab.fab$b_fns = sizeof dbglogname -1;  	} 	else	{  		dbg_fab.fab$l_fna = file; $ 		dbg_fab.fab$b_fns = strlen (file); 	}   	dbg_fab.fab$b_rfm = FAB$C_VAR;  	dbg_fab.fab$b_rat = FAB$M_CR;" 	dbg_fab.fab$b_shr = FAB$M_SHRGET; 	dbg_fab.fab$w_mrs = 512;    	stat = SYS$CREATE(&dbg_fab);  	if (stat & 1) {. 		dbg_rab = cc$rms_rab;			/* initialize rab */ 		dbg_rab.rab$l_fab = &dbg_fab;  		stat = SYS$CONNECT(&dbg_rab);  	} 	debug= stat & 1;	 }    static void dprintf (const char * line,...)  {  	if (dbg_rab.rab$w_isi) {  		int SYS$FLUSH(); 		char	buf[512];
 		va_list ap; 
 		int sts;   		va_start (ap,line);  		sts= SYS$SETAST (0);! 		(void) vsprintf(buf, line, ap); # 		dbg_rab.rab$l_rbf= (char *) &buf; " 		dbg_rab.rab$w_rsz= strlen (buf);: 		if (buf[dbg_rab.rab$w_rsz-1]=='\n') dbg_rab.rab$w_rsz--; 		SYS$PUT (&dbg_rab);  		SYS$FLUSH (&dbg_rab); - 		if (sts==SS$_WASSET) (void) SYS$SETAST (1);  		va_end (ap); 	} }    static   void dbg_close()  {  	int	status, aststs;   	aststs= SYS$SETAST(0);   # 	status= SYS$DISCONNECT (&dbg_rab); J 	if ((status&1) == 0) dprintf ("Error disconnecting trace: 0x%X", status); 	status= SYS$CLOSE (&dbg_fab);D 	if ((status&1) == 0) dprintf ("Error closing trace: 0x%X", status); 	else debug= 0;   . 	if (aststs==SS$_WASSET) (void) SYS$SETAST(1); }    static void  print_efs()  {  	unsigned long efn[2]; 	int SYS$READEF();   	SYS$READEF (0, efn);  	SYS$READEF (32, efn+1);3 	dprintf ("Event flags: %08X%08X", efn[1], efn[0]);  }      static void  print_astcnt(char * mess)  {  static	unsigned short astcnt; & static	struct {uint16  bufsiz, bufcod;0 		ptr32 bufadr, retadr; uint32 endlst;} jpi_lst=" 		{2, JPI$_ASTCNT, &astcnt, 0, 0}; 	int	status; 	int	SYS$GETJPIW();   2 	status= SYS$GETJPIW (0, 0, 0, &jpi_lst, 0, 0, 0);? 	dprintf ("ASTCNT %s: %d, status= %08X", mess, astcnt, status);  }    /* End of debug data	*/    /*4  *	checkstat - check value of system service return.  */  static void  checkstat(stat, string) 	 int stat; 
 char *string;  {  	void LIB$STOP(); 0 	dprintf ("checkstat %s: 0x%X\n", string, stat);! 	if isfalse(stat) LIB$STOP(stat);  }    /*  *	bug - aborts the symbiont  */  static void  bug (string)
 char *string;  {  	void LIB$STOP(); # 	dprintf ("Fatal bug: %s", string);  	LIB$STOP(SS$_BUGCHECK); }   * static	const char lw_crlf[] =	{'\r','\n'};9 static	const char lw_abort[]= {'\003','\004'};	/* ^C^D */ ' static	const char lw_eot[]  = {'\004'};    #pragma nostandardD globalvalue LASER$_MAXITEMS;		/* exit statuses found in laser_err */  globalvalue LASER$_ITEMNOTFOUND;" globalvalue LASER$_STREAMNOTSTART; globalvalue LASER$_TOOMANYTABS;  globalvalue LASER$_FLUSHED; ! globalvalue LASER$_SETUPNOTFOUND;  #pragma standard   struct { 	int	item_code;		/* code */ . 	unsigned short 	item_size;	/* size of item */% 	char	*buffer;		/* address of item */  } item[MAXITEMS]; & int	itmax = 0;			/* max. item index */  7 static uint32	laser_efn;		/* laser read event flag # */ 2 static uint32 	gp_efn;			/* general purpose EFN */6 	/* must NEVER be used on an asynchronous operation *// 	/* the default state of this EFN must be ON */ ( int	startpage;			/* task start page # */$ int	endpage;			/* task end page # */& int	jobstart;			/* job start page # */6 boolean	postscript;			/* GG true if postscript file */' 					/* if false, no special meaning */ = boolean	patchneeded = false;		/* true if patch module sent */    typedef struct {. 	int	spooled_file;		/* true if spooled file */9 	boolean	status_idle;		/* true if idle status received */ < 	boolean	readast /* =False */;	/* true si read ast active */. 	short	chan /*=0*/;		/* laserwriter channel *// 	int	alive;			/* laserwriter activity marker */ 8 	boolean	timeout;		/* GG laserwrite timeout for keyin */; 	boolean	lw_clear;		/* GG ignore laserwrite 'flush' msgs */ 4 	boolean	lw_online;		/* GG laserwriter accessible */8 	int	lw_flushcnt;		/* GG counter for 'flush' messages */. 	int	lw_eotcnt;		/* GG counter for ^D chars *// 	boolean	lw_sync;		/* GG laserwriter SYNCing */ 8 	boolean	stalled;		/* GG laserwriter stall in process */0 	boolean paused;			/* GG pause. unimplemented */; 	boolean	nousermsg;		/* GG messages not sent to the user */ 5 	boolean	user_job_active;	/* GG printing user file */ 0 	boolean	task_active;		/* GG a task is active */) 	boolean	hexdump;		/* ascii/hex switch */ = 	boolean setupsent;		/* a setup has been sent to the LW GG */ 3 	boolean	QMSbug;			/* ^T renvoie toujours "busy" */   = 		/*+++ these variables must be accessed with AST disabled */ 9 	boolean stop_task;		/* JOBCTL requested abort of task */ = 		/*--- these variables must be accessed with AST disabled */   @ 	boolean	check_device;		/* device check needed for this stream*/* 	boolean	empty_file;		/* GG: empty file */. 	int	stop_reason;		/* stop task reason code */T #define SET_STOP_REASON(code) {if (stream.stop_reason==0) stream.stop_reason= code;}7 	int	print_status;		/* print status (for accounting) */ B 	unsigned stallmsg_count;	/* counters to avoid excessive message*/? 	unsigned stallerr_count;	/* logging when printer is stalled */ 6 	unsigned long	debug;		/* GG stream debugging flags */) #define	DBG_DUMP	1		/* GG dump lw data */ + #define DBG_OPEN	2		/* GG open debug log */ - #define DBG_CLOSE	4		/* GG close debug log */ & #define	DBG_VFC		8		/* GG debug VFC */1 #define	DBG_JOBCTL	16		/* GG debug job control */ 2 	enum {	print_unknown,		/* GG copy module as is */2 		print_headers}		/* GG setup module is headers */' 	job_type;			/* GG type d'impression */   . 	unsigned long id /* = 0*/;	/* stream id GG */* 	char	queue[64];		/* nom de la queue GG */& 	char	dev[64];		/* nom du device GG */7 	char	product[64];		/* nom du modele d'imprimante GG */ < 	char	version[64];		/* version du soft de l'imprimante GG */= 	long	task_start[2];		/* date de demarrage de l'impression */   E 	smbmsg$r_device_status	devsts;	/* laser writer device status (GG) */   4 	enum	{resrc_unknown,			/* resource state unknown */( 		 resrc_loaded,			/* resource loaded */. 		 resrc_notloaded}		/* resource not loaded */2 		resrc_state;		/* temoin prsence ressource GG */   	smbmsg$r_separation_control	 		sepctl;   C 	boolean	prtfile_open /*=0*/;	/* temoin ouverture de fichier prt */ A 	char	logfile_lines /*=0*/;	/* temoin ouverture de fichier log */ = 	char	logfile_write /* =false*/;	/* write next messages to */  							/* log file */ > 	char 	printernode[40];	/* nom du noeud ou est l'imprimante */> 	char	servicename [MAXSERVICESIZE+1];	/* nom du service LAT */  9 	char	lw_pw[CONFIG_PASSWORD_SIZE+1];	/* GG lw password */ ; 	char	lat_pw[CONFIG_PASSWORD_SIZE+1];	/* GG lat password */ 7 	char	initstr[CONFIG_INIT_SIZE+1];	/* GG init string */   / 	unsigned long bcnt;		/* GG STAT: bytes sent */  	}	stream_t;   static	stream_t stream;   9 static	const char	default_initstr[]= CONFIG_DEFAULT_INIT;   4 unsigned short laser_iosb[4];		/* laser read iosb */. char	laser_buf[1024];		/* laser read buffer */7 static	struct	FAB main_fab;			/* main file rms stuff */  static	struct	NAM main_nam;  static	struct	RAB main_rab; * static	struct	XABRDT main_xabrdt;	/* gg */* static	struct	XABFHC main_xabfhc;	/* gg */. struct	FAB log_fab;			/* log file rms stuff */ struct	RAB log_rab; M struct  dsc$descriptor_d library_spec = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; J struct	dsc$descriptor_d buffer_des = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};   static	struct	dsc$descriptor_d0 	savelog = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};0 		/* MAXLOGLINE first error lines for trailer */  = static	unsigned short	mbxchan;	/* canal de surveillance GG */ D static	char smb_nodename[20];		/* nom du noeud ou est le symbiont */< static	char smb_vmsvers[20];		/* numero de version de VMS */8 static	long smb_maxbuf;		/* taille max d'un transfert */? static	long smb_maxbuf_lo=0;		/* taille ok pour un transfert */ H static	long smb_maxbuf_ex=0;		/* taille trop grand  pour un transfert */% static	unsigned long	keyin_daytim[2]; % static	unsigned long	stall_daytim[2]; A static	const	$DESCRIPTOR(keyin_interval,"0 :0:30");	/* +30 sec */ @ static	const	$DESCRIPTOR(stall_interval,"0 :2:00");	/* +2 min */7 #define	STALL_MINS	2		/* stall  interval, in minutes */k    static	boolean	getitemdescrip();    2 	/*+++ macros to access AST protected variables */: #define PROT_START(s)	{ int protect$$sts= SYS$SETAST (0);\= 		  	  dprintf ("PROT_START: %s status=%d\n",s,protect$$sts);mC #define PROT_END(s)	if (protect$$sts== SS$_WASSET) SYS$SETAST (1);\a< 		  	  dprintf ("PROT_END: %s status=%d\n",s,protect$$sts);}E #define UNPROTECT(s) 	if (protect$$sts== SS$_WASSET) SYS$SETAST (1);\ < 		  	  dprintf ("UNPROTECT: %s status=%d\n",s,protect$$sts);2 	/*--- macros to access AST protected variables */ t/ /****** ACCOUNTING routines *******************s */   #define ACC_KEYSZ 50 #define ACC_TIMESZ 20  #define ACC_RSZ 80   static struct FAB	cfab;, static struct RAB	crab;e static compta_status	= 0;    static& void compta_init (char * printer_name) {u/ static	char comptafile[]	= "LASER$ACCOUNTING:";s4 static  char comptadefault[]	= "LASER_COUNTERS.DAT"; 	int status;   	cfab= cc$rms_fab; 	crab= cc$rms_rab;& 	cfab.fab$l_fna= (char *) &comptafile;% 	cfab.fab$b_fns= sizeof comptafile-1;c) 	cfab.fab$l_dna= (char *) &comptadefault;i( 	cfab.fab$b_dns= sizeof comptadefault-1; 	cfab.fab$b_org= FAB$C_IDX; / 	cfab.fab$b_fac= FAB$M_GET|FAB$M_PUT|FAB$M_UPD; E 	cfab.fab$b_shr= FAB$M_SHRGET|FAB$M_SHRPUT|FAB$M_SHRUPD|FAB$M_SHRDEL;n 	status= SYS$OPEN (&cfab); 	if (status&1) { 		crab.rab$l_fab= &cfab; 		status= SYS$CONNECT (&crab); 		if (status&1){ 			char msg[ACC_RSZ+1];l	 			int i;s  7 			sprintf (msg,"%-*s%*s%10d", ACC_KEYSZ, printer_name,c 						   ACC_TIMESZ, "", 0);  			crab.rab$w_rsz= strlen (msg); 			crab.rab$l_rbf= msg;h 			status= SYS$PUT (&crab);h$ 			if (status==RMS$_DUP) status|= 1;- 			checkstat (status, "Compta: $PUT record");  			crab.rab$l_kbf= msg;d  			crab.rab$w_usz= strlen (msg); 			crab.rab$l_ubf= msg;o /**/ 			crab.rab$b_rac= RAB$C_KEY;  			crab.rab$b_ksz= ACC_KEYSZ;  			crab.rab$l_kbf= msg;  			crab.rab$l_rop |= RAB$M_NLK;l 			status= SYS$GET (&crab);i 			crab.rab$b_rac= RAB$C_RFA;p- 			checkstat (status, "Compta: $GET record");a  			crab.rab$l_rop &= ~RAB$M_NLK; 			compta_status= status;  		}t/ 		else{	checkstat (status, "Compta: $CONNECT");c 			 exit(status);T 		}f 	}7 	else	dprintf ("Open comptafile returns %08X", status);r }m   void compta_update (int counter)  {o 	char	timbuf[80];l: 	struct	dsc$descriptor_s timadr= {sizeof timbuf, 0, 0, 0}; 	int	status; 	int	SYS$ASCTIM();   	if istrue (compta_status){E 		char msg[ACC_RSZ+1];   		timadr.dsc$a_pointer= timbuf;s 		crab.rab$l_ubf= msg;( 		status= SYS$ASCTIM (0, &timadr, 0, 0);( 		checkstat (status, "Compta: $GETTIM"); 		status= SYS$GET(&crab);m% 		checkstat (status, "Compta: $GET");r% 		sprintf (msg+ACC_KEYSZ,"%*.*s%10d",u- 				ACC_TIMESZ, ACC_TIMESZ, timbuf, counter);< 		status= SYS$UPDATE (&crab);o( 		checkstat (status, "Compta: $UPDATE"); 	} }a   e/ /******	L O G   F I L E routines **************.# *	openuserlog - open user log file.f *"> *	Create a file using the file spec of the file to be printed,8 *	changing the EXT to .LASER_LOG.  Try the logical name < *	LASER$LOG if this does not work (probably a spooled file). *w */ static boolean
 openuserlog()o { 
 	int stat;( 	struct dsc$descriptor_s user_d, file_d;7 	char	printspec[NAM$C_MAXRSS+1],		/* print file spec */T2 		logdnaspec[NAM$C_MAXRSS+1];		/* log file spec */G 	boolean	user_log= isfalse (stream.spooled_file);/* log in user dir. */s 	int	SYS$CHECK_ACCESS();  3 	getitemdescrip(SMBMSG$K_USER_NAME, &user_d, true);   & 	log_fab = cc$rms_fab;		/* init fab */  H /*  Build log file name.  If a spooled file, prepend the job name and */+ /*  put the file in LASER$LOG:					      */r  < 	getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &file_d, true);? 	strncpy(printspec, file_d.dsc$a_pointer, file_d.dsc$w_length);i$ 	printspec[file_d.dsc$w_length] = 0;  K /*	we should allow an user log file only if the user has write access to */ C /*	the containing directory. we do in fact allow it if the user has , /*	write access to the file being printed */   	if istrue (user_log) { . static	unsigned long chp_access = ARM$M_WRITE;- static	unsigned long chp_flags = CHP$M_WRITE;j< static	struct {uint16 itmsiz, itmcod; ptr32 bufadr, retadr;}B 		itmlst[] = {{sizeof chp_access, CHP$_ACCESS, &chp_access, NULL},8 			    {sizeof chp_flags, CHP$_FLAGS, &chp_flags, NULL}, 			    {0, 0, 0, 0}};s( static	unsigned long objtyp= ACL$C_FILE; 		unsigned long status;y  $ 		status= SYS$CHECK_ACCESS (&objtyp, 					  &file_d,R 					  &user_d,i 					  &itmlst);1 		dprintf ("$CHECK_ACCESS returns %08X", status);a 		user_log= istrue (status); 	}   	if isfalse(user_log) {t 		int i; 		char * cp;  A 		strncpy(logdnaspec, user_d.dsc$a_pointer, user_d.dsc$w_length);n5 		i = user_d.dsc$w_length;	/* trim trailing blanks */o 		do { 			logdnaspec[i] = 0; % 			if (logdnaspec[--i] != ' ') break;/ 		} while (i > 0); 		strcat(logdnaspec, "-");" 		cp = strchr(printspec, ']') + 1; 		strcat(logdnaspec, cp);m 	}% 	else	strcpy (logdnaspec, printspec);v 	w  	log_fab.fab$l_dna = logdnaspec;( 	log_fab.fab$b_dns = strlen(logdnaspec); 	if isfalse (user_log) {/ 		log_fab.fab$l_fna = "LASER$LOG:.laser_log;0";n 		log_fab.fab$b_fns = 22;s 	} 	else {r% 		log_fab.fab$l_fna = ".laser_log;0";b 		log_fab.fab$b_fns = 12;r 	}1 	log_fab.fab$b_rfm = FAB$C_STMLF;	/* FAB$C_VAR */o 	log_fab.fab$b_rat = FAB$M_CR; 	log_fab.fab$w_mrs = 512;5   	stat = SYS$CREATE(&log_fab);r 	if ((stat & 1) == 0) {c> 		dprintf ("Cannot $OPEN %s, status= %08X", logdnaspec, stat);& 		return false;		/* if not possible */ 	}  4 	log_fab.fab$b_rfm = FAB$C_UDF;		/* undef. format */- 	log_rab = cc$rms_rab;			/* initialize rab */i 	log_rab.rab$l_fab = &log_fab;   	stat = SYS$CONNECT(&log_rab); 	if ((stat & 1) == 0) { A 		dprintf ("Cannot $CONNECT %s, status= %08X", logdnaspec, stat); & 		return false;		/* if not possible */ 	}  9 	stream.logfile_lines = 1;		/* temoin ouverture du log */O
 	return true;r }      /*&  *	closeuserlog - close user log file.  */t static voidu closeuserlog() {u
 	int stat;  5 /*  If no records written, set for delete on close */    	stat = SYS$CLOSE(&log_fab); 	checkstat(stat,"close log");t 	g2 	STR$FREE1_DX (&savelog);		/* release saved log */  / 	stream.logfile_lines = 0;		/* fermeture log */	 }G   /*.  *	writeuserlog - write line to user log file.6  *	line looks <printableline>\0<additional separators>C  *	first separator is saved in savsep, i don't see why there shouldi;  *	be additional separators, but this is done this way...     */c static voidh writeuserlog(iosb, savsep)
 uint16	*iosb;m char	savsep; { K static	struct dsc$descriptor_s temp =	{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};f
 	int stat;  + 	if isfalse(stream.user_job_active) return;	$ 	if istrue(stream.nousermsg) return;   	PROT_START("writeuserlog")d   	if (stream.logfile_lines==0) {< 		char hdr_buf[128]; 		if isfalse (openuserlog()) {   			UNPROTECT("writeuserlog")   			return;	/* cannot open */ 		}u  & 		/* write a header in the log file */  ? 		sprintf (hdr_buf, "Messages logged by printer %s, node %s\n",A" 				  stream.queue, smb_nodename); 		log_rab.rab$l_rbf = hdr_buf;& 		log_rab.rab$w_rsz = strlen(hdr_buf);" 		stat = SYS$PUT (&log_rab, 0, 0); 	}  , 		/* save printable line for trailer page */  A 	if (stream.logfile_lines<=MAXLOGLINE) {	/* save first 5 lines */  		stream.logfile_lines++; 0 		temp.dsc$w_length = iosb[1]+1;	/* incl '\0' */! 		temp.dsc$a_pointer = laser_buf;0 		STR$APPEND (&savelog, &temp);( 	}  ! 		/* save anything in log file */   4 	laser_buf[iosb[1]]= savsep;	/* restore separator */ 	log_rab.rab$l_rbf = laser_buf;_% 	log_rab.rab$w_rsz = iosb[1]+iosb[3];S  ! 	stat = SYS$PUT (&log_rab, 0, 0);d 	checkstat(stat, "write log");   	PROT_END("writeuserlog")    }c2 	/******	end of  L O G   F I L E S routines	*****/1 	/****** start of print file routines GG		*****/= /*!  *	openfile - open the main file.a"  *	return:	false if open problems.  */  static
 openfile() {;
 	int stat;E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};=$ static	struct dsc$descriptor_s fid =7 		{sizeof main_nam.nam$t_dvi+sizeof main_nam.nam$w_fid,b5 		 DSC$K_DTYPE_T, DSC$K_CLASS_S, main_nam.nam$t_dvi};   , 	if istrue(stream.prtfile_open) return true;  ; 	getitemdescrip(SMBMSG$K_FILE_IDENTIFICATION, &temp, true);g 	b( 	main_fab = cc$rms_fab;			/* init fab */> 	main_fab.fab$l_nam = &main_nam;		/* use NAM to open by FID */! 	main_fab.fab$l_fop |= FAB$M_NAM;	 	_( 	main_nam = cc$rms_nam;			/* init nam */ 	STR$COPY_DX (&fid, &temp);b  ; 	main_xabrdt = cc$rms_xabrdt;		/* gg: XAB pour recuperer */ 9 	main_fab.fab$l_xab= (void *) &main_xabrdt;		/* la rdt */ ; 	main_xabfhc = cc$rms_xabfhc;		/* gg: XAB pour recuperer */ C 	main_xabrdt.xab$l_nxt= (void *) &main_xabfhc;	/* le file header */S   	stat = SYS$OPEN(&main_fab);) 	if isfalse(stat) {			/* if open error */b. 		dprintf ("$OPEN prfile returns %08X", stat); 		SET_STOP_REASON (stat);\ 		return false;_ 	} 	 . 	main_rab = cc$rms_rab;			/* initialize rab */  	main_rab.rab$l_fab = &main_fab;   	stat = SYS$CONNECT(&main_rab); , 	if isfalse(stat) {			/* if connect error */1 		dprintf ("$CONNECT prfile returns %08X", stat);u 		SET_STOP_REASON (stat);) 		return false;1 	}   	stream.prtfile_open= true;n
 	return true;  }t /*  *	closefile - close main file.   */( static void0 closefile()r { 
 	int stat;  # 	stat = SYS$CLOSE(&main_fab, 0, 0);    	stream.prtfile_open= false; 	/*  ignore error *// }	/****** end of print file routines GG		*****/n ; /**  *	sendmess - operator message routines	GGJ  *	mess: asciz message sent to printer operator and/or job originator user  *	context: AST or synchronous  */t #define	MSG_OPER 1 #define MSG_USER 2F #define OPC_MAX_MSG_SIZE 255	/* Cf system services reference manual */   static voids sendmess (mess,to) char * mess; int	to;, {;
 	int	stat; 	int	SYS$SNDOPR(), 		SYS$BRKTHRUW();S   	if (to&MSG_OPER) {_3 static		struct {		/* operator message to printer */X 			struct {n 				char type; 				char target; 				short fill;* 				long id;	 			} hdr;l! 			char text[OPC_MAX_MSG_SIZE+1]; 4 		} msg = {{OPC$_RQ_RQST, OPC$M_NM_PRINT, 0, 0},""};- static		struct dsc$descriptor_s oprmsg_dsc = (4 			{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *) &msg};
 		int sendsz;a 		int hdrsz;  = 		sprintf (msg.text, "Message from printer %s, queue %s\r\n", % 			stream.printernode, stream.queue);  		hdrsz= strlen (msg.text);r  		sendsz= hdrsz + strlen (mess);" 		if (sendsz > OPC_MAX_MSG_SIZE) { 			sendsz= OPC_MAX_MSG_SIZE;2 			dprintf ("Sendmess: message %s tronqu", mess); 		}c/ 		strncpy (msg.text+hdrsz, mess, sendsz-hdrsz); 4 		oprmsg_dsc.dsc$w_length = sendsz + sizeof msg.hdr;$ 		stat= SYS$SNDOPR (&oprmsg_dsc, 0);@ 		if (stat!=SS$_MBFULL)	/* OPCOM saturated... message is lost */ 			checkstat (stat, "$SNDOPR");$ 	}  6 	if ( (to & MSG_USER) && isfalse(stream.nousermsg) ) {K static	struct	dsc$descriptor_s user = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};s: 		if (getitemdescrip (SMBMSG$K_USER_NAME, &user, false)) { 			char  * cp; 			int	iosb[2];/3 			struct	dsc$descriptor_s messdesc = {0, 0, 0, 0};l  ' 			messdesc.dsc$w_length= strlen(mess);g  			messdesc.dsc$a_pointer= mess;A 			stat= SYS$BRKTHRUW (gp_efn, &messdesc, &user, BRK$C_USERNAME, e4 				            iosb, 0, BRK$M_CLUSTER, BRK$C_QUEUE, 					    5, 0, 0);! 			checkstat (stat, "$BRKTHRUW");p 		}  	} }	 s /*  *	various system routines  */a static void 	 wake_me()e {  	int status; 	status= SYS$WAKE (0, 0);s 	checkstat (status, "$WAKE");c }e static void	 hibernate()t {m 	int status; 	status= SYS$HIBER (); 	checkstat (status, "$HIBER"); }d static voido3 send_request (sp, request, accounting, status, msg)  stream_t * sp; unsigned request;  void * accounting; unsigned long status;0 char * msg;w {e 	int syssts; 	int SMB$SEND_TO_JOBCTL(); 	unsigned vec[2];  static	const uint32 vbn=1;= 	/* queman says garbage if chkpt data is not present (v6.2)*/eF static  const struct {int l; const ptr32 p;} vbn_d= {4, (ptr32) &vbn};  + 	if (status) { vec[0]= 1; vec[1]= status; }r  ; 	syssts= SMB$SEND_TO_JOBCTL (&sp->id, &request, accounting,r 				   &vbn_d, /*checkpoint */( 				   &sp->devsts, (status) ? vec : 0);E 	dprintf ("%s SEND_TO_JOBCTL: status= %08x request= %d devsts=%08X",   					 msg,syssts, request,/ 				         sp->devsts.smbmsg$l_device_flags); - 	if isfalse (syssts) checkstat (syssts, msg);  }e  A /**	check_operator - checks for a laserwriter message that shouldp *			 go to the operator.7 *	returns false if message should be written in the log  */ static voidQ wake_stream (if_sync)t4 boolean if_sync;	/* wake even if sync in progress */ {e= 	if (istrue (if_sync) || isfalse (stream.lw_sync)) wake_me();e }d   static boolean check_operator() {b 	int i;b  7 	if (strncmp(laser_buf,"%%[ PrinterError:", 17) == 0) {	* 		sendmess (laser_buf, MSG_USER|MSG_OPER); 		return true; 	}  3 	if (strncmp(laser_buf,"%%[ Product =", 12) == 0) {eB 		strncpy (stream.product, laser_buf+13, sizeof stream.product-1);. 		stream.product[sizeof stream.product-1] = 0;. 		wake_stream (true);	/* sync may need this */ 		return true; 	}  3 	if (strncmp(laser_buf,"%%[ Version =", 12) == 0) {lB 		strncpy (stream.version, laser_buf+13, sizeof stream.version-1);. 		stream.version[sizeof stream.version-1] = 0;. 		wake_stream (true);	/* sync may need this */ 		return true; 	}  5 	if (strncmp(laser_buf,"%%[ exitserver:", 15) == 0) {*! 		sendmess (laser_buf, MSG_OPER);  		return true; 	}  3 	if (strncmp(laser_buf, "%%[ status: ", 12) == 0) {n< 		if (strncmp(laser_buf, "%%[ status: idle ]%%", 20) == 0) { 			stream.status_idle = true;t 			wake_stream (true); 		}n 		return true; 	}  ; 	if (strncmp(laser_buf, "%%[ patch needed ]%%", 20) == 0) {  		patchneeded = true;e 		return true; 	}  8 	if (strncmp(laser_buf, "%%[ start page #=", 17) == 0) {+ 		sscanf(&laser_buf[17], "%d", &startpage);o 		wake_stream (false); 		return true; 	}  8 	if (strncmp(laser_buf, "%%[ end page   #=", 17) == 0) {) 		sscanf(&laser_buf[17], "%d", &endpage);s 		wake_stream (false); 		return true; 	}  9 	if (strcmp(laser_buf, "%%[ resource loaded ]%%") == 0) {a# 		stream.resrc_state= resrc_loaded;r 		wake_stream (false); 		return true; 	}  = 	if (strcmp(laser_buf, "%%[ resource not loaded ]%%") == 0) {l& 		stream.resrc_state= resrc_notloaded; 		wake_stream (false); 		return true; 	}  3 	if (strcmp(laser_buf, "^C") == 0)		/* Control-C */* 		return stream.lw_clear;=  $ 		/* pollution created by ms-word */  = 	if (strncmp(laser_buf, "%%[ document:", 13)==0) return true;u7 	if (strncmp(laser_buf, "%%[ job:", 8)==0) return true;]  4 /*  Abort the job if we see "%%[ Flushing:"		     */? /*  Don't override an already existing stop_reason condition */Z  6 	if ((strncmp(laser_buf, "%%[ Flushing:", 13) == 0) ||? 	    (strncmp(laser_buf, "%%[ Flushing ", 13) == 0)) {	/* GG */ , 		stream.lw_flushcnt++;			/* count flushs */ 		if istrue(stream.lw_clear) { 			dprintf ("Ignoring flush"); 			return true;n 		}o 		else{i  			dprintf ("flushing the job");" 			sendmess (laser_buf, MSG_USER);$ 			SET_STOP_REASON (LASER$_FLUSHED);% 			return false;			/* write in log */r 		}A 	}  4 	/* a partir de ce niveau, tous les messages sont */% 	/* envoyes a l'originateur du job */c.                                                 	sendmess (laser_buf, MSG_USER); 	t 	return false; }u  5 	/****** start of laserwriter I/O routines GG	*****/C /*  *	laserwrite - write on laser  */  static void{ laserwrite (bufadr, bufsize) char * bufadr; int bufsize; {i 	unsigned short iosb[4]; 	unsigned status;L	 	int	len;  	char * cp;N  < 	for (len = bufsize, cp=bufadr; len > 0; len -= smb_maxbuf,  						cp += smb_maxbuf) {c  - 		int l;	/* actual size written in one QIO */u   		do {  : 			if (smb_maxbuf < smb_maxbuf_ex-1) { /* need half > 0 *// 				smb_maxbuf += (smb_maxbuf_ex-smb_maxbuf)/2;a/ 				dprintf ("smb_maxbuf > -> %d", smb_maxbuf);f 			} 			l= min (smb_maxbuf, len);$ 			status= SYS$QIOW (0, stream.chan,% 					  IO$_WRITELBLK | IO$M_NOFORMAT,  					  &iosb, 0, 0,o 					  cp, l, 0, 0, 0, 0); 			if (status == SS$_EXQUOTA) {  				smb_maxbuf_ex= smb_maxbuf;% 				if (smb_maxbuf_lo < smb_maxbuf) {t 					smb_maxbuf -= s% 						(smb_maxbuf+1-smb_maxbuf_lo)/2;  				}	 				else	smb_maxbuf /= 2;e 				smb_maxbuf_lo= smb_maxbuf;) 				dprintf ("smb_maxbuf %d -> %d (%d)",  4 				      smb_maxbuf_ex, smb_maxbuf, smb_maxbuf_lo);1 				if (smb_maxbuf==0) bug ("smb_maxbuf zeroed");d 			}  		} while (status==SS$_EXQUOTA);      		if (status&1) status= iosb[0]; 		if ((status&1) == 0) { 			if (status==SS$_ACCVIO) d' 					checkstat (status, "Write Laser");e; 			dprintf ("Error during laserwrite: (%d) status= 0x%08X",E 				 l, status); 			SET_STOP_REASON (status);	 			break;= 		},    		if (stream.debug & DBG_DUMP) { #define DBG_DISP_MAX 64b
 			int lr; 			char * cpr;  4 			dprintf ("->:%.*s\n", min (DBG_DISP_MAX, l), cp);1 			for (lr= l-DBG_DISP_MAX, cpr= cp+DBG_DISP_MAX;  				lr > 0; 1 				     lr -= DBG_DISP_MAX, cpr += DBG_DISP_MAX)_4 			   dprintf ("  :%.*s\n", min (DBG_DISP_MAX, lr), 
 					cpr); 		}t  ! 		stream.bcnt += l;				/* stat */I 	}- /***		checkstat (status, "Write Laser");	***/E }D  ' #define ADDR_LEN(str) str, sizeof str-1c   c static void cancelread (sp)h stream_t * sp; {  	int 	stat;n 	int	SYS$CANCEL();   	PROT_START("cancelread")*   	print_astcnt("avant $cancel");=9 	stat = SYS$CANCEL (sp->chan);			/* cancel pending read*/a" 	checkstat (stat, "$CANCEL read"); 	sp->readast = false;h 	print_astcnt("apres $cancel");M 	stat= SYS$QIO (0, sp->chan,  			IO$_SETMODE|IO$M_CTRLYAST, 0, 			0, 0, 			0, 0, 0, 0, 0, 0);	  " 	checkstat (stat, "$CANCEL ^AST");% 	print_astcnt("apres $cancel ^YAST");i 	PROT_END("cancelread"), }* /* 1:  *	postlaserread - post non blocking read for stream.chan.  */cF static	void 	laser_read_ast();	/* laser read completion ast routine */ static void postlaserread (sp, purge)a( stream_t * sp;					/* context pointer */' int purge;					/* purge type-ahead ? */  {cG static 	const	int term_block[2] = {0,-1};	/* end read on any control */$ 	int 	stat;K  7 	PROT_START("postlaserread")		/* protect sp->readast */g   	if isfalse(sp->readast) {' 		stat = SYS$QIO (laser_efn, sp->chan, c/ 				IO$_READPBLK | ((purge) ? IO$M_PURGE : 0) , # 				laser_iosb, laser_read_ast, sp,$8 				laser_buf, sizeof laser_buf-1, 0, term_block, 0, 0);   		sp->readast = istrue (stat);6 		if isfalse(stat)	checkstat(stat, "$QIO laser read"); 	} 	else {t% 		dprintf	("BUG: postread multiple");o 	}   	PROT_END("postlaserread") }    /*6  *	laser_read_ast - laser read ast completion routine.  */, static void laser_read_ast(sp) stream_t * sp; {s 	int	iosb_stat;u 	char	savterm;   	iosb_stat = laser_iosb[0];p  C 	if ((iosb_stat == SS$_ABORT) || (iosb_stat == SS$_CANCEL)) return;a   	/* pour debug seulement */,  . 	if ((laser_iosb[1]==0) && (laser_iosb[3]==1))% 		dprintf ("<-X:%02X", laser_buf[0]); 7 	else	{		       /* imprimer le message + terminateur */C 		char prbuf [80]; 		int i; 		char * cp, * cpb;(  4 		for (i=0, cp=prbuf, cpb= laser_buf+laser_iosb[1];  						 i<laser_iosb[3];  						    i++, cp+= 2)  			sprintf (cp, "%02X", *cpb++);> 		dprintf ("<-:%.*s <-X:%s", laser_iosb[1], laser_buf, prbuf); 	}   	/* fin debug */  ( 	if ((laser_iosb[1]+laser_iosb[3]) != 0), 		sp->alive++;			/* note message received */  9 	savterm= laser_buf[laser_iosb[1]];	/* save terminator */o6 	laser_buf[laser_iosb[1]] = 0;		/* terminate string */  > 	if (iosb_stat != SS$_NORMAL){ 		/* if error or strange sts */0 		dprintf ("Badly received message %04X: %s\n",  			  iosb_stat, laser_buf);e 		if (iosb_stat==SS$_HANGUP) { 			SET_STOP_REASON (iosb_stat);; 			sp->lw_online= false;2 			stream.product[0]= '\0';	/* undefine product */ 		}	; 		if isfalse(sp->lw_online) return;	/* plus d'imprimante */,@ 		checkstat (iosb_stat,"laser read AST");	/* plus de symbiont */ 	}  4 	if (laser_iosb[1] != 0)				/* if bytes in buffer */2 		stream.logfile_write= isfalse(check_operator());  D 	if istrue (stream.logfile_write) writeuserlog(laser_iosb, savterm);   	sp->readast= false;0 	postlaserread (sp, 0);				/* issue next read */ }t  2 /*	***	routines de surveillance du terminal	***	*/   /* a1  *	postmbxattn	-	set attention AST for mailbox	GG   */s   static	void mbx_read_ast();g   static void
 postmbxattn()T { 
 	int stat;
 	int iosb[2];a  9 	stat = SYS$QIOW (0, mbxchan, IO$_SETMODE | IO$M_WRTATTN,3 			iosb, 0, 0,  			mbx_read_ast, 0, 0, 0, 0, 0);' 	checkstat(stat, "mbx write attn qio");  }{   /**  *	mbx_read_ast - read mbx attn message	GG  */  static void mbx_read_ast(param)o
 int param; {C 	int 	stat;i 	short	iosb[4];y! 	struct	{unsigned short msg_type;j 		 char msg_data[78];} mbx_buf;s   	postmbxattn();l  @ 	stat= SYS$QIOW (0, mbxchan, IO$_READVBLK|IO$M_NOW, iosb, 0, 0, * 			& mbx_buf, sizeof mbx_buf, 0, 0, 0, 0);? 	dprintf ("MBX msg: status= %08X; iosb status= %04X; code= %d",c$ 			stat, iosb[0], mbx_buf.msg_type); }  r0 	/***** Start of PostScript routines GG 		*****/U #define Makestring_p(c)  if (obufsiz==0) checkstat(LASER$_TOOMANYTABS,"makestring");\ " 			 else { obufsiz--; *cpo++ = c;}
 static char *,  makestring (ibuf, obuf, obufsiz) char * ibuf; char * obuf; int	obufsiz; {) 	char * cpi, * cpo;l   	cpo = obuf; 	Makestring_p('(');s 	for (cpi= ibuf; *cpi; cpi++) {s 		if (isprint(*cpi)) { 			switch (*cpi) { 			case ')': 			case '(':	/* yes ! */
 			case '\\':e 				Makestring_p('\\');n
 			default: ;; 			} 			Makestring_p(*cpi); 		}} 		else {	char sbuf[5];: 			sprintf (sbuf,"\\%03o", (int) * (unsigned char *) cpi); 			obufsiz -= 4;O 			if (obufsiz <= 0) checkstat (LASER$_TOOMANYTABS, "makestring control char");  			strcpy (cpo, sbuf); 			cpo += 4; 		}c 	} 	Makestring_p (')'); 	Makestring_p ('\0'); ) 	dprintf ("makestring returns %s", obuf);n  
 	return obuf;l }r. 	/***** End of PostScript routines GG 		*****/ r   static void_   get_config (sp)$  stream_t *sp;	/* inout stream */ {= 	FILE	*config;
 	int	rsiz;  	char	buffer[CONFIG_LINESIZE+1];$ 	char 	errbuf[CONFIG_LINESIZE+50+1]; 	char	*cpb;/ 	int	i;s  ( 	sp->lw_pw[0]= 0;	/* assume not found */ 	sp->lat_pw[0]= 0;2 	if (sizeof default_initstr <= sizeof sp->initstr)( 		strcpy (sp->initstr, default_initstr); 	else {i 		sp->initstr[0]= 0;G 		sendmess ("get_config: default INITSTR too long; ignored", MSG_OPER);b 	}  A 	config= fopen (CONFIG_FILE, "r", "ctx=rec",CONFIG_DEFAULT_FILE);e 	if (config==NULL) {; 		dprintf ("Erreur a l'ouverture du fichier de config: %s",w# 			  strerror (errno, vaxc$errno));f 	} 	else{ 	 	for (cpb=NULL;;) {\ 			char	* cpl; 			char 	* cpq;t   			buffer[sizeof buffer-1]= 0;5 			if (fgets (buffer, sizeof buffer-1, config)==NULL),
 				break;   			rsiz= strlen (buffer);t1 			if (buffer[rsiz-1] == '\n') buffer[rsiz-1]= 0;b' 			else	if (rsiz == sizeof buffer -1) {e 				buffer[rsiz] = 0;S> 				sprintf (errbuf, "Config: ligne trop longue: %s", buffer);  				sendmess (errbuf, MSG_OPER);  . 				continue;	/* invalid configuration line */ 			}  3 		/* on cherche le nom de la queue en majuscules */r  0 			cpl= buffer;		/* saute les blancs initiaux */$ 			for ( ; isspace (*cpl) ; ) cpl++;  , 			for (cpq= sp->queue; *cpq; cpq++,cpl++) { 				char cb;  1 				cb= (islower (*cpl)) ? toupper (*cpl) : *cpl;  				if (cb != *cpq) break; 			}  : 			for ( ; isspace (*cpl) ; ) cpl++; /* saut des blancs */% 			if ( *cpq || (*cpl!=CONFIG_SEP)) {S 				cpl[1]= 0;	/* pour debug */	* 				dprintf ("Pas bon: q= %s, ligne=[%s]", 					 sp->queue, buffer);<
 				continue;/ 			}	f   			cpb= cpl + 1;	 			break;i 		}n  . 		if ( (cpb==NULL) && (feof (config) == 0) ) {5 			sprintf (errbuf, "Config: erreur de lecture: %s", D# 				 strerror (errno, vaxc$errno));  			sendmess (errbuf, MSG_OPER);r 			/* erreur de lecture */ 		}    		fclose (config);   		if (cpb==NULL) {% 			dprintf ("Config line not found");] 		}  		else {
 			char * cp;,  ) 			dprintf ("Found config line %s", cpb);P  F 	/* premier champ: password laser = chaine de caracteres sans blancs*/  $ 			for ( ; isspace (*cpb) ; ) cpb++; 	t7 			for (i=1, cp= sp->lw_pw ; i<sizeof sp->lw_pw; i++) { B 				if ( (*cpb==0) || (*cpb==CONFIG_SEP) || isspace(*cpb) ) break; 				*cp++ = *cpb++;$ 			} 			*cp = 0;   $ 			for ( ; isspace (*cpb) ; ) cpb++; 			if (*cpb==0) return;t   			if ( *cpb != CONFIG_SEP ) {= 			sprintf (errbuf, "Config: ligne trop longue: %s", buffer);S  				sendmess (errbuf, MSG_OPER);, 				return;	/* invalid configuration line */ 			}  F 	/* deuxieme champ: password lat = chaine de caracteres sans blancs */  	 			cpb++;i$ 			for ( ; isspace (*cpb) ; ) cpb++; 	a9 			for (i=1, cp= sp->lat_pw ; i<sizeof sp->lat_pw; i++) {BB 				if ( (*cpb==0) || (*cpb==CONFIG_SEP) || isspace(*cpb) ) break; 				*cp++ = *cpb++;m 			} 			*cp = 0;_  $ 			for ( ; isspace (*cpb) ; ) cpb++; 			if (*cpb==0) return;d   			if ( *cpb != CONFIG_SEP ) {; 				sprintf (errbuf, "Config: ligne invalide: %s", buffer);   				sendmess (errbuf, MSG_OPER);, 				return;	/* invalid configuration line */ 			}  B 	/* troisieme champ: chaine de caracteres avec blancs supprims */  	 			cpb++;e  : 			for (i=1, cp= sp->initstr; i<sizeof sp->initstr; i++) {  				for (;isspace(*cpb);) cpb++;0 				if ( (*cpb==0) || (*cpb==CONFIG_SEP)) break; 				*cp++ = *cpb++;  			} 			*cp = 0;_   			if ( (*cpb!=0) ) { ; 				sprintf (errbuf, "Config: ligne invalide: %s", buffer);n  				sendmess (errbuf, MSG_OPER);, 				return;	/* invalid configuration line */ 			} 		}  	} }    r /*  *	utilitaires variesi  */c static inte( trnlnm (logname, logval, valsiz, vallen)C char * logname, *logval;	/* nom a traduire, buffer de traduction */_G int valsiz, * vallen;		/* taille buffer traduction, taille valeur lue*/G {* 	int status; 	uint16 retlen;p 	struct {uint16 bufsiz, bufcod;s 		ptr32  bufadr, retadr; 		uint32 endlist;}+ 		itmlist= {0, LNM$_STRING, NULL, NULL, 0};n6 static	const	unsigned long log_attr= LNM$M_CASE_BLIND;1 static	const	$DESCRIPTOR (tab_desc,"LNM$SYSTEM");r. 	struct dsc$descriptor log_desc= {0, 0, 0, 0}; 	int	SYS$TRNLNM();   	itmlist.bufsiz= valsiz-1; 	itmlist.bufadr= logval; 	itmlist.retadr= &retlen;P) 	log_desc.dsc$w_length= strlen (logname);g! 	log_desc.dsc$a_pointer= logname;	C 	status= SYS$TRNLNM (&log_attr, &tab_desc, &log_desc, 0, &itmlist);r 	if isfalse(status) retlen= 0;   	logval [retlen]= 0;G 	dprintf ("trnlnm %s returns %s status=0x%X", logname, logval, status);m 	*vallen= retlen;D 	return status&1;_ }S   static void get_debug (name) char * name; {  	char dbgbuf[256]; 	int	buflen; 	char buflnm[10];e  ( 	sprintf (dbgbuf,"LASER$DEBUG_%s",name);6 	if (trnlnm (dbgbuf, buflnm, sizeof buflnm, &buflen)){ 		unsigned long new_debug; 		new_debug= atol (buflnm);n" 		if (new_debug != stream.debug) { 			stream.debug= new_debug;"3 			dprintf ("New debug flags: 0x%X", stream.debug);s/ 			if ( (stream.debug&DBG_OPEN) && (debug==0)){s 				dbg_init (stream.queue);% 				if isfalse(debug) dbg_init(NULL);_ 			}0 			else if ( (stream.debug&DBG_CLOSE) && debug)  					dbg_close();O 		}$ 	} 	else	if istrue (debug){ 		dbg_close(); 		stream.debug = 0;t 	} }c   static char * to_date (dateptr)T int dateptr; {S static	char	date[24];d+ static	const	$DESCRIPTOR (date_desc, date);  	unsigned short	retlen;s 	unsigned long	stat; 	int	SYS$ASCTIM();  4 	stat= SYS$ASCTIM (&retlen, &date_desc, dateptr, 0);. 	if isfalse(stat) checkstat (stat, "$ASCTIM"); 	date[retlen]= 0;_
 	return date;  }e static char * to_uic (num) int num; {  static	char	uicval[80];U, static	const	$DESCRIPTOR (uicval_d, uicval);* static	const	$DESCRIPTOR (ctrstr_d,"!%I");
 	int	stat; 	uint16	retlen;t 	int	SYS$FAO();m  4 	stat=	SYS$FAO (&ctrstr_d, &retlen, &uicval_d, num); 	checkstat (stat,"$FAO uic");  	return	uicval;e }t  P /******	A T T E N T I O N: la routine suivante utilise une QIO non supportee **/ static void
 getlatinfo ()p {e 	unsigned long stat, iosb[2];  	char buf[256], buf1[258];  N 	stat= SYS$QIOW (0, stream.chan, IO$_TTY_PORT | IO$M_LT_READPORT, &iosb, 0, 0,  			buf, sizeof buf, 0, 0, 0, 0);! 	if ( (stat&1) && (iosb[0]&1) ) {3 		char * cp = buf+buf[0]+1;b; 		sprintf (buf1, "%.*s%/%.*s", cp[0], cp+1, buf[0], buf+1);uB 		strncpy (stream.printernode, buf1, sizeof stream.printernode-1);H 		stream.printernode [min(sizeof stream.printernode-1, strlen(buf1))]=0; 	} }t  9 /*	celle-la est supporte... Si Latmaster est install */e   static booleanc latmaster_init (sp) $ stream_t * sp;		/* current stream */ {d 	int st; 	unsigned short iosb [4];u 	uint8 buf[400]; 	uint8 * cp = buf;	 	int len;g  1 	/* on lit toutes les caractristiques du port */   G 	st= SYS$QIOW (0, stream.chan, IO$_TTY_PORT | IO$M_LT_SENSEMODE, &iosb,  			0, 0, 	   		buf, sizeof buf,  7 			LAT$C_ENT_PORT | (LAT$M_SENSE_FULL << 16), 0, 0, 0);c 		; 	dprintf ("LT sense: status= %08X, IOSB: %08x %04x %04x\n",s/ 		  st, * (long *) (iosb+2), iosb[1], iosb[0]);i  1 	if ( (st&iosb[0]&1) ==0) return false;	/* Bf */o   	len = iosb[2];r   	for (; cp < buf+len; cp+=2)	{ 		char namebuf[80];E 		char * fullname;' 		int itmname= * (unsigned short *) cp;R   		switch (itmname) {9 			case LAT$_ITM_PORT_TYPE: fullname= "Port type"; break;t; 			case LAT$_ITM_QUEUED: fullname= "Enable queuing"; break;;I 			case LAT$_ITM_DISCONNECT_REASON: fullname= "Disconnect reason"; break;s9 			case LAT$_ITM_PORT_NAME: fullname= "Port name"; break;sM 			case LAT$_ITM_TARGET_SERVICE_NAME: fullname= "Target service name"; break;sG 			case LAT$_ITM_TARGET_NODE_NAME: fullname= "Target node name"; break; G 			case LAT$_ITM_TARGET_PORT_NAME: fullname= "Target port name"; break; F 			case LAT$_ITM_SERVICE_CLASS: fullname= "Port service class"; break;E 			case LAT$_ITM_DISPLAY_NUMBER: fullname= "X display number"; break;u #ifdef __ALPHA< 			case LAT$_ITM_COUNTERS: fullname= "Port counters"; break; #endif 			default:{4 				sprintf (namebuf, "Item code #0d%d: ", itmname); 				fullname= namebuf; 			} 		} ' 		if ( (itmname & LAT$M_STRING) != 0) {a 			int strsz = cp[2];e 			int copysz;   #ifdef __ALPHA$ 			if (itmname==LAT$_ITM_COUNTERS) { 				int rmsiz= strsz;[ 				uint8 * ctrptr= cp+3;	  " 				dprintf ("\t%s:\n", fullname); 				while (rmsiz > 0) {b* 					uint16	ctr_name= * (uint16 *) ctrptr; 					uint32	ctr_val; 					uint8	ctr_siz;e 					char namebuf[80]; 					char * fullname;r    					if (ctr_name&LAT$M_STRING){ 						ctr_siz= ctrptr[2];s 						ctrptr++;  							/* account for str len*/	 					}
 					else{ 						ctr_siz= 4;u 					}   					switch (ctr_name) { 			case LAT$_ITM_CTPRT_SSZ: , 				fullname= "Seconds since zeroed"; break; 			case LAT$_ITM_CTPRT_BYTR: a& 				fullname= "Bytes received"; break; 			case LAT$_ITM_CTPRT_BYTT: 	) 				fullname= "Bytes transmitted"; break;s 			case LAT$_ITM_CTPRT_LCL: & 				fullname= "Local accesses"; break; 			case LAT$_ITM_CTPRT_RMT: ' 				fullname= "Remote accesses"; break;  			case LAT$_ITM_CTPRT_SLCA: *. 				fullname= "Solicitations accepted"; break; 			case LAT$_ITM_CTPRT_SLCR: (- 				fullname= "Solicitations refused"; break;( 			case LAT$_ITM_CTPRT_ISOLA:g7 				fullname= "Incoming solicitations accepted"; break;c 			case LAT$_ITM_CTPRT_ISOLR: 6 				fullname= "Incoming solicitations refused"; break;  			case LAT$_ITM_CTPRT_FRAMERR: & 				fullname= "Framing errors"; break; 			case LAT$_ITM_CTPRT_PARERR:% 				fullname= "Parity errors"; break;a 			case LAT$_ITM_CTPRT_OVERRUN:   				fullname= "Overruns"; break;# 			case LAT$_ITM_PASSWORD_FAILURES: ) 				fullname= "Password failures"; break;  			default: 3 				sprintf (namebuf, "Counter #0d%d: ", ctr_name);t 				fullname= namebuf; 					}  % 					ctr_val= *(uint32 *) (ctrptr+2);*  ( 					dprintf ("\t\t%s\t: %8u (%u %u)\n", 							fullname, a 							(unsigned) ctr_val, 							ctr_siz,n 							rmsiz); 					ctrptr += 2+ctr_siz;u 					rmsiz -=  2+ctr_siz;  				}  				if (rmsiz != 0) & 					dprintf ("BUG:rmsiz=%d\n",rmsiz); 			} 			else	 #endif4 				dprintf ("\t%s: %.*s\n", fullname, strsz, cp+3);   			switch (itmname) {i" 			case LAT$_ITM_TARGET_NODE_NAME:4 				copysz= min (strsz,sizeof stream.printernode-1);8 				strncpy (stream.printernode, (char *) cp+3, copysz);" 				stream.printernode[copysz]= 0;
 				break;% 			case LAT$_ITM_TARGET_SERVICE_NAME: 4 				copysz= min (strsz,sizeof stream.servicename-1);8 				strncpy (stream.servicename, (char *) cp+3, copysz);" 				stream.servicename[copysz]= 0;
 				break; 			} 			cp+= strsz+1; 		}  		else	{7 			dprintf ("\t%s: %lu\n", fullname, *(long *) (cp+2));	
 			cp+= 4; 		}x 	}  > 	/* on signale une fin anormale si la longueur du buffer ne */2 	/* correspond pas  celle signale dans l'IOSB */   	if  (cp!= buf+len) 7 		dprintf ("Fin de buffer anormale: cp=%08X, exp=%08X",  				cp, buf+len);E> 	else 	dprintf ("Noeud: %s, Service: %s\n",stream.printernode, 						    stream.servicename);  @ 	/* si le password est non nul, alors on fait setmode du port */! 	/* pour specifier ce password */%   	len= strlen (sp->lat_pw); 	if (len) {N  		struct { unsigned short code; - 			unsigned char length;	/* password asciz */P) 			char password[CONFIG_PASSWORD_SIZE+1];d 		      }	setbuf;,  ) 		setbuf.code= LAT$_ITM_SERVICE_PASSWORD;B' 		strcpy (setbuf.password, sp->lat_pw);r 		setbuf.length= len;D  L 		dprintf ("setbuf %u %d %s", (unsigned) setbuf.code, len, setbuf.password);  ? 		st= SYS$QIOW (0, stream.chan, IO$_TTY_PORT | IO$M_LT_SETMODE,} 			      &iosb, 0, 0,u$ 			      & setbuf, 3+setbuf.length, : 			      LAT$C_ENT_PORT| (LAT$C_ENTS_OLD << 16), 0, 0, 0); 	e= 		dprintf ("LT setmode status: %08X, IOSB: %08x %04x %04x\n", / 				st, * (long *) (iosb+2), iosb[1], iosb[0]);a 	}  
 	return true;  }Y 	A) /**	findandclritem - find and clear item.a *c= *	Finds an item in the item list. Releases the dynamic stringt< *	for that item. If the item doesn't exist in the item list, *	create it. *T$ *	return:	index to item in item list */
 static int findandclritem(whichitem); int whichitem; {rK static	struct dsc$descriptor_d temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};p 	int i;l  6 	for (i = 0; i < itmax; i++) {		/* search item list */' 		if (whichitem == item[i].item_code) {t7 			temp.dsc$w_length = item[i].item_size;	/* release */t5 			temp.dsc$a_pointer = item[i].buffer;	/*  string */g 			STR$FREE1_DX (&temp); 			item[i].buffer = 0; 			return i; 		}e 	} 		/* new item */H 	if (itmax++ > MAXITEMS)  checkstat (LASER$_MAXITEMS, "findandclritem"); 	item[i].item_code = whichitem;{ 	item[i].item_size = 0;_ 	item[i].buffer = 0; 	return i;			/* return index */R }:  , /**	checkspooled - check for a spooled file. *a> *	If the filename has "[]_" in it, then this is a spooled file< *	that the user wants to specify the form name for. Further,8 *	if the extension starts with "_", then it contains the= *	user parameter list.  We forge the item list to make thingsr
 *	look right.e */ checkspooled() {oK static	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};_E 	struct dsc$descriptor_d dynd = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};a 	char *cp, *pp, spoolfile[255];S 	int len, i, stat; 	int ourindex;1 	char setup[257];			/* where to put setup name */e$ 	long iosb[2];				/* for $getquiw */1 	uint16 setupl;				/* returned length of setup */s) 	struct {				/* item list for $getquiw */  		uint16	bufsiz1, bufcod1; 		ptr32	bufadr1, retadr1;  		uint16	bufsiz2, bufcod2; 		ptr32	bufadr2, retadr2; 
 		uint32	end;,- 	} itmlst = {0, QUI$_SEARCH_NAME, NULL, NULL,p- 		    0, QUI$_FORM_SETUP_MODULES, NULL, NULL,u	 		    0};  	int	SYS$GETQUIW();/  ! 	itmlst.bufsiz2= sizeof setup -1;) 	itmlst.bufadr2= setup;/ 	itmlst.retadr2= &setupl;  	stream.spooled_file = false;b 	]! /*  get the file specification */f  H 	if (!getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, false)) return; 		; 	strncpy(spoolfile, temp.dsc$a_pointer, temp.dsc$w_length);s" 	spoolfile[temp.dsc$w_length] = 0; 		 /*  check for []_ */ 	=, 	if (!(cp = strchr(spoolfile, '['))) return; 	if (!(*++cp == ']')) return;	4 	stream.spooled_file = true;			/* file is spooled */ 	if (!(*++cp == '_')) return;e 	n8 /*  find the extension and terminate the name string */	 	d% 	if (!(pp = strchr(cp, '.'))) return;i	 	*pp = 0;s 	cp++;  6 /*  translate the form name into setup module names */8 /*  If it won't translate, then pass on the form name */  3 	itmlst.bufsiz1 = strlen(cp);			/* point to name */  	itmlst.bufadr1 = cp;(B 	stat = SYS$GETQUIW(0, QUI$_DISPLAY_FORM, 0, &itmlst, iosb, 0, 0); 	checkstat(stat, "getquiw");2 	if ((iosb[0] & 1) != 1) 		/* if no translation */ 		strcpy(setup, cp); 	elsed 		setup[setupl] = 0;  @ /*  forge the file setup module to have our setup module name */H /*  Note that the forge transfers the dynamic string "dynd" to "item" */  8 	ourindex = findandclritem(SMBMSG$K_FILE_SETUP_MODULES);0 	dynd.dsc$w_length = 0;		/* get dyamic string */ 	dynd.dsc$a_pointer = 0; 	len = strlen(setup); ! 	STR$COPY_R (&dynd, &len, setup);tC 	item[ourindex].item_size = dynd.dsc$w_length;	/* complete forge */}, 	item[ourindex].buffer = dynd.dsc$a_pointer;  0 /*  forge the form name to have our form name */ 		/ 	ourindex = findandclritem(SMBMSG$K_FORM_NAME);f0 	dynd.dsc$w_length = 0;		/* get dyamic string */ 	dynd.dsc$a_pointer = 0;/ 	len = strlen(cp);			/* pointer to form name */S 	STR$COPY_R (&dynd, &len, cp);C 	item[ourindex].item_size = dynd.dsc$w_length;	/* complete forge */k, 	item[ourindex].buffer = dynd.dsc$a_pointer; 	 / /*  now check to see if there are parameters */   * 	cp = ++pp;				/* set extension address */9 	if (pp = strchr(cp,';')) *pp = 0;	/* terminate at ";" */  	r 	for (i = 0; i < 8; i++) {0 		if (*cp != '_') return;		/* check next char */  		cp++;				/* advance over it */  = 		/* if there is another _, point to it, else point to the */  		/* end of the string 					 */l7 		if ((pp = strchr(cp,'_')) == 0) pp = cp + strlen(cp);n  . 		len = pp - cp;			/* find length of string */2 		if (len == 0) continue;		/* if null parameter */   		/*  forge the item */p4 		ourindex = findandclritem(SMBMSG$K_PARAMETER_1+i);2 		dynd.dsc$w_length = 0;		/* get dynamic string */ 		dynd.dsc$a_pointer = 0;r 		STR$COPY_R (&dynd, &len, cp);P/ 		item[ourindex].item_size = dynd.dsc$w_length;_- 		item[ourindex].buffer = dynd.dsc$a_pointer;r 		
 		cp = pp; 	} }i  . /**	expand_hex - expand buffer into hex bytes. */ static voidF expand_hex(ibuf, obuf, rsz)b4 unsigned char *ibuf;			/* pointer to input buffer */- char *obuf;				/* pointer to output buffer */t) int *rsz;				/* pointer to buffer size */n {t- static	const	char hex[] = "0123456789ABCDEF";] 	int i;e 	int c;g 	c 	for (i = 0; i < *rsz; i++) {;) 		obuf[i*2] = hex[(ibuf[i] & 0xF0) >> 4];n# 		obuf[i*2+1] = hex[ibuf[i] & 0xF];D 	}   	*rsz = (*rsz) * 2;= }L   	 , /**	expand_ascii - expansion des tabulations *			et des caracteres spciaux.r */H #define SEQ(c1,c2) {*cpo++=c1; *cpo++= '\b' ; *cpo++= c2; col++;}; break static void & expand_ascii(ibuf, obuf, rsz, obufsiz)! char *ibuf;				/* input buffer */i" char *obuf;				/* output buffer */) int *rsz;				/* pointer to buffer size */'+ int obufsiz;				/* output buffer size GG */  {e) 	int col;				/* n de colonne courante */	0 	char * cpi, *cpo= obuf, *obufend= obuf+obufsiz;  C 	assert((obufsiz&7) == 0);	/* sinon on risque un ecrasement mem. */d    	col = 0;				/* preset column */  + 	for (cpi= ibuf; cpi < ibuf+ *rsz; cpi++) {r  * 		if ( (stream.job_type==print_headers) &&> 		     ( (*cpi=='\003') || (*cpi=='\004') || (*cpi=='\024') ||0 		       (*cpi & 0x80)  || (*cpi == '\\') )  ) { 			if (cpo+4 >= obufend) { 				cpo= obufend; 
 				break; 			}E 			sprintf (cpo,"\\%d", (int) * (unsigned char *) cpi); /* oui: %d */c 			cpo += 4;	 			col++;p 		}N 		else 			switch (*cpi) { 			case '\t':		/* tab */ 				do {$ 					*cpo++ = ' ';	/* fill spaces */! 					col++;		/* advance column */	 				} while (col & 7);
 				break; 			case '\b':		/* backspace */ 				if (col > 0) {* 					*cpo++ = *cpi;	/* insert backspace */ 					col--;, 				}	
 				break;   				*cpo++ = '.'; 
 				break; /*+ /*			/* caracteres de control postscript */  /*			case '\003':	/* ^C */ /*			case '\004':	/* ^D */ /*				*cpo++ = '.';t /*				break; /**/" 			/* caractre non particulier */* 			default: *cpo++ = *cpi;	/* move char */ 				  col++; 			} 		if (cpo == obufend) break; 	}, 	*rsz = cpo-obuf;				/* return new length */ }     1 /**	getitems - get item list from job controller.+ */ static void getitems()* {=
 	int	stat;/ 	int	context;			/* read_message_item context */ ! 	int	item_code;			/* item code */s# 	uint16	item_size;		/* item size */0, static	struct dsc$descriptor_d item_buffer =) 				{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};g 	int	SMB$READ_MESSAGE_ITEM();s  # 	context = 0;				/* init context */v   /*  Save each item in a list */  	  	do {e@ 		item_buffer.dsc$a_pointer = 0;	/* force d string allocation */  6 		stat = SMB$READ_MESSAGE_ITEM (&buffer_des, &context,, 			 		&item_code, &item_buffer, &item_size);    		if (stream.debug & DBG_JOBCTL)1 			dprintf ("Get items: item #%d, status=0x%X\n",c 				 item_code, stat);   		if isfalse(stat) break;b  A 		if (itmax >= MAXITEMS) checkstat (LASER$_MAXITEMS, "getitems");)  $ 		item[itmax].item_code = item_code;$ 		item[itmax].item_size = item_size;1 		item[itmax].buffer = item_buffer.dsc$a_pointer;u
 		itmax++;   	} while (true); }m    , /**	getitemdescrip - return item descriptor. */ *	return:	true if item found) *		false if (item not found) && NOT FATAL)$ *		exit if (item not found) && FATAL */ static boolean $ getitemdescrip(code, descrip, fatal)+ int code;					/* item code to search for */p> struct dsc$descriptor_s *descrip;		/* pointer to descriptor */' boolean fatal;					/* error severity */; {	 	int	i;	   	for (i = 0; i < itmax; i++) {1 		if (item[i].item_code == code) {	/* if found */i- 			descrip->dsc$w_length = item[i].item_size;v+ 			descrip->dsc$a_pointer = item[i].buffer;o 			return true;f 		}  	}   		/* item not in list */   	if istrue(fatal)e4 		checkstat (LASER$_ITEMNOTFOUND, "getitemdescrip"); 	else	return false;r }    1/ /**	getcopies - send copy count to laserwriter.i *2< *	Leave this here for now, but unfortunately, if you specify9 *	/copies=n to the print command, the job contoller sendsc. *	the file that many times.  Not what we want. */ getcopies()r {g
 	int stat, n;,E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};= 	char defcopy[80];  9 	if (!getitemdescrip(SMBMSG$K_FILE_COPIES, &temp, false)) 9 		if (!getitemdescrip(SMBMSG$K_JOB_COPIES, &temp, false))o 			return;			/* if no copies */&  " 	n = * (long*) temp.dsc$a_pointer;+ 	if (n == 1) return;			/* if only 1 copy */n, 	sprintf(defcopy, "/#copies %d def\r\n", n);  % 	laserwrite(defcopy,strlen(defcopy));t }s   /*-  *	getnote - get /note=<Text> to laserwriter.m  */  static voidf	 getnote()t {fK static	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};n
 	int stat; 	fE 	if (!getitemdescrip(SMBMSG$K_NOTE, &temp, false)) return; /* none */= 	o3 	laserwrite (temp.dsc$a_pointer,temp.dsc$w_length);s4 	laserwrite (lw_crlf, sizeof lw_crlf);			/* cr-lf */ }x ,+ /**	copymodule - write module from library.P * 3 *	return:	true if module could be found (even if itf *			could not be sent properly) 1 *		false if library not found OR module not foundg */ static booleanO copymodule(key)	 struct dsc$descriptor_s key; {; 	int stat, len;= 	int library_index;c 	long txtrfa[2]; 	char inbuf[255];e$ 	struct dsc$descriptor_s inbufdes = 6 		{sizeof inbuf , DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL};# 	struct dsc$descriptor_s outbufdes;t 	int 		LBR$CLOSE(), 		LBR$GET_RECORD(),n 		LBR$INI_CONTROL(), 		LBR$LOOKUP_KEY(),t
 		LBR$OPEN();a  3 	if (library_spec.dsc$a_pointer == 0) return false;    	inbufdes.dsc$a_pointer= inbuf;uC 	dprintf ("Copy module %.*s", key.dsc$w_length, key.dsc$a_pointer);   I 	stat = LBR$INI_CONTROL (&library_index, &LBR$C_READ, &LBR$C_TYP_TXT, 0);l$ 	checkstat(stat, "LBR ini_control");  @ 	stat = LBR$OPEN (&library_index, &library_spec, 0, 0, 0, 0, 0); 	checkstat(stat, "LBR open");*  6 	stat = LBR$LOOKUP_KEY (&library_index, &key, txtrfa);' 	if isfalse (stat) {			/* if bad key */t$ 		stat = LBR$CLOSE (&library_index);# 		checkstat(stat, "close library");  		return false;0 	}   	do {,@ 		stat = LBR$GET_RECORD (&library_index, &inbufdes, &outbufdes); 		if isfalse(stat) break;& 		 		len = outbufdes.dsc$w_length;  #ifdef DBGMODULE' 		dprintf ("Module: %.*s", len, inbuf);  #endif 		inbuf[len++] = '\r'; 		inbuf[len++] = '\n';   		laserwrite(inbuf,len); 		! 	} while (stream.stop_reason==0);a  5 	if ( (stream.stop_reason==0) && (stat != RMS$_EOF) ) ' 		checkstat (stat, "Copymodule: read");  # 	stat = LBR$CLOSE (&library_index);t 	checkstat(stat, "LBR close");  
 	return true;  }t ;. static boolean	/* param parsed successfully */ parse1param (def, str, numpar)  char * def;	/* raw definition */# char * str;	/* parsed definition */0% char * numpar;	/* parameter number */E {M 	char * eq, * cp;   % 	if (strlen (def) == 0) return false;T  / 	for (cp=def; *cp; cp++)	/* lowercase string */d( 		if (isupper(*cp)) *cp = tolower (*cp);  B /*  if there is an = separator (or - for spooled files), use it */7 	if ((eq = strchr(def, '=')) || (eq = strchr(def, '-'))n 		|| (eq = strchr(def, ':'))) {l% 		*eq++ = 0;			/* bust string in 2 */h  2 	/* we allow: anything beginning like data_type */3 	/* and a value that is exactly "postscript"     */E  6 		if (!strncmp (def,"data_type",eq-def-1) &&		/* GG */= 		    !strcmp (eq,"postscript")) {  	  /* check parameter  */C8 			postscript= true;   	    /* "data_type=postscript" */2 			return false;		/* to force "POSTSCRIPT" form */ 		}							/* GG */  ' 		sprintf(str, "(%s) %s\r\n", def, eq);  	}4 	else sprintf(str, "(param%d) %s\r\n", numpar, def);
 	return true;  }e /*#  *	getparams - get user parameters.N&  *	if present write /param [ ... ] def:  *		if parameter name given ... = (<paramname>) <paramval>+  *		else			... = (param<param#>) <paramval>E  *		and copy PARSER module  */b static voidf getparams()c { C static	const	$DESCRIPTOR(parser,"PARSER");	/* parser module name */u 	int numpar; 	int first=true;K static	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};m   	postscript= false;			/* GG */  E 	for (numpar = 0; numpar < 8; numpar++) {/* loop for 8  parameters */I 		char param[255], str[255+15];r  A 		if (!getitemdescrip(SMBMSG$K_PARAMETER_1+numpar, &temp, false));# 			continue;		/* if no parameter */1  < 		if (temp.dsc$w_length == 0) continue;	/* if null string */  8 		strncpy(param, temp.dsc$a_pointer, temp.dsc$w_length); 		param[temp.dsc$w_length] = 0;G  ; 		if isfalse (parse1param (param, str, numpar+1)) continue;o  $ 		if (first) {				/* if first one */ 			first = false; * 			laserwrite (ADDR_LEN("/params [\r\n")); 		}I   		laserwrite(str,strlen(str)); 	}  G 	if istrue (first) { /* if no parameters given, use the submit queue */s 			    /* default parameters */I 		char lognam [256]; 		char logval [256]; 		int  logsiz; 		int  numpar; 		char * endstr, * start;e  . 		getitemdescrip(SMBMSG$K_QUEUE, &temp, true);= 		sprintf (lognam, "LASER$PARAMETER_%.*s", temp.dsc$w_length,I 							 temp.dsc$a_pointer);  		lognam [sizeof lognam -1] = 0;2 		trnlnm (lognam, logval, sizeof logval, &logsiz);  . 		for (numpar=1, start= logval, endstr= logval 				; endstr != NULL# 				; numpar ++, start= endstr+1) {; 			char str[255];A   			endstr= strchr (start, ','); $ 			if (endstr!= NULL) *endstr= '\0';9 			if isfalse(parse1param (start, str, numpar)) continue;g$ 			if (first) {			/* if first one */ 				first = false;+ 				laserwrite (ADDR_LEN("/params [\r\n"));I 			} 			laserwrite(str,strlen(str));r 		}  	}  2 	if isfalse (first) {			/* if some params found */% 		laserwrite (ADDR_LEN("] def\r\n"));u4 		copymodule(parser);		/* write the parser module */ 	} }	 u. /*	getsetup - get setup module to laserwriter.  *5  * 	cette routine est appelle au dbut de chaque JOBn  *1  *	return:	true if no problems with setup module.	,  *	        false if setup module nonexistant  */s static boolean-
 getsetup() { K static	struct dsc$descriptor_s key =  {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};	 		: 	stream.hexdump = false;			/* assume main file is ascii */: 	stream.setupsent= true;			/* flag setups (for error    */ 						/* detection) GG */r  J /*  Try for a file setup module first, then a form setup module.  For now,H     we only support one setup module, the first found. We should support-     lists of setup modules, and all found. */r 	sA 	if (!getitemdescrip(SMBMSG$K_FILE_SETUP_MODULES, &key, false)) {r@ 		if (!getitemdescrip(SMBMSG$K_FORM_SETUP_MODULES, &key, false))& 			return true;		/* if no setup, OK */ 	}D 	if (key.dsc$w_length == 0) return true;	/* assume no setup => OK */ 	 G /*  Get out if no library. Error because the user specified a setup. */   ' 	if (library_spec.dsc$a_pointer == 0) { ) 		SET_STOP_REASON (LASER$_SETUPNOTFOUND);  		return false;e 	}  I /*  If the setup module name ends in "_HEX", set the hexdump file flag */%   	if (key.dsc$w_length >= 4)	H 	   if (strncmp(&key.dsc$a_pointer[key.dsc$w_length-4], "_HEX", 4) == 0) 		stream.hexdump = true; 	sI /*  if this is the setup module HEADERS, assume it needs to have the fileu     name defined. */  9     	if (strncmp(key.dsc$a_pointer, "HEADERS", 7) == 0) { L static		struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}; 		char inbuf[255];  ; 		if (postscript) return true;	/* if postscript we ignore*/l  						/* the HEADERS setup GG */  ! 		stream.job_type= print_headers;u  ; 		getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, true);I. 		sprintf (inbuf, "/filename (%.*s) def \r\n", 				temp.dsc$w_length, 				temp.dsc$a_pointer);" 		laserwrite(inbuf,strlen(inbuf));  - 		/*  Also send the form name if it exists */S  9 		if (getitemdescrip(SMBMSG$K_FORM_NAME, &temp, false)) { / 			sprintf (inbuf, "/formname (%.*s) def \r\n",d 					temp.dsc$w_length,a 					temp.dsc$a_pointer);e# 			laserwrite(inbuf,strlen(inbuf));m 		}r 	} 		 	/*  Send the setup module */n   	if isfalse(copymodule(key)) {) 		SET_STOP_REASON (LASER$_SETUPNOTFOUND);  		return false;i 	}   	stream.setupsent= true; 	 
 	return true;  }t s static voidc keyin_timer_ast(sp)S
 stream_t *sp;C {C 	sp->timeout= true;l 	dprintf ("Keyin timeout");+ 	wake_me();c }t /*;  *	keyin:	 ask a question to the printer. wait for response$&  *	returns	>0: keyin done successfully  *		 0: stream.stop_reason <> 0m   *		<0: lw has gone disconnected  */1 static int  keyin (quest, quest_l,        test, ignerr) char * quest;	/* question */$ int quest_l;	/* longueur question */P int (* test)(int t, int * at);/* routine de test (renvoie >0 si fin de keyin) */4 		/* sinon, pour le prochain intervalle de temps: */1 		/*  renvoie  0 s'il faut reposer la question */f8 		/*  renvoie <0 s'il ne faut pas reposer la question */= 		/* argument t: nombre de priodes de 5mn coules depuis */f# 		/* le dbut de l'appel a keyin */tK boolean	ignerr;	/* continue the keyin sequence regardless of stop_reason */i {t 	int	stat;				/* status VMS *// 	int	timeoutcount;			/* compteur de timeouts */t3 	int	timeoutwarn;			/* quand avertir l'oprateur */s) 	int	tval= 0;			/* renvoye par le test */P 	int	SYS$CANCEL(); 	int	SYS$SETIMR(); 	int	SYS$CANTIM();  ) 	dprintf ("Keyin: %.*s", quest_l, quest);u  . 	stream.timeout= true;			/* timer requested */  , 	for (timeoutcount = 0, timeoutwarn = 0;;) {  2 		stream.alive= 0;		/* counts messages received */  . 		if (tval >= 0 ) laserwrite (quest, quest_l);   		if istrue (stream.timeout) {( 			stat = SYS$SETIMR (0,	&keyin_daytim,  						&keyin_timer_ast,  						&stream, 					   0);A% 			checkstat (stat, "$SETIMR keyin");T 			stream.timeout= false;	 		}}   		hibernate();  ! 		if isfalse (stream.lw_online) {u 			tval= -1;	 			break;s 		}/  > /*	if stop_reason is set, we exit from keyin with a 0 value */5 /*	unless ignerr is set, in which case we continue */r  1 		if (isfalse(ignerr) && (stream.stop_reason)) {	; 			tval= 0;y	 			break;  		}d  4 			/*  Notify the operator on 1 minute intervals. */   		if istrue (stream.timeout) { 		   timeoutcount++;> 		   if ((stream.alive==0) &&	/* rien recu de l'imprimante  */@ 		       (timeoutcount > timeoutwarn)) { /* tous les n(n+1)/2 */; 			 if (timeoutcount > 120) timeoutwarn += 120;/* 1H max */a& 			 else		timeoutwarn += timeoutcount;5 			 if (timeoutcount > 20) /* after at least 10 mn */r, 				 sendmess ("LaserWriter possibly hung",	 							MSG_OPER|MSG_USER); 			} 		}s  @ 		/* si nous avons t rveills par un wake, mais en n'ayant */@ 		/* rien recu de l'imprimante, si l'AST du timer n'a pas t */A 		/* execute, on ne fait rien et on ne repose pas la question */i  7 		if ( (stream.alive==0) && isfalse (stream.timeout) ){s 			dprintf ("Spurious wake");u 			tval= -1; 		}g4 		else	tval= (* test) (timeoutcount, &timeoutcount);   		if (tval > 0) break;	/* Ok */r 	}  I 	(void) SYS$CANTIM (&stream, 0);	/* trop de precautions a prendre pour */I 					/* faire ca proprement */  
 	return tval;e }y c /*?  *	determine product type (before Sync'ing) because ^T does NOTP#  *	work on some printers (e.g. QMS)i&  *	will wait at most 6*keyin intervals  */e static int  getproduct_t(i)u int i; {.% 	int retval = stream.product[0] != 0;m: 	if (i>2) retval=1;	/* don't hold for long if no answer */' 	dprintf ("Get product_t: %d", retval);= 	return retval;c }r static int. getversion_t(i); int i; {r% 	int retval = stream.version[0] != 0; : 	if (i>2) retval=1;	/* don't hold for long if no answer */' 	dprintf ("Get version_t: %d", retval);  	return retval;u }r static void getproduct() {  static const char questprod[]= a "\004 statusdict begin \: (\\n%%[ Product =) print product print (\\n) print flush \	 end\004";e static const char questvers[]=   "\004 statusdict begin \: (\\n%%[ Version =) print version print (\\n) print flush \	 end\004";   ; 	keyin (questprod, sizeof questprod-1, getproduct_t, true);e+ 	dprintf ("Product: [%s]", stream.product);(3 	if (strcmp (stream.product, "QMS-PS 1700") == 0) { < 		keyin (questvers, sizeof questvers-1, getversion_t, true);, 		dprintf ("version: [%s]", stream.version);) 		/* bug seen with firmware version 22 */i #ifdef QMS1700_BUG2 		stream.QMSbug= strcmp(stream.version,"52.4")==0; #endif 	} } /*(  * getidle: get idle status from printer,  *	input: ignerr= ignore stop_task condition  */e static intm6 getidle_t(time, timeaddr)			/* test synchronisation */	 int	time;  int	*timeaddr; {p  ? 	if istrue(stream.status_idle) return 1;		/* if sync occured */,   	if (stream.product[0] == 0) {& 		getproduct();				/* in case of .. */@ 		if (stream.product[0] != 0) return 1;	/* maybe the question */ 							/* needs to be changed*/a? 		if istrue(stream.status_idle) return 1;	/* if sync occured */ 9 		time+= 6;	    /* account for time lost in getproduct */  		*timeaddr += 6; 5 		stream.timeout= true;	/* account for klutzy code */  	}  4 	/* au bout de MAXBUSY intervalles, on casse tout */   	if (time > MAXBUSY){  		stream.lw_clear= true;# 			/*  Abort whatever is running */o* 		laserwrite (&lw_abort, sizeof lw_abort);" 		dprintf ("getidle: abort sent"); 		return 1;		/* retry */ 	}    5 	/*	sinon, au bout d'1 minute, on envoie des CR/LF	*/f  : 	else	if (time > 2) laserwrite (&lw_crlf, sizeof lw_crlf);  > 	if istrue(stream.stop_task) return 1;	/* goto check ignerr */  < 	return 0;		       /* on reste dans keyin sans changement */ }    static boolean getidle(ignerr) 1 boolean ignerr;		/* ignore stop_task condition */; {i3 static	const	char	syncchar='\024';		/* Control-T */p static	const	char	QMSquest[]= 8 	"(\\n%%[ status: idle ]%%] QMSBUG\\n) print flush\004"; 	int	kstat;)  8 	stream.status_idle = false;		/* par dfaut: pas IDLE */ 	stream.lw_sync = true;; 	stream.nousermsg= true;  ( 	dprintf ("Getidle >>> %s", to_date(0));  B 	/* on envoie ^T pour avoir le status, et on attend le rsultat */   	do {\ 		if istrue(stream.QMSbug)- 			kstat= keyin (QMSquest, sizeof QMSquest-1,	 				      getidle_t, true); # 		else	kstat= keyin (&syncchar, 1,   				      getidle_t, true);f% 		/* loop until idle or lw offline */s( 		/*  or (task killed and not ignerr) */7 	} while (  (isfalse(stream.status_idle) && (kstat>=0))a4 		&&(istrue(ignerr) || isfalse(stream.stop_task)) );   	stream.lw_sync = false; 	stream.nousermsg= false;'( 	stream.lw_clear= false;	/* invariant */  ( 	dprintf ("Getidle <<< %s", to_date(0)); 	return stream.status_idle;; }	   /*/  *	syncprinter - get synchronized with printer.	,  *	output:	stop_reason is 0 if all succeeded  */t static into# getstart_t()			/* test startpage */g {t* 	return 	startpage;		/* if sync occured */ }_C /*	temps (en units de 30 secondes) au bout duquel aborter la lw */	 static boolean
 syncprinter()t {c  static	const	char getstart[] = { "\004\= version (23.0) eq { statusdict /Patch1Installed known not { \_* (%%[ patch needed ]%%\n) print } if } if \A statusdict begin (%%[ start page #=) print pagecount pstack pop \. flush end \r\n\004"};oB static	const	$DESCRIPTOR(patch, "PATCH");		/* PATCH module name */  3 	startpage = 0;				/* should be read in stat msg */_  , 	dprintf ("Syncprinter >>> %s", to_date(0));  * 	if isfalse (getidle(false)) return false;+ 	if istrue (stream.stop_task) return false;) 	stream.stop_reason= 0;=  ' 	/*	si l'imprimante est toujours l, */i8 	/* on rcupre les compteurs de page de l'imprimante */  B 	if (keyin (getstart, strlen (getstart), getstart_t, false) <= 0)  			return false;   	if istrue(stream.QMSbug) {  		int savstart;r 		do { 			savstart= startpage; 
 			sleep(10);i* 			if (keyin (getstart, strlen (getstart),- 				   getstart_t, false) <= 0) return false;T  		} while (savstart!=startpage); 	}  = 	/*  This looks like a good place to send the patch module */r  0 	if istrue(patchneeded) {		/* if patch needed */ 		patchneeded = false;2 		copymodule(patch);		/* write the patch module */% 		laserwrite (lw_eot, sizeof lw_eot);t 	}  , 	dprintf ("Syncprinter <<< %s", to_date(0));   	compta_update (startpage);_  
 	return true;p }s _ /*.  *	check_resource: verify a resource is loaded  *	inputs: resource name'  *	outputs: 	true => resource is loadedL8  *			false=> resource is not loaded or abort in progress  */ 
 static int check_resource_t() {o, 	return (stream.resrc_state!=resrc_unknown); }o static boolean check_resource(resnam) char * resnam; {i% static	const	char verifresource[] = {	 "\004\ userdict /%s known \# {(%%%%[ resource loaded ]%%%%\\n)}\ ' {(%%%%[ resource not loaded ]%%%%\\n)}\t ifelse print flush\_ \004"};C7 	char	msg[sizeof verifresource+CONFIG_RESOURCE_SIZE+1];S  # 	stream.resrc_state= resrc_unknown;	& 	sprintf (msg, verifresource, resnam);  3 	/* on envoie veriflogo et on attend le rsultat */n  : 	(void) keyin (msg, strlen (msg), check_resource_t, true);  : 	return (stream.resrc_state==resrc_loaded) ? true : false; }  /* r#  *	load_resource:	download resource   */  static voidg load_resource (resfile)r+ char * resfile;		/* resource module name */t {c4 	struct	dsc$descriptor_s init_desc= {0, 0, 0, NULL};E static	const	char exitserver0[]= "serverdict begin 0 exitserver\r\n";tE static	const	char exitserver[]= "serverdict begin %s exitserver\r\n";e5 	char	msg [sizeof exitserver+CONFIG_PASSWORD_SIZE+1];f  ) 	init_desc.dsc$w_length= strlen(resfile);i# 	init_desc.dsc$a_pointer= resfile;	n? 	stream.nousermsg= true;		/* suppression des messages "user" */n   	if (stream.lw_pw[0] == '\0') 2 		laserwrite (exitserver0, sizeof exitserver0 -1); 	else {u* 		sprintf (msg, exitserver, stream.lw_pw);! 		laserwrite (msg, strlen (msg));x 	}   	copymodule (init_desc); 	5$ 	laserwrite (lw_eot, sizeof lw_eot);  0 		/* synchronize regardless of the error code */   	(void) getidle (true);i  9 		/* we ignore setup errors unless the task was killed */n# 			/* or the lw has gone offline */K  < 	if (isfalse (stream.stop_task) && istrue(stream.lw_online)) 			stream.stop_reason= 0;.   	stream.nousermsg= false;n }( /*)  *	init_lw - verify inits are loaded	(GG)_-  *	returns false if cannot synch with printer_E  *	outputs message if invalid configuration, but does not stop streamt  */; static boolean	 init_lw()a {i& 	char	module_name[CONFIG_INIT_SIZE+1];) 	char	module_keyword[CONFIG_INIT_SIZE+1];$ 	char 	* cp, *cq;y> 	int	loadcount=0;	/* nb of modules loaded by this procedure */  4 	for (cp= stream.initstr; (cp!=NULL) && (*cp!=0); ){ 		cq= strchr (cp, '=');e# 		if ( (cq==NULL) || (cq==cp+1) ) {L' 			char errmsg [CONFIG_INIT_SIZE+30+1];   5 			sprintf (errmsg, "Invalid init substring %s", cp);b 			sendmess (errmsg, MSG_OPER);O
 			*cp= 0;' 			break;			/* invalid configuration */f 		}n# 		strncpy (module_name, cp, cq-cp);' 		module_name[cq-cp]= 0;   		cp= strchr (cq, ',');m/ 		if (cp==NULL) 	strcpy (module_keyword, cq+1);01 		else {	strncpy (module_keyword, cq+1, cp-cq-1);y 			module_keyword [cp-cq-1]= 0;L 			cp= cp+1; 		})& 		if ( strlen (module_keyword) == 0) {' 			char errmsg [CONFIG_INIT_SIZE+30+1];a  5 			sprintf (errmsg, "Invalid init substring %s", cq);) 			sendmess (errmsg, MSG_OPER);/
 			*cq= 0;' 			break;			/* invalid configuration */; 		}a  % 		if isfalse(stream.lw_online) break;   - 		if isfalse(check_resource(module_keyword)){r 			load_resource (module_name);  			loadcount++;( 		}e 	}  < 	if (loadcount!=0)	/* if we loaded new modules, check the */9 		return getidle(false);	/* state of the laser writer  */)B 	else	return true;	/* otherwise, assume it is ok (save a synch) */ }  ; /*  '  *	doflag - do flag page if needed (GG)t  */b static void  doflag(job_flag) boolean job_flag;  {c #define	NOTSMB	0x800- static	const	$DESCRIPTOR (flag_desc, "FLAG"); < static	const	char * varnames[]={"the_jfname","the_filespec",' 		"the_account","the_uic","the_printq",  		"the_submitq","the_priority",	+ 		"the_note","the_clientuser","tdatestart",  		"tdatesubmit","tjobnum",, 		"jfswitch","burst","tprintnode","vmsvers",2 		"tmodified","recstring","tlongrec","t_filelen"};& /*	jfswitch doit valoir JOB ou FILE */A static	const	smbcodes[]= {NOTSMB|11, SMBMSG$K_FILE_SPECIFICATION,f= 		SMBMSG$K_ACCOUNT_NAME,SMBMSG$K_UIC,SMBMSG$K_EXECUTOR_QUEUE,	# 		SMBMSG$K_QUEUE,SMBMSG$K_PRIORITY,* 		NOTSMB|1,NOTSMB,NOTSMB|2,b- 		SMBMSG$K_TIME_QUEUED,SMBMSG$K_ENTRY_NUMBER,$& 		NOTSMB|3,NOTSMB|4,NOTSMB|5,NOTSMB|6,( 		NOTSMB|7,NOTSMB|8,NOTSMB|9,NOTSMB|10}; 	char buf[256], wbuf[80];c 	int	i;t 	char	* ptr; 	int	fileok; 	int	SYS$FILESCAN();  6 	fileok= openfile();		/* get a few infos about file */  5 	for (i= 0; (i<sizeof smbcodes / sizeof smbcodes[0]) m( 		    && (stream.stop_reason==0) ; i++){ 		struct dsc$descriptor_s tmp; 		if (smbcodes[i]&NOTSMB) {;" 			switch (smbcodes[i]& ~NOTSMB) {! 			case 0:		/* the client user */i2 				getitemdescrip (SMBMSG$K_USER_NAME,&tmp,true);+ 				sprintf (wbuf,"%s::%.*s", smb_nodename,l+ 					 tmp.dsc$w_length, tmp.dsc$a_pointer);r 				ptr= wbuf;
 				break; 			case 1:		/* the note */3 				if (getitemdescrip (SMBMSG$K_NOTE,&tmp,false)){D- 					sprintf (wbuf,"%.*s", tmp.dsc$w_length, s 						 tmp.dsc$a_pointer); 					ptr= wbuf;/ 				}  				else ptr= "";s
 				break; 			case 2:		/* date started */, 				ptr= to_date (stream.task_start); break;! 			case 3:		/* job/flag switch */n3 				ptr= istrue (job_flag) ? "JOB" : "FILE"; break;p 			case 5:		/* printer node */# 				ptr= stream.printernode; break;. 			case 6:		/* VMS version */	 				ptr= smb_vmsvers; break; 			case 7: 	/* Revision date */l4 				ptr= (fileok) ? to_date (&main_xabrdt.xab$q_rdt) 					      : ""; o
 				break;! 			case 9:		/* max record size */	 				if (fileok) {  					sprintf (wbuf,"%d", 						 main_xabfhc.xab$w_lrl); 					ptr= wbuf;  				}! 				else	ptr= "";0
 				break; 			case 10:	/* file size */, 				if (fileok) {g# 					union {unsigned short word[2];/ 					       unsigned long vbn; 					      } pdp;r% 					pdp.vbn= main_xabfhc.xab$l_ebk; , 					sprintf (wbuf,"%d",$ 						pdp.word[2]||pdp.word[0]<<16); 					ptr= wbuf;	 				}i 				else	ptr= "";\
 				break; 			case 11:	/* job/file name */  				if istrue(job_flag) + 					if (getitemdescrip (SMBMSG$K_JOB_NAME,i 							    &tmp,false)){ 						sprintf (wbuf,"%.*s",a 							 tmp.dsc$w_length,  							 tmp.dsc$a_pointer);o 						ptr= wbuf; 					} 					else ptr= "";
 				else {5 					if (getitemdescrip (SMBMSG$K_FILE_SPECIFICATION,e 							    &tmp,false)){+ static						struct {unsigned short len,cod;e 							unsigned long addr;}i 							fscnlst[]= {s 							{0, FSCN$_NAME,0},  							{0, FSCN$_TYPE,0},/ 							{0, 0, 0}}; 						int stat;r   						stat= SYS$FILESCAN (&tmp,e 								    &fscnlst,  								    0);o$ 						checkstat (stat, "$FILESCAN"); 						sprintf (wbuf,"%.*s",  							 fscnlst[0].len+  							  fscnlst[1].len, 							 fscnlst[0].addr);_ 						ptr= wbuf; 					} 					else ptr= ""; 				}e
 				break;  ! 				default:	ptr= "Internal err";  			} 			tmp.dsc$a_pointer= ptr;" 			tmp.dsc$w_length= strlen (ptr); 		}u 		else {9 			if isfalse(getitemdescrip (smbcodes[i], &tmp, false)){E8 static				const $DESCRIPTOR (not_present,"Not Present"); 				tmp = not_present; 			} 			else{# 				switch (itemtype[smbcodes[i]]){	 				case	itm_string: break;t) 				case	itm_numeric: sprintf (wbuf,"%d",e) 					*(long *) tmp.dsc$a_pointer); break;n! 				case	itm_time: strcpy (wbuf, c* 					 to_date (tmp.dsc$a_pointer)); break;( 				case	itm_uic:  strcpy (wbuf, to_uic & 						(* (long *) tmp.dsc$a_pointer)); 						break;3 				default: sprintf (wbuf,"type %d not printable",c 					 itemtype[smbcodes[i]]);, 				}0+ 				if (itemtype[smbcodes[i]]!=itm_string){{ 					tmp.dsc$a_pointer= wbuf;,% 					tmp.dsc$w_length= strlen (wbuf);c 				}e 			} 		}/1 		sprintf (buf,"/%s (%.*s) def\r\n", varnames[i],s) 				tmp.dsc$w_length, tmp.dsc$a_pointer);e 		dprintf ("FLAG: %s", buf); 		laserwrite (buf,strlen(buf));u 	}	/* for */  3 	if (stream.stop_reason==0) copymodule (flag_desc);l  " 		/* ignore errors on flag page */   	if istrue (stream.lw_online) {	% 		laserwrite (lw_eot, sizeof lw_eot);s* 		syncprinter();	/* wait for completion */ 		stream.stop_reason= 0; 	} }f 	 /*!  *	dotrailer - issue job trailer.	  *	not reentrant.a  */	 static voido dotrailer()l {r' 	char	buf[1024];			/* scratch buffer */	. 	char	wbuf[512];		/* another scratch buffer */2 	char	user[20], job[255], file[255], message[257];  * static 	const	$DESCRIPTOR(key, "TRAILER");6 static 	const	$DESCRIPTOR(key_empty, "TRAILER_EMPTY");  N static	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL};   static	char time[24];c* static	const	struct dsc$descriptor_s date=7 		{sizeof time -1, DSC$K_DTYPE_T, DSC$K_CLASS_S, time};c   	struct dsc$descriptor_s msgd =n: 		{sizeof message -1, DSC$K_DTYPE_T, DSC$K_CLASS_S, NULL};   static	const char z = 0;, static	const struct dsc$descriptor_s zero =	0 		{1, DSC$K_DTYPE_T, DSC$K_CLASS_S, (char*) &z}; 	int	LIB$DATE_TIME();* 	int	SYS$GETMSG();   	msgd.dsc$a_pointer= message;*, 	/*  save page count if first file of job */D 	if (stream.sepctl.smbmsg$v_first_file_of_job) jobstart = startpage;  ? 	/* send trailer if there is a file trailer or a job trailer	*/ # 	/*	or if the job was errored				*/f< 	/*	or if the file was empty and the TRAILER_EMPTY module	*/# 	/*		is present in the library			*/f  5 	dprintf ("Trailer: empty= %d\n", stream.empty_file);t  / 	if (  (stream.sepctl.smbmsg$v_job_trailer==0) t0 	    &&(stream.sepctl.smbmsg$v_file_trailer== 0)! 	    &&(stream.print_status == 0)t, 	    &&isfalse (stream.empty_file)	) return; 	t/ /*  send the trailer module from the library */l  > 	dprintf ("trailers: job=%d, file=%d, status=%08x, empty=%d", & 		 stream.sepctl.smbmsg$v_job_trailer,' 		 stream.sepctl.smbmsg$v_file_trailer,g 		 stream.print_status,  		 stream.empty_file);   	if istrue(stream.lw_online) { 		int savreason; 		boolean copyst;(  7 		laserwrite (lw_eot, sizeof lw_eot);	/* leading EOF */,  		savreason= stream.stop_reason;0 		stream.stop_reason= 0;			/* ncessaire pour */ 							/* copier le module */i  8 		/* copy the empty file flag if the file was empty and  			no error was detected */   " 		if (istrue(stream.empty_file)) {! 			copyst= copymodule(key_empty);a, 			if (stream.stop_reason!=0) copyst= false;8 			/* if the 'file empty' module could not be copied, */2 			/* if no flag page is requested, just return */ 			if (  isfalse (copyst).1 			    &&(stream.sepctl.smbmsg$v_job_trailer==0) a5 			    &&(stream.sepctl.smbmsg$v_file_trailer== 0)) {(" 				stream.stop_reason= savreason; 				return;/ 			}. 			if isfalse (copyst) copyst=copymodule(key); 		}m  		else 	copyst= copymodule(key);  + 		if (stream.stop_reason!=0) copyst= false;e    		stream.stop_reason= savreason;; 		if isfalse(copyst) 	return;	/* pas pu copier le module */	- 	}	else 			return;	/* lw offline... leave. */r  1 	getitemdescrip(SMBMSG$K_USER_NAME, &temp, true);r6 	strncpy(user, temp.dsc$a_pointer, temp.dsc$w_length); 	user[temp.dsc$w_length] = 0;e  = 	if istrue(getitemdescrip(SMBMSG$K_JOB_NAME, &temp, false)) {a6 		strncpy(job, temp.dsc$a_pointer, temp.dsc$w_length); 		job[temp.dsc$w_length] = 0;t 	}9 	else	job[0]= '\0';	/* seen in VMS V5.5-1: no JOB_NAME */k  : 	getitemdescrip(SMBMSG$K_FILE_SPECIFICATION, &temp, true);6 	strncpy(file, temp.dsc$a_pointer, temp.dsc$w_length); 	file[temp.dsc$w_length] = 0;    	LIB$DATE_TIME (&date);b 	time[sizeof time-1] = 0;d  
 	sprintf(buf, @ 		 "setuppage (%s) h-job (%s) h-user (%s) h-file (%s) h-time  ", 		  job, user, file, time);o 	dprintf ("trailer: %s", buf); 	laserwrite(buf,strlen(buf));   1 /*  only print page count on last trailer page */e  A 	if (stream.sepctl.smbmsg$v_last_file_of_job) {	/* if last one */ * 		sprintf(buf, "(%d) h-pages ", jobstart); 		dprintf ("trailer: %s", buf);= 		laserwrite(buf,strlen(buf)); 	}  N /*  si fin de job anormale (stop_task de JOBCTL ou stop_reason du symbiont) */    	if (stream.print_status != 0) { 		int	stat;c 		unsigned short msglen;  & 		msglen = 0;			/* in case of error */@ 		stat = SYS$GETMSG(stream.print_status, &msglen, &msgd, 15, 0); 		checkstat(stat,"$getmsg"); 		message[msglen] = 0; 		sprintf(buf, "%s h-error ",p1 			     makestring (message, wbuf, sizeof wbuf));s 		laserwrite(buf,strlen(buf)); 		dprintf ("trailer: %s", buf);u 	}  8 /*	si log file, alors le recopier sur la trailer page */ 	10 	if (stream.logfile_lines) {			/* if log file */ 		char *cp;i  4 		STR$APPEND (&savelog, &zero);		/* marque la fin */: 		for (cp=savelog.dsc$a_pointer; *cp; cp+=strlen(cp)+1) {	( 			sprintf(buf, "(%s) h-logline\n", cp); 			laserwrite(buf,strlen(buf));   			dprintf ("trailer: %s", buf); 		}i 	}  ) 	laserwrite (ADDR_LEN(" showpage \004"));n  F 	/* in debug mode, we sync with the printer not to lose any message */  + 	if (stream.debug!=0) (void) getidle(true);e }r . /*$  *	inititems - initialize item list.  */  inititems(). {d 	int	i; ( static	const	unsigned char numeric [] = 3 	{SMBMSG$K_ALIGNMENT_PAGES, SMBMSG$K_BOTTOM_MARGIN,tE 	SMBMSG$K_DEVICE_STATUS, SMBMSG$K_ENTRY_NUMBER, SMBMSG$K_FILE_COPIES,a@ 	SMBMSG$K_FILE_COUNT, SMBMSG$K_FIRST_PAGE, SMBMSG$K_FORM_LENGTH,? 	SMBMSG$K_FORM_WIDTH, SMBMSG$K_JOB_COPIES, SMBMSG$K_JOB_COUNT, mB 	SMBMSG$K_LAST_PAGE, SMBMSG$K_LEFT_MARGIN, SMBMSG$K_PRINT_CONTROL,E 	SMBMSG$K_PRIORITY, SMBMSG$K_RELATIVE_PAGE, SMBMSG$K_REQUEST_CONTROL,eI 	SMBMSG$K_RIGHT_MARGIN, SMBMSG$K_SEPARATION_CONTROL, SMBMSG$K_TOP_MARGIN,_ 	SMBMSG$K_STOP_CONDITION};8 	for (i = 0; i< sizeof numeric / sizeof numeric[0]; i++)$ 		itemtype[numeric[i]]= itm_numeric;* 	itemtype[SMBMSG$K_TIME_QUEUED]= itm_time;/ 	itemtype[SMBMSG$K_MESSAGE_VECTOR]= itm_vector;i2 	itemtype[SMBMSG$K_FILE_IDENTIFICATION] = itm_fid;/ 	itemtype[SMBMSG$K_CHARACTERISTICS]= itm_other;e) 	itemtype[SMBMSG$K_AFTER_TIME]= itm_time;n! 	itemtype[SMBMSG$K_UIC]= itm_uic;	3 	for (i = 0; i < MAXITEMS; i++) item[i].buffer = 0;c }	 c   /*  *  */* typedef struct {uint16 stat; 		uint16 latv1code;\ 		uint32 latv2code;% 		} lat_iosb_t;t static void lat_err (sp, stat, iosb)t
 stream_t *sp;s	 int stat;d lat_iosb_t * iosb; {r( 	char * latmsg, errbuf[80], msgbuf[256];  B 	dprintf ("Lat Error: stat= 0x%08X; iosb= 0x%04X 0x%04X 0x%08X\n",8 		  stat, iosb->stat, iosb->latv1code, iosb->latv2code); 	latmsg= errbuf;   	if (stat==SS$_NORMAL) 	  if (iosb->stat==SS$_ABORT)	  	     switch (iosb->latv2code) {C 	     case	LAT$_DISCONNECTED: latmsg="Session disconnected"; break;*) 	     default: switch	(iosb->latv1code) {r* 		case 0:	latmsg= "Unknown reason"; break;0 		case 2:	latmsg= "Shutdown in progress"; break;9 		case 5: latmsg= "Insufficient server resources"; break;a/ 		case 6: latmsg= "Port/service in use"; break;sI 		case 7: sprintf (errbuf, "No such service %s", sp->servicename); break;t/ 		case 8: latmsg= "Service is disabled"; break; A 		case 9: latmsg= "Service not offered on requested port"; break;e0 		case 10:latmsg= "Port name is unknown"; break;. 		case 11:latmsg= "Incorrect password"; break;. 		case 12:latmsg= "Entry not in queue"; break;5 		case 13:latmsg= "Immediate access rejected"; break;w( 		case 14:latmsg= "Acces denied"; break;- 		case 15:latmsg= "Corrupted request"; break;o< 		case 16:latmsg= "Requested function not supported"; break;5 		case 17:latmsg= "Session cannot be started"; break;n9 		case 18:latmsg= "Queue entry deleted by server"; break;n6 		case 19:latmsg= "Illegal request parameters"; break;
 		default:3 			sprintf	(errbuf,"Illegal LAT rejection code %d",d 				 iosb->latv1code);
 	        } 	     }>% 	   else	if (iosb->stat==SS$_TIMEOUT)d- 			latmsg= "Server not available or unknown";o 		else{e3 			sprintf (errbuf, "Unknown IOSB status: 0x%04X", p 					 iosb->stat); 			latmsg= errbuf; 		}  	else{> 			sprintf (errbuf, "Unknown connect QIO status: 0x%X", stat); 			latmsg= errbuf; 		}f* 	dprintf ("Lat error reason: %s", latmsg);+ 	checkstat (stat," Lat connect abort msg");    	if istrue (stream.stalled) {p> 		if (stream.stallerr_count++ < stream.stallmsg_count) return; 		/* message time ! */. 		if (stream.stallmsg_count*2*STALL_MINS < 60) 			stream.stallmsg_count *= 2;- 		else	stream.stallmsg_count = 60/STALL_MINS;e 		stream.stallerr_count= 0;n 	}   	sprintf (msgbuf, O "Error connecting LAT device %s for queue %s\r\n-%s", stream.dev, stream.queue,  				latmsg); 	sendmess (msgbuf, MSG_OPER);r   }%  ( /*	Connect/Disconnect the laserwriter	*/ static	void ctrlyast();s static booleank connect_laserwriter (sp, on) stream_t * sp; boolean on;  {e 	lat_iosb_t iosb; ' static	long	devtype, devclass, devchar;u" static	struct	{uint16 count, type; 		 ptr32 addr, retlen;}c 		itmlst[]=)A 		{{sizeof devtype, DVI$_DEVTYPE | DVI$M_SECONDARY, &devtype, 0},eD 		 {sizeof devclass, DVI$_DEVCLASS | DVI$M_SECONDARY, &devclass, 0}, 		 {0, 0, 0, 0}};\ 	boolean	con_ok; 	int	ast_st;
 	int	stat; 	int	SYS$GETDVIW();   9 	stat= SYS$GETDVIW (0, sp->chan, 0, &itmlst, 0, 0, 0, 0);_  H 	dprintf	("Stat: 0x%08x; Class: %d; type: %d", stat, devclass, devtype);  B 	con_ok= true;	/* si succes soit pas d'AST, soit iosb status OK */  ? 	PROT_START("connect_laserwriter")	/* protect against ^Y AST */d  ; 	if istrue(on) stream.lw_online= true;	/* assume success */    	print_astcnt("avant connect");?  % 	stat= SYS$QIOW	(laser_efn, sp->chan,e: 			 IO$_TTY_PORT | (on ? IO$M_LT_CONNECT: IO$M_LT_DISCON), 			 &iosb, 0, 0, 			 0, 0, 0, 0, 0, 0);B 	dprintf ("Connect LT %s: stat=%08x iosb= 0x%04X 0x%04X 0x%08X\n",> 		 istrue (on)? "On" : "Off", stat, iosb.stat, iosb.latv1code, 							     iosb.latv2code);   	print_astcnt("apres connect");i  	 	if (on) e 		switch	(stat) { . 		case	SS$_ILLIOFUNC: 			/* pas un port LAT */1 		case	SS$_DEVACTIVE:	break;		/* deja connecte */a 		case	SS$_NORMAL: 			if (iosb.stat==SS$_NORMAL){, 				if (sp->printernode[0]==0) getlatinfo(); 				stat= SYS$QIO (0, sp->chan,i# 						IO$_SETMODE|IO$M_CTRLYAST, 0,1 						0, 0,  						ctrlyast, 0, 0, 0, 0, 0);m( 				print_astcnt("apres connect ^YAST");
 				break; 			}% 		default:	lat_err (sp, stat, &iosb);o 				con_ok= false; 		}*   	if istrue (con_ok)  		if istrue (on){/2 			postlaserread (sp, 1);	/* post read  & purge */* 			sp->devsts.smbmsg$v_unavailable= false; 		}t 		else { 			cancelread (sp);i 			sp->lw_online = false;k 		}i 		   	print_astcnt("fin connect");t    	PROT_END("connect_laserwriter")   	return	con_ok;* }i w4 /*	this routine can be triggered by connect lt on	*/ static void
 ctrlyast() {*A 	dprintf ("Control-Y");		/* par la boucle d'attente du symbiont*/t 	SET_STOP_REASON (SS$_HANGUP); 	stream.lw_online= false;O 	stream.product[0]= '\0';oC 	(void) connect_laserwriter(&stream,false);	/* bug SS$_DEVACTIVE */t3 	wake_me();			/* un wake surnumraire sera aval */f }(1 	/*****	End of laserwriter I/O routines GG	*****/q   c /**	set_typeahead. *(= *	Set /typeahead on the terminal device so characters will be3 *	buffered.s */
 static int set_typeahead(chan)n' int chan;					/* laserwriter channel */E {O
 	int mode[3];	
 	int stat;  1 	stat = SYS$QIOW(0, chan, IO$_SENSEMODE, 0, 0, 0,a! 		mode, sizeof mode, 0, 0, 0, 0);c 	if (!(stat & 1)) return stat; 	 5 	mode[1] &= ~TT$M_NOTYPEAHD;		/* clear notypeahead */e( 	mode[1] |= TT$M_NOECHO;			/* no echo */8 	mode[2] |= TT2$M_ALTYPEAHD;		/* alternate type ahead *// 	mode[2] |= TT2$M_PASTHRU;		/* pass thru mode*/r, 	mode[2] |= TT2$M_XON;			/* resume output */0 	stat = SYS$QIOW(0, chan, IO$_SETMODE, 0, 0, 0,	! 		mode, sizeof mode, 0, 0, 0, 0);   
 	return stat;* }v d /*
  *	Compta.7  *	we use print_status to ignore errors after user job.f  */l static voidu finish_task (do_accounting)a boolean do_accounting; { A static	smbmsg$r_accounting_data acctrec;		/* accounting record */w+ static	struct dsc$descriptor_s accounting =eI 	     {sizeof acctrec , DSC$K_DTYPE_T, DSC$K_CLASS_S, (char *) &acctrec};m 	int stat, request;n 	int print_status;   	if istrue (do_accounting) {	 		int np;   5 		np = endpage - startpage;	 /* compute page count */   						 /* if no obvious error */ 		if (np >= 0){(& 			acctrec.smbmsg$l_pages_printed= np; 			compta_update (endpage);h 		}e 		else{	% 			acctrec.smbmsg$l_pages_printed= 0; 8 			dprintf ("Invalid np value: startpage %d endpage %d", 				 startpage, endpage);a 		}m 	}    < 		/*  If stop_task, we were stopped by the job controller.*/: 	if istrue(stream.stop_task)	request = SMBMSG$K_STOP_TASK;8 		/*  else, ok or we were stopped by some other error */* 	else				request = SMBMSG$K_TASK_COMPLETE;  = 	if (stream.print_status) print_status = stream.print_status;Q$ 	else 			 print_status= SS$_NORMAL;	  H 	/* le stream ne peut etre stalled que si il y a une tache active ... */; 	/* bug queue manager V5.5-1 qui laisse la queue stalled */T  ( 	stream.devsts.smbmsg$v_stalled = false;  : 	stream.task_active= false;	/* task is no longer active */? 	stream.stop_task=   false;	/* meaningless if no task active */i    	send_request (&stream, request,2 		      istrue (do_accounting) ? &accounting : 0,  		      print_status,m 		      "finish_job"); }B ; /*=  *	do_stall:	requeues current task, if any. enters stall moder  */  static voids
 do_stall() {U
 	int	stat; 	int	SYS$SCHDWK();   	stream.stalled= true;* 	stream.stallmsg_count= 1;	/* not 0 !!! */ 	stream.stallerr_count= 0;I 	stat = SYS$SCHDWK(0, 0, stall_daytim, stall_daytim); /* wake up later */T! 	checkstat(stat, "schdwk stall");f  C 	/* if a task is active, tell the job controller about the stall */f  ! 	if istrue (stream.task_active) {r( 		stream.devsts.smbmsg$v_stalled = true;4 		send_request (&stream, SMBMSG$K_TASK_STATUS, 0, 0, 			     "do_stall"); 	} }t   /*  *	perform unstall operation;  *	we are called periodically with a timer and on any eventr  *	with a task active or not  *	the context is *NOT* AST=*  *	this routine is therefore not reentrant  */e static void= do_unstall(requeue)&# boolean requeue;	/* requeue task */" {o 	boolean stat;  , 	stat = connect_laserwriter (&stream, true);9 	if istrue (stat) {		/* try to cause to the imprimante */l   		getproduct();   3 		(void) getidle (true);		/* wait for idle state */*  " 		stat= istrue (stream.lw_online);  . 		(void) connect_laserwriter (&stream, false); 		if istrue (stat) { 			int SYS$CANWAK();   			(void) SYS$CANWAK (0,0);,  5 			/* if active task then requeue task, if allowed */]  5 			if (istrue(stream.task_active) && istrue (requeue)	# 				&& isfalse(stream.stop_task)) {* 				int	SYS$SNDJBCW();) static				struct 	{uint16 buflen, itmcod;_ 					 ptr32  bufadr, retadr;}{ 				jbclst [] =  					{{0, SJC$_QUEUE, 0, 0}, 					 {0, SJC$_REQUEUE, 0, 0}, 					 {0, 0, 0, 0}}; 				struct {uint32 status; 					uint32 whatever;} jbciosb;m  - 				jbclst[0].buflen = strlen (stream.queue); % 				jbclst[0].bufadr = &stream.queue;i2 				stat= SYS$SNDJBCW (gp_efn, SJC$_ABORT_JOB, 0, " 						   &jbclst, &jbciosb, 0, 0);  * 				if istrue (stat) stat= jbciosb.status; 	{* 				/* we were stopped in the meanwhile */ 				/* ignore $SNDJBC	status	*/     				if isfalse(stream.stop_task), 					checkstat (stat, "$SNDJBCW abort job"); 			}   			stream.stalled= false;l 		}  	} }  c /*$  *	releaseitems - release item list.  *0  *	release dynamic strings gotten by read_items.  */r releaseitems() {: 	int	i;tK static	struct dsc$descriptor_d temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};p 	;' 	itmax = 0;					 /* clear item index */s  ! 	for (i = 0; i < MAXITEMS; i++) {t7 		if (item[i].buffer == 0) return;	/* if end of list */	( 		temp.dsc$w_length = item[i].item_size;& 		temp.dsc$a_pointer = item[i].buffer; 		STR$FREE1_DX (&temp);	 		item[i].buffer = 0;i 	} }u   " /*.  *	sendendsequence - send end of job sequence./  *			  cleans up after printing the user files.p  */a static intr/ getendidle_t(time)			/* test synchronisation */		 int	time;g {  static	const char eot= '\004';  ? 	if istrue(stream.status_idle) return 1;		/* if sync occured */m  4 	/* au bout de MAXBUSY intervalles, on casse tout */   	if (time > MAXBUSY){t 		stream.lw_clear= true;# 			/*  Abort whatever is running */c* 		laserwrite (&lw_abort, sizeof lw_abort);% 		dprintf ("Getendidle: abort sent");s 		return 1;		/* retry */ 	}    3 	/*	sinon, au bout de 5 minutes on envoie des ^D */n  * 	else	if (time > 10) laserwrite (&eot, 1);  < 	return 0;		       /* on reste dans keyin sans changement */ }    static boolean getendidle() { 3 static	const	char	syncchar='\024';		/* Control-T */n static	const	char	QMSquest[]= 8 	"(\\n%%[ status: idle ]%%] QMSBUG\\n) print flush\004"; 	int	kstat;a  8 	stream.status_idle = false;		/* par dfaut: pas IDLE */ 	stream.lw_sync = true;/  + 	dprintf ("Getendidle >>> %s", to_date(0));h  B 	/* on envoie ^T pour avoir le status, et on attend le rsultat */   	do {t 		if istrue(stream.QMSbug)- 			kstat= keyin (QMSquest, sizeof QMSquest-1,, 				      getendidle_t, true);# 		else	kstat= keyin (&syncchar, 1, _ 				      getendidle_t, true);% 		/* loop until idle or lw offline */s8 	} while (  isfalse(stream.status_idle) && (kstat>=0) );   	stream.lw_sync = false;  + 	dprintf ("Getendidle <<< %s", to_date(0));  	return stream.status_idle;C }C  
 static int sendend_t(timeoutcount)  int	timeoutcount;r {  static	boolean	abort_sent;  2 	if (endpage) return 1;			/* Ok, got page count */  < 	if (timeoutcount == 0) abort_sent= false;	/* 1er passage */  > 	if isfalse (stream.lw_online) return -1;	/* lw deconnecte */  < 	/* if job deleted or LW not responding, cancel the print */  > 	if ( istrue(stream.stop_task) || (timeoutcount > MAXBUSY) ) { 		if isfalse(abort_sent) {& 			dprintf ("Sendend: sending ABORT"); 			abort_sent = true;	6 			laserwrite (lw_abort, sizeof lw_abort);	/* ^C ^D */ 		}r 	}  3 	/*  Notify the operator on 10 minute intervals. */t 		" 	if ( (timeoutcount+1 %20) == 0) {7 		sendmess ("LaserWriter job possibly hung", MSG_OPER);i 	}  # 	/* ask question every 2 minutes */p  . 	return (((timeoutcount+1) %4) == 0) ? 0 : -1; }r   static void* sendendsequence()a {r static const char getend[] = ,2 {"\004statusdict begin (%%[ end page   #=) print \* pagecount pstack pop flush end \r\n\004"};  
 	endpage = 0;t( 	dprintf (">>> Sendend %s", to_date(0));  ) 	(void) getendidle();		/* for QMS 1700 */o  H 	if ((stream.lw_flushcnt!=0)&&(stream.lw_flushcnt <= stream.lw_eotcnt)){$ 		dprintf ("Unflushing the job...");> 		PROT_START("sendendsequence")	/* stop_reason && stop_task */ 						/* must be consistent */6 		if isfalse (stream.stop_task) stream.stop_reason= 0; 		PROT_END("sendendsequence")s 	}  9 	(void) keyin (getend, sizeof getend-1, sendend_t, true);s   	if istrue(stream.QMSbug) {a
 		int savend;t 		do { 			savend= endpage;n
 			sleep(10);/  ; 			(void) keyin (getend, sizeof getend-1, sendend_t, true);i 		} while (savend!=endpage); 	}  ( 	dprintf ("<<< Sendend %s", to_date(0)); }t m /*0  *	sendfile - send the main file to the printer.  */s   static void
 sendfile() {} 	int stat, end;c 	int i;p 	int line = 0; 	boolean undefined = y> 		main_fab.fab$b_rfm==FAB$C_UDF;	/* undefined record format */, 	boolean print;				/* fichier: PRN format */, 	char ibuf[IBUFSIZE+1];			/* input buffer */8 	char obuf[2+((IBUFSIZE*4+7) & -8)];	/* output buffer */0 	unsigned long	start_time[2],		/* DEBUG/STATS */ 			end_time[2],e 			delta_time[2],e	 			duree,$ 			delta_bytes;[ 	int	SYS$GETTIM();  ' 	struct	{unsigned char prefix,postfix;}J) 					rhb;	/* record header buffer (GG) */t  8 	dprintf ("File size is %d blocks", main_fab.fab$l_alq);   	SYS$GETTIM (start_time);  	stream.bcnt= 0;  % 	if ((main_fab.fab$b_fsz==sizeof rhb)c8 	    && main_fab.fab$v_prn) {		  /* print cobol (UGH) */B 		main_rab.rab$l_rhb= (char *)&rhb; /* address of record header */ 		print= true; 	} 	else {d 		main_rab.rab$l_rhb= 0; 		rhb.prefix= 0; 		rhb.postfix= 0;p 		print= false;s 	}   	main_rab.rab$l_ubf = ibuf;, 	main_rab.rab$w_usz = IBUFSIZE;d3 	stream.lw_flushcnt= 0;			/* reset flush counter */b. 	stream.lw_eotcnt= 0;			/* reset ^D counter */; 	stream.logfile_write= false;		/* don't write to logfile */  			/* send the file */   	do {u* 		char *cp;			/* pointeur record courant*/ 		int rsz;			/* record size */ 		5 		stat = SYS$GET(&main_rab, 0, 0);	/* get a record */p  
 		line ++;   		if ((stat & 1)==0) {9 			dprintf ("SYS$GET returns %08X at line %d (%d bytes)",	% 				 stat, line, main_rab.rab$w_rsz);	 			if (stat == RMS$_EOF) break;=0 			else	SET_STOP_REASON (stat);	/* erreur RMS */ 		};  > 		if isfalse(stream.lw_online) break;	/* low level LZW error*/  > 		if istrue (stream.stop_task) break;	/* job killed by user */  . 	/* postscript text may contain embedded ^D */, 	/* so, "flushing" may not be an error	   */   		if (stream.stop_reason) {r- 			if (stream.job_type==print_headers) break; $ 			if (stream.lw_flushcnt==0) break;% 			if (stream.lw_flushcnt>MAXFLUSH) { 0 				stream.lw_flushcnt= 0x40000000; /* kludge */! 				break; /* too much flushes */( 			} 		}n   		rsz = main_rab.rab$w_rsz;t  8 		if (stream.job_type!=print_headers) {	/* count ^D's */ 			ibuf[rsz]= '\0';(9 			if (strchr (ibuf, '\004') != NULL) stream.lw_eotcnt++;  		}e  @ 		if istrue(undefined) {	/* undefined format: just send bytes */( 			dprintf ("UDF: read %d bytes", rsz);  			laserwrite (ibuf, rsz); 			continue; 		}i 		 /*  process record control */r 		 		cp = ibuf; 		* 		/* on retire les caracteres superflus	*/$ 		/* colonne 1 si RAT == FORTRAN		*/9 		/* si rat==cr alors on retire les \r et \n terminaux */G   		if isfalse(stream.hexdump) { 			if istrue(print) {  				if (stream.debug & DBG_VFC)O- 				dprintf ("VFC: prefix 0x%X postfix 0x%X",M+ 					 (int) rhb.prefix, (int) rhb.postfix);O  ) 				/* sequence normale: prefix = 1 LF */T2 				if ((rhb.prefix&0x80) == 0) /* nb line-feed */ 					for (i=1; i++<rhb.prefix;)_ 						laserwrite (&lw_crlf,  							    sizeof lw_crlf);c, 				else {	/* cross fingers & output char */' 					unsigned char c= rhb.prefix &0x7f;M 					laserwrite (&c,1);e 				}M  ( 				/* sequence normale: postfix = CR */ 				if ( (rhb.postfix&0x80) )N 						if (rsz< sizeof ibuf)G$ 					cp[rsz++]= rhb.postfix & 0x7f;	 			}  * 			if (rsz) {		/* remove possible col 1 */) 				if (main_fab.fab$b_rat & FAB$M_FTN) {X 					static const char ff='\f'; . 					char control= *cp++;/* ignore column 1 */ 					switch (control) {\$ 					case '0': laserwrite (&lw_crlf, 							      sizeof lw_crlf);t% 						  break;/* une ligne blanche */ ) 					case '1': laserwrite (&ff,1); break;b& 					case '+':	/* je sais pas faire */  					case '$':	/* ca non plus */ 					case ' ':	/* cas normal */>% 					default :;	/* on ne fait rien */; 					} 					rsz--;  				}a 			}  0 /*			if ((main_fab.fab$b_rat & FAB$M_CR) == 0) {* 				if (rsz) if (cp[rsz-1] == '\n') rsz--;* 				if (rsz) if (cp[rsz-1] == '\r') rsz--; 			} */ 		}a 			s< 		if isfalse(stream.hexdump){	/* if ascii (vs HEX) format */0 			expand_ascii (cp, obuf, &rsz, sizeof obuf-2); 			if (rsz == sizeof obuf-2 ) / 				checkstat (LASER$_TOOMANYTABS, "sendfile");a  ' 			if (main_fab.fab$b_rat & FAB$M_CR) {e 				obuf[rsz++] = '\r';s 				obuf[rsz++] = '\n';i 			} 		}e( 		else {				/* if file to be hexified */ 			expand_hex(cp, obuf, &rsz); 		}i  ; 		/* si on est en print avec RHB.prefix==0 il faut faire */P> 		/* de la surimpression. On sait pas faire, donc: poubelle */  > 		if (isfalse(print) || (rhb.prefix!=0)) laserwrite(obuf,rsz);   		if istrue(print) { 			if ((rhb.postfix&0x80) == 0)e 				for (i=0; i++<rhb.postfix;); 					laserwrite (&lw_crlf, 						    sizeof lw_crlf); 				 		}    	} while (true);  @ 	if (stream.stop_reason==0)	  /* if the print was OK, but the */; 		stream.empty_file= stream.bcnt == 0;	/* file was empty */;   	if istrue(stream.hexdump) {& 		laserwrite(lw_crlf, sizeof lw_crlf); 	}  2 /*  send abort (^C) if stop_task, else eof (^D) */  4 	if istrue (stream.stop_task) end = 3; else end = 4; 	laserwrite(&end,1);   	/* statistiques */e   	{8 static const unsigned long libdtop= LIB$K_DELTA_SECONDS; 		int	LIB$SUB_TIMES();# 		int	LIB$CVT_FROM_INTERNAL_TIME();s   		SYS$GETTIM (end_time); 		delta_bytes= stream.bcnt;n9 		stat= LIB$SUB_TIMES (end_time, start_time, delta_time);d  		checkstat (stat, "sub times");- 		stat= LIB$CVT_FROM_INTERNAL_TIME (&libdtop,g 						  &duree, delta_time);! 		checkstat (stat, "LIB$CVTIME");nB 		if (duree==0) dprintf ("Dure nulle (%d bytes)??", delta_bytes);@ 		else 	dprintf ("Envoi de %d bytes en %d secondes (%d bit/s)",  					delta_bytes, duree, m 					(10*delta_bytes) / duree);e 	s 	} }_ n /*   *	processtask - process a file.  */n static void
 processtask()u {sL static 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};
 	int stat;7 	boolean	print_ok;	/* temoin pas de rupture de ligne */t 	boolean devunav;  	int	SYS$GETTIM();  & 	/* on verifie qu'on a notre periph */ 	nH 	if (stream.chan == 0) checkstat (LASER$_STREAMNOTSTART, "processtask");  1 	/* on previent JOBCTL qu'on a recu la requete */;  H 	send_request (&stream, SMBMSG$K_START_TASK, 0, 0, "processtask start");   	get_debug (stream.queue);    	stream.job_type= print_unknown; 	stream.empty_file= false;- 	devunav= stream.devsts.smbmsg$v_unavailable;;  H 	/* the lat port may already be connected if several files in the job */  ! 	if (istrue(stream.lw_online) || CM 	    istrue(connect_laserwriter (&stream, true))) {/* connect LT port (GG) */o  = 		/* if the unavailable device was set, tell QUEUE MANAGER */r: 		/* the device is available (prettier in 'show queue') */  I 	   if (istrue (devunav) && isfalse (stream.devsts.smbmsg$v_unavailable))?4 		send_request (&stream, SMBMSG$K_TASK_STATUS, 0, 0, 			      "Task status");  & 		print_astcnt("apres connect laser"); 		= 	   getitemdescrip(SMBMSG$K_SEPARATION_CONTROL, &temp, true);xK 	   stream.sepctl.smbmsg$l_separation_flags = * (long*) temp.dsc$a_pointer;a7 	   dprintf	("ProcessTask: separation control= 0x%X\n",a, 			stream.sepctl.smbmsg$l_separation_flags);  @ 	   SYS$GETTIM (&stream.task_start);	/* sauvegarde date debut */  ? 	   if istrue (syncprinter()) {		/* synchronize with printer */s   	     if istrue (init_lw()) {>  )   		    print_astcnt("debut impression");Y  7 		   if (stream.sepctl.smbmsg$v_job_flag) doflag(true);  		2 		   checkspooled();		/* check for spooled file */  , 		   if (openfile()) {		/* open main file */  - 		   /*	getcopies();	*/	/* send copy count */o0 		   /*	getnote();	*/	/* output possible note */  7 			if (stream.sepctl.smbmsg$v_file_flag) doflag(false);g  ! 			stream.user_job_active = true;b  * 			getparams();		/* get user parameters */  C 			if (istrue (stream.lw_online) &&/* if Laserwriter still there */)- 			    istrue(getsetup()))	/* output setup */r0 				sendfile();	/* send main file if setup ok */  & 			closefile();		/* close main file */ 		   }	/* opened file */ 		}	/* init_lw */a  1 		sendendsequence();		/* send end job sequence */S  9 		/* print is Ok if lw is online OR if lw is offline, but\" 		   after the job has finished */  B 		print_ok= istrue(stream.lw_online) || (stream.stop_reason == 0);  ' 	     }	/* synchronized with printer */l  G 	   else { /* could not synch with printer: hardware pb or STOP_TASK */p/ 		if isfalse(stream.stop_task) print_ok= false;b 	   }u  , 	   stream.print_status= stream.stop_reason;  # 	   stream.user_job_active = false;E  7 	   if istrue(print_ok) dotrailer();	/* send trailer */n  0 	   if (stream.sepctl.smbmsg$v_last_file_of_job)) 		   connect_laserwriter (&stream,false);  	}  . 	else	{	/* could not connect to laserwriter */* 		SET_STOP_REASON (LASER$_STREAMNOTSTART);- 		stream.print_status= LASER$_STREAMNOTSTART;t 		print_ok = false;] 	}  + 	releaseitems();				/* release item list */|  4 	if (stream.logfile_lines) {		/* if errors logged */" 		SET_STOP_REASON (SS$_CREATED-1);( 		closeuserlog();			/* close user log */ 	}  8 		/* if stream stalled, loop until task is aborted or */ 			/* stream is unstalled */   	if isfalse (print_ok) {
 		do_stall(); A 		while (istrue (stream.stalled) && isfalse (stream.stop_task)) {; 			hibernate();e 			do_unstall(true); 			get_debug (stream.queue); 		}  	}  ' 		/* on envoie l'accounting a JOBCTL */S   	finish_task (print_ok);   	get_debug (stream.queue); }a ; /*0  *	resetstream - reset the stream. (AST context)  *	emergency symbiont shutdown  */e static void
 resetstream()b {u 	void SYS$EXIT();p  E 	send_request (&stream, SMBMSG$K_RESET_STREAM, 0, 0, "Reset stream");g 	h 	SYS$EXIT (SS$_NORMAL);r }s s /*>  *	verification que le terminal est bien la. Contexte: non AST  */g   static void check_device() {  	boolean stat;  + 	stat= connect_laserwriter (&stream, true);n3 	stream.devsts.smbmsg$v_unavailable= isfalse(stat);B  * 	if istrue(stat) { /* check device (GG) */ 		getproduct();e: 		(void) syncprinter();	/* accounting: get page counter */. 		(void) connect_laserwriter (&stream, false); 	} 	else	do_stall (); }n t /*;  *	startstream - start the stream.	-- called at AST level !l  */u static void
 startstream()u {u* static 	const	msg_size= 80, msg_bytlm=256;M static	struct dsc$descriptor_s device = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};eK static	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};i
 	int	stat; 	int	startstatus;e 	int	SYS$ALLOC();u 	int	SYS$CREMBX();  H 	/* reset all values to known values (not useful now, since static=0) */8 	/* remember false = 0 => all boolean values are false*/  $ 	memset (&stream, 0, sizeof stream);> assert ((int)false==0);		/* all values are false by default */   		/*	get device port name	*/  5 	getitemdescrip(SMBMSG$K_DEVICE_NAME, &device, true); > 	dprintf ("Start stream: device= %.*s\n", device.dsc$w_length, 						device.dsc$a_pointer); 	sprintf (stream.dev, "%.*s",s2 				min(device.dsc$w_length, sizeof stream.dev-1), 				device.dsc$a_pointer);   		/*	get queue name */  6 	getitemdescrip(SMBMSG$K_EXECUTOR_QUEUE, &temp, true);; 	dprintf ("Start stream: queue= %.*s\n", temp.dsc$w_length,* 					temp.dsc$a_pointer);i 	sprintf (stream.queue, "%.*s", 2 				min(temp.dsc$w_length, sizeof stream.queue-1), 				temp.dsc$a_pointer);
 	if (debug) {* 		char qname[255]; 		get_debug (stream.queue);t 		dbg_close();. 		if (stream.debug!=0) dbg_init(stream.queue); 	}   	get_debug (stream.queue);  : 		/*  Copy the library file specification, if it exists */  B 	if (getitemdescrip(SMBMSG$K_LIBRARY_SPECIFICATION, &temp, false))% 		STR$COPY_DX (&library_spec, &temp);e= 	dprintf ("Start stream: library= %.*s\n", temp.dsc$w_length,l 						  temp.dsc$a_pointer);   		/* allocate device */t  ( 	stat = SYS$ALLOC (&device, 0, 0, 0, 0);6 	dprintf ("Start stream: alloc returns 0x%X\n", stat);   		/* associate control mbx */_   	if (stat & 1) {  3 static		const $DESCRIPTOR (mbx_nam,"Laser$ctlmbx");	  7 		stat = SYS$CREMBX (0, &mbxchan, msg_size, msg_bytlm,   					 0, 0, &mbx_nam);' 		dprintf ("Crembx: stat= 0x%X", stat);Q7 		if (stat&1) stat = SYS$ASSIGN (&device, &stream.chan,, 						   0, &mbx_nam);= 		dprintf ("Start stream: asn wth mbx returns 0x%X\n", stat);. 		compta_init (stream.dev);) 	}   	startstatus= stat;&( 	stream.devsts.smbmsg$l_device_flags= 0;% 	stream.devsts.smbmsg$v_lowercase= 1;l$ 	stream.devsts.smbmsg$v_terminal= 1;   	if (stat&1) { 		postmbxattn();  A 		stat= set_typeahead(stream.chan);  /* set terminal typeahead */s  ? 		dprintf ("Start stream: set typeahead returns 0x%X\n", stat);N  ( 		stream.devsts.smbmsg$v_stop_stream= 0; 	}  ? 	send_request (&stream, SMBMSG$K_START_STREAM, 0, startstatus,  $ 					"startstream: send to jobctl");   	stream.paused = false;s  	stream.user_job_active = false; 	stream.stalled = false; 	stream.debug= 0;,    ; 	if istrue(startstatus){		/* si le priph est utilisable */s 		stream.check_device= true;0 		get_config (&stream);		/* get stream config */ 	}   }i   	 /* e:  *	stopstream - stop the stream. -- called at AST level !!  */[ static void	 stopstream() {m
 	int	stat; 	void	SYS$EXIT();}   	if (stream.chan!=0) {   		stat= SYS$DASSGN (mbxchan);c, 		checkstat(stat, "stopstream: dassgn mbx");  . 		(void) connect_laserwriter (&stream, false);  ! 		stat = SYS$DASSGN(stream.chan);g- 		checkstat(stat, "stopstream: dassgn term");r 		stream.chan = 0; 	}  3 	send_request (&stream, SMBMSG$K_STOP_STREAM, 0, 0,U" 				"stopstream: send to jobctl"); 	  	SYS$EXIT (SS$_NORMAL);e }l l /* t9  *	jobctl_ast - ast routine called by the job controller.l  */r static void jobctl_ast() {	
 	int	stat;$ 	int	request;			/* jobctl request */ 	int	stream_id;	 	int	SMB$READ_MESSAGE();  E 	struct dsc$descriptor_s temp = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};r  = 	stat = SMB$READ_MESSAGE (&stream_id, &buffer_des, &request);  	/* stream_id should be 0 */& 	checkstat (stat, "SMB$READ_MESSAGE");   /*  Process the request */  / 	dprintf ("JOBCTL AST: request=%d\n", request);B   	switch (request) {;   		case SMBMSG$K_START_TASK:s 		print_efs();
 		getitems();p 		print_efs();6 		stream.task_active= true;	/* a task is now active */9 		stream.stop_task = false;	/* and has not been killed */n 		stream.stop_reason =   0;  		wake_me(); 		print_efs(); 		break;   		case SMBMSG$K_STOP_TASK:
 		getitems(); 7 		getitemdescrip(SMBMSG$K_STOP_CONDITION, &temp, true); 1 		SET_STOP_REASON (* (long*) temp.dsc$a_pointer);i 		stream.stop_task = true;% 		if istrue(stream.paused) wake_me();& 		break;   		case SMBMSG$K_START_STREAM: 
 		getitems();t 		startstream(); 		break;   		case SMBMSG$K_PAUSE_TASK:C 		stream.paused= true;< 		send_request(&stream, SMBMSG$K_PAUSE_TASK, 0, 0, "Pause"); 		break;   		case SMBMSG$K_RESUME_TASK:
 		getitems();o 		wake_me(); 		stream.paused= false;_> 		send_request(&stream, SMBMSG$K_RESUME_TASK, 0, 0, "Resume"); 		break;   		case SMBMSG$K_STOP_STREAM:
 		getitems();  		stopstream();, 		break;   		case SMBMSG$K_RESET_STREAM:. 		resetstream(); 		break; 	} }S ) static getsysinfo() {n* static	unsigned short	nodelen, vmsverslen;, static 	const	struct {uint16 itmsiz, itmcod; 			ptr32  retval, retlen;} 			syilist[]= { A 		{sizeof	smb_nodename-1, SYI$_NODENAME,&smb_nodename, &nodelen},t@ 		{sizeof smb_vmsvers, SYI$_VERSION, &smb_vmsvers, &vmsverslen},3 		{sizeof smb_maxbuf, SYI$_MAXBUF, &smb_maxbuf, 0},n
 		{0,0,0,0}};t 	unsigned long stat; 	int	SYS$GETSYIW();   0 	stat= SYS$GETSYIW (0, 0, 0, &syilist, 0, 0, 0);& 	dprintf ("MAXBUF = %lu", smb_maxbuf);   	checkstat (stat, "$GETSYIW"); 	smb_nodename[nodelen]= 0; 	smb_vmsvers [vmsverslen]= 0;0+ 	strcpy (stream.printernode, smb_nodename);  }( /*   *	setprivs - set process privs.+  *	GG rajout TMPMBX (pour mbx surveillance)w!  *		  OPER,WORLD (pour $BRKTHRUW)	  */t static voidg
 setprivs() { 
 	int stat; static	const	privs[2] = {_P   PRV$M_ALLSPOOL|PRV$M_PHY_IO|PRV$M_SYSPRV|PRV$M_TMPMBX|PRV$M_OPER|PRV$M_WORLD,  		0};t 	int	SYS$SETPRV();  # 	stat = SYS$SETPRV(1, privs, 0, 0);  	checkstat(stat, "set privs"); }d /* e*  *	initsymb - initialize printer symbiont.  *	only 1 thread	GG   */{
 initsymb() {d/ static	const	initreq= SMBMSG$K_STRUCTURE_LEVEL;,
 	int	stat; 	int	SMB$INITIALIZE();  1 	stat = SMB$INITIALIZE (&initreq, jobctl_ast, 0);S 	checkstat (stat, "initsymb"); }* /*   *	preset - preset the symbiont.  */r static void  preset() {o
 	int stat; 	int SYS$BINTIM(),LIB$GET_EF();p   	assert	( sizeof (int16) == 2);d  	assert	( sizeof (uint16) == 2); 	assert	( sizeof (int32) == 4);/  	assert	( sizeof (uint32) == 4); 	assert	( sizeof (ptr32) == 4);+  < 	/* convert duration information into VMS internal format */  2 	stat = SYS$BINTIM(&keyin_interval, keyin_daytim);! 	checkstat(stat, "bintim keyin");	2 	stat = SYS$BINTIM(&stall_interval, stall_daytim);! 	checkstat(stat, "bintim stall");   9 	stat = LIB$GET_EF(&laser_efn);	/* allocate event flag */)( 	checkstat (stat, "Allocate Laser efn");6 	stat = LIB$GET_EF(&gp_efn);	/* allocate event flag */% 	checkstat (stat, "Allocate GP efn");f 	=& 	setprivs();			/* set process privs */$ 	inititems();			/* init item list */, 	getsysinfo();			/* collect sys. info. GG */# 	initsymb();			/* do jobctl init */e }    /*<  *	validate a printer: test LAT connection, and printer type  */= static void  validate_stream(sp)  stream_t * sp; {.7 	latmaster_init (&stream);	/* init LAT device if any */t0 	check_device();			/* check connected printer */* 	sp->check_device= false;	/* check done */ }	   /*4  *	**************** Main program *******************  */	 main() {	
 	int	stat;   	dbg_init(NULL); 	 ' 	preset();				/* initialize symbiont */S 	T 	do {r  B 		while (isfalse (stream.task_active) || istrue (stream.stalled)){ 			hibernate();S  E 	/* don't requeue an active task because no work has been done yet */$  0 			if istrue (stream.stalled) do_unstall(false);; 			if istrue(stream.check_device) validate_stream(&stream);e 		}a  ' 	/* invariant: stream.stalled= false *//  $ 		print_astcnt("avant processtask");! 		processtask();			/* do a job */o$ 		print_astcnt("apres processtask");   	} while (true); }m