 /*   Facility:    	VAX/VMS Logical Disk Utility      Abstract:   ; 	This utility enables the user to create, setup and display ; 	information of the Logical Disks available in  the system,  	via the LDDRIVER.  	   Author:   * 	Jur van der Burg 	13-OCT-1992	Version 2.0 	vdburg@utrtsc.uto.dec.com  ? 	Rewritten from original MACRO version (by A. Sweep) for easier 
 	maintenance.      Revision:   * 	Jur van der Burg 	17-FEB-1993	Version 3.0   	Added trace commands  	Minor bugfixes   * 	Jur van der Burg 	23-FEB-1993	Version 3.1  ? 	Expand given devicespec in 'replace' mode to full spec instead  	of spec from the commandline. 	Add more trace functionality   * 	Jur van der Burg 	14-APR-1993	Version 4.0  , 	Modified command interface to use DCLTABLES 	Added cloned device support% 	Reworked error handling and display.  	Add remote trace stop  ) 	Jur van der Burg 	8-JUL-1993	Version 4.1   = 	Corrected bytecount display and iosb display to use longword   	instead of word field for data.> 	Bumped datafile versionnumber because of change in trace data 	layout.  * 	Jur van der Burg 	14-OCT-1993	Version 5.0   	Add WATCH commands ( 	Adapted for new interface with LDdriver  * 	Jur van der Burg 	28-OCT-1994	Version 5.1  " 	Add /SYMBOL qualifier for CONNECTD 	Add /SHARE qualifier to allow sharing of containerfiles clusterwide= 	Add /TRACKS, /SECTORS, /CYLINDERS and /MAXBLOCKS switches to @ 	CONNECT to specify geometry, removed /ALLOCATED (superceeded byA 	/MAXBLOCKS). Also added /ALLOCLASS to set allocation class which 6 	may be different from the system parameter ALLOCLASS.  * 	Jur van der Burg 	15-NOV-1996	Version 6.0  1 	Lifted restriction for contiguous container file 7 	Corrected problem setting virtual watchpoint on a file G         Make sure filename is terminated in open_file to prevent errors 9         during LD DISCONNECT/ALL/LOG with lots of devices ? 	Add /FUNCTION=ALL to watchpoint to allow trapping of all I/O's   * 	Jur van der Burg 	19-AUG-1998	Version 6.2  B 	Added a way to use more controller letters to bypass the limit ofF 	9999 cloned devices. Do this by specifying another device on connect:? 	LD CONNECT FILE.DSK LDC44. The driver can already handle this.      Commands:   2 	- LD CREATE [/LOG] [/SIZE=xxx] [/BACKUP] Filespec2 	- LD CONNECT [/LOG] [/SYMBOL] [/REPLACE] [/SHARE]/ 		[/TRACKS=xxx] [/SECTORS=xxx] [/CYLINDERS=xxx] 4 		[/MAXBLOCKS=xxx] [/ALLOCLASS=xxx] Filespec [LDan:]- 	- LD DISCONNECT [/ALL] [/LOG] [/ABORT] LDan: & 	- LD TRACE [/SIZE=xxx] [/RESET] LDan: 	- LD TRACE/STOP [/ALL] [LDan:]  	- LD NOTRACE LDan: C 	- LD WATCH LDan: lbn [,lbn...] [/FUNCTION=READ,WRITE,ALL,CODE=xxx] + 		[/ACTION=SUSPEND,CRASH,OPCOM,ERROR[=xxx]] . 	- LD NOWATCH LDan: [lbn [,lbn...]] [/INDEX=n]3 	- LD WATCH/RESUME LDan: [lbn [,lbn...]] [/INDEX=n]  	- LD SHOW [/ALL] [LDan:] & 	- LD SHOW/WATCH LDan: [lbn [,lbn...]]H 	- LD SHOW/TRACE [/STATUS] [/RESET] [/OUTPUT=Filespec] [/INPUT=filespec]: 		[/BINARY] [/ENTRIES=[(XXX,YYY)]] [/HEADER] [/CONTINUOUS]0 		[/VERSION_LIMIT=xxx] [/BLOCKS=xxx] [/WARNINGS]& 		[/NUMBER] [/PID] [/LBN] [/BYTECOUNT]( 		[/IOSB[=COMBINATION,TEXT,HEX,LONGHEX]]3 		[/TIMESTAMP[=ABSOLUTE,ELAPSED,COMBINATION,DELTA]]  		[/FUNCTION[=TEXT,HEX]] LDan:   */   #include "ld.h"    main() { 
     int stat;      int length;      char cmdbuf[1024];     struct dsc commandline =     {sizeof(cmdbuf), cmdbuf};      short rlen;      char *p;     struct cmndtbl *q;       ld_fab = cc$rms_fab;     ld_rab = cc$rms_rab;     ld_nam = cc$rms_nam;     ld_xabfhc = cc$rms_xabfhc;     outfile = 0;  % /* Get the rest of the commandline */   6     stat = lib$get_foreign(&commandline, 0, &rlen, 0);     signal_error(stat, 0);     commandline.len = rlen;       p = getqualstring(&command);,     length = strlen(p) >= 4 ? 4 : strlen(p);     q = cmnds;     while (*(q->what)) {( 	if (strncmp(p, q->what, length) == 0) {) 	    (*(q->where)) ();	/* Call command */ 
 	    exit(1);  	} 	q++;      } !     signal_error(CLI$_NOCOMD, 0);  }      int getqual(arg) struct dsc$descriptor_s *arg;  { 
     int stat;   9     stat = cli$present(arg);	/* Get qualifier presence */      if (stat == CLI$_PRESENT ||  	stat == CLI$_LOCPRES || 	stat == CLI$_DEFAULTED) 	return (1);		/* It's there */9     else if (stat == CLI$_NEGATED || stat == CLI$_LOCNEG)  	return (-1);		/* Negated */!     else if (stat == CLI$_ABSENT)  	return (0);		/* Not there */      signal_error(stat, 0); }    int getqualvalue(arg)  struct dsc$descriptor_s *arg;  {      char value[256];     struct dsc out =     {sizeof(value), &value};     int val;     short rlen;        *value = 0; 5     if ((cli$present(arg) & 1) &&	/* If present... */ > 	(cli$get_value(arg, &out, &rlen) & 1)) {	/* Get it's value */ 	*(value + (rlen & 0377)) = 0;0 	return ((sscanf(value, "%d", &val)) ? val : 0);
     } else 	return (0);		/* Default */  }    int getmulqualvalue(arg, more) struct dsc$descriptor_s *arg; 
 int *more; { 
     int stat;      char value[256];     struct dsc out =     {sizeof(value), &value};     int val;     short rlen;        *value = 0;      if (*more < 0)5 	if (!(cli$present(arg) & 1))	/* If not present... */  	    return (0);@     stat = cli$get_value(arg, &out, &rlen);	/* Get it's value */     *more = 0;     if (!(stat & 1)) 	return (0);     if (stat == CLI$_COMMA)  	*more = 1; !     *(value + (rlen & 0377)) = 0; 3     return ((sscanf(value, "%d", &val)) ? val : 0);  }    char *getqualstring(arg) struct dsc$descriptor_s *arg;  {      char *string, *p;      struct dsc out;      short rlen;   3     p = string = malloc(256);	/* Get some memory */ +     out.addr = string;		/* Setup pointer */ "     out.len = 256;		/* and size */5     if ((cli$present(arg) & 1) &&	/* If present... */ > 	(cli$get_value(arg, &out, &rlen) & 1)) {	/* Get it's value */) 	p += rlen;		/* Point to end of string */ # 	*p = '\0';		/* Place terminator */  	return (string); 
     } else 	return (0);		/* Default */  }    /*:   Show connection between LD device and corresponding file */   void show()  { 
     int stat;      int loop = 0;      char matchname[256];     struct dsc matchdev = #     {sizeof(matchname), matchname};      short rlen;      int context[2] =     {0, 0};        if (getqual(&sw_trace) > 0) 2 	show_trace();		/* Special processing for trace */$     else if (getqual(&sw_watch) > 0)2 	show_watch();		/* Special processing for watch */
     else {; 	s_device = getqualstring(&sw_device);	/* Get devicename */   ) 	if (getqual(&sw_all) > 0) {	/* /ALL ? */  	    stat = 1;3 	    while (stat & 1) {	/* Loop until we're done */ C 		stat = sys$device_scan(&matchdev, &rlen, &wildname, 0, &context);  		if (stat == SS$_NOMOREDEV) { 		    if (loop) {  			if (loop == 1) 2 			    lib$signal(&ld_nounitsfound, 1, matchname); 			else " 			    return;	/* No more, quit */ 		    } else9 			signal_error(SS$_NOSUCHDEV, 0);	/* No device at all */  		} 	 		loop++;  		signal_error(stat, 0);0 		matchname[rlen] = '\0';	/* Place terminator */7 		stat = show_one(matchname, 0);	/* Show this device */ 7 		if (stat == SS$_DEVINACT) {	/* If not connected... */ ? 		    lib$signal(&ld_notconnected, 1, matchname);	/* Flag it */ " 		    stat = 1;	/* and continue */ 		}  	    }* 	} else {		/* Only one specified device */= 	    stat = show_one(fulldevspec(s_device), 1);	/* Show it */ : 	    if (stat == SS$_DEVINACT) {	/* If not connected... */G 		lib$signal(&ld_notconnected, 1, fulldevspec(s_device));	/* Flag it */ : 		stat = &ld_notconnected;	/* Convert to better message */4 		stat |= STS$M_INHIB_MSG;	/* Don't show it again */ 	    } 	}     }  }    /*   Show one specific device */   int show_one(which, single)  char *which; int single;  { 
     int stat;      short chan;      struct iosb iosb;      char ldfile[256];      char lddev[64];      struct fiddef fid;     struct dsc sfilename =     {strlen(which), which};   9     if (get_unit(which, 1) == 0) {	/* Don't use unit 0 */  	if (single)B 	    lib$signal(&ld_badunit, 1, which);	/* Show it to the world */ 	else  	    return (1);     } Q     stat = sys$assign(&sfilename, &chan, 0, 0, 0);	/* Assign chan to LD device */ @     if (stat == SS$_DEVALLOC) {	/* Allocated on remote node ? */' 	lib$signal(&ld_remotealloc, 1, which);      } else { 	signal_error(stat, 0); I 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Inquire stat */ A 	    	    lddev, sizeof(lddev), &fid, 0, 0, LDIO_GET_CONNECTION); ! 	signal_error(stat, iosb.status); 0 	stat = sys$dassgn(chan);	/* Deassign channel */ 	signal_error(stat, 0); D 	if (!iosb_flags.connected)	/* Check 'connected' flag from driver */ 	    return (&ld_notconnected); 5 	lddev[iosb.size] = '\0';	/* Terminate device spec */  	if (iosb_flags.replaced) {  	    strcpy(ldfile,lddev);# 	    strcat(ldfile, " (Replaced)");  	} else ( 	    create_filename(lddev,&fid,ldfile); 	if (iosb_flags.protect)( 	    strcat(ldfile, " (Write protect)"); 	if (iosb_flags.share)! 	    strcat(ldfile, " (Shared)"); H 	lib$signal(&ld_connected, 2, which, ldfile);	/* Show it to the world */     }      return (1);  }    /*%   Connect LD device and file together  */   void connect_unit()  {      struct dsc sdev;
     int stat;      short chan;      int replacefl;     int shflag; 
     int unit;      int q_log;
     int func;      int tracks;      int sectors;     int cylinders;         int alloclass;     int tmp;     struct iosb iosb; #     $DESCRIPTOR(symbol, "LD_UNIT");      char tmpstr[10];     char *tmpptr;   8     s_file = getqualstring(&sw_file);	/* Get filename */B     s_device = getqualstring(&sw_device);	/* Get LD device name */,     q_log = getqual(&sw_log);	/* Get /LOG */  K     if ((alloclass = getqualvalue(&sw_alloclass)) > 0) {	/* /ALLOCLASS ? */  	if (alloclass > 255) = 	    lib$signal(&ld_badalloclass);	/* Bad allocation class */      } %     replacefl = getqual(&sw_replace);      if (!replacefl) { ) 	open_file(s_file);	/* Attempt to open */ # 	tracks = getqualvalue(&sw_tracks); % 	sectors = getqualvalue(&sw_sectors); ) 	cylinders = getqualvalue(&sw_cylinders); - 	if ((tmp = getqualvalue(&sw_maxblocks)) > 0) 6 	    maxblocks = tmp;	/* Set new value if specified */ 	else { M /* No maxblocks specified, check if geometry specified. If true set maxblocks     according to that */ = 	    if ((tracks != 0) || (sectors != 0) || (cylinders != 0)) , 		maxblocks = ((tracks == 0) ? 1 : tracks) *' 			    ((sectors == 0) ? 1 : sectors) * * 			    ((cylinders == 0) ? 1 : cylinders); 	}     } else {B 	realdev_dsc.addr = fulldevspec(s_file);	/* Set real devicename */, 	realdev_dsc.len = strlen(realdev_dsc.addr);     }      shflag = 0;      sdev.addr = "LDA0:";     sdev.len = 5; /     if (!s_device) {		/* No device specified */  	s_device = malloc(256);? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0);          if (alloclass > 0) {L 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,/* Init LD dev. */1 		    alloclass, 0, 0, 0, 0, LDIO_SET_ALLOCLASS); % 	    signal_error(stat, iosb.status); 	         }  	getdevnam(chan, s_device); 
 	shflag++;     } else { 	unit = get_unit(s_device, 0);5 	if ((unit == 0) || (unit > 9999))		/* Check range */ * 	    lib$signal(&ld_badunit, 1, s_device); 	set_seed(unit,s_device);          strcpy(tmpstr,"LDA0:");  	tmpptr = s_device+2;          tmpstr[2] = *tmpptr;         sdev.addr = tmpstr; ? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0);          if (alloclass > 0) {L 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,/* Init LD dev. */1 		    alloclass, 0, 0, 0, 0, LDIO_SET_ALLOCLASS); % 	    signal_error(stat, iosb.status); 	         }  	getdevnam(chan, s_device); # 	if (get_unit(s_device, 1) != unit) 2 	    lib$signal(&ld_dupunit);	/* Duplicate unit */     } /     if (getqual(&sw_share) > 0)		/* /SHARE ? */ $ 	func = LDIO_CONNECT | LDIO_M_SHARE;     else- 	func = LDIO_CONNECT;			/* Normal function */ 6     if (!replacefl)		/* Only if not replacing drive */I 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Init LD dev. */ 9 		    &sbk, maxblocks, tracks, sectors, cylinders, func);      elseI 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Init LD dev. */ 7 		    &realdev_dsc, 0, 0, 0, 0, func | LDIO_M_REPLACE); $     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */      signal_error(stat, 0);6     if (!replacefl)		/* Only if not replacing drive */ 	close_file(s_file);     if (getqual(&sw_symbol)) {B 	sprintf(tmpstr,"%d",get_unit(s_device, 1)); /* Get unit number */ 	sdev.addr = tmpstr; 	sdev.len = strlen(tmpstr); D 	stat = lib$set_symbol(&symbol, &sdev, 0); /* Create local symbol */ 	signal_error(stat, 0);      } "     if (q_log > 0) {		/* /LOG ? */O 	stat = show_one(fulldevspec(s_device), 1);	/* Show this one's now connected */  	signal_error(stat, 0);      } 
     else { 	if (shflag)O 	    lib$signal(&ld_unit, 1, fulldevspec(s_device)); /* Show it to the world */      }  }    void getdevnam(chan, s_device) short chan;  char *s_device;  { 
     int stat;      short rlen;      struct dsc dev =     {256, s_device};  A     stat = lib$getdvi(&DVI$_ALLDEVNAM, &chan, 0, 0, &dev, &rlen);      signal_error(stat, 0);+     s_device[rlen] = '\0';	/* Terminator */  }   2 /* Get unitnumber from unit which may not exist */   int get_unit(str, exist)
 char *str;
 int exist; {      char *p, prev;     int num, stat;     short rlen;      struct dsc dev =     {strlen(str), str};   0     if (exist) {		/* If it's there use getdvi */4 	stat = lib$getdvi(&DVI$_UNIT, 0, &dev, &num, 0, 0); 	signal_error(stat, 0);  	return (num);8     } else {			/* If it's not there find it ourselves */	 	p = str; 
 	prev = '\0'; 
 	while (*p) {  	    if (isdigit(*p)) {  		if (prev == '$') { 		    while (isdigit(*p))  			p++;  		} else/ 		    return (atoi(p));	/* Return unitnumber */  	    } 	    prev = *p++;  	}7 	lib$signal(&ld_baddevsyntax, 1, str);	/* Bad syntax */      }  }    void set_seed(num,device)  int num;
 char *device;  {      struct dsc sdev;
     int stat;      short chan;      struct iosb iosb;      char *tmpstr = "LDA0:";      char *tmpptr;   !     if (strncmp(device,"LD",2) || 1         ((device[2] < 'A') || (device[2] > 'Z'))) A         lib$signal(&ld_baddevsyntax, 1, device);	/* Bad syntax */      tmpptr = device+2;9     tmpstr[2] = *tmpptr;			/* Insert controller letter */      sdev.addr = tmpstr;      sdev.len = 5; B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);L     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Init LD dev. */V 		    num - 1, 0, 0, 0, 0, LDIO_SET_SEED);	/* minus one so next one will be correct */$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */      signal_error(stat, 0); }    /*   Enable trace */   void trace() {      struct dsc sdev;
     int stat;      short chan;      int numbuf; 
     int func;      struct iosb iosb;        if (getqual(&sw_stop) > 0) 	stop_trace();
     else {? 	s_device = getqualstring(&sw_device);	/* Get LD device name */ 7 	if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */ R 	    lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */ 	sdev.addr = s_device; 	sdev.len = strlen(s_device); M 	if ((numbuf = getqualvalue(&sw_size)) == 0)	/* Get number of tracebuffers */   	    numbuf = 512;	/* Default */0 	func = LDIO_ENABLE_TRACE;	/* Normal function */+ 	if (getqual(&sw_reset) > 0)	/* /RESET ? */  	    func = LDIO_RESET_TRACE; ? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0); 6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,0 			numbuf, 0, 0, 0, 0, func);	/* Enable trace */! 	signal_error(stat, iosb.status); / 	stat = sys$dassgn(chan);/* Deassign channel */  	signal_error(stat, 0);      }  }    /*   Disable trace  */   void notrace() {      struct dsc sdev;
     int stat;      short chan;      struct iosb iosb;   B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;V      sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0, = 		    0, 0, 0, 0, 0, LDIO_DISABLE_TRACE);	/* Disable trace */r$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */m     signal_error(stat, 0); }    /*   Enable write protect */   void protect() {a     struct dsc sdev;
     int stat;r     short chan;-     struct iosb iosb;   B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;       sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0, * 		    0, 0, 0, 0, 0, LDIO_ENABLE_PROTECT);$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */C     signal_error(stat, 0); }H   /*   Disable write protectt */   void noprotect() {r     struct dsc sdev;
     int stat;1     short chan;q     struct iosb iosb;A  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;s      sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,e+ 		    0, 0, 0, 0, 0, LDIO_DISABLE_PROTECT);f$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */i     signal_error(stat, 0); }o   /*   Enable watch */   void watch() {i     struct dsc sdev;
     int stat;      short chan; 
     int func;r     int cnt, i, size;y     struct iosb iosb; )     struct watchpt *wpt, *wpt1, wptindex;d     int *blkpnt, wptcnt;C     int function_read, function_write, function_code, function_all,v>      action_suspend, action_crash, action_error, action_opcom;,     int function_code_val, action_error_val;'     int resume, index, index_val, file;      char *filename;T   /* Get switches */  !     resume = getqual(&sw_resume);x     index = getqual(&sw_index);N/     function_read = getqual(&sw_function_read);/1     function_write = getqual(&sw_function_write);L/     function_code = getqual(&sw_function_code);b-     function_all = getqual(&sw_function_all); 1     action_suspend = getqual(&sw_action_suspend);L-     action_crash = getqual(&sw_action_crash);L-     action_opcom = getqual(&sw_action_opcom); -     action_error = getqual(&sw_action_error);L     file = getqual(&sw_file);W  9     action_error_val = SS$_BUGCHECK;	/* Default return */]     if (action_error) {(3 	action_error_val = getqualvalue(&sw_action_error);= 	if (action_error_val == 0)]% 	    action_error_val = SS$_BUGCHECK;]     }O     if (function_code)5 	function_code_val = getqualvalue(&sw_function_code);,  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;       sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);       if (file) { $ 	filename = getqualstring(&sw_file);% 	open_file(filename);	/* Open file */n     }0  2     if (index) {		/* /INDEX? (for WATCH/RESUME) */% 	index_val = getqualvalue(&sw_index);(6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,H 			0, 0, 0, 0, 0, LDIO_GET_WATCH | LDIO_M_INQUIRE);	/* Get watch size */! 	signal_error(stat, iosb.status);/. 	wptcnt = iosb_lw;	/* Number of watchpoints */- 	if ((index_val < 1) || (index_val > wptcnt)) < 	    lib$signal(&ld_wptnotfound);	/* Watchpoint not found */ 	if (wptcnt) {, 	    size = wptcnt * sizeof(struct watchpt); 	    if (!(wpt = malloc(size)))P 		signal_error(SS$_INSFMEM, 0); : 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,@ 			    wpt, size, 0, 0, 0, LDIO_GET_WATCH);	/* Get watch data */% 	    signal_error(stat, iosb.status);s6 	    wpt += index_val - 1;	/* Point to correct data */. 	    wptindex.lbn = wpt->lbn;	/* Copy block */# 	    wptindex.action = wpt->action;  	    wptindex.func = wpt->func;t% 	    wptindex.retcode = wpt->retcode;l! 	    wptindex.flags = wpt->flags;  	    wpt = &wptindex;  	    cnt = 1;		/* One entry */ 	}     } else {> 	blkpnt = getlist(&sw_lblock, &cnt);	/* Get LBN's to handle */ 	if (cnt) {+7 	    if (!(wpt = malloc(cnt * sizeof(struct watchpt)))))  		 signal_error(SS$_INSFMEM, 0);4 	    for (i = 0, wpt1 = wpt; i < cnt; i++, wpt1++) {' 		wpt1->lbn = *blkpnt++;	/* Fill lbn */  		if (function_all)t 		    wpt1->func = 0xffff; 		else if (function_read)s  		    wpt1->func = IO$_READPBLK; 		else if (function_write)! 		    wpt1->func = IO$_WRITEPBLK;i9 		else if (function_code) {	/* User specified function */r% 		    wpt1->func = function_code_val;gP 		    switch (function_code_val & IO$M_FCODE) {	/* Function without modifiers */ 		    case IO$_READPBLK: 		    case IO$_WRITEPBLK:  		    case IO$_WRITECHECK: 		    case IO$_DSE:c1 			wpt1->flags = 0;		/* Function with transfer */e	 			break;( 		    default: 			if (file)# 				lib$signal(&ld_noreadwrite, 0); 0 			wpt1->flags = FLAGS_NOLBN;	/* Special case */! 			wpt1->lbn = 0;			/* Zap lbn */o. 			break;				/* For functions without a lbn */ 		    }  		}e
 		if (file) {d9 			wpt1->flags = FLAGS_FILE;	/* Signal 'file' Function */.( 			wpt1->sbk = &sbk;		/* Point to sbk */- 			if (wpt1->lbn == 0)		/* VBN starts at 1 */n  				lib$signal(&ld_vbnerror, 0); 		} & 		if (action_suspend)	/* Set action */* 		    wpt1->action = WATCH_ACTION_SUSPEND; 		else if (action_crash)( 		    wpt1->action = WATCH_ACTION_CRASH; 		else if (action_opcom)( 		    wpt1->action = WATCH_ACTION_OPCOM; 		else if (action_error) {( 		    wpt1->action = WATCH_ACTION_ERROR;= 		    wpt1->retcode = action_error_val;	/* Error to return */  		} else 		    wpt1->retcode = 0; 	    } 	}     };     if (resume)e8 	func = LDIO_RESUME_WATCH;	/* Resume suspended thread */     else2 	func = LDIO_ENABLE_WATCH;	/* Enable watchpoint */9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,* 		    wpt, cnt, 0, 0, 0, func);{$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */t     signal_error(stat, 0);
     if (file)a' 	close_file(filename);	/* Close file */O }E   /*   Disable watch  */   void nowatch() {      struct dsc sdev;
     int stat;t
     int chan;s)     struct watchpt *wpt, *wpt1, wptindex;      struct iosb iosb;o     int cnt;     int i, size;     int *blkpnt, wptcnt;     int index, index_val;0  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;	      sdev.len = strlen(s_device);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);     index = getqual(&sw_index);      if (index) {		/* /INDEX? */t% 	index_val = getqualvalue(&sw_index);o6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,H 			0, 0, 0, 0, 0, LDIO_GET_WATCH | LDIO_M_INQUIRE);	/* Get watch size */! 	signal_error(stat, iosb.status);  	wptcnt = iosb_lw;- 	if ((index_val < 1) || (index_val > wptcnt)) < 	    lib$signal(&ld_wptnotfound);	/* Watchpoint not found */ 	if (wptcnt) {, 	    size = wptcnt * sizeof(struct watchpt); 	    if (!(wpt = malloc(size)))] 		signal_error(SS$_INSFMEM, 0);t: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,@ 			    wpt, size, 0, 0, 0, LDIO_GET_WATCH);	/* Get watch data */% 	    signal_error(stat, iosb.status);)6 	    wpt += index_val - 1;	/* Point to correct data */. 	    wptindex.lbn = wpt->lbn;	/* Copy block */# 	    wptindex.action = wpt->action;e 	    wptindex.func = wpt->func;C% 	    wptindex.retcode = wpt->retcode;l! 	    wptindex.flags = wpt->flags;) 	    wpt = &wptindex;a 	    cnt = 1;		/* One entry */ 	}     } else {7 	blkpnt = getlist(&sw_lblock, &cnt);	/* Get lbn list */d 	if (cnt) {d7 	    if (!(wpt = malloc(cnt * sizeof(struct watchpt))))t  		 signal_error(SS$_INSFMEM, 0);4 	    for (i = 0, wpt1 = wpt; i < cnt; i++, wpt1++) {< 		wpt1->flags = FLAGS_REMOVE_ALL;	/* Flag all of this lbn *// 		wpt1->lbn = *blkpnt++;	/* Fill lbn to kill */  	    } 	}     } 9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,dA 		    wpt, cnt, 0, 0, 0, LDIO_DISABLE_WATCH);	/* Disable watch */)$     signal_error(stat, iosb.status);3     stat = sys$dassgn(chan);	/* Deassign channel */a     signal_error(stat, 0); }    /*   Show watch info  */   void show_watch()e {)     struct dsc sdev;
     int stat;c
     int chan;S     struct watchpt *wpt;     struct suspend_list *slist;      struct iosb iosb; '     int wptcnt, blkcnt, slistcnt, size;      int *blkpnt;  B     s_device = getqualstring(&sw_device);	/* Get LD device name */:     if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */N 	lib$signal(&ld_badunit, 1, fulldevspec(s_device));	/* Show it to the world */     sdev.addr = s_device;s      sdev.len = strlen(s_device);*     blkpnt = getlist(&sw_lblock, &blkcnt);B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */     signal_error(stat, 0);9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,qK 		    0, 0, 0, 0, 0, LDIO_GET_WATCH | LDIO_M_INQUIRE);	/* Get watch size */s$     signal_error(stat, iosb.status);3     if (wptcnt = iosb_lw) {	/* Something to do ? *//( 	size = wptcnt * sizeof(struct watchpt); 	if (!(wpt = malloc(size))))" 	    signal_error(SS$_INSFMEM, 0);6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,< 			wpt, size, 0, 0, 0, LDIO_GET_WATCH);	/* Get watch data */! 	signal_error(stat, iosb.status);)     } 9     stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,=W 		  0, 0, 0, 0, 0, LDIO_GET_SUSPEND_LIST | LDIO_M_INQUIRE);	/* Get suspend list size */m$     signal_error(stat, iosb.status);9     if (slistcnt = iosb_lw) {	/* Something suspended ? */o/ 	size = slistcnt * sizeof(struct suspend_list);r 	if (!(slist = malloc(size))) " 	    signal_error(SS$_INSFMEM, 0);6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,G 			slist, size, 0, 0, 0, LDIO_GET_SUSPEND_LIST);	/* Get suspend list *//! 	signal_error(stat, iosb.status);_     }r3     stat = sys$dassgn(chan);	/* Deassign channel */;     signal_error(stat, 0);N     display_watch(wpt, wptcnt, blkpnt, blkcnt, slist, slistcnt);	/* Show it */ }s  @ void display_watch(wpt, wptcnt, blkpnt, blkcnt, slist, slistcnt) struct watchpt *wpt; int wptcnt;)
 int blkpnt[];  int blkcnt;h struct suspend_list *slist; 
 int slistcnt;v {/
     int i, j;s     int index, index_val;O
     int *bpt;s     int found, printed;a     struct suspend_list *spt;c     char albn[9];s     char filename[256];u  1     if (index = getqual(&sw_index))	/* /INDEX? */i5 	index_val = getqualvalue(&sw_index);	/* get value */u*     if (wptcnt) {		/* Something to do ? */
 	printed = 0;c@ 	for (i = 0; i < wptcnt; i++, wpt++) {	/* For all watchpoints */ 	    found = 0; < 	    if (blkcnt) {	/* Check if in list the user specified */3 		for (j = 0, bpt = blkpnt; j < blkcnt; j++, bpt++)  		    if (*bpt == wpt->lbn) {  			found++;i	 			break;  		    }N
 	    } else { & 		if (index) {	/* Or check by index */ 		    if (index_val == i + 1)  			found++;_ 		} else 		    found++; 	    } 	    if (found) {a. 		if (!printed) {	/* Print header only once */N 		    printf("Index LBN     Action     Function         Error return code\n");W 		    printf("--------------------------------------------------------------------\n");  		    printed = 1; 		}a  		if (wpt->flags & FLAGS_FILE) {0 			create_filename(s_device,&wpt->fid,filename);) 			printf("             %s:\n",filename);/ 		}t 		if (wpt->flags & FLAGS_NOLBN)kF 		    sprintf(albn, "%8s", "");	/* Blank for watchpoint without lbn */ 		else% 		    sprintf(albn, "%8d", wpt->lbn);. 		switch (wpt->action) { 		case WATCH_ACTION_SUSPEND:6 		    printf("%2d %s  Suspend   %-18s\n", i + 1, albn, 			   decode_func(wpt->func));8 		    for (j = 0, spt = slist; j < slistcnt; j++, spt++)  			if ((spt->lbn == wpt->lbn) &&  			    (spt->func == wpt->func))D 			    printf("             Suspended process: %08.8X\n", spt->pid); 		    break; 		case WATCH_ACTION_ERROR:7 		    printf("%2d %s  Error     %-18s   %04.4X (%s)\n",y* 			   i + 1, albn, decode_func(wpt->func),) 			   wpt->retcode, ssdef(wpt->retcode));_ 		    break; 		case WATCH_ACTION_CRASH:6 		    printf("%2d %s  Crash     %-18s\n", i + 1, albn, 			   decode_func(wpt->func)); 		    break; 		case WATCH_ACTION_OPCOM:6 		    printf("%2d %s  Opcom     %-18s\n", i + 1, albn, 			   decode_func(wpt->func)); 		    break;
 		default: 		    break; 		}n 	    } 	} 	if (!printed)< 	    lib$signal(&ld_wptnotfound);	/* Watchpoint not found */
     } else; 	lib$signal(&ld_nowatchdata);	/* No watch data available */  }e   /*)  Get a list of lbn's from the commandlinee */   int *getlist(sw, cnt) 	 char *sw;t	 int *cnt;  {m
     int more;      int *blklist, *blkpnt;  C     if (!(blklist = malloc(sizeof(int))))	/* get mem for 1 entry */u7 	 signal_error(SS$_INSFMEM, 0);	/* Not enough memory */r
     *cnt = 0;      more = -1;     blkpnt = blklist;u     for (;;) {6 	*blkpnt = getmulqualvalue(sw, &more);	/* Get entry */% 	if (more < 0)		/* Not specified ? */  	    return (blklist); 	*cnt += 1;d# 	if (more) {		/* more coming up? */ + 	    /* Get new block to accomodate size */ A 	    if (!(blklist = realloc(blklist, (*cnt + 1) * sizeof(int)))) 8 		 signal_error(SS$_INSFMEM, 0);	/* Not enough memory */ 	    blkpnt = blklist + *cnt;l 	} else( 	    break;t     }s     return blklist;  }    /*   Stop running trace */   void stop_trace()r {e
     int stat;      int loop = 0;      char matchname[256];     struct dsc matchdev = #     {sizeof(matchname), matchname};h     short rlen;      int context[2] =     {0, 0};   >     s_device = getqualstring(&sw_device);	/* Get devicename */  ,     if (getqual(&sw_all) > 0) {	/* /ALL ? */
 	stat = 1;/ 	while (stat & 1) {	/* Loop until we're done */eF 	    stat = sys$device_scan(&matchdev, &rlen, &wildname, 0, &context);! 	    if (stat == SS$_NOMOREDEV) { 
 		if (loop) {s 		    if (loop == 1). 			lib$signal(&ld_nounitsfound, 1, matchname);
 		    else 			return;	/* No more, quit */ 		} else< 		    signal_error(SS$_NOSUCHDEV, 0);	/* No device at all */ 	    } 	    loop++; 	    signal_error(stat, 0);.3 	    matchname[rlen] = '\0';	/* Place terminator */a= 	    stop_one(matchname, 0);	/* Stop trace for this device */  	},     } else			/* Only one specified device */2 	stop_one(fulldevspec(s_device), 1);	/* Stop it */ }    /*$   Stop trace for one specific device */   void stop_one(which, single) char *which; int single;e {a     struct dsc lknam; 
     int stat;a     char *qname;     struct iosb iosb;/     int lockid;0     int retlen;g     int count;
     int i;     int found;     int grp, mem;o     union prvdef oldpriv;c     struct dsc sfilename =     {strlen(which), which};l     struct lkidef locks[10];     struct lkidef *p;*     struct itmlst item[] =0     {sizeof(locks), LKI$_LOCKS, &locks, &retlen,      0, 0, 0, 0};u     struct itmlst jpi_item[] ="     {8, JPI$_CURPRIV, &oldpriv, 0,      4, JPI$_GRP, &grp, 0,      4, JPI$_MEM, &mem, 0,      0, 0, 0, 0};r  9     if (get_unit(which, 1) == 0) {	/* Don't use unit 0 */s 	if (single)B 	    lib$signal(&ld_badunit, 1, which);	/* Show it to the world */ 	elseu 	    return;     }s=     lknam.addr = build_lock(which);	/* Build resource name */ #     lknam.len = strlen(lknam.addr); K     stat = sys$enqw(0, LCK$K_NLMODE, &ld_lksb, LCK$M_SYSTEM | LCK$M_VALBLK, 8 		    &lknam, 0, 0, 0, 0, 0, 0);	/* Enqueue null lock */     signal_error(stat, 0);q     stat = sys$getlkiw(0, &ld_lksb.lockid, &item, &iosb, 0, 0, 0);	/* Get info of other locks on this resource */)$     signal_error(stat, iosb.status);K     count = (retlen & 0xffff) / ((retlen >> 16) & 0x7fff);	/* Lock count */s     p = locks;     found = 0;&     for (i = 0; i < count; i++, p++) {B 	if (p->lki$l_lkid == ld_lksb.lockid)	/* Disregard our own lock */ 	    continue; 	found = 1;CU 	stat = sys$getjpiw(0, 0, 0, &jpi_item, &iosb, 0, 0);	/* Get privs+ group + member */h! 	signal_error(stat, iosb.status);i9 	if (!((grp == ld_lksb.valblk[0]) &&	/* Group the same */ C 	      (mem == ld_lksb.valblk[1]))) {	/* as well as the member ? */ = 	    if ((grp != ld_lksb.valblk[0]) &&	/* Group the same ? */&7 		(mem != ld_lksb.valblk[1])) {	/* Member the same ? */d/ 		if (!oldpriv.prv$v_world)	/* We need WORLD */a, 		    lib$signal(&ld_noworldpriv, 1, which);B 	    } else if (grp == ld_lksb.valblk[0]) {	/* Group the same ? *// 		if (!oldpriv.prv$v_group)	/* We need GROUP */h, 		    lib$signal(&ld_nogrouppriv, 1, which); 	    } 	}N 	stat = sys$enqw(0, LCK$K_EXMODE, &ld_lksb,	/* Convert to fire blocking ast *// 			LCK$M_SYSTEM | LCK$M_CONVERT | LCK$M_VALBLK,a 			0, 0, 0, 0, 0, 0, 0); 	signal_error(stat, 0);eC 	stat = sys$deq(ld_lksb.lockid, 0, 0, 0);	/* Get rid of our lock */r 	signal_error(stat, 0);n 	break;)     }      if (!found);8 	lib$signal(&ld_conttracenotact, 1, fulldevspec(which)); }    /*   Show trace infoi */   void show_trace()  {i     struct dsc sdev;     struct dsc lknam;0
     int stat;u
     int chan;s     int trcsize;     int trcnum;_     int contin;      int qstat;
     int func;d     int inited;      int overrun;     struct iosb iosb;=     char *trcbuf;&     struct itmlst item[] =(     {4, JPI$_GRP, &ld_lksb.valblk[0], 0,(      4, JPI$_MEM, &ld_lksb.valblk[1], 0,      0, 0, 0, 0};        if (getqual(&sw_input) > 0))* 	process_input();	/* Process input file */
     else {; 	s_device = getqualstring(&sw_device);	/* Get devicename */, 	if (!s_device) ; 	    lib$signal(&ld_confqual);	/* Conflicting qualifiers */ < 	s_device = fulldevspec(s_device);	/* Get full devicespec */7 	if (get_unit(s_device, 1) == 0)	/* Don't use unit 0 */,E 	    lib$signal(&ld_badunit, 1, s_device);	/* Show it to the world */n 	sdev.addr = s_device; 	sdev.len = strlen(s_device);_ 	qstat = getqual(&sw_status);r? 	stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* Assign channel */  	signal_error(stat, 0);d    /* Get number of tracebuffers */  6 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,3 			0, 0, 0, 0, 0, LDIO_GET_TRACE | LDIO_M_INQUIRE);a! 	signal_error(stat, iosb.status); 9 	trcnum = iosb_lw;	/* Size of tracebuffer (in entries) */i- 	trcsize = trcnum * sizeof(struct trace_ent);c< 	trcbuf = malloc(trcsize);	/* Get memory for trace buffer */ 	if (trcbuf == 0)u: 	    signal_error(SS$_INSFMEM, 0);	/* Not enough memory */= 	func = LDIO_GET_TRACE | LDIO_M_NOWAIT;	/* Normal function */=+ 	if (getqual(&sw_reset) > 0)	/* /RESET ? */u 	    func |= LDIO_M_RESET;B 	if (contin = (getqual(&sw_continuous) > 0)) {	/* /CONTINUOUS ? */* 	    func = LDIO_GET_TRACE | LDIO_M_RESET;0 	    set_outband();	/* Set out-of-band escape */F 	    lknam.addr = build_lock(s_device);	/* Build lock resource name */$ 	    lknam.len = strlen(lknam.addr);N 	    stat = sys$getjpiw(0, 0, 0, &item, &iosb, 0, 0);	/* Get group + member */% 	    signal_error(stat, iosb.status);0/ 	    stat = sys$enqw(0, LCK$K_PWMODE, &ld_lksb,,$ 			    LCK$M_SYSTEM | LCK$M_NOQUEUE,! 			    &lknam, 0, 0, 0, 0, 0, 0);_ 	    if (stat == SS$_NOTQUEUED)_9 		lib$signal(&ld_conttraceact, 1, fulldevspec(s_device));A 	    signal_error(stat, 0);eL 	    stat = sys$enqw(0, LCK$K_PRMODE, &ld_lksb,	/* Write lock value block */3 			    LCK$M_SYSTEM | LCK$M_CONVERT | LCK$M_VALBLK,( 			    0, 0, 0, 0, 0, 0, 0); 	    signal_error(stat, 0);tF 	    stat = sys$enqw(0, LCK$K_PWMODE, &ld_lksb,	/* Convert up again */3 			    LCK$M_SYSTEM | LCK$M_CONVERT | LCK$M_VALBLK,U# 			    0, 0, 0, 0, &ld_exit, 0, 0);r 	    signal_error(stat, 0);t 	}  	inited = (contin > 0) ? 0 : -1; 	do {i: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,< 			    trcbuf, trcsize, 0, 0, 0, func);	/* Get trace info */ 	    signal_error(stat, 0);( 	    stat = iosb.status;" 	    if (stat == SS$_DATAOVERUN) {2 		overrun = iosb_lw;	/* Save number of overruns */ 		iosb_lw = trcnum;s
 	    } else {  		overrun = 0;D 		signal_error(stat, 0);	/* Test for other error than DATAOVERRUN */ 	    } 	    if (qstat) {n2 		lib$signal(&ld_status, 3, fulldevspec(s_device),2 			   trcnum, iosb_lw);	/* Show it to the world */ 		break;
 	    } else { % 		if (iosb_lw)	/* Anything there ? */tK 		    process_trace(trcbuf, iosb_lw, 0, overrun,	/* Process the contents */=, 				  nodename(), cvttime(0, 0, 0), inited); 		else> 		    lib$signal(&ld_notrcdata);	/* No trace data available */ 	    } 	    inited = 1; 	} 	while (contin);/ 	stat = sys$dassgn(chan);/* Deassign channel */( 	signal_error(stat, 0);r' 	free(trcbuf);		/* Get rid of buffer */)     }p }>   /*   Process the trace buffer */  C void process_trace(buf, size, ovrbuf, overrun, nname, when, inited)s
 char *buf;	 int size;$ struct ovrrun *ovrbuf; int overrun; char *nname; char *when;I int inited;l {i      static int q_bin, q_entries;0     static int q_blocks, q_version_limit, q_vsw;     static int v_end1, v_end2;     static int re_open = 0;n     static int written = 0;	     struct trace_ent *p;     static int outflg;
     int i;     int version, recnum;     int end1, end2;-     int entr, numpack;  *     if ((inited <= 0) || (re_open <= 0)) { 	if (re_open == 0) {7 	    q_entries = getqual(&sw_entries);	/* /ENTRIES ? */L 	    if (q_entries > 0) {wC 		v_end1 = getqualvalue(&sw_entries);	/* Get #of entries to show */ D 		v_end2 = getqualvalue(&sw_entries);	/* Get second part (if any) */ 	    }1 	    q_bin = getqual(&sw_binary);	/* /BINARY ? */i4 	    q_blocks = getqual(&sw_blocks);	/* /BLOCKS ? */ 	    if (q_blocks)6 		q_blocks = getqualvalue(&sw_blocks);	/* Get value */? 	    q_vsw = getqual(&sw_version_limit);	/* /VERSION_LIMIT ? */  	    if (q_vsw) { D 		q_version_limit = getqualvalue(&sw_version_limit);	/* Get value */ 		if (q_version_limit >= 32767); 		    q_version_limit = 32767; 		if (q_version_limit <= 0)O 		    q_version_limit = 1; 		q_version_limit--; 	    }2 	    outflg = getqual(&sw_output);	/* /OUTPUT ? */ 	    if (outflg > 0)= 		outfilename = getqualstring(&sw_output);	/* Get filename */t 	} 	if (outflg > 0) { 	    if (q_bin)AP 		outfilename = fullfilespec(outfilename, "LD_TRACE.DAT");	/* Provide default */	 	    else P 		outfilename = fullfilespec(outfilename, "LD_TRACE.LOG");	/* Provide default */6 	    if (re_open < 0) {	/* New open, close old file */C 		if (outfile >= 0) {	/* Closing outfile closes outfilei as well */  		    if (fclose(outfile) < 0): 			lib$signal(&ld_closerr, 1, outfilename, vaxc$errno, 0); 		}n 		if (q_vsw)/ 		    purge_file(q_version_limit, outfilename);t 	    } /*G    We want to create a normal file with some nice RMS attributes. Since,I    this can't be done with fopen() we will create the file first, and usenI    fdopen to setup the correct file pointers. This takes also care of theg/    substitution of the defaults filename parts.o */ 	    if (q_bin) 9 		outfilei = creat(outfilename, 0, "rfm=var", "ctx=bin");;	 	    else=8 		outfilei = creat(outfilename, 0, "rfm=var", "rat=cr"); 	    if ((outfilei < 0) ||/ 		((outfile = fdopen(outfilei, "a+")) == NULL)){X 		lib$signal(&ld_outfilerr, 1, outfilename, vaxc$errno, 0);	/* Can't open output file */ 	    re_open = 1; ) 	} else if (outflg < 0)	/* /NOOUTPUT ? */_ 	    return; 	elset+ 	    outfile = stdout;	/* Default output */      }n
     end2 = 0;i)     if (q_entries > 0) {	/* /ENTRIES ? */ . 	end1 = v_end1;		/* Get #of entries to show *// 	end2 = v_end2;		/* Get second part (if any) */t- 	if (end2 != 0) {	/* There's a second part */l 	    if ((end1 <= 0) ||r 		(end2 <= 0) || 		(end2 < end1)); 		lib$signal(&ld_badentparam);	/* Bad /ENTRIES parameter */e 	} 	if (end1 == 0)A# 	    return;		/* Nothing to show */a 	if (end1 > 0) {8 	    p = (struct trace_ent *) buf;	/* Start of buffer */, 	    recnum = 1;		/* First one to display */ 	    if (end2 > 0) {2 		p += (end1 - 1);/* New start, first parameter */* 		recnum = end1;	/* Adjust recordnumber */ 	    }	 	} else {.& 	    end1 = -end1;	/* Make absolute */1 	    i = ((size - end1) < 0) ? 0 : (size - end1);e& 	    p = (struct trace_ent *) buf + i;/ 	    recnum = i + 1;	/* First one to display */t 	}     } else {4 	p = (struct trace_ent *) buf;	/* Start of buffer */" 	end1 = size;		/* Default = all */( 	recnum = 1;		/* First one to display */     }O2     if (end1 > size) {		/* More than we've got? */ 	if (end2 > 0)5 	    lib$signal(&ld_pastdata);	/* Past end of data */o( 	end1 = end2 = size;	/* Enforce limit */     }p     if (end2 > size)& 	end2 = size;		/* And another limit */     if (end2 > 0),A 	numpack = end2 - end1 + 1;	/* Total number of packets to show */a     else 	numpack = end1;#     if (q_bin) {		/* Binary mode */ # 	version = DATA_FILE_VERSION << 24;c5 	if ((inited <= 0) || ((written == 0) && q_blocks)) {hT 	    if ((fwrite(&version, sizeof(int), 1, outfile) != 1) ||	/* Data file version */K 		 (fwrite(fulldevspec(s_device), 32, 1, outfile) != 1) ||	/* Devicename */d9 		 (fwrite(nname, 32, 1, outfile) != 1) ||	/* Nodename */,7 		 (fwrite(when, 24, 1, outfile) != 1))	/* Timestamp */,Z 		 lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */ 	    if (q_blocks)D 		written += sizeof(int) + 32 + 32 + 24 + (4 * 2);	/* Header size */ 	}P 	if ((fwrite(&numpack, sizeof(int), 1, outfile) != 1) ||	/* Number of entries */R 	     (fwrite(&overrun, sizeof(int), 1, outfile) != 1) ||	/* Number of overruns */T 	     (fwrite(p, sizeof(struct trace_ent), numpack, outfile) != numpack))	/* Data */] 	     lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */  	if (q_blocks) {) 	    written += (2 * (sizeof(int) + 2)) + 1 	     ((sizeof(struct trace_ent) + 2) * numpack); - 	    if (written >= ((q_blocks - 1) * 512)) {G+ 		re_open = -1;	/* Set flag for new file */a 		written = 0; 	    } 	}
     } else4 	show_trace_data(p, numpack, recnum, outfile, nname,, 			s_device, when, inited, ovrbuf, overrun);F     if ((outfile != stdout) && (inited < 0)) {	/* Close output file */ 	if (fclose(outfile) < 0)m< 	    lib$signal(&ld_closerr, 1, outfilename, vaxc$errno, 0);     }) }    /*   Format all tracedata */5 void show_trace_data(p, numpack, from, outfile, node,h- 		     device, when, inited, ovrbuf, overrun)e struct trace_ent *p; int numpack;	 int from;n FILE *outfile; char *node;t
 char *device;_ char *when;  int inited;s struct ovrrun *ovrbuf; int overrun; {i     struct ovrrun *op;!     int i, j, stat, func, ovrcnt;,#     static int pid, lbn, bytecount; )     static int iosb, function, timestamp;lI     static int time_elapsed, time_absolute, time_combination, time_delta;p+     static int function_hex, function_text;i&     static int iosb_hex, iosb_longhex;+     static int iosb_text, iosb_combination; '     static int number, header, linenum;e%     static int prev_tim[2], warnings;      int restim[2];     char record[256];q     char tmp[256];   /*   Parse various qualifiers */       if (inited <= 0) { 	pid = getqual(&sw_pid); 	lbn = getqual(&sw_lbn);$ 	bytecount = getqual(&sw_bytecount);$ 	timestamp = getqual(&sw_timestamp);* 	time_elapsed = getqual(&sw_time_elapsed);, 	time_absolute = getqual(&sw_time_absolute);2 	time_combination = getqual(&sw_time_combination);& 	time_delta = getqual(&sw_time_delta);" 	function = getqual(&sw_function);* 	function_hex = getqual(&sw_function_hex);, 	function_text = getqual(&sw_function_text); 	iosb = getqual(&sw_iosb);" 	iosb_hex = getqual(&sw_iosb_hex);* 	iosb_longhex = getqual(&sw_iosb_longhex);$ 	iosb_text = getqual(&sw_iosb_text);2 	iosb_combination = getqual(&sw_iosb_combination); 	number = getqual(&sw_number); 	header = getqual(&sw_header);" 	warnings = getqual(&sw_warnings); 	linenum = from; 	prev_tim[0] = 0;e 	prev_tim[1] = 0;c     }>8     if ((header > 0) && (inited <= 0)) {	/* /HEADER ? */A 	if (fprintf(outfile, "         I/O trace for device %s\n    %s",, 		    device, when) <= 0)n\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */& 	if (node)		/* Nodename available ? */6 	    stat = fprintf(outfile, " on node %s\n\n", node); 	elsep% 	    stat = fprintf(outfile, "\n\n");s 	if (stat <= 0)j\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */) 	*record = '\0';		/* Initially nothing */  	if (number > 0) 	    strcpy(record, "Entry "); 	if (timestamp > 0) {s 	    if (time_elapsed) 		strcat(record, "Elaps ");b 	    else if (time_absolute)- 		strcat(record, "Start Time   End Time   ");  	    else if (time_combination):' 		strcat(record, "Start Time  Elaps ");" 	    else if (time_delta)e' 		strcat(record, " Delta Time Elaps ");W 	}
 	if (pid > 0) ! 	    strcat(record, "  Pid    ");8
 	if (lbn > 0)b# 	    strcat(record, "    Lbn    ");	 	if (bytecount > 0): 	    strcat(record, " Bytes ");  	if (iosb > 0) { 	    if (iosb_hex) 		strcat(record, " Iosb[0] "); 	    else if (iosb_longhex)a' 		strcat(record, " Iosb[0]  Iosb[1] ");l 	    else if (iosb_text) 		strcat(record, " Iosb   ");l 	    else if (iosb_combination) $ 		strcat(record, " Iosb    Count "); 	} 	if (function > 0)" 	    strcat(record, " Function "); 	if (!(*record)), 	    return;		/* Nothing to display, quit */ 	j = strlen(record);/ 	record[j - 1] = '\n';	/* Zap trailing space */; 	record[j] = '\0';8 	for (i = 0; i < j - 1; i++)	/* Form string of dashes */ 	    tmp[i] = '-';( 	tmp[i++] = '\n';	/* Trailing newline */ 	tmp[i] = '\0';t- 	if ((fprintf(outfile, "%s", record) <= 0) ||u( 	    (fprintf(outfile, "%s", tmp) <= 0))\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */     }NA     for (i = 0; i < numpack; i++) {	/* For all records to show */ ? 	if ((overrun != 0) && (warnings > 0)) {	/* Signal lost data */ < 	    if (ovrbuf == 0) {	/* Called with number of overruns */ 		ovrcnt = overrun; 5 		overrun = 0;	/* Prevent display for every record */ 
 	    } else {c4 		op = ovrbuf;	/* Called after reading input file */) 		ovrcnt = 0;	/* Check overrun records */uB 		for (j = 0; j < overrun; j++, op++)	/* For all overrunrecords */& 		    if (op->recnum == linenum - 1) {* 			ovrcnt = op->overrun;	/* Found match */	 			break;  		    }i 	    } 	    if (ovrcnt > 0)3 		if (fprintf(outfile, "[%d trace record%slost]\n", . 			    ovrcnt, ovrcnt == 1 ? " " : "s ") <= 0)] 		    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */  	} 	*record = '\0';< 	func = p->func & IO$M_FCODE;	/* Strip function modifiers */D 	if ((func == IO$_SETMODE) ||	/* These functions don't have a lbn */ 	    (func == IO$_PACKACK) ||c 	    (func == IO$_AVAILABLE) ||  	    (func == IO$_UNLOAD))0 	    p->lbn = 0;		/* Clear for better readout */$ 	if (number > 0)		/* Line numbers */& 	    sprintf(record, "%5d ", linenum);  	linenum++;		/* One more line */( 	if (timestamp > 0) {	/* Time display */ 	    if (time_elapsed) {; 		stat = lib$sub_times(p->end_time, p->start_time, restim);  		signal_error(stat, 0);) 		strcat(record, cvttime(&restim, 1, 1));;  	    } else if (time_absolute) {0 		strcat(record, cvttime(&p->start_time, 0, 1)); 		strcat(record, " ");. 		strcat(record, cvttime(&p->end_time, 0, 1));# 	    } else if (time_combination) { ; 		stat = lib$sub_times(p->end_time, p->start_time, restim);} 		signal_error(stat, 0);0 		strcat(record, cvttime(&p->start_time, 0, 1)); 		strcat(record, " ");) 		strcat(record, cvttime(&restim, 1, 1));} 	    } else if (time_delta) {)1 		if ((prev_tim[0] == 0) && (prev_tim[1] == 0)) { $ 		    strcat(record, " 0:00:00.00");
 		} else {< 		    stat = lib$sub_times(p->start_time, prev_tim, restim); 		    if (!(stat & 1)) { 			if (stat == LIB$_NEGTIM) {e= 			    stat = lib$sub_times(prev_tim, p->start_time, restim);& 			    signal_error(stat, 0);A 			    strcat(record, "-");,	 			} else/ 			    signal_error(stat, 0);n 		    } else 			strcat(record, " ");k- 		    strcat(record, cvttime(&restim, 1, 0));/ 		}  		strcat(record, " ");; 		stat = lib$sub_times(p->end_time, p->start_time, restim);o 		signal_error(stat, 0);) 		strcat(record, cvttime(&restim, 1, 1));s! 		prev_tim[0] = p->start_time[0]; ! 		prev_tim[1] = p->start_time[1];{ 	    } 	    strcat(record, " ");k 	} 	if (pid > 0) {		/* Pid */# 	    sprintf(tmp, "%08X ", p->pid);  	    strcat(record, tmp);_ 	}+ 	if (lbn > 0) {		/* Logical block number */*# 	    sprintf(tmp, "%10d ", p->lbn);i 	    strcat(record, tmp);l 	}% 	if (bytecount > 0) {	/* Bytecount */e# 	    sprintf(tmp, "%6d ", p->bcnt);l 	    strcat(record, tmp);i 	}( 	if (iosb > 0) {		/* I/O status block */ 	    if (iosb_hex)& 		sprintf(tmp, "%08.8X ", p->iosb[0]); 	    else if (iosb_longhex)v9 		sprintf(tmp, "%08.8X %08.8X ", p->iosb[0], p->iosb[1]);r 	    else if (iosb_text)6 		sprintf(tmp, "%-7s ", ssdef((p->iosb[0]) & 0xffff));! 	    else if (iosb_combination) {  		if (func == IO$_SENSEMODE) 		    j = 0; 		else) 		    j = ((p->iosb[0] >> 16) & 0xffff) +C! 			((p->iosb[1] & 0xffff) << 16); = 		sprintf(tmp, "%-7s %6d ", ssdef((p->iosb[0]) & 0xffff), j);A 	    } 	    strcat(record, tmp);s 	}, 	if (function > 0) {	/* I/O function code */ 	    if (function_hex)# 		sprintf(tmp, "%04.4X ", p->func);t 	    else if (function_text), 		sprintf(tmp, "%s ", decode_func(p->func)); 	    strcat(record, tmp);  	} 	if (!(*record))+ 	    break;		/* Nothing to display, quit */t 	j = strlen(record);/ 	record[j - 1] = '\n';	/* Zap trailing space */  	record[j] = '\0';2 	if ((stat = fprintf(outfile, "%s", record)) <= 0)\ 	    lib$signal(&ld_filwrterr, 1, outfilename, vaxc$errno, 0);	/* Can't write output file */ 	p++;			/* Next record */      }$ }P   /*!   Convert status to readable codeM */ char *ssdef(code),	 int code;, {      static char msgbuf[64];n     struct dsc msgdsc =t     {sizeof(msgbuf), msgbuf}; 
     int stat;v     short rlen;n  2     stat = sys$getmsg(code, &rlen, &msgdsc, 2, 0);     signal_error(stat, 0);,     msgbuf[rlen] = '\0';	/* Trailing zero */.     return &msgbuf[1];		/* Remove leading % */ }    /*   Process input file */ void process_input() {      char *buf, *savbuf;i&     struct ovrrun *ovrbuf, *savovrbuf;     char *infilename;v     int infilei;     FILE *infile;      char namebuf[32];a     char nodebuf[32];i     char timestmp[24];
     int i;
     int size;s     int recnum;      int overruncnt;      int version;     int overrun;  N     if ((infilename = getqualstring(&sw_input)) == 0)	/* Get input filename */E 	infilename = fullfilespec("", "LD_TRACE.DAT");	/* Provide default */      elseM 	infilename = fullfilespec(infilename, "LD_TRACE.DAT");	/* Provide default */cN     if (((infilei = open(infilename, O_RDONLY, 0, "dna=LD_TRACE.DAT")) < 0) ||+ 	((infile = fdopen(infilei, "r")) == NULL))hT 	lib$signal(&ld_infilerr, 1, infilename, vaxc$errno, 0);	/* Can't open input file */P     if (fread(&version, sizeof(int), 1, infile) != 1)	/* Get datafile version */W 	 lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */E%     version = (version >> 24) & 0xff;a-     if ((version == 0) ||	/* Old version ? */v= 	(version != DATA_FILE_VERSION))	/* Incompatible version ? */kL 	lib$signal(&ld_cantreadoldfmt, 1, version);	/* Can't read old input file */D     if ((fread(namebuf, 32, 1, infile) != 1) ||	/* Get devicename */; 	(fread(nodebuf, 32, 1, infile) != 1) ||	/* Get nodename */_; 	(fread(timestmp, 24, 1, infile) != 1))	/* Get timestamp */=V 	lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */2     s_device = namebuf;		/* Point to devicename */     recnum = 0;*     overruncnt = 0;c     buf = savbuf = 0;E     ovrbuf = savovrbuf = 0;B     while (1) {,O 	if ((fread(&size, sizeof(int), 1, infile) != 1) ||	/* Get number of records */OR 	     (fread(&overrun, sizeof(int), 1, infile) != 1))	/* Get number of overruns */[ 	     lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */n /*G   We will call realloc to increase the size of our databuffer. The datasB   remains valid up till the address where we've written it before. */N 	if ((savbuf = realloc(buf, (size + recnum) * sizeof(struct trace_ent))) == 0); 	     signal_error(SS$_INSFMEM, 0);	/* Not enough memory *//& 	buf = savbuf;		/* Save new address */M 	savbuf += (recnum * sizeof(struct trace_ent));	/* Start writing from here */U 	if (overrun != 0) {6 	    if ((savovrbuf = realloc(ovrbuf, (overruncnt + 1)( 				     * sizeof(struct ovrrun))) == 0)8 		 signal_error(SS$_INSFMEM, 0);	/* Not enough memory *// 	    ovrbuf = savovrbuf;	/* Save new address */bB 	    savovrbuf += overruncnt;	/* Count total number of overruns */F 	    savovrbuf->recnum = recnum;	/* Save recordnumber with overflow */O 	    savovrbuf->overrun = overrun;	/* Save count of overruns for this record */s! 	    overruncnt++;	/* One more */c 	}4 	recnum += size;		/* Total number of data records */R 	if (fread(savbuf, sizeof(struct trace_ent), size, infile) != size)	/* Get data */[ 	     lib$signal(&ld_filreaderr, 1, infilename, vaxc$errno, 0);	/* Can't read input file */r /*K   fread returns a 0 on EOF as well as when an error occurred. Since we wanttN   to distinguish these two we try to read one more byte to find the difference */  	if ((i = fgetc(infile)) == EOF)' 	    break;		/* Ready for processing */n 	else < 	    ungetc(i, infile);	/* Return character and try again */     } I     process_trace(buf, recnum, ovrbuf, overruncnt, nodebuf, timestmp, 0);i$     free(buf);			/* Return buffer */     if (ovrbuf != 0)# 	free(ovrbuf);		/* Return buffer */ 2     if (fclose(infile) < 0)	/* Close input file */7 	lib$signal(&ld_closerr, 1, infilename, vaxc$errno, 0);* }    /*)  Decode the I/O function to readable textn */ char *decode_func(what) 	 int what;g {u     static char funcstr[80];     char str[80];      int modifier;;     int function;        if (what == 0xffff)s         return ("All");s:     modifier = what & ~IO$M_FCODE;	/* Get modifier bits */=     function = what & IO$M_FCODE;	/* Get functioncode bits */ .     if (!modifier)		/* No modifiers present */9 	return cvttbl[function];/* Return pointer to function */ 
     else { 	*str = '\0';; 	switch (function) { 	case IO$_PACKACK:8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);> 	    chk_mod(&modifier, IO$M_MSCP_FORMAT, "MSCP_FORMAT", str); 	    break;_ 	case IO$_AVAILABLE:8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);8 	    chk_mod(&modifier, IO$M_ALLHOSTS, "ALLHOSTS", str);8 	    chk_mod(&modifier, IO$M_DISSOLVE, "DISSOLVE", str);: 	    chk_mod(&modifier, IO$M_NOCLEANUP, "NOCLEANUP", str); 	    break;  	case IO$_REMSHAD:8 	    chk_mod(&modifier, IO$M_SPINDOWN, "SPINDOWN", str); 	    break;a 	case IO$_SENSECHAR:4 	    chk_mod(&modifier, IO$M_SHADOW, "SHADOW", str); 	    break;x 	case IO$_SETMODE:6 	    chk_mod(&modifier, IO$M_LINE_ON, "LINE_ON", str);8 	    chk_mod(&modifier, IO$M_LINE_OFF, "LINE_OFF", str);6 	    chk_mod(&modifier, IO$M_NEWLINE, "NEWLINE", str);2 	    chk_mod(&modifier, IO$M_ABORT, "ABORT", str); 	    break;  	case IO$_UNLOAD:t: 	    chk_mod(&modifier, IO$M_CLSEREXCP, "CLSEREXCP", str); 	    break;u 	case IO$_DSE:: 	    chk_mod(&modifier, IO$M_DATACHECK, "DATACHECK", str);2 	    chk_mod(&modifier, IO$M_ERASE, "ERASE", str); 	    break;e 	case IO$_WRITEVBLK: 	case IO$_WRITELBLK: 	case IO$_WRITEPBLK:6 	    chk_mod(&modifier, IO$M_TRUSTED, "TRUSTED", str);4 	    chk_mod(&modifier, IO$M_EXFUNC, "EXFUNC", str);8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);: 	    chk_mod(&modifier, IO$M_DATACHECK, "DATACHECK", str);: 	    chk_mod(&modifier, IO$M_CLSEREXCP, "CLSEREXCP", str);8 	    chk_mod(&modifier, IO$M_INHRETRY, "INHRETRY", str);2 	    chk_mod(&modifier, IO$M_ERASE, "ERASE", str);< 	    chk_mod(&modifier, IO$M_MSCPMODIFS, "MSCPMODIFS", str); 	    break;t 	case IO$_READVBLK:< 	case IO$_READLBLK:0 	case IO$_READPBLK:)8 	    chk_mod(&modifier, IO$M_NOVCACHE, "NOVCACHE", str);6 	    chk_mod(&modifier, IO$M_TRUSTED, "TRUSTED", str);4 	    chk_mod(&modifier, IO$M_EXFUNC, "EXFUNC", str);8 	    chk_mod(&modifier, IO$M_INHERLOG, "INHERLOG", str);: 	    chk_mod(&modifier, IO$M_DATACHECK, "DATACHECK", str);8 	    chk_mod(&modifier, IO$M_INHRETRY, "INHRETRY", str); 	    break;e	 	default:} 	    break;  	}L 	sprintf(funcstr, "%s%s", cvttbl[function], str);	/* Form function string */7 	if (modifier & ~IO$M_FCODE)	/* Any modifiers left ? */cT 	    sprintf(funcstr, "%s (%08.8X)", funcstr, modifier);	/* Show excess modifiers */1 	return (funcstr);	/* Return pointer to string */l     }  }    /*<  Check if bit set in modifier function, and copy function to  output string if true.g */. void chk_mod(modifier, mask, modifstr, outstr) int *modifier;	 int mask;  char *modifstr;z
 char *outstr;i { 7     if (*modifier & mask) {	/* Check if mask bit set */n+ 	strcat(outstr, "|");	/* Concatenate bar */=: 	strcat(outstr, modifstr);	/* Concatenate inpout string */6 	*modifier &= ~mask;	/* Flags this bit as processed */     }  }r   /*   Convert binary time to ascii,('   return only the time and not the datek */ char *cvttime(time, how, full) int time[2]; int how;	 int full;  {a     short rlen; 
     int stat;d     struct dsc timdsc;     static char timstr[256];       timdsc.len = 256;      timdsc.addr = timstr; U     stat = sys$asctim(&rlen, &timdsc, time, full);	/* Convert binary time to ascii */l     signal_error(stat, 0);0     timstr[rlen] = '\0';	/* Add trailing zero */)     if (how)			/* Display only seconds */+ 	return (&timstr[6]);;     return timstr; }    /*   Open specified file( */   void open_file(name) char *name;n {e
     int stat;r
     int i;     struct iosb iosb;l  6     ld_fab.fab$l_dna = ".DSK";	/* Default extension */*     ld_fab.fab$b_dns = 4;	/* and length */5     ld_fab.fab$l_fop = FAB$M_NAM;	/* Use NAM block */,:     ld_fab.fab$l_nam = &ld_nam;	/* Pointer to NAM block */4     ld_fab.fab$l_fna = name;	/* File name address */5     ld_fab.fab$b_fns = strlen(name);	/* and length */c9     ld_fab.fab$l_xab = &ld_xabfhc;	/* Point to FHC XAB */o>     ld_fab.fab$b_rtv = 255;		/* Open with cathedral windows */>     ld_nam.nam$b_rss = NAM$C_MAXRSS;	/* Max. resultant size */7     ld_nam.nam$l_rsa = resspec;	/* Resultant address */f=     ld_nam.nam$b_ess = NAM$C_MAXRSS;	/* Max. expanded size *//6     ld_nam.nam$l_esa = expspec;	/* Expanded address */J     ld_nam.nam$b_nop = NAM$M_NOCONCEAL;	/* Don't hide concealed devices */3     stat = sys$parse(&ld_fab);	/* Parse this one */      if (!(stat & 1))F 	lib$signal(&ld_openerr, 1, name, ld_fab.fab$l_sts, ld_fab.fab$l_stv); /*B  Copy devicename + directoryname. This is done to include possible5  rooted devicenames which we will lose after the open  */,     i = ld_nam.nam$b_dev + ld_nam.nam$b_dir;+     strncpy(realspec, ld_nam.nam$l_dev, i); 8     realspec[i] = '\0';		/* Make sure it's terminated *//     stat = sys$open(&ld_fab);	/* And open it */i     if (!(stat & 1))F 	lib$signal(&ld_openerr, 1, name, ld_fab.fab$l_sts, ld_fab.fab$l_stv);R     strncat(&realspec[i], ld_nam.nam$l_name, ld_nam.nam$b_name +	/* Append rest */+ 	    ld_nam.nam$b_type + ld_nam.nam$b_ver); 9     realspec_dsc.addr = realspec;	/* Get real filespec */2(     realspec_dsc.len = strlen(realspec);X     ldfilename_dsc.addr = &realspec[ld_nam.nam$b_dev];	/* Get filename without device */=     ldfilename_dsc.len = strlen(realspec) - ld_nam.nam$b_dev;;B     realdev_dsc.addr = ld_nam.nam$l_dev;	/* Get real devicename */'     realdev_dsc.len = ld_nam.nam$b_dev; B     maxblocks = ld_xabfhc.xab$l_ebk;	/* Get current eof pointer */;     if (ld_xabfhc.xab$w_ffb == 0)	/* Adjust if necessary */q
 	maxblocks--;n #ifdef __DECC_MODE_VAXCg=     fib.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */e+     fib.fib$w_fid[1] = ld_nam.nam$w_fid[1];e+     fib.fib$w_fid[2] = ld_nam.nam$w_fid[2];l #elsesO     fib.fib$r_fid_overlay.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */s=     fib.fib$r_fid_overlay.fib$w_fid[1] = ld_nam.nam$w_fid[1];(=     fib.fib$r_fid_overlay.fib$w_fid[2] = ld_nam.nam$w_fid[2];[ #endifT     stat = sys$assign(&realdev_dsc, &fchan, 0, 0, 0);	/* Assign channel to device */3     signal_error(stat, 0);	/* where file resides */ %     atr[0].atr$w_size = SBK$K_LENGTH;(A     atr[0].atr$w_type = ATR$C_STATBLK;	/* Get statistics block */t     atr[0].atr$l_addr = &sbk;m+     atr[1].atr$w_size = 0;	/* Terminator */,     atr[1].atr$w_type = 0; #ifdef __DECC_MODE_VAXCt5     fib.fib$v_notrunc = 1;	/* Truncate not allowed */(;     fib.fib$b_wsize = -1;	/* Open with cathedral windows */  #elsef[     fib.fib$r_acctl_overlay.fib$r_acctl_bits0.fib$v_notrunc = 1;	/* Truncate not allowed */tc     fib.fib$r_acctl_overlay.fib$r_acctl_fields2.fib$b_wsize = -1;	/* Open with cathedral windows */i #endif+     fib_dsc.addr = &fib;	/* Point to FIB */      fib_dsc.len = FIB$K_LENGTH;aD     stat = sys$qiow(0, fchan, IO$_ACCESS | IO$M_ACCESS, &iosb, 0, 0,8 		    &fib_dsc, 0, 0, 0, &atr, 0);	/* Access the file */$     signal_error(stat, iosb.status); }    /*$   Close file opened with 'open_file' */   void close_file(filename)0 char *filename;e {d
     int stat;      struct iosb iosb;i  8     stat = sys$qiow(0, fchan, IO$_DEACCESS, &iosb, 0, 0,3 		    &fib_dsc, 0, 0, 0, 0, 0);	/* Deaccess file */)$     signal_error(stat, iosb.status);:     stat = sys$dassgn(fchan);	/* And get rid of channel */     signal_error(stat, 0);3     stat = sys$close(&ld_fab);	/* Close RMS file */      if (!(stat & 1))J 	lib$signal(&ld_closerr, 1, filename, ld_fab.fab$l_sts, ld_fab.fab$l_stv);     signal_error(stat, 0); }    /*    Disconnect file from LD device */   void disconnect_unit() {o
     int stat;s     int q_abort;     int loop = 0;      char matchname[256];     struct dsc matchdev = #     {sizeof(matchname), matchname};)     short rlen;t     int context[2] =     {0, 0};l  ?     s_device = getqualstring(&sw_device);	/* Get device name */rA     q_abort = getqual(&sw_abort) > 0;	/* Get 'abort' qualifier */F,     if (getqual(&sw_all) > 0) {	/* /ALL ? */
 	stat = 1;/ 	while (stat & 1) {	/* Loop until we're done */uF 	    stat = sys$device_scan(&matchdev, &rlen, &wildname, 0, &context);! 	    if (stat == SS$_NOMOREDEV) { 
 		if (loop) {  		    if (loop == 1). 			lib$signal(&ld_nounitsfound, 1, matchname);
 		    else 			return;	/* No more, quit */ 		} else< 		    signal_error(SS$_NOSUCHDEV, 0);	/* No device at all */ 	    } 	    loop++; 	    signal_error(stat, 0);p3 	    matchname[rlen] = '\0';	/* Place terminator */ 2 	    stat = disconnect_one(matchname, q_abort, 0);! 	    /* Disconnect this device */ : 	    if (stat == SS$_DEVINACT) {	/* If not connected... */; 		lib$signal(&ld_notconnected, 1, matchname);	/* Flag it */o 		stat = 1;	/* and continue */ 	    } 	}     } else {- 	stat = disconnect_one(s_device, q_abort, 1);(6 	if (stat == SS$_DEVINACT) {	/* If not connected... */J 	    lib$signal(&ld_notconnected, 1, fulldevspec(s_device));	/* Flag it */= 	    stat = &ld_notconnected;	/* Convert to better message */ 7 	    stat |= STS$M_INHIB_MSG;	/* Don't show it again */r 	}     }, }5  * int disconnect_one(dev, abortflag, single)
 char *dev; int abortflag; int single;  {      char ldfile[256];{     char lddev[64];m     struct dsc sdev;     char *devstr; 
     int stat;s
     int chan;c
     int func;i     int replacefl;     struct iosb iosb;a     struct fiddef fid;  K     devstr = fulldevspec(dev);	/* Save devicename while it's still there */c:     if (get_unit(devstr, 1) == 0) {	/* Don't use unit 0 */ 	if (single)C 	    lib$signal(&ld_badunit, 1, devstr);	/* Show it to the world */r 	else0 	    return (1);     }i     sdev.addr = dev;     sdev.len = strlen(dev); B     stat = sys$assign(&sdev, &chan, 0, 0, 0);	/* assign channel */@     if (stat == SS$_DEVALLOC) {	/* Allocated on remote node ? */( 	lib$signal(&ld_remotealloc, 1, devstr);     } else { 	signal_error(stat, 0);i% 	if (!abortflag) {		/* No /ABORT ? */t: 	    stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,U 		   lddev, sizeof(lddev), &fid, 0, 0, LDIO_GET_CONNECTION);	/* Get current status */r 	    signal_error(stat, 0);/H 	    if (!iosb_flags.connected)	/* Check 'connected' flag from driver */ 		return (&ld_notconnected);4 	    lddev[iosb.size] = '\0';	/* Terminate string */. 	    if (!(replacefl = iosb_flags.replaced)) {% 		create_filename(lddev,&fid,ldfile);c$ 		open_file(ldfile);	/* Open file */ 	    }2 	    func = LDIO_DISCONNECT;	/* Normal function */	 	} else { E 	    func = LDIO_DISCONNECT | LDIO_M_ABORT;	/* Some more for abort */ 	         }p  M 	stat = sys$qiow(0, chan, IO$_LD_CONTROL, &iosb, 0, 0,	/* Issue disconnect */  		    &sbk, 0, 0, 0, 0, func);! 	signal_error(stat, iosb.status);(2 	stat = sys$dassgn(chan);	/* Get rid of channel */ 	signal_error(stat, 0); 0 	if (!abortflag && !replacefl)	/* No /ABORT ? */6 	    close_file(ldfile);	/* Only close if not abort */' 	if (getqual(&sw_log) > 0)	/* /LOG ? */[B 	    lib$signal(&ld_nowdisconn, 1, devstr);	/* Show what we did */     }b     return (1);r }    /*   Create file for LD */  
 void create()s {(
     int stat;0     int q_size;s     char dummy[512];  8     s_file = getqualstring(&sw_file);	/* Get filespec */*     s_file = fullfilespec(s_file, ".DSK");B     if ((q_size = getqualvalue(&sw_size)) == 0)	/* Get filesize */ 	q_size = 512;		/* Default */ 2     setup_fab(s_file, &q_size);	/* Init for RMS */3     stat = sys$parse(&ld_fab);	/* Parse filename */)     if (!(stat & 1))I 	lib$signal(&ld_createrr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);e:     if (ld_nam.nam$v_node)	/* May not contain node spec */3 	lib$signal(&ld_createrr, 1, s_file, RMS$_SUPPORT); 0     if (ld_nam.nam$v_wildcard)	/* or wildcard *// 	lib$signal(&ld_createrr, 1, s_file, RMS$_WLD);t5     stat = sys$create(&ld_fab);	/* Create the file */g     if (!(stat & 1))I 	lib$signal(&ld_createrr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv); @     setfilechar();		/* Set NOMOVE and NOBACKUP characteristic */1     stat = sys$connect(&ld_rab);/* Hook up RAB */c     if (!(stat & 1))I 	lib$signal(&ld_createrr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);h0     ld_rab.rab$l_rbf = dummy;	/* Dummy buffer */A     stat = sys$put(&ld_rab);	/* Put dummy block at end of file */;+     /* to get EOF pointer at right place */	     if (!(stat & 1))J 	lib$signal(&ld_filwrterr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);/     stat = sys$close(&ld_fab);	/* Close file */u     if (!(stat & 1))H 	lib$signal(&ld_closerr, 1, s_file, ld_fab.fab$l_sts, ld_fab.fab$l_stv);,     if (getqual(&sw_log) > 0) {	/* /LOG ? */$ 	open_file(s_file);	/* Open again */4 	lib$signal(&ld_created, 1, realspec);	/* Show it */ 	close_file(s_file);     }  }e   /*   Init FAB for create	 */   void setup_fab(filname, size)  char *filname;
 int *size; {T,     ld_fab.fab$l_alq = *size;	/* Filesize */6     ld_fab.fab$l_dna = ".DSK";	/* Default extension */*     ld_fab.fab$b_dns = 4;	/* and length */H /*    ld_fab.fab$l_fop = FAB$M_NAM | FAB$M_CBT | FAB$M_OFP; */	/* NAM */7     ld_fab.fab$l_fop = FAB$M_NAM | FAB$M_OFP;	/* NAM */l2     ld_fab.fab$b_org = FAB$C_SEQ;	/* Sequential */-     ld_fab.fab$b_rfm = FAB$C_FIX;	/* Fixed */ 2     ld_fab.fab$w_mrs = 512;	/* 512 byte records *//     ld_fab.fab$l_nam = &ld_nam;	/* NAM block */t.     ld_fab.fab$l_fna = filname;	/* Filename */8     ld_fab.fab$b_fns = strlen(filname);	/* and length */  2     ld_rab.rab$l_fab = &ld_fab;	/* Point to FAB */4     ld_rab.rab$b_rac = RAB$C_KEY;	/* Keyed access */C     ld_rab.rab$l_kbf = size;	/* Pointer to record (last in file) */i-     ld_rab.rab$w_rsz = 512;	/* Record size */o  >     ld_nam.nam$b_rss = NAM$C_MAXRSS;	/* Max. resultant size */7     ld_nam.nam$l_rsa = resspec;	/* Resultant address */a=     ld_nam.nam$b_ess = NAM$C_MAXRSS;	/* Max. expanded size */i6     ld_nam.nam$l_esa = expspec;	/* Expanded address */ }m   void setfilechar() { 
     int stat;0     struct iosb iosb;0     int attrib;s   /*B    Use QIO to modify the attributes since RMS won't support NOMOVE    until VMS V6.0n */   #ifdef __DECC_MODE_VAXCe=     fib.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */e+     fib.fib$w_fid[1] = ld_nam.nam$w_fid[1]; +     fib.fib$w_fid[2] = ld_nam.nam$w_fid[2];u #else*O     fib.fib$r_fid_overlay.fib$w_fid[0] = ld_nam.nam$w_fid[0];	/* Get file-id */ =     fib.fib$r_fid_overlay.fib$w_fid[1] = ld_nam.nam$w_fid[1];r=     fib.fib$r_fid_overlay.fib$w_fid[2] = ld_nam.nam$w_fid[2];r #endifB     realdev_dsc.addr = ld_nam.nam$l_dev;	/* Get real devicename */'     realdev_dsc.len = ld_nam.nam$b_dev;rT     stat = sys$assign(&realdev_dsc, &fchan, 0, 0, 0);	/* Assign channel to device */3     signal_error(stat, 0);	/* where file resides */($     atr[0].atr$w_size = ATR$S_UCHAR;H     atr[0].atr$w_type = ATR$C_UCHAR;	/* Get user file characteristics */      atr[0].atr$l_addr = &attrib;+     atr[1].atr$w_size = 0;	/* Terminator */+     atr[1].atr$w_type = 0;+     fib_dsc.addr = &fib;	/* Point to FIB */m     fib_dsc.len = FIB$K_LENGTH;i6     stat = sys$qiow(0, fchan, IO$_ACCESS, &iosb, 0, 0,8 		    &fib_dsc, 0, 0, 0, &atr, 0);	/* Access the file */$     signal_error(stat, iosb.status);.     attrib |= FCH$M_NOMOVE;	/* Mark no move */      if (getqual(&sw_backup) < 0)/ 	attrib |= FCH$M_NOBACKUP;	/* Mark no backup */i6     stat = sys$qiow(0, fchan, IO$_MODIFY, &iosb, 0, 0,8 		    &fib_dsc, 0, 0, 0, &atr, 0);	/* Access the file */$     signal_error(stat, iosb.status);6     stat = sys$dassgn(fchan);	/* Get rid of channel */     signal_error(stat, 0); }f   /*&   Get full filename from specified one */  ! char *fullfilespec(name, defname)  char *name, *defname;i {l%     static char tmpnam[NAM$C_MAXRSS];/
     int stat;r     int len;  
     if (name), 	len = strlen(name);     else	 	len = 0;r  :     ld_nam.nam$b_nop = NAM$M_NOCONCEAL;	/* Name options */=     ld_nam.nam$b_ess = NAM$C_MAXRSS;	/* Max. expanded size */o5     ld_nam.nam$l_esa = tmpnam;	/* Expanded address */e  /     ld_fab.fab$l_nam = &ld_nam;	/* NAM block */i:     ld_fab.fab$l_dna = defname;	/* Default name address */?     ld_fab.fab$b_dns = strlen(defname);	/* Default name size */ 1     ld_fab.fab$b_fns = len;	/* Filename length */x3     ld_fab.fab$l_fna = name;	/* Filename address */   4     stat = sys$parse(&ld_fab);	/* Parse this name */     if (!(stat & 1))D 	lib$signal(&ld_detectederr, 0, ld_fab.fab$l_sts, ld_fab.fab$l_stv);9     tmpnam[ld_nam.nam$b_esl] = '\0';	/* Add terminator */*     return (tmpnam); }\   /*)   Get full device name from specified one  */   char *fulldevspec(name)R char *name;G {s     char *tmpnam;&     struct dsc resdsc;-     struct dsc namdsc = {strlen(name), name};O     short rlen; 
     int stat;i  8     tmpnam = malloc(64);	/* Get memory for devicename */     if (tmpnam == 0)6 	signal_error(SS$_INSFMEM, 0);	/* Not enough memory */     resdsc.addr = tmpnam;d     resdsc.len = 64;[     stat = lib$getdvi(&DVI$_FULLDEVNAM, 0, &namdsc, 0, &resdsc, &rlen);	/* Get full name */D     signal_error(stat, 0);)     tmpnam[rlen] = '\0';	/* Terminator */d/     return (tmpnam + 1);	/* Skip leading '_' */e }x   /*    Get full filespec from file-id */  ' void create_filename(device,fid,outbuf)m
 char *device;O struct fiddef *fid;F
 char *outbuf;c {m     struct dsc outdsc;     struct dsc devdsc;
     int stat;i     short rlen;      char tmpbuf[256];e     char *p;  7     devdsc.len = strlen(device);	/* Input devicename */X     devdsc.addr = device;c;     outdsc.len = sizeof(tmpbuf);	/* Output buffer length */E     outdsc.addr = tmpbuf;o?     stat = lib$fid_to_name(&devdsc, fid, &outdsc, &rlen, 0, 0);V     signal_error(stat, 0);     tmpbuf[rlen]='\0';  @ /* Modify the devicename (as returned from lib$fid_to_name) from"    DISK$LABEL: to _SYSTEM$BLA0: */  A     strcpy(outbuf,fulldevspec(device));	/* Get real devicename */k     p = strchr(tmpbuf,':') + 1;D     strcat(outbuf,p);c }m   /*   Get nodename */   char *nodename() {      static char tmpnam[256];     static struct dsc resdsc =     {sizeof(tmpnam), tmpnam};      struct dsc tbl =     {12, "LNM$FILE_DEV"};M     struct dsc lognam =;     {8, "SYS$NODE"};     short rlen;c     struct itmlst item[2];
     int stat;        tmpnam[0] = '\0';MR     stat = lib$getsyi(&SYI$_NODENAME, 0, &resdsc, &rlen, 0, 0);	/* Get nodename */)     if (stat & 1) {		/* Nodename found */U& 	tmpnam[rlen] = '\0';	/* Terminator */ 	strcat(tmpnam, "::");:     } else {			/* No nodename, try the logical SYS$NODE */ 	item[0].item = LNM$_STRING; 	item[0].buflen = 256; 	item[0].addr = tmpnam;d 	item[0].rlength = &rlen; ( 	item[1].item = 0;	/* End of itemlist */ 	item[1].buflen = 0;/ 	stat = sys$trnlnm(0, &tbl, &lognam, 0, &item);  	signal_error(stat, 0); & 	tmpnam[rlen] = '\0';	/* Terminator */     }i     return (tmpnam); }i /*   Build lock for trace */   char *build_lock(dev)l
 char *dev; {      static char locknam[256];e  >     strcpy(locknam, "$LOGDISK_");	/* First part of lockname */5     strcat(locknam, nodename());/* Attach nodename */f@     locknam[strlen(locknam) - 2] = '\0';	/* Zap trailing "::" */>     strcat(locknam, fulldevspec(dev));	/* Attach devicename */     return locknam;b }*   void set_outband() {s
     int stat;n
     int type;n     int mask[2];     struct iosb iosb;b(     $DESCRIPTOR(outbdev, "SYS$COMMAND");  ;     stat = lib$getdvi(&DVI$_TRM, 0, &outbdev, &type, 0, 0);e     signal_error(stat, 0);3     if (!type)			/* Not a terminal, don't bother */a 	return;M     stat = sys$assign(&outbdev, &outband_chan, 0, 0, 0);	/* assign channel */      signal_error(stat, 0);     mask[0] = 0;4     mask[1] = (1 << ('C' - 64)) | (1 << ('Z' - 64));M     stat = sys$qiow(0, outband_chan, IO$_SETMODE | IO$M_OUTBAND, &iosb, 0, 0,r< 		    &ld_exit, &mask, 0, 0, 0, 0);	/* Get current status */$     signal_error(stat, iosb.status); })   void purge_file(limit, name)
 int limit; char *name;  { 
     int stat;e     char *pos;     char tmpnam[256];r     struct dsc fildsc;     $DESCRIPTOR(deflt, ".DAT");d  3     pos = strrchr(name, ';');	/* Find trailing ; */d     if (pos != 0) { # 	if (name[strlen(name) - 1] != ';')	, 	    return;		/* Exact filespec speficied */ 	else	& 	    *pos = '\0';	/* Zap trailing ; */     }a     if (limit == 0) D 	sprintf(tmpnam, "%s;%d", name, limit);	/* Delete lastest version */     elseA 	sprintf(tmpnam, "%s;-%d", name, limit);	/* Delete old version */v     fildsc.addr = tmpnam;d      fildsc.len = strlen(tmpnam);  
     stat = 1;;/     while (stat == 1)		/* until out of files */=> 	stat = lib$delete_file(&fildsc, &deflt, 0, 0, 0, 0, 0, 0, 0);8     if (stat != RMS$_FNF)	/* No such file is no error */ 	signal_error(stat, 0);r }    void ld_exit(param)p
 int param; {E
     int stat;d  H     if ((outfile != 0) && (outfile != stdout)) {	/* Close output file */ 	if (fclose(outfile) < 0)b< 	    lib$signal(&ld_closerr, 1, outfilename, vaxc$errno, 0);     }*,     stat = sys$deq(ld_lksb.lockid, 0, 0, 0);     signal_error(stat, 0);     if (outband_chan != 0) {: 	stat = sys$dassgn(outband_chan);	/* Get rid of channel */ 	signal_error(stat, 0);e     } ;     if (param == 0) {		/* Called by blocking ast routine */  	lib$signal(&ld_tracestopped); 	exit(&ld_tracestopped);
     } else	 	exit(1);t }&   void signal_error(st1, st2)1
 int st1, st2;f {l     int stat1, stat2;;     int modified1, modified2;n  I     modified1 = convert_error(st1, &stat1);	/* Return reasonable error */++     modified2 = convert_error(st2, &stat2); 4     if ((!(stat1 & 1)) || (st2 && (!(stat2 & 1)))) { 	if (modified1 || modified2) { 	    if (stat1 == 1) 		lib$signal(stat2, 0, 0);	 	    elsee$ 		lib$signal(stat1, 0, stat2, 0, 0);	 	} else {e 	    if (stat1 == 1). 		lib$signal(&ld_detectederr, 0, stat2, 0, 0);	 	    else 8 		lib$signal(&ld_detectederr, 0, stat1, 0, stat2, 0, 0); 	}     }b }k   /*;   Return a reasonable error for some returned by the driverx */  ' int convert_error(oldstatus, newstatus)q int oldstatus; int *newstatus;O {V     int code = 0;_  #     if (oldstatus == SS$_DEVASSIGN)l; 	code = &ld_devassign;	/* 'Device has channels assigned' */i(     else if (oldstatus == SS$_DEVACTIVE)0 	code = &ld_alrdyconn;	/* 'Already connected' */'     else if (oldstatus == SS$_DEVINACT) * 	code = &ld_notconn;	/* 'Not connected' */%     else if (oldstatus == SS$_NODATA)a7 	code = &ld_trcdisabl;	/* 'Tracing already disabled' */=*     else if (oldstatus == SS$_TOOMUCHDATA)5 	code = &ld_trcenabl;	/* 'Tracing already enabled' */0'     else if (oldstatus == SS$_DATALOST)a= 	code = &ld_nowatchdata;	/* 'No watchpoint data available' */L(     else if (oldstatus == SS$_DATACHECK)5 	code = &ld_wptnotfound;	/* 'Watchpoint not found' */m(     else if (oldstatus == SS$_NOTVOLSET)I 	code = &ld_fileonvolset;/* 'File watchpoint on volumeset not allowed' */*(     else if (oldstatus == SS$_FILALRACC)2 	code = &ld_fileinuse;	/* 'File already in use' */'     else if (oldstatus == SS$_DEVALLOC) 6 	code = &ld_deviceinuse;	/* 'Device already in use' */(     else if (oldstatus == SS$_DEVREQERR)G 	code = &ld_fileonother;	/* 'File not allowed to be on other device' */o(     else if (oldstatus == SS$_ILLBLKNUM)D 	code = &ld_vbnerror;	/* 'Illegal virtual block number specified' */*     else if (oldstatus == SS$_UNSUPPORTED)5 	code = &ld_nocluster;	/* 'No cluster code loaded' */s)     else if (oldstatus == SS$_ACCONFLICT)nD 	code = &ld_notvisible;	/* 'Device is not visible on other nodes' */'     else if (oldstatus == SS$_BADPARAM)t; 	code = &ld_invgeometry;	/* 'Invalid geometry specified' */b%     else if (oldstatus == SS$_UNSAFE)*S 	code = &ld_devconnected;/* 'Cannot set allocation class with active LD devices' */d'     else if (oldstatus == SS$_WRONGACP);F 	code = &ld_notods2;	/* 'Container file must be on an ODS-2 volume' */
     else {5 	*newstatus = oldstatus;	/* Return original status */b 	return 0;		/* Not modified */     };/     *newstatus = code;		/* Return new status */      return 1;			/* Modified */ }n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                