 /*6             %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\7             %% \___________________________________%% \ 8             %% |                                   %%  \9             %% |              MiniSm               %%   \ :             %% |        callbacks.c  c1995         %%    \:             %% |            Lyle W. West           %%    |:             %% |                                   %%    |:             %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |:             \                                        \   |:              \                                        \  |:               \                                        \ |:                \________________________________________\|      :      Copyright (C) 1995 Lyle W. West, All Rights Reserved.K      Permission is granted to copy and use this program so long as [1] this I      copyright notice is preserved, and [2] no financial gain is involved I      in copying the program.  This program may not be sold as "shareware" H      or "public domain" software without the express, written permission      of the author.    */   #include "includes.h"  #include "externs.h" #include <X11/cursorfont.h>    extern int AstEvent();  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AppListSelCB G  * Description: User selected AppList from File menu. If AppForm widget B  *              is address is NULL then create it. Else manage the*  *              AppForm widget and return.  *!  * Inputs: Normal callback inputs   *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ G void AppListSelCB(Widget w, XtPointer client_data, XtPointer call_data)  {   #     if(!AppForm) AppDefDlgCreate();       else XtManageChild(AppForm); }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AppDefBtnCBC  * Description: User selected one of the buttons from AppDef dialog G  *              popup. Determine which button and perform approp action   *!  * Inputs: Normal callback inputs   *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ F void AppDefBtnCB(Widget w, XtPointer client_data, XtPointer call_data) {      int selpos = 0;      int status;      int appscnt;     char errmsgbuf[80];      String filespec;   /*  appscnt = AppLstNumApps; */      selpos = AppLstSelPos;     switch ((int)client_data) { F         case ADD_BTN:   /* check for valid file & less than MAXAPPS */2             filespec = XmTextGetString(AppCmdTxt);:             status = CmdStrValid(filespec, AppLstNumApps);              if(status == TRUE) {                  AppLstNumApps++;.                 if(AppLstNumApps == MAXAPPS) {Q                     sprintf(errmsgbuf, "Exceeded maximum application limit,\n%s", 1                         "application not added"); A                     DispErrPopup("Add", &errmsgbuf, FALSE, TRUE);                  }                  else {4                     ModifyAppsList(AppLstNumApps+1);*                     AppLstModified = TRUE;                 }                  n = 0;7                 XtSetArg(args[n], XmNvalue, "\0"); n++; P                 XtSetValues(AppNamTxt, args, n);    /* clear application name */                 n = 0;7                 XtSetArg(args[n], XmNvalue, "\0"); n++; S                 XtSetValues(AppCmdTxt, args, n);    /* clear application command */   -                 XtSetSensitive(AddPB, False); 6                 if(AppLstNumApps != MAXAPPS) {        8                     XtSetSensitive(AppDefApplyPB, True);5                     XtSetSensitive(AppDefOkPB, True); / /*                  AppLstNumApps = appscnt; */                  } 
             }              else {M                 sprintf(errmsgbuf, "'%s' is\na non-existant file", filespec); >                 DispErrPopup("Add", &errmsgbuf, FALSE, TRUE); 
             }              XtFree(filespec);              break;           case APPLY_BTN: 0             CopyAppList(AppLstNumApps, TO_LIST);             break;           case CANCEL_BTN:             n = 0;3             XtSetArg(args[n], XmNvalue, "\0"); n++; L             XtSetValues(AppNamTxt, args, n);    /* clear application name */             n = 0;3             XtSetArg(args[n], XmNvalue, "\0"); n++; O             XtSetValues(AppCmdTxt, args, n);    /* clear application command */ %             XtUnmanageChild(AppForm); :             if(selpos) XmListDeselectPos(AppsLst, selpos);             AppLstSelPos = 0; .             XtSetSensitive(AppDefOkPB, False);1             XtSetSensitive(AppDefApplyPB, False); )             XtSetSensitive(AddPB, False);              n = 0;8             XtSetArg(args[n], XmNsensitive, False); n++;+             XtSetValues(RemovePB, args, n); %             XtUnmanageChild(AppForm);              break;           case OK_BTN:0             CopyAppList(AppLstNumApps, TO_LIST);%             XtUnmanageChild(AppForm);              break;           case REMOVE_BTN:3             XmListDeletePos(AppsLst, AppLstSelPos);              AppLstSelPos = 0;              selpos--;              AppLstNumApps--;1             AdjustAppsLst(selpos, AppLstNumApps); "             AppLstModified = TRUE;             n = 0;3             XtSetArg(args[n], XmNvalue, "\0"); n++; L             XtSetValues(AppNamTxt, args, n);    /* clear application name */             n = 0;3             XtSetArg(args[n], XmNvalue, "\0"); n++; O             XtSetValues(AppCmdTxt, args, n);    /* clear application command */ 0             XtSetSensitive(AppDefApplyPB, True);-             XtSetSensitive(AppDefOkPB, True);              n = 0;8             XtSetArg(args[n], XmNsensitive, False); n++;+             XtSetValues(RemovePB, args, n);              break;     }  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: DispErrPopupCB H  * Description: Popup message box indicating abmormal return status fromG  *              a system (non X11) call. Uses OK button. This is a NOP.   *!  * Inputs: Normal callback inputs   *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ I void DispErrPopupCB(Widget w, XtPointer client_data, XtPointer call_data)  { 
 #ifdef ARF     switch ((int)client_data) { ,         case OK_BTN:         /* Ok button */             break;0         case CANCEL_BTN:     /* Cancel button */             break;     }  #else      int dummy = 0; #endif }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ExceedTaskPopupCBD  * Description: Popup message box for exceeding max task count will F  *              come here after user presses OK button. This is a NOP.  *  * Inputs: Irrelevant   *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */   L void ExceedTaskPopupCB(Widget w, XtPointer client_data, XtPointer call_data) {      int dummy; }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AppTxt_activateCBB  * Description: User pressed Return key while cursor was in either*  *              AppName or AppCmd text box  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ L void AppTxt_activateCB(Widget w, XtPointer client_data, XtPointer call_data) {      int dummy; }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AppsSelCBB  * Description: User selected an existing application from  the   B  *              Applications List widget. Display application nameK  *              and application command string. If same item was previously F  *              selected, unselect item and clear the application name/  *              and application command string.   *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ D void AppsSelCB(Widget w, XtPointer client_data, XtPointer call_data) { C     XmListCallbackStruct *cb =  (XmListCallbackStruct *) call_data;      int newpos = 0;      XmString SelApp;     APPSLST *AscFiles;        newpos  = cb->item_position;F     if(AppLstSelPos == newpos) { /* Already selected, unselect item */         newpos--; "         AscFiles = AscNewAppsList;         AscFiles += newpos; A         SelApp = XmStringCreateLtoR(AscFiles->ApplName, charset); ,         XmListDeselectItem(AppsLst, SelApp);         XmStringFree(SelApp);          AppLstSelPos = 0; (         XtSetSensitive(RemovePB, False);*         XtSetSensitive(AppDefOkPB, False);-         XtSetSensitive(AppDefApplyPB, False); %         XtSetSensitive(AddPB, False); !         XmUpdateDisplay(AppForm);          n = 0;-         XtSetArg(args[n], XmNvalue, ""); n++; H         XtSetValues(AppNamTxt, args, n);    /* Clear application name */         n = 0;-         XtSetArg(args[n], XmNvalue, ""); n++; F         XtSetValues(AppCmdTxt, args, n);    /* Clear command string */     } 9     else {      /* User selected previously unsel item */          n = 0;3         XtSetArg(args[n], XmNsensitive, True); n++; '         XtSetValues(RemovePB, args, n);          AppLstSelPos = newpos;         newpos--; "         AscFiles = AscNewAppsList;         AscFiles += newpos;          n = 0;=         XtSetArg(args[n], XmNvalue, AscFiles->ApplName); n++; I         XtSetValues(AppNamTxt, args, n);    /* Insert application name */          n = 0;<         XtSetArg(args[n], XmNvalue, AscFiles->ApplCmd); n++;G         XtSetValues(AppCmdTxt, args, n);    /* Insert command string */      }  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AppTxtchangedCBC  * Description: User added or deleted char(s) from either AppNamTxt ?  *              or AppCmdTxt text box in Application Definition B  *              popup dialog. If text NOT added because of an itemB  *              being selected from AppDefLst, the turn off Remove,  *              button & turn on Add button.  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ J void AppTxtchangedCB(Widget w, XtPointer client_data, XtPointer call_data) {      short RemoveStat;      XmTextPosition curlength;        switch((int)client_data) {         case NAMTXT:9             curlength = XmTextGetLastPosition(AppNamTxt); 3             if(curlength) AppNamstrlen = curlength; "             else AppNamstrlen = 0;             break;         case CMDTXT:9             curlength = XmTextGetLastPosition(AppCmdTxt); 3             if(curlength) AppCmdstrlen = curlength; "             else AppNamstrlen = 0;             break;     } E     if(!AppLstSelPos) {     /* txt not added due to item selection */ *         if(AppNamstrlen && AppCmdstrlen) {(             XtSetSensitive(AddPB, True);,             XtSetSensitive(RemovePB, False);	         }      } 
     else {'         XtSetSensitive(RemovePB, True); %         XtSetSensitive(AddPB, False);      } 
 #ifdef ARFE     n = 0;  /* if Remove button sensitive, dont make Add sensitive */ 6     XtSetArg(args[n], XmNsensitive, &RemoveStat); n++;#     XtGetValues(RemovePB, args, n); !     if(RemoveStat & 0xff) return; A     if(AppNamstrlen && AppCmdstrlen) XtSetSensitive(AddPB, True); &     else XtSetSensitive(AddPB, False); #endif }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: FileSelCBA  * Description: This is a selection callback.  Its function is to F  *              identify the application filename selected by the userG  *              and execute that file via spawn or run, add the last 3  E  *              digits of the mpid to taskname (for the procnam) then I  *              add to to task list. Finally it deselects the application H  *              file which was selected. First checks are made to verifyF  *              the value of num_tasks is less than the constant value4  *              of MAXTASKS. Return if this is True.  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ D void FileSelCB(Widget w, XtPointer client_data, XtPointer call_data) { 
     int indx;      int flags = 9;     int status;      int taskpid;     char comfile[135];     char taskstr[30];      char procname[17];     char *ptr;     static Cursor watch = 0;     XmString TaskName;     APPSLST *AscFiles;     TASKLST *TaskPtr; "     $DESCRIPTOR(dsc_com, comfile);%     $DESCRIPTOR(dsc_disp, decw_disp); #     $DESCRIPTOR(dsc_prc, procname); C     XmListCallbackStruct *cb =  (XmListCallbackStruct *) call_data;        indx = cb->item_position;      indx--;      if(num_tasks >= MAXTASKS) { .         ExceedTask(w, client_data, call_data);9         XmListDeselectItem(AppsList, CsAlistItems[indx]);          return;      } ;     watch = XCreateFontCursor(XtDisplay(MsmForm),XC_watch); >     XDefineCursor(XtDisplay(MsmForm),XtWindow(MsmForm),watch);     AscFiles = AscAppsList;      AscFiles += indx; (     strcpy(taskstr, AscFiles->ApplName);%     status = CheckDetached(&taskstr); .     dsc_disp.dsc$w_length = strlen(decw_disp);)     strcpy(procname, AscFiles->ApplName); 3     if(strlen(procname) >= 12) procname[11] = '\0';      strcat(procname, mpidsfx);,     dsc_prc.dsc$w_length = strlen(procname);.     sprintf(comfile, "%s", AscFiles->ApplCmd);+     dsc_com.dsc$w_length = strlen(comfile); 2     status = lib$spawn(0,       /* command line */0              &dsc_com,          /* input file */1              &dsc_disp,         /* output file */ +              &flags,            /* flags */ 2              &dsc_prc,          /* process name */0              &taskpid,          /* process id */7              0,                 /* completion status */ 4              0,                 /* event flag num */1              0,                 /* AST address */ 2              0,                 /* AST argument */3              0,                 /* prompt string */ )              0);                /* cli */ <     if(status != 1) DispErrPopup(AscFiles, 0, status, TRUE);
     else {C         XmUpdateDisplay(MsmForm);    /* startup the Watch cursor */          TaskPtr = TaskStruct;          TaskPtr += num_tasks; #         TaskPtr->TaskPid = taskpid; +         strcpy(TaskPtr->TaskName, taskstr);          num_tasks++;8         TaskName = XmStringCreateLtoR(taskstr, charset);7         XmListAddItemUnselected(TaskList, TaskName, 0); 7         newtaskpos = XmListItemPos(TaskList, TaskName);          XmStringFree(TaskName);          NewTask(taskpid);          n = 0;.         XtSetArg(args[n], XmNwidth, 120); n++;'         XtSetValues(TaskList, args, n);      } 5     XmListDeselectItem(AppsList, CsAlistItems[indx]);      if(detached) {&         FindTaskPid(&taskstr,taskpid);         detached = FALSE;      } 
     n = 0;*     XtSetArg(args[n], XmNwidth, 130); n++;#     XtSetValues(AppsList, args, n); '     XtSetSensitive(StopTaskBtn, FALSE); :     XUndefineCursor(XtDisplay(MsmForm),XtWindow(MsmForm));     XmUpdateDisplay(MsmForm);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: FsBoxActivateCBN  * Description: User selected either OK or Cancel button in File Selection Box  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ J void FsBoxActivateCB(Widget w, XtPointer client_data, XtPointer call_data) {      int status;      String NewdirTmp;      Widget temp;       switch ((int)client_data) { ,         case OK_BTN:         /* Ok Button */@             temp = XmFileSelectionBoxGetChild(w, XmDIALOG_TEXT);.             NewdirTmp = XmTextGetString(temp);-             strcpy(AppsInputFile, NewdirTmp);              XtFree(NewdirTmp);             if(num_apps) {#                 cfree(AscAppsList); +                 XmStringFree(CsAlistItems);%
             }              LoadAppFileList();             break;  4         case CANCEL_BTN:         /* Cancel Button */             break;     }      XtUnmanageChild(FsbDialog);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: FsBoxCreateCB:  * Description: User selected 'Open' option from File menu  *  * Inputs: Parent widget  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void FsBoxCreateCB(Widget w) {      char *ptr;     char TargetDir[80];      Widget nobtn;\       if(Xdefaults) {_)         strcpy(TargetDir, AppsInputFile); %         ptr = strchr(TargetDir, ']');          if(ptr) {.             ptr++;             *ptr = '\0';	         }      } 
     else {'         strcpy(TargetDir, "SYS$LOGIN"); #         GetLogicalName(&TargetDir);      }o       if(FsbDialog) {s'         XtSetArg(args[n], XmNdirectory, 9             XmStringCreateLtoR(TargetDir, charset)); n++;e(         XtSetValues(FsbDialog, args, n);!         XtManageChild(FsbDialog);"     }.
     else {         n = 0;*         XtSetArg(args[n], XmNdialogTitle, J             XmStringCreateLtoR("Select Applications File", charset)); n++;.         XtSetArg(args[n], XmNlistLabelString, <             XmStringCreateLtoR("Appl Files", charset)); n++;3         XtSetArg(args[n], XmNselectionLabelString, t@             XmStringCreateLtoR("New Input File", charset)); n++;(         XtSetArg(args[n], XmNdirectory, 9             XmStringCreateLtoR(TargetDir, charset)); n++;*%         XtSetArg(args[n], XmNpattern,t7             XmStringCreateLtoR("*.INP", charset)); n++;a3         XtSetArg(args[n], XmNtextColumns, 32); n++;lI         FsbDialog = XmCreateFileSelectionDialog(w, "FsbDialog", args, n);*H         nobtn = XmSelectionBoxGetChild(FsbDialog, XmDIALOG_HELP_BUTTON);         XtUnmanageChild(nobtn);t!         XtManageChild(FsbDialog);   I         XtAddCallback(FsbDialog, XmNokCallback, FsBoxActivateCB, OK_BTN);IQ         XtAddCallback(FsbDialog, XmNcancelCallback, FsBoxActivateCB, CANCEL_BTN);*     }* }*  N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: SaveCBlE  * Description: User entered AppDef filespec and presses Ok or Cancel   *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */BA void SaveCB(Widget w, XtPointer client_data, XtPointer call_data)i {p     String filename;     Widget TextWidget;     APPSLST *AppsPtr;l&     XmSelectionBoxCallbackStruct *cb =2         (XmSelectionBoxCallbackStruct *)call_data;       switch ((int)client_data) {          case OK_BTN:              if(AppLstModified) {F                 TextWidget = XmSelectionBoxGetChild(w, XmDIALOG_TEXT);7                 filename = XmTextGetString(TextWidget);"
 #ifdef MSMDBGA>                 printf("SaveCB: Writing file %s\n", filename); #endif/                 AppsFp = fopen(filename, "w+");                  if(!AppsFp) {;K                     printf("SaveCB: Cannot open %s for write\n", filename);]                     break;                 }V)                 AppsPtr = AscNewAppsList;iP                 fprintf(AppsFp, "# MsmApps.Inp - Input file for MiniSm V2.x\n");4                 fprintf(AppsFp, "# %s\n", __DATE__);(                 fprintf(AppsFp, "# \n");2                 while(strlen(AppsPtr->ApplName)) {E                     fprintf(AppsFp, "\t%-20s%s\n", AppsPtr->ApplName, .                             AppsPtr->ApplCmd);                     AppsPtr++;                 } (                 fprintf(AppsFp, "# \n");3                 fprintf(AppsFp, "# End of file\n");                  fclose(AppsFp);t'                 AppLstModified = FALSE;e!                 XtFree(filename);p
             }              else break;          break;           case CANCEL_BTN:         break;     };     XtUnmanageChild(w);N }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: InvLogPopupCB3  * Description: User specified invalid logical name   *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ H void InvLogPopupCB(Widget w, XtPointer client_data, XtPointer call_data) {      char *newdirptr;  )     newdirptr =  XmTextGetString(NewDir);s     switch ((int)client_data) { 1         case 1:     /* Ok Button, leave string */e             break;6         case 2:     /* Cancel Button, remove string */#             strcpy(newdirptr,"\0");)             n = 0;8             XtSetArg(args[n], XmNvalue, newdirptr); n++;)             XtSetValues(NewDir, args, n);              XtFree(newdirptr);     }r }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: QuitCBn?  * Description: Callback for quit button. Determine each active_G  *              task and delete it. Wait a specified time and look for pA  *              next task. When no more tasks, execute exit call.-  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */+A void QuitCB(Widget w, XtPointer client_data, XtPointer call_data)a {n     int indx = num_tasks;;     int cntr = num_tasks;[     int status, pid;     char msgbuf[80];     TASKLST *TaskPtr;,#     $DESCRIPTOR(dsc_old, prevproc);*  )     if(AppLstModified && !AppLstModAck) { <         sprintf(msgbuf, " Application Definitions have\n%s",5             "been modified but have not been saved");e6         DispErrPopup("Warning", &msgbuf, FALSE, TRUE);         AppLstModAck = TRUE;         return;*     }*     TaskPtr = TaskStruct;*,     dsc_old.dsc$w_length = strlen(prevproc);     status = sys$cantim(0, 0);"     status = sys$setprn(&dsc_old);     indx--;e     TaskPtr += indx;     while(indx >= 0) {         pid = TaskPtr->TaskPid; (         XmListDeletePos(TaskList, cntr);"         XmUpdateDisplay(TaskList);%         status = sys$delprc(&pid, 0);*R         if(status != SS$_NORMAL) printf("QuitCB:$delprc,pid=%8x,err=%x,indx=%d\n",             pid, status, indx);          cntr--;          TaskPtr--;         indx--;          sleep(1);      }k     exit(0); }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: QuitCB F  * Description: Callback for quit button. Try to determine each activeG  *              task and delete it. Wait a specified time and look for sA  *              next task. When no more tasks, execute exit call.   *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */*D void OldQuitCB(Widget w, XtPointer client_data, XtPointer call_data) {      int indx = 0;_     int tmp = num_tasks;     int status, pid;     char msgbuf[80];     TASKLST *TaskPtr;*#     $DESCRIPTOR(dsc_old, prevproc);*  )     if(AppLstModified && !AppLstModAck) {s<         sprintf(msgbuf, " Application Definitions have\n%s",5             "been modified but have not been saved");t6         DispErrPopup("Warning", &msgbuf, FALSE, TRUE);         AppLstModAck = TRUE;         return;*     }*     TaskPtr = TaskStruct;*,     dsc_old.dsc$w_length = strlen(prevproc);     status = sys$cantim(0, 0);"     status = sys$setprn(&dsc_old);
 #ifdef ARF#     XmListDeleteAllItems(TaskList);*     XmUpdateDisplay(TaskList); #endif     while(indx < num_tasks) {i         pid = TaskPtr->TaskPid;l #ifndef ARF 6         if(tmp > 1) XmListDeletePos(TaskList, indx+1);"         XmUpdateDisplay(TaskList); #endif%         status = sys$delprc(&pid, 0);sR         if(status != SS$_NORMAL) printf("QuitCB:$delprc,pid=%8x,err=%x,indx=%d\n",             pid, status, indx);          tmp--;         TaskPtr++;         indx++;t         sleep(1);*     }t     exit(0); }*      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: StopTaskCBcE  * Description: This is the delete task callback.  Its function is toXE  *              verify the application task name selected by the userSE  *              is actually active and delete the given task when the C  *              'Stop Task' button is selected. It then updates the $  *              'Tasks' list display  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ E void StopTaskCB(Widget w, XtPointer client_data, XtPointer call_data)S {i     int status;l
     int indx;t     TASKLST *TaskPtr;,  O     XmPushButtonCallbackStruct *cb =  (XmPushButtonCallbackStruct *) call_data;d     if(task_selpos) {m         TaskPtr = TaskStruct;          task_selpos--;         TaskPtr += task_selpos; "         status = sys$cantim(0, 0);2         status = sys$delprc(&TaskPtr->TaskPid, 0);1         XmListDeletePos(TaskList, task_selpos+1); )         AdjustTaskList(TaskPtr->TaskPid);*         num_tasks--;+         XtSetSensitive(StopTaskBtn, FALSE);pK         if(num_tasks)  status = sys$setimr(0, &delta_time, AstEvent, 0, 0);i         task_selpos = 0;     }l }(      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: TaskSelCBB  * Description: This is a selection callback.  Its function is to G  *              identify the application task name selected by the user,I  *              and indicate which task to delete when 'Stop Task' buttongK  *              is selected (StopTaskCB) by placing the position value into,I  *              global var task_selpos; if task_selpos is nonzero, assume*J  *              user selected a task to stop, and changed their mind. TheyJ  *              selected same item while hi-lited, so we will deselect it.  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */eD void TaskSelCB(Widget w, XtPointer client_data, XtPointer call_data) {&C     XmListCallbackStruct *cb =  (XmListCallbackStruct *) call_data;      int newpos = 0;      XmString SelTask;*     TASKLST *TaskPtr;*           newpos  = cb->item_position;     if(task_selpos == newpos) {,         TaskPtr = TaskStruct;e"         TaskPtr += task_selpos -1;A         SelTask = XmStringCreateLtoR(TaskPtr->TaskName, charset);).         XmListDeselectItem(TaskList, SelTask);         XmStringFree(SelTask);         task_selpos = 0;+         XtSetSensitive(StopTaskBtn, FALSE); "         XmUpdateDisplay(TaskList);     } 
     else {(         task_selpos = cb->item_position;*         XtSetSensitive(StopTaskBtn, TRUE);     }h }p      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: VersionCB0  * Description: Callback for Version help button  *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */   = /************************************************************A4  * VersionCB      - callback for Version help button>  ************************************************************/D void VersionCB(Widget w, XtPointer client_data, XtPointer call_data) {r     Widget message_box;a  #     message_box = CreateVersion(w);      XtManageChild(message_box);d },    ; &     else XtSetSensitive(AddPB, False); #endif }         N /* * * * * * * * * * * * * * * * * * * *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                