 /*3          %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\ 4          %% \___________________________________%% \5          %% |                                   %%  \ 6          %% |              MiniSm               %%   \7          %% |           Tasks.c  c1995          %%    \ 7          %% |            Lyle W. West           %%    | 7          %% |                                   %%    | 7          %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    | 7          \                                        \   | 7           \                                        \  | 7            \                                        \ | 7             \________________________________________\|       :      Copyright (C) 1995 Lyle W. West, All Rights Reserved.K      Permission is granted to copy and use this program so long as [1] this I      copyright notice is preserved, and [2] no financial gain is involved I      in copying the program.  This program may not be sold as "shareware" H      or "public domain" software without the express, written permission      of the author.    */   #include "includes.h"  #include "externs.h"    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *   * Forward/External DeclarationsO  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void DispErrPopupCB ();  void ExceedTaskPopupCB (); void SaveCB ();     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AdjustAppsLstI  * Description: Rebuild the AscNewAppsLst structure after an Application  +  *              Definition has been removed   *(  * Inputs: Offset into the AscNewAppslst  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ ) void AdjustAppsLst(int item, int appscnt)  {      int indx = item;     APPSLST *AppsPtr1;     APPSLST *AppsPtr2;       AppsPtr1 = AscNewAppsList;     AppsPtr2 = AscNewAppsList;     AppsPtr1 += item + 1;      AppsPtr2 += item;      while(indx < appscnt) { 7         strcpy(AppsPtr2->ApplName, AppsPtr1->ApplName); 5         strcpy(AppsPtr2->ApplCmd, AppsPtr1->ApplCmd);          indx++;          AppsPtr2++;          AppsPtr1++;      }      AppsPtr1 = AscNewAppsList;     AppsPtr1 +=  appscnt - 2; 3     memset(AppsPtr2->ApplName, 0, sizeof(APPSLST));  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AdjustTaskList D  * Description: Rebuild the tasklist structure after a task has been'  *              deleted or has exited.    *$  * Inputs: Offset into the task list  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void AdjustTaskList(int procid)  {      int indx = 0;      int targetpid;     TASKLST *TaskPtr1;     TASKLST *TaskPtr2;  <     TaskPtr1 = TaskStruct;  /* previous structure pointer */7     TaskPtr2 = TaskStruct;  /* new structure pointer */ 
 #ifdef ARF     TaskPtr1 += offset + 1;      TaskPtr2 += offset;      while(indx < num_tasks) { 7         strcpy(TaskPtr2->TaskName, TaskPtr1->TaskName); .         TaskPtr2->TaskPid = TaskPtr1->TaskPid;         indx++;          TaskPtr2++;          TaskPtr1++;      }      TaskPtr1 = TaskStruct;     TaskPtr1 += num_tasks - 1;3     memset(TaskPtr1->TaskName, 0, sizeof(TASKLST));      TaskPtr1->TaskPid = 0; #else      targetpid = procid; 0     while(indx < num_tasks && indx < MAXTASKS) {,         if(TaskPtr1->TaskPid == targetpid) {             TaskPtr2++;              targetpid = -1; 	         } 7         strcpy(TaskPtr1->TaskName, TaskPtr2->TaskName); .         TaskPtr1->TaskPid = TaskPtr2->TaskPid;         indx++;          TaskPtr2++;          TaskPtr1++;      } >     memset(TaskPtr2->TaskName, 0, sizeof(TaskPtr2->TaskName));     TaskPtr2->TaskPid = 0; #endif  
 #ifdef ARF
     n = 0;*     XtSetArg(args[n], XmNwidth, 160); n++;#     XtSetValues(TaskList, args, n);  #endif }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: AstEvent A  * Description: Check if tasks listed in TaskPtr are still active   *  * Inputs: Target pid   *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void AstEvent(int pid) {      int indx = 0;      int status;      int task_cnt;      TASKLST *TaskPtr;        TaskPtr = TaskStruct;      task_cnt = num_tasks - 1;      if(detached) {<         status = sys$setimr(0, &delta_time, AstEvent, 0, 0);         return;      }      while(indx <= task_cnt) { 0         status = CheckProcess(TaskPtr->TaskPid);         if(!status) { .             XmListDeletePos(TaskList, indx+1);             num_tasks--;!             AdjustTaskList(indx); &             XmUpdateDisplay(TaskList);             if(!num_tasks) {3                 XtSetSensitive(StopTaskBtn, FALSE); *                 status = sys$cantim(0, 0);
             } 	         }          indx++;          TaskPtr++;     } F     if(num_tasks) status = sys$setimr(0, &delta_time, AstEvent, 0, 0); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckProcess .  * Description: Check if task is  still active  *  * Inputs: Target pid   *&  * Returns: TRUE if active, else FALSE  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckProcess(int pid)  {      int status, mpid; >     struct { short len, code; char *buf, *retlen; } itmlis[2];&     $DESCRIPTOR(dsc_delta, delta_str);       itmlis[0].len    = 4; '     itmlis[0].code   = JPI$_MASTER_PID;      itmlis[0].buf    = &mpid;      itmlis[0].retlen = 0;      itmlis[1].len    = 0;      itmlis[1].code   = 0;        if(newtask_count) {          newtask_count--;         if(!newtask_count) {0             sprintf(delta_str, "0 00:00:20.00");7             dsc_delta.dsc$w_length = strlen(delta_str); 9             status = sys$bintim(&dsc_delta, &delta_time); 	         }      } 7     status = sys$getjpiw(0, &pid, 0, &itmlis, 0, 0, 0); *     if(status == SS$_NORMAL) return(TRUE);     else return(FALSE);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckDetachedI  * Description: MiniSm creates a task and assigns a process name which is I  *              the filename plus the last three hex digits of the master I  *              process id (MiniSm). This prohibits, by default, multiple J  *              occurances of a given task due to duplicate process names.G  *              However, limiting task instances to 1 is not acceptable M  *              with certain tasks (such as DecTerm). This routine references K  *              a process logical name equivalence string and looks for the K  *              taskname in that string. If found, create a unique taskname %  *              and return to caller.   *4  * Inputs: Pointer to application list name selected  *=  * Returns: Detached process status, or FALSE if not detached   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckDetached(char *name)  {      int count = 1;     int done = FALSE; 
     int indx;      int match;     char *bptr;      char *eptr;      char taskname[30];     char detachedstr[30];      TASKLST *TaskPtr;   
 #ifdef MSMDBG 1     printf("task_detached: %s\n", task_detached);  #endif-     if(!strlen(task_detached)) return(FALSE);      TaskPtr = TaskStruct; /     for(indx = 0; indx <= strlen(name); indx++) -         taskname[indx] = toupper(name[indx]); "     taskname[strlen(name)] = '\0';
 #ifdef MSMDBG 7     printf("CheckDetached: taskname = %s\n", taskname);  #endif+     bptr = strstr(task_detached, taskname);      if(!bptr) return(FALSE);&     eptr = strchr(task_detached, '%');     if(eptr) {         bptr = eptr + 1;*         eptr = strchr(task_detached, ',');         if(eptr) {              match = eptr - bptr;.             strncpy(detachedstr, bptr, match);&             detachedstr[match] = '\0';	         } '         else strcpy(detachedstr, bptr);      }      else InvalidDetachedDef();
 #ifdef MSMDBG =     printf("CheckDetached: detachedstr = %s\n", detachedstr);  #endif(     while(done == FALSE && count <= 9) {.         sprintf(taskname,"%s%d", name, count);
 #ifdef MSMDBG ;         printf("CheckDetached: taskname = %s\n", taskname);  #endif         match = FALSE;         indx = 0; 4         while(strlen(TaskPtr->TaskName) && !match) {:             if(strcmp(taskname, TaskPtr->TaskName) == 0) {                 match = TRUE;                  count++;
             }              TaskPtr++;             indx++; 	         }          if(!match) done = TRUE;      }      strcpy(name, taskname); "     GetCurDev(&detachedstr, TRUE);     detached = TRUE;     return(TRUE);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: SaveAppDefsPopup ;  * Description: User selected 'File Save' item from menubar   *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ K void SaveAppDefsPopup(Widget w, XtPointer client_data, XtPointer call_data)  {      XmString filespec;     Widget DispSaveFile;  (     sprintf(Wtitle, "Save AppDef List");  
     n = 0;:     filespec = XmStringCreateLtoR(AppsInputFile, charset);2     WdTitle = XmStringCreateLtoR(Wtitle, charset);6     WarnMsg = XmStringCreateLtoR("Save as:", charset);4     XtSetArg(args[n], XmNdialogTitle, WdTitle); n++;=     XtSetArg(args[n], XmNselectionLabelString, WarnMsg); n++; /     XtSetArg(args[n], XmNtextColumns, 36); n++; L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;4     XtSetArg(args[n], XmNtextString, filespec); n++;J     DispSaveFile = XmCreatePromptDialog(MsmForm, "DispSaveFile", args, n);$     XtManageChild(DispSaveFile);    H     Button = XmSelectionBoxGetChild(DispSaveFile, XmDIALOG_HELP_BUTTON);     XtUnmanageChild(Button);@     XtAddCallback (DispSaveFile, XmNokCallback, SaveCB, OK_BTN);H     XtAddCallback (DispSaveFile, XmNcancelCallback, SaveCB, CANCEL_BTN);     XmStringFree(WdTitle);     XmStringFree(WarnMsg);     XmStringFree(filespec);  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: DispErrPopup G  * Description: An error was detected. Display calling function string, J  *              determine if an error code was passed or and error string,H  *              get the error value or address of the error string, and H  *              how to handle the exit whether to quit or ret to caller.  *3  * Inputs: funct: string ponter to calling function K  *         ErrStr:  if NULL then err_msg is vms error code, else is address 4  *                of error message string to displayI  *         err_msg: if NULL then ErrStr is address of error message, else #  *                is vms error code I  *         ExitStat: Boolean, TRUE = ret to caller, FALSE = exit (this is 4  *                performed by the callback routine)  *>  * Returns: If exit status is TRUE return to caller, else exit  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ G void DispErrPopup(char *funct, char *ErrStr, int err_msg, int ExitStat)  {      int status;      short msglen;      char msgbuf[120];      char tmpmsg[30];      $DESCRIPTOR(msgdsc, msgbuf);     XmString OkLabel;   
 #ifdef ARF
     n = 0;%     XtSetArg(args[n], XmNy, 10); n++; %     XtSetArg(args[n], XmNx, 10); n++; ;     w = XmCreateDialogShell(MsmForm, "Dlogshell", args, n);  #endif&     sprintf(Wtitle, " MiniSm Error ");     if(ErrStr) {6         sprintf(warnstr, "%s: %s\n\n", funct, ErrStr);     } 
     else {=         status = sys$getmsg(err_msg, &msglen, &msgdsc, 0, 0);          msgbuf[msglen] = '\0';6         sprintf(warnstr, "%s: %s\n\n", funct, msgbuf);     } 9     OkLabel = XmStringCreateLtoR("Acknowledge", charset); 
     n = 0;2     WdTitle = XmStringCreateLtoR(Wtitle, charset);3     WarnMsg = XmStringCreateLtoR(warnstr, charset); 4     XtSetArg(args[n], XmNdialogTitle, WdTitle); n++;6     XtSetArg(args[n], XmNmessageString, WarnMsg); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;6     XtSetArg(args[n], XmNokLabelString, OkLabel); n++;I     DispErrWarn = XmCreateWarningDialog(MsmForm, "DispErrWarn", args, n); I     XtAddCallback (DispErrWarn, XmNokCallback, DispErrPopupCB, ExitStat);      XmStringFree(WdTitle);     XmStringFree(WarnMsg);     XmStringFree(OkLabel);  !     /* remove unneeded buttons */ E     Button = XmMessageBoxGetChild(DispErrWarn, XmDIALOG_HELP_BUTTON);      XtUnmanageChild(Button);G     Button = XmMessageBoxGetChild(DispErrWarn, XmDIALOG_CANCEL_BUTTON);      XtUnmanageChild(Button);     XtManageChild(DispErrWarn);  }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ExceedTask I  * Description: User selected an application to execute after the maximum I  *              task limit has been reached. This is a compile time value @  *              arbitrarily selected by the programmer and is an>  *              application modal implementation, requiring an?  *              acknowledgement by the user to continue MiniSm.   *0  * Inputs: Parent widget, client data, call data  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ E void ExceedTask(Widget w, XtPointer client_data, XtPointer call_data)  {      char tmpmsg[30];     XmString OkLabel;   (     sprintf(Wtitle, "Exceeded Maximum");8     sprintf(tmpmsg, "  is %d active tasks ", num_tasks);9     sprintf(warnstr, " Maximum task limit \n%s", tmpmsg);   
     n = 0;5     OkLabel = XmStringCreateLtoR("Bummer!", charset); 2     WdTitle = XmStringCreateLtoR(Wtitle, charset);3     WarnMsg = XmStringCreateLtoR(warnstr, charset); 4     XtSetArg(args[n], XmNdialogTitle, WdTitle); n++;6     XtSetArg(args[n], XmNmessageString, WarnMsg); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;6     XtSetArg(args[n], XmNokLabelString, OkLabel); n++;I     ExceedTaskWarn = XmCreateWarningDialog(w, "ExceedTaskWarn", args, n); H     XtAddCallback (ExceedTaskWarn, XmNokCallback, ExceedTaskPopupCB, 0);     XmStringFree(WdTitle);     XmStringFree(WarnMsg);     XmStringFree(OkLabel);  !     /* remove unneeded buttons */ H     Button = XmMessageBoxGetChild(ExceedTaskWarn, XmDIALOG_HELP_BUTTON);     XtUnmanageChild(Button);J     Button = XmMessageBoxGetChild(ExceedTaskWarn, XmDIALOG_CANCEL_BUTTON);     XtUnmanageChild(Button);"     XtManageChild(ExceedTaskWarn); }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: FileNotFoundDlgG  * Description: Input file containing application information for the   J  *              AppsList box could not be found. User must acknowledge    #  *              popup to continue.    *3  * Inputs: funct: string ponter to calling function K  *         ErrStr:  if NULL then err_msg is vms error code, else is address 4  *                of error message string to displayI  *         err_msg: if NULL then ErrStr is address of error message, else #  *                is vms error code I  *         ExitStat: Boolean, TRUE = ret to caller, FALSE = exit (this is 4  *                performed by the callback routine)  *>  * Returns: If exit status is TRUE return to caller, else exit  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ J void FileNotFoundDlg(char *funct, char *ErrStr, int err_msg, int ExitStat) {      int status;      short msglen;      char msgbuf[120];      char tmpmsg[30];      $DESCRIPTOR(msgdsc, msgbuf);
     Widget w;      XmString OkLabel;   
     n = 0;%     XtSetArg(args[n], XmNy, 10); n++; %     XtSetArg(args[n], XmNx, 10); n++; ;     w = XmCreateDialogShell(MsmForm, "Dlogshell", args, n); *     sprintf(Wtitle, " Input File Error ");     if(ErrStr) {6         sprintf(warnstr, "%s: %s\n\n", funct, ErrStr);     } 
     else {=         status = sys$getmsg(err_msg, &msglen, &msgdsc, 0, 0);          msgbuf[msglen] = '\0';5         sprintf(warnstr, "%s\n %s\n", funct, msgbuf);_     }_9     OkLabel = XmStringCreateLtoR("Acknowledge", charset); 
     n = 0;2     WdTitle = XmStringCreateLtoR(Wtitle, charset);3     WarnMsg = XmStringCreateLtoR(warnstr, charset);94     XtSetArg(args[n], XmNdialogTitle, WdTitle); n++;6     XtSetArg(args[n], XmNmessageString, WarnMsg); n++;L     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;6     XtSetArg(args[n], XmNokLabelString, OkLabel); n++;C     DispErrWarn = XmCreateWarningDialog(w, "DispErrWarn", args, n); I     XtAddCallback (DispErrWarn, XmNokCallback, DispErrPopupCB, ExitStat);_     XmStringFree(WdTitle);     XmStringFree(WarnMsg);     XmStringFree(OkLabel);  !     /* remove unneeded buttons */sE     Button = XmMessageBoxGetChild(DispErrWarn, XmDIALOG_HELP_BUTTON);g     XtUnmanageChild(Button);G     Button = XmMessageBoxGetChild(DispErrWarn, XmDIALOG_CANCEL_BUTTON);r     XtUnmanageChild(Button);     XtManageChild(DispErrWarn);t }e    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: FindTaskPidE  * Description: Some tasks can conceivably create detached processes.*F  *              In this case, MiniSm's process id value from lib$spawnD  *              is not the pid of the task. This routine will locateD  *              the task, get the actual process id, and replace the/  *              task pid reported by lib$spawn.*  *9  * Inputs: String pointer to taskname, pid from lib$spawns  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */e, void FindTaskPid(char *taskstr, int taskpid) {l     int     mlen, indx;      long    pid, status;     char    devicestr[30];     char    tasktmp[30];     char    *bptr;     char    *eptr;     TASKLST *TaskPtr;n       TaskPtr = TaskStruct;P/     strncpy(tasktmp, taskstr, strlen(taskstr));c&     tasktmp[strlen(taskstr)-1] = '\0';1     for(indx = 0; indx < strlen(tasktmp); indx++)t/         tasktmp[indx] = toupper(tasktmp[indx]);y*     bptr = strstr(task_detached, tasktmp);     eptr = strchr(bptr, '%');d     bptr = eptr + 1;     eptr = strchr(bptr, ',');s     if(eptr) {         mlen = eptr-bptr; '         strncpy(devicestr, bptr, mlen);+         devicestr[mlen] = '\0';P     }p      else strcpy(devicestr,bptr);  /     sleep(5);  /* wait for window to come up */*&     pid = GetCurDev(&devicestr,FALSE);
     indx = 0;s1     while(TaskPtr->TaskPid != taskpid) TaskPtr++;r     TaskPtr->TaskPid = pid;  }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetMpidD  * Description: Get the process id of our master process and get the6  *              entry process name to restore at exit.B  *              (additionally, set our process name with a suffix)  *  * Inputs: None=  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */i
 int GetMpid()a {t     int status, mpid;      char mpidstr[9];     char msmpnam[16];s     char *ptr;     short prevproc_len;,  >     struct { short len, code; char *buf, *retlen; } itmlis[3];"     $DESCRIPTOR(dsc_prn, msmpnam);#     $DESCRIPTOR(dsc_old, prevproc);        itmlis[0].len    = 4; '     itmlis[0].code   = JPI$_MASTER_PID;t$     itmlis[0].buf    = &mpid;            itmlis[0].retlen = 0; (     itmlis[1].len    = sizeof(prevproc);#     itmlis[1].code   = JPI$_PRCNAM;X!     itmlis[1].buf    = &prevproc;P%     itmlis[1].retlen = &prevproc_len;2     itmlis[2].len    = 0;      itmlis[2].code   = 0;   4     status = sys$getjpiw(0, 0, 0, &itmlis, 0, 0, 0);     if(status == SS$_NORMAL) {'         sprintf(mpidstr, "%08x", mpid);t         ptr = &mpidstr + 5; $         sprintf(mpidsfx,"-%s", ptr);.         sprintf(msmpnam, "MiniSm%s", mpidsfx);/         dsc_prn.dsc$w_length = strlen(msmpnam); &         status = sys$setprn(&dsc_prn);         return(TRUE);i     }s     else return(FALSE);  }*      N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: NewTaskG  * Description: We have started a new task. Check 3 times to see if the:G  *              pid is still active. If after 3 checks is stive active,*:  *              then it must have started so cancel timer.  *  * Inputs: Pid of new task  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */t void NewTask(int pid)  {d     int status; 
     int indx;s&     $DESCRIPTOR(dsc_delta, delta_str);  D     /* set the number of times we will wait and check for this newlyE        created process still being active (name is probably wrong) */   B     newtask_count = 3;  /* numtimes to check if proc is running */(     sprintf(delta_str, "0 00:00:10.00");/     dsc_delta.dsc$w_length = strlen(delta_str);k1     status = sys$bintim(&dsc_delta, &delta_time);A     status = CheckProcess(pid);s     if(status == SS$_NORMAL) {"         status = sys$cantim(0, 0);<         status = sys$setimr(0, &delta_time, AstEvent, 0, 0);     }t
     else {.         XmListDeletePos(TaskList, newtaskpos);         num_tasks--;         indx = num_tasks;*<         AdjustTaskList(indx);  /* remove last one created */:         if(!num_tasks) XtSetSensitive(StopTaskBtn, FALSE);"         XmUpdateDisplay(TaskList);         newtask_count = 0;,         sprintf(delta_str, "0 00:00:20.00");5         status = sys$bintim(&dsc_delta, &delta_time);t"         status = sys$cantim(0, 0);J         if(num_tasks) status = sys$setimr(0, &delta_time, AstEvent, 0, 0);'         else status = sys$cantim(0, 0);l     }o }         N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: HandleXevents=  * Description: Service X events for a particular widget whenoD  *              it is not feasable to get back to the XtAppMainLoop.  *+  * Inputs: Pointer to the widget to serviceg  *  * Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ ! void HandleXevents(Widget widget)& {l     XtAppContext      context;  4     context = XtWidgetToApplicationContext (widget);$     while(XtAppPending (context) ) {-         XtAppProcessEvent (context, XtIMAll);*     }* }n    